#ifndef __HeapBuffer_h
#define __HeapBuffer_h

enum
{
	FD_BUFFER_TYPE_NONE = 0,
	FD_BUFFER_TYPE_MEMORY,		// _xZkqqHx_iDiBiDiCiDiKiBfLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	FD_BUFFER_TYPE_FILE,		// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
};

/////////////////////////////////////////////////////////////////////////////
// FCHeapBuffer

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCHeapBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiCmFiOgHiCoNiCoKiCoJiDgPiDgCiDhEiDeAiCpAiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiCmFiOgHiCoNiCoKiCoJiDgPiDgCiDhEiDeAiCmNiBeB_xHqqkZx_FCHeapPool_xZkqqHx_iDeOiDiJiDfIiCmMiMlDiCmFjFkBjAjEiCkK_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiClDiCoKiCmEiCkCiCoJiBeCiClBiCmMiDeOiDiJiDfIiCmNiBeBiClLiCmMiIoKiCmCiCmMiDgPiDgCiDhEiDeAiCpAiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgPiDgCiDhEiDeAiCmNiBeBiDiBiDiCiDiKiBfLiPoDiCmGiDhEiDeAiDeDiDiLiPoDiCmMiCfBiOoNjHnOiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCkKjBoFiCkLiCkCiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiPoDiCmJiDgPiDgCiDhEiDeAiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCHeapBuffer
{
public:
	FCHeapBuffer (BYTE byHeapBufferType, void* pHeapBuffer);
	BYTE	GetHeapBufferType () const;
	DWORD	GetRestBufferSize ();
	DWORD	GetRestDataSize ();
	BOOL	IsEmpty ();
	DWORD	AllocateSegment (DWORD dwDataSize);
	void	FreeSegment (DWORD dwSegmentPosition);
	void	Reduce (DWORD dwSegmentPosition);
	BOOL	GetNextSegment (DWORD& dwSegmentPosition);

	DWORD	GetBufferSize ();
	DWORD	GetSegmentSize (DWORD dwSegmentPosition) const;
	DWORD	GetReferenceCount (DWORD dwSegmentPosition);
	void	SetReferenceCount (DWORD dwSegmentPosition, DWORD dwReferenceCount);
	DWORD	GetDataId (DWORD dwSegmentPosition);
	void	SetDataId (DWORD dwSegmentPosition, DWORD dwDataId);
	DWORD	GetDataSize (DWORD dwSegmentPosition) const;
	DWORD	GetData (DWORD dwSegmentPosition, void* pDataBuffer, DWORD dwBuffSize, DWORD dwStartOffset);
	void	SetData (DWORD dwSegmentPosition, const void* pData);

	void	Append (FCHeapBuffer& heapBuffer);

	static DWORD	GetMaxBufferSize (BYTE byHeapBufferType);
	static void*	CreateHeapBuffer (BYTE byHeapBufferType);
	static void		DeleteHeapBuffer (BYTE byHeapBufferType, void* pHeapBuffer);

protected:
	const BYTE*	GetMemoryBuffer () const;
	BYTE*	GetMemoryBuffer ();
	HANDLE	GetFileBuffer () const;
	const wchar_t*	GetFilePath () const;

	void	Read (DWORD dwPosition, void* pBuff, DWORD dwSize) const;
	void	Write (DWORD dwPosition, const void* pBuff, DWORD dwSize);
	void	SetSegmentSize (DWORD dwSegmentPosition, DWORD dwSegmentSize);
	void	SetBufferSize (DWORD dwBufferSize);
	DWORD	CopySegment (DWORD dwSegmentTo, DWORD dwSegmentFrom);

protected:
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTE*	m_pMemoryBuffer;
//	HANDLE	m_hFileBuffer;
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	BYTE	m_byHeapBufferType;
	void*	m_pHeapBuffer;
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
}; // class FCHeapBuffer.

#endif//__HeapBuffer_h
