#ifndef __HiProject_h
#define __HiProject_h

#include "HiDocumentRec.h"	// For FCHiDocumentRec.
#include "HiGroupBase.h"	// For Baseclass.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCHiGroupBase

class FCHiDocumentRecW;

class FCHiProject : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	//----- _xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiBeFiPjBiCkLiNjOiCnNiOjBiKgJiCmMiPoOjFpB_xHqqkZx_ -----
	enum Qualification
	{
		NOT_MEMBER = 0,		// _xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
		MEMBER_USER,		// _xZkqqHx_iDiGiBfLiDfFiBfLiDiBiDjDiDgPiBfLiBeC_xHqqkZx_
		LIMITED_USER,		// _xZkqqHx_jDmHiCnNiPgPiClFiCmMiCnNiCmJjAkHiMmAiClDiCoKiClNiDiGiBfLiDfFiBfLiBeC_xHqqkZx_
	};
public:
	FCHiProject ();
	FCHiProject (const FCDbGroup& dbGroup);
// 06.01.16 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual FDTIME		GetLastUpdatedTime () const;
	virtual void		Clear ();
	virtual void		operator = (const FCDbGroup& dbGroup);
	virtual BOOL		UpdateData (const FCDbReadLock& readLock);

// 06.01.08 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual BOOL		UpdateFile (const FCDbWriteLock& writeLock);

	virtual WString		GetTitle ();
	virtual void		SetTitle (const wchar_t* wcpTitle);

	virtual GUID		GetUserId ();
	virtual void		SetUserId (const GUID& guid);

	virtual BOOL		GetIsAllowToJoinUsersGroup ();
	virtual void		SetIsAllowToJoinUsersGroup (BOOL bIsAllowToJoinUsersGroup);

	virtual FDSECTIME	GetDate ();
	virtual void		SetDate (FDSECTIME fdstDate);

	virtual WString		GetComment ();
	virtual void		SetComment (const wchar_t* wcpComm);

	virtual BOOL		GetIsUnknownFile () const;
// 06.02.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void		SetIsUnknownFile (BOOL bIsUnknownFile);

	virtual void		GetMemberUserList (GuidToUserNameMap& mpGuidToUserName);
	virtual void		SetMemberUserList (const GuidToUserNameMap& mpNewMemberUserList);
	virtual void		GetMemberUser (GUID& guidUserId, WString& wstrUserName, DWORD dwIndex);
	virtual void		JoinUsersGroup (const GUID& guid, const wchar_t* wcpUserName);
	virtual WString		UserIdToUserName (const GUID& guid);
	virtual BOOL		IsMemberOfUsersGroup (const GUID& guid) const;

	virtual void		GetLimitedUserList (set<GUID>& stUserId) const;
	virtual void		SetLimitedUserList (const set<GUID>& stNewLimitedUserList);
	virtual void		AddLimitedUser (const GUID& guid);
	virtual BOOL		IsQualifiedToModify (const GUID& guidUserId) const;
	virtual Qualification CheckQualification (const GUID& guidUserId) const;

	virtual FCHiDocumentRec	GetDocumentRec (long lDocId);
	virtual long		GetFirstDocumentId () const;
	virtual long		GetNextDocumentId (long lDocId) const;
	virtual long		DocTitleVersionToDocumentId (	const wchar_t* wcpDocTitle,
														const wchar_t* wcpVersion);
	virtual long		GetFreeDocumentId (long lId) const;
	virtual long		FindDocumentId (const wchar_t* wcpDocTitle,
										const wchar_t* wcpVersion);

	virtual long		RegisterDocument (	FCDbReadLock& readLock,
											FCDbWriteLock& writeLock,
											FCHiDocumentRecW& hiDocRecW,
											long lDocId);
	virtual void		UnregisterDocument (long lDocId);

	virtual int			CalcUniqSubVersion (const wchar_t* wcpDocTitle,
											const wchar_t* wcpVersion);

	virtual void		CalcUniqDocTitle (	WString& wstrNewTitle,
											const wchar_t* wcpDocTitle,
											const wchar_t* wcpVersion);

	virtual WString		GetMemberUserListString ();
	virtual void		SetMemberUserListString (const wchar_t* wcpMemberString);
	virtual WString 	GetLimitedUserListString ();
	virtual void		SetLimitedUserListString (const wchar_t* wcpUserListString);
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL		IsRealTableReplaced () const;
//	virtual BOOL		IsRealTableRecordModified () const;
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual BOOL		IsProjectOpened () const;
	virtual long		SubDocumentIdToTopId (long lDocId);
	virtual WString		GetHidocumentTitle (long lDocId, BOOL bShort);

	virtual long		RegisterDDDocument (FCDbReadLock& readLock,
											FCDbWriteLock& writeLock,
											long lDocId,
											const wchar_t* wcpDocTitle,
											const GUID& guid,
											const wchar_t* wcpVersion,
											FDSECTIME fdstDate,
											const wchar_t* wcpComment,
											BOOL bIsLogCommandUserId,
											long lSuperDocId,
											double dHtreeScore);
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual long		RegisterTempDDDocument (FCDbReadLock& readLock,
//												FCDbWriteLock& writeLock,
//												const wchar_t* wcpDocTitle,
//												const GUID& guid,
//												const wchar_t* wcpVersion,
//												FDSECTIME fdstDate,
//												const wchar_t* wcpComment,
//												BOOL bIsLogCommandUserId,
//												double dHtreeScore);
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual FCHiDocumentRec	GetFirstHidocumentRec (long& lDocId);
	virtual FCHiDocumentRec	GetNextHidocumentRec (long& lDocId);
	virtual void		GetHidocumentTree (longSet& stTopId, map<long, longSet>& mpIdToSubId);
	virtual void		GetLowerHidocument (longSet& stHiDocId, long lHiDocId);
	virtual void		GetSubHidocument (longSet& stHiDocId, long lHiDocId);
	virtual WString		GetUniqSubDocumentVersion (long lSuperDocId);

	virtual HString		GetFilePathH () const;
	virtual WString		GetFilePath () const;

	static void			MemberUserListToString (WString& wstrMemberUserList, const GuidToUserNameMap& mpMemberUserList);
	static void			MemberStringToList (GuidToUserNameMap& mpMemberUserList, WString wstrMemberUserList);
	static void			LimitedUserListToString (WString& wstrLimitedUserList, const set<GUID>& stLimitedUserList);
	static void			LimitedStringToList (set<GUID>& stLimitedUserList, WString wstrLimitedUserList);

friend class FCHiDocumentRecW;

protected:
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL		GetIsModified () const;
//	virtual void		SetIsModified (BOOL bUpdated);
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	virtual void		ClearProperty ();

	virtual void		SetHeaderRecord (DWORD dwId, const void* pData, size_t szDataSize);
	virtual void		SetDocumentRecord (long lDocumentId, const void* pData, size_t szDataSize);
	virtual const BYTE*	GetControlData (BYTEVector& vDataBuff, DWORD dwIndex);
	virtual void		UpdateHash ();


protected:
	enum
	{
		FDCT_ID_TITLE = 0,			// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
		FDCT_ID_USER_ID,			// _xZkqqHx_iDiGiBfLiDfFiBfL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		FDCT_ID_ARROW_TO_JOIN,		// _xZkqqHx_jAfGiLeLiOfBiJmBiCpAiLjGiJmCiBeC_xHqqkZx_
		FDCT_ID_DATE,				// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
		FDCT_ID_COMMENT,			// _xZkqqHx_iDfCiDiBiDjDiDgHiBeC_xHqqkZx_
// 06.02.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		FDCT_ID_IS_UNKNOWN,			// _xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
		FDCT_ID_MEMBER_USER,		// _xZkqqHx_iDiBiDjDiDgPiBfLiIoKjHjHiBeC_xHqqkZx_
		FDCT_ID_LIMITED_USER,		// _xZkqqHx_jAkHiMmAiDiGiBfLiDfFiBfLiBeC_xHqqkZx_
	};

//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FDTIME		m_fdtmLastUpdatedTime;	// _xZkqqHx_iNmFiMoDiCmJiNfIjAfGiClDiCoKiClNiOjOiKnEiCpAjAnNjCoIiBeC_xHqqkZx_
//										// _xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//
//	GUID		m_guidTableGuid;				// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
//	DWORD		m_dwLockedDeleteIdentifier;		// _xZkqqHx_iDgGiBfLiDfOiPeDjAlDiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	DWORD		m_dwLockedAppendIdentifier;		// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	map<DWORD, DWORD>				m_mpHeaderIdToIndex;
	map<GUID, DWORD>				m_mpMemberUserToIndex;
	map<GUID, DWORD>				m_mpLimitedUserToIndex;
	map<long, DWORD>				m_mpDocumentIdToIndex;
}; // class FCHiProject.

#endif//__HiProject_h
