#ifndef __HiTableBaseTmpl_h
#define __HiTableBaseTmpl_h

/*************************************************************************
 * <_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_> HiTableBaseTmpl.h
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_> FCHiTableBaseTmpl_xZkqqHx_iDeOiDiJiDfIiCmMiDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_> 06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/

#include "stdafx.h"
#include "UtilMisc.h"	// For FFGetCurrentTime.
#include "DynamicDb.h"	// For g_pFileServer.

template<class SUPER> class FCHiTableBaseTmpl : public SUPER
{
protected:
	FCHiTableBaseTmpl ();
	virtual ~FCHiTableBaseTmpl ();
// 06.02.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	SetIsModified (BOOL bUpdated);
//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual DWORD	AppendRecord (flint fliPrimaryId, const void* pData, DWORD dwDataSize);
//	virtual void	ReduceRecordCount (DWORD dwIndex);
//	virtual void	DeleteRecords (const DWORDSet& stIndex);
//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

public:
	virtual void	Clear ();
	virtual BOOL	UpdateDataA (const FCDbLockBank& lockBank);
	virtual BOOL	UpdateData (const FCDbReadLock& readLock);
// 06.02.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	ResetModifiedFlag ();

	virtual BOOL	IsRealTableReplaced () const;
	virtual BOOL	IsRealTableRecordDeleted () const;
	virtual BOOL	IsRealTableRecordAppended () const;
	virtual BOOL	IsRealTableRecordModified () const;
	virtual void	ResetRealTableIdentifier ();

// 06.02.07 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual BOOL	IsVirtualTableReplaced ();
	virtual BOOL	IsVirtualTableRecordOverwrited ();
	virtual BOOL	IsVirtualTableRecordAppended ();
	virtual BOOL	IsVirtualTableRecordModified ();
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	virtual void	ResetVirtualTableIdentifier ();
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	GetIsModified () const;
//	virtual FDTIME	GetLastUpdatedTime () const;
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

protected:
	GUID		m_guidRealTableGuid;
	DWORD		m_dwRealDeleteIdentifier;
	DWORD		m_dwRealAppendIdentifier;

	GUID		m_guidVirtualTableGuid;
	DWORD		m_dwVirtualEndIndex;
	DWORD		m_dwVirtualLastIdentifier;


//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FDTIME		m_fdtmLastUpdatedTime;		// _xZkqqHx_iNmFiMoDiCmJiNfIjAfGiClDiCoKiClNiOjOiKnEiCpAjAnNjCoIiBeC_xHqqkZx_
//											// _xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
}; // class FCHiTableBaseTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::FCHiTableBaseTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
FCHiTableBaseTmpl<SUPER>::FCHiTableBaseTmpl ()
{
	// _xZkqqHx_iPiJiKpKiJlLiCmMjFeLjHhGiCmIjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	Clear();
} // FCHiTableBaseTmpl<SUPER>::FCHiTableBaseTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::~FCHiTableBaseTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
FCHiTableBaseTmpl<SUPER>::~FCHiTableBaseTmpl ()
{
} // FCHiTableBaseTmpl<SUPER>::~FCHiTableBaseTmpl.

//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::SetIsModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bUpdated	:_xZkqqHx_iNfIjAfGiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNfIjAfGiDhEiDiJiDePiCmJ_xHqqkZx_TRUE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiCmGiBeB_xHqqkZx_UpdateFile _xZkqqHx_iCmFiDhEiDeAiDeDiDiLiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCHiTableBaseTmpl<SUPER>::SetIsModified (BOOL bUpdated)
//{
//	if (bUpdated)
//	{
//		// _xZkqqHx_iNmFiMoDiCmJ_xHqqkZx_UpdateData_xZkqqHx_iClDiCoKiClNiOjOiKnEiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//		m_fdtmLastUpdatedTime = 0;
//	} else
//	{
//		m_fdtmLastUpdatedTime = FFGetCurrentTime();
//	}
//} // FCHiTableBaseTmpl<SUPER>::SetIsModified.
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::AppendRecord
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiNmFiMoDiCmJiDiMiDfCiBfLiDgIiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliPrimaryId	:_xZkqqHx_iDiMiDfCiBfLiDgIiCmMiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			pData			:_xZkqqHx_iDiMiDfCiBfLiDgIiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			dwDataSize		:_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHiJmBiClDiCoKiClNiDiMiDfCiBfLiDgIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//DWORD FCHiTableBaseTmpl<SUPER>::AppendRecord (flint fliPrimaryId, const void* pData, DWORD dwDataSize)
//{
//// 06.02.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	SetIsModified(TRUE);
////----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	return SUPER::AppendRecord(fliPrimaryId, pData, dwDataSize);
////----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	DWORD dwIndex = SUPER::AppendRecord(fliPrimaryId, pData, dwDataSize);
//	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiPeDjAlD_xHqqkZx_Identifier_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
//	ResetVirtualTableIdentifier();
//	return dwIndex;
////----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCHiTableBaseTmpl<SUPER>::AppendRecord.
//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::ReduceRecordCount
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiImIiNhOiBgJiOhHjCoIjCgMiCpAiKnMiCnOiBgKiCmMiDiMiDfCiBfLiDgIiCpAjBfDiCmE_xHqqkZx_
// *			_xZkqqHx_iNoNiPjMiClHiCoJiBeCiMiLiJmKiBeBiDgFiBfLiDhFiDiLiCmMiDfEiDeDiDfJiCmNiOhHjCoIiCmMjBoFiCkLiClDiCmJiPgLiPkMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_iPgLiPkMiClHiCoJiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCHiTableBaseTmpl<SUPER>::ReduceRecordCount (DWORD dwIndex)
//{
//// 06.02.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	SetIsModified(TRUE);
//	SUPER::ReduceRecordCount(dwIndex);
////----- 06.02.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiPeDjAlD_xHqqkZx_Identifier_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
//	ResetVirtualTableIdentifier();
////----- 06.02.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//} // FCHiTableBaseTmpl<SUPER>::ReduceRecordCount.
//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::DeleteRecords
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stIndex	:_xZkqqHx_iNoNiPjMiClHiCoJiDiMiDfCiBfLiDgIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCpAiNoNiPjMiClHiCoJiCmJiCmNiBeBiCnMiClIiOhHjCoIiDiMiDfCiBfLiDgIiImIiNhOiCpAjBfDiCmE_xHqqkZx_
// *			_xZkqqHx_iNoNiPjMiClFiBeBiOhHjCoIiDiMiDfCiBfLiDgIiBhLiCfAiImIiNhOiCpAiNmEjDgPjIfOiClHiCoJiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iCmCiCnMiCoIiBeB_xHqqkZx_ReduceRecordCount _xZkqqHx_iCmG_xHqqkZx_ AppendRecord _xZkqqHx_iCkKiOmAiNhDiClDiCoKiClNiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCHiTableBaseTmpl<SUPER>::DeleteRecords (const DWORDSet& stIndex)
//{
//// 06.02.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	SetIsModified(TRUE);
//	SUPER::DeleteRecords(stIndex);
////----- 06.02.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiPeDjAlD_xHqqkZx_Identifier_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
//	ResetVirtualTableIdentifier();
////----- 06.02.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//} // FCHiTableBaseTmpl<SUPER>::DeleteRecords.
//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiPoOjFpBiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCHiTableBaseTmpl<SUPER>::Clear ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	SUPER::Clear();
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNmFiPeJiNfIjAfGiOjOiKnEiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	SetIsModified(FALSE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	m_guidRealTableGuid = GUID_NULL;
	m_dwRealDeleteIdentifier = DWORD(-1);
	m_dwRealAppendIdentifier = DWORD(-1);

	m_guidVirtualTableGuid = GUID_NULL;			// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_dwVirtualEndIndex = DWORD(-1);		// _xZkqqHx_iDgGiBfLiDfOiCmMiDiMiDfCiBfLiDgIjAjEiBeC_xHqqkZx_
	m_dwVirtualLastIdentifier = DWORD(-1);	// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
} // FCHiTableBaseTmpl<SUPER>::Clear.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::UpdateDataA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoKiCmOiDiNiBfLiDgIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lockBank	:Read_xZkqqHx_jHhAiDiNiDgCiDeOiOkJjDkOiJpAjFpKjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *						  _xZkqqHx_iDiNiDgCiDeOiPoOjFpBiCkKiKgNjEeGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiBfLiDgIiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCHiTableBaseTmpl<SUPER>::UpdateDataA (const FCDbLockBank& lockBank)
{
	return UpdateData(lockBank.GetReadLock(GetTableName()));
} // FCHiTableBaseTmpl<SUPER>::UpdateDataA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::UpdateData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoKiCmOiDiNiBfLiDgIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:Read_xZkqqHx_jHhAiDiNiDgCiDeOiOkJjDkOiJpAjFpKjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *						  _xZkqqHx_iDiNiDgCiDeOiPoOjFpBiCkKiKgNjEeGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiBfLiDgIiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCHiTableBaseTmpl<SUPER>::UpdateData (const FCDbReadLock& readLock)
{
	ASSERT(readLock.IsLocked());
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNmFiPeJiNfIjAfGiOjOiKnEiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	SetIsModified(FALSE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	if (!IsRealTableRecordModified() &&
		!IsVirtualTableRecordModified())
	//----- _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return FALSE;
	} else
	//----- _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjAlD_xHqqkZx_ID_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
		ResetRealTableIdentifier();
		ResetVirtualTableIdentifier();
		return TRUE;
	}
} // FCHiTableBaseTmpl<SUPER>::UpdateData.

//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::ResetModifiedFlag
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiBeFjCmHiJmB_xHqqkZx_ID_xZkqqHx_iBeBiPeDjAlDiDhEiDiJiDePiCpAiJpAiPjMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCHiTableBaseTmpl<SUPER>::ResetModifiedFlag ()
//{
//	// _xZkqqHx_iNmFiPeJiNfIjAfGiOjOiKnEiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	SetIsModified(FALSE);
//	ResetVirtualTableIdentifier();
//} // FCHiTableBaseTmpl<SUPER>::ResetModifiedFlag.
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::IsRealTableReplaced
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjChFiKlHiClDiCoKiClNiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jChFiKlHiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCHiTableBaseTmpl<SUPER>::IsRealTableReplaced () const
{
	return (m_guidVirtualTableGuid != g_pFileServer->GetLockedTableGuid(GetTableName()));
} // FCHiTableBaseTmpl<SUPER>::IsRealTableReplaced.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::IsRealTableRecordDeleted
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFiPoDiPjBiCkLiNfIjAfGiClDiCoKiClNiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCHiTableBaseTmpl<SUPER>::IsRealTableRecordDeleted () const
{
	return (m_dwRealDeleteIdentifier != g_pFileServer->GetLockedDeleteIdentifier(GetTableName()));
} // FCHiTableBaseTmpl<SUPER>::IsRealTableRecordDeleted.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::IsRealTableRecordAppended
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjCmHiJmBiNfIjAfGiClDiCoKiClNiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCHiTableBaseTmpl<SUPER>::IsRealTableRecordAppended () const
{
	return (m_dwRealAppendIdentifier != g_pFileServer->GetLockedAppendIdentifier(GetTableName()));
} // FCHiTableBaseTmpl<SUPER>::IsRealTableRecordAppended.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::IsRealTableRecordModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjCmHiJmBiNfIjAfG_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_
 *			_xZkqqHx_iPoDiPjBiCkLiNfIjAfGiClDiCoKiClNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCHiTableBaseTmpl<SUPER>::IsRealTableRecordModified () const
{
	return (IsRealTableReplaced() || IsRealTableRecordDeleted() || IsRealTableRecordAppended());
} // FCHiTableBaseTmpl<SUPER>::IsRealTableRecordModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::ResetRealTableIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCmMiBeBjCmHiJmBiNfIjAfGiDeKiDeFiDjDiDfOiCmGiPoDiPjBiCkLiNfIjAfGiDeKiDeFiDjDiDfO_xHqqkZx_
 *			_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDiCiDiKjCiGiCmMiDeKiDeFiDjDiDfOjCgMiCmNiBeBiDiNiDgCiDeOiDhEiDeAiDeDiDiLjCiGiCmMiDeKiDeFiDjDiDfOiCmJ_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAiNiHiCoNiClJiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCHiTableBaseTmpl<SUPER>::ResetRealTableIdentifier ()
{
	// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_guidVirtualTableGuid = g_pFileServer->GetLockedTableGuid(GetTableName());
	// _xZkqqHx_iNoNiPjM_xHqqkZx_ID_xZkqqHx_iCmGjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_dwRealDeleteIdentifier = g_pFileServer->GetLockedDeleteIdentifier(GetTableName());
	m_dwRealAppendIdentifier = g_pFileServer->GetLockedAppendIdentifier(GetTableName());
} // FCHiTableBaseTmpl<SUPER>::ResetRealTableIdentifier.

//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::IsVirtualTableReplaced
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjChFiKlHiClDiCoKiClNiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jChFiKlHiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//BOOL FCHiTableBaseTmpl<SUPER>::IsVirtualTableReplaced ()
//{
//	return (m_guidVirtualTableGuid != GetTableGuid());
//} // FCHiTableBaseTmpl<SUPER>::IsVirtualTableReplaced.
//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::IsVirtualTableRecordOverwrited
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFiPoDiPjBiCkLiNfIjAfGiClDiCoKiClNiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCHiTableBaseTmpl<SUPER>::IsVirtualTableRecordOverwrited ()
{
	if (m_guidVirtualTableGuid != GetTableGuid())
		return TRUE;
	if (GetRecordCount() < m_dwVirtualEndIndex)
		return TRUE;
	if (m_dwVirtualEndIndex == 0)
		return FALSE;
	if (GetRecordAppendIdentifier(m_dwVirtualEndIndex - 1) != m_dwVirtualLastIdentifier)
		return TRUE;
	return FALSE;
} // FCHiTableBaseTmpl<SUPER>::IsVirtualTableRecordOverwrited.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::IsVirtualTableRecordAppended
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjCmHiJmBiNfIjAfGiClDiCoKiClNiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCHiTableBaseTmpl<SUPER>::IsVirtualTableRecordAppended ()
{
	if (m_guidVirtualTableGuid != GetTableGuid())
		return FALSE;
	if (GetRecordCount() <= m_dwVirtualEndIndex)
		return FALSE;
	if (m_dwVirtualEndIndex == 0)
		return TRUE;
	if (GetRecordAppendIdentifier(m_dwVirtualEndIndex - 1) == m_dwVirtualLastIdentifier)
		return TRUE;
	return FALSE;
} // FCHiTableBaseTmpl<SUPER>::IsVirtualTableRecordAppended.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::IsVirtualTableRecordModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDeOiDfKiDfIiCmFjCmHiJmBiNfIjAfG_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_
 *			_xZkqqHx_iPoDiPjBiCkLiNfIjAfGiClDiCoKiClNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCHiTableBaseTmpl<SUPER>::IsVirtualTableRecordModified ()
{
	return (IsVirtualTableRecordOverwrited() || IsVirtualTableRecordAppended());
} // FCHiTableBaseTmpl<SUPER>::IsVirtualTableRecordModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::ResetVirtualTableIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCmMiBeBjCmHiJmBiNfIjAfGiDeKiDeFiDjDiDfOiCmGiPoDiPjBiCkLiNfIjAfGiDeKiDeFiDjDiDfO_xHqqkZx_
 *			_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDiCiDiKjCiGiCmMiDeKiDeFiDjDiDfOjCgMiCmNiBeBiDiNiDgCiDeOiDhEiDeAiDeDiDiLjCiGiCmMiDeKiDeFiDjDiDfOiCmJ_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAiNiHiCoNiClJiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCHiTableBaseTmpl<SUPER>::ResetVirtualTableIdentifier ()
{
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//	m_guidVirtualTableGuid = g_pFileServer->GetLockedTableGuid(GetTableName());
//	// _xZkqqHx_iNoNiPjM_xHqqkZx_ID_xZkqqHx_iCmGjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//	m_dwRealDeleteIdentifier = g_pFileServer->GetLockedDeleteIdentifier(GetTableName());
//	m_dwVirtualLastIdentifier = g_pFileServer->GetLockedAppendIdentifier(GetTableName());
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_guidVirtualTableGuid = GetTableGuid();
	// _xZkqqHx_iDiMiDfCiBfLiDgIjAjEiCmGjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	m_dwVirtualEndIndex = GetRecordCount();
	if (m_dwVirtualEndIndex != 0)
		m_dwVirtualLastIdentifier = GetRecordAppendIdentifier(m_dwVirtualEndIndex - 1);
	else
		m_dwVirtualLastIdentifier = DWORD(-1);
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiTableBaseTmpl<SUPER>::ResetVirtualTableIdentifier.

//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::GetIsModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//BOOL FCHiTableBaseTmpl<SUPER>::GetIsModified () const
//{
//	return (m_fdtmLastUpdatedTime == 0);
//} // FCHiTableBaseTmpl<SUPER>::GetIsModified.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiTableBaseTmpl<SUPER>::GetLastUpdatedTime
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiNfIjAfGiClDiCoKiClNiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiNfIjAfGiClDiCoKiClNiOjOiKnEiBeCiDeJiDhFiDfHiDeGiDeOiDgHjFmPiNfIiMoDiCmJiDhEiDeAiDeDiDiLiCmJiPjBiCkLiNjOiCnN_xHqqkZx_
// *			_xZkqqHx_iClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//FDTIME FCHiTableBaseTmpl<SUPER>::GetLastUpdatedTime () const
//{
//	return m_fdtmLastUpdatedTime;
//} // FCHiTableBaseTmpl<SUPER>::GetLastUpdatedTime.
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#endif//__HiTableBaseTmpl_h
