#ifndef __HistFrameTmpl_h
#define __HistFrameTmpl_h

#include "stdafx.h"
#include "DynamicDraw.h"	// For FFCanBasicOperate(),IDXXX.
#include "PursuerText.h"	// For CFCPursuerText.
#include "HTreeRec.h"		// For FDTR_HTREE_REC.
#include "HTreeManager.h"	// For FTHTViewMode.
#include "WndHistoryTree.h"	// For CFCWndHistoryTree.
#include "FoundDoc.h"		// For g_pDoc.
#include "DynamicDb.h"		// For g_pFileServer.
#include "CtlBrSideView.h"	// For CFCCtlBrSideView.
#include "DlgSideView.h"	// For CFCDlgSideView.
#include "DlgInitUserRegistration.h"	// For CFCDlgInitUserRegistration.
#include "WndHtreeView.h"	// For CFCWndHtreeView.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	CFCHistFrameTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiIlFiCkEiDhEiDiMiBfLiDiAiBgJ_xHqqkZx_HistoricDraw,HistViewer_xZkqqHx_iBgKiCmMiKoOjGhLiDeOiDiJiDfIiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC> class CFCHistFrameTmpl : public SUPER
{
protected:
typedef SUPER BASE_CLASS;

protected:
	enum
	{
		INDICATOR_COUNT = 6,	// _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmMiDeDiDjDiDfHiDfAiBfLiDfOiBfLjAjEiBeC_xHqqkZx_
	};

// _xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_
public:
	CFCHistFrameTmpl ();
	virtual ~CFCHistFrameTmpl ();

//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void		SetStatusBarUser (const GUID& guidUserId, const wchar_t* wcpUserName);
	virtual void		SetStatusBarDate (FDSECTIME fdstDate);
// 06.04.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual FDSECTIME	GetStatusBarDate () const;
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual void	SetHiviewTempMark (	short nForkOrLabel,
										const wchar_t* wcpProjectPath,
										long lDocumentId,
										flint fliSessionIndex);
	virtual void	SetHiviewMarkUpHidocument (	const wchar_t* wcpProjectPath,
												const longSet& stDocId);
//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual void	SyncHiviewToDocument (	FTHTViewMode viewMode,
//											const wchar_t* wcpSelectedProjectPath,
//											long lSelectedDocumentId,
//											const wchar_t* wcpMarkedProjectPath,
//											long lMarkedDocumentId,
//											flint fliMarkedSessionIndex,
//											BOOL bIsFitHtreeViewZoom,
//											BOOL bScrollTo);
//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual BOOL	SyncHiviewToDocument (	FTHTViewMode viewMode,
											const wchar_t* wcpProjectPath,
											long lDocumentId,
											flint fliSessionIndex,
											BOOL bIsSelect,
											BOOL bIsMark,
											BOOL bIsFitHtreeViewZoom,
											BOOL bScrollTo,
											const WStringVector* vProjectPath = NULL,
											const longVector* vDocumentId = NULL);
//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	virtual void	SetHiviewFontZoom (double dZoom);
	virtual void	ChangeHiviewViewMode (FTHTViewMode viewMode);
	virtual void	SetHiviewZoom256 (long lZoom256);

protected:
//----- 05.10.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiKnGiMfHiKnGjAjE_xHqqkZx_ -----
	virtual void	OnViewSizingBarVisible (DWORD dwCommandId);
	virtual void	OnUpdateViewSizingBarVisible (CCmdUI* pCmdUI);
//----- 05.10.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiKnGiMfHiKnGjAjE_xHqqkZx_ -----
	virtual BOOL	IsHtreeViewVisible () const;
	virtual void	SetHtreeViewVisible (BOOL bIsVisible);
	virtual CFCWndHtreeView*	GetWndHtreeView ();
	virtual CFCWndHistoryTree*	GetWndHistoryTree ();

	virtual void	PushBackSyncHiviewToDocument (	BOOL bIsSelectHtreeCurrent = TRUE,
													BOOL bIsScrollHtreeView = TRUE,
													BOOL bIsFitHtreeViewZoom = FALSE);


	//----- _xZkqqHx_iPiJiKpKiJlLjDjJiCmMiKnGjAjE_xHqqkZx_ -----
	virtual void	OnFirstExecute ();
	virtual void	PostOnCreate (CFrameWnd* pWndFrame);
	virtual void	PreOnDestroy ();
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual const UINT*	GetIndicatorArray () const;
	virtual long	GetIndicatorArraySize () const;
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual DOC*	GetDocument ();

// _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiKnGjAjEiBeC_xHqqkZx_
public:
	virtual BOOL OnCmdMsg (UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);

protected:
	virtual BOOL OnWndMsg (UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pResult);

protected:
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	LRESULT OnUserWhtLbuttondown (WPARAM wParam, LPARAM lParam);
	LRESULT OnUserUnlockRequest (WPARAM wParam, LPARAM lParam);
	LRESULT OnUserSetHiviewZoom256 (WPARAM wParam, LPARAM lParam);
	LRESULT OnUserPursuerTextNeedInfo (WPARAM wParam, LPARAM lParam = 0);
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.10.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	void OnViewHtreeVisible ();
//	void OnUpdateViewHtreeVisible (CCmdUI* pCmdUI);
//----- 05.10.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	void OnViewHtreeDockOrFloat ();
	void OnUpdateViewHtreeDockOrFloat (CCmdUI* pCmdUI);
	void OnViewHtreeSideChange ();
	void OnUpdateViewHtreeSideChange (CCmdUI* pCmdUI);

	void OnHtreeFontSmall ();
	void OnUpdateHtreeFontSmall (CCmdUI* pCmdUI);
	void OnHtreeFontMedium ();
	void OnUpdateHtreeFontMedium (CCmdUI* pCmdUI);
	void OnHtreeFontLarge ();
	void OnUpdateHtreeFontLarge (CCmdUI* pCmdUI);

	void OnHtreeProjectView ();
	void OnUpdateHtreeProjectView (CCmdUI* pCmdUI);
	void OnHtreeTreeView ();
	void OnUpdateHtreeTreeView (CCmdUI* pCmdUI);
	void OnHtreeBranchView ();
	void OnUpdateHtreeBranchView (CCmdUI* pCmdUI);

	void OnRbtnHtreeDocDelete ();
	void OnUpdateRbtnHtreeDocDelete (CCmdUI* pCmdUI);
	void OnRbtnHtreeMoveHiPosition ();
	void OnUpdateRbtnHtreeMoveHiPosition (CCmdUI* pCmdUI);
	void OnRbtnHtreeProjectProperty ();
	void OnUpdateRbtnHtreeProjectProperty (CCmdUI* pCmdUI);
	void OnRbtnHtreeDocumentProperty ();
	void OnUpdateRbtnHtreeDocumentProperty (CCmdUI* pCmdUI);
	void OnRbtnHtreePutHiForkTag ();
	void OnUpdateRbtnHtreePutHiForkTag (CCmdUI* pCmdUI);
	void OnRbtnHtreeHiTagProperty ();
	void OnUpdateRbtnHtreeHiTagProperty (CCmdUI* pCmdUI);
	void OnRbtnHtreeDeleteHiForkTag ();
	void OnUpdateRbtnHtreeDeleteHiForkTag (CCmdUI* pCmdUI);
	void OnRbtnHtreeForkHistory ();
	void OnUpdateRbtnHtreeForkHistory (CCmdUI* pCmdUI);

//----- 06.04.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	void OnRbtnHtreeChangeBranchIntoTrunk ();
//	void OnUpdateRbtnHtreeChangeBranchIntoTrunk (CCmdUI* pCmdUI);
//	void OnRbtnHtreeChangeTrunkIntoBranch ();
//	void OnUpdateRbtnHtreeChangeTrunkIntoBranch (CCmdUI* pCmdUI);
//	void OnRbtnHtreeChangeBranchIntoTop ();
//	void OnUpdateRbtnHtreeChangeBranchIntoTop (CCmdUI* pCmdUI);
//----- 06.04.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	void OnRbtnHtreeTimeLabelProperty ();
	void OnUpdateRbtnHtreeTimeLabelProperty (CCmdUI* pCmdUI);
	void OnRbtnHtreeDeleteTimeLabel ();
	void OnUpdateRbtnHtreeDeleteTimeLabel (CCmdUI* pCmdUI);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.09.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	void OnRbtnHtreeExecHistviewTarget ();
	void OnUpdateRbtnHtreeExecHistviewTarget (CCmdUI* pCmdUI);
	void OnRbtnHtreeExecHistdrawTarget ();
	void OnUpdateRbtnHtreeExecHistdrawTarget (CCmdUI* pCmdUI);
//----- 05.09.30 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiBeC_xHqqkZx_
protected:
	CFCCtlBrSideView*	m_pCtlBrHTree;			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiBeC_xHqqkZx_
	CFCDlgSideView*		m_pDlgHtreeView;		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfL_xHqqkZx_2_xZkqqHx_iBeC_xHqqkZx_
	CFCWndHtreeView*	m_pWndHtreeView;
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmMiPoOjFpB_xHqqkZx_ -----
	GUID		m_guidSessionUserId;	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiBfLiCgIiCgDiBeC_xHqqkZx_
	WString		m_wstrSessionUserName;	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiBfLjGlMiBeC_xHqqkZx_
	FDSECTIME	m_fdstSessionTime;		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
}; // class CFCHistFrameTmpl.

////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiBiDjDiDgPiKnGjAjEjCoIiLgAiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::CFCHistFrameTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iKgFiOoNjHjKjHpAjFlGiPjBjHhAiCmMiDiBiDjDiDgPjFmPjAjEiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
CFCHistFrameTmpl<SUPER, DOC>::CFCHistFrameTmpl ()
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiBeC_xHqqkZx_
	m_pCtlBrHTree = NULL;
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfL_xHqqkZx_2_xZkqqHx_iBeC_xHqqkZx_
	m_pDlgHtreeView = NULL;
	m_pWndHtreeView = NULL;
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmMiPoOjFpB_xHqqkZx_ -----
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiBfLiCgIiCgDiBeC_xHqqkZx_
	m_guidSessionUserId = GUID_NULL;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
	m_fdstSessionTime = FDSECTIME(-1);
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::CFCHistFrameTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::~CFCHistFrameTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
CFCHistFrameTmpl<SUPER, DOC>::~CFCHistFrameTmpl ()
{
} // CFCHistFrameTmpl<SUPER, DOC>::~CFCHistFrameTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::SetStatusBarUser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmJiDiGiBfLiDfFiBfLiPoOjFpBiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfFiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpUserName	:_xZkqqHx_iDiGiBfLiDfFiBfLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::SetStatusBarUser (const GUID& guidUserId, const wchar_t* wcpUserName)
{
	// _xZkqqHx_iDeDiDjDiDfHiDfAiBfLiDfOiBfLiCmNiBeB_xHqqkZx_ON_UPDATE_COMMAND_UI(OnUpdateIndicator) _xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_jFeLiClIiOjNiClNiClJiCoJiClBiCmGiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiBeB_xHqqkZx_
	// _xZkqqHx_jBlMiDeBiDhGiDiKiCpAiDhNiDeFiDfIiDeOiDiKiDgCiDeOiClFiNmEiCnBjGnPiCmBiCmEiCkLiClNiPoKiNiHiCmJiBeB_xHqqkZx_
	// _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmJjFlGiOjKiCkKjFfMiOkGiClDiCoKiCmIiCkNiCmIiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiBfLiCgIiCgDiBeC_xHqqkZx_
	m_guidSessionUserId = guidUserId;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiBfLjGlMiBeC_xHqqkZx_
	m_wstrSessionUserName = wcpUserName;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiBfLjGlMiBeC_xHqqkZx_
	SetStatusBarText(m_wstrSessionUserName, ID_INDICATOR_USER);
} // CFCHistFrameTmpl<SUPER, DOC>::SetStatusBarUser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::SetStatusBarDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmJjDpKiOjOiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstDate	:_xZkqqHx_jDpKiOjOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::SetStatusBarDate (FDSECTIME fdstDate)
{
	// _xZkqqHx_iDeDiDjDiDfHiDfAiBfLiDfOiBfLiCmNiBeB_xHqqkZx_ON_UPDATE_COMMAND_UI(OnUpdateIndicator) _xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_jFeLiClIiOjNiClNiClJiCoJiClBiCmGiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiBeB_xHqqkZx_
	// _xZkqqHx_jBlMiDeBiDhGiDiKiCpAiDhNiDeFiDfIiDeOiDiKiDgCiDeOiClFiNmEiCnBjGnPiCmBiCmEiCkLiClNiPoKiNiHiCmJiBeB_xHqqkZx_
	// _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmJjFlGiOjKiCkKjFfMiOkGiClDiCoKiCmIiCkNiCmIiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
	m_fdstSessionTime = fdstDate;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
	if (m_fdstSessionTime != FDSECTIME(-1))
	{
		// _xZkqqHx_jDpKiOjOjFfMiOkGiBeC_xHqqkZx_
		COleDateTime otmDate = FdsecToFiletime(m_fdstSessionTime);
		// IDS_FORM_DATE_TIME_LONG "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d_xZkqqHx_jDpK_xHqqkZx_ %#H_xZkqqHx_iOjO_xHqqkZx_%#M_xZkqqHx_jFkK_xHqqkZx_"
		SetStatusBarText(TStrToWStr(otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG))), ID_INDICATOR_DATE);
	} else
	{
		SetStatusBarText(L"", ID_INDICATOR_DATE);
	}
} // CFCHistFrameTmpl<SUPER, DOC>::SetStatusBarDate.

//----- 06.04.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::GetStatusBarDate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmJjFfMiOkGiClDiCoKiCmEiCkCiCoJjDpKiOjOiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class DOC>
//FDSECTIME CFCHistFrameTmpl<SUPER, DOC>::GetStatusBarDate () const
//{
//	return m_fdstSessionTime;
//} // CFCHistFrameTmpl<SUPER, DOC>::GetStatusBarDate.
//----- 06.04.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::SetHiviewTempMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjAnNjHjKjHpAjFkKiKpCiCpAjAnNjCoIiClFiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjFfMiOkGiClDiClJiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClDiCoKiClNiJlMjAnNjHjKjHpAjFkKiKpCiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_jFkKiKpCiMlDiCmMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_NULL _xZkqqHx_iCpA_xHqqkZx_
 *							 _xZkqqHx_iOhHjCoIiClFiCmEiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jFkKiKpCiMlDiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_jFkKiKpCiMlDiCmMjHjKjHpAjFlGiPjBiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::SetHiviewTempMark (short nForkOrLabel,
													const wchar_t* wcpProjectPath,
													long lDocumentId,
													flint fliSessionIndex)
{
	GetWndHistoryTree()->SetTempMark(nForkOrLabel,
									wcpProjectPath,
									lDocumentId,
									fliSessionIndex);
} // CFCHistFrameTmpl<SUPER, DOC>::SetHiviewTempMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::SetHiviewMarkUpHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCpAjAnNjCoIiClFiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjFfMiOkGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stDocId			:_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCmNjBfDiCmEjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJiDhNiBfLiDeOiClDiCoKiClNiPpDjBnEiCmF_xHqqkZx_
 *			_xZkqqHx_jFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::SetHiviewMarkUpHidocument (	const wchar_t* wcpProjectPath,
																const longSet& stDocId)
{
	GetWndHistoryTree()->SetMarkUpHidocument(
							wcpProjectPath, stDocId);
} // CFCHistFrameTmpl<SUPER, DOC>::SetHiviewMarkUpHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::SyncHiviewToDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeBiImKjChFiPoOjFpBjDjJiCmJiIoKjChGiClDiClJiCoJiBeC_xHqqkZx_
 *			WM_USER_SYNC_HIVIEW_TO_DOCUMENT_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiDgOiDjDiDgIiDiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	viewMode				:_xZkqqHx_jAfGiClFiCkCiDhCiDiFiBfLiDiCiBfLiDgIiCpAiOhHjCoIiBeCjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *									 FDHT_VMODE_NONE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpProjectPath			:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId				:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex			:_xZkqqHx_jFlGiPjBiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSelect				:_xZkqqHx_jBeJjBpAiImKjChFiCpAiOhHjCoIiImKjChFiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
 *			bIsMark					:_xZkqqHx_iDhNiBfLiDeKiBfLiImKjChFiCpAiOhHjCoIiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
 *			bIsFitHtreeViewZoom	:	:_xZkqqHx_iJoGjGmKiDfEiDeDiDfJiCmJiDfJiBfLiDiAiCpAiDhEiDeCiDgCiDgHiClDiClJiCoJiCkJiOhHjCoIiBeC_xHqqkZx_
 *			bScrollTo				:_xZkqqHx_iDhCiDiFiBfLiCmMjBiLiCpAjHjKjHpAiImKjChFiCmJiNiHiCoNiClJiCmEiDfIiDeOiDiNiBfLiDiL_xHqqkZx_
 *						 			 _xZkqqHx_iClHiCoJiCkJiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
BOOL CFCHistFrameTmpl<SUPER, DOC>::SyncHiviewToDocument (
									FTHTViewMode viewMode,
									const wchar_t* wcpProjectPath,
									long lDocumentId,
									flint fliSessionIndex,
									BOOL bIsSelect,
									BOOL bIsMark,
									BOOL bIsFitHtreeViewZoom,
									BOOL bScrollTo,
									const WStringVector* vProjectPath,
									const longVector* vDocumentId)
{
	if (GetWndHistoryTree()->IsWindowVisible())
	{
		return GetWndHistoryTree()->SyncToDocument(	viewMode,
													wcpProjectPath,
													lDocumentId,
													fliSessionIndex,
													bIsSelect,
													bIsMark,
													bIsFitHtreeViewZoom,
													bScrollTo,
													vProjectPath,
													vDocumentId);
	}
	return TRUE;
} // CFCHistFrameTmpl<SUPER, DOC>::SyncHiviewToDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::SetHiviewFontZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhEiDeIiDjDiDgHiCmMiDfJiBfLiDiAjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dZoom	:_xZkqqHx_iDfJiBfLiDiAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::SetHiviewFontZoom (double dZoom)
{
	GetWndHistoryTree()->SetFontZoom(dZoom);
} // CFCHistFrameTmpl<SUPER, DOC>::SetHiviewFontZoom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::ChangeHiviewViewMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhCiDiFiBfLiDiCiBfLiDgIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	viewMode	:_xZkqqHx_iDhCiDiFiBfLiDiCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::ChangeHiviewViewMode (FTHTViewMode viewMode)
{
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!GetWndHistoryTree()->ChangeViewMode(viewMode))
//		FFErrorBox(wstrErrorMessage);
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!GetWndHistoryTree()->ChangeViewMode(viewMode))
		FFErrorBox(FFGetDDErrorMessage());
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::ChangeHiviewViewMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::SetHiviewZoom256
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiCmMiDfJiBfLiDiAjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lZoom256	:_xZkqqHx_iDfJiBfLiDiAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::SetHiviewZoom256 (long lZoom256)
{
	GetWndHistoryTree()->SendMessage(WM_USER_SET_ZOOM256, 0, lZoom256);
} // CFCHistFrameTmpl<SUPER, DOC>::SetHiviewZoom256.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnViewSizingBarVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiDfEiDeDiDfJiCkKjFmPiNfIiClDiCoKiCoJiDgPiBfLiBgJiDfIiDgFiBfLiDfOiDfIiDgPiBfLiBeBiDhEiDeAiDjDiDeOiDfGiDiHiDjDiDgPiBfLiBeB_xHqqkZx_
 *			_xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiBgKiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCommandId	:_xZkqqHx_iDgPiBfLiCpAjDmBjCoIiClHiCoJiDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *				ID_VIEW_STATUS_BAR			:_xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiBeC_xHqqkZx_
 *				ID_VIEW_TOOLBAR_FUNCTION_KEY:_xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiDgPiBfLiBeC_xHqqkZx_
 *				ID_VIEW_CHIP_STORE_VISIBLE	:_xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiBeC_xHqqkZx_
 *				ID_VIEW_HTREE_VISIBLE		:_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKgFiDfCiDhNiDjDiDgIiCkJiCoHiBeB_xHqqkZx_WM_USER_VIEW_SIZING_BAR_VISIBLE_xZkqqHx_iCmM_xHqqkZx_PostMessage_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_iMgPjHfCiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDeMiDiDiDjDiDgPiDfIiPoDiCmMiJeFiDeOiDiKiDgCiDeOiCmJiCoGiCoJiDgAiDgCiDhGiDfIiDgHiDeBjFfMiOkGiBeFjEpBjFfMiOkGiCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiCpAjClMjAnKiPiIjHjNiClHiCoJiCmGiNmEjFgAiJoGiCmMiNnLiCmJiDiBiDgKiDiFiBfLiCmMjFfMiOkGiCkKiJoGjGmKiCmJ_xHqqkZx_
 *			_xZkqqHx_iOgDiCmBiCmEiClFiCnMiCkEiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnViewSizingBarVisible (DWORD dwCommandId)
{
	if (dwCommandId == ID_VIEW_HTREE_VISIBLE)
	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		SetHtreeViewVisible(!IsHtreeViewVisible());
	} else
	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		SUPER::OnViewSizingBarVisible(dwCommandId);
	}
} // CFCHistFrameTmpl<SUPER, DOC>::OnViewSizingBarVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewSizingBarVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiDfEiDeDiDfJiCkKjFmPiNfIiClDiCoKiCoJiDgPiBfLiBgJiDfIiDgFiBfLiDfOiDfIiDgPiBfLiBeBiDhEiDeAiDjDiDeOiDfGiDiHiDjDiDgPiBfLiBeB_xHqqkZx_
 *			_xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiBgKiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_jFfMiOkGiBeFjEpBjFfMiOkGiCpAjAnNjCoIiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewSizingBarVisible (CCmdUI* pCmdUI)
{
	if (pCmdUI->m_nID == ID_VIEW_HTREE_VISIBLE)
	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		pCmdUI->Enable(FFCanBasicOperate());
		pCmdUI->SetCheck(IsHtreeViewVisible());
	} else
	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		SUPER::OnUpdateViewSizingBarVisible(pCmdUI);
	}
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewSizingBarVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::IsHtreeViewVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDhCiDiFiBfLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFfMiOkGjCiGiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
BOOL CFCHistFrameTmpl<SUPER, DOC>::IsHtreeViewVisible () const
{
	return	(m_pCtlBrHTree != NULL && m_pCtlBrHTree->IsWindowVisible()) ||
			(m_pDlgHtreeView != NULL && m_pDlgHtreeView->IsWindowVisible());
} // CFCHistFrameTmpl<SUPER, DOC>::IsHtreeViewVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::SetHtreeViewVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bVisible	:_xZkqqHx_jFfMiOkGiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjEpBjFfMiOkGiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::SetHtreeViewVisible (BOOL bIsVisible)
{
	if (IsHtreeViewVisible() == bIsVisible) return;
	if (bIsVisible)
	{
		if (m_pCtlBrHTree->GetWndSideView() != NULL)
		{
			m_pCtlBrHTree->ShowWindow(SW_SHOW);
			RecalcLayout();
		} else
		{
			m_pDlgHtreeView->SetWindowVisible(TRUE);
		}
		// _xZkqqHx_jEpBjFfMiOkGjCiGiCmNjDkPiKpKiPiIjHjNiCpAiClFiCmIiCkCiCmMiCmFiBeBjFfMiOkGiClDiCoKiClNiPhFiKnEiCmN_xHqqkZx_
		// _xZkqqHx_jFfMiOkGiPpDjBnEiCkKiClIiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiClNiCnPiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
		PushBackSyncHiviewToDocument();
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
	} else
	{
		if (m_pCtlBrHTree->GetWndSideView() != NULL)
		{
			m_pCtlBrHTree->ShowWindow(SW_HIDE);
			RecalcLayout();
		} else
		{
			m_pDlgHtreeView->SetWindowVisible(FALSE);
		}
	}
} // CFCHistFrameTmpl<SUPER, DOC>::SetHtreeViewVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::GetWndHtreeView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDhCiDiFiBfLiDfKiDgCiDgHiCmMiDeFiDeCiDjDiDgIiDeFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDhCiDiFiBfLiDfKiDgCiDgHiCmMiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
CFCWndHtreeView* CFCHistFrameTmpl<SUPER, DOC>::GetWndHtreeView ()
{
	return m_pWndHtreeView;
} // CFCHistFrameTmpl<SUPER, DOC>::GetWndHtreeView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::GetWndHistoryTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDhCiDiFiBfLiCmMiDiBiDeDiDjDiDeFiDeCiDjDiDgIiDeFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDhCiDiFiBfLiCmMiDiBiDeDiDjDiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
CFCWndHistoryTree* CFCHistFrameTmpl<SUPER, DOC>::GetWndHistoryTree ()
{
	return m_pWndHtreeView->GetWndHistoryTree();
} // CFCHistFrameTmpl<SUPER, DOC>::GetWndHistoryTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::PushBackSyncHiviewToDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsSelectHtreeCurrent	:_xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmM_xHqqkZx_
 *									 _xZkqqHx_jBeJjBpAiImKjChFiCmJjAnNjCoIiClHiCoJiCkJiBeI_xHqqkZx_
 *			bIsScrollHtreeView		:_xZkqqHx_iDhCiDiFiBfLiCmMjBiLiCpAjHjKjHpAiImKjChFiCmJiNiHiCoNiClJiCmE_xHqqkZx_
 *									 _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiClHiCoJiCkJiBeI_xHqqkZx_
 *			bIsFitHtreeViewZoom		:_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiOkJjDkOiCmFiDfJiBfLiDiAiClHiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCHistFrameTmpl_xZkqqHx_iCmFiCmNiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJiCkIiCkCiCmEiJeFiDeOiDiKiDgCiDeOjBeJjBpAiCmJiCoGiCoJ_xHqqkZx_
 *			_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiDfCiDhNiDjDiDgIiBgJ_xHqqkZx_OnRbtnHtreeXXX_xZkqqHx_iBgKiCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiMlLiNnNjFfMiOkGjCiGiCmMjFlGiPjBiLhJiCnBiDfKiDgCiDfGiDiHiDjDiCmGiInJiCmIiCoJjFlGiPjBiIlNiCkCiCmN_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiPiIjHjNiClHiCoJiPoKiNiHiCkKjBlNiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmNiBeBjAfGiClFiCkNjAnNjCoIiClDiCoKiCoJjFlGiPjBiClOiCkPiCmFiCmIiCkNiBeBiMlLiNnNjAnNjCoIjCiGiCmMjFlGiPjBiBeB_xHqqkZx_
 *			_xZkqqHx_iDhNiBfLiDeOjCiGiCmMjFlGiPjBiCoAiNfIjAfGiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMlLiNnNiImKjChFiCmGiIoBiCkEjFlGiPjBiCmJjFkKiKpCiDfOiDePiCpAjAnNjChFiClHiCoJiPoKiNiHiCmIiCmHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFlGiPjBiCoAiNfIjAfGiCpAiDgAiDeGiDgCiDeOiClFiCmEiCkIiCkJiCmIiCkCiCmG_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiCkKjElNiJgGiClDiCoKiCmIiCkCiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::PushBackSyncHiviewToDocument (	BOOL bIsSelectHtreeCurrent,
																	BOOL bIsScrollHtreeView,
																	BOOL bIsFitHtreeViewZoom)
{
	WStringVector vProjectPath;
	longVector vDocumentId;
	if (GetWndHistoryTree()->GetLastClickedProjectPath() != NULL &&
		GetWndHistoryTree()->GetLastClickedDocumentId() != -1)
	//----- _xZkqqHx_iDeOiDiKiDgCiDeOiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiBeFjFlGiPjBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeOiDiKiDgCiDeOiClDiCoKiClNjFlGiPjBiCpAiDgAiDeGiDgCiDeOjBmOiPnLiCmJjCmHiJmBiBeC_xHqqkZx_
		vProjectPath.push_back(GetWndHistoryTree()->GetLastClickedProjectPath());
		vDocumentId.push_back(GetWndHistoryTree()->GetLastClickedDocumentId());
	}
	if (GetWndHistoryTree()->GetMarkedProjectPath() != NULL &&
		GetWndHistoryTree()->GetMarkedDocumentId() != -1)
	//----- _xZkqqHx_iDhNiBfLiDeOiCkKjFfMiOkGiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhNiBfLiDeOiImKjChFiCpAiDgAiDeGiDgCiDeOjBmOiPnLiCmJjCmHiJmBiBeC_xHqqkZx_
		vProjectPath.push_back(GetWndHistoryTree()->GetMarkedProjectPath());
		vDocumentId.push_back(GetWndHistoryTree()->GetMarkedDocumentId());
	}
	if (!GetWndHistoryTree()->GetSelectedProjectPath().IsEmpty() &&
		GetWndHistoryTree()->GetSelectedDocumentId() != -1)
	//----- _xZkqqHx_jBeJjBpAiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiBeFjFlGiPjBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFlGiPjBiCpAiDgAiDeGiDgCiDeOjBmOiPnLiCmJjCmHiJmBiBeC_xHqqkZx_
		vProjectPath.push_back(GetWndHistoryTree()->GetSelectedProjectPath());
		vDocumentId.push_back(GetWndHistoryTree()->GetSelectedDocumentId());
	}
	g_pDoc->PushBackDocRequest(	ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT,
								FCReqBase::IS_SELECT_HTREE_CURRENT, bIsSelectHtreeCurrent,
								FCReqBase::IS_SCROLL_HTREE_VIEW, bIsScrollHtreeView,
								FCReqBase::IS_FIT_HTREE_VIEW_ZOOM, bIsFitHtreeViewZoom,
								FCReqBase::PROJECT_PATH_VECTOR, &vProjectPath,
								FCReqBase::HIDOCUMENT_ID_VECTOR, &vDocumentId,
								FCReqBase::NONE);
} // CFCHistFrameTmpl<SUPER, DOC>::PushBackSyncHiviewToDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnFirstExecute
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiNmFiPiJiCmMiLeOjDkOiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnFirstExecute ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	SUPER::OnFirstExecute();

	// _xZkqqHx_iBhFiLeOjDkOiOjOiDiGiBfLiDfFjDgPjIfOiPoOjFpBiBhGiCpAiOmAiNhDiBeC_xHqqkZx_
	// _xZkqqHx_iClBiClBiCpAjChIiJiEiOmAiNhDiCmJiClHiCoJiCmGiBeBjHjKjHpAjFlGiPjBiCkKjAfGiLeLiNoMjAkMiClDiCoKiClNiMoDiCmJ_xHqqkZx_
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_jDgPjIfOiCmGiCmIiCmBiCmEiClFiCnMiCkCiBeBiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjDgPjIfOiClDiCoKiCmIiCkCiPpDjBnEiCmF_xHqqkZx_
	// _xZkqqHx_iNmFiPiJiCmMjFlGiPjBiCkKiNoMjAkMiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_

//----- 06.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetUserId() == GUID_NULL)
	//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iDiGiBfLiDfFjDgPjIfOiDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_
		CFCDlgInitUserRegistration dlg;
		dlg.DoModal();
	}
	if (g_pReg->GetUserId() == GUID_NULL)
	//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// "_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjDgPjIfOiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_\r\n_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmNjHjIjHhAiCmFiCkLiCnMiClJiCpBiBeC_xHqqkZx_"
		FFErrorBox(IDS_ERR_MSG_USER_ID_NOT_REGISTERED);
	}
} // CFCHistFrameTmpl<SUPER, DOC>::OnFirstExecute.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::PostOnCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OnCreate_xZkqqHx_iKnGjAjEiCmMiOmAiNhDjClMiMoDiCmJiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpCreateStruct	: _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiPiJiKpKiJlLiKgFiOoNjFmPjAjEiCmMiNfMjBkCjBmMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::PostOnCreate (CFrameWnd* pWndFrame)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	SUPER::PostOnCreate(pWndFrame);

//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmMiDfOiBfLiDfBiDgCiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
	FFGetApp()->RegisterPopHintTarget(m_hWnd);
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiBgJiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiBgKiCpAiNoMjAkM_xHqqkZx_ -----
	m_pCtlBrHTree = new CFCCtlBrSideView();
	m_pCtlBrHTree->Create(	pWndFrame,
							WS_CHILD|WS_VISIBLE,
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//							IDW_HTREE_VIEW,
							IDD_WIN_SIDE_HTREE,
							this);

//	m_pCtlBrHTree->SetBarStyle(CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_ALIGN_LEFT);

// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_pDlgHtreeView = new CFCDlgSideView(IDW_HTREE_VIEW);
	m_pDlgHtreeView = new CFCDlgSideView();
	m_pDlgHtreeView->Create(IDD_WIN_SIDE_HTREE, this);
	m_pDlgHtreeView->SetIcon(FFGetApp()->LoadIcon(IDR_HIST_VIEW), FALSE);
	m_pDlgHtreeView->SetWindowVisible();

	// _xZkqqHx_iClBiCmMiOjOjDfPiCmFiCmNiBeB_xHqqkZx_m_pCtlBrHTree _xZkqqHx_iCmMjFfMiOkGiBeFjEpBjFfMiOkGiCmNiKgNjCoIiClFiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iClNiClOiClFiBeB_xHqqkZx_m_pDlgHtreeView _xZkqqHx_iCmMjFfMiOkGiBeFjEpBjFfMiOkGiCmNiKgNjCoIiClFiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_
	// m_pDlgHtreeView _xZkqqHx_iCmMjFfMiOkGiPpDjBnEiCkJiCoHiBeB_xHqqkZx_m_pWndHtreeView _xZkqqHx_iCmMjAnNjCoIiCpAjElLjCgGiClHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDhCiDiFiBfLiDfKiDgCiDgHiBeC_xHqqkZx_
	m_pWndHtreeView = new CFCWndHtreeView();
	if (m_pDlgHtreeView->IsWindowVisible())
	//----- _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiBgJiDeFiDeCiDjDiDgIiDeFiBgKiCkKjFfMiOkGiPpDjBnEiCmMiPoKiNiH_xHqqkZx_ ----
	{
		m_pWndHtreeView->Create(CRect(0, 0, 10, 10), m_pDlgHtreeView, 0);
		m_pDlgHtreeView->SetWndSideView(m_pWndHtreeView);
	} else
	//----- _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiBgJiDeFiDeCiDjDiDgIiDeFiBgKiCkKjEpBjFfMiOkGiPpDjBnEiCmMiPoKiNiH_xHqqkZx_ ----
	{
		m_pWndHtreeView->Create(CRect(0, 0, 10, 10), m_pCtlBrHTree, 0);
		m_pCtlBrHTree->SetWndSideView(m_pWndHtreeView);
	}

//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmMjDpKiOjOjFfMiOkGiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	SetStatusBarText(L"", ID_INDICATOR_USER);
	SetStatusBarText(L"", ID_INDICATOR_DATE);
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::PostOnCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::PreOnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OnDestroy_xZkqqHx_iKnGjAjEiCmMiOmAiNhDiOjOiCmJiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::PreOnDestroy ()
{
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmMiDfOiBfLiDfBiDgCiDgHiCkJiCoHjDgPjIfOiJpAiPjMiBeC_xHqqkZx_
	FFGetApp()->UnregisterPopHintTarget(m_hWnd);
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjEgKiKpM_xHqqkZx_ -----
	m_pCtlBrHTree->DestroyWindow();
	delete m_pCtlBrHTree;
	m_pCtlBrHTree = NULL;

	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiDeFiDeCiDjDiDgIiDeFiCmMjEgKiKpM_xHqqkZx_ -----
	m_pDlgHtreeView->DestroyWindow();
	delete m_pDlgHtreeView;
	m_pDlgHtreeView = NULL;

	//----- _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDhCiDiFiBfLiDfKiDgCiDgHiCmMjEgKiKpM_xHqqkZx_ -----
	m_pWndHtreeView->DestroyWindow();
	delete m_pWndHtreeView;
	m_pWndHtreeView = NULL;

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	SUPER::PreOnDestroy();
} // CFCHistFrameTmpl<SUPER, DOC>::PreOnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::GetIndicatorArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiPiJiKpKiJlLiCmMiClNiCnPiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiPiJiKpKiJlLiCmMiClNiCnPiCmMjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
const UINT* CFCHistFrameTmpl<SUPER, DOC>::GetIndicatorArray () const
{
	static UINT s_indicators[INDICATOR_COUNT + 1] =
	{
		ID_INDICATOR_PROP,	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiBeCiNmAjFfHiPoOjFpBiBeC_xHqqkZx_
		ID_INDICATOR_USER,	// _xZkqqHx_iDiGiBfLiDfFiBfLjGlMiBeC_xHqqkZx_
		ID_INDICATOR_DATE,	// _xZkqqHx_jDpKiOjOiBeC_xHqqkZx_
		ID_INDICATOR_KANA,	// _xZkqqHx_iDeKiDgJiBeC_xHqqkZx_
		ID_INDICATOR_CAPS,	// CAPS LOCK_xZkqqHx_iBeC_xHqqkZx_
		ID_INDICATOR_OVR,	// _xZkqqHx_iPoDiPjBiCkLiBeC_xHqqkZx_
		DWORD(-1),			// _xZkqqHx_iPeJjCfLiBeCiDfPiDhOiBfLiBeC_xHqqkZx_
	}; // s_indicators.
	ASSERT(s_indicators[INDICATOR_COUNT] == DWORD(-1));
	return s_indicators;
} // CFCHistFrameTmpl<SUPER, DOC>::GetIndicatorArray.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::GetIndicatorArraySize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetIndicatorArray_xZkqqHx_iKnGjAjEiCkKjFnEiClHjEhKjHpBiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
long CFCHistFrameTmpl<SUPER, DOC>::GetIndicatorArraySize () const
{
	return INDICATOR_COUNT;
} // CFCHistFrameTmpl<SUPER, DOC>::GetIndicatorArraySize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::GetDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
DOC* CFCHistFrameTmpl<SUPER, DOC>::GetDocument ()
{
	return (DOC*)g_pDoc;
} // CFCHistFrameTmpl<SUPER, DOC>::GetDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnCmdMsg
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjDlBiCkLiDgGiDeCiDfIiDhAiDgCiDgAiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iDhHiDiLiDhGiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiPiIjHjNiClDiCoKiClNiCmGiCkLiCmN_xHqqkZx_ 0 _xZkqqHx_iImIiKePiBeCiClLiCoKiImIiKePiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
 *
//----- 05.01.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiCpAiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClFiCmIiCkCiCmGiBeBiDfCiDhNiDjDiDgI_xHqqkZx_(ID_XXXX)_xZkqqHx_iCkK_xHqqkZx_
// *			_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjDmNiCkPiCoHiCoKiCmIiCkCiBeC_xHqqkZx_
// *
//----- 05.01.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
BOOL CFCHistFrameTmpl<SUPER, DOC>::OnCmdMsg (UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	if (pHandlerInfo == NULL)
	{
	//----- 06.01.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		if (nCode == CN_UPDATE_COMMAND_UI && !FFCanBasicOperate())
		//----- BasicOperate_xZkqqHx_iCkKjFhDiJmCiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiBeBiDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiCkKiDiNiDgCiDeOiClDiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
			// _xZkqqHx_iDfCiDhNiDjDiDgIiCpAjBfDiCmEjFhDiJmCiCmGiClHiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iClLiCkEiClFiCmIiCkCiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiCmMiCnNiCmFiDgFiBfLiDhFiDiLiOfBiPmG_xHqqkZx_->_xZkqqHx_jHiOiClPiCoJiClBiCmGiCoAiCkAiCoJiClNiCnPiBeC_xHqqkZx_
			((CCmdUI*)pExtra)->Enable(FALSE);
			return TRUE;
		}
	//----- 06.01.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		//----- _xZkqqHx_iClBiCmMiDhEiDiMiBfLiDiAiCmMiDfCiDhNiDjDiDgIiCpAjClCiCnHiCoJ_xHqqkZx_ -----
		switch (nID)
		{
		case ID_VIEW_HTREE_DOCK_OR_FLOAT:
			switch (nCode)
			{
			case CN_COMMAND:
				OnViewHtreeDockOrFloat();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateViewHtreeDockOrFloat((CCmdUI*)pExtra);
				return TRUE;
			}
			break;

		case ID_VIEW_HTREE_SIDE_CHANGE:
			switch (nCode)
			{
			case CN_COMMAND:
				OnViewHtreeSideChange();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateViewHtreeSideChange((CCmdUI*)pExtra);
				return TRUE;
			}
			break;

		case ID_HTREE_FONT_SMALL:
			switch (nCode)
			{
			case CN_COMMAND:
				OnHtreeFontSmall();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateHtreeFontSmall((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_HTREE_FONT_MEDIUM:
			switch (nCode)
			{
			case CN_COMMAND:
				OnHtreeFontMedium();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateHtreeFontMedium((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_HTREE_FONT_LARGE:
			switch (nCode)
			{
			case CN_COMMAND:
				OnHtreeFontLarge();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateHtreeFontLarge((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_HTREE_PROJECT_VIEW:
			switch (nCode)
			{
			case CN_COMMAND:
				OnHtreeProjectView();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateHtreeProjectView((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_HTREE_TREE_VIEW:
			switch (nCode)
			{
			case CN_COMMAND:
				OnHtreeTreeView();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateHtreeTreeView((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_HTREE_BRANCH_VIEW:
			switch (nCode)
			{
			case CN_COMMAND:
				OnHtreeBranchView();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateHtreeBranchView((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_RBTN_HTREE_DOC_DELETE:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeDocDelete();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeDocDelete((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_RBTN_HTREE_MOVE_HI_POSITION:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeMoveHiPosition();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeMoveHiPosition((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_RBTN_HTREE_PROJECT_PROPERTY:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeProjectProperty();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeProjectProperty((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_RBTN_HTREE_DOCUMENT_PROPERTY:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeDocumentProperty();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeDocumentProperty((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_RBTN_HTREE_PUT_HI_FORK_TAG:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreePutHiForkTag();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreePutHiForkTag((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_RBTN_HTREE_HI_TAG_PROPERTY:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeHiTagProperty();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeHiTagProperty((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
// 06.10.20 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		case ID_RBTN_DELETE_HI_FORK_TAG:
		case ID_RBTN_HTREE_DELETE_HI_FORK_TAG:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeDeleteHiForkTag();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeDeleteHiForkTag((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_RBTN_HTREE_FORK_HISTORY:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeForkHistory();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeForkHistory((CCmdUI*)pExtra);
				return TRUE;
			}
			break;

//----- 06.04.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		case ID_RBTN_HTREE_CHANGE_BRANCH_INTO_TRUNK:
//			switch (nCode)
//			{
//			case CN_COMMAND:
//				OnRbtnHtreeChangeBranchIntoTrunk();
//				return TRUE;
//			case CN_UPDATE_COMMAND_UI:
//				OnUpdateRbtnHtreeChangeBranchIntoTrunk((CCmdUI*)pExtra);
//				return TRUE;
//			}
//			break;
//
//		case ID_RBTN_HTREE_CHANGE_TRUNK_INTO_BRANCH:
//			switch (nCode)
//			{
//			case CN_COMMAND:
//				OnRbtnHtreeChangeTrunkIntoBranch();
//				return TRUE;
//			case CN_UPDATE_COMMAND_UI:
//				OnUpdateRbtnHtreeChangeTrunkIntoBranch((CCmdUI*)pExtra);
//				return TRUE;
//			}
//			break;
//
//		case ID_RBTN_HTREE_CHANGE_BRANCH_INTO_TOP:
//			switch (nCode)
//			{
//			case CN_COMMAND:
//				OnRbtnHtreeChangeBranchIntoTop();
//				return TRUE;
//			case CN_UPDATE_COMMAND_UI:
//				OnUpdateRbtnHtreeChangeBranchIntoTop((CCmdUI*)pExtra);
//				return TRUE;
//			}
//			break;
//----- 06.04.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		case ID_RBTN_HTREE_TIME_LABEL_PROPERTY:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeTimeLabelProperty();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeTimeLabelProperty((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_RBTN_HTREE_DELETE_TIME_LABEL:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeDeleteTimeLabel();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeDeleteTimeLabel((CCmdUI*)pExtra);
				return TRUE;
			}
			break;

		case ID_RBTN_HTREE_EXEC_HISTVIEW_TARGET:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeExecHistviewTarget();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeExecHistviewTarget((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
		case ID_RBTN_HTREE_EXEC_HISTDRAW_TARGET:
			switch (nCode)
			{
			case CN_COMMAND:
				OnRbtnHtreeExecHistdrawTarget();
				return TRUE;
			case CN_UPDATE_COMMAND_UI:
				OnUpdateRbtnHtreeExecHistdrawTarget((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		case ID_INDICATOR_USER:
		case ID_INDICATOR_DATE:
			switch (nCode)
			{
			case CN_UPDATE_COMMAND_UI:
				BASE_CLASS::OnUpdateIndicator((CCmdUI*)pExtra);
				return TRUE;
			}
			break;
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		}
	}
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	return SUPER::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
} // CFCHistFrameTmpl<SUPER, DOC>::OnCmdMsg.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnWndMsg
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDiBiDgCiDfKiBfLiDfHiCpAjDlBiCkLiDgGiDeCiDfIiDhAiDgCiDgAiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	message	:_xZkqqHx_jBjHiCoJiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *			wParam	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiImLjBlGiCmMjCmHiJmBiPoOjFpBiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiImLjBlGiCmMjCmHiJmBiPoOjFpBiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_ 
 *			pResult	:WindowProc _xZkqqHx_iCmMjGnPiCoIjCgMiBeCiDiBiDgCiDfKiBfLiDfHiCmJiImLjBlGiClFiCnMiClHiBeC_xHqqkZx_
 *					 NULL _xZkqqHx_iCmMiPoKiNiHiCoAiCkAiCoIiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiPiIjHjNiClDiCoKiClNiCmGiCkLiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeCiClLiCoKiImIiKePiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiCpAiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClFiCmIiCkCiCmGiBeBiDiBiDgCiDfKiBfLiDfHiCkK_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjDmNiCkPiCoHiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
BOOL CFCHistFrameTmpl<SUPER, DOC>::OnWndMsg (UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
//----- 04.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//	if (SUPER::OnWndMsg(message, wParam, lParam, pResult))
//		return TRUE;
//----- 04.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	switch (message)
	{
	case WM_USER_WHT_LBUTTONDOWN:	// CFCWndHistoryTree _xZkqqHx_iCmJiCkIiCkCiCmEiBeBiNlGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiPoKiNiHiCmMjCmKjCgNiBeC_xHqqkZx_
		*pResult = OnUserWhtLbuttondown(wParam, lParam);
		return TRUE;

	case WM_USER_UNLOCK_REQUEST:	// READ_xZkqqHx_iDiNiDgCiDeOiJpAjFpKjHhGiLiBiCmMiDiBiDgCiDfKiBfLiDfHiBeCiJlMjBhKiDhEiDeAiDeDiDiLiDfEiBfLiDgPiCkJiCoHiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
		*pResult = OnUserUnlockRequest(wParam, lParam);
		return TRUE;

	case WM_USER_SET_HIVIEW_ZOOM256:
		*pResult = OnUserSetHiviewZoom256(wParam, lParam);
		return TRUE;

//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case WM_USER_PURSUER_TEXT_NEED_INFO:
		*pResult = OnUserPursuerTextNeedInfo(wParam, lParam);
		return TRUE;
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	default:
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		return SUPER::OnWndMsg(message, wParam, lParam, pResult);
	}
//----- 04.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnWndMsg.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUserWhtLbuttondown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WM_USER_WHT_LBUTTONDOWN_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iMmEiCnBiPgPiClFiMlDiCmMiDeFiDeCiDjDiDgIiDeFiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiMiLiJmKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCWndHistoryTree _xZkqqHx_iCmJiCkIiCkCiCmEiBeBiNlGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiPoKiNiHiCmMjCmKjCgNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
LRESULT CFCHistFrameTmpl<SUPER, DOC>::OnUserWhtLbuttondown (WPARAM wParam, LPARAM lParam)
{
	return SendMessage(WM_COMMAND, ID_RBTN_HTREE_MOVE_HI_POSITION, 0);
} // CFCHistFrameTmpl<SUPER, DOC>::OnUserWhtLbuttondown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUserUnlockRequest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WM_USER_UNLOCK_REQUEST_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCfAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	READ_xZkqqHx_iDiNiDgCiDeOiJpAjFpKjHhGiLiBiCmMiDiBiDgCiDfKiBfLiDfHiBeCiJlMjBhKiDhEiDeAiDeDiDiLiDfEiBfLiDgPiCkJiCoHiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
LRESULT CFCHistFrameTmpl<SUPER, DOC>::OnUserUnlockRequest (WPARAM wParam, LPARAM lParam)
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmFiCmIiCkCiPoKiNiHiCmNiBeBiJlMjBhKiDhEiDeAiDeDiDiLiDfEiBfLiDgPiCmJ_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiCmM_xHqqkZx_
	// _xZkqqHx_iJpAiPjMiCpAiOhHiOkGiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmNiJpAiPjMiCmFiCkLiCmIiCkCiCkKiBeBiJlMjBhKiDhEiDeAiDeDiDiLiDfEiBfLiDgPjCiGiCmFiBeB_xHqqkZx_
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiCkKiOkJjDkOjDeJiCmJiJpAiPjMiCpAiNhDiCkEiClNiCnPjGoCjBoIiCmIiCkCiBeC_xHqqkZx_
	if (!g_pFileServer->IsFlushing())
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		TRACE(_T("WM_USER_UNLOCK_REQUEST\n"));
		// _xZkqqHx_iJpAjFpKjHhGiLiBiCkKiCkAiCoKiCmOiBeBiClLiCoKiCpAiJpAjFpKiBeC_xHqqkZx_
		g_pFileServer->UnkeepIfUnlockRequest();
	}
	return 1;
} // CFCHistFrameTmpl<SUPER, DOC>::OnUserUnlockRequest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUserSetHiviewZoom256
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WM_USER_SET_HIVIEW_ZOOM256_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jAfGiClFiCkCiDfJiBfLiDiAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCfAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDfJiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
LRESULT CFCHistFrameTmpl<SUPER, DOC>::OnUserSetHiviewZoom256 (WPARAM wParam, LPARAM lParam)
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDfJiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_SET_HIVIEW_ZOOM,
								FCReqBase::VIEW_ZOOM_256, lParam,
								FCReqBase::NONE);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->ProceedDocRequest();
	return 1;
} // CFCHistFrameTmpl<SUPER, DOC>::OnUserSetHiviewZoom256.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUserPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iImIiKePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmNiBeBiDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiCpAjClCiCnHiBeBiCnMiClIiClLiCmMiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			WM_USER_PURSUER_TEXT_NEED_INFO_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_SendMessage_xZkqqHx_iCmFjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjGnPiCoIjCgMiCkKiCePiCmMiPoKiNiHiCmNiBeBiClLiCmMiDeFiDeCiDjDiDgIiDeFiCmMjAgFiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jGnPiCoIjCgMiCkKiCePiImIiKePiCmFiCkAiCoJiCkJjAgFiDeFiDeCiDjDiDgIiDeFiCkKjGlDiCkNiCmIiCoJiCnMiCmFiClBiCoKiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_
 *			wParam _xZkqqHx_iCmJiCmNiBeBiNmFiPiJiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiDeFiDeCiDjDiDgIiDeFiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
LRESULT CFCHistFrameTmpl<SUPER, DOC>::OnUserPursuerTextNeedInfo (WPARAM wParam, LPARAM)
{
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupStatusBarHint())
	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmMiDhBiDjDiDgHiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		HWND hwndPoint = HWND(wParam);
		if (m_wndStatusBar.m_hWnd == hwndPoint)
		//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmJiDhNiDeFiDfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiGiBfLiDfFiBfLjGlMjFfMiOkGjIgHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
			int iIndexUser = m_wndStatusBar.CommandToIndex(ID_INDICATOR_USER);
			CRect rtUser;
			m_wndStatusBar.GetItemRect(iIndexUser, rtUser);
			// _xZkqqHx_jDpKiOjOjFfMiOkGjIgHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
			int iIndexDate = m_wndStatusBar.CommandToIndex(ID_INDICATOR_DATE);
			CRect rtDate;
			m_wndStatusBar.GetItemRect(iIndexDate, rtDate);
			// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
			CPoint ptMouse;
			(void)::GetCursorPos(&ptMouse);
			m_wndStatusBar.ScreenToClient(&ptMouse);
			if ((rtUser | rtDate).PtInRect(ptMouse))
			//----- _xZkqqHx_iDeKiBfLiDfMiDiLiCkKiDiGiBfLiDfFiBfLjGlMiCkJjDpKiOjOiCmMjIgHjDoAiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
				WString wstrDate;
				if (m_fdstSessionTime != FDSECTIME(-1))
				{
					// _xZkqqHx_jDpKiOjOjFfMiOkGiBeC_xHqqkZx_
					COleDateTime otmDate = FdsecToFiletime(m_fdstSessionTime);
					// IDS_FORM_DATE_TIME_LONG "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d_xZkqqHx_jDpK_xHqqkZx_ %#H_xZkqqHx_iOjO_xHqqkZx_%#M_xZkqqHx_jFkK_xHqqkZx_"
					wstrDate = TStrToWStr(otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
				}
				// _xZkqqHx_jFnCiPfHiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				WString wstrUserId;
				if (m_guidSessionUserId != GUID_NULL)
					wstrUserId = FFGuidToString(m_guidSessionUserId);
				// IDS_FORM_HTREE_PROPERTY_M = "_xZkqqHx_jDpKiOjO_xHqqkZx_:%s\r\n_xZkqqHx_jFnCiPfHiOnCjGlM_xHqqkZx_:%s\r\n_xZkqqHx_jFnCiPfHiOnC_xHqqkZx_ID:%s"
				FFGetApp()->GetPopHint()->SetTargetInfo(
					FormatResString(IDS_FORM_HTREE_PROPERTY_M,
									wstrDate.c_str(),				// _xZkqqHx_jDpKiOjOiBeC_xHqqkZx_
									m_wstrSessionUserName.c_str(),	// _xZkqqHx_jFnCiPfHiOnCjGlMiBeC_xHqqkZx_
									wstrUserId.c_str()));			// _xZkqqHx_jFnCiPfHiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			}
		}
	}
	return 0;
} // CFCHistFrameTmpl<SUPER, DOC>::OnUserPursuerTextNeedInfo.

//----- 05.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::ActivateFrame
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDeDiDjDiDhEiDiMiBfLiDiAiCkKiDeBiDeOiDgFiDeCiDhFiCmJiCmIiCoJiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nCmdShow	:ShowWindow_xZkqqHx_iCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfEiDeDiDfJiCmN_xHqqkZx_PreCreateWindow_xZkqqHx_iCmFjAnNjCoIiJmCjEfMiClOiCkKiBeBiDeFiDeCiDjDiDgIiDeF_xHqqkZx_
// *			_xZkqqHx_iDfIiDfOiDeDiDiLiBgJiNmFjBoFiJlLiBgKiCmNiClBiClBiCmFiCmIiCkPiCoKiCmOiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
// *			_xZkqqHx_iLhEiCmJiBeBiDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAiClBiClBiCmFjAnNjCoIiClHiCoJiCmGiBeBiDfEiDeDiDfJiCmMjCmKjCgNiCkK_xHqqkZx_
// *			View_xZkqqHx_jDjJiCmJiNhDiCkLjDgOiCoHiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.18 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class DOC>
//void CFCHistFrameTmpl<SUPER, DOC>::ActivateFrame (int nCmdShow)
//{
//	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiBgJiDeFiDeCiDjDiDgIiDeFiBgKiCpAiNoMjAkM_xHqqkZx_ -----
//	// PostOnCreate _xZkqqHx_iCmFiNoMjAkMiClHiCoJiCmGiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhHiDiLiDhGiDhLiDfOiDjDiCkK_xHqqkZx_
//	// HIDE _xZkqqHx_iCmJiCmIiCmBiCmEiClFiCnMiCkEiBeCiCnMiClOiDhHiDiLiDhGiKnGiMfHiCmMiPiAjEpFiCkKiPgPjHiIiCmEiCkCiCmIiCkC_xHqqkZx_
//	// _xZkqqHx_iClNiCnPiClOiCmGiOhGiCoNiCoKiCoJiBeC_xHqqkZx_
//	if (m_pDlgHtreeView == NULL)
//	{
//		m_pDlgHtreeView = new CFCDlgSideView(IDW_HTREE_VIEW);
//		m_pDlgHtreeView->Create(CFCDlgSideView::IDD, this);
//		m_pDlgHtreeView->SetIcon(FFGetApp()->LoadIcon(IDR_HIST_VIEW), FALSE);
////		m_pDlgHtreeView->ShowWindow(SW_SHOW);
//	}
//
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	SUPER::ActivateFrame(nCmdShow);
//} // CFCHistFrameTmpl<SUPER, DOC>::ActivateFrame.
//----- 05.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.10.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnViewHtreeVisible
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class DOC>
//void CFCHistFrameTmpl<SUPER, DOC>::OnViewHtreeVisible ()
//{
//	SetHtreeViewVisible(!IsHtreeViewVisible());
//} // CFCHistFrameTmpl<SUPER, DOC>::OnViewHtreeVisible.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewHtreeVisible
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class DOC>
//void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewHtreeVisible (CCmdUI* pCmdUI)
//{
//	pCmdUI->Enable(FFCanBasicOperate());
//	pCmdUI->SetCheck(IsHtreeViewVisible());
//} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewHtreeVisible.
//----- 05.10.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnViewHtreeDockOrFloat
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjFfMiOkGjFpLjGeAiCpAjAnIiCoIjBnGiCkGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnViewHtreeDockOrFloat ()
{
	// _xZkqqHx_jEpBjFfMiOkGjCiGiCmFiCkAiCoKiCmOiPiIjHjNiClFiCmIiCkCiBeC_xHqqkZx_
	if (!IsHtreeViewVisible()) return;

	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjAgFiCpAjFhEiCkPjBnGiCkGiCoJiBeC_xHqqkZx_
	if (m_pCtlBrHTree->GetWndSideView() != NULL)
	{
		GetWndHtreeView()->SetParent(m_pDlgHtreeView);
		m_pCtlBrHTree->SetWndSideView(NULL);
		m_pDlgHtreeView->SetWndSideView(GetWndHtreeView());
		m_pCtlBrHTree->ShowWindow(SW_HIDE);
		// RecalcLayout _xZkqqHx_iCmFjFfMiOkGiCpAiNfIjAfGiClFiCmEiCkJiCoHiBeB_xHqqkZx_m_pDlgHtreeView _xZkqqHx_iCpA_xHqqkZx_
		// _xZkqqHx_jFfMiOkGiClHiCoJiBeC_xHqqkZx_
		RecalcLayout();
		m_pDlgHtreeView->SetWindowVisible(TRUE);
	} else
	{
		GetWndHtreeView()->SetParent(m_pCtlBrHTree);
		m_pDlgHtreeView->SetWndSideView(NULL);
		m_pCtlBrHTree->SetWndSideView(GetWndHtreeView());
		m_pDlgHtreeView->SetWindowVisible(FALSE);
		// m_pDlgHtreeView _xZkqqHx_iCkKiDeMiDiDiDjDiDgPiDfIiCmJiCkJiCkJiCmBiCmEiCkCiCoJiPoKiNiHiBeBiClBiClBiCmF_xHqqkZx_
		// _xZkqqHx_iNmEjFfMiOkGiCpAiClFiCmEiCkIiCkJiCmIiCkCiCmGiBeBiJlKiCmM_xHqqkZx_ RecalcLayout _xZkqqHx_iCmFiNfIjAfGjHmMiIoGiCpA_xHqqkZx_
		// _xZkqqHx_iPmBiLiOiClDiCoKiCmEiClFiCnMiCkCiBeB_xHqqkZx_m_pDlgHtreeView_xZkqqHx_iCmMiDeDiDiBiBfLiDfHiCkKiDeMiDiDiDjDiDgPiDfIiCmJ_xHqqkZx_
		// _xZkqqHx_iOgDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		UpdateWindow();
		m_pCtlBrHTree->ShowWindow(SW_SHOW);
		RecalcLayout();
	}
} // CFCHistFrameTmpl<SUPER, DOC>::OnViewHtreeDockOrFloat.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewHtreeDockOrFloat
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjFfMiOkGjFpLjGeAiCpAjAnIiCoIjBnGiCkGiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewHtreeDockOrFloat (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && IsHtreeViewVisible());
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewHtreeDockOrFloat.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnViewHtreeSideChange
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjElNjBmOjBkEiCnGiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnViewHtreeSideChange ()
{
	m_pCtlBrHTree->SetIsLeftSide(!m_pCtlBrHTree->GetIsLeftSide());
} // CFCHistFrameTmpl<SUPER, DOC>::OnViewHtreeSideChange.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewHtreeSideChange
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjElNjBmOjBkEiCnGiInKjDkOiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewHtreeSideChange (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && IsHtreeViewVisible());
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateViewHtreeSideChange.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnHtreeFontSmall
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiPkMiClDiCkCiDhEiDeIiDjDiDgHiCmFjFfMiOkGiBhGiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnHtreeFontSmall ()
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhEiDeIiDjDiDgHiDfJiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_SET_HIVIEW_FONT_ZOOM,
								FCReqBase::HTSCRN_FONT_ZOOM, 0.5,
								FCReqBase::NONE);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->ProceedDocRequest();
} // CFCHistFrameTmpl<SUPER, DOC>::OnHtreeFontSmall.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeFontSmall
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiPkMiClDiCkCiDhEiDeIiDjDiDgHiCmFjFfMiOkGiBhGiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeFontSmall (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	FFCanBasicOperate() &&
					GetWndHistoryTree()->IsWindowVisible());
	pCmdUI->SetRadio(rougheq(GetWndHistoryTree()->GetFontZoom(), 0.5));
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeFontSmall.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnHtreeFontMedium
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjFiBjCmKiCmMiDhEiDeIiDjDiDgHiCmFjFfMiOkGiBhGiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnHtreeFontMedium ()
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhEiDeIiDjDiDgHiDfJiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_SET_HIVIEW_FONT_ZOOM,
								FCReqBase::HTSCRN_FONT_ZOOM, 0.75,
								FCReqBase::NONE);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->ProceedDocRequest();
} // CFCHistFrameTmpl<SUPER, DOC>::OnHtreeFontMedium.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeFontMedium
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjFiBjCmKiCmMiDhEiDeIiDjDiDgHiCmFjFfMiOkGiBhGiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeFontMedium (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	FFCanBasicOperate() &&
					GetWndHistoryTree()->IsWindowVisible());
	pCmdUI->SetRadio(rougheq(GetWndHistoryTree()->GetFontZoom(), 0.75));
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeFontMedium.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnHtreeFontLarge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjBoFiCkLiCmIiDhEiDeIiDjDiDgHiCmFjFfMiOkGiBhGiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnHtreeFontLarge ()
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhEiDeIiDjDiDgHiDfJiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_SET_HIVIEW_FONT_ZOOM,
								FCReqBase::HTSCRN_FONT_ZOOM, 1.0,
								FCReqBase::NONE);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->ProceedDocRequest();
} // CFCHistFrameTmpl<SUPER, DOC>::OnHtreeFontLarge.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeFontLarge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjBoFiCkLiCmIiDhEiDeIiDjDiDgHiCmFjFfMiOkGiBhGiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeFontLarge (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	FFCanBasicOperate() &&
					GetWndHistoryTree()->IsWindowVisible());
	pCmdUI->SetRadio(rougheq(GetWndHistoryTree()->GetFontZoom(), 1.0));
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeFontLarge.

//----- 04.11.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnHtreeProjectView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjFfMiOkGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnHtreeProjectView ()
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhCiDiFiBfLiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_CHANGE_HIVIEW_VIEW_MODE,
								FCReqBase::HTSCRN_VIEW_MODE, FDHT_VMODE_PROJECT,
								FCReqBase::NONE);

	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->ProceedDocRequest();
} // CFCHistFrameTmpl<SUPER, DOC>::OnHtreeProjectView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeProjectView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjFfMiOkGiBhGiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeProjectView (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	FFCanBasicOperate() &&
					GetWndHistoryTree()->IsWindowVisible() &&
					GetWndHistoryTree()->CanChangeViewMode(FDHT_VMODE_PROJECT));
	pCmdUI->SetRadio(GetWndHistoryTree()->GetViewMode() == FDHT_VMODE_PROJECT);
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeProjectView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnHtreeTreeView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjFfMiOkGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnHtreeTreeView ()
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhCiDiFiBfLiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_CHANGE_HIVIEW_VIEW_MODE,
								FCReqBase::HTSCRN_VIEW_MODE, FDHT_VMODE_TREE,
								FCReqBase::NONE);
//----- 06.11.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	// HistDraw_xZkqqHx_iCmFiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCkJiCoHjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnG_xHqqkZx_
	// _xZkqqHx_jFmPiNfIiClHiCoJiNnLiBeBjHjKjHpAiImKjChFiCkKiNfIjAfGiClDiCoKiCmIiCkCiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	if (!g_pDoc->IsThereDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT))
		g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
//----- 06.11.30 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->ProceedDocRequest();
} // CFCHistFrameTmpl<SUPER, DOC>::OnHtreeTreeView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeTreeView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjFfMiOkGiBhGiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeTreeView (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	FFCanBasicOperate() &&
					GetWndHistoryTree()->IsWindowVisible() &&
					GetWndHistoryTree()->CanChangeViewMode(FDHT_VMODE_TREE));
	pCmdUI->SetRadio(GetWndHistoryTree()->GetViewMode() == FDHT_VMODE_TREE);
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeTreeView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnHtreeBranchView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjFfMiOkGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnHtreeBranchView ()
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhCiDiFiBfLiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(	ID_DREQ_CHANGE_HIVIEW_VIEW_MODE,
								FCReqBase::HTSCRN_VIEW_MODE, FDHT_VMODE_BRANCH,
								FCReqBase::NONE);
//----- 06.11.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	// HistDraw_xZkqqHx_iCmFiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCkJiCoHiMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnG_xHqqkZx_
	// _xZkqqHx_jFmPiNfIiClHiCoJiNnLiBeBjHjKjHpAiImKjChFiCkKiNfIjAfGiClDiCoKiCmIiCkCiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	if (!g_pDoc->IsThereDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT))
		g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
//----- 06.11.30 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	g_pDoc->PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->ProceedDocRequest();
} // CFCHistFrameTmpl<SUPER, DOC>::OnHtreeBranchView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeBranchView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjFfMiOkGiBhGiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeBranchView (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	FFCanBasicOperate() &&
					GetWndHistoryTree()->IsWindowVisible() &&
					GetWndHistoryTree()->CanChangeViewMode(FDHT_VMODE_BRANCH));
	pCmdUI->SetRadio(GetWndHistoryTree()->GetViewMode() == FDHT_VMODE_BRANCH);
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateHtreeBranchView.
//----- 04.11.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDocDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjHjKjHpAjFlGiPjBiCpAiNoNiPjMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDocDelete ()
{
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	if (GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath, &lSelectedDocumentId))
	{
		// "_xZkqqHx_iClBiCmMiPiIjHjNiCmNiMlDiCmJjGnPiClHiClBiCmGiCmNiCmFiCkLiCnMiClJiCpBiBeCiOmAiNhDiClFiCnMiClHiCkJiBeI_xHqqkZx_"
		if (FFMessageBox(IDS_MSG_NOT_UNDO_PROCESS_IS_CONTINUE, 0, MB_YESNO) == IDYES)
		{
			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoNiPjMiCmMiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_DELETE_HIDOCUMENT,
										FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
										FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
										FCReqBase::NONE);
			// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
										FCReqBase::RETURN, IDYES,
										FCReqBase::NONE);

				// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiNoNiPjMiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
				g_pDoc->PushBackDocRequest(ID_DREQ_DELETE_HIDOCUMENT);
				// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
				PushBackSyncHiviewToDocument();

			// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
			// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_END);
			// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
			g_pDoc->ProceedDocRequest();
		}
	}
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDocDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDocDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjHjKjHpAjFlGiPjBiCpAiNoNiPjMiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDocDelete (CCmdUI* pCmdUI)
{
//----- 06.05.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	pCmdUI->Enable(	FFCanEditProject() &&
//					GetWndHistoryTree()->IsDocumentSelected());
//----- 06.05.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	pCmdUI->Enable(	FFCanEditProject() &&
					GetWndHistoryTree()->IsDocumentSelected() &&
					!GetWndHistoryTree()->IsSelectedProjectUnknownFile());
//----- 06.05.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDocDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeMoveHiPosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiPoDiCmFiOhHjCoIiClDiCoKiClNjHjKjHpAiImKjChFiCmJiInKjDkOiClHiCoJiBhG_xHqqkZx_
 *			_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOmAiNnLiCmJiCmNiBeBiClBiCmMiDfCiDhNiDjDiDgIiCmNiDiBiDgKiDiFiBfLjCiGiCmJiCmNjBlGiNnNiClJiClIiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpA_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiCmFiDeOiDiKiDgCiDeOiClFiClNiPoKiNiHiCmJjBjHjAeNiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeMoveHiPosition ()
{
	if (GetWndHistoryTree()->GetLastClickedDocumentId() != -1)
	//----- _xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNjHjKjHpAiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 05.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_PUSH_CURRENT_TO_DSM);
////----- 05.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iClBiClBiCmFiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCkK_xHqqkZx_ _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiCiBfLiDgIiCmMiPoKiNiHiCmNiBeB_xHqqkZx_
		// GetLastClickedSessionIndex _xZkqqHx_iCmJ_xHqqkZx_ -1 _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
		// _xZkqqHx_jHjKjHpAiCmMiNmFjAfGiDfKiDgCiDfGiDiHiDjDiImKjChFiCkKjFfMiOkGiClDiCoKiCoJiCoGiCkEiBeB_xHqqkZx_fliSessionIndex _xZkqqHx_iCmJ_xHqqkZx_
		// _xZkqqHx_iPfMjFkKjBoFiCkLiCmIjCgMiCpAjAnNjCoIiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		flint fliSessionIndex = GetWndHistoryTree()->GetLastClickedSessionIndex();
		if (fliSessionIndex == -1)
			fliSessionIndex = FLINT_MAX;

		switch (GetWndHistoryTree()->GetLastClickedObject())
		{
		case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iOhHjCoIiCmMiDhGiDiNiDfHiDeGiDeOiDgHiBeFjHjKjHpAjFlGiPjBiBeFiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_MOVE_HISTORY_UNTIL_PJ_HIDOC_SESSION,
							FCReqBase::PROJECT_PATH, GetWndHistoryTree()->GetLastClickedProjectPath(),
							FCReqBase::HIDOCUMENT_ID, GetWndHistoryTree()->GetLastClickedDocumentId(),
							FCReqBase::SESSION_INDEX, fliSessionIndex,
							FCReqBase::IS_SELECT_OBJECT, FALSE,
							FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::NONE,
							FCReqBase::NONE);
			// _xZkqqHx_iDiJiDhIiDiLiCkKjCiGjAfDiCmJiCkNiCoJiCoGiCkEiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
			const FCHiLabelRec* pRec = (const FCHiLabelRec*)GetWndHistoryTree()->GetLastClickedObjectRec();
			g_pDoc->PushBackDocRequest(	ID_DREQ_SCROLL_TO_LABEL,
										FCReqBase::LABEL_ID, pRec->GetObjectId(),
										FCReqBase::NONE);
			break;
		  }
		case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iOhHjCoIiCmMiDhGiDiNiDfHiDeGiDeOiDgHiBeFjHjKjHpAjFlGiPjBiBeFiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_MOVE_HISTORY_UNTIL_PJ_HIDOC_SESSION,
							FCReqBase::PROJECT_PATH, GetWndHistoryTree()->GetLastClickedProjectPath(),
							FCReqBase::HIDOCUMENT_ID, GetWndHistoryTree()->GetLastClickedDocumentId(),
							FCReqBase::SESSION_INDEX, fliSessionIndex,
							FCReqBase::IS_SELECT_OBJECT, FALSE,
							FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::NONE,
							FCReqBase::NONE);
			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCkKjCiGjAfDiCmJiCkNiCoJiCoGiCkEiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
			const FCTimeLabelRec* pRec = (const FCTimeLabelRec*)GetWndHistoryTree()->GetLastClickedObjectRec();
			g_pDoc->PushBackDocRequest(	ID_DREQ_SCROLL_TO_TIME_LABEL,
										FCReqBase::TIME_LABEL_ID, pRec->GetTimeLabelId(),
										FCReqBase::NONE);
			break;
		  }
		default:
			// _xZkqqHx_iOhHjCoIiCmMiDhGiDiNiDfHiDeGiDeOiDgHiBeFjHjKjHpAjFlGiPjBiBeFiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_MOVE_HISTORY_UNTIL_PJ_HIDOC_SESSION,
							FCReqBase::PROJECT_PATH, GetWndHistoryTree()->GetLastClickedProjectPath(),
							FCReqBase::HIDOCUMENT_ID, GetWndHistoryTree()->GetLastClickedDocumentId(),
							FCReqBase::SESSION_INDEX, fliSessionIndex,
							FCReqBase::IS_SELECT_OBJECT, FALSE,
							FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
							FCReqBase::NONE);
		}

		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
		PushBackSyncHiviewToDocument();
//----- 05.11.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_PUSH_CURRENT_TO_DSM);
//----- 05.11.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
	}
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeMoveHiPosition.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeMoveHiPosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjHjKjHpAiNfMjBkCiDhCiDiFiBfLiPoDiCmFiOhHjCoIiClDiCoKiClNjHjKjHpAiImKjChFiCmJiInKjDkOiClHiCoJiBhG_xHqqkZx_
 *			_xZkqqHx_iCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOmAiNnLiCmJiCmNiBeBiClBiCmMiDfCiDhNiDjDiDgIiCmNiDiBiDgKiDiFiBfLjCiGiCmJiCmNjBlGiNnNiClJiClIiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpA_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiCmFiDeOiDiKiDgCiDeOiClFiClNiPoKiNiHiCmJjBjHjAeNiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeMoveHiPosition (CCmdUI* pCmdUI)
{
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	pCmdUI->Enable(FFCanBasicOperate() && GetWndHistoryTree()->IsSelectedProjectOpened());
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	pCmdUI->Enable(	FFCanBasicOperate() &&
					GetWndHistoryTree()->GetLastClickedDocumentId() != -1);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeMoveHiPosition.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeProjectProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhGiDiNiDhAiDgFiDeCiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeProjectProperty ()
{
	WString wstrSelectedProjectPath;
	if (GetWndHistoryTree()->IsProjectSelected(&wstrSelectedProjectPath))
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_PROJECT_PROPERTY,
									FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
									FCReqBase::NONE);
		// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
									FCReqBase::RETURN, IDOK,
									FCReqBase::NONE);

			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhGiDiNiDhAiDgFiDeCiCpAjFmPiNfIiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_REPLACE_PROJECT_PROPERTY);
			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
			PushBackSyncHiviewToDocument();

		// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
	}
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeProjectProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeProjectProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhGiDiNiDhAiDgFiDeCiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeProjectProperty (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	FFCanBasicOperate() && GetWndHistoryTree()->IsProjectSelected());
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeProjectProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDocumentProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjHjKjHpAjFlGiPjBiCmMiDhGiDiNiDhAiDgFiDeCiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDocumentProperty ()
{
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (GetWndHistoryTree()->IsSelectedProjectOpened() &&
//		GetWndHistoryTree()->GetSelectedDocumentId() == -1)
//	//----- _xZkqqHx_jBmOiPnLiCkKiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_PROJECT_PROPERTY,
//									FCReqBase::PROJECT_PATH, GetWndHistoryTree()->GetSelectedProjectPath(),
//									FCReqBase::NONE);
//		// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
//									FCReqBase::RETURN, IDOK,
//									FCReqBase::NONE);
//
//			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhGiDiNiDhAiDgFiDeCiCpAjFmPiNfIiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(ID_DREQ_REPLACE_PROJECT_PROPERTY);
//			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//			PushBackSyncHiviewToDocument();
//
//		// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
//		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_END);
//		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//		g_pDoc->ProceedDocRequest();
//	} else
//	//----- _xZkqqHx_jBmOiPnLiCkKjHjKjHpAjFlGiPjBiCmMiDhGiDiNiDhAiDgFiDeCiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDhGiDiNiDhAiDgFiDeCiCmMiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_HIDOCUMENT_PROPERTY,
//									FCReqBase::PROJECT_PATH, GetWndHistoryTree()->GetSelectedProjectPath(),
//									FCReqBase::HIDOCUMENT_ID, GetWndHistoryTree()->GetSelectedDocumentId(),
//									FCReqBase::NONE);
//		// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
//									FCReqBase::RETURN, IDOK,
//									FCReqBase::NONE);
//
//			// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDhGiDiNiDhAiDgFiDeCiCmMiDhGiDiNiDhAiDgFiDeCiCpAjFmPiNfIiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(ID_DREQ_REPLACE_HIDOCUMENT_PROPERTY);
//			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiOfBiJmBiCmMjFeLjHhGjAkLiCpAiDgAiDeGiDgCiDeOiClFiBeBjFeLjHhGiCmIiCoHiOfBiJmBiOoIjBlBiCkLiCpAjAgJiCnPiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(ID_DREQ_CHECK_JOIN_PROJECT_USER);
//
//			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(	ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT,
//										FCReqBase::IS_SCROLL_HTREE_VIEW, FALSE,
//										FCReqBase::IS_SELECT_HTREE_CURRENT, FALSE,
//										FCReqBase::NONE);
//
//		// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
//		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_END);
//		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//		g_pDoc->ProceedDocRequest();
//	}
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	if (GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath, &lSelectedDocumentId))
	//----- _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDhGiDiNiDhAiDgFiDeCiCmMiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_HIDOCUMENT_PROPERTY,
									FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
									FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
									FCReqBase::NONE);
		// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
									FCReqBase::RETURN, IDOK,
									FCReqBase::NONE);

			// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDhGiDiNiDhAiDgFiDeCiCmMiDhGiDiNiDhAiDgFiDeCiCpAjFmPiNfIiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_REPLACE_HIDOCUMENT_PROPERTY);
//----- 05.10.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiOfBiJmBiCmMjFeLjHhGjAkLiCpAiDgAiDeGiDgCiDeOiClFiBeBjFeLjHhGiCmIiCoHiOfBiJmBiOoIjBlBiCkLiCpAjAgJiCnPiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(ID_DREQ_CHECK_JOIN_PROJECT_USER);
//----- 05.10.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
			PushBackSyncHiviewToDocument(FALSE, FALSE);

		// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
	}
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDocumentProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDocumentProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjHjKjHpAjFlGiPjBiCmMiDhGiDiNiDhAiDgFiDeCiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDocumentProperty (CCmdUI* pCmdUI)
{
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	pCmdUI->Enable(FFCanBasicOperate() && GetWndHistoryTree()->IsSelectedProjectOpened());
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	pCmdUI->Enable(FFCanBasicOperate() && GetWndHistoryTree()->IsDocumentSelected());
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDocumentProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreePutHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAjFkKiKpCiDfOiDePiCpAjAnNjChFiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreePutHiForkTag ()
{
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
//	WString wstrClickedProjectPath;
//	long lClickedDocumentId;
//	flint fliClickedSessionIndex;
//	GetWndHistoryTree()->GetDefaultClickedPosition(wstrClickedProjectPath, lClickedDocumentId, fliClickedSessionIndex);
//
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//	PushBackSyncHiviewToDocument();
//	// [_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_PUT_HI_FORK_TAG,
//						FCReqBase::PROJECT_PATH, wstrClickedProjectPath.c_str(),
//						FCReqBase::HIDOCUMENT_ID, lClickedDocumentId,
//						FCReqBase::SESSION_INDEX, fliClickedSessionIndex,
//						FCReqBase::NONE);
//	// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
//						FCReqBase::RETURN, IDOK,
//						FCReqBase::NONE);
//
//		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjAnNjCoIiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_PUT_HI_FORK_TAG);
//		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//		PushBackSyncHiviewToDocument();
//
//	// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
//	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//	g_pDoc->PushBackDocRequest(ID_DREQ_END);
//	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//	g_pDoc->ProceedDocRequest();
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	flint fliSelectedSessionIndex;
	if (GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath, &lSelectedDocumentId, &fliSelectedSessionIndex))
	{
		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
		PushBackSyncHiviewToDocument();
		// [_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_PUT_HI_FORK_TAG,
									FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
									FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
									FCReqBase::SESSION_INDEX, fliSelectedSessionIndex,
									FCReqBase::NONE);
		// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
									FCReqBase::RETURN, IDOK,
									FCReqBase::NONE);

			// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjAnNjCoIiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_PUT_HI_FORK_TAG);
			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
			PushBackSyncHiviewToDocument();

		// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
	}
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreePutHiForkTag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreePutHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAjFkKiKpCiDfOiDePiCpAjAnNjChFiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreePutHiForkTag (CCmdUI* pCmdUI)
{
	BOOL bEnable = FALSE;
  do {
	if (!FFCanEditProject()) break;
	if (GetWndHistoryTree()->GetViewMode() <= FDHT_VMODE_PROJECT) break;
	// _xZkqqHx_iDeJiDhJiDiMiBfLiDfGiDiHiDjDjFhDiJmCjEfMiBeC_xHqqkZx_
	if (!FFCanBasicOperate()) break;
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	flint fliSelectedSessionIndex;
	if (!GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath, &lSelectedDocumentId, &fliSelectedSessionIndex)) break;
	if (!GetWndHistoryTree()->IsThereFork(wstrSelectedProjectPath, lSelectedDocumentId, fliSelectedSessionIndex)) break;
	if (GetWndHistoryTree()->IsThereHiForkTag(wstrSelectedProjectPath, lSelectedDocumentId, fliSelectedSessionIndex)) break;
	bEnable = TRUE;
  } while (FALSE);
	pCmdUI->Enable(bEnable);
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreePutHiForkTag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeHiTagProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAjFkKiKpCiDfOiDePiCpAjFmPiNfIiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeHiTagProperty ()
{
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	flint fliSelectedSessionIndex;
	if (GetWndHistoryTree()->IsHiTagSelected(&wstrSelectedProjectPath,
											 &lSelectedDocumentId,
											 &fliSelectedSessionIndex))
	//----- _xZkqqHx_jHjKjHpAiDfOiDePiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
		PushBackSyncHiviewToDocument();
		// [_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_HI_FORK_TAG_PROPERTY,
									FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
									FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
									FCReqBase::SESSION_INDEX, fliSelectedSessionIndex,
									FCReqBase::NONE);
		// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
									FCReqBase::RETURN, IDOK,
									FCReqBase::NONE);

			// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjFmPiNfIiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_REPLACE_HI_FORK_TAG);
			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
			PushBackSyncHiviewToDocument();

		// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
	}
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeHiTagProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeHiTagProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAjFkKiKpCiDfOiDePiCmMjFfMiOkGiBeFjFmPiNfIiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeHiTagProperty (CCmdUI* pCmdUI)
{
	BOOL bEnable = FALSE;
  do {
	if (GetWndHistoryTree()->GetViewMode() <= FDHT_VMODE_PROJECT) break;
	// _xZkqqHx_iDeJiDhJiDiMiBfLiDfGiDiHiDjDjFhDiJmCjEfMiBeC_xHqqkZx_
	if (!FFCanBasicOperate()) break;
	if (!GetWndHistoryTree()->IsHiTagSelected()) break;
	bEnable = TRUE;
  } while (FALSE);
	pCmdUI->Enable(bEnable);
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeHiTagProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDeleteHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAjFkKiKpCiDfOiDePiCpAiNoNiPjMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDeleteHiForkTag ()
{
//----- 05.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WString wstrSelectedProjectPath;
//	long lSelectedDocumentId;
//	flint fliSelectedSessionIndex;
//	if (GetWndHistoryTree()->IsHiTagSelected(&wstrSelectedProjectPath,
//											 &lSelectedDocumentId,
//											 &fliSelectedSessionIndex))
//	//----- _xZkqqHx_jHjKjHpAiDfOiDePiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//		PushBackSyncHiviewToDocument();
//		// [_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiNoNiPjMiCmMiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_DELETE_HI_FORK_TAG,
//									FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
//									FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
//									FCReqBase::SESSION_INDEX, fliSelectedSessionIndex,
//									FCReqBase::NONE);
//		// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
//									FCReqBase::RETURN, IDYES,
//									FCReqBase::NONE);
//
//			// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAiNoNiPjMiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(ID_DREQ_DELETE_HI_FORK_TAG);
//			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//			PushBackSyncHiviewToDocument();
//
//		// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
//		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//		g_pDoc->PushBackDocRequest(ID_DREQ_END);
//		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//		g_pDoc->ProceedDocRequest();
//	}
//----- 05.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	flint fliSelectedSessionIndex;
	FCHiForkTagRec hiForkTagRec;
	if (GetWndHistoryTree()->IsHiTagSelected(&wstrSelectedProjectPath,
											 &lSelectedDocumentId,
											 &fliSelectedSessionIndex,
											 &hiForkTagRec))
	//----- _xZkqqHx_jHjKjHpAiDfOiDePiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// "_xZkqqHx_iClBiCmMiPiIjHjNiCmNiMlDiCmJjGnPiClHiClBiCmGiCmNiCmFiCkLiCnMiClJiCpBiBeCiOmAiNhDiClFiCnMiClHiCkJiBeI_xHqqkZx_"
		if (FFMessageBox(IDS_MSG_NOT_UNDO_PROCESS_IS_CONTINUE, 0, MB_YESNO) == IDYES)
		{
			// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAiNoNiPjMiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(	ID_DREQ_DELETE_HI_FORK_TAG,
										FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
										FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
										FCReqBase::SESSION_INDEX, fliSelectedSessionIndex,
										FCReqBase::HI_FORK_TAG_USER_ID, hiForkTagRec.GetUserId(),
										FCReqBase::HI_FORK_TAG_CREATE_TIME, hiForkTagRec.GetCreateTime(),
										FCReqBase::HI_FORK_TAG_TITLE, hiForkTagRec.GetTitleString().c_str(),
										FCReqBase::HI_FORK_TAG_COMMENT, hiForkTagRec.GetCommentString().c_str(),
										FCReqBase::NONE);
			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
			PushBackSyncHiviewToDocument();
			// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_END);
			// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
			g_pDoc->ProceedDocRequest();
		}
	}
//----- 05.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDeleteHiForkTag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDeleteHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAjFkKiKpCiDfOiDePiCpAiNoNiPjMiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDeleteHiForkTag (CCmdUI* pCmdUI)
{
	BOOL bEnable = FALSE;
  do {
	if (!FFCanEditProject()) break;
	if (GetWndHistoryTree()->GetViewMode() <= FDHT_VMODE_PROJECT) break;
	// _xZkqqHx_iDeJiDhJiDiMiBfLiDfGiDiHiDjDjFhDiJmCjEfMiBeC_xHqqkZx_
	if (!FFCanBasicOperate()) break;
	if (!GetWndHistoryTree()->IsHiTagSelected()) break;
	bEnable = TRUE;
  } while (FALSE);
	pCmdUI->Enable(bEnable);
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDeleteHiForkTag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeForkHistory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFfMiOkGiImKjChFiCmJjHjKjHpAjFkKiKpCiCpAiNoMjAkMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeForkHistory ()
{
	SendMessage(WM_COMMAND, ID_FILE_FORK_HISTORY, (LPARAM)0);
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeForkHistory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeForkHistory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFfMiOkGiImKjChFiCmJjHjKjHpAjFkKiKpCiCpAiNoMjAkMiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeForkHistory (CCmdUI* pCmdUI)
{
	// _xZkqqHx_iImIiJlKiCmMiCfCiCmCiCmMiPpAiMiPiCmMiIoKiCmCiCmFiCoAiIoKjChGiClFiClNiPoKiNiHiCmNjGlDiMpIiBeC_xHqqkZx_
	// _xZkqqHx_iCfAiBeEiNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiPoKiPiKiCkKiMlLiNnNiCmMiImKjChFiCmGiIoKjChGiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	// _xZkqqHx_iCfBiBeEiDeJiDhJiDiMiBfLiDfGiDiHiDjDjFhDiJmCjEfMiBeC_xHqqkZx_
	// _xZkqqHx_iCfCiBeEjHjKjHpAjFlGiPjBiCkKjFmCiClGiCmEiCkCiCoJiBeBiIlNiCkCiCmNiMlLiNnNiCmMiPoKiPiKiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_

	BOOL bEnable = FALSE;
  do {
	if (!FFCanEditProject()) break;
	if (GetWndHistoryTree()->GetViewMode() <= FDHT_VMODE_PROJECT) break;
	// _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	flint fliSelectedSessionIndex;
	if (!GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath,
												 &lSelectedDocumentId,
												 &fliSelectedSessionIndex)) break;
	// _xZkqqHx_iCfAiBeEiNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiPoKiPiKiCkKiMlLiNnNiCmMiImKjChFiCmGiIoKjChGiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	if (wstrSelectedProjectPath != GetWndHistoryTree()->GetMarkedProjectPath() ||
		lSelectedDocumentId != GetWndHistoryTree()->GetMarkedDocumentId() ||
		fliSelectedSessionIndex != GetWndHistoryTree()->GetMarkedSessionIndex()) break;

	// _xZkqqHx_iCfBiBeEiDeJiDhJiDiMiBfLiDfGiDiHiDjDjFhDiJmCjEfMiBeC_xHqqkZx_
	if (!FFCanBasicOperate()) break;

	// _xZkqqHx_iCfCiBeEjHjKjHpAjFlGiPjBiCkKjFmCiClGiCmEiCkCiCoJiBeBiIlNiCkCiCmNiMlLiNnNiCmMiPoKiPiKiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	if (!GetDocument()->CanForkHistory()) break;

	bEnable = TRUE;
  } while (FALSE);
	pCmdUI->Enable(bEnable);
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeForkHistory.

//----- 06.04.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeChangeBranchIntoTrunk
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiOhNiCpAiPoDjHkMiCmMiKlCiCmJjFmPiNfIiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class DOC>
//void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeChangeBranchIntoTrunk ()
//{
//	WString wstrSelectedProjectPath;
//	long lSelectedDocumentId;
//	if (GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath, &lSelectedDocumentId))
//	//----- _xZkqqHx_jFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// "_xZkqqHx_iClBiCmMiPiIjHjNiCmNiMlDiCmJjGnPiClHiClBiCmGiCmNiCmFiCkLiCnMiClJiCpBiBeCiOmAiNhDiClFiCnMiClHiCkJiBeI_xHqqkZx_"
//		if (FFMessageBox(IDS_MSG_NOT_UNDO_PROCESS_IS_CONTINUE, 0, MB_YESNO) == IDYES)
//		{
//			// _xZkqqHx_iBhFjHjKjHpAiOhNiCpAiPoDjHkMiCmMiKlCiCmJjFmPiNfIiBhG_xHqqkZx_
//			g_pDoc->PushBackDocRequest(	ID_DREQ_CHANGE_BRANCH_INTO_TRUNK,
//										FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
//										FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
//										FCReqBase::NONE);
//			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//			PushBackSyncHiviewToDocument();
//			// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(ID_DREQ_END);
//			// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//			g_pDoc->ProceedDocRequest();
//		}
//	}
//} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeChangeBranchIntoTrunk.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeChangeBranchIntoTrunk
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiOhNiCpAiPoDjHkMiCmMiKlCiCmJjFmPiNfIiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class DOC>
//void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeChangeBranchIntoTrunk (CCmdUI* pCmdUI)
//{
//	BOOL bEnable = FALSE;
//  do {
//	if (!FFCanEditProject()) break;
//	if (GetWndHistoryTree()->GetViewMode() <= FDHT_VMODE_PROJECT) break;
//	// _xZkqqHx_iCfBiBeEiDeJiDhJiDiMiBfLiDfGiDiHiDjDjFhDiJmCjEfMiBeC_xHqqkZx_
//	if (!FFCanBasicOperate()) break;
//
////----- 05.09.27 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	WString wstrSelectedProjectPath;
//	long lSelectedDocumentId;
//	// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIjBeJjBpAiCmFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (!GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath, &lSelectedDocumentId))
//		break;
////----- 05.09.27 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	if (!GetDocument()->CanChangeBranchIntoTrunk(wstrSelectedProjectPath,
//												lSelectedDocumentId)) break;
//	bEnable = TRUE;
//  } while (FALSE);
//	pCmdUI->Enable(bEnable);
//} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeChangeBranchIntoTrunk.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeChangeTrunkIntoBranch
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiClBiClBiCoGiCoIiJlKiCmMjHjKjHpAiCpAiJlKjHkMiCmMiOhNiCmJjFmPiNfIiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class DOC>
//void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeChangeTrunkIntoBranch ()
//{
//	// _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
//	WString wstrSelectedProjectPath;
//	long lSelectedDocumentId;
//	flint fliSelectedSessionIndex;
//	if (GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath,
//												&lSelectedDocumentId,
//												&fliSelectedSessionIndex) &&
//		fliSelectedSessionIndex != -1)
//	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCmGiImKjChFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// "_xZkqqHx_iClBiCmMiPiIjHjNiCmNiMlDiCmJjGnPiClHiClBiCmGiCmNiCmFiCkLiCnMiClJiCpBiBeCiOmAiNhDiClFiCnMiClHiCkJiBeI_xHqqkZx_"
//		if (FFMessageBox(IDS_MSG_NOT_UNDO_PROCESS_IS_CONTINUE, 0, MB_YESNO) == IDYES)
//		{
//			// _xZkqqHx_iBhFiClBiClBiCoGiCoIiJlKiCmMjHjKjHpAiCpAiJlKjHkMiCmMiOhNiCmJjFmPiNfIiBhG_xHqqkZx_
//			g_pDoc->PushBackDocRequest(	ID_DREQ_CHANGE_TRUNK_INTO_BRANCH,
//										FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
//										FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
//										FCReqBase::SESSION_INDEX, fliSelectedSessionIndex,
//										FCReqBase::NONE);
//			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//			PushBackSyncHiviewToDocument();
//			// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(ID_DREQ_END);
//			// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//			g_pDoc->ProceedDocRequest();
//		}
//	}
//} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeChangeTrunkIntoBranch.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeChangeTrunkIntoBranch
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiClBiClBiCoGiCoIiJlKiCmMjHjKjHpAiCpAiJlKjHkMiCmMiOhNiCmJjFmPiNfIiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class DOC>
//void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeChangeTrunkIntoBranch (CCmdUI* pCmdUI)
//{
//	// _xZkqqHx_iImIiJlKiCmMiCfCiCmCiCmMiPpAiMiPiCmMiIoKiCmCiCmFiCoAiIoKjChGiClFiClNiPoKiNiHiCmNjGlDiMpIiBeC_xHqqkZx_
//	// _xZkqqHx_iCfAiBeEiNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiPoKiPiKiCkKiMlLiNnNiCmMiImKjChFiCmGiIoKjChGiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//	// _xZkqqHx_iCfBiBeEiDeJiDhJiDiMiBfLiDfGiDiHiDjDjFhDiJmCjEfMiBeC_xHqqkZx_
//	// _xZkqqHx_iCfCiBeEjHjKjHpAjFlGiPjBiCkKjFmCiClGiCmEiCkCiCoJiBeBiIlNiCkCiCmNiMlLiNnNiCmMiPoKiPiKiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//
//	BOOL bEnable = FALSE;
//  do {
//	if (!FFCanEditProject()) break;
//	if (GetWndHistoryTree()->GetViewMode() <= FDHT_VMODE_PROJECT) break;
//
//	// _xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
//	WString wstrSelectedProjectPath;
//	long lSelectedDocumentId;
//	flint fliSelectedSessionIndex;
//	if (!GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath,
//												 &lSelectedDocumentId,
//												 &fliSelectedSessionIndex)) break;
//	// _xZkqqHx_iCfAiBeEiNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiPoKiPiKiCkKiMlLiNnNiCmMiImKjChFiCmGiIoKjChGiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//	if (wstrSelectedProjectPath != GetWndHistoryTree()->GetMarkedProjectPath() ||
//		lSelectedDocumentId != GetWndHistoryTree()->GetMarkedDocumentId() ||
//		fliSelectedSessionIndex != GetWndHistoryTree()->GetMarkedSessionIndex()) break;
//	// _xZkqqHx_iCfBiBeEiDeJiDhJiDiMiBfLiDfGiDiHiDjDjFhDiJmCjEfMiBeC_xHqqkZx_
//	if (!FFCanBasicOperate()) break;
//
//	// _xZkqqHx_iCfCiBeEjHjKjHpAjFlGiPjBiCkKjFmCiClGiCmEiCkCiCoJiBeBiIlNiCkCiCmNiMlLiNnNiCmMiPoKiPiKiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//	if (!GetDocument()->CanForkHistory()) break;
//
//	bEnable = TRUE;
//  } while (FALSE);
//	pCmdUI->Enable(bEnable);
//} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeChangeTrunkIntoBranch.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeChangeBranchIntoTop
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiOhNiCpAiDhGiDiNiDfHiDeGiDeOiDgHjClMiJlKiCmJjFmPiNfIiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class DOC>
//void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeChangeBranchIntoTop ()
//{
//	WString wstrSelectedProjectPath;
//	long lSelectedDocumentId;
//	if (GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath, &lSelectedDocumentId))
//	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// "_xZkqqHx_iClBiCmMiPiIjHjNiCmNiMlDiCmJjGnPiClHiClBiCmGiCmNiCmFiCkLiCnMiClJiCpBiBeCiOmAiNhDiClFiCnMiClHiCkJiBeI_xHqqkZx_"
//		if (FFMessageBox(IDS_MSG_NOT_UNDO_PROCESS_IS_CONTINUE, 0, MB_YESNO) == IDYES)
//		{
//			// _xZkqqHx_iBhFjHjKjHpAiOhNiCpAiDhGiDiNiDfHiDeGiDeOiDgHjClMiJlKiCmJjFmPiNfIiBhG_xHqqkZx_
//			g_pDoc->PushBackDocRequest(	ID_DREQ_CHANGE_BRANCH_INTO_TOP,
//										FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
//										FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
//										FCReqBase::NONE);
//			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//			PushBackSyncHiviewToDocument();
//			// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(ID_DREQ_END);
//			// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//			g_pDoc->ProceedDocRequest();
//		}
//	}
//} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeChangeBranchIntoTop.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeChangeBranchIntoTop
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiOhNiCpAiDhGiDiNiDfHiDeGiDeOiDgHjClMiJlKiCmJjFmPiNfIiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER, class DOC>
//void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeChangeBranchIntoTop (CCmdUI* pCmdUI)
//{
//	BOOL bEnable = FALSE;
//  do {
//	if (!FFCanEditProject()) break;
//	if (GetWndHistoryTree()->GetViewMode() <= FDHT_VMODE_PROJECT) break;
//	// _xZkqqHx_iCfBiBeEiDeJiDhJiDiMiBfLiDfGiDiHiDjDjFhDiJmCjEfMiBeC_xHqqkZx_
//	if (!FFCanBasicOperate()) break;
//
////----- 05.09.27 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	WString wstrSelectedProjectPath;
//	long lSelectedDocumentId;
//	// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIjBeJjBpAiCmFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (!GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath, &lSelectedDocumentId))
//		break;
////----- 05.09.27 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	if (!GetDocument()->CanChangeBranchIntoTrunk(wstrSelectedProjectPath,
//												lSelectedDocumentId)) break;
//	bEnable = TRUE;
//  } while (FALSE);
//	pCmdUI->Enable(bEnable);
//} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeChangeBranchIntoTop.
//----- 06.04.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeTimeLabelProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFiOjOiKnEiDiJiDhIiDiLiCmMiDhGiDiNiDhAiDgFiDeCiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCToolTimeLabel::OnObjectTimeLabelProperty _xZkqqHx_iCmNiBeBiDeMiDiDiDjDiDgPiDfIiPoDiCmF_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIjBeJjBpAiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiCpAjFmPiNfIiClHiCoJiCmMiCmJjBmOiClFiCmEiBeB_xHqqkZx_
 *			OnRbtnHtreeTimeLabelProperty _xZkqqHx_iCmNjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeTimeLabelProperty ()
{
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WString wstrSelectedProjectPath;
//	long lSelectedDocumentId;
//	flint fliSelectedSessionIndex;
//	FCTimeLabelRec timeLabelRec;
//	GetWndHistoryTree()->IsTimeLabelSelected();
//	if (GetWndHistoryTree()->IsTimeLabelSelected(&wstrSelectedProjectPath,
//												&lSelectedDocumentId,
//												&fliSelectedSessionIndex,
//												&timeLabelRec))
//	//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCmGiMlLiNnNiKeKiCkCiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCkK_xHqqkZx_
//		// _xZkqqHx_iInJiCmIiCoJiPoKiNiHiCmNiPiIjHjNiCpAjCiGjCgGiBeCiCnMiClIiCkAiCoIiCkGiCmIiCkCiCmNiClIiBeC_xHqqkZx_
//		if (wcscmp(g_pProject->GetFilePath(), wstrSelectedProjectPath) != 0)
//			return;
//		//----- _xZkqqHx_jDpMjHmNjHhAiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_ -----
//		CFCDlgTimeLabel dlg(FALSE);
//		// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//		dlg.Initialize(	*g_pProject,
//						lSelectedDocumentId,
//						fliSelectedSessionIndex,
//						timeLabelRec.GetContentsText(),
//						timeLabelRec.GetCreateTime(),
//						timeLabelRec.GetUserId());
//		// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
//		if (dlg.DoModal() == IDOK)
//		{
//			longVector vTimeLabelId;
//			WStringVector vLabelTextOld;
//			WStringVector vLabelText;
//			vTimeLabelId.push_back(timeLabelRec.GetTimeLabelId());
//			vLabelTextOld.push_back(timeLabelRec.GetContentsText());
//			vLabelText.push_back(TStrToWStr(dlg.m_strLabel));
//
//			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//			PushBackSyncHiviewToDocument();
//			// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLjFmPiNfI_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(	ID_DREQ_CHANGE_TIME_LABEL,
//										FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
//										FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
//										FCReqBase::TIME_LABEL_ID_VECTOR, &vTimeLabelId,
//										FCReqBase::TIME_LABEL_TEXT_VECTOR_OLD, &vLabelTextOld,
//										FCReqBase::TIME_LABEL_TEXT_VECTOR, &vLabelText,
//										FCReqBase::NONE);
//			// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(ID_DREQ_END);
//			// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//			g_pDoc->ProceedDocRequest();
//		}
//	}
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	flint fliSelectedSessionIndex;
	FCTimeLabelRec timeLabelRec;
	GetWndHistoryTree()->IsTimeLabelSelected();
	if (GetWndHistoryTree()->IsTimeLabelSelected(&wstrSelectedProjectPath,
												&lSelectedDocumentId,
												&fliSelectedSessionIndex,
												&timeLabelRec))
	//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCmGiMlLiNnNiKeKiCkCiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCkK_xHqqkZx_
		// _xZkqqHx_iInJiCmIiCoJiPoKiNiHiCmNiPiIjHjNiCpAjCiGjCgGiBeCiCnMiClIiCkAiCoIiCkGiCmIiCkCiCmNiClIiBeC_xHqqkZx_
		if (wcscmp(g_pProject->GetFilePath(), wstrSelectedProjectPath) != 0)
			return;

		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
		PushBackSyncHiviewToDocument();
		// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_DLG_TIME_LABEL_PROPERTY,
									FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
									FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
									FCReqBase::SESSION_INDEX, fliSelectedSessionIndex,
									FCReqBase::TIME_LABEL_ID, timeLabelRec.GetTimeLabelId(),
									FCReqBase::NONE);
		// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_IF,
									FCReqBase::RETURN, IDOK,
									FCReqBase::NONE);

			// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLjFmPiNfI_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_CHANGE_TIME_LABEL);
			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
			PushBackSyncHiviewToDocument();

		// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
	}
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeTimeLabelProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeTimeLabelProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFiOjOiKnEiDiJiDhIiDiLiCmMiDhGiDiNiDhAiDgFiDeCiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeTimeLabelProperty (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && GetWndHistoryTree()->IsTimeLabelSelected());
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeTimeLabelProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDeleteTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFiOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCToolTimeLabel::OnDelete _xZkqqHx_iCmNiBeBiDeMiDiDiDjDiDgPiDfIiPoDiCmFiDhNiDeFiDfIjBeJjBpAiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiClHiCoJiCmMiCmJjBmOiClFiCmEiBeB_xHqqkZx_OnRbtnHtreeDeleteTimeLabel _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDeleteTimeLabel ()
{
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	flint fliSelectedSessionIndex;
	FCTimeLabelRec timeLabelRec;
	GetWndHistoryTree()->IsTimeLabelSelected();
	if (GetWndHistoryTree()->IsTimeLabelSelected(&wstrSelectedProjectPath,
												&lSelectedDocumentId,
												&fliSelectedSessionIndex,
												&timeLabelRec))
	//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// "_xZkqqHx_iClBiCmMiPiIjHjNiCmNiMlDiCmJjGnPiClHiClBiCmGiCmNiCmFiCkLiCnMiClJiCpBiBeCiOmAiNhDiClFiCnMiClHiCkJiBeI_xHqqkZx_"
		if (FFMessageBox(IDS_MSG_NOT_UNDO_PROCESS_IS_CONTINUE, 0, MB_YESNO) == IDYES)
		{
			// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCmGiMlLiNnNiKeKiCkCiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCkK_xHqqkZx_
			// _xZkqqHx_iInJiCmIiCoJiPoKiNiHiCmNiPiIjHjNiCpAjCiGjCgGiBeCiCnMiClIiCkAiCoIiCkGiCmIiCkCiCmNiClIiBeC_xHqqkZx_
			if (wcscmp(g_pProject->GetFilePath(), wstrSelectedProjectPath) != 0)
				return;

			longVector vTimeLabelId;
			WStringVector vLabelText;
			vTimeLabelId.push_back(timeLabelRec.GetTimeLabelId());
			vLabelText.push_back(timeLabelRec.GetContentsText());

			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
			PushBackSyncHiviewToDocument();
			// [_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjM_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(	ID_DREQ_DELETE_TIME_LABELS,
										FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
										FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
										FCReqBase::SESSION_INDEX, fliSelectedSessionIndex,
										FCReqBase::TIME_LABEL_ID_VECTOR, &vTimeLabelId,
										FCReqBase::TIME_LABEL_TEXT_VECTOR, &vLabelText,
										FCReqBase::NONE);
			// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_END);
			// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
			g_pDoc->ProceedDocRequest();
		}
	}
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeDeleteTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDeleteTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFiOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDeleteTimeLabel (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanEditProject() && GetWndHistoryTree()->IsTimeLabelSelected());
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeDeleteTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeExecHistviewTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjBeJjBpAiClDiCoKiClNjHjKjHpAjFlGiPjBiCpA_xHqqkZx_History Viewer _xZkqqHx_iCmFiKeKiCkNiBhG_xHqqkZx_
 *			_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeExecHistviewTarget ()
{
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	flint fliSelectedSessionIndex;
	if (GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath,
												&lSelectedDocumentId,
												&fliSelectedSessionIndex))
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// [History Viewer_xZkqqHx_iCpAiLeOjDkOiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		if (fliSelectedSessionIndex != -1)
			g_pDoc->PushBackDocRequest(	ID_DREQ_EXEC_HISTVIEWER,
										FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
										FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
										FCReqBase::SESSION_INDEX, fliSelectedSessionIndex,
										FCReqBase::NONE);
		else
			g_pDoc->PushBackDocRequest(	ID_DREQ_EXEC_HISTVIEWER,
										FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
										FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
										FCReqBase::NONE);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
	}
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeExecHistviewTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeExecHistviewTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjBeJjBpAiClDiCoKiClNjHjKjHpAjFlGiPjBiCpA_xHqqkZx_History Viewer _xZkqqHx_iCmFiKeKiCkNiBhG_xHqqkZx_
 *			_xZkqqHx_iCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeExecHistviewTarget (CCmdUI* pCmdUI)
{
//----- 06.05.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	pCmdUI->Enable(FFCanBasicOperate() && GetWndHistoryTree()->IsDocumentSelected());
//----- 06.05.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	pCmdUI->Enable(	FFCanBasicOperate() &&
					GetWndHistoryTree()->IsDocumentSelected() &&
					!GetWndHistoryTree()->IsSelectedProjectUnknownFile());
//----- 06.05.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeExecHistviewTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeExecHistdrawTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjBeJjBpAiClDiCoKiClNjHjKjHpAjFlGiPjBiCpA_xHqqkZx_Dynamic Draw Professional _xZkqqHx_iCmFiKeKiCkNiBhG_xHqqkZx_
 *			_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeExecHistdrawTarget ()
{
	WString wstrSelectedProjectPath;
	long lSelectedDocumentId;
	if (GetWndHistoryTree()->IsDocumentSelected(&wstrSelectedProjectPath,
												&lSelectedDocumentId))
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDkPiClGjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCmMiDeFiDeCiDjDiDgIiDeFiCpAjCfEiClHiBeC_xHqqkZx_
		HWND hwndTarget = FFFindHidocumentWindow(	wstrSelectedProjectPath,
													lSelectedDocumentId,
													AfxGetMainWnd()->GetSafeHwnd(),
													GetSpecAppName(FD_APPMODE_HISTORICDRAW));
		if (hwndTarget != NULL)
		//----- _xZkqqHx_iKpJiCmJjDkPiClGjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_Historic Draw_xZkqqHx_iCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiDeBiDhGiDiKiCpAiDhEiDeIiDeBiDePiDiJiDjDiDgIiCmJiBeC_xHqqkZx_
			::SetForegroundWindow(hwndTarget);
		} else
		//----- _xZkqqHx_jDkPiClGjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_Historic Draw_xZkqqHx_iCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// [Historic Draw_xZkqqHx_iCpAiLeOjDkOiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(	ID_DREQ_EXEC_HISTDRAW,
										FCReqBase::PROJECT_PATH, wstrSelectedProjectPath.c_str(),
										FCReqBase::HIDOCUMENT_ID, lSelectedDocumentId,
										FCReqBase::NONE);
			// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(ID_DREQ_END);
			// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
			g_pDoc->ProceedDocRequest();
		}
	}
} // CFCHistFrameTmpl<SUPER, DOC>::OnRbtnHtreeExecHistdrawTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeExecHistdrawTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjBeJjBpAiClDiCoKiClNjHjKjHpAjFlGiPjBiCpA_xHqqkZx_Dynamic Draw Professional _xZkqqHx_iCmFiKeKiCkNiBhG_xHqqkZx_
 *			_xZkqqHx_iCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER, class DOC>
void CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeExecHistdrawTarget (CCmdUI* pCmdUI)
{
//----- 06.05.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	pCmdUI->Enable(FFCanBasicOperate() && GetWndHistoryTree()->IsDocumentSelected());
//----- 06.05.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		if (FFCanBasicOperate())
		{
			WString wstrProjectPath;
			long lDocumentId;
			if (GetWndHistoryTree()->IsDocumentSelected(&wstrProjectPath, &lDocumentId))
			{
				if (!GetWndHistoryTree()->IsSelectedProjectUnknownFile())
				{
					if (g_pDoc->GetIsDocumentOpened())
					{
						// _xZkqqHx_iMlLiNnNiKeKiCkCiCmEiCkCiCoJjFlGiPjBiCmGiOhHjCoIiCmMjFlGiPjBiCkKiIoKjChGiClHiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
						if (wstrProjectPath != g_pProject->GetFilePath() ||
							lDocumentId != g_pDoc->GetDocumentId())
						{
							pCmdUI->Enable(TRUE);
							break;
						}
					} else
					{
						pCmdUI->Enable(TRUE);
						break;
					}
				}
			}
		}
		pCmdUI->Enable(FALSE);
		break;
	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
		pCmdUI->Enable(	FFCanBasicOperate() &&
						GetWndHistoryTree()->IsDocumentSelected() &&
						!GetWndHistoryTree()->IsSelectedProjectUnknownFile());
		break;
	}
//----- 06.05.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistFrameTmpl<SUPER, DOC>::OnUpdateRbtnHtreeExecHistdrawTarget.

#endif//__HistFrameTmpl_h
