// HistViewDoc.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include <algorithm>			// For find template.
#include "DynamicDraw.h"
#include "UtilMisc.h"			// For COleDtToFdsec.
#include "UtilMath.h"			// For _i64towcs.
#include "UtilStr.h"			// For FormatResString.
#include "UtilErr.h"			// For FFMessageBox.
#include "UtilFile.h"			// For SplitFileName.
#include "UtilCoord.h"			// For lg2mm.
#include "UtilStdLib.h"			// For FFIsIntersect.
#include "HistViewFrame.h"		// For FD_HTREE_MOVE_OPERATION_EACH.
#include "DynamicDb.h"			// For g_pFileServer.
#include "DbLock.h"				// For FCLockVar.
#include "RegData.h"			// For REG_COMPAPP_NAME.
#include "RecentList.h"			// For FCRecentList.
#include "HiProject.h"			// For FCHiProject.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "HiFrameWnd.h"			// For FFGetHiMainWnd().
#include "DynamicDrawView.h"	// For g_pView.
#include "ToolManager.h"		// For FCToolManager.
#include "HiCommandTable.h"		// For m_pGate->XX.
#include "DlgTimeLabel.h"		// For CFCDlgTimeLabel.
#include "TimeLabel.h"			// For FCTimeLabel.
#include "PursuerText.h"		// For CFCPursuerText.
#include "ObjDynabase.h"		// For FCObjDynabase.
#include "HistoryFindInfo.h"	// For FCTimeIndexFile.
#include "HistoryFind.h"		// For FCHistoryFind.
#include "DlgInitUserRegistration.h"// For CFCDlgInitUserRegistration.
#include "DlgCreateTimeIndex.h"	// For CFCDlgCreateTimeIndex.
#include "HistViewDoc.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// DSM_xZkqqHx_jHjKjHpAiCmMiDfEiDeDiDfJiCmMiMmAjDhIiBeC_xHqqkZx_
#define FD_DSM_HISTORY_MAX	120
#define FD_DSM_HISTORY_MIN	100

/////////////////////////////////////////////////////////////////////////////
// FCDsmRec

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	!=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCDsmRec _xZkqqHx_iCkKjDjJiClFiCkCiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDsmRec::operator != (const FCDsmRec& dsmRec) const
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
	if (m_hstrProjectFilePath != dsmRec.m_hstrProjectFilePath)
		return TRUE;
	// _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	if (m_lDocumentId != dsmRec.m_lDocumentId)
		return TRUE;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	if (m_fliSessionIndex != dsmRec.m_fliSessionIndex)
		return TRUE;
	// _xZkqqHx_jBeJjBpAjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	if (m_stObjectId != dsmRec.m_stObjectId)
		return TRUE;
	// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAiBeC_xHqqkZx_
	if (m_vTextSelection != dsmRec.m_vTextSelection)
		return TRUE;
	// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	if (m_stid != dsmRec.m_stid)
		return TRUE;
	// _xZkqqHx_iDfJiBfLiDiAjCgMiBeC_xHqqkZx_
	if (m_lZoom256 != dsmRec.m_lZoom256)
		return TRUE;
	// _xZkqqHx_jCiGjAfDiNmAjFfHiCmMiLjHjHkDiCkKiBeBiDhDiDeOiDfKiDiLjCgMiCmF_xHqqkZx_51_xZkqqHx_iImIiPoDiCmIiCoHiInJiCmIiCoJiCmGjElLjCgGiBeC_xHqqkZx_
	const double dZoom = ((double)m_lZoom256 * g_->dDisplayPPM) / 256.0;
	if (50 < mm2lg((m_mmptCenter - dsmRec.m_mmptCenter).Len(), dZoom))
		return TRUE;
	return FALSE;
} // FCDsmRec::operator !=.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	==
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCDsmRec _xZkqqHx_iCkKjDjJiClFiCkCiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDsmRec::operator == (const FCDsmRec& dsmRec) const
{
	return !(operator !=)(dsmRec);
} // FCDsmRec::operator ==.

//----- 06.03.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///////////////////////////////////////////////////////////////////////////////
//// FCCanvasStatEx
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCCanvasStatEx::FCCanvasStatEx
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCCanvasStatEx::FCCanvasStatEx ()
//{
//	m_lgOffsetX = LONG_MAX;
//	m_lgOffsetY = LONG_MAX;
//} // FCCanvasStatEx::FCCanvasStatEx.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCCanvasStatEx::UpdateCanvas
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEjDjJiBeBiDeMiDiDiDjDiDgPiDfIjBkEiCmMiPoOjFpBiCpAiBeBiDiBiDjDiDgPjFmPjAjEiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCCanvasStatEx::UpdateCanvas ()
//{
//	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::UpdateCanvas();
//
//	if (m_lgOffsetX == LONG_MAX && g_ != NULL)
//	{
//		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiCmMiDeJiDhEiDfKiDgCiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
//		m_lgOffsetX = g_->lgOffsetX;
//		m_lgOffsetY = g_->lgOffsetY;
//	}
//	if (g_ != NULL)
//	{
//		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiCmMiDeJiDhEiDfKiDgCiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
//		g_->lgOffsetX = m_lgOffsetX;
//		g_->lgOffsetY = m_lgOffsetY;
//	}
//} // FCCanvasStatEx::UpdateCanvas.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCCanvasStatEx::UpdateData
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCpAiDeMiDiDiDjDiDgPiDfIjBkEiCmMiPoOjFpBiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCCanvasStatEx::UpdateData ()
//{
//	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::UpdateData();
//	if (g_ != NULL)
//	{
//		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiCmMiDeJiDhEiDfKiDgCiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
//		m_lgOffsetX = g_->lgOffsetX;
//		m_lgOffsetY = g_->lgOffsetY;
//	}
//} // FCCanvasStatEx::UpdateData.
//----- 06.03.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCHistViewDoc

IMPLEMENT_DYNCREATE(CFCHistViewDoc, CFCFoundDoc)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::CFCHistViewDoc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCHistViewDoc::CFCHistViewDoc ()
			:m_pWorkDir(NULL),			// _xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
			m_pFileTimeIndex(NULL),		// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
			m_bIsUseTimeIndex(FALSE)	// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
{
} // CFCHistViewDoc::CFCHistViewDoc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::~CFCHistViewDoc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCHistViewDoc::~CFCHistViewDoc ()
{
	// _xZkqqHx_iOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiKeKiCkCiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
	if (m_pFileTimeIndex != NULL)
		FFThrowMiscUnknown();
	// _xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
	if (m_pWorkDir != NULL)
		FFThrowMiscUnknown();
} // CFCHistViewDoc::~CFCHistViewDoc.

BEGIN_MESSAGE_MAP(CFCHistViewDoc, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCHistViewDoc)
	ON_COMMAND(ID_FILE_EXEC_HISTDRAW_TARGET, OnFileExecHistdrawTarget)
	ON_UPDATE_COMMAND_UI(ID_FILE_EXEC_HISTDRAW_TARGET, OnUpdateFileExecHistdrawTarget)
	ON_COMMAND(ID_HTREE_MOVE_AFTER, OnHtreeMoveAfter)
	ON_UPDATE_COMMAND_UI(ID_HTREE_MOVE_AFTER, OnUpdateHtreeMoveAfter)
	ON_COMMAND(ID_HTREE_MOVE_BEFORE, OnHtreeMoveBefore)
	ON_UPDATE_COMMAND_UI(ID_HTREE_MOVE_BEFORE, OnUpdateHtreeMoveBefore)
	ON_COMMAND(ID_HTREE_MOVE_HIGHER, OnHtreeMoveHigher)
	ON_UPDATE_COMMAND_UI(ID_HTREE_MOVE_HIGHER, OnUpdateHtreeMoveHigher)
	ON_COMMAND(ID_HTREE_MOVE_LOWER, OnHtreeMoveLower)
	ON_UPDATE_COMMAND_UI(ID_HTREE_MOVE_LOWER, OnUpdateHtreeMoveLower)
	ON_COMMAND(ID_FILE_DELETE_HISTORY, OnFileDeleteHistory)
	ON_UPDATE_COMMAND_UI(ID_FILE_DELETE_HISTORY, OnUpdateFileDeleteHistory)
	ON_COMMAND(ID_TEST_TEST_TEST2, OnTestTestTest2)
	ON_UPDATE_COMMAND_UI(ID_TEST_TEST_TEST2, OnUpdateTestTestTest2)
	ON_COMMAND(ID_VIEW_TIME_LABEL_SHOW_MODE, OnViewTimeLabelShowMode)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TIME_LABEL_SHOW_MODE, OnUpdateViewTimeLabelShowMode)
	ON_COMMAND(ID_HTREE_MOVE_OPERATION_BEFORE, OnHtreeMoveOperationBefore)
	ON_UPDATE_COMMAND_UI(ID_HTREE_MOVE_OPERATION_BEFORE, OnUpdateHtreeMoveOperationBefore)
	ON_COMMAND(ID_HTREE_MOVE_OPERATION_AFTER, OnHtreeMoveOperationAfter)
	ON_UPDATE_COMMAND_UI(ID_HTREE_MOVE_OPERATION_AFTER, OnUpdateHtreeMoveOperationAfter)
	ON_COMMAND(ID_OPTION_USER_REGISTRATION, OnOptionUserRegistration)
	ON_UPDATE_COMMAND_UI(ID_OPTION_USER_REGISTRATION, OnUpdateOptionUserRegistration)
	ON_COMMAND(ID_HTREE_MOVE_SELECTION_BEFORE, OnHtreeMoveSelectionBefore)
	ON_UPDATE_COMMAND_UI(ID_HTREE_MOVE_SELECTION_BEFORE, OnUpdateHtreeMoveSelectionBefore)
	ON_COMMAND(ID_HTREE_MOVE_SELECTION_AFTER, OnHtreeMoveSelectionAfter)
	ON_UPDATE_COMMAND_UI(ID_HTREE_MOVE_SELECTION_AFTER, OnUpdateHtreeMoveSelectionAfter)
	ON_COMMAND(ID_FILE_PROJECT_CLOSE, OnFileProjectClose)
	ON_UPDATE_COMMAND_UI(ID_FILE_PROJECT_CLOSE, OnUpdateFileProjectClose)
	ON_COMMAND(ID_HTREE_CREATE_TIME_INDEX, OnHtreeCreateTimeIndex)
	ON_UPDATE_COMMAND_UI(ID_HTREE_CREATE_TIME_INDEX, OnUpdateHtreeCreateTimeIndex)
	ON_COMMAND(ID_HTREE_USE_TIME_INDEX, OnHtreeUseTimeIndex)
	ON_UPDATE_COMMAND_UI(ID_HTREE_USE_TIME_INDEX, OnUpdateHtreeUseTimeIndex)
	//}}AFX_MSG_MAP
//	ON_COMMAND_RANGE(ID_FILE_RECENT1, ID_FILE_RECENTEND, OnFileRecent)
//----- 03.09.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ON_COMMAND(ID_FILE_SAVE_AS_MOLIPDRAW, OnFileSaveAsMolipdraw)
//	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS_MOLIPDRAW, OnUpdateFileSaveAsMolipdraw)
//----- 03.09.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.08.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ON_COMMAND(ID_OPTION_SYNC_OTHER_DOC, OnOptionSyncOtherDoc)
//	ON_UPDATE_COMMAND_UI(ID_OPTION_SYNC_OTHER_DOC, OnUpdateOptionSyncOtherDoc)
//----- 05.08.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ON_COMMAND(ID_VIEW_PASTE_POSITION, OnViewPastePosition)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_PASTE_POSITION, OnUpdateViewPastePosition)
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.02.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ON_COMMAND(ID_VIEW_COPY_POSITION, OnViewCopyPosition)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_COPY_POSITION, OnUpdateViewCopyPosition)
//----- 06.02.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ON_COMMAND(ID_VIEW_PREV_DSM, OnViewPrevDsm)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_PREV_DSM, OnUpdateViewPrevDsm)
//	ON_COMMAND(ID_VIEW_NEXT_DSM, OnViewNextDsm)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_NEXT_DSM, OnUpdateViewNextDsm)
//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnActivateDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeOiDgFiDeCiDhFiCmIiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkKjAnIiCoIjBnGiCoNiCoJiOjOiCmJiBeB_xHqqkZx_CFCMainFrame_xZkqqHx_iCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bActive	:_xZkqqHx_iClBiCmMiDfOiDfIiDeOiCkKiDeBiDeOiDgFiDeCiDhFiCmJiCmIiCoJiCmGiCkLiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjEpBiDeBiDeOiDgFiDeCiDhF_xHqqkZx_
 *					_xZkqqHx_iCmJiCmIiCoJiCmGiCkLiCmN_xHqqkZx_ FALSE _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnActivateDocument (BOOL bActive)
{
	if (bActive)
	//----- _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkKiDeBiDeOiDgFiDeCiDhFiCmJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (g_pProject->IsProjectOpened())
		//----- _xZkqqHx_iKpJiCmJiDhGiDiNiDfHiDeGiDeOiDgHiCpAiDeJiBfLiDhGiDjDiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// [_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiNfIjAfGiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
			PushBackDocRequest(ID_DREQ_UPDATE_PROJECT);
			if (GetIsDocumentOpened())
			{
				// [_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiNfIjAfGiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
				PushBackDocRequest(ID_DREQ_UPDATE_HIDOCUMENT);
			}
			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeCiDfIiDeOiDiNiBfLiDiLiCmNiClFiCmIiCkCiBeC_xHqqkZx_
			PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT,
							FCReqBase::IS_SCROLL_HTREE_VIEW, FALSE,
							FCReqBase::IS_SELECT_HTREE_CURRENT, FALSE,
							FCReqBase::NONE);
			// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
			PushBackDocRequest(ID_DREQ_END);
			// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeCjBkGiOjOiOmAiNhDiClFiCmIiCkCiCmMiCmNiBeBiDeHiDgGiDeCiDfOiCkJiCoH_xHqqkZx_
			// _xZkqqHx_iDhEiDeIiDeBiDePiDiJiDjDiDgIiCkKjAnIiCoIjBnGiCoNiCmBiClNiPoKiNiHiCmJiBeBiDeHiDgGiDeCiDfOiCmM_xHqqkZx_
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDhEiDiJiDgCiDfGiDiFiCoGiCoIiClBiClPiCoHiCmMiNfIjAfGiPpDiLlFiDgAiDeGiDgCiDeOiCkKjAoGiCmJ_xHqqkZx_
			// _xZkqqHx_iOmAiNhDiClDiCoKiCmEiClFiCnMiCkEiClNiCnPiBeC_xHqqkZx_
			ProceedDocRequest(FALSE);
		}
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnActivateDocument(bActive);
} // CFCHistViewDoc::OnActivateDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKiBeBiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnPursuerTextNeedInfo ()
{
	if (g_pReg->GetIsShowTimeLabel() &&
		g_pReg->GetIsPopupHint() && 
		g_pReg->GetIsPopupObjectHint())
	//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
		CPoint lgptMsc;
		(void)::GetCursorPos(&lgptMsc);
		// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiImKjChFiCpAiOmAiNmAjFfHiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
		g_pView->ScreenToClient(&lgptMsc);
		g_pView->DPtoLP(lgptMsc);
		const DBLPoint mmptMsc = lg2mm(lgptMsc);

		FTIdToTimeLabelMap::reverse_iterator rTl;
		for (rTl = m_mpIdToTimeLabel.rbegin(); rTl != m_mpIdToTimeLabel.rend(); rTl++)
		//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDeJiDhFiDfHiDeGiDeOiDgHiCpAiLhEiCmJiDiLiBfLiDhG_xHqqkZx_ ------
		{
			if ((*rTl).second->GetFrame().PtInRect(mmptMsc))
			//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLjCiGiCmJiDhNiDeFiDfIiDeKiBfLiDfMiDiLiCkKiNnNiCoJiPoKiNiH_xHqqkZx_ -----
			{
				FFGetApp()->GetPopHint()->SetTargetInfo((*rTl).second->GetHintText());
				return;
			}
		}
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnPursuerTextNeedInfo();
} // CFCHistViewDoc::OnPursuerTextNeedInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetAndClearErrFontInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeHiDiJiBfLiPoOjFpBiCpAiOoGiCoIiPgPiClFiCmEiBeBjDoAjFjEjFmPjAjEiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vFontInfo	:_xZkqqHx_iDeHiDiJiBfLiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::GetAndClearErrFontInfo (vector<FCErrFontInfo>& vFontInfo)
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::GetAndClearErrFontInfo(vFontInfo);
	vector<FCErrFontInfo>::iterator i;
	for (i = vFontInfo.begin(); i != vFontInfo.end();)
	{
		pair<BYTE, WString> v(i->m_byOldCharSet, i->m_wstrOldFaceName);
		// _xZkqqHx_iDiGiBfLiDfFiBfLiCmJjFpBiNjAiNmPiCnNiCmMiDeHiDiJiBfLiDhEiDeIiDjDiDgHiPoOjFpBiCmJjCmHiJmBiBeC_xHqqkZx_
		// _xZkqqHx_jCmHiJmBiCmFiCkLiCmIiCkCiBgJiCmCiCnMiCoIjFpBiNjAiNmPiCnNiCmMiBgKiPoKiNiHiBeB_xHqqkZx_vFontInfo_xZkqqHx_iCkJiCoHiNoNiPjMiClHiCoJiBeC_xHqqkZx_
		if (m_stReportedErrorFont.insert(v).second)
			i++;
		else
			i = vFontInfo.erase(i);
	}
} // CFCHistViewDoc::GetAndClearErrFontInfo.

/////////////////////////////////////////////////////////////////////////////
// CFCHistViewDoc _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetStdTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfHiPiAiBgJiPiJiKpKiOjOiBgKiDgDiBfLiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFfHiPiAiBgJiPiJiKpKiOjOiBgKiDgDiBfLiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FoundDoc;:DeleteContents_xZkqqHx_iCmFiOgHjHhAiClHiCoJiBeCjFfHiPiAiDgDiBfLiDiLiCpAjFmPiNfIiClHiCoJiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCpAiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD CFCHistViewDoc::GetStdTool () const
{
	// _xZkqqHx_jBeJjBpAiDgDiBfLiDiLiCpAjFnEiClHiBeC_xHqqkZx_
	return ID_TOOL_SELECT;
} // CFCHistViewDoc::GetStdTool.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::IsReadOnly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnNjAoKjHhAiCmGiClFiCmEiDeJiBfLiDhGiDjDiClFiCmEiCkCiCoJiCkJiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCnNjAoKjHhAiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCkEiCmFiCmIiCkCiCmIiCoH_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::IsReadOnly () const
{
	return TRUE;
} // CFCHistViewDoc::IsReadOnly.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::CanHtreeMoveBefore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiCpAiImIjBePiCmJiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::CanHtreeMoveBefore ()
{
	if (GetIsUseTimeIndex())
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiPoKiNiH_xHqqkZx_ ------
	{
		return (FFCanBasicOperate() &&
				GetIsDocumentOpened() &&
				m_pFileTimeIndex->GetFirstSessionTime() <= GetPrevSessionTime());
	} else
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_ ------
	{
		return (FFCanBasicOperate() &&
				GetIsDocumentOpened() &&
				GetNextSessionIndexAbout() != GetFirstSessionIndex());
	}
} // CFCHistViewDoc::CanHtreeMoveBefore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::CanHtreeMoveAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiCpAiImIiMoDiCmJiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::CanHtreeMoveAfter ()
{
	if (GetIsUseTimeIndex())
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiPoKiNiH_xHqqkZx_ ------
	{
		return (FFCanBasicOperate() &&
				GetIsDocumentOpened() &&
				GetPrevSessionTime() <= m_pFileTimeIndex->GetLastSessionTime());
	} else
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_ ------
	{
		return (FFCanBasicOperate() &&
				GetIsDocumentOpened() &&
				GetNextSessionIndexAbout() < GetEndSessionIndexAbout());
	}
} // CFCHistViewDoc::CanHtreeMoveAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::CanHtreeMoveHigher
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiCpAiPoDiImKiCmJiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::CanHtreeMoveHigher () const
{
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!FFCanBasicOperate())
//	{
//		return FALSE;
//	} else
//	{
//		BOOL bEnable = FALSE;
//		if (GetIsDocumentOpened())
//		{
////----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
////----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
////----- 06.01.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////			if ((g_pProject->GetDocumentRec(m_lDocId)).GetSuperDocId() != -1)
////				bEnable = TRUE;
////----- 06.01.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//			// _xZkqqHx_jGkCiDiNiDgCiDeOiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeCiDiNiDgCiDeOiClFiCmEiCkCiCmIiCkCiCmG_xHqqkZx_GetDocumentRec_xZkqqHx_iCkKiOmAiNhDiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
//			if (g_pProject->GetIsReadLocked() &&
//				(g_pProject->GetDocumentRec(m_lDocId)).GetSuperDocId() != -1)
//				bEnable = TRUE;
////----- 06.01.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		}
//		return bEnable;
//	}
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!FFCanBasicOperate())
		return FALSE;

	if (!GetIsDocumentOpened())
		return FALSE;

	// _xZkqqHx_jGkCiDiNiDgCiDeOiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeCiDiNiDgCiDeOiClFiCmEiCkCiCmIiCkCiCmG_xHqqkZx_GetDocumentRec_xZkqqHx_iCkKiOmAiNhDiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	if (!g_pProject->GetIsReadLocked())
		return FALSE;

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpA_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiClFiBeBiDgGiBfLiDfOiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDiNiDgCiDeOiNmPiCnNiCpAiKgNjEeGiClFiCmEiCkCiCoJiCmMiCmFiBeBiOlIjEhDiClHiCoJiClBiCmGiCmNjGlDiCkCiCmNiClIiBeC_xHqqkZx_
	FCDbReadLock readLockProject;
	g_pProject->TryLock(readLockProject);
	g_pProject->UpdateData(readLockProject);

	// GetDocumentId() _xZkqqHx_iCmM_xHqqkZx_HiDocumentRec_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	// HiDocumentRec_xZkqqHx_iCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	FCHiDocumentRec hiDocRec = g_pProject->GetDocumentRec(GetDocumentId());
	if (hiDocRec.GetIsInvalid())
		return FALSE;

	// _xZkqqHx_iPoDiImKjHjKjHpAiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (hiDocRec.GetSuperDocId() == -1)
		return FALSE;

	return TRUE;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistViewDoc::CanHtreeMoveHigher.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::CanHtreeMoveLower
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiCpAiJlKiImKiCmJiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmIiPoKiNiHiCmNiBeB_xHqqkZx_A0_xZkqqHx_iCkJiCoH_xHqqkZx_A3_xZkqqHx_iCpAiDfEiDeDiDeOiDiLiClHiCoJiBeC_xHqqkZx_
 *
 *         _xZkqqHx_iEkBiBkI_xHqqkZx_ A0 _xZkqqHx_iBkI_xHqqkZx_ A1 _xZkqqHx_iBkI_xHqqkZx_ A2 _xZkqqHx_iBkI_xHqqkZx_ A3 _xZkqqHx_iEjPiEkC_xHqqkZx_
 *         _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          A0_xZkqqHx_iEkKiEkK_xHqqkZx_A1_xZkqqHx_iEkKiEkK_xHqqkZx_A2_xZkqqHx_iEkKiEkK_xHqqkZx_A3
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iBeG_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::CanHtreeMoveLower ()
{
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!FFCanBasicOperate() ||
//		!GetIsDocumentOpened())
//	{
//		return FALSE;
//	}
//	// _xZkqqHx_jGkCiDiNiDgCiDeOiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeCiDiNiDgCiDeOiClFiCmEiCkCiCmIiCkCiCmG_xHqqkZx_GetDocumentRec_xZkqqHx_iCkKiOmAiNhDiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
//	if (!g_pProject->GetIsReadLocked())
//		return FALSE;
//	// _xZkqqHx_jGkCiDiNiDgCiDeOiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeCiDiNiDgCiDeOiClFiCmEiCkCiCmIiCkCiCmG_xHqqkZx_IsThereRegalFork_xZkqqHx_iCkKiOmAiNhDiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
//	if (!m_forkFile.GetIsReadLocked())
//		return FALSE;
//	// _xZkqqHx_jFkBjAjEiCmMjFkKiKpCiCkKiCkAiCoJiPoKiNiHiCmJiBeBiDiNiBfLiDgFiBfLiDfGiDiHiDjDiCpAiJmCjEfMiCmJiClHiCoJiClNiCnPiBeB_xHqqkZx_
//	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgHiDgCiDhGiCmJiCkAiCoJiPoKiNiHiCmNiChDiChBiChEiCgEiBeC_xHqqkZx_
//	if ((g_pProject->GetDocumentRec(GetDocumentId())).GetSuperDocId() != -1 &&
//		GetNextSessionIndexAbout() == GetFirstSessionIndex())
//		return TRUE;
//	if (m_forkFile.IsThereRegalFork(GetNextSessionIndexAbout()))
//		return TRUE;
//	return FALSE;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!FFCanBasicOperate() || !GetIsDocumentOpened())
		return FALSE;

	// _xZkqqHx_jGkCiDiNiDgCiDeOiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeCiDiNiDgCiDeOiClFiCmEiCkCiCmIiCkCiCmG_xHqqkZx_IsThereRegalFork_xZkqqHx_iCkKiOmAiNhDiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	if (!m_forkFile.GetIsReadLocked())
		return FALSE;

	// _xZkqqHx_iDhEiDeIiBfLiDeOiDgFiBfLiDhFiDiLiCpA_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiClFiBeBiDgGiBfLiDfOiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDiNiDgCiDeOiNmPiCnNiCpAiKgNjEeGiClFiCmEiCkCiCoJiCmMiCmFiBeBiOlIjEhDiClHiCoJiClBiCmGiCmNjGlDiCkCiCmNiClIiBeC_xHqqkZx_
	FCDbReadLock readLockFork;
	m_forkFile.TryLock(readLockFork);
	m_forkFile.UpdateData(readLockFork);

	// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	long lSuperDocId;
	m_forkFile.GetSuperInfo(NULL, &lSuperDocId);
	// _xZkqqHx_jFkBjAjEiCmMjFkKiKpCiCkKiCkAiCoJiPoKiNiHiCmJiBeBiDiNiBfLiDgFiBfLiDfGiDiHiDjDiCpAiJmCjEfMiCmJiClHiCoJiClNiCnPiBeB_xHqqkZx_
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgHiDgCiDhGiCmJiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
	if (lSuperDocId != -1 &&
		GetNextSessionIndexAbout() == GetFirstSessionIndex())
		return TRUE;

	// _xZkqqHx_jHjKjHpAjFkKiKpCiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
	if (m_forkFile.IsThereRegalFork(GetNextSessionIndexAbout()))
		return TRUE;

	return FALSE;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistViewDoc::CanHtreeMoveLower.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnDrawFrontView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CView::OnDraw_xZkqqHx_iCmMjBePiMgJjFgAiJoGiBeCiDeHiDgGiDeCiDfOjDjJiCmMiDgIiDeMiDiFiDiBiDjDiDgHjFmKiCmMjDmBjFmKiCmI_xHqqkZx_
 *			_xZkqqHx_jBePiMgJjFgAiJoGiCpAjCfDjDjGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnDrawFrontView (CDC* pDC)
{
	if (g_pReg->GetIsShowTimeLabel())
	//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		FTIdToTimeLabelMap::const_iterator iTl;
		for (iTl = m_mpIdToTimeLabel.begin(); iTl != m_mpIdToTimeLabel.end(); iTl++)
		//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDeJiDhFiDfHiDeGiDeOiDgHiCpAiDiLiBfLiDhG_xHqqkZx_ ------
		{
			DBLRectVector::const_iterator iR;
			for (iR = g_pView->DBLRgnVector().begin(); iR != g_pView->DBLRgnVector().end(); iR++)
			{
				if (!(*iR & (*iTl).second->GetOuterFrame()).IsRectNull())
				{
					(*iTl).second->OnDraw(pDC);
					break;
				}
			}
		}
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawFrontView(pDC);
} // CFCHistViewDoc::OnDrawFrontView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetSelectedTimeLabelId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiNmPiCnNiCmMiOjOiKnEiDiJiDhIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stId	:_xZkqqHx_jBeJjBpAiNmPiCnNiCmMiOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::GetSelectedTimeLabelId (longSet& stId) const
{
	stId = m_stSelectTimeLabel;
} // CFCHistViewDoc::GetSelectedTimeLabelId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetAllTimeLabelId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmIjBfDiCmEiCmMiOjOiKnEiDiJiDhIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stId	:_xZkqqHx_jBeJjBpAiJmCjEfMiCmIjBfDiCmEiCmMiOjOiKnEiDiJiDhIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::GetAllTimeLabelId (longSet& stId) const
{
	stId.clear();
	FTIdToTimeLabelMap::const_iterator iTl;
	for (iTl = m_mpIdToTimeLabel.begin(); iTl != m_mpIdToTimeLabel.end(); iTl++)
		stId.insert((*iTl).first);
} // CFCHistViewDoc::GetAllTimeLabelId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetTimeLabelCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmIjBfDiCmEiCmMiOjOiKnEiDiJiDhIiDiLiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmIjBfDiCmEiCmMiOjOiKnEiDiJiDhIiDiLiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCHistViewDoc::GetTimeLabelCount () const
{
	return m_mpIdToTimeLabel.size();
} // CFCHistViewDoc::GetTimeLabelCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::IsSelectedTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiCkKjBeJjBpAiNmPiCnNiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiNmPiCnNiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::IsSelectedTimeLabel (long lId) const
{
	return (m_stSelectTimeLabel.find(lId) != m_stSelectTimeLabel.end());
} // CFCHistViewDoc::IsSelectedTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SelectTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::SelectTimeLabel (long lId)
{
	m_stSelectTimeLabel.insert(lId);
} // CFCHistViewDoc::SelectTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::UnselectAllTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjBeJjBpAiClDiCoKiCmEiCkCiCoJiOjOiKnEiDiJiDhIiDiLiCpAjBeJjBpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::UnselectAllTimeLabel ()
{
	m_stSelectTimeLabel.clear();
} // CFCHistViewDoc::UnselectAllTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::UnselectTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiCpAjBeJjBpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::UnselectTimeLabel (long lId)
{
	m_stSelectTimeLabel.erase(lId);
} // CFCHistViewDoc::UnselectTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiPoOjFpBiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCTimeLabel* CFCHistViewDoc::GetTimeLabel (long lId) const
{
	FTIdToTimeLabelMap::const_iterator iTl = m_mpIdToTimeLabel.find(lId);
	if (iTl != m_mpIdToTimeLabel.end())
		return (*iTl).second;
	return NULL;
} // CFCHistViewDoc::GetTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetDsmRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjFlGiPjBiDfKiDgCiDfGiDiHiDjDiDiBiDiCiDiKiBfLiCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiDfKiDgCiDfGiDiHiDjDiDiBiDiCiDiKiBfLiCmMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCDsmRec* CFCHistViewDoc::GetDsmRec (long lIndex) const
{
	return m_vDsmHistory[lIndex].get();
} // CFCHistViewDoc::GetDsmRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetDsmSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiDfKiDgCiDfGiDiHiDjDiDiBiDiCiDiKiBfLiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiDfKiDgCiDfGiDiHiDjDiDiBiDiCiDiKiBfLiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCHistViewDoc::GetDsmSize () const
{
	return m_vDsmHistory.size();
} // CFCHistViewDoc::GetDsmSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::EraseDsm
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmM_xHqqkZx_DSM_xZkqqHx_iCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:DSM_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DSM_xZkqqHx_iCpAjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiNiDgCiDeOjDjJiCkKjFeLjHhGiCmIiClNiCnP_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpAiOgHiCkEiCkKiBeBiNoNiPjMiClHiCoJiPoKiNiHiCmNjEhKjHpBiCkJiCoHiNoNiPjMiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iClOiCkPiCmIiCmMiCmFiBeBjClMiCmJiKnGjAjEiCmFiOmAiNhDiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::EraseDsm (long lIndex)
{
	m_vDsmHistory.erase(m_vDsmHistory.begin() + lIndex);
	// DSM_xZkqqHx_iNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	FFGetMainWnd()->PostMessage(WM_USER_DSM_UPDATED, WPARAM(FALSE), LPARAM(lIndex));
} // CFCHistViewDoc::EraseDsm.

//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetCurrentDsmPosition
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiDfKiDgCiDfGiDiHiDjDiDiBiDiCiDiKiBfLiCmMiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiDfKiDgCiDfGiDiHiDjDiDiBiDiCiDiKiBfLiCmMiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long CFCHistViewDoc::GetCurrentDsmPosition () const
//{
//	return m_lCurrentDsmPosition;
//} // CFCHistViewDoc::GetCurrentDsmPosition.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SetCurrentDsmPosition
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiDfKiDgCiDfGiDiHiDjDiDiBiDiCiDiKiBfLiCmMiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_jFlGiPjBiDfKiDgCiDfGiDiHiDjDiDiBiDiCiDiKiBfLiCmMiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::SetCurrentDsmPosition (long lIndex)
//{
//	m_lCurrentDsmPosition = lIndex;
//} // CFCHistViewDoc::SetCurrentDsmPosition.
//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.02.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqSaveAndExit
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_SAVE_AND_EXIT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jFnLjBlGiClFiCmEiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCpAiPeJjHlJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqSaveAndExit (FCReqBase& ret, FCReqLock& reqLock)
//{
//	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFjMiLeBjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
//	ret.SetReturn(IDYES);
//	// _xZkqqHx_iDhCiDiFiBfLiDeBiCmFjFnLjBlGiCmMjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
//	// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCpAiPeJjHlJiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_APP_EXIT);
//	return FD_DRR_OK;
//} // CFCHistViewDoc::OnReqSaveAndExit.
//----- 06.02.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqOpenProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_OPEN_PROJECT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiKeKiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
 *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
 *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqOpenProject (FCReqBase& ret, FCReqLock& reqLock)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	FTDocReqResult result = BASE_CLASS::OnReqOpenProject(ret, reqLock);
	if (result != FD_DRR_OK) return result;
	// OnReqOpenProject_xZkqqHx_iCmMiMiLiJmKiCmJiKnGiCoNiCoHiClIiBeB_xHqqkZx_
	// _xZkqqHx_iDhCiDiFiBfLiDeBiCmFiIoKiOjOiDhEiDeAiDeDiDiLiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkNiClBiCmGiCmNiLjGiClDiCoKiCmIiCkCiCkKiBeB_xHqqkZx_
	// BASE_CLASS::OnReqOpenProject _xZkqqHx_iCmNiBeBiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpAjAmPiCpBiCmF_xHqqkZx_
	// RETRY_xZkqqHx_iCmMiPoKiNiHiCoAiCkAiCoJiCmMiCmFiBeB_xHqqkZx_result_xZkqqHx_iCkK_xHqqkZx_OK_xZkqqHx_iCmMiPoKiNiHiCmMiCnNiOjPiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
	if (g_pProject->IsProjectOpened() && g_pProject->GetIsUnknownFile())
	//----- _xZkqqHx_iIoKiOjOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiNiDgCiDeOiCpAjBfDiCmEiJpAiPjMiBeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiClNiCnPiBeC_xHqqkZx_
		reqLock.Unlock(FCReqLock::ALL);
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
		// IDS_ERR_MSG_CANNOT_OPEN_UNTITLED_PROJECT = _xZkqqHx_jGkCjFnLjBlGiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiDeJiBfLiDhGiDjDiClHiCoJiClBiCmGiCmNiPgPjHiIiCnMiClJiCpBiBeC_xHqqkZx_
		FFErrorBox(IDS_ERR_MSG_CANNOT_OPEN_UNTITLED_PROJECT);
		// [_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjFmCiClGiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjBhNjDpMiBeC_xHqqkZx_
		InsertDocRequest(0, ID_DREQ_CLOSE_PROJECT);
		// [_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpAiPeJjHlJiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjBhNjDpMiBeC_xHqqkZx_
		InsertDocRequest(1, ID_DREQ_CANCEL);
		// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiMhAjBlBiClHiCoJiBeC_xHqqkZx_
		return FD_DRR_RETRY;
	}
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqOpenProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqCloseProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_CLOSE_PROJECT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjFmCiClGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
 *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
 *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqCloseProject (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.05.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiGiBfLiDfFiBfLiCmJjFpBiNjAiNmPiCnNiCmMiDeHiDiJiBfLiDhEiDeIiDjDiDgHiPoOjFpBiBeC_xHqqkZx_
	m_stReportedErrorFont.clear();
//----- 06.05.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	SetIsUseTimeIndex(FALSE);
	if (m_pFileTimeIndex != NULL)
	//----- _xZkqqHx_iOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjFmCiClGiCmEiNoNiPjMiBeC_xHqqkZx_
		WString wstrTimeIndexPath = m_pFileTimeIndex->GetFilePath();
		m_pFileTimeIndex->Close();
		delete m_pFileTimeIndex;
		m_pFileTimeIndex = NULL;
		FFDeleteFile(wstrTimeIndexPath);
	}
	if (m_pWorkDir != NULL)
	//----- _xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKiCpAiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		delete m_pWorkDir;
		m_pWorkDir = NULL;
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::OnReqCloseProject(ret, reqLock);
} // CFCHistViewDoc::OnReqCloseProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqOpenHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_OPEN_HIDOCUMENT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
 *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
 *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqOpenHidocument (FCReqBase& ret, FCReqLock& reqLock)
{
	ASSERT(g_pProject->IsProjectOpened());
	// _xZkqqHx_iKnEiIoBiCmBiClNjFlGiPjBiCpAiKeKiClBiCkEiCmGiClFiClNiCmGiCkLiBeBiNkBiCmMjFlGiPjBiCkKjFmCiClGiCmEiClFiCnMiCkEiCmMiCpA_xHqqkZx_
	// _xZkqqHx_jGgIiCkOiClNiCnPiBeBiClBiClBiCmFjFlGiPjBiCkKjBlGiNnNiClHiCoJiCkJiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	if (g_pProject->GetDocumentRec(ret.GetHidocumentId()).GetIsInvalid())
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiNiDgCiDeOiCpAjBfDiCmEiJpAiPjMiBeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiClNiCnPiBeC_xHqqkZx_
		reqLock.Unlock(FCReqLock::ALL);
		// _xZkqqHx_iBhFiOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCkKiMkJiCmCiCkJiCoIiCnMiClJiCpBiBeCiBhG_xHqqkZx_
		FFErrorBox(IDS_ERR_MSG_DOC_IS_NOT_FOUND);
		if (FCRecentList::Find(	NULL,
								NULL,
								g_pProject->GetFilePath(),
								FFFormatString(L"%d", ret.GetHidocumentId()),
								NULL,
								NULL,
								NULL) != -1)
		//----- _xZkqqHx_iNmFiLnPiOgHiCmBiClNiDhEiDeAiDeDiDiLiDiKiDfIiDgHiCmJjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNmFiLnPiOgHiCmBiClNiDhEiDeAiDeDiDiLiCmMiDiKiDfIiDgHiCkJiCoHjDgPjIfOiCpAiNoNiPjMiClFiCnMiClHiCkJiBeI_xHqqkZx_
			if (FFMessageBox(IDS_MSG_IS_REMOVE_RECENT_FILE, 0, MB_YESNO) == IDYES)
			//----- YES_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jDkPiClGjHjKjHpAjFlGiPjBiCpAiKnMiCnOiClHiCnHiCmEiCpAiBeBiNmFiLnPiOgHiCmBiClNiDhEiDeAiDeDiDiLiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				FCRecentList::Del(	NULL,
//									NULL,
//									g_pProject->GetFilePath(),
//									FFFormatString(L"%d", ret.GetHidocumentId()),
//									NULL,
//									NULL);
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				for (;;)
				{
					short nRecentIndex = FCRecentList::Find(NULL,
															NULL,
															g_pProject->GetFilePath(),
															FFFormatString(L"%d", ret.GetHidocumentId()),
															NULL,
															NULL,
															NULL);
					if (nRecentIndex == -1) break;
					FCRecentList::Del(nRecentIndex);
				}
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			}
		}
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmNjFfMiOkGiNmPiCnNiCmIiCmMiCmFiBeBiDeHiDiJiBfLiCkKjFfMiOkGiClDiCoKiCmIiCkCiCoGiCkE_xHqqkZx_
		// _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_ID_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		FFResetDDError();
		// _xZkqqHx_iDeHiDiJiBfLiCpAjFnEiClHiBeCjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiNfIjAfGiClHiCoJjFeLjHhGiCkKiCkAiCoJiCmMiCmFiBeB_xHqqkZx_FD_DRR_CANCEL_xZkqqHx_iCpAjFnEiClFiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
		return FD_DRR_ERR;
	}
	if (IsClosableTemporaryDocument())
	//----- _xZkqqHx_iIoKiOjOjDeJiCmIjHjKjHpAjFlGiPjBiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_[_xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFmCiClGiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		if (GetIsDocumentOpened())
		{
			InsertDocRequest(0, ID_DREQ_CLOSE_HIDOCUMENT);
			return FD_DRR_RETRY;	// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiMhAjBlBiClHiCoJiBeC_xHqqkZx_
		}
	}

	// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkJiCoKiCmEiCkCiCoJiPoKiNiHiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (GetIsDocumentOpened())
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkJiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDkPiClGjHjKjHpAjFlGiPjBiCkKiKeKiCkJiCoKiCmEiCkCiCoJiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		// CFCMolipDrawApp::InitInstance_xZkqqHx_iKnGjAjEjCiGiCmM_xHqqkZx_cmdInfo.CheckSameDocumentApp_xZkqqHx_iKnGjAjE_xHqqkZx_
		// _xZkqqHx_iCmMiMiLiJmKiBeBjDkPiClGjHjKjHpAjFlGiPjBiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmNiBeB_xHqqkZx_OPEN_HIDOCUMENT_xZkqqHx_jHhGiLiBiCpA_xHqqkZx_
		// _xZkqqHx_jEkNiNhDiClFiCmEiCkNiCoJiCmMiCmFiBeBiClBiCoKiCpAjGlDiOiLiClHiCoJiClNiCnPiCmJiCoAiImIiJlKiCkKjFeLjHhGiBeC_xHqqkZx_
		if (GetDocumentId() == ret.GetHidocumentId())
			return FD_DRR_OK;

		// _xZkqqHx_jDkPiClGjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCmMiDeFiDeCiDjDiDgIiDeFiCpAjCfEiClHjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iMlLiNnNiBeBiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiDeMiDiFiBfLiCmMjAoGjDkKiCmJiCmN_xHqqkZx_[_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkN_xHqqkZx_]_xZkqqHx_iCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClLiCmMjBePiCmJ_xHqqkZx_[_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiKeKiCkN_xHqqkZx_]_xZkqqHx_iCpAjAnNjCoIiClFiCmEiBeBjFmKiCmI_xHqqkZx_EXE_xZkqqHx_iCmJiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpA_xHqqkZx_
		// _xZkqqHx_iIpIiCkLjDgOiClHiBeC_xHqqkZx_
		InsertDocRequest(0, ID_DREQ_OPEN_PROJECT,
							FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
							FCReqBase::NONE);
		// _xZkqqHx_jFmKiCmI_xHqqkZx_EXE_xZkqqHx_iCpAiLeOjDkOiClFiCmEiBeBiClLiClPiCoHiCmFiDhGiDiNiDfHiDeGiDeOiDgHiBeFjHjKjHpAjFlGiPjBiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_
		ExecDocRequest();
		return FD_DRR_CANCEL;
	}

	//----- _xZkqqHx_iImIiNhOiBeBjHjKjHpAjFlGiPjBiCkKiKeKiCkJiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----

	// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjEgKjBlJiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	if (g_pFileServer->IsRecoveryRequired(g_pProject->GetFilePathH()))
	//----- _xZkqqHx_iPeDjFjMiNlHjFkKiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iBhFiDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNjEgKjBlJiClFiCmEiCkCiCnMiClHiBeCiPeDjFjMiDgDiBfLiDiLiCmFiPeDjFjMiClFiCmEiCkNiClOiClDiCkCiBeCiBhG_xHqqkZx_
		FFSetDDError(IDS_ERR_MSG_REPAIR_DAMAGED_FILE, g_pProject->GetFilePath().c_str());
		return FD_DRR_ERR;
	}

	// _xZkqqHx_iNmEjFgAiJoGiClHiCoJiCkJiBeIiDgGiDhEiDeIiDiLiDgHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
	const BOOL bIsRedraw = ret.IsNullIsRedraw() ? TRUE : ret.GetIsRedraw();

	ASSERT(!GetIsDocumentOpened());
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiBeB_xHqqkZx_reqLock.Initialize_xZkqqHx_iCmNjHoBiKePiCpAjEkNjAlGiClHiCoJiCkKiBeB_xHqqkZx_
	// _xZkqqHx_iPoDiCmMiCnJiCkEiCmFjFlGiPjBiCkKjBlGiNnNiClHiCoJiClBiCmGiCpAiKgNjEeGiNmPiCnNiCmIiCmMiCmFjGoCjBoIiCmIiCkCiBeC_xHqqkZx_
	reqLock.Initialize(g_pProject->GetSubTableName(DWORD(ret.GetHidocumentId())));
	if (!reqLock.TryLock(FCReqLock::ALL_READ & ~FCReqLock::PROJECT_READ))
	//----- _xZkqqHx_iDiNiDgCiDeOiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (FFGetDDErrorCode() == IDS_ERR_MSG_FILE_LOCKED_BY_OTHERS ||
//			FFGetDDErrorCode() == IDS_ERR_MSG_FILE_UNLOCK_REQUESTED)
//			return FD_DRR_LATER;	// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiClFiCmOiCoHiCkNiOjOiKnEiCpAiLpDiCkPiCmEiMhAjBlBiClHiCoJiBeC_xHqqkZx_
//		else
//			return FD_DRR_ERR;		// _xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iDiNiDgCiDeOiOlIjEhDiOjOiCmMjDeLjAnIiCmIjGnPiCoIjCgMiCpAjFnEiClHiBeC_xHqqkZx_
		return GetLockFailReqResult();
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	try
	{
		// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_
		*m_pGate = g_pProject->GetSubGroup(ret.GetHidocumentId());
		m_pGate->UpdateData(reqLock.m_autoLockCommandRead);
		// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_
		m_historyIndex = g_pProject->GetSubGroup(ret.GetHidocumentId());
		m_historyIndex.UpdateData(reqLock.m_autoLockSummaryRead);
		// _xZkqqHx_jHjKjHpAiPeJjCfLiLeMjIfOiDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_
		m_cmdTerminateFile = g_pProject->GetSubGroup(ret.GetHidocumentId());
		m_cmdTerminateFile.UpdateData(reqLock.m_autoLockTerminateRead);
		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		m_spotFile = g_pProject->GetSubGroup(ret.GetHidocumentId());
		m_spotFile.UpdateData(reqLock.m_autoLockSpotRead);
		// _xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		m_forkFile = g_pProject->GetSubGroup(ret.GetHidocumentId());
		m_forkFile.UpdateData(reqLock.m_autoLockForkRead);

		//----- _xZkqqHx_iOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmJiNmFiCoAiLnPiCkCiImKjChFiCmMjHjKjHpAjFlGiPjBiCpAiKeKiCkN_xHqqkZx_ -----
		// _xZkqqHx_iHeAiOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiNmFiCoAiLnPiCkCiImKjChFiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiMjPiNpFiBeC_xHqqkZx_
		// _xZkqqHx_iHeBiMjPiNpFiClFiClNiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		// _xZkqqHx_iHeCjHjKjHpAiDhEiDeAiDeDiDiLiCpAiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiImKjChFiCnMiCmFiDfGiBfLiDeOiBeC_xHqqkZx_
		// _xZkqqHx_iHeDiOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCnMiCmF_xHqqkZx_ Redo/Undo _xZkqqHx_iCmFiInKjDkOiBeC_xHqqkZx_
		// _xZkqqHx_iHeEjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmJjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_

		// _xZkqqHx_iKeKiOgOiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOoGjDlOiBeCiDgGiDhEiDeIiDiLiDgHiCkKiPeJjCfLiCmJiCmIiCoJiCoGiCkEiBeBiNmFjBoFjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
// 06.04.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		flint fliGoalSessionIndex = -1;
		flint fliGoalSessionIndex = FLINT_MAX;
		if (!ret.IsNullSessionIndex())
			fliGoalSessionIndex = ret.GetSessionIndex();
		// _xZkqqHx_iImKjChFiCkKjBoFiCkLiClHiCkMiCoJiPoKiNiHiCmNiDhEiDeAiDeDiDiLjGjGiCmJiPeDjAlDiBeC_xHqqkZx_-1_xZkqqHx_iCoAiClBiCmMiOjOiPeDjAlDiBeC_xHqqkZx_
		if (GetEndSessionIndex() < fliGoalSessionIndex)
			fliGoalSessionIndex = GetEndSessionIndex();
		else
		if (fliGoalSessionIndex < GetFirstSessionIndex())
			fliGoalSessionIndex = GetFirstSessionIndex();
		//----- _xZkqqHx_iNmFiKpBiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiOfKiPgP_xHqqkZx_ -----
		// _xZkqqHx_iHeAiOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiNmFiCoAiLnPiCkCiImKjChFiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiMjPiNpFiBeC_xHqqkZx_
		flint fliDistToSpot = FLINT_MAX;
		FCSpotConstIterator iSpot = m_spotFile.FindNearestSpot(	fliDistToSpot,
																fliGoalSessionIndex);
		// _xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiPeJjHlJiBeC_xHqqkZx_
		if (iSpot.GetIsInvalid())
		{
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjEgKjBlJiClFiCmEiCkCiCnMiClHiBeC_xHqqkZx_
			FFSetDDError(	IDS_ERR_FILE_DESTROIED,
							WString(g_pProject->GetTableName().GetTopDirPath()));
			AfxDebugBreak();
			return FD_DRR_FATAL_ERR;
		}

		flint fliSpotSessionIndex;
		BYTE* pSpotStream;
		DWORD dwSpotStreamSize;
		if (m_cmdTerminateFile.IsThereEndSessionSpot() &&
			fli_abs(GetEndSessionIndex() - fliGoalSessionIndex) < fliDistToSpot)
		//----- _xZkqqHx_iPeJjCfLiDfIiDhMiDgCiDgHiCkKiLnPiCkCiPoKiNiH_xHqqkZx_ -----
		{
			fliSpotSessionIndex = GetEndSessionIndex();
			FC2Ref<BYTE*, DWORD>(pSpotStream, dwSpotStreamSize) = m_cmdTerminateFile.SeeEndSessionSpotStream();
		} else
		//----- _xZkqqHx_jCiGiKnEiDfIiDhMiDgCiDgHiCkKiLnPiCkCiPoKiNiH_xHqqkZx_ -----
		{
			fliSpotSessionIndex = iSpot.GetSessionIndex();
			FC2Ref<BYTE*, DWORD>(pSpotStream, dwSpotStreamSize) = iSpot.GetSpotStream();
		}

		// _xZkqqHx_iHeBiMjPiNpFiClFiClNiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		// _xZkqqHx_iLeMjIfOiClFiCmEiCkAiCoJiDeMiDiDiDjDiDgPiDfIiPoOjFpBiCpAiDiKiDhEiDeAiDiMiDjDiDfIiCmGiClFiCmEiOhHjCoIiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoOjFpBiCmFiDeMiDiDiDjDiDgPiDfIiPoOjFpBiCmNiPiJiKpKiJlLiClDiCoKiCoJiBeC_xHqqkZx_
		DeleteContents();

		// FFImportSpotFile _xZkqqHx_iCmMiNmEjFgAiJoGiIpIjAjEiCmJ_xHqqkZx_bIsRedraw_xZkqqHx_iCmNiOhHjCoIiClFiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iJlKiCmF_xHqqkZx_ MoveSessionTo _xZkqqHx_iCkKiCkAiCoJiCmMiCmFiBeBiNmEjFgAiJoGiCmN_xHqqkZx_ MoveSessionTo _xZkqqHx_iCmMiMoDiCmJ_xHqqkZx_
		// _xZkqqHx_iClHiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
		BOOL bImportSucceed;
		if (!ret.IsNullIsUseLastCanvasStat() && ret.GetIsUseLastCanvasStat())
			bImportSucceed = FFImportSpotFile(	this,
												&m_canvasStatLast,
												pSpotStream,
												dwSpotStreamSize,
												FALSE);
		else
			bImportSucceed = FFImportSpotFile(	this,
												NULL,
												pSpotStream,
												dwSpotStreamSize,
												FALSE);
		if (!bImportSucceed)
		//----- _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjDmHiCnNiPgPiClFiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfIiDhMiDgCiDgHiDgGiBfLiDfOiCpAiJpAjFpKiBeC_xHqqkZx_
			delete[] pSpotStream;
			pSpotStream = NULL;
			// _xZkqqHx_iKpJiCmJjFlGiPjBiDhEiDeAiDeDiDiLiCpAiDiNiDgCiDeOiNmPiCnNiCmIiCmMiCmFiBeB_xHqqkZx_
			// _xZkqqHx_jCmKiPoNiBeBiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjDmHiCnNiPgPiClFiCmJiOlIjEhDiClHiCoJiClBiCmGiCmNiCkAiCoIiCkGiCmIiCkCiBeC_xHqqkZx_
			AfxDebugBreak();
			return FD_DRR_FATAL_ERR;
		}
		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgGiBfLiDfOiCpAiJpAjFpKiBeC_xHqqkZx_
		delete[] pSpotStream;
		pSpotStream = NULL;
		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiImKjChFiCnMiCmFjHjKjHpAiDhEiDeAiDeDiDiLiCpAiDfGiBfLiDeOiBeC_xHqqkZx_
		m_pGate->SeekToSessionIndex(fliSpotSessionIndex);
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBjFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
		m_pGate->SetupSessionTimeAndIndex();
		// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiDfGiBfLiDeOiImKjChFiCkJiCoHiMlLiNnNiCmMiImKjChFiCnMiCmFiInKjDkOiBeC_xHqqkZx_
		m_historyIndex.SeekToSessionIndex(fliGoalSessionIndex);

		if (fliSpotSessionIndex != fliGoalSessionIndex)
		//----- _xZkqqHx_iDfIiDhMiDgCiDgHiImKjChFiCmGiKeKiOgOiImKjChFiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiBeBiDfGiBfLiDeOiImKjChFiCkJiCoHiKeKiOgOiImKjChFiCnMiCmFiInKjDkOiBeC_xHqqkZx_
			m_pGate->MoveSessionTo(DWORDSet(), fliGoalSessionIndex);
		}

		// _xZkqqHx_iKeKiCkCiCmEiCkCiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		m_lDocId = ret.GetHidocumentId();

		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
		UpdateTimeLabel(*g_pProject,
						m_forkFile,
						reqLock.m_autoLockProjectRead,
						reqLock.m_autoLockForkRead);

		// _xZkqqHx_iDiBiDgKiDiFiBfLiBhFiNmFiLnPiOgHiCmBiClNjHjKjHpAjFlGiPjBiBhGiCmMiKmHjHjNiDeJiDhFiDfHiDeGiDeOiDgHiCmJjAnNjCoIiBeC_xHqqkZx_
		if (!g_pProject->GetIsUnknownFile())
		{
			WString wstrHidocId;
			wstrHidocId.Format(L"%d", ret.GetHidocumentId());
			FCRecentList::Add(	g_pProject->GetHidocumentTitle(ret.GetHidocumentId(), TRUE),
								g_pProject->GetHidocumentTitle(ret.GetHidocumentId(), FALSE),
								g_pProject->GetFilePath(),
								wstrHidocId,
								g_pProject->GetTitle(),
								g_pProject->GetDocumentRec(ret.GetHidocumentId()).GetDocTitle(),
								g_pProject->GetDocumentRec(ret.GetHidocumentId()).GetVersion());
		}
		// _xZkqqHx_iDhEiDiMiBfLiDiAiDeFiDeCiDjDiDgIiDeFiCmMiDfOiDeDiDgHiDiLiCpAjFmPiNfIiBeC_xHqqkZx_
		InsertDocRequest(1, ID_DREQ_SET_TITLE);

//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iBhFiDhGiDiNiDfHiDeGiDeOiDgHiCmJiDiGiBfLiDfFiBfLjDgPjIfOiClDiCoKiCmEiCkCiCnMiClJiCpBiBhGiCmMiDfPiDeDiDeBiDiNiDePiCkK_xHqqkZx_
		// _xZkqqHx_jFfMiOkGiClDiCoKiClNiPoKiNiHiBeBiJlKiCkK_xHqqkZx_ PostRgnRedraw(TRUE) _xZkqqHx_iClOiCmGiNmEjFgAiJoGiCmJ_xHqqkZx_
		// _xZkqqHx_iOlIjEhDiClHiCoJiBeC_xHqqkZx_
		if (bIsRedraw)
			g_pView->SendRgnRedraw(TRUE);	// _xZkqqHx_jBfDiJoGjGmKiNmEjFgAiJoGiBeC_xHqqkZx_

		// AfterLoadDocument_xZkqqHx_iKnGjAjEiCmNjFeLjHhGiCmIiCkCiBeC_xHqqkZx_FFImportSpotFile_xZkqqHx_iCmMiJjMjCoKiCmFiOmAiNhDiNmPiCnNiBeC_xHqqkZx_
//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iDhCiDiFiBfLiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//		AfterLoadDocument(bIsRedraw);
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	} catch (CException* e)
	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		FFSetDDErrorCodeMessage(FFGetErrorCode(e), FFGetErrorMessage(e));
		e->Delete();
		return FD_DRR_FATAL_ERR;
	}

//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmMiDiGiBfLiDfFiBfLjGlMiBeBjDpKjFhEjFfMiOkGiCpAiNfIjAfGiBeC_xHqqkZx_
	WString wstrUserName;
	if (GetPrevSessionUser() == GUID_NULL)
		wstrUserName.LoadString(IDS_GUEST);
	else
		wstrUserName = g_pProject->UserIdToUserName(GetPrevSessionUser());
	FFGetHiMainWnd()->SetStatusBarUser(GetPrevSessionUser(), wstrUserName);
	FFGetHiMainWnd()->SetStatusBarDate(GetPrevSessionTime());
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqOpenHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqCloseHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_CLOSE_HIDOCUMENT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFmCiClGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
 *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
 *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqCloseHidocument (FCReqBase& ret, FCReqLock& reqLock)
{
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!GetIsDocumentOpened()) return FD_DRR_OK;

//----- 06.04.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjFmPjAjEiCmJiDePiDiNiBfLiDgPiDiLiCpAjElNiJgGiBeC_xHqqkZx_
	// DeleteContents _xZkqqHx_iCmFiMmEiCpBiCmFiCkCiClNiCkKiBeB_xHqqkZx_DeleteContents _xZkqqHx_iCmN_xHqqkZx_
	// OpenHidocument_xZkqqHx_iCmMiCmGiCkLiCoAiOmAiNhDiClDiCoKiCoJiClNiCnPiBeBjFlGiPjBiCkKjFmCiClGiCmE_xHqqkZx_
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmMiIoGiCkKjFmPiNfIiClDiCoKiClNiMoDiCmMiPoOjFpBiCkKiLeMjIfOiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	m_canvasStatLast.UpdateData();
//----- 06.04.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// OnReqCheckLock_xZkqqHx_iKnGjAjEiCmNiMmEiCnBiPgPiClFiCmEiCmNiCmIiCoHiCmIiCkCiBeCiDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiClNiPoKiNiHiBeB_xHqqkZx_
	// OnReqCheckLock_xZkqqHx_iCmF_xHqqkZx_UPDATE_HIDOCUMENT _xZkqqHx_iCkKjEkNiNhDiClDiCoKiBeB_xHqqkZx_UpdateHidocument_xZkqqHx_iKnGjAjEiCmFiCmNiBeB_xHqqkZx_
	// CLOSE_HIDOCUMENT + OPEN_HIDOCUMENT_xZkqqHx_iCkKjEkNiNhDiClDiCoKiBeFiBeFiBeFiBeFiBeAiClBiCmMiMeKiCoIjFnEiClFiCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFmCiClGiCoJiClOiCkPiCmIiCmMiCmFiBeB_xHqqkZx_OnReqCheckLock_xZkqqHx_iKnGjAjEiCmNjFhDjHhGiBeC_xHqqkZx_

	// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDiNiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	// _xZkqqHx_iDiNiDgCiDeOiCmMiDeBiDgHiDiAiCoAiJpAiPjMiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiBeB_xHqqkZx_
	// _xZkqqHx_iOjPiCmMiDeJiBfLiDhGiDjDiCpAjBlBiCkPiCmEiNhDiCmBiClNiPoKiNiHiCmJiBeBiDiNiDgCiDeOiCmJ_xHqqkZx_
	// _xZkqqHx_iNkBiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDeBiDgHiDiAiCkKiOgDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	reqLock.ClearHidocumentLock();
	// _xZkqqHx_jFlGiPjBiCpAjFmCiClGiCoJiBeC_xHqqkZx_
	OnNewDocument();

	// _xZkqqHx_iNmEjFgAiJoGiClHiCoJiCkJiBeIiDgGiDhEiDeIiDiLiDgHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
	const BOOL bIsRedraw = ret.IsNullIsRedraw() ? TRUE : ret.GetIsRedraw();
	// _xZkqqHx_iDhCiDiFiBfLiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	// _xZkqqHx_iImIiJlKiCmN_xHqqkZx_PostRgnRedraw_xZkqqHx_iCpAiOgHiCmBiCmEiCkCiClNiCkKiBeBjFlGiPjBiNoNiPjM_xHqqkZx_->_xZkqqHx_jFmCiClGiCoJiOjOiCmJiDeMiDiDiDjDiDgPiDfIiPoDiCmJ_xHqqkZx_
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCkKiCkAiCmBiClNiPoKiNiHiBeBiNmEjFgAiJoGiCkKiOlIjEhDiClFiCmEiCkCiClNiCmMiCmFiBeB_xHqqkZx_SendRgnRedraw_xZkqqHx_iCmJjFmPiNfIiBeC_xHqqkZx_
	if (bIsRedraw)
		g_pView->SendRgnRedraw(TRUE);
	// _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmMiDiGiBfLiDfFiBfLjGlMiBeBjDpKjFhEjFfMiOkGiCpAiNfIjAfGiBeC_xHqqkZx_
	FFGetHiMainWnd()->SetStatusBarUser(GUID_NULL, FFLoadWString(IDS_GUEST));
	FFGetHiMainWnd()->SetStatusBarDate(FDSECTIME(-1));
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqCloseHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqUpdateCmdTerminate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_UPDATE_CMD_TERMINATE]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAiDfCiDhNiDjDiDgIjClHiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
 *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
 *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ID_DREQ_UPDATE_CMD_TERMINATE _xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeCiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_jClHiClDiCkKjFmPiNfIiClDiCoKiClNiPoKiNiHiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKiPgLiPkMiClDiCoKiClNiPoKiNiHiBeB_xHqqkZx_ID_DREQ_UPDATE_CMD_TERMINATE
 *			_xZkqqHx_iImIjBePiCmJ_xHqqkZx_ID_DREQ_UPDATE_HIDOCUMENT_xZkqqHx_iCkKiPiIjHjNiClDiCoKiCoJiBeC_xHqqkZx_
 *			ID_DREQ_UPDATE_HIDOCUMENT _xZkqqHx_iCmNiBeBjHjKjHpAjFlGiPjBiCpAjFmCiClGiCmEiKeKiCkNiClNiCnPiBeB_xHqqkZx_
 *			ID_DREQ_UPDATE_CMD_TERMINATE _xZkqqHx_iCmNiCoAiCkEiPiIjHjNiClHiCoJjFeLjHhGiCkKjGlDiCkNiCmIiCoJiBeC_xHqqkZx_
 *			ID_DREQ_UPDATE_CMD_TERMINATE _xZkqqHx_iCkKiPiIjHjNiClDiCoKiCoJiPoKiNiHiCmGiCmNjBkGiClPiBeB_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKiJiEjClHiClDiCoKiClNiPoKiNiHiCmMiCnNiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeB_xHqqkZx_m_cmdTerminateFile _xZkqqHx_iCpAiNmEjDmHiCnNiNjOiCnNiClHiCoJiCmMiClOiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmJiCoAjFmPiNfIiCkKiJmBiCkGiCoHiCoKiCmEiCkCiCoJiClNiCnPiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmJ_xHqqkZx_
 *			_xZkqqHx_iDiKiDgKiDiFiBfLiDeBiDiLiDeJiBfLiDhGiDjDiCpAiOmAiNhDiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqUpdateCmdTerminate (FCReqBase& ret, FCReqLock& reqLock)
{
	ASSERT(g_pProject->IsProjectOpened());
	ASSERT(GetIsDocumentOpened());

	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiDhEiDeAiDeDiDiLiCpAiDiNiDgCiDeOiBjFiDgAiDeGiDgCiDeO_xHqqkZx_ ------
	// OnReqCheckLock _xZkqqHx_iCmNiOgHiCkGiCmIiCkCiBeCiNfIjAfGiClDiCoKiCmEiCkCiCoJiCmGjElLjCgGiClDiCoKiClNiPoKiNiHiBeB_xHqqkZx_
	// ID_DREQ_UPDATE_HIDOCUMENT,UPDATE_TERMINATE _xZkqqHx_iCpA_xHqqkZx_Document_xZkqqHx_iDeMiDiFiBfLiCmJjAmPiCpBiCmFiClFiCnMiCkEiClNiCnPiBeC_xHqqkZx_
	if (!reqLock.m_autoLockCommandRead.TryLock())
	{
		return FD_DRR_LATER;	// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiMhAjBlBiClHiCoJiPoKiNiHiBeC_xHqqkZx_
	}
	if (!reqLock.m_autoLockSummaryRead.TryLock())
	{
		return FD_DRR_LATER;	// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiMhAjBlBiClHiCoJiPoKiNiHiBeC_xHqqkZx_
	}
	if (!reqLock.m_autoLockTerminateRead.TryLock())
	//----- _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return FD_DRR_LATER;	// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiMhAjBlBiClHiCoJiPoKiNiHiBeC_xHqqkZx_
	}

	if (m_cmdTerminateFile.IsRealTableRecordModified() ||
		m_cmdTerminateFile.IsVirtualTableRecordModified())
	//----- _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCmNiBeBjCmHiJmBiCmMiCnNiCkAiCmBiClNiCmNiClIiBeCjCmHiJmBiCmMiCnNiCpAjElNiJgGiBeC_xHqqkZx_
//		m_pGate->UpdateAppendant(reqLock.m_autoLockCommandRead);
//		m_historyIndex.UpdateAppendant(reqLock.m_autoLockSummaryRead);
//----- 06.02.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jHjKiPeJjCfLiLeMjIfOiDeOiDiJiDfIiCpAiNfIjAfGiBeC_xHqqkZx_
		m_cmdTerminateFile.UpdateData(reqLock.m_autoLockTerminateRead);

//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
//		m_fliEndSessionIndex = m_cmdTerminateFile.SeeEndSessionIndex();
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCmMiMlLiNnNiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		if (GetEndSessionIndex() < GetNextSessionIndex())
		//----- _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCkKiBeBjAfGiClFiCkCiPeJjCfLiCpAiJhKiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiCnMiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
			InsertDocRequest(1,
							ID_DREQ_MOVE_HISTORY_UNTIL_SESSION,
							FCReqBase::SESSION_INDEX,
							GetEndSessionIndex(),
							FCReqBase::NONE);
		}
	}
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqUpdateCmdTerminate.

//----- 06.04.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqDlgDeleteHidocument
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_DLG_DELETE_HIDOCUMENT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_jHjKjHpAjFlGiPjBiNoNiPjMiCmMiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
// *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
// *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqDlgDeleteHidocument (FCReqBase& ret, FCReqLock& reqLock)
//{
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpA_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiClFiBeBiDgGiBfLiDfOiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	FCDbReadLock autoLockProjectRead;
//	FCHiProject project;
//	FTDocReqResult result = OnReqLockAndUpdate(	ret.GetProjectPath(),
//												-1,
//												autoLockProjectRead,
//												project);
//	if (result != FD_DRR_OK) return result;
//
////----- 05.10.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	FD_CHECK_QUALIFICATION(&project);
////----- 05.10.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	const DWORD dwLockDeleteIdentifier = autoLockProjectRead.GetLockDeleteIdentifier();
//	const DWORD dwLockAppendIdentifier = autoLockProjectRead.GetLockAppendIdentifier();
//	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFfMiOkGjBePiCmJiDiNiDgCiDeOiJpAiPjMiBeC_xHqqkZx_
//	autoLockProjectRead.UnlockAll();
//
//	// _xZkqqHx_iNoNiPjMiClHiCoJjHjKjHpAjFlGiPjBiCmGiClLiCmMjFkKiKpCjFlGiPjBiCpAjBfDiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iClBiCoKiCoHjBfDiCmEiCmMjHjKjHpAjFlGiPjBiCkKiBeBiNoNiPjMjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_
//	longSet stDelDocId;
//	project.GetLowerHidocument(stDelDocId, ret.GetHidocumentId());
//
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCmMjDoAjHgFiCmJiIoKjChGiClDiClJiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiHiCmNiMhAjBlBiBeC_xHqqkZx_
//	const flint fliNextSessionIndex = GetIsDocumentOpened() ? GetNextSessionIndex() : -1;
//	if (!FFGetHiMainWnd()->SyncHiviewToDocument(	FDHT_VMODE_NONE,
//												g_pProject->GetFilePath(),
//												GetDocumentId(),
//												fliNextSessionIndex,
//												FALSE,
//												TRUE,
//												FALSE,
//												TRUE))
//		return FD_DRR_LATER;	// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiMhAjBlBiClHiCoJiPoKiNiHiBeC_xHqqkZx_
//	// _xZkqqHx_iNoNiPjMjBmOiPnLjHjKjHpAjFlGiPjBiCpAjAnNjCoIiClFiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjFfMiOkGiClDiClJiCoJiBeC_xHqqkZx_
//	FFGetHiMainWnd()->SetHiviewMarkUpHidocument(	project.GetFilePath(),
//												stDelDocId);
//
//	//----- _xZkqqHx_iNoNiPjMiKgNjEeGiDfPiDeDiDeBiDiNiDePiDhLiDgCiDeOiDfI_xHqqkZx_ -----
//	// _xZkqqHx_iDiNiDgCiDeOiCpAjBfDiCmEiJpAiPjMiBeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiClNiCnPiBeC_xHqqkZx_
//	reqLock.Unlock(FCReqLock::ALL);
//	// IDS_MSG_IS_DELETE_DOC "_xZkqqHx_jHjKjHpAjFlGiPjBiBhF_xHqqkZx_%s_xZkqqHx_iBhGiImIiJlKiCpAjBfDiCmEiNoNiPjMiClFiCnMiClHiCkJiBeI_xHqqkZx_"
//	long lReturn = FFMessageBox(FormatResString(IDS_MSG_IS_DELETE_DOC,
//								(const wchar_t*)project.GetHidocumentTitle(ret.GetHidocumentId(), TRUE)),
//								NULL, MB_YESNO);
//
//	// _xZkqqHx_jAnNjCoIiClDiCoKiClNiNoNiPjMjBmOiPnLjHjKjHpAjFlGiPjBiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
//	FFGetHiMainWnd()->SetHiviewMarkUpHidocument(NULL, longSet());
//
//	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFjMiLeBjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
//	ret.SetReturn(lReturn);
//
//	if (lReturn == IDYES)
//	//----- _xZkqqHx_iNoNiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		ret.SetProjectDeleteIdentifier(dwLockDeleteIdentifier);
//		ret.SetProjectAppendIdentifier(dwLockAppendIdentifier);
//	}
//	return FD_DRR_OK;
//} // CFCHistViewDoc::OnReqDlgDeleteHidocument.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqDeleteHidocument
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_DELETE_HIDOCUMENT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
// *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
// *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJoGjGmKiNmEjFgAiJoGjDjJiCmMiDeDiDhIiDjDiDgHiCpAjDkOiCkJiClFiCmCiCmDiCkPiCoJiClBiCmGiCpAiNgMjHlGiClHiCoJiCmGiBeB_xHqqkZx_
// *			_xZkqqHx_jFkBjAjEiCmMiOhNiCmMiNoNiPjMiCmNiBeBiMmCiBfIiCmMiOhNiCmMiNoNiPjMiCpAjFkBjAjEiCmM_xHqqkZx_Document_xZkqqHx_jHhGiLiBiCmJjFkKiJpA_xHqqkZx_
// *			_xZkqqHx_iClHiCoJiClBiCmGiCoAiJmCjEfMiClOiCkKiBeBiNoNiPjMjCiGiCmJjBlMiCmMiDeBiDhGiDiKiCkJiCoHjDkPjHgMiCmMiNoNiPjMjBiAiNoMiCpA_xHqqkZx_
// *			_xZkqqHx_iClDiCoKiCoJiJmCjEfMjAkLiCoAiCkAiCoJiClNiCnPiBeBiDhGiDiNiDfHiDeGiDeOiDgHjDjJiCpAiDiNiDgCiDeOiClFiClNiCnMiCnM_xHqqkZx_
// *			_xZkqqHx_iIoKiLeDiCmJiPiIjHjNiClFiCmEiClFiCnMiCkEjFpLiCkKiImAjBfDiCmFiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqDeleteHidocument (FCReqBase& ret, FCReqLock& reqLock)
//{
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_g_pFileServer->FlushAll _xZkqqHx_iCpAiOjNiCmCiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPiIjHjN_xHqqkZx_
//	// _xZkqqHx_iCmMjDkKjBfDiCmEiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiPoKiNiHiCmNiBeBjHjKjHpAjFlGiPjBiCmMiDhEiDiJiDgCiDfGiDiFiCpAiOmAiNhDiBeC_xHqqkZx_
//	if (OnReqCheckFlush()) return FD_DRR_RETRY;
//
//	//	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpA_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiClFiBeBiDgGiBfLiDfOiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	FCDbReadLock readLockProject;
//	FCHiProject project;
//	FTDocReqResult result = OnReqLockAndUpdate(	ret.GetProjectPath(),
//												-1,
//												readLockProject,
//												project);
//	if (result != FD_DRR_OK) return result;
//
//	if (readLockProject.GetLockDeleteIdentifier() != ret.GetProjectDeleteIdentifier() ||
//		readLockProject.GetLockAppendIdentifier() != ret.GetProjectAppendIdentifier())
//	//----- _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFfMiOkGjCiGiCmJiBeBjBlMiCmMiDeBiDhGiDiKiCmFiDhGiDiNiDfHiDeGiDeOiDgHiCkKiNfIjAfGiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDiNiDgCiDeOiCpAjBfDiCmEiJpAiPjMiBeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiClNiCnPiBeC_xHqqkZx_
//		reqLock.Unlock(FCReqLock::ALL);
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
//		// IDS_ERR_MSG_HIDOC_IS_MODIFIED "_xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_"
//		FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
//		return FD_DRR_CANCEL;		// _xZkqqHx_iPiIjHjNiCmNiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
//	}
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	FD_CHECK_QUALIFICATION(&project);
//
//	// _xZkqqHx_iNoNiPjMiClHiCoJjHjKjHpAjFlGiPjBiCmGiClLiCmMjFkKiKpCjFlGiPjBiCpAjBfDiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iClBiCoKiCoHjBfDiCmEiCmMjHjKjHpAjFlGiPjBiCkKiBeBiNoNiPjMjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_
//	longSet stDelDocId;
//	project.GetLowerHidocument(stDelDocId, ret.GetHidocumentId());
//
//	//	_xZkqqHx_iNkBiKeKiCkCiCmEiCkCiCoJjHjKjHpAjFlGiPjBiCkKiBeBiNoNiPjMiClFiCoGiCkEiCmGiClHiCoJjHjKjHpAjFlGiPjBiCmMiJlKiCmJiCkAiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
//	//	_xZkqqHx_jFlGiPjBiCpAjFmCiClGiCmEiCoCiCoIjClMiClFiBeC_xHqqkZx_
//
//	if (g_pProject->GetTableName() == project.GetTableName() && GetIsDocumentOpened())
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiIoKjChGiBeBjHjKjHpAjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (stDelDocId.find(GetDocumentId()) != stDelDocId.end())
//		//----- _xZkqqHx_iNoNiPjMiClFiCoGiCkEiCmGiClHiCoJjHjKjHpAjFlGiPjBiCmJiKnMiCnMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// [_xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFnLjBlGiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
//			InsertDocRequest(0, ID_DREQ_SAVE_HIDOCUMENT);
//			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//			InsertDocRequest(1, ID_DREQ_CLOSE_HIDOCUMENT);
//			return FD_DRR_RETRY;	// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiMhAjBlBiClHiCoJiBeC_xHqqkZx_
//		}
//	}
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpA_xHqqkZx_W_xZkqqHx_iDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbWriteLock writeLockProject;
//	if (!project.TryLock(writeLockProject))
//		return FD_DRR_LATER;
//
//	// _xZkqqHx_iNoNiPjMjHfMjCoIiCmMiKgFiDhEiDeAiDeDiDiLiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbLockBank lockBank;
//	mdef_const_iterator(longSet, iId);
//	m1_for (iId, stDelDocId)
//	{
//		// _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iBiB_xHqqkZx_*iId _xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjFlGiPjBiImIiJlKiCmMiDgFiBfLiDhFiDiLiCpAjBfDiCmEiDiNiDgCiDeOiBeC_xHqqkZx_
//		if (!project.GetSubGroup(*iId).TryLockLower(lockBank))
//			return FD_DRR_LATER;
//	}
//
//	// _xZkqqHx_jHjKjHpAjFlGiPjBiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
//	FCDbReadLock readLockForkSuper;
//	FCDbWriteLock writeLockForkSuper;
//	FCHiDocumentRec hiDocRec = project.GetDocumentRec(ret.GetHidocumentId());
//	if (hiDocRec.GetSuperDocId() != -1)
//	//----- _xZkqqHx_iPoDiImKiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ ----
//	{
//		// _xZkqqHx_iPoDiImKiDgIiDeMiDiFiDiBiDjDiDgHiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//		if (!FFTryLock(readLockForkSuper, writeLockForkSuper, project.GetSubTableName(hiDocRec.GetSuperDocId(), FDHI_FORK_TABLE_ID)))
//			return FD_DRR_LATER;
//	}
//
//	//----- _xZkqqHx_iBkKiClBiClBiCnMiCmFiCmFiBeBjFmPiNfIiBgJiNoNiPjMiBgKiClDiCoKiCoJiDgFiBfLiDhFiDiLiCmNjBfDiCmEiDiNiDgCiDeOiCmFiCkLiClN_xHqqkZx_ -----
//
//	if (hiDocRec.GetSuperDocId() != -1)
//	//----- _xZkqqHx_iPoDiImKiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ ----
//	{
//		// _xZkqqHx_iPoDiImKjFlGiPjBiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
//		FCHiForkTable forkFileSuper = project.GetSubGroup(hiDocRec.GetSuperDocId());
//		forkFileSuper.UpdateData(readLockForkSuper);
//		// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkJiCoHiBeBiNoNiPjMiClDiCoKiCoJjFlGiPjBiCmMiDeHiDjDiDgHiDiKiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
//		FCForkConstIterator iFork = forkFileSuper.FindForkByDocumentId(ret.GetHidocumentId());
//		flint fliSessionIndex = iFork.GetSessionIndex();
//		// _xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCpAiNoNiPjMiBeC_xHqqkZx_
//		forkFileSuper.Remove(iFork);
//		if (!forkFileSuper.IsThereRegalFork(fliSessionIndex))
//		//----- _xZkqqHx_iCoAiCkEjHjKjHpAjFkKiKpCiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jFkKiKpCiDfOiDePiCkKiCkAiCoKiCmOiBeBiNoNiPjMiClHiCoJiBeC_xHqqkZx_
//			FCHiForkTagConstIterator iTag = forkFileSuper.FindHiForkTag(fliSessionIndex);
//			if (!iTag.IsEnd())
//				forkFileSuper.Remove(iTag);
//		}
//	}
//
//	// _xZkqqHx_iNoNiPjMjBmOiPnLiCmMjFlGiPjBiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeCjDkPiOjOiCmJiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDeHiDjDiDgHiDiKiBfLiCoAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
//	m1_for (iId, stDelDocId)
//		project.UnregisterDocument(*iId);
//
//	// _xZkqqHx_jDkPiClGjHjKjHpAjFlGiPjBiCpAiKnMiCnOiClHiCnHiCmEiCpAiBeBiNmFiLnPiOgHiCmBiClNiDhEiDeAiDeDiDiLiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
//	m1_for (iId, stDelDocId)
//	{
//		for (;;)
//		{
//			short nRecentIndex = FCRecentList::Find(NULL,
//													NULL,
//													project.GetFilePath(),
//													FFFormatString(L"%d", *iId),
//													NULL,
//													NULL,
//													NULL);
//			if (nRecentIndex == -1) break;
//			FCRecentList::Del(nRecentIndex);
//		}
//	}
//
//	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
//	return FD_DRR_OK;
//} // CFCHistViewDoc::OnReqDeleteHidocument.
//----- 06.04.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.02.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqDeleteHidocumentSub
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_DELETE_HIDOCUMENT_SUB]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[DELETE_HIDOCUMENT_xZkqqHx_iCmMiDfEiDhF_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqDeleteHidocumentSub (FCReqBase& ret, FCReqLock& reqLock)
//{
//
//	//	_xZkqqHx_iCfAiBeEiJlKiImKiDgIiDeMiDiFiDiBiDjDiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiClLiCoKiCoHiCpAiNoNiPjMiClHiCoJiClNiCnPiCmM_xHqqkZx_
//	//		_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpAjClMjBePiCmJiDeDiDjDiDfEiBfLiDgHiClFiCmEiBeBiDiKiDgHiDiJiDeDiBeC_xHqqkZx_
//	//	_xZkqqHx_iCfBiBeEiDfEiDhFiDgIiDeMiDiFiDiBiDjDiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeBiOkJjFkKiOkJjAgHiCpAiNoNiPjMiClFiCmEiBeB_xHqqkZx_
//	//		_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmGiPoDiImKiDgIiDeMiDiFiDiBiDjDiDgHiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiPeDjAlDiBeC_xHqqkZx_
//	//	_xZkqqHx_iBkG_xHqqkZx_	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiKgFiOoNiDhEiDeAiDeDiDiLiCmNiBeBiNmFiPiJiCmJ_xHqqkZx_ID_DREQ_DELETE_HIDOCUMENT_xZkqqHx_iCmJiCmE_xHqqkZx_
//	//		W_xZkqqHx_iDiNiDgCiDeOiNmPiCnNiClOiCkKiBeBiDhGiDiNiDePiDiJiDiAiCpAiKmIjCfAiCmJiClHiCoJiClNiCnPiBeBiClBiClBiCmFiCoAiDiNiDgCiDeOiBeC_xHqqkZx_
//	//		W_xZkqqHx_iDiNiDgCiDeOiNmPiCnNiCmMiClNiCnPiBeBiDiNiDgCiDeOiOlIjEhDiCmNiCkAiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
//	//		_xZkqqHx_iNmEiLeBjDeJiCmIiJlKiImKiDgIiDeMiDiFiDiBiDjDiDgHiNoNiPjMiCmMjDhCjCiGiCmFiCmMiPeJjHlJiCmN_xHqqkZx_ _xZkqqHx_iCnMiClIiCkC_xHqqkZx_ _xZkqqHx_iCmMiCmFiBeB_xHqqkZx_
//	//		FATAL_ERR_xZkqqHx_iCmFiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
//	//	_xZkqqHx_iBkG_xHqqkZx_	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiCmNiNmFiMoDiCmJiCnMiCmGiCnPiCmEiNhDiCkEiCmMiCmFiBeBiClBiClBiCmFiCmNiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmGjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiBeBiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClFiCmEjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCDbReadLock autoLockProjectRead;
//	FCDbReadLock autoLockForkRead;
//	FCDbReadLock autoLockSpotRead;
//	FCHiProject project;
//	FCHiForkTable forkFile;
//	FCHiSpotTable spotFile;
//	FTDocReqResult result = OnReqLockAndUpdate(	ret.GetProjectPath(),
//												ret.GetHidocumentId(),
//												autoLockProjectRead,
//												project,
//												&autoLockForkRead,
//												&forkFile,
//												&autoLockSpotRead,
//												&spotFile);
//	// _xZkqqHx_iNmEiLeBjDeJiCmIiJlKiImKiDgIiDeMiDiFiDiBiDjDiDgHiNoNiPjMiCmMjDhCjCiGiCmFiCmMiPeJjHlJiCmN_xHqqkZx_ _xZkqqHx_iCnMiClIiCkC_xHqqkZx_ _xZkqqHx_iCmMiCmFiBeB_xHqqkZx_
//	// FATAL_ERR_xZkqqHx_iCmFiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
//	if (result != FD_DRR_OK)
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//
//	// _xZkqqHx_iJlKiImKiDgIiDeMiDiFiDiBiDjDiDgHiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
//	BOOL bIsThereSubDocument = FALSE;
//	FCForkConstIterator iFork;
//	for (iFork = forkFile.GetFirstFork(); !iFork.IsEnd(); iFork++)
//	{
//		// _xZkqqHx_iJlMiCmMjHjKjHpAjFkKiKpCiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (iFork.GetIsTemporary()) continue;
//		// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiNoNiPjMiClHiCoJ_xHqqkZx_]_xZkqqHx_iCpAjClMjBePiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
//		InsertDocRequest(0, ID_DREQ_DELETE_HIDOCUMENT_SUB,
//							FCReqBase::HIDOCUMENT_ID, iFork.GetDocumentId(),
//							FCReqBase::NONE);
//		// _xZkqqHx_iJlKiImKiDgIiDeMiDiFiDiBiDjDiDgHiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
//		bIsThereSubDocument = TRUE;
//	}
//	// _xZkqqHx_iJlKiImKiDgIiDeMiDiFiDiBiDjDiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiDiKiDgHiDiJiDeDiBeC_xHqqkZx_
//	if (bIsThereSubDocument) return FD_DRR_RETRY;
//
//	//----- _xZkqqHx_jFeLjHhGiCmIiDhEiDeAiDeDiDiLiCpAjBfDiCmE_xHqqkZx_W_xZkqqHx_iDiNiDgCiDeO_xHqqkZx_ -----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpA_xHqqkZx_Write_xZkqqHx_iDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbWriteLock autoLockProjectWrite(project.GetTableName());
//	if (!autoLockProjectWrite.TryLock())
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiImIiKePiCpA_xHqqkZx_Write_xZkqqHx_iDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbWriteLockVector vWriteLock;
//	vWriteLock.push_back(FCDbWriteLock(project.GetFilePathH(), ret.GetHidocumentId(), FDHI_COMMAND_TABLE_ID));
//	if (!vWriteLock.back().TryLock())
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//	vWriteLock.push_back(FCDbWriteLock(project.GetFilePathH(), ret.GetHidocumentId(), FDHI_SUMMARY_TABLE_ID));
//	if (!vWriteLock.back().TryLock())
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//	vWriteLock.push_back(FCDbWriteLock(project.GetFilePathH(), ret.GetHidocumentId(), FDHI_FORK_TABLE_ID));
//	if (!vWriteLock.back().TryLock())
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//	vWriteLock.push_back(FCDbWriteLock(project.GetFilePathH(), ret.GetHidocumentId(), FDHI_SPOT_TABLE_ID));
//	if (!vWriteLock.back().TryLock())
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//	vWriteLock.push_back(FCDbWriteLock(project.GetFilePathH(), ret.GetHidocumentId(), FDHI_TERMINATE_TABLE_ID));
//	if (!vWriteLock.back().TryLock())
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//
//	FCSpotIterator iSpot;
//	for (iSpot = spotFile.GetFirstSpot(); !iSpot.IsEnd(); iSpot++)
//	{
//		// _xZkqqHx_iNoNiPjMiClHiCoJiDfIiDhMiDgCiDgHiCmMiDhEiDeAiDeDiDiLiDeBiDgHiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
//		const long lAtom = g_pFileServer->QueryAtom(iSpot.GetFilePath(), FD_NO, FD_YES);
//		vWriteLock.push_back(FCDbWriteLock(lAtom));
//		if (!vWriteLock.back().TryLock())
//		{
//			AfxDebugBreak();
//			return FD_DRR_FATAL_ERR;
//		}
//	}
//
//	// _xZkqqHx_jHjKjHpAjFlGiPjBiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
//	FCHiDocumentRec hiDocRec = project.GetDocumentRec(ret.GetHidocumentId());
//	if (hiDocRec.GetSuperDocId() != -1)
//	//----- _xZkqqHx_iPoDiImKiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ ----
//	{
//		// _xZkqqHx_iPoDiImKiDgIiDeMiDiFiDiBiDjDiDgHiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpA_xHqqkZx_RW_xZkqqHx_iDiNiDgCiDeOiBeC_xHqqkZx_
//		FCDbReadLock autoLockForkSuperRead(project.GetFilePathH(), hiDocRec.GetSuperDocId(), FDHI_FORK_TABLE_ID);
//		if (!autoLockForkSuperRead.TryLock())
//		{
//			AfxDebugBreak();
//			return FD_DRR_FATAL_ERR;
//		}
//		FCDbWriteLock autoLockForkSuperWrite(project.GetFilePathH(), hiDocRec.GetSuperDocId(), FDHI_FORK_TABLE_ID);
//		if (!autoLockForkSuperWrite.TryLock())
//		{
//			AfxDebugBreak();
//			return FD_DRR_FATAL_ERR;
//		}
//		// _xZkqqHx_iPoDiImKiDgIiDeMiDiFiDiBiDjDiDgHiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
//		FCHiForkTable forkFileSuper;
//		forkFileSuper = project.GetSubGroup(hiDocRec.GetSuperDocId());
//
//		forkFileSuper.UpdateData(autoLockForkSuperRead);
//		// _xZkqqHx_iPoDiImKiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkJiCoHiBeBjFkKiKpCiCpAiNoNiPjMiBeC_xHqqkZx_
//// 06.01.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		flint fliSessionIndex = forkFileSuper.RemoveFork(ret.GetHidocumentId());
//		flint fliSessionIndex = forkFileSuper.Remove(forkFileSuper.FindForkByDocumentId(ret.GetHidocumentId()));
////----- 05.10.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iCoAiCkEjFkKiKpCiCkKiOgDiCmBiCmEiCkIiCoHiClIiBeBjHjKjHpAjFkKiKpCiDfOiDePiCmMiCnNiOgDiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
//		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAiNoNiPjMiBeC_xHqqkZx_
//		if (!forkFileSuper.IsThereRegalFork(fliSessionIndex) &&
//			forkFileSuper.IsThereHiForkTag(fliSessionIndex))
//			forkFileSuper.Remove(forkFileSuper.FindHiForkTag(fliSessionIndex));
////----- 05.10.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		// _xZkqqHx_iPoDiImKiDgIiDeMiDiFiDiBiDjDiDgHiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
////		forkFileSuper.UpdateFile(autoLockForkSuperWrite);
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	}
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkJiCoHjHjKjHpAjFlGiPjBiPoOjFpBiCpAjGjFiPmBiBeC_xHqqkZx_
//	project.UnregisterDocument(ret.GetHidocumentId());
//// 06.01.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	project.UpdateFile(autoLockProjectWrite);
//	for (long lC = 0; lC < vWriteLock.size(); lC++)
//	{
//		// _xZkqqHx_iKgFiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
//		g_pFileServer->DeleteFile(vWriteLock[lC].GetTableName(), NULL, NULL);
//	}
//	return FD_DRR_OK;
//} // CFCHistViewDoc::OnReqDeleteHidocumentSub.
//----- 06.02.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveHistoryBackwardUntilOperate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_HISTORY_BACKWARD_UNTIL_OPERATE]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAiCpAiDfCiDhNiDjDiDgIiDfCiBfLiDgIiCnMiCmFjGnPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
 *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
 *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveHistoryBackwardUntilOperate (FCReqBase& ret, FCReqLock& reqLock)
{
	// _xZkqqHx_iJlKjAhNiCmMiCoGiCkEiCmJiBeBiDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiChCiCmJiMlLiNnNiImKjChFiCkKiCkAiCoJiPoKiNiHiBeB_xHqqkZx_
	// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCpAiDfIiDeMiDgCiDhGiClHiCoJiCoGiCkEiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iCnMiClIiCfAiDfKiDgCiDfGiDiHiDjDiJnPiLiOiCnGiInKjDkOiClFiBeBiDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiCgAiCoGiCoI_xHqqkZx_
	// _xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCgNiCmJiCkIiCkCiCmEiDfOiBfLiDfBiDgCiDgHiCmMjFmPiNfIiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiCgNiBhLiCfAiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iCoAiClFiDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiCgNiCnMiCmFiInKjDkOiClFiCmEiClFiCnMiCkEiCmGiBeB_xHqqkZx_
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiCmMjBeJjBpAiCmJiOhIiPoBiCkKjAlGiClGiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iBgJiNoNiPjMiClDiCoKiClNiPoKiNiHiCmIiCmHiBgK_xHqqkZx_
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiCnMiCmF_xHqqkZx_
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAjGnPiClFiBeBiPoDiImKiMjPiNpFiClHiCoJiCkJiKgNjEeGiClHiCoJiBeC_xHqqkZx_
	// 
	//     _xZkqqHx_iEkG_xHqqkZx_ NextSession = O_xZkqqHx_iBgJiDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBgK_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iBeG_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkJ_xHqqkZx_ NextSession = N
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_ Session = N_xZkqqHx_iBgJiDfOiBfLiDfBiDgCiDgHjFjEjFgJiCmMjFmPiNfIiBgK_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkJ_xHqqkZx_ NextSession = N + 1
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iBeG_xHqqkZx_
	//     _xZkqqHx_iBeG_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBkK_xHqqkZx_
	//     _xZkqqHx_iEkJ_xHqqkZx_ NextSession = A_xZkqqHx_iBgJiMjPiNpFiKeKiOgOiImKjChFiBgK_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBkK_xHqqkZx_
	//     _xZkqqHx_iEkJ_xHqqkZx_ NextSession = S_xZkqqHx_iBgJiMlLiNnNiImKjChFiBgK_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iBeG_xHqqkZx_
	// 
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ);
//	if (result != FD_DRR_OK) return result;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiCpAiDfIiDeMiDgCiDhGiClFiCmEiOjPiDfKiDgCiDfGiDiHiDjDiCkJiCoHiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL bIsSkipThisSession = TRUE;
	if (!ret.IsNullIsSkipThisSession())
		bIsSkipThisSession = ret.GetIsSkipThisSession();

	flint fliSessionIndex = GetNextSessionIndex();
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBjBhNjDpMiImKjChFiBeC_xHqqkZx_
	long lReqIndex = 1;

	if (fliSessionIndex != GetFirstSessionIndex())
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjAoGjDkKiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiPfHiNiHiBeC_xHqqkZx_
		const DWORDSet stObjectId = *ret.GetObjectIdSet();
//----- 06.01.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jHjKjHpAiCmMiMlLiNnNiImKjChFiBgJiChCiBgKiCpAiLeMiJkPiBeC_xHqqkZx_
//		const flint fliCurrentSessionIndex = GetNextSessionIndex();
//----- 06.01.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		if (bIsSkipThisSession)
		//----- _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiCpAiDfIiDeMiDgCiDhGiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHjKjHpAiCpAiCfAiDfKiDgCiDfGiDiHiDjDiJnPiLiOiCnGiDfIiDeMiDgCiDhGiBeCiMjPiNpFiKeKiOgOiImKjChFiBgJiCgAiBgKiCnGiBeC_xHqqkZx_
			m_pGate->ScanSessionPrev(DWORDSet(), longSet(), fliSessionIndex);
			fliSessionIndex--;
		}
		for (;;)
		{
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjAoGjDkKiCmJiOiKiCmBiClNiPoKiNiHiCmNiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (fliSessionIndex == GetFirstSessionIndex())
				break;
			// _xZkqqHx_jHjKjHpAiCpAiCfAiDfKiDgCiDfGiDiHiDjDiJnPiLiOiCnGiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			DWORDSet stChangedObjectId;
			longSet stChangedLinkId;
			m_pGate->ScanSessionPrev(stChangedObjectId, stChangedLinkId, fliSessionIndex);
			// _xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (FFIsIntersect(stObjectId, stChangedObjectId))
				break;
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjFmPjAjEiCpAiBhMiCfAiBeCiDiLiBfLiDhGiCpAjElCiCkPiCoJiDfOiDeDiDhOiDjDiDePiCmM_xHqqkZx_
			// _xZkqqHx_iMoDiCmJiMlIiOfKiClHiCoJiClBiCmGiCkKiPgEjHhGiBeC_xHqqkZx_
			fliSessionIndex--;
		}
//----- 06.01.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiMlDiCmMiImKjChFiBgJiChCiBgKiCnMiCmFiDfGiBfLiDeOiBeC_xHqqkZx_
//		m_pGate->SeekToSessionIndex(fliCurrentSessionIndex, FILE_BEGIN);
//----- 06.01.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiCnMiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDfKiDgCiDfGiDiHiDjDjClMiMoDiCmJiInKjDkOiClDiCoKiCoJiBeC_xHqqkZx_
		InsertDocRequest(lReqIndex++,
						ID_DREQ_MOVE_HISTORY_UNTIL_SESSION,
						FCReqBase::SESSION_INDEX,
						fliSessionIndex,
						FCReqBase::NONE);
		// _xZkqqHx_jFjEjFgJiCpAjBeJjBpAiBeC_xHqqkZx_
		InsertDocRequest(lReqIndex++,
						ID_DREQ_SELECT_OBJECT,
						FCReqBase::IS_SELECT_OBJECT, TRUE,
						FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
						FCReqBase::IS_DRAW_SELECT_MARK, TRUE,
						FCReqBase::NONE);
	}
	if (fliSessionIndex == GetFirstSessionIndex())
	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCkKiMkJiCmCiCkJiCoHiClIiBeBiDfKiDgCiDfGiDiHiDjDjAoGjDkKiCmJiOiKiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAjFlGiPjBiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
		FCHiDocumentRec hiDocRec = g_pProject->GetDocumentRec(GetDocumentId());
		// _xZkqqHx_iPoDiImKjFlGiPjBiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		if (hiDocRec.GetSuperDocId() == -1)
		//----- _xZkqqHx_iPoDiImKjFlGiPjBiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiBhFiDfKiDgCiDfGiDiHiDjDjAoGjDkKiCmJjCeCiClFiCnMiClFiClNiBeCiBhG_xHqqkZx_
			InsertDocRequest(lReqIndex++,
							ID_DREQ_MESSAGE_BOX,
							FCReqBase::MESSAGE_TEXT_ID, IDS_MSG_REACH_SESSION_BEGIN,
							FCReqBase::MESSAGE_BOX_TYPE, MB_OK,
							FCReqBase::NONE);
		} else
		//----- _xZkqqHx_iPoDiImKjFlGiPjBiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiBhFiDfKiDgCiDfGiDiHiDjDjAoGjDkKiCmJjCeCiClFiCnMiClFiClNiBeCiPoDiImKiCmMjHjKjHpAjFlGiPjBiCoAiMjPiNpFiClFiCnMiClHiCkJiBeIiBhG_xHqqkZx_
			InsertDocRequest(lReqIndex++,
							ID_DREQ_MESSAGE_BOX,
							FCReqBase::MESSAGE_TEXT_ID, IDS_MSG_REACH_SESSION_BEGIN_IS_SEARCH_HIGHER,
							FCReqBase::MESSAGE_BOX_TYPE, MB_YESNO,
							FCReqBase::NONE);
			// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
			InsertDocRequest(lReqIndex++,
							ID_DREQ_IF,
							FCReqBase::RETURN, IDYES,
							FCReqBase::NONE);
				// _xZkqqHx_iPoDiImKiCnGiInKjDkOiBeC_xHqqkZx_
				InsertDocRequest(lReqIndex++,
								ID_DREQ_MOVE_HISTORY_TO_HIGHER_TREE);
				// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiDeJiDhFiDfHiDeGiDeOiDgHiCmMjBiAiNoMiCnMiCmFjGnPiClHiBeCiPoDiImKiCmMjHjKjHpAiMjPiNpFiCmFiCmNiBeB_xHqqkZx_
				// _xZkqqHx_iMlLiNnNiImKjChFiCpAiDfIiDeMiDgCiDhGiCmNiClFiCmIiCkCiBeC_xHqqkZx_
				InsertDocRequest(lReqIndex++,
								ID_DREQ_MOVE_HISTORY_BACKWARD_UNTIL_OPERATE,
								FCReqBase::IS_SKIP_THIS_SESSION,
								FALSE,
								FCReqBase::NONE);
			// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
			InsertDocRequest(lReqIndex++,
							ID_DREQ_END_IF);
		}
	}
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqMoveHistoryBackwardUntilOperate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveHistoryForward
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_HISTORY_FORWARD_UNTIL_OPERATE]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAiCpAiDfCiDhNiDjDiDgIiDfCiBfLiDgIiCnMiCmFjAgJiCnPiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveHistoryForwardUntilOperate (FCReqBase& ret, FCReqLock& reqLock)
{
	// _xZkqqHx_iJlKjAhNiCmMiCoGiCkEiCmJiBeBiDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiChCiCmJiMlLiNnNiImKjChFiCkKiCkAiCoJiPoKiNiHiBeB_xHqqkZx_
	// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCpAiDfIiDeMiDgCiDhGiClHiCoJiCoGiCkEiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iCnMiClIiCfAiDfKiDgCiDfGiDiHiDjDjGkCjHiIiCnGiInKjDkOiClFiBeBiDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiCgAiCoGiCoI_xHqqkZx_
	// _xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCgNiCmJiCkIiCkCiCmEiDfOiBfLiDfBiDgCiDgHiCmMjFmPiNfIiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiCgNiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iCoAiClFiDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiCgNiBhLiCfAiCnMiCmFiInKjDkOiClFiCmEiClFiCnMiCkEiCmGiBeB_xHqqkZx_
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiCmMjBeJjBpAiCmJiOhIiPoBiCkKjAlGiClGiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iBgJiNoNiPjMiClDiCoKiClNiPoKiNiHiCmIiCmHiBgK_xHqqkZx_
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiPeJjCfLiImKjChFiCnMiCmF_xHqqkZx_
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
	// 
	//     _xZkqqHx_iBeG_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkJ_xHqqkZx_ NextSession = S_xZkqqHx_iBgJiMlLiNnNiImKjChFiBgK_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBkL_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkJ_xHqqkZx_ NextSession = A_xZkqqHx_iBgJiMjPiNpFiKeKiOgOiImKjChFiBgK_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBkL_xHqqkZx_
	//     _xZkqqHx_iBeG_xHqqkZx_
	//     _xZkqqHx_iBeG_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkJ_xHqqkZx_ NextSession = N
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_ Session = N_xZkqqHx_iBgJiDfOiBfLiDfBiDgCiDgHjFjEjFgJiCmMjFmPiNfIiBgK_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkJ_xHqqkZx_ NextSession = N + 1
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iBeG_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkI_xHqqkZx_ NextSession = E_xZkqqHx_iBgJiDfKiDgCiDfGiDiHiDjDiPeJjCfLiImKjChFiBgK_xHqqkZx_
	// 

//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// m_fliEndSessionIndex _xZkqqHx_iCpAiOgHiCkEiClNiCnPiBeB_xHqqkZx_TERMINATE_READ _xZkqqHx_iCpAiNfIjAfGiBeC_xHqqkZx_
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ |
//											FCReqLock::TERMINATE_READ);
//	if (result != FD_DRR_OK) return result;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiCpAiDfIiDeMiDgCiDhGiClFiCmEiOjPiDfKiDgCiDfGiDiHiDjDiCkJiCoHiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL bIsSkipThisSession = TRUE;
	if (!ret.IsNullIsSkipThisSession())
		bIsSkipThisSession = ret.GetIsSkipThisSession();

	flint fliSessionIndex = GetNextSessionIndex();
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBjBhNjDpMiImKjChFiBeC_xHqqkZx_
	long lReqIndex = 1;
	if (fliSessionIndex != GetEndSessionIndex())
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjCfLiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiPfHiNiHiBeC_xHqqkZx_
		const DWORDSet stObjectId = *ret.GetObjectIdSet();
//----- 06.01.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jHjKjHpAiCmMiMlLiNnNiImKjChFiBgJiChCiBgKiCpAiLeMiJkPiBeC_xHqqkZx_
//		const flint fliCurrentSessionIndex = GetNextSessionIndex();
//----- 06.01.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		if (bIsSkipThisSession)
		//----- _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiCpAiDfIiDeMiDgCiDhGiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHjKjHpAiCpAiCfAiDfKiDgCiDfGiDiHiDjDjGkCjHiIiCnGiDfIiDeMiDgCiDhGiBeCiMjPiNpFiKeKiOgOiImKjChFiBgJiCgAiBgKiCnGiBeC_xHqqkZx_
			m_pGate->ScanSessionNext(DWORDSet(), longSet(), fliSessionIndex);
			fliSessionIndex++;
		}
		for (;;)
		{
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjCfLiCmJiOiKiCmBiClNiPoKiNiHiCmNiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (fliSessionIndex == GetEndSessionIndex())
				break;
			// _xZkqqHx_jHjKjHpAiCpAiCfAiDfKiDgCiDfGiDiHiDjDjGkCjHiIiCnGiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			DWORDSet stChangedObjectId;
			longSet stChangedLinkId;
			m_pGate->ScanSessionNext(stChangedObjectId, stChangedLinkId, fliSessionIndex);
			// _xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (FFIsIntersect(stObjectId, stChangedObjectId))
				break;
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjFmPjAjEiCpAiBhLiCfAiBeCiDiLiBfLiDhGiCpAjElCiCkPiCoJiDfOiDeDiDhOiDjDiDePiCmM_xHqqkZx_
			// _xZkqqHx_iMoDiCmJiJmBiOfKiClHiCoJiClBiCmGiCkKiPgEjHhGiBeC_xHqqkZx_
			fliSessionIndex++;
		}
//----- 06.01.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiMlDiCmMiImKjChFiBgJiChCiBgKiCnMiCmFiDfGiBfLiDeOiBeC_xHqqkZx_
//		m_pGate->SeekToSessionIndex(fliCurrentSessionIndex, FILE_BEGIN);
//----- 06.01.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiCnMiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDfKiDgCiDfGiDiHiDjDjClMjBePiCmJiInKjDkOiClDiCoKiCoJiBeC_xHqqkZx_
		InsertDocRequest(lReqIndex++,
						ID_DREQ_MOVE_HISTORY_UNTIL_SESSION,
						FCReqBase::SESSION_INDEX,
						fliSessionIndex,
						FCReqBase::NONE);
		// _xZkqqHx_jFjEjFgJiCpAjBeJjBpAiBeC_xHqqkZx_
		InsertDocRequest(lReqIndex++,
						ID_DREQ_SELECT_OBJECT,
						FCReqBase::IS_SELECT_OBJECT, TRUE,
						FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
						FCReqBase::IS_DRAW_SELECT_MARK, TRUE,
						FCReqBase::NONE);
	}
	if (fliSessionIndex == GetEndSessionIndex())
	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCkKiMkJiCmCiCkJiCoHiClIiBeBiDfKiDgCiDfGiDiHiDjDiPeJjCfLiCmJiOiKiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiBhFiDfKiDgCiDfGiDiHiDjDiPeJjCfLiCmJjCeCiClFiCnMiClFiClNiBeCiBhG_xHqqkZx_
		InsertDocRequest(lReqIndex++,
						ID_DREQ_MESSAGE_BOX,
						FCReqBase::MESSAGE_TEXT_ID, IDS_MSG_REACH_SESSION_END,
						FCReqBase::MESSAGE_BOX_TYPE, MB_OK,
						FCReqBase::NONE);
	}
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqMoveHistoryForwardUntilOperate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveHistorySessionCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_HISTORY_SESSION_COUNT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAiCpAiOhHjCoIjAjEiDfKiDgCiDfGiDiHiDjDiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
 *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
 *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveHistorySessionCount (FCReqBase& ret, FCReqLock& reqLock)
{
	// _xZkqqHx_iInKjDkOjAoGiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmMjCgMiCpAjClCjAkOiBeC_xHqqkZx_
	flint i64NextSessionIndex = GetNextSessionIndex() + ret.GetSessionCount();
	if (i64NextSessionIndex < 0) i64NextSessionIndex = 0;
	// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiCnMiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
	InsertDocRequest(1,
					ID_DREQ_MOVE_HISTORY_UNTIL_SESSION,
					FCReqBase::SESSION_INDEX, i64NextSessionIndex,
					FCReqBase::NONE);
	if (0 < ret.GetSessionCount())
		InsertDocRequest(	2,
							ID_DREQ_SCROLL_TO_SPOT,
							FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
							FCReqBase::SESSION_DIRECTION, SESSION_DIRECTION::FROM_BEFORE_TO_AFTER,
							FCReqBase::IS_SELECT_OBJECT, FALSE,
							FCReqBase::NONE);
	else
		InsertDocRequest(	2,
							ID_DREQ_SCROLL_TO_SPOT,
							FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
							FCReqBase::SESSION_DIRECTION, SESSION_DIRECTION::FROM_AFTER_TO_BEFORE,
							FCReqBase::IS_SELECT_OBJECT, FALSE,
							FCReqBase::NONE);
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqMoveHistorySessionCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveHistoryUntilSession
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_HISTORY_UNTIL_SESSION]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiCnMiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ret.GetSessionIndex()	:_xZkqqHx_jFfMiOkGiClHiCoJjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCmM_xHqqkZx_
 *									 _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *									 _xZkqqHx_jHjKjHpAiCmMiNmFiMoDiCpAjFfMiOkGiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_-1_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *									 _xZkqqHx_jCgMiCkKjAlDiKgNiCmFiCkAiCoJjFeLjHhGiCmNjGlDiCkCiBeCjBoFiCkLiClHiCkMiCoJiPoKiNiHiCmN_xHqqkZx_
 *									 _xZkqqHx_iPeDjAlDiClDiCoKiCoJiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
 *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
 *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveHistoryUntilSession (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.01.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	ASSERT(GetIsDocumentOpened());
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ |
//											FCReqLock::SUMMARY_READ |
//											FCReqLock::SPOT_READ |
//											FCReqLock::TERMINATE_READ |
//											FCReqLock::FORK_READ);
//	if (result != FD_DRR_OK) return result;
//
//	// _xZkqqHx_iIpIjAjEjCgMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//	flint fliSessionIdx = ret.GetSessionIndex();
//	// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCpAjAnNjCoIiBeCiDhEiDeAiDeDiDiLiImKjChFiCmMiInKjDkOiLjHjHkDiMhGiOfKiCmJiOgHiCkEiBeC_xHqqkZx_
//	const flint fliCurIdx = GetNextSessionIndex();
//	// _xZkqqHx_jFjEjFgJiNoNiPjMjDjJiCmJjEpFiCkGiCmEiBeBjBeJjBpAjCiGiCmMjFjEjFgJiCpAiJpAjFpKiBeC_xHqqkZx_
//	g_pView->ClearSelectObj(TRUE);
//	//----- _xZkqqHx_iNmFiCoAiLnPiCkCiImKjChFiCkJiCoHiBeBjHjKjHpAiDhEiDeAiDeDiDiLiCpAiKeKiCkCiCmEiInKjDkOiBgJiMlLiNnNiImKjChFiCpAiCfAiCePjEhLjHeEjAoGiBgK_xHqqkZx_ -----
//
//	// _xZkqqHx_iImKjChFiCkKjBoFiCkLiClHiCkMiCoJiBeBiPkMiClDiClHiCkMiCoJiPoKiNiHiCmNiPeDjAlDiBeC_xHqqkZx_
//	if (m_fliEndSessionIndex < fliSessionIdx)
//		fliSessionIdx = m_fliEndSessionIndex;
//	else
//	if (fliSessionIdx < GetFirstSessionIndex())
//		fliSessionIdx = GetFirstSessionIndex();
//
//	// _xZkqqHx_iMlLiNnNiImKjChFiCkJiCoHiCmMiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
//	const flint fliFromCur = (fliSessionIdx < fliCurIdx) ?
//								fliCurIdx - fliSessionIdx : fliSessionIdx - fliCurIdx;
//
//	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCkJiCoHiCmMiLjHjHkDiCpAiOfKiPgPiBgJiCfAiCePjEhLiClHiCoJiBgKiBeC_xHqqkZx_
//
//	// _xZkqqHx_iOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiNmFiCoAiLnPiCkCiImKjChFiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiMjPiNpFiBeC_xHqqkZx_
//	WString	strSpotFile;		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjGlMiBeC_xHqqkZx_
//	flint fliCmdPtrSpot;		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiImKjChFiBeC_xHqqkZx_
//	flint fliIdxPtrSpot;		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiImKjChFiBeC_xHqqkZx_
//	flint fliSessionIdxSpot;	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiImKjChFiBeC_xHqqkZx_
//
//#ifndef _DEBUG
//_xZkqqHx_iMiLiLmHiCmMiCmGiClBiCoLiBeBiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmN_xHqqkZx_OnSaveHidocument _xZkqqHx_iCmFiNfIjAfGiClDiCoKiCoJiCmMiClOiCkKiBeB_xHqqkZx_
//_xZkqqHx_iClLiCmMiNnLiBeB_xHqqkZx_HIDOCUMENT_xZkqqHx_iCmMiNfIjAfGiDeKiDeFiDjDiDfOiCkK_xHqqkZx_UP_xZkqqHx_iClFiCmIiCkCiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
//_xZkqqHx_jBkGiClPiBeB_xHqqkZx_FLUSH_xZkqqHx_iCmNiKpJiCmJiClDiCoKiCmEiCkCiCoJiCmMiClOiCkKiBeBiPeJjCfLiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpA_xHqqkZx_
//_xZkqqHx_iPjBiCkLiNjOiCpBiClOiPoKiNiHiBeC_xHqqkZx_
//_xZkqqHx_iClBiCoKiCmJjBmOiPiIiClHiCoJiCmJiCmNiBeBiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiCoAjFeLjHhGiCkJiCmIiBeI_xHqqkZx_
//_xZkqqHx_iCmGiClHiCoJiCmGiBeBiMiLiLmHiBeBjBfDiCmEiCmMiDhEiDeAiDeDiDiLiClCiCmGiCmJiDiNiDgCiDeOiCkKjFeLjHhGiCmGiCmIiCoJiCmMiCmFiBeB_xHqqkZx_
//_xZkqqHx_iDhEiDeAiDeDiDiLiKmHjHjNiDeOiDiJiDfIiCmJiDiNiDgCiDeOiLeAjEfMiCpAjCmHiJmBiClHiCoJiCmMiCkKiCoGiClDiClAiBeC_xHqqkZx_
//#endif//_DEBUG
//
//	flint fliDistToSpot = m_spotFile.SearchPath2(&fliSessionIdxSpot,
//												&fliCmdPtrSpot,
//												&fliIdxPtrSpot,
//												&strSpotFile,
//												fliSessionIdx,
//												FLINT_MAX);
//	fliDistToSpot = m_forkFile.SearchPath2(	&fliSessionIdxSpot,
//											&fliCmdPtrSpot,
//											&fliIdxPtrSpot,
//											&strSpotFile,
//											fliSessionIdx,
//											fliDistToSpot);
//	// _xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNjHoBiKePiCpAjEkNjAlGiBeCiDhEiDeAiDeDiDiLiCkKjEgKjBlJiClFiCmEiCkCiCnMiClHiBeC_xHqqkZx_
//	if (fliDistToSpot == FLINT_MAX)
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
//		// IDS_ERR_FILE_DESTROIED  "_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjEgKjBlJiClFiCmEiCkCiCnMiClHiBeC_xHqqkZx_"
//		FFSetDDError(IDS_ERR_FILE_DESTROIED);
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//	flint fliFromSpot = (fliSessionIdx < fliSessionIdxSpot) ?
//						fliSessionIdxSpot - fliSessionIdx : fliSessionIdx - fliSessionIdxSpot;
//	// _xZkqqHx_iDfIiDhMiDgCiDgHjDmHiCnNiNjOiCnNiCmMiOjOiKnEiCmGiClFiCmEiBeB_xHqqkZx_100_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiDhJiDgJiDiLiDgFiDeCjCmHiJmBiBeC_xHqqkZx_
//	fliFromSpot += 100;
//	//----- _xZkqqHx_iNmFiCoAiLnPiCkCiImKjChFiCpAjHeEjAoGiClFiCmEiDiNiBfLiDgIiBgJiMlLiNnNiImKjChFiCkJiCoHiCkKiCfAiCePiCePiDfIiDgFiDgCiDhGjHeEjAoGiBgK_xHqqkZx_ -----
//	if (fliFromSpot < fliFromCur)
//	{
//		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjFmPjAjEiCmJiDePiDiNiBfLiDgPiDiLiCpAjElNiJgGiBeC_xHqqkZx_
//		m_canvasStatLast.UpdateData();
//		// _xZkqqHx_jDoAjFjEiCmMiPoOjFpBiBgJjFjEjFgJiBeBiKmCiLkLjDjJiBgKiCpAiNoNiPjMiBeC_xHqqkZx_
//		BASE_CLASS::DeleteContents();
//		// _xZkqqHx_iHeBiMjPiNpFiClFiClNiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		// _xZkqqHx_iLeMjIfOiClFiCmEiCkAiCoJiDeMiDiDiDjDiDgPiDfIiPoOjFpBiCpAiDiKiDhEiDeAiDiMiDjDiDfIiCmGiClFiCmEiOhHjCoIiBeC_xHqqkZx_
//		// _xZkqqHx_iClBiCmMiPoOjFpBiCmFiDeMiDiDiDjDiDgPiDfIiPoOjFpBiCmNiPiJiKpKiJlLiClDiCoKiCoJiBeC_xHqqkZx_
//		FCDbReadLock readLockSpot;
//		if (!FFImportSpotFile(	this,
//								strSpotFile,
//								&m_canvasStatLast,
//								readLockSpot,
//								TRUE))
//		//----- _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjDmHiCnNiPgPiClFiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iKpJiCmJjFlGiPjBiDhEiDeAiDeDiDiLiCpAiDiNiDgCiDeOiNmPiCnNiCmIiCmMiCmFiBeB_xHqqkZx_
//			// _xZkqqHx_jCmKiPoNiBeBiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjDmHiCnNiPgPiClFiCmJiOlIjEhDiClHiCoJiClBiCmGiCmNiCkAiCoIiCkGiCmIiCkCiBeC_xHqqkZx_
//			AfxDebugBreak();
//			return FD_DRR_FATAL_ERR;
//		}
//
//		// _xZkqqHx_iHeCjHjKjHpAiDhEiDeAiDeDiDiLiCpAiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiImKjChFiCnMiCmFiDfGiBfLiDeOiBeC_xHqqkZx_
//		m_pGate->SeekToSessionIndex(fliCmdPtrSpot, FILE_BEGIN);
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBjFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
//		m_pGate->SetupSessionTimeAndIndex();
//		// _xZkqqHx_iHeDiOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCnMiCmF_xHqqkZx_ Redo/Undo _xZkqqHx_iCmFiInKjDkOiBeC_xHqqkZx_
//		m_pGate->MoveSessionTo(DWORDSet(), fliSessionIdx);
//		// _xZkqqHx_iHeEjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmJjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//		m_historyIndex.SeekToSessionIndex(fliIdxPtrSpot, FILE_BEGIN);
//		// _xZkqqHx_iOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCnMiCmF_xHqqkZx_ Redo/Undo _xZkqqHx_iCmFiInKjDkOiBeC_xHqqkZx_
//		m_historyIndex.SeekToSessionIndex(fliSessionIdx);
//		// _xZkqqHx_jBfDjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoIiClFiCmEiNmEjFgAiJoGiBeC_xHqqkZx_
//		g_pView->SetClientToRgn();
//
//		// _xZkqqHx_iDhEiDiMiBfLiDiAiDeFiDeCiDjDiDgIiDeFiCmMiDfOiDeDiDgHiDiLiCpAjAnNjCoIiBeC_xHqqkZx_BASE_CLASS::DeleteContents_xZkqqHx_jDoAjFjEiCmF_xHqqkZx_
//		// _xZkqqHx_iDfOiDeDiDgHiDiLiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiClNiCnPiBeBiClBiClBiCmFiMmEiCnBiPgPiClFiCmEiMlDiCmJjGnPiClHiBeC_xHqqkZx_
//		SetTitle(NULL);
//	} else
//	{
//		// _xZkqqHx_iHeDiOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCnMiCmF_xHqqkZx_ Redo/Undo _xZkqqHx_iCmFiInKjDkOiBeC_xHqqkZx_
//		m_pGate->MoveSessionTo(DWORDSet(), fliSessionIdx);
//		// _xZkqqHx_iHeEjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmJjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//		m_historyIndex.SeekToSessionIndex(GetNextSessionIndex());
//	}
//	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	UpdateTimeLabel(m_forkFile, reqLock.m_autoLockForkRead);
//	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_fliSessionIdx, 
//	g_pView->SendRgnRedraw();
//
//	// _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmMjDpKjFhEjFfMiOkGiCpAiNfIjAfGiBeC_xHqqkZx_
//	FFGetHiMainWnd()->UpdateStatusBarUserDate();
//
//	return FD_DRR_OK;
//----- 06.01.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	ASSERT(GetIsDocumentOpened());
//----- 06.01.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ |
//											FCReqLock::SUMMARY_READ |
//											FCReqLock::SPOT_READ |
//											FCReqLock::TERMINATE_READ |
//											FCReqLock::FORK_READ);
//----- 06.01.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FTDocReqResult result = OnReqCheckLock(	reqLock,
											FCReqLock::SPOT_READ);
//----- 06.01.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	if (result != FD_DRR_OK) return result;

	// _xZkqqHx_jGnKjFfHiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	flint fliDestinationIndex = ret.GetSessionIndex();
	// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCpAjAnNjCoIiBeCiDhEiDeAiDeDiDiLiImKjChFiCmMiInKjDkOiLjHjHkDiMhGiOfKiCmJiOgHiCkEiBeC_xHqqkZx_
	const flint fliCurrentSessionIndex = GetNextSessionIndex();
	// _xZkqqHx_jFjEjFgJiNoNiPjMjDjJiCmJjEpFiCkGiCmEiBeBjBeJjBpAjCiGiCmMjFjEjFgJiCpAiJpAjFpKiBeC_xHqqkZx_
	g_pView->ClearSelectObj(TRUE);
	//----- _xZkqqHx_iNmFiCoAiLnPiCkCiImKjChFiCkJiCoHiBeBjHjKjHpAiDhEiDeAiDeDiDiLiCpAiKeKiCkCiCmEiInKjDkOiBgJiMlLiNnNiImKjChFiCpAiCfAiCePjEhLjHeEjAoGiBgK_xHqqkZx_ -----

	// _xZkqqHx_iImKjChFiCkKjBoFiCkLiClHiCkMiCoJiBeBiPkMiClDiClHiCkMiCoJiPoKiNiHiCmNiPeDjAlDiBeC_xHqqkZx_
	if (GetEndSessionIndex() < fliDestinationIndex)
		fliDestinationIndex = GetEndSessionIndex();
	else
	if (fliDestinationIndex < GetFirstSessionIndex())
		fliDestinationIndex = GetFirstSessionIndex();

	// _xZkqqHx_iMlLiNnNiImKjChFiCkJiCoHiCmMiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
	const flint fliDistanceFromCurrent = fli_abs(fliCurrentSessionIndex - fliDestinationIndex);

	//----- _xZkqqHx_iNmFiKpBiCoIiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiOfKiPgP_xHqqkZx_ -----
	flint fliDistanceFromSpot = FLINT_MAX;
	FCSpotConstIterator iSpot = m_spotFile.FindNearestSpot(	fliDistanceFromSpot,
															fliDestinationIndex);
	// _xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiPeJjHlJiBeC_xHqqkZx_
	if (iSpot.GetIsInvalid())
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjEgKjBlJiClFiCmEiCkCiCnMiClHiBeC_xHqqkZx_
		FFSetDDError(	IDS_ERR_FILE_DESTROIED,
							WString(g_pProject->GetTableName().GetTopDirPath()));
		AfxDebugBreak();
		return FD_DRR_FATAL_ERR;
	}

//----- 06.01.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjCfLiDfIiDhMiDgCiDgHiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	BOOL bIsUseEndSpot = FALSE;
	if (m_cmdTerminateFile.IsThereEndSessionSpot() &&
		fli_abs(GetEndSessionIndex() - fliDestinationIndex) < fliDistanceFromSpot)
	//----- _xZkqqHx_jCiGiKnEiDfIiDhMiDgCiDgHiCoGiCoIiPeJjCfLiDfIiDhMiDgCiDgHiCkKiLnPiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeJjCfLiDfIiDhMiDgCiDgHiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
		bIsUseEndSpot = TRUE;
		fliDistanceFromSpot = fli_abs(GetEndSessionIndex() - fliDestinationIndex);
	}
//----- 06.01.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfIiDhMiDgCiDgHjDmHiCnNiNjOiCnNiCmMiOjOiKnEiCmGiClFiCmEiBeB_xHqqkZx_100_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiDhJiDgJiDiLiDgFiDeCjCmHiJmBiBeC_xHqqkZx_
	fliDistanceFromSpot += 100;
	//----- _xZkqqHx_iNmFiCoAiLnPiCkCiImKjChFiCpAjHeEjAoGiClFiCmEiDiNiBfLiDgIiBgJiMlLiNnNiImKjChFiCkJiCoHiCkKiCfAiCePiCePiDfIiDgFiDgCiDhGjHeEjAoGiBgK_xHqqkZx_ -----
	if (fliDistanceFromSpot < fliDistanceFromCurrent)
	{
		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjFmPjAjEiCmJiDePiDiNiBfLiDgPiDiLiCpAjElNiJgGiBeC_xHqqkZx_
		m_canvasStatLast.UpdateData();
		// _xZkqqHx_jDoAjFjEiCmMiPoOjFpBiBgJjFjEjFgJiBeBiKmCiLkLjDjJiBgKiCpAiNoNiPjMiBeC_xHqqkZx_
		BASE_CLASS::DeleteContents();
		// _xZkqqHx_iHeBiMjPiNpFiClFiClNiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		// _xZkqqHx_iLeMjIfOiClFiCmEiCkAiCoJiDeMiDiDiDjDiDgPiDfIiPoOjFpBiCpAiDiKiDhEiDeAiDiMiDjDiDfIiCmGiClFiCmEiOhHjCoIiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoOjFpBiCmFiDeMiDiDiDjDiDgPiDfIiPoOjFpBiCmNiPiJiKpKiJlLiClDiCoKiCoJiBeC_xHqqkZx_
		flint fliSpotSessionIndex;
		BYTE* pSpotStream;
		DWORD dwSpotStreamSize;
		if (bIsUseEndSpot)
		{
			fliSpotSessionIndex = GetEndSessionIndex();
			FC2Ref<BYTE*, DWORD>(pSpotStream, dwSpotStreamSize) = m_cmdTerminateFile.SeeEndSessionSpotStream();
		} else
		//----- _xZkqqHx_jCiGiKnEiDfIiDhMiDgCiDgHiCkKiLnPiCkCiPoKiNiH_xHqqkZx_ -----
		{
			fliSpotSessionIndex = iSpot.GetSessionIndex();
			FC2Ref<BYTE*, DWORD>(pSpotStream, dwSpotStreamSize) = iSpot.GetSpotStream();
		}
		if (!FFImportSpotFile(	this,
								&m_canvasStatLast,
								pSpotStream,
								dwSpotStreamSize,
								TRUE))
		//----- _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjDmHiCnNiPgPiClFiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfIiDhMiDgCiDgHiDgGiBfLiDfOiCpAiJpAjFpKiBeC_xHqqkZx_
			delete[] pSpotStream;
			pSpotStream = NULL;
			// _xZkqqHx_iKpJiCmJjFlGiPjBiDhEiDeAiDeDiDiLiCpAiDiNiDgCiDeOiNmPiCnNiCmIiCmMiCmFiBeB_xHqqkZx_
			// _xZkqqHx_jCmKiPoNiBeBiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjDmHiCnNiPgPiClFiCmJiOlIjEhDiClHiCoJiClBiCmGiCmNiCkAiCoIiCkGiCmIiCkCiBeC_xHqqkZx_
			AfxDebugBreak();
			return FD_DRR_FATAL_ERR;
		}
		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgGiBfLiDfOiCpAiJpAjFpKiBeC_xHqqkZx_
		delete[] pSpotStream;
		pSpotStream = NULL;
		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiImKjChFiCnMiCmFjHjKjHpAiDhEiDeAiDeDiDiLiCpAiDfGiBfLiDeOiBeC_xHqqkZx_
		m_pGate->SeekToSessionIndex(fliSpotSessionIndex);
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBjFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
		m_pGate->SetupSessionTimeAndIndex();
		// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiBeBiDfGiBfLiDeOiImKjChFiCkJiCoHjGnKjFfHiImKjChFiCnMiCmFiInKjDkOiBeC_xHqqkZx_
		m_pGate->MoveSessionTo(DWORDSet(), fliDestinationIndex);
		// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiDfGiBfLiDeOiImKjChFiCkJiCoHjGnKjFfHiImKjChFiCnMiCmFiInKjDkOiBeC_xHqqkZx_
		m_historyIndex.SeekToSessionIndex(fliDestinationIndex);
		// _xZkqqHx_jBfDjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoIiClFiCmEiNmEjFgAiJoGiBeC_xHqqkZx_
		g_pView->SetClientToRgn();
		// _xZkqqHx_iDhEiDiMiBfLiDiAiDeFiDeCiDjDiDgIiDeFiCmMiDfOiDeDiDgHiDiLiCpAjAnNjCoIiBeC_xHqqkZx_BASE_CLASS::DeleteContents_xZkqqHx_jDoAjFjEiCmF_xHqqkZx_
		// _xZkqqHx_iDfOiDeDiDgHiDiLiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiClNiCnPiBeBiClBiClBiCmFiMmEiCnBiPgPiClFiCmEiMlDiCmJjGnPiClHiBeC_xHqqkZx_
// 06.01.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		SetTitle(NULL);
		InsertDocRequest(1, ID_DREQ_SET_TITLE);
	} else
	{
		// _xZkqqHx_iHeDiOhHjCoIiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCnMiCmF_xHqqkZx_ Redo/Undo _xZkqqHx_iCmFiInKjDkOiBeC_xHqqkZx_
		m_pGate->MoveSessionTo(DWORDSet(), fliDestinationIndex);
		// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBjGnKjFfHiImKjChFiCnMiCmFiInKjDkOiBeC_xHqqkZx_
		m_historyIndex.SeekToSessionIndex(fliDestinationIndex);
	}
	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	UpdateTimeLabel(*g_pProject,
					m_forkFile,
					reqLock.m_autoLockProjectRead,
					reqLock.m_autoLockForkRead);
	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();

//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmMiDiGiBfLiDfFiBfLjGlMiBeBjDpKjFhEjFfMiOkGiCpAiNfIjAfGiBeC_xHqqkZx_
	WString wstrUserName;
	if (GetPrevSessionUser() == GUID_NULL)
		wstrUserName.LoadString(IDS_GUEST);
	else
		wstrUserName = g_pProject->UserIdToUserName(GetPrevSessionUser());
	FFGetHiMainWnd()->SetStatusBarUser(GetPrevSessionUser(), wstrUserName);
	FFGetHiMainWnd()->SetStatusBarDate(GetPrevSessionTime());
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	return FD_DRR_OK;
//----- 06.01.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistViewDoc::OnReqMoveHistoryUntilSession.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveHistoryToHigherTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_HISTORY_TO_HIGHER_TREE]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjGnIiCmMiPoDiImKiCnGiInKjDkOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
 *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
 *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveHistoryToHigherTree (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ |
//											FCReqLock::SUMMARY_READ |
//											FCReqLock::TERMINATE_READ |
//											FCReqLock::FORK_READ);
//	if (result != FD_DRR_OK) return result;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	flint fliSessionIdx;
	long lDocId;
	// _xZkqqHx_iPoDiImKiDgIiDeMiDiFiDiBiDjDiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
// 06.01.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_forkFile.GetSuperInfo(&fliSessionIdx, NULL, NULL, &lDocId);
	m_forkFile.GetSuperInfo(&fliSessionIdx, &lDocId);
	if (lDocId != -1)
	//----- _xZkqqHx_iPoDiImKiDgIiDeMiDiFiDiBiDjDiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (fliSessionIdx == GetNextSessionIndex())
		//----- _xZkqqHx_iCkCiCnMiKeKiCkCiCmEiCkCiCoJjFlGiPjBiCmMjHjKjHpAiCmMiNmFiPiJiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHjKjHpAiCpAiPoDiImKiCmJiInKjDkOiClFiCmEiCoAiBeBjFfMiOkGjDoAjHgFiCmJiIoBiCkCiCmNiCmIiCkCiClNiCnPiBeBiNmEjFgAiJoGiCmNiClFiCmIiCkCiBeC_xHqqkZx_
			// FCReqBase::IS_REDRAW = FALSE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_

			// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
			DWORDSet stSelectObjectId;
			g_pView->GetSelectObjectId(stSelectObjectId);

			// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAiPpDjBnEiCmNiDeOiDiKiDeBiClDiCoKiCoJiClNiCnPiBeBiClBiClBiCmFjFjEjFgJjBeJjBpAiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
			// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCmNiPmBiLiOiClFiCmIiCkCiBeC_xHqqkZx_
			g_pView->ClearSelectObj(FALSE);

			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFmCiClGiCoJiBeC_xHqqkZx_
			InsertDocRequest(1, ID_DREQ_CLOSE_HIDOCUMENT,
							FCReqBase::IS_REDRAW, FALSE,
							FCReqBase::NONE);
			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkNiBeC_xHqqkZx_
			InsertDocRequest(2, ID_DREQ_OPEN_HIDOCUMENT,
							FCReqBase::HIDOCUMENT_ID, lDocId,
							FCReqBase::SESSION_INDEX, fliSessionIdx,
							FCReqBase::IS_USE_LAST_CANVAS_STAT, TRUE,
							FCReqBase::IS_REDRAW, FALSE,
							FCReqBase::NONE);

			// _xZkqqHx_jFjEjFgJiCpAjBeJjBpAiBeCjBeJjBpAiDhNiBfLiDeOiCmNjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
			InsertDocRequest(3,
							ID_DREQ_SELECT_OBJECT,
							FCReqBase::OBJECT_ID_SET, &stSelectObjectId,
							FCReqBase::IS_SELECT_OBJECT, TRUE,
							FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::NONE,
							FCReqBase::IS_DRAW_SELECT_MARK, FALSE,
							FCReqBase::NONE);
		} else
		//----- _xZkqqHx_iCkCiCnMiKeKiCkCiCmEiCkCiCoJjFlGiPjBiCmMjHjKjHpAiCmMjDhCjCiGiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHjKjHpAiCpAiPoDiImKiCmJiInKjDkOiClHiCoJiCmGiBeBjFfMiOkGjDoAjHgFiCmJiIoBiCkCiCkKiCkAiCoJiClNiCnPiBeBiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFmCiClGiCoJiBeC_xHqqkZx_
			// FCReqBase::IS_USE_LAST_CANVAS_STAT = TRUE _xZkqqHx_iCpAiOhHjCoIiClFiCmEiCkCiCoJiCkKiBeB_xHqqkZx_
			// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIiDfEiDeDiDfJiCkKiPgLiPkMiClHiCoJiCmIiCmHiCmMiKoLiMkPjAkLiCoAiCkAiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iClLiCmMiPoKiNiHiCmNiBeB_xHqqkZx_View::UpdateScrollSize _xZkqqHx_iCmFjBmOiJjOiCmFiCkLiCoJiDgOiDfJiBeC_xHqqkZx_
			InsertDocRequest(1, ID_DREQ_CLOSE_HIDOCUMENT);
			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkNiBeC_xHqqkZx_
			InsertDocRequest(2, ID_DREQ_OPEN_HIDOCUMENT,
							FCReqBase::HIDOCUMENT_ID, lDocId,
							FCReqBase::SESSION_INDEX, fliSessionIdx,
							FCReqBase::IS_USE_LAST_CANVAS_STAT, TRUE,
							FCReqBase::NONE);
		}
	} else
	//----- _xZkqqHx_iPoDiImKiDgIiDeMiDiFiDiBiDjDiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		InsertDocRequest(1, ID_DREQ_CLOSE_HIDOCUMENT);
	}
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqMoveHistoryToHigherTree.

//----- 05.10.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqCheckJoinProjectUser
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_CHECK_JOIN_PROJECT_USER]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiOfBiJmBiCmMjFeLjHhGjAkLiCpAiDgAiDeGiDgCiDeOiClFiBeBjFeLjHhGiCmIiCoHiOfBiJmBiOoIjBlBiCkLiCpAjAgJiCnPiCoJ_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqCheckJoinProjectUser (FCReqBase& ret, FCReqLock& reqLock)
//{
//	return FD_DRR_OK;
//} // CFCHistViewDoc::OnReqCheckJoinProjectUser.
//----- 05.10.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::myLockAllLower
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiPjBiCmJiKnGiClHiCoJiDgFiBfLiDhFiDiLjBfDiCmEiCmGiBeBiDhGiDiNiDfHiDeGiDeOiDgHiBeBiOhHjCoIiImKjChF_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIiJlKiCkJiCoHjFkKiKpCiClHiCoJjFlGiPjBiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjBfDiCmE_xHqqkZx_Read|Write_xZkqqHx_iDiNiDgCiDeO_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lockBank			:_xZkqqHx_iDiNiDgCiDeOiDgPiDjDiDeOiCpAiOhHjCoIiBeCiDiNiDgCiDeOiCkKiOpLjEfLiClDiCoKiCoJiBeC_xHqqkZx_
 *			wcpProjectPath		:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId				:_xZkqqHx_jFlGiPjBiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndexX	:_xZkqqHx_iImKjChFiChHiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsLockForkOnX		:_xZkqqHx_iImKjChFiChHiCkJiCoHjFkKiKpCiClHiCoJjFlGiPjBiCpAiDiNiDgCiDeOiClHiCoJiCkJiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmJiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ FD_DRR_ERR_xZkqqHx_iBeBiClLiCoKiImIiKePiCmMiPoKiNiHiCmNjDeLjAnIiCmI_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMiPoKiNiHiBeBiOjPiCmMiDgFiBfLiDhFiDiLiCkKiDiNiDgCiDeOiClDiCoKiCoJiBgJ_xHqqkZx_bIsLockForkOnX = FALSE_xZkqqHx_iBgK_xHqqkZx_
 *			_xZkqqHx_iBeFiDhGiDiNiDfHiDeGiDeOiDgHiChA_xHqqkZx_
 *			_xZkqqHx_iBeFiCgAiCmMiDfCiDhNiDjDiDgIiBeBiDfEiDhNiDiKiBfLiBeBjHjKjHpAjFkKiKpCiBeBiDfIiDhMiDgCiDgHiBeBjHjKjHpAiPeJjCfLiBeBiKmHjHjNiDgFiBfLiDhFiDiL_xHqqkZx_
 *			_xZkqqHx_iBeFiCgCiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiL_xHqqkZx_
 *			_xZkqqHx_iCgBiCmGiCgDiCmMiDgFiBfLiDhFiDiLiCmNiDiNiDgCiDeOiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *			bIsLockForkOnX = TRUE _xZkqqHx_iCmMiPoKiNiHiCmNiBeBiCgBiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCoAiDiNiDgCiDeOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiChA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ _xZkqqHx_iChH_xHqqkZx_
 *                  _xZkqqHx_iEkAiBfO_xHqqkZx_
 *                  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iCgB_xHqqkZx_
 *                  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                  _xZkqqHx_iCgA_xHqqkZx_  _xZkqqHx_iCgC_xHqqkZx_  _xZkqqHx_iCgD_xHqqkZx_
 *
 *			_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiNiDgCiDeOiMoDiCmJiBeBjFlGiPjBiCgAiCmMjBlGiNnNiCoAiKgNjEeGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::myLockAllLower (	FCDbLockBank& lockBank,
												const wchar_t* wcpProjectPath,
												long lDocId,
												flint fliSessionIndexX,
												BOOL bIsLockForkOnX)
{
	if (!g_pFileServer->IsTopGroupExist(HString(wcpProjectPath)))
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// "_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNjBlGiNnNiClFiCnMiClJiCpBiBeC_xHqqkZx_"
		FFSetDDError(IDS_ERR_MSG_FILE_NOT_EXIST, wcpProjectPath);
		return FD_DRR_ERR;
	}
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDePiDiLiBfLiDhGiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	FCDbGroup dbTopGroup = g_pFileServer->GetTopGroup(HString(wcpProjectPath));
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	FCDbReadLock readLockProject;
	FCDbWriteLock writeLockProject;
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!dbTopGroup.TryLock(readLockProject, writeLockProject))
//		return FD_DRR_LATER;
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!dbTopGroup.TryLock(readLockProject, writeLockProject))
		return GetLockFailReqResult();
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiDgPiDjDiDeOiCmJjCmHiJmBiBeC_xHqqkZx_
	lockBank.Append(readLockProject);
	lockBank.Append(writeLockProject);
	// _xZkqqHx_jFlGiPjBiCgAiCmMiDePiDiLiBfLiDhGiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCDbGroup dbDocGroup = dbTopGroup.GetSubGroup(lDocId);
	if (dbDocGroup.GetIsInvalid())
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiDiMiDfCiBfLiDgIiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiBgJjBlMiDeBiDhGiDiKiCmFiNoNiPjMiClDiCoKiClNiPoKiNiHiBgK_xHqqkZx_-----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
		return FD_DRR_ERR;
	}
	// _xZkqqHx_iOhNiCgAiCmMjFlGiPjBiDgFiBfLiDhFiDiL_xHqqkZx_(_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCpAiKnMiCnO_xHqqkZx_)_xZkqqHx_iCpAjBfDiCmE_xHqqkZx_Read|Write_xZkqqHx_iDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!dbDocGroup.TryLockLower(lockBank))
//		return FD_DRR_LATER;
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!dbDocGroup.TryLockLower(lockBank))
		return GetLockFailReqResult();
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iOhNiCgAiCmMiImKjChFiChHiCoGiCoIiJlKiCkJiCoHjFkKiKpCiClHiCoJjFlGiPjBiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpA_xHqqkZx_
	// Read|Write_xZkqqHx_iDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	FCHiForkTable forkFile = dbDocGroup;
	forkFile.UpdateDataA(lockBank);
	FCForkConstIterator iFork = bIsLockForkOnX ?
							forkFile.GetLowerBoundFork(fliSessionIndexX) :
							forkFile.GetUpperBoundFork(fliSessionIndexX);
	while (!iFork.IsEnd())
	{
		FCDbReadLock readLockForkSub;
		FCDbWriteLock writeLockForkSub;
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (!FFTryLock(	readLockForkSub,
//						writeLockForkSub,
//						dbTopGroup.GetSubTableName(iFork.GetDocumentId(), FDHI_FORK_TABLE_ID)))
//			return FD_DRR_LATER;
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		if (!FFTryLock(	readLockForkSub,
						writeLockForkSub,
						dbTopGroup.GetSubTableName(iFork.GetDocumentId(), FDHI_FORK_TABLE_ID)))
			return GetLockFailReqResult();
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		lockBank.Append(readLockForkSub);
		lockBank.Append(writeLockForkSub);
		iFork++;
	}
	return FD_DRR_OK;
} // CFCHistViewDoc::myLockAllLower.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqChangeBranchIntoTrunk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_CHANGE_BRANCH_INTO_TRUNK]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAiOhNiCpAiPoDjHkMiCmMiKlCiCmJjFmPiNfIiClHiCoJ_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iCgAiCmMiChHiCoGiCoIiJlKiCkKjGlDiCkCiPoKiNiHiCmNiBeBiChHiImIiJlKiCpAiCgCiCmJjFkKiKpCiClFiCmIiCkNiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_jHmHiCkCiCmMiClOiCkKiBeBiNmFiPiJiCmMiPpDjBnEiCmF_xHqqkZx_ _xZkqqHx_iCkAiCkGiCmEiCgAiCmGiCgBiCmJjFkKiCkPiCmEiCkAiCoJiClBiCmGiCpA_xHqqkZx_
 *			_xZkqqHx_iNgMiCkGiCoJiCmGiBeBjClHiClDiCePiCmMiOhNiCmFiCkAiCmBiCmEiCoAjFkKiKpCiClFiCmEjFnLjBlGiClHiCnHiCkLiBeC_xHqqkZx_
 *			_xZkqqHx_iCnMiClNiBeBiChHiImIiJlKiCkKiCkAiCoJiCkJjGlDiCkCiCkJiCpAjElLjCgGiClHiCoJiCmMiCoAjGmKjDhMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAiOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiChHiCoGiCoIiJlKjFjEjFkKiCpAiBeBjHjKjHpAiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmGiClFiCmEjFkKiKpCiClDiClJiBeB_xHqqkZx_
 *			_xZkqqHx_jFkKiKpCjHjKjHpAiOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCpAjHjKjHpAiOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiChHiImIiJlKiCmJjAnKjBlBiClHiCoJiBeC_xHqqkZx_
 *
 *                     _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ _xZkqqHx_iChH_xHqqkZx_
 *                     _xZkqqHx_iEkAiBfO_xHqqkZx_
 *                     _xZkqqHx_iEkFiEjPiEjPiEjPiEkC_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iCgB_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iBkL_xHqqkZx_
 *                     _xZkqqHx_iCgA_xHqqkZx_
 *
 *                   _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *                 _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                  _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                    _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *                     _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkBiEjPiEjPiEjPiEkH_xHqqkZx_-_xZkqqHx_iChH_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iCgA_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iBkL_xHqqkZx_
 *             _xZkqqHx_iCgC_xHqqkZx_
 *
 *			------------------------------------------------------
 *			_xZkqqHx_iImKjChFiChHiCoGiCoIiJlKiCmMjFkKiKpCiCmNiBeBiCgCiCmJiInKjDkOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *
 *                  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ _xZkqqHx_iChH_xHqqkZx_
 *                  _xZkqqHx_iEkAiBfO_xHqqkZx_
 *                  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iCgB_xHqqkZx_
 *                  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                  _xZkqqHx_iCgA_xHqqkZx_
 *
 *               _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *             _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *              _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *                  _xZkqqHx_iEkA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkH_xHqqkZx_-_xZkqqHx_iChH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iCgA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *          _xZkqqHx_iCgC_xHqqkZx_
 *
 *		_xZkqqHx_iMlLiNnNiKeKiCkCiCmEiCoJjFlGiPjBiCkKiCgAiCmMiChHiImIiNhOiCkJiBeBiCgBiCmFiCkAiCmBiClNiPoKiNiHiCmNiBeBiIoKjDhIjFmCiClGiCmEiCkJiCoH_xHqqkZx_
 *		_xZkqqHx_jBePiCmMiImKjChFiCmJjBmOiJjOiClHiCoJiImKjChFiCpAiOhHjCoIiClFiCmEiKeKiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqChangeBranchIntoTrunk (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpA_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiClFiBeBiDgGiBfLiDfOiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	FCDbReadLock autoLockProjectRead;
//	FCHiProject project;
//	FTDocReqResult result = OnReqLockAndUpdate(	ret.GetProjectPath(),
//												-1,
//												autoLockProjectRead,
//												project);
//	if (result != FD_DRR_OK) return result;
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	FD_CHECK_QUALIFICATION(&project);
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	const long lDocIdB = ret.GetHidocumentId();
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFlGiPjBiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
//	FCHiDocumentRec hiDocRecB = project.GetDocumentRec(lDocIdB);
//	// _xZkqqHx_jHjKjHpAjFlGiPjBiDiMiDfCiBfLiDgIiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiBgJjBlMiDeBiDhGiDiKiCmFiNoNiPjMiClDiCoKiClNiPoKiNiHiBgK_xHqqkZx_
//	if (hiDocRecB.GetIsInvalid())
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
//		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
//		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
//		return FD_DRR_ERR;
//	}
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//	const long lDocIdA = hiDocRecB.GetSuperDocId();
//	if (lDocIdA == -1)
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
//		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
//		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
//		return FD_DRR_ERR;
//	}
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCDbReadLock autoLockForkARead;
//	FCHiForkTable forkFileA;
//	result = OnReqLockAndUpdate(NULL,
//								lDocIdA,
//								FCDbReadLock(),
//								project,
//								&autoLockForkARead,
//								&forkFileA);
//	if (result != FD_DRR_OK) return result;
//
//	FCForkConstIterator iFork = forkFileA.FindForkByDocumentId(lDocIdB);
//	if (iFork.IsEnd())
//	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
//		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
//		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
//		return FD_DRR_ERR;
//	}
//
//	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpA_xHqqkZx_1_xZkqqHx_iCmMiImKjChF_xHqqkZx_X_xZkqqHx_iCoGiCoIiJlKiCpAjHjKjHpA_xHqqkZx_3_xZkqqHx_iCmJjFmPiNfIiClFiBeBjHjKjHpA_xHqqkZx_2_xZkqqHx_iCpAjHjKjHpA_xHqqkZx_1_xZkqqHx_iCmJjFmPiNfI_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_CHANGE_BRANCH_1_TO_3_X_2_TO_1,
//						FCReqBase::HIDOCUMENT_ID, lDocIdA,
//						FCReqBase::HIDOCUMENT_ID_2, lDocIdB,
//						FCReqBase::SESSION_INDEX, iFork.GetSessionIndex(),
//						FCReqBase::NONE);
//	return FD_DRR_OK;
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_g_pFileServer->FlushAll _xZkqqHx_iCpAiOjNiCmCiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPiIjHjN_xHqqkZx_
	// _xZkqqHx_iCmMjDkKjBfDiCmEiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiPoKiNiHiCmNiBeBjHjKjHpAjFlGiPjBiCmMiDhEiDiJiDgCiDfGiDiFiCpAiOmAiNhDiBeC_xHqqkZx_
	if (OnReqCheckFlush()) return FD_DRR_RETRY;
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiBeC_xHqqkZx_
	const WString wstrProjectPath = ret.GetProjectPath();
	// _xZkqqHx_iOhNiCgBiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	const long lDocIdB = ret.GetHidocumentId();
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmGiOhNiCgBiCmMjFlGiPjBiDgFiBfLiDhFiDiLiCpAjBfDiCmE_xHqqkZx_Read|Write_xZkqqHx_iDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	FCDbLockBank lockBank;
	FTDocReqResult result = myLockAllLower(	lockBank,
											wstrProjectPath,
											lDocIdB,
											0,
											TRUE);
	if (result != FD_DRR_OK) return result;

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	FCHiProject project = g_pFileServer->GetTopGroup(HString(wstrProjectPath));
	project.UpdateDataA(lockBank);

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	FD_CHECK_QUALIFICATION(&project);

	// _xZkqqHx_iOhNiCgBiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCHiForkTable forkTableB = project.GetSubGroup(lDocIdB);
	forkTableB.UpdateDataA(lockBank);

	// _xZkqqHx_iOhNiCgBiCkKjBlGiNnNiClHiCoJiClBiCmGiCmN_xHqqkZx_ myLockAllLower _xZkqqHx_iCmFiKgNjEeGiNmPiCnNiBeC_xHqqkZx_
	// _xZkqqHx_iOhNiCgAiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmGjFkKiKpCiImKjChFiChHiCpAiOoGjDlOiBeC_xHqqkZx_
	flint fliSessionIndexX;
	long lDocIdA;
	forkTableB.GetSuperInfo(&fliSessionIndexX, &lDocIdA);
	if (lDocIdA == -1)
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
		return FD_DRR_ERR;
	}

//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOhNiCgAiCmMjHjKjHpAjFlGiPjBiDgFiBfLiDhFiDiLiCpAjBfDiCmEiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	result = myLockAllLower(lockBank,
							wstrProjectPath,
							lDocIdA,
							fliSessionIndexX,
							FALSE);
	if (result != FD_DRR_OK) return result;
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iClBiClBiCmFjHjKjHpAjFlGiPjBiCpAjFmCiClGiCoJjBePiCmJiBeBiKnGiMfHiClHiCoJjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiCpA_xHqqkZx_
	// _xZkqqHx_iOiOiCnNiCmEiCkIiCkNiBeC_xHqqkZx_
	// _xZkqqHx_iJlKiCmMiPiIjHjNiCmFiDiNiDgCiDeOiCmNjGlDjBmKiCmJiCmIiCoJiCkKiBeBiCoAiClFjBlMiDeBiDhGiDiKiCmFiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
	// _xZkqqHx_iPoKiNiHiBeBjFlGiPjBiCpAjFmCiClGiCoJiPiIjHjNiCpAjAoGiCmJiClFiCmEiClFiCnMiCkEiCmGiBeBiJgFiLlPiCkKjBoFiCkLiCkCiBeC_xHqqkZx_

	if (GetIsDocumentOpened())
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (g_pProject->GetFilePath() == wstrProjectPath &&
			(GetDocumentId() == lDocIdA || GetDocumentId() == lDocIdB))
		//----- _xZkqqHx_iNkBiKeKiCkCiCmEiCkCiCoJjFlGiPjBiCkKiOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iIlNiCkCiCmNiOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjApMiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iCnMiClIiBeBjFlGiPjBiCpAjFmCiClGiCoJiBeCiMoDiCmFiKeKiCkCiCmEiCkCiClNjFlGiPjBiCmMiImKjChFiCkK_xHqqkZx_
			// _xZkqqHx_iOoGiCoIiPgPiClJiCoJiCoGiCkEiCmJiBeB_xHqqkZx_OLD_xZkqqHx_jFmPjAjEiCmJjAnNjCoIiBeC_xHqqkZx_
			InsertDocRequest(0, ID_DREQ_CLOSE_HIDOCUMENT,
								FCReqBase::IS_REDRAW, FALSE,							// _xZkqqHx_iNmEjFgAiJoGiBeI_xHqqkZx_
								FCReqBase::HIDOCUMENT_ID_OLD, GetDocumentId(),			// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
								FCReqBase::SESSION_INDEX_OLD, GetNextSessionIndex(),	// _xZkqqHx_jFlGiPjBiImKjChFiBeC_xHqqkZx_
								FCReqBase::NONE);
			return FD_DRR_RETRY;	// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiMhAjBlBiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		}
	}

//----- 06.04.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iOhNiCgAiCmMjHjKjHpAjFlGiPjBiDgFiBfLiDhFiDiLiCpAjBfDiCmEiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	result = myLockAllLower(lockBank,
//							wstrProjectPath,
//							lDocIdA,
//							fliSessionIndexX,
//							FALSE);
//	if (result != FD_DRR_OK) return result;
//----- 06.04.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iImKjChFiChHiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	FCHiSpotTable spotTableB = project.GetSubGroup(lDocIdB);
	spotTableB.UpdateDataA(lockBank);
	FCSpotConstIterator iSpot = spotTableB.FindSpot(fliSessionIndexX);
	if (iSpot.GetIsInvalid())
		FFThrowMiscUnknown();
	BYTE* pSpotStream;
	DWORD dwSpotStreamSize;
	FC2Ref<BYTE*, DWORD>(pSpotStream, dwSpotStreamSize) = iSpot.GetSpotStream();
	long lDocIdC = BranchAToC(	project,
								lDocIdA,
								fliSessionIndexX,
								lockBank,
								pSpotStream,
								dwSpotStreamSize,
								FALSE,					// _xZkqqHx_iCgAiCmMiPeJjCfLiImKjChFiDgFiBfLiDhFiDiLiCpAiChHiCmJjAnNjCoIiClHiCoJiCkJiBeI_xHqqkZx_
								FALSE,					// _xZkqqHx_iImKjChFiChHiCmMjFkKiKpCiCpAiCgCiCnGiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
								TRUE);					// _xZkqqHx_iImKjChFiChHiCmMiOjOiKnEiDiJiDhIiDiLiCpAiCgCiCnGiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
	// _xZkqqHx_iDfIiDhMiDgCiDgHiDfIiDgHiDiKiBfLiDiAiCpAiJpAjFpKiBeC_xHqqkZx_
	delete pSpotStream;
	if (lDocIdC == -1)
		return FD_DRR_ERR;

	// _xZkqqHx_iOhNiCgAiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCHiForkTable forkTableA = project.GetSubGroup(lDocIdA);
	forkTableA.UpdateDataA(lockBank);
	// _xZkqqHx_iCgAiCmMiOhNiCgBiCmJiKnGiClHiCoJjFkKiKpCiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	FCForkConstIterator iFork = forkTableA.FindForkByDocumentId(lDocIdB);
	if (iFork.IsEnd())
		FFThrowMiscUnknown();
	// _xZkqqHx_iCgAiCmMiOhNiCgBiCmJiKnGiClHiCoJjFkKiKpCiPoOjFpBiCpAiNoNiPjMiBeC_xHqqkZx_
	forkTableA.Remove(iFork);

	// _xZkqqHx_iOhNiCgBiCmMiImKjChFiChH_xHqqkZx_(_xZkqqHx_iNmFiPiJ_xHqqkZx_)_xZkqqHx_iCkJiCoHiNmFiMoDiCnMiCmFiCpAiOhNiCgAiCmJjCmHiJmBiBeC_xHqqkZx_
	if (!CopyBranch(project,
					lDocIdB,
					lDocIdA,
					fliSessionIndexX,
					lockBank,
					TRUE,					// _xZkqqHx_iImKjChFiChHiCmMjFkKiKpCiCpAiCgAiCnGiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
					TRUE))					// _xZkqqHx_iImKjChFiChHiCmMiOjOiKnEiDiJiDhIiDiLiCpAiCgAiCnGiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
		return FD_DRR_ERR;

//----- 06.04.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCgBiCmMiPoOjFpBiCpAiBeBiImKjChFiChHiCmMjHjKjHpAjFkKiKpCiDfOiDePiCmGiClFiCmEjDgPjIfOiClHiCoJiBeC_xHqqkZx_
	if (!forkTableA.IsThereHiForkTag(fliSessionIndexX))
	//---- _xZkqqHx_iImKjChFiChHiCmJjHjKjHpAjFkKiKpCiDfOiDePiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// CopyBranch_xZkqqHx_iKnGjAjEiCmFiImKjChFiChHiCmJjHjKjHpAjFkKiKpCiDfOiDePiCkKiDfCiDhDiBfLiClDiCoKiClNiJmCjEfMjAkLiCoA_xHqqkZx_
		// _xZkqqHx_iCkAiCoJiCmMiCmFiBeBjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmMiCnNjDgPjIfOiClHiCoJiBeC_xHqqkZx_

		// _xZkqqHx_jHjKjHpAjFlGiPjBiCgBiCmMiPoOjFpBiCpAiBeBiImKjChFiChHiCmMjHjKjHpAjFkKiKpCiDfOiDePiCmGiClFiCmEjDgPjIfOiClHiCoJiBeC_xHqqkZx_
		FCHiDocumentRec hiDocRecB = project.GetDocumentRec(lDocIdB);
		forkTableA.AppendHiForkTag(	fliSessionIndexX,			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
									hiDocRecB.GetDate(),		// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
									hiDocRecB.GetHtreeScore(),	// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
									hiDocRecB.GetUserId(),		// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
									hiDocRecB.GetDocTitle(),	// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
									hiDocRecB.GetComment());	// _xZkqqHx_iDfCiDiBiDjDiDgHjDoAjHgFiBeC_xHqqkZx_
	}
//----- 06.04.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jFlGiPjBiCgBiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	project.UnregisterDocument(lDocIdB);

	if (GetIsDocumentOpened())
	//----- _xZkqqHx_jFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// m_pGate_xZkqqHx_iBeF_xHqqkZx_m_historyIndex _xZkqqHx_jFmPjAjEiCpAiOgHiCoNiClIiCmJiBeBiDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiBeFiDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiL_xHqqkZx_
		// _xZkqqHx_iCpAjFnCiPfHiClFiClNiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
		// m_pGate_xZkqqHx_iBeF_xHqqkZx_m_historyIndex _xZkqqHx_jFmPjAjEiCmGiJlMjBhKiDgFiBfLiDhFiDiLiCmJjAeIiCkCiIoBiCkCiCkKjAlGiClGiCoJiCmMiCmF_xHqqkZx_
		// _xZkqqHx_jElNiJgGiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		// m_pGate->GetNextRecordIndex() _xZkqqHx_iCoGiCoIiMoDiCoLiCmMiPeDjAlDiCmIiCmMiCmFiDeKiDeFiDjDiDfOiDiKiDfKiDgCiDgHiCmMiCnNiCmF_xHqqkZx_
		// _xZkqqHx_jGoCjBoIiCmIiCkCiBeC_xHqqkZx_
		if (m_pGate->IsVirtualTableRecordModified())
			m_pGate->ResetVirtualTableIdentifier();
		if (m_historyIndex.IsVirtualTableRecordModified())
			m_historyIndex.ResetVirtualTableIdentifier();

		// m_forkFile,m_spotFile_xZkqqHx_jDjJiCmNiBeBjFmPjAjEiCmGiJlMjBhKiDgFiBfLiDhFiDiLiCmJjAeIiCkCiIoBiCkCiCkKjAlGiClGiCmEiCoA_xHqqkZx_
		// ID_DREQ_UPDATE_FORK_xZkqqHx_jDjJiCmF_xHqqkZx_UpdateData_xZkqqHx_iCkKiOkJjDkOjDeJiCmJiOmAiNhDiClDiCoKiCoJiClNiCnPjGoCjBoIiCmIiCkCiBeC_xHqqkZx_
	}

	//----- DSM_xZkqqHx_jHjKjHpAiCpAjFoCjAlDiClHiCoJ_xHqqkZx_ -----
	vector< auto_ptr<FCDsmRec> >::iterator iHrec;
	for (iHrec = m_vDsmHistory.begin(); iHrec != m_vDsmHistory.end(); iHrec++)
	{
		if ((*iHrec)->m_hstrProjectFilePath == HString(wstrProjectPath))
		//----- _xZkqqHx_jDkPiClGiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (lDocIdB != -1 && (*iHrec)->m_lDocumentId == lDocIdB)
			//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmJjHjKjHpAiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ ----
			{
				(*iHrec)->m_lDocumentId = lDocIdA;
			}
			// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCoGiCoIiCoAiJlKiCmMjHjKjHpAiCmNiBeB_xHqqkZx_BranchAToC _xZkqqHx_iCmFjFoCjAlDiNmPiCnNiBeC_xHqqkZx_
		}
	}
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
	// _xZkqqHx_iNmEjDhIjFlGiPjBiCpAiKeKiCkNiBeC_xHqqkZx_
	if (g_pProject->IsProjectOpened() &&
		g_pProject->GetFilePath() == wstrProjectPath &&
		!GetIsDocumentOpened())
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (!ret.IsNullHidocumentIdOld() &&
			!ret.IsNullSessionIndexOld() &&
			(ret.GetHidocumentIdOld() == lDocIdA ||
			 ret.GetHidocumentIdOld() == lDocIdB))
		//----- _xZkqqHx_iImIjBePiKeKiCkCiCmEiCkCiClNjHjKjHpAjFlGiPjBiCmMiPoOjFpBiCkKiOgDiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			long lNewDocId = ret.GetHidocumentIdOld();
			if (lNewDocId == lDocIdB)
			//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAiCpAiKeKiCkCiCmEiCkCiClNiPoKiNiH_xHqqkZx_ -----
			{
				lNewDocId = lDocIdA;
			} else
			if (lNewDocId == lDocIdA &&
				fliSessionIndexX < ret.GetSessionIndexOld())
			//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCoGiCoIiCoAiJlKiCmJjHjKjHpAiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
			{
				lNewDocId = lDocIdC;
			}
			// _xZkqqHx_jFlGiPjBiCpAiKeKiCkNiBeC_xHqqkZx_CopyRecord_xZkqqHx_iCmJiCoGiCoJiPeJjCfLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiClNiCnPiBeB_xHqqkZx_
			// _xZkqqHx_jFeLiClIiDhEiDiJiDgCiDfGiDiFiCmMiMoDiCmJiOmAiNhDiClHiCoJiClBiCmGiBeC_xHqqkZx_
			InsertDocRequest(2, ID_DREQ_OPEN_HIDOCUMENT,
								FCReqBase::IS_USE_LAST_CANVAS_STAT, TRUE,
								FCReqBase::IS_REDRAW, FALSE,							// _xZkqqHx_iNmEjFgAiJoGiBeI_xHqqkZx_
								FCReqBase::HIDOCUMENT_ID, lNewDocId,
								FCReqBase::SESSION_INDEX, ret.GetSessionIndexOld(),
								FCReqBase::NONE);
		}
	}
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpA_xHqqkZx_1_xZkqqHx_iCmMiImKjChF_xHqqkZx_X_xZkqqHx_iCoGiCoIiJlKiCpAjHjKjHpA_xHqqkZx_3_xZkqqHx_iCmJjFmPiNfIiClFiBeBjHjKjHpA_xHqqkZx_2_xZkqqHx_iCpAjHjKjHpA_xHqqkZx_1_xZkqqHx_iCmJjFmPiNfI_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_CHANGE_BRANCH_1_TO_3_X_2_TO_1,
//						FCReqBase::HIDOCUMENT_ID, lDocIdA,
//						FCReqBase::HIDOCUMENT_ID_2, lDocIdB,
//						FCReqBase::SESSION_INDEX, iFork.GetSessionIndex(),
//						FCReqBase::NONE);
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return FD_DRR_OK;
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistViewDoc::OnReqChangeBranchIntoTrunk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqChangeTrunkIntoBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_CHANGE_TRUNK_INTO_BRANCH]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iClBiClBiCoGiCoIiJlKiCmMjHjKjHpAiCpAiJlKjHkMiCmMiOhNiCmJjFmPiNfIiClHiCoJ_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAiOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiChHiCoGiCoIiJlKjFjEjFkKiCpAiBeBjHjKjHpAiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmGiClFiCmEjFkKiKpCiClDiClJiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCgAiCmMiImKjChFiChHiCoGiCoIiJlKiCmNiNoNiPjMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *                    _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_-_xZkqqHx_iChH_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iBkL_xHqqkZx_
 *                    _xZkqqHx_iCgA_xHqqkZx_
 *
 *                 _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *               _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                  _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *                    _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkBiEjPiEjPiEjPiEkDiChH_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *            _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *            _xZkqqHx_iCgC_xHqqkZx_      _xZkqqHx_iCgA_xHqqkZx_
 *
 *			------------------------------------------------------
 *			_xZkqqHx_iCgAiCmMiImKjChFiChHiCmJjFkKiKpCiCgEiCkKiCkAiCoJiPoKiNiHiBeBjFkKiKpCiCgEiCmNiCgAiCmJiOgDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iImKjChFiChHiCoGiCoIiJlKiCmMjFkKiKpCiCmNiBeBiCgCiCmJiInKjDkOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *                    _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ _xZkqqHx_iChH_xHqqkZx_
 *                    _xZkqqHx_iEkAiBfO_xHqqkZx_
 *                    _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iCgE_xHqqkZx_
 *                    _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                    _xZkqqHx_iCgA_xHqqkZx_
 *     
 *                 _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *               _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                  _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *                    _xZkqqHx_iCgA_xHqqkZx_
 *                    _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ _xZkqqHx_iChH_xHqqkZx_
 *                    _xZkqqHx_iEkAiBfO_xHqqkZx_
 *            _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEkC_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iCgE_xHqqkZx_
 *            _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *            _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *            _xZkqqHx_iCgC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqChangeTrunkIntoBranch (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.02.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	FD_CHECK_QUALIFICATION(g_pProject);
//
//	// _xZkqqHx_iMlLiNnNiImKjChFiCmGiOhHjCoIiCmMiImKjChFiCkKiIoKjChGiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
//	if (wcsicmp(g_pProject->GetFilePath(), ret.GetProjectPath()) != 0 ||
//		GetDocumentId() != ret.GetHidocumentId() ||
//		GetNextSessionIndex() != ret.GetSessionIndex())
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
//		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
//		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
//		return FD_DRR_ERR;
//	}
//
//	if (!m_spotFile.IsThereSpot(ret.GetSessionIndex()) &&
//		!m_forkFile.IsThereRegalFork(ret.GetSessionIndex()))
//	//----- _xZkqqHx_iMlLiNnNiImKjChFiCmJiDfIiDhMiDgCiDgHiBeBjHjKjHpAjFkKiKpCiCmGiCoAiCmJjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjFnLjBlGiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
//		InsertDocRequest(0, ID_DREQ_SAVE_SPOT_FILE);
//		return FD_DRR_RETRY;	// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiMhAjBlBiClHiCoJiPoKiNiHiBeC_xHqqkZx_
//	}
//
//	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpA_xHqqkZx_1_xZkqqHx_iCmMiImKjChF_xHqqkZx_X_xZkqqHx_iCoGiCoIiJlKiCpAjHjKjHpA_xHqqkZx_3_xZkqqHx_iCmJjFmPiNfIiClFiBeBjHjKjHpA_xHqqkZx_2_xZkqqHx_iCpAjHjKjHpA_xHqqkZx_1_xZkqqHx_iCmJjFmPiNfI_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_CHANGE_BRANCH_1_TO_3_X_2_TO_1,
//						FCReqBase::HIDOCUMENT_ID_2, -1,
//						FCReqBase::NONE);
//----- 06.02.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_g_pFileServer->FlushAll _xZkqqHx_iCpAiOjNiCmCiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPiIjHjN_xHqqkZx_
	// _xZkqqHx_iCmMjDkKjBfDiCmEiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiPoKiNiHiCmNiBeBjHjKjHpAjFlGiPjBiCmMiDhEiDiJiDgCiDfGiDiFiCpAiOmAiNhDiBeC_xHqqkZx_
	if (OnReqCheckFlush()) return FD_DRR_RETRY;

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	FD_CHECK_QUALIFICATION(g_pProject);

	// _xZkqqHx_iMlLiNnNiImKjChFiCmGiOhHjCoIiCmMiImKjChFiCkKiIoKjChGiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	if (wcsicmp(g_pProject->GetFilePath(), ret.GetProjectPath()) != 0 ||
		GetDocumentId() != ret.GetHidocumentId() ||
		GetNextSessionIndex() != ret.GetSessionIndex())
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
		return FD_DRR_ERR;
	}

	FCDbLockBank lockBank;
	// _xZkqqHx_iOhNiCgAiCmMjFlGiPjBiDgFiBfLiDhFiDiLiCpAjBfDiCmE_xHqqkZx_Read|Write_xZkqqHx_iDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	FTDocReqResult result = myLockAllLower(	lockBank,
											g_pProject->GetFilePath(),
											GetDocumentId(),
											GetNextSessionIndex(),
											FALSE);
	if (result != FD_DRR_OK) return result;

//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (!reqLock.TryAndCopyLock(FCReqLock::ALL, lockBank))
//		return FD_DRR_LATER;
//
//	// _xZkqqHx_iOhNiCgAiCmMiImKjChFiChHiCoGiCoIiJlKiCkJiCoHjFkKiKpCiClHiCoJjFlGiPjBiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpA_xHqqkZx_
//	// Read|Write_xZkqqHx_iDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	FCHiForkTable forkFileA = g_pProject->GetSubGroup(GetDocumentId());
//	forkFileA.UpdateData(reqLock.m_autoLockForkRead);
//	FCForkConstIterator iFork = forkFileA.GetUpperBoundFork(GetNextSessionIndex());
//	while (!iFork.IsEnd())
//	{
//		FCDbReadLock readLockForkSub;
//		FCDbWriteLock writeLockForkSub;
//		if (!FFTryLock(	readLockForkSub,
//						writeLockForkSub,
//						g_pProject->GetSubTableName(iFork.GetDocumentId(), FDHI_FORK_TABLE_ID)))
//			return FD_DRR_LATER;
//		lockBank.Append(readLockForkSub);
//		lockBank.Append(writeLockForkSub);
//		iFork++;
//	}
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiDfKiBfLiDhFiClHiCoJiBeC_xHqqkZx_
	BYTE* pSpotStream;
	DWORD dwSpotStreamSize;
	FC2Ref<BYTE*, DWORD>(pSpotStream, dwSpotStreamSize) = FFExportSpotFile(this);
	long lDocIdC = BranchAToC(	*g_pProject,
								GetDocumentId(),
								GetNextSessionIndex(),
								lockBank,
								pSpotStream,
								dwSpotStreamSize,
								TRUE,					// _xZkqqHx_iCgAiCmMiPeJjCfLiImKjChFiDgFiBfLiDhFiDiLiCpAiChHiCmJjAnNjCoIiClHiCoJiCkJiBeI_xHqqkZx_
								FALSE,					// _xZkqqHx_iImKjChFiChHiCmMjFkKiKpCiCpAiCgCiCnGiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
								TRUE);					// _xZkqqHx_iImKjChFiChHiCmMiOjOiKnEiDiJiDhIiDiLiCpAiCgCiCnGiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
	// _xZkqqHx_iDfIiDhMiDgCiDgHiDfIiDgHiDiKiBfLiDiAiCpAiJpAjFpKiBeC_xHqqkZx_
	::free(pSpotStream);
	if (lDocIdC == -1)
		return FD_DRR_ERR;

	if (GetIsDocumentOpened())
	//----- _xZkqqHx_jFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// m_pGate_xZkqqHx_iBeF_xHqqkZx_m_historyIndex _xZkqqHx_jFmPjAjEiCpAiOgHiCoNiClIiCmJiBeBiDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiBeFiDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiL_xHqqkZx_
		// _xZkqqHx_iCpAjFnCiPfHiClFiClNiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
		// m_pGate_xZkqqHx_iBeF_xHqqkZx_m_historyIndex _xZkqqHx_jFmPjAjEiCmGiJlMjBhKiDgFiBfLiDhFiDiLiCmJjAeIiCkCiIoBiCkCiCkKjAlGiClGiCoJiCmMiCmF_xHqqkZx_
		// _xZkqqHx_jElNiJgGiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		// m_pGate->GetNextRecordIndex() _xZkqqHx_iCoGiCoIiMoDiCoLiCmMiPeDjAlDiCmIiCmMiCmFiDeKiDeFiDjDiDfOiDiKiDfKiDgCiDgHiCmMiCnNiCmF_xHqqkZx_
		// _xZkqqHx_jGoCjBoIiCmIiCkCiBeC_xHqqkZx_
		if (m_pGate->IsVirtualTableRecordModified())
			m_pGate->ResetVirtualTableIdentifier();
		if (m_historyIndex.IsVirtualTableRecordModified())
			m_historyIndex.ResetVirtualTableIdentifier();

		// m_forkFile,m_spotFile_xZkqqHx_jDjJiCmNiBeBjFmPjAjEiCmGiJlMjBhKiDgFiBfLiDhFiDiLiCmJjAeIiCkCiIoBiCkCiCkKjAlGiClGiCmEiCoA_xHqqkZx_
		// ID_DREQ_UPDATE_FORK_xZkqqHx_jDjJiCmF_xHqqkZx_UpdateData_xZkqqHx_iCkKiOkJjDkOjDeJiCmJiOmAiNhDiClDiCoKiCoJiClNiCnPjGoCjBoIiCmIiCkCiBeC_xHqqkZx_
	}

	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
//----- 06.02.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqChangeTrunkIntoBranch.

//----- 06.02.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqChangeBranch1To3X2To1
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_CHANGE_BRANCH_1_TO_3_X_2_TO_1]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpA_xHqqkZx_1_xZkqqHx_iCmMiImKjChF_xHqqkZx_X_xZkqqHx_iCoGiCoIiJlKiCpAjHjKjHpA_xHqqkZx_3_xZkqqHx_iCmJjFmPiNfIiClFiBeBjHjKjHpA_xHqqkZx_2_xZkqqHx_iCpAjHjKjHpA_xHqqkZx_1_xZkqqHx_iCmJjFmPiNfI_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAiCfAiCmMiImKjChFiChHiCkJiCoHiJlKiCpAiBeBjAfGiClFiCkNiNoMiCmBiClNjHjKjHpAiCfCiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_jHjKjHpAiCfBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBjHjKjHpAiCfBiCpAjHjKjHpAiCfAiCmMiImKjChFiChHiImIiJlKiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iCgAiCmN_xHqqkZx_ret.GetHidocumentId()_xZkqqHx_iBeBiCgBiCmN_xHqqkZx_ret.GetHidocumentId2()_xZkqqHx_iCmF_xHqqkZx_
// *			_xZkqqHx_iOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_jBoFiCkLiCmIjHjKjHpAiCmMjFkBiOmKiBeBiInKjDkOiCmNiOjOiKnEiCkKiCkJiCkJiCoJiClNiCnPiBeBiJlMjFlGiPjBiCpAjFnLjBlGiClFiCmEiCkIiCkCiCmEiBeB_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLjFkBiOmKjCiGiCmNiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiOgEjHgMiCpAiNgMiCkGiClNiCmMiClOiCkKiBeB_xHqqkZx_
// *			_xZkqqHx_jBfDjFjEiCmMjAkOiNiHjAkLiCpAjFnLiCmCiClNiCnPiCmJiCmNiBeBiNmFiMoDiCmMiDhEiDiJiDgCiDfGiDiFiCmFiDhEiDeAiDeDiDiLiInKjDkOiBhL_xHqqkZx_
// *			_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiJlMjFlGiPjBiCpAjAlDjFlGiPjBiCnGjFmPiNfI_xHqqkZx_ _xZkqqHx_iCpAiDfKiDgCiDgHiCmFiNhDiCoNiCmIiCkNiCmEiCmNiCmIiCoHiClIiBeB_xHqqkZx_
// *			_xZkqqHx_iNmFiMoDiCmMiDhEiDiJiDgCiDfGiDiFiOjOiCmJiCoAiDhGiDiNiDfHiDeGiDeOiDgHiCmNiPjBiCkLiNjOiCnMiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
// *			_xZkqqHx_iNmFiMoDiCmMiDhEiDiJiDgCiDfGiDiFiCmNjBoFiCkLiCmIiOjOiKnEiCpAjAoIiCnPiCoJiClNiCnPiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCpAjDhCjCiGiCmF_xHqqkZx_
// *			_xZkqqHx_iDiNiDgCiDeOiJpAiPjMiClFiCmEiCoAiCkAiCnMiCoIiInDjGkBiCkKiCmIiCkCiBeC_xHqqkZx_
// *			_xZkqqHx_iCnOiClFiCoLiBeBiNmEiDiNiDgCiDeOiCkKiPgPjHiIiCmIiCkJiCmBiClNiDiNiDfIiCmGiDiKiDfIiDeOiCpAiNgMiCkGiCoJiCmGiBeB_xHqqkZx_
// *			_xZkqqHx_iClIiCmBiCmG_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiInLiOjNiClFiClNjFpLiCkKjHmHiCkCiBeC_xHqqkZx_
// *
// * --------- _xZkqqHx_jHjKjHpAjFkKiKpCiCgBiCmMiOhHjCoIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ ----------
// *
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *                  _xZkqqHx_iEkAiChH_xHqqkZx_
// *          _xZkqqHx_iEkBiBgDiBgDiBgDiEkFiEjPiEjPiEjPiEkC_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *          _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_     2(B)
// *         3(C)    1(A)
// *
// *                _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_     
// *              _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_   
// *               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_    
// *                 _xZkqqHx_iBfPiBfO_xHqqkZx_      
// *   
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *                  _xZkqqHx_iEkAiChH_xHqqkZx_
// *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkHiBgDiBgDiBgDiEkC_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iBkL_xHqqkZx_     1(A)    2(B)
// *         3(C)    _xZkqqHx_iMlD_xHqqkZx_B
// *         _xZkqqHx_iMlD_xHqqkZx_A
// *
// * --------- _xZkqqHx_jHjKjHpAjFkKiKpCiCgBiCmMiOhHjCoIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ ----------
// *
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkBiBgDiBgDiBgDiEkAiChH_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *         3(C)    1(A)
// *
// *                _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_     
// *              _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_   
// *               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_    
// *                 _xZkqqHx_iBfPiBfO_xHqqkZx_      
// *   
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkDiChH_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *         3(C)    1(A)
// *         _xZkqqHx_iMlD_xHqqkZx_A
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqChangeBranch1To3X2To1 (FCReqBase& ret, FCReqLock& reqLock)
//{
//	// _xZkqqHx_jHjKjHpAiCfAiBiBiCgAiBeBjHjKjHpAiCfBiBiBiCgBiBeBjHjKjHpAiCfCiBiBiCgCiCmGiClHiCoJiBeC_xHqqkZx_
//
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_g_pFileServer->FlushAll _xZkqqHx_iCpAiOjNiCmCiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPiIjHjN_xHqqkZx_
//	// _xZkqqHx_iCmMjDkKjBfDiCmEiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiPoKiNiHiCmNiBeBjHjKjHpAjFlGiPjBiCmMiDhEiDiJiDgCiDfGiDiFiCpAiOmAiNhDiBeC_xHqqkZx_
//	if (OnReqCheckFlush()) return FD_DRR_RETRY;
//
//	long lDocIdA = ret.GetHidocumentId();
//	long lDocIdB = ret.GetHidocumentId2();
//	long lDocIdC;
//
//	if (GetIsDocumentOpened())
//	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (wcscmp(g_pProject->GetFilePath(), ret.GetProjectPath()) == 0 &&
//			(GetDocumentId() == lDocIdA || GetDocumentId() == lDocIdB))
//		//----- _xZkqqHx_iNkBiKeKiCkCiCmEiCkCiCoJjFlGiPjBiCkKiOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iIlNiCkCiCmNiOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjApMiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCnMiClIiBeBjFlGiPjBiCpAjFmCiClGiCoJiBeCiMoDiCmFiKeKiCkCiCmEiCkCiClNjFlGiPjBiCmMiImKjChFiCkK_xHqqkZx_
//			// _xZkqqHx_iOoGiCoIiPgPiClJiCoJiCoGiCkEiCmJiBeB_xHqqkZx_OLD_xZkqqHx_jFmPjAjEiCmJjAnNjCoIiBeC_xHqqkZx_
//			InsertDocRequest(0, ID_DREQ_CLOSE_HIDOCUMENT,
//								FCReqBase::HIDOCUMENT_ID_OLD, GetDocumentId(),				// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//								FCReqBase::SESSION_INDEX_OLD, GetNextSessionIndex(),		// _xZkqqHx_jFlGiPjBiImKjChFiBeC_xHqqkZx_
//								FCReqBase::NONE);
//			return FD_DRR_RETRY;	// _xZkqqHx_jDkPiClGiPiIjHjNiCpAiMhAjBlBiClHiCoJiPoKiNiHiBeC_xHqqkZx_
//		}
//	}
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpA_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiClFiBeBiDgGiBfLiDfOiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	FCDbReadLock autoLockProjectRead;
//	FCHiProject project;
//	FTDocReqResult result = OnReqLockAndUpdate(	ret.GetProjectPath(),
//												-1,
//												autoLockProjectRead,
//												project);
//	if (result != FD_DRR_OK) return result;
//
////----- 05.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	FD_CHECK_QUALIFICATION(&project);
////----- 05.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpA_xHqqkZx_Write_xZkqqHx_iDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbWriteLock autoLockProjectWrite(ret.GetProjectPath(), FALSE);
//	if (!autoLockProjectWrite.TryLock()) return FD_DRR_LATER;
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiBeBiDhGiDiNiDfHiDeGiDeOiDgHiImIiKePiCpAjBfDiCmEiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCReqLock reqLockA(project.GetFilePathH(), lDocIdA);
//	if (!reqLockA.TryLock(FCReqLock::ALL & ~(FCReqLock::PROJECT_READ|FCReqLock::PROJECT_WRITE)))
//		return FD_DRR_LATER;
//
//	FCReqLock reqLockB;
//	if (lDocIdB != -1)
//	//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMiBeBiDhGiDiNiDfHiDeGiDeOiDgHiImIiKePiCpAjBfDiCmEiDiNiDgCiDeOiBeC_xHqqkZx_
//		reqLockB.Initialize(project.GetSubTableName(DWORD(lDocIdB)));
//		if (!reqLockB.TryLock(FCReqLock::ALL & ~(FCReqLock::PROJECT_READ|FCReqLock::PROJECT_WRITE)))
//			return FD_DRR_LATER;
//	}
//
//	flint fliSessionIndexX = ret.GetSessionIndex();
//	flint fliCmdFilePtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
//	flint fliIdxFilePtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
//	long lDocIdX;			// _xZkqqHx_iImKjChFiChHiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAiBeC_xHqqkZx_
//
//	// _xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiImKjChFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	if (!SessionIndexToPosition(&fliCmdFilePtrX,
//								&fliIdxFilePtrX,
//								&lDocIdX,
//								project,
//								lDocIdA,
//								fliSessionIndexX)) return FD_DRR_LATER;
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCHiForkTable forkFileA;
//	forkFileA = project.GetSubGroup(lDocIdA);
//	forkFileA.UpdateData(reqLockA.m_autoLockForkRead);
//
//	FCHiDocumentRec hiDocRecA = project.GetDocumentRec(lDocIdA);
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjFkKiKpCiImKjChFiCmMjHjKjHpAjFkKiKpCiDfOiDePiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//	GUID guidUserIdC;
//	FDSECTIME fdstCreateTimeC;
//	WString wstrTitleC;
//	WString wstrCommentC;
//// 05.09.16 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//	double dHtreeScoreC;
//	if (!forkFileA.IsThereHiForkTag(fliSessionIndexX,
//									&fdstCreateTimeC,
//									&guidUserIdC,
//									&wstrTitleC,
//									&wstrCommentC,
//									&dHtreeScoreC))
//	//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCmJjHjKjHpAjFkKiKpCiDfOiDePiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		fdstCreateTimeC = FFGetCurrentSecTime();
//		guidUserIdC = FFGetApp()->GetUserId();
//		wstrTitleC = hiDocRecA.GetDocTitle();
//		wstrCommentC = hiDocRecA.GetComment();
//		dHtreeScoreC = 1.0;
//	}
//
//	// _xZkqqHx_jAfGiLeLjFkKiKpCjHjKjHpAjFlGiPjBiCpAiBeBiNkBiCmMjHjKjHpAiImKjChFiCkJiCoHjFkKiKpCiClDiClJiCmEiNoMjAkMiBeC_xHqqkZx_
//	// _xZkqqHx_iKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjFlGiPjBiCkJiCoHiBeBiDiGiDgKiBfLiDeOiCmIiDgPiBfLiDfHiDiHiDjDiCpAiNoMjAkMiBeC_xHqqkZx_
//	WString wstrVersionC = project.GetUniqSubDocumentVersion(lDocIdA);
//	// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjDgPjIfOiBeC_xHqqkZx_
//	lDocIdC = project.RegisterDDDocument(	wstrTitleC,
//											guidUserIdC,
//											wstrVersionC,
//											fdstCreateTimeC,
//											wstrCommentC,
//											hiDocRecA.GetIsLogCommandUserId(),
//											lDocIdA,
//											dHtreeScoreC);
////----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
////	(void)project.UpdateFile(autoLockProjectWrite);
////----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiNoMjAkMiBeCjCmKiPoNiCmN_xHqqkZx_ "_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_\_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_ID"_xZkqqHx_iBeC_xHqqkZx_
//	WString wstrDirPathC = project.GetDocumentDirectory(lDocIdC);
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
//	if (!g_pFileServer->CreateDirectory(NULL, wstrDirPathC))
//	//----- _xZkqqHx_iOhHjCoIiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCkKiNoMjAkMiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
//		// IDS_ERR_FILE_NOT_CREATE_DIRECTORY = "_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKiNoMjAkMiCmFiCkLiCnMiClJiCpBiBeC_xHqqkZx_"
//		FFSetDDError(IDS_ERR_FILE_NOT_CREATE_DIRECTORY);
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiBeBiDhGiDiNiDfHiDeGiDeOiDgHiImIiKePiCpAjBfDiCmEiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCReqLock reqLockC(project.GetFilePathH(), lDocIdC);
//	if (!reqLockC.TryLock(FCReqLock::ALL & ~(FCReqLock::PROJECT_READ|FCReqLock::PROJECT_WRITE)))
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//
//	if (forkFileA.IsThereHiForkTag(fliSessionIndexX, NULL, NULL, NULL))
//	//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCmJjHjKjHpAjFkKiKpCiDfOiDePiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_jHfMiCnPiNoNiPjMiClFiCmEiCkIiCkJiCmIiCkCiCmGiBeB_xHqqkZx_MoveToTrunkFork_xZkqqHx_iCmFiDeHiDiJiBfLiCkKjEkNjAlGiBeC_xHqqkZx_
//		forkFileA.Remove(forkFileA.FindHiForkTag(fliSessionIndexX));
//// 06.01.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////		forkFileA.UpdateFile(reqLockA.m_autoLockForkWrite);
//	}
//	// _xZkqqHx_jDfNjBjHiClHiCoJiDhEiDeAiDeDiDiLiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
//	flint fliTotalSize = CalcHidocumentSize(project, lDocIdA, fliSessionIndexX, fliCmdFilePtrX, fliIdxFilePtrX);
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiDiNiDgCiDeOiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
//	if (fliTotalSize == -1)
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiJmBiOfKiBeC_xHqqkZx_
//	if (lDocIdB != -1)
//	{
//		const flint fliTmpSize = CalcHidocumentSize(project, lDocIdB);
//		// _xZkqqHx_iDhEiDeAiDeDiDiLiDiNiDgCiDeOiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
//		if (fliTmpSize == -1)
//		{
//			AfxDebugBreak();
//			return FD_DRR_FATAL_ERR;
//		}
//		fliTotalSize += fliTmpSize;
//	}
//	// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjFfMiOkGiBeC_xHqqkZx_
//	g_pFileServer->ShowProgressBar(fliTotalSize * 2);
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiBeBiImKjChFiChHiCkJiCoHiNmFiMoDiCnMiCmFiCpAiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmJiInKjDkOiBeC_xHqqkZx_
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
//
//	if (!MoveToBranchCommandFile(project, lDocIdA, lDocIdC, fliSessionIndexX, fliCmdFilePtrX, fliIdxFilePtrX))
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmMiBeBiImKjChFiChHiCkJiCoHiNmFiMoDiCnMiCmFiCpAiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmJiInKjDkOiBeC_xHqqkZx_
//	if (!MoveToBranchSpot(project, lDocIdA, lDocIdC, lDocIdX, fliSessionIndexX, fliCmdFilePtrX, fliIdxFilePtrX))
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCmMiBeBiImKjChFiChHiCkJiCoHiNmFiMoDiCnMiCmFiCpAiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmJiInKjDkOiBeC_xHqqkZx_
//	if (!MoveToBranchFork(project, lDocIdA, lDocIdC, fliSessionIndexX, fliCmdFilePtrX, fliIdxFilePtrX))
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//
//	if (lDocIdB != -1)
//	//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMjBfDiCmEiCpAiBeBiOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCmJiInKjDkOiBeC_xHqqkZx_
////----- 04.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
////		if (!MoveToTrunkCommandFile(&m_wstrReqErrMessage, project, lDocIdB))
////			return FD_DRR_FATAL_ERR;
////		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmMjBfDiCmEiCpAiBeBiOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCmJiInKjDkOiBeC_xHqqkZx_
////		if (!MoveToTrunkSpot(&m_wstrReqErrMessage, project, lDocIdB))
////			return FD_DRR_FATAL_ERR;
////		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCmMjBfDiCmEiCpAiBeBiOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCmJiInKjDkOiBeC_xHqqkZx_
////		if (!MoveToTrunkFork(&m_wstrReqErrMessage, project, lDocIdB))
////			return FD_DRR_FATAL_ERR;
////----- 04.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
//		if (!MoveToTrunkCommandFile(project, lDocIdA, lDocIdB, fliSessionIndexX))
//		{
//			AfxDebugBreak();
//			return FD_DRR_FATAL_ERR;
//		}
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmMjBfDiCmEiCpAiBeBiOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCmJiInKjDkOiBeC_xHqqkZx_
//		if (!MoveToTrunkSpot(project, lDocIdA, lDocIdB,
//							 fliSessionIndexX, fliCmdFilePtrX, fliIdxFilePtrX))
//		{
//			AfxDebugBreak();
//			return FD_DRR_FATAL_ERR;
//		}
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCmMjBfDiCmEiCpAiBeBiOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCmJiInKjDkOiBeC_xHqqkZx_
//		if (!MoveToTrunkFork(	project, lDocIdA, lDocIdB,
//							 fliSessionIndexX, fliCmdFilePtrX, fliIdxFilePtrX))
//		{
//			AfxDebugBreak();
//			return FD_DRR_FATAL_ERR;
//		}
////----- 04.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	}
//
//	// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAiJeCiClHiBeC_xHqqkZx_
//	g_pFileServer->HideProgressBar();
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_MoveXXX_xZkqqHx_iCmFiNfIjAfGiClDiCoKiCmEiCkCiCoJiCmNiClIiBeC_xHqqkZx_
//	forkFileA.UpdateData(reqLockA.m_autoLockForkRead);
//
//	if (lDocIdB != -1)
//	//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCmJiBeBjHjKjHpAjFlGiPjBiCgBiCmMiPoOjFpBiCpAjHjKjHpAjFkKiKpCiDfOiDePiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
//		FCHiDocumentRec hiDocRecB = project.GetDocumentRec(lDocIdB);
//		forkFileA.AppendHiForkTag(	fliSessionIndexX,			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//									hiDocRecB.GetDate(),		// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
//									hiDocRecB.GetUserId(),		// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//									hiDocRecB.GetDocTitle(),	// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
//									hiDocRecB.GetComment(),		// _xZkqqHx_iDfCiDiBiDjDiDgHjDoAjHgFiBeC_xHqqkZx_
//									hiDocRecB.GetHtreeScore());	// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiCkJiCoHiBeBiOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
//// 06.01.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		forkFileA.RemoveFork(lDocIdB);
//		forkFileA.Remove(forkFileA.FindForkByDocumentId(lDocIdB));
//	}
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiCmJiBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
//	forkFileA.AppendFork(	fliSessionIndexX,
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////							fliCmdFilePtrX,
////							fliIdxFilePtrX,
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//							lDocIdC);
//// 06.01.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	forkFileA.UpdateFile(reqLockA.m_autoLockForkWrite);
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiNmFjAfGiCmMiPpDjBnEiCmJiBeC_xHqqkZx_MoveFork_xZkqqHx_jDjJiCmFiDhGiDiNiDfHiDeGiDeOiDgHiCkKiPeDjAlDiClDiCoKiCmEiCkCiCoJiClNiCnPiBeC_xHqqkZx_
//	project.UpdateData(autoLockProjectRead);
//	if (lDocIdB != -1)
//	//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
//		project.UnregisterDocument(lDocIdB);
//	}
//// 06.01.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	project.UpdateFile(autoLockProjectWrite);
//
//	//----- DSM_xZkqqHx_jHjKjHpAiCpAjFoCjAlDiClHiCoJ_xHqqkZx_ -----
//	vector< auto_ptr<FCDsmRec> >::iterator iHrec;
//	for (iHrec = m_vDsmHistory.begin(); iHrec != m_vDsmHistory.end(); iHrec++)
//	{
//		if ((*iHrec)->m_hstrProjectFilePath == project.GetTableName().GetTopDirPath())
//		//----- _xZkqqHx_jDkPiClGiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			if (lDocIdB != -1 && (*iHrec)->m_lDocumentId == lDocIdB)
//			//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmJjHjKjHpAiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ ----
//			{
//				(*iHrec)->m_lDocumentId = lDocIdA;
//			} else
//			if ((*iHrec)->m_lDocumentId == lDocIdA &&
//				fliSessionIndexX < (*iHrec)->m_fliSessionIndex)
//			//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCoGiCoIiCoAiJlKiCmJjHjKjHpAiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
//			{
//				(*iHrec)->m_lDocumentId = lDocIdC;
//			}
//		}
//	}
//
//	//----- _xZkqqHx_iNmEjDhIiKeKiCkNjFlGiPjBiCpAjFoCjAlDiClHiCoJ_xHqqkZx_ -----
//	if (g_pProject->IsProjectOpened() && !GetIsDocumentOpened())
//	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (!ret.IsNullHidocumentIdOld() &&
//			!ret.IsNullSessionIndexOld())
//		//----- _xZkqqHx_iImIjBePiKeKiCkCiCmEiCkCiClNjHjKjHpAjFlGiPjBiCmMiPoOjFpBiCkKiOgDiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			long lNewDocId = ret.GetHidocumentIdOld();
//			if (lDocIdB != -1 && ret.GetHidocumentIdOld() == lDocIdB)
//			//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAiCpAiKeKiCkCiCmEiCkCiClNiPoKiNiH_xHqqkZx_ -----
//			{
//				lNewDocId = lDocIdA;
//			} else
//			if (ret.GetHidocumentIdOld() == lDocIdA &&
//				fliSessionIndexX < ret.GetSessionIndexOld())
//			//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCoGiCoIiCoAiJlKiCmJjHjKjHpAiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
//			{
//				lNewDocId = lDocIdC;
//			}
//			// _xZkqqHx_jFlGiPjBiCpAiKeKiCkNiBeC_xHqqkZx_
//			InsertDocRequest(1, ID_DREQ_OPEN_HIDOCUMENT,
//								FCReqBase::HIDOCUMENT_ID, lNewDocId,
//								FCReqBase::SESSION_INDEX, ret.GetSessionIndexOld(),
//								FCReqBase::NONE);
//		}
//	}
//	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
//	return FD_DRR_OK;
//} // CFCHistViewDoc::OnReqChangeBranch1To3X2To1.
//----- 06.02.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqChangeBranchIntoTop
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_CHANGE_BRANCH_INTO_TOP]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAiOhNiCpAiDhGiDiNiDfHiDeGiDeOiDgHjClMiJlKiCmJjFmPiNfIiClHiCoJ_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqChangeBranchIntoTop (FCReqBase& ret, FCReqLock& reqLock)
{
	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_g_pFileServer->FlushAll _xZkqqHx_iCpAiOjNiCmCiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPiIjHjN_xHqqkZx_
	// _xZkqqHx_iCmMjDkKjBfDiCmEiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiPoKiNiHiCmNiBeBjHjKjHpAjFlGiPjBiCmMiDhEiDiJiDgCiDfGiDiFiCpAiOmAiNhDiBeC_xHqqkZx_
	if (OnReqCheckFlush()) return FD_DRR_RETRY;

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiBeBjHjKjHpAjFkKiKpCiCpA_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiClFiBeBiDgGiBfLiDfOiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	FCDbReadLock autoLockProjectRead;
	FCDbReadLock autoLockForkRead;
//----- 06.04.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	FCDbWriteLock autoLockProjectWrite;
	FCDbWriteLock autoLockForkWrite;
//----- 06.04.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	FCHiProject project;
	FCHiForkTable forkFile;
	FTDocReqResult result = OnReqLockAndUpdate(	ret.GetProjectPath(),
												ret.GetHidocumentId(),
												autoLockProjectRead,
												&autoLockProjectWrite,
												project,
												&autoLockForkRead,
												&autoLockForkWrite,
												&forkFile);
	if (result != FD_DRR_OK) return result;

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	FD_CHECK_QUALIFICATION(&project);

	flint fliSessionIdxSuper;
	long lDocIdSuper;
	// _xZkqqHx_iPoDiImKiCmMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	forkFile.GetSuperInfo(&fliSessionIdxSuper, &lDocIdSuper);
	// _xZkqqHx_iPoDiImKiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	FCDbReadLock autoLockForkSuperRead;
//----- 06.04.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	FCDbWriteLock autoLockForkSuperWrite;
//----- 06.04.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	FCHiForkTable forkFileSuper;
	result = OnReqLockAndUpdate(NULL,
								lDocIdSuper,
								FCDbReadLock(),
								NULL,
								project,
								&autoLockForkSuperRead,
								&autoLockForkSuperWrite,
								&forkFileSuper);
	if (result != FD_DRR_OK) return result;

//----- 06.04.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiBeBjHjKjHpAjFkKiKpCiCpA_xHqqkZx_Write_xZkqqHx_iDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbWriteLock autoLockProjectWrite(project.GetTableName());
//	if (!autoLockProjectWrite.TryLock()) return FD_DRR_LATER;
//	FCDbWriteLock autoLockForkWrite(forkFile.GetTableName());
//	if (!autoLockForkWrite.TryLock()) return FD_DRR_LATER;
//	FCDbWriteLock autoLockForkSuperWrite(forkFileSuper.GetTableName());
//	if (!autoLockForkSuperWrite.TryLock()) return FD_DRR_LATER;
//----- 06.04.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iPoDiImKiCmMiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
	forkFile.SetSuperInfo(fliSessionIdxSuper, -1);
	flint fliSessionIndex = forkFileSuper.Remove(forkFileSuper.FindForkByDocumentId(ret.GetHidocumentId()));
	// _xZkqqHx_iCoAiCkEjFkKiKpCiCkKiOgDiCmBiCmEiCkIiCoHiClIiBeBjHjKjHpAjFkKiKpCiDfOiDePiCmMiCnNiOgDiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAiNoNiPjMiBeC_xHqqkZx_
	if (!forkFileSuper.IsThereRegalFork(fliSessionIndex) &&
		forkFileSuper.IsThereHiForkTag(fliSessionIndex))
		forkFileSuper.Remove(forkFileSuper.FindHiForkTag(fliSessionIndex));

	// _xZkqqHx_jFkKiKpCiCmMiBeBjAgFjHjKjHpAiCmMiPoOjFpBiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
	FCHiDocumentRecW hiDocRec = project.GetDocumentRec(ret.GetHidocumentId());
	hiDocRec.SetSuperDocId(-1);
	hiDocRec.Update();

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiImIiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqChangeBranchIntoTop.

//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqRegisterTempTimeLabel
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_REGISTER_TEMP_TIME_LABEL]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqRegisterTempTimeLabel (FCReqBase& ret, FCReqLock& reqLock)
//{
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_g_pFileServer->FlushAll _xZkqqHx_iCpAiOjNiCmCiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPiIjHjN_xHqqkZx_
//	// _xZkqqHx_iCmMjDkKjBfDiCmEiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiPoKiNiHiCmNiBeBjHjKjHpAjFlGiPjBiCmMiDhEiDiJiDgCiDfGiDiFiCpAiOmAiNhDiBeC_xHqqkZx_
//	if (OnReqCheckFlush()) return FD_DRR_RETRY;
//
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCmNiBeB_xHqqkZx_EXCLUSIVE & READ_WRITE _xZkqqHx_iCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
////----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////											FCReqLock::PROJECT_READ |
////											FCReqLock::COMMAND_READ |
////											FCReqLock::SUMMARY_READ |
////											FCReqLock::TERMINATE_READ |
////											FCReqLock::FORK_READ |
////----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//											FCReqLock::FORK_WRITE);
//	if (result != FD_DRR_OK) return result;
//
////----- 05.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	FD_CHECK_QUALIFICATION(g_pProject);
////----- 05.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iMlLiNnNiImKjChFiCmGiOhHjCoIiImKjChFiCkKiIoBiCkEiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
//	if (wcscmp(ret.GetProjectPath(), g_pProject->GetFilePath()) != 0 ||
//		ret.GetHidocumentId() != GetDocumentId() ||
//		ret.GetSessionIndex() != GetNextSessionIndex())
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
//		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
//		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
//		return FD_DRR_ERR;
//	}
//
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCmJiBeBiJlMjAnNiOjOiKnEiDiJiDhIiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
//	GUID guidTempLabel = m_forkFile.AppendTempTimeLabel(GetNextSessionIndex());
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCmMiPjBiCkLiPgPiClFiBeCiNfIjAfGiCpAjCmKjCgNiClHiCoJiBeC_xHqqkZx_
////	m_forkFile.UpdateFile(reqLock.m_autoLockForkWrite);
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
//	ret.SetTempTimeLabelGuid(guidTempLabel);
//	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
//	return FD_DRR_OK;
//} // CFCHistViewDoc::OnReqRegisterTempTimeLabel.
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqDlgPutTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_DLG_PUT_TIME_LABEL]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iOjOiKnEiDiJiDhIiDiLjAnNjCoIiCmMiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqDlgPutTimeLabel (FCReqBase& ret, FCReqLock& reqLock)
{
	// _xZkqqHx_iMlLiNnNiImKjChFiCmGiOhHjCoIiImKjChFiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
	if (wcscmp(ret.GetProjectPath(), g_pProject->GetFilePath()) != 0 ||
		ret.GetHidocumentId() != GetDocumentId() ||
		ret.GetSessionIndex() != GetNextSessionIndex() ||
		ret.GetSheetId() != GetCurrentSheetId())
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
		return FD_DRR_ERR;
	}
	//----- _xZkqqHx_jDpMjHmNjHhAiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJ_xHqqkZx_ -----
	CFCDlgTimeLabel dlg(TRUE);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	dlg.Initialize(	*g_pProject,
					ret.GetHidocumentId(),
					ret.GetSessionIndex());
	// _xZkqqHx_iJlMjAnNjHjKjHpAjFkKiKpCiCpAjAnNjCoIiClFiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjFfMiOkGiClDiClJiCoJiBeC_xHqqkZx_
	FFGetHiMainWnd()->SetHiviewTempMark(1,
										g_pProject->GetFilePath(),
										GetDocumentId(),
										GetNextSessionIndex());
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
//----- 06.01.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAjBfDiCmEiJpAiPjMiBeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiClNiCnPiBeC_xHqqkZx_
	reqLock.Unlock(FCReqLock::ALL);
//----- 06.01.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	long lReturn = dlg.DoModal();
	// _xZkqqHx_jAnNjCoIiClDiCoKiClNiJlMjAnNjHjKjHpAjFkKiKpCiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	FFGetHiMainWnd()->SetHiviewTempMark(-1, NULL, -1, -1);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFjMiLeBjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	ret.SetReturn(lReturn);
	if (lReturn == IDOK)
	//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNoMjAkMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		ret.SetTimeLabelText(TStrToWStr(dlg.m_strLabel));
		if (dlg.m_bRegisterUserId)
		//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjDgPjIfOiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			ret.SetTimeLabelUserId(dlg.m_guidRegisterUserId);			// _xZkqqHx_iNoMiOnCiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		} else
		//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjDgPjIfOiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			ret.SetTimeLabelUserId(GUID_NULL);							// _xZkqqHx_iNoMiOnCiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		}
	}
	return FD_DRR_OK;	// _xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
} // CFCHistViewDoc::OnReqDlgPutTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqPutTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_PUT_TIME_LABEL]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqPutTimeLabel (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_g_pFileServer->FlushAll _xZkqqHx_iCpAiOjNiCmCiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPiIjHjN_xHqqkZx_
//	// _xZkqqHx_iCmMjDkKjBfDiCmEiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiPoKiNiHiCmNiBeBjHjKjHpAjFlGiPjBiCmMiDhEiDiJiDgCiDfGiDiFiCpAiOmAiNhDiBeC_xHqqkZx_
//	if (OnReqCheckFlush()) return FD_DRR_RETRY;
//
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
////----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////											FCReqLock::PROJECT_READ |
////											FCReqLock::COMMAND_READ |
////											FCReqLock::SUMMARY_READ |
////											FCReqLock::TERMINATE_READ |
////											FCReqLock::FORK_READ |
////----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//											FCReqLock::FORK_WRITE);
//	if (result != FD_DRR_OK) return result;
//
////----- 05.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	FD_CHECK_QUALIFICATION(g_pProject);
////----- 05.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iMlLiNnNiImKjChFiCmGiOhHjCoIiImKjChFiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
//	if (wcscmp(ret.GetProjectPath(), g_pProject->GetFilePath()) != 0 ||
//		ret.GetHidocumentId() != GetDocumentId() ||
//		ret.GetSessionIndex() != GetNextSessionIndex())
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
//		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
//		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
//		return FD_DRR_ERR;
//	}
//	FCTimeLabelConstIterator iTimeLabel = m_forkFile.FindTempTimeLabelByGuid(ret.GetTempTimeLabelGuid());
//	if (iTimeLabel.IsEnd() ||									// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCkKiOgDiCmBiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//		GetNextSessionIndex() != iTimeLabel.GetSessionIndex())	// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
//		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
//		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
//		return FD_DRR_ERR;
//	}
//
//	//----- _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCkKiOgDiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//
//	//_xZkqqHx_jAfGiLeLiOjOiKnEiDiJiDhIiDiLiCpAiBeBiNkBiCmMjHjKjHpAiImKjChFiCmJiNoMjAkMiBeC_xHqqkZx_
//	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiClHiCoJiCkJiBeI_xHqqkZx_
//	BOOL bIsLogCommandUserId = TRUE;
//	if (!g_pProject->GetIsAllowToJoinUsersGroup() ||
//		g_pReg->GetIsInhibitSetId())
//		bIsLogCommandUserId = FALSE;
//
//	// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiBeCjAlDiOkOiCmIjHjKjHpAjFkKiKpCiCpAjCmHiJmBiBeC_xHqqkZx_
//	m_forkFile.Remove(m_forkFile.FindTempTimeLabelByGuid(ret.GetTempTimeLabelGuid()));
//	const long lTimeLabelId = m_forkFile.GetFreeTimeLabelId();
//	m_forkFile.AppendTimeLabel(	ret.GetSessionIndex(),
//								lTimeLabelId,
//								ret.GetSheetId(),
//								DBLPoint(ret.GetMmX(), ret.GetMmY()),
//								FFGetCurrentSecTime(),
//								ret.GetIsLogCommandUserId() ? FFGetApp()->GetUserId() : GUID_NULL,
//								ret.GetTimeLabelText());
//
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCmJjAfGiLeLjDgPjIfOiClHiCoJjFlGiPjBiCmMiPoOjFpBiCpAjAnNjCoI_xHqqkZx_ -----
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCpAiDfKiBfLiDhFiBeC_xHqqkZx_
////	m_forkFile.UpdateFile(reqLock.m_autoLockForkWrite);
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_jFnEjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
//	ret.SetTimeLabelId(lTimeLabelId);
//
////----- 05.08.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	if (UpdateTimeLabel(*g_pProject,
//						m_forkFile,
//						reqLock.m_autoLockProjectRead,
//						reqLock.m_autoLockForkRead))
//		g_pView->SendRgnRedraw();
////----- 05.08.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiImIiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_g_pFileServer->FlushAll _xZkqqHx_iCpAiOjNiCmCiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPiIjHjN_xHqqkZx_
	// _xZkqqHx_iCmMjDkKjBfDiCmEiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiPoKiNiHiCmNiBeBjHjKjHpAjFlGiPjBiCmMiDhEiDiJiDgCiDfGiDiFiCpAiOmAiNhDiBeC_xHqqkZx_
	if (OnReqCheckFlush()) return FD_DRR_RETRY;

	FTDocReqResult result = OnReqCheckLock(	reqLock,
											FCReqLock::FORK_WRITE);
	if (result != FD_DRR_OK) return result;

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	FD_CHECK_QUALIFICATION(g_pProject);

	// _xZkqqHx_iMlLiNnNiImKjChFiCmGiOhHjCoIiImKjChFiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
	if (wcscmp(ret.GetProjectPath(), g_pProject->GetFilePath()) != 0 ||
		ret.GetHidocumentId() != GetDocumentId() ||
		ret.GetSessionIndex() != GetNextSessionIndex() ||
		ret.GetSheetId() != GetCurrentSheetId())
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
		return FD_DRR_ERR;
	}

	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAjCmHiJmBiBeC_xHqqkZx_
	const long lTimeLabelId = m_forkFile.GetFreeTimeLabelId();
	m_forkFile.AppendTimeLabel(	ret.GetSessionIndex(),
								lTimeLabelId,
								ret.GetSheetId(),
								DBLPoint(ret.GetMmX(), ret.GetMmY()),
								FFGetCurrentSecTime(),
// 06.04.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//								ret.GetIsLogCommandUserId() ? FFGetApp()->GetUserId() : GUID_NULL,
								ret.GetTimeLabelUserId(),
								ret.GetTimeLabelText());
	// _xZkqqHx_jFnEjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	ret.SetTimeLabelId(lTimeLabelId);

	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	if (UpdateTimeLabel(*g_pProject,
						m_forkFile,
						reqLock.m_autoLockProjectRead,
						reqLock.m_autoLockForkRead))
		g_pView->SendRgnRedraw();
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiImIiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
//----- 06.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	return FD_DRR_OK;	// _xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
} // CFCHistViewDoc::OnReqPutTimeLabel.

//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqDeleteTempTimeLabel
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_DELETE_TEMP_TIME_LABEL]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqDeleteTempTimeLabel (FCReqBase& ret, FCReqLock& reqLock)
//{
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_g_pFileServer->FlushAll _xZkqqHx_iCpAiOjNiCmCiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPiIjHjN_xHqqkZx_
//	// _xZkqqHx_iCmMjDkKjBfDiCmEiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiPoKiNiHiCmNiBeBjHjKjHpAjFlGiPjBiCmMiDhEiDiJiDgCiDfGiDiFiCpAiOmAiNhDiBeC_xHqqkZx_
//	if (OnReqCheckFlush()) return FD_DRR_RETRY;
//
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiBeB_xHqqkZx_EXCLUSIVE & READ_WRITE _xZkqqHx_iCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	// OnReqCheckLock _xZkqqHx_iCmFiBeBiPoKiNiHiCmJiCoGiCmBiCmEiCmN_xHqqkZx_ Document_xZkqqHx_jHhGiLiBiCkKjAmPiCnMiCoKiCoJiCkKiBeB_xHqqkZx_
//	// FD_DRR_CANCEL _xZkqqHx_iCpAjFnEiClHiClNiCnPiBeBiDeMiDiFiBfLiCkJiCoHjGjFiPmBiClDiCoKiCoJiCmMiCmFjGoCjBoIjGlDiCkCiBeC_xHqqkZx_
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
////----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////											FCReqLock::PROJECT_READ |
////											FCReqLock::FORK_READ |
////----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//											FCReqLock::FORK_WRITE);
//	if (result != FD_DRR_OK) return result;
//
////----- 05.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	FD_CHECK_QUALIFICATION(g_pProject);
////----- 05.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
//
//	// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
////----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jFeLiClIiJlMjAnNiOjOiKnEiDiJiDhIiDiLiCmFiCkAiCoJiCoGiCkEiBeBiKgNjEeGiClFiCmEiCkIiCkNiBeC_xHqqkZx_
////	if (0 <= ret.GetTimeLabelId())
////	{
////		AfxDebugBreak();
////		return FD_DRR_FATAL_ERR;
////	}
////----- 06.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiBeCjBlMiCmFiNfIjAfGiBeFiNoNiPjMiClDiCoKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCoAjHeMiCoIjDlOiCoJiCkKiBeB_xHqqkZx_
//	// _xZkqqHx_iDeHiDiJiBfLiCmNjEkNjAlGiClFiCmIiCkCiCmMiCmFiBeBjBlGiNnNiClHiCoJiCkJiCmNiKgNjEeGiClFiCmIiCkCiBeC_xHqqkZx_
//	m_forkFile.Remove(m_forkFile.FindTempTimeLabelByGuid(ret.GetTempTimeLabelGuid()));
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCmMiPjBiCkLiPgPiClFiBeCiNfIjAfGiCpAjCmKjCgNiClHiCoJiBeC_xHqqkZx_
////	m_forkFile.UpdateFile(reqLock.m_autoLockForkWrite);
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiImIiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
//	return FD_DRR_OK;
//} // CFCHistViewDoc::OnReqDeleteTempTimeLabel.
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveTimeLabels
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_TIME_LABELS]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveTimeLabels (FCReqBase& ret, FCReqLock& reqLock)
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmGjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClFiCmEjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	FCDbReadLock autoLockProjectRead;
	FCDbReadLock autoLockForkRead;
// 06.04.12 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	FCDbWriteLock autoLockForkWrite;
	FCHiProject project;
	FCHiForkTable forkFile;
	FTDocReqResult result = OnReqLockAndUpdate(	ret.GetProjectPath(),
												ret.GetHidocumentId(),
												autoLockProjectRead,
												NULL,
												project,
												&autoLockForkRead,
												&autoLockForkWrite,
												&forkFile);
	if (result != FD_DRR_OK) return result;

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	FD_CHECK_QUALIFICATION(&project);

//----- 06.04.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FCDbWriteLock autoLockForkWrite(autoLockForkRead.GetTableName());
//	if (!autoLockForkWrite.TryLock())
//		return FD_DRR_LATER;
//----- 06.04.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	const longVector* vSelectedLabelId = ret.GetTimeLabelIdVector();
	const DBLPointVector* vLabelPointOld = ret.GetMmPointVectorOld();
	const DBLPointVector* vLabelPoint = ret.GetMmPointVector();
	long lC;
	for (lC = 0; lC != vSelectedLabelId->size(); lC++)
	{
		FCTimeLabelConstIterator iTimeLabel = forkFile.FindTimeLabelById(vSelectedLabelId->at(lC));
		// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCkKiOgDiCmBiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
		if (iTimeLabel.IsEnd()) break;
		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiImKjChFiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCkJiCoHiOoGjDlOiClFiClNjCgMiBgJ_xHqqkZx_iTimeLabel.GetPoint_xZkqqHx_iBgKiCmNiBeB_xHqqkZx_
		// _xZkqqHx_jCgMiCkKiClIiCoKiCmEiCkCiCoJiCmMiCmF_xHqqkZx_ rougheq _xZkqqHx_iCmFjEoEiKhCiClHiCoJiBeC_xHqqkZx_
		if (!rougheq(vLabelPointOld->at(lC), iTimeLabel.GetPoint()))
			break;
	}
	if (lC != vSelectedLabelId->size())
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
		FFSetDDError(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
		return FD_DRR_ERR;
	}

	for (lC = 0; lC != vSelectedLabelId->size(); lC++)
	{
		FCTimeLabelIterator iTimeLabel = forkFile.FindTimeLabelByIdW(vSelectedLabelId->at(lC));
		iTimeLabel.SetPoint(vLabelPoint->at(lC));
		// _xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCpAiDfKiBfLiDhFiBeC_xHqqkZx_
		iTimeLabel.Update();
	}

	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCmJjAfGiLeLjDgPjIfOiClHiCoJjFlGiPjBiCmMiPoOjFpBiCpAjAnNjCoI_xHqqkZx_ -----

	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	if (UpdateTimeLabel(project, forkFile, autoLockProjectRead, autoLockForkRead))
		g_pView->SendRgnRedraw();

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiImIiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
	return FD_DRR_OK;	// _xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
} // CFCHistViewDoc::OnReqMoveTimeLabels.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqScrollToLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_SCROLL_TO_LABEL]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iOhHjCoIiCmMiDiJiDhIiDiLiCkKjCiGjAfDiNmAjFfHiCmJiCkNiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqScrollToLabel (FCReqBase& ret, FCReqLock& reqLock)
{
	const FCObjDynabase* pObj = ObjID2Object(ret.GetLabelId());
	if (pObj != NULL)
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiDiJiDhIiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		const DBLPoint mmptCenter = pObj->GetResizeFrame().CenterPoint();
		// _xZkqqHx_iOoGjDlOiClFiClNiNmAjFfHiCkKjCiGjAfDiCmJiCkNiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		InsertDocRequest(1, ID_DREQ_CHANGE_SHEET_ZOOM_CENTER,
							FCReqBase::MM_X, mmptCenter.x,
							FCReqBase::MM_Y, mmptCenter.y,
							FCReqBase::NONE);
	}
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqScrollToLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqScrollToTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_SCROLL_TO_TIME_LABEL]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iOhHjCoIiCmMiOjOiKnEiDiJiDhIiDiLiCkKjCiGjAfDiNmAjFfHiCmJiCkNiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqScrollToTimeLabel (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiBeB_xHqqkZx_READ _xZkqqHx_iCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::FORK_READ);
//	if (result != FD_DRR_OK) return result;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	FCTimeLabelConstIterator iTimeLabel = m_forkFile.FindTimeLabelById(ret.GetTimeLabelId());
	if (!iTimeLabel.IsEnd())
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOoGjDlOiClFiClNiNmAjFfHiCkKjCiGjAfDiCmJiCkNiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		InsertDocRequest(1, ID_DREQ_CHANGE_SHEET_ZOOM_CENTER,
							FCReqBase::MM_X, iTimeLabel.GetPoint().x,
							FCReqBase::MM_Y, iTimeLabel.GetPoint().y,
							FCReqBase::NONE);
	}
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqScrollToTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveHistoryBackwardUntilInterval
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_HISTORY_BACKWARD_UNTIL_INTERVAL]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAiCpAiDeDiDjDiDfOiBfLiDgPiDiLiCnMiCmFjGnPiClHiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveHistoryBackwardUntilInterval (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ);
//	if (result != FD_DRR_OK) return result;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iIpIjAjEjCgMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	const FDSECTIME fdstInterval = ret.GetTimeDifference();
	// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCpAiLeMiJkPiBeC_xHqqkZx_
	const flint fliCurrentSessionIndex = GetNextSessionIndex();

	// _xZkqqHx_jClMjBePiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
	FDSECTIME fdstNextSessionTime = m_pGate->GetPrevSessionTime();
	while (GetNextSessionIndex() != GetFirstSessionIndex())
	//----- _xZkqqHx_jAoGjDkKiCnMiCmFiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDjBePiCnGiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		m_pGate->SkipSessionPrev();
		// _xZkqqHx_jClMjBePiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		const FDSECTIME fdstPrevSessionTime = m_pGate->GetPrevSessionTime();
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmMiMgPiJnPiOjOiKnEiCkKiOhHjCoIjCgMiCpAjClEiCkGiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (fdstInterval <= fdstNextSessionTime - fdstPrevSessionTime) break;
		// _xZkqqHx_jClMjBePiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEjFmPjAjEiCpAiNfIjAfGiBeC_xHqqkZx_
		fdstNextSessionTime = fdstPrevSessionTime;
	}
	// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiCnMiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
	InsertDocRequest(1,
					ID_DREQ_MOVE_HISTORY_UNTIL_SESSION,
					FCReqBase::SESSION_INDEX, GetNextSessionIndex(),
					FCReqBase::NONE);
	InsertDocRequest(2,
					ID_DREQ_SCROLL_TO_SPOT,
					FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
					FCReqBase::SESSION_DIRECTION, SESSION_DIRECTION::FROM_AFTER_TO_BEFORE,
					FCReqBase::IS_SELECT_OBJECT, FALSE,
					FCReqBase::NONE);

	// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiMlDiCmMiImKjChFiCnMiCmFiDfGiBfLiDeOiBeC_xHqqkZx_
	m_pGate->SeekToSessionIndex(fliCurrentSessionIndex);
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBjFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pGate->SetupSessionTimeAndIndex();
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqMoveHistoryBackwardUntilInterval.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveHistoryForwardUntilInterval
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_HISTORY_FORWARD_UNTIL_INTERVAL]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAiCpAiDeDiDjDiDfOiBfLiDgPiDiLiCnMiCmFjAgJiCnPiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveHistoryForwardUntilInterval (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ);
//	if (result != FD_DRR_OK) return result;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iIpIjAjEjCgMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	const FDSECTIME fdstInterval = ret.GetTimeDifference();
	// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCpAiLeMiJkPiBeC_xHqqkZx_
	const flint fliCurrentSessionIndex = GetNextSessionIndex();

	// _xZkqqHx_jClMjBePiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
	FDSECTIME fdstPrevSessionTime = m_pGate->GetPrevSessionTime();
	while (GetNextSessionIndex() != GetEndSessionIndex())
	//----- _xZkqqHx_iPeJjCfLiCnMiCmFiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDiMoDiCoLiCnGiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		m_pGate->SkipSessionNext();
		// _xZkqqHx_jClMjBePiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		const FDSECTIME fdstNextSessionTime = m_pGate->GetPrevSessionTime();
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmMiMgPiJnPiOjOiKnEiCkKiOhHjCoIjCgMiCpAjClEiCkGiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (fdstInterval <= fdstNextSessionTime - fdstPrevSessionTime) break;
		// _xZkqqHx_jClMjBePiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEjFmPjAjEiCpAiNfIjAfGiBeC_xHqqkZx_
		fdstPrevSessionTime = fdstNextSessionTime;
	}
	// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiCnMiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
	InsertDocRequest(1,
					ID_DREQ_MOVE_HISTORY_UNTIL_SESSION,
					FCReqBase::SESSION_INDEX, GetNextSessionIndex(),
					FCReqBase::NONE);
	InsertDocRequest(2,
					ID_DREQ_SCROLL_TO_SPOT,
					FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
					FCReqBase::SESSION_DIRECTION, SESSION_DIRECTION::FROM_BEFORE_TO_AFTER,
					FCReqBase::IS_SELECT_OBJECT, FALSE,
					FCReqBase::NONE);

	// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiMlDiCmMiImKjChFiCnMiCmFiDfGiBfLiDeOiBeC_xHqqkZx_
	m_pGate->SeekToSessionIndex(fliCurrentSessionIndex);
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBjFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pGate->SetupSessionTimeAndIndex();
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqMoveHistoryForwardUntilInterval.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveHistoryBackwardTimePassed
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_HISTORY_BACKWARD_TIME_PASSED]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiOjOiKnEiCkKiMgPiJnPiClHiCoJiCnMiCmFjGnPiClHiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveHistoryBackwardTimePassed (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ);
//	if (result != FD_DRR_OK) return result;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iIpIjAjEjCgMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	const FDSECTIME fdstTimeDiff = ret.GetTimeDifference();
	// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCpAiLeMiJkPiBeC_xHqqkZx_
	const flint fliCurrentSessionIndex = GetNextSessionIndex();

	// _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
	const FDSECTIME fdstCurSessionTime = m_pGate->GetPrevSessionTime();
	while (GetNextSessionIndex() != GetFirstSessionIndex())
	//----- _xZkqqHx_jAoGjDkKiCnMiCmFiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDjBePiCnGiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		m_pGate->SkipSessionPrev();
		// _xZkqqHx_jClMjBePiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		const FDSECTIME fdstPrevSessionTime = m_pGate->GetPrevSessionTime();
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmMiMgPiJnPiOjOiKnEiCkKiOhHjCoIjCgMiCpAjClEiCkGiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (fdstTimeDiff <= fdstCurSessionTime - fdstPrevSessionTime) break;
	}
	// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiCnMiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
	InsertDocRequest(1,
					ID_DREQ_MOVE_HISTORY_UNTIL_SESSION,
					FCReqBase::SESSION_INDEX, GetNextSessionIndex(),
					FCReqBase::NONE);
	InsertDocRequest(2,
					ID_DREQ_SCROLL_TO_SPOT,
					FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
					FCReqBase::SESSION_DIRECTION, SESSION_DIRECTION::FROM_AFTER_TO_BEFORE,
					FCReqBase::IS_SELECT_OBJECT, FALSE,
					FCReqBase::NONE);

	// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiMlDiCmMiImKjChFiCnMiCmFiDfGiBfLiDeOiBeC_xHqqkZx_
	m_pGate->SeekToSessionIndex(fliCurrentSessionIndex);
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBjFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pGate->SetupSessionTimeAndIndex();
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqMoveHistoryBackwardTimePassed.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveHistoryForwardTimePassed
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_HISTORY_FORWARD_TIME_PASSED]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiOjOiKnEiCkKiMgPiJnPiClHiCoJiCnMiCmFjAgJiCnPiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveHistoryForwardTimePassed (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ);
//	if (result != FD_DRR_OK) return result;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iIpIjAjEjCgMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	const FDSECTIME fdstTimeDiff = ret.GetTimeDifference();
	// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCpAiLeMiJkPiBeC_xHqqkZx_
	const flint fliCurrentSessionIndex = GetNextSessionIndex();

	// _xZkqqHx_jClMjBePiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
	const FDSECTIME fdstCurSessionTime = m_pGate->GetPrevSessionTime();
	while (GetNextSessionIndex() != GetEndSessionIndex())
	//----- _xZkqqHx_iPeJjCfLiCnMiCmFiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDiMoDiCoLiCnGiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		m_pGate->SkipSessionNext();
		// _xZkqqHx_jClMjBePiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		const FDSECTIME fdstNextSessionTime = m_pGate->GetPrevSessionTime();
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmMiMgPiJnPiOjOiKnEiCkKiOhHjCoIjCgMiCpAjClEiCkGiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (fdstTimeDiff <= fdstNextSessionTime - fdstCurSessionTime) break;
	}
	// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiCnMiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
	InsertDocRequest(1,
					ID_DREQ_MOVE_HISTORY_UNTIL_SESSION,
					FCReqBase::SESSION_INDEX, GetNextSessionIndex(),
					FCReqBase::NONE);
	InsertDocRequest(2,
					ID_DREQ_SCROLL_TO_SPOT,
					FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
					FCReqBase::SESSION_DIRECTION, SESSION_DIRECTION::FROM_BEFORE_TO_AFTER,
					FCReqBase::IS_SELECT_OBJECT, FALSE,
					FCReqBase::NONE);

	// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiMlDiCmMiImKjChFiCnMiCmFiDfGiBfLiDeOiBeC_xHqqkZx_
	m_pGate->SeekToSessionIndex(fliCurrentSessionIndex);
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBjFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pGate->SetupSessionTimeAndIndex();
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqMoveHistoryForwardTimePassed.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqSaveHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_SAVE_HIDOCUMENT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFnLjBlGiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqSaveHidocument (FCReqBase& ret, FCReqLock& reqLock)
{
	// HistoryViewer_xZkqqHx_iCmFiCmNiClBiCmMiPiIjHjNiCmNjFhDjHhGiBeC_xHqqkZx_
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqSaveHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqScrollToSpot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_SCROLL_TO_SPOT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jBiAiNoMiImKjChFiCnGiDfIiDeOiDiNiBfLiDiLiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqScrollToSpot (FCReqBase& ret, FCReqLock& reqLock)
{
	// _xZkqqHx_jClMjBePiBeBiIlNiCkCiCmNjClMiMoDiCmMiDfKiDgCiDfGiDiHiDjDiCmJiCkIiCkCiCmEjFmPiNfIiClDiCoKiClNjHmMiIoGiBgJjFjEjFgJiBeBiDiKiDjDiDeOiBgK_xHqqkZx_
	// _xZkqqHx_iCpAjClCiCnHiCmEiBeBiClLiCmMiImKjChFiCmJiDfIiDeOiDiNiBfLiDiLiClHiCoJiBeC_xHqqkZx_
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ);
//	if (result != FD_DRR_OK) return result;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iDhAiDiJiDiBiBfLiDfOiCpAiOoGjDlO_xHqqkZx_ -----
	// _xZkqqHx_jClCiCnHiCoJiDfKiDgCiDfGiDiHiDjDiBgJiJnPiLiOiBeIjGkCjHiIiBeIiBgK_xHqqkZx_
	long lSessionDirection = SESSION_DIRECTION::FROM_BEFORE_TO_AFTER;
	if (!ret.IsNullSessionDirection())
		lSessionDirection = ret.GetSessionDirection();

	// _xZkqqHx_iIoKiCmCjBePiBeBiIlNiCkCiCmNiMoDiCmMiDfKiDgCiDfGiDiHiDjDiCkJiCoHiBeBiNoMjAkMiBeFjFmPiNfIiClDiCoKiClNjFjEjFgJiCmGiBeB_xHqqkZx_
	// _xZkqqHx_iNoMjAkMiBeFjFmPiNfIiBeFiNoNiPjMiClDiCoKiClNjFjEjFgJiCmMjHmMiIoGiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	DBLRect mmrtFrame;
	DWORDSet stMovedObjId;
	BOOL bSucceed;
	if (lSessionDirection == SESSION_DIRECTION::FROM_BEFORE_TO_AFTER)
		bSucceed = m_pGate->GetPrevSessionFrame(mmrtFrame, stMovedObjId);
	else
		bSucceed = m_pGate->GetNextSessionFrame(mmrtFrame, stMovedObjId);

	if (bSucceed && !mmrtFrame.IsRectNull())
	//----- _xZkqqHx_jFmPiNfIiClDiCoKiClNjHmMiIoGiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHmMiIoGiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		InsertDocRequest(1,
						ID_DREQ_SCROLL_TO_FRAME,
						FCReqBase::MM_RECT, mmrtFrame,
						FCReqBase::NONE);
		// _xZkqqHx_jFjEjFgJiCpAjBeJjBpAiBeCiDfIiDeOiDiNiBfLiDiLiNmPiCnNiCmIiCmMiCmFiDfIiDeOiDiNiBfLiDiLiCmNiClDiClJiCmIiCkCiBeC_xHqqkZx_
		InsertDocRequest(2,
						ID_DREQ_SELECT_OBJECT,
						FCReqBase::OBJECT_ID_SET, &stMovedObjId,
						FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::NONE,
						FCReqBase::NONE);
	}
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqScrollToSpot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myMergeTimeIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiDhNiBfLiDfHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pwstrFilePath	:_xZkqqHx_iDhNiBfLiDfHiClDiCoKiCoJjFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
 *							 _xZkqqHx_iDhAiDfIiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iFilePathCount	:pwstrFilePath_xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpWorkDir		:_xZkqqHx_iDhNiBfLiDfHiClFiClNiPgPjHmNiDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_
 *							 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiClFiCmEiNoMjAkMiClFiClNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static WString myMergeTimeIndex (const WString pwstrFilePath[], int iFilePathCount, const wchar_t* wcpWorkDir)
{
	// _xZkqqHx_iPgPjHmNiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
	WString wstrFileOut;
	// _xZkqqHx_iDhEiDeAiDeDiDiLiNoMjAkMiDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
	WString wstrWorkDir(wcpWorkDir);
	// _xZkqqHx_iPgPjHmNiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
	FCTimeIndexFile fileOut;
	// _xZkqqHx_iDiGiDgKiBfLiDeOiCmIjGlMjBePiCmFiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
	int index;
	for (index = 0; index != 5; index++)
	{
		FFMakeUniqFileName(wstrFileOut, wstrWorkDir + L"\\s", FD_FILE_EXT_TIME_INDEX);
		if (fileOut.Open(wstrFileOut, TRUE))
			break;
	}
	// _xZkqqHx_iDiGiDgKiBfLiDeOiCmIjGlMjBePiCkKiNoMjAkMiCmFiCkLiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (index == 5)
		FFThrowMiscUnknown();

	// _xZkqqHx_jBfDiCmEiCmMjDpMjHmNiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
	vector<FCTimeIndexFile> fileIn(iFilePathCount);
	for (index = 0; index != iFilePathCount; index++)
	{
		if (!fileIn[index].Open(pwstrFilePath[index], FALSE))
			FFThrowMiscUnknown();
	}

	// _xZkqqHx_jDpMjHmNiDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHjDmHiCnNiPgPiClHiClNiCnPiCmMiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	vector<FCTimeIndexRec> vTimeIndexRec(iFilePathCount);
	// _xZkqqHx_iCnMiClIiBeBjBfDiCmEiCmMjDpMjHmNiDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHiBeBiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	map<FCTimeIndexRec, int> mpSort;
	for (index = 0; index != iFilePathCount; index++)
	{
		if (fileIn[index].Read(vTimeIndexRec[index]))
			mpSort[vTimeIndexRec[index]] = index;
	}

	// _xZkqqHx_jBePiJpBjDmHiCnNiPgPiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiBeBiDhGiDiJiDeDiDhNiDiKiBfLiDeMiBfLiBgJiOjOiKnEiBgKiBeC_xHqqkZx_
	// _xZkqqHx_jDpMjHmNiDeDiDjDiDgGiDgCiDeOiDfIiCkKiDeMiBfLiCmMiPlIiPiHiCmJjFmAiCpBiCmFiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	FCTimeIndexRec timeIndexPrev(FDSECTIME_MIN, 0, 0);

	while (!mpSort.empty())
	{
		// _xZkqqHx_jAoGjDkKiCmMiOjOiKnEiCkKiCoAiCmBiCmGiCoAiPkMiClDiCkCiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		index = mpSort.begin()->second;
		// _xZkqqHx_iDfMiBfLiDgHjHhAiDgOiDgCiDfGiDiFiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
		mpSort.erase(mpSort.begin());
		if (vTimeIndexRec[index] < timeIndexPrev)
		//----- _xZkqqHx_jBePiJpBiCmMiOjOiKnEiCoGiCoIiCoAiJnPiLiOiCmJjGnPiCmBiCmEiClFiCnMiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jGhLjHiIiBeBiOjOiKnEiCmNiPlIiPiHiCmFiCkAiCoJiCmNiClIiClOiCkKiBeBiDhNiDfGiDjDiCmMiOjOiMhGiCkKiLlGiCmBiCmEiBeBiOjOiKnEiCkKjBePiMoDiClHiCoJiPoKiNiHiCmNiCkAiCoJiBeC_xHqqkZx_
			// _xZkqqHx_jCeBiClFiBeB_xHqqkZx_FCMakeTimeIndexInfo::AppendFindRec_xZkqqHx_iKnGjAjEiCmFjFoCjAlDiClDiCoKiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_
			// _xZkqqHx_iClBiClBiCmFjBePiMoDiClHiCoJiClBiCmGiCmNiCkAiCoIiCkGiCmIiCkCiBeC_xHqqkZx_
			FFThrowMiscUnknown();
		}

		// _xZkqqHx_iPgPjHmNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmJiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
		fileOut.Write(vTimeIndexRec[index]);
		// _xZkqqHx_jBePiJpBiCmMiOjOiKnEiCpAiNfIjAfGiBeC_xHqqkZx_
		timeIndexPrev = vTimeIndexRec[index];

		// _xZkqqHx_jDpMjHmNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkJiCoHjAoGjDkKiCmMjCgMiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		if (fileIn[index].Read(vTimeIndexRec[index]))
			mpSort[vTimeIndexRec[index]] = index;
	}
	// _xZkqqHx_jDpMjHmNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjFmCiClGiCmEiBeBiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	for (index = 0; index != iFilePathCount; index++)
	{
		fileIn[index].Close();
		FFDeleteFile(pwstrFilePath[index]);
	}
	fileOut.Close();
	return wstrFileOut;
} // myMergeTimeIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqCreateTimeIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_CREATE_TIME_INDEX]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiNoMjAkMiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqCreateTimeIndex (FCReqBase& ret, FCReqLock& reqLock)
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmNiNoMjAkMjFhDiJmCiBeC_xHqqkZx_
	if (!g_pProject->IsProjectOpened())
		return FD_DRR_OK;
	// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiNoMjAkMiDfPiDeDiDeBiDiNiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	CFCDlgCreateTimeIndex dlg;
	dlg.Initialize(*g_pProject, GetIsDocumentOpened());
	// _xZkqqHx_iDiNiDgCiDeOiCpAjBfDiCmEiJpAiPjMiBeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiClNiCnPiBeC_xHqqkZx_
	reqLock.Unlock(FCReqLock::ALL);

	// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiNoMjAkMiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
	if (dlg.DoModal() == IDOK)
	//----- _xZkqqHx_iNoMjAkMiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		if (m_pFileTimeIndex != NULL)
		//----- _xZkqqHx_iKpJiCmJiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjFmCiClGiCmEiNoNiPjMiBeC_xHqqkZx_
			WString wstrTimeIndexPath = m_pFileTimeIndex->GetFilePath();
			m_pFileTimeIndex->Close();
			delete m_pFileTimeIndex;
			m_pFileTimeIndex = NULL;
			FFDeleteFile(wstrTimeIndexPath);
		}

		if (m_pWorkDir == NULL)
		//----- _xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKjGkCiNoMjAkMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			m_pWorkDir = new FCWorkDir(FD_FILE_EXT_HEAP);
		} else
		//----- _xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKiNoMjAkMiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfDiDhOiDhEiDeAiDeDiDiLiCkKiOgDiCmBiCmEiCkCiCoJiCmGiCkCiCkPiCmIiCkCiCmMiCmFiBeBiNoNiPjMiClFiCmEiCkIiCkNiBeC_xHqqkZx_
			// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiBeFiDhEiDeAiDeDiDiLiCmMjHpBiLjDiBeC_xHqqkZx_
			WStringVector vFileName;
			FFEnumDirectoryFile(WStringVector(), vFileName, m_pWorkDir->GetWorkDir() + L"\\*");
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjBfDiCmEiNoNiPjMiBeC_xHqqkZx_
			mdef_iterator(WStringVector, iStr);
			m1_for (iStr, vFileName)
				FFDeleteFile(m_pWorkDir->GetWorkDir() + L'\\' + (*iStr));
		}

		// _xZkqqHx_jBfDjFlGiPjBiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
		BOOL bSearchAllDocument = (dlg.GetSearchWhere() == IDC_CTI_RDO_SEARCH_ALL);
		// _xZkqqHx_iKgFjFlGiPjBiCkJiCoHiBeB_xHqqkZx_m_pWorkDir->GetWorkDir()_xZkqqHx_iCmMiJlKiCmJjFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
		if (FCHistoryFind().MakeTimeIndex(	dlg.GetProjectPathH(),
											dlg.GetNarrowTimeFrom(),
											dlg.GetNarrowTimeUntil(),
											dlg.GetNarrowUserId(),
											bSearchAllDocument,
											GetDocumentId(),
											m_pWorkDir->GetWorkDir()))
		//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiNoMjAkMiCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFlGiPjBiClCiCmGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiDhNiBfLiDfHiClFiCmEiCfAiCmCiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmJiCnMiCmGiCnPiPoDiClAiCoJiBeC_xHqqkZx_

			// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiBeFiDhEiDeAiDeDiDiLiCmMjHpBiLjDiBeC_xHqqkZx_
			WStringVector vFileName;
			FFEnumDirectoryFile(WStringVector(), vFileName, m_pWorkDir->GetWorkDir() + L"\\*" + FD_FILE_EXT_TIME_INDEX);

			// _xZkqqHx_iNoMjAkMiNmPiCnNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
			WStringVector vFileIn;
			mdef_iterator(WStringVector, iStr);
			m1_for (iStr, vFileName)
				vFileIn.push_back(m_pWorkDir->GetWorkDir() + L'\\' + (*iStr));

			while (vFileIn.size() != 1)
			//----- _xZkqqHx_iNoMjAkMiNmPiCnNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiCfAiCmCiCmJiCmIiCoJiCnMiCmF_xHqqkZx_ -----
			{
				// _xZkqqHx_iDhNiBfLiDfHiCmFiNoMjAkMiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
				WStringVector vFileOut;
				while (!vFileIn.empty())
				//----- _xZkqqHx_iNoMjAkMiNmPiCnNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiCePiCmJiCmIiCoJiCnMiCmF_xHqqkZx_ -----
				{
					// _xZkqqHx_iNmFjBoFiCmFiCoAiCfDiCmCiClIiCmCiDhNiBfLiDfHiClHiCoJiBeC_xHqqkZx_
					int iCC = (4 < vFileIn.size()) ? 4 : vFileIn.size();
					if (iCC == 1)
					//----- _xZkqqHx_iOgDiCoIiCfAiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
					{
						// _xZkqqHx_iDhNiBfLiDfHiCmNiClJiClIiBeBiClLiCmMiCnMiCnMiPgPjHmNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmGiClFiCmEiBeC_xHqqkZx_
						vFileOut.push_back(vFileIn[0]);
					} else
					//----- _xZkqqHx_iOgDiCoIiCfBiDhEiDeAiDeDiDiLiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
					{
						// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiDhNiBfLiDfHiClFiCmEiBeBiNoMjAkMiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAjDgPjIfOiBeC_xHqqkZx_
						vFileOut.push_back(myMergeTimeIndex(&vFileIn[0], iCC, m_pWorkDir->GetWorkDir()));
					}
					// _xZkqqHx_iNoMjAkMiNmPiCnNiDiKiDfIiDgHiCkJiCoHiDhNiBfLiDfHiClFiClNjFkKiCpAiPjMiCkNiBeC_xHqqkZx_
					vFileIn.erase(vFileIn.begin(), vFileIn.begin() + iCC);
				}
				// _xZkqqHx_iNoMjAkMiClDiCoKiClNiDhNiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjDpMjHmNiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
				vFileIn = vFileOut;
			}
			// _xZkqqHx_iNmFiMoDiCmJiCfAiCmCiOgDiCmBiClNiDhNiBfLiDfHiDhEiDeAiDeDiDiLiCpAiBeBjFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmGiClFiCmEiKeKiCkNiBeC_xHqqkZx_
			m_pFileTimeIndex = new FCTimeIndexFile();
			m_pFileTimeIndex->Open(vFileIn.front(), FALSE);
			m_pFileTimeIndex->UpdateData();
		}
	}
	// _xZkqqHx_iOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiNoMjAkMiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjBeJjBpAiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	if (m_pFileTimeIndex == NULL)
		SetIsUseTimeIndex(FALSE);
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqCreateTimeIndex.

//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqDeleteTimeLabel
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_DELETE_TIME_LABEL]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqDeleteTimeLabel (FCReqBase& ret, FCReqLock& reqLock)
//{
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::COMMAND_READ |
//											FCReqLock::SUMMARY_READ |
//											FCReqLock::TERMINATE_READ |
//											FCReqLock::FORK_READ |
//											FCReqLock::FORK_WRITE);
//	if (result != FD_DRR_OK) return result;
//
//	// _xZkqqHx_iMlLiNnNiImKjChFiCmGiOhHjCoIiImKjChFiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
//	if (wcscmp(ret.GetProjectPath(), g_pProject->GetFilePath()) != 0 ||
//		ret.GetHidocumentId() != GetDocumentId() ||
//		ret.GetSessionIndex() != GetNextSessionIndex())
//		return FD_DRR_ERR;
//
//	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
//	const longVector* vSelectedLabel = ret.GetTimeLabelIdVector();
//	const WStringVector* vLabelText = ret.GetTimeLabelTextVector();
//	const DBLPointVector* vLabelPoint = ret.GetMmPointVector();
//	for (long lC = 0; lC != vSelectedLabel->size(); lC++)
//	{
//		FCTimeLabelIterator iTimeLabel = m_forkFile.FindTimeLabelById(vSelectedLabel->at(lC));
//		if (iTimeLabel.IsEnd() ||											// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCkKiOgDiCmBiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//			GetNextSessionIndex() != iTimeLabel.GetSessionIndex() ||		// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
//			vLabelText->at(lC) != iTimeLabel.GetLabelText() ||				// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDgFiDeMiDfIiDgHiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
//			!almosteq(vLabelPoint->at(lC), iTimeLabel.GetPoint()))			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiImKjChFiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
//		{
//			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
//			// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
//			FFMessageBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
//			return FD_DRR_ERR;		// _xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
//		}
//	}
//
//	//_xZkqqHx_jAfGiLeLiOjOiKnEiDiJiDhIiDiLiCpAiBeBiNkBiCmMjHjKjHpAiImKjChFiCmJiNoMjAkMiBeC_xHqqkZx_
//	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiClHiCoJiCkJiBeI_xHqqkZx_
//	BOOL bIsLogCommandUserId = TRUE;
//	if (!g_pProject->GetIsAllowToJoinUsersGroup() ||
//		g_pReg->GetIsInhibitSetId())
//		bIsLogCommandUserId = FALSE;
//
//	longVector::const_iterator iId;
//	for (iId = vSelectedLabel->begin(); iId != vSelectedLabel->end(); iId++)
//	{
//		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
//		m_forkFile.RemoveTimeLabel(*iId);
//	}
//
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCmJjAfGiLeLjDgPjIfOiClHiCoJjFlGiPjBiCmMiPoOjFpBiCpAjAnNjCoI_xHqqkZx_ -----
//	// _xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCpAiDfKiBfLiDhFiBeC_xHqqkZx_
//	m_forkFile.UpdateFile(reqLock.m_autoLockForkWrite);
//	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	if (UpdateTimeLabel(m_forkFile, reqLock.m_autoLockForkRead))
//		g_pView->SendRgnRedraw();
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiImIiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
//	return FD_DRR_OK;	// _xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
//} // CFCHistViewDoc::OnReqDeleteTimeLabel.
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqChangeTimeLabel
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_CHANGE_TIME_LABEL]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDgFiDeMiDfIiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqChangeTimeLabel (FCReqBase& ret, FCReqLock& reqLock)
//{
////----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	FTDocReqResult result = OnReqCheckLock(	reqLock,
////											FCReqLock::PROJECT_READ |
////											FCReqLock::COMMAND_READ |
////											FCReqLock::SUMMARY_READ |
////											FCReqLock::TERMINATE_READ |
////											FCReqLock::FORK_READ |
////											FCReqLock::FORK_WRITE);
////	if (result != FD_DRR_OK) return result;
////
////	// _xZkqqHx_iMlLiNnNiImKjChFiCmGiOhHjCoIiImKjChFiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
////	if (wcscmp(ret.GetProjectPath(), g_pProject->GetFilePath()) != 0 ||
////		ret.GetHidocumentId() != GetDocumentId() ||
////		ret.GetSessionIndex() != GetNextSessionIndex())
////		return FD_DRR_ERR;
////
////	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
////	const longVector* vSelectedLabel = ret.GetTimeLabelIdVector();
////	const WStringVector* vLabelTextOld = ret.GetTimeLabelTextVectorOld();
////	const WStringVector* vLabelText = ret.GetTimeLabelTextVector();
////	const DBLPointVector* vLabelPointOld = ret.GetMmPointVectorOld();
////	const DBLPointVector* vLabelPoint = ret.GetMmPointVector();
////	long lC;
////	for (lC = 0; lC != vSelectedLabel->size(); lC++)
////	{
////		FCTimeLabelIterator iTimeLabel = m_forkFile.FindTimeLabelById(vSelectedLabel->at(lC));
////		if (iTimeLabel.IsEnd() ||											// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCkKiOgDiCmBiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
////			GetNextSessionIndex() != iTimeLabel.GetSessionIndex() ||		// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
////			vLabelTextOld->at(lC) != iTimeLabel.GetLabelText() ||			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDgFiDeMiDfIiDgHiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
////			!almosteq(vLabelPointOld->at(lC), iTimeLabel.GetPoint()))		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiImKjChFiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
////		{
////			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
////			// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
////			FFMessageBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
////			return FD_DRR_ERR;		// _xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
////		}
////	}
////
////	//_xZkqqHx_jAfGiLeLiOjOiKnEiDiJiDhIiDiLiCpAiBeBiNkBiCmMjHjKjHpAiImKjChFiCmJiNoMjAkMiBeC_xHqqkZx_
////	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiClHiCoJiCkJiBeI_xHqqkZx_
////	BOOL bIsLogCommandUserId = TRUE;
////	if (!g_pProject->GetIsAllowToJoinUsersGroup() ||
////		g_pReg->GetIsInhibitSetId())
////		bIsLogCommandUserId = FALSE;
////
////	for (lC = 0; lC != vSelectedLabel->size(); lC++)
////	{
////		FCTimeLabelIterator iTimeLabel = m_forkFile.FindTimeLabelById(vSelectedLabel->at(lC));
////		iTimeLabel.SetLabelText(vLabelText->at(lC));
////		iTimeLabel.SetPoint(vLabelPoint->at(lC));
////	}
////
////	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCmJjAfGiLeLjDgPjIfOiClHiCoJjFlGiPjBiCmMiPoOjFpBiCpAjAnNjCoI_xHqqkZx_ -----
////	// _xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCpAiDfKiBfLiDhFiBeC_xHqqkZx_
////	m_forkFile.UpdateFile(reqLock.m_autoLockForkWrite);
////	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
////	UpdateTimeLabel(reqLock.m_autoLockForkRead);
////	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
////	g_pView->SendRgnRedraw();
////
////	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiImIiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
////	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
////	return FD_DRR_OK;	// _xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
////----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmGjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClFiCmEjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCDbReadLock autoLockProjectRead;
//	FCDbReadLock autoLockForkRead;
//	FCHiProject project;
//	FCHiForkTable forkFile;
//	if (!OnReqLockAndUpdate(ret.GetProjectPath(),
//							ret.GetHidocumentId(),
//							&m_wstrReqErrMessage,
//							&autoLockProjectRead,
//							project,
//							&autoLockForkRead,
//							&forkFile)) return FD_DRR_FATAL_ERR;
//	FCDbWriteLock autoLockForkWrite(forkFile.GetTableName());
//	if (!autoLockForkWrite.TryLock())
//		return FD_DRR_LATER;
//
//	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
//	const longVector* vSelectedLabel = ret.GetTimeLabelIdVector();
//	const WStringVector* vLabelTextOld = ret.GetTimeLabelTextVectorOld();
//	const WStringVector* vLabelText = ret.IsNullTimeLabelTextVector() ? NULL : ret.GetTimeLabelTextVector();
//	const DBLPointVector* vLabelPointOld = ret.IsNullMmPointVectorOld() ? NULL : ret.GetMmPointVectorOld();
//	const DBLPointVector* vLabelPoint = ret.IsNullMmPointVector() ? NULL : ret.GetMmPointVector();
//	long lC;
//	for (lC = 0; lC != vSelectedLabel->size(); lC++)
//	{
//		FCTimeLabelIterator iTimeLabel = forkFile.FindTimeLabelById(vSelectedLabel->at(lC));
//		// _xZkqqHx_iJlMjAnNiOjOiKnEiDiJiDhIiDiLiCkKiOgDiCmBiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//		if (iTimeLabel.IsEnd()) break;
//		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDgFiDeMiDfIiDgHiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
//		if (vLabelTextOld->at(lC) != iTimeLabel.GetLabelText())
//			break;
//		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiImKjChFiCkKiIoBiCkEiPoKiNiHiBeC_xHqqkZx_
//		if (vLabelPointOld != NULL &&
//			!almosteq(vLabelPointOld->at(lC), iTimeLabel.GetPoint()))
//			break;
//	}
//	if (lC != vSelectedLabel->size())
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
//		// IDS_ERR_MSG_HIDOC_IS_MODIFIED = _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
//		FFMessageBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
//		return FD_DRR_ERR;		// _xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
//	}
//
//	//_xZkqqHx_jAfGiLeLiOjOiKnEiDiJiDhIiDiLiCpAiBeBiNkBiCmMjHjKjHpAiImKjChFiCmJiNoMjAkMiBeC_xHqqkZx_
//	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiClHiCoJiCkJiBeI_xHqqkZx_
//	BOOL bIsLogCommandUserId = TRUE;
//	if (!g_pProject->GetIsAllowToJoinUsersGroup() ||
//		g_pReg->GetIsInhibitSetId())
//		bIsLogCommandUserId = FALSE;
//
//	for (lC = 0; lC != vSelectedLabel->size(); lC++)
//	{
//		FCTimeLabelIterator iTimeLabel = forkFile.FindTimeLabelById(vSelectedLabel->at(lC));
//		if (vLabelText != NULL)
//			iTimeLabel.SetLabelText(vLabelText->at(lC));
//		if (vLabelPoint != NULL)
//			iTimeLabel.SetPoint(vLabelPoint->at(lC));
//	}
//
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCmJjAfGiLeLjDgPjIfOiClHiCoJjFlGiPjBiCmMiPoOjFpBiCpAjAnNjCoI_xHqqkZx_ -----
//	// _xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCpAiDfKiBfLiDhFiBeC_xHqqkZx_
//	forkFile.UpdateFile(autoLockForkWrite);
//
//	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	if (UpdateTimeLabel(forkFile, autoLockForkRead))
//		g_pView->SendRgnRedraw();
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiImIiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
//	return FD_DRR_OK;	// _xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
////----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // CFCHistViewDoc::OnReqChangeTimeLabel.
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::ExecDocRequest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmKiCmI_xHqqkZx_MolipDraw.exe_xZkqqHx_iCpAiLeOjDkOiClFiBeBiMlLiNnNiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpA_xHqqkZx_
 *			_xZkqqHx_iIpIiCkLiMhAiCkKiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLeOjDkOiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::ExecDocRequest () const
{
	FCReqBase reqBaseTop = m_reqResult;
	reqBaseTop.m_drqRequest = ID_DREQ_NOP;
	return FFExecSpecDocRequest(&reqBaseTop, *m_pvDocRequest, L"-histview");
} // CFCHistViewDoc::ExecDocRequest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::UpdateTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjFfMiOkGiClDiCoKiCmEiCkCiCoJiOjOiKnEiDiJiDhIiDiLiCkKiNfIjAfGiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	m_forkFile_xZkqqHx_iBeB_xHqqkZx_GetNextSessionIndex()_xZkqqHx_iCmJiKoOiCmDiCkCiCmEiBeBiMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjD_xHqqkZx_
 *			_xZkqqHx_iImKjChFiCmJiCkAiCoJiOjOiKnEiDiJiDhIiDiLiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiBeBiNoMjAkMiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiCmMiImKjChFiCmJiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpA_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::UpdateTimeLabel (	FCHiProject& project,
										FCHiForkTable& forkFile,
										const FCDbReadLock& autoLockProjectRead,
										const FCDbReadLock& autoLockForkRead)
{
	ASSERT(autoLockProjectRead.GetTableName().GetLast() == CONTROL_TABLE_ID);
	ASSERT(autoLockForkRead.GetTableName().GetLast() == FDHI_FORK_TABLE_ID);
	ASSERT(project.GetTableName() == autoLockProjectRead.GetTableName());
	ASSERT(forkFile.GetTableName() == autoLockForkRead.GetTableName());
	ASSERT(autoLockProjectRead.IsLocked());
	ASSERT(autoLockForkRead.IsLocked());

	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCkKiMlLiNnNiCmMiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCmGiInJiCmIiCoJiPoKiNiHiCmNiNfIjAfGiClFiCmIiCkCiBeC_xHqqkZx_
	if (forkFile.GetTableName() != m_forkFile.GetTableName())
		return FALSE;

	// _xZkqqHx_iNfIjAfGiClDiCoKiClNiCkJiBeI_xHqqkZx_
	BOOL bUpdated = !m_mpIdToTimeLabel.empty();

//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMjBeJjBpAiPpDjBnEiCpAjFjMiMlDiClHiCoJiClNiCnPiCmJiBeBiLeMjIfOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	const longSet stSelectTimeLabelBackup = m_stSelectTimeLabel;
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDeJiDhFiDfHiDeGiDeOiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	ClearTimeLabel();

	FCTimeLabelConstIterator iTimeLabel = forkFile.GetLowerBoundTimeLabel(GetNextSessionIndex());
	while (!iTimeLabel.IsEnd() && iTimeLabel.GetSessionIndex() == GetNextSessionIndex())
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmJiOjOiKnEiDiJiDhIiDiLiCkKiOgDiCmBiCmEiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNfIjAfGiClDiCoKiClNiCkJiBeI_xHqqkZx_
		bUpdated = TRUE;
		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
		FCTimeLabel* pTimeLabel = new FCTimeLabel(	iTimeLabel.GetPoint(),
													iTimeLabel.GetLabelText(),
													iTimeLabel.GetCreateTime(),
													iTimeLabel.GetUserId(),
													project.UserIdToUserName(iTimeLabel.GetUserId()));
		pTimeLabel->CalcLayout();
		// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(pTimeLabel->GetOuterFrame());
		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDeJiDhFiDfHiDeGiDeOiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
		m_mpIdToTimeLabel[iTimeLabel.GetTimeLabelId()] = pTimeLabel;
		iTimeLabel++;
	}

//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMjBeJjBpAiPpDjBnEiCpAjFjMiMlDiClHiCoJiBeC_xHqqkZx_
	mdef_const_iterator(longSet, iId);
	m1_for (iId, stSelectTimeLabelBackup)
	{
		if (m_mpIdToTimeLabel.find(*iId) != m_mpIdToTimeLabel.end())
			m_stSelectTimeLabel.insert(*iId);
	}
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	return bUpdated;
} // CFCHistViewDoc::UpdateTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::ClearTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiOjOiKnEiDiJiDhIiDiLiCpAjBfDiCmEiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNiOjOiKnEiDiJiDhIiDiLiCmMiImKjChFiCmJiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::ClearTimeLabel ()
{
	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDeJiDhFiDfHiDeGiDeOiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	FTIdToTimeLabelMap::iterator iTl;
	for (iTl = m_mpIdToTimeLabel.begin(); iTl != m_mpIdToTimeLabel.end(); iTl++)
	{
		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoIiBeC_xHqqkZx_
		if (g_pView != NULL)
			g_pView->AppendToLastRgn((*iTl).second->GetOuterFrame());
		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		delete (*iTl).second;
	}
	m_mpIdToTimeLabel.clear();
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiOjOiKnEiDiJiDhIiDiLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_stSelectTimeLabel.clear();
} // CFCHistViewDoc::ClearTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::BranchAToC
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhNiCgAiCmMiImKjChFiChHiCmJiOhNiCgCiCpAiNoMjAkMiClFiCmEiBeBiImKjChFiChHiImIiNhOiCmMjHjKjHpAjFlGiPjBiCpAiOhNiCgCiCmJ_xHqqkZx_
 *			_xZkqqHx_iInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocIdA				:_xZkqqHx_iOhNiCgAiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliNextSessionIndexX:_xZkqqHx_iImKjChFiChHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lockBank			:_xZkqqHx_iKgFiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pSpotStreamX		:_xZkqqHx_iImKjChFiChHiCmMiDfIiDhMiDgCiDgHiCmMiDfIiDgHiDiKiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szSpotStreamX		:pSpotStreamX_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsTerminateAToX	:_xZkqqHx_iImKjChFiChHiCmJiPeJjCfLiCpAjAnNjCoIiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 FALSE_xZkqqHx_iCmMiPoKiNiHiCmNiPeJjCfLiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *			bIsMoveForkOnX		:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiChHiCmJiCkAiCoJjHjKjHpAjFkKiKpCiCpAiInKjDkO_xHqqkZx_
 *								 _xZkqqHx_iClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMoveTimeLabelOnX	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiChHiCmJiCkAiCoJiOjOiKnEiDiJiDhIiDiLiCpAiInKjDkO_xHqqkZx_
 *								 _xZkqqHx_iClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhNiCgCiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeCiNoMjAkMiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAiCgAiCmMiImKjChFiChHiCkJiCoHiJlKiCpAiBeBjAfGiClFiCkNiNoMiCmBiClNjHjKjHpAiCgCiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBoFiCkLiCmIjHjKjHpAiCmMjFkBiOmKiBeBiInKjDkOiCmNiOjOiKnEiCkKiCkJiCkJiCoJiClNiCnPiBeBiJlMjFlGiPjBiCpAjFnLjBlGiClFiCmEiCkIiCkCiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLjFkBiOmKjCiGiCmNiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiOgEjHgMiCpAiNgMiCkGiClNiCmMiClOiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jBfDjFjEiCmMjAkOiNiHjAkLiCpAjFnLiCmCiClNiCnPiCmJiCmNiBeBiNmFiMoDiCmMiDhEiDiJiDgCiDfGiDiFiCmFiDhEiDeAiDeDiDiLiInKjDkOiBhL_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiJlMjFlGiPjBiCpAjAlDjFlGiPjBiCnGjFmPiNfI_xHqqkZx_ _xZkqqHx_iCpAiDfKiDgCiDgHiCmFiNhDiCoNiCmIiCkNiCmEiCmNiCmIiCoHiClIiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiMoDiCmMiDhEiDiJiDgCiDfGiDiFiOjOiCmJiCoAiDhGiDiNiDfHiDeGiDeOiDgHiCmNiPjBiCkLiNjOiCnMiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iNmFiMoDiCmMiDhEiDiJiDgCiDfGiDiFiCmNjBoFiCkLiCmIiOjOiKnEiCpAjAoIiCnPiCoJiClNiCnPiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCpAjDhCjCiGiCmF_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiJpAiPjMiClFiCmEiCoAiCkAiCnMiCoIiInDjGkBiCkKiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iCnOiClFiCoLiBeBiNmEiDiNiDgCiDeOiCkKiPgPjHiIiCmIiCkJiCmBiClNiDiNiDfIiCmGiDiKiDfIiDeOiCpAiNgMiCkGiCoJiCmGiBeB_xHqqkZx_
 *			_xZkqqHx_iClIiCmBiCmG_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiInLiOjNiClFiClNjFpLiCkKjHmHiCkCiBeC_xHqqkZx_
 *
 *
 *                        _xZkqqHx_iEkA_xHqqkZx_
 *                        _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkBiBgDiBgDiBgDiEkAiChH_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *                (C)     (A)
 *
 *                      _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                     _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                       _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *                        _xZkqqHx_iEkA_xHqqkZx_
 *                        _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkBiEjPiEjPiEjPiBkLiChH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *                (C)    (A)
 *               _xZkqqHx_iMlD_xHqqkZx_A
 *
 *			_xZkqqHx_iJlKjAhNiCmFiBeB_xHqqkZx_NextSessionIndex=5_xZkqqHx_iBgJ_xHqqkZx_Session4_xZkqqHx_iCmG_xHqqkZx_Session5_xZkqqHx_iCmMiKnEiBgKiCkJiCoHiJlKiCpA_xHqqkZx_
 *			_xZkqqHx_jFmKiOhNiCgCiCmJjFmPiNfIiClHiCoJiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPoKiNiHiBeBiDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiBeBiDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmN_xHqqkZx_Session5_xZkqqHx_iImIiNhO_xHqqkZx_
 *			_xZkqqHx_iBgJ_xHqqkZx_Session5_xZkqqHx_iCpAiKnMiCnOiBgKiCpAiCgCiCnGiInKjDkOiClHiCoKiCmOjHmHiCkCiCkKiBeBjFkKiKpCiBeFjFkKiKpCiDfOiDePiBeF_xHqqkZx_
 *			_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeFiDfIiDhMiDgCiDgHiCmNiDfKiDgCiDfGiDiHiDjDiLkLiKeFiCmJiCkAiCoJiClNiCnPiInKjDkOiClHiCnHiCkLiCkJ_xHqqkZx_
 *			_xZkqqHx_iOgDiClHiCnHiCkLiCkJjElLjCgGiCkKjDoPiClFiCkCiBeC_xHqqkZx_
 *
 *        _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiL_xHqqkZx_                              _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiL_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_                                  _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_Session3_xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_Session3_xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_                                  _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_Session4_xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkBiEjPiEjPiEjPiBkIiEkA_xHqqkZx_Session6_xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkHiEjPiBkIjFkKiKpC_xHqqkZx_J,_xZkqqHx_iDfOiDeP_xHqqkZx_K,        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_Session5_xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iDiJiDhIiDiL_xHqqkZx_L,_xZkqqHx_iDfIiDhMiDgCiDgH_xHqqkZx_M   _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkBiEjPiBkIiEkA_xHqqkZx_Session8_xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_Session6_xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_Session7_xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_Session8_xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *
 *			--------------------------------------------------------------
 *			_xZkqqHx_iImKjChFiChHiCmJjFkKiKpCiCgJiCkKiCkAiCoIiBeBiDfOiDePiCgKiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeBjAfGiClFiCkNiNoMiCoHiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_jFlGiPjBiCgCiCmMiDfOiDeDiDgHiDiLiBeFiDfCiDiBiDjDiDgHjDjJiCmNiDfOiDePiCgKiCmMiPoOjFpBiCkKiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfOiDePiCgKiCmNiOhNiCgAiCmMiImKjChFiChHiImIiNhOiCmMiPoOjFpBiCmIiCmMiCmFiBeBjFlGiPjBiCgCiCmMiPoOjFpBiCmGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_jHjIjHhAiClHiCoJiCmMiCkKiOkJjBfCiBeC_xHqqkZx_
 *			_xZkqqHx_jFkKiKpCiCgJiCmNiOhNiCgAiCmJiOgDiClHiBeCjFkKiKpCiCgJiCmNiOhNiCgAiCmMiPoDjHkMiCkJiCoHiImKjChFiChHiCnMiCmFiCmM_xHqqkZx_
 *			_xZkqqHx_jHkMiCoKiCmMjCiGiCmFjAlGiClGiCoJiCoAiCmMiCmIiCmMiCmFiBeBiOhNiCgAiCmJiOgDiClHiCmMiCkKiOkJjBfCiBeC_xHqqkZx_
 *
 *                        _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ Tag K
 *                        _xZkqqHx_iEkAiBfO_xHqqkZx_
 *                _xZkqqHx_iEkBiBgDiBgDiBgDiEkFiEjP_xHqqkZx_J-_xZkqqHx_iEkC_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBkL_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *                (C)     (A)
 *
 *                      _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                     _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                       _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *                        _xZkqqHx_iEkA_xHqqkZx_
 *              Title K   _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkBiEjPiEjPiEjPiBkLiEjP_xHqqkZx_J-_xZkqqHx_iEkC_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBkL_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *                (C)    (A)
 *               _xZkqqHx_iMlD_xHqqkZx_A
 *
 *			--------------------------------------------------------------
 *			_xZkqqHx_iImKjChFiChHiCmJiOjOiKnEiDiJiDhIiDiLiCgLiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeBiCgLiCpAiCgAiCmJiOgDiClHiCkJ_xHqqkZx_
 *			_xZkqqHx_iCgCiCnGiInKjDkOiClHiCoJiCkJiCmNjDoPiClFiCkCjGoCjBoIiClOiCkKiBeBiImIiJlKiCmMjHjNjHfCiCkJiCoHiCgCiCnG_xHqqkZx_
 *			_xZkqqHx_iInKjDkOiClHiCoJiClBiCmGiCmJiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iBjLiDiJiDhIiDiLiCgLiCmNiBeBiCmHiClPiCoHiCkJiCmGiCkCiCkEiCmGiImKjChFiChHiImIiNhOiCmMiPoOjFpBiCpAjFfMiClH_xHqqkZx_
 *			_xZkqqHx_iBeAiPoKiNiHiCkKjBlNiCkCiClNiCnPiBeBiCgCiCnGiInKjDkOiClFiClNjFpLiCkKjHmHiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iBjLiClBiCmMiKnGjAjEiCmNiBeBiJlKiJeFjAhNiCmMiCoGiCkEiCmJiOhNiCgBiCpAiOoFjHkMiOhNiCmJjAnIiCoIjBnGiCkGiCoJ_xHqqkZx_
 *			_xZkqqHx_iBeAiPoKiNiHiCmJiCoAiOgHiCoNiCoKiCoJiCkKiBeBiCgBiCmMiCgLiCfBiCkKiCgAiCmJiInKjDkOiClFiCmEiCkNiCoJiCmMiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iBeAiCgAiCmMiCgLiCfAiCpAiCgCiCnGiInKjDkOiClFiCmIiCkCiCmGiCgLiCfAiCmGiCgLiCfBiCkKiPgEiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *
 *                        _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ Label L1
 *                        _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkAiBfO_xHqqkZx_
 *                _xZkqqHx_iEkBiBgDiBgDiBgDiEkA_xHqqkZx_- Label L               _xZkqqHx_iEkBiBgDiBgDiBgDiEkFiEjPiEjPiEjPiEkC_xHqqkZx_- Label L2
 *                _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *                _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_                        _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_      (B)
 *                (C)     (A)                       (C)     (A)
 *
 *                      _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_                            _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_                        _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                     _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_                          _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                       _xZkqqHx_iBfPiBfO_xHqqkZx_                              _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *                        _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ Label L2
 *                        _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkAiBfO_xHqqkZx_
 *       Label L -_xZkqqHx_iEkBiEjPiEjPiEjPiBkL_xHqqkZx_              Label L1 -_xZkqqHx_iEkBiEjPiEjPiEjPiEkHiBgDiBgDiBgDiEkC_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *                _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_                        _xZkqqHx_iBkL_xHqqkZx_      (A)     (B)
 *                (C)    (A)                        (C)     _xZkqqHx_iMlD_xHqqkZx_B
 *               _xZkqqHx_iMlD_xHqqkZx_A                               _xZkqqHx_iMlD_xHqqkZx_A
 *
 *
 *			--------------------------------------------------------------
 *			_xZkqqHx_iOhNiCgCiCmJiCmNiBeBiPiJiKpKiDfIiDhMiDgCiDgHiCkKjHfMiCnPjAnNjCoIiClDiCoKiCmEiCkCiCoJiBeCiClBiCmMiClNiCnPiBeBiClLiCmMiCnMiCnM_xHqqkZx_
 *			_xZkqqHx_iOhNiCgAiCmMiChHiImIiNhOiCmMiDfIiDhMiDgCiDgHiCpAiCgCiCmJjCmHiJmBiClFiCmEiClFiCnMiCkEiCmGiBeBiJeFiJlKjAhNiCmMiCoGiCkEiCmJ_xHqqkZx_
 *			_xZkqqHx_iDfIiDhMiDgCiDgHiKnEiCkKiLnPjAnKiClFiCmEiClFiCnMiCkEiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 *                     _xZkqqHx_iCgA_xHqqkZx_                                              _xZkqqHx_iCgA_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_                                              _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iEkAiBkI_xHqqkZx_ M1                                         _xZkqqHx_iEkAiBkI_xHqqkZx_ M1
 *                     _xZkqqHx_iEkA_xHqqkZx_                                              _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkAiBfP_xHqqkZx_                          _xZkqqHx_iEkA_xHqqkZx_
 *      _xZkqqHx_iCgC_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkBiEjPiEkD_xHqqkZx_  _xZkqqHx_iBfP_xHqqkZx_       _xZkqqHx_iCgC_xHqqkZx_               _xZkqqHx_iEkA_xHqqkZx_
 *      _xZkqqHx_iBkLiBkI_xHqqkZx_ m0      _xZkqqHx_iChHiEkH_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        >      _xZkqqHx_iEkAiBkI_xHqqkZx_ m0        _xZkqqHx_iChHiBkL_xHqqkZx_
 *                     _xZkqqHx_iEkAiBkI_xHqqkZx_ M2       _xZkqqHx_iEkEiEjPiEkC_xHqqkZx_  _xZkqqHx_iBfO_xHqqkZx_       _xZkqqHx_iEkAiBkI_xHqqkZx_ M2
 *                     _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkAiBfO_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_                             _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iEkE_xHqqkZx_ _xZkqqHx_iDfIiDhMiDgCiDgH_xHqqkZx_m2_xZkqqHx_iCmG_xHqqkZx_M2_xZkqqHx_iCkK_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_                             _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iLnPjAnKiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_                             _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iEkAiBkI_xHqqkZx_ M3                        _xZkqqHx_iEkAiBkI_xHqqkZx_ M3
 *                     _xZkqqHx_iBkL_xHqqkZx_                             _xZkqqHx_iBkL_xHqqkZx_
 *
 *			_xZkqqHx_iClBiCoKiCpAjGgIiCkOiClNiCnPiCmJiBeB_xHqqkZx_m0_xZkqqHx_iCmG_xHqqkZx_M2_xZkqqHx_iCmMiLjHjHkDiCpAjClCiCnHiCmEiBeBiLjHjHkDiCkKiLnPiCkCiPoKiNiHiCmN_xHqqkZx_M2_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_iDfIiDeMiDgCiDhGiClFiCmE_xHqqkZx_M3_xZkqqHx_iCkJiCoHiDfCiDhDiBfLiClHiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCHistViewDoc::BranchAToC (	FCHiProject& project,
									long lDocIdA,
									flint fliNextSessionIndexX,
									FCDbLockBank& lockBank,
									const BYTE* pSpotStreamX,
									size_t szSpotStreamX,
									BOOL bIsTerminateAToX,
									BOOL bIsMoveForkOnX,
									BOOL bIsMoveTimeLabelOnX)
{
	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	FCHiForkTable forkFileA;
	forkFileA = project.GetSubGroup(lDocIdA);
	forkFileA.UpdateDataA(lockBank);

	FCHiDocumentRec hiDocRecA = project.GetDocumentRec(lDocIdA);

	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjFkKiKpCiImKjChFiCmMjHjKjHpAjFkKiKpCiDfOiDePiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	GUID guidUserIdC;
	FDSECTIME fdstCreateTimeC;
	WString wstrTitleC;
	WString wstrCommentC;
	double dHtreeScoreC;
	if (!forkFileA.IsThereHiForkTag(fliNextSessionIndexX,
									&fdstCreateTimeC,
									&dHtreeScoreC,
									&guidUserIdC,
									&wstrTitleC,
									&wstrCommentC))
	//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCmJjHjKjHpAjFkKiKpCiDfOiDePiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		fdstCreateTimeC = FFGetCurrentSecTime();
		guidUserIdC = FFGetApp()->GetUserId();
		wstrTitleC = hiDocRecA.GetDocTitle();
		wstrCommentC = hiDocRecA.GetComment();
		dHtreeScoreC = 1.0;
	}

	// _xZkqqHx_jAfGiLeLjFkKiKpCjHjKjHpAjFlGiPjBiCpAiBeBiNkBiCmMjHjKjHpAiImKjChFiCkJiCoHjFkKiKpCiClDiClJiCmEiNoMjAkMiBeC_xHqqkZx_
	// _xZkqqHx_iKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjFlGiPjBiCkJiCoHiBeBiDiGiDgKiBfLiDeOiCmIiDgPiBfLiDfHiDiHiDjDiCpAiNoMjAkMiBeC_xHqqkZx_
	WString wstrVersionC = project.GetUniqSubDocumentVersion(lDocIdA);
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjDgPjIfOiBeC_xHqqkZx_
	FCDbReadLock readLock;
	FCDbWriteLock writeLock;
	long lDocIdC = project.RegisterDDDocument(	readLock,
												writeLock,
												-1,
												wstrTitleC,
												guidUserIdC,
												wstrVersionC,
												fdstCreateTimeC,
												wstrCommentC,
												hiDocRecA.GetIsLogCommandUserId(),
												lDocIdA,
												dHtreeScoreC);

	FCHiCommandTable cmdTableA = project.GetSubGroup(lDocIdA);
	cmdTableA.UpdateDataA(lockBank);
	cmdTableA.SeekToSessionIndex(fliNextSessionIndexX);
	cmdTableA.SetupSessionTimeAndIndex();

	if (!FFCreateFirstDocument(	lockBank,
								project,
								lDocIdC,
								pSpotStreamX,
								szSpotStreamX,
								lDocIdA,
								fliNextSessionIndexX,
								cmdTableA.GetPrevSessionTime(),
								cmdTableA.GetPrevSessionUser()))
		return -1;

	if (forkFileA.IsThereHiForkTag(fliNextSessionIndexX, NULL, NULL, NULL))
	//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCmJjHjKjHpAjFkKiKpCiDfOiDePiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jHfMiCnPiNoNiPjMiClFiCmEiCkIiCkJiCmIiCkCiCmGiBeB_xHqqkZx_MoveToTrunkFork_xZkqqHx_iCmFiDeHiDiJiBfLiCkKjEkNjAlGiBeC_xHqqkZx_
		forkFileA.Remove(forkFileA.FindHiForkTag(fliNextSessionIndexX));
	}

	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCkJiCoHiNmFiMoDiCnMiCmFiCpAiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmJiInKjDkOiBeC_xHqqkZx_
	if (!MoveBranch(	project,
						lDocIdA,
						lDocIdC,
						fliNextSessionIndexX,
						lockBank,
						bIsTerminateAToX,
						bIsMoveForkOnX,
						bIsMoveTimeLabelOnX))
		return -1;

	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiCmJiBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
	forkFileA.AppendFork(	fliNextSessionIndexX,
							lDocIdC);

	//----- DSM_xZkqqHx_jHjKjHpAiCpAjFoCjAlDiClHiCoJ_xHqqkZx_ -----
	vector< auto_ptr<FCDsmRec> >::iterator iHrec;
	for (iHrec = m_vDsmHistory.begin(); iHrec != m_vDsmHistory.end(); iHrec++)
	{
		if ((*iHrec)->m_hstrProjectFilePath == project.GetTableName().GetTopDirPath())
		//----- _xZkqqHx_jDkPiClGiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if ((*iHrec)->m_lDocumentId == lDocIdA &&
				fliNextSessionIndexX < (*iHrec)->m_fliSessionIndex)
			//----- _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCoGiCoIiCoAiJlKiCmJjHjKjHpAiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
			{
				(*iHrec)->m_lDocumentId = lDocIdC;
			}
		}
	}
	return lDocIdC;
} // CFCHistViewDoc::BranchAToC.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetIsUseTimeIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOgHiCkEiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::GetIsUseTimeIndex () const
{
	return m_bIsUseTimeIndex;
} // CFCHistViewDoc::GetIsUseTimeIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SetIsUseTimeIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsUseTimeIndex	:_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::SetIsUseTimeIndex (BOOL bIsUseTimeIndex)
{
	if (m_bIsUseTimeIndex != bIsUseTimeIndex)
	{
		m_bIsUseTimeIndex = bIsUseTimeIndex;
		FFHistViewFrame()->UseTimeIndexChangedNotify(bIsUseTimeIndex);
	}
} // CFCHistViewDoc::SetIsUseTimeIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SyncTimeIndexToCurrent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjHjKjHpAjFlGiPjBiCmMiMlLiNnNiImKjChFiCmJiDfGiBfLiDeOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDeOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiImKjChFiCmJjBmOiJjOiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCkKjBlGiNnNiClHiCoJiCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::SyncTimeIndexToCurrent ()
{
	if (m_pFileTimeIndex != NULL)
	//----- _xZkqqHx_iOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiMiDfCiBfLiDgIjAjEiCkKiCePiCmMiPoKiNiHiCmNiDeHiDiJiBfLjCgM_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
		if (m_pFileTimeIndex->GetCount() == 0)
			return FALSE;
		// _xZkqqHx_jHjKjHpAiImKjChFiCkKiIoKjChGiClHiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
		long lDocumentId;
		flint fliSessionIndex;
		m_pFileTimeIndex->See(NULL, &lDocumentId, &fliSessionIndex);
		if (lDocumentId == GetDocumentId() &&
			fliSessionIndex == GetNextSessionIndexAbout())
			return TRUE;

		//----- LowerBound _xZkqqHx_iCpAiLiBiCnPiCoJ_xHqqkZx_ -----

		// _xZkqqHx_iMlLiNnNiCmMiImKjChFiBeC_xHqqkZx_
		const FCTimeIndexRec timeIndexRecCurrent(GetPrevSessionTime(), GetDocumentId(), GetNextSessionIndexAbout());
		// _xZkqqHx_iJlKiMmAjCgMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
		flint fliIndexLower = 0;
		// _xZkqqHx_iPoDiMmAjCgMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
		flint fliIndexUpper = m_pFileTimeIndex->GetCount() - 1;
		// _xZkqqHx_iPoDiMmAjCgMiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		FCTimeIndexRec timeIndexRecUpper;
		m_pFileTimeIndex->See(timeIndexRecUpper, fliIndexUpper);

		// _xZkqqHx_iOhHjCoIiCmMiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCkKiPoDiMmAjCgMiCmJjDpMiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jDpMiCoHiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLjCgM_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
		if (timeIndexRecUpper < timeIndexRecCurrent)
			return FALSE;

		while (1 < fliIndexUpper - fliIndexLower)
		//----- _xZkqqHx_iPoDiMmAjCgMiBeBiJlKiMmAjCgMiCmMiNlHiCkKiCfBiImIiPoDiCmMiKnEiCmNiDiLiBfLiDhG_xHqqkZx_ -----
		{
			// _xZkqqHx_iPoDiMmAiCmGiJlKiMmAiCmMjCiGiKnEiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOfKiPgPiBeC_xHqqkZx_
			const flint fliIndexMiddle = (fliIndexLower + fliIndexUpper) / 2;
			// _xZkqqHx_jCiGiKnEiCmMiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
			FCTimeIndexRec timeIndexRecMiddle;
			m_pFileTimeIndex->See(timeIndexRecMiddle, fliIndexMiddle);
			// _xZkqqHx_iPoDiMmAiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iBeBiJlKiMmAiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCmGjEoEiKhCiClFiCmEiPoDiMmAiBeFiJlKiMmAiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFmPiNfIiBeC_xHqqkZx_
			if (timeIndexRecMiddle < timeIndexRecCurrent)
				fliIndexLower = fliIndexMiddle;
			else
				fliIndexUpper = fliIndexMiddle;
		}
		// _xZkqqHx_iPoDiMmAiDeDiDjDiDgGiDgCiDeOiDfIiCmGiJlKiMmAiDeDiDjDiDgGiDgCiDeOiDfIiCmMiNlHiCmNiCfAiBeCiCmHiClPiCoHiCkJiCmJjCgMiCkKiCkAiCoJiCmNiClIiBeC_xHqqkZx_
		// _xZkqqHx_iJlKiMmAiCmMiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
		FCTimeIndexRec timeIndexRecLower;
		m_pFileTimeIndex->See(timeIndexRecLower, fliIndexLower);
		// _xZkqqHx_iJlKiMmAiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCmGjEoEiKhCiBeC_xHqqkZx_
		if (timeIndexRecLower < timeIndexRecCurrent)
		{
			m_pFileTimeIndex->SetCurrentIndex(fliIndexUpper);
		} else
		{
			m_pFileTimeIndex->SetCurrentIndex(fliIndexLower);
		}
		return TRUE;
	} else
	{
		return FALSE;
	}
} // CFCHistViewDoc::SyncTimeIndexToCurrent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SeekTimeIndexSession
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiBeBiOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDjFkKiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionCount	:_xZkqqHx_iInKjDkOiClHiCoJiDfKiDgCiDfGiDiHiDjDjAjEiCpAiOhHjCoIiBeCjFiJiCmMjCgMiCmFiCoAjHmHiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCkCiCkNiCoHiCkJiCmFiCoAiInKjDkOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiCnMiCmBiClNiCkNiInKjDkOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::SeekTimeIndexSession (flint fliSessionCount)
{
	// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	flint fliIndex = m_pFileTimeIndex->GetCurrentIndex();
	fliIndex += fliSessionCount;
	if (0 < fliSessionCount)
	{
		if (m_pFileTimeIndex->GetCount() <= fliIndex)
			fliIndex = m_pFileTimeIndex->GetCount() - 1;
	} else
	{
		if (fliIndex < 0)
			fliIndex = 0;
	}

	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkKiInKjDkOiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmNiJlNiCoAiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (fliIndex == m_pFileTimeIndex->GetCurrentIndex())
		return FALSE;

	// _xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmJiInKjDkOiBeC_xHqqkZx_
	m_pFileTimeIndex->SetCurrentIndex(fliIndex);
	return TRUE;
} // CFCHistViewDoc::SeekTimeIndexSession.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SeekTimeIndexIntervalBefore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiBeBiOhHjCoIiClDiCoKiClNiDeDiDjDiDfOiBfLiDgPiDiLiClOiCkP_xHqqkZx_
 *			_xZkqqHx_iKnEiKhFiCkKiLpDiCkCiClNiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstInterval:_xZkqqHx_iDeDiDjDiDfOiBfLiDgPiDiLiCmMjFgCjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCkCiCkNiCoHiCkJiCmFiCoAiInKjDkOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiCnMiCmBiClNiCkNiInKjDkOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::SeekTimeIndexIntervalBefore (FDSECTIME fdstInterval)
{
	// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiBeC_xHqqkZx_
	const flint fliCurrentIndex = m_pFileTimeIndex->GetCurrentIndex();
	// _xZkqqHx_jBePiDfKiDgCiDfGiDiHiDjDiCmMiOjOiKnEiCpAiOoGjDlOiBeC_xHqqkZx_
	// fliCurrentIndex == m_pFileTimeIndex->GetCount() _xZkqqHx_iCmNjGlDiCkCiCmNiClIiBeC_xHqqkZx_
	FDSECTIME fdstPrevTime = m_pFileTimeIndex->SeeSessionTime(fliCurrentIndex);
	for (;;)
	{
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FDSECTIME fdstSessionTime;
		if (!m_pFileTimeIndex->RRead(&fdstSessionTime, NULL, NULL))
		{
			// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiNmFiPiJiCmJiInKjDkOiBeC_xHqqkZx_
			m_pFileTimeIndex->SetCurrentIndex(0);
			break;
		}
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmMiMgPiJnPiOjOiKnEiCkKiOhHjCoIjCgMiCpAjClEiCkGiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (fdstInterval <= fdstPrevTime - fdstSessionTime)
			break;
		// _xZkqqHx_jBePiDfKiDgCiDfGiDiHiDjDiCmMiOjOiKnEiBeC_xHqqkZx_
		fdstPrevTime = fdstSessionTime;
	}
	// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmNiInKjDkOiClFiClNiCkJiBeI_xHqqkZx_
	return (fliCurrentIndex != m_pFileTimeIndex->GetCurrentIndex());
} // CFCHistViewDoc::SeekTimeIndexIntervalBefore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SeekTimeIndexIntervalAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiBeBiOhHjCoIiClDiCoKiClNiDeDiDjDiDfOiBfLiDgPiDiLiClOiCkP_xHqqkZx_
 *			_xZkqqHx_iKnEiKhFiCkKiLpDiCkCiClNiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstInterval:_xZkqqHx_iDeDiDjDiDfOiBfLiDgPiDiLiCmMjFgCjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCkCiCkNiCoHiCkJiCmFiCoAiInKjDkOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiCnMiCmBiClNiCkNiInKjDkOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::SeekTimeIndexIntervalAfter (FDSECTIME fdstInterval)
{
	// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiBeC_xHqqkZx_
	const flint fliCurrentIndex = m_pFileTimeIndex->GetCurrentIndex();
//----- 06.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiPeJjCfLiCmJiDhMiDeDiDjDiDfOiCkKiCkAiCoJiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
//	if (fliCurrentIndex == m_pFileTimeIndex->GetCount() - 1)
//		return FALSE;
//----- 06.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jBePiDfKiDgCiDfGiDiHiDjDiCmMiOjOiKnEiCpAiOoGjDlOiBeC_xHqqkZx_
	FDSECTIME fdstPrevTime;
	m_pFileTimeIndex->Read(&fdstPrevTime, NULL, NULL);
	for (;;)
	{
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FDSECTIME fdstSessionTime;
		if (!m_pFileTimeIndex->Read(&fdstSessionTime, NULL, NULL))
		{
			// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiNmFiMoDiCmJiInKjDkOiBeC_xHqqkZx_
			m_pFileTimeIndex->SetCurrentIndex(m_pFileTimeIndex->GetCount() - 1);
			break;
		}
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmMiMgPiJnPiOjOiKnEiCkKiOhHjCoIjCgMiCpAjClEiCkGiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (fdstInterval <= fdstSessionTime - fdstPrevTime)
		{
			// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjClMjBePiCmJiInKjDkOiBeC_xHqqkZx_
			m_pFileTimeIndex->SetCurrentIndex(m_pFileTimeIndex->GetCurrentIndex() - 1);
			break;
		}
		// _xZkqqHx_jBePiDfKiDgCiDfGiDiHiDjDiCmMiOjOiKnEiBeC_xHqqkZx_
		fdstPrevTime = fdstSessionTime;
	}
	// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmNiInKjDkOiClFiClNiCkJiBeI_xHqqkZx_
	return (fliCurrentIndex != m_pFileTimeIndex->GetCurrentIndex());
} // CFCHistViewDoc::SeekTimeIndexIntervalAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SeekTimeIndexPassedBefore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiBeBiOhHjCoIiClDiCoKiClNiOjOiKnEiImIiPoDiJnPiCkMiClN_xHqqkZx_
 *			_xZkqqHx_iImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstPass:_xZkqqHx_jFgCjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCkCiCkNiCoHiCkJiCmFiCoAiInKjDkOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiCnMiCmBiClNiCkNiInKjDkOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::SeekTimeIndexPassedBefore (FDSECTIME fdstPass)
{
	// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiBeC_xHqqkZx_
	const flint fliCurrentIndex = m_pFileTimeIndex->GetCurrentIndex();
	// _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiOoGjDlOiBeC_xHqqkZx_
	// fliCurrentIndex == m_pFileTimeIndex->GetCount() _xZkqqHx_iCmNjGlDiCkCiCmNiClIiBeC_xHqqkZx_
	FDSECTIME fdstCurrentTime = m_pFileTimeIndex->SeeSessionTime(fliCurrentIndex);
	for (;;)
	{
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FDSECTIME fdstSessionTime;
		if (!m_pFileTimeIndex->RRead(&fdstSessionTime, NULL, NULL))
		{
			// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiNmFiPiJiCmJiInKjDkOiBeC_xHqqkZx_
			m_pFileTimeIndex->SetCurrentIndex(0);
			break;
		}
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmMiMgPiJnPiOjOiKnEiCkKiOhHjCoIjCgMiCpAjClEiCkGiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (fdstPass <= fdstCurrentTime - fdstSessionTime)
			break;
	}
	// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmNiInKjDkOiClFiClNiCkJiBeI_xHqqkZx_
	return (fliCurrentIndex != m_pFileTimeIndex->GetCurrentIndex());
} // CFCHistViewDoc::SeekTimeIndexPassedBefore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SeekTimeIndexPassedAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiBeBiOhHjCoIiClDiCoKiClNiOjOiKnEiImIiPoDiJnPiCkMiClN_xHqqkZx_
 *			_xZkqqHx_iImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstPass:_xZkqqHx_jFgCjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCkCiCkNiCoHiCkJiCmFiCoAiInKjDkOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiCnMiCmBiClNiCkNiInKjDkOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::SeekTimeIndexPassedAfter (FDSECTIME fdstPass)
{
	// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiBeC_xHqqkZx_
	const flint fliCurrentIndex = m_pFileTimeIndex->GetCurrentIndex();
	// _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiOoGjDlOiBeC_xHqqkZx_
	FDSECTIME fdstCurrentTime;
	m_pFileTimeIndex->Read(&fdstCurrentTime, NULL, NULL);
	for (;;)
	{
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FDSECTIME fdstSessionTime;
		if (!m_pFileTimeIndex->Read(&fdstSessionTime, NULL, NULL))
		{
			// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiNmFiMoDiCmJiInKjDkOiBeC_xHqqkZx_
			m_pFileTimeIndex->SetCurrentIndex(m_pFileTimeIndex->GetCount() - 1);
			break;
		}
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmMiMgPiJnPiOjOiKnEiCkKiOhHjCoIjCgMiCpAjClEiCkGiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (fdstPass <= fdstSessionTime - fdstCurrentTime)
		{
			// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjClMjBePiCmJiInKjDkOiBeC_xHqqkZx_
			m_pFileTimeIndex->SetCurrentIndex(m_pFileTimeIndex->GetCurrentIndex() - 1);
			break;
		}
	}
	// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmNiInKjDkOiClFiClNiCkJiBeI_xHqqkZx_
	return (fliCurrentIndex != m_pFileTimeIndex->GetCurrentIndex());
} // CFCHistViewDoc::SeekTimeIndexPassedAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::GetNextSameLevelBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiOhNiCmMiOjPiBgJiJeFjHnHiBgKiCmMiOhNiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId			:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMiOhNiCmMjAgFiBgJiKlCiBgKiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocIdSub		:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMiOhNiCkKjFkKiKpCiClFiCmEiCkCiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjPiCmMiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeCiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiCmNiBeBiCgAiBgAiCgGiCmMiOhNiCmNjBfDiCmEjDkPiClGiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBgJiChHiBgK_xHqqkZx_
 *			_xZkqqHx_iCkJiCoHjAeMiCnBiCmEiCkCiCoJiCmGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPoKiNiHiBeBiNkBiCgAiCmJiCkAiCoJiCmGiClHiCoJiCmGiBeBiCgAiBkIiCgBiBkIiCgCiBkIiCgDiBkIiCgEiBkIiCgFiBkIiCgGiBkIiCgOiBeFiBeFiBeF_xHqqkZx_
 *			_xZkqqHx_iCmGiCkCiCkEiPiHiCmFiDfEiDeDiDeOiDiLiClHiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_
 *        _xZkqqHx_iChHiElAiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkN_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiElBiEkKiElBiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiElBiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iCgO_xHqqkZx_              _xZkqqHx_iCgA_xHqqkZx_  _xZkqqHx_iCgB_xHqqkZx_  _xZkqqHx_iCgC_xHqqkZx_  _xZkqqHx_iCgD_xHqqkZx_  _xZkqqHx_iCgE_xHqqkZx_  _xZkqqHx_iCgF_xHqqkZx_  _xZkqqHx_iCgG_xHqqkZx_
 *
 *			_xZkqqHx_iCfAiBeEiCnMiClIiBeBiMlLiNnNiCmMiOhNiBgJ_xHqqkZx_lDocIdSub_xZkqqHx_iBgKiCmGjDkPiClGiDiMiDhIiDiLiCmMiOhNiCpAjBfDiCmEiPfHiCnPiBeB_xHqqkZx_
 *				_xZkqqHx_iBhFiDfOiDeDiDgHiDiLiBhLiDgPiBfLiDfHiDiHiDjDiBhGjFlGiOjKjHpBiCmFiDfMiBfLiDgHiClHiCoJiBgJiDiKiDfIiDgHiCgLiBgKiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEiOjPiCmJiBeBiDiKiDfIiDgHiCgLjCiGiCmFiBeBiOhNiBgJ_xHqqkZx_lDocIdSub_xZkqqHx_iBgKiCmMiOjPiCmMiOhNiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeEiOjPiCmMiOhNiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiBgJiCmCiCnMiCoIiMlLiNnNiCmMiOhNiCkKjDkPiClGiDiMiDhIiDiLiCmFiNmFiMoDiCmMiPoKiNiHiBgKiCmNiBeB_xHqqkZx_
 *				_xZkqqHx_iKlCiBgJ_xHqqkZx_lDocId_xZkqqHx_iBgKiCkKjDkPiClGiDiMiDhIiDiLiCkJiCoHjFkKiKpCiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeCjHoBiCkGiCmOiPoDjAhNiCmM_xHqqkZx_
 *				_xZkqqHx_iPoKiNiHiClOiCmGiBeBiMlLiNnNiCmMiOhNiCkKiCgFiCmMiPoKiNiHiCmJiBeBiKlCiCgDiCkKiChHiCkJiCoHiKeKiOgOiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfDiBeEiKlCiCkKjDkPiClGiDiMiDhIiDiLiCmFiCkAiCoKiCmOiBeBiKlCiCmJjBmOiClFiCmEiBeBiNmEiLeBjDeJiCmJjDkPiClGiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfEiBeEiKlCiCkKjDkPiClGiDiMiDhIiDiLiCmFiCmIiCkPiCoKiCmOiBeBiKlCiCpAiOjPiCmMiOhNiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iCfFiBeEiOjPiCmMiOhNiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiClLiCoKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCHistViewDoc::GetNextSameLevelBranch (long lDocId, long lDocIdSub, flint fliSessionIndex)
{
//----- 06.01.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCHiForkTable forkFile;
//	{
//		FCDbReadLock autoLockForkRead;
//		FTDocReqResult result = OnReqLockAndUpdate(	NULL,
//													lDocId,
//													FCDbReadLock(),
//													*g_pProject,
//													&autoLockForkRead,
//													&forkFile);
//		if (result != FD_DRR_OK) return -1;
//	}
//
//	// _xZkqqHx_iDfOiDeDiDgHiDiLiBeFiDgPiBfLiDfHiDiHiDjD_xHqqkZx_ -> _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
//	multimap<pair<flint, WString>, long, FCLessBranch> mmpSessionToDocId;
//
//	//----- _xZkqqHx_jDkPiClGiDiMiDhIiDiLiCmMiOhNiCpAiDiKiDfIiDgHiDeBiDgCiDhG_xHqqkZx_ -----
//	FCForkConstIterator iFork;
//	for (iFork = forkFile.FindFork(fliSessionIndex);
//		 !iFork.IsEnd() && iFork.GetSessionIndex() == fliSessionIndex;
//		 iFork++)
//	{
//		// _xZkqqHx_iJlMjFkKiKpCiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (iFork.GetIsTemporary()) continue;
//		// _xZkqqHx_iDfOiDeDiDgHiDiLiBhLiDgPiBfLiDfHiDiHiDjDiCmMjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
//		WString wstrTitle = g_pProject->GetDocumentRec(iFork.GetDocumentId()).GetDocTitle();
//		WString wstrVersion = g_pProject->GetDocumentRec(iFork.GetDocumentId()).GetVersion();
//		// _xZkqqHx_iDhDiDiKiDeJiDgIiCmNjHfMiCnPiDgOiDeDiDhEiDjDiCmJjFmPiNfIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
//		wstrTitle.Replace(L'.', L'-');
//		// _xZkqqHx_iDfOiDeDiDgHiDiLiCmGiDgPiBfLiDfHiDiHiDjDiCpAiDhDiDiKiDeJiDgIiCmFjAnKjBlBiBeC_xHqqkZx_
//		wstrTitle += L'.' + wstrVersion;
//		mmpSessionToDocId.insert(pair<pair<flint, WString>, long>(pair<flint, WString>(fliSessionIndex, wstrTitle), iFork.GetDocumentId()));
//	}
//	// _xZkqqHx_iDfOiDeDiDgHiDiLiBhLiDgPiBfLiDfHiDiHiDjDiCmMjFlGiOjKjHpBiCmFiDfMiBfLiDgHiBeC_xHqqkZx_
//	longVector vDocId;
//	vDocId.push_back(lDocId);
//	multimap<pair<flint, WString>, long, FCLessBranch>::reverse_iterator i;
//	for (i = mmpSessionToDocId.rbegin(); i != mmpSessionToDocId.rend(); i++)
//		vDocId.push_back((*i).second);
//	// _xZkqqHx_iDiKiDfIiDgHiCkJiCoHiBeBiIoKiCmCiOjPiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//	longVector::const_iterator iVid = std::find(vDocId.begin(), vDocId.end(), lDocIdSub);
//	iVid++;
//	if (iVid == vDocId.end())
//	//----- _xZkqqHx_iOjPiCmMjFlGiPjBiCgIiCgDiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		flint fliSessionIdxSuper;
//		long lDocIdSuper;
//		// _xZkqqHx_iPoDiImKiCmMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
//		forkFile.GetSuperInfo(&fliSessionIdxSuper, &lDocIdSuper);
//		// _xZkqqHx_jDkPiClGiDiMiDhIiDiLiChHiCmFiKeKiOgOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiNmEiLeBjDeJiCmJiOmAiNhDiBeC_xHqqkZx_
//		if (lDocIdSuper != -1 && fliSessionIdxSuper == fliSessionIndex)
//			return GetNextSameLevelBranch(lDocIdSuper, lDocId, fliSessionIndex);
//		else
//			return lDocId;
//	}
//	return *iVid;
//----- 06.01.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	FCDbReadLock autoLockProjectRead;
	FCDbReadLock autoLockForkRead;
	FCHiForkTable forkFile;
	FTDocReqResult result = OnReqLockAndUpdate(	NULL,
												lDocId,
												autoLockProjectRead,
												NULL,
												*g_pProject,
												&autoLockForkRead,
												NULL,
												&forkFile);
	if (result != FD_DRR_OK) return -1;

	// _xZkqqHx_iPoDiImKiCmMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	flint fliSessionIdxSuper;
	long lDocIdSuper;
	forkFile.GetSuperInfo(&fliSessionIdxSuper, &lDocIdSuper);

	// _xZkqqHx_iDfOiDeDiDgHiDiLiBeFiDgPiBfLiDfHiDiHiDjD_xHqqkZx_ -> _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	multimap<pair<flint, WString>, long, FCLessBranch> mmpSessionToDocId;

	//----- _xZkqqHx_jDkPiClGiDiMiDhIiDiLiCmMiOhNiCpAiDiKiDfIiDgHiDeBiDgCiDhG_xHqqkZx_ -----
	FCForkConstIterator iFork;
	for (iFork = forkFile.FindFork(fliSessionIndex);
		 !iFork.IsEnd() && iFork.GetSessionIndex() == fliSessionIndex;
		 iFork++)
	{
		// _xZkqqHx_iJlMjFkKiKpCiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		if (iFork.GetIsTemporary()) continue;
		// _xZkqqHx_iDfOiDeDiDgHiDiLiBhLiDgPiBfLiDfHiDiHiDjDiCmMjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
		WString wstrTitle = g_pProject->GetDocumentRec(iFork.GetDocumentId()).GetDocTitle();
		WString wstrVersion = g_pProject->GetDocumentRec(iFork.GetDocumentId()).GetVersion();
		// _xZkqqHx_iDhDiDiKiDeJiDgIiCmNjHfMiCnPiDgOiDeDiDhEiDjDiCmJjFmPiNfIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		wstrTitle.Replace(L'.', L'-');
		// _xZkqqHx_iDfOiDeDiDgHiDiLiCmGiDgPiBfLiDfHiDiHiDjDiCpAiDhDiDiKiDeJiDgIiCmFjAnKjBlBiBeC_xHqqkZx_
		wstrTitle += L'.' + wstrVersion;
		mmpSessionToDocId.insert(pair<pair<flint, WString>, long>(pair<flint, WString>(fliSessionIndex, wstrTitle), iFork.GetDocumentId()));
	}
	// _xZkqqHx_iDfOiDeDiDgHiDiLiBhLiDgPiBfLiDfHiDiHiDjDiCmMjFlGiOjKjHpBiCmFiDfMiBfLiDgHiBeC_xHqqkZx_
	longVector vDocId;
	vDocId.push_back(lDocId);
	multimap<pair<flint, WString>, long, FCLessBranch>::reverse_iterator i;
	for (i = mmpSessionToDocId.rbegin(); i != mmpSessionToDocId.rend(); i++)
		vDocId.push_back((*i).second);
	// _xZkqqHx_iDiKiDfIiDgHiCkJiCoHiBeBiIoKiCmCiOjPiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	longVector::const_iterator iVid = std::find(vDocId.begin(), vDocId.end(), lDocIdSub);
	iVid++;
	if (iVid == vDocId.end())
	//----- _xZkqqHx_iOjPiCmMjFlGiPjBiCgIiCgDiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDkPiClGiDiMiDhIiDiLiChHiCmFiKeKiOgOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiNmEiLeBjDeJiCmJiOmAiNhDiBeC_xHqqkZx_
		if (lDocIdSuper != -1 && fliSessionIdxSuper == fliSessionIndex)
			return GetNextSameLevelBranch(lDocIdSuper, lDocId, fliSessionIndex);
		else
			return lDocId;
	}
	return *iVid;
//----- 06.01.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistViewDoc::GetNextSameLevelBranch.

//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::MoveToBranchCommandFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKlCiCkJiCoHiOhNiCnGiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pwstrErrMessage		:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lTrunkDocId			:_xZkqqHx_iKlCiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lBranchDocId		:_xZkqqHx_iOhNiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndexX	:_xZkqqHx_iImKjChFiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkCommandPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkIndexPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKiCmMjAhNiCmFiBeBiOhNiCgCiCmJiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiBeB_xHqqkZx_
// *			_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
// *			_xZkqqHx_iCgAiCmMiImKjChFiChHiCkJiCoHiJlKiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpA_xHqqkZx_
// *			_xZkqqHx_iOhNiCgCiCmJjFkBiOmKiBeC_xHqqkZx_
// *			_xZkqqHx_iCgAiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiImKjChFiChHiCkJiCoH_xHqqkZx_
// *			_xZkqqHx_iJlKiCpAjAnIiCoIiLgMiCnPiCoJiBeC_xHqqkZx_
// *
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkBiBgDiBgDiBgDiEkAiChH_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *          _xZkqqHx_iCgC_xHqqkZx_      _xZkqqHx_iCgA_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCHistViewDoc::MoveToBranchCommandFile (	FCHiProject& project,
//												long lTrunkDocId,
//												long lBranchDocId,
//												flint fliSessionIndexX,
//												flint fliTrunkCommandPtrX,
//												flint fliTrunkIndexPtrX)
//{
//#if 0
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockCommandTrunkRead(project.GetFilePathH(), lTrunkDocId, FDHI_COMMAND_TABLE_ID);
//	FCDbReadLock autoLockCommandBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_COMMAND_TABLE_ID);
//	FCDbWriteLock autoLockCommandTrunkWrite(project.GetFilePathH(), lTrunkDocId, FDHI_COMMAND_TABLE_ID);
//	FCDbWriteLock autoLockCommandBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_COMMAND_TABLE_ID);
//	if (!autoLockCommandTrunkRead.TryLock()) return FALSE;
//	if (!autoLockCommandBranchRead.TryLock()) return FALSE;
//	if (!autoLockCommandTrunkWrite.TryLock()) return FALSE;
//	if (!autoLockCommandBranchWrite.TryLock()) return FALSE;
//
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockIndexTrunkRead(project.GetFilePathH(), lTrunkDocId, FDHI_SUMMARY_TABLE_ID);
//	FCDbReadLock autoLockIndexBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_SUMMARY_TABLE_ID);
//	FCDbWriteLock autoLockIndexTrunkWrite(project.GetFilePathH(), lTrunkDocId, FDHI_SUMMARY_TABLE_ID);
//	FCDbWriteLock autoLockIndexBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_SUMMARY_TABLE_ID);
//	if (!autoLockIndexTrunkRead.TryLock()) return FALSE;
//	if (!autoLockIndexBranchRead.TryLock()) return FALSE;
//	if (!autoLockIndexTrunkWrite.TryLock()) return FALSE;
//	if (!autoLockIndexBranchWrite.TryLock()) return FALSE;
//
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockTerminateTrunkRead(project.GetFilePathH(), lTrunkDocId, FDHI_TERMINATE_TABLE_ID);
//	FCDbReadLock autoLockTerminateBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_TERMINATE_TABLE_ID);
//	FCDbWriteLock autoLockTerminateTrunkWrite(project.GetFilePathH(), lTrunkDocId, FDHI_TERMINATE_TABLE_ID);
//	FCDbWriteLock autoLockTerminateBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_TERMINATE_TABLE_ID);
//	if (!autoLockTerminateTrunkRead.TryLock()) return FALSE;
//	if (!autoLockTerminateBranchRead.TryLock()) return FALSE;
//	if (!autoLockTerminateTrunkWrite.TryLock()) return FALSE;
//	if (!autoLockTerminateBranchWrite.TryLock()) return FALSE;
//
//	// _xZkqqHx_iKlCiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiKeKiCkCiCmEiBeBiPoOjFpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
//	FCHiCommandTable gateTrunk;
//	gateTrunk.OpenExisting(project, lTrunkDocId, TRUE, TRUE);
//	// _xZkqqHx_iPeDjAlDiDhEiDiJiDePiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
//	gateTrunk.ResetTableModifiedIdentifier();
//	// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiImKjChFiCnMiCmFiDfGiBfLiDeOiBeC_xHqqkZx_
//	gateTrunk.SeekToSessionIndex(fliTrunkCommandPtrX);
//	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBjFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
//	gateTrunk.SetupSessionTimeAndIndex();
//	const FDSECTIME fdstTrunkSessionTimeX = gateTrunk.GetPrevSessionTime();
//	gateTrunk.Close();
//
//	// _xZkqqHx_iOhNiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
//	CFCHIFSFile fileBranchCommand(	project.GetDocumentPath(lBranchDocId, FDHI_COMMAND_TABLE_ID),
//									TRUE,
//									TRUE,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////									GENERIC_READ|GENERIC_WRITE,
////									0,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//									CREATE_NEW, NULL, NULL);
//	// _xZkqqHx_jAoGjDkKiCmJiDfKiDgCiDfGiDiHiDjDiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	fileBranchCommand.Write(&fliSessionIndexX, sizeof(fliSessionIndexX));
//	// _xZkqqHx_jAoGjDkKiCmJiOjOiKnEiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	fileBranchCommand.Write64(&fdstTrunkSessionTimeX, sizeof(fdstTrunkSessionTimeX));
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//	fileBranchCommand.Close();
//
//	// _xZkqqHx_iOhNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
//	CFCHIFSFile(project.GetDocumentPath(lBranchDocId, FDHI_SUMMARY_TABLE_ID),
//				TRUE,
//				FALSE,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////				GENERIC_READ|GENERIC_WRITE,
////				0,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//				CREATE_NEW, NULL, NULL);
//
//	// _xZkqqHx_iOhNiCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
//	FCHiTerminateTable().OpenCreate(project,
//										lBranchDocId,
//										fliSessionIndexX);
//
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiKlCiCkJiCoHiOhNiCnGjFkBiOmKiClHiCoJiBeC_xHqqkZx_
//	if (!CopyCommandFile(project,
//						lTrunkDocId,
//						lBranchDocId,
//// 04.12.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////						fliSessionIndexX,
//						fliTrunkCommandPtrX,
//						fliTrunkIndexPtrX)) return FALSE;
//
//	// _xZkqqHx_iKlCiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
//	CFCHIFSFile fileTrunkCommand(	project.GetDocumentPath(lTrunkDocId, FDHI_COMMAND_TABLE_ID),
//									TRUE,
//									TRUE,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////									GENERIC_READ|GENERIC_WRITE,
////									0,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//									OPEN_EXISTING, NULL, NULL);
//	// _xZkqqHx_jDfNjBjHiCpAiKeKiOgOiClFiClNiImKjChFiCnGiInKjDkOiBeC_xHqqkZx_
//	fileTrunkCommand.Seek64(fliTrunkCommandPtrX, FILE_BEGIN);
//	// _xZkqqHx_iImIiNhOiCmMiDgGiBfLiDfOiCpAiNoNiPjMiBeC_xHqqkZx_
//	fileTrunkCommand.EraseLater();
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//	fileTrunkCommand.Close();
//
//	// _xZkqqHx_iKlCiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
//	CFCHIFSFile fileTrunkIndex(	project.GetDocumentPath(lTrunkDocId, FDHI_SUMMARY_TABLE_ID),
//								TRUE,
//								FALSE,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////								GENERIC_READ|GENERIC_WRITE,
////								0,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//								OPEN_EXISTING, NULL, NULL);
//	// _xZkqqHx_jDfNjBjHiCpAiKeKiOgOiClFiClNiImKjChFiCnGiInKjDkOiBeC_xHqqkZx_
//	fileTrunkIndex.Seek64(fliTrunkIndexPtrX, FILE_BEGIN);
//	// _xZkqqHx_iImIiNhOiCmMiDgGiBfLiDfOiCpAiNoNiPjMiBeC_xHqqkZx_
//	fileTrunkIndex.EraseLater();
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//	fileTrunkIndex.Close();
//
//	//----- _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiPeDjAlDiClHiCoJ_xHqqkZx_ -----
//
//	// _xZkqqHx_iKlCiCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
//	FCHiTerminateTable cmdTermFileTrunk;
//	cmdTermFileTrunk.OpenExisting(project, lTrunkDocId);
//	cmdTermFileTrunk.UpdateEndSessionIndex(fliSessionIndexX);
//	cmdTermFileTrunk.Close();
//#endif//0
//	return TRUE;
//} // CFCHistViewDoc::MoveToBranchCommandFile.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::MoveToTrunkCommandFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhNiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiBeBjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpA_xHqqkZx_
// *			_xZkqqHx_iKlCiCnGiInKjDkOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pwstrErrMessage		:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lTrunkDocId			:_xZkqqHx_iKlCiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lBranchDocId		:_xZkqqHx_iOhNiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndexX	:_xZkqqHx_iImKjChFiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkCommandPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkIndexPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKiCmMjAhNiCmFiBeBiOhNiCgBiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiBeB_xHqqkZx_
// *			_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiOhNiCgAiCmMiImKjChFiChHiCkJiCoHiJlKiCnGjFkBiOmKiBeC_xHqqkZx_
// *			_xZkqqHx_iOhNiCgBiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiBeBjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpA_xHqqkZx_
// *			_xZkqqHx_iNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// *          _xZkqqHx_iCgA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkAiChH_xHqqkZx_
// *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkC_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *                  _xZkqqHx_iCgB_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCHistViewDoc::MoveToTrunkCommandFile (FCHiProject& project,
//											long lTrunkDocId,
//											long lBranchDocId,
//											flint fliSessionIndexX)
//{
//#if 0
////----- 04.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//----- _xZkqqHx_iImKjChFiChHiCmMiDfIiDhMiDgCiDgHiBeBjHjKjHpAjFkKiKpCiCpAiMjPiNpFiClHiCoJ_xHqqkZx_ -----
////
////	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
////	FCDbReadLock autoLockForkBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_FORK_TABLE_ID);
////	if (!autoLockForkBranchRead.TryLock()) return FALSE;
////	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
////	FCHiForkTable forkFileBranch;
////	forkFileBranch.SetProjectAndDid(project, lBranchDocId);
////	forkFileBranch.UpdateData(autoLockForkBranchRead);//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjFkKiKpCiImKjChFiCmMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_, 
////	flint fliSessionIndexX;		// _xZkqqHx_iImKjChFiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////	flint fliTrunkCommandPtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
////	flint fliTrunkIndexPtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
////	long lTrunkDocId;
////	forkFileBranch.GetSuperInfo(fliSessionIndexX,
////								fliTrunkCommandPtrX,
////								fliTrunkIndexPtrX,
////								lTrunkDocId);
////----- 04.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockCommandTrunkRead(project.GetFilePathH(), lTrunkDocId, FDHI_COMMAND_TABLE_ID);
//	FCDbReadLock autoLockCommandBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_COMMAND_TABLE_ID);
//	FCDbWriteLock autoLockCommandTrunkWrite(project.GetFilePathH(), lTrunkDocId, FDHI_COMMAND_TABLE_ID);
//	FCDbWriteLock autoLockCommandBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_COMMAND_TABLE_ID);
//	if (!autoLockCommandTrunkRead.TryLock()) return FALSE;
//	if (!autoLockCommandBranchRead.TryLock()) return FALSE;
//	if (!autoLockCommandTrunkWrite.TryLock()) return FALSE;
//	if (!autoLockCommandBranchWrite.TryLock()) return FALSE;
//
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockIndexTrunkRead(project.GetFilePathH(), lTrunkDocId, FDHI_SUMMARY_TABLE_ID);
//	FCDbReadLock autoLockIndexBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_SUMMARY_TABLE_ID);
//	FCDbWriteLock autoLockIndexTrunkWrite(project.GetFilePathH(), lTrunkDocId, FDHI_SUMMARY_TABLE_ID);
//	FCDbWriteLock autoLockIndexBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_SUMMARY_TABLE_ID);
//	if (!autoLockIndexTrunkRead.TryLock()) return FALSE;
//	if (!autoLockIndexBranchRead.TryLock()) return FALSE;
//	if (!autoLockIndexTrunkWrite.TryLock()) return FALSE;
//	if (!autoLockIndexBranchWrite.TryLock()) return FALSE;
//
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockTerminateTrunkRead(project.GetFilePathH(), lTrunkDocId, FDHI_TERMINATE_TABLE_ID);
//	FCDbReadLock autoLockTerminateBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_TERMINATE_TABLE_ID);
//	FCDbWriteLock autoLockTerminateTrunkWrite(project.GetFilePathH(), lTrunkDocId, FDHI_TERMINATE_TABLE_ID);
//	FCDbWriteLock autoLockTerminateBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_TERMINATE_TABLE_ID);
//	if (!autoLockTerminateTrunkRead.TryLock()) return FALSE;
//	if (!autoLockTerminateBranchRead.TryLock()) return FALSE;
//	if (!autoLockTerminateTrunkWrite.TryLock()) return FALSE;
//	if (!autoLockTerminateBranchWrite.TryLock()) return FALSE;
//
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhNiCkJiCoHiKlCiCnGjFkBiOmKiClHiCoJiBeC_xHqqkZx_
//	if (!CopyCommandFile(project,
//						lBranchDocId,
//						lTrunkDocId,
//// 04.12.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////						fliSessionIndexX,
//						FD_CMDFILE_HEAD_SIZE,
//						0)) return FALSE;
//
//	// _xZkqqHx_iOhNiCmMiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
//	g_pFileServer->DeleteFile(autoLockCommandBranchRead.GetTableName(), NULL, NULL);
//	g_pFileServer->DeleteFile(autoLockIndexBranchRead.GetTableName(), NULL, NULL);
//	g_pFileServer->DeleteFile(autoLockTerminateBranchRead.GetTableName(), NULL, NULL);
//#endif//0
//	return TRUE;
//} // CFCHistViewDoc::MoveToTrunkCommandFile.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::CopyCommandFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiMlDiCmMjHjKjHpAjFlGiPjBiCkJiCoHjFkBiOmKjAoGiCmMjHjKjHpAjFlGiPjBiCnGiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiBeB_xHqqkZx_
// *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiBeBjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pwstrErrMessage		:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocIdFrom			:_xZkqqHx_jFkBiOmKiMlDiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocIdTo			:_xZkqqHx_jFkBiOmKjAoGiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliCommandPtrFrom	:_xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliIndexPtrFrom		:_xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFkBiOmKiMlD_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCkJiCoHiImIiNhOiCpAiBeBjFkBiOmKjAoG_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiPeJjCfLiChIiCnGjFkBiOmKiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_jFkBiOmKjAoGiBgJiCgCiBgKiCmJiCmNiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiBeB_xHqqkZx_
// *			_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkKjBlGiNnNiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// *          ---------_xZkqqHx_iBhJjFkBiOmKjBePiBhK_xHqqkZx_---------
// *              _xZkqqHx_iCgC_xHqqkZx_        _xZkqqHx_iCgA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *            _xZkqqHx_iChIiBkL_xHqqkZx_        _xZkqqHx_iEkF_xHqqkZx_ _xZkqqHx_iChH_xHqqkZx_
// *                        _xZkqqHx_iEkA_xHqqkZx_
// *                        _xZkqqHx_iEkA_xHqqkZx_
// *                        _xZkqqHx_iEkA_xHqqkZx_
// *                        _xZkqqHx_iEkA_xHqqkZx_
// *                        _xZkqqHx_iEkA_xHqqkZx_
// *                        _xZkqqHx_iBkL_xHqqkZx_
// *
// *          ---------_xZkqqHx_iBhJjFkBiOmKiMoDiBhK_xHqqkZx_---------
// *
// *              _xZkqqHx_iCgC_xHqqkZx_        _xZkqqHx_iCgA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkF_xHqqkZx_ _xZkqqHx_iChH_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCHistViewDoc::CopyCommandFile (	FCHiProject& project,
//										long lDocIdFrom,
//										long lDocIdTo,
//										flint fliCommandPtrFrom,
//										flint fliIndexPtrFrom)
//{
//#if 0
//	// _xZkqqHx_jFkBiOmKiMlDjHjKjHpAiBeBjFkBiOmKjAoGjHjKjHpAiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockCommandReadFrom(project.GetFilePathH(), lDocIdFrom, FDHI_COMMAND_TABLE_ID);
//	FCDbReadLock autoLockCommandReadTo(project.GetFilePathH(), lDocIdTo, FDHI_COMMAND_TABLE_ID);
//	FCDbWriteLock autoLockCommandWriteTo(project.GetFilePathH(), lDocIdTo, FDHI_COMMAND_TABLE_ID);
//	if (!autoLockCommandReadFrom.TryLock()) return FALSE;
//	if (!autoLockCommandReadTo.TryLock()) return FALSE;
//	if (!autoLockCommandWriteTo.TryLock()) return FALSE;
//
//	// _xZkqqHx_jFkBiOmKiMlDjHjKjHpAiBeBjFkBiOmKjAoGjHjKjHpAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockIndexReadFrom(project.GetFilePathH(), lDocIdFrom, FDHI_SUMMARY_TABLE_ID);
//	FCDbReadLock autoLockIndexReadTo(project.GetFilePathH(), lDocIdTo, FDHI_SUMMARY_TABLE_ID);
//	FCDbWriteLock autoLockIndexWriteTo(project.GetFilePathH(), lDocIdTo, FDHI_SUMMARY_TABLE_ID);
//	if (!autoLockIndexReadFrom.TryLock()) return FALSE;
//	if (!autoLockIndexReadTo.TryLock()) return FALSE;
//	if (!autoLockIndexWriteTo.TryLock()) return FALSE;
//
//	// _xZkqqHx_jFkBiOmKiMlDjHjKjHpAiBeBjFkBiOmKjAoGjHjKjHpAiCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockTerminateReadFrom(project.GetFilePathH(), lDocIdFrom, FDHI_TERMINATE_TABLE_ID);
//	FCDbReadLock autoLockTerminateReadTo(project.GetFilePathH(), lDocIdTo, FDHI_TERMINATE_TABLE_ID);
//	FCDbWriteLock autoLockTerminateWriteTo(project.GetFilePathH(), lDocIdTo, FDHI_TERMINATE_TABLE_ID);
//	if (!autoLockTerminateReadFrom.TryLock()) return FALSE;
//	if (!autoLockTerminateReadTo.TryLock()) return FALSE;
//	if (!autoLockTerminateWriteTo.TryLock()) return FALSE;
//
//	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAjFkBiOmKiClHiCoJ_xHqqkZx_ -----
//
//	// _xZkqqHx_jFkBiOmKiMlDjHjKjHpAiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
//	CFCHIFSFile fileFromCommand(project.GetDocumentPath(lDocIdFrom, FDHI_COMMAND_TABLE_ID),
//								TRUE,
//								TRUE,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////								GENERIC_READ,
////								0,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//								OPEN_EXISTING, NULL, NULL);
//	// _xZkqqHx_jDfNjBjHiClHiCnHiCkLiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
//	flint fliCommandDataSize = fileFromCommand.GetLength64() - fliCommandPtrFrom;
//	// _xZkqqHx_jFkBiOmKjAoGjHjKjHpAiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
//	CFCHIFSFile fileToCommand(	project.GetDocumentPath(lDocIdTo, FDHI_COMMAND_TABLE_ID),
//								TRUE,
//								TRUE,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////								GENERIC_WRITE,
////								0,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//								OPEN_EXISTING, NULL, NULL);
//	// _xZkqqHx_jDfNjBjHiCpAiKeKiOgOiClHiCoJiImKjChFiCnGiInKjDkOiBeC_xHqqkZx_
//	fileFromCommand.Seek64(fliCommandPtrFrom, FILE_BEGIN);
//	fileToCommand.Seek64(fileToCommand.GetLength64(), FILE_BEGIN);
//	// _xZkqqHx_iDgGiBfLiDfOiCpAjDfNjBjHiClHiCoJiBeC_xHqqkZx_
//	fileToCommand.Copy64(fileFromCommand, fliCommandDataSize);
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//	fileFromCommand.Close();
//	fileToCommand.Close();
//
//	//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjFkBiOmKiClHiCoJ_xHqqkZx_ -----
//
//	// _xZkqqHx_jFkBiOmKiMlDjHjKjHpAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
//	CFCHIFSFile fileFromIndex(	project.GetDocumentPath(lDocIdFrom, FDHI_SUMMARY_TABLE_ID),
//								TRUE,
//								FALSE,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////								GENERIC_READ,
////								0,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//								OPEN_EXISTING, NULL, NULL);
//	// _xZkqqHx_jDfNjBjHiClHiCnHiCkLiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
//	flint fliIndexDataSize = fileFromIndex.GetLength64() - fliIndexPtrFrom;
//	// _xZkqqHx_jFkBiOmKjAoGjHjKjHpAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
//	CFCHIFSFile fileToIndex(project.GetDocumentPath(lDocIdTo, FDHI_SUMMARY_TABLE_ID),
//							TRUE,
//							FALSE,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////							GENERIC_WRITE,
////							0,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//							OPEN_EXISTING, NULL, NULL);
//	// _xZkqqHx_jDfNjBjHiCpAiKeKiOgOiClHiCoJiImKjChFiCnGiInKjDkOiBeC_xHqqkZx_
//	fileFromIndex.Seek64(fliIndexPtrFrom, FILE_BEGIN);
//	fileToIndex.Seek64(fileToIndex.GetLength64(), FILE_BEGIN);
//	// _xZkqqHx_iDgGiBfLiDfOiCpAjDfNjBjHiClHiCoJiBeC_xHqqkZx_
//	fileToIndex.Copy64(fileFromIndex, fliIndexDataSize);
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//	fileFromIndex.Close();
//	fileToIndex.Close();
//
//	//----- _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiPeDjAlDiClHiCoJ_xHqqkZx_ -----
//
//	// _xZkqqHx_jFkBiOmKiMlDjHjKjHpAiCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//	FCHiTerminateTable cmdTermFileFrom;
//// 05.10.31 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////	cmdTermFileFrom.OpenRead(project, lDocIdFrom);
//	cmdTermFileFrom.OpenExisting(project, lDocIdFrom);
//	const flint fliFromEndSessionIndex = cmdTermFileFrom.SeeEndSessionIndex();
//	cmdTermFileFrom.Close();
//
//	// _xZkqqHx_jFkBiOmKjAoGjHjKjHpAiCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiPeDjAlDiClHiCoJiBeC_xHqqkZx_
//	FCHiTerminateTable cmdTermFileTo;
//	cmdTermFileTo.OpenExisting(project, lDocIdTo);
//	cmdTermFileTo.UpdateEndSessionIndex(fliFromEndSessionIndex);
//	cmdTermFileTo.Close();
//
//#endif//0
//	return TRUE;
//} // CFCHistViewDoc::CopyCommandFile.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::MoveToBranchSpot
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKlCiCmMiImKjChFiChHiImIiJlKiCmMiDfIiDhMiDgCiDgHiCpAiOhNiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pwstrErrMessage		:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lTrunkDocId			:_xZkqqHx_iKlCiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lBranchDocId		:_xZkqqHx_iOhNiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocIdX				:_xZkqqHx_iImKjChFiChHiCkJiCoHjFkKiKpCiClFiCmEiCkCiCoJjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_jBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndexX	:_xZkqqHx_iImKjChFiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkCommandPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkIndexPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	lDocIdX = -1 _xZkqqHx_iCmMiPoKiNiHiBeBiImKjChFiChHiCmJiDfIiDhMiDgCiDgHiCkKjBlGiNnNiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
// *			_xZkqqHx_iCgCiCmJiDfIiDhMiDgCiDgHiCpAiInKjDkOiClHiCoJiClNiCnPiCmJiCmNiBeBiCgCiCmMiImKjChFiChHiBgJiDgHiDgCiDhGiBgKiCmJiDfIiDhMiDgCiDgHiCkK_xHqqkZx_
// *			_xZkqqHx_jFeLjAhLiCmMiClNiCnPiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKlCiCgAiCmMiImKjChFiChHiCkJiCoHiJlKiBgJiImKjChFiChHiCpAiKnMiCnOiBgKiCmMiDfIiDhMiDgCiDgHiCpAiOhNiCgCiCnGiInKjDkOiBeC_xHqqkZx_
// *			_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiOhNiCgCiCmJiNoMjAkMiBeC_xHqqkZx_
// *			_xZkqqHx_iKlCiCgAiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmMiBeBiImKjChFiChHiImIiNhOiCpAiNoNiPjMiBeC_xHqqkZx_
// *
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkBiBgDiBgDiBgDiEkHiChH_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *          _xZkqqHx_iCgC_xHqqkZx_      _xZkqqHx_iCgA_xHqqkZx_
// *
// *                _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_     
// *              _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_   
// *               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_    
// *                 _xZkqqHx_iBfPiBfO_xHqqkZx_      
// *
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkHiChH_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *          _xZkqqHx_iCgC_xHqqkZx_      _xZkqqHx_iCgA_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCHistViewDoc::MoveToBranchSpot (	FCHiProject& project,
//										long lTrunkDocId,
//										long lBranchDocId,
//										long lDocIdX,
//										flint fliSessionIndexX,
//										flint fliTrunkCommandPtrX,
//										flint fliTrunkIndexPtrX)
//{
//#if 0
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockSpotTrunkRead(project.GetFilePathH(), lTrunkDocId, FDHI_SPOT_TABLE_ID);
//	FCDbReadLock autoLockSpotBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_SPOT_TABLE_ID);
//	FCDbWriteLock autoLockSpotTrunkWrite(project.GetFilePathH(), lTrunkDocId, FDHI_SPOT_TABLE_ID);
//	FCDbWriteLock autoLockSpotBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_SPOT_TABLE_ID);
//	if (!autoLockSpotTrunkRead.TryLock()) return FALSE;
//	if (!autoLockSpotBranchRead.TryLock()) return FALSE;
//	if (!autoLockSpotTrunkWrite.TryLock()) return FALSE;
//	if (!autoLockSpotBranchWrite.TryLock()) return FALSE;
//
////----- 04.11.05 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//----- _xZkqqHx_iImKjChFiChHiCmMiDfIiDhMiDgCiDgHiBeBjHjKjHpAjFkKiKpCiCpAiMjPiNpFiClHiCoJ_xHqqkZx_ -----
////
////	flint fliTrunkCommandPtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
////	flint fliTrunkIndexPtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
////	long lDocIdX;				// _xZkqqHx_iImKjChFiChHiCkJiCoHjFkKiKpCiClHiCoJiBeBjFmKiCmMjHjKjHpAjFkKiKpCiBeC_xHqqkZx_
////
////	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmMiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCmIiCmHiCpAiOoGjDlOiBeC_xHqqkZx_
////	if (!SessionIndexToPosition(&fliTrunkCommandPtrX,
////								&fliTrunkIndexPtrX,
////								&lDocIdX,
////								project,
////								lTrunkDocId,
////								fliSessionIndexX)) return FALSE;
////----- 04.11.05 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCHiSpotTable spotFileTrunk;
//	spotFileTrunk = project.GetSubGroup(lTrunkDocId);
//	spotFileTrunk.UpdateData(autoLockSpotTrunkRead);
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
//	FCHiSpotTable spotFileBranch;
//	spotFileBranch = project.GetSubGroup(lBranchDocId);
//
//	if (!spotFileTrunk.IsThereSpot(fliSessionIndexX))
//	//----- _xZkqqHx_iImKjChFiChHiCmJiDfIiDhMiDgCiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		ASSERT(lDocIdX != -1);
//		//
//		// _xZkqqHx_iImKjChFiChHiCkJiCoHjFkKiKpCiClFiCmEiCkCiCoJjHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iChH_xHqqkZx_)_xZkqqHx_iCpAjDmHiCnNiNjOiCpBiCmFiBeB_xHqqkZx_
//		// _xZkqqHx_iChHiCmMiNmFiPiJiCmMjHjKjHpAjFkKiKpCiCpAiCgCiCnGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
//		//
//		//                  _xZkqqHx_iEkA_xHqqkZx_
//		//                  _xZkqqHx_iEkAiChH_xHqqkZx_
//		//          _xZkqqHx_iEkBiBgDiBgDiBgDiEkHiEjPiEjPiEjPiEkC_xHqqkZx_
//		//          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
//		//          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
//		//          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
//		//          _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iChH_xHqqkZx_
//		//          _xZkqqHx_iCgC_xHqqkZx_      _xZkqqHx_iCgA_xHqqkZx_
//		//
//
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iChH_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//		FCDbReadLock autoLockSpotXRead(project.GetFilePathH(), lDocIdX, FDHI_SPOT_TABLE_ID);
//		if (!autoLockSpotXRead.TryLock()) return FALSE;
//		// _xZkqqHx_iChHiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		FCHiSpotTable spotFileX;
//		spotFileX = project.GetSubGroup(lDocIdX);
//		spotFileX.UpdateData(autoLockSpotXRead);
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iChH_xHqqkZx_)_xZkqqHx_iCmMiNmFiPiJiCmMiDfIiDhMiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//		const WString wstrSpotFileX = spotFileX.FindSpot(fliSessionIndexX).GetFilePath();
//
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iChH_xHqqkZx_)_xZkqqHx_iCmMiNmFiPiJiCmMiDfIiDhMiDgCiDgHiCpAiBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCnGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
//		const WString wstrSpotFileC = spotFileBranch.GetSpotFilePath(fliSessionIndexX);
//
//		// _xZkqqHx_jFkBiOmKiClHiCoJiDfIiDhMiDgCiDgHiCmMiDhEiDeAiDeDiDiLiDeBiDgHiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
//		const long lAtomX = g_pFileServer->QueryAtom(wstrSpotFileX, FD_NO, FD_YES);
//		const long lAtomC = g_pFileServer->QueryAtom(wstrSpotFileC, FD_NO, FD_YES);
//		// _xZkqqHx_jFkBiOmKiMlDiDfIiDhMiDgCiDgHiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//		FCDbReadLock readLockVar(lAtomX);
//		if (!readLockVar.TryLock()) return FALSE;
//		// _xZkqqHx_jFkBiOmKjAoGiDfIiDhMiDgCiDgHiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//		FCDbWriteLock writeLockVar(lAtomC);
//		if (!writeLockVar.TryLock()) return FALSE;
//		// _xZkqqHx_iDfIiDhMiDgCiDgHiCpAjFkBiOmKiBeC_xHqqkZx_
//		g_pFileServer->CopyFile(lAtomC, lAtomX);
//
//		spotFileBranch.AppendSpot(	fliSessionIndexX,
//									TRUE,
//									FD_CMDFILE_HEAD_SIZE,
//									0);
//	}
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
////	spotFileBranch.UpdateFile(autoLockSpotBranchWrite);
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iDfIiDhMiDgCiDgHiCpAiKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCkJiCoHiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCnGjFkBiOmKiClHiCoJiBeC_xHqqkZx_
//	if (!CopySpot(	project,
//					lTrunkDocId,
//					lBranchDocId,
//					fliSessionIndexX,
//					fliTrunkCommandPtrX,
//					fliTrunkIndexPtrX,
//					FD_CMDFILE_HEAD_SIZE,
//					0,
//					TRUE)) return FALSE;
//
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiNoNiPjMiClHiCnHiCkLiDfIiDhMiDgCiDgHiCpAiMhGiOfKiBeC_xHqqkZx_
//	longSet stDelSpotAtom;
//	spotFileTrunk.GetDeleteSpotFileAfterSessionIndex(stDelSpotAtom, fliSessionIndexX, TRUE);
//	longSet::const_iterator iAtm;
//	for (iAtm = stDelSpotAtom.begin(); iAtm != stDelSpotAtom.end(); iAtm++)
//	{
//		// _xZkqqHx_iDfIiDhMiDgCiDgHiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//		FCDbWriteLock writeLockVar(*iAtm);
//		if (!writeLockVar.TryLock())
//			return FALSE;
//		// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiCpAiNoNiPjMiBeC_xHqqkZx_
//		g_pFileServer->DeleteFile(*iAtm, NULL, NULL);
//	}
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
//	spotFileTrunk.RemoveSpot(stDelSpotAtom);
//// 06.01.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	spotFileTrunk.UpdateFile(autoLockSpotTrunkWrite);
//#endif//0
//	return TRUE;
//} // CFCHistViewDoc::MoveToBranchSpot.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::MoveToTrunkSpot
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhNiCmMiDfIiDhMiDgCiDgHiCpAiKlCiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pwstrErrMessage		:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lTrunkDocId			:_xZkqqHx_iKlCiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lBranchDocId		:_xZkqqHx_iOhNiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndexX	:_xZkqqHx_iImKjChFiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkCommandPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkIndexPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKiCmMjAhNiCmFiBeBiOhNiCgBiCmMiDfIiDhMiDgCiDgHiCpAiOhNiCgAiCmMiImKjChFiChHiCkJiCoHiJlKiCnGjFkBiOmKiBeC_xHqqkZx_
// *			_xZkqqHx_iOhNiCgBiCmMiDfIiDhMiDgCiDgHiCmGiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// *          _xZkqqHx_iCgA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkAiChH_xHqqkZx_
// *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkC_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *                  _xZkqqHx_iCgB_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCHistViewDoc::MoveToTrunkSpot (	FCHiProject& project,
////----- 04.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////										long lBranchDocId)
////----- 04.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//										long lTrunkDocId,
//										long lBranchDocId,
//										flint fliSessionIndexX,
//										flint fliTrunkCommandPtrX,
//										flint fliTrunkIndexPtrX)
////----- 04.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//{
//#if 0
////----- 04.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//----- _xZkqqHx_iImKjChFiChHiCmMiDfIiDhMiDgCiDgHiBeBjHjKjHpAjFkKiKpCiCpAiMjPiNpFiClHiCoJ_xHqqkZx_ -----
////	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
////	FCDbReadLock autoLockForkBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_FORK_TABLE_ID);
////	if (!autoLockForkBranchRead.TryLock()) return FALSE;
////	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
////	FCHiForkTable forkFileBranch;
////	forkFileBranch.SetProjectAndDid(project, lBranchDocId);
////	forkFileBranch.UpdateData(autoLockForkBranchRead);
////	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjFkKiKpCiImKjChFiCmMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
////	flint fliSessionIndexX;		// _xZkqqHx_iImKjChFiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////	flint fliTrunkCommandPtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
////	flint fliTrunkIndexPtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
////	long lTrunkDocId;
////	forkFileBranch.GetSuperInfo(fliSessionIndexX,
////								fliTrunkCommandPtrX,
////								fliTrunkIndexPtrX,
////								lTrunkDocId);
////----- 04.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iBeBiOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockSpotTrunkRead(project.GetFilePathH(), lTrunkDocId, FDHI_SPOT_TABLE_ID);
//	FCDbReadLock autoLockSpotBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_SPOT_TABLE_ID);
//	FCDbWriteLock autoLockSpotTrunkWrite(project.GetFilePathH(), lTrunkDocId, FDHI_SPOT_TABLE_ID);
//	FCDbWriteLock autoLockSpotBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_SPOT_TABLE_ID);
//	if (!autoLockSpotTrunkRead.TryLock()) return FALSE;
//	if (!autoLockSpotBranchRead.TryLock()) return FALSE;
//	if (!autoLockSpotTrunkWrite.TryLock()) return FALSE;
//	if (!autoLockSpotBranchWrite.TryLock()) return FALSE;
//
//	// _xZkqqHx_iDfIiDhMiDgCiDgHiCpAiOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCkJiCoHiKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCnGjFkBiOmKiClHiCoJiBeC_xHqqkZx_
//	if (!CopySpot(	project,
//					lBranchDocId,
//					lTrunkDocId,
//					fliSessionIndexX,
//					FD_CMDFILE_HEAD_SIZE,
//					0,
//					fliTrunkCommandPtrX,
//					fliTrunkIndexPtrX,
//					TRUE)) return FALSE;
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCHiSpotTable spotFileBranch;
//	spotFileBranch = project.GetSubGroup(lBranchDocId);
//	spotFileBranch.UpdateData(autoLockSpotBranchRead);
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMiNoNiPjMiClHiCnHiCkLiDfIiDhMiDgCiDgHiCpAiMhGiOfKiBeC_xHqqkZx_
//	longSet stDelSpotAtom;
//	spotFileBranch.GetDeleteSpotFileAfterSessionIndex(stDelSpotAtom, fliSessionIndexX, TRUE);
//	longSet::const_iterator iAtm;
//	for (iAtm = stDelSpotAtom.begin(); iAtm != stDelSpotAtom.end(); iAtm++)
//	{
////----- 04.11.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		// _xZkqqHx_iDfIiDhMiDgCiDgHiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
////		vWriteLockForFlush.push_back(FCDbWriteLock(*iAtm));
////		if (!vWriteLockForFlush.back().TryLock())
////			return FALSE;
////----- 04.11.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		// _xZkqqHx_iDfIiDhMiDgCiDgHiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//		FCDbWriteLock writeLockVar(*iAtm);
//		if (!writeLockVar.TryLock())
//			return FALSE;
////----- 04.11.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiCpAiNoNiPjMiBeC_xHqqkZx_
//		g_pFileServer->DeleteFile(*iAtm, NULL, NULL);
//	}
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
//	g_pFileServer->DeleteFile(autoLockSpotBranchWrite.GetTableName(), NULL, NULL);
//
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iBeBiOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmMiChGiDiNiDgCiDeOiCpAjFnLjBlGiBeC_xHqqkZx_
////	vWriteLockForFlush.push_back(autoLockSpotTrunkWrite);
////	vWriteLockForFlush.push_back(autoLockSpotBranchWrite);
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//#endif//0
//	return TRUE;
//} // CFCHistViewDoc::MoveToTrunkSpot.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::CopySpot
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	lDocIdFrom_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjHjKjHpAiCmMiBeBiOhHjCoIiClDiCoKiClNiImKjChFiImIiNhOiCmJjBlGiNnNiClHiCoJ_xHqqkZx_
// *			_xZkqqHx_iDfIiDhMiDgCiDgHiCpAiBeB_xHqqkZx_lDocIdTo_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjHjKjHpAiCmJjFkBiOmKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocIdFrom			:_xZkqqHx_jFkBiOmKiMlDiCmMjHjKjHpAiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocIdTo			:_xZkqqHx_jFkBiOmKjAoGiCmMjHjKjHpAiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndex		:_xZkqqHx_jFkBiOmKiClHiCoJiOgOjDfPiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliCommandPtrFrom	:_xZkqqHx_jFkBiOmKiClHiCoJiOgOjDfPiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliIndexPtrFrom		:_xZkqqHx_jFkBiOmKiClHiCoJiOgOjDfPiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliCommandPtrTo		:_xZkqqHx_iChHiCmJjBmOiJjOiClHiCoJjFkBiOmKjAoGiCmMiImKjChFiChIiCmMiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliIndexPtrTo		:_xZkqqHx_iChHiCmJjBmOiJjOiClHiCoJjFkBiOmKjAoGiCmMiImKjChFiChIiCmMiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			bIncludeEqual		:_xZkqqHx_iChHiCmJiImKjChFiClHiCoJiDfIiDhMiDgCiDgHiCoAjFkBiOmKiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
// *								 _xZkqqHx_jFkBiOmKiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
//// 04.11.22 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//// *			vWriteLockForFlush	:_xZkqqHx_jFkBiOmKiCmFjFmPiNfIiClDiCoKiCoJiDhEiDeAiDeDiDiLiCmMiDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFkBiOmKiMoDiCmJiBeBiDhEiDeAiDeDiDiLiCpAiDhEiDiJiDgCiDfGiDiFiCmNiClFiCmIiCkCiBeCiImKjChFiChHiCmMiDfIiDhMiDgCiDgHiCoA_xHqqkZx_
// *			_xZkqqHx_jFkBiOmKiClDiCoKiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// *			_xZkqqHx_iImKjChFiChHiCmGiImKjChFiChIiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmNjDkPiClGiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpA_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCkJiCoHiImIiNhOiCpAiBeBjHjKjHpA_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChIiCnGjFkBiOmKiClHiCoJiPoKiNiHiBeC_xHqqkZx_
// *			_xZkqqHx_iBkG_xHqqkZx_ bIncludeEqual = TRUE _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
// *
// *          ---------_xZkqqHx_iBhJjFkBiOmKjBePiBhK_xHqqkZx_---------
// *
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *            _xZkqqHx_iChIiEkA_xHqqkZx_      _xZkqqHx_iChHiEkF_xHqqkZx_ S0
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkF_xHqqkZx_ S1
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkF_xHqqkZx_ S2
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkF_xHqqkZx_ S4
// *              _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
// *              _xZkqqHx_iCgC_xHqqkZx_        _xZkqqHx_iCgA_xHqqkZx_
// *
// *          ---------_xZkqqHx_iBhJjFkBiOmKiMoDiBhK_xHqqkZx_---------
// *
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *            _xZkqqHx_iChIiEkF_xHqqkZx_ S0   _xZkqqHx_iChHiEkF_xHqqkZx_ S0
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkF_xHqqkZx_ S1     _xZkqqHx_iEkF_xHqqkZx_ S1
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkF_xHqqkZx_ S2     _xZkqqHx_iEkF_xHqqkZx_ S2
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
// *              _xZkqqHx_iEkF_xHqqkZx_ S4     _xZkqqHx_iEkF_xHqqkZx_ S4
// *              _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
// *              _xZkqqHx_iCgC_xHqqkZx_        _xZkqqHx_iCgA_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCHistViewDoc::CopySpot (	FCHiProject& project,
//								long lDocIdFrom,
//								long lDocIdTo,
//								flint fliSessionIndex,
//								flint fliCommandPtrFrom,
//								flint fliIndexPtrFrom,
//								flint fliCommandPtrTo,
//								flint fliIndexPtrTo,
//								BOOL bIncludeEqual)
//// 04.11.22 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////								FCDbWriteLockVector& vWriteLockForFlush)
//{
//#if 0
//	// _xZkqqHx_jFkBiOmKiMlDjHjKjHpAiBeBjFkBiOmKjAoGjHjKjHpAiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockSpotReadFrom(project.GetFilePathH(), lDocIdFrom, FDHI_SPOT_TABLE_ID);
//	FCDbReadLock autoLockSpotReadTo(project.GetFilePathH(), lDocIdTo, FDHI_SPOT_TABLE_ID);
//	FCDbWriteLock autoLockSpotWriteTo(project.GetFilePathH(), lDocIdTo, FDHI_SPOT_TABLE_ID);
//	if (!autoLockSpotReadFrom.TryLock()) return FALSE;
//	if (!autoLockSpotReadTo.TryLock()) return FALSE;
//	if (!autoLockSpotWriteTo.TryLock()) return FALSE;
//
//	// _xZkqqHx_iOhNiCnGiDfIiDhMiDgCiDgHiCpAjFkBiOmKiClHiCoJiNnLiCmMiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCmMiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
//	const flint fliCmdFilePtrOffset = fliCommandPtrFrom - fliCommandPtrTo;
//	// _xZkqqHx_iOhNiCnGiDfIiDhMiDgCiDgHiCpAjFkBiOmKiClHiCoJiNnLiCmMiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCmMiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
//	const flint fliIdxFilePtrOffset = fliIndexPtrFrom - fliIndexPtrTo;
//
//	// _xZkqqHx_jFkBiOmKiMlDjHjKjHpAiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCHiSpotTable spotFileFrom;
//	spotFileFrom = project.GetSubGroup(lDocIdFrom);
//	spotFileFrom.UpdateData(autoLockSpotReadFrom);
//
//	// _xZkqqHx_jFkBiOmKjAoGjHjKjHpAiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCHiSpotTable spotFileTo;
//	spotFileTo = project.GetSubGroup(lDocIdTo);
//	spotFileTo.UpdateData(autoLockSpotReadTo);
//
////----- 04.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
////	FCIdxToSpotInfoMap::const_iterator iSi;
////	// _xZkqqHx_iImKjChFiChHiCmMjFkKiKpCiCpAiKnMiCnOiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
////	if (bIncludeEqual)
////		iSi = spotFileFrom.GetSpotList().lower_bound(fliSessionIndex);
////	else
////		iSi = spotFileFrom.GetSpotList().upper_bound(fliSessionIndex);
////
////	for (; iSi != spotFileFrom.GetSpotList().end(); iSi++)
////	{
////		// _xZkqqHx_jFkBiOmKiClHiCoJiDfIiDhMiDgCiDgHiCmMiDhEiDeAiDeDiDiLiDeBiDgHiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
////		const long lAtomFrom = g_pFileServer->QueryAtom(spotFileFrom.GetSpotFilePath((*iSi).first), FD_NO, FD_YES);
////		const long lAtomTo = g_pFileServer->QueryAtom(spotFileTo.GetSpotFilePath((*iSi).first), FD_NO, FD_YES);
////		// _xZkqqHx_jFkBiOmKiMlDiDfIiDhMiDgCiDgHiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
////		FCDbReadLock readLockVar(lAtomFrom);
////		if (!readLockVar.TryLock()) return FALSE;
////		// _xZkqqHx_jFkBiOmKjAoGiDfIiDhMiDgCiDgHiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
////		FCDbWriteLock writeLockVar(lAtomTo);
////		if (!writeLockVar.TryLock()) return FALSE;
////		// _xZkqqHx_iDfIiDhMiDgCiDgHiCpAjFkBiOmKiBeC_xHqqkZx_
////		g_pFileServer->CopyFile(lAtomTo, lAtomFrom);
////		// _xZkqqHx_jFkBiOmKjAoGjHjKjHpAiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmJiDfIiDhMiDgCiDgHiPoOjFpBiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
////		spotFileTo.AppendSpot(	(*iSi).first,
////								(*iSi).second.m_bIsOfficial,								// _xZkqqHx_jAlDiOkOiCmIiDfIiDhMiDgCiDgHiCkJiBeIiBgJjEpBjAlDiOkOiCmIiDfIiDhMiDgCiDgHiCmGiCmNiBeBiDhEiDeAiDeDiDiLiPeJjCfLiCmMiDfIiDhMiDgCiDgHiBgK_xHqqkZx_
////								(*iSi).second.m_fliCmdPtr - fliCmdFilePtrOffset,			// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
////								(*iSi).second.m_fliIdxPtr - fliIdxFilePtrOffset);			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
////// 04.11.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//////								spotFileTo.GetSpotFilePath((*iSi).second.m_wstrFileName));	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjGlMiBeC_xHqqkZx_
////		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiCnMiCmFiDiNiDgCiDeOiCpAjFnLjBlGiBeC_xHqqkZx_
////		vWriteLockForFlush.push_back(writeLockVar);
////	}
////----- 04.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
//	FCSpotIterator iSi;
//	// _xZkqqHx_iImKjChFiChHiCmMjFkKiKpCiCpAiKnMiCnOiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
//	if (bIncludeEqual)
//		iSi = spotFileFrom.GetLowerBoundSpot(fliSessionIndex);
//	else
//		iSi = spotFileFrom.GetUpperBoundSpot(fliSessionIndex);
//
//	for (; !iSi.IsEnd(); iSi++)
//	{
//		// _xZkqqHx_jFkBiOmKiClHiCoJiDfIiDhMiDgCiDgHiCmMiDhEiDeAiDeDiDiLiDeBiDgHiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
//		const long lAtomFrom = g_pFileServer->QueryAtom(spotFileFrom.GetSpotFilePath(iSi.GetSessionIndex()), FD_NO, FD_YES);
//		const long lAtomTo = g_pFileServer->QueryAtom(spotFileTo.GetSpotFilePath(iSi.GetSessionIndex()), FD_NO, FD_YES);
//		// _xZkqqHx_jFkBiOmKiMlDiDfIiDhMiDgCiDgHiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//		FCDbReadLock readLockVar(lAtomFrom);
//		if (!readLockVar.TryLock()) return FALSE;
//		// _xZkqqHx_jFkBiOmKjAoGiDfIiDhMiDgCiDgHiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//		FCDbWriteLock writeLockVar(lAtomTo);
//		if (!writeLockVar.TryLock()) return FALSE;
//		// _xZkqqHx_iDfIiDhMiDgCiDgHiCpAjFkBiOmKiBeC_xHqqkZx_
//		g_pFileServer->CopyFile(lAtomTo, lAtomFrom);
//		// _xZkqqHx_jFkBiOmKjAoGjHjKjHpAiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmJiDfIiDhMiDgCiDgHiPoOjFpBiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
//#if 0
//		spotFileTo.AppendSpot(	iSi.GetSessionIndex(),
//								iSi.GetIsOfficial(),									// _xZkqqHx_jAlDiOkOiCmIiDfIiDhMiDgCiDgHiCkJiBeIiBgJjEpBjAlDiOkOiCmIiDfIiDhMiDgCiDgHiCmGiCmNiBeBiDhEiDeAiDeDiDiLiPeJjCfLiCmMiDfIiDhMiDgCiDgHiBgK_xHqqkZx_
//								iSi.GetCommandFilePtr() - fliCmdFilePtrOffset,			// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
//								iSi.GetIndexFilePtr() - fliIdxFilePtrOffset);			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
//#endif//0
//// 04.11.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////								spotFileTo.GetSpotFilePath((*iSi).second.m_wstrFileName));	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjGlMiBeC_xHqqkZx_
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiCnMiCmFiDiNiDgCiDeOiCpAjFnLjBlGiBeC_xHqqkZx_
////		vWriteLockForFlush.push_back(writeLockVar);
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	}
////----- 04.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
////----- 04.11.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNmFiPiJiCmMiDfIiDhMiDgCiDgHiCpAiDeJiDhEiDeCiDfGiDiDiDiLiCmJiBeC_xHqqkZx_
//	// _xZkqqHx_iDfIiDhMiDgCiDgHjFkBiOmKiCmFiBeBjEpBiDeJiDhEiDeCiDfGiDiDiDiLiCmIiClHiDhMiDgCiDgHiCkK_xHqqkZx_
//	// _xZkqqHx_iNmFiPiJiCmMiDfIiDhMiDgCiDgHiCmGiClFiCmEjFkBiOmKiClDiCoKiCoJiJmCjEfMjAkLiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
//	spotFileTo.GetFirstSpot().SetIsOfficial(TRUE);
////----- 04.11.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjFnLjBlGiBeC_xHqqkZx_
////	spotFileTo.UpdateFile(autoLockSpotWriteTo);
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmMiChGiDiNiDgCiDeOiCpAjFnLjBlGiBeC_xHqqkZx_
////	vWriteLockForFlush.push_back(autoLockSpotWriteTo);
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//#endif//0
//	return TRUE;
//} // CFCHistViewDoc::CopySpot.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::MoveToBranchFork
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKlCiCmMiImKjChFiChHiImIiNhOiCmMjHjKjHpAjFkKiKpCiCpAiBeBiOhNiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pwstrErrMessage		:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lTrunkDocId			:_xZkqqHx_iKlCiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lBranchDocId		:_xZkqqHx_iOhNiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndexX	:_xZkqqHx_iImKjChFiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkCommandPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkIndexPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKlCiCgAiCmMiImKjChFiChHiCkJiCoHiJlKiBgJiImKjChFiChHiCpAiKnMiCnMiCmIiCkCiBgKiCmMjHjKjHpAjFkKiKpCiCpAiOhNiCgCiCnGiInKjDkOiBeC_xHqqkZx_
// *			_xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCpAiOhNiCgCiCmJiNoMjAkMiBeC_xHqqkZx_
// *			_xZkqqHx_iKlCiCgAiCmMiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCmMiBeBiImKjChFiChHiImIiNhOiCpAiNoNiPjMiBeC_xHqqkZx_
// *
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkBiBgDiBgDiBgDiEkHiChH_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *          _xZkqqHx_iCgC_xHqqkZx_      _xZkqqHx_iCgA_xHqqkZx_
// *
// *                _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_     
// *              _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_   
// *               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_    
// *                 _xZkqqHx_iBfPiBfO_xHqqkZx_      
// *
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *                  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkHiChH_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *          _xZkqqHx_iCgC_xHqqkZx_      _xZkqqHx_iCgA_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCHistViewDoc::MoveToBranchFork (	FCHiProject& project,
//										long lTrunkDocId,
//										long lBranchDocId,
//										flint fliSessionIndexX,
//										flint fliTrunkCommandPtrX,
//										flint fliTrunkIndexPtrX)
//{
//	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iBeBiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbWriteLock autoLockForkBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_FORK_TABLE_ID);
//	if (!autoLockForkBranchWrite.TryLock()) return FALSE;
//
////----- 04.11.05 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//----- _xZkqqHx_iImKjChFiChHiCmMiDfIiDhMiDgCiDgHiBeBjHjKjHpAjFkKiKpCiCpAiMjPiNpFiClHiCoJ_xHqqkZx_ -----
////	flint fliTrunkCommandPtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
////	flint fliTrunkIndexPtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
////	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmMiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCmIiCmHiCpAiOoGjDlOiBeC_xHqqkZx_
////	if (!SessionIndexToPosition(&fliTrunkCommandPtrX,
////								&fliTrunkIndexPtrX,
////								NULL,
////								project,
////								lTrunkDocId,
////								fliSessionIndexX)) return FALSE;
////----- 04.11.05 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
//	FCHiForkTable forkFileBranch;
//	forkFileBranch = project.GetSubGroup(lBranchDocId);
//	forkFileBranch.SetSuperInfo(fliSessionIndexX,
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////								fliTrunkCommandPtrX,
////								fliTrunkIndexPtrX,
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//								lTrunkDocId);
//// 06.01.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	forkFileBranch.UpdateFile(autoLockForkBranchWrite);
//
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiCpAiKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCkJiCoHiOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCnGiInKjDkOiBeC_xHqqkZx_
////----- 04.11.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (!MoveFork(	project,
////					lTrunkDocId,
////					lBranchDocId,
////					fliSessionIndexX,
////					fliTrunkCommandPtrX,
////					fliTrunkIndexPtrX,
////					FD_CMDFILE_HEAD_SIZE,
////					0,
////					FALSE,								// _xZkqqHx_iImKjChFiChHiCmMjFkKiKpCiCmNiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
////					vWriteLockForFlush)) return FALSE;
////----- 04.11.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//#if 0
//	if (!MoveFork(	project,
//					lTrunkDocId,
//					lBranchDocId,
//					fliSessionIndexX,
//					fliTrunkCommandPtrX,
//					fliTrunkIndexPtrX,
//					FD_CMDFILE_HEAD_SIZE,
//					0,
//					FALSE))								// _xZkqqHx_iImKjChFiChHiCmMjFkKiKpCiCmNiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
//		return FALSE;
//#endif//0
////----- 04.11.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCmMiChGiDiNiDgCiDeOiCpAjFnLjBlGiBeC_xHqqkZx_
////	vWriteLockForFlush.push_back(autoLockForkBranchWrite);
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	return TRUE;
//} // CFCHistViewDoc::MoveToBranchFork.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::MoveToTrunkFork
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhNiCmMjHjKjHpAjFkKiKpCiCpAiKlCiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pwstrErrMessage		:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lTrunkDocId			:_xZkqqHx_iKlCiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lBranchDocId		:_xZkqqHx_iOhNiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndexX	:_xZkqqHx_iImKjChFiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkCommandPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliTrunkIndexPtrX	:_xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKiCmMjAhNiCmFiBeBiOhNiCgBiCmMjHjKjHpAjFkKiKpCiCpAiOhNiCgAiCmMiImKjChFiChHiCkJiCoHiJlKiCnGiInKjDkOiBeC_xHqqkZx_
// *			_xZkqqHx_iOhNiCgBiCmMiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// *          _xZkqqHx_iCgA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkAiChH_xHqqkZx_
// *          _xZkqqHx_iEkFiEjPiEjPiEjPiEkC_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *                  _xZkqqHx_iCgB_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCHistViewDoc::MoveToTrunkFork (	FCHiProject& project,
////----- 04.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////										long lBranchDocId)
////----- 04.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//										long lTrunkDocId,
//										long lBranchDocId,
//										flint fliSessionIndexX,
//										flint fliTrunkCommandPtrX,
//										flint fliTrunkIndexPtrX)
////----- 04.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//{
//#if 0
////----- 04.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//----- _xZkqqHx_iImKjChFiChHiCmMiDfIiDhMiDgCiDgHiBeBjHjKjHpAjFkKiKpCiCpAiMjPiNpFiClHiCoJ_xHqqkZx_ -----
////
////	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
////	FCDbReadLock autoLockForkBranchRead(project.GetFilePathH(), lBranchDocId, FDHI_FORK_TABLE_ID);
////	FCDbWriteLock autoLockForkBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_FORK_TABLE_ID);
////	if (!autoLockForkBranchRead.TryLock()) return FALSE;
////	if (!autoLockForkBranchWrite.TryLock()) return FALSE;
////	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
////	FCHiForkTable forkFileBranch;
////	forkFileBranch.SetProjectAndDid(project, lBranchDocId);
////	forkFileBranch.UpdateData(autoLockForkBranchRead);
////	// _xZkqqHx_iKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMjFkKiKpCiImKjChFiCmMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
////	flint fliSessionIndexX;		// _xZkqqHx_iImKjChFiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////	flint fliTrunkCommandPtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
////	flint fliTrunkIndexPtrX;	// _xZkqqHx_iImKjChFiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
////	long lTrunkDocId;
////	forkFileBranch.GetSuperInfo(fliSessionIndexX,
////								fliTrunkCommandPtrX,
////								fliTrunkIndexPtrX,
////								lTrunkDocId);
////----- 04.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiCpAiOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCkJiCoHiKlC_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCnGiInKjDkOiBeC_xHqqkZx_
//	if (!MoveFork(	project,
//					lBranchDocId,
//					lTrunkDocId,
//					fliSessionIndexX,
//					FD_CMDFILE_HEAD_SIZE,
//					0,
//					fliTrunkCommandPtrX,
//					fliTrunkIndexPtrX,
//					TRUE))								// _xZkqqHx_iImKjChFiChHiCmMjFkKiKpCiCoAiInKjDkOiClHiCoJiBeC_xHqqkZx_
//		return FALSE;
//
////----- 04.12.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbWriteLock autoLockForkBranchWrite(project.GetFilePathH(), lBranchDocId, FDHI_FORK_TABLE_ID);
//	if (!autoLockForkBranchWrite.TryLock()) return FALSE;
////----- 04.12.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
//	g_pFileServer->DeleteFile(autoLockForkBranchWrite.GetTableName(), NULL, NULL);
//
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iOhN_xHqqkZx_(_xZkqqHx_iCgB_xHqqkZx_)_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCmMiChGiDiNiDgCiDeOiCpAjFnLjBlGiBeC_xHqqkZx_
////	vWriteLockForFlush.push_back(autoLockForkBranchWrite);
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//#endif//0
//	return TRUE;
//} // CFCHistViewDoc::MoveToTrunkFork.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::MoveFork
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	lDocIdFrom_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjHjKjHpAiCmMiBeBiOhHjCoIiClDiCoKiClNiImKjChFiImIiNhOiCmJjAnKjBlBiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
// *			_xZkqqHx_jHjKjHpAjFkKiKpCiCmGjHjKjHpAjFkKiKpCiDfOiDePiCpAiBeB_xHqqkZx_lDocIdTo_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjHjKjHpAiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocIdFrom			:_xZkqqHx_iInKjDkOiMlDiCmMjHjKjHpAiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocIdTo			:_xZkqqHx_iInKjDkOjAoGiCmMjHjKjHpAiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndex		:_xZkqqHx_iInKjDkOiClHiCoJiOgOjDfPiChHiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliCommandPtrFrom	:_xZkqqHx_iInKjDkOiClHiCoJiOgOjDfPiChHiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliIndexPtrFrom		:_xZkqqHx_iInKjDkOiClHiCoJiOgOjDfPiChHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliCommandPtrTo		:_xZkqqHx_iChHiCmJjBmOiJjOiClHiCoJiInKjDkOjAoGiCmMiImKjChFiChIiCmMiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliIndexPtrTo		:_xZkqqHx_iChHiCmJjBmOiJjOiClHiCoJiInKjDkOjAoGiCmMiImKjChFiChIiCmMiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			bIncludeEqual		:_xZkqqHx_iChHiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAiCoAiInKjDkOiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
// *								 _xZkqqHx_iInKjDkOiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
//// 04.11.22 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//// *			vWriteLockForFlush	:_xZkqqHx_iInKjDkOiCmFjFmPiNfIiClDiCoKiCoJiDhEiDeAiDeDiDiLiCmMiDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iInKjDkOiMoDiCmJiBeBiDhEiDeAiDeDiDiLiCpAiDhEiDiJiDgCiDfGiDiFiCmNiClFiCmIiCkCiBeCiImKjChFiChHiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAiCoA_xHqqkZx_
// *			_xZkqqHx_iInKjDkOiClDiCoKiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// *			_xZkqqHx_iImKjChFiChHiCmGiImKjChFiChIiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmNjDkPiClGiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpA_xHqqkZx_(_xZkqqHx_iCgA_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChHiCkJiCoHiImIiNhOiCpAiBeBjHjKjHpA_xHqqkZx_(_xZkqqHx_iCgC_xHqqkZx_)_xZkqqHx_iCmMiImKjChFiChIiCnGiInKjDkOiClHiCoJiPoKiNiHiBeC_xHqqkZx_
// *			_xZkqqHx_iBkG_xHqqkZx_ bIncludeEqual = TRUE _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
// *
// *          ---------_xZkqqHx_iBhJiInKjDkOjBePiBhK_xHqqkZx_---------
// *
// *                      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkAiChI_xHqqkZx_    _xZkqqHx_iEkBiEjPiEkHiChH_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      A0  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkBiEjPiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  A1  _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iBkL_xHqqkZx_      A3  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iCgC_xHqqkZx_          _xZkqqHx_iCgA_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
// *                              A2
// *
// *          ---------_xZkqqHx_iBhJiInKjDkOiMoDiBhK_xHqqkZx_---------
// *
// *                      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
// *      _xZkqqHx_iEkBiEjPiEkHiChI_xHqqkZx_        _xZkqqHx_iEkAiChH_xHqqkZx_
// *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
// *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
// *      _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *      A0  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
// *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *      _xZkqqHx_iEkBiEjPiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  A1  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *      _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
// *      A3  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
// *          _xZkqqHx_iCgC_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iCgA_xHqqkZx_
// *                  A2
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCHistViewDoc::MoveFork (	FCHiProject& project,
//								long lDocIdFrom,
//								long lDocIdTo,
//								flint fliSessionIndex,
//								flint fliCommandPtrFrom,
//								flint fliIndexPtrFrom,
//								flint fliCommandPtrTo,
//								flint fliIndexPtrTo,
//								BOOL bIncludeEqual)
//{
//	// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiBeBiInKjDkOjAoGjHjKjHpAiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiChBiChGiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
//	FCDbReadLock autoLockForkReadFrom(project.GetFilePathH(), lDocIdFrom, FDHI_FORK_TABLE_ID);
//	FCDbReadLock autoLockForkReadTo(project.GetFilePathH(), lDocIdTo, FDHI_FORK_TABLE_ID);
//	FCDbWriteLock autoLockProjectWrite(project.GetFilePathH(), CONTROL_TABLE_ID);
//	FCDbWriteLock autoLockForkWriteFrom(project.GetFilePathH(), lDocIdFrom, FDHI_FORK_TABLE_ID);
//	FCDbWriteLock autoLockForkWriteTo(project.GetFilePathH(), lDocIdTo, FDHI_FORK_TABLE_ID);
//	if (!autoLockForkReadFrom.TryLock()) return FALSE;
//	if (!autoLockForkReadTo.TryLock()) return FALSE;
//	if (!autoLockProjectWrite.TryLock()) return FALSE;
//	if (!autoLockForkWriteFrom.TryLock()) return FALSE;
//	if (!autoLockForkWriteTo.TryLock()) return FALSE;
//
//	// _xZkqqHx_iOhNiCnGjHjKjHpAjFkKiKpCiCpAiInKjDkOiClHiCoJiNnLiCmMiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCmMiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
//	const flint fliCmdFilePtrOffset = fliCommandPtrFrom - fliCommandPtrTo;
//	// _xZkqqHx_iOhNiCnGjHjKjHpAjFkKiKpCiCpAiInKjDkOiClHiCoJiNnLiCmMiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCmMiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
//	const flint fliIdxFilePtrOffset = fliIndexPtrFrom - fliIndexPtrTo;
//
//	// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCHiForkTable forkFileFrom;
//	forkFileFrom = project.GetSubGroup(lDocIdFrom);
//	forkFileFrom.UpdateData(autoLockForkReadFrom);
//
//	// _xZkqqHx_iInKjDkOjAoGjHjKjHpAiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	FCHiForkTable forkFileTo;
//	forkFileTo = project.GetSubGroup(lDocIdTo);
//	forkFileTo.UpdateData(autoLockForkReadTo);
//
////----- 04.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iImKjChFiChHiCmMjFkKiKpCiCpAiKnMiCnOiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
////	FCIdxToForkInfoMmap::const_iterator iFi;
////	if (bIncludeEqual)
////		iFi = forkFileFrom.GetForkList().lower_bound(fliSessionIndex);
////	else
////		iFi = forkFileFrom.GetForkList().upper_bound(fliSessionIndex);
////
////	for (; iFi != forkFileFrom.GetForkList().end(); iFi++)
////	{
////		// _xZkqqHx_iJlMjFkKiKpCiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
////		if ((*iFi).second.m_lDocumentId < 0) continue;
////
////		// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCpAiBeBiInKjDkOjAoGjHjKjHpAiCkJiCoHiCmMjFkKiKpCiCmGiClFiCmEjFkBiOmKiBeC_xHqqkZx_
////		forkFileTo.AppendFork(	(*iFi).first,										// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////								(*iFi).second.m_fliCmdPtr - fliCmdFilePtrOffset,	// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
////								(*iFi).second.m_fliIdxPtr - fliIdxFilePtrOffset,	// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////								(*iFi).second.m_lDocumentId);						// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
////
////		// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCmMiBeBjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
////		FCDbWriteLock writeLockVar(&project, (*iFi).second.m_lDocumentId, FDHI_FORK_TABLE_ID);
////		FCDbReadLock readLockVar(&project, (*iFi).second.m_lDocumentId, FDHI_FORK_TABLE_ID);
////		if (!writeLockVar.TryLock()) return FALSE;
////		if (!readLockVar.TryLock()) return FALSE;
////		// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCmMiBeBjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
////		FCHiForkTable forkFile;
////		forkFile.SetProjectAndDid(project, (*iFi).second.m_lDocumentId);
////		forkFile.UpdateData(readLockVar);
////		// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCmMiBeBjAgFjHjKjHpAiCmMiPoOjFpBiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
////		forkFile.SetSuperInfo(	(*iFi).first,
////								(*iFi).second.m_fliCmdPtr - fliCmdFilePtrOffset,
////								(*iFi).second.m_fliIdxPtr - fliIdxFilePtrOffset,
////								lDocIdTo);
////		forkFile.UpdateFile(writeLockVar);
////		// _xZkqqHx_jHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCmMiChGiDiNiDgCiDeOiCpAjFnLjBlGiBeC_xHqqkZx_
////		vWriteLockForFlush.push_back(writeLockVar);
////
////		// _xZkqqHx_jHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCmMiBeBjAgFjHjKjHpAiCmMiPoOjFpBiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
////		FCHiDocumentRec hiDocRecAx = project.GetDocumentRec((*iFi).second.m_lDocumentId);
////		hiDocRecAx.SetSuperDocId(lDocIdTo);
////	}
////----- 04.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	FCForkConstIterator iFork;
//	if (bIncludeEqual)
//		iFork = forkFileFrom.GetLowerBoundFork(fliSessionIndex);
//	else
//		iFork = forkFileFrom.GetUpperBoundFork(fliSessionIndex);
//
//	for (; !iFork.IsEnd(); iFork++)
//	{
//		// _xZkqqHx_iJlMjFkKiKpCiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (iFork.GetIsTemporary()) continue;
//
//		// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCpAiBeBiInKjDkOjAoGjHjKjHpAiCkJiCoHiCmMjFkKiKpCiCmGiClFiCmEjFkBiOmKiBeC_xHqqkZx_
//		forkFileTo.AppendFork(	iFork.GetSessionIndex(),										// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////								iFork.GetCommandFilePtr() - fliCmdFilePtrOffset,	// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
////								iFork.GetIndexFilePtr() - fliIdxFilePtrOffset,	// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//								iFork.GetDocumentId());						// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//
//		// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCmMiBeBjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
//		FCDbReadLock readLockVar(project.GetFilePathH(), iFork.GetDocumentId(), FDHI_FORK_TABLE_ID);
//		FCDbWriteLock writeLockVar(project.GetFilePathH(), iFork.GetDocumentId(), FDHI_FORK_TABLE_ID);
//		if (!readLockVar.TryLock()) return FALSE;
//		if (!writeLockVar.TryLock()) return FALSE;
//		// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCmMiBeBjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		FCHiForkTable forkFile;
//		forkFile = project.GetSubGroup(iFork.GetDocumentId());
//		forkFile.UpdateData(readLockVar);
//		// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCmMiBeBjAgFjHjKjHpAiCmMiPoOjFpBiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
//		forkFile.SetSuperInfo(	iFork.GetSessionIndex(),
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////								iFork.GetCommandFilePtr() - fliCmdFilePtrOffset,
////								iFork.GetIndexFilePtr() - fliIdxFilePtrOffset,
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//								lDocIdTo);
//// 06.01.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////		forkFile.UpdateFile(writeLockVar);
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		// _xZkqqHx_jHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCmMiChGiDiNiDgCiDeOiCpAjFnLjBlGiBeC_xHqqkZx_
////		vWriteLockForFlush.push_back(writeLockVar);
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//		// _xZkqqHx_jHjKjHpAjFkKiKpC_xHqqkZx_(_xZkqqHx_iCgAiCjI_xHqqkZx_)_xZkqqHx_iCmMiBeBjAgFjHjKjHpAiCmMiPoOjFpBiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
//		FCHiDocumentRecW hiDocRecAx = project.GetDocumentRec(iFork.GetDocumentId());
//		hiDocRecAx.SetSuperDocId(lDocIdTo);
//		hiDocRecAx.Update();
//	}
////----- 04.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iImKjChFiChHiCmMjHjKjHpAjFkKiKpCiDfOiDePiCpAiKnMiCnOiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
////----- 04.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	FCIdxToHiForkTagInfoMap::const_iterator iCi;
////	if (bIncludeEqual)
////		iCi = forkFileFrom.GetHiForkTagList().lower_bound(fliSessionIndex);
////	else
////		iCi = forkFileFrom.GetHiForkTagList().upper_bound(fliSessionIndex);
////
////	for (; iCi != forkFileFrom.GetHiForkTagList().end(); iCi++)
////	{
////		// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCmMjHjKjHpAjFkKiKpCiDfOiDePiCpAiBeBiInKjDkOjAoGjHjKjHpAiCmMjHjKjHpAjFkKiKpCiDfOiDePiCmGiClFiCmEjFkBiOmKiBeC_xHqqkZx_
////		forkFileTo.AppendHiForkTag(	(*iCi).first,								// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////										(*iCi).second.m_fdstCreateTime,				// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
////										(*iCi).second.m_fdstUpdateTime,				// _xZkqqHx_iNfIjAfGiOjOiKnEiBeC_xHqqkZx_
////										(*iCi).second.m_guidUserId,					// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
////										(*iCi).second.m_wstrComment);				// _xZkqqHx_iDfCiDiBiDjDiDgHjDoAjHgFiBeC_xHqqkZx_
////	}
////----- 04.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	FCHiForkTagConstIterator iHtcm;
//	if (bIncludeEqual)
//		iHtcm = forkFileFrom.GetLowerBoundHiForkTag(fliSessionIndex);
//	else
//		iHtcm = forkFileFrom.GetUpperBoundHiForkTag(fliSessionIndex);
//	for (; !iHtcm.IsEnd(); iHtcm++)
//	{
//		// _xZkqqHx_iInKjDkOiMlDjHjKjHpAiCmMjHjKjHpAjFkKiKpCiDfOiDePiCpAiBeBiInKjDkOjAoGjHjKjHpAiCmMjHjKjHpAjFkKiKpCiDfOiDePiCmGiClFiCmEjFkBiOmKiBeC_xHqqkZx_
//		forkFileTo.AppendHiForkTag(	iHtcm.GetSessionIndex(),			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//									iHtcm.GetCreateTime(),				// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
//									iHtcm.GetHtreeScore(),				// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
//									iHtcm.GetUserId(),					// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//									iHtcm.GetTitle(),					// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
//									iHtcm.GetComment());				// _xZkqqHx_iDfCiDiBiDjDiDgHjDoAjHgFiBeC_xHqqkZx_
//	}
////----- 04.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//#if 0
//	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiImIiNhOiCmMjHjKjHpAjFkKiKpCiCmGiDfCiDiBiDjDiDgHiCpAiNoNiPjMiBeC_xHqqkZx_
//	forkFileFrom.RemoveAfterSessionIndex(fliSessionIndex, bIncludeEqual);
//#endif//0
////----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiNfIjAfGiBeC_xHqqkZx_
////	project.UpdateFile(autoLockProjectWrite);
////----- 06.01.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
////	forkFileFrom.UpdateFile(autoLockForkWriteFrom);
////	forkFileTo.UpdateFile(autoLockForkWriteTo);
////----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iInKjDkOjAoGjHjKjHpAiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCmMiChGiDiNiDgCiDeOiCpAjFnLjBlGiBeC_xHqqkZx_
////	vWriteLockForFlush.push_back(autoLockProjectWrite);
////	vWriteLockForFlush.push_back(autoLockForkWriteFrom);
////	vWriteLockForFlush.push_back(autoLockForkWriteTo);
////----- 04.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	return TRUE;
//} // CFCHistViewDoc::MoveFork.
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::MoveBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhNiCgAiCmMiImKjChFiChHiImIiNhOiCmMjHjKjHpAjFlGiPjBiCpAiBeBiOhNiCgCiCmMiNmFiMoDiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocIdA				:_xZkqqHx_iOhNiCgAiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocIdC				:_xZkqqHx_iOhNiCgCiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliNextSessionIndexX:_xZkqqHx_iImKjChFiChHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lockBank			:_xZkqqHx_iKgFiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMoveForkOnX		:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiChHiCmJiCkAiCoJjHjKjHpAjFkKiKpCiCpAiInKjDkO_xHqqkZx_
 *								 _xZkqqHx_iClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMoveTimeLabelOnX	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiChHiCmJiCkAiCoJiOjOiKnEiDiJiDhIiDiLiCpAiInKjDkO_xHqqkZx_
 *								 _xZkqqHx_iClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhNiCgAiCmMiImKjChFiChHiImIiNhOiCmMjHjKjHpAjFlGiPjBiCpAiBeBiOhNiCgCiCmMiNmFiMoDiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iCgC_xHqqkZx_                  _xZkqqHx_iCgA_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ K1
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkAiBfO_xHqqkZx_
 *              _xZkqqHx_iBkL_xHqqkZx_                  _xZkqqHx_iEkFiEjP_xHqqkZx_J1_xZkqqHx_iEkC_xHqqkZx_
 *                                _xZkqqHx_iChHiEkH_xHqqkZx_    _xZkqqHx_iBkL_xHqqkZx_
 *                                  _xZkqqHx_iEkA_xHqqkZx_- L1
 *                                  _xZkqqHx_iEkA_xHqqkZx_
 *                                  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ K2
 *                                  _xZkqqHx_iEkAiBfO_xHqqkZx_
 *                                  _xZkqqHx_iEkFiEjP_xHqqkZx_J2_xZkqqHx_iEkC_xHqqkZx_
 *                                  _xZkqqHx_iEkA_xHqqkZx_- T _xZkqqHx_iBkL_xHqqkZx_
 *                                  _xZkqqHx_iBkL_xHqqkZx_
 *
 *                      _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                     _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                       _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *              _xZkqqHx_iCgC_xHqqkZx_                  _xZkqqHx_iCgA_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ K1
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkAiBfO_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkFiEjP_xHqqkZx_J1_xZkqqHx_iEkC_xHqqkZx_
 *            _xZkqqHx_iChHiEkH_xHqqkZx_                _xZkqqHx_iChHiBkL_xHqqkZx_    _xZkqqHx_iBkL_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_- L1              
 *              _xZkqqHx_iEkA_xHqqkZx_                  
 *              _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ K2          
 *              _xZkqqHx_iEkAiBfO_xHqqkZx_                
 *              _xZkqqHx_iEkFiEjP_xHqqkZx_J2_xZkqqHx_iEkC_xHqqkZx_            
 *              _xZkqqHx_iEkA_xHqqkZx_- T _xZkqqHx_iBkL_xHqqkZx_            
 *              _xZkqqHx_iBkL_xHqqkZx_                  
 *
 *			--------------------------------------------------------------
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiBeBiDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiPoKiNiHiBeBiChHiCmFiOhHjCoIiClDiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiCoGiCoIiJlKiCmJiCkAiCoJiDfKiDgCiDfGiDiHiDjDiCpAjBfDiCmEiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiL_xHqqkZx_      _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiL_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session3_xZkqqHx_iEkAiEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_Session3_xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session4_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiBkIiEkA_xHqqkZx_Session6_xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session5_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkBiBkIiEkA_xHqqkZx_Session8_xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iChHiBkIiEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session6_xZkqqHx_iEkAiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session7_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session8_xZkqqHx_iEkAiEjPiEjPiEjPiEkD_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *
 *                              _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *                            _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                             _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                               _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *                                    _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiL_xHqqkZx_
 *                                      _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                              _xZkqqHx_iEkBiEjPiEjPiBkIiEkA_xHqqkZx_Session6_xZkqqHx_iEkA_xHqqkZx_
 *                              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *              _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiEkA_xHqqkZx_  _xZkqqHx_iEkBiBkIiEkA_xHqqkZx_Session8_xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iChHiBkIiEkBiEjPiEjPiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session6_xZkqqHx_iEkAiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session7_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session8_xZkqqHx_iEkAiEjPiEjPiEjPiEkD_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *
 *			--------------------------------------------------------------
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiBeBjFkKiKpCiDfOiDePiBeBiOjOiKnEiDiJiDhIiDiLiCmNiDfKiDgCiDfGiDiHiDjDiLkLiKeFiCmJiCkAiCoJiClNiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_iInKjDkOiClHiCoJiCkJiCmHiCkEiCkJiCmNiIpIjAjEiCmFiOhHjCoIiBeC_xHqqkZx_
 *			_xZkqqHx_iDfIiDhMiDgCiDgHiCmNiBeBiInKjDkOiCmMiMiLiJmKiDfIiDhMiDgCiDgHiCkKiLnPjAnKiClHiCoJiClBiCmGiCkKjGlDiCkCiCoGiCkEjClCjAkOiClFiCmE_xHqqkZx_
 *			_xZkqqHx_jDfNjBjHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iPeJjCfLiImKjChFiDgFiBfLiDhFiDiLiCmNiBeB_xHqqkZx_bIsTerminateToX=TRUE _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_
 *			_xZkqqHx_iCmNiImKjChFiChHiCpAjAnNjCoIiBeC_xHqqkZx_bIsTerminateToX=FALSE _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_jFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::MoveBranch (	FCHiProject& project,
									long lDocIdA,
									long lDocIdC,
									flint fliNextSessionIndexX,
									FCDbLockBank& lockBank,
									BOOL bIsTerminateAToX,
									BOOL bIsMoveForkOnX,
									BOOL bIsMoveTimeLabelOnX)
{
	// _xZkqqHx_iCnMiClIiBeBiCgAiCkJiCoHiCgCiCnGiBeBiChHiImIiNhOiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	if (!CopyBranch(project,
					lDocIdA,
					lDocIdC,
					fliNextSessionIndexX,
					lockBank,
					bIsMoveForkOnX,
					bIsMoveTimeLabelOnX))
		return FALSE;
	// _xZkqqHx_iOjPiCmJiBeBiCgAiCmMiChHiImIiNhOiCpAiNoNiPjMiBeC_xHqqkZx_
	if (!ShortenBranch(	project,
						lDocIdA,
						fliNextSessionIndexX,
						lockBank,
						bIsTerminateAToX,
						bIsMoveForkOnX,
						bIsMoveTimeLabelOnX))
		return FALSE;
	return TRUE;
} // CFCHistViewDoc::MoveBranch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::CopyBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhNiCgAiCmMiImKjChFiChHiImIiNhOiCmMjHjKjHpAjFlGiPjBiCpAiBeBiOhNiCgCiCmMiNmFiMoDiCmJiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocIdA				:_xZkqqHx_iOhNiCgAiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocIdC				:_xZkqqHx_iOhNiCgCiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliNextSessionIndexX:_xZkqqHx_iImKjChFiChHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lockBank			:_xZkqqHx_iKgFiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsCopyForkOnX		:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiChHiCmJiCkAiCoJjHjKjHpAjFkKiKpCiCpAiDfCiDhDiBfL_xHqqkZx_
 *								 _xZkqqHx_iClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsCopyTimeLabelOnX	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiChHiCmJiCkAiCoJiOjOiKnEiDiJiDhIiDiLiCpAiDfCiDhDiBfL_xHqqkZx_
 *								 _xZkqqHx_iClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhNiCgAiCmMiImKjChFiChHiImIiNhOiCmMjHjKjHpAjFlGiPjBiCpAiBeBiOhNiCgCiCmMiNmFiMoDiCmJiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iCgC_xHqqkZx_                  _xZkqqHx_iCgA_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ K1
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkAiBfO_xHqqkZx_
 *              _xZkqqHx_iBkL_xHqqkZx_                  _xZkqqHx_iEkFiEjP_xHqqkZx_J1_xZkqqHx_iEkC_xHqqkZx_
 *                                _xZkqqHx_iChHiEkH_xHqqkZx_    _xZkqqHx_iBkL_xHqqkZx_
 *                                  _xZkqqHx_iEkA_xHqqkZx_- L1
 *                                  _xZkqqHx_iEkA_xHqqkZx_
 *                                  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ K2
 *                                  _xZkqqHx_iEkAiBfO_xHqqkZx_
 *                                  _xZkqqHx_iEkFiEjP_xHqqkZx_J2_xZkqqHx_iEkC_xHqqkZx_
 *                                  _xZkqqHx_iEkA_xHqqkZx_- T _xZkqqHx_iBkL_xHqqkZx_
 *                                  _xZkqqHx_iBkL_xHqqkZx_
 *
 *                      _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                     _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                       _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *              _xZkqqHx_iCgC_xHqqkZx_                  _xZkqqHx_iCgA_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ K1
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkAiBfO_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkFiEjP_xHqqkZx_J1_xZkqqHx_iEkC_xHqqkZx_
 *            _xZkqqHx_iChHiEkH_xHqqkZx_                _xZkqqHx_iChHiEkH_xHqqkZx_    _xZkqqHx_iBkL_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_- L1              _xZkqqHx_iEkA_xHqqkZx_- L1
 *              _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ K2          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjP_xHqqkZx_ K2
 *              _xZkqqHx_iEkAiBfO_xHqqkZx_                _xZkqqHx_iEkAiBfO_xHqqkZx_
 *              _xZkqqHx_iEkFiEjP_xHqqkZx_J2_xZkqqHx_iEkC_xHqqkZx_            _xZkqqHx_iEkFiEjP_xHqqkZx_J2_xZkqqHx_iEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_- T _xZkqqHx_iBkL_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_- T _xZkqqHx_iBkL_xHqqkZx_
 *              _xZkqqHx_iBkL_xHqqkZx_                  _xZkqqHx_iBkL_xHqqkZx_
 *
 *			--------------------------------------------------------------
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiBeBiDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiPoKiNiHiBeBiChHiCmFiOhHjCoIiClDiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiCoGiCoIiJlKiCmJiCkAiCoJiDfKiDgCiDfGiDiHiDjDiCpAjBfDiCmEiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiL_xHqqkZx_      _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiL_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session3_xZkqqHx_iEkAiEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_Session3_xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session4_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiBkIiEkA_xHqqkZx_Session6_xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session5_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkBiBkIiEkA_xHqqkZx_Session8_xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iChHiBkIiEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session6_xZkqqHx_iEkAiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session7_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session8_xZkqqHx_iEkAiEjPiEjPiEjPiEkD_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *
 *                              _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *                            _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                             _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                               _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *                                    _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiL_xHqqkZx_
 *                                      _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                              _xZkqqHx_iEkBiEjPiEjPiBkIiEkA_xHqqkZx_Session6_xZkqqHx_iEkA_xHqqkZx_
 *                              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *              _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiEkA_xHqqkZx_  _xZkqqHx_iEkBiBkIiEkA_xHqqkZx_Session8_xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iChHiBkIiEkBiEjPiEjPiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session6_xZkqqHx_iEkAiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session7_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session8_xZkqqHx_iEkAiEjPiEjPiEjPiEkD_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *
 *			--------------------------------------------------------------
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiBeBjFkKiKpCiDfOiDePiBeBiOjOiKnEiDiJiDhIiDiLiCmNiDfKiDgCiDfGiDiHiDjDiLkLiKeFiCmJiCkAiCoJ_xHqqkZx_
 *			_xZkqqHx_iClNiCnPiBeBiDfCiDhDiBfLiClHiCoJiCkJiCmHiCkEiCkJiCmNiIpIjAjEiCmFiOhHjCoIiBeC_xHqqkZx_
 *			_xZkqqHx_iDfIiDhMiDgCiDgHiCmNiBeBiDfCiDhDiBfLiCmMiMiLiJmKiDfIiDhMiDgCiDgHiCkKiLnPjAnKiClHiCoJiClBiCmGiCkKjGlDiCkCiCoGiCkE_xHqqkZx_
 *			_xZkqqHx_jClCjAkOiClFiCmEjDfNjBjHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iPeJjCfLiImKjChFiDgFiBfLiDhFiDiLiCmNiBeBiClLiCmMiCnMiCnMiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::CopyBranch (	FCHiProject& project,
									long lDocIdA,
									long lDocIdC,
									flint fliNextSessionIndexX,
									FCDbLockBank& lockBank,
									BOOL bIsCopyForkOnX,
									BOOL bIsCopyTimeLabelOnX)
{
	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiCpAiDfCiDhDiBfL_xHqqkZx_ -----
	// _xZkqqHx_iCgAiCmGiCgCiCmMiDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCDbTable dbTableCommandA = project.GetSubTable(lDocIdA, FDHI_COMMAND_TABLE_ID);
	FCDbTable dbTableCommandC = project.GetSubTable(lDocIdC, FDHI_COMMAND_TABLE_ID);
	// _xZkqqHx_iImKjChFiChHiCmMiDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwCommandIndexA = dbTableCommandA.PrimaryIdToIndex(fliNextSessionIndexX);
	if (dwCommandIndexA != -1)
	//----- _xZkqqHx_iDiMiDfCiBfLiDgIiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iCgAiCmMiImKjChFiChHiImIiNhOiBgJiChHiCpAiKnMiCnOiBgKiCpAiCgCiCmJjCmHiJmBiClFiCmEjFkBiOmKiBeC_xHqqkZx_
		dbTableCommandC.CopyRecord(dbTableCommandA.GetTableName(), dwCommandIndexA, DWORD(-1));
	}

	//----- _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCpAiDfCiDhDiBfL_xHqqkZx_ -----
	// _xZkqqHx_iCgAiCmGiCgCiCmMiDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCDbTable dbTableSummaryA = project.GetSubTable(lDocIdA, FDHI_SUMMARY_TABLE_ID);
	FCDbTable dbTableSummaryC = project.GetSubTable(lDocIdC, FDHI_SUMMARY_TABLE_ID);
	// _xZkqqHx_iImKjChFiChHiImIiNhOiBgJiChHiCpAiKnMiCnOiBgKiCmMiDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwSummaryIndexA = dbTableSummaryA.PrimaryIdToLowerBoundIndex(fliNextSessionIndexX);
	if (dwSummaryIndexA != -1)
	//----- _xZkqqHx_iDiMiDfCiBfLiDgIiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iCgAiCmMiImKjChFiChHiImIiNhOiBgJiChHiCpAiKnMiCnOiBgKiCpAiCgCiCmJjCmHiJmBiClFiCmEjFkBiOmKiBeC_xHqqkZx_
		dbTableSummaryC.CopyRecord(dbTableSummaryA.GetTableName(), dwSummaryIndexA, DWORD(-1));
	}

	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiDfCiDhDiBfL_xHqqkZx_ -----
	// _xZkqqHx_iCgAiCmGiCgCiCmMjHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCHiForkTable forkTableA = project.GetSubGroup(lDocIdA);
	forkTableA.UpdateDataA(lockBank);
	FCHiForkTable forkTableC = project.GetSubGroup(lDocIdC);
	forkTableC.UpdateDataA(lockBank);

	//----- _xZkqqHx_jFkBiOmKjAoGiCmJjFkKiKpCiPoOjFpBiCpAjAnNjCoI_xHqqkZx_ -----
	FCForkConstIterator iFork;
	FCTimeLabelConstIterator iTime;
	FCHiForkTagConstIterator iTag;
	if (bIsCopyForkOnX)
	{
		iFork = forkTableA.GetLowerBoundFork(fliNextSessionIndexX);
		iTag = forkTableA.GetLowerBoundHiForkTag(fliNextSessionIndexX);
	} else
	{
		iFork = forkTableA.GetUpperBoundFork(fliNextSessionIndexX);
		iTag = forkTableA.GetUpperBoundHiForkTag(fliNextSessionIndexX);
	}
	if (bIsCopyTimeLabelOnX)
		iTime = forkTableA.GetLowerBoundTimeLabel(fliNextSessionIndexX);
	else
		iTime = forkTableA.GetUpperBoundTimeLabel(fliNextSessionIndexX);
	for (; !iFork.IsEnd(); iFork++)
	{
		// _xZkqqHx_jFkBiOmKiClHiCoJiBeC_xHqqkZx_
		forkTableC.AppendFork(	iFork.GetSessionIndex(),
								iFork.GetDocumentId());
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmMjFkKiKpCjAoGiCmMiPoDiImKjFlGiPjBiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
		FCHiDocumentRecW hiDocRecSub = project.GetDocumentRec(iFork.GetDocumentId());
		hiDocRecSub.SetSuperDocId(lDocIdC);
		hiDocRecSub.Update();
		// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLjCiGiCmMjFkKiKpCjAoGiCmMiPoDiImKjFlGiPjBiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
		FCHiForkTable forkTableSub = project.GetSubGroup(iFork.GetDocumentId());
		forkTableSub.UpdateDataA(lockBank);
		forkTableSub.SetSuperInfo(iFork.GetSessionIndex(), lDocIdC);
	}

	//----- _xZkqqHx_jFkBiOmKjAoGiCmJiOjOiKnEiDiJiDhIiDiLiCpAjAnNjCoI_xHqqkZx_ -----
	for (; !iTime.IsEnd(); iTime++)
	{
		// _xZkqqHx_jFkBiOmKiClHiCoJiBeC_xHqqkZx_
		forkTableC.AppendTimeLabel(	iTime.GetSessionIndex(),
									iTime.GetTimeLabelId(),
									iTime.GetSheetId(),
									iTime.GetPoint(),
									iTime.GetCreateTime(),
									iTime.GetUserId(),
									iTime.GetLabelText());
	}

	//----- _xZkqqHx_jFkBiOmKjAoGiCmJjFkKiKpCiDfOiDePiCpAjAnNjCoI_xHqqkZx_ -----
	for (; !iTag.IsEnd(); iTag++)
	{
		// _xZkqqHx_jFkBiOmKiClHiCoJiBeC_xHqqkZx_
		forkTableC.AppendHiForkTag(	iTag.GetSessionIndex(),
									iTag.GetCreateTime(),
									iTag.GetHtreeScore(),
									iTag.GetUserId(),
									iTag.GetTitle(),
									iTag.GetComment());
	}

	//----- _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiDfCiDhDiBfL_xHqqkZx_ -----
	//
	// _xZkqqHx_iClLiCmMiCnMiCnMiOhNiCgAiCmMiChHiImIiNhOiCmMiDfIiDhMiDgCiDgHiCpAiCgCiCmJjCmHiJmBiClFiCmEiClFiCnMiCkEiCmGiBeBiJlKjAhNiCmMiCoGiCkEiCmJ_xHqqkZx_
	// _xZkqqHx_iDfIiDhMiDgCiDgHiKnEiCkKiLnPjAnKiClFiCmEiClFiCnMiCkEiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	//
	//     _xZkqqHx_iCgC_xHqqkZx_              _xZkqqHx_iCgA_xHqqkZx_                              _xZkqqHx_iCgC_xHqqkZx_              _xZkqqHx_iCgA_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkAiBkI_xHqqkZx_ m1         _xZkqqHx_iEkAiBkI_xHqqkZx_ M1                         _xZkqqHx_iEkAiBkI_xHqqkZx_ m1         _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkAiBkI_xHqqkZx_ M1
	//     _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
	//     _xZkqqHx_iBkLiBkI_xHqqkZx_ m2       _xZkqqHx_iChHiEkHiBkI_xHqqkZx_ M2           _xZkqqHx_iEkAiBfP_xHqqkZx_          _xZkqqHx_iEkAiBkI_xHqqkZx_ m2,M2    _xZkqqHx_iChHiBkLiBkI_xHqqkZx_ M2
	//                     _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkBiEjPiEkD_xHqqkZx_  _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
	//                     _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        >       _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkE_xHqqkZx_ _xZkqqHx_iDfIiDhMiDgCiDgH_xHqqkZx_m2_xZkqqHx_iCmG_xHqqkZx_M2_xZkqqHx_iCkK_xHqqkZx_
	//                     _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkEiEjPiEkC_xHqqkZx_  _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iLnPjAnKiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	//                     _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkAiBfO_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
	//                     _xZkqqHx_iEkAiBkI_xHqqkZx_ M3                         _xZkqqHx_iEkAiBkI_xHqqkZx_ M3
	//                     _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
	//                     _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
	//                     _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
	//                     _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
	//                     _xZkqqHx_iEkAiBkI_xHqqkZx_ M4                         _xZkqqHx_iEkAiBkI_xHqqkZx_ M4
	//                     _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
	//                     _xZkqqHx_iBkL_xHqqkZx_                              _xZkqqHx_iBkL_xHqqkZx_
	//
	// _xZkqqHx_iClBiCoKiCpAjGgIiCkOiClNiCnPiBeBiOhNiCgCiCmMiNmFiMoDiCmMiDfIiDhMiDgCiDgH_xHqqkZx_(m2)_xZkqqHx_iCmGiOhNiCgAiCmMiImKjChFiChHiImIiNhOiCmM_xHqqkZx_
	// _xZkqqHx_iNmFiPiJiCmMiDfIiDhMiDgCiDgH_xHqqkZx_(M2)_xZkqqHx_iCmMiLjHjHkDiCpAjClCiCnHiBeBiLjHjHkDiCkKiPkMiClDiCkCiPoKiNiHiCmN_xHqqkZx_M2_xZkqqHx_iCpAiDfIiDeMiDgCiDhG_xHqqkZx_
	// _xZkqqHx_iClFiCmE_xHqqkZx_M3_xZkqqHx_iCkJiCoHiDfCiDhDiBfLiClHiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iCmIiCkIiBeBiPoDjAhNiCmMiCoGiCkEiCmJiImKjChFiChHiClPiCoFiCkEiCmHiCmJiDfIiDhMiDgCiDgHiCkKjHeMiCoJiPoKiNiH_xHqqkZx_(M2)_xZkqqHx_iBeB_xHqqkZx_
	// M2_xZkqqHx_iCpAiOhNiCgCiCmJjFkBiOmKiClFiClNiPoKiNiHiCmFiCoAiOhNiCgAiCmM_xHqqkZx_M2_xZkqqHx_iCmNiOgDiClFiCmEiCkIiCkNiClBiCmGiBeC_xHqqkZx_
	//
	// _xZkqqHx_iCgAiCmGiCgCiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCDbTable dbTableSpotA = project.GetSubTable(lDocIdA, FDHI_SPOT_TABLE_ID);
	FCDbTable dbTableSpotC = project.GetSubTable(lDocIdC, FDHI_SPOT_TABLE_ID);
	// _xZkqqHx_iImKjChFiChHiImIiNhOiBgJiChHiCpAiKnMiCnOiBgKiCmMiDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwSpotIndexM2 = dbTableSpotA.PrimaryIdToLowerBoundIndex(fliNextSessionIndexX);
	if (dwSpotIndexM2 != -1)
	//----- _xZkqqHx_iDiMiDfCiBfLiDgIiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfIiDhMiDgCiDgH_xHqqkZx_M2 _xZkqqHx_iCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		flint fliFirstSpotSessionA = dbTableSpotA.GetRecordPrimaryId(dwSpotIndexM2);
		if (dbTableSpotC.GetRecordCount() != 0)
		//----- _xZkqqHx_iOhNiCgCiCmJiIoKiCmCiImIiPoDiDfIiDhMiDgCiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfIiDhMiDgCiDgH_xHqqkZx_m2 _xZkqqHx_iCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			flint fliLastSpotSessionC = dbTableSpotC.GetRecordPrimaryId(dbTableSpotC.GetRecordCount() - 1);
			// _xZkqqHx_iDfIiDhMiDgCiDgH_xHqqkZx_m2 _xZkqqHx_iCmG_xHqqkZx_M2 _xZkqqHx_iCmMiLjHjHkDiCkKiLnPiCkCiPoKiNiHiCmNiBeB_xHqqkZx_M2_xZkqqHx_iCmMiOjPiCmM_xHqqkZx_M3_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
			if (fliFirstSpotSessionA - fliLastSpotSessionC < FD_SPOT_INTERVAL_SESSION_INDEX / 4)
				dwSpotIndexM2++;
		}
		if (dwSpotIndexM2 != dbTableSpotA.GetRecordCount())
		//----- _xZkqqHx_iOhNiCgAiCmMiImKjChFiChHiImIiNhOiCmMiDfIiDhMiDgCiDgHiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iCgAiCmMiImKjChFiChHiImIiNhOiBgJiChHiCpAiKnMiCnOiBgKiCpAiCgCiCmJjCmHiJmBiClFiCmEjFkBiOmKiBeC_xHqqkZx_
			dbTableSpotC.CopyRecord(dbTableSpotA.GetTableName(), dwSpotIndexM2, DWORD(-1));
		}
	}

	//----- _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiDfCiDhDiBfL_xHqqkZx_ -----
	// _xZkqqHx_iCgAiCmGiCgCiCmMjHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCDbTable dbTableTerminateA = project.GetSubTable(lDocIdA, FDHI_TERMINATE_TABLE_ID);
	FCDbTable dbTableTerminateC = project.GetSubTable(lDocIdC, FDHI_TERMINATE_TABLE_ID);
	// _xZkqqHx_iCgAiCpAiCgCiCmJjFkBiOmKiBeC_xHqqkZx_
	dbTableTerminateC.ReduceRecordCount(0);
	dbTableTerminateC.CopyRecord(dbTableTerminateA.GetTableName(), 0, DWORD(-1));
	return TRUE;
} // CFCHistViewDoc::CopyBranch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::ShortenBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhNiCgAiCmMiImKjChFiChHiImIiNhOiCmMjHjKjHpAjFlGiPjBiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId				:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliNextSessionIndexX:_xZkqqHx_iImKjChFiChHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lockBank			:_xZkqqHx_iKgFiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsTerminateToX		:_xZkqqHx_iImKjChFiChHiCmJiPeJjCfLiCpAjAnNjCoIiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 FALSE_xZkqqHx_iCmMiPoKiNiHiCmNiPeJjCfLiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *			bIsDeleteForkOnX	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiChHiCmJiCkAiCoJjHjKjHpAjFkKiKpCiCpAiNoNiPjM_xHqqkZx_
 *								 _xZkqqHx_iClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsDeleteTimeLabelOnX:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiChHiCmJiCkAiCoJiOjOiKnEiDiJiDhIiDiLiCpAiNoNiPjM_xHqqkZx_
 *								 _xZkqqHx_iClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiBeBiDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiPoKiNiHiBeBiChHiCmFiOhHjCoIiClDiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiLkLiKeFiCoGiCoIiJlKiCmJiCkAiCoJiDfKiDgCiDfGiDiHiDjDiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiL_xHqqkZx_      _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiL_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session3_xZkqqHx_iEkAiEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_Session3_xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session4_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiBkIiEkA_xHqqkZx_Session6_xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session5_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkBiBkIiEkA_xHqqkZx_Session8_xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iChHiBkIiEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session6_xZkqqHx_iEkAiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session7_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session8_xZkqqHx_iEkAiEjPiEjPiEjPiEkD_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *
 *                              _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_
 *                            _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *                             _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                               _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *              _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiL_xHqqkZx_      _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiL_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session3_xZkqqHx_iEkAiEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_Session3_xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session4_xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_Session5_xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iChHiBkIiEkEiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *			--------------------------------------------------------------
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiBeBjFkKiKpCiDfOiDePiBeBiOjOiKnEiDiJiDhIiDiLiCmNiDfKiDgCiDfGiDiHiDjDiLkLiKeFiCmJiCkAiCoJ_xHqqkZx_
 *			_xZkqqHx_iClNiCnPiBeBiNoNiPjMiClHiCoJiCkJiCmHiCkEiCkJiCmNiIpIjAjEiCmFiOhHjCoIiBeC_xHqqkZx_
 *			_xZkqqHx_iPeJjCfLiImKjChFiDgFiBfLiDhFiDiLiCmNiBeB_xHqqkZx_bIsTerminateToX=TRUE _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_
 *			_xZkqqHx_iCmNiImKjChFiChHiCpAjAnNjCoIiBeC_xHqqkZx_bIsTerminateToX=FALSE _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_jFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::ShortenBranch (FCHiProject& project,
									long lDocId,
									flint fliNextSessionIndexX,
									FCDbLockBank& lockBank,
									BOOL bIsTerminateToX,
									BOOL bIsDeleteForkOnX,
									BOOL bIsDeleteTimeLabelOnX)
{
	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiCpAiPgLiPkM_xHqqkZx_ -----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCDbTable dbTableCommand = project.GetSubTable(lDocId, FDHI_COMMAND_TABLE_ID);
	// _xZkqqHx_iImKjChFiChHiCmMiDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwCommandIndex = dbTableCommand.PrimaryIdToIndex(fliNextSessionIndexX);
	// _xZkqqHx_iCgAiCmMiImKjChFiChHiImIiNhOiBgJiChHiCpAiKnMiCnOiBgKiCpAiNoNiPjMiBeC_xHqqkZx_
	if (dwCommandIndex != -1)
		dbTableCommand.ReduceRecordCount(dwCommandIndex);

	//----- _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCpAiPgLiPkM_xHqqkZx_ -----
	// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCDbTable dbTableSummary = project.GetSubTable(lDocId, FDHI_SUMMARY_TABLE_ID);
	// _xZkqqHx_iImKjChFiChHiImIiNhOiBgJiChHiCpAiKnMiCnOiBgKiCmMiDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwSummaryIndex = dbTableSummary.PrimaryIdToLowerBoundIndex(fliNextSessionIndexX);
	// _xZkqqHx_iCgAiCmMiImKjChFiChHiImIiNhOiBgJiChHiCpAiKnMiCnOiBgKiCpAiNoNiPjMiBeC_xHqqkZx_
	if (dwSummaryIndex != -1)
		dbTableSummary.ReduceRecordCount(dwSummaryIndex);

	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiPgLiPkM_xHqqkZx_ -----
	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCHiForkTable forkTable = project.GetSubGroup(lDocId);
	forkTable.UpdateDataA(lockBank);
	// _xZkqqHx_iChHiImIiNhOiCmMjFkKiKpCiBeBiDfOiDePiBeBiDiJiDhIiDiLiCpAjGjFiPmBiBeC_xHqqkZx_
	forkTable.RemoveAfterSessionIndex(	fliNextSessionIndexX,
										bIsDeleteForkOnX,
										bIsDeleteTimeLabelOnX);

	//----- _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiPgLiPkM_xHqqkZx_ -----
	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCDbTable dbTableSpot = project.GetSubTable(lDocId, FDHI_SPOT_TABLE_ID);
	// _xZkqqHx_iImKjChFiChHiImIiNhOiBgJiChHiCpAiKnMiCnMiCmIiCkCiBgKiCmMiDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwSpotIndex = dbTableSpot.PrimaryIdToUpperBoundIndex(fliNextSessionIndexX);
	// _xZkqqHx_iCgAiCmMiImKjChFiChHiImIiNhOiBgJiChHiCpAiKnMiCnMiCmIiCkCiBgKiCpAiNoNiPjMiBeC_xHqqkZx_
	if (dwSpotIndex != -1)
		dbTableSpot.ReduceRecordCount(dwSpotIndex);

	if (bIsTerminateToX)
	{
		//----- _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiInKjDkO_xHqqkZx_ -----
		// _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
		FCHiTerminateTable terminateTable = project.GetSubGroup(lDocId);
		terminateTable.UpdateDataA(lockBank);
		// _xZkqqHx_iPeJjCfLiImKjChFiCpA_xHqqkZx_X_xZkqqHx_iCmJjAnNjCoIiBeC_xHqqkZx_
		terminateTable.UpdateEndSessionIndex(fliNextSessionIndexX, NULL, 0);
	}
	return TRUE;
} // CFCHistViewDoc::ShortenBranch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqMoveHistoryToLowerTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_MOVE_HISTORY_TO_LOWER_TREE]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjGnIiCmMiJlKiImKiCnGiInKjDkOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arg	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ret	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DRR_OK:	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiBeC_xHqqkZx_
 *			FD_DRR_LATER:	_xZkqqHx_iPiIjHjNiCpAiDhJiDjDiDgGiDeCiDjDiDePiBeC_xHqqkZx_
 *			FD_DRR_ERR	_xZkqqHx_iPiIjHjNiCkKiOlIjEhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqMoveHistoryToLowerTree (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiCnNiNmFjAfGiCmMiPpDjBnEiCmJiBeC_xHqqkZx_
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//										 	FCReqLock::PROJECT_READ);
//	if (result != FD_DRR_OK) return result;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	long lNextDocId = GetNextSameLevelBranch(GetDocumentId(), GetDocumentId(), GetNextSessionIndex());
	if (lNextDocId != -1)
	//----- _xZkqqHx_iOjPiCmMiOhNiCkKiMkJiCmCiCkPiCoHiCoKiCoHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAiCpAiJlKiImKiCmJiInKjDkOiClFiCmEiCoAiBeBjFfMiOkGjDoAjHgFiCmJiIoBiCkCiCmNiCmIiCkCiClNiCnPiBeBiNmEjFgAiJoGiCmNiClFiCmIiCkCiBeC_xHqqkZx_
		// FCReqBase::IS_REDRAW = FALSE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_

		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
		DWORDSet stSelectObjectId;
		g_pView->GetSelectObjectId(stSelectObjectId);

		// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAiPpDjBnEiCmNiDeOiDiKiDeBiClDiCoKiCoJiClNiCnPiBeBiClBiClBiCmFjFjEjFgJjBeJjBpAiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCmNiPmBiLiOiClFiCmIiCkCiBeC_xHqqkZx_
		g_pView->ClearSelectObj(FALSE);

		// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		InsertDocRequest(1, ID_DREQ_CLOSE_HIDOCUMENT,
						FCReqBase::IS_REDRAW, FALSE,
						FCReqBase::NONE);
		// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkNiBeC_xHqqkZx_
		InsertDocRequest(2, ID_DREQ_OPEN_HIDOCUMENT,
						FCReqBase::HIDOCUMENT_ID, lNextDocId,
						FCReqBase::SESSION_INDEX, GetNextSessionIndex(),
						FCReqBase::IS_USE_LAST_CANVAS_STAT, TRUE,
						FCReqBase::IS_REDRAW, FALSE,
						FCReqBase::NONE);

		// _xZkqqHx_jFjEjFgJiCpAjBeJjBpAiBeCjBeJjBpAiDhNiBfLiDeOiCmNjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
		InsertDocRequest(3,
						ID_DREQ_SELECT_OBJECT,
						FCReqBase::OBJECT_ID_SET, &stSelectObjectId,
						FCReqBase::IS_SELECT_OBJECT, TRUE,
						FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::NONE,
						FCReqBase::IS_DRAW_SELECT_MARK, FALSE,
						FCReqBase::NONE);
//----- 05.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	return FD_DRR_OK;
} // CFCHistViewDoc::OnReqMoveHistoryToLowerTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqPushCurrentToDsm
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_PUSH_CURRENT_TO_DSM]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCHistViewDoc::OnReqPushCurrentToDsm (FCReqBase& ret, FCReqLock& reqLock)
{
//----- 06.03.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (GetIsDocumentOpened())
//	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (m_lCurrentDsmPosition != -1 &&
//			g_pProject->GetTableName().GetTopDirPath() == m_vDsmHistory[m_lCurrentDsmPosition]->m_hstrProjectFilePath &&
//			GetDocumentId() == m_vDsmHistory[m_lCurrentDsmPosition]->m_lDocumentId &&
//			GetNextSessionIndex() == m_vDsmHistory[m_lCurrentDsmPosition]->m_fliSessionIndex)
//		//----- DSM_xZkqqHx_jHjKjHpAiMlLiNnNiCmMiLeMjIfOiCkKiMlLiNnNiImKjChFiCmGjDkPiClGiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iMlLiNnNiCmM_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCkKiMlLiNnNiImKjChFiCmGjDkPiClGiPoKiNiHiCmNiBeB_xHqqkZx_
//			// _xZkqqHx_iClLiCmMiMlLiNnNiImKjChFiCmMjHjKjHpAiCoAiNoNiCoIiCmGiCmBiCmEiBeBjAfGiClFiCkNjCmHiJmBiClHiCoJiBeC_xHqqkZx_
//			// _xZkqqHx_iNoNiCoIiOoGiCoHiClIjCmHiJmBiCoAiClFiCmIiCkCiBeBiCmGiCkCiCkEiOoIiCoAiCkAiCoJiCkKiBeB_xHqqkZx_
//			// _xZkqqHx_jFjEjFgJjBeJjBpAiCoCiNmAjFfHjDjJiBeB_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCmGiMlLiNnNiCmMiPoOjFpBiCkKiInJiCmIiCoJiPoKiNiHiCoA_xHqqkZx_
//			// _xZkqqHx_iCkAiCoJiCmMiCmFiBeBjAfGiClFiCkNjCmHiJmBiClFiCmIiCkIiClFiClNiCnJiCkEiCkKiCoGiCkCiBeC_xHqqkZx_
//			m_lCurrentDsmPosition--;
//		}
//		// _xZkqqHx_iMlLiNnNiCmM_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiImIiNhOiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
//		m_vDsmHistory.erase(m_vDsmHistory.begin() + m_lCurrentDsmPosition + 1, m_vDsmHistory.end());
//		if (FD_DSM_HISTORY_MAX < m_vDsmHistory.size())
//		//----- DSM_xZkqqHx_jHjKjHpAiCmMiDfEiDeDiDfJiCkKiMmAjDhIiCpAiJhKiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iNoNiPjMiClHiCoJiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
//			const long lReduce = m_vDsmHistory.size() - FD_DSM_HISTORY_MIN;
//			// _xZkqqHx_iMmDiCkC_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCkJiCoHiNoNiPjMiClHiCoJiBeC_xHqqkZx_
//			m_vDsmHistory.erase(m_vDsmHistory.begin(), m_vDsmHistory.begin() + lReduce);
//			m_lCurrentDsmPosition -= lReduce;
//		}
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//		DWORDSet stObjId;
//		g_pView->GetSelectObjectId(stObjId);
//		// _xZkqqHx_jBeJjBpAjCiGiCmMiDgFiDeMiDfIiDgHjEmNiImNiCpAiOoGjDlOiBeC_xHqqkZx_
//		DWORDVector vTextSelection;
//		mdef_const_iterator(DWORDSet, iId);
//		m1_for (iId, stObjId)
//			g_pDoc->ObjID2Object(*iId)->GetTextSelection(vTextSelection);
//		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
//		DBLRect mmrtClient;
//		g_pView->GetClientRectMM(mmrtClient);
//		// _xZkqqHx_jAfGiClFiCkC_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
//		FCDsmRec* pRec = new FCDsmRec(g_pProject->GetFilePathH(),
//													GetDocumentId(),
//													GetNextSessionIndex(),
//													stObjId,
//													vTextSelection,
//													mmrtClient.CenterPoint(),
//													GetCurrentSheetId(),
//													g_->lZoom256);
//		m_vDsmHistory.push_back(auto_ptr<FCDsmRec>(pRec));
//		m_lCurrentDsmPosition++;
//	}
//	return FD_DRR_OK;
//----- 06.03.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (GetIsDocumentOpened())
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (FD_DSM_HISTORY_MAX < m_vDsmHistory.size())
		//----- DSM_xZkqqHx_jHjKjHpAiCmMiDfEiDeDiDfJiCkKiMmAjDhIiCpAiJhKiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNoNiPjMiClHiCoJiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
			const long lReduce = m_vDsmHistory.size() - FD_DSM_HISTORY_MIN;
			// _xZkqqHx_iMmDiCkC_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCkJiCoHiNoNiPjMiClHiCoJiBeC_xHqqkZx_
			m_vDsmHistory.erase(m_vDsmHistory.begin(), m_vDsmHistory.begin() + lReduce);
		}
		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		DWORDSet stObjId;
		g_pView->GetSelectObjectId(stObjId);
		// _xZkqqHx_jBeJjBpAjCiGiCmMiDgFiDeMiDfIiDgHjEmNiImNiCpAiOoGjDlOiBeC_xHqqkZx_
		DWORDVector vTextSelection;
		mdef_const_iterator(DWORDSet, iId);
		m1_for (iId, stObjId)
			ObjID2Object(*iId)->GetTextSelection(vTextSelection);
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
		DBLRect mmrtClient;
		g_pView->GetClientRectMM(mmrtClient);
		// _xZkqqHx_jAfGiClFiCkC_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
		FCDsmRec* pRec = new FCDsmRec(	g_pProject->GetFilePath(),
										GetDocumentId(),
										GetNextSessionIndex(),
										stObjId,
										vTextSelection,
										mmrtClient.CenterPoint(),
										GetCurrentSheetId(),
										g_->lZoom256,
										g_pProject->GetTitle(),
										g_pProject->GetDocumentRec(GetDocumentId()).GetDocTitle(),
										g_pProject->GetDocumentRec(GetDocumentId()).GetVersion());
		if (m_vDsmHistory.empty() ||
			*m_vDsmHistory.back().get() != *pRec)
		//----- _xZkqqHx_iNmFiMoDiCmJiLeMjIfOiClDiCoKiClN_xHqqkZx_DSM_xZkqqHx_iCmGiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
		{
			m_vDsmHistory.push_back(auto_ptr<FCDsmRec>(pRec));
			// DSM_xZkqqHx_iNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
			FFGetMainWnd()->PostMessage(WM_USER_DSM_UPDATED, WPARAM(TRUE), LPARAM(m_vDsmHistory.size() - 1));
		} else
		//----- _xZkqqHx_iNmFiMoDiCmJiLeMjIfOiClDiCoKiClN_xHqqkZx_DSM_xZkqqHx_iCmGjDkPiClGiPoKiNiH_xHqqkZx_ -----
		{
			delete pRec;
		}
	}
	return FD_DRR_OK;
//----- 06.03.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistViewDoc::OnReqPushCurrentToDsm.

//----- 06.01.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnReqSaveSpotFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_SAVE_SPOT_FILE]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjFnLjBlGiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMjClMiMoDiCmJiCmNiBeBjFeLiClI_xHqqkZx_ ID_DREQ_FLUSH_ALL _xZkqqHx_iCkKiMmEiCmOiCoKiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
// *			_xZkqqHx_iCmIiClKiCmIiCoHiBeBiDfIiDhMiDgCiDgHiNoMjAkMjClMiMoDiCmJ_xHqqkZx_ Undo _xZkqqHx_iCkKiCkAiCmBiClNiPoKiNiHiBeBjGkCiDhEiDiJiDgCiDfGiDiFiCmM_xHqqkZx_
// *			_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiNoNiPjMiClHiCoJiPiIjHjNiCkKjDpMiCmBiCmEiClFiCnMiCkCiBeBiDeHiDiJiBfLiCkKjEkNjAlG_xHqqkZx_
// *			_xZkqqHx_iClHiCoJiClNiCnPiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCHistViewDoc::OnReqSaveSpotFile (FCReqBase& ret, FCReqLock& reqLock)
//{
//#if 0
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_g_pFileServer->FlushAll _xZkqqHx_iCpAiOjNiCmCiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPiIjHjN_xHqqkZx_
//	// _xZkqqHx_iCmMjDkKjBfDiCmEiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiPoKiNiHiCmNiBeBjHjKjHpAjFlGiPjBiCmMiDhEiDiJiDgCiDfGiDiFiCpAiOmAiNhDiBeC_xHqqkZx_
//	if (OnReqCheckFlush()) return FD_DRR_RETRY;
//
//	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiChBiChGiDiNiDgCiDeOiBeC_xHqqkZx_
//	// HistDrawDoc_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDfIiDhMiDgCiDgHiCpAiDiNiDgCiDeOiClFiCmBiCmPiCmIiClFiCmIiCmMiCmFjFhDjHhGiCmIiCmMiClOiCkKiBeC_xHqqkZx_
//	FTDocReqResult result = OnReqCheckLock(	reqLock,
//											FCReqLock::PROJECT_READ |
//											FCReqLock::SPOT_READ |
//											FCReqLock::SPOT_WRITE);
//	if (result != FD_DRR_OK) return result;
//
////----- 05.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPeDjAlDiCmMiMkAiMmAiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//	FD_CHECK_QUALIFICATION(g_pProject);
////----- 05.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCmJiDfIiDhMiDgCiDgHiCkAiCoJiCkJiBeC_xHqqkZx_
//	if (m_spotFile.IsThereSpot(GetNextSessionIndex())) return FD_DRR_OK;
//
//	//----- _xZkqqHx_jGlDiCkCiPoKiNiH_xHqqkZx_ -----
//
//	//----- _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCmJiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiNoMjAkM_xHqqkZx_ -----
//	// _xZkqqHx_jAlDiOkOiCmIiDfIiDhMiDgCiDgHiCkJiBeI_xHqqkZx_
//	BOOL bIsOfficialSpot = TRUE;
//#if 0
//	if (!ret.IsNullIsTempSpot() && ret.GetIsTempSpot())
//		bIsOfficialSpot = FALSE;
//#endif//0
//	// _xZkqqHx_iPeJjDfPiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
//	WString wstrSpotFile;
//	wstrSpotFile = m_spotFile.GetSpotFilePath(GetNextSessionIndex());
//	// _xZkqqHx_iPeJjDfPiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
//	FCDbWriteLock writeLockSpot;
//	if (!FFExportSpotFile(this, wstrSpotFile, writeLockSpot))
//	//----- _xZkqqHx_iDeHiDeOiDfIiDhMiBfLiDgHiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		AfxDebugBreak();
//		return FD_DRR_FATAL_ERR;
//	}
//	//----- _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjGlMiCkJiCoHiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCmGiKgHjCkDiOhBiCpAiOoGiCoIiPjMiCkN_xHqqkZx_ -----
//	// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLjGlMiCpAiLeMjIfOiBeC_xHqqkZx_
//#if 0
//	m_spotFile.AppendSpot(	GetNextSessionIndex(),
//							bIsOfficialSpot,
//							GetCommandFilePtr(),
//							GetIndexFilePtr());
//#endif//0
//// 06.01.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	m_spotFile.UpdateFile(reqLock.m_autoLockSpotWrite);
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiImIiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
//	InsertDocRequest(1, ID_DREQ_FLUSH_ALL);
//#endif//0
//	return FD_DRR_OK;
//} // CFCHistViewDoc::OnReqSaveSpotFile.
//----- 06.01.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCHistViewDoc _xZkqqHx_jAgGjCgG_xHqqkZx_

#ifdef _DEBUG
void CFCHistViewDoc::AssertValid() const
{
	BASE_CLASS::AssertValid();
} // CFCHistViewDoc::AssertValid.

void CFCHistViewDoc::Dump(CDumpContext& dc) const
{
	BASE_CLASS::Dump(dc);
} // CFCHistViewDoc::Dump.
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFCHistViewDoc _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SetModifiedFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjAlDiDhEiDiJiDePiCmMjAnNjCoIiBeC_xHqqkZx_HistoryViewer_xZkqqHx_iCmFiCmNiBeBiPeDjAlDiDhEiDiJiDePiCpAjAnNjCoIiClFiCmEiCmN_xHqqkZx_
 *			_xZkqqHx_iCkCiCkPiCmIiCkCiClNiCnPiBeBiClBiCmMiKnGjAjEiCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bModified	:_xZkqqHx_iPeDjAlDiBeFjGkCiPeDjAlDiCmMjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::SetModifiedFlag (BOOL bModified)
{
} // CFCHistViewDoc::SetModifiedFlag.

/////////////////////////////////////////////////////////////////////////////
// CFCHistViewDoc _xZkqqHx_iDfGiDiKiDeBiDiJiDeDiDfJ_xHqqkZx_

/////////////////////////////////////////////////////////////////////////////
// CFCHistViewDoc _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::DeleteContents
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMiDgGiBfLiDfOiCpAiNoNiPjMiClFiBeBiNmEiCnBiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_ _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiOkJjAgHiCmNjEgKiKpMiClJiClIiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOiCpAiNoNiPjMiClHiCoJiClNiCnPiCmJiBeBiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkKiMmEiCnBiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmMiCfCiCmCiCmMiKnGjAjEiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iBeF_xHqqkZx_COleServerDoc::OnNewDocument
 *			_xZkqqHx_iBeF_xHqqkZx_COleServerDoc::OnOpenDocument
 *			_xZkqqHx_iBeF_xHqqkZx_CFrameWnd::OnClose
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjEgKiKpMiOjOiCmJiClBiCmMiKnGjAjEiCkKiMmEiCmOiCoKiCoJiOjOiCmNiBeBiKpJiCmJ_xHqqkZx_View_xZkqqHx_iCmNjEgKiKpM_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiCmEiCkCiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::DeleteContents ()
{
	// _xZkqqHx_jHjKjHpAjFlGiPjBjFnLiOjNiDhEiDiJiDePiCkKjAnNjCoIiClDiCoKiCmEiCkIiCoHiClIiBeB_xHqqkZx_
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmNjFmCiClGiCoJiBeC_xHqqkZx_
	if (GetIsDocumentOpened())
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiBeB_xHqqkZx_CFCHistDocumentTmpl::DeleteContents _xZkqqHx_iCnG_xHqqkZx_
		// _xZkqqHx_iInKjDkOiClFiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
		// DeleteContents _xZkqqHx_iCmNiBeB_xHqqkZx_XXXClass::DeleteContents() _xZkqqHx_iCmGiCkCiCkE_xHqqkZx_
		// _xZkqqHx_iMgAiCmFiBeBjClMjAnKiOmAiNhDiClDiCoKiCoJiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
		// _xZkqqHx_iCnMiClNiBeBiClBiCmMiDeOiDiJiDfIiCmM_xHqqkZx_ OnReqOpenHidocument_xZkqqHx_iKnGjAjEiCmFiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_
		// _xZkqqHx_iClNiCnPiBeBjDkPiClGiClBiCmMiDeOiDiJiDfIiCmFjFmCiClGiCoJiCnHiCkLiBeC_xHqqkZx_

//----- 06.03.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjFmPjAjEiCmJiDePiDiNiBfLiDgPiDiLiCpAjElNiJgGiBeC_xHqqkZx_
//		m_canvasStatLast.UpdateData();
//----- 06.03.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		//----- _xZkqqHx_jHjKjHpAjFlGiPjBjBkOjAkLiCpAiDeOiDiKiDeB_xHqqkZx_ -----

//----- 05.08.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDeJiDhFiDfHiDeGiDeOiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		ClearTimeLabel();
//----- 05.08.30 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//		m_fliEndSessionIndex = -1;
//----- 06.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		m_historyIndex.Clear();
		// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		m_pGate->Clear();
		// _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		m_cmdTerminateFile.Clear();
		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		m_spotFile.Clear();
		// _xZkqqHx_jFkKiKpCiDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		m_forkFile.Clear();
		// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		m_lDocId = -1L;
	}
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::DeleteContents();
} // CFCHistViewDoc::DeleteContents.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::SaveModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiCpAjFmCiClGiCoJiNnLiBeB_xHqqkZx_ModifiedFlag _xZkqqHx_iCmJiKnGiCoNiCoHiClIiBeBiClBiCmMiKnGjAjEiCkKiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCpAjBlBiCkPiCmEiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCpAjFmCiClGiCmEiCoGiCkCiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iImIiKePiCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCpAjFmCiClGiCmEiCmNiCkCiCkPiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmMiDeDiDjDiDhGiDiKiDiBiDjDiDgHiCmFiCmNiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiCmGiBeB_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMjFmPiNfIiCpAjFnLjBlGiClHiCoJiCkJiCmHiCkEiCkJiCpAjGoCiCkCiNiHiCoNiClJiCoJiDiBiDgCiDfKiBfLiDfH_xHqqkZx_
 *			_xZkqqHx_iDhLiDgCiDeOiDfIiCpAjFfMiOkGiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCHistViewDoc::SaveModified ()
{
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiMiLiJmKiCkKiDeHiDiJiBfLiCmMiPoKiNiHiCmNjBkGiOjOiPeJjHlJiBeC_xHqqkZx_
	if (GetDocRequestResult() == FD_DRR_FATAL_ERR) return TRUE;

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
	// ID_DREQ_SAVE_AND_EXIT _xZkqqHx_iCmMiMiLiJmKiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmNjFmCiClGiCmEiCkJiCoH_xHqqkZx_
	// _xZkqqHx_iClBiClBiCmJjHiIiCoJiCmNiClIiBeC_xHqqkZx_
	if (!g_pProject->IsProjectOpened())
		return TRUE;

	if (!IsThereDocRequest(ID_DREQ_APP_EXIT))
	//----- ID_DREQ_APP_EXIT _xZkqqHx_iCkKiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmJiKnMiCnMiCoKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCpAiPeJjHlJiBeC_xHqqkZx_
		PushBackDocRequest(ID_DREQ_APP_EXIT);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		ProceedDocRequest();
	}
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmNjFmCiClGiCmIiCkCiBeC_xHqqkZx_
	return FALSE;

	// Superclass_xZkqqHx_iKnGjAjEiCmNiOmAiNhDiClFiCmIiCkCiBeCiOmAiNhDiClFiCmEiClFiCnMiCkEiCmGiBeBjCmKiPoNiCmMjFnLjBlGiPiIjHjNiCkK_xHqqkZx_
	// _xZkqqHx_iNhDiCoNiCoKiCmEiClFiCnMiCkEiClNiCnPiBeC_xHqqkZx_
	// return BASE_CLASS::SaveModified();
} // CFCHistViewDoc::SaveModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnFileExecHistdrawTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFlGiPjBiCpA_xHqqkZx_Historic Draw_xZkqqHx_iCmFiKeKiCkNiBhGiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnFileExecHistdrawTarget ()
{
//----- 05.09.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iLeOjDkOiDhAiDiJiDiBiBfLiDfOiCmMjFlGiOjKjHpBiCpAiNoMiCoJiBeC_xHqqkZx_
//	WString strParam = L"-histdraw";
//	if (g_pProject->IsProjectOpened())
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDhAiDiJiDiBiBfLiDfOiNoMjAkMiBeCiDhEiDeAiDeDiDiLjGlMiCmN_xHqqkZx_""_xZkqqHx_iCmFiImNiCnOiBeCiDfIiDhJiBfLiDfIjDpMiCoIiDhEiDeAiDeDiDiLjGlMiCmJjBmOiJjOiBeC_xHqqkZx_
//		// strParam_xZkqqHx_iCmMiDiBiDjDiDgPiKnGjAjEiCmJ_xHqqkZx_strParam_xZkqqHx_iCpAiOgHiCkEiClNiCnPiBeB_xHqqkZx_WString_xZkqqHx_iCmFiDeMiDiDiDfIiDgHiCkKjFeLjHhGiBeC_xHqqkZx_
//		strParam.Format(L"%s -hpf:\"%s\"", WString(strParam).c_str(), g_pProject->GetFilePath());
//		if (GetIsDocumentOpened())
//		//----- _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhAiDiJiDiBiBfLiDfOiNoMjAkMiBeCiDhEiDeAiDeDiDiLjGlMiCmN_xHqqkZx_""_xZkqqHx_iCmFiImNiCnOiBeCiDfIiDhJiBfLiDfIjDpMiCoIiDhEiDeAiDeDiDiLjGlMiCmJjBmOiJjOiBeC_xHqqkZx_
//			// strParam_xZkqqHx_iCmMiDiBiDjDiDgPiKnGjAjEiCmJ_xHqqkZx_strParam_xZkqqHx_iCpAiOgHiCkEiClNiCnPiBeB_xHqqkZx_WString_xZkqqHx_iCmFiDeMiDiDiDfIiDgHiCkKjFeLjHhGiBeC_xHqqkZx_
//			strParam.Format(L"%s -did:\"%ld\"", WString(strParam).c_str(), m_lDocId);
//		}
//	}
//	// _xZkqqHx_iDhBiDfIiDgHiDiKiDgCiDeOiDhCiDiFiDeBiCpAiLeOjDkOiBeC_xHqqkZx_
//	(void)::ExecMolipDraw(strParam);
//----- 05.09.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (g_pProject->IsProjectOpened())
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDkPiClGjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCmMiDeFiDeCiDjDiDgIiDeFiCpAjCfEiClHiBeC_xHqqkZx_
		HWND hwndTarget = FFFindHidocumentWindow(	g_pProject->GetFilePath(),
													GetIsDocumentOpened() ? GetDocumentId() : -1,
													NULL,
													GetSpecAppName(FD_APPMODE_HISTORICDRAW));
		if (hwndTarget != NULL)
		//----- _xZkqqHx_iKpJiCmJjDkPiClGjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_Historic Draw_xZkqqHx_iCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiDeBiDhGiDiKiCpAiDhEiDeIiDeBiDePiDiJiDjDiDgIiCmJiBeC_xHqqkZx_
			::SetForegroundWindow(hwndTarget);
		} else
		//----- _xZkqqHx_jDkPiClGjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_Historic Draw_xZkqqHx_iCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			if (GetIsDocumentOpened())
			//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// [Historic Draw_xZkqqHx_iCpAiLeOjDkOiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
				PushBackDocRequest(	ID_DREQ_EXEC_HISTDRAW,
									FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
									FCReqBase::HIDOCUMENT_ID, GetDocumentId(),
									FCReqBase::NONE);
			} else
			//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// [Historic Draw_xZkqqHx_iCpAiLeOjDkOiClHiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
				PushBackDocRequest(	ID_DREQ_EXEC_HISTDRAW,
									FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
									FCReqBase::NONE);
			}
			// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
			PushBackDocRequest(ID_DREQ_END);
			// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
			ProceedDocRequest();
		}
	}
//----- 05.09.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCHistViewDoc::OnFileExecHistdrawTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateFileExecHistdrawTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFlGiPjBiCpA_xHqqkZx_Historic Draw_xZkqqHx_iCmFiKeKiCkNiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEjAnNjCoIjHhAiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateFileExecHistdrawTarget (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && g_pProject->IsProjectOpened());
} // CFCHistViewDoc::OnUpdateFileExecHistdrawTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnHtreeMoveAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiJlKjFpLiCnGiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnHtreeMoveAfter ()
{
	if (GetIsUseTimeIndex())
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiBeBiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
		if (SyncTimeIndexToCurrent())
		//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCkKiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoHiCoKiClNiPoKiNiH_xHqqkZx_ -----
		{
//----- 06.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//			flint fliIndex = m_pFileTimeIndex->GetCurrentIndex();
//			fliIndex++;
//			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIjGjGjEpGiCmMiPoKiNiHiCmNiJlNiCoAiClJiClIjFjMiLeBiBeC_xHqqkZx_
//			if (fliIndex == m_pFileTimeIndex->GetCount()) return;
//			// _xZkqqHx_iIoKiCmCjBePiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmJiInKjDkOiBeC_xHqqkZx_
//			m_pFileTimeIndex->SetCurrentIndex(fliIndex);
//----- 06.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiBhLiCfAiInKjDkOiBeC_xHqqkZx_
			if (!SeekTimeIndexSession(1))
				return;
		} else
		//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCkKiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoHiCoKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmMjAoGjDkKiCmJiInKjDkOiBeC_xHqqkZx_
			m_pFileTimeIndex->SetCurrentIndex(0);
		}
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHiBeBiOjOiKnEiBeFjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeFiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FDSECTIME fdstSessionTime;
		long lDocumentId;
		flint fliSessionIndex;
		m_pFileTimeIndex->See(&fdstSessionTime, &lDocumentId, &fliSessionIndex);
		// _xZkqqHx_iOhHjCoIiCmMjHjKjHpAjFlGiPjBiBeFiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
		PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_UNTIL_PJ_HIDOC_SESSION,
							FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
							FCReqBase::HIDOCUMENT_ID, lDocumentId,
							FCReqBase::SESSION_INDEX, fliSessionIndex,
							FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
							FCReqBase::IS_SELECT_OBJECT, FALSE,
							FCReqBase::NONE);
	} else
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIjAjEiDfKiDgCiDfGiDiHiDjDiInKjDkOiClHiCoJiBeC_xHqqkZx_
		PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_SESSION_COUNT,
							FCReqBase::SESSION_COUNT, 1i64,
							FCReqBase::NONE);
	}
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	ProceedDocRequest();
} // CFCHistViewDoc::OnHtreeMoveAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateHtreeMoveAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiJlKjFpLiCnGiInKjDkOiBhGiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateHtreeMoveAfter (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(CanHtreeMoveAfter());
} // CFCHistViewDoc::OnUpdateHtreeMoveAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnHtreeMoveBefore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiPoDjFpLiCnGiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnHtreeMoveBefore ()
{
	ASSERT(FFCanBasicOperate());
	if (GetIsUseTimeIndex())
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiBeBiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
		if (SyncTimeIndexToCurrent())
		//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCkKiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoHiCoKiClNiPoKiNiH_xHqqkZx_ -----
		{
//----- 06.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//			flint fliIndex = m_pFileTimeIndex->GetCurrentIndex();
//			fliIndex--;
//			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIjAoGjDkKiCmMiPoKiNiHiCmNiJlNiCoAiClJiClIjFjMiLeBiBeC_xHqqkZx_
//			if (fliIndex == -1) return;
//			// _xZkqqHx_iIoKiCmCjBePiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmJiInKjDkOiBeC_xHqqkZx_
//			m_pFileTimeIndex->SetCurrentIndex(fliIndex);
//----- 06.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiBhMiCfAiInKjDkOiBeC_xHqqkZx_
			if (!SeekTimeIndexSession(-1))
				return;
		} else
		//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCkKiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoHiCoKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmMjGjGjEpGiCmJiInKjDkOiBeC_xHqqkZx_
			m_pFileTimeIndex->SetCurrentIndex(m_pFileTimeIndex->GetCount() - 1);
		}
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHiBeBiOjOiKnEiBeFjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeFiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FDSECTIME fdstSessionTime;
		long lDocumentId;
		flint fliSessionIndex;
		m_pFileTimeIndex->See(&fdstSessionTime, &lDocumentId, &fliSessionIndex);
		// _xZkqqHx_iOhHjCoIiCmMjHjKjHpAjFlGiPjBiBeFiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
		PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_UNTIL_PJ_HIDOC_SESSION,
							FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
							FCReqBase::HIDOCUMENT_ID, lDocumentId,
							FCReqBase::SESSION_INDEX, fliSessionIndex,
							FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
							FCReqBase::IS_SELECT_OBJECT, FALSE,
							FCReqBase::NONE);
	} else
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIjAjEiDfKiDgCiDfGiDiHiDjDiInKjDkOiClHiCoJiBeC_xHqqkZx_
		PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_SESSION_COUNT,
							FCReqBase::SESSION_COUNT, -1i64,
							FCReqBase::NONE);
	}
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	ProceedDocRequest();
} // CFCHistViewDoc::OnHtreeMoveBefore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateHtreeMoveBefore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiPoDjFpLiCnGiInKjDkOiBhGiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateHtreeMoveBefore (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(CanHtreeMoveBefore());
} // CFCHistViewDoc::OnUpdateHtreeMoveBefore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnHtreeMoveOperationBefore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjHjKjHpAiCpAjBiAiNoMjCfAiImKiCmFiPoDjFpLiCnGiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnHtreeMoveOperationBefore ()
{
	ASSERT(FFCanBasicOperate());
	// _xZkqqHx_iOhHjCoIiClDiCoKiCmEiCkCiCoJjBiAiNoMiCpAiOoGjDlOiBeC_xHqqkZx_
	long lOpeValue;
	const long lOperation = FFGetHiMainWnd()->GetHiMoveOperation(lOpeValue);
	if (GetIsUseTimeIndex())
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiBeBiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
		if (SyncTimeIndexToCurrent())
		//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCkKiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoHiCoKiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iInKjDkOjCfAiImKiClCiCmGiCmJiInKjDkOiPiIjHjNiBeC_xHqqkZx_
			switch (lOperation)
			{
			case FD_HTREE_MOVE_OPERATION_EACH:	// _xZkqqHx_jBiAiNoMjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
				// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
				if (!SeekTimeIndexSession(-lOpeValue))
					return;
				break;
			case FD_HTREE_MOVE_LTT_EACH:		// _xZkqqHx_jClHiNgMjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
				// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
				if (!SeekTimeIndexIntervalBefore(FDSECTIME(lOpeValue)))
					return;
				break;
			case FD_HTREE_MOVE_TIME_EACH:		// _xZkqqHx_iOjOiKnEjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
				// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
				if (!SeekTimeIndexPassedBefore(FDSECTIME(lOpeValue)))
					return;
				break;
			}
		} else
		//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCkKiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoHiCoKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmMjGjGjEpGiCmJiInKjDkOiBeC_xHqqkZx_
			m_pFileTimeIndex->SetCurrentIndex(m_pFileTimeIndex->GetCount() - 1);
		}
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHiBeBiOjOiKnEiBeFjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeFiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FDSECTIME fdstSessionTime;
		long lDocumentId;
		flint fliSessionIndex;
		m_pFileTimeIndex->See(&fdstSessionTime, &lDocumentId, &fliSessionIndex);
		// _xZkqqHx_iOhHjCoIiCmMjHjKjHpAjFlGiPjBiBeFiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
		PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_UNTIL_PJ_HIDOC_SESSION,
							FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
							FCReqBase::HIDOCUMENT_ID, lDocumentId,
							FCReqBase::SESSION_INDEX, fliSessionIndex,
							FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
							FCReqBase::IS_SELECT_OBJECT, FALSE,
							FCReqBase::NONE);
	} else
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_iInKjDkOjCfAiImKiClCiCmGiCmJiInKjDkOiPiIjHjNiBeC_xHqqkZx_
		switch (lOperation)
		{
		case FD_HTREE_MOVE_OPERATION_EACH:	// _xZkqqHx_jBiAiNoMjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
			// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIjAjEiDfKiDgCiDfGiDiHiDjDiInKjDkOiClHiCoJiBeC_xHqqkZx_
			PushBackDocRequest(ID_DREQ_MOVE_HISTORY_SESSION_COUNT,
								FCReqBase::SESSION_COUNT, flint(-lOpeValue),
								FCReqBase::NONE);
			break;
		case FD_HTREE_MOVE_LTT_EACH:	// _xZkqqHx_jClHiNgMjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
			// _xZkqqHx_jHjKjHpAiCpAiDeDiDjDiDfOiBfLiDgPiDiLiCnMiCmFjGnPiClHiBeC_xHqqkZx_
			PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_BACKWARD_UNTIL_INTERVAL,
								FCReqBase::TIME_DIFFERENCE, FDSECTIME(lOpeValue),
								FCReqBase::NONE);
			break;
		case FD_HTREE_MOVE_TIME_EACH:	// _xZkqqHx_iOjOiKnEjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
			// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiOjOiKnEiCkKiMgPiJnPiClHiCoJiCnMiCmFjGnPiClHiBeC_xHqqkZx_
			PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_BACKWARD_TIME_PASSED,
								FCReqBase::TIME_DIFFERENCE, FDSECTIME(lOpeValue),
								FCReqBase::NONE);
			break;
		}
	}
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	ProceedDocRequest();
} // CFCHistViewDoc::OnHtreeMoveOperationBefore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateHtreeMoveOperationBefore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjHjKjHpAiCpAjBiAiNoMjCfAiImKiCmFiPoDjFpLiCnGiInKjDkOiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDfCiDhNiDjDiDgIiCmMjHeMiMpIjAkLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateHtreeMoveOperationBefore (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(CanHtreeMoveBefore());
} // CFCHistViewDoc::OnUpdateHtreeMoveOperationBefore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnHtreeMoveOperationAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjHjKjHpAiCpAjBiAiNoMjCfAiImKiCmFiJlKjFpLiCnGiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnHtreeMoveOperationAfter ()
{
	// _xZkqqHx_iOhHjCoIiClDiCoKiCmEiCkCiCoJjBiAiNoMiCpAiOoGjDlOiBeC_xHqqkZx_
	long lOpeValue;
	const long lOperation = FFGetHiMainWnd()->GetHiMoveOperation(lOpeValue);
	if (GetIsUseTimeIndex())
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiBeBiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
		if (SyncTimeIndexToCurrent())
		//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCkKiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoHiCoKiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iInKjDkOjCfAiImKiClCiCmGiCmJiInKjDkOiPiIjHjNiBeC_xHqqkZx_
			switch (lOperation)
			{
			case FD_HTREE_MOVE_OPERATION_EACH:	// _xZkqqHx_jBiAiNoMjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
				// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
				if (!SeekTimeIndexSession(lOpeValue))
					return;
				break;
			case FD_HTREE_MOVE_LTT_EACH:		// _xZkqqHx_jClHiNgMjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
				// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
				if (!SeekTimeIndexIntervalAfter(FDSECTIME(lOpeValue)))
					return;
				break;
			case FD_HTREE_MOVE_TIME_EACH:		// _xZkqqHx_iOjOiKnEjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
				// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMlLiNnNiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
				if (!SeekTimeIndexPassedAfter(FDSECTIME(lOpeValue)))
					return;
				break;
			}
		} else
		//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCkKiMlLiNnNiCmMiImKjChFiCmJiNiHiCoNiClJiCoHiCoKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmMjAoGjDkKiCmJiInKjDkOiBeC_xHqqkZx_
			m_pFileTimeIndex->SetCurrentIndex(0);
		}
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHiBeBiOjOiKnEiBeFjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeFiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FDSECTIME fdstSessionTime;
		long lDocumentId;
		flint fliSessionIndex;
		m_pFileTimeIndex->See(&fdstSessionTime, &lDocumentId, &fliSessionIndex);
		// _xZkqqHx_iOhHjCoIiCmMjHjKjHpAjFlGiPjBiBeFiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
		PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_UNTIL_PJ_HIDOC_SESSION,
							FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
							FCReqBase::HIDOCUMENT_ID, lDocumentId,
							FCReqBase::SESSION_INDEX, fliSessionIndex,
							FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_IF_OUT,
							FCReqBase::IS_SELECT_OBJECT, FALSE,
							FCReqBase::NONE);
	} else
	//----- _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_iInKjDkOjCfAiImKiClCiCmGiCmJiInKjDkOiPiIjHjNiBeC_xHqqkZx_
		switch (lOperation)
		{
		case FD_HTREE_MOVE_OPERATION_EACH:	// _xZkqqHx_jBiAiNoMjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
			// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIjAjEiDfKiDgCiDfGiDiHiDjDiInKjDkOiClHiCoJiBeC_xHqqkZx_
			PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_SESSION_COUNT,
								FCReqBase::SESSION_COUNT, flint(lOpeValue),
								FCReqBase::NONE);
			break;
		case FD_HTREE_MOVE_LTT_EACH:	// _xZkqqHx_jClHiNgMjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
			// _xZkqqHx_jHjKjHpAiCpAiDeDiDjDiDfOiBfLiDgPiDiLiCnMiCmFjAgJiCnPiCoJiBeC_xHqqkZx_
			PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_FORWARD_UNTIL_INTERVAL,
								FCReqBase::TIME_DIFFERENCE, FDSECTIME(lOpeValue),
								FCReqBase::NONE);
			break;
		case FD_HTREE_MOVE_TIME_EACH:	// _xZkqqHx_iOjOiKnEjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
			// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiCmMiOjOiKnEiCkKiMgPiJnPiClHiCoJiCnMiCmFjAgJiCnPiCoJiBeC_xHqqkZx_
			PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_FORWARD_TIME_PASSED,
								FCReqBase::TIME_DIFFERENCE, FDSECTIME(lOpeValue),
								FCReqBase::NONE);
			break;
		}
	}
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	ProceedDocRequest();
} // CFCHistViewDoc::OnHtreeMoveOperationAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateHtreeMoveOperationAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjHjKjHpAiCpAjBiAiNoMjCfAiImKiCmFiJlKjFpLiCnGiInKjDkOiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDfCiDhNiDjDiDgIiCmMjHeMiMpIjAkLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateHtreeMoveOperationAfter (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(CanHtreeMoveAfter());
} // CFCHistViewDoc::OnUpdateHtreeMoveOperationAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnHtreeMoveSelectionBefore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjBeJjBpAjFjEjFgJiCkKjBiAiNoMiClDiCoKiClNiJnPiLiOiCnGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnHtreeMoveSelectionBefore ()
{
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiKnMiCnPiCmEjBfDiCmEiCmMjFjEjFgJiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	ObjDynabaseVector vAllObj;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = g_pView->SelectObjVector().begin();
		 iObj != g_pView->SelectObjVector().end(); iObj++)
		(*iObj)->GetKindOfMembers(vAllObj, FDOJ_OBJECT);
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	DWORDSet stObjId;
	for (iObj = vAllObj.begin(); iObj != vAllObj.end(); iObj++)
		stObjId.insert((*iObj)->GetObjID());

	// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiDeJiDhFiDfHiDeGiDeOiDgHiCmMjBiAiNoMiCnMiCmFjGnPiClHiBeC_xHqqkZx_
	PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_BACKWARD_UNTIL_OPERATE,
						FCReqBase::OBJECT_ID_SET, &stObjId,
						FCReqBase::NONE);
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	ProceedDocRequest();
} // CFCHistViewDoc::OnHtreeMoveSelectionBefore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateHtreeMoveSelectionBefore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjBeJjBpAjFjEjFgJiCkKjBiAiNoMiClDiCoKiClNiJnPiLiOiCnGiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateHtreeMoveSelectionBefore (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && !g_pView->SelectObjVector().empty());
} // CFCHistViewDoc::OnUpdateHtreeMoveSelectionBefore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnHtreeMoveSelectionAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjBeJjBpAjFjEjFgJiCkKjBiAiNoMiClDiCoKiClNjGkCjHiIiCnGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnHtreeMoveSelectionAfter ()
{
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiKnMiCnPiCmEjBfDiCmEiCmMjFjEjFgJiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	ObjDynabaseVector vAllObj;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = g_pView->SelectObjVector().begin();
		 iObj != g_pView->SelectObjVector().end(); iObj++)
		(*iObj)->GetKindOfMembers(vAllObj, FDOJ_OBJECT);
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	DWORDSet stObjId;
	for (iObj = vAllObj.begin(); iObj != vAllObj.end(); iObj++)
		stObjId.insert((*iObj)->GetObjID());

	// _xZkqqHx_jHjKjHpAiCpAiOhHjCoIiDeJiDhFiDfHiDeGiDeOiDgHiCmMjBiAiNoMiCnMiCmFjAgJiCnPiCoJiBeC_xHqqkZx_
	PushBackDocRequest(	ID_DREQ_MOVE_HISTORY_FORWARD_UNTIL_OPERATE,
						FCReqBase::OBJECT_ID_SET, &stObjId,
						FCReqBase::NONE);
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	ProceedDocRequest();
} // CFCHistViewDoc::OnHtreeMoveSelectionAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateHtreeMoveSelectionAfter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFjBeJjBpAjFjEjFgJiCkKjBiAiNoMiClDiCoKiClNjGkCjHiIiCnGiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateHtreeMoveSelectionAfter (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && !g_pView->SelectObjVector().empty());
} // CFCHistViewDoc::OnUpdateHtreeMoveSelectionAfter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnOptionUserRegistration
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDiGiBfLiDfFjDgPjIfOiPoOjFpBiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnOptionUserRegistration ()
{
	const GUID guidOld = FFGetApp()->GetUserId();
	// _xZkqqHx_iDiGiBfLiDfFjDgPjIfOiDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_
	CFCDlgInitUserRegistration dlg;
	dlg.DoModal();
	// "_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjDgPjIfOiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_\r\n_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmNjHjIjHhAiCmFiCkLiCnMiClJiCpBiBeC_xHqqkZx_"
	if (g_pReg->GetUserId() == GUID_NULL)
		FFErrorBox(IDS_ERR_MSG_USER_ID_NOT_REGISTERED);
//----- 05.11.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pProject->IsProjectOpened() &&
		guidOld != FFGetApp()->GetUserId())
	//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmJjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiBiDjDiDgPiBfLiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_]
		PushBackDocRequest(ID_DREQ_CHECK_IS_MEMBER_OF_PROJECT_USER);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		ProceedDocRequest();
	}
//----- 05.11.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCHistViewDoc::OnOptionUserRegistration.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateOptionUserRegistration
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDiGiBfLiDfFjDgPjIfOiPoOjFpBiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateOptionUserRegistration (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate());
} // CFCHistViewDoc::OnUpdateOptionUserRegistration.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnHtreeMoveHigher
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiPoDiImKiCnGiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnHtreeMoveHigher ()
{
//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_PUSH_CURRENT_TO_DSM);
//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPoDiImKiCnGiInKjDkOiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_MOVE_HISTORY_TO_HIGHER_TREE);
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	ProceedDocRequest();
} // CFCHistViewDoc::OnHtreeMoveHigher.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateHtreeMoveHigher
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiPoDiImKiCnGiInKjDkOiBhGiCmMiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateHtreeMoveHigher (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(CanHtreeMoveHigher());
} // CFCHistViewDoc::OnUpdateHtreeMoveHigher.

//----- 05.08.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnOptionSyncOtherDoc
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFmKjFlGiPjBiCmGjDkPiKpKiBhGiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::OnOptionSyncOtherDoc ()
//{
//	g_pReg->SetIsSyncOtherDoc(!g_pReg->GetIsSyncOtherDoc());
//} // CFCHistViewDoc::OnOptionSyncOtherDoc.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateOptionSyncOtherDoc
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFmKjFlGiPjBiCmGjDkPiKpKiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::OnUpdateOptionSyncOtherDoc (CCmdUI* pCmdUI)
//{
//	pCmdUI->Enable(FFCanBasicOperate() && GetIsDocumentOpened());
//	pCmdUI->SetCheck(g_pReg->GetIsSyncOtherDoc());
//} // CFCHistViewDoc::OnUpdateOptionSyncOtherDoc.
//----- 05.08.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnHtreeMoveLower
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiJlKiImKiCnGiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmIiPoKiNiHiCmNiBeB_xHqqkZx_A0_xZkqqHx_iCkJiCoH_xHqqkZx_A3_xZkqqHx_iCpAiDfEiDeDiDeOiDiLiClHiCoJiBeC_xHqqkZx_
 *
 *         _xZkqqHx_iEkBiBkI_xHqqkZx_ A0 _xZkqqHx_iBkI_xHqqkZx_ A1 _xZkqqHx_iBkI_xHqqkZx_ A2 _xZkqqHx_iBkI_xHqqkZx_ A3 _xZkqqHx_iEjPiEkC_xHqqkZx_
 *         _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          A0_xZkqqHx_iEkKiEkK_xHqqkZx_A1_xZkqqHx_iEkKiEkK_xHqqkZx_A2_xZkqqHx_iEkKiEkK_xHqqkZx_A3
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iBeG_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnHtreeMoveLower ()
{
//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 05.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_PUSH_CURRENT_TO_DSM);
////----- 05.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iJlKiImKiCnGiInKjDkOiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_MOVE_HISTORY_TO_LOWER_TREE);
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
//----- 05.11.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_PUSH_CURRENT_TO_DSM);
//----- 05.11.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	ProceedDocRequest();
} // CFCHistViewDoc::OnHtreeMoveLower.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateHtreeMoveLower
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiJlKiImKiCnGiInKjDkOiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmIiPoKiNiHiCmNiBeB_xHqqkZx_A0_xZkqqHx_iCkJiCoH_xHqqkZx_A3_xZkqqHx_iCpAiDfEiDeDiDeOiDiLiClHiCoJiBeC_xHqqkZx_
 *
 *         _xZkqqHx_iEkBiBkI_xHqqkZx_ A0 _xZkqqHx_iBkI_xHqqkZx_ A1 _xZkqqHx_iBkI_xHqqkZx_ A2 _xZkqqHx_iBkI_xHqqkZx_ A3 _xZkqqHx_iEjPiEkC_xHqqkZx_
 *         _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          A0_xZkqqHx_iEkKiEkK_xHqqkZx_A1_xZkqqHx_iEkKiEkK_xHqqkZx_A2_xZkqqHx_iEkKiEkK_xHqqkZx_A3
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iBeG_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateHtreeMoveLower (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(CanHtreeMoveLower());
} // CFCHistViewDoc::OnUpdateHtreeMoveLower.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnFileDeleteHistory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAjFlGiPjBiCpAiNoNiPjMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnFileDeleteHistory ()
{
	// "_xZkqqHx_iClBiCmMiPiIjHjNiCmNiMlDiCmJjGnPiClHiClBiCmGiCmNiCmFiCkLiCnMiClJiCpBiBeCiOmAiNhDiClFiCnMiClHiCkJiBeI_xHqqkZx_"
	if (FFMessageBox(IDS_MSG_NOT_UNDO_PROCESS_IS_CONTINUE, 0, MB_YESNO) == IDYES)
	{
		// _xZkqqHx_jHjKjHpAjFlGiPjBiNoNiPjMiCmMiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
		PushBackDocRequest(	ID_DREQ_DLG_DELETE_HIDOCUMENT,
							FCReqBase::PROJECT_PATH, g_pProject->GetFilePath().c_str(),
							FCReqBase::HIDOCUMENT_ID, GetDocumentId(),
							FCReqBase::NONE);
		// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
		PushBackDocRequest(	ID_DREQ_IF,
							FCReqBase::RETURN, IDYES,
							FCReqBase::NONE);

			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiNoNiPjMiClHiCoJiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
			PushBackDocRequest(ID_DREQ_DELETE_HIDOCUMENT);
			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
			PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);

		// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
		PushBackDocRequest(ID_DREQ_END_IF);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		ProceedDocRequest();
	}
} // CFCHistViewDoc::OnFileDeleteHistory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateFileDeleteHistory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAjFlGiPjBiCpAiNoNiPjMiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateFileDeleteHistory (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && GetIsDocumentOpened());
} // CFCHistViewDoc::OnUpdateFileDeleteHistory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnFileProjectClose
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDhGiDiNiDfHiDeGiDeOiDgHiCpAjFmCiClGiCoJiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmNiBeBjFmCiClGiCoJiBeCiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiBeB_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnFileProjectClose ()
{
	// [_xZkqqHx_jHjKjHpAjFlGiPjBiBeFiDhGiDiNiDfHiDeGiDeOiDgHiCpAjFmCiClGiCoJ_xHqqkZx_]_xZkqqHx_jHhGiLiBiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_CLOSE_HIDOCUMENT_AND_PROJECT);
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	ProceedDocRequest();
} // CFCHistViewDoc::OnFileProjectClose.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateFileProjectClose
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDhGiDiNiDfHiDeGiDeOiDgHiCpAjFmCiClGiCoJiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEjAnNjCoIjHhAiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateFileProjectClose (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && g_pProject->IsProjectOpened());
} // CFCHistViewDoc::OnUpdateFileProjectClose.

//----- 06.02.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnViewCopyPosition
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiImKjChFiCpAiDfCiDhDiBfLiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiClDiCoKiCoJjFlGiPjBiImKjChFiPoOjFpBiCmNiImIiJlKiCmMiMgAiOkOiBeC_xHqqkZx_
// *		<mdrwpos file="C:\foo\bar\file.mdrw" sheet="0" cposx="78" cposy="114"/>
// *			                  _xZkqqHx_iBkK_xHqqkZx_                   _xZkqqHx_iBkK_xHqqkZx_         _xZkqqHx_iBkK_xHqqkZx_          _xZkqqHx_iBkK_xHqqkZx_
// *			            _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLjGlM_xHqqkZx_           SheetID      mmX        mmY
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::OnViewCopyPosition ()
//{
////----- 02.01.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////// 02.01.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//////	const DWORD dwCurPtr = GetHistoryPosition();
////	const flint fliCurPtr = GetHistoryPosition();
////	DBLRect mmrt;
////	g_pView->GetClientRectMM(mmrt);
////	DBLPoint mmpt = mmrt.CenterPoint();
////	WString strMMX;
////	strMMX.Format(_T("%f"), mmpt.x);
////	// _xZkqqHx_iPkMjAjEjDfPiImIiJlKiCmMiCePiCpAiNoNiPjMiBeC_xHqqkZx_
////	strMMX.TrimRight(_T('0'));
////	strMMX.TrimRight(_T('.'));
////	WString strMMY;
////	strMMY.Format(_T("%f"), mmpt.y);
////	// _xZkqqHx_iPkMjAjEjDfPiImIiJlKiCmMiCePiCpAiNoNiPjMiBeC_xHqqkZx_
////	strMMY.TrimRight(_T('0'));
////	strMMX.TrimRight(_T('.'));
////	WString strPos;
////	strPos.Format(_T("/%s/%ld/%ld/%s/%s/"),
////					g_pProject->GetFilePath(), GetDocumentId(), fliCurPtr, strMMX, strMMY);
////	CEdit edit;
////	edit.Create(0, CRect(0,0,10,10), AfxGetMainWnd(), 100);
////	edit.SetWindowText(strPos);
////	edit.SetSel(0, -1);	// _xZkqqHx_jBfDjFjEjBeJjBpAiBeC_xHqqkZx_
////	edit.Copy();
////----- 02.01.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//#ifndef _DEBUG
//	_xZkqqHx_iClBiCoKiCpAiCmIiCpBiCmGiCkJiClJiCmLiCmOiBeC_xHqqkZx_
//#endif//_DEBUG
//} // CFCHistViewDoc::OnViewCopyPosition.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateViewCopyPosition
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjHjKjHpAiImKjChFiCpAiDfCiDhDiBfLiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::OnUpdateViewCopyPosition (CCmdUI* pCmdUI)
//{
//	pCmdUI->Enable(FFCanBasicOperate() && GetIsDocumentOpened());
//} // CFCHistViewDoc::OnUpdateViewCopyPosition.
//----- 06.02.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnViewPastePosition
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDfCiDhDiBfLiClDiCoKiClNjHjKjHpAiImKjChFiCmJiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfIiDgHiClDiCoKiCoJjHjKjHpAjFlGiPjBiImKjChFiPoOjFpBiCmNiImIiJlKiCmMiMgAiOkOiBeC_xHqqkZx_
// *			/H:\src\FastDraw\Untitled4\Untitled4.mdpj/11/293/84.4/87.4/
// *			                  _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_   _xZkqqHx_iBkK_xHqqkZx_
// *			        _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlM_xHqqkZx_          DocID _xZkqqHx_iBgC_xHqqkZx_  mmX  _xZkqqHx_iBgC_xHqqkZx_
// *			                                             HiPtr     mmY
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::OnViewPastePosition ()
//{
////----- 02.01.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	WString	strFile;
////	long	lDocId = -1L;
////// 02.01.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//////	DWORD	dwHiPtr = DWORD(-1);
////	flint	fliHiPtr = flint(-1);
////	mmetol	mmX = 50.0;
////	mmetol	mmY = 50.0;
////
////	//----- _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCkJiCoHjHjKjHpAjFlGiPjBiImKjChFiPoOjFpBiCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
////	WString strPos;
////	CEdit edit;
////	edit.Create(WS_CHILD|ES_AUTOHSCROLL, CRect(0,0,10,10), AfxGetMainWnd(), 100);
////	edit.SetSel(0, 0);
////	edit.Paste();
////	edit.GetWindowText(strPos);
////	// _xZkqqHx_iDfKiDhAiDiMiBfLiDfOiLeMiNiGiCpAiOoGiCoIiPgPiClHiBeCiNmFiPiJiCmMiCfAjFlGiOjKiCkKiDfKiDhAiDiMiBfLiDfOiLeMiNiGiBeCjCmKiPoNiCmN_xHqqkZx_'/'
////	const _TCHAR tcSpace = strPos[0];
////	strPos = strPos.Mid(1);
////
////	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
////	int iPos = strPos.Find(tcSpace);
////	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCkKjGlDiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
////	if (iPos <= 0) return;
////	strFile = strPos.Left(iPos);
////	strPos = strPos.Mid(iPos + 1);
////
////	//----- _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
////	iPos = strPos.Find(tcSpace);
////	if (0 < iPos)
////		lDocId = wcstol(strPos.Left(iPos), NULL, 10);
////	strPos = strPos.Mid(iPos + 1);
////
////	//----- _xZkqqHx_jHjKjHpAiImKjChFiCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
////	iPos = strPos.Find(tcSpace);
////	if (0 < iPos)
////		fliHiPtr = wcstol(strPos.Left(iPos), NULL, 10);
////	strPos = strPos.Mid(iPos + 1);
////
////	//----- _xZkqqHx_iDhCiDiFiBfLjCiGjAfDiNmAjFfH_xHqqkZx_X_xZkqqHx_iCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
////	iPos = strPos.Find(tcSpace);
////	if (0 < iPos)
////		mmX = wcstod(strPos.Left(iPos), NULL);
////	strPos = strPos.Mid(iPos + 1);
////
////	//----- _xZkqqHx_iDhCiDiFiBfLjCiGjAfDiNmAjFfH_xHqqkZx_Y_xZkqqHx_iCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
////	iPos = strPos.Find(tcSpace);
////	if (0 < iPos)
////		mmY = wcstod(strPos.Left(iPos), NULL);
////	strPos = strPos.Mid(iPos + 1);
////
////	// _xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCpAiKeKiCkNiBeC_xHqqkZx_
////	ViewHidocument(strFile, lDocId, fliHiPtr);
////	// _xZkqqHx_iOoGjDlOiClFiClNiNmAjFfHiCkKjCiGjAfDiCmJiCkNiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
////	g_pView->SetScrollCenter(DBLPoint(mmX, mmY));
////----- 02.01.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//#ifndef _DEBUG
//	_xZkqqHx_iClBiCoKiCpAiCmIiCpBiCmGiCkJiClJiCmLiCmOiBeC_xHqqkZx_
//#endif//_DEBUG
//} // CFCHistViewDoc::OnViewPastePosition.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateViewPastePosition
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDfCiDhDiBfLiClDiCoKiClNjHjKjHpAiImKjChFiCmJiInKjDkOiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::OnUpdateViewPastePosition (CCmdUI* pCmdUI)
//{
//	pCmdUI->Enable(FFCanBasicOperate() && IsClipboardFormatAvailable(CF_TEXT));
//} // CFCHistViewDoc::OnUpdateViewPastePosition.
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCreateFirstDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiCmJiNoMjAkMiClDiCoKiClNiDePiDiLiBfLiDhGjCiGiCmJiBeBjHjKjHpAjFlGiPjBiCmMiDgFiBfLiDhFiDiLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lockBank		:_xZkqqHx_jAfGiClFiCkNiNoMjAkMiClDiCoKiClNiKgFiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *			project			:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_iNoMjAkMiClHiCoJjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			pSpotStream		:_xZkqqHx_iPiJiKpKiDfIiDhMiDgCiDgHiCmMiDfIiDgHiDiKiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szSpotStream	:pSpotStream_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocIdFrom		:_xZkqqHx_jFkKiKpCiClFiClNjAgFiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIdxFrom:_xZkqqHx_jFkKiKpCiClFiClNjAgFiCmMjFkKiKpCiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstDateFrom	:_xZkqqHx_jFkKiKpCjClMjBePiCmMjDpKiOjOiCpAiOhHjCoIiBeCjAfGiLeLiCmMiPoKiNiHiCmNjHjKjHpAiNoMjAkMjDpKiOjOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidPrevUser	:_xZkqqHx_jFkKiKpCjClMjBePiCmMiDiGiBfLiDfFiBfLiCpAiOhHjCoIiBeCjAfGiLeLiCmMiPoKiNiHiCmNjHjKjHpAiNoMjAkMiOnCiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmN_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiBeBiDePiDiLiBfLiDhGiCmMiKmHjHjNiDgFiBfLiDhFiDiLiCmN_xHqqkZx_
 *			Read|Write_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiBeBiDePiDiLiBfLiDhGiCfA_xHqqkZx_(lDocId)_xZkqqHx_iCmJjHjKjHpAjFlGiPjBiDgFiBfLiDhFiDiLiCpAiNoMjAkMiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jEgKjApMiCmFiImNiCnMiCoKiClNiDgFiBfLiDhFiDiLiCkKjAfGiLeLiCmJiNoMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *                                                    _xZkqqHx_iBeG_xHqqkZx_
 *                                              _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                              _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                              _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEkIiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      
 *                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkBiBgDiBgDiBgDiEkAiBgDiBgDiBgDiBgDiBgDiBgDiEkAiBgDiBgDiBgDiBgDiBgDiBgDiEkAiBgDiBgDiBgDiBgDiBgDiBgDiEkAiBgDiBgDiBgDiBgDiBgDiBgDiEkAiBgDiBgDiBgDiEkC_xHqqkZx_
 *        _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEkCiBeGiEkBiEjPiEjPiEkIiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkCiBeG_xHqqkZx_
 *        _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiEkAiBeGiEkA_xHqqkZx_ _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_ _xZkqqHx_iDfEiDhNiDiKiBfL_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_ _xZkqqHx_jHjKjHpAjFkKiKpC_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_ _xZkqqHx_iDfIiDhMiDgCiDgH_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_ _xZkqqHx_iPeJjCfLiImKjChF_xHqqkZx_ _xZkqqHx_iEkAiBeG_xHqqkZx_
 *        _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkDiBeGiEkEiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkDiBeG_xHqqkZx_
 *                        _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 *			_xZkqqHx_iKgFiDgFiBfLiDhFiDiLiCmJiCmNiBeBiImIiJlKiCmMiPiJiKpKiDiMiDfCiBfLiDgIiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *                           _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiL_xHqqkZx_
 *                    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iDiMiDfCiBfLiDgIiCePiEkAiDfKiDgCiDfGiDiHiDjDiPiJiKpKjCgMiEkA_xHqqkZx_  _xZkqqHx_iOjOiKnEiPiJiKpKjCgM_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *                           _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiL_xHqqkZx_
 *                    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iDiMiDfCiBfLiDgIiCePiEkA_xHqqkZx_ _xZkqqHx_jFkKiKpCiDfKiDgCiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_jAgFjFlGiPjB_xHqqkZx_ID   _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *                           _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiL_xHqqkZx_
 *                    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iDiMiDfCiBfLiDgIiCePiEkAiDfKiDgCiDfGiDiHiDjDiPiJiKpKjCgMiEkA_xHqqkZx_ _xZkqqHx_iPiJiKpKiDfIiDhMiDgCiDgH_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *			_xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiBeBiPeJjCfLiImKjChFiDgFiBfLiDhFiDiLiCmNiLpDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCreateFirstDocument (FCDbLockBank& lockBank,
							FCHiProject& project,
							long lDocId,
							const BYTE* pSpotStream,
							size_t szSpotStream,
							long lDocIdFrom,
							flint fliSessionIdxFrom,
							FDSECTIME fdstDateFrom,
							const GUID& guidPrevUser)
{
	const DWORD dwTableIds[] =
		{
			FDHI_COMMAND_TABLE_ID,
			FDHI_SUMMARY_TABLE_ID,
			FDHI_FORK_TABLE_ID,
			FDHI_SPOT_TABLE_ID,
			FDHI_TERMINATE_TABLE_ID
		};

	FCDbGroup dbDocumentGroup = project.GetSubGroup(lDocId);
	// _xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiCmNiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCmNiClIiBeC_xHqqkZx_
	if (!dbDocumentGroup.GetIsReadLocked() ||
		!dbDocumentGroup.GetIsWriteLocked())
		FFThrowMiscUnknown();

	long lC;
	for (lC = 0; lC != sizeof(dwTableIds) / sizeof(dwTableIds[0]); lC++)
	{
		//----- _xZkqqHx_iDgFiBfLiDhFiDiLiNoMjAkM_xHqqkZx_ -----
		FCDbReadLock readLock;
		FCDbWriteLock writeLock;
		FCDbTable dbTableNew = dbDocumentGroup.CreateSubTable(	readLock,
																writeLock,
																NULL, 0,
																dwTableIds[lC]);
		// _xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiCmMiNoMjAkMiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
		if (dbTableNew.GetIsInvalid())
			return FALSE;
		// _xZkqqHx_iDiNiDgCiDeOiDgPiDjDiDeOiCmJiDiNiDgCiDeOiCpAjChOjAmPiBeC_xHqqkZx_
		lockBank.Append(readLock);
		lockBank.Append(writeLock);

		switch (dwTableIds[lC])
		{
		case FDHI_COMMAND_TABLE_ID:		// _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
		  {
			//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiCmMiPiJiKpKjCgMiCpAjAnNjCoI_xHqqkZx_ -----
			FCHiCommandTable commandTable = dbDocumentGroup;
			// _xZkqqHx_iLpDiCmMiDgFiBfLiDhFiDiLiCmMiPoKiNiHiCmNiBeB_xHqqkZx_UpdateData _xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_
			commandTable.WriteHeader(fliSessionIdxFrom, fdstDateFrom, guidPrevUser);
			break;
		  }
		case FDHI_FORK_TABLE_ID:		// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
		  {
			//----- _xZkqqHx_jFkKiKpCiImKjChFiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ -----
			FCHiForkTable forkTable = dbDocumentGroup;
			// _xZkqqHx_iLpDiCmMiDgFiBfLiDhFiDiLiCmMiPoKiNiHiCmNiBeB_xHqqkZx_UpdateData _xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_
			forkTable.SetSuperInfo(	fliSessionIdxFrom,
									lDocIdFrom);
			break;
		  }
		case FDHI_SPOT_TABLE_ID:		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
		  {
			//----- _xZkqqHx_iDfIiDhMiDgCiDgHiPoOjFpBiCpAjDgPjIfOiClHiCoJ_xHqqkZx_ -----
			FCHiSpotTable spotTable = dbDocumentGroup;
			// _xZkqqHx_iLpDiCmMiDgFiBfLiDhFiDiLiCmMiPoKiNiHiCmNiBeB_xHqqkZx_UpdateData _xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_
			spotTable.AppendSpot(	fliSessionIdxFrom,
									pSpotStream,
									szSpotStream);
			break;
		  }
		case FDHI_SUMMARY_TABLE_ID:		// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
		case FDHI_TERMINATE_TABLE_ID:	// _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
			break;
		}
	}
	return TRUE;
} // FFCreateFirstDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCreateFirstFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiCmJjHjKjHpAjFlGiPjBiCpAiNoMjAkMiClHiCoJiBeCiOkJjAgHiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCmMiPoOjFpBiCmNiPiJiKpKiJlLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lockBank		:_xZkqqHx_jAfGiClFiCkNiNoMjAkMiClDiCoKiClNiKgFiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *			project			:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_iNoMjAkMiClHiCoJjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			wcpTemplateFile	:_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDoc			:Document_xZkqqHx_iCpAiOhHjCoIiBeCiNmFiPiJiCmMiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpA_xHqqkZx_
 *							 _xZkqqHx_jFnLjBlGiClHiCoJiCmMiCmJiOgHiCkEiBeC_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmN_xHqqkZx_
 *							 _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmM_xHqqkZx_Document_xZkqqHx_iCpAiNoMjAkMiClFiCmEiOgHiCkEiBeC_xHqqkZx_
 *			fliSessionIdxFrom:_xZkqqHx_jFkKiKpCiClFiClNjAgFiCmMjFkKiKpCiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstDateFrom	:_xZkqqHx_jFkKiKpCjClMjBePiCmMjDpKiOjOiCpAiOhHjCoIiBeCjAfGiLeLiCmMiPoKiNiHiCmNjHjKjHpAiNoMjAkMjDpKiOjOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidPrevUser	:_xZkqqHx_jFkKiKpCjClMjBePiCmMiDiGiBfLiDfFiBfLiCpAiOhHjCoIiBeCjAfGiLeLiCmMiPoKiNiHiCmNjHjKjHpAiNoMjAkMiOnCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocIdFrom		:_xZkqqHx_jFkKiKpCiClFiClNjAgFiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	<mdrwpos file="D:\src\DynamicDraw\_xZkqqHx_jHjKjHpAjFlGiPjBiLkEjHeMiOgEjHgM_xHqqkZx_.mdrw" sheet="1" cposx="507" cposy="307"/>
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCreateFirstFile (FCDbLockBank& lockBank,
						FCHiProject& project,
						long lDocId,
						const wchar_t* wcpTemplateFile,
						CFCFoundDoc* pDoc,
						flint fliSessionIdxFrom,
						FDSECTIME fdstDateFrom,
						const GUID& guidPrevUser,
						long lDocIdFrom)
{
	//----- _xZkqqHx_iOgOjDfPiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ ----
	BYTE* pSpotStream = NULL;
	DWORD dwSpotStreamSize = 0;
	if (pDoc == NULL)
	//----- _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		struct my
		{
			my () : pSpotStream(NULL), dwSpotStreamSize(0), wcpTemplateFile(NULL) {}
			static int EnumNewDocumentProc (CFCFoundDoc* pDoc,	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiBeC_xHqqkZx_
											void* pData)		// _xZkqqHx_iDiGiBfLiDfFiDgGiBfLiDfOiBeC_xHqqkZx_
			{
				int iReturn = 0;
				my* pMy = (my*)pData;
				// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNjDmHiCnNiPgPiClHiBeC_xHqqkZx_
				if (pMy->wcpTemplateFile != NULL &&
					pMy->wcpTemplateFile[0] != L'\0')
				{
					try
					{
						// _xZkqqHx_iOhHjCoIiCmMiDhEiDeAiDeDiDiLiCpAiDeDiDjDiDhMiBfLiDgHiBeCiLiMiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
						// _xZkqqHx_jFmPiKlHiCkKiPgPjHiIiCmIiCkCiPoKiNiHiCmIiCmHiBeBiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
						pDoc->ImportFile(pMy->wcpTemplateFile, NULL);
					} catch (CException* e)
					//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
					{
						// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
						iReturn = FFGetErrorCode(e);
						// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
						FFSetDDErrorCodeMessage(FFGetErrorCode(e), FFGetErrorMessage(e));
						e->Delete();
					}
				}
				// _xZkqqHx_iOgOjDfPiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiDfKiBfLiDhFiClHiCoJiBeC_xHqqkZx_
				if (iReturn == 0)
					FC2Ref<BYTE*, DWORD>(pMy->pSpotStream, pMy->dwSpotStreamSize) = FFExportSpotFile(pDoc);
				return iReturn;
			}
			BYTE* pSpotStream;
			DWORD dwSpotStreamSize;
			const wchar_t* wcpTemplateFile;
		} data;
		// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
		data.wcpTemplateFile = wcpTemplateFile;
		// _xZkqqHx_jAfGiClFiCkC_xHqqkZx_CFCFoundDoc_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClFiCmEiBeBiDfCiBfLiDiLiDgPiDgCiDeOiCpAiOmAiNhDiBeC_xHqqkZx_
		if (CFCFoundDoc::EnumNewDocument(my::EnumNewDocumentProc, &data) == 0)
		{
			// _xZkqqHx_jCgMiCpAjAnNjCoIiBeC_xHqqkZx_
			pSpotStream = data.pSpotStream;
			dwSpotStreamSize = data.dwSpotStreamSize;
		}
	} else
	//----- _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOgOjDfPiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiDfKiBfLiDhFiClHiCoJiBeC_xHqqkZx_
		FC2Ref<BYTE*, DWORD>(pSpotStream, dwSpotStreamSize) = FFExportSpotFile(pDoc);
	}
	if (pSpotStream == NULL)
	//----- _xZkqqHx_iDeHiDeOiDfIiDhMiBfLiDgHiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		AfxDebugBreak();
		return FALSE;
	}
	// _xZkqqHx_iPiJiKpKiDgFiBfLiDhFiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
	if (!FFCreateFirstDocument(	lockBank,
								project,
								lDocId,
								pSpotStream,
								dwSpotStreamSize,
								lDocIdFrom,
								fliSessionIdxFrom,
								fdstDateFrom,
								guidPrevUser))
	{
		// _xZkqqHx_jHmMiIoGiCpAiJpAjFpKiBeC_xHqqkZx_
		::free(pSpotStream);
		return FALSE;
	}

	// _xZkqqHx_jHmMiIoGiCpAiJpAjFpKiBeC_xHqqkZx_
	::free(pSpotStream);
	pSpotStream = NULL;

	//----- _xZkqqHx_jHjKjHpAiPeJjCfLiLeMjIfOiCpAjDgPjIfOiClHiCoJ_xHqqkZx_ -----
	FCHiTerminateTable termTable = project.GetSubGroup(lDocId);
	// _xZkqqHx_iLpDiCmMiDgFiBfLiDhFiDiLiCmMiPoKiNiHiCmNiBeB_xHqqkZx_UpdateData _xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_
	termTable.UpdateEndSessionIndex(fliSessionIdxFrom, NULL, 0);

	return TRUE;
} // FFCreateFirstFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFImportSpotFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCmJiBeBiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnMiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwErrCode		:_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *			wstrErrMessage	:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			pDoc			:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCpAiOhHjCoIiBeCiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCkKjDmHiCnNiNjOiCnMiCoKiCoJiBeC_xHqqkZx_
 *			wcpFilePath		:_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCanvasStatRefer:_xZkqqHx_iDeMiDiDiDjDiDgPiDfIiPoOjFpBiCmMiDiKiDhEiDeAiDiMiDjDiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iClBiCmMjCgMiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiBeBjDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_
 *							 _xZkqqHx_iDeMiDiDiDjDiDgPiDfIiPoOjFpBiCmFiCmNiCmIiCkNiBeBiClBiCmMjCgMiCpA_xHqqkZx_
 *							 _xZkqqHx_iOgHiCmBiCmEiPiJiKpKiJlLiClDiCoKiCoJiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			readLockSpot	:_xZkqqHx_iDiNiDgCiDeOjFmPjAjEiCpAiOhHjCoIiBeCiDhEiDeAiDeDiDiLiCpAiDiNiDgCiDeOiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			bIsRedraw		:_xZkqqHx_jDmHiCnNiNjOiCnNiMoDiBeBiNmEjFgAiJoGiClHiCoJiCkJiCmHiCkEiCkJiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiBgJiDiNiDgCiDeOiCmFiCkLiCmIiCkCiBeBiDhEiDeAiDeDiDiLjEgKjBlJjDjJiBgKiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFImportSpotFile (	CFCFoundDoc* pDoc,
						FCCanvasStat* pCanvasStatRefer,
						const BYTE* pSpotStream,
						DWORD dwSpotStreamSize,
						BOOL bIsRedraw)
{
	// _xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiBeC_xHqqkZx_
	pDoc->InWorkFormat(CMemFile((BYTE*)pSpotStream, dwSpotStreamSize), pCanvasStatRefer, bIsRedraw);
	return TRUE;
} // FFImportSpotFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFExportSpotFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCmJiBeBiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAiPjBiCkLiPgPiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwErrCode		:_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *			wstrErrMessage	:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			pDoc		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCpAiOhHjCoIiBeCiDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCkKiPjBiCkLiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *			wcpFilePath	:_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			readLockSpot:_xZkqqHx_iDiNiDgCiDeOjFmPjAjEiCpAiOhHjCoIiBeCiDiNiDgCiDeOiClFiCmEjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *			writeLockSpot:_xZkqqHx_iDiNiDgCiDeOjFmPjAjEiCpAiOhHjCoIiBeCiDiNiDgCiDeOiClFiCmEjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiBgJiDiNiDgCiDeOiCmFiCkLiCmIiCkCiBeBiDhEiDeAiDeDiDiLjEgKjBlJjDjJiBgKiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FC2Fold<BYTE*, DWORD> FFExportSpotFile (CFCFoundDoc* pDoc)
{
	// _xZkqqHx_iDiBiDiCiDiKiDhEiDeAiDeDiDiLiCpAjAlGjAkMiBeC_xHqqkZx_
	CMemFile memFile;
	// _xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiBeC_xHqqkZx_
	pDoc->OutWorkFormat(memFile, TRUE, TRUE);
	// _xZkqqHx_iPgPjHmNiDgGiBfLiDfOiDfEiDeDiDfJiCmMiOfKiPgPiBeC_xHqqkZx_
	const DWORD dwStreamSize = memFile.GetLength();
	// CMemFile_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiCpAjAnIiCoIjHkDiClHiBeC_xHqqkZx_
	BYTE* pStream = memFile.Detach();
	return FC2Fold<BYTE*, DWORD>(pStream, dwStreamSize);
} // FFExportSpotFile.

//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnViewPrevDsm
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_[_xZkqqHx_jBePiCmMjFlGiPjBiImKjChFiCmJjGnPiCoJ_xHqqkZx_]_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::OnViewPrevDsm ()
//{
//#if 0
////----- 05.11.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iClBiCoKiImIiPoDjGnPiCoKiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
////	// _xZkqqHx_iOmAiNnLiCmJiCmNjGnPiCoKiCmIiCkCiPoKiNiHiCmFiCoAiBeBjBgGjBiBiCkNiDhLiDfOiDjDiCpAiJjPiClFiClNiPoKiNiH_xHqqkZx_ OnUpdateViewPrevDsm
////	// _xZkqqHx_iCkKjHeMiMpIiCmGiCmIiCoJiPoKiNiHiCkKiCkAiCoJiBeCiClLiCoKiCpAjGgIiCkOiClNiCnPiBeBiClBiCmMjElLjCoIiCkKjFeLjHhGiBeC_xHqqkZx_
////	if (m_lCurrentDsmPosition < 1) return;
////----- 05.11.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
////----- 05.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	if (GetIsDocumentOpened() && 
//		m_lCurrentDsmPosition != -1 &&
//		m_vDsmHistory.size() == m_lCurrentDsmPosition + 1)
//	//----- DSM_xZkqqHx_jHjKjHpAiCmMiNmFiMoDiCmJiDhMiDeDiDjDiDfOiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiDeOiDiKiDgCiDeOiClFiCmEjFlGiPjBiCpAiInKjDkOiClFiClNiPoKiNiHiBeB_xHqqkZx_
//		// _xZkqqHx_iMlLiNnNiImKjChFiCmNiCnMiClO_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCmJiLeMjIfOiClDiCoKiCmEiCkCiCmIiCkCiBeC_xHqqkZx_
//		// _xZkqqHx_iClBiCmMiPpDjBnEiCmF_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCpAiIoKiCmCjGnPiClHiCmGiBeBiMlLiNnNiImKjChFiCkK_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCmJ_xHqqkZx_
//		// _xZkqqHx_iLeMjIfOiClDiCoKiClIiBeBiBhF_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCpAiIoKiCmCjAgJiCnPiCoJiBhGiCkKiOmAiNhDiCmFiCkLiCmIiCkNiCmIiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iClBiCmMiClNiCnPiBeBiClBiClBiCmF_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
////----- 06.02.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		if (g_pProject->GetTableName().GetTopDirPath() != m_vDsmHistory[m_lCurrentDsmPosition]->m_hstrProjectFilePath ||
////			GetDocumentId() != m_vDsmHistory[m_lCurrentDsmPosition]->m_lDocumentId ||
////			GetNextSessionIndex() != m_vDsmHistory[m_lCurrentDsmPosition]->m_fliSessionIndex)
////----- 06.02.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		if (g_pProject->GetTableName().GetTopDirPath() != m_vDsmHistory[m_lCurrentDsmPosition]->m_hstrProjectFilePath ||
//			GetDocumentId() != m_vDsmHistory[m_lCurrentDsmPosition]->m_lDocumentId ||
//			GetNextSessionIndexAbout() != m_vDsmHistory[m_lCurrentDsmPosition]->m_fliSessionIndex)
////----- 06.02.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		//----- DSM_xZkqqHx_jHjKjHpAiNmFiMoDiCmMiLeMjIfOiCkKiMlLiNnNiImKjChFiCmGiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//			DWORDSet stObjId;
//			g_pView->GetSelectObjectId(stObjId);
//			// _xZkqqHx_jBeJjBpAjCiGiCmMiDgFiDeMiDfIiDgHjEmNiImNiCpAiOoGjDlOiBeC_xHqqkZx_
//			DWORDVector vTextSelection;
//			mdef_const_iterator(DWORDSet, iId);
//			m1_for (iId, stObjId)
//				g_pDoc->ObjID2Object(*iId)->GetTextSelection(vTextSelection);
//			// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
//			DBLRect mmrtClient;
//			g_pView->GetClientRectMM(mmrtClient);
//			// _xZkqqHx_jAfGiClFiCkC_xHqqkZx_DSM_xZkqqHx_jHjKjHpAiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
//			FCDsmRec* pRec = new FCDsmRec(g_pProject->GetFilePathH(),
//														GetDocumentId(),
//														GetNextSessionIndexAbout(),
//														stObjId,
//														vTextSelection,
//														mmrtClient.CenterPoint(),
//														GetCurrentSheetId(),
//														g_->lZoom256);
//			m_vDsmHistory.push_back(auto_ptr<FCDsmRec>(pRec));
//			// DSM_xZkqqHx_jHjKjHpAiCmMiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
//			m_lCurrentDsmPosition++;
//		}
//	}
//	// _xZkqqHx_iClBiCoKiImIiPoDjGnPiCoKiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	// _xZkqqHx_iOmAiNnLiCmJiCmNjGnPiCoKiCmIiCkCiPoKiNiHiCmFiCoAiBeBjBgGjBiBiCkNiDhLiDfOiDjDiCpAiJjPiClFiClNiPoKiNiH_xHqqkZx_ OnUpdateViewPrevDsm
//	// _xZkqqHx_iCkKjHeMiMpIiCmGiCmIiCoJiPoKiNiHiCkKiCkAiCoJiBeCiClLiCoKiCpAjGgIiCkOiClNiCnPiBeBiClBiCmMjElLjCoIiCkKjFeLjHhGiBeC_xHqqkZx_
//	if (m_lCurrentDsmPosition < 1) return;
////----- 05.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	// DSM_xZkqqHx_jHjKjHpAiCmMiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
//	m_lCurrentDsmPosition--;
//	// _xZkqqHx_iOhHjCoIiCmMiDhGiDiNiDfHiDeGiDeOiDgHiBeFjHjKjHpAjFlGiPjBiBeFiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
//	PushBackDocRequest(
//					ID_DREQ_MOVE_HISTORY_UNTIL_PJ_HIDOC_SESSION,
//					FCReqBase::PROJECT_PATH,
//					(const wchar_t*)WString(m_vDsmHistory[m_lCurrentDsmPosition]->m_hstrProjectFilePath),
//					FCReqBase::HIDOCUMENT_ID, m_vDsmHistory[m_lCurrentDsmPosition]->m_lDocumentId,
//					FCReqBase::SESSION_INDEX, m_vDsmHistory[m_lCurrentDsmPosition]->m_fliSessionIndex,
//					FCReqBase::IS_SELECT_OBJECT, FALSE,
//					FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::NONE,
//					FCReqBase::NONE);
//	// _xZkqqHx_jFjEjFgJiCpAjBeJjBpAiClHiCoJiBeC_xHqqkZx_
//	PushBackDocRequest(	ID_DREQ_SELECT_OBJECT,
//						FCReqBase::OBJECT_ID_SET, &m_vDsmHistory[m_lCurrentDsmPosition]->m_stObjectId,
//// 06.03.01 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//						FCReqBase::TEXT_SELECTION_VECTOR, &m_vDsmHistory[m_lCurrentDsmPosition]->m_vTextSelection,
//						FCReqBase::IS_SELECT_OBJECT, TRUE,
//						FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::NONE,
//						FCReqBase::IS_DRAW_SELECT_MARK, TRUE,
//						FCReqBase::NONE);
//	// _xZkqqHx_iOhHjCoIiClFiClNiNmAjFfHiCkKjCiGjAfDiCmJiCkNiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
//	PushBackDocRequest(	ID_DREQ_CHANGE_SHEET_ZOOM_CENTER,
//						FCReqBase::MM_X, m_vDsmHistory[m_lCurrentDsmPosition]->m_mmptCenter.x,
//						FCReqBase::MM_Y, m_vDsmHistory[m_lCurrentDsmPosition]->m_mmptCenter.y,
//						FCReqBase::SHEET_ID, m_vDsmHistory[m_lCurrentDsmPosition]->m_stid,
//						FCReqBase::VIEW_ZOOM_256, m_vDsmHistory[m_lCurrentDsmPosition]->m_lZoom256,
//						FCReqBase::NONE);
//
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
//	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_END);
//	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//	ProceedDocRequest();
//#endif//0
//} // CFCHistViewDoc::OnViewPrevDsm.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateViewPrevDsm
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_[_xZkqqHx_jBePiCmMjFlGiPjBiImKjChFiCmJjGnPiCoJ_xHqqkZx_]_xZkqqHx_iCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::OnUpdateViewPrevDsm (CCmdUI* pCmdUI)
//{
//#if 0
//	if (!FFCanBasicOperate())
//	{
//		pCmdUI->Enable(FALSE);
//	} else
//	{
//		if (m_vDsmHistory.size() == 1)
//			pCmdUI->Enable(TRUE);
//		else
//			pCmdUI->Enable(0 < m_lCurrentDsmPosition);
//	}
//#endif//0
//} // CFCHistViewDoc::OnUpdateViewPrevDsm.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnViewNextDsm
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_[_xZkqqHx_iOjPiCmMjFlGiPjBiImKjChFiCmJjAgJiCnO_xHqqkZx_]_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::OnViewNextDsm ()
//{
//#if 0
//	// _xZkqqHx_iClBiCoKiImIiPoDjAgJiCnPiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	// _xZkqqHx_iOmAiNnLiCmJiCmNjAgJiCnPiCmIiCkCiPoKiNiHiCmFiCoAiBeBjBgGjBiBiCkNiDhLiDfOiDjDiCpAiJjPiClFiClNiPoKiNiH_xHqqkZx_ OnUpdateViewPrevDsm
//	// _xZkqqHx_iCkKjHeMiMpIiCmGiCmIiCoJiPoKiNiHiCkKiCkAiCoJiBeCiClLiCoKiCpAjGgIiCkOiClNiCnPiBeBiClBiCmMjElLjCoIiCkKjFeLjHhGiBeC_xHqqkZx_
//	if (m_vDsmHistory.size() == m_lCurrentDsmPosition + 1) return;
//	// DSM_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAiJmBiOfKiBeC_xHqqkZx_
//	m_lCurrentDsmPosition++;
//	// _xZkqqHx_iOhHjCoIiCmMiDhGiDiNiDfHiDeGiDeOiDgHiBeFjHjKjHpAjFlGiPjBiBeFiImKjChFiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
//	PushBackDocRequest(
//					ID_DREQ_MOVE_HISTORY_UNTIL_PJ_HIDOC_SESSION,
//					FCReqBase::PROJECT_PATH,
//					(const wchar_t*)WString(m_vDsmHistory[m_lCurrentDsmPosition]->m_hstrProjectFilePath),
//					FCReqBase::HIDOCUMENT_ID, m_vDsmHistory[m_lCurrentDsmPosition]->m_lDocumentId,
//					FCReqBase::SESSION_INDEX, m_vDsmHistory[m_lCurrentDsmPosition]->m_fliSessionIndex,
//					FCReqBase::IS_SELECT_OBJECT, FALSE,
//					FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::NONE,
//					FCReqBase::NONE);
//	// _xZkqqHx_jFjEjFgJiCpAjBeJjBpAiClHiCoJiBeC_xHqqkZx_
//	PushBackDocRequest(	ID_DREQ_SELECT_OBJECT,
//						FCReqBase::OBJECT_ID_SET, &m_vDsmHistory[m_lCurrentDsmPosition]->m_stObjectId,
//// 06.03.01 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//						FCReqBase::TEXT_SELECTION_VECTOR, &m_vDsmHistory[m_lCurrentDsmPosition]->m_vTextSelection,
//						FCReqBase::IS_SELECT_OBJECT, TRUE,
//						FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::NONE,
//						FCReqBase::IS_DRAW_SELECT_MARK, TRUE,
//						FCReqBase::NONE);
//	// _xZkqqHx_iOhHjCoIiClFiClNiNmAjFfHiCkKjCiGjAfDiCmJiCkNiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
//	PushBackDocRequest(	ID_DREQ_CHANGE_SHEET_ZOOM_CENTER,
//						FCReqBase::MM_X, m_vDsmHistory[m_lCurrentDsmPosition]->m_mmptCenter.x,
//						FCReqBase::MM_Y, m_vDsmHistory[m_lCurrentDsmPosition]->m_mmptCenter.y,
//						FCReqBase::SHEET_ID, m_vDsmHistory[m_lCurrentDsmPosition]->m_stid,
//						FCReqBase::VIEW_ZOOM_256, m_vDsmHistory[m_lCurrentDsmPosition]->m_lZoom256,
//						FCReqBase::NONE);
//
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
//	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_END);
//	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//	ProceedDocRequest();
//#endif//0
//} // CFCHistViewDoc::OnViewNextDsm.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateViewNextDsm
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_[_xZkqqHx_iOjPiCmMjFlGiPjBiImKjChFiCmJjAgJiCnO_xHqqkZx_]_xZkqqHx_iCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiPpDjBnEiCpAiOkGiClHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCHistViewDoc::OnUpdateViewNextDsm (CCmdUI* pCmdUI)
//{
//#if 0
//	if (!FFCanBasicOperate())
//	{
//		pCmdUI->Enable(FALSE);
//	} else
//	{
//		pCmdUI->Enable(m_lCurrentDsmPosition + 1 < m_vDsmHistory.size());
//	}
//#endif//0
//} // CFCHistViewDoc::OnUpdateViewNextDsm.
//----- 06.03.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnViewTimeLabelShowMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjOiKnEiDiJiDhIiDiLiCpAjFfMiOkGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnViewTimeLabelShowMode ()
{
	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLjFfMiOkGiDiCiBfLiDgIiCpAjFmPiNfIiBeC_xHqqkZx_
	g_pReg->SetIsShowTimeLabel(!g_pReg->GetIsShowTimeLabel());
	// _xZkqqHx_iJoGjGmKiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw(TRUE);
} // CFCHistViewDoc::OnViewTimeLabelShowMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateViewTimeLabelShowMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjOiKnEiDiJiDhIiDiLiCpAjFfMiOkGiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateViewTimeLabelShowMode (CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(g_pReg->GetIsShowTimeLabel());
	pCmdUI->Enable(GetIsDocumentOpened() && FFCanBasicOperate());
} // CFCHistViewDoc::OnUpdateViewTimeLabelShowMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnHtreeCreateTimeIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiNoMjAkMiBhGiDfCiDhNiDjDiDgIiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnHtreeCreateTimeIndex ()
{
	// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiNoMjAkMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_CREATE_TIME_INDEX);
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
	PushBackDocRequest(ID_DREQ_END);
	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
	ProceedDocRequest();
} // CFCHistViewDoc::OnHtreeCreateTimeIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateHtreeCreateTimeIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiNoMjAkMiBhGiDfCiDhNiDjDiDgIiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateHtreeCreateTimeIndex (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && g_pProject->IsProjectOpened());
} // CFCHistViewDoc::OnUpdateHtreeCreateTimeIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnHtreeUseTimeIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiBhGiDfCiDhNiDjDiDgIiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnHtreeUseTimeIndex ()
{
	// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	SetIsUseTimeIndex(!GetIsUseTimeIndex());
} // CFCHistViewDoc::OnHtreeUseTimeIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCHistViewDoc::OnUpdateHtreeUseTimeIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiBhGiDfCiDhNiDjDiDgIiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCHistViewDoc::OnUpdateHtreeUseTimeIndex (CCmdUI* pCmdUI)
{
	// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCkKjHeMiCoJiPoKiNiHiCmMiCnNjHeMiMpIiBeC_xHqqkZx_
	pCmdUI->Enable(m_pFileTimeIndex != NULL);
	// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	pCmdUI->SetCheck(GetIsUseTimeIndex());
} // CFCHistViewDoc::OnUpdateHtreeUseTimeIndex.


void CFCHistViewDoc::OnTestTestTest2 () 
{
}

void CFCHistViewDoc::OnUpdateTestTestTest2 (CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(TRUE);
}

