#ifndef __LayerManager_h
#define __LayerManager_h

// 03.05.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include <map>	// For map template.

class FCUndoArchive;
class FCZOrder;

typedef map<const FCObjDynabase*, DWORD> ObjectLZHashMap;

//----- 05.05.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// 05.04.12 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//typedef BOOL (*FuncForAllObject) (FCObjDynabase* pObj, DWORD data);
//----- 05.05.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//;----- <EXPORT TO SDK> -----;

#define FDOZ_ON_NONE	(0x0000)
#define FDOZ_ON_PRINT	(0x0001 << 0)
#define FDOZ_ON_DRAW	(0x0001 << 1)
#define FDOZ_ON_SELECT	(0x0001 << 2)
#define FDOZ_ON_EDIT	(0x0001 << 3)
#define FDOZ_ON_ALL		(FDOZ_ON_DRAW | FDOZ_ON_PRINT | FDOZ_ON_SELECT | FDOZ_ON_EDIT)
#define FDOZ_ON_ANY		0x0000

struct FCLayerZOrder
{
	// _xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeCiDhCiDiFiBfLiDeBiDfMiBfLiDfIiDfCiBfLiDgIjFmPiKlHjHhAiCmJiBeBiNmFiMoDiCmJ_xHqqkZx_";"_xZkqqHx_iCpAjFhEiCkPiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	FCLayerZOrder (DWORD dwA = MAXDWORD, DWORD dwB = MAXDWORD)
			: dwLayerIdx(dwA), dwZOrder(dwB) {};
	DWORD	dwLayerIdx;
	DWORD	dwZOrder;
}; // struct FCLayerZOrder.

inline bool operator < (const FCLayerZOrder& a, const FCLayerZOrder& b)
{
	if (a.dwLayerIdx < b.dwLayerIdx) return true;
	if (a.dwLayerIdx > b.dwLayerIdx) return false;
	if (a.dwZOrder < b.dwZOrder) return true;
	return false;
} // operator <.

inline bool operator <= (const FCLayerZOrder& a, const FCLayerZOrder& b)
{
	if (a.dwLayerIdx < b.dwLayerIdx) return true;
	if (a.dwLayerIdx > b.dwLayerIdx) return false;
	if (a.dwZOrder <= b.dwZOrder) return true;
	return false;
} // operator <=.

inline bool operator == (const FCLayerZOrder& a, const FCLayerZOrder& b)
{
	if (a.dwLayerIdx == b.dwLayerIdx && a.dwZOrder == b.dwZOrder) return true;
	return false;
} // operator ==.

inline bool operator != (const FCLayerZOrder& a, const FCLayerZOrder& b)
{
	if (a.dwLayerIdx != b.dwLayerIdx || a.dwZOrder != b.dwZOrder) return true;
	return false;
} // operator !=.

inline FCLayerZOrder operator + (const FCLayerZOrder& a, long l)
{
	return FCLayerZOrder(a.dwLayerIdx, a.dwZOrder + l);
} // operator +.

const FCLayerZOrder LAST_LAYER_ORDER(MAXDWORD, MAXDWORD);
const FCLayerZOrder FIRST_LAYER_ORDER(DWORD(0), DWORD(0));

typedef vector<FCLayerZOrder>	LayerZOrderVector;

//;------ </EXPORT TO SDK> -----;

// 03.07.08 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "../MolipSDK/FCLayerManagerExp.h"	// Superclass.

class FCLayerRec
{
public:
	FCLayerRec (const wchar_t* tcpName, WORD wFlag, ObjDynabaseVector* pvLayer);
	void	Delete ();
	WString			m_strName;
	WORD			m_wFlag;
	ObjDynabaseVector*	m_pvLayer;
}; // class FCLayerRec.

typedef vector<FCLayerRec>	LayerRecVector;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCLayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Document_xZkqqHx_iCmMjFjEjFgJiCmM_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiKmHjHjNiClHiCoJiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCLayerManager
{
public:
	FCLayerManager (BOOL bReady, const wchar_t* tcpName, ObjectLZHashMap& mpLZHash,
					ObjDynabaseVector& vBottomLayer, ObjDynabaseVector& vTopLayer);
	virtual ~FCLayerManager ();
	virtual void	DeleteAll ();
	virtual const wchar_t*	GetName () const;
	virtual WString&	GetName ();
	virtual void	SetName (const wchar_t* tcpName);
	virtual BOOL	IsReady () const;
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual void	OutStream (FCUndoArchive& ar, BOOL bIsOutObject) const;
	virtual void	OutStream (FCUndoArchive& ar, BOOL bIsOutObject, BOOL bIsOutBezier) const;
	virtual void	InStream (FCUndoArchive& ar);
// 03.06.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OutStreamTemplate (FCUndoArchive& ar) const;

	virtual void	InsertLayer (DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag);
	virtual void	DeleteLayer (DWORD dwLayerIdx);
// 02.09.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)
//	virtual BOOL	ModifyLayer (DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag);
	virtual BOOL	ModifyLayer (BOOL& bViewUpdated, DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag);
	virtual void	SetCurrentLayerIdx (DWORD dwIdx);
	virtual BOOL	ReOrderLayer (DWORD dwFirstIdx, DWORD dwLastIdx, const DWORD dwaNewLayerIdx[]);
	virtual void	AppendToLZOrder (FCObjDynabase* pObj);
	virtual void	AppendToLZOrder (const ObjDynabaseVector& vObj);
	virtual void	AppendToLZOrder (FCObjDynabase*const* pObjArray, long lArraySz);
	virtual void	AppendToLZOrder (DWORD dwLayerIdx, FCObjDynabase* pObj);
	virtual void	AppendToLZOrder (DWORD dwLayerIdx, const ObjDynabaseVector& vObj);
	virtual void	AppendToLZOrder (DWORD dwLayerIdx, FCObjDynabase*const* pObjArray, long lArraySz);
	virtual void	InsertToLZOrder (FCObjDynabase* pPos, FCObjDynabase* pObj);
	virtual void	InsertToLZOrder (FCObjDynabase* pPos, const ObjDynabaseVector& vObj);
	virtual void	InsertToLZOrder (FCObjDynabase* pPos,
								FCObjDynabase*const* pObjArray, long lArraySz);
	virtual void	InsertToLZOrder (const FCLayerZOrder& lzorder, FCObjDynabase* pObj);
	virtual void	InsertToLZOrder (const FCLayerZOrder& lzorder, const ObjDynabaseVector& vObj);
	virtual void	InsertToLZOrder (const FCLayerZOrder& lzorder,
								FCObjDynabase*const* pObjArray, long lArraySz);
	virtual void	InsertToLZOrder (const LayerZOrderVector& vLZOrder, const ObjDynabaseVector& vObj);
	virtual void	RemoveFromLZOrder (FCObjDynabase* pObj);
	virtual void	RemoveFromLZOrder (const ObjDynabaseVector& vObj);
	virtual BOOL	MoveZFront (const FCLayerZOrder& lzorder, FCObjDynabase* pObj);
	virtual BOOL	MoveLZFront (ObjDynabaseVector& vMoved, const ObjDynabaseVector& vObj);
	virtual BOOL	MoveZBack (const FCLayerZOrder& lzorder, FCObjDynabase* pObj);
	virtual BOOL	MoveLZBack (ObjDynabaseVector& vMoved, const ObjDynabaseVector& vObj);
	virtual FCLayerZOrder	ObjDynabaseToLZOrder (const FCObjDynabase* pObj) const;
	virtual FCObjDynabase*	LZOrderToObjDynabase (const FCLayerZOrder& lzorder) const;

	virtual DWORD	GetCurrentLayerIdx () const;
	virtual DWORD	GetZOrderSize (WORD wOption = FDOZ_ON_ANY, DWORD dwFromIdx = 0, DWORD dwUntilIdx = MAXDWORD) const;
	virtual void	GetZOrder (FCZOrder& zOrder, WORD wOption = FDOZ_ON_ANY, DWORD dwFromIdx = 0, DWORD dwUntilIdx = MAXDWORD) const;
	virtual void	GetZOrder (ObjDynabaseVector& vObj, WORD wOption = FDOZ_ON_ANY, DWORD dwFromIdx = 0, DWORD dwUntilIdx = MAXDWORD) const;

	virtual DWORD	FirstFrontLayerIdx (DWORD dwFromIdx, WORD wOption) const;
	virtual DWORD	GetLayerSize () const;
	virtual void	GetLayerInfo (WString* strName, WORD* wFlag, DWORD dwLayerIdx) const;

	virtual void	FirstFrontLZOrder (FCLayerZOrder& lzorder, WORD wOption,
										const FCLayerZOrder& lzFrom = LAST_LAYER_ORDER) const;
	virtual void	NextBackLZOrder (FCLayerZOrder& lzorder, WORD wOption) const;

	virtual void	FirstBackLZOrder (FCLayerZOrder& lzorder, WORD wOption,
									const FCLayerZOrder& lzFrom = FIRST_LAYER_ORDER) const;
	virtual void	NextFrontLZOrder (FCLayerZOrder& lzorder, WORD wOption) const;

// 05.04.12 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	CallForAllObject (FuncForAllObject func, void* data) const;

//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	IsUsedSColor (SColorID val) const;
//	virtual BOOL	IsUsedEmfImage (EmfImageID val) const;
//	virtual BOOL	IsUsedBrushRegister (BrushRegisterID val) const;
//	virtual BOOL	IsUsedPenRegister (PenRegisterID val) const;
//	virtual BOOL	IsUsedPenStyle (PenStyleID val) const;
//	virtual BOOL	IsUsedSFont (SFontID val) const;
//	virtual BOOL	IsUsedPictArrow (PictArrowID val) const;
//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

protected:
	virtual ObjDynabaseVector*	GetObjOrder (DWORD dwLayerIdx) const;
	virtual ObjDynabaseVector*	GetTopObjOrder () const;
	virtual void		NextFrontLZOrder (FCLayerZOrder& lzorder) const;
	virtual void		UpdateLZHashTable (const FCLayerZOrder& lzorder);
	virtual void		UpdateLZHashTable (FCLayerZOrder lzorderFrom,
									FCLayerZOrder lzorderUntil);
	virtual void		EraseFromLZHashTable (const FCObjDynabase* pObj);

protected:
// 03.07.24 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	BOOL				m_bReady;
	WString				m_strName;
	ObjectLZHashMap*	m_mpLZHash;
	LayerRecVector		m_vLayerTable;
	DWORD				m_dwCurLayerIdx;
}; // class FCLayerManager.

#endif//__LayerManager_h

