#include "stdafx.h"
#include "UtilErr.h"	// For FFThrowMiscUnknown.
#include "MemFileEx.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMemFileEx::CFCMemFileEx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCMemFileEx::CFCMemFileEx (UINT nGrowBytes)
			:	BASE_CLASS(nGrowBytes)
{}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMemFileEx::CFCMemFileEx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCMemFileEx::CFCMemFileEx (BYTE* lpBuffer,
							UINT nBufferSize,
							UINT nGrowBytes)
			:	BASE_CLASS(lpBuffer, nBufferSize, nGrowBytes)
{}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMemFileEx::Insert
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiImKjChFiCmJiBeBiDgGiBfLiDfOiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliInsPos	:_xZkqqHx_jBhNjDpMiClHiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lpBuff		:_xZkqqHx_jBhNjDpMiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliCount	:lpBuff_xZkqqHx_iCmMjBhNjDpMiClHiCoJiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 *                      Buff
 *                       _xZkqqHx_iEkA_xHqqkZx_
 *                       _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
 *         _xZkqqHx_jBhNjDpMiClHiCoJiDgGiBfLiDfOiEkAiChH_xHqqkZx_  _xZkqqHx_iChI_xHqqkZx_  _xZkqqHx_iChJiEkA_xHqqkZx_
 *                       _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
 *                       _xZkqqHx_iEkFiEjP_xHqqkZx_Count-_xZkqqHx_iEjPiEkH_xHqqkZx_
 *
 *
 *         _xZkqqHx_jBhNjDpMiOoIiPiHiBeC_xHqqkZx_
 *
 *                     InsPos              CurLen
 *                       _xZkqqHx_iBkL_xHqqkZx_                  _xZkqqHx_iBkL_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
 *         _xZkqqHx_jBhNjDpMjBePiEkAiCiB_xHqqkZx_  _xZkqqHx_iCiC_xHqqkZx_  _xZkqqHx_iCiD_xHqqkZx_  _xZkqqHx_iCiE_xHqqkZx_  _xZkqqHx_iCiF_xHqqkZx_  _xZkqqHx_iCiG_xHqqkZx_  _xZkqqHx_iCiHiEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
 *                       _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                            CurLen-InsPos
 *
 *
 *                     InsPos              CurLen
 *                       _xZkqqHx_iBkL_xHqqkZx_                  _xZkqqHx_iBkL_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
 *         _xZkqqHx_iNoMiLmGiCfAiEkAiCiB_xHqqkZx_  _xZkqqHx_iCiC_xHqqkZx_  _xZkqqHx_iCiD_xHqqkZx_  _xZkqqHx_iCiE_xHqqkZx_  _xZkqqHx_iCiF_xHqqkZx_  _xZkqqHx_iCiG_xHqqkZx_  _xZkqqHx_iCiHiEkAiChH_xHqqkZx_  _xZkqqHx_iChI_xHqqkZx_  _xZkqqHx_iChJiEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
 *                       _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                            CurLen-InsPos
 *
 *
 *                     InsPos   InsPos+Count
 *                       _xZkqqHx_iBkL_xHqqkZx_          _xZkqqHx_iBkL_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
 *         _xZkqqHx_iNoMiLmGiCfBiEkAiCiB_xHqqkZx_  _xZkqqHx_iCiC_xHqqkZx_  _xZkqqHx_iCiD_xHqqkZx_  _xZkqqHx_iCiE_xHqqkZx_  _xZkqqHx_iCiF_xHqqkZx_  _xZkqqHx_iCiD_xHqqkZx_  _xZkqqHx_iCiE_xHqqkZx_  _xZkqqHx_iCiF_xHqqkZx_  _xZkqqHx_iCiG_xHqqkZx_  _xZkqqHx_iCiHiEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
 *                                   _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                                       CurLen-InsPos
 *
 *                     InsPos
 *                       _xZkqqHx_iBkL_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
 *         _xZkqqHx_iNoMiLmGiCfCiEkAiCiB_xHqqkZx_  _xZkqqHx_iCiC_xHqqkZx_  _xZkqqHx_iChH_xHqqkZx_  _xZkqqHx_iChI_xHqqkZx_  _xZkqqHx_iChJ_xHqqkZx_  _xZkqqHx_iCiD_xHqqkZx_  _xZkqqHx_iCiE_xHqqkZx_  _xZkqqHx_iCiF_xHqqkZx_  _xZkqqHx_iCiG_xHqqkZx_  _xZkqqHx_iCiHiEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
 *                       _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                           Count
 *
 *
 *         _xZkqqHx_iCfAiBeEiMlLiNnNiImKjChFiCkKiInKjDkOiClHiCoJiPoKiNiHiBeC_xHqqkZx_
 *
 *                       InsPos    CurPos
 *                         _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *         _xZkqqHx_jBhNjDpMjBePiEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *                       InsPos                CurPos
 *                         _xZkqqHx_iBkL_xHqqkZx_                    _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *         _xZkqqHx_jBhNjDpMiMoDiEkA_xHqqkZx_        _xZkqqHx_iEkAiChH_xHqqkZx_  _xZkqqHx_iChI_xHqqkZx_  _xZkqqHx_iChJiEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *
 *         _xZkqqHx_iCfBiBeEiMlLiNnNiImKjChFiCkKiInKjDkOiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
 *
 *                       CurPos    InsPos
 *                         _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *         _xZkqqHx_jBhNjDpMjBePiEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *                       CurPos    InsPos
 *                         _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *         _xZkqqHx_jBhNjDpMiMoDiEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiChH_xHqqkZx_  _xZkqqHx_iChI_xHqqkZx_  _xZkqqHx_iChJiEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMemFileEx::Insert (flint fliInsPos, const void* lpBuff, flint fliCount)
{
	// _xZkqqHx_iDhMiDeDiDjDiDfOiCpAiLeMiJkPiBeC_xHqqkZx_
	const flint fliCurPos = BASE_CLASS::GetPosition();
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfEiDeDiDfJiCpAiLeMiJkPiBeC_xHqqkZx_
	const flint fliCurLen = BASE_CLASS::GetLength();

	// _xZkqqHx_jBhNjDpMiImKjChFiCkKiDhEiDeAiDeDiDiLiDfEiDeDiDfJiCpAjClEiCkGiCoJiPoKiNiHiCmNiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
	if (fliCurLen < fliInsPos)
		FFThrowMiscUnknown();

	// _xZkqqHx_iDhEiDeAiDeDiDiLiPeJjCfLiCmJiInKjDkOiBeC_xHqqkZx_
	BASE_CLASS::Seek(0, CFile::end);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiPeJjCfLiCmJiDgGiBfLiDfOiCpAiLeMjIfOiBeCiPoDjAhNiCmMiNoMiLmGiCfAiBeC_xHqqkZx_
	BASE_CLASS::Write(lpBuff, fliCount);

	if (fliCurLen != fliInsPos)
	//----- _xZkqqHx_jBhNjDpMiImKjChFiCkKjDhCjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiBiDiCiDiKiBfLiCpAiInKjDkOiBeCiPoDjAhNiCmMiNoMiLmGiCfBiBeC_xHqqkZx_
		memmove(m_lpBuffer + fliInsPos + fliCount, m_lpBuffer + fliInsPos, fliCurLen - fliInsPos);
		// _xZkqqHx_iDiBiDiCiDiKiBfLiCpAjDfNjBjHiBeCiPoDjAhNiCmMiNoMiLmGiCfCiBeC_xHqqkZx_
		memcpy(m_lpBuffer + fliInsPos, lpBuff, fliCount);
	}

	// _xZkqqHx_iDhMiDeDiDjDiDfOiCpAjGnPiClHiBeC_xHqqkZx_
	// _xZkqqHx_iMlDiCmMiDhMiDeDiDjDiDfOiCkKjBhNjDpMiImKjChFiCoGiCoIiMoDiCoLiCmJiCkAiCoJiPoKiNiHiCmNiBeBiDhMiDeDiDjDiDfOiCpAiInKjDkOiBeC_xHqqkZx_
	if (fliInsPos <= fliCurPos)
		BASE_CLASS::Seek(fliCurPos + fliCount, CFile::begin);
	else
		BASE_CLASS::Seek(fliCurPos, CFile::begin);
} // CFCMemFileEx::Insert.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMemFileEx::Alloc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHmMiIoGiCpAiKgNjFnLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nBytes	:_xZkqqHx_jHmMiIoGiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHmMiIoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	protected_xZkqqHx_iDiBiDjDiDgPiBfLiCpA_xHqqkZx_public_xZkqqHx_iCmJiClHiCoJiClNiCnPiDeJiBfLiDgPiBfLiDiJiDeDiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BYTE* CFCMemFileEx::Alloc (SIZE_T nBytes)
{
	return BASE_CLASS::Alloc(nBytes);
} // CFCMemFileEx::Alloc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMemFileEx::Free
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHmMiIoGiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpMem	:_xZkqqHx_jHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	protected_xZkqqHx_iDiBiDjDiDgPiBfLiCpA_xHqqkZx_public_xZkqqHx_iCmJiClHiCoJiClNiCnPiDeJiBfLiDgPiBfLiDiJiDeDiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMemFileEx::Free (BYTE* lpMem)
{
	BASE_CLASS::Free(lpMem);
} // CFCMemFileEx::Free.
