#ifndef __MfcClass_h
#define __MfcClass_h

//;----- <EXPORT TO SDK> -----;

interface IMpgMfcString
{
	virtual void	_MfcString (CString* pStr) = 0;
	virtual void	_MfcString (CString* pStr, LPCSTR lpsz) = 0;
	virtual int		_GetLength (const CString* pStr) = 0;
	virtual void	_Empty (CString* pStr) = 0;
	virtual LPCTSTR	_lpctstr (const CString* pStr) = 0;
	virtual const CString&	_Eq (CString* pStr, LPCSTR lpsz) = 0;
	virtual void	__MfcString (CString* pStr) = 0;
}; // interface IMpgMfcString.

interface IMpgMfcWnd
{
	virtual BOOL _Eq (const CWnd* pWnd, const CWnd* wnd) const = 0;
	virtual HWND _GetSafeHwnd (const CWnd* pWnd) const = 0;
	virtual DWORD _GetStyle (const CWnd* pWnd) const = 0;
	virtual DWORD _GetExStyle (const CWnd* pWnd) const = 0;
	virtual BOOL _ModifyStyle (CWnd* pWnd, DWORD dwRemove, DWORD dwAdd, UINT nFlags) = 0;
	virtual BOOL _ModifyStyleEx (CWnd* pWnd, DWORD dwRemove, DWORD dwAdd, UINT nFlags) = 0;
	virtual CWnd* _GetOwner (const CWnd* pWnd) const = 0;
	virtual void _SetOwner (CWnd* pWnd, CWnd* pOwnerWnd) = 0;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual CWnd* _FromHandle (HWND hWnd) const = 0;
	virtual CWnd* _FromHandlePermanent (HWND hWnd) const = 0;
	virtual void _DeleteTempMap () const = 0;
	virtual BOOL _Attach (CWnd* pWnd, HWND hWndNew) const = 0;
	virtual HWND _Detach (CWnd* pWnd) const = 0;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
}; // interface IMpgMfcWnd.

interface IMpgMfcDC
{
	virtual CDC* _New () const = 0;
	virtual void _Delete (CDC* pDC) const = 0;
	virtual HDC _HDC (const CDC* pDC) const = 0;
	virtual HDC _GetSafeHdc (const CDC* pDC) const = 0;
	virtual CWnd* _GetWindow (const CDC* pDC) const = 0;
	virtual CDC* _FromHandle (HDC hDC) const = 0;
	virtual void _DeleteTempMap () const = 0;
	virtual BOOL _Attach (CDC* pDC, HDC hDC) = 0;
	virtual HDC _Detach (CDC* pDC) = 0;
	virtual BOOL _IsPrinting (const CDC* pDC) const = 0;
	virtual CPen* _GetCurrentPen (const CDC* pDC) const = 0;
	virtual CBrush* _GetCurrentBrush (const CDC* pDC) const = 0;
	virtual CPalette* _GetCurrentPalette (const CDC* pDC) const = 0;
	virtual CFont* _GetCurrentFont (const CDC* pDC) const = 0;
	virtual CBitmap* _GetCurrentBitmap (const CDC* pDC) const = 0;
	virtual DWORD _GetLayout (const CDC* pDC) const = 0;
	virtual DWORD _SetLayout (CDC* pDC, DWORD dwLayout) = 0;
	virtual BOOL _CreateDC (CDC* pDC, LPCTSTR lpszDriverName, LPCTSTR lpszDeviceName, LPCTSTR lpszOutput, const void* lpInitData) = 0;
	virtual BOOL _CreateIC (CDC* pDC, LPCTSTR lpszDriverName, LPCTSTR lpszDeviceName, LPCTSTR lpszOutput, const void* lpInitData) = 0;
	virtual BOOL _CreateCompatibleDC (CDC* pDC, CDC* pDC2) = 0;
	virtual BOOL _DeleteDC (CDC* pDC) = 0;
	virtual int _GetDeviceCaps (const CDC* pDC, int nIndex) const = 0;
	virtual UINT _SetBoundsRect (CDC* pDC, LPCRECT lpRectBounds, UINT flags) = 0;
	virtual UINT _GetBoundsRect (CDC* pDC, LPRECT lpRectBounds, UINT flags) = 0;
	virtual BOOL _ResetDC (CDC* pDC, const DEVMODE* lpDevMode) = 0;
	virtual CPoint _GetBrushOrg (const CDC* pDC) const = 0;
	virtual CPoint _SetBrushOrg (CDC* pDC, int x, int y) = 0;
	virtual CPoint _SetBrushOrg (CDC* pDC, POINT point) = 0;
	virtual int _EnumObjects (CDC* pDC, int nObjectType, int (CALLBACK* lpfn) (LPVOID, LPARAM), LPARAM lpData) = 0;
	virtual CPen* _SelectObject (CDC* pDC, CPen* pPen) = 0;
	virtual CBrush* _SelectObject (CDC* pDC, CBrush* pBrush) = 0;
	virtual CBitmap* _SelectObject (CDC* pDC, CBitmap* pBitmap) = 0;
	virtual int _SelectObject (CDC* pDC, CRgn* pRgn) = 0;
	virtual CGdiObject* _SelectObject (CDC* pDC, CGdiObject* pObject) = 0;
	virtual COLORREF _GetNearestColor (const CDC* pDC, COLORREF crColor) const = 0;
	virtual CPalette* _SelectPalette (CDC* pDC, CPalette* pPalette, BOOL bForceBackground) = 0;
	virtual UINT _RealizePalette (CDC* pDC) = 0;
	virtual void _UpdateColors (CDC* pDC) = 0;
	virtual COLORREF _GetBkColor (const CDC* pDC) const = 0;
	virtual int _GetBkMode (const CDC* pDC) const = 0;
	virtual int _GetPolyFillMode (const CDC* pDC) const = 0;
	virtual int _GetROP2 (const CDC* pDC) const = 0;
	virtual int _GetStretchBltMode (const CDC* pDC) const = 0;
	virtual COLORREF _GetTextColor (const CDC* pDC) const = 0;
	virtual int _SetBkMode (CDC* pDC, int nBkMode) = 0;
	virtual int _SetPolyFillMode (CDC* pDC, int nPolyFillMode) = 0;
	virtual int _SetROP2 (CDC* pDC, int nDrawMode) = 0;
	virtual int _SetStretchBltMode (CDC* pDC, int nStretchMode) = 0;
	virtual BOOL _GetColorAdjustment (const CDC* pDC, LPCOLORADJUSTMENT lpColorAdjust) const = 0;
	virtual BOOL _SetColorAdjustment (CDC* pDC, const COLORADJUSTMENT* lpColorAdjust) = 0;
	virtual int _GetMapMode (const CDC* pDC) const = 0;
	virtual CPoint _GetViewportOrg (const CDC* pDC) const = 0;
	virtual CPoint _SetViewportOrg (CDC* pDC, POINT point) = 0;
	virtual CSize _GetViewportExt (const CDC* pDC) const = 0;
	virtual CSize _SetViewportExt (CDC* pDC, SIZE size) = 0;
	virtual CPoint _GetWindowOrg (const CDC* pDC) const = 0;
	virtual CPoint _SetWindowOrg (CDC* pDC, int x, int y) = 0;
	virtual CPoint _SetWindowOrg (CDC* pDC, POINT point) = 0;
	virtual CPoint _OffsetWindowOrg (CDC* pDC, int nWidth, int nHeight) = 0;
	virtual CSize _GetWindowExt (const CDC* pDC) const = 0;
	virtual CSize _SetWindowExt (CDC* pDC, SIZE size) = 0;
	virtual void _DPtoLP (const CDC* pDC, LPPOINT lpPoints, int nCount) const = 0;
	virtual void _DPtoLP (const CDC* pDC, LPRECT lpRect) const = 0;
	virtual void _DPtoLP (const CDC* pDC, LPSIZE lpSize) const = 0;
	virtual void _LPtoDP (const CDC* pDC, LPPOINT lpPoints, int nCount) const = 0;
	virtual void _LPtoDP (const CDC* pDC, LPRECT lpRect) const = 0;
	virtual void _LPtoDP (const CDC* pDC, LPSIZE lpSize) const = 0;
	virtual void _DPtoHIMETRIC (const CDC* pDC, LPSIZE lpSize) const = 0;
	virtual void _LPtoHIMETRIC (const CDC* pDC, LPSIZE lpSize) const = 0;
	virtual void _HIMETRICtoDP (const CDC* pDC, LPSIZE lpSize) const = 0;
	virtual void _HIMETRICtoLP (const CDC* pDC, LPSIZE lpSize) const = 0;
	virtual BOOL _FillRgn (CDC* pDC, CRgn* pRgn, CBrush* pBrush) = 0;
	virtual BOOL _FrameRgn (CDC* pDC, CRgn* pRgn, CBrush* pBrush, int nWidth, int nHeight) = 0;
	virtual BOOL _InvertRgn (CDC* pDC, CRgn* pRgn) = 0;
	virtual BOOL _PaintRgn (CDC* pDC, CRgn* pRgn) = 0;
	virtual BOOL _PtVisible (const CDC* pDC, POINT point) const = 0;
	virtual int _SelectClipRgn (CDC* pDC, CRgn* pRgn) = 0;
	virtual int _ExcludeClipRect (CDC* pDC, int x1, int y1, int x2, int y2) = 0;
	virtual int _ExcludeClipRect (CDC* pDC, LPCRECT lpRect) = 0;
	virtual int _ExcludeUpdateRgn (CDC* pDC, CWnd* pWnd) = 0;
	virtual int _IntersectClipRect (CDC* pDC, int x1, int y1, int x2, int y2) = 0;
	virtual int _IntersectClipRect (CDC* pDC, LPCRECT lpRect) = 0;
	virtual int _OffsetClipRgn (CDC* pDC, int x, int y) = 0;
	virtual int _OffsetClipRgn (CDC* pDC, SIZE size) = 0;
	virtual int _SelectClipRgn (CDC* pDC, CRgn* pRgn, int nMode) = 0;
	virtual CPoint _GetCurrentPosition (const CDC* pDC) const = 0;
	virtual CPoint _MoveTo (CDC* pDC, int x, int y) = 0;
	virtual CPoint _MoveTo (CDC* pDC, POINT point) = 0;
	virtual BOOL _LineTo (CDC* pDC, int x, int y) = 0;
	virtual BOOL _LineTo (CDC* pDC, POINT point) = 0;
	virtual BOOL _Arc (CDC* pDC, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) = 0;
	virtual BOOL _Arc (CDC* pDC, LPCRECT lpRect, POINT ptStart, POINT ptEnd) = 0;
	virtual BOOL _Polyline (CDC* pDC, LPPOINT lpPoints, int nCount) = 0;
	virtual BOOL _AngleArc (CDC* pDC, int x, int y, int nRadius, float fStartAngle, float fSweepAngle) = 0;
	virtual BOOL _ArcTo (CDC* pDC, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) = 0;
	virtual BOOL _ArcTo (CDC* pDC, LPCRECT lpRect, POINT ptStart, POINT ptEnd) = 0;
	virtual int _GetArcDirection (const CDC* pDC) const = 0;
	virtual int _SetArcDirection (CDC* pDC, int nArcDirection) = 0;
	virtual BOOL _PolyDraw (CDC* pDC, const POINT* lpPoints, const BYTE* lpTypes, int nCount) = 0;
	virtual BOOL _PolylineTo (CDC* pDC, const POINT* lpPoints, int nCount) = 0;
	virtual BOOL _PolyPolyline (CDC* pDC, const POINT* lpPoints, const DWORD* lpPolyPoints, int nCount) = 0;
	virtual BOOL _PolyBezier (CDC* pDC, const POINT* lpPoints, int nCount) = 0;
	virtual BOOL _PolyBezierTo (CDC* pDC, const POINT* lpPoints, int nCount) = 0;
	virtual void _FillRect (CDC* pDC, LPCRECT lpRect, CBrush* pBrush) = 0;
	virtual void _FrameRect (CDC* pDC, LPCRECT lpRect, CBrush* pBrush) = 0;
	virtual void _InvertRect (CDC* pDC, LPCRECT lpRect) = 0;
	virtual BOOL _DrawIcon (CDC* pDC, int x, int y, HICON hIcon) = 0;
	virtual BOOL _DrawIcon (CDC* pDC, POINT point, HICON hIcon) = 0;
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, HBITMAP hBitmap, UINT nFlags, HBRUSH hBrush) = 0;
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, CBitmap* pBitmap, UINT nFlags, CBrush* pBrush) = 0;
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, HICON hIcon, UINT nFlags, HBRUSH hBrush) = 0;
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, HICON hIcon, UINT nFlags, CBrush* pBrush) = 0;
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, LPCTSTR lpszText, UINT nFlags, BOOL bPrefixText, int nTextLen, HBRUSH hBrush) = 0;
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, LPCTSTR lpszText, UINT nFlags, BOOL bPrefixText, int nTextLen, CBrush* pBrush) = 0;
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, DRAWSTATEPROC lpDrawProc, LPARAM lData, UINT nFlags, HBRUSH hBrush) = 0;
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, DRAWSTATEPROC lpDrawProc, LPARAM lData, UINT nFlags, CBrush* pBrush) = 0;
	virtual BOOL _Chord (CDC* pDC, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) = 0;
	virtual BOOL _Chord (CDC* pDC, LPCRECT lpRect, POINT ptStart, POINT ptEnd) = 0;
	virtual void _DrawFocusRect (CDC* pDC, LPCRECT lpRect) = 0;
	virtual BOOL _Ellipse (CDC* pDC, int x1, int y1, int x2, int y2) = 0;
	virtual BOOL _Ellipse (CDC* pDC, LPCRECT lpRect) = 0;
	virtual BOOL _Pie (CDC* pDC, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) = 0;
	virtual BOOL _Pie (CDC* pDC, LPCRECT lpRect, POINT ptStart, POINT ptEnd) = 0;
	virtual BOOL _Polygon (CDC* pDC, LPPOINT lpPoints, int nCount) = 0;
	virtual BOOL _PolyPolygon (CDC* pDC, LPPOINT lpPoints, LPINT lpPolyCounts, int nCount) = 0;
	virtual BOOL _Rectangle (CDC* pDC, int x1, int y1, int x2, int y2) = 0;
	virtual BOOL _Rectangle (CDC* pDC, LPCRECT lpRect) = 0;
	virtual BOOL _RoundRect (CDC* pDC, int x1, int y1, int x2, int y2, int x3, int y3) = 0;
	virtual BOOL _RoundRect (CDC* pDC, LPCRECT lpRect, POINT point) = 0;
	virtual BOOL _PatBlt (CDC* pDC, int x, int y, int nWidth, int nHeight, DWORD dwRop) = 0;
	virtual BOOL _BitBlt (CDC* pDC, int x, int y, int nWidth, int nHeight, CDC* pSrcDC, int xSrc, int ySrc, DWORD dwRop) = 0;
	virtual BOOL _StretchBlt (CDC* pDC, int x, int y, int nWidth, int nHeight, CDC* pSrcDC, int xSrc, int ySrc, int nSrcWidth, int nSrcHeight, DWORD dwRop) = 0;
	virtual COLORREF _GetPixel (const CDC* pDC, int x, int y) const = 0;
	virtual COLORREF _GetPixel (const CDC* pDC, POINT point) const = 0;
	virtual COLORREF _SetPixel (CDC* pDC, int x, int y, COLORREF crColor) = 0;
	virtual COLORREF _SetPixel (CDC* pDC, POINT point, COLORREF crColor) = 0;
	virtual BOOL _FloodFill (CDC* pDC, int x, int y, COLORREF crColor) = 0;
	virtual BOOL _ExtFloodFill (CDC* pDC, int x, int y, COLORREF crColor, UINT nFillType) = 0;
	virtual BOOL _MaskBlt (CDC* pDC, int x, int y, int nWidth, int nHeight, CDC* pSrcDC, int xSrc, int ySrc, CBitmap& maskBitmap, int xMask, int yMask, DWORD dwRop) = 0;
	virtual BOOL _PlgBlt (CDC* pDC, LPPOINT lpPoint, CDC* pSrcDC, int xSrc, int ySrc, int nWidth, int nHeight, CBitmap& maskBitmap, int xMask, int yMask) = 0;
	virtual BOOL _SetPixelV (CDC* pDC, int x, int y, COLORREF crColor) = 0;
	virtual BOOL _SetPixelV (CDC* pDC, POINT point, COLORREF crColor) = 0;
	virtual BOOL _TextOut (CDC* pDC, int x, int y, const CString& str) = 0;
	virtual BOOL _ExtTextOut (CDC* pDC, int x, int y, UINT nOptions, LPCRECT lpRect, const CString& str, LPINT lpDxWidths) = 0;
	virtual CSize _TabbedTextOut (CDC* pDC, int x, int y, const CString& str, int nTabPositions, LPINT lpnTabStopPositions, int nTabOrigin) = 0;
	virtual int _DrawText (CDC* pDC, const CString& str, LPRECT lpRect, UINT nFormat) = 0;
	virtual CSize _GetTextExtent (const CDC* pDC, LPCTSTR lpszString, int nCount) const = 0;
	virtual CSize _GetTextExtent (const CDC* pDC, const CString& str) const = 0;
	virtual CSize _GetOutputTextExtent (const CDC* pDC, LPCTSTR lpszString, int nCount) const = 0;
	virtual CSize _GetOutputTextExtent (const CDC* pDC, const CString& str) const = 0;
	virtual CSize _GetTabbedTextExtent (const CDC* pDC, LPCTSTR lpszString, int nCount, int nTabPositions, LPINT lpnTabStopPositions) const = 0;
	virtual CSize _GetTabbedTextExtent (const CDC* pDC, const CString& str, int nTabPositions, LPINT lpnTabStopPositions) const = 0;
	virtual CSize _GetOutputTabbedTextExtent (const CDC* pDC, LPCTSTR lpszString, int nCount, int nTabPositions, LPINT lpnTabStopPositions) const = 0;
	virtual CSize _GetOutputTabbedTextExtent (const CDC* pDC, const CString& str, int nTabPositions, LPINT lpnTabStopPositions) const = 0;
	virtual UINT _GetTextAlign (const CDC* pDC) const = 0;
	virtual UINT _SetTextAlign (CDC* pDC, UINT nFlags) = 0;
	virtual int _GetTextFace (const CDC* pDC, int nCount, LPTSTR lpszFacename) const = 0;
	virtual int _GetTextFace (const CDC* pDC, CString& rString) const = 0;
	virtual BOOL _GetTextMetrics (const CDC* pDC, LPTEXTMETRIC lpMetrics) const = 0;
	virtual BOOL _GetOutputTextMetrics (const CDC* pDC, LPTEXTMETRIC lpMetrics) const = 0;
	virtual int _SetTextJustification (CDC* pDC, int nBreakExtra, int nBreakCount) = 0;
	virtual int _GetTextCharacterExtra (const CDC* pDC) const = 0;
	virtual int _SetTextCharacterExtra (CDC* pDC, int nCharExtra) = 0;
	virtual BOOL _DrawEdge (CDC* pDC, LPRECT lpRect, UINT nEdge, UINT nFlags) = 0;
	virtual BOOL _DrawFrameControl (CDC* pDC, LPRECT lpRect, UINT nType, UINT nState) = 0;
	virtual BOOL _ScrollDC (CDC* pDC, int dx, int dy, LPCRECT lpRectScroll, LPCRECT lpRectClip, CRgn* pRgnUpdate, LPRECT lpRectUpdate) = 0;
	virtual BOOL _GetCharWidth (const CDC* pDC, UINT nFirstChar, UINT nLastChar, LPINT lpBuffer) const = 0;
	virtual BOOL _GetOutputCharWidth (const CDC* pDC, UINT nFirstChar, UINT nLastChar, LPINT lpBuffer) const = 0;
	virtual DWORD _SetMapperFlags (CDC* pDC, DWORD dwFlag) = 0;
	virtual CSize _GetAspectRatioFilter (const CDC* pDC) const = 0;
	virtual BOOL _GetCharABCWidths (const CDC* pDC, UINT nFirstChar, UINT nLastChar, LPABC lpabc) const = 0;
	virtual DWORD _GetFontData (const CDC* pDC, DWORD dwTable, DWORD dwOffset, LPVOID lpData, DWORD cbData) const = 0;
	virtual int _GetKerningPairs (const CDC* pDC, int nPairs, LPKERNINGPAIR lpkrnpair) const = 0;
	virtual UINT _GetOutlineTextMetrics (const CDC* pDC, UINT cbData, LPOUTLINETEXTMETRIC lpotm) const = 0;
	virtual DWORD _GetGlyphOutline (const CDC* pDC, UINT nChar, UINT nFormat, LPGLYPHMETRICS lpgm, DWORD cbBuffer, LPVOID lpBuffer, const MAT2* lpmat2) const = 0;
	virtual BOOL _GetCharABCWidths (const CDC* pDC, UINT nFirstChar, UINT nLastChar, LPABCFLOAT lpABCF) const = 0;
	virtual BOOL _GetCharWidth (const CDC* pDC, UINT nFirstChar, UINT nLastChar, float* lpFloatBuffer) const = 0;
	virtual int _Escape (CDC* pDC, int nEscape, int nInputSize, LPCSTR lpszInputData, int nOutputSize, LPSTR lpszOutputData) = 0;
	virtual int _DrawEscape (CDC* pDC, int nEscape, int nInputSize, LPCSTR lpszInputData) = 0;
	virtual int _StartDoc (CDC* pDC, LPCTSTR lpszDocName) = 0;
	virtual int _StartDoc (CDC* pDC, LPDOCINFO lpDocInfo) = 0;
	virtual int _StartPage (CDC* pDC) = 0;
	virtual int _EndPage (CDC* pDC) = 0;
	virtual int _SetAbortProc (CDC* pDC, BOOL (CALLBACK* lpfn) (HDC, int)) = 0;
	virtual int _AbortDoc (CDC* pDC) = 0;
	virtual int _EndDoc (CDC* pDC) = 0;
	virtual BOOL _PlayMetaFile (CDC* pDC, HMETAFILE hMF) = 0;
	virtual BOOL _PlayMetaFile (CDC* pDC, HENHMETAFILE hEnhMetaFile, LPCRECT lpBounds) = 0;
	virtual BOOL _AddMetaFileComment (CDC* pDC, UINT nDataSize, const BYTE* pCommentData) = 0;
	virtual BOOL _AbortPath (CDC* pDC) = 0;
	virtual BOOL _BeginPath (CDC* pDC) = 0;
	virtual BOOL _CloseFigure (CDC* pDC) = 0;
	virtual BOOL _EndPath (CDC* pDC) = 0;
	virtual BOOL _FillPath (CDC* pDC) = 0;
	virtual BOOL _FlattenPath (CDC* pDC) = 0;
	virtual BOOL _StrokeAndFillPath (CDC* pDC) = 0;
	virtual BOOL _StrokePath (CDC* pDC) = 0;
	virtual BOOL _WidenPath (CDC* pDC) = 0;
	virtual float _GetMiterLimit (const CDC* pDC) const = 0;
	virtual BOOL _SetMiterLimit (CDC* pDC, float fMiterLimit) = 0;
	virtual int _GetPath (const CDC* pDC, LPPOINT lpPoints, LPBYTE lpTypes, int nCount) const = 0;
	virtual BOOL _SelectClipPath (CDC* pDC, int nMode) = 0;
	virtual CBrush* _GetHalftoneBrush () const = 0;
	virtual void _DrawDragRect (CDC* pDC, LPCRECT lpRect, SIZE size, LPCRECT lpRectLast, SIZE sizeLast, CBrush* pBrush, CBrush* pBrushLast) = 0;
	virtual void _FillSolidRect (CDC* pDC, LPCRECT lpRect, COLORREF clr) = 0;
	virtual void _FillSolidRect (CDC* pDC, int x, int y, int cx, int cy, COLORREF clr) = 0;
	virtual void _Draw3dRect (CDC* pDC, LPCRECT lpRect, COLORREF clrTopLeft, COLORREF clrBottomRight) = 0;
	virtual void _Draw3dRect (CDC* pDC, int x, int y, int cx, int cy, COLORREF clrTopLeft, COLORREF clrBottomRight) = 0;
	virtual HGDIOBJ _SelectObject (CDC* pDC, HGDIOBJ h) = 0;
}; // interface IMpgMfcDC.

interface IMpgMfcBrush
{
	virtual CBrush* _New () const = 0;
	virtual void _Delete (CBrush* pSrc) const = 0;
	virtual CBrush* _FromHandle (HBRUSH hBrush) const = 0;
	virtual BOOL _CreateSolidBrush (CBrush* pSrc, COLORREF crColor) = 0;
	virtual BOOL _CreateHatchBrush (CBrush* pSrc, int nIndex, COLORREF crColor) = 0;
	virtual BOOL _CreateBrushIndirect (CBrush* pSrc, const LOGBRUSH* lpLogBrush) = 0;
	virtual BOOL _CreatePatternBrush (CBrush* pSrc, CBitmap* pBitmap) = 0;
	virtual BOOL _CreateDIBPatternBrush (CBrush* pSrc, HGLOBAL hPackedDIB, UINT nUsage) = 0;
	virtual BOOL _CreateDIBPatternBrush (CBrush* pSrc, const void* lpPackedDIB, UINT nUsage) = 0;
	virtual BOOL _CreateSysColorBrush (CBrush* pSrc, int nIndex) = 0;
	virtual HBRUSH _HBRUSH (const CBrush* pSrc) const = 0;
	virtual int _GetLogBrush (CBrush* pSrc, LOGBRUSH* pLogBrush) = 0;
}; // interface IMpgMfcBrush.

interface IMpgMfcFont
{
	virtual CFont* _New () const = 0;
	virtual void _Delete (CFont* pSrc) const = 0;
	virtual CFont* _FromHandle (HFONT hFont) const = 0;
	virtual BOOL _CreateFontIndirect (CFont* pSrc, const LOGFONT* lpLogFont) = 0;
	virtual BOOL _CreateFont (CFont* pSrc, int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight, BYTE bItalic, BYTE bUnderline, BYTE cStrikeOut, BYTE nCharSet, BYTE nOutPrecision, BYTE nClipPrecision, BYTE nQuality, BYTE nPitchAndFamily, LPCTSTR lpszFacename) = 0;
	virtual BOOL _CreatePointFont (CFont* pSrc, int nPointSize, LPCTSTR lpszFaceName, CDC* pDC = NULL) = 0;
	virtual BOOL _CreatePointFontIndirect (CFont* pSrc, const LOGFONT* lpLogFont, CDC* pDC = NULL) = 0;
	virtual HFONT _HFONT (const CFont* pSrc) const = 0;
	virtual int _GetLogFont (CFont* pSrc, LOGFONT* pLogFont) = 0;
}; // interface IMpgMfcFont.

interface IMpgMfcPalette
{
	virtual CPalette* _New () const = 0;
	virtual void _Delete (CPalette* pSrc) const = 0;
	virtual CPalette* _FromHandle (HPALETTE hPalette) const = 0;
	virtual BOOL _CreatePalette (CPalette* pSrc, LPLOGPALETTE lpLogPalette) = 0;
	virtual BOOL _CreateHalftonePalette (CPalette* pSrc, CDC* pDC) = 0;
	virtual HPALETTE _HPALETTE (const CPalette* pSrc) const = 0;
	virtual int _GetEntryCount (CPalette* pSrc) = 0;
	virtual UINT _GetPaletteEntries (const CPalette* pSrc, UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors) const = 0;
	virtual UINT _SetPaletteEntries (CPalette* pSrc, UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors) = 0;
	virtual void _AnimatePalette (CPalette* pSrc, UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors) = 0;
	virtual UINT _GetNearestPaletteIndex (const CPalette* pSrc, COLORREF crColor) const = 0;
	virtual BOOL _ResizePalette (CPalette* pSrc, UINT nNumEntries) = 0;
}; // interface IMpgMfcPalette.

interface IMpgMfcPen
{
	virtual CPen* _New () const = 0;
	virtual void _Delete (CPen* pSrc) const = 0;
	virtual CPen* _FromHandle (HPEN hPen) const = 0;
	virtual BOOL _CreatePen (CPen* pSrc, int nPenStyle, int nWidth, COLORREF crColor) = 0;
	virtual BOOL _CreatePen (CPen* pSrc, int nPenStyle, int nWidth, const LOGBRUSH* pLogBrush, int nStyleCount = 0, const DWORD* lpStyle = NULL) = 0;
	virtual BOOL _CreatePenIndirect (CPen* pSrc, LPLOGPEN lpLogPen) = 0;
	virtual HPEN _HPEN (const CPen* pSrc) const = 0;
	virtual int _GetLogPen (CPen* pSrc, LOGPEN* pLogPen) = 0;
	virtual int _GetExtLogPen (CPen* pSrc, EXTLOGPEN* pLogPen) = 0;
}; // interface IMpgMfcPen.

interface IMpgMfcRgn
{
	virtual CRgn* _New () const = 0;
	virtual void _Delete (CRgn* pSrc) const = 0;
	virtual CRgn* _FromHandle (HRGN hRgn) const = 0;
	virtual HRGN _HRGN (const CRgn* pSrc) const = 0;
	virtual BOOL _CreateRectRgn (CRgn* pSrc, int x1, int y1, int x2, int y2) = 0;
	virtual BOOL _CreateRectRgnIndirect (CRgn* pSrc, LPCRECT lpRect) = 0;
	virtual BOOL _CreateEllipticRgn (CRgn* pSrc, int x1, int y1, int x2, int y2) = 0;
	virtual BOOL _CreateEllipticRgnIndirect (CRgn* pSrc, LPCRECT lpRect) = 0;
	virtual BOOL _CreatePolygonRgn (CRgn* pSrc, LPPOINT lpPoints, int nCount, int nMode) = 0;
	virtual BOOL _CreatePolyPolygonRgn (CRgn* pSrc, LPPOINT lpPoints, LPINT lpPolyCounts, int nCount, int nPolyFillMode) = 0;
	virtual BOOL _CreateRoundRectRgn (CRgn* pSrc, int x1, int y1, int x2, int y2, int x3, int y3) = 0;
	virtual BOOL _CreateFromPath (CRgn* pSrc, CDC* pDC) = 0;
	virtual BOOL _CreateFromData (CRgn* pSrc, const XFORM* lpXForm, int nCount, const RGNDATA* pRgnData) = 0;
	virtual void _SetRectRgn (CRgn* pSrc, int x1, int y1, int x2, int y2) = 0;
	virtual void _SetRectRgn (CRgn* pSrc, LPCRECT lpRect) = 0;
	virtual int _CombineRgn (CRgn* pSrc, CRgn* pRgn1, CRgn* pRgn2, int nCombineMode) = 0;
	virtual int _CopyRgn (CRgn* pSrc, CRgn* pRgnSrc) = 0;
	virtual BOOL _EqualRgn (const CRgn* pSrc, CRgn* pRgn) const = 0;
	virtual int _OffsetRgn (CRgn* pSrc, int x, int y) = 0;
	virtual int _OffsetRgn (CRgn* pSrc, POINT point) = 0;
	virtual int _GetRgnBox (const CRgn* pSrc, LPRECT lpRect) const = 0;
	virtual BOOL _PtInRegion (const CRgn* pSrc, int x, int y) const = 0;
	virtual BOOL _PtInRegion (const CRgn* pSrc, POINT point) const = 0;
	virtual BOOL _RectInRegion (const CRgn* pSrc, LPCRECT lpRect) const = 0;
	virtual int _GetRegionData (const CRgn* pSrc, LPRGNDATA lpRgnData, int nCount) const = 0;
}; // interface IMpgMfcRgn.

interface IMpgMfcBitmap
{
	virtual CBitmap* _New () const = 0;
	virtual void _Delete (CBitmap* pSrc) const = 0;
	virtual CBitmap* _FromHandle (HBITMAP hBitmap) const = 0;
	virtual BOOL _LoadBitmap (CBitmap* pSrc, LPCTSTR lpszResourceName) = 0;
	virtual BOOL _LoadBitmap (CBitmap* pSrc, UINT nIDResource) = 0;
	virtual BOOL _LoadOEMBitmap (CBitmap* pSrc, UINT nIDBitmap) = 0;
	virtual BOOL _LoadMappedBitmap (CBitmap* pSrc, UINT nIDBitmap, UINT nFlags = 0, LPCOLORMAP lpColorMap = NULL, int nMapSize = 0) = 0;
	virtual BOOL _CreateBitmap (CBitmap* pSrc, int nWidth, int nHeight, UINT nPlanes, UINT nBitcount, const void* lpBits) = 0;
	virtual BOOL _CreateBitmapIndirect (CBitmap* pSrc, LPBITMAP lpBitmap) = 0;
	virtual BOOL _CreateCompatibleBitmap (CBitmap* pSrc, CDC* pDC, int nWidth, int nHeight) = 0;
	virtual BOOL _CreateDiscardableBitmap (CBitmap* pSrc, CDC* pDC, int nWidth, int nHeight) = 0;
	virtual HBITMAP _HBITMAP (const CBitmap* pSrc) const = 0;
	virtual int _GetBitmap (CBitmap* pSrc, BITMAP* pBitMap) = 0;
	virtual DWORD _SetBitmapBits (CBitmap* pSrc, DWORD dwCount, const void* lpBits) = 0;
	virtual DWORD _GetBitmapBits (const CBitmap* pSrc, DWORD dwCount, LPVOID lpBits) const = 0;
	virtual CSize _SetBitmapDimension (CBitmap* pSrc, int nWidth, int nHeight) = 0;
	virtual CSize _GetBitmapDimension (const CBitmap* pSrc) const = 0;
}; // interface IMpgMfcBitmap.

interface IMpgMfcGdiObject
{
	virtual HGDIOBJ _HGDIOBJ (const CGdiObject* pSrc) const = 0;
	virtual HGDIOBJ _GetSafeHandle (const CGdiObject* pSrc) const = 0;
	virtual CGdiObject* _FromHandle (HGDIOBJ hObject) const = 0;
	virtual void _DeleteTempMap () const = 0;
	virtual BOOL _Attach (CGdiObject* pSrc, HGDIOBJ hObject) = 0;
	virtual HGDIOBJ _Detach (CGdiObject* pSrc) = 0;
	virtual BOOL _DeleteObject (CGdiObject* pSrc) = 0;
	virtual int _GetObject (const CGdiObject* pSrc, int nCount, LPVOID lpObject) const = 0;
	virtual UINT _GetObjectType (const CGdiObject* pSrc) const = 0;
	virtual BOOL _CreateStockObject (CGdiObject* pSrc, int nIndex) = 0;
	virtual BOOL _UnrealizeObject (CGdiObject* pSrc) = 0;
	virtual BOOL _Eq (const CGdiObject* pSrc, const CGdiObject& obj) const = 0;
}; // interface IMpgMfcGdiObject.

interface IMpgMfcWaitCursor
{
	virtual CWaitCursor* _New () const = 0;
	virtual void _Delete (CWaitCursor* pSrc) const = 0;
	virtual void _Restore (CWaitCursor* pSrc) = 0;
}; // interface IMpgMfcWaitCursor.

interface IMpgMfcClass
{
	virtual IMpgMfcString*	MfcStringI () = 0;
	virtual IMpgMfcWnd*		MfcWndI () = 0;
	virtual IMpgMfcDC*		MfcDCI () = 0;
	virtual IMpgMfcBrush*	MfcBrushI () = 0;
	virtual IMpgMfcFont*	MfcFontI () = 0;
	virtual IMpgMfcPalette*	MfcPaletteI () = 0;
	virtual IMpgMfcPen*		MfcPenI () = 0;
	virtual IMpgMfcRgn*		MfcRgnI () = 0;
	virtual IMpgMfcBitmap*		MfcBitmapI () = 0;
	virtual IMpgMfcGdiObject*	MfcGdiObjectI () = 0;
	virtual IMpgMfcWaitCursor*	MfcWaitCursorI () = 0;
}; // interface IMpgMfcClass.

//;----- </EXPORT TO SDK> -----;

interface FCIMfcString : public IMpgMfcString
{
	virtual void	_MfcString (CString* pStr)
		{
			new ((void*)pStr) CString();
		}
	virtual void	_MfcString (CString* pStr, LPCSTR lpsz)
		{
			new ((void*)pStr) CString(lpsz);
		}
	virtual int		_GetLength (const CString* pStr)
		{
			return pStr->GetLength();
		}
	virtual void	_Empty (CString* pStr)
		{
			pStr->Empty();
		}
	virtual LPCTSTR	_lpctstr (const CString* pStr)
		{
			return (LPCTSTR)(*pStr);
		}
	virtual const CString&	_Eq (CString* pStr, LPCSTR lpsz)
		{
			return (*pStr = lpsz);
		}
	virtual void	__MfcString (CString* pStr)
		{
			pStr->~CString();
		}
}; // interface FCIMfcString.

interface FCIMfcWnd : IMpgMfcWnd
{
	virtual BOOL _Eq (const CWnd* pWnd, const CWnd* wnd) const
		{
			return (*pWnd == *wnd);
		}
	virtual HWND _GetSafeHwnd (const CWnd* pWnd) const
		{
			return pWnd->GetSafeHwnd();
		}
	virtual DWORD _GetStyle (const CWnd* pWnd) const
		{
			return pWnd->GetStyle();
		}
	virtual DWORD _GetExStyle (const CWnd* pWnd) const
		{
			return pWnd->GetExStyle();
		}
	virtual BOOL _ModifyStyle (CWnd* pWnd, DWORD dwRemove, DWORD dwAdd, UINT nFlags)
		{
			return pWnd->ModifyStyle(dwRemove, dwAdd, nFlags);
		}
	virtual BOOL _ModifyStyleEx (CWnd* pWnd, DWORD dwRemove, DWORD dwAdd, UINT nFlags)
		{
			return pWnd->ModifyStyleEx(dwRemove, dwAdd, nFlags);
		}
	virtual CWnd* _GetOwner (const CWnd* pWnd) const
		{
			return pWnd->GetOwner();
		}
	virtual void _SetOwner (CWnd* pWnd, CWnd* pOwnerWnd)
		{
			pWnd->SetOwner(pOwnerWnd);
		}
	virtual CWnd* _FromHandle (HWND hWnd) const
		{
			return CWnd::FromHandle(hWnd);
		}
	virtual CWnd* _FromHandlePermanent (HWND hWnd) const
		{
			return CWnd::FromHandlePermanent(hWnd);
		}
	virtual void _DeleteTempMap () const
		{
			CWnd::DeleteTempMap();
		}
	virtual BOOL _Attach (CWnd* pWnd, HWND hWndNew) const
		{
			return pWnd->Attach(hWndNew);
		}
	virtual HWND _Detach (CWnd* pWnd) const
		{
			return pWnd->Detach();
		}
}; // interface FCIMfcWnd.

interface FCIMfcDC : IMpgMfcDC
{
	virtual CDC* _New () const
		{
			return new CDC();
		}
	virtual void _Delete (CDC* pDC) const
		{
			delete pDC;
		}
	virtual HDC _HDC (const CDC* pDC) const
		{
			return HDC(*pDC);
		}
	virtual HDC _GetSafeHdc (const CDC* pDC) const
		{
			return pDC->GetSafeHdc();
		}
	virtual CWnd* _GetWindow (const CDC* pDC) const
		{
			return pDC->GetWindow();
		}
	virtual CDC* _FromHandle (HDC hDC) const
		{
			return CDC::FromHandle(hDC);
		}
	virtual void _DeleteTempMap () const
		{
			CDC::DeleteTempMap();
		}
	virtual BOOL _Attach (CDC* pDC, HDC hDC)
		{
			return pDC->Attach(hDC);
		}
	virtual HDC _Detach (CDC* pDC)
		{
			return pDC->Detach();
		}
	virtual BOOL _IsPrinting (const CDC* pDC) const
		{
			return pDC->IsPrinting();
		}
	virtual CPen* _GetCurrentPen (const CDC* pDC) const
		{
			return pDC->GetCurrentPen();
		}
	virtual CBrush* _GetCurrentBrush (const CDC* pDC) const
		{
			return pDC->GetCurrentBrush();
		}
	virtual CPalette* _GetCurrentPalette (const CDC* pDC) const
		{
			return pDC->GetCurrentPalette();
		}
	virtual CFont* _GetCurrentFont (const CDC* pDC) const
		{
			return pDC->GetCurrentFont();
		}
	virtual CBitmap* _GetCurrentBitmap (const CDC* pDC) const
		{
			return pDC->GetCurrentBitmap();
		}
	virtual DWORD _GetLayout (const CDC* pDC) const
		{
			return pDC->GetLayout();
		}
	virtual DWORD _SetLayout (CDC* pDC, DWORD dwLayout)
		{
			return pDC->SetLayout(dwLayout);
		}
	virtual BOOL _CreateDC (CDC* pDC, LPCTSTR lpszDriverName, LPCTSTR lpszDeviceName, LPCTSTR lpszOutput, const void* lpInitData)
		{
			return pDC->CreateDC(lpszDriverName, lpszDeviceName, lpszOutput, lpInitData);
		}
	virtual BOOL _CreateIC (CDC* pDC, LPCTSTR lpszDriverName, LPCTSTR lpszDeviceName, LPCTSTR lpszOutput, const void* lpInitData)
		{
			return pDC->CreateIC(lpszDriverName, lpszDeviceName, lpszOutput, lpInitData);
		}
	virtual BOOL _CreateCompatibleDC (CDC* pDC, CDC* pDC2)
		{
			return pDC->CreateCompatibleDC(pDC2);
		}
	virtual BOOL _DeleteDC (CDC* pDC)
		{
			return pDC->DeleteDC();
		}
	virtual int _GetDeviceCaps (const CDC* pDC, int nIndex) const
		{
			return pDC->GetDeviceCaps(nIndex);
		}
	virtual UINT _SetBoundsRect (CDC* pDC, LPCRECT lpRectBounds, UINT flags)
		{
			return pDC->SetBoundsRect(lpRectBounds, flags);
		}
	virtual UINT _GetBoundsRect (CDC* pDC, LPRECT lpRectBounds, UINT flags)
		{
			return pDC->GetBoundsRect(lpRectBounds, flags);
		}
	virtual BOOL _ResetDC (CDC* pDC, const DEVMODE* lpDevMode)
		{
			return pDC->ResetDC(lpDevMode);
		}
	virtual CPoint _GetBrushOrg (const CDC* pDC) const
		{
			return pDC->GetBrushOrg();
		}
	virtual CPoint _SetBrushOrg (CDC* pDC, int x, int y)
		{
			return pDC->SetBrushOrg(x, y);
		}
	virtual CPoint _SetBrushOrg (CDC* pDC, POINT point)
		{
			return pDC->SetBrushOrg(point);
		}
	virtual int _EnumObjects (CDC* pDC, int nObjectType, int (CALLBACK* lpfn) (LPVOID, LPARAM), LPARAM lpData)
		{
			return pDC->EnumObjects(nObjectType, lpfn, lpData);
		}
	virtual CPen* _SelectObject (CDC* pDC, CPen* pPen)
		{
			return pDC->SelectObject(pPen);
		}
	virtual CBrush* _SelectObject (CDC* pDC, CBrush* pBrush)
		{
			return pDC->SelectObject(pBrush);
		}
	virtual CBitmap* _SelectObject (CDC* pDC, CBitmap* pBitmap)
		{
			return pDC->SelectObject(pBitmap);
		}
	virtual int _SelectObject (CDC* pDC, CRgn* pRgn)
		{
			return pDC->SelectObject(pRgn);
		}
	virtual CGdiObject* _SelectObject (CDC* pDC, CGdiObject* pObject)
		{
			return pDC->SelectObject(pObject);
		}
	virtual COLORREF _GetNearestColor (const CDC* pDC, COLORREF crColor) const
		{
			return pDC->GetNearestColor(crColor);
		}
	virtual CPalette* _SelectPalette (CDC* pDC, CPalette* pPalette, BOOL bForceBackground)
		{
			return pDC->SelectPalette(pPalette, bForceBackground);
		}
	virtual UINT _RealizePalette (CDC* pDC)
		{
			return pDC->RealizePalette();
		}
	virtual void _UpdateColors (CDC* pDC)
		{
			pDC->UpdateColors();
		}
	virtual COLORREF _GetBkColor (const CDC* pDC) const
		{
			return pDC->GetBkColor();
		}
	virtual int _GetBkMode (const CDC* pDC) const
		{
			return pDC->GetBkMode();
		}
	virtual int _GetPolyFillMode (const CDC* pDC) const
		{
			return pDC->GetPolyFillMode();
		}
	virtual int _GetROP2 (const CDC* pDC) const
		{
			return pDC->GetROP2();
		}
	virtual int _GetStretchBltMode (const CDC* pDC) const
		{
			return pDC->GetStretchBltMode();
		}
	virtual COLORREF _GetTextColor (const CDC* pDC) const
		{
			return pDC->GetTextColor();
		}
	virtual int _SetBkMode (CDC* pDC, int nBkMode)
		{
			return pDC->SetBkMode(nBkMode);
		}
	virtual int _SetPolyFillMode (CDC* pDC, int nPolyFillMode)
		{
			return pDC->SetPolyFillMode(nPolyFillMode);
		}
	virtual int _SetROP2 (CDC* pDC, int nDrawMode)
		{
			return pDC->SetROP2(nDrawMode);
		}
	virtual int _SetStretchBltMode (CDC* pDC, int nStretchMode)
		{
			return pDC->SetStretchBltMode(nStretchMode);
		}
	virtual BOOL _GetColorAdjustment (const CDC* pDC, LPCOLORADJUSTMENT lpColorAdjust) const
		{
			return pDC->GetColorAdjustment(lpColorAdjust);
		}
	virtual BOOL _SetColorAdjustment (CDC* pDC, const COLORADJUSTMENT* lpColorAdjust)
		{
			return pDC->SetColorAdjustment(lpColorAdjust);
		}
	virtual int _GetMapMode (const CDC* pDC) const
		{
			return pDC->GetMapMode();
		}
	virtual CPoint _GetViewportOrg (const CDC* pDC) const
		{
			return pDC->GetViewportOrg();
		}
	virtual CPoint _SetViewportOrg (CDC* pDC, POINT point)
		{
			return pDC->SetViewportOrg(point);
		}
	virtual CSize _GetViewportExt (const CDC* pDC) const
		{
			return pDC->GetViewportExt();
		}
	virtual CSize _SetViewportExt (CDC* pDC, SIZE size)
		{
			return pDC->SetViewportExt(size);
		}
	virtual CPoint _GetWindowOrg (const CDC* pDC) const
		{
			return pDC->GetWindowOrg();
		}
	virtual CPoint _SetWindowOrg (CDC* pDC, int x, int y)
		{
			return pDC->SetWindowOrg(x, y);
		}
	virtual CPoint _SetWindowOrg (CDC* pDC, POINT point)
		{
			return pDC->SetWindowOrg(point);
		}
	virtual CPoint _OffsetWindowOrg (CDC* pDC, int nWidth, int nHeight)
		{
			return pDC->OffsetWindowOrg(nWidth, nHeight);
		}
	virtual CSize _GetWindowExt (const CDC* pDC) const
		{
			return pDC->GetWindowExt();
		}
	virtual CSize _SetWindowExt (CDC* pDC, SIZE size)
		{
			return pDC->SetWindowExt(size);
		}
	virtual void _DPtoLP (const CDC* pDC, LPPOINT lpPoints, int nCount) const
		{
			pDC->DPtoLP(lpPoints, nCount);
		}
	virtual void _DPtoLP (const CDC* pDC, LPRECT lpRect) const
		{
			pDC->DPtoLP(lpRect);
		}
	virtual void _DPtoLP (const CDC* pDC, LPSIZE lpSize) const
		{
			pDC->DPtoLP(lpSize);
		}
	virtual void _LPtoDP (const CDC* pDC, LPPOINT lpPoints, int nCount) const
		{
			pDC->LPtoDP(lpPoints, nCount);
		}
	virtual void _LPtoDP (const CDC* pDC, LPRECT lpRect) const
		{
			pDC->LPtoDP(lpRect);
		}
	virtual void _LPtoDP (const CDC* pDC, LPSIZE lpSize) const
		{
			pDC->LPtoDP(lpSize);
		}
	virtual void _DPtoHIMETRIC (const CDC* pDC, LPSIZE lpSize) const
		{
			pDC->DPtoHIMETRIC(lpSize);
		}
	virtual void _LPtoHIMETRIC (const CDC* pDC, LPSIZE lpSize) const
		{
			pDC->LPtoHIMETRIC(lpSize);
		}
	virtual void _HIMETRICtoDP (const CDC* pDC, LPSIZE lpSize) const
		{
			pDC->HIMETRICtoDP(lpSize);
		}
	virtual void _HIMETRICtoLP (const CDC* pDC, LPSIZE lpSize) const
		{
			pDC->HIMETRICtoLP(lpSize);
		}
	virtual BOOL _FillRgn (CDC* pDC, CRgn* pRgn, CBrush* pBrush)
		{
			return pDC->FillRgn(pRgn, pBrush);
		}
	virtual BOOL _FrameRgn (CDC* pDC, CRgn* pRgn, CBrush* pBrush, int nWidth, int nHeight)
		{
			return pDC->FrameRgn(pRgn, pBrush, nWidth, nHeight);
		}
	virtual BOOL _InvertRgn (CDC* pDC, CRgn* pRgn)
		{
			return pDC->InvertRgn(pRgn);
		}
	virtual BOOL _PaintRgn (CDC* pDC, CRgn* pRgn)
		{
			return pDC->PaintRgn(pRgn);
		}
	virtual BOOL _PtVisible (const CDC* pDC, POINT point) const
		{
			return pDC->PtVisible(point);
		}
	virtual int _SelectClipRgn (CDC* pDC, CRgn* pRgn)
		{
			return pDC->SelectClipRgn(pRgn);
		}
	virtual int _ExcludeClipRect (CDC* pDC, int x1, int y1, int x2, int y2)
		{
			return pDC->ExcludeClipRect(x1, y1, x2, y2);
		}
	virtual int _ExcludeClipRect (CDC* pDC, LPCRECT lpRect)
		{
			return pDC->ExcludeClipRect(lpRect);
		}
	virtual int _ExcludeUpdateRgn (CDC* pDC, CWnd* pWnd)
		{
			return pDC->ExcludeUpdateRgn(pWnd);
		}
	virtual int _IntersectClipRect (CDC* pDC, int x1, int y1, int x2, int y2)
		{
			return pDC->IntersectClipRect(x1, y1, x2, y2);
		}
	virtual int _IntersectClipRect (CDC* pDC, LPCRECT lpRect)
		{
			return pDC->IntersectClipRect(lpRect);
		}
	virtual int _OffsetClipRgn (CDC* pDC, int x, int y)
		{
			return pDC->OffsetClipRgn(x, y);
		}
	virtual int _OffsetClipRgn (CDC* pDC, SIZE size)
		{
			return pDC->OffsetClipRgn(size);
		}
	virtual int _SelectClipRgn (CDC* pDC, CRgn* pRgn, int nMode)
		{
			return pDC->SelectClipRgn(pRgn, nMode);
		}
	virtual CPoint _GetCurrentPosition (const CDC* pDC) const
		{
			return pDC->GetCurrentPosition();
		}
	virtual CPoint _MoveTo (CDC* pDC, int x, int y)
		{
			return pDC->MoveTo(x, y);
		}
	virtual CPoint _MoveTo (CDC* pDC, POINT point)
		{
			return pDC->MoveTo(point);
		}
	virtual BOOL _LineTo (CDC* pDC, int x, int y)
		{
			return pDC->LineTo(x, y);
		}
	virtual BOOL _LineTo (CDC* pDC, POINT point)
		{
			return pDC->LineTo(point);
		}
	virtual BOOL _Arc (CDC* pDC, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4)
		{
			return pDC->Arc(x1, y1, x2, y2, x3, y3, x4, y4);
		}
	virtual BOOL _Arc (CDC* pDC, LPCRECT lpRect, POINT ptStart, POINT ptEnd)
		{
			return pDC->Arc(lpRect, ptStart, ptEnd);
		}
	virtual BOOL _Polyline (CDC* pDC, LPPOINT lpPoints, int nCount)
		{
			return pDC->Polyline(lpPoints, nCount);
		}
	virtual BOOL _AngleArc (CDC* pDC, int x, int y, int nRadius, float fStartAngle, float fSweepAngle)
		{
			return pDC->AngleArc(x, y, nRadius, fStartAngle, fSweepAngle);
		}
	virtual BOOL _ArcTo (CDC* pDC, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4)
		{
			return pDC->ArcTo(x1, y1, x2, y2, x3, y3, x4, y4);
		}
	virtual BOOL _ArcTo (CDC* pDC, LPCRECT lpRect, POINT ptStart, POINT ptEnd)
		{
			return pDC->ArcTo(lpRect, ptStart, ptEnd);
		}
	virtual int _GetArcDirection (const CDC* pDC) const
		{
			return pDC->GetArcDirection();
		}
	virtual int _SetArcDirection (CDC* pDC, int nArcDirection)
		{
			return pDC->SetArcDirection(nArcDirection);
		}
	virtual BOOL _PolyDraw (CDC* pDC, const POINT* lpPoints, const BYTE* lpTypes, int nCount)
		{
			return pDC->PolyDraw(lpPoints, lpTypes, nCount);
		}
	virtual BOOL _PolylineTo (CDC* pDC, const POINT* lpPoints, int nCount)
		{
			return pDC->PolylineTo(lpPoints, nCount);
		}
	virtual BOOL _PolyPolyline (CDC* pDC, const POINT* lpPoints, const DWORD* lpPolyPoints, int nCount)
		{
			return pDC->PolyPolyline(lpPoints, lpPolyPoints, nCount);
		}
	virtual BOOL _PolyBezier (CDC* pDC, const POINT* lpPoints, int nCount)
		{
			return pDC->PolyBezier(lpPoints, nCount);
		}
	virtual BOOL _PolyBezierTo (CDC* pDC, const POINT* lpPoints, int nCount)
		{
			return pDC->PolyBezierTo(lpPoints, nCount);
		}
	virtual void _FillRect (CDC* pDC, LPCRECT lpRect, CBrush* pBrush)
		{
			pDC->FillRect(lpRect, pBrush);
		}
	virtual void _FrameRect (CDC* pDC, LPCRECT lpRect, CBrush* pBrush)
		{
			pDC->FrameRect(lpRect, pBrush);
		}
	virtual void _InvertRect (CDC* pDC, LPCRECT lpRect)
		{
			pDC->InvertRect(lpRect);
		}
	virtual BOOL _DrawIcon (CDC* pDC, int x, int y, HICON hIcon)
		{
			return pDC->DrawIcon(x, y, hIcon);
		}
	virtual BOOL _DrawIcon (CDC* pDC, POINT point, HICON hIcon)
		{
			return pDC->DrawIcon(point, hIcon);
		}
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, HBITMAP hBitmap, UINT nFlags, HBRUSH hBrush)
		{
			return pDC->DrawState(pt, size, hBitmap, nFlags, hBrush);
		}
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, CBitmap* pBitmap, UINT nFlags, CBrush* pBrush)
		{
			return pDC->DrawState(pt, size, pBitmap, nFlags, pBrush);
		}
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, HICON hIcon, UINT nFlags, HBRUSH hBrush)
		{
			return pDC->DrawState(pt, size, hIcon, nFlags, hBrush);
		}
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, HICON hIcon, UINT nFlags, CBrush* pBrush)
		{
			return pDC->DrawState(pt, size, hIcon, nFlags, pBrush);
		}
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, LPCTSTR lpszText, UINT nFlags, BOOL bPrefixText, int nTextLen, HBRUSH hBrush)
		{
			return pDC->DrawState(pt, size, lpszText, nFlags, bPrefixText, nTextLen, hBrush);
		}
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, LPCTSTR lpszText, UINT nFlags, BOOL bPrefixText, int nTextLen, CBrush* pBrush)
		{
			return pDC->DrawState(pt, size, lpszText, nFlags, bPrefixText, nTextLen, pBrush);
		}
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, DRAWSTATEPROC lpDrawProc, LPARAM lData, UINT nFlags, HBRUSH hBrush)
		{
			return pDC->DrawState(pt, size, lpDrawProc, lData, nFlags, hBrush);
		}
	virtual BOOL _DrawState (CDC* pDC, CPoint pt, CSize size, DRAWSTATEPROC lpDrawProc, LPARAM lData, UINT nFlags, CBrush* pBrush)
		{
			return pDC->DrawState(pt, size, lpDrawProc, lData, nFlags, pBrush);
		}
	virtual BOOL _Chord (CDC* pDC, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4)
		{
			return pDC->Chord(x1, y1, x2, y2, x3, y3, x4, y4);
		}
	virtual BOOL _Chord (CDC* pDC, LPCRECT lpRect, POINT ptStart, POINT ptEnd)
		{
			return pDC->Chord(lpRect, ptStart, ptEnd);
		}
	virtual void _DrawFocusRect (CDC* pDC, LPCRECT lpRect)
		{
			pDC->DrawFocusRect(lpRect);
		}
	virtual BOOL _Ellipse (CDC* pDC, int x1, int y1, int x2, int y2)
		{
			return pDC->Ellipse(x1, y1, x2, y2);
		}
	virtual BOOL _Ellipse (CDC* pDC, LPCRECT lpRect)
		{
			return pDC->Ellipse(lpRect);
		}
	virtual BOOL _Pie (CDC* pDC, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4)
		{
			return pDC->Pie(x1, y1, x2, y2, x3, y3, x4, y4);
		}
	virtual BOOL _Pie (CDC* pDC, LPCRECT lpRect, POINT ptStart, POINT ptEnd)
		{
			return pDC->Pie(lpRect, ptStart, ptEnd);
		}
	virtual BOOL _Polygon (CDC* pDC, LPPOINT lpPoints, int nCount)
		{
			return pDC->Polygon(lpPoints, nCount);
		}
	virtual BOOL _PolyPolygon (CDC* pDC, LPPOINT lpPoints, LPINT lpPolyCounts, int nCount)
		{
			return pDC->PolyPolygon(lpPoints, lpPolyCounts, nCount);
		}
	virtual BOOL _Rectangle (CDC* pDC, int x1, int y1, int x2, int y2)
		{
			return pDC->Rectangle(x1, y1, x2, y2);
		}
	virtual BOOL _Rectangle (CDC* pDC, LPCRECT lpRect)
		{
			return pDC->Rectangle(lpRect);
		}
	virtual BOOL _RoundRect (CDC* pDC, int x1, int y1, int x2, int y2, int x3, int y3)
		{
			return pDC->RoundRect(x1, y1, x2, y2, x3, y3);
		}
	virtual BOOL _RoundRect (CDC* pDC, LPCRECT lpRect, POINT point)
		{
			return pDC->RoundRect(lpRect, point);
		}
	virtual BOOL _PatBlt (CDC* pDC, int x, int y, int nWidth, int nHeight, DWORD dwRop)
		{
			return pDC->PatBlt(x, y, nWidth, nHeight, dwRop);
		}
	virtual BOOL _BitBlt (CDC* pDC, int x, int y, int nWidth, int nHeight, CDC* pSrcDC, int xSrc, int ySrc, DWORD dwRop)
		{
			return pDC->BitBlt(x, y, nWidth, nHeight, pSrcDC, xSrc, ySrc, dwRop);
		}
	virtual BOOL _StretchBlt (CDC* pDC, int x, int y, int nWidth, int nHeight, CDC* pSrcDC, int xSrc, int ySrc, int nSrcWidth, int nSrcHeight, DWORD dwRop)
		{
			return pDC->StretchBlt(x, y, nWidth, nHeight, pSrcDC, xSrc, ySrc, nSrcWidth, nSrcHeight, dwRop);
		}
	virtual COLORREF _GetPixel (const CDC* pDC, int x, int y) const
		{
			return pDC->GetPixel(x, y);
		}
	virtual COLORREF _GetPixel (const CDC* pDC, POINT point) const
		{
			return pDC->GetPixel(point);
		}
	virtual COLORREF _SetPixel (CDC* pDC, int x, int y, COLORREF crColor)
		{
			return pDC->SetPixel(x, y, crColor);
		}
	virtual COLORREF _SetPixel (CDC* pDC, POINT point, COLORREF crColor)
		{
			return pDC->SetPixel(point, crColor);
		}
	virtual BOOL _FloodFill (CDC* pDC, int x, int y, COLORREF crColor)
		{
			return pDC->FloodFill(x, y, crColor);
		}
	virtual BOOL _ExtFloodFill (CDC* pDC, int x, int y, COLORREF crColor, UINT nFillType)
		{
			return pDC->ExtFloodFill(x, y, crColor, nFillType);
		}
	virtual BOOL _MaskBlt (CDC* pDC, int x, int y, int nWidth, int nHeight, CDC* pSrcDC, int xSrc, int ySrc, CBitmap& maskBitmap, int xMask, int yMask, DWORD dwRop)
		{
			return pDC->MaskBlt(x, y, nWidth, nHeight, pSrcDC, xSrc, ySrc, maskBitmap, xMask, yMask, dwRop);
		}
	virtual BOOL _PlgBlt (CDC* pDC, LPPOINT lpPoint, CDC* pSrcDC, int xSrc, int ySrc, int nWidth, int nHeight, CBitmap& maskBitmap, int xMask, int yMask)
		{
			return pDC->PlgBlt(lpPoint, pSrcDC, xSrc, ySrc, nWidth, nHeight, maskBitmap, xMask, yMask);
		}
	virtual BOOL _SetPixelV (CDC* pDC, int x, int y, COLORREF crColor)
		{
			return pDC->SetPixelV(x, y, crColor);
		}
	virtual BOOL _SetPixelV (CDC* pDC, POINT point, COLORREF crColor)
		{
			return pDC->SetPixelV(point, crColor);
		}
	virtual BOOL _TextOut (CDC* pDC, int x, int y, const CString& str)
		{
			return pDC->TextOut(x, y, str);
		}
	virtual BOOL _ExtTextOut (CDC* pDC, int x, int y, UINT nOptions, LPCRECT lpRect, const CString& str, LPINT lpDxWidths)
		{
			return pDC->ExtTextOut(x, y, nOptions, lpRect, str, lpDxWidths);
		}
	virtual CSize _TabbedTextOut (CDC* pDC, int x, int y, const CString& str, int nTabPositions, LPINT lpnTabStopPositions, int nTabOrigin)
		{
			return pDC->TabbedTextOut(x, y, str, nTabPositions, lpnTabStopPositions, nTabOrigin);
		}
	virtual int _DrawText (CDC* pDC, const CString& str, LPRECT lpRect, UINT nFormat)
		{
			return pDC->DrawText(str, lpRect, nFormat);
		}
	virtual CSize _GetTextExtent (const CDC* pDC, LPCTSTR lpszString, int nCount) const
		{
			return pDC->GetTextExtent(lpszString, nCount);
		}
	virtual CSize _GetTextExtent (const CDC* pDC, const CString& str) const
		{
			return pDC->GetTextExtent(str);
		}
	virtual CSize _GetOutputTextExtent (const CDC* pDC, LPCTSTR lpszString, int nCount) const
		{
			return pDC->GetOutputTextExtent(lpszString, nCount);
		}
	virtual CSize _GetOutputTextExtent (const CDC* pDC, const CString& str) const
		{
			return pDC->GetOutputTextExtent(str);
		}
	virtual CSize _GetTabbedTextExtent (const CDC* pDC, LPCTSTR lpszString, int nCount, int nTabPositions, LPINT lpnTabStopPositions) const
		{
			return pDC->GetTabbedTextExtent(lpszString, nCount, nTabPositions, lpnTabStopPositions);
		}
	virtual CSize _GetTabbedTextExtent (const CDC* pDC, const CString& str, int nTabPositions, LPINT lpnTabStopPositions) const
		{
			return pDC->GetTabbedTextExtent(str, nTabPositions, lpnTabStopPositions);
		}
	virtual CSize _GetOutputTabbedTextExtent (const CDC* pDC, LPCTSTR lpszString, int nCount, int nTabPositions, LPINT lpnTabStopPositions) const
		{
			return pDC->GetOutputTabbedTextExtent(lpszString, nCount, nTabPositions, lpnTabStopPositions);
		}
	virtual CSize _GetOutputTabbedTextExtent (const CDC* pDC, const CString& str, int nTabPositions, LPINT lpnTabStopPositions) const
		{
			return pDC->GetOutputTabbedTextExtent(str, nTabPositions, lpnTabStopPositions);
		}
	virtual UINT _GetTextAlign (const CDC* pDC) const
		{
			return pDC->GetTextAlign();
		}
	virtual UINT _SetTextAlign (CDC* pDC, UINT nFlags)
		{
			return pDC->SetTextAlign(nFlags);
		}
	virtual int _GetTextFace (const CDC* pDC, int nCount, LPTSTR lpszFacename) const
		{
			return pDC->GetTextFace(nCount, lpszFacename);
		}
	virtual int _GetTextFace (const CDC* pDC, CString& rString) const
		{
			return pDC->GetTextFace(rString);
		}
	virtual BOOL _GetTextMetrics (const CDC* pDC, LPTEXTMETRIC lpMetrics) const
		{
			return pDC->GetTextMetrics(lpMetrics);
		}
	virtual BOOL _GetOutputTextMetrics (const CDC* pDC, LPTEXTMETRIC lpMetrics) const
		{
			return pDC->GetOutputTextMetrics(lpMetrics);
		}
	virtual int _SetTextJustification (CDC* pDC, int nBreakExtra, int nBreakCount)
		{
			return pDC->SetTextJustification(nBreakExtra, nBreakCount);
		}
	virtual int _GetTextCharacterExtra (const CDC* pDC) const
		{
			return pDC->GetTextCharacterExtra();
		}
	virtual int _SetTextCharacterExtra (CDC* pDC, int nCharExtra)
		{
			return pDC->SetTextCharacterExtra(nCharExtra);
		}
	virtual BOOL _DrawEdge (CDC* pDC, LPRECT lpRect, UINT nEdge, UINT nFlags)
		{
			return pDC->DrawEdge(lpRect, nEdge, nFlags);
		}
	virtual BOOL _DrawFrameControl (CDC* pDC, LPRECT lpRect, UINT nType, UINT nState)
		{
			return pDC->DrawFrameControl(lpRect, nType, nState);
		}
	virtual BOOL _ScrollDC (CDC* pDC, int dx, int dy, LPCRECT lpRectScroll, LPCRECT lpRectClip, CRgn* pRgnUpdate, LPRECT lpRectUpdate)
		{
			return pDC->ScrollDC(dx, dy, lpRectScroll, lpRectClip, pRgnUpdate, lpRectUpdate);
		}
	virtual BOOL _GetCharWidth (const CDC* pDC, UINT nFirstChar, UINT nLastChar, LPINT lpBuffer) const
		{
			return pDC->GetCharWidth(nFirstChar, nLastChar, lpBuffer);
		}
	virtual BOOL _GetOutputCharWidth (const CDC* pDC, UINT nFirstChar, UINT nLastChar, LPINT lpBuffer) const
		{
			return pDC->GetOutputCharWidth(nFirstChar, nLastChar, lpBuffer);
		}
	virtual DWORD _SetMapperFlags (CDC* pDC, DWORD dwFlag)
		{
			return pDC->SetMapperFlags(dwFlag);
		}
	virtual CSize _GetAspectRatioFilter (const CDC* pDC) const
		{
			return pDC->GetAspectRatioFilter();
		}
	virtual BOOL _GetCharABCWidths (const CDC* pDC, UINT nFirstChar, UINT nLastChar, LPABC lpabc) const
		{
			return pDC->GetCharABCWidths(nFirstChar, nLastChar, lpabc);
		}
	virtual DWORD _GetFontData (const CDC* pDC, DWORD dwTable, DWORD dwOffset, LPVOID lpData, DWORD cbData) const
		{
			return pDC->GetFontData(dwTable, dwOffset, lpData, cbData);
		}
	virtual int _GetKerningPairs (const CDC* pDC, int nPairs, LPKERNINGPAIR lpkrnpair) const
		{
			return pDC->GetKerningPairs(nPairs, lpkrnpair);
		}
	virtual UINT _GetOutlineTextMetrics (const CDC* pDC, UINT cbData, LPOUTLINETEXTMETRIC lpotm) const
		{
			return pDC->GetOutlineTextMetrics(cbData, lpotm);
		}
	virtual DWORD _GetGlyphOutline (const CDC* pDC, UINT nChar, UINT nFormat, LPGLYPHMETRICS lpgm, DWORD cbBuffer, LPVOID lpBuffer, const MAT2* lpmat2) const
		{
			return pDC->GetGlyphOutline(nChar, nFormat, lpgm, cbBuffer, lpBuffer, lpmat2);
		}
	virtual BOOL _GetCharABCWidths (const CDC* pDC, UINT nFirstChar, UINT nLastChar, LPABCFLOAT lpABCF) const
		{
			return pDC->GetCharABCWidths(nFirstChar, nLastChar, lpABCF);
		}
	virtual BOOL _GetCharWidth (const CDC* pDC, UINT nFirstChar, UINT nLastChar, float* lpFloatBuffer) const
		{
			return pDC->GetCharWidth(nFirstChar, nLastChar, lpFloatBuffer);
		}
	virtual int _Escape (CDC* pDC, int nEscape, int nInputSize, LPCSTR lpszInputData, int nOutputSize, LPSTR lpszOutputData)
		{
			return pDC->Escape(nEscape, nInputSize, lpszInputData, nOutputSize, lpszOutputData);
		}
	virtual int _DrawEscape (CDC* pDC, int nEscape, int nInputSize, LPCSTR lpszInputData)
		{
			return pDC->DrawEscape(nEscape, nInputSize, lpszInputData);
		}
	virtual int _StartDoc (CDC* pDC, LPCTSTR lpszDocName)
		{
			return pDC->StartDoc(lpszDocName);
		}
	virtual int _StartDoc (CDC* pDC, LPDOCINFO lpDocInfo)
		{
			return pDC->StartDoc(lpDocInfo);
		}
	virtual int _StartPage (CDC* pDC)
		{
			return pDC->StartPage();
		}
	virtual int _EndPage (CDC* pDC)
		{
			return pDC->EndPage();
		}
	virtual int _SetAbortProc (CDC* pDC, BOOL (CALLBACK* lpfn) (HDC, int))
		{
			return pDC->SetAbortProc(lpfn);
		}
	virtual int _AbortDoc (CDC* pDC)
		{
			return pDC->AbortDoc();
		}
	virtual int _EndDoc (CDC* pDC)
		{
			return pDC->EndDoc();
		}
	virtual BOOL _PlayMetaFile (CDC* pDC, HMETAFILE hMF)
		{
			return pDC->PlayMetaFile(hMF);
		}
	virtual BOOL _PlayMetaFile (CDC* pDC, HENHMETAFILE hEnhMetaFile, LPCRECT lpBounds)
		{
			return pDC->PlayMetaFile(hEnhMetaFile, lpBounds);
		}
	virtual BOOL _AddMetaFileComment (CDC* pDC, UINT nDataSize, const BYTE* pCommentData)
		{
			return pDC->AddMetaFileComment(nDataSize, pCommentData);
		}
	virtual BOOL _AbortPath (CDC* pDC)
		{
			return pDC->AbortPath();
		}
	virtual BOOL _BeginPath (CDC* pDC)
		{
			return pDC->BeginPath();
		}
	virtual BOOL _CloseFigure (CDC* pDC)
		{
			return pDC->CloseFigure();
		}
	virtual BOOL _EndPath (CDC* pDC)
		{
			return pDC->EndPath();
		}
	virtual BOOL _FillPath (CDC* pDC)
		{
			return pDC->FillPath();
		}
	virtual BOOL _FlattenPath (CDC* pDC)
		{
			return pDC->FlattenPath();
		}
	virtual BOOL _StrokeAndFillPath (CDC* pDC)
		{
			return pDC->StrokeAndFillPath();
		}
	virtual BOOL _StrokePath (CDC* pDC)
		{
			return pDC->StrokePath();
		}
	virtual BOOL _WidenPath (CDC* pDC)
		{
			return pDC->WidenPath();
		}
	virtual float _GetMiterLimit (const CDC* pDC) const
		{
			return pDC->GetMiterLimit();
		}
	virtual BOOL _SetMiterLimit (CDC* pDC, float fMiterLimit)
		{
			return pDC->SetMiterLimit(fMiterLimit);
		}
	virtual int _GetPath (const CDC* pDC, LPPOINT lpPoints, LPBYTE lpTypes, int nCount) const
		{
			return pDC->GetPath(lpPoints, lpTypes, nCount);
		}
	virtual BOOL _SelectClipPath (CDC* pDC, int nMode)
		{
			return pDC->SelectClipPath(nMode);
		}
	virtual CBrush* _GetHalftoneBrush () const
		{
			return CDC::GetHalftoneBrush();
		}
	virtual void _DrawDragRect (CDC* pDC, LPCRECT lpRect, SIZE size, LPCRECT lpRectLast, SIZE sizeLast, CBrush* pBrush, CBrush* pBrushLast)
		{
			pDC->DrawDragRect(lpRect, size, lpRectLast, sizeLast, pBrush, pBrushLast);
		}
	virtual void _FillSolidRect (CDC* pDC, LPCRECT lpRect, COLORREF clr)
		{
			pDC->FillSolidRect(lpRect, clr);
		}
	virtual void _FillSolidRect (CDC* pDC, int x, int y, int cx, int cy, COLORREF clr)
		{
			pDC->FillSolidRect(x, y, cx, cy, clr);
		}
	virtual void _Draw3dRect (CDC* pDC, LPCRECT lpRect, COLORREF clrTopLeft, COLORREF clrBottomRight)
		{
			pDC->Draw3dRect(lpRect, clrTopLeft, clrBottomRight);
		}
	virtual void _Draw3dRect (CDC* pDC, int x, int y, int cx, int cy, COLORREF clrTopLeft, COLORREF clrBottomRight)
		{
			pDC->Draw3dRect(x, y, cx, cy, clrTopLeft, clrBottomRight);
		}
	virtual HGDIOBJ _SelectObject (CDC* pDC, HGDIOBJ h)
		{
			return pDC->SelectObject(h);
		}
}; // interface FCIMfcDC.

interface FCIMfcBrush : IMpgMfcBrush
{
	virtual CBrush* _New () const
	{
		return new CBrush();
	} // CBrush* _New () const;

	virtual void _Delete (CBrush* pSrc) const
	{
		delete pSrc;
	} // void _Delete (CBrush* pSrc) const;

	virtual CBrush* _FromHandle (HBRUSH hBrush) const
	{
		return CBrush::FromHandle(hBrush);
	} // CBrush* _FromHandle (HBRUSH hBrush) const;

	virtual BOOL _CreateSolidBrush (CBrush* pSrc, COLORREF crColor)
	{
		return pSrc->CreateSolidBrush(crColor);
	} // BOOL _CreateSolidBrush (COLORREF crColor);

	virtual BOOL _CreateHatchBrush (CBrush* pSrc, int nIndex, COLORREF crColor)
	{
		return pSrc->CreateHatchBrush(nIndex, crColor);
	} // BOOL _CreateHatchBrush (int nIndex, COLORREF crColor);

	virtual BOOL _CreateBrushIndirect (CBrush* pSrc, const LOGBRUSH* lpLogBrush)
	{
		return pSrc->CreateBrushIndirect(lpLogBrush);
	} // BOOL _CreateBrushIndirect (const LOGBRUSH* lpLogBrush);

	virtual BOOL _CreatePatternBrush (CBrush* pSrc, CBitmap* pBitmap)
	{
		return pSrc->CreatePatternBrush(pBitmap);
	} // BOOL _CreatePatternBrush (CBitmap* pBitmap);

	virtual BOOL _CreateDIBPatternBrush (CBrush* pSrc, HGLOBAL hPackedDIB, UINT nUsage)
	{
		return pSrc->CreateDIBPatternBrush(hPackedDIB, nUsage);
	} // BOOL _CreateDIBPatternBrush (HGLOBAL hPackedDIB, UINT nUsage);

	virtual BOOL _CreateDIBPatternBrush (CBrush* pSrc, const void* lpPackedDIB, UINT nUsage)
	{
		return pSrc->CreateDIBPatternBrush(lpPackedDIB, nUsage);
	} // BOOL _CreateDIBPatternBrush (const void* lpPackedDIB, UINT nUsage);

	virtual BOOL _CreateSysColorBrush (CBrush* pSrc, int nIndex)
	{
		return pSrc->CreateSysColorBrush(nIndex);
	} // BOOL _CreateSysColorBrush (int nIndex);

	virtual HBRUSH _HBRUSH (const CBrush* pSrc) const
	{
		return HBRUSH(*pSrc);
	} // HBRUSH _HBRUSH () const;

	virtual int _GetLogBrush (CBrush* pSrc, LOGBRUSH* pLogBrush)
	{
		return pSrc->GetLogBrush(pLogBrush);
	} // int _GetLogBrush (LOGBRUSH* pLogBrush);
}; // interface FCIMfcBrush.

interface FCIMfcFont : IMpgMfcFont
{
	virtual CFont* _New () const
	{
		return new CFont();
	} // CFont* _New () const;

	virtual void _Delete (CFont* pSrc) const
	{
		delete pSrc;
	} // void _Delete (CFont* pSrc) const;

	virtual CFont* _FromHandle (HFONT hFont) const
	{
		return CFont::FromHandle(hFont);
	} // CFont* _FromHandle (HFONT hFont) const;

	virtual BOOL _CreateFontIndirect (CFont* pSrc, const LOGFONT* lpLogFont)
	{
		return pSrc->CreateFontIndirect(lpLogFont);
	} // BOOL _CreateFontIndirect (const LOGFONT* lpLogFont);

	virtual BOOL _CreateFont (CFont* pSrc, int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight, BYTE bItalic, BYTE bUnderline, BYTE cStrikeOut, BYTE nCharSet, BYTE nOutPrecision, BYTE nClipPrecision, BYTE nQuality, BYTE nPitchAndFamily, LPCTSTR lpszFacename)
	{
		return pSrc->CreateFont(nHeight, nWidth, nEscapement, nOrientation, nWeight, bItalic, bUnderline, cStrikeOut, nCharSet, nOutPrecision, nClipPrecision, nQuality, nPitchAndFamily, lpszFacename);
	} // BOOL _CreateFont (int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight, BYTE bItalic, BYTE bUnderline, BYTE cStrikeOut, BYTE nCharSet, BYTE nOutPrecision, BYTE nClipPrecision, BYTE nQuality, BYTE nPitchAndFamily, LPCTSTR lpszFacename);

	virtual BOOL _CreatePointFont (CFont* pSrc, int nPointSize, LPCTSTR lpszFaceName, CDC* pDC = NULL)
	{
		return pSrc->CreatePointFont(nPointSize, lpszFaceName, pDC);
	} // BOOL _CreatePointFont (int nPointSize, LPCTSTR lpszFaceName, CDC* pDC = NULL);

	virtual BOOL _CreatePointFontIndirect (CFont* pSrc, const LOGFONT* lpLogFont, CDC* pDC = NULL)
	{
		return pSrc->CreatePointFontIndirect(lpLogFont, pDC);
	} // BOOL _CreatePointFontIndirect (const LOGFONT* lpLogFont, CDC* pDC = NULL);

	virtual HFONT _HFONT (const CFont* pSrc) const
	{
		return HFONT(*pSrc);
	} // HFONT _HFONT () const;

	virtual int _GetLogFont (CFont* pSrc, LOGFONT* pLogFont)
	{
		return pSrc->GetLogFont(pLogFont);
	} // int _GetLogFont (LOGFONT* pLogFont);
}; // interface FCIMfcFont.

interface FCIMfcPalette : IMpgMfcPalette
{
	virtual CPalette* _New () const
	{
		return new CPalette();
	} // CPalette* _New () const;

	virtual void _Delete (CPalette* pSrc) const
	{
		delete pSrc;
	} // void _Delete (CPalette* pSrc) const;

	virtual CPalette* _FromHandle (HPALETTE hPalette) const
	{
		return CPalette::FromHandle(hPalette);
	} // CPalette* _FromHandle (HPALETTE hPalette) const;

	virtual BOOL _CreatePalette (CPalette* pSrc, LPLOGPALETTE lpLogPalette)
	{
		return pSrc->CreatePalette(lpLogPalette);
	} // BOOL _CreatePalette (LPLOGPALETTE lpLogPalette);

	virtual BOOL _CreateHalftonePalette (CPalette* pSrc, CDC* pDC)
	{
		return pSrc->CreateHalftonePalette(pDC);
	} // BOOL _CreateHalftonePalette (CDC* pDC);

	virtual HPALETTE _HPALETTE (const CPalette* pSrc) const
	{
		return HPALETTE(*pSrc);
	} // HPALETTE _HPALETTE () const;

	virtual int _GetEntryCount (CPalette* pSrc)
	{
		return pSrc->GetEntryCount();
	} // int _GetEntryCount ();

	virtual UINT _GetPaletteEntries (const CPalette* pSrc, UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors) const
	{
		return pSrc->GetPaletteEntries(nStartIndex, nNumEntries, lpPaletteColors);
	} // UINT _GetPaletteEntries (UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors) const;

	virtual UINT _SetPaletteEntries (CPalette* pSrc, UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors)
	{
		return pSrc->SetPaletteEntries(nStartIndex, nNumEntries, lpPaletteColors);
	} // UINT _SetPaletteEntries (UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors);

	virtual void _AnimatePalette (CPalette* pSrc, UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors)
	{
		pSrc->AnimatePalette(nStartIndex, nNumEntries, lpPaletteColors);
	} // void _AnimatePalette (UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors);

	virtual UINT _GetNearestPaletteIndex (const CPalette* pSrc, COLORREF crColor) const
	{
		return pSrc->GetNearestPaletteIndex(crColor);
	} // UINT _GetNearestPaletteIndex (COLORREF crColor) const;

	virtual BOOL _ResizePalette (CPalette* pSrc, UINT nNumEntries)
	{
		return pSrc->ResizePalette(nNumEntries);
	} // BOOL _ResizePalette (UINT nNumEntries);
}; // interface FCIMfcPalette.

interface FCIMfcPen : IMpgMfcPen
{
	virtual CPen* _New () const
	{
		return new CPen();
	} // CPen* _New () const;

	virtual void _Delete (CPen* pSrc) const
	{
		delete pSrc;
	} // void _Delete (CPen* pSrc) const;

	virtual CPen* _FromHandle (HPEN hPen) const
	{
		return CPen::FromHandle(hPen);
	} // CPen* _FromHandle (HPEN hPen) const;

	virtual BOOL _CreatePen (CPen* pSrc, int nPenStyle, int nWidth, COLORREF crColor)
	{
		return pSrc->CreatePen(nPenStyle, nWidth, crColor);
	} // BOOL _CreatePen (int nPenStyle, int nWidth, COLORREF crColor);

	virtual BOOL _CreatePen (CPen* pSrc, int nPenStyle, int nWidth, const LOGBRUSH* pLogBrush, int nStyleCount = 0, const DWORD* lpStyle = NULL)
	{
		return pSrc->CreatePen(nPenStyle, nWidth, pLogBrush, nStyleCount, lpStyle);
	} // BOOL _CreatePen (int nPenStyle, int nWidth, const LOGBRUSH* pLogBrush, int nStyleCount = 0, const DWORD* lpStyle = NULL);

	virtual BOOL _CreatePenIndirect (CPen* pSrc, LPLOGPEN lpLogPen)
	{
		return pSrc->CreatePenIndirect(lpLogPen);
	} // BOOL _CreatePenIndirect (LPLOGPEN lpLogPen);

	virtual HPEN _HPEN (const CPen* pSrc) const
	{
		return HPEN(*pSrc);
	} // HPEN _HPEN () const;

	virtual int _GetLogPen (CPen* pSrc, LOGPEN* pLogPen)
	{
		return pSrc->GetLogPen(pLogPen);
	} // int _GetLogPen (LOGPEN* pLogPen);

	virtual int _GetExtLogPen (CPen* pSrc, EXTLOGPEN* pLogPen)
	{
		return pSrc->GetExtLogPen(pLogPen);
	} // int _GetExtLogPen (EXTLOGPEN* pLogPen);
}; // interface FCIMfcPen.

interface FCIMfcRgn : IMpgMfcRgn
{
	virtual CRgn* _New () const
	{
		return new CRgn();
	} // CRgn* _New () const;

	virtual void _Delete (CRgn* pSrc) const
	{
		delete pSrc;
	} // void _Delete (CRgn* pSrc) const;

	virtual CRgn* _FromHandle (HRGN hRgn) const
	{
		return CRgn::FromHandle(hRgn);
	} // CRgn* _FromHandle (HRGN hRgn) const;

	virtual HRGN _HRGN (const CRgn* pSrc) const
	{
		return HRGN(*pSrc);
	} // HRGN _HRGN () const;

	virtual BOOL _CreateRectRgn (CRgn* pSrc, int x1, int y1, int x2, int y2)
	{
		return pSrc->CreateRectRgn(x1, y1, x2, y2);
	} // BOOL _CreateRectRgn (int x1, int y1, int x2, int y2);

	virtual BOOL _CreateRectRgnIndirect (CRgn* pSrc, LPCRECT lpRect)
	{
		return pSrc->CreateRectRgnIndirect(lpRect);
	} // BOOL _CreateRectRgnIndirect (LPCRECT lpRect);

	virtual BOOL _CreateEllipticRgn (CRgn* pSrc, int x1, int y1, int x2, int y2)
	{
		return pSrc->CreateEllipticRgn(x1, y1, x2, y2);
	} // BOOL _CreateEllipticRgn (int x1, int y1, int x2, int y2);

	virtual BOOL _CreateEllipticRgnIndirect (CRgn* pSrc, LPCRECT lpRect)
	{
		return pSrc->CreateEllipticRgnIndirect(lpRect);
	} // BOOL _CreateEllipticRgnIndirect (LPCRECT lpRect);

	virtual BOOL _CreatePolygonRgn (CRgn* pSrc, LPPOINT lpPoints, int nCount, int nMode)
	{
		return pSrc->CreatePolygonRgn(lpPoints, nCount, nMode);
	} // BOOL _CreatePolygonRgn (LPPOINT lpPoints, int nCount, int nMode);

	virtual BOOL _CreatePolyPolygonRgn (CRgn* pSrc, LPPOINT lpPoints, LPINT lpPolyCounts, int nCount, int nPolyFillMode)
	{
		return pSrc->CreatePolyPolygonRgn(lpPoints, lpPolyCounts, nCount, nPolyFillMode);
	} // BOOL _CreatePolyPolygonRgn (LPPOINT lpPoints, LPINT lpPolyCounts, int nCount, int nPolyFillMode);

	virtual BOOL _CreateRoundRectRgn (CRgn* pSrc, int x1, int y1, int x2, int y2, int x3, int y3)
	{
		return pSrc->CreateRoundRectRgn(x1, y1, x2, y2, x3, y3);
	} // BOOL _CreateRoundRectRgn (int x1, int y1, int x2, int y2, int x3, int y3);

	virtual BOOL _CreateFromPath (CRgn* pSrc, CDC* pDC)
	{
		return pSrc->CreateFromPath(pDC);
	} // BOOL _CreateFromPath (CDC* pDC);

	virtual BOOL _CreateFromData (CRgn* pSrc, const XFORM* lpXForm, int nCount, const RGNDATA* pRgnData)
	{
		return pSrc->CreateFromData(lpXForm, nCount, pRgnData);
	} // BOOL _CreateFromData (const XFORM* lpXForm, int nCount, const RGNDATA* pRgnData);

	virtual void _SetRectRgn (CRgn* pSrc, int x1, int y1, int x2, int y2)
	{
		pSrc->SetRectRgn(x1, y1, x2, y2);
	} // void _SetRectRgn (int x1, int y1, int x2, int y2);

	virtual void _SetRectRgn (CRgn* pSrc, LPCRECT lpRect)
	{
		pSrc->SetRectRgn(lpRect);
	} // void _SetRectRgn (LPCRECT lpRect);

	virtual int _CombineRgn (CRgn* pSrc, CRgn* pRgn1, CRgn* pRgn2, int nCombineMode)
	{
		return pSrc->CombineRgn(pRgn1, pRgn2, nCombineMode);
	} // int _CombineRgn (CRgn* pRgn1, CRgn* pRgn2, int nCombineMode);

	virtual int _CopyRgn (CRgn* pSrc, CRgn* pRgnSrc)
	{
		return pSrc->CopyRgn(pRgnSrc);
	} // int _CopyRgn (CRgn* pRgnSrc);

	virtual BOOL _EqualRgn (const CRgn* pSrc, CRgn* pRgn) const
	{
		return pSrc->EqualRgn(pRgn);
	} // BOOL _EqualRgn (CRgn* pRgn) const;

	virtual int _OffsetRgn (CRgn* pSrc, int x, int y)
	{
		return pSrc->OffsetRgn(x, y);
	} // int _OffsetRgn (int x, int y);

	virtual int _OffsetRgn (CRgn* pSrc, POINT point)
	{
		return pSrc->OffsetRgn(point);
	} // int _OffsetRgn (POINT point);

	virtual int _GetRgnBox (const CRgn* pSrc, LPRECT lpRect) const
	{
		return pSrc->GetRgnBox(lpRect);
	} // int _GetRgnBox (LPRECT lpRect) const;

	virtual BOOL _PtInRegion (const CRgn* pSrc, int x, int y) const
	{
		return pSrc->PtInRegion(x, y);
	} // BOOL _PtInRegion (int x, int y) const;

	virtual BOOL _PtInRegion (const CRgn* pSrc, POINT point) const
	{
		return pSrc->PtInRegion(point);
	} // BOOL _PtInRegion (POINT point) const;

	virtual BOOL _RectInRegion (const CRgn* pSrc, LPCRECT lpRect) const
	{
		return pSrc->RectInRegion(lpRect);
	} // BOOL _RectInRegion (LPCRECT lpRect) const;

	virtual int _GetRegionData (const CRgn* pSrc, LPRGNDATA lpRgnData, int nCount) const
	{
		return pSrc->GetRegionData(lpRgnData, nCount);
	} // int _GetRegionData (LPRGNDATA lpRgnData, int nCount) const;
}; // interface FCIMfcRgn.

interface FCIMfcBitmap : IMpgMfcBitmap
{
	virtual CBitmap* _New () const
	{
		return new CBitmap();
	} // CBitmap* _New () const;

	virtual void _Delete (CBitmap* pSrc) const
	{
		delete pSrc;
	} // void _Delete (CBitmap* pSrc) const;

	virtual CBitmap* _FromHandle (HBITMAP hBitmap) const
	{
		return CBitmap::FromHandle(hBitmap);
	} // CBitmap* _FromHandle (HBITMAP hBitmap) const;

	virtual BOOL _LoadBitmap (CBitmap* pSrc, LPCTSTR lpszResourceName)
	{
		return pSrc->LoadBitmap(lpszResourceName);
	} // BOOL _LoadBitmap (LPCTSTR lpszResourceName);

	virtual BOOL _LoadBitmap (CBitmap* pSrc, UINT nIDResource)
	{
		return pSrc->LoadBitmap(nIDResource);
	} // BOOL _LoadBitmap (UINT nIDResource);

	virtual BOOL _LoadOEMBitmap (CBitmap* pSrc, UINT nIDBitmap)
	{
		return pSrc->LoadOEMBitmap(nIDBitmap);
	} // BOOL _LoadOEMBitmap (UINT nIDBitmap);

	virtual BOOL _LoadMappedBitmap (CBitmap* pSrc, UINT nIDBitmap, UINT nFlags = 0, LPCOLORMAP lpColorMap = NULL, int nMapSize = 0)
	{
		return pSrc->LoadMappedBitmap(nIDBitmap, nFlags, lpColorMap, nMapSize);
	} // BOOL _LoadMappedBitmap (UINT nIDBitmap, UINT nFlags = 0, LPCOLORMAP lpColorMap = NULL, int nMapSize = 0);

	virtual BOOL _CreateBitmap (CBitmap* pSrc, int nWidth, int nHeight, UINT nPlanes, UINT nBitcount, const void* lpBits)
	{
		return pSrc->CreateBitmap(nWidth, nHeight, nPlanes, nBitcount, lpBits);
	} // BOOL _CreateBitmap (int nWidth, int nHeight, UINT nPlanes, UINT nBitcount, const void* lpBits);

	virtual BOOL _CreateBitmapIndirect (CBitmap* pSrc, LPBITMAP lpBitmap)
	{
		return pSrc->CreateBitmapIndirect(lpBitmap);
	} // BOOL _CreateBitmapIndirect (LPBITMAP lpBitmap);

	virtual BOOL _CreateCompatibleBitmap (CBitmap* pSrc, CDC* pDC, int nWidth, int nHeight)
	{
		return pSrc->CreateCompatibleBitmap(pDC, nWidth, nHeight);
	} // BOOL _CreateCompatibleBitmap (CDC* pDC, int nWidth, int nHeight);

	virtual BOOL _CreateDiscardableBitmap (CBitmap* pSrc, CDC* pDC, int nWidth, int nHeight)
	{
		return pSrc->CreateDiscardableBitmap(pDC, nWidth, nHeight);
	} // BOOL _CreateDiscardableBitmap (CDC* pDC, int nWidth, int nHeight);

	virtual HBITMAP _HBITMAP (const CBitmap* pSrc) const
	{
		return HBITMAP(*pSrc);
	} // HBITMAP _HBITMAP () const;

	virtual int _GetBitmap (CBitmap* pSrc, BITMAP* pBitMap)
	{
		return pSrc->GetBitmap(pBitMap);
	} // int _GetBitmap (BITMAP* pBitMap);

	virtual DWORD _SetBitmapBits (CBitmap* pSrc, DWORD dwCount, const void* lpBits)
	{
		return pSrc->SetBitmapBits(dwCount, lpBits);
	} // DWORD _SetBitmapBits (DWORD dwCount, const void* lpBits);

	virtual DWORD _GetBitmapBits (const CBitmap* pSrc, DWORD dwCount, LPVOID lpBits) const
	{
		return pSrc->GetBitmapBits(dwCount, lpBits);
	} // DWORD _GetBitmapBits (DWORD dwCount, LPVOID lpBits) const;

	virtual CSize _SetBitmapDimension (CBitmap* pSrc, int nWidth, int nHeight)
	{
		return pSrc->SetBitmapDimension(nWidth, nHeight);
	} // CSize _SetBitmapDimension (int nWidth, int nHeight);

	virtual CSize _GetBitmapDimension (const CBitmap* pSrc) const
	{
		return pSrc->GetBitmapDimension();
	} // CSize _GetBitmapDimension () const;
}; // interface FCIMfcBitmap.

interface FCIMfcGdiObject : IMpgMfcGdiObject
{
	virtual HGDIOBJ _HGDIOBJ (const CGdiObject* pSrc) const
	{
		return HGDIOBJ(*pSrc);
	} // HGDIOBJ _HGDIOBJ () const;

	virtual HGDIOBJ _GetSafeHandle (const CGdiObject* pSrc) const
	{
		return pSrc->GetSafeHandle();
	} // HGDIOBJ _GetSafeHandle () const;

	virtual CGdiObject* _FromHandle (HGDIOBJ hObject) const
	{
		return CGdiObject::FromHandle(hObject);
	} // CGdiObject* _FromHandle (HGDIOBJ hObject) const;

	virtual void _DeleteTempMap () const
	{
		CGdiObject::DeleteTempMap();
	} // void _DeleteTempMap () const;

	virtual BOOL _Attach (CGdiObject* pSrc, HGDIOBJ hObject)
	{
		return pSrc->Attach(hObject);
	} // BOOL _Attach (HGDIOBJ hObject);

	virtual HGDIOBJ _Detach (CGdiObject* pSrc)
	{
		return pSrc->Detach();
	} // HGDIOBJ _Detach ();

	virtual BOOL _DeleteObject (CGdiObject* pSrc)
	{
		return pSrc->DeleteObject();
	} // BOOL _DeleteObject ();

	virtual int _GetObject (const CGdiObject* pSrc, int nCount, LPVOID lpObject) const
	{
		return pSrc->GetObject(nCount, lpObject);
	} // int _GetObject (int nCount, LPVOID lpObject) const;

	virtual UINT _GetObjectType (const CGdiObject* pSrc) const
	{
		return pSrc->GetObjectType();
	} // UINT _GetObjectType () const;

	virtual BOOL _CreateStockObject (CGdiObject* pSrc, int nIndex)
	{
		return pSrc->CreateStockObject(nIndex);
	} // BOOL _CreateStockObject (int nIndex);

	virtual BOOL _UnrealizeObject (CGdiObject* pSrc)
	{
		return pSrc->UnrealizeObject();
	} // BOOL _UnrealizeObject ();

	virtual BOOL _Eq (const CGdiObject* pSrc, const CGdiObject& obj) const
	{
		return (*pSrc == obj);
	} // BOOL _Eq (const CGdiObject& obj) const;
}; // interface FCIMfcGdiObject.

interface FCIMfcWaitCursor : IMpgMfcWaitCursor
{
	virtual CWaitCursor* _New () const
	{
		return new CWaitCursor();
	} // CWaitCursor* _New () const;

	virtual void _Delete (CWaitCursor* pSrc) const
	{
		delete pSrc;
	} // void _Delete (CWaitCursor* pSrc) const;

	virtual void _Restore (CWaitCursor* pSrc)
	{
		pSrc->Restore();
	} // void _Restore (CWaitCursor* pSrc);
}; // interface FCIMfcWaitCursor.

interface FCIMfcClass : public IMpgMfcClass
{
	virtual IMpgMfcString*	MfcStringI ()
		{
			return &m_ifMfcString;
		}
	virtual IMpgMfcWnd*	MfcWndI ()
		{
			return &m_ifMfcWnd;
		}
	virtual IMpgMfcDC*	MfcDCI ()
		{
			return &m_ifMfcDC;
		}

	virtual IMpgMfcBrush*	MfcBrushI ()
		{
			return &m_ifMfcBrush;
		}
	virtual IMpgMfcFont*	MfcFontI ()
		{
			return &m_ifMfcFont;
		}
	virtual IMpgMfcPalette*	MfcPaletteI ()
		{
			return &m_ifMfcPalette;
		}
	virtual IMpgMfcPen*		MfcPenI ()
		{
			return &m_ifMfcPen;
		}
	virtual IMpgMfcRgn*		MfcRgnI ()
		{
			return &m_ifMfcRgn;
		}
	virtual IMpgMfcBitmap*		MfcBitmapI ()
		{
			return &m_ifMfcBitmap;
		}
	virtual IMpgMfcGdiObject*	MfcGdiObjectI ()
		{
			return &m_ifMfcGdiObject;
		}
	virtual IMpgMfcWaitCursor*	MfcWaitCursorI ()
		{
			return &m_ifMfcWaitCursor;
		}
	FCIMfcString	m_ifMfcString;
	FCIMfcWnd		m_ifMfcWnd;
	FCIMfcDC		m_ifMfcDC;
	FCIMfcBrush		m_ifMfcBrush;
	FCIMfcFont		m_ifMfcFont;
	FCIMfcPalette	m_ifMfcPalette;
	FCIMfcPen		m_ifMfcPen;
	FCIMfcRgn		m_ifMfcRgn;
	FCIMfcBitmap		m_ifMfcBitmap;
	FCIMfcGdiObject		m_ifMfcGdiObject;
	FCIMfcWaitCursor	m_ifMfcWaitCursor;
}; // interface FCIMfcClass.

#endif//__MfcClass_h
