// MolipExport.cpp

#include "stdafx.h"
#include "DynamicDraw.h"
#include <new>

#include "RegData.h"			// For FCRegData.
#include "UtilMisc.h"			// For FFLoadRegString.
#include "UtilMath.h"			// For _w10toi64,etc.
#include "UtilStr.h"			// For GetWChar.
#include "UtilDlg.h"			// For FFMakeCommandText.
#include "UtilBezier.h"			// For .
#include "UtilPrint.h"			// For m_ifUtilPrint.
#include "UtilFile.h"			// For FFMakeUniqTmpFileName.
#include "UtilFont.h"			// For FFCopy,etc.
#include "UtilErr.h"			// For FFMessageBox.
#include "UtilZlibPng.h"		// For FCPngStruct.
//----- 06.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#include "FCUtilMath.h"			// For IMpgUtilMath.
//#include "FCUtilStr.h"			// For IMpgUtilStr.
//#include "FCUtilDlg.h"			// For IMpgUtilDlg.
//#include "FCUtilBezier.h"		// For IMpgUtilBezier.
//#include "FCUtilPrint.h"		// For IMpgUtilPrint.
//#include "FCUtilFile.h"			// For IMpgUtilFile.
//#include "FCUtilFont.h"			// For IMpgUtilFont.
//#include "FCUtilErr.h"			// For IMpgUtilErr.
//#include "FCUtilCoord.h"		// For IMpgUtilCoord.
//#include "FCUtilZlibPng.h"		// For IMpgUtilZlibPng.
//#include "FCUtilMisc.h"			// For IMpgUtilMisc.
//----- 06.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
#include "FileConv.h"			// For IMpgFileConv.
#include "HiProject.h"			// For operator < (GUID, GUID).
#include "ToolManager.h"		// For FCToolManager.
#include "ToolBaseFDA.h"		// For FCToolBaseFDA.
#include "DynamicDrawView.h"	// For g_pView.
#include "FoundDoc.h"			// For g_pDoc.
#include "WndRichEdit.h"		// For GetRTFEditor.
#include "NewFDObjAny.h"		// For NewFDObjAny.
#include "MainFrame.h"			// For g_pFrame.
#include "SrvrItem.h"			// For CFCMolipDrawSrvrItem.
#include "DlgPlugInAboutbox.h"	// For CFCDlgPlugInAboutbox.
#include "ClassInstance.h"		// For IMpgClassInstance.
#include "MfcClass.h"			// For IMpgMfcClass.
#include "StdClass.h"			// For IMpgStdClass.
#include "FrameWnd.h"			// For FFGetMainWnd().
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// FCUtilXXX.h _xZkqqHx_iCmNiBeBjCoIiLgAiCkK_xHqqkZx_ UtilXXX.h _xZkqqHx_iCmGiPgEjFkBiClHiCoJiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeB_xHqqkZx_
// _xZkqqHx_iNmFiMoDiCmJiDeDiDjDiDeOiDiLiBfLiDgIiClHiCoJiCmMiCkKjGfNiCnMiClFiCkCiBeC_xHqqkZx_
#include "FCUtilMath.h"			// For IMpgUtilMath.
#include "FCUtilStr.h"			// For IMpgUtilStr.
#include "FCUtilDlg.h"			// For IMpgUtilDlg.
#include "FCUtilBezier.h"		// For IMpgUtilBezier.
#include "FCUtilPrint.h"		// For IMpgUtilPrint.
#include "FCUtilFile.h"			// For IMpgUtilFile.
#include "FCUtilFont.h"			// For IMpgUtilFont.
#include "FCUtilErr.h"			// For IMpgUtilErr.
#include "FCUtilCoord.h"		// For IMpgUtilCoord.
#include "FCUtilZlibPng.h"		// For IMpgUtilZlibPng.
#include "FCUtilMisc.h"			// For IMpgUtilMisc.
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
#include "FCUtilDoc.h"			// For IMpgUtilDoc.
#include "FCUtilToolbar.h"		// For IMpgUtilToolbar.
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
#include "MolipExport.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----- 06.05.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//typedef HRESULT (WINAPI *FuncMolipSupportInfo)(WORD* wSupportApp, WORD* wAppVersion, const wchar_t** wcpIsUnicode, LANGID** pLangId, const wchar_t** wcpModuleName, const wchar_t** wcpSupportInfo);
//typedef HRESULT (WINAPI *FuncMolipInitialize)(FuncAllocate pfnAllocate, FuncFree pfnFree, IMpgMolipBase* pI);
//typedef HRESULT (WINAPI *FuncMolipTerminate)();
//typedef HRESULT (WINAPI *FuncMolipGetClassObject)(int idxCompo, const IID& iid, void** ppv);
//typedef HRESULT (WINAPI *FuncCanUnloadNow) ();
//----- 06.05.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

// To use IID_IMpgPlugInInfo.
PG_USE_PLUGIN_INTERFACE

////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IMpgMolipMain_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCmMiOmAjBjFiDeOiDiJiDfIiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDfCiDjDiDhMiBfLiDgMiDjDiDgHiCfAiCmCiCmJiBeBiCfAiCmCiCmM_xHqqkZx_FCIMolipMain_xZkqqHx_iDeDiDjDiDfIiDfOiDjDiDfIiCkK_xHqqkZx_
 *			_xZkqqHx_iKiEiCoIjDjGiCmEiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCIMolipMain : public IMpgMolipMain
{
protected:
typedef IMpgMolipMain BASE_CLASS;

public:
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual WORD GetStcAppVersion () const;
//	virtual const wchar_t* GetStcAppVersionString () const;
//	virtual WORD GetAppMode () const;
//
//	virtual HRESULT	LockInterface ();
//	virtual HRESULT	UnlockInterface ();
//	virtual HRESULT	Suspend ();
//	virtual HRESULT	Resume ();
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual ULONG	RegisterCommand (BOOL bMenu, const wchar_t* wcpMenu, wchar_t wcShortcut);
	virtual ULONG	RegisterSelObjSaveFormat (const wchar_t* wcpName, const wchar_t* wcpExt);
//----- 05.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual ULONG	RegisterImportFormat (const wchar_t* wcpName, const wchar_t* wcpExt,
//										long lIsSingleFile);
//----- 05.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	CanCommand ();

	virtual HRESULT	GetProfileBinary (wchar_t* wcpEntry, BYTE* bypBuff, DWORD dwBuffSz) const;
	virtual HRESULT	SetProfileBinary (wchar_t* wcpEntry, const BYTE* bypBuff, DWORD dwBuffSz);
	virtual HRESULT	GetProfileString (wchar_t* wcpEntry, WString& wstrText) const;
	virtual HRESULT	SetProfileString (wchar_t* wcpEntry, const wchar_t* wcpText);

//	virtual HRESULT	PostMessage (UINT Msg, WPARAM wParam, LPARAM lParam);
//	virtual FCObjDynabase*			CreateObject (FTObjectType type) const;
//	virtual CFCFoundDoc*		GetDocument () const;
//	virtual CFCDynamicDrawView*	GetView () const;
//	virtual CFCMainFrame*		GetFrame () const;
//	virtual CFCWndRichEdit*	GetTextEditor () const;
//	virtual FCEnv*			GetEnv () const;
//	virtual FCRegData*		GetRegData () const;
//
//	virtual mmetol		GetDisplayPPM () const;
//	virtual mmetol		GetRealDisplayPPMHorz () const;
//	virtual mmetol		GetRealDisplayPPMVert () const;
//	virtual double		GetZoom () const;
//	virtual double		SetZoom (double dZoom);
//	virtual long		GetOffsetX () const;
//	virtual long		SetOffsetX (long lOffsetX);
//	virtual long		GetOffsetY () const;
//	virtual long		SetOffsetY (long lOffsetY);
//	virtual FTDrawWhich	GetDrawWhich () const;
//	virtual FTDrawWhich	SetDrawWhich (FTDrawWhich drawWhich);
//	virtual CPalette*	GetPalette () const;
//	virtual CPalette*	SetPalette (CPalette* pPalette);
//
//	virtual FCToolBase*	GetTool (DWORD dwIndex) const;

	virtual BOOL		ShowAboutDialog () const;

//	virtual HINSTANCE	ShellExecute (HWND hwnd, const wchar_t* lpVerb,
//												const wchar_t* lpFile,
//												const wchar_t* lpParameters,
//												const wchar_t* lpDirectory,
//												INT nShowCmd) const;
//	virtual HWND	GetMainWindow () const;
//	virtual BOOL	SaveSelectedWMF (const wchar_t* wcpPath,
//												mmetol mmMarginLeft, mmetol mmMarginTop,
//												mmetol mmMarginRight, mmetol mmMarginBottom) const;
//	virtual BOOL	SaveSelectedEMF (const wchar_t* wcpPath,
//												mmetol mmMarginLeft, mmetol mmMarginTop,
//												mmetol mmMarginRight, mmetol mmMarginBottom) const;
//	virtual void*	Allocate (size_t sz);
//	virtual void	Free (void* p);
//
//	virtual IMpgClassInstance*	GetClassInstanceI ();
//
//	virtual IMpgMfcClass*	GetMfcClassI ();
//
////----- 05.05.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	virtual IMpgSet*			GetSetI ();
////----- 06.03.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	virtual IMpgVector*			GetVectorI ();
////	virtual IMpgString*			GetStringI ();
////----- 06.03.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
////----- 05.05.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	virtual const IMpgUtilErr*		GetUtilErrI () const;
//	virtual const IMpgUtilMath*		GetUtilMathI () const;
//	virtual const IMpgUtilFile*		GetUtilFileI () const;
//	virtual const IMpgUtilFont*		GetUtilFontI () const;
//	virtual const IMpgUtilStr*		GetUtilStrI () const;
//	virtual const IMpgUtilDlg*		GetUtilDlgI () const;
//	virtual const IMpgUtilPrint*	GetUtilPrintI () const;
//	virtual const IMpgUtilCoord*	GetUtilCoordI () const;
//	virtual const IMpgUtilZlibPng*	GetUtilZlibPngI () const;
//	virtual const IMpgUtilMisc*		GetUtilMiscI () const;
//
//	virtual IMpgFileConv*	GetFileConvI ();
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	//----- FCIMolipMain native -----

	virtual HRESULT	InitPlugIn ();
	virtual HRESULT	TerminatePlugIn ();

	virtual HRESULT OnCommand (UINT nCmdID);
	virtual HRESULT OnUpdateCommandUI (CCmdUI* pCmdUI);
	virtual HRESULT GetPopHint (WString& wstrHintText, UINT nCmdID);
	virtual wchar_t	RegisterShortcut (wchar_t tcKey);
	virtual HRESULT OnSelectedObjectSave (	UINT nFormatId, const wchar_t* wcpFileName,
											mmetol mmMarginLeft, mmetol mmMarginTop,
											mmetol mmMarginRight, mmetol mmMarginBottom);
// 05.07.29 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual HRESULT	OnFileImport (UINT nFormatId, long lFileCount, const wchar_t* wcpFileName[]);

	FCIMolipMain (HINSTANCE hInstance, IMpgPlugInMain* pIMpgPlugInMain);
	virtual ~FCIMolipMain ();

	virtual GUID	GetCLSID () const;

	virtual IMpgPlugInInfo*	GetPlugInInfoI ();
	virtual IMpgPlugInMain*	GetPlugInMainI ();
	virtual IMpgPlugInFileConv* GetPlugInFileConvI ();

private:
	HINSTANCE			m_hInstance;
	IMpgPlugInInfo*		m_pIMpgPlugInInfo;
	IMpgPlugInMain*		m_pIMpgPlugInMain;
	IMpgPlugInFileConv*	m_pIMpgPlugInFileConv;
	HMENU				m_hSubMenu;
	set<wchar_t>		m_stUsedShortcut;

//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FCISet				m_ifSet;
//	IMpgClassInstance	m_ifClassInstance;
//	FCIMfcClass			m_ifMfcClass;
//	IMpgUtilErr			m_ifUtilErr;
//	IMpgUtilMath		m_ifUtilMath;
//	IMpgUtilFile		m_ifUtilFile;
//	IMpgUtilFont		m_ifUtilFont;
//	IMpgUtilStr			m_ifUtilStr;
//	IMpgUtilDlg			m_ifUtilDlg;
//	IMpgUtilPrint		m_ifUtilPrint;
//	IMpgUtilCoord		m_ifUtilCoord;
//	IMpgUtilZlibPng		m_ifUtilZlibPng;
//	IMpgUtilMisc		m_ifUtilMisc;
//	IMpgFileConv		m_iFileConv;
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
}; // class FCIMolipMain.

////////////////////////////////////////////////////////////////////////////

//----- 05.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//class FCCmdUI : public FCCmdUIWrp
//{
//public:
//	virtual void Enable (BOOL bOn = TRUE);
//	virtual void SetCheck (int nCheck = 1);
//	virtual void SetRadio (BOOL bOn = TRUE);
//	virtual void SetText (const wchar_t* wszText);
//	virtual CCmdUI* GetCmdUI ();
//	FCCmdUI (CCmdUI* pCmdUI);
//	CCmdUI*	m_pCmdUI;
//}; // class FCCmdUI.
//----- 05.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

////////////////////////////////////////////////////////////////////////////

static const wchar_t SHORTCUT_KEYS[] =
{
	L'Q',
	L'W',
	L'E',
	L'R',
	L'T',
	L'A',
	L'S',
	L'D',
	L'F',
	L'G',
	L'Z',
	L'X',
	L'C',
	L'V',
	L'B',
	L'1',
	L'2',
	L'3',
	L'4',
	L'5',
	L'6',
}; // wchar_t SHORTCUT_KEYS[].

const int SHORTCUT_KEYS_SZ = sizeof(SHORTCUT_KEYS) / sizeof(SHORTCUT_KEYS[0]);

////////////////////////////////////////////////////////////////////////////

static FCAutoDeleteCriticalSection s_csLockInterface;
static FCAutoDeleteCriticalSection s_csSuspendMolip;
static FCAutoDeleteCriticalSection s_csIsMolipSuspended;

static long s_lSuspendCount = 0;
static BOOL s_bIsMolipSuspended = FALSE;
static DWORD s_dwMolipThreadId = 0;

typedef map<DWORD, FCIMolipMain*>	DWORDToIMolipMainMap;
static vector<FCIMolipMain*>		s_vIMolipMain;
static map<GUID, FCIMolipMain*>		s_mpPlugInCLSIDToMolipMainI;

static DWORDToIMolipMainMap			s_mpCmdToIMolipMain;			// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ -> FCIMolipMain_xZkqqHx_iBeC_xHqqkZx_
static HMENU		s_hPlugInMenu = NULL;	// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDgHiDgCiDhGiDiBiDgKiDiFiBfLiBeC_xHqqkZx_
set<wchar_t>		s_stUsedShortcut;		// _xZkqqHx_iKpJiCmJiOgHiCoNiCoKiCmEiCkCiCoJiDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiBeC_xHqqkZx_
static DWORDToIMolipMainMap	s_mpExportFormatIdToIMolipMain;	// _xZkqqHx_iDeHiDeOiDfIiDhMiBfLiDgHiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_ID -> FCIMolipMain_xZkqqHx_iBeC_xHqqkZx_

//----- 06.03.21 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// 06.04.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//static FCISet				s_ifSet;
static IMpgClassInstance	s_ifClassInstance;
static FCIMfcClass			s_ifMfcClass;
static FCIStdClass			s_ifStdClass;
static IMpgUtilErr			s_ifUtilErr;
static IMpgUtilMath			s_ifUtilMath;
static IMpgUtilFile			s_ifUtilFile;
static IMpgUtilFont			s_ifUtilFont;
static IMpgUtilStr			s_ifUtilStr;
static IMpgUtilDlg			s_ifUtilDlg;
static IMpgUtilPrint		s_ifUtilPrint;
static IMpgUtilCoord		s_ifUtilCoord;
static IMpgUtilZlibPng		s_ifUtilZlibPng;
static IMpgUtilMisc			s_ifUtilMisc;
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
static IMpgUtilDoc			s_ifUtilDoc;
static IMpgUtilToolbar		s_ifUtilToolbar;
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
static IMpgFileConv			s_ifFileConv;
// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
static IMpgUtilBezier		s_ifUtilBezier;

static IMpgMolipBase		s_ifMolipBase;
//----- 06.03.21 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myAllocate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Allocate_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sz	:_xZkqqHx_iKgNjFnLiClHiCoJiDiBiDiCiDiKiBfLiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKgNjFnLiClDiCoKiClNjHmMiIoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void* myAllocate (size_t sz)
{
	return (void*)new char[sz];
} // myAllocate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myFree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Free_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	p	:_xZkqqHx_iJpAjFpKiClHiCoJiDiBiDiCiDiKiBfLiCmMjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myFree (void* p)
{
	::operator delete(p);
} // myFree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myGlobalRegisterShortcut
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiCpAjDgPjIfOiClHiCoJiBeCiOhHjCoIiClFiClNiDeMiBfLiCkKiOgHiCoNiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_jFmKiCmMiDeMiBfLiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcKey	:_xZkqqHx_jDgPjIfOiClHiCoJiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiClNiDeMiBfLiCpAjFnEiClHiBeCjDgPjIfOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDgPjIfOiCpAjHhGiLiBiClHiCoJiDeMiBfLiCmNiBeBiDeMiBfLiDhLiBfLiDgIiNlGjBkEiCmMiDeMiBfLiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static wchar_t myGlobalRegisterShortcut (wchar_t wcKey)
{
	if (s_stUsedShortcut.find(wcKey) == s_stUsedShortcut.end())
	//----- _xZkqqHx_iDeMiBfLiCkKjDgPjIfOiNmPiCnNiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		for (int iC = 0; iC < SHORTCUT_KEYS_SZ; iC++)
		{
			if (SHORTCUT_KEYS[iC] == wcKey)
			//----- _xZkqqHx_iNlGjBkEiDeMiBfLiCmMiPoKiNiH_xHqqkZx_ -----
			{
				s_stUsedShortcut.insert(SHORTCUT_KEYS[iC]);
				return SHORTCUT_KEYS[iC];
			}
		}
	}
	//----- _xZkqqHx_iDeMiBfLiCkKjDgPjIfOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
	for (int iC = 0; iC < SHORTCUT_KEYS_SZ; iC++)
	{
		if (s_stUsedShortcut.find(SHORTCUT_KEYS[iC]) == s_stUsedShortcut.end())
		//----- _xZkqqHx_iDeMiBfLiCkKjDgPjIfOiNmPiCnNiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			s_stUsedShortcut.insert(SHORTCUT_KEYS[iC]);
			return SHORTCUT_KEYS[iC];
		}
	}
	return L'\0';
} // myGlobalRegisterShortcut.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myRegisterNewCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkCiDfCiDhNiDjDiDgIiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pIMolipMain	:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAjDgPjIfOiClHiCoJ_xHqqkZx_FCIMolipMain_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkCiDfCiDhNiDjDiDgI_xHqqkZx_Id_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfGiDjDiDePiDiLiDfIiDiMiDgCiDgIjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static DWORD myRegisterNewCommand (FCIMolipMain* pIMolipMain)
{
	DWORD dwNewId = ID_PLUGIN_COMMAND_BGN;
	DWORDToIMolipMainMap::iterator iMp;
	for (iMp = s_mpCmdToIMolipMain.begin(); iMp != s_mpCmdToIMolipMain.end(); iMp++, dwNewId++)
	{
		// _xZkqqHx_iLpDiCkLiDfCiDhNiDjDiDgIiCkKiMkJiCmCiCkJiCmBiClNiBeC_xHqqkZx_
		if ((*iMp).first != dwNewId) break;
	}
	// _xZkqqHx_iCoAiCkEiClBiCoKiImIiPoDiDfCiDhNiDjDiDgIiCpAiKiEiCoIjAfFiCoJiClBiCmGiCkKiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
	if (ID_PLUGIN_COMMAND_END < dwNewId) return DWORD(-1);
	// Map_xZkqqHx_iCmJjCgMiCpAjBhNjDpMiBeC_xHqqkZx_
	s_mpCmdToIMolipMain[dwNewId] = pIMolipMain;
	return dwNewId;
} // myRegisterNewCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myIsMolipSuspended
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iCkKiDfEiDfIiDhJiDjDiDgIiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDfIiDhJiDjDiDgIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCIMolipMain::Suspend_xZkqqHx_iCkK_xHqqkZx_PlugIn_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiClNiOjOiCmMjFoCiPjFiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static BOOL myIsMolipSuspended ()
{
	// Molip Draw_xZkqqHx_iCmMiDfEiDfIiDhJiDjDiDgIjFmPjAjEiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	FCAutoLeaveCriticalSection atlcs(s_csIsMolipSuspended);
	BOOL bIsSuspend = s_bIsMolipSuspended;
	return bIsSuspend;
} // myIsMolipSuspended.

////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_g_pDoc = NULL _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiPoKiNiHiCkK_xHqqkZx_
 *			_xZkqqHx_iCkAiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void IMpgMolipBase::Initialize ()
{
	m_pDocument = g_pDoc;
	m_pView = g_pView;
	m_pFrame = g_pFrame;
	m_pTextEditor = g_pView->GetRTFEditor();
	m_pEnv = g_pEnv;
	m_pRegData = g_pReg;
} // IMpgMolipBase::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetStcAppVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiCmMiDhCiDgCiDgHiClCiCmGiCmMiInDjGkBiCmNiImIiJlKiBeC_xHqqkZx_
 *			struct {
 *				WORD	wMajor	: 5;	// _xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
 *				WORD	wMinor	: 5;	// _xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
 *				WORD	wLevelA	: 4;	// _xZkqqHx_iDiMiDhIiDiLiCgAiBeC_xHqqkZx_
 *				WORD	wLevelB	: 2;	// _xZkqqHx_iDiMiDhIiDiLiCgBiBeC_xHqqkZx_
 *			};
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD IMpgMolipBase::GetStcAppVersion () const
{
	return FCHeaderInf::GetStcAppVersion();
} // IMpgMolipBase::GetStcAppVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetStcAppVersionString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* IMpgMolipBase::GetStcAppVersionString () const
{
	return FCHeaderInf::GetStcAppVersionString();
} // IMpgMolipBase::GetStcAppVersionString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetAppMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Dynamic Draw_xZkqqHx_iCmMiDeBiDhGiDiKiOmAiNhDiDiCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDhGiDiKiOmAiNhDiDiCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD IMpgMolipBase::GetAppMode () const
{
	return g_->appMode;		// _xZkqqHx_iDeBiDhGiDiKiOmAiNhDiDiCiBfLiDgIiBeC_xHqqkZx_
} // IMpgMolipBase::GetAppMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetAppLangId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Dynamic Draw_xZkqqHx_iCmMiMlOiMoKiOkPjFmKiOhBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlOiMoKiOkPjFmKiOhBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD IMpgMolipBase::GetAppLangId () const
{
	WString wstrLangId;
	wstrLangId.LoadString(IDS_APP_LANGUAGE_ID);
	return WORD(wcstol(wstrLangId, NULL, 10));
} // IMpgMolipBase::GetAppLangId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::LockInterface
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCIMolipMain_xZkqqHx_iCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_S_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOgHjHhAjCiGiCmJiBeBjBlMiCmM_xHqqkZx_DLL_xZkqqHx_iCkKiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOgHiCmBiCmE_xHqqkZx_
 *			MolipDraw_xZkqqHx_iCmMiPpDjBnEiCpAjFmPiNfIiClFiClNiCoIiClFiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT IMpgMolipBase::LockInterface ()
{
	EnterCriticalSection(&s_csLockInterface.cs);
	return S_OK;
} // IMpgMolipBase::LockInterface.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::UnlockInterface
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCIMolipMain_xZkqqHx_iCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCmMiDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_S_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT IMpgMolipBase::UnlockInterface ()
{
	LeaveCriticalSection(&s_csLockInterface.cs);
	return S_OK;
} // IMpgMolipBase::UnlockInterface.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::Suspend
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iCpAiDfEiDfIiDhJiDjDiDgIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfGiDjDiDePiDiLiDfIiDiMiDgCiDgIiCmMiPoKiNiHiCmNjGoCjBoIjGlDiCkCiCkKiBeBiDhNiDiLiDgAiDfIiDiMiDgCiDgIiCmMiPoKiNiHiBeB_xHqqkZx_
 *			Molip Draw_xZkqqHx_iCkKjDkOiNoMjCiGiCmJ_xHqqkZx_FCIMolipMain_xZkqqHx_iCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCkKiOmAiNhDiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCpAjGgIiCkOiClNiCnPiCmJiBeB_xHqqkZx_Molip Draw_xZkqqHx_iCpAiDfEiDfIiDhJiDjDiDgIiClHiCoJiBeC_xHqqkZx_
 *			SuspendThread_xZkqqHx_iCmFiOhOiCnPiCmEiClFiCnMiCkEiCmGiBeBiCmHiClBiCmFiOhOiCnMiCoJiCkJjElLiCoHiCmIiCkCiCmMiCmFiBeB_xHqqkZx_
 *			PostMessage_xZkqqHx_iCmFiDfEiDfIiDhJiDjDiDgIiDiBiDgCiDfKiBfLiDfHiCpAjBjHiCoIiCmCiCkPiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iOhOiCnMiCoJiPoKiPiKiCpAjDmBjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT IMpgMolipBase::Suspend ()
{
	// _xZkqqHx_iDfGiDjDiDePiDiLiDfIiDiMiDgCiDgIiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (GetCurrentThreadId() == s_dwMolipThreadId) return S_OK;
	// _xZkqqHx_iDeKiDeFiDjDiDfOiCpAiMjPiNlIiBeC_xHqqkZx_
	if (0 < s_lSuspendCount)
	{
		s_lSuspendCount++;
		return S_OK;
	} else
	{
		// Molip Draw_xZkqqHx_iCkK_xHqqkZx_WM_USER_SUSPEND_xZkqqHx_iCmMiPiIjHjNiCmFjCoCiOhOiClHiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
		EnterCriticalSection(&s_csSuspendMolip.cs);
		// Molip Draw_xZkqqHx_iCmJjCoCiOhOiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
		AfxGetMainWnd()->PostMessage(WM_USER_SUSPEND);
		// _xZkqqHx_jCoCiOhOiClHiCoJiCmMiCpAjBnCiCmCiBeC_xHqqkZx_
		while (!myIsMolipSuspended())
		{
			Sleep(100);
		}
		s_lSuspendCount = 1;
		return S_OK;
	}
} // IMpgMolipBase::Suspend.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::Resume
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iCpAiDiMiDfHiDiFiBfLiDiAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT IMpgMolipBase::Resume ()
{
	// _xZkqqHx_iDfGiDjDiDePiDiLiDfIiDiMiDgCiDgIiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (GetCurrentThreadId() == s_dwMolipThreadId) return S_OK;
	// _xZkqqHx_iDeKiDeFiDjDiDfOiCpAiMjPiNlIiBeC_xHqqkZx_
	if (1 < s_lSuspendCount)
	{
		s_lSuspendCount--;
		return S_OK;
	} else
	{
		// Molip Draw_xZkqqHx_iCmMjCoCiOhOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
		LeaveCriticalSection(&s_csSuspendMolip.cs);
		s_lSuspendCount = 0;
		return S_OK;
	}
} // IMpgMolipBase::Resume.

//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::RegisterCommand
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bMenu	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmJjFfMiOkGiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpMenu	:_xZkqqHx_iDfCiDhNiDjDiDgIjGlMjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcShortcut:_xZkqqHx_iDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfGiDjDiDePiDiLiDfIiDiMiDgCiDgIjHhAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//ULONG IMpgMolipBase::RegisterCommand (BOOL bMenu, const wchar_t* wcpMenu, wchar_t wcShortcut)
//{
//	// _xZkqqHx_iDhNiDiLiDgAiDfIiDiMiDgCiDgIiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (GetCurrentThreadId() != s_dwMolipThreadId) return DWORD(-1);
//	// _xZkqqHx_jAfGiClFiCkCiDfCiDhNiDjDiDgIiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
//	DWORD dwNewCmdId = myRegisterNewCommand(this);
//	// _xZkqqHx_iCoAiCkEiKiEiCoIjDjGiCmEiCoJiDfCiDhNiDjDiDgIiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (dwNewCmdId == DWORD(-1)) return DWORD(-1);
//	// _xZkqqHx_iDiBiDgKiDiFiBfLjDgPjIfOiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (!bMenu) return dwNewCmdId;
//	// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiDiBiDgKiDiFiBfLiCkKjGkCjAnNjCoIiCmMiPoKiNiHiBeC_xHqqkZx_
//	if (s_hPlugInMenu == NULL)
//	{
//		s_hPlugInMenu = CreatePopupMenu();
//		// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDiBiDeDiDjDiDiBiDgKiDiFiBfLiCmJjCmHiJmBiClHiCoJiCmMiCmNiBeBiDiBiDeDiDjDiDhEiDiMiBfLiDiAiCkKjFfMiOkGiClDiCoKiCoJiCmGiCkLiBeC_xHqqkZx_
//		// _xZkqqHx_jCmKiPoNiCmMiLeOjDkOiCmMiPoKiNiHiCmNiClBiClBiCmFiCoAjCmHiJmBiCmFiCkLiCoJiCkKiBeB_xHqqkZx_OLE_xZkqqHx_iLeOjDkOiCmMiPoKiNiHiCmNiDiBiDeDiDjDiDiBiDgKiDiFiBfLiCkK_xHqqkZx_
//		// _xZkqqHx_jDpMiCoKjBnGiCoNiCoJiClNiCnPiBeBiClBiClBiCmFiCmNjCmHiJmBiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
////----- 05.06.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAjCmHiJmBiBeC_xHqqkZx_AfxGetMainWnd_xZkqqHx_iCmNiBeBjGkCiClO_xHqqkZx_NULL_xZkqqHx_iCmIiCmMiCmF_xHqqkZx_ g_pFrame_xZkqqHx_iCpAiOgHjHhAiBeC_xHqqkZx_
////		AppendMenu(FFGetMainWnd()->GetWnd()->GetMenu()->m_hMenu, MF_POPUP|MF_STRING,
////					UINT_PTR(s_hPlugInMenu), FFLoadString(IDS_PLUG_IN));
////----- 05.06.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//		// _xZkqqHx_iDiBiDgKiDiFiBfLiCpAiNmEiMhGiOfKiBjFiNmEjFgAiJoGiBeC_xHqqkZx_
//		FFGetMainWnd()->GetWnd()->DrawMenuBar();
//	}
//	// _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiDfEiDhFiDiBiDgKiDiFiBfLiCkKjGkCjAnNjCoIiCmMiPoKiNiHiBeC_xHqqkZx_
//	if (m_hSubMenu == NULL)
//	{
////----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		//----- _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCkJiCoHiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlO_xHqqkZx_ -----
////		IMpgPlugInInfo* pIMpgPlugInInfo = NULL;
////		HRESULT hr = m_pIMpgPlugInMain->QueryInterface(IID_IMpgPlugInInfo, (void**)&pIMpgPlugInInfo);
////		if (FAILED(hr)) return DWORD(-1);
////----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//		//----- _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCpAiNoMjAkM_xHqqkZx_ -----
//		WString strName;
//		wchar_t tcKey = myGlobalRegisterShortcut(m_pIMpgPlugInInfo->GetComponentShortcut());
////----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		if (tcKey != L'\0')
////			strName.Format(L"%s(&%c)", m_pIMpgPlugInInfo->GetComponentName(), tcKey);
////		else
////			strName = m_pIMpgPlugInInfo->GetComponentName();
////----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		if (tcKey != L'\0')
//			strName = FFMakeCommandText(m_pIMpgPlugInInfo->GetComponentName(), tcKey);
//		else
//			strName = m_pIMpgPlugInInfo->GetComponentName();
////----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		//----- _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAjCmHiJmB_xHqqkZx_ -----
//		m_hSubMenu = CreatePopupMenu();
//		AppendMenu(s_hPlugInMenu, MF_POPUP|MF_STRING, UINT_PTR(m_hSubMenu), WStrToTStr(strName));
//// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////		pIMpgPlugInInfo->Release();
//	}
//	WString strName;
//	wchar_t wcKey = RegisterShortcut(wcShortcut);
////----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (wcKey != L'\0')
////		strName.Format(L"%s(&%c)", wcpMenu, wcKey);
////	else
////		strName = wcpMenu;
////----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	if (wcKey != L'\0')
//		strName = FFMakeCommandText(wcpMenu, wcKey);
//	else
//		strName = wcpMenu;
////----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAjCmHiJmBiBeC_xHqqkZx_
//	AppendMenu(m_hSubMenu, MF_STRING, UINT_PTR(dwNewCmdId), WStrToTStr(strName));
//	// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
//	return dwNewCmdId;
//} // IMpgMolipBase::RegisterCommand.
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::RegisterSelObjSaveFormat
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFjEjFgJiCmMjFmKiDhEiDeIiBfLiDhNiDgCiDgHiCmFjFnLjBlGiDfPiDeDiDeBiDiNiDePiCmJiBeBiDhEiDeIiBfLiDhNiDgCiDgHiCpA_xHqqkZx_
// *			_xZkqqHx_jCmHiJmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpName		:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *						_xZkqqHx_jHoBiBeG_xHqqkZx_"JPEG file (*.jpg)"
// *			wcpExt		:_xZkqqHx_iDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_
// *						_xZkqqHx_jHoBiBeG_xHqqkZx_".jpg"
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfGiDjDiDePiDiLiDfIiDiMiDgCiDgIjHhAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//ULONG IMpgMolipBase::RegisterSelObjSaveFormat (const wchar_t* wcpName, const wchar_t* wcpExt)
//{
//	// _xZkqqHx_iDhNiDiLiDgAiDfIiDiMiDgCiDgIiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (GetCurrentThreadId() != s_dwMolipThreadId) return DWORD(-1);
//	// _xZkqqHx_jAfGiClFiCkCiDhEiDeIiBfLiDhNiDgCiDgHiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
//	DWORD dwNewId = g_pDoc->RegisterSelObjSaveFormat(wcpName, wcpExt);
//	// _xZkqqHx_iCoAiCkEiKiEiCoIjDjGiCmEiCoJ_xHqqkZx_id_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (dwNewId == DWORD(-1)) return DWORD(-1);
//	// Map_xZkqqHx_iCmJjCgMiCpAjBhNjDpMiBeC_xHqqkZx_
//	s_mpExportFormatIdToIMolipMain[dwNewId] = this;
//	// Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
//	return dwNewId;
//} // IMpgMolipBase::RegisterSelObjSaveFormat.
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::RegisterImportFormat
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlMiMgAiOkOiCmMiDhEiDeAiDeDiDiLjDmHiNjOiCnNiDfPiDeDiDeBiDiNiDePiCmJiBeBiDhEiDeIiBfLiDhNiDgCiDgHiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpName		:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *						_xZkqqHx_jHoBiBeG_xHqqkZx_"JPEG file (*.jpg)"
// *			wcpExt		:_xZkqqHx_iDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_
// *						_xZkqqHx_jHoBiBeG_xHqqkZx_".jpg"
// *			lIsSingleFile	:_xZkqqHx_iIoKjDhIiCmJ_xHqqkZx_1_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiCnNjBeJjBpAiCkJiBeBjFkBjAjEiDhEiDeAiDeDiDiLjBeJjBpAiCkJiBeI_xHqqkZx_
// *						0: _xZkqqHx_iDhNiDiLiDgAjBeJjBpAiBeB_xHqqkZx_1:_xZkqqHx_iDfGiDjDiDePiDiLjBeJjBpAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfGiDjDiDePiDiLiDfIiDiMiDgCiDgIjHhAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//ULONG IMpgMolipBase::RegisterImportFormat (const wchar_t* wcpName, const wchar_t* wcpExt,
//								long lIsSingleFile)
//{
//	// _xZkqqHx_iDhNiDiLiDgAiDfIiDiMiDgCiDgIiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (GetCurrentThreadId() != s_dwMolipThreadId) return DWORD(-1);
//	// _xZkqqHx_jAfGiClFiCkCiDhEiDeIiBfLiDhNiDgCiDgHiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
//	DWORD dwNewId = g_pDoc->RegisterImportFormat(wcpName, wcpExt,
//												lIsSingleFile);
//	// _xZkqqHx_iCoAiCkEiKiEiCoIjDjGiCmEiCoJ_xHqqkZx_id_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (dwNewId == DWORD(-1)) return DWORD(-1);
//	// Map_xZkqqHx_iCmJjCgMiCpAjBhNjDpMiBeC_xHqqkZx_
//	s_mpImportFormatIdToIMolipMain[dwNewId] = this;
//	// Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
//	return dwNewId;
//} // IMpgMolipBase::RegisterImportFormat.
//----- 05.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::CanCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CmdGate_xZkqqHx_iCmMiDfCiDhNiDjDiDgIiCkKjEkNiNhDiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jEkNiNhDiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFlGiPjBiCmMiDeJiBfLiDhGiDjDiPpDjBnEiBeBiDgDiBfLiDiLiCmMjBeJjBpAiBeBiDgDiBfLiDiLiCmMiPpDjBnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL IMpgMolipBase::CanCommand ()
{
	if (FFCanEditDocument() &&
		!g_pDoc->IsOleDocumentsOpened() &&
		g_pToolManager->Tool2CommandID(g_pView->GetCurrentTool()) == ID_TOOL_SELEDIT &&
		((FCToolBaseFDA*)g_pView->GetCurrentTool())->GetCurrentState() == FCToolBaseFDA::STATE_IDLE &&
		g_pDoc->GetSessionDepth() == 0) return TRUE;
	return FALSE;
} // IMpgMolipBase::CanCommand.

//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetProfileBinary
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfHiDfIiDgHiDiKiCkJiCoHiBeBiDgPiDeDiDgJiDiKiDgGiBfLiDfOiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpEntry	:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiDeHiDjDiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			bypBuff		:_xZkqqHx_iDgPiDeDiDgJiDiKiDgGiBfLiDfOiCpAiOoGjDlOiClHiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
// *			dwBuffSz	:_xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//HRESULT IMpgMolipBase::GetProfileBinary (wchar_t* wcpEntry, BYTE* bypBuff, DWORD dwBuffSz) const
//{
//	WString strSection;
//	strSection.Format(L"PlugInData\\{%s}", FFGuidToString(GetCLSID()).c_str());
//	if (g_pReg->LoadRegBinary(strSection, wcpEntry, bypBuff, dwBuffSz))
//		return S_OK;
//	else
//		return E_FAIL;
//} // IMpgMolipBase::GetProfileBinary.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::SetProfileBinary
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfHiDfIiDgHiDiKiCmJiBeBiDgPiDeDiDgJiDiKiDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpEntry	:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiDeHiDjDiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			bypBuff		:_xZkqqHx_iPjBiCkLiNjOiCnOiDgPiDeDiDgJiDiKiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			dwBuffSz	:_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPjBiCkLiNjOiCnNiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//HRESULT IMpgMolipBase::SetProfileBinary (wchar_t* wcpEntry, const BYTE* bypBuff, DWORD dwBuffSz)
//{
//	WString strSection;
//	strSection.Format(L"PlugInData\\{%s}", FFGuidToString(GetCLSID()).c_str());
//	g_pReg->SaveRegBinary(strSection, wcpEntry, bypBuff, dwBuffSz);
//	return S_OK;
//} // IMpgMolipBase::SetProfileBinary.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetProfileString
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfHiDfIiDgHiDiKiCkJiCoHiBeBiDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpEntry	:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiDeHiDjDiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			wstrText	:_xZkqqHx_iDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAiOoGjDlOiClHiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//HRESULT IMpgMolipBase::GetProfileString (wchar_t* wcpEntry, WString& wstrText) const
//{
//	WString strSection;
//	strSection.Format(L"PlugInData\\{%s}", FFGuidToString(GetCLSID()).c_str());
//	if (g_pReg->LoadRegString(strSection, wcpEntry, wstrText))
//		return S_OK;
//	else
//		return E_FAIL;
//} // IMpgMolipBase::GetProfileString.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::SetProfileString
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfHiDfIiDgHiDiKiCmJiBeBiDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpEntry	:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiDeHiDjDiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpText		:_xZkqqHx_iPjBiCkLiNjOiCnOiDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPjBiCkLiNjOiCnNiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//HRESULT IMpgMolipBase::SetProfileString (wchar_t* wcpEntry, const wchar_t* wcpText)
//{
//	WString strSection;
//	strSection.Format(L"PlugInData\\{%s}", FFGuidToString(GetCLSID()).c_str());
//	g_pReg->SaveRegString(strSection, wcpEntry, wcpText);
//	return S_OK;
//} // IMpgMolipBase::SetProfileString.
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::PostMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iCmJiDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	Msg		:_xZkqqHx_iDhMiDfIiDgHiClHiCoJiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wParam	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhMiDfIiDgHiPgPjHiIiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Molip Draw_xZkqqHx_iCpAiDiNiDgCiDeOiClHiCoJiClBiCmGiCmIiCkNjFmKiDfIiDiMiDgCiDgIiCkJiCoHiOmAiNhDiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL IMpgMolipBase::PostMessage (UINT Msg, WPARAM wParam, LPARAM lParam)
{
	if (AfxGetMainWnd() == NULL) return FALSE;
	return AfxGetMainWnd()->PostMessage(Msg, wParam, lParam);
} // IMpgMolipBase::PostMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::SendMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iCmJiDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	Msg		:_xZkqqHx_iDhMiDfIiDgHiClHiCoJiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wParam	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhMiDfIiDgHiPgPjHiIiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Molip Draw_xZkqqHx_iCpAiDiNiDgCiDeOiClHiCoJiClBiCmGiCmIiCkNjFmKiDfIiDiMiDgCiDgIiCkJiCoHiOmAiNhDiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT IMpgMolipBase::SendMessage (UINT Msg, WPARAM wParam, LPARAM lParam)
{
	if (AfxGetMainWnd() == NULL) return E_FAIL;
	if (AfxGetMainWnd()->SendMessage(Msg, wParam, lParam)) return S_OK;
	return E_FAIL;
} // IMpgMolipBase::SendMessage.

//----- 01.08.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::EnableFrameWindow
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iCmMiDhEiDiMiBfLiDiAiDeFiDeCiDjDiDgIiDeFiCmMjDpMjHmNiCpAjAkHiMoEiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bEnable	:_xZkqqHx_jDpMjHmNiJmCiCmMiOjOiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCiCmMiOjOiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIjBePiCmMiPpDjBnEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL IMpgMolipBase::EnableFrameWindow (BOOL bEnable)
//{
//	return AfxGetMainWnd()->EnableWindow(bEnable);
//} // IMpgMolipBase::EnableFrameWindow.
//----- 01.08.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.08.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetClientRect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iCmM_xHqqkZx_View_xZkqqHx_iCmMjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrt	:_xZkqqHx_jHmMiIoGiCpAiOpDiCkPiOoGiCoJjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void IMpgMolipBase::GetClientRect (DBLRect& mmrt)
//{
//	// _xZkqqHx_iJoGjGmKiCmMjFfMiOkGjHmMiIoGiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	g_pView->GetClientRectMM(mmrt);
//} // IMpgMolipBase::GetClientRect.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetSelectObject
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCkJiCoHiBeBiOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIdx	:_xZkqqHx_jFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDeJiDhFiDfHiDeGiDeOiDgHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmN_xHqqkZx_PlugIn_xZkqqHx_jBkEiCmFiJpAjFpKiClHiCoJjFeLjHhGiCkKjGlDiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const FCObjectExp* IMpgMolipBase::GetSelectObject (long lIdx) const
//{
//	if (g_pView->SelectObjVector().size() <= lIdx) return NULL;
//	return (const FCObjectExp*)g_pView->SelectObjVector()[lIdx];
//} // IMpgMolipBase::GetSelectObject.
//----- 01.08.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::CreateObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfOiDeDiDhGiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	type	:_xZkqqHx_jFjEjFgJiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKjFhDjHhGiCmJiCmIiCmBiClNiPoKiNiHiCmNiBeB_xHqqkZx_PlugIn_xZkqqHx_jBkEiCmFiJpAjFpKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCmMjDgPjIfOiDfCiDhNiDjDiDgIiCmIiCmHiCmF_xHqqkZx_Molip Draw_xZkqqHx_iCmJjBgHiCnNiNjOiCpBiClOiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iClLiCmMjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* IMpgMolipBase::CreateObject (FTObjectType type) const
{
	FCObjDynabase* pObj = NewFDObjAny(type);
	pObj->CalcResizeFrame();
// 05.05.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	pObj->CalcOuterFrame();
	return pObj;
} // IMpgMolipBase::CreateObject.

//----- 03.07.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetDocumentWrp
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDgCiDhGiClDiCoKiClNiDgIiDeMiDiFiDiBiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCDocumentWrp* IMpgMolipBase::GetDocumentWrp () const
//{
//	return &s_Document;
//} // IMpgMolipBase::GetDocumentWrp.
//----- 03.07.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 03.07.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetViewWrp
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDgCiDhGiClDiCoKiClNiDhCiDiFiBfLiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCViewWrp* IMpgMolipBase::GetViewWrp () const
//{
//	return &s_View;
//} // IMpgMolipBase::GetViewWrp.
//----- 03.07.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 03.07.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetFrameWrp
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDgCiDhGiClDiCoKiClNiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCFrameWrp* IMpgMolipBase::GetFrameWrp () const
//{
//	return &s_Frame;
//} // IMpgMolipBase::GetFrameWrp.
//----- 03.07.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 03.07.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetTextEditorWrp
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDgCiDhGiClDiCoKiClNiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	PlugIn_xZkqqHx_jBkEiCmFiJpAjFpKiClHiCoJjFeLjHhGiCmNjGlDiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCTextEditorWrp* IMpgMolipBase::GetTextEditorWrp () const
//{
//	return &s_TextEditor;
//} // IMpgMolipBase::GetTextEditorWrp.
//----- 03.07.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCFoundDoc* IMpgMolipBase::GetDocument () const
{
	return m_pDocument;
} // IMpgMolipBase::GetDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDynamicDrawView* IMpgMolipBase::GetView () const
{
	return m_pView;
} // IMpgMolipBase::GetView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCMainFrame* IMpgMolipBase::GetFrame () const
{
	return m_pFrame;
} // IMpgMolipBase::GetFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetTextEditor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCWndRichEdit* IMpgMolipBase::GetTextEditor () const
{
	return m_pTextEditor;
} // IMpgMolipBase::GetTextEditor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetEnv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCEnv* IMpgMolipBase::GetEnv () const
{
	return m_pEnv;
} // IMpgMolipBase::GetEnv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetRegData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCRegData* IMpgMolipBase::GetRegData () const
{
	return m_pRegData;
} // IMpgMolipBase::GetRegData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetDisplayPPM
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	 _xZkqqHx_iDgGiDeCiDfIiDhGiDiMiDeDiCmMjIfPjHjNiDhOiDiKjCfAiImKiCmMiDhDiDeOiDfKiDiLjAjE_xHqqkZx_(g_->dDisplayPPM)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol IMpgMolipBase::GetDisplayPPM () const
{
	return g_->dDisplayPPM;
} // IMpgMolipBase::GetDisplayPPM.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetRealDisplayPPMHorz
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Display_xZkqqHx_iCmMjAiFjFlNjFpLiMpMiCmMjIfPjHjNiDhOiDiKjCfAiImKiCmMiDhDiDeOiDfKiDiLjAjE_xHqqkZx_
 *			(HORZRES/HORZSIZE_xZkqqHx_iCmFiOoGjDlO_xHqqkZx_)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol IMpgMolipBase::GetRealDisplayPPMHorz () const
{
	return g_->dRealDisplayPPMHorz;
} // IMpgMolipBase::GetRealDisplayPPMHorz.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetRealDisplayPPMVert
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Display_xZkqqHx_iCmMjAiCjClMjFpLiMpMiCmMjIfPjHjNiDhOiDiKjCfAiImKiCmMiDhDiDeOiDfKiDiLjAjE_xHqqkZx_
 *			(VERTRES/VERTSIZE_xZkqqHx_iCmFiOoGjDlO_xHqqkZx_)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol IMpgMolipBase::GetRealDisplayPPMVert () const
{
	return g_->dRealDisplayPPMVert;
} // IMpgMolipBase::GetRealDisplayPPMVert.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiA_xHqqkZx_(g_->dZoom)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double IMpgMolipBase::GetZoom () const
{
	return g_->dZoom;
} // IMpgMolipBase::GetZoom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::SetZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiA_xHqqkZx_(g_->dZoom)_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeCjAnNjCoIjBePiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double IMpgMolipBase::SetZoom (double dZoom)
{
	double dZoomOld = g_->dZoom;
	g_->dZoom = dZoom;
	return dZoomOld;
} // IMpgMolipBase::SetZoom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetOffsetX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long IMpgMolipBase::GetOffsetX () const
{
	return g_->lgOffsetX;
} // IMpgMolipBase::GetOffsetX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::SetOffsetX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiCpAjAnNjCoIiClHiCoJiBeCiMmDiCkCjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long IMpgMolipBase::SetOffsetX (long lOffsetX)
{
	long lgOffsetXOld = g_->lgOffsetX;
	g_->lgOffsetX = lOffsetX;
	return lgOffsetXOld;
} // IMpgMolipBase::SetOffsetX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetOffsetY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiCjClMjFpLiMpMiCmMiDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long IMpgMolipBase::GetOffsetY () const
{
	return g_->lgOffsetY;
} // IMpgMolipBase::GetOffsetY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::SetOffsetY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiCjClMjFpLiMpMiCmMiDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiCpAjAnNjCoIiClHiCoJiBeCiMmDiCkCjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long IMpgMolipBase::SetOffsetY (long lOffsetY)
{
	long lgOffsetYOld = g_->lgOffsetY;
	g_->lgOffsetY = lOffsetY;
	return lgOffsetYOld;
} // IMpgMolipBase::SetOffsetY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetDrawWhich
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFgAiJoGiDiCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFgAiJoGiDiCiBfLiDgIiCmNiBeBjEhHiMgJjAhNiBgJiDiBiDfOiDhEiDeAiDeDiDiLiBgKiCoCjFjEjFgJiCmMiDhFiDiJiDfGjGmNjHgMiCmM_xHqqkZx_
 *			_xZkqqHx_jFgAiJoGjFpLjGeAiCmJiJgFiLlPiCpAjHfOiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDrawWhich IMpgMolipBase::GetDrawWhich () const
{
	return g_->eDrawWhich;
} // IMpgMolipBase::GetDrawWhich.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::SetDrawWhich
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFgAiJoGiDiCiBfLiDgIiCpAjAnNjCoIiClHiCoJiBeCiMmDiCkCjFgAiJoGiDiCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFgAiJoGiDiCiBfLiDgIiCmNiBeBjEhHiMgJjAhNiBgJiDiBiDfOiDhEiDeAiDeDiDiLiBgKiCoCjFjEjFgJiCmMiDhFiDiJiDfGjGmNjHgMiCmM_xHqqkZx_
 *			_xZkqqHx_jFgAiJoGjFpLjGeAiCmJiJgFiLlPiCpAjHfOiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDrawWhich IMpgMolipBase::SetDrawWhich (FTDrawWhich drawWhich)
{
	FTDrawWhich eDrawWhichOld = g_->eDrawWhich;
	g_->eDrawWhich = drawWhich;
	return eDrawWhichOld;
} // IMpgMolipBase::SetDrawWhich.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetPalette
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFgAiJoGjHhAiDhAiDiMiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFgAiJoGiDhAiDiMiDgCiDgHiCmNiBeB_xHqqkZx_256_xZkqqHx_jAeGiDiCiBfLiDgIiCmIiCmHiBeBiDhAiDiMiDgCiDgHiCkKjFeLjHhGiCmIjFgAiJoGiCmJ_xHqqkZx_
 *			_xZkqqHx_iOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPalette* IMpgMolipBase::GetPalette () const
{
	return g_pFDPalette;
} // IMpgMolipBase::GetPalette.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::SetPalette
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFgAiJoGjHhAiDhAiDiMiDgCiDgHiCpAjAnNjCoIiClHiCoJiBeCiMmDiCkCiDhAiDiMiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jFgAiJoGiDhAiDiMiDgCiDgHiCmNiBeB_xHqqkZx_256_xZkqqHx_jAeGiDiCiBfLiDgIiCmIiCmHiBeBiDhAiDiMiDgCiDgHiCkKjFeLjHhGiCmIjFgAiJoGiCmJ_xHqqkZx_
 *			_xZkqqHx_iOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPalette* IMpgMolipBase::SetPalette (CPalette* pPalette)
{
	CPalette* pFDPaletteOld = g_pFDPalette;
	g_pFDPalette = pPalette;
	return pFDPaletteOld;
} // IMpgMolipBase::SetPalette.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDgDiBfLiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_iDgDiBfLiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.10.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCToolBase* IMpgMolipBase::GetTool (DWORD dwIndex) const
{
	return g_pToolManager->GetTool(dwIndex);
} // IMpgMolipBase::GetTool.

//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::ShowAboutDialog
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmM_xHqqkZx_ABOUT_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.12.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL IMpgMolipBase::ShowAboutDialog () const
//{
////----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//----- _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCkJiCoHiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlO_xHqqkZx_ -----
////	IMpgPlugInInfo* pIMpgPlugInInfo = NULL;
////	HRESULT hr = m_pIMpgPlugInMain->QueryInterface(IID_IMpgPlugInInfo,
////													(void**)&pIMpgPlugInInfo);
////	if (FAILED(hr)) return FALSE;
////----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	CFCDlgPlugInAboutbox dlg;
//	if (m_pIMpgPlugInInfo->GetComponentName() != NULL)
//	{
//		dlg.m_strPlugInName = m_pIMpgPlugInInfo->GetComponentName();
//		dlg.m_strPlugInName.Remove(_T('\r'));
//	}
//	if (m_pIMpgPlugInInfo->GetVersionName() != NULL)
//	{
//		dlg.m_strPlugInVersion = m_pIMpgPlugInInfo->GetVersionName();
//		dlg.m_strPlugInName.Remove(_T('\r'));
//	}
//	if (m_pIMpgPlugInInfo->GetAuthorName() != NULL)
//	{
//		dlg.m_strAuthor = m_pIMpgPlugInInfo->GetAuthorName();
//		dlg.m_strPlugInName.Remove(_T('\r'));
//	}
////----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (m_pIMpgPlugInInfo->GetSupportInfo() != NULL)
////	{
////		dlg.m_strSupportInfo = m_pIMpgPlugInInfo->GetSupportInfo();
////		dlg.m_strPlugInName.Remove(_T('\r'));
////	}
////----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// DLL_xZkqqHx_iPoOjFpBiOoGjDlOjHhAiCmMiKnGjAjEiCpAiMjPiNpFiBeC_xHqqkZx_
//	FuncMolipSupportInfo lpfnMolipSupportInfo = (FuncMolipSupportInfo)GetProcAddress(m_hInstance, "DllMolipSupportInfo");
//	// DLL_xZkqqHx_iCmMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
//	const wchar_t* wcpSupportInfo;
//	if (SUCCEEDED((*lpfnMolipSupportInfo)(NULL, NULL, NULL, &wcpSupportInfo)))
//	{
//		dlg.m_strSupportInfo = wcpSupportInfo;
//		dlg.m_strPlugInName.Remove(_T('\r'));
//	}
////----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	if (m_pIMpgPlugInInfo->GetComment() != NULL)
//	{
//		dlg.m_strComment = m_pIMpgPlugInInfo->GetComment();
//		dlg.m_strPlugInName.Remove(_T('\r'));
//	}
//	dlg.DoModal();
//
//// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	pIMpgPlugInInfo->Release();
//	return TRUE;
//} // IMpgMolipBase::ShowAboutDialog.
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.08.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::CommandCreateObject
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjAfGiLeLjDgPjIfOiCmMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	obj		:_xZkqqHx_jAfGiLeLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lZPos	:_xZkqqHx_jDgPjIfOiClHiCoJ_xHqqkZx_LayerManager_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCjDgPjIfOiMoDiCmJjFjEjFgJiCmN_xHqqkZx_
// *					 _xZkqqHx_iClBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmJiCmIiCoJiBeC_xHqqkZx_LayerManager_xZkqqHx_iCmMiNmFiMoDiCmJjDgPjIfOiClHiCoJiPoKiNiHiCmN_xHqqkZx_
// *					 -1_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			bIsRegisterId:_xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjDgPjIfOiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lZPos_xZkqqHx_iCmM_xHqqkZx_LayerManager_xZkqqHx_iCmNiBeBjFfMiOkGiCmMiPiHjEnEiCpAiKmHjHjNiClHiCoJiBeC_xHqqkZx_bIsRegisterId_xZkqqHx_iCmNiBeB_xHqqkZx_
// *			_xZkqqHx_jCmKiPoNiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//HRESULT IMpgMolipBase::CommandCreateObject (FCObjectExp& obj, long lZPos, BOOL bIsRegisterId)
//{
//	FCObjDynabase& base = (FCObjDynabase&)obj;
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//	// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	if (bIsRegisterId) base.RegisterObjID();
//	// _xZkqqHx_jFjEjFgJjAlGjAkMiCmMiLeMjIfOiBeC_xHqqkZx_
//	g_pDoc->CmdCreate1Obj(&base, FCLayerZOrder(DWORD(-1), lZPos));
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
//	// _xZkqqHx_jFjEjFgJiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//	g_pView->AddRgn(&base);
//	g_pView->SendRgnRedraw();
//	return S_OK;
//} // IMpgMolipBase::WriteCommand.
//----- 01.08.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::ShellExecute
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ShellExecute_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ShellExecute_xZkqqHx_iCmMiDhHiDiLiDhGiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	ShellExecute_xZkqqHx_iCmMiDhHiDiLiDhGiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 01.08.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//HINSTANCE IMpgMolipBase::ShellExecute (HWND hwnd, LPCTSTR lpVerb, LPCTSTR lpFile,
//									LPCTSTR lpParameters, LPCTSTR lpDirectory,
//									INT nShowCmd) const
//{
//	return ::ShellExecute(hwnd, lpVerb, lpFile, lpParameters, lpDirectory, nShowCmd);
//} // IMpgMolipBase::ShellExecute.
//----- 01.08.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
HINSTANCE IMpgMolipBase::ShellExecute (HWND hwnd, const wchar_t* lpVerb,
									const wchar_t* lpFile,
									const wchar_t* lpParameters,
									const wchar_t* lpDirectory,
									INT nShowCmd) const
{
	return ::ShellExecute(hwnd, WStrToTStr(lpVerb), WStrToTStr(lpFile),
								WStrToTStr(lpParameters), WStrToTStr(lpDirectory),
								nShowCmd);
} // IMpgMolipBase::ShellExecute.
//----- 01.08.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetMainWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDeDiDjDiDhEiDiMiBfLiDiAiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HWND IMpgMolipBase::GetMainWindow () const
{
	return AfxGetMainWnd()->GetSafeHwnd();
} // IMpgMolipBase::GetMainWindow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::SaveSelectedWMF
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDiBiDfOiDhEiDeAiDeDiDiLiCpAiOhHjCoIiCmMiDhEiDeAiDeDiDiLiCmJjFnLjBlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPath	:_xZkqqHx_jFnLjBlGiClHiCoJiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL IMpgMolipBase::SaveSelectedWMF (const wchar_t* wcpPath,
									mmetol mmMarginLeft, mmetol mmMarginTop,
									mmetol mmMarginRight, mmetol mmMarginBottom) const
{
	return CFCMolipDrawSrvrItem::SaveSelectedWMF(wcpPath,
												mmMarginLeft, mmMarginTop,
												mmMarginRight, mmMarginBottom);
} // IMpgMolipBase::SaveSelectedWMF.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::SaveSelectedEMF
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFjEjFgJiCmMiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCpAiOhHjCoIiCmMiDhEiDeAiDeDiDiLiCmJjFnLjBlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPath	:_xZkqqHx_jFnLjBlGiClHiCoJiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL IMpgMolipBase::SaveSelectedEMF (const wchar_t* wcpPath,
									mmetol mmMarginLeft, mmetol mmMarginTop,
									mmetol mmMarginRight, mmetol mmMarginBottom) const
{
	return CFCMolipDrawSrvrItem::SaveSelectedEMF(wcpPath,
												mmMarginLeft, mmMarginTop,
												mmMarginRight, mmMarginBottom);
} // IMpgMolipBase::SaveSelectedEMF.

//----- 03.06.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::FFMakeUniqTmpFileName
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLjFmPjAjE_xHqqkZx_'TMP'_xZkqqHx_iCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiClFiBeBiClLiCmMiJlKiCmJiDiGiDgKiBfLiDeOiCmI_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpNameBuff	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeCiPfMjFkKiCmIjBoFiCkLiClDiCmMiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpPreName	:_xZkqqHx_iMlDiCmGiCmIiCoJiDhEiDeAiDeDiDiLjGlMiCmMiBeBiKgHjCkDiOhBiCpAiPjMiCkCiClNjFjEjFkKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *			wcpExt		:_xZkqqHx_iMlDiCmGiCmIiCoJiDhEiDeAiDeDiDiLjGlMiCmMiBeBiKgHjCkDiOhBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	MakeUniqFileName_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
// *			_xZkqqHx_jHoBiBeG_xHqqkZx_TMP_xZkqqHx_jFmPjAjE_xHqqkZx_ = "C:\TMP", wcpPreName = "HELLO", wcpExt = ".TXT"_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
// *				strName = "C:\TMP\HELLO_1f.TXT"
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL IMpgMolipBase::FFMakeUniqTmpFileName (wchar_t* wcpNameBuff, const wchar_t* wcpPreName,
//													const wchar_t* wcpExt) const
//{
//	try
//	{
//		WString strName;
//		::FFMakeUniqTmpFileName(strName, wcpPreName, wcpExt);
//		wcscpy(wcpNameBuff, strName);
//	} catch (CException* e)
//	//-----	_xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
//	{
//		e->Delete();
//		return FALSE;
//	}
//	return TRUE;
//} // IMpgMolipBase::FFMakeUniqTmpFileName.
//----- 03.06.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.08.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::New
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFmPjAjEjHmMiIoGiCpAiKgNjFnLiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void IMpgMolipBase::New (DBLPointVector*& p)
//{
//	p = new DBLPointVector();
//} // IMpgMolipBase::New.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::Delete
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	New _xZkqqHx_iCmFiKiEiCoIjDjGiCmEiClNjFmPjAjEjHmMiIoGiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void IMpgMolipBase::Delete (DBLPointVector* p)
//{
//	delete p;
//} // IMpgMolipBase::Delete.
//----- 01.08.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::Allocate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFmPjAjEjHmMiIoGiCpAiKgNjFnLiClFiCmEjFnEiClHiBeC_xHqqkZx_STL_xZkqqHx_iCmM_xHqqkZx_allocator_xZkqqHx_jHhAiCmJiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sz	:_xZkqqHx_iKgNjFnLiClHiCoJjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void* IMpgMolipBase::Allocate (size_t sz)
{
// 06.03.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return new char[sz];
	return myAllocate(sz);
} // IMpgMolipBase::Allocate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::Free
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	New _xZkqqHx_iCmFiKiEiCoIjDjGiCmEiClNjFmPjAjEjHmMiIoGiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void IMpgMolipBase::Free (void* p)
{
// 06.03.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	delete[] (char*)p;
	myFree(p);
} // IMpgMolipBase::Free.

//----- 05.05.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::CreateFCInstance
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeOiDiJiDfIiCmMiDeDiDjDiDfIiDfOiDjDiDfIiCpAiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cpClassName	:_xZkqqHx_iDeOiDiJiDfIjGlMiCpAiOhHjCoIiBeCjHoB_xHqqkZx_:"FCUndoArchive"
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiDeDiDjDiDfIiDfOiDjDiDfIiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void* IMpgMolipBase::CreateFCInstance (const char* cpClassName)
//{
//	return FFCreateFCInstance(cpClassName);
//} // IMpgMolipBase::CreateFCInstance.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::DeleteFCInstance
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeOiDiJiDfIiCmMiDeDiDjDiDfIiDfOiDjDiDfIiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cpClassName	:_xZkqqHx_iDeOiDiJiDfIjGlMiCpAiOhHjCoIiBeCjHoB_xHqqkZx_:"FCUndoArchive"
// *			pInstance	:_xZkqqHx_iNoNiPjMiClHiCoJiDeDiDjDiDfIiDfOiDjDiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void IMpgMolipBase::DeleteFCInstance (const char* cpClassName, void* pInstance)
//{
//	FFDeleteFCInstance(cpClassName, pInstance);
//} // IMpgMolipBase::DeleteFCInstance.
//----- 05.05.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetClassInstanceI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCmMiDeDiDjDiDfIiDfOiDjDiDfIiCpAiNoMjAkMiBeFiNoNiPjMiClHiCoJiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgClassInstance* IMpgMolipBase::GetClassInstanceI ()
{
	return &s_ifClassInstance;
} // IMpgMolipBase::GetClassInstanceI.

//----- 05.05.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetMfcClassI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MFC6.0_xZkqqHx_iCmM_xHqqkZx_virtual_xZkqqHx_iCmFiCmIiCkCiDeOiDiJiDfIiKnGjAjEiCpAiMpGiKeKiClHiCoJiClNiCnPiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfI_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgMfcClass* IMpgMolipBase::GetMfcClassI ()
{
	return &s_ifMfcClass;
} // IMpgMolipBase::GetMfcClassI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetStdClassI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MFC6.0_xZkqqHx_iCmM_xHqqkZx_virtual_xZkqqHx_iCmFiCmIiCkCiDeOiDiJiDfIiKnGjAjEiCpAiMpGiKeKiClHiCoJiClNiCnPiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfI_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgStdClass* IMpgMolipBase::GetStdClassI ()
{
	return &s_ifStdClass;
} // IMpgMolipBase::GetStdClassI.

//----- 05.05.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 02.06.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (DWORDSet _xZkqqHx_iCmNiBeBjDoAjFjEiCmJ_xHqqkZx_static_xZkqqHx_jFmPjAjEiCpAiOjNiCmCiClNiCnPiBeBiInJiCmIiCoJiDiCiDfHiDiFiBfLiDiLiKnEiCmFjDgOiClJiCmIiCkC_xHqqkZx_)-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetDWORDSetI
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DWORDSet _xZkqqHx_iCmNiBeBjDoAjFjEiCmJ_xHqqkZx_static_xZkqqHx_jFmPjAjEiCpAiOjNiCmCiClNiCnPiBeBiInJiCmIiCoJiDiCiDfHiDiFiBfLiDiLiKnEiCmF_xHqqkZx_
// *			_xZkqqHx_jDgOiClJiCmIiCkCiBeCiClBiCmMiClNiCnPiBeBjDmBjFmKiCmJiDiJiDgCiDhGiClFiClN_xHqqkZx_DWORDSet_xZkqqHx_iDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
// *			_xZkqqHx_iClLiCmMiDiBiDjDiDgPiOmAiNhDjHhAiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	DWORDSet_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.06.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//IMpgDWORDSet* IMpgMolipBase::GetDWORDSetI ()
//{
//	return &s_ifDWORDSet;
//} // IMpgMolipBase::GetDWORDSetI.
////----- 02.06.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (DWORDSet _xZkqqHx_iCmNiBeBjDoAjFjEiCmJ_xHqqkZx_static_xZkqqHx_jFmPjAjEiCpAiOjNiCmCiClNiCnPiBeBiInJiCmIiCoJiDiCiDfHiDiFiBfLiDiLiKnEiCmFjDgOiClJiCmIiCkC_xHqqkZx_)-----
//----- 05.05.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


//----- 05.05.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//----- 06.04.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetSetI
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//IMpgSet* IMpgMolipBase::GetSetI ()
//{
//	return &s_ifSet;
//} // IMpgMolipBase::GetSetI ().
//----- 06.04.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.03.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetVectorI
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//IMpgVector* IMpgMolipBase::GetVectorI ()
//{
//	return &s_ifVector;
//} // IMpgMolipBase::GetVectorI ().
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetStringI
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//IMpgString* IMpgMolipBase::GetStringI ()
//{
//	return &s_ifString;
//} // IMpgMolipBase::GetStringI ().
//----- 06.03.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.05.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----



//----- 03.06.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetMathUtilI
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAjEjCgMiJiJiOfKiKnGiMfHiCmMiKnGjAjEiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnGjAjEiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const IMpgMathUtil* IMpgMolipBase::GetMathUtilI () const
//{
//	return &s_ifMathUtil;
//} // IMpgMolipBase::GetMathUtilI.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetFileUtilI
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const IMpgFileUtil* IMpgMolipBase::GetFileUtilI () const
//{
//	return &s_ifFileUtil;
//} // IMpgMolipBase::GetFileUtilI.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetFontUtilI
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const IMpgFontUtil* IMpgMolipBase::GetFontUtilI () const
//{
//	return &s_ifFontUtil;
//} // IMpgMolipBase::GetFontUtilI.
//----- 03.06.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilErrI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiKnGiMfHiCmMiKnGjAjEiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnGjAjEiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilErr* IMpgMolipBase::GetUtilErrI () const
{
	return &s_ifUtilErr;
} // IMpgMolipBase::GetUtilErrI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilMathI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAjEjCgMiJiJiOfKiKnGiMfHiCmMiKnGjAjEiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnGjAjEiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilMath* IMpgMolipBase::GetUtilMathI () const
{
	return &s_ifUtilMath;
} // IMpgMolipBase::GetUtilMathI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilFileI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilFile* IMpgMolipBase::GetUtilFileI () const
{
	return &s_ifUtilFile;
} // IMpgMolipBase::GetUtilFileI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilFontI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilFont* IMpgMolipBase::GetUtilFontI () const
{
	return& s_ifUtilFont;
} // IMpgMolipBase::GetUtilFontI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilStrI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilStr* IMpgMolipBase::GetUtilStrI () const
{
	return& s_ifUtilStr;
} // IMpgMolipBase::GetUtilStrI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilDlgI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilDlg* IMpgMolipBase::GetUtilDlgI () const
{
	return& s_ifUtilDlg;
} // IMpgMolipBase::GetUtilDlgI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilPrintI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilPrint* IMpgMolipBase::GetUtilPrintI () const
{
	return& s_ifUtilPrint;
} // IMpgMolipBase::GetUtilPrintI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilCoordI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilCoord* IMpgMolipBase::GetUtilCoordI () const
{
	return& s_ifUtilCoord;
} // IMpgMolipBase::GetUtilCoordI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilZlibPngI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ZLIB/PNG_xZkqqHx_iKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	ZLIB/PNG_xZkqqHx_iKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilZlibPng* IMpgMolipBase::GetUtilZlibPngI () const
{
	return& s_ifUtilZlibPng;
} // IMpgMolipBase::GetUtilZlibPngI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilMiscI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ZLIB/PNG_xZkqqHx_iKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	ZLIB/PNG_xZkqqHx_iKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilMisc* IMpgMolipBase::GetUtilMiscI () const
{
	return& s_ifUtilMisc;
} // IMpgMolipBase::GetUtilMiscI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilDocI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Document_xZkqqHx_iKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	Document_xZkqqHx_iKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilDoc* IMpgMolipBase::GetUtilDocI () const
{
	return& s_ifUtilDoc;
} // IMpgMolipBase::GetUtilDocI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilToolbarI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Toolbar_xZkqqHx_iKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	Toolbar_xZkqqHx_iKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilToolbar* IMpgMolipBase::GetUtilToolbarI () const
{
	return& s_ifUtilToolbar;
} // IMpgMolipBase::GetUtilToolbarI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetFileConvI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgFileConv* IMpgMolipBase::GetFileConvI ()
{
	return &s_ifFileConv;
} // IMpgMolipBase::GetFileConvI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgMolipBase::GetUtilBezierI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Bezier_xZkqqHx_iKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	Bezier_xZkqqHx_iKnGjIeBiKnGjAjEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const IMpgUtilBezier* IMpgMolipBase::GetUtilBezierI () const
{
	return& s_ifUtilBezier;
} // IMpgMolipBase::GetUtilBezierI.

////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::RegisterCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bMenu	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmJjFfMiOkGiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpMenu	:_xZkqqHx_iDfCiDhNiDjDiDgIjGlMjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcShortcut:_xZkqqHx_iDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfGiDjDiDePiDiLiDfIiDiMiDgCiDgIjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
ULONG FCIMolipMain::RegisterCommand (BOOL bMenu, const wchar_t* wcpMenu, wchar_t wcShortcut)
{
	// _xZkqqHx_iDhNiDiLiDgAiDfIiDiMiDgCiDgIiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (GetCurrentThreadId() != s_dwMolipThreadId) return DWORD(-1);
	// _xZkqqHx_jAfGiClFiCkCiDfCiDhNiDjDiDgIiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
	DWORD dwNewCmdId = myRegisterNewCommand(this);
	// _xZkqqHx_iCoAiCkEiKiEiCoIjDjGiCmEiCoJiDfCiDhNiDjDiDgIiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (dwNewCmdId == DWORD(-1)) return DWORD(-1);
	// _xZkqqHx_iDiBiDgKiDiFiBfLjDgPjIfOiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!bMenu) return dwNewCmdId;
	// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiDiBiDgKiDiFiBfLiCkKjGkCjAnNjCoIiCmMiPoKiNiHiBeC_xHqqkZx_
	if (s_hPlugInMenu == NULL)
	{
		s_hPlugInMenu = CreatePopupMenu();
		// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDiBiDeDiDjDiDiBiDgKiDiFiBfLiCmJjCmHiJmBiClHiCoJiCmMiCmNiBeBiDiBiDeDiDjDiDhEiDiMiBfLiDiAiCkKjFfMiOkGiClDiCoKiCoJiCmGiCkLiBeC_xHqqkZx_
		// _xZkqqHx_jCmKiPoNiCmMiLeOjDkOiCmMiPoKiNiHiCmNiClBiClBiCmFiCoAjCmHiJmBiCmFiCkLiCoJiCkKiBeB_xHqqkZx_OLE_xZkqqHx_iLeOjDkOiCmMiPoKiNiHiCmNiDiBiDeDiDjDiDiBiDgKiDiFiBfLiCkK_xHqqkZx_
		// _xZkqqHx_jDpMiCoKjBnGiCoNiCoJiClNiCnPiBeBiClBiClBiCmFiCmNjCmHiJmBiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
//----- 05.06.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAjCmHiJmBiBeC_xHqqkZx_AfxGetMainWnd_xZkqqHx_iCmNiBeBjGkCiClO_xHqqkZx_NULL_xZkqqHx_iCmIiCmMiCmF_xHqqkZx_ g_pFrame_xZkqqHx_iCpAiOgHjHhAiBeC_xHqqkZx_
//		AppendMenu(FFGetMainWnd()->GetWnd()->GetMenu()->m_hMenu, MF_POPUP|MF_STRING,
//					UINT_PTR(s_hPlugInMenu), FFLoadString(IDS_PLUG_IN));
//----- 05.06.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iDiBiDgKiDiFiBfLiCpAiNmEiMhGiOfKiBjFiNmEjFgAiJoGiBeC_xHqqkZx_
		FFGetMainWnd()->GetWnd()->DrawMenuBar();
	}
	// _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiDfEiDhFiDiBiDgKiDiFiBfLiCkKjGkCjAnNjCoIiCmMiPoKiNiHiBeC_xHqqkZx_
	if (m_hSubMenu == NULL)
	{
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		//----- _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCkJiCoHiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlO_xHqqkZx_ -----
//		IMpgPlugInInfo* pIMpgPlugInInfo = NULL;
//		HRESULT hr = m_pIMpgPlugInMain->QueryInterface(IID_IMpgPlugInInfo, (void**)&pIMpgPlugInInfo);
//		if (FAILED(hr)) return DWORD(-1);
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		//----- _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCpAiNoMjAkM_xHqqkZx_ -----
		WString strName;
		wchar_t tcKey = myGlobalRegisterShortcut(m_pIMpgPlugInInfo->GetComponentShortcut());
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (tcKey != L'\0')
//			strName.Format(L"%s(&%c)", m_pIMpgPlugInInfo->GetComponentName(), tcKey);
//		else
//			strName = m_pIMpgPlugInInfo->GetComponentName();
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		if (tcKey != L'\0')
			strName = FFMakeCommandText(m_pIMpgPlugInInfo->GetComponentName(), tcKey);
		else
			strName = m_pIMpgPlugInInfo->GetComponentName();
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		//----- _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAjCmHiJmB_xHqqkZx_ -----
		m_hSubMenu = CreatePopupMenu();
		AppendMenu(s_hPlugInMenu, MF_POPUP|MF_STRING, UINT_PTR(m_hSubMenu), WStrToTStr(strName));
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		pIMpgPlugInInfo->Release();
	}
	WString strName;
	wchar_t wcKey = RegisterShortcut(wcShortcut);
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (wcKey != L'\0')
//		strName.Format(L"%s(&%c)", wcpMenu, wcKey);
//	else
//		strName = wcpMenu;
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (wcKey != L'\0')
		strName = FFMakeCommandText(wcpMenu, wcKey);
	else
		strName = wcpMenu;
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAjCmHiJmBiBeC_xHqqkZx_
	AppendMenu(m_hSubMenu, MF_STRING, UINT_PTR(dwNewCmdId), WStrToTStr(strName));
	// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	return dwNewCmdId;
} // FCIMolipMain::RegisterCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::RegisterSelObjSaveFormat
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFjEjFgJiCmMjFmKiDhEiDeIiBfLiDhNiDgCiDgHiCmFjFnLjBlGiDfPiDeDiDeBiDiNiDePiCmJiBeBiDhEiDeIiBfLiDhNiDgCiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_jCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpName		:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *						_xZkqqHx_jHoBiBeG_xHqqkZx_"JPEG file (*.jpg)"
 *			wcpExt		:_xZkqqHx_iDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_
 *						_xZkqqHx_jHoBiBeG_xHqqkZx_".jpg"
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfGiDjDiDePiDiLiDfIiDiMiDgCiDgIjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
ULONG FCIMolipMain::RegisterSelObjSaveFormat (const wchar_t* wcpName, const wchar_t* wcpExt)
{
	// _xZkqqHx_iDhNiDiLiDgAiDfIiDiMiDgCiDgIiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (GetCurrentThreadId() != s_dwMolipThreadId) return DWORD(-1);
	// _xZkqqHx_jAfGiClFiCkCiDhEiDeIiBfLiDhNiDgCiDgHiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
	DWORD dwNewId = g_pDoc->RegisterSelObjSaveFormat(wcpName, wcpExt);
	// _xZkqqHx_iCoAiCkEiKiEiCoIjDjGiCmEiCoJ_xHqqkZx_id_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (dwNewId == DWORD(-1)) return DWORD(-1);
	// Map_xZkqqHx_iCmJjCgMiCpAjBhNjDpMiBeC_xHqqkZx_
	s_mpExportFormatIdToIMolipMain[dwNewId] = this;
	// Id_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	return dwNewId;
} // FCIMolipMain::RegisterSelObjSaveFormat.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::GetProfileBinary
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfHiDfIiDgHiDiKiCkJiCoHiBeBiDgPiDeDiDgJiDiKiDgGiBfLiDfOiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpEntry	:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiDeHiDjDiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bypBuff		:_xZkqqHx_iDgPiDeDiDgJiDiKiDgGiBfLiDfOiCpAiOoGjDlOiClHiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwBuffSz	:_xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT FCIMolipMain::GetProfileBinary (wchar_t* wcpEntry, BYTE* bypBuff, DWORD dwBuffSz) const
{
	WString strSection;
	strSection.Format(L"PlugInData\\{%s}", FFGuidToString(GetCLSID()).c_str());
	if (g_pReg->LoadRegBinary(strSection, wcpEntry, bypBuff, dwBuffSz))
		return S_OK;
	else
		return E_FAIL;
} // FCIMolipMain::GetProfileBinary.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::SetProfileBinary
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfHiDfIiDgHiDiKiCmJiBeBiDgPiDeDiDgJiDiKiDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpEntry	:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiDeHiDjDiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bypBuff		:_xZkqqHx_iPjBiCkLiNjOiCnOiDgPiDeDiDgJiDiKiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwBuffSz	:_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPjBiCkLiNjOiCnNiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT FCIMolipMain::SetProfileBinary (wchar_t* wcpEntry, const BYTE* bypBuff, DWORD dwBuffSz)
{
	WString strSection;
	strSection.Format(L"PlugInData\\{%s}", FFGuidToString(GetCLSID()).c_str());
	g_pReg->SaveRegBinary(strSection, wcpEntry, bypBuff, dwBuffSz);
	return S_OK;
} // FCIMolipMain::SetProfileBinary.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::GetProfileString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfHiDfIiDgHiDiKiCkJiCoHiBeBiDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpEntry	:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiDeHiDjDiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstrText	:_xZkqqHx_iDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAiOoGjDlOiClHiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT FCIMolipMain::GetProfileString (wchar_t* wcpEntry, WString& wstrText) const
{
	WString strSection;
	strSection.Format(L"PlugInData\\{%s}", FFGuidToString(GetCLSID()).c_str());
	if (g_pReg->LoadRegString(strSection, wcpEntry, wstrText))
		return S_OK;
	else
		return E_FAIL;
} // FCIMolipMain::GetProfileString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::SetProfileString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfHiDfIiDgHiDiKiCmJiBeBiDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpEntry	:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiDeHiDjDiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpText		:_xZkqqHx_iPjBiCkLiNjOiCnOiDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPjBiCkLiNjOiCnNiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT FCIMolipMain::SetProfileString (wchar_t* wcpEntry, const wchar_t* wcpText)
{
	WString strSection;
	strSection.Format(L"PlugInData\\{%s}", FFGuidToString(GetCLSID()).c_str());
	g_pReg->SaveRegString(strSection, wcpEntry, wcpText);
	return S_OK;
} // FCIMolipMain::SetProfileString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::ShowAboutDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmM_xHqqkZx_ABOUT_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.12.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCIMolipMain::ShowAboutDialog () const
{
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCkJiCoHiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlO_xHqqkZx_ -----
//	IMpgPlugInInfo* pIMpgPlugInInfo = NULL;
//	HRESULT hr = m_pIMpgPlugInMain->QueryInterface(IID_IMpgPlugInInfo,
//													(void**)&pIMpgPlugInInfo);
//	if (FAILED(hr)) return FALSE;
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	CFCDlgPlugInAboutbox dlg;
	if (m_pIMpgPlugInInfo->GetComponentName() != NULL)
	{
		dlg.m_strPlugInName = m_pIMpgPlugInInfo->GetComponentName();
		dlg.m_strPlugInName.Remove(_T('\r'));
	}
	if (m_pIMpgPlugInInfo->GetVersionName() != NULL)
	{
		dlg.m_strPlugInVersion = m_pIMpgPlugInInfo->GetVersionName();
		dlg.m_strPlugInName.Remove(_T('\r'));
	}
	if (m_pIMpgPlugInInfo->GetAuthorName() != NULL)
	{
		dlg.m_strAuthor = m_pIMpgPlugInInfo->GetAuthorName();
		dlg.m_strPlugInName.Remove(_T('\r'));
	}
//----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_pIMpgPlugInInfo->GetSupportInfo() != NULL)
//	{
//		dlg.m_strSupportInfo = m_pIMpgPlugInInfo->GetSupportInfo();
//		dlg.m_strPlugInName.Remove(_T('\r'));
//	}
//----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// DLL_xZkqqHx_iPoOjFpBiOoGjDlOjHhAiCmMiKnGjAjEiCpAiMjPiNpFiBeC_xHqqkZx_
	FuncMolipSupportInfo lpfnMolipSupportInfo = (FuncMolipSupportInfo)GetProcAddress(m_hInstance, "DllMolipSupportInfo");
	// DLL_xZkqqHx_iCmMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	const wchar_t* wcpSupportInfo;
	if (SUCCEEDED((*lpfnMolipSupportInfo)(NULL, NULL, NULL, NULL, NULL, &wcpSupportInfo)))
	{
		dlg.m_strSupportInfo = wcpSupportInfo;
		dlg.m_strPlugInName.Remove(_T('\r'));
	}
//----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	if (m_pIMpgPlugInInfo->GetComment() != NULL)
	{
		dlg.m_strComment = m_pIMpgPlugInInfo->GetComment();
		dlg.m_strPlugInName.Remove(_T('\r'));
	}
	dlg.DoModal();

// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	pIMpgPlugInInfo->Release();
	return TRUE;
} // FCIMolipMain::ShowAboutDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::InitPlugIn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT FCIMolipMain::InitPlugIn ()
{
	HRESULT result = m_pIMpgPlugInMain->Initialize((IMpgMolipMain*)this);
//----- 06.05.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (!FAILED(result))
	{
		// _xZkqqHx_iDfCiDjDiDgPiBfLiDfOiBfLiCmMjDgPjIfOiBeC_xHqqkZx_
		const FCFileConvInfo* pConvInfo;
		long lConvInfoSize;
		if (m_pIMpgPlugInFileConv->GetFileConvInfo(&pConvInfo, &lConvInfoSize) == S_OK)
			GetFileConvI()->RegisterConvertInfo(GetCLSID(), pConvInfo, lConvInfoSize);
	}
//----- 06.05.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return result;
} // FCIMolipMain::InitPlugIn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::TerminatePlugIn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiPeJjHlJiPiIjHjNiCpAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT FCIMolipMain::TerminatePlugIn ()
{
	return m_pIMpgPlugInMain->Terminate();
} // FCIMolipMain::TerminatePlugIn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::OnCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkKjAnNjCoIiClFiClNiDfCiDhNiDjDiDgIiCmMiOmAiNhDiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT FCIMolipMain::OnCommand (UINT nCmdID)
{
	return m_pIMpgPlugInMain->OnCommand(nCmdID);
} // FCIMolipMain::OnCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::OnUpdateCommandUI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkKjAnNjCoIiClFiClNiDfCiDhNiDjDiDgIiDiBiDgKiDiFiBfLiCmMjFfMiOkGiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDfCiDhNiDjDiDgIiDiBiDgKiDiFiBfLiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT FCIMolipMain::OnUpdateCommandUI (CCmdUI* pCmdUI)
{
//----- 05.05.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCCmdUI cmdUI(pCmdUI);
//	return m_pIMpgPlugInMain->OnUpdateCommandUI(&cmdUI);
//----- 05.05.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return m_pIMpgPlugInMain->OnUpdateCommandUI(pCmdUI);
//----- 05.05.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCIMolipMain::OnUpdateCommandUI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::GetPopHint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDfCiDhNiDjDiDgIiCmMiDhMiDgCiDhGiDhBiDjDiDgHiCmMiDgFiDeMiDfIiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrHintText:_xZkqqHx_iDhBiDjDiDgHiDgFiDeMiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			nCmdID		:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT FCIMolipMain::GetPopHint (WString& wstrHintText, UINT nCmdID)
{
	return m_pIMpgPlugInMain->GetPopHint(wstrHintText, nCmdID);
} // FCIMolipMain::GetPopHint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegisterShortcut
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiCpAjDgPjIfOiClHiCoJiBeCiOhHjCoIiClFiClNiDeMiBfLiCkKiOgHiCoNiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_jFmKiCmMiDeMiBfLiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcKey	:_xZkqqHx_jDgPjIfOiClHiCoJiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiClNiDeMiBfLiCpAjFnEiClHiBeCjDgPjIfOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDgPjIfOiCpAjHhGiLiBiClHiCoJiDeMiBfLiCmNiBeBiDeMiBfLiDhLiBfLiDgIiNlGjBkEiCmMiDeMiBfLiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
wchar_t FCIMolipMain::RegisterShortcut (wchar_t wcKey)
{
	if (m_stUsedShortcut.find(wcKey) == m_stUsedShortcut.end())
	//----- _xZkqqHx_iDeMiBfLiCkKjDgPjIfOiNmPiCnNiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		for (int iC = 0; iC < SHORTCUT_KEYS_SZ; iC++)
		{
			if (SHORTCUT_KEYS[iC] == wcKey)
			//----- _xZkqqHx_iNlGjBkEiDeMiBfLiCmMiPoKiNiH_xHqqkZx_ -----
			{
				m_stUsedShortcut.insert(SHORTCUT_KEYS[iC]);
				return SHORTCUT_KEYS[iC];
			}
		}
	}
	//----- _xZkqqHx_iDeMiBfLiCkKjDgPjIfOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
	for (int iC = 0; iC < SHORTCUT_KEYS_SZ; iC++)
	{
		if (m_stUsedShortcut.find(SHORTCUT_KEYS[iC]) == m_stUsedShortcut.end())
		//----- _xZkqqHx_iDeMiBfLiCkKjDgPjIfOiNmPiCnNiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			m_stUsedShortcut.insert(SHORTCUT_KEYS[iC]);
			return SHORTCUT_KEYS[iC];
		}
	}
	return L'\0';
} // FCIMolipMain::RegisterShortcut.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::OnSelectedObjectSave
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkKjAnNjCoIiClFiClNiDhEiDeIiBfLiDhNiDgCiDgHiCmFiDhEiDeAiDeDiDiLjFnLjBlGiCmMiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFormatId	:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFileName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT FCIMolipMain::OnSelectedObjectSave (UINT nFormatId, const wchar_t* wcpFileName,
											mmetol mmMarginLeft, mmetol mmMarginTop,
											mmetol mmMarginRight, mmetol mmMarginBottom)
{
	return m_pIMpgPlugInMain->OnSelectedObjectSave(nFormatId, wcpFileName,
												mmMarginLeft, mmMarginTop,
												mmMarginRight, mmMarginBottom);
} // FCIMolipMain::OnSelectedObjectSave.

//----- 05.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::OnFileImport
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmKiMgAiOkOiCmMiDhEiDeAiDeDiDiLiCmMiDeDiDjDiDhMiBfLiDgHiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFormatId	:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lFileCount	:wcpFileName_xZkqqHx_iCmMjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpFileName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//HRESULT FCIMolipMain::OnFileImport (UINT nFormatId, long lFileCount, const wchar_t* wcpFileName[])
//{
//	return m_pIMpgPlugInMain->OnFileImport(nFormatId, lFileCount, wcpFileName);
//} // FCIMolipMain::OnFileImport.
//----- 05.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::FCIMolipMain
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCIMolipMain::FCIMolipMain (HINSTANCE hInstance, IMpgPlugInMain* pIMpgPlugInMain)
			:m_hInstance(hInstance),
			 m_pIMpgPlugInInfo(NULL),
			 m_pIMpgPlugInMain(NULL),
			 m_pIMpgPlugInFileConv(NULL),
			 m_hSubMenu(NULL)
{
	if (pIMpgPlugInMain != NULL)
	{
		pIMpgPlugInMain->QueryInterface(IID_IMpgPlugInInfo, (void**)&m_pIMpgPlugInInfo);
		pIMpgPlugInMain->QueryInterface(IID_IMpgPlugInMain, (void**)&m_pIMpgPlugInMain);
		pIMpgPlugInMain->QueryInterface(IID_IMpgPlugInFileConv, (void**)&m_pIMpgPlugInFileConv);
	}
} // FCIMolipMain::FCIMolipMain.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::~FCIMolipMain
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCIMolipMain::~FCIMolipMain ()
{
	if (m_pIMpgPlugInMain != NULL)
	{
		m_pIMpgPlugInInfo->Release();
		m_pIMpgPlugInInfo = NULL;
		m_pIMpgPlugInMain->Release();
		m_pIMpgPlugInMain = NULL;
		m_pIMpgPlugInFileConv->Release();
		m_pIMpgPlugInFileConv = NULL;
	}
	if (m_hInstance != NULL)
	{
		FuncCanUnloadNow lpfnCanUnload = (FuncCanUnloadNow)GetProcAddress(m_hInstance, "DllCanUnloadNow");
// 05.05.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		if (lpfnCanUnload != NULL && (*lpfnCanUnload)() == S_OK)
		if ((*lpfnCanUnload)() == S_OK)
		//----- DLL_xZkqqHx_iJpAjFpKiJmCiCmMiPoKiNiH_xHqqkZx_ -----
		{
//----- 05.05.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// DLL_xZkqqHx_iPeJjHlJjHhAiCmMiKnGjAjEiCpAiMjPiNpFiBeC_xHqqkZx_
			FuncMolipTerminate lpfnMolipTerminate = (FuncMolipTerminate)GetProcAddress(m_hInstance, "DllMolipTerminate");
			// DLL_xZkqqHx_iPeJjHlJiPiIjHjNiBeC_xHqqkZx_
			(*lpfnMolipTerminate)();
//----- 05.05.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			// DLL_xZkqqHx_iCpAiJpAjFpKiBeC_xHqqkZx_
			FFFreeLibrary(m_hInstance);
		}
		m_hInstance = NULL;
	}
} // FCIMolipMain::~FCIMolipMain.

//----- 05.05.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::GetCLSIDString
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmM_xHqqkZx_CLSID_xZkqqHx_iCmMjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmM_xHqqkZx_CLSID_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_{}_xZkqqHx_iCkKjFhEiCkJiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// *			_xZkqqHx_jHoBiBeG_xHqqkZx_A9AF7D19-B197-413F-BF49-D6D293CA0B24
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const wchar_t* FCIMolipMain::GetCLSIDString ()
//{
//	if (m_strCLSID.empty())
//	{
//		//----- _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCkJiCoHiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlO_xHqqkZx_ -----
//		IMpgPlugInInfo* pIMpgPlugInInfo = NULL;
//		HRESULT hr = m_pIMpgPlugInMain->QueryInterface(IID_IMpgPlugInInfo, (void**)&pIMpgPlugInInfo);
//		if (FAILED(hr)) return NULL;
//		// CLSID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		m_strCLSID = pIMpgPlugInInfo->GetComponentCLSIDName();
//		m_strCLSID = FFGuidToString(pIMpgPlugInInfo->GetComponentCLSID());
//		// _xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiKeKjFpKiBeC_xHqqkZx_
//		pIMpgPlugInInfo->Release();
//	}
//	return m_strCLSID.c_str();
//} // FCIMolipMain::GetCLSIDString.
//----- 05.05.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::GetCLSID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmM_xHqqkZx_CLSID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmM_xHqqkZx_CLSID_xZkqqHx_iBeCiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_GUID_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_A9AF7D19-B197-413F-BF49-D6D293CA0B24
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.03.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//GUID FCIMolipMain::GetCLSID ()
GUID FCIMolipMain::GetCLSID () const
{
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCkJiCoHiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlO_xHqqkZx_ -----
//	IMpgPlugInInfo* pIMpgPlugInInfo = NULL;
//	HRESULT hr = m_pIMpgPlugInMain->QueryInterface(IID_IMpgPlugInInfo, (void**)&pIMpgPlugInInfo);
//	if (FAILED(hr)) return GUID_NULL;
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// CLSID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	return m_pIMpgPlugInInfo->GetComponentCLSID();
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiKeKjFpKiBeC_xHqqkZx_
//	pIMpgPlugInInfo->Release();
//	return clsid;
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCIMolipMain::GetCLSID.
//----- 05.05.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::GetPlugInInfoI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IMpgPlugInInfo_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgPlugInInfo_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgPlugInInfo* FCIMolipMain::GetPlugInInfoI ()
{
	return m_pIMpgPlugInInfo;
} // FCIMolipMain::GetPlugInInfoI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::GetPlugInMainI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IMpgPlugInMain_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgPlugInMain_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgPlugInMain* FCIMolipMain::GetPlugInMainI ()
{
	return m_pIMpgPlugInMain;
} // FCIMolipMain::GetMolipMainI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIMolipMain::GetPlugInFileConvI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IMpgPlugInFileConv_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgPlugInFileConv_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgPlugInFileConv* FCIMolipMain::GetPlugInFileConvI ()
{
	return m_pIMpgPlugInFileConv;
} // FCIMolipMain::GetMolipFileConvI.

////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iDhGiDiJiDePiDeDiDjDjHhA_xHqqkZx_Export_xZkqqHx_iLeAjEfMiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::Initialize ()
{
	// MolipDraw_xZkqqHx_iCmM_xHqqkZx_Thread ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	s_dwMolipThreadId = GetCurrentThreadId();
	// _xZkqqHx_iPiJiKpKiJlLiBeC_xHqqkZx_
	s_ifMolipBase.Initialize();
} // FCExport::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::Terminate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iDhGiDiJiDePiDeDiDjDjHhA_xHqqkZx_Export_xZkqqHx_iLeAjEfMiCmMiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::Terminate ()
{
} // FCExport::Terminate.

//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::LoadPlugInModule
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiJiDePiDeDiDjD_xHqqkZx_DLL_xZkqqHx_iCpAiDiNiBfLiDgIiClFiCmEiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpModulePath	:DLL_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiCkKiBeBiDiCiDfHiDiFiBfLiDiLiCoAiDfCiDjDiDhMiBfLiDgMiDjDiDgHiCoA_xHqqkZx_
// *			_xZkqqHx_jDgPjIfOiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//HINSTANCE FCExport::LoadPlugInModule (const wchar_t* wcpModulePath)
//{
//	// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCpAiDiNiBfLiDgIiBeC_xHqqkZx_
//	HINSTANCE hModule = FFLoadLibrary(wcpModulePath);
//	// _xZkqqHx_iDiNiBfLiDgIiCmJiOlIjEhDiClFiClNiCoHiBeBiPeJjHlJiBeC_xHqqkZx_
//	if (hModule <= (HINSTANCE)HINSTANCE_ERROR)
//		return hModule;
//	// DLL_xZkqqHx_iPiJiKpKiJlLjHhAiCmMiKnGjAjEiCpAiMjPiNpFiBeC_xHqqkZx_
//	FuncMolipInitialize lpfnMolipInitialize = (FuncMolipInitialize)GetProcAddress(hModule, "DllMolipInitialize");
//	// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
//	if (lpfnMolipInitialize != NULL)
//	{
//		if (FAILED((*lpfnMolipInitialize)(myAllocate, myFree, &s_ifMolipBase)))
//		{
//			FFFreeLibrary(hModule);
//			hModule = NULL;
//		}
//	}
//	return hModule;
//} // FCExport::LoadPlugInModule.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::FreePlugInModule
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiJiDePiDeDiDjD_xHqqkZx_DLL_xZkqqHx_iCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hModule	:DLL_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDeDiDjDiDfIiDfOiDjDiDfIiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCExport::FreePlugInModule (HINSTANCE hModule)
//{
//	// DLL_xZkqqHx_iPeJjHlJjHhAiCmMiKnGjAjEiCpAiMjPiNpFiBeC_xHqqkZx_
//	FuncMolipTerminate lpfnMolipTerminate = (FuncMolipTerminate)GetProcAddress(hModule, "DllMolipTerminate");
//	// DLL_xZkqqHx_iPeJjHlJiPiIjHjNiBeC_xHqqkZx_
//	if (lpfnMolipTerminate != NULL)
//		(*lpfnMolipTerminate)();
//	// DLL_xZkqqHx_iCpAiJpAjFpKiBeC_xHqqkZx_
//	FFFreeLibrary(hModule);
//} // FCExport::FreePlugInModule.
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::LoadPlugIn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDiCiDfHiDiFiBfLiDiLiCmMjDmHiCnNiNjOiCnNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::LoadPlugIn ()
{
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDhGiDiJiDePiDeDiDjDiDiCiDfHiDiFiBfLiDiLjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	map<WString, WString> mpNameToValue;
	g_pReg->GetPlugInClsidValue(mpNameToValue);
	map<WString, WString>::iterator iNv;
	for (iNv = mpNameToValue.begin(); iNv != mpNameToValue.end(); iNv++)
	{
		// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiPoOjFpBiCmMiDiMiDfHiDfIiDgHiDiKiDeMiBfLjGlMiBeC_xHqqkZx_
		WString wstrRegKeyName;
		wstrRegKeyName.Format(	L"CLSID\\%s\\PlugIn%s\\%s",
								DYNAMIC_DRAW_CLSID_WSTR,
								(const wchar_t*)FCHeaderInf::GetStcAppMajorMinorString(),
								(*iNv).first.c_str());

		if ((*iNv).second.compare(L"+") != 0)
		//----- _xZkqqHx_jBePiJpBiLeOjDkOiOjOiCmMiDhGiDiJiDePiDeDiDjDiPiJiKpKiJlLiCmFiOlIjEhDiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiJiDePiDeDiDjDjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
			WString wstrModuleName;
			(void)FFLoadRegString(	wstrModuleName, HKEY_CLASSES_ROOT,
									wstrRegKeyName, L"ModuleName");
			// IDS_MSG_IS_OFF_FAILED_PLUG_IN = "_xZkqqHx_jBePiJpBiCmMiLeOjDkOiOjOiCmJiDhGiDiJiDePiDeDiDjDiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmM_xHqqkZx_
			//									_xZkqqHx_jBgHiNjOiCnNiCmJiOlIjEhDiClFiCmEiCkCiCnMiClHiBeCiClBiCmMiDhGiDiJiDePiDeDiDjDiCpA_xHqqkZx_
			//									OFF_xZkqqHx_iCmJiClFiCnMiClHiCkJiBeI_xHqqkZx_"
			switch(FFMessageBox(FormatResString(IDS_MSG_IS_OFF_FAILED_PLUG_IN,
												(const wchar_t*)wstrModuleName),
								NULL, MB_YESNOCANCEL))
			{
			case IDYES:
				// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDiMiDfHiDfIiDgHiDiKjDgPjIfOiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
				g_pReg->SetPlugInClsidValue((*iNv).first.c_str(), NULL);
				break;
			case IDNO:
				// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiPpDjBnEiCpAiBhFjAkMiMpHiBhGiCmJjFmPiNfIiBeC_xHqqkZx_
				(*iNv).second = L"+";
				break;
			default: // IDCANCEL:
				break;
			}
		}

		if ((*iNv).second.compare(L"+") == 0)
		//----- _xZkqqHx_jBePiJpBiLeOjDkOiOjOiCmMiDhGiDiJiDePiDeDiDjDiPiJiKpKiJlLiCmFjAkMiMpHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDiMiDfHiDfIiDgHiDiKjDgPjIfOiCpAiPiJiKpKiJlLjCiGiCmJjAnNjCoIiBeC_xHqqkZx_
			g_pReg->SetPlugInClsidValue((*iNv).first.c_str(), L"-");
			// _xZkqqHx_iOhHjCoIiCmMiDhGiDiJiDePiDeDiDjDiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
			WString wstrFilePath;
			if (!FFLoadRegString(	wstrFilePath, HKEY_CLASSES_ROOT,
									wstrRegKeyName, L"FilePath"))
				goto L_NEXT_MODULE_LOOP;
			// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCpAiDiNiBfLiDgIiBeC_xHqqkZx_
			HINSTANCE hInst = FFLoadLibrary(wstrFilePath);
			// _xZkqqHx_iDiNiBfLiDgIiCmJiOlIjEhDiClFiClNiCoHiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			if (hInst <= (HINSTANCE)HINSTANCE_ERROR)
				goto L_NEXT_MODULE_LOOP;

			// DLL_xZkqqHx_iPoOjFpBiOoGjDlOjHhAiCmMiKnGjAjEiCpAiMjPiNpFiBeC_xHqqkZx_
			FuncMolipSupportInfo lpfnMolipSupportInfo = (FuncMolipSupportInfo)GetProcAddress(hInst, "DllMolipSupportInfo");
			// DLL_xZkqqHx_iPiJiKpKiJlLjHhAiCmMiKnGjAjEiCpAiMjPiNpFiBeC_xHqqkZx_
			FuncMolipInitialize lpfnMolipInitialize = (FuncMolipInitialize)GetProcAddress(hInst, "DllMolipInitialize");
			// DLL_xZkqqHx_iPeJjHlJjHhAiCmMiKnGjAjEiCpAiMjPiNpFiBeC_xHqqkZx_
			FuncMolipTerminate lpfnMolipTerminate = (FuncMolipTerminate)GetProcAddress(hInst, "DllMolipTerminate");
			// DLL_xZkqqHx_iJpAjFpKjClCiNlIiCmMiKnGjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
			FuncCanUnloadNow lpfnCanUnloadNow = (FuncCanUnloadNow)GetProcAddress(hInst, "DllCanUnloadNow");
			// _xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiOoGjDlOjHhAiCmMiKnGjAjEiCpAiMjPiNpFiBeC_xHqqkZx_
			FuncMolipGetClassObject lpfnMolipGetClassObject = (FuncMolipGetClassObject)GetProcAddress(hInst, "DllMolipGetClassObject");

			if (lpfnMolipSupportInfo == NULL ||
				lpfnMolipInitialize == NULL ||
				lpfnMolipTerminate == NULL ||
				lpfnCanUnloadNow == NULL ||
				lpfnMolipGetClassObject == NULL)
			{
				FFFreeLibrary(hInst);
				goto L_NEXT_MODULE_LOOP;
			}

			// DLL_xZkqqHx_iCmMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
			WORD wSupportApp;
			WORD wAppVersion;
			const wchar_t* wcpIsUnicode;
			LANGID* pLangId;
			const wchar_t* wcpModuleName;
			const wchar_t* wcpSupportInfo;
			if (FAILED((*lpfnMolipSupportInfo)(&wSupportApp, &wAppVersion, &wcpIsUnicode, &pLangId, &wcpModuleName, &wcpSupportInfo)))
			{
				FFFreeLibrary(hInst);
				goto L_NEXT_MODULE_LOOP;
			}

			//----- _xZkqqHx_iDeBiDhGiDiKiDiCiBfLiDgIiCpAjEoEiKhC_xHqqkZx_ -----
			if ((g_->appMode & wSupportApp) == 0)
			//----- _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkKjGhLjBmMiCmMiMlLiNnNiCmMiDeBiDhGiDiKiDiCiBfLiDgIiCmJjBmOiJjOiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iOmAiNnLiCmNiBeBiDeBiDhGiDiKiDiCiBfLiDgIiCkKiInJiCmIiCoJiPoKiNiHiCmNjDgPjIfOiClDiCoKiCoJiDiMiDfHiDfIiDgHiDiKiCkK_xHqqkZx_
				// _xZkqqHx_iInJiCmIiCoJiClNiCnPiBeB_xHqqkZx_DynamicDraw_xZkqqHx_jGhLjBmMiCmJiDhGiDiJiDePiDeDiDjDiCkKjFfMiOkGiClDiCoKiCoJiClBiCmGiCmNiCmIiCkNiBeB_xHqqkZx_
				// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDeDiDjDiDfIiDgHiBfLiDiJiCpAiKnEiIoBiCmBiCmEiNoMiCoHiCmIiCkCiMmAiCoIiClBiClBiCkKiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
				// _xZkqqHx_iClBiCmGiCoAiCmIiCkCiCmNiClIiBeC_xHqqkZx_
				ASSERT(FALSE);

				// IDS_ERR_MSG_WRONG_APPMODE_PLUGIN =
				// _xZkqqHx_iDeDiDjDiDfIiDgHiBfLiDiLiClDiCoKiCmEiCkCiCoJiDhGiDiJiDePiDeDiDjDiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmN_xHqqkZx_%s_xZkqqHx_iCmJjBmOiJjOiClFiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_
				// %s_xZkqqHx_jHhAiCmMiDhGiDiJiDePiDeDiDjDiCpAiDeDiDjDiDfIiDgHiBfLiDiLiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
				// _xZkqqHx_jDpMiOoIjAoG_xHqqkZx_:
				// %s
				FFErrorBox(IDS_ERR_MSG_WRONG_APPMODE_PLUGIN,
											wcpModuleName,
											::GetLocalAppName(),
											::GetLocalAppName(),
											wcpSupportInfo);
				FFFreeLibrary(hInst);
				goto L_NEXT_MODULE_LOOP;
			}

			//----- _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiCpAjEoEiKhC_xHqqkZx_ -----
			FCAppVersion appVersionDynamic;
			appVersionDynamic.wVersion = FCHeaderInf::GetStcAppVersion();
			FCAppVersion appVersionSDK;
			appVersionSDK.wVersion = wAppVersion;
			if (appVersionDynamic.wMajor != appVersionSDK.wMajor ||
				appVersionDynamic.wMinor != appVersionSDK.wMinor ||
				wcscmp(wcpIsUnicode, FD_APP_IS_UNICODE) != 0)
			//----- _xZkqqHx_jGhLjBmMiCmGiDhGiDiJiDePiDeDiDjDiCmFiBeBiDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiBeFiDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iOmAiNnLiCmNiBeBiDiBiDfHiDiDiBfLiBeFiDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiCkKiInJiCmIiCoJiPoKiNiHiCmNjDgPjIfOiClDiCoKiCoJiDiMiDfHiDfIiDgHiDiKiCkK_xHqqkZx_
				// _xZkqqHx_iInJiCmIiCoJiClNiCnPiBeB_xHqqkZx_DynamicDraw_xZkqqHx_jGhLjBmMiCmJiDhGiDiJiDePiDeDiDjDiCkKjFfMiOkGiClDiCoKiCoJiClBiCmGiCmNiCmIiCkNiBeB_xHqqkZx_
				// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDeDiDjDiDfIiDgHiBfLiDiJiCpAiKnEiIoBiCmBiCmEiNoMiCoHiCmIiCkCiMmAiCoIiClBiClBiCkKiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
				// _xZkqqHx_iClBiCmGiCoAiCmIiCkCiCmNiClIiBeC_xHqqkZx_
				ASSERT(FALSE);

				// IDS_ERR_MSG_WRONG_VERSION_PLUGIN =
				// _xZkqqHx_iDeDiDjDiDfIiDgHiBfLiDiLiClDiCoKiCmEiCkCiCoJiDhGiDiJiDePiDeDiDjDiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmN_xHqqkZx_%s%d.%d (%s)_xZkqqHx_jHhAiCmFiClHiBeC_xHqqkZx_
				// %s%d.%d (%s)_xZkqqHx_jHhAiCmMiDhGiDiJiDePiDeDiDjDiCpAiDeDiDjDiDfIiDgHiBfLiDiLiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
				// _xZkqqHx_jDpMiOoIjAoG_xHqqkZx_:
				// %s
				FFErrorBox(IDS_ERR_MSG_WRONG_VERSION_PLUGIN,
											wcpModuleName,
											::GetLocalAppName(),
											appVersionSDK.wMajor,
											appVersionSDK.wMinor,
											wcpIsUnicode,
											::GetLocalAppName(),
											appVersionDynamic.wMajor,
											appVersionDynamic.wMinor,
											FD_APP_IS_UNICODE,
											wcpSupportInfo);
				FFFreeLibrary(hInst);
				goto L_NEXT_MODULE_LOOP;
			}

			if (longPair(appVersionDynamic.wLevelA, appVersionDynamic.wLevelB) <
				longPair(appVersionSDK.wLevelA, appVersionSDK.wLevelB))
			//----- _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDiMiDhIiDiLiCkKjGhLjBmMiCmMiDiMiDhIiDiLiCoGiCoIjAfGiClFiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDiMiDhIiDiLiCkKjAfGiClFiCkNiCmIiCoJiCmGiBeBiDhGiDiJiDePiDeDiDjDiCmJiMpGiKeKiClDiCoKiCoJiKnGjAjEiDgFiBfLiDhFiDiLiCkK_xHqqkZx_
				// _xZkqqHx_iKgHjCkDiClDiCoKiCmEiCkCiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeCiKgHjCkDiCmNiKnGjAjEiDgFiBfLiDhFiDiLiCmMiNmFiMoDiCmJ_xHqqkZx_
				// _xZkqqHx_jCmHiJmBiClHiCoJiMgAiCmFiNhDiCoNiCoKiCoJiClNiCnPiBeBiPoDiImKiMnNiKlHiCmGiCmIiCoJiBeC_xHqqkZx_

				// IDS_ERR_MSG_WRONG_LEVEL_PLUGIN =
				// _xZkqqHx_iDeDiDjDiDfIiDgHiBfLiDiLiClDiCoKiCmEiCkCiCoJiDhGiDiJiDePiDeDiDjDiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmN_xHqqkZx_%s%d.%d _xZkqqHx_iCmM_xHqqkZx_%c%d_xZkqqHx_jHhAiCmFiClHiBeC_xHqqkZx_
				// %c%d_xZkqqHx_iImIiNhOiCmM_xHqqkZx_%s%d.%d_xZkqqHx_iCpAiDeDiDjDiDfIiDgHiBfLiDiLiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
				// _xZkqqHx_jDpMiOoIjAoG_xHqqkZx_:
				// %s
				FFErrorBox(IDS_ERR_MSG_WRONG_LEVEL_PLUGIN,
											wcpModuleName,
											::GetLocalAppName(),
											appVersionSDK.wMajor,
											appVersionSDK.wMinor,
// 06.06.30 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//											appVersionSDK.wLevelA + L'A',
											appVersionSDK.wLevelA + L'K',
											appVersionSDK.wLevelB + 1,
// 06.06.30 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//											appVersionSDK.wLevelA + L'A',
											appVersionSDK.wLevelA + L'K',
											appVersionSDK.wLevelB + 1,
											::GetLocalAppName(),
											appVersionSDK.wMajor,
											appVersionSDK.wMinor,
											wcpSupportInfo);
				FFFreeLibrary(hInst);
				goto L_NEXT_MODULE_LOOP;
			}
			//----- _xZkqqHx_iMlOiMoKiCpAiDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJiCkJiDgAiDeGiDgCiDeO_xHqqkZx_ ------
			BOOL bIsLangSupport = (pLangId[0] == 0);
			int iC;
			for (iC = 0; pLangId[iC] != 0; iC++)
			{
				if (pLangId[iC] == s_ifMolipBase.GetAppLangId())
				{
					bIsLangSupport = TRUE;
					break;
				}
			}
			if (!bIsLangSupport)
			//----- _xZkqqHx_iMlOiMoKiCpAiDfEiDhMiBfLiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ ------
			{
				// IDS_ERR_MSG_WRONG_LANGID_PLUGIN =
				// _xZkqqHx_iDeDiDjDiDfIiDgHiBfLiDiLiClDiCoKiCmEiCkCiCoJiDhGiDiJiDePiDeDiDjDiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNiMlOiMoK_xHqqkZx_ID:%x _xZkqqHx_iCmJjBmOiJjOiClFiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_
				// _xZkqqHx_iMlOiMoK_xHqqkZx_ID:%x _xZkqqHx_iCmJjBmOiJjOiClFiClNiDhGiDiJiDePiDeDiDjDiCpAiDeDiDjDiDfIiDgHiBfLiDiLiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
				// _xZkqqHx_jDpMiOoIjAoG_xHqqkZx_:
				// %s
				FFErrorBox(	IDS_ERR_MSG_WRONG_LANGID_PLUGIN,
							wcpModuleName,
							s_ifMolipBase.GetAppLangId(),
							s_ifMolipBase.GetAppLangId(),
							wcpSupportInfo);
				FFFreeLibrary(hInst);
				goto L_NEXT_MODULE_LOOP;
			}
			// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
			if (FAILED((*lpfnMolipInitialize)(myAllocate, myFree, &s_ifMolipBase)))
			{
				FFFreeLibrary(hInst);
				goto L_NEXT_MODULE_LOOP;
			}
			for (int idx = 0;; idx++)
			//----- _xZkqqHx_iDiCiDfHiDiFiBfLiDiLjCiGiCmMjFkBjAjEiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgHiCpAiMmEiCnBiPgPiClFiBjFiPiJiKpKiJlL_xHqqkZx_ -----
			{
				IMpgPlugInMain* pIMpgPlugInMain = NULL;
				// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgHiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
				if (FAILED((*lpfnMolipGetClassObject)(idx, IID_IMpgPlugInMain, (void**)&pIMpgPlugInMain))) break;
				// _xZkqqHx_iDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCmJjBmOiJjOiClHiCoJiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
				s_vIMolipMain.push_back((FCIMolipMain*)FCExport::CreateMolipMainI(hInst, pIMpgPlugInMain));
				// CLSID->_xZkqqHx_iDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCmMiDgOiDgCiDfGiDiFiCpAiNoMjAkMiBeC_xHqqkZx_
				s_mpPlugInCLSIDToMolipMainI[s_vIMolipMain.back()->GetCLSID()] = s_vIMolipMain.back();
				pIMpgPlugInMain->Release();
				// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
				if (FAILED(s_vIMolipMain.back()->InitPlugIn()))
				{
					FCExport::DeleteMolipMainI(s_vIMolipMain.back());
					s_vIMolipMain.pop_back();
					goto L_NEXT_MODULE_LOOP;
				}
			}
			// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDiMiDfHiDfIiDgHiDiKjDgPjIfOiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
			g_pReg->SetPlugInClsidValue((*iNv).first.c_str(), L"+");
		}
L_NEXT_MODULE_LOOP:;
	}
} // FCExport::LoadPlugIn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::FreePlugIn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDiCiDfHiDiFiBfLiDiLiCmMiKeKjFpKiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::FreePlugIn ()
{
	vector<FCIMolipMain*>::iterator iCa;
	for (iCa = s_vIMolipMain.begin(); iCa != s_vIMolipMain.end(); iCa++)
	{
		(*iCa)->TerminatePlugIn();
		FCExport::DeleteMolipMainI(*iCa);
	}
	s_vIMolipMain.clear();
	s_mpPlugInCLSIDToMolipMainI.clear();
	s_mpCmdToIMolipMain.clear();
	s_hPlugInMenu = NULL;
	s_stUsedShortcut.clear();
} // FCExport::FreePlugIn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::RegisterMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfEiDhFiDiBiDgKiDiFiBfLiCpAiDiBiDeDiDjDiDiBiDgKiDiFiBfLiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::RegisterMenu ()
{
	if (s_hPlugInMenu != NULL)
	//----- _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDgHiDgCiDhGiDiBiDgKiDiFiBfLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAjCmHiJmBiBeC_xHqqkZx_
		AppendMenu(FFGetMainWnd()->GetWnd()->GetMenu()->m_hMenu, MF_POPUP|MF_STRING,
					UINT_PTR(s_hPlugInMenu), FFLoadString(IDS_PLUG_IN));
		// _xZkqqHx_iDiBiDgKiDiFiBfLiCpAiNmEiMhGiOfKiBjFiNmEjFgAiJoGiBeC_xHqqkZx_
		FFGetMainWnd()->GetWnd()->DrawMenuBar();
	}
} // FCExport::RegisterMenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::SelfSuspendMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iOkJjAgHiCpAiDfEiDfIiDhJiDjDiDgIiClHiCoJiBeC_xHqqkZx_FCIMolipMain::Suspend_xZkqqHx_iCmGiLkGjClCiClFiCmEiLeAjEfMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::SelfSuspendMolip ()
{
	// Molip Draw_xZkqqHx_iCmMiDfEiDfIiDhJiDjDiDgIjFmPjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
	{
		FCAutoLeaveCriticalSection atlcs(s_csIsMolipSuspended);
		s_bIsMolipSuspended = TRUE;
	}

	// s_csSuspendMolip.cs_xZkqqHx_iCmJiCoGiCmBiCmEiBeBiClBiClBiCmFjCoCiOhOiClDiClJiCoHiCoKiCoJiBeC_xHqqkZx_
	EnterCriticalSection(&s_csSuspendMolip.cs);
	LeaveCriticalSection(&s_csSuspendMolip.cs);

	// Molip Draw_xZkqqHx_iCmMiDfEiDfIiDhJiDjDiDgIjFmPjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
	{
		FCAutoLeaveCriticalSection atlcs(s_csIsMolipSuspended);
		s_bIsMolipSuspended = FALSE;
	}
} // FCExport::SelfSuspendMolip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::OnCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDfCiDhNiDjDiDgIiCmMiOmAiNhDiOjOiCmJiMmEiCnBiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::OnCommand (UINT nCmdID)
{
	DWORDToIMolipMainMap::iterator iMp = s_mpCmdToIMolipMain.find(nCmdID);
	if (iMp == s_mpCmdToIMolipMain.end()) return;
	(*iMp).second->OnCommand(nCmdID);
} // FCExport::OnCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::OnUpdateCommandUI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDfCiDhNiDjDiDgIiCmMiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmJiMmEiCnBiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDfCiDhNiDjDiDgIiDiBiDgKiDiFiBfLiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::OnUpdateCommandUI (CCmdUI* pCmdUI)
{
	DWORDToIMolipMainMap::iterator iMp = s_mpCmdToIMolipMain.find(pCmdUI->m_nID);
	if (iMp == s_mpCmdToIMolipMain.end()) return;
	(*iMp).second->OnUpdateCommandUI(pCmdUI);
} // FCExport::OnUpdateCommandUI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::GetPopHint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDfCiDhNiDjDiDgIiCmMiDhMiDgCiDhGiDhBiDjDiDgHiCmMiDgFiDeMiDfIiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrHintText:_xZkqqHx_iDhBiDjDiDgHiDgFiDeMiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			nCmdID		:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::GetPopHint (WString& wstrHintText, UINT nCmdID)
{
	DWORDToIMolipMainMap::iterator iMp = s_mpCmdToIMolipMain.find(nCmdID);
	if (iMp == s_mpCmdToIMolipMain.end()) return;
	(*iMp).second->GetPopHint(wstrHintText, nCmdID);
} // FCExport::GetPopHint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::SaveSelectedObjectImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAjFjEjFgJiCpAjFmKiDhEiDeIiBfLiDhNiDgCiDgHiCmFiDfKiBfLiDhFiBhGiDfPiDeDiDeBiDiNiDePiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwFormatId	:_xZkqqHx_iDfKiBfLiDhFiClHiCnHiCkLiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpFileName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::SaveSelectedObjectImage (DWORD dwFormatId, const wchar_t* tcpFileName,
										mmetol mmMarginLeft, mmetol mmMarginTop,
										mmetol mmMarginRight, mmetol mmMarginBottom)
{
	DWORDToIMolipMainMap::iterator iMp = s_mpExportFormatIdToIMolipMain.find(dwFormatId);
	if (iMp == s_mpExportFormatIdToIMolipMain.end()) return;
	(*iMp).second->OnSelectedObjectSave(dwFormatId, tcpFileName,
										mmMarginLeft, mmMarginTop,
										mmMarginRight, mmMarginBottom);
} // FCExport::SaveSelectedObjectImage.

//----- 05.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::OnFileImport
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlMiMgAiOkOiCpAiDeDiDjDiDhMiBfLiDgHiClHiCoJiBeCiBhFjBlMiMgAiOkOiCmMiDhEiDeAiDeDiDiLiCmMjDmHiNjOiCnNiBhGiDhEiDeAiDeDiDiL_xHqqkZx_
// *			_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPathList	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCExport::OnFileImport (UINT nFormatId, const WStringVector& vPathList)
//{
//	DWORDToIMolipMainMap::iterator iMp = s_mpImportFormatIdToIMolipMain.find(nFormatId);
//	if (iMp == s_mpImportFormatIdToIMolipMain.end()) return;
//	vector<const wchar_t*> vList;
//	WStringVector::const_iterator iFn;
//	for (iFn = vPathList.begin(); iFn != vPathList.end(); iFn++)
//		vList.push_back((*iFn).c_str());
//	(*iMp).second->OnFileImport(nFormatId, vList.size(), vList.begin());
//} // FCExport::OnFileImport.
//----- 05.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::GetMolipMainI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_CLSID_xZkqqHx_iCkJiCoH_xHqqkZx_IMpgMolipMain_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpA_xHqqkZx_
 *			_xZkqqHx_iOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	clsid	:_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_CLSID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgMolipMain_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_CLSID_xZkqqHx_iCmJjBmOiJjOiClHiCoJiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCkK_xHqqkZx_
 *			_xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgMolipMain* FCExport::GetMolipMainI (const GUID& clsid)
{
	map<GUID, FCIMolipMain*>::iterator i = s_mpPlugInCLSIDToMolipMainI.find(clsid);
	if (i == s_mpPlugInCLSIDToMolipMainI.end()) return NULL;
	return (*i).second;
} // FCExport::GetMolipMainI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::GetPlugInInfoI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_CLSID_xZkqqHx_iCkJiCoH_xHqqkZx_IMpgPlugInInfo_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpA_xHqqkZx_
 *			_xZkqqHx_iOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	clsid	:_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_CLSID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgPlugInInfo_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_CLSID_xZkqqHx_iCmJjBmOiJjOiClHiCoJiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCkK_xHqqkZx_
 *			_xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgPlugInInfo* FCExport::GetPlugInInfoI (const GUID& clsid)
{
	FCIMolipMain* pMolipMainI = (FCIMolipMain*)GetMolipMainI(clsid);
	if (pMolipMainI == NULL) return NULL;
	return pMolipMainI->GetPlugInInfoI();
} // FCExport::GetPlugInInfoI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::GetPlugInMainI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_CLSID_xZkqqHx_iCkJiCoH_xHqqkZx_IMpgPlugInMain_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpA_xHqqkZx_
 *			_xZkqqHx_iOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	clsid	:_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_CLSID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgPlugInMain_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_CLSID_xZkqqHx_iCmJjBmOiJjOiClHiCoJiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCkK_xHqqkZx_
 *			_xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgPlugInMain* FCExport::GetPlugInMainI (const GUID& clsid)
{
	FCIMolipMain* pMolipMainI = (FCIMolipMain*)GetMolipMainI(clsid);
	if (pMolipMainI == NULL) return NULL;
	return pMolipMainI->GetPlugInMainI();
} // FCExport::GetPlugInMainI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::GetPlugInFileConvI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_CLSID_xZkqqHx_iCkJiCoH_xHqqkZx_IMpgPlugInFileConv
 *			_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	clsid	:_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_CLSID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgPlugInFileConv_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_CLSID_xZkqqHx_iCmJjBmOiJjOiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgPlugInFileConv* FCExport::GetPlugInFileConvI (const GUID& clsid)
{
	FCIMolipMain* pMolipMainI = (FCIMolipMain*)GetMolipMainI(clsid);
	if (pMolipMainI == NULL) return NULL;
	return pMolipMainI->GetPlugInFileConvI();
} // FCExport::GetMolipFileConvI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::CreateMolipMainI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IMpgMolipMain _xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hInstance		:IMpgMolipMain _xZkqqHx_iCpAjHjIjHhAiClHiCoJiDhGiDiJiDePiDeDiDjDiCmM_xHqqkZx_
 *							 _xZkqqHx_iDeDiDjDiDfIiDfOiDjDiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pIMpgPlugInMain	:IMpgMolipMain _xZkqqHx_iCpAjHjIjHhAiClHiCoJiDhGiDiJiDePiDeDiDjDiCmM_xHqqkZx_
 *							 _xZkqqHx_iDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgMolipMain _xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgMolipMain* FCExport::CreateMolipMainI (HINSTANCE hInstance, IMpgPlugInMain* pIMpgPlugInMain)
{
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return new FCIMolipMain(hInstance, pIMpgPlugInMain);
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	IMpgMolipMain* pMolipMain = new FCIMolipMain(hInstance, pIMpgPlugInMain);
	// _xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	pMolipMain->Initialize();
	return pMolipMain;
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // FCExport::CreateMolipMainI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCExport::DeleteMolipMainI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IMpgMolipMain _xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pMolipMainI	:IMpgMolipMain _xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCExport::DeleteMolipMainI (IMpgMolipMain* pMolipMainI)
{
	delete (FCIMolipMain*)pMolipMainI;
} // FCExport::DeleteMolipMainI.

//----- 06.03.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//// interface IMpgStringContainer
//
//template<>
//basic_string<char>::size_type IMpgStringContainer<char>::strlen (const char* _S)
//{
//	return ::strlen(_S);
//} // IMpgStringContainer<char>::strlen.
//
//template<>
//basic_string<wchar_t>::size_type IMpgStringContainer<wchar_t>::strlen (const wchar_t* _S)
//{
//	return ::wcslen(_S);
//} // IMpgStringContainer<wchar_t>::strlen.
//----- 06.03.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
