#ifndef __MultiControlTmpl_h
#define __MultiControlTmpl_h

#include "stdafx.h"
// 03.05.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include <map>					// For map template.
#include "DynamicDraw.h"
#include "FoundDoc.h"			// For g_pDoc.
#include "RegData.h"			// For FCRegData.
#include "UtilDlg.h"			// For RightByLeftHand.
#include "FrameWnd.h"			// For FFGetMainWnd().

//----- _xZkqqHx_iDfOiDeDiDhNiBfL_xHqqkZx_ID -----
#define FDTIMER_WNDMATRIX	1

typedef map<DWORD, DWORDVector>	IdToIdvMap;


template<class SUPER> class CFCMultiControlTmpl : public SUPER
{
// _xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfGiDiHiDjD_xHqqkZx_
public:
	CFCMultiControlTmpl ();

// _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_
public:
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//// 06.11.07 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	virtual void	ClearContents ();
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual void	ClearContents ();
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	virtual void	AddFreeId (DWORD dwId);
	virtual void	SetNextFreeId (DWORD dwId);
	virtual void	SetProhibitDelete (BOOL bProhibitDelete);
	virtual BOOL	GetProhibitDelete () const;
	virtual const DWORDSet&		GetInsertedIdSet () const;
	virtual const DWORDSet&		GetRemovedIdSet () const;
	virtual const DWORDSet&		GetChangedIdSet () const;
	virtual const IdToIdvMap&	GetMergedIdSet () const;
	virtual const DWORDVector&	GetMergedIdVector (DWORD dwId) const;
	virtual BOOL	CanInsertItemPrev () const;
	virtual BOOL	CanInsertItemNext () const;
	virtual BOOL	CanStartMoveItem () const;
	virtual BOOL	CanMoveItemPrev () const;
	virtual BOOL	CanMoveItemNext () const;
	virtual BOOL	CanChangeItem () const;
	virtual BOOL	CanDeleteItem () const;
	virtual BOOL	CanMergeItem () const;

protected:
	virtual DWORD	GetNextFreeId ();
	virtual void	AddInsertedId (DWORD dwId);
	virtual void	AddRemovedId (DWORD dwId);
	virtual void	AddRemovedId (const DWORD* dwIdFrom, const DWORD* dwIdTo);
	virtual void	AddChangedId (DWORD dwId);
	virtual void	AddMergedId (DWORD dwId, DWORD dwAppendId);
	virtual void	AddMergedId (DWORD dwId, const DWORD* dwIdFrom, const DWORD* dwIdTo);
	virtual BOOL	IsInsertedId (DWORD dwId) const;
	virtual BOOL	IsRemovedId (DWORD dwId) const;
	virtual BOOL	IsChangedId (DWORD dwId) const;
	virtual BOOL	IsMergedId (DWORD dwId) const;
	virtual void	DelInsertedId (DWORD dwId);
	virtual void	DelRemovedId (DWORD dwId);
	virtual void	DelChangedId (DWORD dwId);
	virtual void	DelMergedId (DWORD dwId);

protected:
	//----- _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFiDeDiDjDiDhGiDiKiDiBiDjDiDgHiCkKjFeLjHhGiCmIiKnGjAjE_xHqqkZx_ -----
	virtual long	GetFrontFixedItemSize () const;
	virtual long	GetBackFixedItemSize () const;
	virtual long	GetSubMenuIndex (long lId) const;
	virtual BOOL	OnInsertItem (long lIndex, DWORD dwId);
	virtual BOOL	OnChangeItem (long lIndex, DWORD dwId);
// 06.10.20 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	OnChangeItem2 (long lIndex, DWORD dwId);
	virtual BOOL	OnDeleteItem (long lIndex, DWORD dwId);
	virtual BOOL	OnMergeItem (long lIndexFrom, long lIndexUntil);

protected:
	// _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiBeC_xHqqkZx_
	virtual BOOL	OnCmdMsg (UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);

	virtual long	GetSelectedCount (long& lFrontSelected, long& lMidSelected,
										long& lBackSelected) const;
	virtual void	MoveItem (long lTargetIndex);
// 06.02.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OnUpdatePopupMenu (CMenu* pMenu) const;
	//----- _xZkqqHx_iDeDiDhIiDjDiDgHiPiIjHjNiKnGjAjE_xHqqkZx_ -----
	virtual void	TimerEvent (DWORD dwIDEvent);
	virtual long	TransFDA (long iState, DWORD dwMessage, DWORD dwCommand = 0);
	virtual void	StateFDA (long iState);
	//----- _xZkqqHx_jBeKiInKiPpDjBnEiPiIjHjNiKnGjAjE_xHqqkZx_ -----
	virtual void	StateContextMenu ();			// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
	virtual void	StateWaitEvent ();				// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClPiBeC_xHqqkZx_
	virtual void	StateWaitEvent2 ();				// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClP_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	virtual void	StateBeginMoveItem ();			// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
	virtual void	StateMovingItem ();				// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
	virtual void	StateEndMoveItem ();			// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
	virtual void	StateCancelMoveItem ();			// _xZkqqHx_iInKjDkOiPiIjHjNiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
	virtual void	StateRbtnSelectItem2 ();		// _xZkqqHx_iJeFiDhLiDfOiDjDjHhAjBeJjBpA_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	virtual void	StateContextMenu2 ();			// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	virtual void	StateBeginStaticMoveItem ();	// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
	virtual void	StateStaticMovingItem ();		// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNjCiGiBeC_xHqqkZx_
	virtual void	StateStaticMoveItemPrev ();		// _xZkqqHx_jClMjBePiCnGjAmDjDeJiInKjDkOiBeC_xHqqkZx_
	virtual void	StateStaticMoveItemNext ();		// _xZkqqHx_jClMiMoDiCnGjAmDjDeJiInKjDkOiBeC_xHqqkZx_

	virtual void	StateCmdInsertItemPrev ();		// _xZkqqHx_jClMjBePiCnGjBhNjDpMiBeC_xHqqkZx_
	virtual void	StateCmdInsertItemNext ();		// _xZkqqHx_jClMiMoDiCnGjBhNjDpMiBeC_xHqqkZx_
	virtual void	StateCmdDeleteItem ();			// _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiBeC_xHqqkZx_
	virtual void	StateCmdChangeItem ();			// _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfIiBeC_xHqqkZx_
// 06.10.20 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	StateCmdChangeItem2 ();			// _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfI_xHqqkZx_2_xZkqqHx_iBeC_xHqqkZx_
	virtual void	StateCmdMergeItem ();			// _xZkqqHx_iDeBiDeDiDgFiDiAiDhNiBfLiDfHiBeC_xHqqkZx_

// _xZkqqHx_iDiGiBfLiDfFjCoIiLgAiBeC_xHqqkZx_
public:
enum
{
//----- 01.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	STATE_BEGIN_MOVE_ITEM = SUPER::STATE_END,	// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
//	STATE_MOVING_ITEM,				// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
//	STATE_END_MOVE_ITEM,			// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
//	STATE_CANCEL_MOVE_ITEM,			// _xZkqqHx_iInKjDkOiPiIjHjNjCiGiOhOiBeC_xHqqkZx_
//----- 01.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	STATE_BEGIN = SUPER::STATE_END,	// _xZkqqHx_iPpDjBnEiKeKiOgOiBeC_xHqqkZx_
	STATE_RBTN_SELECT_ITEM_2,		// _xZkqqHx_iJeFiDhLiDfOiDjDjHhAjBeJjBpA_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	STATE_CONTEXT_MENU_2,			// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	STATE_BEGIN_STATIC_MOVE_ITEM,	// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
	STATE_STATIC_MOVING_ITEM,		// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNjCiGiBeC_xHqqkZx_
	STATE_STATIC_MOVE_ITEM_PREV,	// _xZkqqHx_jClMjBePiCnGjAmDjDeJiInKjDkOiBeC_xHqqkZx_
	STATE_STATIC_MOVE_ITEM_NEXT,	// _xZkqqHx_jClMiMoDiCnGjAmDjDeJiInKjDkOiBeC_xHqqkZx_

	STATE_CMD_INSERT_ITEM_PREV,		// _xZkqqHx_jClMjBePiCnGjBhNjDpMiBeC_xHqqkZx_
	STATE_CMD_INSERT_ITEM_NEXT,		// _xZkqqHx_jClMiMoDiCnGjBhNjDpMiBeC_xHqqkZx_
	STATE_CMD_DELETE_ITEM,			// _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiBeC_xHqqkZx_
	STATE_CMD_CHANGE_ITEM,			// _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfIiBeC_xHqqkZx_
// 06.10.20 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	STATE_CMD_CHANGE_ITEM_2,		// _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfI_xHqqkZx_2_xZkqqHx_iBeC_xHqqkZx_
	STATE_CMD_MERGE_ITEM,			// _xZkqqHx_iDeBiDeDiDgFiDiAiDhNiBfLiDfHiBeC_xHqqkZx_

	STATE_END,						// _xZkqqHx_iPpDjBnEiPeJjHlJiBeC_xHqqkZx_
};

// _xZkqqHx_iDiGiBfLiDfFjFmPjAjEiBeC_xHqqkZx_
protected:
	DWORDSet	m_stFreeId;			// _xZkqqHx_iDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiBeCiDeBiDeDiDgFiDiAjAfGiLeLiNoMjAkMiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
	DWORD		m_dwNextFreeId;		// _xZkqqHx_iOjPiCmMiDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeCiDeBiDeDiDgFiDiAjAfGiLeLiNoMjAkMiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
	BOOL		m_bProhibitDelete;	// _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiCmMiLnGiOhOiBeI_xHqqkZx_

	DWORDSet	m_stInsertedId;
	DWORDSet	m_stRemovedId;
	DWORDSet	m_stChangedId;
	IdToIdvMap	m_mpMergedId;

// _xZkqqHx_iDeBiDgHiDiKiDhCiDiFiBfLiDgH_xHqqkZx_
public:

// _xZkqqHx_iDeJiDhJiDiMiBfLiDfGiDiHiDjD_xHqqkZx_
public:

// _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_
public:
	virtual ~CFCMultiControlTmpl();

}; // class CFCMultiControlTmpl.

/////////////////////////////////////////////////////////////////////////////
// CFCMultiControlTmpl

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::CFCMultiControlTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
CFCMultiControlTmpl<SUPER>::CFCMultiControlTmpl ()
{
// 01.05.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_lgptMemo = CPoint(0, 0);		// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBgJiLeMiJkPjHhAiBgKiBeC_xHqqkZx_
	m_dwNextFreeId = 0;				// _xZkqqHx_iOjPiCmMiDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeCiDeBiDeDiDgFiDiAjAfGiLeLiNoMjAkMiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
	m_bProhibitDelete = FALSE;		// _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiCmMiLnGiOhOiBeI_xHqqkZx_
} // CFCMultiControlTmpl::CFCMultiControlTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::~CFCMultiControlTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
CFCMultiControlTmpl<SUPER>::~CFCMultiControlTmpl ()
{
} // CFCMultiControlTmpl::~CFCMultiControlTmpl.

/////////////////////////////////////////////////////////////////////////////
// CFCMultiControlTmpl _xZkqqHx_iDiGiBfLiDfFiKnGjAjE_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::AddFreeId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCpAjCmHiJmBiClHiCoJiBeCiDeBiDeDiDgFiDiAjAfGiLeLiNoMjAkMiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jCmHiJmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::AddFreeId (DWORD dwId)
{
	m_stFreeId.insert(dwId);
} // CFCMultiControlTmpl<SUPER>::AddFreeId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetFrontFixedItemSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFmAiCnBiCmMjBePjFpLiCmMiCkEiClPiBeBiNoNiPjMiBeFiInKjDkOiCkKiCmFiCkLiCmIiCkCiMmFjCoIiDeBiDeDiDgFiDiA_xHqqkZx_
 *			_xZkqqHx_iCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
long CFCMultiControlTmpl<SUPER>::GetFrontFixedItemSize () const
{
	return 0;
} // CFCMultiControlTmpl<SUPER>::GetFrontFixedItemSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetBackFixedItemSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFmAiCnBiCmMiMoDjFpLiCmMiCkEiClPiBeBiNoNiPjMiBeFiInKjDkOiCkKiCmFiCkLiCmIiCkCiMmFjCoIiDeBiDeDiDgFiDiA_xHqqkZx_
 *			_xZkqqHx_iCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
long CFCMultiControlTmpl<SUPER>::GetBackFixedItemSize () const
{
	return 0;
} // CFCMultiControlTmpl<SUPER>::GetBackFixedItemSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetSubMenuIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiPpAiMiPiCmFiDhMiDgCiDhGiDeBiDgCiDhGiClHiCoJiDiBiDgKiDiFiBfLiCmMiBeB_xHqqkZx_IDR_RBTN_MULTI_xZkqqHx_iCmMjCiGiCmJ_xHqqkZx_
 *			_xZkqqHx_iCkIiCkPiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeCjCmKiPoNiOjOiCmMiDhMiDgCiDhGiDeBiDgCiDhGiCmN_xHqqkZx_ 0_xZkqqHx_iBeBiDeBiDeDiDgFiDiAiInKjDkOjCiGiCmM_xHqqkZx_
 *				 _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiCmN_xHqqkZx_ 1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
long CFCMultiControlTmpl<SUPER>::GetSubMenuIndex (long lId) const
{
	if (lId == 0) return FD_MENU_MULT_MTRX_STATIC;
	return FD_MENU_MULT_MTRX_MOVING;
} // CFCMultiControlTmpl<SUPER>::GetSubMenuIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::OnInsertItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMjBhNjDpMiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_jBhNjDpMiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_jBhNjDpMiClDiCoKiCoJiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBhNjDpMiDeBiDeDiDgFiDiAiCkKiNoMjAkMiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::OnInsertItem (long lIndex, DWORD dwId)
{
	return FALSE;
} // CFCMultiControlTmpl<SUPER>::OnInsertItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::OnChangeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMjFmPiNfIiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKjFmPiNfIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::OnChangeItem (long lIndex, DWORD dwId)
{
	return FALSE;
} // CFCMultiControlTmpl<SUPER>::OnChangeItem.

//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::OnChangeItem2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMjFmPiNfIiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKjFmPiNfIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::OnChangeItem2 (long lIndex, DWORD dwId)
{
	return FALSE;
} // CFCMultiControlTmpl<SUPER>::OnChangeItem2.
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::OnDeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMiNoNiPjMiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKiNoNiPjMiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::OnDeleteItem (long lIndex, DWORD dwId)
{
	return FALSE;
} // CFCMultiControlTmpl<SUPER>::OnDeleteItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::OnMergeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMiDhNiBfLiDfHiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndexFrom	:_xZkqqHx_iDhNiBfLiDfHjBmOiPnLiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndexUntil	:_xZkqqHx_iDhNiBfLiDfHjBmOiPnLiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKiDhNiBfLiDfHiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lIndexUntil_xZkqqHx_iCkKiDhNiBfLiDfHjAoGiCmMiDeBiDeDiDgFiDiAiBeC_xHqqkZx_lIndexUntil - 1 _xZkqqHx_iCkJiCoH_xHqqkZx_
 *			lIndexFrom_xZkqqHx_iCnMiCmFiBgJ_xHqqkZx_lIndexFrom_xZkqqHx_iCpAiKnMiCnOiBgKiCpAiPiHiOjP_xHqqkZx_
 *			lIndexUntil_xZkqqHx_iDeBiDeDiDgFiDiAiCmJiDhNiBfLiDfHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::OnMergeItem (long lIndexFrom, long lIndexUntil)
{
	return FALSE;
} // CFCMultiControlTmpl<SUPER>::OnMergeItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::SetNextFreeId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjPiCmJiOgHiCkEiDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeCiDeBiDeDiDgFiDiAjAfGiLeLiNoMjAkMiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jAnNjCoIiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::SetNextFreeId (DWORD dwId)
{
	m_dwNextFreeId = dwId;
} // CFCMultiControlTmpl<SUPER>::SetNextFreeId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::SetProhibitDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiCpAiLnGiOhOiClHiCoJiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bProhibitDelete	:_xZkqqHx_iLnGiOhOiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_TRUE _xZkqqHx_iCmIiCoHiCmOiLnGiOhOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::SetProhibitDelete (BOOL bProhibitDelete)
{
	m_bProhibitDelete = bProhibitDelete;
} // CFCMultiControlTmpl<SUPER>::SetProhibitDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetProhibitDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiCkKiLnGiOhOiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLnGiOhOiPpDjBnEiBeC_xHqqkZx_TRUE _xZkqqHx_iCmIiCoHiCmOiLnGiOhOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::GetProhibitDelete () const
{
	return m_bProhibitDelete;
} // CFCMultiControlTmpl<SUPER>::GetProhibitDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetInsertedIdSet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBhNjDpMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
const DWORDSet& CFCMultiControlTmpl<SUPER>::GetInsertedIdSet () const
{
	return m_stInsertedId;
} // CFCMultiControlTmpl<SUPER>::GetInsertedIdSet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetRemovedIdSet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
const DWORDSet& CFCMultiControlTmpl<SUPER>::GetRemovedIdSet () const
{
	return m_stRemovedId;
} // CFCMultiControlTmpl<SUPER>::GetRemovedIdSet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetChangedIdSet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
const DWORDSet& CFCMultiControlTmpl<SUPER>::GetChangedIdSet () const
{
	return m_stChangedId;
} // CFCMultiControlTmpl<SUPER>::GetChangedIdSet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetMergedIdSet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
const IdToIdvMap& CFCMultiControlTmpl<SUPER>::GetMergedIdSet () const
{
	return m_mpMergedId;
} // CFCMultiControlTmpl<SUPER>::GetMergedIdSet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetMergedIdVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCmJiDhNiBfLiDfHiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iPfHiNiHiCmMjAoGjDkKiCmJiCmNiBeBiOhHjCoIiCmMiDeBiDeDiDgFiDiA_xHqqkZx_(dwId)_xZkqqHx_iCpAiKnMiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiBeCiOhHjCoIiCmMiDeBiDeDiDgFiDiAiCkKiDhNiBfLiDfHiPfHiNiHiCmFiCmNiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iLpDiCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
const DWORDVector& CFCMultiControlTmpl<SUPER>::GetMergedIdVector (DWORD dwId) const
{
	static DWORDVector vDummy;
	const DWORDVector* pvReturn = &vDummy;
	IdToIdvMap::const_iterator i = m_mpMergedId.find(dwId);
	if (i != m_mpMergedId.end()) pvReturn = &(*i).second;
	return *pvReturn;
} // CFCMultiControlTmpl<SUPER>::GetMergedIdVector.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::CanInsertItemPrev
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAjBhNjDpMiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::CanInsertItemPrev () const
{
	long lMidItem = GetItemCount() - GetFrontFixedItemSize() - GetBackFixedItemSize();
	long lFrontSelected;
	long lMidSelected;
	long lBackSelected;
	long lIndex = GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
	long lSelected = lFrontSelected + lMidSelected + lBackSelected;
	if (FFCanEditDocument() && lSelected == 1 && lFrontSelected == 0 &&
		lIndex <= lMidItem + GetFrontFixedItemSize()) return TRUE;
	return FALSE;
} // CFCMultiControlTmpl<SUPER>::CanInsertItemPrev.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::CanInsertItemNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAjBhNjDpMiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::CanInsertItemNext () const
{
	long lMidItem = GetItemCount() - GetFrontFixedItemSize() - GetBackFixedItemSize();
	long lFrontSelected;
	long lMidSelected;
	long lBackSelected;
	long lIndex = GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
	long lSelected = lFrontSelected + lMidSelected + lBackSelected;
	if (FFCanEditDocument() && lSelected == 1 && lBackSelected == 0 &&
		GetFrontFixedItemSize() -1 <= lIndex) return TRUE;
	// _xZkqqHx_jBeJjBpAiCkKiIoKiCmCiCoAiCmIiCkCiPoKiNiHiCmMjBmOiJjOiBeC_xHqqkZx_
	if (FFCanEditDocument() && lSelected == 0 && 0 <= lMidItem) return TRUE;
	return FALSE;
} // CFCMultiControlTmpl<SUPER>::CanInsertItemNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::CanStartMoveItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::CanStartMoveItem () const
{
	// Superclass_xZkqqHx_iKnGjAjEiCmNiMmEiCmOiCmIiCkCiBeCjElLjCgGiKoOiPiAiCkKiIoBiCkEiClNiCnPiBeC_xHqqkZx_
	long lMidItem = GetItemCount() - GetFrontFixedItemSize() - GetBackFixedItemSize();
	long lFrontSelected;
	long lMidSelected;
	long lBackSelected;
	long lIndex = GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
	long lSelected = lFrontSelected + lMidSelected + lBackSelected;
	if (FFCanEditDocument() && lFrontSelected == 0 && lBackSelected == 0 &&
		0 < lMidSelected && lMidSelected < lMidItem) return TRUE;
	return FALSE;
} // CFCMultiControlTmpl::CanStartMoveItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::CanMoveItemPrev
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::CanMoveItemPrev () const
{
	long lMidItem = GetItemCount() - GetFrontFixedItemSize() - GetBackFixedItemSize();
	long lFrontSelected;
	long lMidSelected;
	long lBackSelected;
	long lIndex = GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
	long lSelected = lFrontSelected + lMidSelected + lBackSelected;
	if (FFCanEditDocument() && lSelected == 1 && lFrontSelected == 0 &&
		lIndex <= lMidItem + GetFrontFixedItemSize()) return TRUE;
	return FALSE;
} // CFCMultiControlTmpl<SUPER>::CanMoveItemPrev.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::CanMoveItemNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::CanMoveItemNext () const
{
	long lMidItem = GetItemCount() - GetFrontFixedItemSize() - GetBackFixedItemSize();
	long lFrontSelected;
	long lMidSelected;
	long lBackSelected;
	long lIndex = GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
	long lSelected = lFrontSelected + lMidSelected + lBackSelected;
	if (FFCanEditDocument() && lSelected == 1 && lBackSelected == 0 &&
		GetFrontFixedItemSize() -1 <= lIndex) return TRUE;
	return FALSE;
} // CFCMultiControlTmpl<SUPER>::CanMoveItemNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::CanChangeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAjFmPiNfIiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::CanChangeItem () const
{
	long lMidItem = GetItemCount() - GetFrontFixedItemSize() - GetBackFixedItemSize();
	long lFrontSelected;
	long lMidSelected;
	long lBackSelected;
	long lIndex = GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
	long lSelected = lFrontSelected + lMidSelected + lBackSelected;
	if (FFCanEditDocument() && lSelected == 1 && lFrontSelected == 0 && lBackSelected == 0)
		return TRUE;
	return FALSE;
} // CFCMultiControlTmpl::CanChangeItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::CanDeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAiNoNiPjMiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::CanDeleteItem () const
{
	// _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiLnGiOhOiBeI_xHqqkZx_
	if (m_bProhibitDelete) return FALSE;
	long lMidItem = GetItemCount() - GetFrontFixedItemSize() - GetBackFixedItemSize();
	long lFrontSelected;
	long lMidSelected;
	long lBackSelected;
	long lIndex = GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
	long lSelected = lFrontSelected + lMidSelected + lBackSelected;
	if (FFCanEditDocument() && 0 < lSelected && lFrontSelected == 0 && lBackSelected == 0)
		return TRUE;
	return FALSE;
} // CFCMultiControlTmpl::CanDeleteItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::CanMergeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAiDhNiBfLiDfHiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::CanMergeItem () const
{
	return TRUE;
} // CFCMultiControlTmpl::CanMergeItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetNextFreeId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCkJiCoHiBeBiOjPiCmMiDhEiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAjElCiCkLiOoGiCoIjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
DWORD CFCMultiControlTmpl<SUPER>::GetNextFreeId ()
{
	DWORD dwNextId;
	if (!m_stFreeId.empty())
	//----- _xZkqqHx_iDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCkKiLpDiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCkJiCoHiBeBiIoKjEnEiPkMiClDiCkCjCgMiCpAjElCiCkLiPgPiClHiBeC_xHqqkZx_
		dwNextId = *m_stFreeId.begin();
		m_stFreeId.erase(dwNextId);
	} else
	//----- _xZkqqHx_iDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCkKiLpDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOjPiCmMiDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		dwNextId = m_dwNextFreeId;
		m_dwNextFreeId++;
	}
	return dwNextId;
} // CFCMultiControlTmpl<SUPER>::GetNextFreeId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::AddInsertedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLjCmHiJmBiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCmJiBeB_xHqqkZx_ID_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jCmHiJmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::AddInsertedId (DWORD dwId)
{
	m_stInsertedId.insert(dwId);
} // CFCMultiControlTmpl<SUPER>::AddInsertedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::AddRemovedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCmJiBeB_xHqqkZx_ID_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jCmHiJmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::AddRemovedId (DWORD dwId)
{
	m_stRemovedId.insert(dwId);
} // CFCMultiControlTmpl<SUPER>::AddRemovedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::AddRemovedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCmJiBeB_xHqqkZx_ID_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIdFrom	:_xZkqqHx_jCmHiJmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwIdTo		:_xZkqqHx_jCmHiJmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCmMiNmFiMoDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::AddRemovedId (const DWORD* dwIdFrom,
												const DWORD* dwIdTo)
{
	m_stRemovedId.insert(dwIdFrom, dwIdTo);
} // CFCMultiControlTmpl<SUPER>::AddRemovedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::AddChangedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCmJiBeB_xHqqkZx_ID_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jCmHiJmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::AddChangedId (DWORD dwId)
{
	m_stChangedId.insert(dwId);
} // CFCMultiControlTmpl<SUPER>::AddChangedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::AddMergedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCmJiBeB_xHqqkZx_ID_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId		:_xZkqqHx_jCmHiJmBiClHiCoJjAoGiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwAppendId	:_xZkqqHx_jCmHiJmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::AddMergedId (DWORD dwId, DWORD dwAppendId)
{
	m_mpMergedId[dwId].push_back(dwAppendId);
} // CFCMultiControlTmpl<SUPER>::AddMergedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::AddMergedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCmJiBeB_xHqqkZx_ID_xZkqqHx_iCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId		:_xZkqqHx_jCmHiJmBiClHiCoJjAoGiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwIdFrom	:_xZkqqHx_jCmHiJmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwIdTo		:_xZkqqHx_jCmHiJmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCmMiNmFiMoDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::AddMergedId (DWORD dwId, const DWORD* dwIdFrom,
												const DWORD* dwIdTo)
{
	m_mpMergedId[dwId].insert(m_mpMergedId[dwId].end(), dwIdFrom, dwIdTo);
} // CFCMultiControlTmpl<SUPER>::AddMergedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::IsInsertedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLjCmHiJmBiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCmJiBeBiOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCkKiKnMiCnMiCoKiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jClCiNlIiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnMiCnMiCoKiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::IsInsertedId (DWORD dwId) const
{
	return (m_stInsertedId.find(dwId) != m_stInsertedId.end());
} // CFCMultiControlTmpl<SUPER>::IsInsertedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::IsRemovedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCmJiBeBiOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCkKiKnMiCnMiCoKiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jClCiNlIiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnMiCnMiCoKiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::IsRemovedId (DWORD dwId) const
{
	return (m_stRemovedId.find(dwId) != m_stRemovedId.end());
} // CFCMultiControlTmpl<SUPER>::IsRemovedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::IsChangedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCmJiBeBiOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCkKiKnMiCnMiCoKiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jClCiNlIiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnMiCnMiCoKiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::IsChangedId (DWORD dwId) const
{
	return (m_stChangedId.find(dwId) != m_stChangedId.end());
} // CFCMultiControlTmpl<SUPER>::IsChangedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::IsMergedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCmJiBeBiOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCkKiKnMiCnMiCoKiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jClCiNlIiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnMiCnMiCoKiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::IsMergedId (DWORD dwId) const
{
	return (m_mpMergedId.find(dwId) != m_mpMergedId.end());
} // CFCMultiControlTmpl<SUPER>::IsMergedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::DelInsertedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiNoMjAkMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCkJiCoHiBeBiOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jGjFiPmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::DelInsertedId (DWORD dwId)
{
	m_stInsertedId.erase(dwId);
} // CFCMultiControlTmpl<SUPER>::DelInsertedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::DelRemovedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCkJiCoHiBeBiOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jGjFiPmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::DelRemovedId (DWORD dwId)
{
	m_stRemovedId.erase(dwId);
} // CFCMultiControlTmpl<SUPER>::DelRemovedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::DelChangedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCkJiCoHiBeBiOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jGjFiPmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::DelChangedId (DWORD dwId)
{
	m_stChangedId.erase(dwId);
} // CFCMultiControlTmpl<SUPER>::DelChangedId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::DelMergedId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDfHiClDiCoKiClNiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCkJiCoHiBeBiOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_jGjFiPmBiClHiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::DelMergedId (DWORD dwId)
{
	m_mpMergedId.erase(dwId);
} // CFCMultiControlTmpl<SUPER>::DelMergedId.

//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////----- 06.11.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
/////*************************************************************************
//// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::ClearContents
//// *
//// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgFiDjDiDgDiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
//// *
//// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
//// *************************************************************************/
////template<class SUPER>
////void CFCMultiControlTmpl<SUPER>::ClearContents ()
////{
////// 01.05.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//////	m_lgptMemo = CPoint(0, 0);		// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBgJiLeMiJkPjHhAiBgKiBeC_xHqqkZx_
////	m_dwNextFreeId = 0;				// _xZkqqHx_iOjPiCmMiDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeCiDeBiDeDiDgFiDiAjAfGiLeLiNoMjAkMiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
////	// _xZkqqHx_iOjPiCmMiDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeCiDeBiDeDiDgFiDiAjAfGiLeLiNoMjAkMiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
////	m_dwNextFreeId = 0;
////	// _xZkqqHx_iNoNiPjMiBeBjFmPiNfIiBeBjCmHiJmBiBeBiDhNiBfLiDfHiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
////	m_stInsertedId.clear();
////	m_stRemovedId.clear();
////	m_stChangedId.clear();
////	m_mpMergedId.clear();
////	// Superclass_xZkqqHx_iBeC_xHqqkZx_
////	SUPER::ClearContents();
////} // CFCMultiControlTmpl<SUPER>::ClearContents.
////----- 06.11.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::ClearContents
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgFiDjDiDgDiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::ClearContents ()
{
// 01.05.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_lgptMemo = CPoint(0, 0);		// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBgJiLeMiJkPjHhAiBgKiBeC_xHqqkZx_
	m_dwNextFreeId = 0;				// _xZkqqHx_iOjPiCmMiDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeCiDeBiDeDiDgFiDiAjAfGiLeLiNoMjAkMiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
	// _xZkqqHx_iOjPiCmMiDhEiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeCiDeBiDeDiDgFiDiAjAfGiLeLiNoMjAkMiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
	m_dwNextFreeId = 0;
	// _xZkqqHx_iNoNiPjMiBeBjFmPiNfIiBeBjCmHiJmBiBeBiDhNiBfLiDfHiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_stInsertedId.clear();
	m_stRemovedId.clear();
	m_stChangedId.clear();
	m_mpMergedId.clear();
	// Superclass_xZkqqHx_iBeC_xHqqkZx_
	SUPER::ClearContents();
} // CFCMultiControlTmpl<SUPER>::ClearContents.
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::OnCmdMsg
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjDlBiCkLiDgGiDeCiDfIiDhAiDgCiDgAiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iDhHiDiLiDhGiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiPiIjHjNiClDiCoKiClNiCmGiCkLiCmN_xHqqkZx_ 0 _xZkqqHx_iImIiKePiBeCiClLiCoKiImIiKePiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiCpAiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClFiCmIiCkCiCmGiBeBiDfCiDhNiDjDiDgI_xHqqkZx_(ID_XXXX)_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjDmNiCkPiCoHiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCMultiControlTmpl<SUPER>::OnCmdMsg (UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	if (pHandlerInfo == NULL)
	{
		if (nCode == CN_UPDATE_COMMAND_UI)
		{
			CCmdUI* pCmdUI = (CCmdUI*)pExtra;
			//----- _xZkqqHx_iClBiCmMiDhEiDiMiBfLiDiAiCmMiDfCiDhNiDjDiDgIiCpAjClCiCnHiCoJ_xHqqkZx_ -----
			switch (nID)
			{
			//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCpAiInKjDkO_xHqqkZx_ -----
			case ID_RBTN_ITEM_MOVE_BEGIN:
				pCmdUI->Enable(CanStartMoveItem());
				return TRUE;
			//----- _xZkqqHx_jClMjBePiCmJiDeBiDeDiDgFiDiAjBhNjDpM_xHqqkZx_ -----
			case ID_RBTN_ITEM_INSERT_PREV:
				pCmdUI->Enable(CanInsertItemPrev());
				return TRUE;
			//----- _xZkqqHx_jClMjBePiCmJiDeBiDeDiDgFiDiAiInKjDkO_xHqqkZx_ -----
			case ID_RBTN_ITEM_MOVE_PREV:
				pCmdUI->Enable(CanMoveItemPrev());
				return TRUE;
			//----- _xZkqqHx_jClMiMoDiCmJiDeBiDeDiDgFiDiAjBhNjDpM_xHqqkZx_ -----
			case ID_RBTN_ITEM_INSERT_NEXT:
				pCmdUI->Enable(CanInsertItemNext());
				return TRUE;
			//----- _xZkqqHx_jClMiMoDiCmJiDeBiDeDiDgFiDiAiInKjDkO_xHqqkZx_ -----
			case ID_RBTN_ITEM_MOVE_NEXT:
				pCmdUI->Enable(CanMoveItemNext());
				return TRUE;
			//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCpAiNoNiPjM_xHqqkZx_ -----
			case ID_RBTN_ITEM_DELETE:
				pCmdUI->Enable(CanDeleteItem());
				return TRUE;
			//----- _xZkqqHx_iDeBiDeDiDgFiDiAjGlMiCpAjFmPiNfI_xHqqkZx_ -----
			case ID_RBTN_ITEM_CHANGE:
				pCmdUI->Enable(CanChangeItem());
				return TRUE;
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			//----- _xZkqqHx_iDeBiDeDiDgFiDiAjGlMiCpAjFmPiNfI_xHqqkZx_2 -----
			case ID_RBTN_ITEM_CHANGE_2:
				pCmdUI->Enable(CanChangeItem());
				return TRUE;
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCpAiDhNiBfLiDfH_xHqqkZx_ -----
			case ID_RBTN_ITEM_MERGE:
				pCmdUI->Enable(CanMergeItem());
				return TRUE;
			//----- _xZkqqHx_iDeBiDeDiDgFiDiAiInKjDkOiCpAjCiGiOhO_xHqqkZx_ -----
			case ID_RBTN_ITEM_MOVE_CANCEL:
				pCmdUI->Enable(FFCanEditDocument());
				return TRUE;
			}
		}
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return SUPER::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
} // CFCMultiControlTmpl<SUPER>::OnCmdMsg.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::GetSelectedCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiClNiDeBiDeDiDgFiDiAjAjEiCpAiBeBjBePjFpLiMmFjCoIiIoGiBeBjCiGiKnEjEpBiMmFjCoIiIoGiBeBiMoDjFpLiMmFjCoIiIoG_xHqqkZx_
 *			_xZkqqHx_iClCiCmGiCmJjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lFrontSelected	:_xZkqqHx_jBePjFpLiMmFjCoIiIoGjCiGiCmFiBeBjBeJjBpAiClDiCoKiClNiDeBiDeDiDgFiDiAjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *			lMidSelected	:_xZkqqHx_jCiGiKnEjEpBiMmFjCoIiIoGjCiGiCmFiBeBjBeJjBpAiClDiCoKiClNiDeBiDeDiDgFiDiAjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *			lBackSelected	:_xZkqqHx_iMoDjFpLiMmFjCoIiIoGjCiGiCmFiBeBjBeJjBpAiClDiCoKiClNiDeBiDeDiDgFiDiAjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
long CFCMultiControlTmpl<SUPER>::GetSelectedCount (
				long& lFrontSelected, long& lMidSelected, long& lBackSelected) const
{
	lFrontSelected = 0;
	lMidSelected = 0;
	lBackSelected = 0;
	long lCurIndex = -1;
	long lIndex;
	for (lIndex = 0; lIndex < GetFrontFixedItemSize() && lIndex < GetItemCount(); lIndex++)
		if (IsSelectionMark(lIndex))
		{
			lFrontSelected++;
			lCurIndex = lIndex;
		}
	for (; lIndex < GetItemCount() - GetBackFixedItemSize() && lIndex < GetItemCount(); lIndex++)
		if (IsSelectionMark(lIndex))
		{
			lMidSelected++;
			lCurIndex = lIndex;
		}
	for (; lIndex < GetItemCount(); lIndex++)
		if (IsSelectionMark(lIndex))
		{
			lBackSelected++;
			lCurIndex = lIndex;
		}
	return lCurIndex;
} // CFCMultiControlTmpl<SUPER>::GetSelectedCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::MoveItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDgCiDgHiDhNiBfLiDeOiCkKjFhEiCkCiClNiDeBiDeDiDgFiDiAiCpAiBeBiOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmJ_xHqqkZx_
 *			_xZkqqHx_iInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lTargetIndex	:_xZkqqHx_iInKjDkOjAoGiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCiClBiCmMjClMjBePiCmJjBhNjDpMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::MoveItem (long lTargetIndex)
{
	if (lTargetIndex == -1)
		lTargetIndex = GetItemCount();
	if (GetItemCount() < lTargetIndex)
		lTargetIndex = GetItemCount();
	if (lTargetIndex < GetFrontFixedItemSize())
		lTargetIndex = GetFrontFixedItemSize();
	if (GetItemCount() - GetBackFixedItemSize() < lTargetIndex)
		lTargetIndex = GetItemCount() - GetBackFixedItemSize();
	// _xZkqqHx_iDeKiDgCiDgHiDeBiDeDiDgFiDiAiCmIiCoHiCmOiBeBjBhNjDpMiImKjChFiCpAiMoDiCoLiCmJiInKjDkOiBeC_xHqqkZx_
	for (; lTargetIndex < GetItemCount() && IsCutMark(lTargetIndex); lTargetIndex++);
	// _xZkqqHx_jBfDiCmEiCmMjBeJjBpAjCiGiDeBiDeDiDgFiDiAiCmMjBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
	SetAllSelectionMark(FALSE);
	//----- _xZkqqHx_iInKjDkOiClHiCoJiDeBiDeDiDgFiDiAiCmMiDiKiDfIiDgHiCpAiNoMjAkM_xHqqkZx_ -----
	DWORDVector vMove;
	long lIndex;
	for (lIndex = 0; lIndex < GetItemCount(); lIndex++)
	{
		if (IsCutMark(lIndex))
			vMove.push_back(GetItemData(lIndex));
	}
	//----- _xZkqqHx_jBhNjDpMiImKjChFiCmJiBeBjFnLjBlGiClFiCmEiCkIiCkCiClNiDeBiDeDiDgFiDiAiCpAjBhNjDpM_xHqqkZx_ -----
	while (!vMove.empty())
	{
		InsertItem(lTargetIndex, vMove.back());
		vMove.pop_back();
		// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
		SetSelectionMark(lTargetIndex);
	}
	//----- _xZkqqHx_iNoNiPjMiDhNiBfLiDeOiCkKjFhEiJmBiClDiCoKiCmEiCkCiCoJiDeBiDeDiDgFiDiAiCpAiNoNiPjM_xHqqkZx_ -----
	for (lIndex = 0; lIndex < GetItemCount();)
	{
		if (IsCutMark(lIndex))
			DeleteItem(lIndex);
		else
			lIndex++;
	}
	// _xZkqqHx_iNmFiMoDiCmMjBeJjBpAiDeBiDeDiDgFiDiAiCpAiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmJjAnNjCoIiBeC_xHqqkZx_
	for (lIndex = GetItemCount() - 1; 0 <= lIndex; lIndex--)
		if (IsSelectionMark(lIndex)) break;
// 01.03.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	SetIndexAB(lIndex, lIndex, FALSE, TRUE);
	SetIndexAB(lIndex, lIndex, TRUE, TRUE);
	// _xZkqqHx_jFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
	GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
	// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
	Invalidate();
} // CFCMultiControlTmpl::MoveItem.

//----- 01.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::MemoMscPoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void CFCMultiControlTmpl<SUPER>::MemoMscPoint ()
//{
//	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBgJiLeMiJkPjHhAiBgKiBeC_xHqqkZx_
//	m_lgptMemo = m_ptMsc;
//} // CFCMultiControlTmpl::MemoMscPoint.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::CalcMemoToMscPower
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLeMjIfOiClDiCoKiClNiImKjChFiCmGiBeBiMlLiNnNiCmMiDhNiDeFiDfIiImKjChFiCmMiLjHjHkDiCmMiCfBiPoGiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLjHjHkDiCmMiCfBiPoGiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//long CFCMultiControlTmpl<SUPER>::CalcMemoToMscPower () const
//{
//	CSize sz = m_lgptMemo - m_ptMsc;
//	return sz.cx * sz.cx + sz.cy * sz.cy;
//} // CFCMultiControlTmpl::CalcMemoToMscPower.
//----- 01.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.02.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl<SUPER>::OnUpdatePopupMenu
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiDeBiDeDiDgFiDiAiCmMjHeMiMpIjAkLiCpAiDgAiDeGiDgCiDeOiClFiBeB_xHqqkZx_
// *			_xZkqqHx_jGlDiMpIiCmMiDfCiDhNiDjDiDgIiCmNiDePiDiMiBfLiBjFjGlDiMpIiJlLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pMenu	:_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void CFCMultiControlTmpl<SUPER>::OnUpdatePopupMenu (CMenu* pMenu) const
//{
//#ifndef _DEBUG
//_xZkqqHx_iClBiCmMiKnGjAjEiCmNiBeBiNoNiPjMiCmFiCkLiCoJiCmMiCmFiCmNiBeI_xHqqkZx_
//CFCCtlBrHTree::OnCmdMsg_xZkqqHx_iCmG_xHqqkZx_CFCWndHistoryTree_xZkqqHx_iCmMiDfCiDhNiDjDiDgIiPiIjHjNiCpAiOfBiPmGiBeC_xHqqkZx_
//#endif//_DEBUG
//
//	//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCpAiInKjDkO_xHqqkZx_ -----
//	ON_UPDATE_POPUP_MENU(ID_RBTN_ITEM_MOVE_BEGIN, CanStartMoveItem())
//	//----- _xZkqqHx_jClMjBePiCmJiDeBiDeDiDgFiDiAjBhNjDpM_xHqqkZx_ -----
//	ON_UPDATE_POPUP_MENU(ID_RBTN_ITEM_INSERT_PREV, CanInsertItemPrev())
//	//----- _xZkqqHx_jClMjBePiCmJiDeBiDeDiDgFiDiAiInKjDkO_xHqqkZx_ -----
//	ON_UPDATE_POPUP_MENU(ID_RBTN_ITEM_MOVE_PREV, CanMoveItemPrev())
//	//----- _xZkqqHx_jClMiMoDiCmJiDeBiDeDiDgFiDiAjBhNjDpM_xHqqkZx_ -----
//	ON_UPDATE_POPUP_MENU(ID_RBTN_ITEM_INSERT_NEXT, CanInsertItemNext())
//	//----- _xZkqqHx_jClMiMoDiCmJiDeBiDeDiDgFiDiAiInKjDkO_xHqqkZx_ -----
//	ON_UPDATE_POPUP_MENU(ID_RBTN_ITEM_MOVE_NEXT, CanMoveItemNext())
//	//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCpAiNoNiPjM_xHqqkZx_ -----
//	ON_UPDATE_POPUP_MENU(ID_RBTN_ITEM_DELETE, CanDeleteItem())
//	//----- _xZkqqHx_iDeBiDeDiDgFiDiAjGlMiCpAjFmPiNfI_xHqqkZx_ -----
//	ON_UPDATE_POPUP_MENU(ID_RBTN_ITEM_CHANGE, CanChangeItem())
//	//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCpAiDhNiBfLiDfH_xHqqkZx_ -----
//	ON_UPDATE_POPUP_MENU(ID_RBTN_ITEM_MERGE, CanMergeItem())
//	//----- _xZkqqHx_iDeBiDeDiDgFiDiAiInKjDkOiCpAjCiGiOhO_xHqqkZx_ -----
//	ON_UPDATE_POPUP_MENU(ID_RBTN_ITEM_MOVE_CANCEL, FFCanEditDocument())
//} // CFCMultiControlTmpl<SUPER>::OnUpdatePopupMenu.
//----- 06.02.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::TimerEvent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDhNiBfLiCkKjAnNjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBjCoIiKpKjDeJiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIDEvent	:_xZkqqHx_iDfOiDeDiDhNiBfLiDeDiDhIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::TimerEvent (DWORD dwIDEvent)
{
	TRACE(_T("CFCMultiControlTmpl::TimerEvent\r\n"));
//----- 06.11.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
//	CRect rtClient;
//	GetClientRect(rtClient);
//	// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
//	CPoint dvptMsc;
//	(void)::GetCursorPos(&dvptMsc);
//	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiNmAjFfHiCpAiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCnGjFmPiKlHiBeC_xHqqkZx_
//	ScreenToClient(&dvptMsc);
//	long lMoveY = 0;
//	if (dvptMsc.y <= rtClient.top)
//	{
//		lMoveY = -1 - (rtClient.top - dvptMsc.y) / GetItemHeight();
//	} else if (rtClient.bottom <= dvptMsc.y)
//	{
//		lMoveY = 1 + (dvptMsc.y - rtClient.bottom) / GetItemHeight();
//	}
//	if (::FFGetCapture() != m_hWnd || lMoveY == 0)
//	//----- _xZkqqHx_iDeMiDiDiDhGiDgAiDiDiCkKiKePiCoKiCmEiCkCiCoJiPoKiNiHiBeBiDhNiDeFiDfIiCkKjHmMiIoGjDoAiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		if (m_dwTimer != 0)
//		{
//			// _xZkqqHx_iDfOiDeDiDhNiBfLjCoCiOhOiBeC_xHqqkZx_
//			(void)KillTimer(m_dwTimer);
//			// _xZkqqHx_iDfOiDeDiDhNiBfLjCoCiOhOjCiGiCmJjAnNjCoIiBeC_xHqqkZx_
//			m_dwTimer = 0;
//		}
//	} else
//	//----- _xZkqqHx_iDeMiDiDiDhGiDgAiDiDiCkKiCkAiCoIiBeBiDhNiDeFiDfIiCkKjHmMiIoGiKePiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		//----- _xZkqqHx_iPgDiDfIiDeOiDiNiBfLiDiL_xHqqkZx_ -----
//		OffsetScroll(-lMoveY);
//		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiBeC_xHqqkZx_
//		PostMessage(WM_MOUSEMOVE, 0, MAKELPARAM(dvptMsc.x, dvptMsc.y));
//	}
//----- 06.11.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
	CPoint dvptMsc;
	(void)::GetCursorPos(&dvptMsc);
	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiNmAjFfHiCpAiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCnGjFmPiKlHiBeC_xHqqkZx_
	ScreenToClient(&dvptMsc);
	long lMoveY = 0;
	if (dvptMsc.y <= rtClient.top)
	{
		lMoveY =  -(rtClient.top - dvptMsc.y) / GetPixelOf1Scroll();
		if (lMoveY == 0) lMoveY = -1;
	} else if (rtClient.bottom <= dvptMsc.y)
	{
		lMoveY = (dvptMsc.y - rtClient.bottom) / GetPixelOf1Scroll();
		if (lMoveY == 0) lMoveY = 1;
	}
	if (::FFGetCapture() != m_hWnd || lMoveY == 0)
	//----- _xZkqqHx_iDeMiDiDiDhGiDgAiDiDiCkKiKePiCoKiCmEiCkCiCoJiPoKiNiHiBeBiDhNiDeFiDfIiCkKjHmMiIoGjDoAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_dwTimer != 0)
		{
			// _xZkqqHx_iDfOiDeDiDhNiBfLjCoCiOhOiBeC_xHqqkZx_
			(void)KillTimer(m_dwTimer);
			// _xZkqqHx_iDfOiDeDiDhNiBfLjCoCiOhOjCiGiCmJjAnNjCoIiBeC_xHqqkZx_
			m_dwTimer = 0;
		}
	} else
	//----- _xZkqqHx_iDeMiDiDiDhGiDgAiDiDiCkKiCkAiCoIiBeBiDhNiDeFiDfIiCkKjHmMiIoGiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iPgDiDfIiDeOiDiNiBfLiDiL_xHqqkZx_ -----
		OffsetScroll(-lMoveY);
		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiBeC_xHqqkZx_
		PostMessage(WM_MOUSEMOVE, 0, MAKELPARAM(dvptMsc.x, dvptMsc.y));
	}
//----- 06.11.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMultiControlTmpl::TimerEvent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolBaseFDA.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMessage	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCommand	:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
long CFCMultiControlTmpl<SUPER>::TransFDA (long lState, DWORD dwMessage, DWORD dwCommand)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	long lNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeBiDeDiDgFiDiAiCkKjGlDiCkCiPoKiNiHiCmNiDfPiDiBiBeC_xHqqkZx_
//	if (GetItemCount() == 0) return lNextState;
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (lState)
	{
	case STATE_IDLE:				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		switch (dwMessage)
		{
		case WM_COMMAND:		// _xZkqqHx_iDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			switch (dwCommand)
			{
			case ID_RBTN_ITEM_MOVE_BEGIN:
				if (CanStartMoveItem())
					lNextState = STATE_BEGIN_STATIC_MOVE_ITEM;	// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
				break;
			case ID_RBTN_ITEM_INSERT_PREV:
				if (CanInsertItemPrev())
					lNextState = STATE_CMD_INSERT_ITEM_PREV;	// _xZkqqHx_jClMjBePiCnGjBhNjDpMiBeC_xHqqkZx_
				break;
			case ID_RBTN_ITEM_INSERT_NEXT:
				if (CanInsertItemNext())
					lNextState = STATE_CMD_INSERT_ITEM_NEXT;	// _xZkqqHx_jClMiMoDiCnGjBhNjDpMiBeC_xHqqkZx_
				break;
			case ID_RBTN_ITEM_DELETE:
				if (CanDeleteItem())
					lNextState = STATE_CMD_DELETE_ITEM;			// _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiBeC_xHqqkZx_
				break;
			case ID_RBTN_ITEM_CHANGE:
				if (CanChangeItem())
					lNextState = STATE_CMD_CHANGE_ITEM;			// _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfIiBeC_xHqqkZx_
				break;
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			case ID_RBTN_ITEM_CHANGE_2:
				if (CanChangeItem())
					lNextState = STATE_CMD_CHANGE_ITEM_2;		// _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfI_xHqqkZx_2_xZkqqHx_iBeC_xHqqkZx_
				break;
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			case ID_RBTN_ITEM_MERGE:
				if (CanMergeItem())
					lNextState = STATE_CMD_MERGE_ITEM;			// _xZkqqHx_iDeBiDeDiDgFiDiAiDhNiBfLiDfHiBeC_xHqqkZx_
				break;
			}
			break;

		case WM_KEYDOWN:		// _xZkqqHx_iDeMiBfLiDfPiDeFiDjDiBeC_xHqqkZx_
			if (m_dwChar == VK_DELETE && CanDeleteItem())
				lNextState = STATE_CMD_DELETE_ITEM;			// _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiBeC_xHqqkZx_
			break;
		}
		break;

//----- 01.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case STATE_WAIT_EVENT:			// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClPiBeC_xHqqkZx_
//		switch (dwMessage)
//		{
//		case WM_MOUSEMOVE:		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
//			if (4 < CalcMemoToMscPower() && CanStartMoveItem())
//				lNextState = STATE_BEGIN_MOVE_ITEM;			// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
//			break;
//		}
//		break;
//
//	case STATE_WAIT_EVENT_2:			// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClP_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
//		switch (dwMessage)
//		{
//		case WM_MOUSEMOVE:		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
//			if (4 < CalcMemoToMscPower() && CanStartMoveItem())
//				lNextState = STATE_BEGIN_MOVE_ITEM;			// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
//			break;
//		}
//		break;
//
//	case STATE_BEGIN_MOVE_ITEM:	// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
//		lNextState = STATE_MOVING_ITEM;						// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
//		break;
//
//	case STATE_MOVING_ITEM:	// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
//		switch (dwMessage)
//		{
//		case WM_MOUSEMOVE:		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
//			lNextState = STATE_MOVING_ITEM;					// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
//			break;
//
//		case WM_LBUTTONUP:		// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
//			lNextState = STATE_END_MOVE_ITEM;				// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
//			break;
//
//		case WM_RBUTTONUP:		// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
//			lNextState = STATE_CANCEL_MOVE_ITEM;			// _xZkqqHx_iInKjDkOiPiIjHjNjCiGiOhOiBeC_xHqqkZx_
//			break;
//		}
//		break;
//
//	case STATE_END_MOVE_ITEM:	// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
//		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
//		break;
//
//	case STATE_CANCEL_MOVE_ITEM:	// _xZkqqHx_iInKjDkOiPiIjHjNjCiGiOhOiBeC_xHqqkZx_
//		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
//		break;
//----- 01.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	case STATE_RBTN_SELECT_ITEM_2:	// _xZkqqHx_iJeFiDhLiDfOiDjDjHhAjBeJjBpA_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		lNextState = STATE_STATIC_MOVING_ITEM;	// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNjCiGiBeC_xHqqkZx_
		break;

	case STATE_CONTEXT_MENU_2:		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		lNextState = STATE_STATIC_MOVING_ITEM;	// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNjCiGiBeC_xHqqkZx_
		break;

	case STATE_BEGIN_STATIC_MOVE_ITEM:	// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
		lNextState = STATE_STATIC_MOVING_ITEM;	// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNjCiGiBeC_xHqqkZx_
		break;

	case STATE_STATIC_MOVING_ITEM:	// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNjCiGiBeC_xHqqkZx_
		switch (dwMessage)
		{
		case WM_COMMAND:		// _xZkqqHx_iDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			if (dwCommand == ID_RBTN_ITEM_MOVE_CANCEL)
				lNextState = STATE_CANCEL_MOVE_ITEM;		// _xZkqqHx_iInKjDkOiPiIjHjNjCiGiOhOiBeC_xHqqkZx_
			else
			if (dwCommand == ID_RBTN_ITEM_MOVE_PREV)
				lNextState = STATE_STATIC_MOVE_ITEM_PREV;	// _xZkqqHx_jClMjBePiCnGjAmDjDeJiInKjDkOiBeC_xHqqkZx_
			else
			if (dwCommand == ID_RBTN_ITEM_MOVE_NEXT)
				lNextState = STATE_STATIC_MOVE_ITEM_NEXT;	// _xZkqqHx_jClMiMoDiCnGjAmDjDeJiInKjDkOiBeC_xHqqkZx_
			break;

		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			lNextState = STATE_END_MOVE_ITEM;	// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
			break;

		case WM_MOUSEMOVE:		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			lNextState = STATE_STATIC_MOVING_ITEM;	// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNjCiGiBeC_xHqqkZx_
			break;

		case WM_RBUTTONDOWN:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (!(m_dwFlags & MK_SHIFT) && !(m_dwFlags & MK_CONTROL) && !IsOnSelectedItem(m_ptMsc))
				lNextState = STATE_RBTN_SELECT_ITEM_2;		// _xZkqqHx_iJeFiDhLiDfOiDjDjHhAjBeJjBpA_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
			break;

		case WM_CONTEXTMENU:		// _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiDiBiDgKiDiFiBfLiBeC_xHqqkZx_
			lNextState = STATE_CONTEXT_MENU_2;				// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
			break;

		}
		break;

	case STATE_STATIC_MOVE_ITEM_PREV:	// _xZkqqHx_jClMjBePiCnGjAmDjDeJiInKjDkOiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_STATIC_MOVE_ITEM_NEXT:	// _xZkqqHx_jClMiMoDiCnGjAmDjDeJiInKjDkOiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_CMD_INSERT_ITEM_PREV:	// _xZkqqHx_jClMjBePiCnGjBhNjDpMiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_CMD_INSERT_ITEM_NEXT:	// _xZkqqHx_jClMiMoDiCnGjBhNjDpMiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_CMD_DELETE_ITEM:			// _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_CMD_CHANGE_ITEM:			// _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfIiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case STATE_CMD_CHANGE_ITEM_2:			// _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfI_xHqqkZx_2_xZkqqHx_iBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	case STATE_CMD_MERGE_ITEM:			// _xZkqqHx_iDeBiDeDiDgFiDiAiDhNiBfLiDfHiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (lNextState == STATE_NONE)
		lNextState = SUPER::TransFDA(lState, dwMessage, dwCommand);
	return lNextState;
} // CFCMultiControlTmpl::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateFDA (long lState)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (lState)
	{
	case STATE_NONE:					// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
		break;
//----- 01.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case STATE_BEGIN_MOVE_ITEM:			// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
//		StateBeginMoveItem();
//		break;
//	case STATE_MOVING_ITEM:				// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
//		StateMovingItem();
//		break;
//	case STATE_END_MOVE_ITEM:			// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
//		StateEndMoveItem();
//		break;
//	case STATE_CANCEL_MOVE_ITEM:		// _xZkqqHx_iInKjDkOiPiIjHjNjCiGiOhOiBeC_xHqqkZx_
//		StateCancelMoveItem();
//		break;
//----- 01.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case STATE_RBTN_SELECT_ITEM_2:		// _xZkqqHx_iJeFiDhLiDfOiDjDjHhAjBeJjBpA_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		StateRbtnSelectItem2();
		break;
	case STATE_CONTEXT_MENU_2:			// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		StateContextMenu2();
		break;
	case STATE_BEGIN_STATIC_MOVE_ITEM:	// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
		StateBeginStaticMoveItem();
		break;
	case STATE_STATIC_MOVING_ITEM:		// _xZkqqHx_jAmDjDeJiInKjDkOiPiIjHjNjCiGiBeC_xHqqkZx_
		StateStaticMovingItem();
		break;
	case STATE_STATIC_MOVE_ITEM_PREV:	// _xZkqqHx_jClMjBePiCnGjAmDjDeJiInKjDkOiBeC_xHqqkZx_
		StateStaticMoveItemPrev();
		break;
	case STATE_STATIC_MOVE_ITEM_NEXT:	// _xZkqqHx_jClMiMoDiCnGjAmDjDeJiInKjDkOiBeC_xHqqkZx_
		StateStaticMoveItemNext();
		break;
	case STATE_CMD_INSERT_ITEM_PREV:	// _xZkqqHx_jClMjBePiCnGjBhNjDpMiBeC_xHqqkZx_
		StateCmdInsertItemPrev();
		break;
	case STATE_CMD_INSERT_ITEM_NEXT:	// _xZkqqHx_jClMiMoDiCnGjBhNjDpMiBeC_xHqqkZx_
		StateCmdInsertItemNext();
		break;
	case STATE_CMD_DELETE_ITEM:			// _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiBeC_xHqqkZx_
		StateCmdDeleteItem();
		break;
	case STATE_CMD_CHANGE_ITEM:			// _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfIiBeC_xHqqkZx_
		StateCmdChangeItem();
		break;
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case STATE_CMD_CHANGE_ITEM_2:		// _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfI_xHqqkZx_2_xZkqqHx_iBeC_xHqqkZx_
		StateCmdChangeItem2();
		break;
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	case STATE_CMD_MERGE_ITEM:			// _xZkqqHx_iDeBiDeDiDgFiDiAiDhNiBfLiDfHiBeC_xHqqkZx_
		StateCmdMergeItem();
		break;
	default:
		SUPER::StateFDA(lState);
	}
} // CFCMultiControlTmpl::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateContextMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDiBiDgKiDiFiBfLjFfMiOkGiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateContextMenu ()
{
	TRACE(_T("CFCMultiControlTmpl::StateContextMenu\r\n"));
//----- 01.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CMenu menu;
//	CPoint point = m_ptMsc;
//	if (menu.LoadMenu(IDR_RBTN_MULTI))
//	{
//		if (point.x < 0 || point.y < 0)
//		//----- _xZkqqHx_iDiBiDgKiDiFiBfLiDeMiBfLiCmJiCoGiCoJiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMiDeBiDeDiDgFiDiAiImKjChFiCmJiDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
//			CRect rtItem(0,0,0,0);
//			if (0 <= GetIndexA())
//				GetItemRect(rtItem, GetIndexA());
//			point = rtItem.CenterPoint();
//			ClientToScreen(&point);
//		}
//		CMenu* pPopup;
//		pPopup = menu.GetSubMenu(GetSubMenuIndex(0));
//		ASSERT(pPopup != NULL);
//		// _xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiCmIiCoHiCmOiBeBiDiBiDgKiDiFiBfLiCpAjFmPiNfIiBeC_xHqqkZx_
//		if (g_pReg->GetIsLeftHand())
//			::RightByLeftHand(pPopup->m_hMenu, TRUE);
//		// _xZkqqHx_iDiBiDgKiDiFiBfLiDeBiDeDiDgFiDiAiCmMjHeMiMpIjAkLiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
////		OnUpdatePopupMenu(pPopup);
//		pPopup->TrackPopupMenu(TPM_RIGHTBUTTON | TPM_LEFTALIGN,
//								point.x, point.y,
//								// route commands through main window.
//								this);
//	}
//----- 01.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 05.01.31 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CPoint point = m_ptMsc;
//	if (point.x < 0 || point.y < 0)
//	//----- _xZkqqHx_iDiBiDgKiDiFiBfLiDeMiBfLiCmJiCoGiCoJiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMiDeBiDeDiDgFiDiAiImKjChFiCmJiDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
//		CRect rtItem(0,0,0,0);
//		if (0 <= GetIndexA())
//			GetItemRect(rtItem, GetIndexA());
//		point = rtItem.CenterPoint();
//		ClientToScreen(&point);
//	}
//	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
//	FFPopupSubmenu(point, GetSubMenuIndex(0), this);
//----- 05.01.31 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
	FFPopupSubmenu(m_ptMsc, IDR_RBTN_MULTI, GetSubMenuIndex(0), this);
//----- 05.01.31 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMultiControlTmpl::StateContextMenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateWaitEvent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeDiDhIiDjDiDgHjBnCiClPiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateWaitEvent ()
{
	TRACE(_T("CFCMultiControlTmpl::StateWaitEvent\r\n"));
//----- 01.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiLeMiJkPiBeCiInKjDkOjHmKiMhGiOfKjHhAiBeC_xHqqkZx_
//	MemoMscPoint();
//----- 01.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	SUPER::StateWaitEvent();
//----- 01.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMultiControlTmpl::StateWaitEvent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateWaitEvent2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeDiDhIiDjDiDgHjBnCiClP_xHqqkZx__2_xZkqqHx_iBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateWaitEvent2 ()
{
	TRACE(_T("CFCMultiControlTmpl::StateWaitEvent2\r\n"));
	StateWaitEvent();
} // CFCMultiControlTmpl::StateWaitEvent2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateBeginMoveItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiInKjDkOiPiIjHjNiKeKiOgOiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateBeginMoveItem ()
{
	TRACE(_T("CFCMultiControlTmpl::StateBeginMoveItem\r\n"));
	// _xZkqqHx_iClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(m_hWnd);
	// _xZkqqHx_jBfDiCmEiCmMjBeJjBpAjCiGiDeBiDeDiDgFiDiAiCmJiDeKiDgCiDgHiCpAiDhNiBfLiDeOiBeC_xHqqkZx_
	for (long lIndex = 0; lIndex < GetItemCount(); lIndex++)
	{
		if (IsSelectionMark(lIndex))
			SetCutMark(lIndex);
	}
} // CFCMultiControlTmpl::StateBeginMoveItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateMovingItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiInKjDkOiPiIjHjNiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateMovingItem ()
{
	TRACE(_T("CFCMultiControlTmpl::StateMovingItem\r\n"));
	// _xZkqqHx_iDeKiBfLiDfMiDiLjFmPiNfIiBeC_xHqqkZx_
	FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_INSERT));
	if (::FFGetCapture() == m_hWnd && m_dwTimer == 0)
	//----- _xZkqqHx_iDeMiDiDiDhGiDgAiDiDiClDiCoKiCmEiCkCiCmEiBeBiDfOiDeDiDhNiBfLiCkKjGkCiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtClient;
		GetClientRect(rtClient);
		if (m_ptMsc.y <= rtClient.top || rtClient.bottom <= m_ptMsc.y)
		//----- _xZkqqHx_iDhNiDeFiDfIiCkKjHmMiIoGiCpAiKePiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfOiDeDiDhNiBfLiCpAiLeOjDkOiBeC_xHqqkZx_
			m_dwTimer = SetTimer(FDTIMER_WNDMATRIX, 150, NULL);
		}
	}
} // CFCMultiControlTmpl::StateMovingItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateEndMoveItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiInKjDkOiPiIjHjNiPeJjHlJiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateEndMoveItem ()
{
	TRACE(_T("CFCMultiControlTmpl::StateEndMoveItem\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeCiDhAiDfIiCmJiCoGiCmBiCmEiCmN_xHqqkZx_ FFSetCapture _xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_iMgPjHfCiClFiCmIiCkCiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeBiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	if (::FFGetCapture() == m_hWnd)
		::FFReleaseCapture();
	// _xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeBiDeDiDgFiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
	long lMscIndex = PointToIndex(m_ptMsc);
	if (lMscIndex == -1)
	{
		lMscIndex = GetItemCount();
	} else
	{
		//----- _xZkqqHx_jBhNjDpMiImKjChFiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
		// _xZkqqHx_iDhNiDeFiDfIiImKjChFiDeBiDeDiDgFiDiAiCmMiLoJiMgAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		CRect rtItem;
		GetItemRect(rtItem, lMscIndex);
		// _xZkqqHx_iLoJiMgAiCmMiMoDjElMiCmIiCoHiBeBjBhNjDpMiImKjChFiCmNiOjPiCmMiDeBiDeDiDgFiDiAiBeC_xHqqkZx_
		if (!IsFrontOfRect(rtItem, m_ptMsc))
			lMscIndex++;
	}
	// lMscIndex_xZkqqHx_iCmMjClMjBePiCnGiDeKiDgCiDgHiDhNiBfLiDeOiCmMiDeBiDeDiDgFiDiAiCpAiInKjDkOiBeC_xHqqkZx_
	MoveItem(lMscIndex);
} // CFCMultiControlTmpl::StateEndMoveItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateCancelMoveItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiInKjDkOiPiIjHjNiPeJjHlJiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateCancelMoveItem ()
{
	TRACE(_T("CFCMultiControlTmpl::StateCancelMoveItem\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeCiDhAiDfIiCmJiCoGiCmBiCmEiCmN_xHqqkZx_ FFSetCapture _xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_iMgPjHfCiClFiCmIiCkCiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeBiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	if (::FFGetCapture() == m_hWnd)
		::FFReleaseCapture();
	// _xZkqqHx_jBfDiCmEiCmMiDeBiDeDiDgFiDiAiCmMiDeKiDgCiDgHiDhNiBfLiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	for (long lIndex = 0; lIndex < GetItemCount(); lIndex++)
		SetCutMark(lIndex, FALSE);
} // CFCMultiControlTmpl::StateCancelMoveItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateRbtnSelectItem2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiJeFiDhLiDfOiDjDjHhAjBeJjBpAiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateRbtnSelectItem2 ()
{
	TRACE(_T("CFCMultiControlTmpl::StateRbtnSelectItem2\r\n"));
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
	SetAllSelectionMark(FALSE);
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpAjCiGiDeBiDeDiDgFiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	long lIndex = PointToIndex(m_ptMsc);
	SetIndexAB(lIndex, lIndex, FALSE, TRUE);
	SetSelectionMark(GetIndexA());
	// _xZkqqHx_jFmPiNfIiClDiCoKiClNiDeBiDeDiDgFiDiAiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	SendRgnRedraw();
} // CFCMultiControlTmpl::StateRbtnSelectItem2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateContextMenu2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx__2_xZkqqHx_iBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateContextMenu2 ()
{
	TRACE(_T("CFCMultiControlTmpl::StateContextMenu2\r\n"));
//----- 01.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CMenu menu;
//	CPoint point = m_ptMsc;
//	if (menu.LoadMenu(IDR_RBTN_MULTI))
//	{
//		if (point.x < 0 || point.y < 0)
//		//----- _xZkqqHx_iDiBiDgKiDiFiBfLiDeMiBfLiCmJiCoGiCoJiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMiDeBiDeDiDgFiDiAiImKjChFiCmJiDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
//			CRect rtItem(0,0,0,0);
//			if (0 <= GetIndexA())
//				GetItemRect(rtItem, GetIndexA());
//			point = rtItem.CenterPoint();
//			ClientToScreen(&point);
//		}
//		CMenu* pPopup;
//		pPopup = menu.GetSubMenu(GetSubMenuIndex(1));
//		ASSERT(pPopup != NULL);
//		// _xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiCmIiCoHiCmOiBeBiDiBiDgKiDiFiBfLiCpAjFmPiNfIiBeC_xHqqkZx_
//		if (g_pReg->GetIsLeftHand())
//			::RightByLeftHand(pPopup->m_hMenu, TRUE);
//		// _xZkqqHx_iDiBiDgKiDiFiBfLiDeBiDeDiDgFiDiAiCmMjHeMiMpIjAkLiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
////		OnUpdatePopupMenu(pPopup);
//		pPopup->TrackPopupMenu(TPM_RIGHTBUTTON | TPM_LEFTALIGN,
//								point.x, point.y,
//								// route commands through main window.
//								this);
//	}
//----- 01.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 05.01.31 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CPoint point = m_ptMsc;
//	if (point.x < 0 || point.y < 0)
//	//----- _xZkqqHx_iDiBiDgKiDiFiBfLiDeMiBfLiCmJiCoGiCoJiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMiDeBiDeDiDgFiDiAiImKjChFiCmJiDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
//		CRect rtItem(0,0,0,0);
//		if (0 <= GetIndexA())
//			GetItemRect(rtItem, GetIndexA());
//		point = rtItem.CenterPoint();
//		ClientToScreen(&point);
//	}
//	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
//	FFPopupSubmenu(point, GetSubMenuIndex(1), this);
//----- 05.01.31 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
	FFPopupSubmenu(m_ptMsc, IDR_RBTN_MULTI, GetSubMenuIndex(1), this);
//----- 05.01.31 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMultiControlTmpl::StateContextMenu2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateBeginStaticMoveItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjAmDjDeJiInKjDkOiPiIjHjNiKeKiOgOiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateBeginStaticMoveItem ()
{
	TRACE(_T("CFCMultiControlTmpl::StateBeginStaticMoveItem\r\n"));
	// _xZkqqHx_jBfDiCmEiCmMjBeJjBpAjCiGiDeBiDeDiDgFiDiAiCmJiDeKiDgCiDgHiCpAiDhNiBfLiDeOiBeC_xHqqkZx_
	for (long lIndex = 0; lIndex < GetItemCount(); lIndex++)
	{
		if (IsSelectionMark(lIndex))
			SetCutMark(lIndex);
	}
} // CFCMultiControlTmpl::StateBeginStaticMoveItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateStaticMovingItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjAmDjDeJiInKjDkOiPiIjHjNjCiGiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateStaticMovingItem ()
{
	TRACE(_T("CFCMultiControlTmpl::StateStaticMovingItem\r\n"));
	FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_INSERT));
} // CFCMultiControlTmpl::StateStaticMovingItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateStaticMoveItemPrev
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjClMjBePiCnGjAmDjDeJiInKjDkOiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateStaticMoveItemPrev ()
{
	TRACE(_T("CFCMultiControlTmpl::StateStaticMoveItemPrev\r\n"));
	// lMscIndex_xZkqqHx_iCmMjClMjBePiCmMiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
	long lIndex = GetIndexA();
	if (lIndex == -1)
		lIndex = GetItemCount();
	MoveItem(lIndex);
} // CFCMultiControlTmpl::StateStaticMoveItemPrev.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateStaticMoveItemNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjClMiMoDiCnGjAmDjDeJiInKjDkOiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateStaticMoveItemNext ()
{
	TRACE(_T("CFCMultiControlTmpl::StateStaticMoveItemNext\r\n"));
	// lMscIndex_xZkqqHx_iCmMjClMiMoDiCmMiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
	long lIndex = GetIndexA() + 1;
	if (lIndex == 0)
		lIndex = GetItemCount();
	MoveItem(lIndex);
} // CFCMultiControlTmpl::StateStaticMoveItemNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateCmdInsertItemPrev
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjClMjBePiCnGjBhNjDpMiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateCmdInsertItemPrev ()
{
	TRACE(_T("CFCMultiControlTmpl::StateCmdInsertItemPrev\r\n"));
	// lMscIndex_xZkqqHx_iCmMjClMjBePiCmMiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
	long lIndex = GetIndexA();
	if (lIndex == -1) lIndex = GetItemCount();
	if (lIndex < GetFrontFixedItemSize())
		lIndex = GetFrontFixedItemSize();
	if (GetItemCount() - GetBackFixedItemSize() < lIndex)
		lIndex = GetItemCount() - GetBackFixedItemSize();
	// _xZkqqHx_jAfGiClFiCkC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	DWORD dwNextId = GetNextFreeId();
	if (OnInsertItem(lIndex, dwNextId))
	//----- _xZkqqHx_jAfGiClFiCkCiDeBiDeDiDgFiDiAjBhNjDpMiCkKiCgOiCgKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiDeDiDgFiDiAiCpAjBhNjDpMiBeC_xHqqkZx_
		InsertItem(lIndex, dwNextId);
		// _xZkqqHx_jAfGiLeLjBhNjDpMiDeBiDeDiDgFiDiAiPfHiNiHiCmJjCmHiJmBiBeC_xHqqkZx_
		AddInsertedId(dwNextId);
//----- 01.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
//		SetAllSelectionMark(FALSE);
//		SetSelectionMark(lIndex + 1);
//// 01.03.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		SetIndexAB(lIndex, lIndex, FALSE, TRUE);
//		SetIndexAB(lIndex + 1, lIndex + 1, TRUE, TRUE);
//----- 01.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jBhNjDpMiClFiClNiDeBiDeDiDgFiDiAiCpAiDfEiDeDiDfJiCmJjElNiJgGiBeC_xHqqkZx_
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		UpdateItemSize();
		UpdateScrollSize(TRUE);
//----- 01.03.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_jBeJjBpAiCpAjAnNjCoIiBeC_xHqqkZx_
		SetCurSel(lIndex, TRUE, TRUE);
//----- 01.03.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
		GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
	} else
	//----- _xZkqqHx_jAfGiClFiCkCiDeBiDeDiDgFiDiAjBhNjDpMiCkKiCgNiCgGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOoGiCoIiPgPiClFiClN_xHqqkZx_FreeId_xZkqqHx_iCpAjGnPiClHiBeC_xHqqkZx_
		AddFreeId(dwNextId);
	}
} // CFCMultiControlTmpl::StateCmdInsertItemPrev.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateCmdInsertItemNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjClMiMoDiCnGjBhNjDpMiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateCmdInsertItemNext ()
{
	TRACE(_T("CFCMultiControlTmpl::StateCmdInsertItemNext\r\n"));
	// lMscIndex_xZkqqHx_iCmMjClMiMoDiCmMiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
	long lIndex = GetIndexA() + 1;
	if (lIndex == 0) lIndex = GetItemCount();
	if (lIndex < GetFrontFixedItemSize())
		lIndex = GetFrontFixedItemSize();
	if (GetItemCount() - GetBackFixedItemSize() < lIndex)
		lIndex = GetItemCount() - GetBackFixedItemSize();
	// _xZkqqHx_jAfGiClFiCkC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	DWORD dwNextId = GetNextFreeId();
	if (OnInsertItem(lIndex, dwNextId))
	//----- _xZkqqHx_jAfGiClFiCkCiDeBiDeDiDgFiDiAjBhNjDpMiCkKiCgOiCgKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiDeDiDgFiDiAiCpAjBhNjDpMiBeC_xHqqkZx_
		InsertItem(lIndex, dwNextId);
		// _xZkqqHx_jAfGiLeLjBhNjDpMiDeBiDeDiDgFiDiAiPfHiNiHiCmJjCmHiJmBiBeC_xHqqkZx_
		AddInsertedId(dwNextId);
//----- 01.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
//		SetAllSelectionMark(FALSE);
//		SetSelectionMark(lIndex - 1);
//// 01.03.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		SetIndexAB(lIndex - 1, lIndex, FALSE, TRUE);
//		SetIndexAB(lIndex - 1, lIndex, TRUE, TRUE);
//----- 01.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jBhNjDpMiClFiClNiDeBiDeDiDgFiDiAiCpAiDfEiDeDiDfJiCmJjElNiJgGiBeC_xHqqkZx_
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		UpdateItemSize();
		UpdateScrollSize(TRUE);
//----- 01.03.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_jBeJjBpAiCpAjAnNjCoIiBeC_xHqqkZx_
		SetCurSel(lIndex, TRUE, TRUE);
//----- 01.03.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
		GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
	} else
	//----- _xZkqqHx_jAfGiClFiCkCiDeBiDeDiDgFiDiAjBhNjDpMiCkKiCgNiCgGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOoGiCoIiPgPiClFiClN_xHqqkZx_FreeId_xZkqqHx_iCpAjGnPiClHiBeC_xHqqkZx_
		AddFreeId(dwNextId);
	}
} // CFCMultiControlTmpl::StateCmdInsertItemNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateCmdDeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeBiDeDiDgFiDiAiNoNiPjMiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateCmdDeleteItem ()
{
	TRACE(_T("CFCMultiControlTmpl::StateCmdDeleteItem\r\n"));
	// _xZkqqHx_jBfDiCmEiCmMjBeJjBpAjCiGiDeBiDeDiDgFiDiAiCpAiNoNiPjMiBeC_xHqqkZx_
	BOOL bDeleted = FALSE;
	for (long lIndex = 0; lIndex < GetItemCount();)
	{
		if (IsSelectionMark(lIndex))
		//----- _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCkKjFhEiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			bDeleted = TRUE;
			DWORD dwId = GetItemData(lIndex);
			if (OnDeleteItem(lIndex, dwId))
			//----- _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiCkKiCgOiCgKiCmMiPoKiNiH_xHqqkZx_ -----
			{
				//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCpAiNoNiPjM_xHqqkZx_ -----
				DeleteItem(lIndex);
				if (IsInsertedId(dwId))
				//----- _xZkqqHx_jAfGiLeLjBhNjDpMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiPoKiNiH_xHqqkZx_ -----
				{
//----- 01.08.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
					// _xZkqqHx_jFmPiNfIiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
					DelChangedId(dwId);
//----- 01.08.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
					// _xZkqqHx_jAfGiLeLjBhNjDpMiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
					DelInsertedId(dwId);
				} else
				//----- _xZkqqHx_jAfGiLeLjBhNjDpMiCmFiCmNiCmIiCkCiBgJiNnNjHiIiCmMiBgKiDeBiDeDiDgFiDiAiCmMiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iNoNiPjMiDeBiDeDiDgFiDiAiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
					if (IsMergedId(dwId))
						AddRemovedId(GetMergedIdVector(dwId).begin(),
									 GetMergedIdVector(dwId).end());
					else
						AddRemovedId(dwId);
					// _xZkqqHx_jFmPiNfIiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
					DelChangedId(dwId);
					// _xZkqqHx_iDhNiBfLiDfHiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
					DelMergedId(dwId);
				}
			} else
			//----- _xZkqqHx_iDeBiDeDiDgFiDiAiNoNiPjMiCkKiCgNiCgGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				lIndex++;
			}
		} else
		//----- _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCkKjFhEiCkCiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			lIndex++;
		}
	}
	// _xZkqqHx_iNoNiPjMiClFiClNiDeBiDeDiDgFiDiAiCpAiDfEiDeDiDfJiCmJjElNiJgGiBeC_xHqqkZx_
	if (bDeleted)
	{
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		UpdateItemSize();
		UpdateScrollSize(TRUE);
		// _xZkqqHx_jFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
		GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
	}
} // CFCMultiControlTmpl::StateCmdDeleteItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateCmdChangeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeBiDeDiDgFiDiAjFmPiNfIiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateCmdChangeItem ()
{
	TRACE(_T("CFCMultiControlTmpl::StateCmdChangeItem\r\n"));
	if (GetIndexA() == -1) return;
	if (OnChangeItem(GetIndexA(), GetItemData(GetIndexA())))
	//----- _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfIiCkKiCgOiCgKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFmPiNfIiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
		AddChangedId(GetItemData(GetIndexA()));
		// _xZkqqHx_jFmPiNfIiClFiClNiDeBiDeDiDgFiDiAiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
		SetRedrawMark(GetIndexA());
		SendRgnRedraw();
		// _xZkqqHx_jFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
		GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
	}
} // CFCMultiControlTmpl::StateCmdChangeItem.

//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateCmdChangeItem2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeBiDeDiDgFiDiAjFmPiNfI_xHqqkZx_2_xZkqqHx_iBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateCmdChangeItem2 ()
{
	TRACE(_T("CFCMultiControlTmpl::StateCmdChangeItem2\r\n"));
	if (GetIndexA() == -1) return;
	if (OnChangeItem2(GetIndexA(), GetItemData(GetIndexA())))
	//----- _xZkqqHx_iDeBiDeDiDgFiDiAjFmPiNfI_xHqqkZx_2_xZkqqHx_iCkKiCgOiCgKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFmPiNfIiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
		AddChangedId(GetItemData(GetIndexA()));
		// _xZkqqHx_jFmPiNfIiClFiClNiDeBiDeDiDgFiDiAiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
		SetRedrawMark(GetIndexA());
		SendRgnRedraw();
		// _xZkqqHx_jFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
		GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
	}
} // CFCMultiControlTmpl::StateCmdChangeItem2.
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMultiControlTmpl::StateCmdMergeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeBiDeDiDgFiDiAiDhNiBfLiDfHiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCMultiControlTmpl<SUPER>::StateCmdMergeItem ()
{
	TRACE(_T("CFCMultiControlTmpl::StateCmdMergeItem\r\n"));
	long lFrom;
	long lUntil;
	for (lFrom = 0; lFrom < GetItemCount(); lFrom++)
		if (IsSelectionMark(lFrom)) break;
	for (lUntil = lFrom; lUntil < GetItemCount(); lUntil++)
		if (!IsSelectionMark(lUntil)) break;
	lUntil--;

	BOOL bMerged = FALSE;
	if (OnMergeItem(lFrom, lUntil))
	//----- _xZkqqHx_iDeBiDeDiDgFiDiAiDhNiBfLiDfHiCkKiCgOiCgKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		bMerged = TRUE;
		DWORD dwHeadId = GetItemData(lUntil);
		if (!IsMergedId(dwHeadId)) AddMergedId(dwHeadId, dwHeadId);
		for (long lIndex = lUntil - 1; lFrom <= lIndex; lIndex--)
		{
			DWORD dwId = GetItemData(lIndex);
			if (IsInsertedId(dwId))
			//----- _xZkqqHx_jAfGiLeLjBhNjDpMiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jAfGiLeLjBhNjDpMiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
				DelInsertedId(dwId);
			} else
			//----- _xZkqqHx_jAfGiLeLjBhNjDpMiClDiCoKiClNiDeBiDeDiDgFiDiAiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
			{
				if (IsMergedId(dwId))
				//---- _xZkqqHx_iDhNiBfLiDfHjBmOiPnLiCkKiDhNiBfLiDfHiPfHiNiHiCmMiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iDhNiBfLiDfHiPfHiNiHiCpAiBeBiDfOiBfLiDfBiDgCiDgHiCmJiDhNiBfLiDfHiClHiCoJiBeC_xHqqkZx_
					AddMergedId(dwHeadId, GetMergedIdVector(dwId).begin(),
											GetMergedIdVector(dwId).end());
					// _xZkqqHx_iDhNiBfLiDfHiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
					DelMergedId(dwId);
				} else
				{
					// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmJiDhNiBfLiDfHjBmOiPnLiCpAiDhNiBfLiDfHiBeC_xHqqkZx_
					AddMergedId(dwHeadId, dwId);
				}
				// _xZkqqHx_iNoNiPjMiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
				AddRemovedId(dwId);
				// _xZkqqHx_jFmPiNfIiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
				DelChangedId(dwId);
			}
			// _xZkqqHx_iDeBiDeDiDgFiDiAiCpAiNoNiPjMiBeC_xHqqkZx_
			DeleteItem(lIndex);
		}
	}
	// _xZkqqHx_iDhNiBfLiDfHiClFiClNiDeBiDeDiDgFiDiAiCpAiDfEiDeDiDfJiCmJjElNiJgGiBeC_xHqqkZx_
	if (bMerged)
	{
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		UpdateItemSize();
		UpdateScrollSize(TRUE);
		// _xZkqqHx_jFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
		GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
	}
} // CFCMultiControlTmpl::StateCmdMergeItem.

/////////////////////////////////////////////////////////////////////////////
// CFCMultiControlTmpl _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

#endif//__MultiControlTmpl_h
