#include "stdafx.h"
#include "resource.h"		// For ProObjArc.h.
#include "ProObjArc.h"		// For CFCProObjArc.
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "UtilErr.h"		// For FFThrowMiscUnknown.
#include "UtilArc.h"		// For GetArcPolygon.
#include "UndoArchive.h"	// For FCUndoArchive.
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "UtilBezier.h"		// For FFGetStdElemLen.
#include "ObjArc.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/**********************************************************************
 * FCObjArc class implimentation
 **********************************************************************/

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::FCObjArc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_jFmPjAjEiCmMiPiJiKpKiJlLiCpAjCmHiJmB_xHqqkZx_.Tool_xZkqqHx_iCmFjAlGjAkMiClDiCoKiClNiOjOiCmMiInH_xHqqkZx_.
 *************************************************************************/
FCObjArc::FCObjArc ()
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjArc, m_nArcType));
	memset(&m_nArcType, 0, sizeof(FCObjArc) - offsetof(FCObjArc, m_nArcType));
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	m_nArcType	= FDOA_PIE;
	m_dBgnR		= 0.0;
	m_dEndR		= 0.0;
} // FCObjArc::FCObjArc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	:_xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *************************************************************************/
BOOL FCObjArc::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_ARC) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjArc::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjArc::Type () const
{
	return FDOJ_ARC;
} // FCObjArc::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjArc::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjArc* trgp = static_cast<const FCObjArc*>(objp);
	return (memcmp(&m_nArcType, &trgp->m_nArcType,
				sizeof(FCObjArc) - offsetof(FCObjArc, m_nArcType)) == 0);
} // FCObjArc::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjArc::OutStream (FCUndoArchive& ar)
void FCObjArc::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	ar << m_nArcType;	// _xZkqqHx_iJhOiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
	ar << m_dBgnR;		// _xZkqqHx_iJhOiCmMiKeKiOgOiKhAiBeC_xHqqkZx_
	ar << m_dEndR;		// _xZkqqHx_iJhOiCmMiPeJjHlJiKhAiBeC_xHqqkZx_
} // FCObjArc::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void FCObjArc::InStream (FCUndoArchive& ar)
{
	BASE_CLASS::InStream(ar);
	ar >> m_nArcType;	// _xZkqqHx_iJhOiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
	ar >> m_dBgnR;		// _xZkqqHx_iJhOiCmMiKeKiOgOiKhAiBeC_xHqqkZx_
	ar >> m_dEndR;		// _xZkqqHx_iJhOiCmMiPeJjHlJiKhAiBeC_xHqqkZx_
} // FCObjArc::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::CreatePropertyPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiMmFjHeMiCmM_xHqqkZx_PropertyPage_xZkqqHx_iCpAiNoMjAkMiBeFiPiJiKpKiJlLiClFiBeBiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	: PropertyPage_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiInHiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			vSelect		: _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiPfHiNiH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *************************************************************************/
void FCObjArc::CreatePropertyPage (CPropertyPageVector& vPropPage,
											const ObjDynabaseVector& vSelect)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::CreatePropertyPage(vPropPage, vSelect);
	ObjDynabaseVector::const_iterator i;
	for (i = vSelect.begin(); i != vSelect.end(); i++)
		if (!(*i)->IsKindOf(FDOJ_ARC)) return;
	vPropPage.push_back(new CFCProObjArc());
} // FCObjArc::CreatePropertyPage.

//----- 01.03.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::GetIsOpenPolygon
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjArc::GetIsOpenPolygon () const
//{
//	return (m_nArcType == FDOA_ARC);
//} // FCObjArc::GetIsOpenPolygon.
//----- 01.03.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::IsClosePolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	NewObjPolygon_xZkqqHx_iCkKjFnEiClHiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjArc::IsClosePolygon () const
{
	return (m_nArcType != FDOA_ARC);
} // FCObjArc::IsClosePolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::NewObjPolygonForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOmAiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClH_xHqqkZx_.
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiH_xHqqkZx_.
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmElemLen_xZkqqHx_iCmNiBeBjClIjDfPiNmAjFfHiCpAiMhGiOfKiClHiCoJiOjOiCmJiBeBjHnHiCoIiNiHiCkEjClIjDfPiCmGjClIjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_mmElemLen_xZkqqHx_iCmMjCgMiCkKiPkMiClDiCkCiCnJiCmHjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iLjHjHkDiCmNiLlHiCnMiCoIjAhNiMgAiCmMjAlIjDhIiCmNiMpMiPoDiClHiCoJiCkKiBeBiCoGiCoIjBlNiCkNiCmMiMhGiOfKiOjOiKnEiCmG_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIjBlNiCkNiCmMiDiBiDiCiDiKiCpAjFeLjHhGiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmptpPoly_xZkqqHx_iCmN_xHqqkZx_delete[]_xZkqqHx_iCmFiKeKjFpKiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_.
 *************************************************************************/
void FCObjArc::NewObjPolygonForDraw (	DBLPointVector& vmmptPoly,
										mmetol mmElemLen,
										const DBLRect mmrtaClip[],
										int iClipSize) const
{
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	::GetArcPolygon(vmmptPoly, m_mmptCenter.x, m_mmptCenter.y,
//					m_mmHAxisX, m_mmVAxisY, m_dBgnR, m_dEndR, m_nArcType,
//					mmElemLen, m_mmVAxisX, m_dAngle, m_mmptCenter.x, m_mmptCenter.y);
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (mmElemLen < 0)
	//----- _xZkqqHx_iNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iCnMiClIjFfHiPiAjCgMiCmFiDhMiDiKiDiJiDeDiDjDiCpAiMhGiOfKiBeC_xHqqkZx_
		mmElemLen = FFGetStdElemLen();
		::GetArcPolygon(vmmptPoly, m_mmptCenter.x, m_mmptCenter.y,
						m_mmHAxisX, m_mmVAxisY, m_dBgnR, m_dEndR, m_nArcType,
						mmElemLen, m_mmVAxisX, m_dAngle, m_mmptCenter.x, m_mmptCenter.y);
		// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
		DBLRect mmrtFrame;
		FFCalcFrame(mmrtFrame, (long)vmmptPoly.size(), &vmmptPoly.front());
		// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmMjFjNiBhLiNiCiClD_xHqqkZx_ _xZkqqHx_iCmM_xHqqkZx_20_xZkqqHx_jFkKiCmM_xHqqkZx_1 _xZkqqHx_iCpAiKoOiPiAiCmJiBeC_xHqqkZx_
		const mmetol mmNewElemLen = (mmrtFrame.Width() + mmrtFrame.Height()) / 20.0;
		if (mmNewElemLen < mmElemLen)
		//----- _xZkqqHx_jAlIjDhIiCkKjBkLiCoIiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jAfGiClFiCkCjAlIjDhIiCmFiDhMiDiKiDiJiDeDiDjDiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
			vmmptPoly.clear();
			::GetArcPolygon(vmmptPoly, m_mmptCenter.x, m_mmptCenter.y,
							m_mmHAxisX, m_mmVAxisY, m_dBgnR, m_dEndR, m_nArcType,
							mmNewElemLen, m_mmVAxisX, m_dAngle, m_mmptCenter.x, m_mmptCenter.y);
		}
	} else
	//----- _xZkqqHx_jCgMiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		::GetArcPolygon(vmmptPoly, m_mmptCenter.x, m_mmptCenter.y,
						m_mmHAxisX, m_mmVAxisY, m_dBgnR, m_dEndR, m_nArcType,
						mmElemLen, m_mmVAxisX, m_dAngle, m_mmptCenter.x, m_mmptCenter.y);
	}
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjArc::NewObjPolygonForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::NewObjBezierForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	: _xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJjFgAiJoGjDjJiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjArc::NewObjBezierForDraw (FCMmPolyBezier& polyBezier) const
{
	FFGetArcBeziers(polyBezier,
					m_mmptCenter,
					m_mmHAxisX, m_mmVAxisY,
					m_dBgnR, m_dEndR, m_nArcType,
					m_mmVAxisX, m_dAngle,
					m_mmptCenter);
} // FCObjArc::NewObjBezierForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::GetEdgePos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJhOiMmKiCmMiBeBiKeKiOgOjDfPiBeBiPeJjHlJjDfPiCmMiNmAjFfHjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptPos	:_xZkqqHx_jDfPiNmAjFfHjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			pArc	:_xZkqqHx_iMhGiOfKiClHiCoJiJhOiMmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dEdgeR	:_xZkqqHx_iMhGiOfKiClHiCoJjDfPiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dSinR	:_xZkqqHx_iJhOiMmKiCmMiJpBjDfNiKhAiCmM_xHqqkZx_sin_xZkqqHx_jCgMiCpAiOhHjCoIiBeCiJhOiMmKjDoAjFjEiDgGiBfLiDfOiCkJiCoH_xHqqkZx_
 *					 _xZkqqHx_iMhGiOfKiJmCjEfMiClOiCkKiBeBiNiCjBkMiJlLiCmMiInHiCmJiKePjFjEiCkJiCoHiLjPiLiLiBeC_xHqqkZx_
 *			dCosR	:_xZkqqHx_iJhOiMmKiCmMiJpBjDfNiKhAiCmM_xHqqkZx_cos_xZkqqHx_jCgMiCpAiOhHjCoIiBeCiJhOiMmKjDoAjFjEiDgGiBfLiDfOiCkJiCoH_xHqqkZx_
 *					 _xZkqqHx_iMhGiOfKiJmCjEfMiClOiCkKiBeBiNiCjBkMiJlLiCmMiInHiCmJiKePjFjEiCkJiCoHiLjPiLiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjArc::GetEdgePos (DBLPoint& mmptPos, const FCObjArc* pArc,
							double dEdgeR, double dSinR, double dCosR)
{
	mmptPos.SetPoint(pArc->GetCenterX() + pArc->GetHAxisX() * cos(dEdgeR * M_PI),
					 pArc->GetCenterY() + pArc->GetVAxisY() * sin(dEdgeR * M_PI));
	::ShiftConv(mmptPos, pArc->GetVAxisY(), pArc->GetVAxisX(), pArc->GetCenterY());
	::RotateConv(mmptPos, dSinR, dCosR, pArc->GetCenterX(), pArc->GetCenterY());
} // FCObjArc::GetEdgePos.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::GetEdgePoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFmCiClGiClNjAhNiMgAiCmMiPoKiNiHiCmNiBeBjCgMiCmN_xHqqkZx_DBLPoint(0,0)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjArc::GetEdgePoint (DBLPoint& mmptF, DBLPoint& mmptB) const
{
	const double dSinR = sin(GetAngle() * M_PI);
	const double dCosR = cos(GetAngle() * M_PI);
	FCObjArc::GetEdgePos(mmptF, this, GetArcBgnR(), dSinR, dCosR);
	FCObjArc::GetEdgePos(mmptB, this, GetArcEndR(), dSinR, dCosR);
} // FCObjArc::GetEdgePoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::GetMolipCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MOLIP_xZkqqHx_iBgJiDiKiDjDiDeOiCpAjCkDiCoJiCmGiCkLjDjJiCmJiOgHjHhAiBgKiCmMjAjEiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID -1 _xZkqqHx_iCmMjAjEiCmNiDeKiDeFiDjDiDgHiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjArc::GetMolipCount () const
{
	return 0;
} // FCObjArc::GetMolipCount.

//----- 06.12.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::CalcArea
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjGmKjAmPiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGmKjAmPiBeCjFlNjFpLiDhOiDiKiDiBiBfLiDgHiDiL_xHqqkZx_(mm^2)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jGmKjAmPiCmNiKfEiOfKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCObjArc::CalcArea () const
{
	//
	// "_xZkqqHx_iJhOiCmMjGmKjAmPiMhGiOfK_xHqqkZx_.mdpf"_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
	//
	const mmetol mmHAxisX = fabs(GetHAxisX());	// _xZkqqHx_jAhNiMgAiCmMjAiFjFlNiOlCiCmMjBoFiCkLiClDiBeCjFiJiCoAiCkAiCoIiBeC_xHqqkZx_
	const mmetol mmVAxisY = GetVAxisY();		// _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmM_xHqqkZx_Y_xZkqqHx_jAkMjFkKiBeCjAlDiCmMiCnNiBeC_xHqqkZx_
	// mmHAxisX _xZkqqHx_iCpAjElMiMgBiCmGiClHiCoJjAfOiJhOiCmMjGmKjAmPiCpAiMhGiOfKiBeC_xHqqkZx_
	double dArea = mmHAxisX * mmHAxisX * M_PI;
	// _xZkqqHx_iCnMiClIiBeBiDhAiDeDiMfOiCmGiClFiCmEiMhGiOfKiBeC_xHqqkZx_
	double dAngle = ::RegulateAngle(GetArcEndR() - GetArcBgnR());
	if (!almost0(dAngle))
		dArea = dArea * (dAngle / 2.0);
	switch (GetArcType())
	{
	case FDOA_PIE:		// _xZkqqHx_iDhAiDeDiCpAjAnIiCmBiClNiCoGiCkEiCmIiMgAiBeC_xHqqkZx_
		break;
	case FDOA_CHORD:	// _xZkqqHx_iLhMiCmJiMlHiCpAjCkDiCmBiClNiCoGiCkEiCmIiMgAiBeC_xHqqkZx_
	case FDOA_ARC:		// _xZkqqHx_iKeKiCkCiClNiMgAiBeC_xHqqkZx_
	  {
		//----- _xZkqqHx_iDhAiDeDiMfOiCpAjGiEiCnPiCoJiOePiKhAiMgAiCpAiMhGiOfK_xHqqkZx_ -----
		const double dS = (2.0 - dAngle) / 2.0;
		const double dTriangle = mmHAxisX * mmHAxisX * FFSin(dS) * FFCos(dS);
		dArea = dArea + dTriangle;
		break;
	  }
	default:
		FFThrowMiscUnknown();
	}
	// _xZkqqHx_jBmIiJhOiMhGiOfKiBeC_xHqqkZx_
	dArea = dArea * (mmVAxisY / mmHAxisX);
	return dArea;
} // FCObjArc::CalcArea.
//----- 06.12.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

short FCObjArc::GetArcType () const // _xZkqqHx_iJhOiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
{
	return m_nArcType;
} // FCObjArc::GetArcType.

double FCObjArc::GetArcBgnR () const	// _xZkqqHx_iJhOiCmMiKeKiOgOiKhAiBeC_xHqqkZx_
{
	return m_dBgnR;
} // FCObjArc::GetArcBgnR.

double FCObjArc::GetArcEndR () const	// _xZkqqHx_iJhOiCmMiPeJjHlJiKhAiBeC_xHqqkZx_
{
	return m_dEndR;
} // FCObjArc::GetArcEndR.

void FCObjArc::SetArcType (SHORT nArcType)	// _xZkqqHx_iJhOiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
{
	if (m_nArcType == nArcType) return;
	m_nArcType = nArcType;
} // FCObjArc::SetArcType.

void FCObjArc::SetArcBgnR (double dBgnR)			// _xZkqqHx_iJhOiCmMiKeKiOgOiKhAiBeC_xHqqkZx_
{
	if (m_dBgnR == dBgnR) return;
	m_dBgnR = dBgnR;
} // FCObjArc::SetArcBgnR.

void FCObjArc::SetArcEndR (double dEndR)			// _xZkqqHx_iJhOiCmMiPeJjHlJiKhAiBeC_xHqqkZx_
{
	if (m_dEndR == dEndR) return;
	m_dEndR = dEndR;
} // FCObjArc::SetArcEndR.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjArc::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjArc::CopySelf(pObj);
} // FCObjArc::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjArc::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjArc::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjArc, m_nArcType));
	FCObjArc* pArc = reinterpret_cast<FCObjArc*>(pObj);
	memcpy(&pArc->m_nArcType, &m_nArcType,
			sizeof(FCObjArc) - offsetof(FCObjArc, m_nArcType));
} // FCObjArc::CopySelf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::ResizeNoChangeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ObjRect::Resize_xZkqqHx_jHhAiDfEiDhFiKnGjAjEiBeCjDpBiCmCiCmM_xHqqkZx_Resize_xZkqqHx_iKnGjAjEiCkJiCoHiLkEjCmKiCmF_xHqqkZx_
 *			_xZkqqHx_iOgHiCkEiClNiCnPiCmJiNoMjAkMiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiPiIjHjNiCpAiNhDiCkEiCkKiBeB_xHqqkZx_m_mmrtResize_xZkqqHx_jFmPjAjEiCmMjFmPiNfIiCmNiNhDiCoNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptOrig	:_xZkqqHx_iDiKiDfEiDeDiDfJjBePiCmMiMlEjDfP_xHqqkZx_
 *			dptMagnif	:_xZkqqHx_iDiKiDfEiDeDiDfJiCmMjEoEjHkG_xHqqkZx_
 *			mmptOrigNew	:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiMlEjDfP_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJjBePiCmMiKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmMiNmAjFfHiCpAiOfKiPgPiClFiBeBiNmAjFfHjCgMiCmJiDiKiDfEiDeDiDfJjFmPiKlHiBeC_xHqqkZx_
 *			_xZkqqHx_jFmPiKlHiMoDiCmMiNmAjFfHjCgMiCkJiCoHiBeBiKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmMiKhAjDhIiCpAiLhEiMhGiOfKiBeC_xHqqkZx_
 *			_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P226 _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCkKjDjJiClFiCkCiPoKiNiHiBeBjFmPiKlHiMoDiCmMjCgMiCkKiIoKjChGiClHiCoJiCoGiCkEiCmJiNeIjFhGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.01 Fukushiro M. Resize_xZkqqHx_iKnGjAjEiCkJiCoHjFmPiNfIiBeC_xHqqkZx_
 *			99.03.02 Fukushiro M. _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCkKjDjJiClFiCkCiPoKiNiHiCpAiNgMjHlGiClFiBeB_xHqqkZx_
 *								_xZkqqHx_iDeBiDiLiDfDiDiKiDfJiDiAiCpAjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void FCObjArc::ResizeNoChangeFrame (const DBLPoint& mmptOrig,
									const DBLPoint& dptMagnif,
									const DBLPoint& mmptOrigNew)
{
	// _xZkqqHx_iLoJiMgAiCmMiDiKiDfEiDeDiDfJiPiIjHjNiBeCjAiFjFlNiBeFjAiCjClMiOlCiCmMjFmPiNfIiCmGiJpBjDfNiKhAiCmMjFmPiNfIiBeC_xHqqkZx_
	BASE_CLASS::ResizeNoChangeFrame(mmptOrig, dptMagnif, mmptOrigNew);
	if ((dptMagnif.x < 0.0 && 0.0 < dptMagnif.y) ||
		(dptMagnif.y < 0.0 && 0.0 < dptMagnif.x))
	{
		double dEndR = ::RegulateAngle(2.0 - m_dBgnR);
		double dBgnR = ::RegulateAngle(2.0 - m_dEndR);
		m_dBgnR = dBgnR;
		m_dEndR = dEndR;
	}
} // FCObjArc::ResizeNoChangeFrame.

