#ifndef __ObjChipMaster_h
#define __ObjChipMaster_h

#include "ObjGroup.h"	// Superclass.

class FCUndoArchive;
class CFCChipEditorDoc;

//;----- <EXPORT TO SDK> -----;

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCObjGroup

//----- _xZkqqHx_iDgAiDgCiDhGiOoNjFmK_xHqqkZx_ -----
enum
{
	FDCM_NONE			= 0,	// _xZkqqHx_jGlDiMpIiCmMjCgMiBeC_xHqqkZx_
	FDCM_OBJECT_CHIP	= 1,	// _xZkqqHx_jDmGjHkHjFjEjFgJiDgAiDgCiDhGiBeC_xHqqkZx_
	FDCM_COMPOSITE_CHIP	= 2,	// _xZkqqHx_jFkBiNiHjFjEjFgJiDgAiDgCiDhGiBeC_xHqqkZx_
};

//;------ </EXPORT TO SDK> -----;

class FCObjChipMaster : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	FCObjChipMaster ();
	virtual ~FCObjChipMaster ();
	virtual BOOL	IsKindOf (FTObjectType nType) const;

	//----- _xZkqqHx_iOmAjBmMiJlLiJmCjEfMiCmIiDeOiDiJiDfIiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual FTObjectType	Type () const;

	//----- _xZkqqHx_jBkOjAkLiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual BOOL	IsEqual (const FCObjDynabase* objp) const;
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual void	OutStream (FCUndoArchive& ar);
	virtual void	OutStream (FCUndoArchive& ar, BOOL bIsOutBezier);
	virtual void	InStream (FCUndoArchive& ar);

	//----- _xZkqqHx_jFkBjAjEiCmMiDiCiDiKiDhGiCpAiOjNiCmC_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual DBLPoint	GetMolipPos (long lMolipId, long lTerminalIdx = 0) const;
	virtual long		GetMolipCount () const;
	virtual DBLRect		GetMolipFrame (long lMolipId) const;
	virtual mmetol		GetMolipWeight (long lMolipId) const;

//----- 01.10.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	IsLineMolip (long lMolipId) const;
	virtual void	NewLineMolipPolygon (DBLPointVector& vmmptPoly,
										long lMolipId, mmetol mmElemLen,
										const DBLRect mmrtaClip[], int iClipSize) const;
	virtual BOOL	IsCloseLineMolipPolygon (long lMolipId) const;
//----- 01.10.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jFeLjHhGiCmJiJjOiClGiCmEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClHiCoKiCmOjHmHiCkC_xHqqkZx_ -----
// 06.02.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual BOOL	IsTextIntersect (const DBLPoint& mmpt) const;

//----- 06.03.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual FCObjDynabase*	GetIntersect (	BOOL& bIsHitEditText,
											long& lHitCharIndex,
											BOOL& bIsHitCharFront,
// 06.04.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//											BOOL bIsCheckText,
											const DBLPoint& mmptMargin,
											const DBLPoint& mmpt,
											BOOL bAsFillPaint) const;
//----- 06.03.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.02.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual FCObjDynabase*	GetIntersectText (	long& lHitCharIndex,
//												BOOL& bIsHitCharFront,
//												const DBLPoint& mmptMargin,
//												const DBLPoint& mmpt) const;
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.02.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual BOOL	IsLinkable (long lMolipID, BOOL bLinkOut) const;

// 06.04.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	GetUnlinkMarkPoint (DBLPointVector& vmmpt) const;


public:
	//----- ObjGroup_xZkqqHx_iCmM_xHqqkZx_Subclass_xZkqqHx_iCmFjFeLjHhGiCmJiJjOiClGiCmEiDeDiDjDiDhGiDiKiDiBiDjDiDgH_xHqqkZx_ -----
	virtual FCObjDynabase*	GetEditableTextObj (const DBLPoint& mmpt) const;
	virtual void		GetCanBeTextObject (ObjDynabaseVector& vObj) const;

	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMiKnGjAjE_xHqqkZx_ -----
//----- 01.08.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual short		GetChipKind () const;
	virtual void		SetChipKind (short nChipKind);
//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual DWORD		GetObjUserUlong () const;
//	virtual void		SetObjUserUlong (DWORD dwObjUserUlong);
//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 01.08.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	virtual short		GetDutyLinkSize () const;
	virtual FCObjDynabase*	GetDutyLink (short nIndex) const;
	virtual void		AppendDutyLink (FCObjDynabase* ojpLink);
	virtual void		ClearDutyLink ();
	virtual short		GetDutyTextSize () const;
	virtual FCObjDynabase*	GetDutyText (short nIndex) const;
	virtual void		AppendDutyText (FCObjDynabase* ojpText);
	virtual void		ClearDutyText ();

friend class CFCChipEditorDoc;
protected:
	//----- _xZkqqHx_jBkOjAkLiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual void	Copy (FCObjDynabase* pObj) const;
	virtual void	CopySelf (FCObjDynabase* pObj) const;

protected:
	short		m_nChipKind;		// _xZkqqHx_iDgAiDgCiDhGiOoNjFmKiBeC_xHqqkZx_
// 05.05.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DWORD		m_dwObjUserUlong;	// _xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	long		m_lDutyLinkIndexSz;	// _xZkqqHx_iDiKiDjDiDeOjGpAiKiEjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	short*		m_pDutyLinkIndex;	// _xZkqqHx_iDiKiDjDiDeOjGpAiKiEjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	long		m_lDutyTextIndexSz;	// _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	short*		m_pDutyTextIndex;	// _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
}; // class FCObjChipMaster.

#endif//__ObjChipMaster_h
