#include "stdafx.h"
#include <float.h>			// For DBL_MAX.
#include "UtilMisc.h"			// For FCArray.
#include "UtilErr.h"		// For FFThrowMiscUnknown.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "RegData.h"		// For g_pReg.
#include "DynamicDrawView.h"// For g_pView.
#include "SearchParser.h"	// For FCSearchParser.
#include "FoundDoc.h"		// For RegisterObject.
#include "NewFDObjAny.h"	// For NewFDObjAny.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "RichText.h"		// For GetRichText().
#include "ObjGroup.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//#define _LOCAL_CONV	// _xZkqqHx_iDfCiDjDiDgPiBfLiDfOiBeC_xHqqkZx_

//----- 06.10.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLjAjEiCkKjBlNiClHiCkMiCoJiPoKiNiHiBeBiDiKiDfEiDeDiDfJiCkKjChIiCkNiCmIiCoJ_xHqqkZx_)-----
// _xZkqqHx_iDiBiDjDiDgPiBfLjAjEiCkKiClBiCmMjAjEiCpAjClEiCkGiClNiCoHiBeBiDiKiDfEiDeDiDfJiDhMiDiKiDfDiDjDiCmNiPmIjHkKiMfOiCnGiBeC_xHqqkZx_
#define FD_OMIT_RESIZE_POLYGON_MAX	10
//----- 06.10.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLjAjEiCkKjBlNiClHiCkMiCoJiPoKiNiHiBeBiDiKiDfEiDeDiDfJiCkKjChIiCkNiCmIiCoJ_xHqqkZx_)-----

///////////////////////////////////////////////////////////////////////////
// FCGpLinkRec_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCGpLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCmMiDiMiDfCiBfLiDgIiCpAiKmHjHjNiClHiCoJiClNiCnPiCmMiDeOiDiJiDfIiBeC_xHqqkZx_FCLinkRec_xZkqqHx_iNfMjBkCjBmMiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iNmAjFfHiPoOjFpBiCpAiPjMiCkCiClNiOgDiCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCGpLinkRec
{
	FCGpLinkRec ();
//----------<NOT EXPORT TO VIEWER>-----------
	FCGpLinkRec (const FCLinkRec& rec);
//----------</NOT EXPORT TO VIEWER>-----------

	FCMolipRec	m_mlpFrom;		// _xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiBeC_xHqqkZx_
	FCMolipRec	m_mlpTo;		// _xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiBeC_xHqqkZx_
	WORD		m_wLinkKind;	// mmptOffset_xZkqqHx_iCmMiOoNjHnOiBeC_xHqqkZx_FDLMLinkKind_xZkqqHx_iCmMiCfAiCmCiBeC_xHqqkZx_
}; // struct FCGpLinkRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGpLinkRec::FCGpLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCGpLinkRec::FCGpLinkRec ()
	 : m_mlpFrom(0,0), m_mlpTo(0,0), m_wLinkKind(0)
{
} // FCGpLinkRec::FCGpLinkRec.

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGpLinkRec::FCGpLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCGpLinkRec::FCGpLinkRec (const FCLinkRec& rec)
			: m_mlpFrom(rec.m_mlpFrom), m_mlpTo(rec.m_mlpTo), m_wLinkKind(rec.m_wLinkKind)
{
} // FCGpLinkRec::FCGpLinkRec.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	==
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDjJiNiGiCmMiDeJiDhJiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
bool operator == (const FCGpLinkRec& rec0, const FCGpLinkRec& rec1)
{
	return	rec0.m_mlpFrom == rec1.m_mlpFrom &&
			rec0.m_mlpTo == rec1.m_mlpTo &&
			rec0.m_wLinkKind == rec1.m_wLinkKind;
} // bool operator ==.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	!=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFhDjDjJiNiGiCmMiDeJiDhJiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
bool operator != (const FCGpLinkRec& rec0, const FCGpLinkRec& rec1)
{
	return	rec0.m_mlpFrom != rec1.m_mlpFrom ||
			rec0.m_mlpTo != rec1.m_mlpTo ||
			rec0.m_wLinkKind != rec1.m_wLinkKind;
} // bool operator !=.

///////////////////////////////////////////////////////////////////////////
// FCObjGroup_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::FCObjGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_FDFoundDoc_xZkqqHx_iCmM_xHqqkZx_InStream_xZkqqHx_iCmFjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_jFmPjAjEiCmMiPiJiKpKiJlLiCpAjCmHiJmB_xHqqkZx_.Tool_xZkqqHx_iCmFjAlGjAkMiClDiCoKiClNiOjOiCmMiInH_xHqqkZx_.
 *************************************************************************/
FCObjGroup::FCObjGroup ()
{
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjGroup, m_mmrtResize));
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	memset(&m_mmrtResize, 0, sizeof(FCObjGroup) - offsetof(FCObjGroup, m_mmrtResize));

//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// m_mmrtOuter_xZkqqHx_iCpAjGlDiMpIiCmJiClHiCoJiBeCiMoDiCmFiOfBiPmGiClDiCoKiClNiCmGiCkLiPiJiCnPiCmEiMhGiOfKiClHiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
//	m_mmrtOuter.SetRect(1,1,0,0);
//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// m_mmrtResize_xZkqqHx_iCpAjGlDiMpIiCmJiClHiCoJiBeCiMoDiCmFiOfBiPmGiClDiCoKiClNiCmGiCkLiPiJiCnPiCmEiMhGiOfKiClHiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
	m_mmrtResize.SetRect(1,1,0,0);

	m_lObjListSz = 0;
	m_pObjList = NULL;
	m_lLinkListSz = 0;
	m_pLinkList = NULL;
} // FCObjGroup::FCObjGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *************************************************************************/
BOOL FCObjGroup::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_GROUP) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjGroup::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjGroup::Type () const
{
	return FDOJ_GROUP;
} // FCObjGroup::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::OnDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMono	:_xZkqqHx_iDiCiDgNiDeOiDiNjFgAiJoGiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.03 Fukushiro M. bIsMono_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void FCObjGroup::OnDraw (CDC* pDC, BOOL bIsMono)
{
	if (g_->eDrawWhich == FDDR_DISPLAY)
	{
		long lObjIdx;
		for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		{
			if (g_pView->IsRgnOverlap(m_pObjList[lObjIdx]->GetOuterFrame()))
				m_pObjList[lObjIdx]->OnDraw(pDC, bIsMono);
		}
	} else
	{
		long lObjIdx;
		for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		{
			m_pObjList[lObjIdx]->OnDraw(pDC, bIsMono);
		}
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDraw(pDC, bIsMono);
} // FCObjGroup::OnDraw.

//----- 05.05.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetOuterFrame
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeCjApMiCkKiCkAiCoKiCmOiClLiCmMjFjNiCoAiNgMjHlGiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeCjCgMiCmJiCmNiCkAiCoJjCpGjDhIiMoLiNlHiCkKiCkAiCmBiCmEiCoAiCoGiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
// *************************************************************************/
//DBLRect FCObjGroup::GetOuterFrame () const
//{
//	// m_mmrtOuter_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiMhGiOfKiBeC_xHqqkZx_
//	if (m_mmrtOuter.right < m_mmrtOuter.left)
//	{
//		FCObjGroup* pGrp = (FCObjGroup*)this;
//		pGrp->m_mmrtOuter.SetRect(DBL_MAX, DBL_MAX, -DBL_MAX, -DBL_MAX);
//		DBLRect mmrtMembOuter;
//		long lObjIdx;
//		for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
//		{
//			// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
//			mmrtMembOuter = m_pObjList[lObjIdx]->GetOuterFrame();
//			if (mmrtMembOuter.left < pGrp->m_mmrtOuter.left)
//				pGrp->m_mmrtOuter.left = mmrtMembOuter.left;
//			if (mmrtMembOuter.top < pGrp->m_mmrtOuter.top)
//				pGrp->m_mmrtOuter.top = mmrtMembOuter.top;
//			if (pGrp->m_mmrtOuter.right < mmrtMembOuter.right)
//				pGrp->m_mmrtOuter.right = mmrtMembOuter.right;
//			if (pGrp->m_mmrtOuter.bottom < mmrtMembOuter.bottom)
//				pGrp->m_mmrtOuter.bottom = mmrtMembOuter.bottom;
//		}
//	}
//	return m_mmrtOuter;
//} // FCObjGroup::GetOuterFrame.
//----- 05.05.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetOuterFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeCjApMiCkKiCkAiCoKiCmOiClLiCmMjFjNiCoAiNgMjHlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeCjCgMiCmJiCmNiCkAiCoJjCpGjDhIiMoLiNlHiCkKiCkAiCmBiCmEiCoAiCoGiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.02 Fukushiro M. _xZkqqHx_iPeDjAlDiBeC_xHqqkZx_m_mmrtOuter _xZkqqHx_iCpAiOgHiCoNiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
 *************************************************************************/
DBLRect FCObjGroup::GetOuterFrame () const
{
	DBLRect mmrtOuterFrame(0.0, 0.0, 0.0, 0.0);
	for (long lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		mmrtOuterFrame |= m_pObjList[lObjIdx]->GetOuterFrame();
	return mmrtOuterFrame;
} // FCObjGroup::GetOuterFrame.
//----- 05.05.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jCgMiCmMjAlDiKgNiClDiCmGiOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *************************************************************************/
DBLRect FCObjGroup::GetResizeFrame () const
{
//----- 01.07.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return m_mmrtResize;
//----- 01.07.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// m_mmrtResize_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiMhGiOfKiBeC_xHqqkZx_
	if (m_mmrtResize.right < m_mmrtResize.left)
	{
		FCObjGroup* pGrp = (FCObjGroup*)this;
		if (m_lObjListSz != 0)
		//----- _xZkqqHx_iDiBiDjDiDgPiBfLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			pGrp->m_mmrtResize.SetRect(DBL_MAX, DBL_MAX, -DBL_MAX, -DBL_MAX);
			DBLRect mmrtMembResize;
			long lObjIdx;
			for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
			{
				// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
				mmrtMembResize = m_pObjList[lObjIdx]->GetResizeFrame();
				if (mmrtMembResize.left < pGrp->m_mmrtResize.left)
					pGrp->m_mmrtResize.left = mmrtMembResize.left;
				if (mmrtMembResize.top < pGrp->m_mmrtResize.top)
					pGrp->m_mmrtResize.top = mmrtMembResize.top;
				if (pGrp->m_mmrtResize.right < mmrtMembResize.right)
					pGrp->m_mmrtResize.right = mmrtMembResize.right;
				if (pGrp->m_mmrtResize.bottom < mmrtMembResize.bottom)
					pGrp->m_mmrtResize.bottom = mmrtMembResize.bottom;
			}
		} else
		//----- _xZkqqHx_iDiBiDjDiDgPiBfLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgDiBfLiDiLiCmMjDoAjFjEjFjEjFgJiBgJjFfMjFjEjFgJiBgKiCmFiBeBiDiBiDjDiDgPiBfLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iDfEiDeDiDfJiCkKiCePiCmFiCkAiCoKiCmOiBeBiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCmFiCoAiDiKiDfEiDeDiDfJiCmNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
			pGrp->m_mmrtResize.SetRect(0,0,0,0);
		}
	}
	return m_mmrtResize;
//----- 01.07.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjGroup::GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjFigure::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjGroup::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjGroup* ogrpp = static_cast<const FCObjGroup*>(objp);
//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// m_mmrtResize ,m_mmrtOuter _xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeCiClBiCmMjCgMiCmNiBeBiCkAiClPiClBiClPiCmFiPiJiKpKiJlLiClDiCoKiBeB_xHqqkZx_
//	// GetOuterFrame _xZkqqHx_iCmMjDhIiCmJiNmEiMhGiOfKiClDiCoKiCoJiClNiCnPiBeC_xHqqkZx_
//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAjEoEiKhC_xHqqkZx_ -----
	if (m_lObjListSz != ogrpp->m_lObjListSz) return FALSE;
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		if (!m_pObjList[lObjIdx]->IsEqual(ogrpp->m_pObjList[lObjIdx])) return FALSE;
	//----- _xZkqqHx_iDiKiDjDiDeOiCpAjEoEiKhC_xHqqkZx_ -----
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_lLinkListSz != ogrpp->m_lLinkListSz) return FALSE;
//	long lLnkIdx;
//	for (lLnkIdx = 0; lLnkIdx < m_lLinkListSz; lLnkIdx++)
//		if (m_pLinkList[lLnkIdx] != ogrpp->m_pLinkList[lLnkIdx]) return FALSE;
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (FCConstArray<FCGpLinkRec>(m_pLinkList, m_lLinkListSz) !=
		FCConstArray<FCGpLinkRec>(ogrpp->m_pLinkList, ogrpp->m_lLinkListSz))
		return FALSE;
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // FCObjGroup::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjGroup::OutStream (FCUndoArchive& ar)
void FCObjGroup::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjDoAjFjEjFgJiDgFiBfLiDhFiDiLiCpAiPgPjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_lObjListSz;
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiMfOiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << BYTE(m_pObjList[lObjIdx]->Type());
		// _xZkqqHx_jFjEjFgJiCpAiPgPjHmNiBeC_xHqqkZx_
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		m_pObjList[lObjIdx]->OutStream(ar);
		m_pObjList[lObjIdx]->OutStream(ar, bIsOutBezier);
	}
	//----- _xZkqqHx_iDiKiDjDiDeOiCpAiPgPjHmN_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDjDiDeOiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_lLinkListSz;
	long lLnkIdx;
	for (lLnkIdx = 0; lLnkIdx < m_lLinkListSz; lLnkIdx++)
	{
		// _xZkqqHx_iDiKiDjDiDeOiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << m_pLinkList[lLnkIdx];
	}
} // FCObjGroup::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.16 Fukushiro M. _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMjDgPjIfOiPiIjHjNiCpAjCmHiJmBiBeC_xHqqkZx_
 *			99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *			99.10.26 Fukushiro M. RegisterObject_xZkqqHx_iCpAjGjFiPmBiBeCiDgAiDgCiDhGiCpAiOgHiCmBiClNiOjO_xHqqkZx_
 *									_xZkqqHx_jDpBiPgEjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *************************************************************************/
void FCObjGroup::InStream (FCUndoArchive& ar)
{
	BASE_CLASS::InStream(ar);

	long lObjIdx;
	if (m_pObjList != NULL)
	{
		//----- _xZkqqHx_iKpJjBlGiCmMjFjEjFgJiCpAjDgPjIfOjGjFiPmB_xHqqkZx_ -----
		for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
			m_pObjList[lObjIdx]->UnregisterObjID();
		//----- _xZkqqHx_iKpJjBlGiCmMjFjEjFgJiCpAiNoNiPjM_xHqqkZx_ -----
		for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
			delete m_pObjList[lObjIdx];
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		m_lObjListSz = 0;
//		delete[] m_pObjList;
//		m_pObjList = NULL;
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCArray<FCObjDynabase*>(m_pObjList, m_lObjListSz).Clear();
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	if (m_pLinkList != NULL)
	{
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		m_lLinkListSz = 0;
//		delete[] m_pLinkList;
//		m_pLinkList = NULL;
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCArray<FCGpLinkRec>(m_pLinkList, m_lLinkListSz).Clear();
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}

	// m_mmrtResize_xZkqqHx_iCpAjGlDiMpIiCmJiClHiCoJiBeCiMoDiCmFiOfBiPmGiClDiCoKiClNiCmGiCkLiPiJiCnPiCmEiMhGiOfKiClHiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
	m_mmrtResize.SetRect(1,1,0,0);
//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// m_mmrtOuter_xZkqqHx_iCpAjGlDiMpIiCmJiClHiCoJiBeCiMoDiCmFiOfBiPmGiClDiCoKiClNiCmGiCkLiPiJiCnPiCmEiMhGiOfKiClHiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
//	m_mmrtOuter.SetRect(1,1,0,0);
//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjDoAjFjEjFgJiDgFiBfLiDhFiDiLiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_lObjListSz;
	m_pObjList = new FCObjDynabase*[m_lObjListSz];
	BYTE byType;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiMfOiCpAjDpMjHmNiBeC_xHqqkZx_
		ar >> byType;
		m_pObjList[lObjIdx] = NewFDObjAny(FTObjectType(byType));
		// _xZkqqHx_jFjEjFgJiCpAjDpMjHmNiBeC_xHqqkZx_
		m_pObjList[lObjIdx]->InStream(ar);
		// _xZkqqHx_iDiBiDjDiDgPjFjEjFgJiCmJjAgFjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
		m_pObjList[lObjIdx]->SetGroupParent(this);
	}

	//----- _xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDjDiDeOjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_lLinkListSz;
	m_pLinkList = new FCGpLinkRec[m_lLinkListSz];
	long lLnkIdx;
	for (lLnkIdx = 0; lLnkIdx < m_lLinkListSz; lLnkIdx++)
	{
		ar >> m_pLinkList[lLnkIdx];
#ifdef _LOCAL_CONV
		// _xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiBeC_xHqqkZx_
		if (m_pObjList[m_pLinkList[lLnkIdx].m_mlpFrom.dwObjID]->Type() == FDOJ_ARC &&
			m_pLinkList[lLnkIdx].m_mlpFrom.lMolipId != -1)
		{
			m_pLinkList[lLnkIdx].m_mlpFrom.lMolipId = -1;
		}
		// _xZkqqHx_iDiKiDjDiDeOiDeDiDjDjFhDiJmCiCmMiClNiCnPiBeBiDiKiDjDiDeOjAoGiDiCiDiKiDhGiCmNjClCiCnHiCoJjFeLjHhGiCkKjGlDiCkCiBeC_xHqqkZx_
#endif// _LOCAL_CONV
	}
//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iClBiClBiCmJ_xHqqkZx_CalcOuterFrame_xZkqqHx_iCpAjDpMiCoKiClNiCkCiCmGiClBiCoLiClOiCkKiBeBiImIiJlKiCmMjHjNjHfCiCmFjFhDiJmCiBeC_xHqqkZx_
//	// CalcOuterFrame_xZkqqHx_jCiGiCmFiMmEiCmOiCoKiCoJ_xHqqkZx_GetOuterFrame_xZkqqHx_iCmNiBeBjDgPjIfOiDhJiDjDiCmMjBlOiClDiCmIiCmHiCpAiOfBiPmGiClHiCoJiBeC_xHqqkZx_
//	// OnPaste_xZkqqHx_iCmF_xHqqkZx_ _xZkqqHx_jDgPjIfOiDhJiDjDiCmMjBlOiClDiCpAiOfBiPmGiClHiCoJiCmGiBeBjGkCiClOjDgPjIfOiPiIjHjNiCkKiPeJiCoNiCmBiCmEiCkCiCmIiCkC_xHqqkZx_
//	// _xZkqqHx_iPpDjBnEiCmFiOfBiPmGiClDiCoKiCmEiClFiCnMiCkEiClNiCnPiBeBjHiOiClPiCoJiBeC_xHqqkZx_
//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCObjGroup::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::CreatePropertyPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiMmFjHeMiCmM_xHqqkZx_PropertyPage_xZkqqHx_iCpAiNoMjAkMiBeFiPiJiKpKiJlLiClFiBeBiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	: PropertyPage_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiInHiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			vSelect		: _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiPfHiNiH_xHqqkZx_
 *************************************************************************/
void FCObjGroup::CreatePropertyPage (CPropertyPageVector& vPropPage,
											const ObjDynabaseVector& vSelect)
{
	BASE_CLASS::CreatePropertyPage(vPropPage, vSelect);
} // FCObjGroup::CreatePropertyPage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::NewObjPolygonForResize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJjHhAiCmMiDhMiDiKiDiJiDeDiDjDiNoMjAkMiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiDhEiDiMiBfLiDiAjFgAiJoGiCmGiBeBjFjEjFgJiDfEiDeDiDfJiMhGiOfKiOjOiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiCoGiCkEiCmJjFkBjAjEiCmMjFjEjFgJiCmMiPfHiNiHiCmMiPoKiNiHiBeB_xHqqkZx_DBL_MAX_xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iLoGjAnIiCoHiCoKiClNjFkBjAjEiCmMiDhMiDiKiDiJiDeDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::NewObjPolygonForResize (	DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const
{
	vmmptPoly.clear();
//----- 06.10.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLjAjEiCkKjBlNiClHiCkMiCoJiPoKiNiHiBeBiDiKiDfEiDeDiDfJiCkKjChIiCkNiCmIiCoJ_xHqqkZx_)-----
//	long lObjIdx;
//	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
//	{
//		DBLPointVector vmmptPolyTmp;
//		// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCmMiDhMiDiKiDfDiDjDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//		m_pObjList[lObjIdx]->NewObjPolygonForResize(vmmptPolyTmp,
//													mmElemLen,
//													mmrtaClip,
//													iClipSize);
//		vmmptPoly.insert(vmmptPoly.end(), vmmptPolyTmp.begin(), vmmptPolyTmp.end());
//		vmmptPoly.push_back(DBLPoint(DBL_MAX, DBL_MAX));
//	}
//	// _xZkqqHx_iNmFiMoDiCmM_xHqqkZx_DBL_MAX_xZkqqHx_iCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
//	vmmptPoly.pop_back();
//----- 06.10.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLjAjEiCkKjBlNiClHiCkMiCoJiPoKiNiHiBeBiDiKiDfEiDeDiDfJiCkKjChIiCkNiCmIiCoJ_xHqqkZx_)-----
	if (m_lObjListSz < FD_OMIT_RESIZE_POLYGON_MAX)
	//----- _xZkqqHx_iDiBiDjDiDgPiBfLjAjEiCkKiPmIjHkKjFgAiJoGiCmMjAkHiMmAjAjEiCpAjClEiCkGiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		long lObjIdx;
		for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		{
			DBLPointVector vmmptPolyTmp;
			// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCmMiDhMiDiKiDfDiDjDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
			m_pObjList[lObjIdx]->NewObjPolygonForResize(vmmptPolyTmp,
														mmElemLen,
														mmrtaClip,
														iClipSize);
			vmmptPoly.insert(vmmptPoly.end(), vmmptPolyTmp.begin(), vmmptPolyTmp.end());
			vmmptPoly.push_back(DBLPoint(DBL_MAX, DBL_MAX));
		}
		// _xZkqqHx_iNmFiMoDiCmM_xHqqkZx_DBL_MAX_xZkqqHx_iCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
		vmmptPoly.pop_back();
	} else
	//----- _xZkqqHx_iDiBiDjDiDgPiBfLjAjEiCkKiPmIjHkKjFgAiJoGiCmMjAkHiMmAjAjEiCpAjClEiCkGiClNiPoKiNiH_xHqqkZx_ -----
	{
		const DBLRect mmrtFrame = GetResizeFrame();
		vmmptPoly.resize(5);
		mmrtFrame.Get5Polygon(&vmmptPoly.at(0));
	}
//----- 06.10.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLjAjEiCkKjBlNiClHiCkMiCoJiPoKiNiHiBeBiDiKiDfEiDeDiDfJiCkKjChIiCkNiCmIiCoJ_xHqqkZx_)-----
} // FCObjGroup::NewObjPolygonForResize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::ConvertEnvProp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDhJiBfLiDfIiDgHiOjOiCmJiCmNiKmCiLkLiBgJjAeGiBeFiDhAiDfOiBfLiDjDjDjJiBgKiCmMiCgIiCgDiCkKjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCpAjGhLjHiIiCmMiKmCiLkLiCgIiCgDiCmJjFmPiKlHiClFiBeBjFeLjHhGiCmJiJjOiClGiCmEjAfGiLeLiCgIiCgDiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::ConvertEnvProp (FCConvEnv* pConv)
{
	BASE_CLASS::ConvertEnvProp(pConv);
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->ConvertEnvProp(pConv);
} // FCObjGroup::ConvertEnvProp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetMolipWeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhGiCmMjFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCkKjDfPiDiCiDiKiDhGiCmMiPoKiNiHiCmNiBeB_xHqqkZx_0.0_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCkKjApMiDiCiDiKiDhGiCmMiPoKiNiHiCmNiBeBiDhMiDiKiDfDiDjDiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjGroup::GetMolipWeight (long lMolipId) const
{
	if (lMolipId == -1)
	//----- _xZkqqHx_jCiGjAfDjDfPiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// OuterFrame_xZkqqHx_iCmG_xHqqkZx_ResizeFrame_xZkqqHx_iCmMiNlHiCpAjApMiDiCiDiKiDhGjFjNiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
		const DBLRect mmrtOuter = GetOuterFrame();
		const DBLRect mmrtResize = GetResizeFrame();
		const mmetol mmW = mmrtOuter.Width() - mmrtResize.Width();
		const mmetol mmH = mmrtOuter.Height() - mmrtResize.Height();
		const mmetol mmL = (mmW < mmH) ? mmH : mmW;
		if (0.0 < mmL) return mmL;
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::GetMolipWeight(lMolipId);
} // FCObjGroup::GetMolipWeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::Move
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiInKjDkOiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDX	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *			mmDY	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_Y_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *************************************************************************/
void FCObjGroup::Move (mmetol mmDX, mmetol mmDY)
{
	if (mmDX == 0.0 && mmDY == 0.0) return;

	m_mmrtResize += DBLPoint(mmDX, mmDY);
// 05.05.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_mmrtOuter += DBLPoint(mmDX, mmDY);

	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
	{
		m_pObjList[lObjIdx]->Move(mmDX, mmDY);
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Move(mmDX, mmDY);
} // FCObjGroup::Move.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::Resize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	:X_xZkqqHx_jFpLiMpMiCmMjElNjDfNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bYPosi	:Y_xZkqqHx_jFpLiMpMiCmMjElNjDfNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtNew	:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfHiCpAiOhHjCoIiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.27 Fukushiro M. ObjPoint_xZkqqHx_iCkKiCkEiCnMiCkNiNmAjFfHiInKjDkOiClDiCoKiCmIiCkCiCmMiCmJjBmOiJjOiBeC_xHqqkZx_
 *************************************************************************/
void FCObjGroup::Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld)
{
// 05.04.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	const DBLRect mmrtOld = GetResizeFrame();
	//----- _xZkqqHx_jFjNiBeFiNiCiClDiCmMiKgHjBoFjHkGiCpAiOfKiPgP_xHqqkZx_ -----
	// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmFiCoAiBeBjFjNiBeBiNiCiClDiCkKiCePiCmJiCmIiCoJiClBiCmGiCkKiCkAiCoJiBeC_xHqqkZx_
	double dRaX = 1.0;
	double dRaY = 1.0;
	if (!almost0(mmrtOld.Width()))
		dRaX = mmrtNew.Width() / mmrtOld.Width();
	if (!almost0(mmrtOld.Height()))
		dRaY = mmrtNew.Height() / mmrtOld.Height();
	long lObjIdx;
// 05.06.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
	{
		DBLRect mmrtSubNew;
		const DBLRect mmrtSubOld = m_pObjList[lObjIdx]->GetResizeFrame();
		if (bXPosi)
		//----- X_xZkqqHx_jFpLiMpMiCmFiLhEjDfNiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			mmrtSubNew.left  = dRaX * (mmrtSubOld.left - mmrtOld.left) + mmrtNew.left;
			mmrtSubNew.right = dRaX * (mmrtSubOld.right - mmrtOld.left) + mmrtNew.left;
		} else
		//----- X_xZkqqHx_jFpLiMpMiCmFiLhEjDfNiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
		{
			mmrtSubNew.left  = mmrtNew.right - dRaX * (mmrtSubOld.right - mmrtOld.left);
			mmrtSubNew.right = mmrtNew.right - dRaX * (mmrtSubOld.left - mmrtOld.left);
		}
		if (bYPosi)
		//----- Y_xZkqqHx_jFpLiMpMiCmFiLhEjDfNiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			mmrtSubNew.top    = dRaY * (mmrtSubOld.top - mmrtOld.top) + mmrtNew.top;
			mmrtSubNew.bottom = dRaY * (mmrtSubOld.bottom - mmrtOld.top) + mmrtNew.top;
		} else
		//----- Y_xZkqqHx_jFpLiMpMiCmFiLhEjDfNiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
		{
			mmrtSubNew.top    = mmrtNew.bottom - dRaY * (mmrtSubOld.bottom - mmrtOld.top);
			mmrtSubNew.bottom = mmrtNew.bottom - dRaY * (mmrtSubOld.top - mmrtOld.top);
		}
// 05.06.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		if (m_pObjList[lObjIdx]->IsResizable(bXPosi, bYPosi, mmrtSubNew))
		if (m_pObjList[lObjIdx]->GetIsResizable(mmrtSubNew.Width(), mmrtSubNew.Height()))
		{
			m_pObjList[lObjIdx]->Resize(bXPosi, bYPosi, mmrtSubNew, m_pObjList[lObjIdx]->GetResizeFrame());
			// _xZkqqHx_jGhLjHiIiCmN_xHqqkZx_ Resize_xZkqqHx_iKnGjAjEiCmJ_xHqqkZx_CalcResizeFrameSelf_xZkqqHx_iCmNjFhDjHhGiClOiCkKiBeBiImIiJlKiCmMjHjNjHfCiCmJiCoGiCoIiOmAiNhDiBeC_xHqqkZx_
			// 1. _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiDfEiDeDiDfJiCpAiLmJiPkMiCmJiDiKiDfEiDeDiDfJiBeCiClBiCmMiOjOiBeBjFjEjFgJiInKjDkOjDjJiCmF_xHqqkZx_CalcResizeFrame_xZkqqHx_iCkKiOmAiNhDiBeC_xHqqkZx_
			// 2. _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiDfEiDeDiDfJiCpAiLmJjBoFiCmJiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
			// 3. _xZkqqHx_iDePiDiLiBfLiDhGiJpAiPjMiBeC_xHqqkZx_
			// _xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmMiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCmNiLmJiPkMiOjOiCmMiDfEiDeDiDfJiMhGiOfKiCmFiMhGiOfKiClFiClNjCgMiCmIiCmMiCmFiBeBiLlGiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
// 05.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			m_pObjList[lObjIdx]->CalcResizeFrameSelf();
			m_pObjList[lObjIdx]->CalcResizeFrame();
		} else
		{
			m_pObjList[lObjIdx]->Move(mmrtSubNew.left - mmrtSubOld.left, mmrtSubNew.top - mmrtSubOld.top);
		}
//----- 05.06.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		if (!m_pObjList[lObjIdx]->GetIsResizableHorz(mmrtSubNew.Width()))
//		//----- _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDiKiDfEiDeDiDfJiCkKjFhDiJmCiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDfEiDeDiDfJiCmNjFmPiNfIiClJiClIiBeBiImKjChFiCmMiCnNiCpAiPeDjAlDiBeCiImKjChFiCmNjAfGiClFiCkCiLoJiMgAiCmMjCiGjAfDiCmGiIoKjChGiClHiCoJiCoGiCkEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//			mmrtSubNew.left = (mmrtSubNew.left + mmrtSubNew.right - mmrtSubOld.Width()) / 2.0;
//			mmrtSubNew.right = mmrtSubNew.left + mmrtSubOld.Width();
//		}
//		if (!m_pObjList[lObjIdx]->GetIsResizableVert(mmrtSubNew.Height()))
//		//----- _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDiKiDfEiDeDiDfJiCkKjFhDiJmCiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDfEiDeDiDfJiCmNjFmPiNfIiClJiClIiBeBiImKjChFiCmMiCnNiCpAiPeDjAlDiBeCiImKjChFiCmNjAfGiClFiCkCiLoJiMgAiCmMjCiGjAfDiCmGiIoKjChGiClHiCoJiCoGiCkEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//			mmrtSubNew.top = (mmrtSubNew.top + mmrtSubNew.bottom - mmrtSubOld.Height()) / 2.0;
//			mmrtSubNew.bottom = mmrtSubNew.top + mmrtSubOld.Height();
//		}
//		if (!m_pObjList[lObjIdx]->GetIsResizableHorz(mmrtSubNew.Width()) &&
//			!m_pObjList[lObjIdx]->GetIsResizableVert(mmrtSubNew.Height()))
//		//----- _xZkqqHx_jAiFjFlNiBeFjAiCjClMjHlMjFpLiMpMiCmGiCoAiDiKiDfEiDeDiDfJjFhDiJmCiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jFjEjFgJiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
//			m_pObjList[lObjIdx]->Move(mmrtSubNew.left - mmrtSubOld.left, mmrtSubNew.top - mmrtSubOld.top);
//		} else
//		//----- _xZkqqHx_jAiFjFlNiBeFjAiCjClMiCmMiCkCiClIiCoKiCkJiCkKiDiKiDfEiDeDiDfJiJmCiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			m_pObjList[lObjIdx]->Resize(bXPosi, bYPosi, mmrtSubNew, mmrtSubOld);
//			// _xZkqqHx_jGhLjHiIiCmN_xHqqkZx_ Resize_xZkqqHx_iKnGjAjEiCmJ_xHqqkZx_CalcResizeFrameSelf_xZkqqHx_iCmNjFhDjHhGiClOiCkKiBeBiImIiJlKiCmMjHjNjHfCiCmJiCoGiCoIiOmAiNhDiBeC_xHqqkZx_
//			// 1. _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiDfEiDeDiDfJiCpAiLmJiPkMiCmJiDiKiDfEiDeDiDfJiBeCiClBiCmMiOjOiBeBjFjEjFgJiInKjDkOjDjJiCmF_xHqqkZx_CalcResizeFrame_xZkqqHx_iCkKiOmAiNhDiBeC_xHqqkZx_
//			// 2. _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiDfEiDeDiDfJiCpAiLmJjBoFiCmJiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
//			// 3. _xZkqqHx_iDePiDiLiBfLiDhGiJpAiPjMiBeC_xHqqkZx_
//			// _xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmMiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCmNiLmJiPkMiOjOiCmMiDfEiDeDiDfJiMhGiOfKiCmFiMhGiOfKiClFiClNjCgMiCmIiCmMiCmFiBeBiLlGiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//			m_pObjList[lObjIdx]->CalcResizeFrame();
//		}
//----- 05.06.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	}
	// _xZkqqHx_jAfGiClFiCkCiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmrtResize = mmrtNew;
//----- 05.06.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// m_mmrtResize_xZkqqHx_iCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmJiDiKiDfEiDeDiDfJjFhDiJmCiCmIjFjEjFgJ_xHqqkZx_(_xZkqqHx_iBkGiCgA_xHqqkZx_)_xZkqqHx_iCkKiKnMiCnMiCoKiCoJiPoKiNiHiBeB_xHqqkZx_
//	// _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiDfEiDeDiDfJiCkK_xHqqkZx_ mmrtNew _xZkqqHx_iCmGiCmIiCoJiCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
//	// _xZkqqHx_iDfEiDeDiDfJiPgLiPkMiMoDiCmJiDiKiDfEiDeDiDfJiClFiCmIiCkCiBkGiCgAiCmMjFpLiCkKjBoFiCkLiCkNiCmIiCoJiPoKiNiHiCoAiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
//	m_mmrtResize.SetRect(1,1,0,0);
//----- 05.06.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Resize(bXPosi, bYPosi, mmrtNew, mmrtOld);
} // FCObjGroup::Resize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::Rotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR		:_xZkqqHx_iJpBjDfNiClDiClJiCoJiKhAjDhIiBeC_xHqqkZx_-2.0 < dR < 2.0.
 *			mmCX	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
 *			mmCX	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *************************************************************************/
// 05.03.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjGroup::Rotate (double dR, mmetol mmCX, mmetol mmCY)
void FCObjGroup::Rotate (double dR, const DBLPoint& mmptCenter)
{
	// _xZkqqHx_iDiBiDjDiDgPiBfLiCmMjFjEjFgJiCpAiJpBjDfNiPiIjHjNiBeC_xHqqkZx_
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->Rotate(dR, mmptCenter);
//----- 05.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::Rotate(dR, mmCX, mmCY);
//----- 05.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDhEiDiMiBfLiDiAiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
	CalcResizeFrame();
// 05.05.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	CalcOuterFrame();
//----- 05.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjGroup::Rotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::OnChildFrameResized
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhBjFjEjFgJiCmMiDhEiDiMiBfLiDiAiDfEiDeDiDfJiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::OnChildFrameResized ()
{
	// m_mmrtResize_xZkqqHx_iCpAjGlDiMpIiCmJiClHiCoJiBeCiMoDiCmFiOfBiPmGiClDiCoKiClNiCmGiCkLiPiJiCnPiCmEiMhGiOfKiClHiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
	m_mmrtResize.SetRect(1,1,0,0);
} // FCObjGroup::OnChildFrameResized.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::CanRotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpBjDfNiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjGroup::CanRotate () const
{
	return TRUE;
} // FCObjGroup::CanRotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::OutSizeStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vBuff	:_xZkqqHx_iPgPjHmNjAoGiCmMiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bXPosi	:X_xZkqqHx_jFpLiMpMiCkKjElNjDfNiClFiClNiDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bYPosi	:Y_xZkqqHx_jFpLiMpMiCkKjElNjDfNiClFiClNiDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiPoOjFpBiCpAiMlDiCmJiDfEiDeDiDfJiCpAjFjMiMlDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::OutSizeStream (BYTEVector& vBuff, BOOL bXPosi, BOOL bYPosi) const
{
	for (long lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->OutSizeStream(vBuff, bXPosi, bYPosi);
} // FCObjGroup::OutSizeStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::InSizeStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiCpAjDmHiCnNiNjOiCpBiCmFiBeBiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pBuff	:_xZkqqHx_iDgGiBfLiDfOiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::InSizeStream (const BYTE*& pBuff)
{
	for (long lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->InSizeStream(pBuff);
	// _xZkqqHx_iOhBjFjEjFgJiCmMiDhEiDiMiBfLiDiAiDfEiDeDiDfJjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
	OnChildFrameResized();
} // FCObjGroup::InSizeStream.

//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::IsIntersect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDfPiCkKjFjEjFgJjDoAiCmJiMpAiCoNiCmBiCmEiCkCiCoJiCkJiCpAjClCiCnHiCoJiBeCjFjEjFgJiCkKjDkHjGlOiCmM_xHqqkZx_
// *			_xZkqqHx_iPoKiNiHiCmNiBeBjFnDiCmGiCmMiMpAiCoNiCoIiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpt	: _xZkqqHx_iOhHjCoIiClDiCoKiClNjDfP_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_
// *			FALSE	: _xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_
// *************************************************************************/
//BOOL FCObjGroup::IsIntersect (const DBLPoint& mmpt) const
//{
////----- 06.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	long lObjIdx;
////	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
////	{
////		if (m_pObjList[lObjIdx]->IsIntersect(mmpt)) return TRUE;
////	}
////	return FALSE;
////----- 06.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCpAjBePjGmKiCkJiCoHjClCiCnHiCoJiClNiCnPiCmJiBeBiLhEiPiHiCmJjClCiCnHiCoJiBeC_xHqqkZx_
//	long lObjIdx;
//	for (lObjIdx = m_lObjListSz - 1; 0 <= lObjIdx; lObjIdx--)
//		if (m_pObjList[lObjIdx]->IsIntersect(mmpt)) return TRUE;
//	return FALSE;
////----- 06.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCObjGroup::IsIntersect.
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetIntersect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDfPiCkKiMpAiCoNiCmBiCmEiCkCiCoJjFjEjFgJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsHitEditText	:_xZkqqHx_jFnCiPfHiJmCjEfMiCmIiDgFiDeMiDfIiDgHiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *							 _xZkqqHx_jEhHiMgJiDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lHitCharIndex	:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFlGiOjKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsHitCharFront	:_xZkqqHx_jFlGiOjKiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiBeBjFlGiOjKiCmMjBePjElMiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *							 _xZkqqHx_iMoDjElMiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsCheckText	:_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiCkJiBeI_xHqqkZx_
 *			mmptMargin		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiDgAiDeGiDgCiDeOiClHiCoJjBmOiPnLiCmMiBeBjFlGiOjKiCmMiLoJiMgAiCpA_xHqqkZx_
 *							 _xZkqqHx_iNeMiClAiCoJiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt			:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJjClCiCnHiCoJiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeBjFjEjFgJiCpAjFnEiClHiBeCiMpAiCoNiCmBiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmNiBeBiDgFiDeMiDfIiDgHiCpAjHeEjAoGiClFiCmEjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgFiDeMiDfIiDgHiCmJiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmNiBeBjEhHiMgJiCmJiDhBiDgCiDgHiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.01 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCObjGroup::GetIntersect (	BOOL& bIsHitEditText,
											long& lHitCharIndex,
											BOOL& bIsHitCharFront,
// 06.04.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//											BOOL bIsCheckText,
											const DBLPoint& mmptMargin,
											const DBLPoint& mmpt,
											BOOL bAsFillPaint) const
{
	// _xZkqqHx_jFjEjFgJiCpAjBePjGmKiCkJiCoHjClCiCnHiCoJiClNiCnPiCmJiBeBiLhEiPiHiCmJjClCiCnHiCoJiBeC_xHqqkZx_
	FCObjDynabase* pObj = NULL;
	long lObjIdx;
	for (lObjIdx = m_lObjListSz - 1; 0 <= lObjIdx; lObjIdx--)
	{
		pObj = m_pObjList[lObjIdx]->GetIntersect(	bIsHitEditText,
													lHitCharIndex,
													bIsHitCharFront,
// 06.04.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//													bIsCheckText,
													mmptMargin,
													mmpt,
													bAsFillPaint);
		if (pObj != NULL) break;
	}
	return pObj;
} // FCObjGroup::GetIntersect.

//----- 06.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::IsTextIntersect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiPoDiCmFiCmMiMpAiCoNiCoIiCkJiCmHiCkEiCkJiBeI_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpt	:_xZkqqHx_jClCiCnHiCoJjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjGroup::IsTextIntersect (const DBLPoint& mmpt) const
//{
//	long lObjIdx;
//	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
//	{
//		if (m_pObjList[lObjIdx]->IsTextIntersect(mmpt)) return TRUE;
//	}
//	return FALSE;
//} // FCObjGroup::IsTextIntersect.
//----- 06.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetIntersectText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDeDiDjDiDgHiCkKiCmHiCmMjFlGiOjKiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lHitCharIndex	:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFlGiOjKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *			bIsHitCharFront	:_xZkqqHx_jFlGiOjKiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiBeBjFlGiOjKiCmMjBePjElMiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
// *							 _xZkqqHx_iMoDjElMiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			mmptMargin		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiDgAiDeGiDgCiDeOiClHiCoJjBmOiPnLiCmMiBeBjFlGiOjKiCmMiLoJiMgAiCpA_xHqqkZx_
// *							 _xZkqqHx_iNeMiClAiCoJiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			mmpt			:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJjClCiCnHiCoJiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiDgFiDeMiDfIiDgHjFjEjFgJiBeCiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmptMargin_xZkqqHx_iCpAiOhHjCoIiClHiCoJiPoKiNiHiBeBjAhNiMgAiCmMiKePiCmMiDeOiDiKiDgCiDeOiCoAiPeFiCkEiJmCjEfMjAkLiCkK_xHqqkZx_
// *			_xZkqqHx_iCkAiCoJiCmMiCmFiBeBjHfMiCnPjAhNiMgAjCiGiCmMiDeOiDiKiDgCiDeOiCkJjClCiCnHiCmEiCkJiCoHiOmAiNhDiClHiCnHiCkLiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCkCiClIiCoKiCkJiCmMjFlGiOjKiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiLnPjGfEiCmMjFlGiOjKiCpAjClCiCnHiBeBiCmHiClPiCoHiCmJ_xHqqkZx_
// *			_xZkqqHx_iCoGiCoIiLnPiCkCiCkJiCoAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCObjDynabase* FCObjGroup::GetIntersectText (	long& lHitCharIndex,
//												BOOL& bIsHitCharFront,
//												const DBLPoint& mmptMargin,
//												const DBLPoint& mmpt) const
//{
//	// _xZkqqHx_jFjEjFgJiCpAjBePjGmKiCkJiCoHjClCiCnHiCoJiClNiCnPiCmJiBeBiLhEiPiHiCmJjClCiCnHiCoJiBeC_xHqqkZx_
//	FCObjDynabase* pObj = NULL;
//	long lObjIdx;
//	for (lObjIdx = m_lObjListSz - 1; 0 <= lObjIdx; lObjIdx--)
//	{
//		pObj = m_pObjList[lObjIdx]->GetIntersectText(lHitCharIndex,
//													bIsHitCharFront,
//													mmptMargin,
//													mmpt);
//		if (pObj != NULL) break;
//	}
//	return pObj;
//} // FCObjGroup::GetIntersectText.
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.04.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetMembers
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLiCpAiOjNiCmCiPoKiNiHiCmNiBeBiDiBiDjDiDgPiBfLiCmMjFjEjFgJjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJjEhKjHpBiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const ObjDynabaseVector* FCObjGroup::GetMembers () const
//{
//	return &m_vObj;
//} // FCObjGroup::GetMembers.
//----- 01.04.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetMembers
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLiCpAiOjNiCmCiPoKiNiHiCmNiBeBiDiBiDjDiDgPiBfLiCmMjFjEjFgJjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::GetMembers (ObjDynabaseVector& vObj) const
{
	vObj.clear();
	vObj.insert(vObj.end(), m_pObjList, m_pObjList + m_lObjListSz);
} // FCObjGroup::GetMembers.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetMemberArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLiCpAiOjNiCmCiPoKiNiHiCmNiBeBiDiBiDjDiDgPiBfLiCmMjFjEjFgJjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase** FCObjGroup::GetMemberArray () const
{
	return m_pObjList;
} // FCObjGroup::GetMemberArray.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetMemberSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLiCmMjFjEjFgJjEhKjHpBiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjGroup::GetMemberSize () const
{
	return m_lObjListSz;
} // FCObjGroup::GetMemberSize.
//----- 01.04.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 01.04.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::IsMemberKindOf
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjFjEjFgJiBeBiIlNiCkCiCmNiDiBiDjDiDgPiCmMjFjEjFgJiCmMiCkCiClIiCoKiCkJiCkKiBeBiOhHjCoIiCmMjFjEjFgJiOoNiCmFiCkAiCoJiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_jFjEjFgJiOoNiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiOoNiCpAiKnMiCnOiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjCiGiCmMjFjEjFgJiOoNiCpAjClCiCnHiCoJiCmMiCmJjHhAiCkCiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjGroup::IsMemberKindOf (FTObjectType nType) const
//{
//	if (IsKindOf(nType)) return TRUE;
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = m_vObj.begin(); iObj != m_vObj.end(); iObj++)
//	{
//		if (m_pObjList[lObjIdx]->IsMemberKindOf(nType)) return TRUE;
//	}
//	return FALSE;
//} // FCObjGroup::IsMemberKindOf.
//----- 01.04.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 99.05.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::NearestIntersect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkK_xHqqkZx_Fill_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiOhHjCoIiClDiCoKiClNjDfPiCkKjFjEjFgJiCmMjFnDiCmMiLnPiCkNiIlNiCkCiCmNjFjEjFgJiCmM_xHqqkZx_
// *			_xZkqqHx_jDoAjBkEiCmJiCkAiCoJiPoKiNiHiCmJiBeBiClLiCmMjDfPiCmJiNmFiCoAiLnPiCkCjFjEjFgJiCmMjFnDiPoDiCmMiCfAjDfPiCpAjFnEiClHiBeC_xHqqkZx_
// *			_xZkqqHx_jFjEjFgJiCkKiLpDiCmMiPoKiNiHiCmNiBeBiOhHjCoIiClDiCoKiClNjDfPiCkKjFjEjFgJiCmMjFnDiCmMiLnPiCkNiCmJiCkAiCoJiPoKiNiHiCmJiBeB_xHqqkZx_
// *			_xZkqqHx_iClLiCmMjDfPiCmJiNmFiCoAiLnPiCkCjFjEjFgJiCmMjFnDiPoDiCmMiCfAjDfPiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptNear	: _xZkqqHx_iNmFiCoAiLnPiCkCjDfPiCpAjFnEiClH_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_
// *			mmptSrc		: _xZkqqHx_iOhHjCoIiClDiCoKiClNjDfP_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_jDfPiCkKjFjEjFgJiCmJiLnPiCkCiIlNiCkCiCmNjDoAjBkEiCmMiPoKiNiH_xHqqkZx_
// *			FALSE	: _xZkqqHx_jDfPiCkKjFjEjFgJiCkJiCoHiJjDiCkCiPoKiNiH_xHqqkZx_
// *************************************************************************/
//BOOL FCObjGroup::NearestIntersect (DBLPoint& mmptNear,
//									const DBLPoint& mmptSrc) const
//{
//	ObjDynabaseVector::const_iterator iObj;
//
//	for (iObj = m_vObj.begin(); iObj != m_vObj.end(); iObj++)
//	{
//		if (m_pObjList[lObjIdx]->NearestIntersect(mmptNear, mmptSrc)) return TRUE;
//	}
//	return FALSE;
//}
//----- 99.05.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::CalcOuterFrame
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiKePjAnKiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeCiDePiDiLiBfLiDhGiCmMjAgFiCmJiClDiCkJiCmMiCnKiCmBiCmEiMhGiOfKiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.25 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
// *************************************************************************/
//void FCObjGroup::CalcOuterFrame ()
//{
//	// m_mmrtOuter_xZkqqHx_iCkKiJpAiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBjFjMiLeBiBeC_xHqqkZx_
//	// _xZkqqHx_iCmIiCpBiCmHiCoAiDiBiDjDiDgPiCmM_xHqqkZx_CalcOuterFrameSelf_xZkqqHx_iCkKiMmEiCmOiCoKiCoJiCmMiCpAjGgIiCkOiBeC_xHqqkZx_
//	if (m_mmrtOuter.right < m_mmrtOuter.left) return;
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::CalcOuterFrame();
//} // FCObjGroup::CalcOuterFrame.
//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::CalcResizeFrame
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeCiDePiDiLiBfLiDhGiCmMjAgFiCmJiClDiCkJiCmMiCnKiCmBiCmEiMhGiOfKiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.25 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
// *************************************************************************/
//void FCObjGroup::CalcResizeFrame ()
//{
//	// m_mmrtResize_xZkqqHx_iCkKiJpAiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBjFjMiLeBiBeC_xHqqkZx_
//	// _xZkqqHx_iCmIiCpBiCmHiCoAiDiBiDjDiDgPiCmM_xHqqkZx_CalcResizeFrameSelf_xZkqqHx_iCkKiMmEiCmOiCoKiCoJiCmMiCpAjGgIiCkOiBeC_xHqqkZx_
//	if (m_mmrtResize.right < m_mmrtResize.left) return;
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::CalcResizeFrame();
//} // FCObjGroup::CalcResizeFrame.
//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::CalcOuterFrameSelf
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeCjApMiCmMjFjNiCmNiNgMjHlGiClFiCmIiCkCiBeC_xHqqkZx_
// *************************************************************************/
//void FCObjGroup::CalcOuterFrameSelf ()
//{
//	// m_mmrtOuter_xZkqqHx_iCpAjGlDiMpIiCmJiClHiCoJiBeCiMoDiCmFiOfBiPmGiClDiCoKiClNiCmGiCkLiPiJiCnPiCmEiMhGiOfKiClHiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
//	m_mmrtOuter.SetRect(1,1,0,0);
//	long lObjIdx;
//	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
//	{
//		// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//		m_pObjList[lObjIdx]->CalcOuterFrameSelf();
//	}
//} // FCObjGroup::CalcOuterFrameSelf.
//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::CalcResizeFrameSelf
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *************************************************************************/
//void FCObjGroup::CalcResizeFrameSelf ()
//{
////----- 00.09.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	ObjDynabaseVector::const_iterator iObj;
////	iObj = m_vObj.begin();
////	m_mmrtResize = m_pObjList[lObjIdx]->GetResizeFrame();
////	DBLRect	mmrtMembOuter;
////	for (iObj++; iObj != m_vObj.end(); iObj++)
////	{
////		mmrtMembOuter = m_pObjList[lObjIdx]->GetResizeFrame();
////		if (mmrtMembOuter.left < m_mmrtResize.left)
////					m_mmrtResize.left = mmrtMembOuter.left;
////		if (mmrtMembOuter.top < m_mmrtResize.top)
////					m_mmrtResize.top = mmrtMembOuter.top;
////		if (m_mmrtResize.right < mmrtMembOuter.right)
////					m_mmrtResize.right = mmrtMembOuter.right;
////		if (m_mmrtResize.bottom < mmrtMembOuter.bottom)
////					m_mmrtResize.bottom = mmrtMembOuter.bottom;
////	}
////----- 00.09.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
////----- 01.07.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	m_mmrtResize.SetRect(DBL_MAX, DBL_MAX, -DBL_MAX, -DBL_MAX);
////	DBLRect mmrtMembOuter;
////	long lObjIdx;
////	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
////	{
////		// _xZkqqHx_iCnMiClIiBeBiDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeCiDePiDiLiBfLiDhGjCiGiCmJ_xHqqkZx_
////		// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCkKiKnMiCnMiCoKiCoJiClBiCmGiCpAiNgMjHlGiClFiCmEiBeC_xHqqkZx_
////		m_pObjList[lObjIdx]->CalcResizeFrameSelf();
////		mmrtMembOuter = m_pObjList[lObjIdx]->GetResizeFrame();
////		if (mmrtMembOuter.left < m_mmrtResize.left)
////					m_mmrtResize.left = mmrtMembOuter.left;
////		if (mmrtMembOuter.top < m_mmrtResize.top)
////					m_mmrtResize.top = mmrtMembOuter.top;
////		if (m_mmrtResize.right < mmrtMembOuter.right)
////					m_mmrtResize.right = mmrtMembOuter.right;
////		if (m_mmrtResize.bottom < mmrtMembOuter.bottom)
////					m_mmrtResize.bottom = mmrtMembOuter.bottom;
////	}
////----- 01.07.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	TRACE(_T("FCObjGroup::CalcResizeFrameSelf\n"));
//
//	// m_mmrtResize_xZkqqHx_iCpAjGlDiMpIiCmJiClHiCoJiBeCiMoDiCmFiOfBiPmGiClDiCoKiClNiCmGiCkLiPiJiCnPiCmEiMhGiOfKiClHiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
//	m_mmrtResize.SetRect(1,1,0,0);
//	long lObjIdx;
//	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
//	{
//		// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//		m_pObjList[lObjIdx]->CalcResizeFrameSelf();
//	}
////----- 01.07.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
////----- 00.09.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCObjGroup::CalcResizeFrameSelf.
//----- 05.06.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::~FCObjGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *************************************************************************/
FCObjGroup::~FCObjGroup ()
{
	if (m_pObjList != NULL)
	{
		// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
		long lObjIdx;
		for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
			delete m_pObjList[lObjIdx];
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		m_lObjListSz = 0;
//		delete[] m_pObjList;
//		m_pObjList = NULL;
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCArray<FCObjDynabase*>(m_pObjList, m_lObjListSz).Clear();
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	if (m_pLinkList != NULL)
	{
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		m_lLinkListSz = 0;
//		delete[] m_pLinkList;
//		m_pLinkList = NULL;
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCArray<FCGpLinkRec>(m_pLinkList, m_lLinkListSz).Clear();
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // FCObjGroup::~FCObjGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::RegisterObjID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJjDgPjIfOiPiIjHjNiBeCjFjEjFgJjAlGjAkMiMoDiBeB_xHqqkZx_InStream_xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiPoKiNiHiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *************************************************************************/
void FCObjGroup::RegisterObjID ()
{
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjCiGiCmMiKgFjFjEjFgJiCpAjDgPjIfO_xHqqkZx_ -----
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->RegisterObjID();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiClBiClBiCmFiClBiCmMjFjEjFgJiOkJjAgHiCmMjDgPjIfOiCkKjAkMiClDiCoKiCoJiBeC_xHqqkZx_
	BASE_CLASS::RegisterObjID();
} // FCObjGroup::RegisterObjID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::RegisterObjForceID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiCgIiCgDiCpAjDgPjIfOiClHiCoJiBeCiClBiCmMjFjEjFgJiCmJjFhEiCkPiCoHiCoKiCmEiCkCiCoJiCgIiCgDiOkJjAgHiCpA_xHqqkZx_
 *			_xZkqqHx_iLkNjAkHjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmGiDgAiDgCiDhGiCmMjDgPjIfOiKnGiMfHiCmFiClBiCmMiKnGjAjEiCpAjAfGjAnNiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::RegisterObjForceID ()
{
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjCiGiCmMiKgFjFjEjFgJiCpAiLkNjAkHjDgPjIfO_xHqqkZx_ -----
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->RegisterObjForceID();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiClBiClBiCmFiClBiCmMjFjEjFgJiOkJjAgHiCmMjDgPjIfOiCkKjAkMiClDiCoKiCoJiBeC_xHqqkZx_
	BASE_CLASS::RegisterObjForceID();
} // FCObjGroup::RegisterObjForceID ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::UnregisterObjID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJiPiIjHjNiBeC_xHqqkZx_delete_xZkqqHx_jBePiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *************************************************************************/
void FCObjGroup::UnregisterObjID ()
{
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->UnregisterObjID();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UnregisterObjID();
} // FCObjGroup::UnregisterObjID.

//----- 06.11.21 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::PasteOverAs
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkJiCoHiBeBiOhHjCoIiClDiCoKiClNjBkOjAkLiCmMiCnNiCpAjDfMiCoIjFhEiCkPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objFig		:_xZkqqHx_jDfMiCoIjFhEiCkPiCoJiMlDiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwPasteAttr	:_xZkqqHx_jDfMiCoIjFhEiCkPiCoJjBkOjAkLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiBeCiDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iMmEiCnBiPgPiClHjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::PasteOverAs (const FCObjFigure& objFig, DWORD dwPasteAttr)
{
	if ((dwPasteAttr & FD_PASTE_ATTR_TEXT) ||
		(dwPasteAttr & FD_PASTE_ATTR_PLAIN_TEXT))
	//----- _xZkqqHx_iDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgH_xHqqkZx_/_xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCmIjFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
		FCObjDynabase* pObj = GetFrontEditableTextObj();
		if (pObj != NULL)
		{
			// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiDeMiDfIiDgHjBkOjAkLiCpAjDfMiCoIjFhEiCkPiCoJiBeC_xHqqkZx_
			pObj->PasteOverAs(objFig,
							dwPasteAttr & (FD_PASTE_ATTR_TEXT | FD_PASTE_ATTR_PLAIN_TEXT));
		}
		// Baseclass_xZkqqHx_iKnGjAjEiCmMiClNiCnPjBkOjAkLjAnNjCoIiCpAiKePiClHiBeC_xHqqkZx_
		dwPasteAttr &= ~FD_PASTE_ATTR_TEXT;
		dwPasteAttr &= ~FD_PASTE_ATTR_PLAIN_TEXT;
	}
	// _xZkqqHx_iDiBiDjDiDgPiBfLiCmJiDePiDiJiDhEiDeCiDeOiDfIjBkOjAkLiCpAjDfMiCoIjFhEiCkPiCoJiBeC_xHqqkZx_
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != GetMemberSize(); lObjIdx++)
		GetMember(lObjIdx)->PasteOverAs(objFig, dwPasteAttr & FD_PASTE_ATTR_GRAPHICS);
	// Baseclass_xZkqqHx_iKnGjAjEiCmMiClNiCnPjBkOjAkLjAnNjCoIiCpAiKePiClHiBeC_xHqqkZx_
	dwPasteAttr &= ~FD_PASTE_ATTR_GRAPHICS;
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::PasteOverAs(objFig, dwPasteAttr);
} // FCObjGroup::PasteOverAs.
//----- 06.11.21 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetMemberResizeHorzByText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmMiBeBjAiFjFlNjFpLiMpMiCmMiDiKiDfEiDeDiDfJiLeLjBkFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_RPT_NONE:
// *					_xZkqqHx_iDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCmIiCkCiBeC_xHqqkZx_
// *			FD_RPT_H_LEFT:
// *					_xZkqqHx_jFjEjFgJiCmMiNlGjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_H_CENTER:
// *					_xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_H_RIGHT:
// *					_xZkqqHx_jFjEjFgJiCmMiJeFjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeBiDiBiDjDiDgPiBfLjFjEjFgJiCkKiDiKiDfEiDeDiDfJjBkOjAkLiCpAiOjNiCmBiCmEiCkCiClNiCoHiBeB_xHqqkZx_
// *			_xZkqqHx_jAiFjFlNiBeFjAiCjClMjHlMjFpLiMpMiCmMiDiKiDfEiDeDiDfJjBkOjAkLiCmJiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmFiCmNiBeBiIoKjFpLiMpMiCmMiCnNiCmMiDiKiDfEiDeDiDfJiCmNjGlDjHjNiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WORD FCObjGroup::GetMemberResizeHorzByText (const FCObjDynabase* pObj) const
//{
//	if (pObj->GetStdResizeVertByText() != FD_RPT_NONE &&
//		pObj->GetStdResizeHorzByText() == FD_RPT_NONE)
//		return pObj->GetStdResizeVertByText();
//	return pObj->GetStdResizeHorzByText();
//} // FCObjGroup::GetMemberResizeHorzByText.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetMemberResizeVertByText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmMiBeBjAiCjClMjFpLiMpMiCmMiDiKiDfEiDeDiDfJiLeLjBkFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_RPT_NONE:
// *					_xZkqqHx_iDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCmIiCkCiBeC_xHqqkZx_
// *			FD_RPT_V_TOP:
// *					_xZkqqHx_jFjEjFgJiCmMiPoDjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_V_CENTER:
// *					_xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_V_BOTTOM:
// *					_xZkqqHx_jFjEjFgJiCmMiJlKjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeBiDiBiDjDiDgPiBfLjFjEjFgJiCkKiDiKiDfEiDeDiDfJjBkOjAkLiCpAiOjNiCmBiCmEiCkCiClNiCoHiBeB_xHqqkZx_
// *			_xZkqqHx_jAiFjFlNiBeFjAiCjClMjHlMjFpLiMpMiCmMiDiKiDfEiDeDiDfJjBkOjAkLiCmJiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmFiCmNiBeBiIoKjFpLiMpMiCmMiCnNiCmMiDiKiDfEiDeDiDfJiCmNjGlDjHjNiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WORD FCObjGroup::GetMemberResizeVertByText (const FCObjDynabase* pObj) const
//{
//	if (pObj->GetStdResizeHorzByText() != FD_RPT_NONE &&
//		pObj->GetStdResizeVertByText() == FD_RPT_NONE)
//		return pObj->GetStdResizeHorzByText();
//	return pObj->GetStdResizeVertByText();
//} // FCObjGroup::GetMemberResizeVertByText.
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetMemberFixResizeByText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmMiBeBiDgFiDeMiDfIiDgHjFmPiNfIiOjOiCmMjCmHiPfNiDiKiDfEiDeDiDfJiCmMiLeLjBkFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_RPT_V_MASK _xZkqqHx_iCmFiDhNiDfIiDeOiClFiClNjCgMiBeC_xHqqkZx_
 *				FD_RPT_NONE		:_xZkqqHx_jAiCjClMjFpLiMpMiCmJiCmNiDfEiDeDiDfJjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *				FD_RPT_V_TOP	:_xZkqqHx_jFjEjFgJiCmMiPoDiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *				FD_RPT_V_BOTTOM	:_xZkqqHx_jFjEjFgJiCmMiJlKiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *				FD_RPT_V_CENTER	:_xZkqqHx_jFjEjFgJiCmMjCiGjAfDiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *			FD_RPT_H_MASK _xZkqqHx_iCmFiDhNiDfIiDeOiClFiClNjCgMiBeC_xHqqkZx_
 *				FD_RPT_NONE		:_xZkqqHx_jAiCjClMjFpLiMpMiCmJiCmNiDfEiDeDiDfJjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *				FD_RPT_H_LEFT	:_xZkqqHx_jFjEjFgJiCmMiNlGiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *				FD_RPT_H_RIGHT	:_xZkqqHx_jFjEjFgJiCmMiJeFiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *				FD_RPT_H_CENTER	:_xZkqqHx_jFjEjFgJiCmMjCiGjAfDiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeBiDiBiDjDiDgPiBfLjFjEjFgJiCkKjAiFjFlNiBeFjAiCjClMiCmMiCkCiClIiCoKiCkJiCmJ_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiJmCiCpAiOjNiCmBiCmEiCkCiClNiCoHiBeBjAiFjFlNiBeFjAiCjClMjHlMjFpLiMpMiCpAiDiKiDfEiDeDiDfJiJmC_xHqqkZx_
 *			_xZkqqHx_iCmJiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmFiCmNiBeBiIoKjFpLiMpMiCmMiCnNiCmMiDiKiDfEiDeDiDfJiCmNjGlDjHjNiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCObjGroup::GetMemberFixResizeByText (const FCObjDynabase* pObj) const
{
	if (pObj->GetStdFixResizeByText() != FD_RPT_NONE)
		return g_pReg->GetResizeFixPosition();
	return FD_RPT_NONE;
} // FCObjGroup::GetMemberFixResizeByText.
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetIsMemberShortenByText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmMiDgFiDeMiDfIiDgHiPgLiPkMiOjOiCmJiBeBjAgFjFjEjFgJiCoAiPgLiPkMiClHiCoJiCkJiCmHiCkEiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPgLiPkMiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjGroup::GetIsMemberShortenByText (const FCObjDynabase* pObj) const
{
	return pObj->GetIsShortenByText();
} // FCObjGroup::GetIsMemberShortenByText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::AdjustObjectSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjFjEjFgJiCpAiBeBiClBiCmMjFjEjFgJiCmJiKnMiCnMiCoKiCoJjFjEjFgJiBgJiDiBiDjDiDgPiBfLiBgKiCmMiDgFiDeMiDfIiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iIoMiCoKiCkKjGlDiCkNiCmIiCoJiCoGiCkEiCmJiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pTextObj	:_xZkqqHx_iDgFiDeMiDfIiDgHiCkKjFmPiNfIiClDiCoKiClNjFjEjFgJiCpAiOhHjCoIiBeCiDePiDiLiBfLiDhGjFjEjFgJiCmM_xHqqkZx_
 *						 _xZkqqHx_iPoKiNiHiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiClFiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *			dRatioHorz	:X_xZkqqHx_jFpLiMpMiDiKiDfEiDeDiDfJiCmMiKgHjBoFjHkGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRatioVert	:Y_xZkqqHx_jFpLiMpMiDiKiDfEiDeDiDfJiCmMiKgHjBoFjHkGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiDfCiDhNiDjDiDgIjEkNiNhDiClHiCoJiClBiCmGiCmJjCiNiInDiBeCiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEiCkIiCkN_xHqqkZx_
 *			_xZkqqHx_jFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDeOiDiJiDfIjCiGiCmFiCmNiCmIiCkNiBeBiCoNiClEiCoNiClEjFjEjFgJiDeOiDiJiDfIjCiGiCmJiClBiCmMiKnGjAjEiCpAjChFiCkNiCmMiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_jFfMjFjEjFgJiCmFiDiBiDjDiDgPiBfLiCkKiDiKiDfEiDeDiDfJiClDiCoKiClNiNnLiCmMiPiIjHjNiCpAiNhDiCoNiClJiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::AdjustObjectSize (	FCObjDynabase* pTextObj,
									double dRatioHorz,
									double dRatioVert,
									const DBLPoint& mmptFixPoint)
{
	// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeBjAiFjFlNiBeFjAiCjClMiCmMiKgHjBoFjHkGiCmNjDkPiClGiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (dRatioHorz != dRatioVert) FFThrowMiscUnknown();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDfEiDeDiDfJjFmPiNfIiCkKiOhHiOkGiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (almosteq(dRatioHorz, 1.0) && almosteq(dRatioVert, 1.0)) return;

	// _xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLjCiGiCmFiBeBiDgFiDeMiDfIiDgHiCmJiDhEiDeCiDgCiDgHiClHiCoJ_xHqqkZx_
	// _xZkqqHx_iKgHjBoFjEoEjHkGiCmMiNmFjBoFiCmMjCgMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	double dRatioMax = 0.0;
	// _xZkqqHx_jFjEjFgJjCiGiCmMiBeB_xHqqkZx_OBJ_FIGURE_xZkqqHx_jFjEjFgJiCpAjBfDiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	ObjDynabaseVector vSubObj;
	GetKindOfMembers(vSubObj, FDOJ_FIGURE);
	ObjDynabaseVector::iterator iSubObj;
	for (iSubObj = vSubObj.begin(); iSubObj != vSubObj.end(); iSubObj++)
	{
		if (*iSubObj != pTextObj && (*iSubObj)->GetRichText() != NULL)
		//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOjNiCmCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jAiFjFlNiBeFjAiCjClMjFpLiMpMiCmMiDhEiDeCiDgCiDgHiDfEiDeDiDfJiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			double dRatioHorzTmp;
			double dRatioVertTmp;
			(*iSubObj)->GetRichText()->CalcTextFitSize(	dRatioHorzTmp,
														dRatioVertTmp,
														(const FCObjFigure*)(*iSubObj),
														FD_HIT_UPPER_LEFT,
														TRUE);
			// _xZkqqHx_iCoGiCoIjBoFiCkLiCkCiKgHjBoFjHkGiCpAiLeMjIfOiBeC_xHqqkZx_
			if (dRatioMax < dRatioHorzTmp) dRatioMax = dRatioHorzTmp;
		}
	}
	if (dRatioHorz < dRatioMax)
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjCiGiCmMjBlMiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiDhEiDeCiDgCiDgHiKgHjBoFjHkGiCkKjBoFiCkLiCkCiPoKiNiH_xHqqkZx_ -----
	{
		dRatioHorz = dRatioMax;
		dRatioVert = dRatioMax;
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::AdjustObjectSize(pTextObj, dRatioHorz, dRatioVert, mmptFixPoint);
} // FCObjGroup::AdjustObjectSize.

//----- 02.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ (Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkKiCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_)-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::Terminate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPeJjHlJiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_CommandGate_xZkqqHx_iCmFjFjEjFgJiCpAiNoNiPjMiClHiCoJjBePiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiOjOiBeBiDeBiDhGiDiKiPeJjHlJiOjOiCmJiCmNiOmAiNhDiClDiCoKiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.11.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCObjGroup::Terminate ()
//{
//	long lObjIdx;
//	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
//		m_pObjList[lObjIdx]->Terminate();
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::Terminate();
//} // FCObjGroup::Terminate.
//----- 02.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ (Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkKiCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::SetGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_iDiBiDjDiDgPjFjEjFgJiPfHiNiHiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::SetGroup (const ObjDynabaseVector& vObj)
{
	ASSERT(m_pObjList == NULL);
	m_lObjListSz = vObj.size();
	m_pObjList = new FCObjDynabase*[m_lObjListSz];
	for (long lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
	{
		// _xZkqqHx_iDiBiDjDiDgPjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
		m_pObjList[lObjIdx] = vObj[lObjIdx];
		// _xZkqqHx_iDiBiDjDiDgPjFjEjFgJiCmJjAgFjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
		m_pObjList[lObjIdx]->SetGroupParent(this);
	}
	// _xZkqqHx_iDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
	CalcResizeFrame();
// 05.05.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	CalcOuterFrame();
} // FCObjGroup::SetGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::SetLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiCpAiCmCiCmIiCkOiDiKiDjDiDeOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vLinkId	:_xZkqqHx_iDiBiDjDiDgPiKnEiCmMiKnEiCpAiCmCiCmIiCkOiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKnGjAjEiOmAiNhDiOjOiCmNiBeBiDiKiDjDiDeOiDiMiDfCiBfLiDgIjCiGiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
 *			_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeCiClBiCmMiClNiCnPiBeBiDePiDiLiBfLiDhGjCiGiCmMjFjEjFgJiCmNjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCmJ_xHqqkZx_
 *			_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::SetLink (const DWORDVector& vLinkId)
{
	ASSERT(m_pLinkList == NULL);
	if (vLinkId.empty()) return;
	//----- _xZkqqHx_jFjEjFgJ_xHqqkZx_ID -> _xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_IDX_xZkqqHx_iCmMjFmPiKlHiDgFiBfLiDhFiDiLiCpAiNoMjAkM_xHqqkZx_ -----
	map<DWORD, DWORD> mpIdToIdx;
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		mpIdToIdx[m_pObjList[lObjIdx]->GetObjID()] = DWORD(lObjIdx);

	//----- _xZkqqHx_iDiKiDjDiDeOiDiKiDfIiDgHiCpAiDfCiDhDiBfLiBeCjDkPiOjOiCmJjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjFmPiKlH_xHqqkZx_ -----
	m_lLinkListSz = vLinkId.size();
	m_pLinkList = new FCGpLinkRec[m_lLinkListSz];
	long lLnkIdx;
	for (lLnkIdx = 0; lLnkIdx < m_lLinkListSz; lLnkIdx++)
	{
		m_pLinkList[lLnkIdx] = *g_pDoc->LinkManager()->LinkIDtoLinkRec(vLinkId[lLnkIdx]);
		m_pLinkList[lLnkIdx].m_mlpFrom.dwObjID =
								mpIdToIdx[m_pLinkList[lLnkIdx].m_mlpFrom.dwObjID];
		m_pLinkList[lLnkIdx].m_mlpTo.dwObjID =
								mpIdToIdx[m_pLinkList[lLnkIdx].m_mlpTo.dwObjID];
	}
} // FCObjGroup::SetLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiCpAiCmCiCmIiCkOiDiKiDjDiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vGpLinkRec	:_xZkqqHx_iDiBiDjDiDgPiKnEiCmMiKnEiCpAiCmCiCmIiCkOiDiKiDjDiDeOiPoOjFpBiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKnGjAjEiOmAiNhDiOjOiCmNiBeBiDiKiDjDiDeOiDiMiDfCiBfLiDgIjCiGiCmMiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFjEjFgJ_xHqqkZx_ID
 *			_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeCiClBiCmMiClNiCnPiBeBiDePiDiLiBfLiDhGjCiGiCmMjFjEjFgJiCmNjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCmJ_xHqqkZx_
 *			_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::GetLink (FCLinkRecVector& vLinkRec) const
{
//----- 01.08.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	vGpLinkRec.assign(m_pLinkList, m_pLinkList + m_lLinkListSz);
//	GpLinkRecVector::iterator iGr;
//	for (iGr = vGpLinkRec.begin(); iGr != vGpLinkRec.end(); iGr++)
//	{
//		(*iGr).m_mlpFrom.dwObjID = m_pObjList[(*iGr).m_mlpFrom.dwObjID]->GetObjID();
//		(*iGr).m_mlpTo.dwObjID = m_pObjList[(*iGr).m_mlpTo.dwObjID]->GetObjID();
//	}
//----- 01.08.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	vLinkRec.assign(m_lLinkListSz);
	for (long lIdx = 0; lIdx < m_lLinkListSz; lIdx++)
	{
		vLinkRec[lIdx].m_mlpFrom	= m_pLinkList[lIdx].m_mlpFrom;
		vLinkRec[lIdx].m_mlpTo		= m_pLinkList[lIdx].m_mlpTo;
		vLinkRec[lIdx].m_wLinkKind	= m_pLinkList[lIdx].m_wLinkKind;
		vLinkRec[lIdx].m_mmptOffset.SetPoint(0,0);
		// FCGpLinkRec_xZkqqHx_iCmM_xHqqkZx_mlpFrom_xZkqqHx_iCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNiDePiDiLiBfLiDhGiDiBiDjDiDgP_xHqqkZx_index_xZkqqHx_iCmJ_xHqqkZx_
		// _xZkqqHx_jChFiCkLiKlHiCkGiCmEiCkAiCoJiCmMiCmFiBeBiMlDiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmJjGnPiClHiBeC_xHqqkZx_
		vLinkRec[lIdx].m_mlpFrom.dwObjID = m_pObjList[vLinkRec[lIdx].m_mlpFrom.dwObjID]->GetObjID();
		vLinkRec[lIdx].m_mlpTo.dwObjID = m_pObjList[vLinkRec[lIdx].m_mlpTo.dwObjID]->GetObjID();
	}
//----- 01.08.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjGroup::GetLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::ClearGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeBiDjDiDePiDiLiBfLiDhGiOjOiCmNiBeBjFjEjFgJjEgKiJpDiCmMjBePiCmJiClBiCmMiPiIjHjNiCpAiClFiCmIiCkCiCmGiBeBiDiBiDjDiDgPjFjEjFgJ_xHqqkZx_
 *			_xZkqqHx_iCoAiIoKiPiPiCmJjEgKiJpDiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::ClearGroup ()
{
	if (m_pObjList != NULL)
	{
//----- 01.07.23 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		for (long lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
		{
			// _xZkqqHx_iDiBiDjDiDgPjFjEjFgJiCmMjAgFjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
			m_pObjList[lObjIdx]->SetGroupParent(NULL);
		}
//----- 01.07.23 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		delete[] m_pObjList;
//		m_pObjList = NULL;
//		m_lObjListSz = 0;
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCArray<FCObjDynabase*>(m_pObjList, m_lObjListSz).Clear();
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // FCObjGroup::ClearGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetEditableTextObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjCiGiCmFiBeBiOhHjCoIiClDiCoKiClNiNmAjFfHiCmGiMpAiNlDiClHiCoJiDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCmI_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiJmCjEfMjFjEjFgJiCpAjFnEiClHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCObjGroup::GetEditableTextObj (const DBLPoint& mmpt) const
{
	long lObjIdx;
	for (lObjIdx = m_lObjListSz - 1; 0 <= lObjIdx; lObjIdx--)
	{
		// _xZkqqHx_jFjEjFgJiCkKiDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		if (m_pObjList[lObjIdx]->CanBeTextObject())
		{
//----- 06.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			// _xZkqqHx_jBmOiPnLiCmMjFjEjFgJiCkKiNmAjFfHiCmGiMpAiNlDiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
//			if (m_pObjList[lObjIdx]->IsIntersect(mmpt, FALSE)) return m_pObjList[lObjIdx];
//----- 06.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			if (m_pObjList[lObjIdx]->IsIntersect(mmpt, FALSE))
			//----- _xZkqqHx_jBmOiPnLiCmMjFjEjFgJiCkKiNmAjFfHiCmGiMpAiNlDiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iPiKjCoIiCmMjGmKjAmPiImIiPoDiCmFiCkAiCoKiCmOjFnCiPfHiJmCjEfMiBeC_xHqqkZx_
				if (FD_MIN_AREA_FOR_TEXT <= m_pObjList[lObjIdx]->CalcArea())
					return m_pObjList[lObjIdx];
			}
//----- 06.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		} else if (m_pObjList[lObjIdx]->IsKindOf(FDOJ_GROUP))
		// _xZkqqHx_jFjEjFgJiCkKiDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeC_xHqqkZx_
		{
			FCObjDynabase* pObj = ((FCObjGroup*)m_pObjList[lObjIdx])->GetEditableTextObj(mmpt);
			if (pObj != NULL) return pObj;
		}
	}
	return NULL;
} // FCObjGroup::GetEditableTextObj.

//----- 06.12.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetFrontEditableTextObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLjCiGiCmFiBeBiDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCmIjFjEjFgJiCmMiCkEiClPiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiCoAjBePjGmKiCmJiCkAiCoJiCoAiCmMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCmIjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCObjGroup::GetFrontEditableTextObj () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfM_xHqqkZx_(_xZkqqHx_jGmKjAmPiCePiCpAiKnMiCnOiBgKiCmIjFjEjFgJiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	GetCanBeTextObject(vObj);
	while (!vObj.empty())
	{
		// _xZkqqHx_iPiKjCoIiCmMjGmKjAmPiImIiPoDiCmFiCkAiCoKiCmOjFnCiPfHiJmCjEfMiBeC_xHqqkZx_
		if (FD_MIN_AREA_FOR_TEXT <= vObj.back()->CalcArea())
			return vObj.back();
		vObj.pop_back();
	}
	return NULL;
} // FCObjGroup::GetFrontEditableTextObj.
//----- 06.12.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetCanBeTextObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjCiGiCmFiBeBiDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCmIjFjEjFgJjBfDiCmEiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iOmAiNnLiCmJiCmNjFnCiPfHjFhDiJmCiBgJjGmKjAmPiCkKiCePiBgKiCmMiPoKiNiHiCoAjHeMiCoIiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::GetCanBeTextObject (ObjDynabaseVector& vObj) const
{
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
	{
		// _xZkqqHx_jFjEjFgJiCkKiDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		if (m_pObjList[lObjIdx]->CanBeTextObject())
			vObj.push_back(m_pObjList[lObjIdx]);
		else if (m_pObjList[lObjIdx]->IsKindOf(FDOJ_GROUP))
		// _xZkqqHx_jFjEjFgJiCkKiDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeC_xHqqkZx_
			((FCObjGroup*)m_pObjList[lObjIdx])->GetCanBeTextObject(vObj);
	}
} // FCObjGroup::GetCanBeTextObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::GetObjToIndexTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJ_xHqqkZx_->_xZkqqHx_iDiBiDjDiDgPiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDgOiDgCiDfGiDiFiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpObjToIndex	:_xZkqqHx_jFjEjFgJ_xHqqkZx_->_xZkqqHx_iDiBiDjDiDgPiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDgOiDgCiDfGiDiFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJiBiB_xHqqkZx_NULL _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCkKiDeDiDjDiDgGiDgCiDeOiDfIiCmGiClFiCmEjAnNjCoIiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::GetObjToIndexTable (map<const FCObjDynabase*, long>& mpObjToIndex) const
{
	mpObjToIndex.clear();
	mpObjToIndex[NULL] = -1;
	for (long lIndex = 0; lIndex != GetMemberSize(); lIndex++)
		mpObjToIndex[GetMember(lIndex)] = lIndex;
} // FCObjGroup::GetObjToIndexTable.

//----- 05.06.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::FindNextMemberText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLjFjEjFgJiCmMiDgFiDeMiDfIiDgHjFjEjFgJiCpAiMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sp			:_xZkqqHx_iMjPiNpFjHhA_xHqqkZx_SearchParser_xZkqqHx_iCpAiOhHjCoIiBeCiMjPiNpFiPpAiMiPiCkKjAnNjCoIiClDiCoKiClN_xHqqkZx_
// *						 _xZkqqHx_iCoAiCmMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pCurrentObj	:_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeCiClBiCmMjFjEjFgJiCmM_xHqqkZx_
// *						 _xZkqqHx_iOjPiCmMjFjEjFgJiCkJiCoHiMjPiNpFiClDiCoKiCoJiBeCjGkCjBeJjBpAiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiBiDjDiDgPiBfLjFjEjFgJiBeCiDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAiNmEiLeBjDeJiCmJjBfDiCmEiOoGiCoIiPgPiClFiCmEiMjPiNpFiClHiCoJiBeC_xHqqkZx_
// *			Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmFiMkJiCoJiCmGiBeBiMoDjFpLiCmJiMpMiCkJiCkEiCmGiCmNiBeBiNmFiMoDiCkJiCoHiNmFiPiJiCmJiMpMiCkJiCmBiCmE_xHqqkZx_
// *			_xZkqqHx_iMjPiNpFiClHiCoJiClBiCmGiCmFiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCObjDynabase* FCObjGroup::FindNextMemberText (FCSearchParser& sp, FCObjDynabase* pCurrentObj)
//{
//	// ObjGroup_xZkqqHx_jCiGiCmMiBeBjBfDiCmEiCmMjFnCiPfHiJmCjEfMiDgFiDeMiDfIiDgHjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
//	ObjDynabaseVector vObj;
//	// _xZkqqHx_iDgAiDgCiDhGiCmMjEpBjFnCiPfHiDgFiDeMiDfIiDgHiCoAjBmOiPnLiCmJiJmBiCkGiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
//	// FCObjFigure_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCpAjBfDiCmEiPfHiCnPiCoJiBeC_xHqqkZx_
//	if (g_pReg->GetIsFindChipText())
//		GetKindOfMembers(vObj, FDOJ_FIGURE);
//	else
//		GetCanBeTextObject(vObj);
//
//	// _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKiCkAiCoKiCmOiBeBiClLiCmMjFjEjFgJiCmMiOjPiCmMjFjEjFgJiCnMiCmFjBjHiCoJiBeC_xHqqkZx_
//	ObjDynabaseVector::reverse_iterator rObj = vObj.rbegin();
//	if (pCurrentObj != NULL)
//	//----- _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		for (; rObj != vObj.rend(); rObj++)
//		{
//			if (*rObj == pCurrentObj)
//			//----- _xZkqqHx_jDkPiClGjFjEjFgJiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iClLiCmMiIoKiCmCjAoGiCmJjBjHiCoJiBeC_xHqqkZx_
//				rObj++;
//				break;
//			}
//		}
//		// _xZkqqHx_iMjPiNpFiPpAiMiPiCpAjFmPiNfIiClFiClNiPoKiNiHiBgJiDgAiDgCiDhGiCmMjEpBjFnCiPfHiDgFiDeMiDfIiDgHiCpAiMjPiNpFjBmOiPnLiCkJiCoHiKePiClHiCmIiCmHiBgKiBeB_xHqqkZx_
//		// _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iClLiCmMiPoKiNiHiCmNiBeB_xHqqkZx_rObj = rend() _xZkqqHx_iCmGiCmIiCoJiCoGiCkEiCmJiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	}
//	// _xZkqqHx_iOjPiCmMiDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
//	FCObjDynabase* pNextObj = NULL;
//	for (; rObj != vObj.rend(); rObj++)
//	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiOjPiCmMjFjEjFgJiImIiNhOiCpAiDiLiBfLiDhG_xHqqkZx_ -----
//	{
//		ASSERT((*rObj)->IsKindOf(FDOJ_FIGURE));
//		FCRichText* pText = ((FCObjFigure*)*rObj)->GetRichText();
//		if (pText != NULL)
//		//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// wchar_t_xZkqqHx_iMfOiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//			WString strTarget;
//			pText->GetText(strTarget);
//			// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClHiCoJiPoKiNiHiCmNiBeBiDfOiBfLiDfBiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
//			if (sp.IsMatch(strTarget.c_str()) == 1)
//			{
//				// _xZkqqHx_iOjPiCmMiDhBiDgCiDgHiClFiClNjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
//				pNextObj = *rObj;
//				break;
//			}
//		}
//	}
//	return pNextObj;
//} // FCObjGroup::FindNextMemberText.
//----- 05.06.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::FindPrevMemberText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLjFjEjFgJiCmMiDgFiDeMiDfIiDgHjFjEjFgJiCpAjBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sp			:_xZkqqHx_iMjPiNpFjHhA_xHqqkZx_SearchParser_xZkqqHx_iCpAiOhHjCoIiBeCiMjPiNpFiPpAiMiPiCkKjAnNjCoIiClDiCoKiClN_xHqqkZx_
// *						 _xZkqqHx_iCoAiCmMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pCurrentObj	:_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeCiClBiCmMjFjEjFgJiCmM_xHqqkZx_
// *						 _xZkqqHx_iOjPiCmMjFjEjFgJiCkJiCoHiMjPiNpFiClDiCoKiCoJiBeCjGkCjBeJjBpAiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiDiBiDjDiDgPiBfLjFjEjFgJiBeCiDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAiNmEiLeBjDeJiCmJjBfDiCmEiOoGiCoIiPgPiClFiCmEiMjPiNpFiClHiCoJiBeC_xHqqkZx_
// *			Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmFiMkJiCoJiCmGiBeBjBePjFpLiCmJiMpMiCkJiCkEiCmGiCmNiBeBiNmFiPiJiCkJiCoHiNmFiMoDiCmJiMpMiCkJiCmBiCmE_xHqqkZx_
// *			_xZkqqHx_iMjPiNpFiClHiCoJiClBiCmGiCmFiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCObjDynabase* FCObjGroup::FindPrevMemberText (FCSearchParser& sp, FCObjDynabase* pCurrentObj)
//{
//	// ObjGroup_xZkqqHx_jCiGiCmMiBeBjBfDiCmEiCmMjFnCiPfHiJmCjEfMiDgFiDeMiDfIiDgHjFjEjFgJiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
//	ObjDynabaseVector vObj;
//	// _xZkqqHx_iDgAiDgCiDhGiCmMjEpBjFnCiPfHiDgFiDeMiDfIiDgHiCoAjBmOiPnLiCmJiJmBiCkGiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
//	// FCObjFigure_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCpAjBfDiCmEiPfHiCnPiCoJiBeC_xHqqkZx_
//	if (g_pReg->GetIsFindChipText())
//		GetKindOfMembers(vObj, FDOJ_FIGURE);
//	else
//		GetCanBeTextObject(vObj);
//
//	// _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKiCkAiCoKiCmOiBeBiClLiCmMjFjEjFgJiCmMiOjPiCmMjFjEjFgJiCnMiCmFjBjHiCoJiBeC_xHqqkZx_
//	ObjDynabaseVector::iterator iObj = vObj.begin();
//	if (pCurrentObj != NULL)
//	//----- _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		for (; iObj != vObj.end(); iObj++)
//		{
//			if (*iObj == pCurrentObj)
//			//----- _xZkqqHx_jDkPiClGjFjEjFgJiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iClLiCmMiIoKiCmCjAoGiCmJjBjHiCoJiBeC_xHqqkZx_
//				iObj++;
//				break;
//			}
//		}
//		// _xZkqqHx_iMjPiNpFiPpAiMiPiCpAjFmPiNfIiClFiClNiPoKiNiHiBgJiDgAiDgCiDhGiCmMjEpBjFnCiPfHiDgFiDeMiDfIiDgHiCpAiMjPiNpFjBmOiPnLiCkJiCoHiKePiClHiCmIiCmHiBgKiBeB_xHqqkZx_
//		// _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iClLiCmMiPoKiNiHiCmNiBeB_xHqqkZx_iObj = end() _xZkqqHx_iCmGiCmIiCoJiCoGiCkEiCmJiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	}
//	// _xZkqqHx_iOjPiCmMiDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
//	FCObjDynabase* pNextObj = NULL;
//	for (; iObj != vObj.end(); iObj++)
//	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiOjPiCmMjFjEjFgJiImIiNhOiCpAiDiLiBfLiDhG_xHqqkZx_ -----
//	{
//		ASSERT((*iObj)->IsKindOf(FDOJ_FIGURE));
//		FCRichText* pText = ((FCObjFigure*)*iObj)->GetRichText();
//		if (pText != NULL)
//		//----- _xZkqqHx_jFjEjFgJiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// wchar_t_xZkqqHx_iMfOiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//			WString strTarget;
//			pText->GetText(strTarget);
//			// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClHiCoJiPoKiNiHiCmNiBeBiDfOiBfLiDfBiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
//			if (sp.IsMatch(strTarget.c_str()) == 1)
//			{
//				// _xZkqqHx_iOjPiCmMiDhBiDgCiDgHiClFiClNjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
//				pNextObj = *iObj;
//				break;
//			}
//		}
//	}
//	return pNextObj;
//} // FCObjGroup::FindPrevMemberText.
//----- 05.06.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjGroup::CopySelf(pObj);
} // FCObjGroup::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjGroup::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	FCObjGroup* pGrp = reinterpret_cast<FCObjGroup*>(pObj);
	ASSERT(pGrp->m_pObjList == NULL);
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjGroup, m_mmrtResize));
	ASSERT(sizeof(*this) - offsetof(FCObjGroup, m_pObjList) ==
			sizeof(m_pObjList) + sizeof(m_lLinkListSz) + sizeof(m_pLinkList));
	memcpy(&pGrp->m_mmrtResize, &m_mmrtResize,
			offsetof(FCObjGroup, m_pObjList) - offsetof(FCObjGroup, m_mmrtResize));
	pGrp->m_pObjList = new FCObjDynabase*[m_lObjListSz];
	long lObjIdx;
//----- 01.07.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
//		pGrp->m_pObjList[lObjIdx] = (FCObjDynabase*)m_pObjList[lObjIdx]->Duplicate();
//----- 01.07.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	for (lObjIdx = 0; lObjIdx != m_lObjListSz; lObjIdx++)
	{
		pGrp->m_pObjList[lObjIdx] = (FCObjDynabase*)m_pObjList[lObjIdx]->Duplicate();
		// _xZkqqHx_iDiBiDjDiDgPjFjEjFgJiCmJjAgFjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
		pGrp->m_pObjList[lObjIdx]->SetGroupParent(pGrp);
	}
//----- 01.07.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	pGrp->m_lLinkListSz = m_lLinkListSz;
//	if (m_pLinkList != NULL)
//	{
//		pGrp->m_pLinkList = new FCGpLinkRec[m_lLinkListSz];
//		memcpy(pGrp->m_pLinkList, m_pLinkList, m_lLinkListSz * sizeof(m_pLinkList[0]));
//	}
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCArray<FCGpLinkRec>(pGrp->m_pLinkList, pGrp->m_lLinkListSz) =
			FCConstArray<FCGpLinkRec>(m_pLinkList, m_lLinkListSz);
//----- 05.02.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjGroup::CopySelf.

//----- 05.02.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::AddGroup
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiDePiDiLiBfLiDhGiDiBiDjDiDgPiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHiJmBiClDiCoKiClNjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiCmMiNmEiMhGiOfKiCmNiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long FCObjGroup::AddGroup (FCObjDynabase* pObj)
//{
//	FCArray<FCObjDynabase*>(m_pObjList, m_lObjListSz).PushBack(pObj);
//	// _xZkqqHx_iDiBiDjDiDgPjFjEjFgJiCmJjAgFjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
//	pObj->SetGroupParent(this);
//	return m_lObjListSz - 1;
//} // FCObjGroup::AddGroup.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::EraseGroup
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiDePiDiLiBfLiDhGiDiBiDjDiDgPiCkJiCoHjGjFiPmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_jGjFiPmBiClHiCoJjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDgPjIfOjGjFiPmBiClDiCoKiClNjFjEjFgJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiCmMiNmEiMhGiOfKiCmNiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCObjDynabase* FCObjGroup::EraseGroup (long lIndex)
//{
//	// m_lObjListSz = 8_xZkqqHx_iBeB_xHqqkZx_lIndex = 5 _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
//	// _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
//	// _xZkqqHx_iEkA_xHqqkZx_ 0_xZkqqHx_iEkA_xHqqkZx_ 1_xZkqqHx_iEkA_xHqqkZx_ 2_xZkqqHx_iEkA_xHqqkZx_ 3_xZkqqHx_iEkA_xHqqkZx_ 4_xZkqqHx_iEkA_xHqqkZx_ 5_xZkqqHx_iEkA_xHqqkZx_ 6_xZkqqHx_iEkA_xHqqkZx_ 7_xZkqqHx_iEkA_xHqqkZx_
//	// _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
//	//
//	// _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
//	// _xZkqqHx_iEkA_xHqqkZx_ 0_xZkqqHx_iEkA_xHqqkZx_ 1_xZkqqHx_iEkA_xHqqkZx_ 2_xZkqqHx_iEkA_xHqqkZx_ 3_xZkqqHx_iEkA_xHqqkZx_ 4_xZkqqHx_iEkA_xHqqkZx_ 6_xZkqqHx_iEkA_xHqqkZx_ 7_xZkqqHx_iEkA_xHqqkZx_
//	// _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
//
//	FCObjDynabase* pObj = m_pObjList[lIndex];
//	FCArray<FCObjDynabase*>(m_pObjList, m_lObjListSz).Erase(lIndex);
//	return pObj;
//} // FCObjGroup::EraseGroup.
//
//----- 05.02.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::InsertGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiDePiDiLiBfLiDhGiDiBiDjDiDgPiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vInsertIndex	:_xZkqqHx_jBhNjDpMiClHiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vInsertMember	:_xZkqqHx_jBhNjDpMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiCmMiNmEiMhGiOfKiCmNiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::InsertGroup (const longVector& vInsertIndex, const ObjDynabaseVector& vInsertMember)
{
	// _xZkqqHx_jBhNjDpMiImKjChFiCmFjFjEjFgJiCpAiDfMiBfLiDgHiClHiCoJiBeC_xHqqkZx_
	map<long, FCObjDynabase*> mpIndexToObj;
	long lC;
	for (lC = 0; lC != vInsertIndex.size(); lC++)
	{
		// _xZkqqHx_iDiBiDjDiDgPjFjEjFgJiCmJjAgFjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
		vInsertMember[lC]->SetGroupParent(this);
		mpIndexToObj[vInsertIndex[lC]] = vInsertMember[lC];
	}
	// vObj_xZkqqHx_iCmJiDiBiDjDiDgPiBfLiDiKiDfIiDgHiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	vObj.reserve(m_lObjListSz + vInsertIndex.size());
	vObj.insert(vObj.begin(), m_pObjList, m_pObjList + m_lObjListSz);
	// vObj_xZkqqHx_iCmFjBhNjDpMiPiIjHjNiBeC_xHqqkZx_
	map<long, FCObjDynabase*>::const_iterator iIxo;
	for (iIxo = mpIndexToObj.begin(); iIxo != mpIndexToObj.end(); iIxo++)
		vObj.insert(vObj.begin() + (*iIxo).first, (*iIxo).second);
	// _xZkqqHx_iDiBiDjDiDgPiBfLiDiKiDfIiDgHiCmJ_xHqqkZx_vObj_xZkqqHx_iCmMjCgMiCpAjGnPiClHiBeC_xHqqkZx_
	FCArray<FCObjDynabase*>(m_pObjList, m_lObjListSz).Assign(vObj.begin(), vObj.end());
} // FCObjGroup::InsertGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::AddGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiDePiDiLiBfLiDhGiDiBiDjDiDgPiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vAddIndex	:_xZkqqHx_jCmHiJmBiClHiCoJiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			vAddMember	:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHiJmBiClDiCoKiClNjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiCmMiNmEiMhGiOfKiCmNiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::AddGroup (longVector& vAddIndex, const ObjDynabaseVector& vAddMember)
{
	vAddIndex.clear();
	long lIndex;
	for (lIndex = 0; lIndex != vAddMember.size(); lIndex++)
		vAddIndex.push_back(GetMemberSize() + lIndex);
	InsertGroup(vAddIndex, vAddMember);
} // FCObjGroup::AddGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjGroup::EraseGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiCkJiCoHiOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjFjEjFgJiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stMemberIndex	:_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCkJiCoHjGjFiPmBiClHiCoJjFjEjFgJiCmM_xHqqkZx_
 *							 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjGroup::EraseGroup (const longSet& stMemberIndex)
{
	// vObj_xZkqqHx_iCmJiDiBiDjDiDgPiBfLiDiKiDfIiDgHiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
	ObjDynabaseVector vObj(m_pObjList, m_pObjList + m_lObjListSz);
	// vObj_xZkqqHx_iCmFiNoNiPjMiPiIjHjNiBeC_xHqqkZx_
	longSet::const_reverse_iterator rIdx;
	for (rIdx = stMemberIndex.rbegin(); rIdx != stMemberIndex.rend(); rIdx++)
		vObj.erase(vObj.begin() + (*rIdx));
	// _xZkqqHx_iDiBiDjDiDgPiBfLiDiKiDfIiDgHiCmJ_xHqqkZx_vObj_xZkqqHx_iCmMjCgMiCpAjGnPiClHiBeC_xHqqkZx_
	FCArray<FCObjDynabase*>(m_pObjList, m_lObjListSz).Assign(vObj.begin(), vObj.end());
} // FCObjGroup::EraseGroup.

