#include "stdafx.h"
#include <math.h>		// For sin,cos.
#include "UtilCoord.h"	// For mm2lg.etc.
#include "resource.h"	// For ProObjLabel.h.
#include "FoundDoc.h"	// For g_pDoc.
#include "UndoArchive.h"// For FCUndoArchive.
#include "UtilMisc.h"	// For RotateConv.FFGetCurrentTime.
#include "UtilMath.h"	// For mmroundoff.
#include "UtilGraph.h"	// For PenInit.
#include "UtilBezier.h"	// For FCMmPolyBezier.
#include "RegData.h"	// For FCRegData.
#include "RichText.h"	// For FCRichText.
#include "ProObjLabel.h"// For CFCProObjLabel.
#include "ObjLabel.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const mmetol FD_OBLB_PENMARK_WIDTH  = 5.0;
const mmetol FD_OBLB_PENMARK_HEIGHT = 5.0;
const mmetol FD_OBLB_PENMARK_OFFSET_X = -4.5;
const mmetol FD_OBLB_PENMARK_OFFSET_Y = 0.5;

const mmetol FD_PENCIL_WEIGHT = 0.1;

const DBLPoint FD_PENCIL_PICT_A[] = {
	DBLPoint(0.0, 2.0),
	DBLPoint(2.0, 0.0),
	DBLPoint(2.5, 0.5),
	DBLPoint(1.0, 2.0),
	DBLPoint(0.0, 2.0) };
const DBLPoint FD_PENCIL_PICT_B[] = {
	DBLPoint(1.0, 2.0),
	DBLPoint(2.5, 0.5),
	DBLPoint(3.5, 1.5),
	DBLPoint(2.0, 3.0),
	DBLPoint(1.0, 3.0),
	DBLPoint(1.0, 2.0) };
const DBLPoint FD_PENCIL_PICT_C[] = {
	DBLPoint(2.0, 3.0),
	DBLPoint(3.5, 1.5),
	DBLPoint(4.0, 2.0),
	DBLPoint(2.0, 4.0),
	DBLPoint(2.0, 3.0) };
const DBLPoint FD_PENCIL_PICT_D[] = {
	DBLPoint(0.0, 3.0),
	DBLPoint(0.0, 2.0),
	DBLPoint(1.0, 2.0),
	DBLPoint(1.0, 3.0),
	DBLPoint(2.0, 3.0),
	DBLPoint(2.0, 4.0),
	DBLPoint(1.0, 4.0),
	DBLPoint(0.0, 3.0) };
const DBLPoint FD_PENCIL_PICT_E[] = {
	DBLPoint(0.0, 4.0),
	DBLPoint(0.0, 3.0),
	DBLPoint(1.0, 4.0),
	DBLPoint(0.0, 4.0) };

const int FD_PENCIL_PICT_A_SZ = sizeof(FD_PENCIL_PICT_A) / sizeof(FD_PENCIL_PICT_A[0]);
const int FD_PENCIL_PICT_B_SZ = sizeof(FD_PENCIL_PICT_B) / sizeof(FD_PENCIL_PICT_B[0]);
const int FD_PENCIL_PICT_C_SZ = sizeof(FD_PENCIL_PICT_C) / sizeof(FD_PENCIL_PICT_C[0]);
const int FD_PENCIL_PICT_D_SZ = sizeof(FD_PENCIL_PICT_D) / sizeof(FD_PENCIL_PICT_D[0]);
const int FD_PENCIL_PICT_E_SZ = sizeof(FD_PENCIL_PICT_E) / sizeof(FD_PENCIL_PICT_E[0]);

const COLORREF FD_PENCIL_COL_A = FD_COLREF_WHITE;
const COLORREF FD_PENCIL_COL_B = FD_COLREF_DARK_GRAY;
const COLORREF FD_PENCIL_COL_C = FD_COLREF_GRAY;
const COLORREF FD_PENCIL_COL_D = FD_COLREF_ORANGE;
const COLORREF FD_PENCIL_COL_E = FD_COLREF_BLACK;


const DBLRect  FD_WATCH_PICT_A(0.0, 0.0, 4.0, 4.0);
const DBLPoint FD_WATCH_PICT_B[] = {
	DBLPoint(1.8, 2.1),
	DBLPoint(2.8, 2.1) };
const DBLPoint FD_WATCH_PICT_C[] = {
	DBLPoint(2.8, 2.1),
	DBLPoint(3.2, 1.9),
	DBLPoint(3.6, 2.1),
	DBLPoint(3.2, 2.3),
	DBLPoint(2.8, 2.1) };
const DBLPoint FD_WATCH_PICT_D[] = {
	DBLPoint(2.1, 2.4),
	DBLPoint(2.1, 1.1) };
const DBLPoint FD_WATCH_PICT_E[] = {
	DBLPoint(2.1, 1.1),
	DBLPoint(1.9, 0.7),
	DBLPoint(2.1, 0.3),
	DBLPoint(2.3, 0.7),
	DBLPoint(2.1, 1.1) };
const DBLPoint FD_WATCH_PICT_F[] = {
	DBLPoint(1.7, 2.0),
	DBLPoint(2.7, 2.0) };
const DBLPoint FD_WATCH_PICT_G[] = {
	DBLPoint(2.7, 2.0),
	DBLPoint(3.1, 1.8),
	DBLPoint(3.5, 2.0),
	DBLPoint(3.1, 2.2),
	DBLPoint(2.7, 2.0) };
const DBLPoint FD_WATCH_PICT_H[] = {
	DBLPoint(2.0, 2.3),
	DBLPoint(2.0, 1.0) };
const DBLPoint FD_WATCH_PICT_I[] = {
	DBLPoint(2.0, 1.0),
	DBLPoint(1.8, 0.6),
	DBLPoint(2.0, 0.2),
	DBLPoint(2.2, 0.6),
	DBLPoint(2.0, 1.0) };
const DBLRect FD_WATCH_PICT_J(0.2, 1.95, 0.7, 2.05);
const DBLRect FD_WATCH_PICT_K(1.95, 3.3, 2.05, 3.8);

const int FD_WATCH_PICT_B_SZ = sizeof(FD_WATCH_PICT_B) / sizeof(FD_WATCH_PICT_B[0]);
const int FD_WATCH_PICT_C_SZ = sizeof(FD_WATCH_PICT_C) / sizeof(FD_WATCH_PICT_C[0]);
const int FD_WATCH_PICT_D_SZ = sizeof(FD_WATCH_PICT_D) / sizeof(FD_WATCH_PICT_D[0]);
const int FD_WATCH_PICT_E_SZ = sizeof(FD_WATCH_PICT_E) / sizeof(FD_WATCH_PICT_E[0]);
const int FD_WATCH_PICT_F_SZ = sizeof(FD_WATCH_PICT_F) / sizeof(FD_WATCH_PICT_F[0]);
const int FD_WATCH_PICT_G_SZ = sizeof(FD_WATCH_PICT_G) / sizeof(FD_WATCH_PICT_G[0]);
const int FD_WATCH_PICT_H_SZ = sizeof(FD_WATCH_PICT_H) / sizeof(FD_WATCH_PICT_H[0]);
const int FD_WATCH_PICT_I_SZ = sizeof(FD_WATCH_PICT_I) / sizeof(FD_WATCH_PICT_I[0]);

const mmetol FD_WATCH_WEIGHT_A = 0.1;
const mmetol FD_WATCH_WEIGHT_B = 0.1;
const mmetol FD_WATCH_WEIGHT_C = 0.1;
const mmetol FD_WATCH_WEIGHT_D = 0.1;
const mmetol FD_WATCH_WEIGHT_E = 0.1;
const mmetol FD_WATCH_WEIGHT_F = 0.1;
const mmetol FD_WATCH_WEIGHT_G = 0.1;
const mmetol FD_WATCH_WEIGHT_H = 0.1;
const mmetol FD_WATCH_WEIGHT_I = 0.1;
const mmetol FD_WATCH_WEIGHT_J = 0.05;
const mmetol FD_WATCH_WEIGHT_K = 0.05;

const COLORREF FD_WATCH_PENCOL_A = FD_COLREF_BLACK;
const COLORREF FD_WATCH_PENCOL_B = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_PENCOL_C = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_PENCOL_D = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_PENCOL_E = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_PENCOL_F = FD_COLREF_DIM_GRAY;
const COLORREF FD_WATCH_PENCOL_G = FD_COLREF_DIM_GRAY;
const COLORREF FD_WATCH_PENCOL_H = FD_COLREF_DIM_GRAY;
const COLORREF FD_WATCH_PENCOL_I = FD_COLREF_DIM_GRAY;
const COLORREF FD_WATCH_PENCOL_J_1 = FD_COLREF_WHITE;
const COLORREF FD_WATCH_PENCOL_J_2 = FD_COLREF_BLACK;
const COLORREF FD_WATCH_PENCOL_K_1 = FD_COLREF_WHITE;
const COLORREF FD_WATCH_PENCOL_K_2 = FD_COLREF_BLACK;

const COLORREF FD_WATCH_BRUSHCOL_A = FD_COLREF_GAINS_BORO;
const COLORREF FD_WATCH_BRUSHCOL_C = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_BRUSHCOL_E = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_BRUSHCOL_G = FD_COLREF_ORANGE;
const COLORREF FD_WATCH_BRUSHCOL_I = FD_COLREF_ORANGE;
const COLORREF FD_WATCH_BRUSHCOL_J = FD_COLREF_SILVER;
const COLORREF FD_WATCH_BRUSHCOL_K = FD_COLREF_SILVER;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::FCObjLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCFoundDoc_xZkqqHx_iCmM_xHqqkZx_Stream_xZkqqHx_jDmHiCnNiNjOiCnNiOjOiCmJiBeB_xHqqkZx_FCObjLabel_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjLabel::FCObjLabel (WORD wImageType)
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjLabel, m_mmrtResize));
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	memset(&m_mmrtResize, 0, sizeof(FCObjLabel) - offsetof(FCObjLabel, m_mmrtResize));
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	m_mmrtResize = mmroundoff(DBLRect(0.0, 0.0, 30.0, 30.0));
	// _xZkqqHx_iMlLiNnNiCmMiOjOiKnEiBeC_xHqqkZx_
	m_fdtmCreateTime = 0;
	// _xZkqqHx_iClBiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHjFmPiNfIiOjOiNiPiBeC_xHqqkZx_
	m_fdtmModifyTime = 0;
//----- 01.07.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iJeFiPoDiDeDiDiBiBfLiDfHiDfOiDeDiDhGiBeC_xHqqkZx_0:_xZkqqHx_iJjEjFeNiBeB_xHqqkZx_1:_xZkqqHx_iOiGiBeB_xHqqkZx_2:_xZkqqHx_iOjOiMhGiBeC_xHqqkZx_
	m_wImageType = wImageType;
//----- 01.07.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjLabel::FCObjLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	:_xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLabel::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_LABEL) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjLabel::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjLabel::Type () const
{
	return FDOJ_LABEL;
} // FCObjLabel::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::OnDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjFgAiJoGiKnGjAjEiBeC_xHqqkZx_pDC_xZkqqHx_iCmJjBePiPiIjHjNiCpAiNhDiCkCiBeBiKgFjFjEjFgJiCmM_xHqqkZx_Draw_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMono	:_xZkqqHx_iDiCiDgNiDeOiDiNjFgAiJoGiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. bIsMono_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void FCObjLabel::OnDraw (CDC* pDC, BOOL bIsMono)
{
	if (!g_pReg->GetIsShowObjLabel()) return;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDraw(pDC, bIsMono);
	if (!bIsMono &&
		FD_OBLB_PENMARK_WIDTH <= m_mmrtResize.Width() &&
		FD_OBLB_PENMARK_HEIGHT <= m_mmrtResize.Height())
	{
//----- 01.07.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		//----- _xZkqqHx_iJeFiPoDiCmMjAnMiCoIjFnEiClFiCpAjFgAiJoG_xHqqkZx_ -----
//		CPointVector vlgptPoly(3);
//		vlgptPoly[0].x = mm2lg(m_mmrtResize.right - 4.0);
//		vlgptPoly[0].y = mm2lg(m_mmrtResize.top);
//		vlgptPoly[1].x = mm2lg(m_mmrtResize.right - 4.0);
//		vlgptPoly[1].y = mm2lg(m_mmrtResize.top + 4.0);
//		vlgptPoly[2].x = mm2lg(m_mmrtResize.right);
//		vlgptPoly[2].y = mm2lg(m_mmrtResize.top + 4.0);
//		FCDraw draw(pDC);
//		draw.PenInit(GetStdPenStyle(), GetStdPenWeight(), GetStdPenBackSColor());
//		draw.Polyline(vlgptPoly.begin(), vlgptPoly.size());
//----- 01.07.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		switch (GetImageType())
		{
		case 1:	// Note.
		  {
			//----- _xZkqqHx_iJeFiPoDiCmMjAnMiCoIjFnEiClFiCpAjFgAiJoG_xHqqkZx_ -----
			CPointVector vlgptPoly(3);
			vlgptPoly[0].x = mm2lg(m_mmrtResize.right - FD_OBLB_PENMARK_WIDTH);
			vlgptPoly[0].y = mm2lg(m_mmrtResize.top);
			vlgptPoly[1].x = mm2lg(m_mmrtResize.right - FD_OBLB_PENMARK_WIDTH);
			vlgptPoly[1].y = mm2lg(m_mmrtResize.top + FD_OBLB_PENMARK_HEIGHT);
			vlgptPoly[2].x = mm2lg(m_mmrtResize.right);
			vlgptPoly[2].y = mm2lg(m_mmrtResize.top + FD_OBLB_PENMARK_HEIGHT);
			FCDraw draw(pDC);
			draw.PenInit(GetStdPenStyle(), GetStdPenWeight(), GetStdPenBackSColor());
			draw.Polyline(vlgptPoly.begin(), vlgptPoly.size());
			break;
		  }
		case 2:	// Watch.
		  {
			FCAutoDC atDC(pDC, FALSE);
			long lC;
			const DBLPoint mmptOffset(	m_mmrtResize.right + FD_OBLB_PENMARK_OFFSET_X,
										m_mmrtResize.top + FD_OBLB_PENMARK_OFFSET_Y);

			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_A), ::OptiColor(FD_WATCH_PENCOL_A));
			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_A));
			atDC.Chord(mm2lg(FD_WATCH_PICT_A + mmptOffset), CPoint(0,0), CPoint(0,0));

			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_B), ::OptiColor(FD_WATCH_PENCOL_B));
//			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_B));
			CPoint lgpt_B[FD_WATCH_PICT_B_SZ];
			for (lC = 0; lC < FD_WATCH_PICT_B_SZ; lC++)
				lgpt_B[lC] = mm2lg(FD_WATCH_PICT_B[lC] + mmptOffset);
			atDC.Polyline(lgpt_B, FD_WATCH_PICT_B_SZ);

			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_C), ::OptiColor(FD_WATCH_PENCOL_C));
			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_C));
			CPoint lgpt_C[FD_WATCH_PICT_C_SZ];
			for (lC = 0; lC < FD_WATCH_PICT_C_SZ; lC++)
				lgpt_C[lC] = mm2lg(FD_WATCH_PICT_C[lC] + mmptOffset);
			atDC.Polygon(lgpt_C, FD_WATCH_PICT_C_SZ);

			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_D), ::OptiColor(FD_WATCH_PENCOL_D));
//			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_D));
			CPoint lgpt_D[FD_WATCH_PICT_D_SZ];
			for (lC = 0; lC < FD_WATCH_PICT_D_SZ; lC++)
				lgpt_D[lC] = mm2lg(FD_WATCH_PICT_D[lC] + mmptOffset);
			atDC.Polyline(lgpt_D, FD_WATCH_PICT_D_SZ);

			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_E), ::OptiColor(FD_WATCH_PENCOL_E));
			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_E));
			CPoint lgpt_E[FD_WATCH_PICT_E_SZ];
			for (lC = 0; lC < FD_WATCH_PICT_E_SZ; lC++)
				lgpt_E[lC] = mm2lg(FD_WATCH_PICT_E[lC] + mmptOffset);
			atDC.Polygon(lgpt_E, FD_WATCH_PICT_E_SZ);

			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_F), ::OptiColor(FD_WATCH_PENCOL_F));
//			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_F));
			CPoint lgpt_F[FD_WATCH_PICT_F_SZ];
			for (lC = 0; lC < FD_WATCH_PICT_F_SZ; lC++)
				lgpt_F[lC] = mm2lg(FD_WATCH_PICT_F[lC] + mmptOffset);
			atDC.Polyline(lgpt_F, FD_WATCH_PICT_F_SZ);

			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_G), ::OptiColor(FD_WATCH_PENCOL_G));
			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_G));
			CPoint lgpt_G[FD_WATCH_PICT_G_SZ];
			for (lC = 0; lC < FD_WATCH_PICT_G_SZ; lC++)
				lgpt_G[lC] = mm2lg(FD_WATCH_PICT_G[lC] + mmptOffset);
			atDC.Polygon(lgpt_G, FD_WATCH_PICT_G_SZ);

			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_H), ::OptiColor(FD_WATCH_PENCOL_H));
//			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_H));
			CPoint lgpt_H[FD_WATCH_PICT_H_SZ];
			for (lC = 0; lC < FD_WATCH_PICT_H_SZ; lC++)
				lgpt_H[lC] = mm2lg(FD_WATCH_PICT_H[lC] + mmptOffset);
			atDC.Polyline(lgpt_H, FD_WATCH_PICT_H_SZ);

			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_I), ::OptiColor(FD_WATCH_PENCOL_I));
			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_I));
			CPoint lgpt_I[FD_WATCH_PICT_I_SZ];
			for (lC = 0; lC < FD_WATCH_PICT_I_SZ; lC++)
				lgpt_I[lC] = mm2lg(FD_WATCH_PICT_I[lC] + mmptOffset);
			atDC.Polygon(lgpt_I, FD_WATCH_PICT_I_SZ);

			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_J));
			atDC.FillRect(mm2lg(FD_WATCH_PICT_J + mmptOffset), FCAtBrush(::OptiColor(FD_WATCH_BRUSHCOL_J)));
			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_J), ::OptiColor(FD_WATCH_PENCOL_J_1));
			atDC.MoveTo(mm2lg(DBLPoint(FD_WATCH_PICT_J.left, FD_WATCH_PICT_J.bottom) + mmptOffset));
			atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_J.left, FD_WATCH_PICT_J.top) + mmptOffset));
			atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_J.right, FD_WATCH_PICT_J.top) + mmptOffset));
			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_J), ::OptiColor(FD_WATCH_PENCOL_J_2));
			atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_J.right, FD_WATCH_PICT_J.bottom) + mmptOffset));
			atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_J.left, FD_WATCH_PICT_J.bottom) + mmptOffset));

			atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_K));
			atDC.FillRect(mm2lg(FD_WATCH_PICT_K + mmptOffset), FCAtBrush(::OptiColor(FD_WATCH_BRUSHCOL_K)));
			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_K), ::OptiColor(FD_WATCH_PENCOL_K_1));
			atDC.MoveTo(mm2lg(DBLPoint(FD_WATCH_PICT_K.left, FD_WATCH_PICT_K.bottom) + mmptOffset));
			atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_K.left, FD_WATCH_PICT_K.top) + mmptOffset));
			atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_K.right, FD_WATCH_PICT_K.top) + mmptOffset));
			atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_K), ::OptiColor(FD_WATCH_PENCOL_K_2));
			atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_K.right, FD_WATCH_PICT_K.bottom) + mmptOffset));
			atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_K.left, FD_WATCH_PICT_K.bottom) + mmptOffset));

			break;
		  }

		case 0:	// Pencil.
		default:
		  {
			//----- _xZkqqHx_iJeFiPoDiCmMiDhJiDjDiCpAjFgAiJoG_xHqqkZx_ -----
			FCAutoDC atDC(pDC, FALSE);
			atDC.SetPen(PS_SOLID, mm2lg(FD_PENCIL_WEIGHT), ::OptiColor(FD_COLREF_BLACK));
			long lC;
			atDC.SetBrush(::OptiColor(FD_PENCIL_COL_A));
			CPoint lgptA[FD_PENCIL_PICT_A_SZ];
			for (lC = 0; lC < FD_PENCIL_PICT_A_SZ; lC++)
				lgptA[lC] = mm2lg(DBLPoint(	m_mmrtResize.right + FD_OBLB_PENMARK_OFFSET_X +
											FD_PENCIL_PICT_A[lC].x,
											m_mmrtResize.top + FD_OBLB_PENMARK_OFFSET_Y +
											FD_PENCIL_PICT_A[lC].y));
			atDC.Polygon(lgptA, FD_PENCIL_PICT_A_SZ);

			atDC.SetBrush(::OptiColor(FD_PENCIL_COL_B));
			CPoint lgptB[FD_PENCIL_PICT_B_SZ];
			for (lC = 0; lC < FD_PENCIL_PICT_B_SZ; lC++)
				lgptB[lC] = mm2lg(DBLPoint(	m_mmrtResize.right + FD_OBLB_PENMARK_OFFSET_X +
											FD_PENCIL_PICT_B[lC].x,
											m_mmrtResize.top + FD_OBLB_PENMARK_OFFSET_Y +
											FD_PENCIL_PICT_B[lC].y));
			atDC.Polygon(lgptB, FD_PENCIL_PICT_B_SZ);

			atDC.SetBrush(::OptiColor(FD_PENCIL_COL_C));
			CPoint lgptC[FD_PENCIL_PICT_C_SZ];
			for (lC = 0; lC < FD_PENCIL_PICT_C_SZ; lC++)
				lgptC[lC] = mm2lg(DBLPoint(	m_mmrtResize.right + FD_OBLB_PENMARK_OFFSET_X +
											FD_PENCIL_PICT_C[lC].x,
											m_mmrtResize.top + FD_OBLB_PENMARK_OFFSET_Y +
											FD_PENCIL_PICT_C[lC].y));
			atDC.Polygon(lgptC, FD_PENCIL_PICT_C_SZ);

			atDC.SetBrush(::OptiColor(FD_PENCIL_COL_D));
			CPoint lgptD[FD_PENCIL_PICT_D_SZ];
			for (lC = 0; lC < FD_PENCIL_PICT_D_SZ; lC++)
				lgptD[lC] = mm2lg(DBLPoint(	m_mmrtResize.right + FD_OBLB_PENMARK_OFFSET_X +
											FD_PENCIL_PICT_D[lC].x,
											m_mmrtResize.top + FD_OBLB_PENMARK_OFFSET_Y +
											FD_PENCIL_PICT_D[lC].y));
			atDC.Polygon(lgptD, FD_PENCIL_PICT_D_SZ);

			atDC.SetBrush(::OptiColor(FD_PENCIL_COL_E));
			CPoint lgptE[FD_PENCIL_PICT_E_SZ];
			for (lC = 0; lC < FD_PENCIL_PICT_E_SZ; lC++)
				lgptE[lC] = mm2lg(DBLPoint(	m_mmrtResize.right + FD_OBLB_PENMARK_OFFSET_X +
											FD_PENCIL_PICT_E[lC].x,
											m_mmrtResize.top + FD_OBLB_PENMARK_OFFSET_Y +
											FD_PENCIL_PICT_E[lC].y));
			atDC.Polygon(lgptE, FD_PENCIL_PICT_E_SZ);
			break;
		  }
		}
//----- 01.07.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // FCObjLabel::OnDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jCgMiCmMjAlDiKgNiClDiCmGiOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCObjLabel::GetResizeFrame () const
{
	return m_mmrtResize;
} // FCObjLabel::GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLabel::IsEqual (const FCObjDynabase* objp) const
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjLabel, m_mmrtResize));
	const FCObjLabel* trgp = static_cast<const FCObjLabel*>(objp);
	return (memcmp(&m_mmrtResize, &trgp->m_mmrtResize,
				sizeof(FCObjLabel) - offsetof(FCObjLabel, m_mmrtResize)) == 0);
} // FCObjLabel::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjLabel::OutStream (FCUndoArchive& ar)
void FCObjLabel::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	ar << m_mmrtResize;		// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	ar << m_fdtmCreateTime;	// _xZkqqHx_iClBiCmMjFjEjFgJiCmMjDgPjIfOiOjOiNiPiBeC_xHqqkZx_
	ar << m_fdtmModifyTime;	// _xZkqqHx_iClBiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHjFmPiNfIiOjOiNiPiBeC_xHqqkZx_
//----- 01.07.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	ar << m_wImageType;		// _xZkqqHx_iJeFiPoDiDeDiDiBiBfLiDfHiDfOiDeDiDhGiBeC_xHqqkZx_0:_xZkqqHx_iJjEjFeNiBeB_xHqqkZx_1:_xZkqqHx_iOiGiBeB_xHqqkZx_2:_xZkqqHx_iOjOiMhGiBeC_xHqqkZx_
//----- 01.07.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjLabel::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::InStream (FCUndoArchive& ar)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::InStream(ar);
	ar >> m_mmrtResize;		// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiA_xHqqkZx_.
	ar >> m_fdtmCreateTime;	// _xZkqqHx_iClBiCmMjFjEjFgJiCmMjDgPjIfOiOjOiNiPiBeC_xHqqkZx_
	ar >> m_fdtmModifyTime;	// _xZkqqHx_iClBiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHjFmPiNfIiOjOiNiPiBeC_xHqqkZx_
//----- 01.07.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	ar >> m_wImageType;		// _xZkqqHx_iJeFiPoDiDeDiDiBiBfLiDfHiDfOiDeDiDhGiBeC_xHqqkZx_0:_xZkqqHx_iJjEjFeNiBeB_xHqqkZx_1:_xZkqqHx_iOiGiBeB_xHqqkZx_2:_xZkqqHx_iOjOiMhGiBeC_xHqqkZx_
//// _xZkqqHx_iImIiJlKiCmNiDfCiDjDiDgPiBfLiDfOjHhAiBeC_xHqqkZx_
//	m_wImageType = 1;		// _xZkqqHx_iJeFiPoDiDeDiDiBiBfLiDfHiDfOiDeDiDhGiBeC_xHqqkZx_
//----- 01.07.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjLabel::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::CreatePropertyPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiMmFjHeMiCmM_xHqqkZx_PropertyPage_xZkqqHx_iCpAiNoMjAkMiBeFiPiJiKpKiJlLiClFiBeBiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	:PropertyPage_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiInHiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			vSelect		:_xZkqqHx_jBeJjBpAjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::CreatePropertyPage (CPropertyPageVector& vPropPage,
											const ObjDynabaseVector& vSelect)
{
	BASE_CLASS::CreatePropertyPage(vPropPage, vSelect);
	ObjDynabaseVector::const_iterator i;
	for (i = vSelect.begin(); i != vSelect.end(); i++)
		if (!(*i)->IsKindOf(FDOJ_LABEL)) return;
	vPropPage.push_back(new CFCProObjLabel());
} // FCObjLabel::CreatePropertyPage.

//----- 01.11.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::IsClosePolygon
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	NewObjPolygon_xZkqqHx_iCkKjFnEiClHiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjLabel::IsClosePolygon () const
//{
//	return TRUE;
//} // FCObjLabel::IsClosePolygon.
//----- 01.11.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::NewObjPolygonForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOmAiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClH_xHqqkZx_.
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiH_xHqqkZx_.
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmElemLen_xZkqqHx_iCmNiBeBjClIjDfPiNmAjFfHiCpAiMhGiOfKiClHiCoJiOjOiCmJiBeBjHnHiCoIiNiHiCkEjClIjDfPiCmGjClIjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_mmElemLen_xZkqqHx_iCmMjCgMiCkKiPkMiClDiCkCiCnJiCmHjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iLjHjHkDiCmNiLlHiCnMiCoIjAhNiMgAiCmMjAlIjDhIiCmNiMpMiPoDiClHiCoJiCkKiBeBiCoGiCoIjBlNiCkNiCmMiMhGiOfKiOjOiKnEiCmG_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIjBlNiCkNiCmMiDiBiDiCiDiKiCpAjFeLjHhGiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmpPoint_xZkqqHx_iCmN_xHqqkZx_delete[]_xZkqqHx_iCmFiKeKjFpKiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::NewObjPolygonForDraw (DBLPointVector& vmmptPoly,
								mmetol mmElemLen,
								const DBLRect mmrtaClip[], int iClipSize) const
{
	DBLRect mmrtInn = GetResizeFrame();

	if (FD_OBLB_PENMARK_WIDTH <= mmrtInn.Width() &&
		FD_OBLB_PENMARK_HEIGHT <= mmrtInn.Height())
	{
		switch (GetImageType())
		{
		case 1:	// Note.
			vmmptPoly.resize(6);
			vmmptPoly[0].SetPoint(mmrtInn.left, mmrtInn.top);
			vmmptPoly[1].SetPoint(mmrtInn.right - FD_OBLB_PENMARK_WIDTH, mmrtInn.top);
			vmmptPoly[2].SetPoint(mmrtInn.right, mmrtInn.top + FD_OBLB_PENMARK_HEIGHT);
			vmmptPoly[3].SetPoint(mmrtInn.right, mmrtInn.bottom);
			vmmptPoly[4].SetPoint(mmrtInn.left, mmrtInn.bottom);
			vmmptPoly[5].SetPoint(mmrtInn.left, mmrtInn.top);
			break;
		case 0:	// Pencil.
		default:
			vmmptPoly.resize(5);
			mmrtInn.Get5Polygon(vmmptPoly.begin());
			break;
		}
	} else
	{
		vmmptPoly.resize(5);
		mmrtInn.Get5Polygon(vmmptPoly.begin());
	}
} // FCObjLabel::NewObjPolygonForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::NewObjBezierForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	: _xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJjFgAiJoGjDjJiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::NewObjBezierForDraw (FCMmPolyBezier& polyBezier) const
{
	DBLRect mmrtInn = GetResizeFrame();
	polyBezier.clear();
	polyBezier.SetIsBezier(TRUE);
	if (FD_OBLB_PENMARK_WIDTH <= mmrtInn.Width() &&
		FD_OBLB_PENMARK_HEIGHT <= mmrtInn.Height())
	{
		switch (GetImageType())
		{
		case 1:	// Note.
			polyBezier.push_back(DBLPoint(mmrtInn.left, mmrtInn.top));		// A.
			polyBezier.push_back(DBLPoint(mmrtInn.left, mmrtInn.top));		// B.

			polyBezier.push_back(DBLPoint(mmrtInn.right - FD_OBLB_PENMARK_WIDTH, mmrtInn.top));		// C.
			polyBezier.push_back(DBLPoint(mmrtInn.right - FD_OBLB_PENMARK_WIDTH, mmrtInn.top));		// A.
			polyBezier.push_back(DBLPoint(mmrtInn.right - FD_OBLB_PENMARK_WIDTH, mmrtInn.top));		// B.

			polyBezier.push_back(DBLPoint(mmrtInn.right, mmrtInn.top + FD_OBLB_PENMARK_HEIGHT));	// C.
			polyBezier.push_back(DBLPoint(mmrtInn.right, mmrtInn.top + FD_OBLB_PENMARK_HEIGHT));	// A.
			polyBezier.push_back(DBLPoint(mmrtInn.right, mmrtInn.top + FD_OBLB_PENMARK_HEIGHT));	// B.

			polyBezier.push_back(DBLPoint(mmrtInn.right, mmrtInn.bottom));	// C.
			polyBezier.push_back(DBLPoint(mmrtInn.right, mmrtInn.bottom));	// A.
			polyBezier.push_back(DBLPoint(mmrtInn.right, mmrtInn.bottom));	// B.

			polyBezier.push_back(DBLPoint(mmrtInn.left, mmrtInn.bottom));	// C.
			polyBezier.push_back(DBLPoint(mmrtInn.left, mmrtInn.bottom));	// A.
			polyBezier.push_back(DBLPoint(mmrtInn.left, mmrtInn.bottom));	// B.

			polyBezier.push_back(DBLPoint(mmrtInn.left, mmrtInn.top));		// C.
			polyBezier.push_back(DBLPoint(mmrtInn.left, mmrtInn.top));		// D.
			break;
		case 0:	// Pencil.
		default:
			polyBezier.assign(13);
			mmrtInn.Get5Bezier(&polyBezier.front());
			break;
		}
	} else
	{
		polyBezier.assign(13);
		mmrtInn.Get5Bezier(&polyBezier.front());
	}
} // FCObjLabel::NewObjBezierForDraw.

//----- 05.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::IsSamePolygonForText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	NewObjPolygonForText _xZkqqHx_iCmG_xHqqkZx_ NewObjPolygon _xZkqqHx_iCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	NewObjPolygonForText _xZkqqHx_iCmG_xHqqkZx_ NewObjPolygon _xZkqqHx_iCpAjDkPiOjOiCmJjFeLjHhGiCmGiClHiCoJiPoKiNiHiBeB_xHqqkZx_
// *			_xZkqqHx_jHfNiMhGiCmIiMhGiOfKiCpAjEpAiCkPiCoJiClNiCnPiCmJiOgHjHhAiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjLabel::IsSamePolygonForText () const
//{
//	return FALSE;
//} // FCObjLabel::IsSamePolygonForText.
//----- 05.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::NewObjPolygonForText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDiMiDeDiDeBiDeFiDgHjHhAiCmMjAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOmAiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiDiMiDeDiDeBiDeFiDgHiClHiCoJiNnLiCmJjHjIjHhAiClHiCoJiDhMiDiKiDfDiDjDiCpAjAlGjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::NewObjPolygonForText (DBLPointVector& vmmptPoly,
								mmetol mmElemLen,
								const DBLRect mmrtaClip[], int iClipSize) const
{
	vmmptPoly.assign(7);
	vmmptPoly[0].SetPoint(	m_mmrtResize.left, m_mmrtResize.top);
	vmmptPoly[1].SetPoint(	m_mmrtResize.right - FD_OBLB_PENMARK_WIDTH,
							m_mmrtResize.top);
	vmmptPoly[2].SetPoint(	m_mmrtResize.right - FD_OBLB_PENMARK_WIDTH,
							m_mmrtResize.top + FD_OBLB_PENMARK_HEIGHT);
	vmmptPoly[3].SetPoint(	m_mmrtResize.right,
							m_mmrtResize.top + FD_OBLB_PENMARK_HEIGHT);
	vmmptPoly[4].SetPoint(	m_mmrtResize.right,  m_mmrtResize.bottom);
	vmmptPoly[5].SetPoint(	m_mmrtResize.left,  m_mmrtResize.bottom);
	vmmptPoly[6].SetPoint(	m_mmrtResize.left,  m_mmrtResize.top);
} // FCObjLabel::NewObjPolygonForText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::NewObjPolygonForResize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJjHhAiCmMiDhMiDiKiDiJiDeDiDjDiNoMjAkMiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiDhEiDiMiBfLiDiAjFgAiJoGiCmGiBeBjFjEjFgJiDfEiDeDiDfJiMhGiOfKiOjOiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiCoGiCkEiCmJjFkBjAjEiCmMjFjEjFgJiCmMiPfHiNiHiCmMiPoKiNiHiBeB_xHqqkZx_DBL_MAX_xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iLoGjAnIiCoHiCoKiClNjFkBjAjEiCmMiDhMiDiKiDiJiDeDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::NewObjPolygonForResize (	DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const
{
	vmmptPoly.resize(5);
	GetResizeFrame().Get5Polygon(vmmptPoly.begin());
} // FCObjLabel::NewObjPolygonForResize.

//----- 01.07.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::IsResizable
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	:X_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
// *			bYPosi	:Y_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
// *			mmrtNew	:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfHiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfM_xHqqkZx_
// *			FALSE	:_xZkqqHx_iDiKiDfEiDeDiDfJjFhDiJmCjEfM_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjLabel::IsResizable (BOOL bXPosi, BOOL bYPosi,
//								const DBLRect& mmrtNew) const
//{
//	if (mmrtNew.Width() <= 5 || mmrtNew.Height() <= 5) return FALSE;
//	return TRUE;
//} // FCObjLabel::IsResizable.
//----- 01.07.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::CanRotate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpBjDfNiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCkKiJpBjDfNiClFiCmEiCkCiCoJiPoKiNiHiCmMiBeBiOkJjDkOiDiKiDfEiDeDiDfJiCmMiPiIjHjNiCmFiBeBiClBiCmMiKnGjAjEiCkK_xHqqkZx_
// *			_xZkqqHx_iOgHiCoNiCoKiCoJiClNiCnPiBeBjAlDiClFiCkNjCgMiCpAjFnEiClHjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjLabel::CanRotate () const
//{
//	return FALSE;
//} // FCObjLabel::CanRotate.
//----- 05.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::IsIntersect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDfPiCkKjFjEjFgJjDoAiCmJiMpAiCoNiCmBiCmEiCkCiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpt	: _xZkqqHx_iOhHjCoIiClDiCoKiClNjDfP_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_
// *			FALSE	: _xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjLabel::IsIntersect (const DBLPoint& mmpt) const
//{
//	if (!g_pReg->GetIsShowObjLabel()) return FALSE;
//	return BASE_CLASS::IsIntersect(mmpt);
//} // FCObjLabel::IsIntersect.
//----- 06.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::GetIntersect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDfPiCkKiMpAiCoNiCmBiCmEiCkCiCoJjFjEjFgJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsHitEditText	:_xZkqqHx_jFnCiPfHiJmCjEfMiCmIiDgFiDeMiDfIiDgHiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *							 _xZkqqHx_jEhHiMgJiDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lHitCharIndex	:_xZkqqHx_iDhBiDgCiDgHiClFiClNjFlGiOjKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsHitCharFront	:_xZkqqHx_jFlGiOjKiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiBeBjFlGiOjKiCmMjBePjElMiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *							 _xZkqqHx_iMoDjElMiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsCheckText	:_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiCkJiBeI_xHqqkZx_
 *			mmptMargin		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiDgAiDeGiDgCiDeOiClHiCoJjBmOiPnLiCmMiBeBjFlGiOjKiCmMiLoJiMgAiCpA_xHqqkZx_
 *							 _xZkqqHx_iNeMiClAiCoJiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt			:_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJjClCiCnHiCoJiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiCoNiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeBjFjEjFgJiCpAjFnEiClHiBeCiMpAiCoNiCmBiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmNiBeBiDgFiDeMiDfIiDgHiCpAjHeEjAoGiClFiCmEjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgFiDeMiDfIiDgHiCmJiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmNiBeBjEhHiMgJiCmJiDhBiDgCiDgHiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.01 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCObjLabel::GetIntersect (	BOOL& bIsHitEditText,
											long& lHitCharIndex,
											BOOL& bIsHitCharFront,
// 06.04.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//											BOOL bIsCheckText,
											const DBLPoint& mmptMargin,
											const DBLPoint& mmpt,
											BOOL bAsFillPaint) const
{
	// _xZkqqHx_jEpBjFfMiOkGiPpDjBnEiCmIiCoHiCmO_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
	if (!g_pReg->GetIsShowObjLabel()) return NULL;
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::GetIntersect(bIsHitEditText,
									lHitCharIndex,
									bIsHitCharFront,
// 06.04.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//									bIsCheckText,
									mmptMargin,
									mmpt,
									bAsFillPaint);
} // FCObjLabel::GetIntersect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::IsObjInRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiLoJiMgAjDoAiCmJjFjEjFgJiCkKjDpMiCmBiCmEiCkCiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrt	:_xZkqqHx_iOhHjCoIiClDiCoKiClNiLoJiMgA_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_
 *			FALSE	:_xZkqqHx_jDpMiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLabel::IsObjInRect (const DBLRect& mmrt) const
{
	if (!g_pReg->GetIsShowObjLabel()) return FALSE;
	return BASE_CLASS::IsObjInRect(mmrt);
} // FCObjLabel::IsObjInRect (const DBLRect& mmrt) const.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::IsPtInOuterFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiNmAjFfHiCkKiBeBiDeBiDeFiDfOiBfLiDhEiDiMiBfLiDiAjCiGiCmJjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMsc	:_xZkqqHx_jClCiCnHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmExt	:_xZkqqHx_jClCiCnHiCoJiNnLiCmJiBeBiDeBiDeFiDfOiBfLiDhEiDiMiBfLiDiAiCpAiKgHjCkDiClHiCoJiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCiGiCmJjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLabel::IsPtInOuterFrame (const DBLPoint& mmptMsc, mmetol mmExt) const
{
	if (!g_pReg->GetIsShowObjLabel()) return FALSE;
	return BASE_CLASS::IsPtInOuterFrame(mmptMsc, mmExt);
} // FCObjLabel::IsPtInOuterFrame.

//----- 05.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::CalcResizeFrameSelf
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCObjLabel::CalcResizeFrameSelf ()
//{
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiBeC_xHqqkZx_
//	if (GetRichText() != NULL)
//	{
////----- 05.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		DBLPointVector vmmptPoly;
////		// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
////		NewObjPolygonForText(vmmptPoly, FFGetStdElemLen(), NULL, 0);
////		m_pRichText->CalcTextLayout(NULL, vmmptPoly.begin(), vmmptPoly.size());
////----- 05.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiBeC_xHqqkZx_
//		GetRichText()->CalcTextLayout(NULL, this);
////----- 05.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	}
//} // FCObjLabel::CalcResizeFrameSelf.
//----- 05.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::GetLabelCtime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiNoMjAkMiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_FILETIME_xZkqqHx_jCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FDTIME& FCObjLabel::GetLabelCtime () const
{
	return m_fdtmCreateTime;
} // FCObjLabel::GetLabelCtime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::GetLabelMtime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDgFiDeMiDfIiDgHjFmPiNfIiOjOiNiPiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiBeC_xHqqkZx_FILETIME_xZkqqHx_jCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FDTIME& FCObjLabel::GetLabelMtime () const
{
	return m_fdtmModifyTime;
} // FCObjLabel::GetLabelMtime.

//----- 05.07.05 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::GetLabelCtimeString
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiNoMjAkMiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iNoMjAkMiOjOiKnEiCmMjFlGiOjKjHpBiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FCObjLabel::GetLabelCtimeString () const
//{
//	return TStrToWStr(COleDateTime(FdtimeToFiletime(GetLabelCtime())).Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
//} // FCObjLabel::GetLabelCtimeString.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::GetLabelMtimeString
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDgFiDeMiDfIiDgHjFmPiNfIiOjOiNiPiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iNfIjAfGiOjOiKnEiCmMjFlGiOjKjHpBiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FCObjLabel::GetLabelMtimeString () const
//{
//	return TStrToWStr(COleDateTime(FdtimeToFiletime(GetLabelMtime())).Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
//} // FCObjLabel::GetLabelMtimeString.
//----- 05.07.05 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::GetImageType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiPoDiDeDiDiBiBfLiDfHiDfOiDeDiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *			0:_xZkqqHx_iJjEjFeNiBeB_xHqqkZx_1:_xZkqqHx_iOiGiBeB_xHqqkZx_2:_xZkqqHx_iOjOiMhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCObjLabel::GetImageType () const
{
	return m_wImageType;
} // FCObjLabel::GetImageType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjLabel::CopySelf(pObj);
} // FCObjLabel::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjLabel::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjLabel, m_mmrtResize));
	FCObjLabel* pLabel = reinterpret_cast<FCObjLabel*>(pObj);
	memcpy(&pLabel->m_mmrtResize, &m_mmrtResize,
			sizeof(FCObjLabel) - offsetof(FCObjLabel, m_mmrtResize));
} // FCObjLabel::CopySelf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::Move
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiInKjDkOiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDX	:_xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *			mmDY	:_xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_Y_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *************************************************************************/
void FCObjLabel::Move (mmetol mmDX, mmetol mmDY)
{
	m_mmrtResize += DBLPoint(mmDX, mmDY);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Move(mmDX, mmDY);
} // FCObjLabel::Move.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::Resize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmNiBeBiDfEiDeDiDfJiCkKiCmIiCoJiCnHiCkNjAlDiKgNiCmJ_xHqqkZx_mmrtNew_xZkqqHx_iCmJiCmIiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	:X_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			bYPosi	:Y_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			mmrtNew	:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfH_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P223,P224,P225
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld)
{
	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmrtResize = mmrtNew;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Resize(bXPosi, bYPosi, mmrtNew, mmrtOld);
}	// FCObjLabel::Resize.

//----- 05.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::Rotate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR		:_xZkqqHx_iJpBjDfNiClDiClJiCoJiKhAjDhIiBeC_xHqqkZx_-2.0 < dR < 2.0.
// *			mmCX	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
// *			mmCX	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCObjLabel::Rotate (double dR, mmetol mmCX, mmetol mmCY)
//{
//	//----- m_mmrtResize_xZkqqHx_iCmNiBeBiJpBjDfNiCmJiCkAiCoNiClJiCmEiImKjChFiCpAiInKjDkOiClHiCoJiClOiCkP_xHqqkZx_ -----
//	DBLPoint mmptNew = m_mmrtResize.CenterPoint();
//	RotateConv(mmptNew, sin(dR * M_PI), cos(dR * M_PI), mmCX, mmCY);
//	// _xZkqqHx_iInKjDkOiLjHjHkDiBeC_xHqqkZx_
//	const DBLPoint mmptMove = mmptNew - m_mmrtResize.CenterPoint();
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCpAiInKjDkOiBeC_xHqqkZx_
//	m_mmrtResize += mmptMove;
//	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiJpBjDfNiCmJiCkAiCoNiClJiCmEiNmEjEhKjChF_xHqqkZx_ -----
//	if (m_pRichText != NULL)
//	{
////----- 03.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		DBLPointVector vmmptPoly;
////		// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
////		NewObjPolygonForText(vmmptPoly, FFGetStdElemLen(), NULL, 0);
////		m_pRichText->CalcTextLayout(vmmptPoly.begin(), vmmptPoly.size());
////----- 03.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		m_pRichText->SetTextRect(m_pRichText->GetTextRect() + mmptMove);
////----- 03.07.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	}
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiJpBjDfNiCpAjGgIiCkOiClNiCnPiCmJiBeB_xHqqkZx_Superclass::Rotate_xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_
//} // FCObjLabel::Rotate.
//----- 05.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::RegisterObjID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJjDgPjIfOiPiIjHjNiBeCjFjEjFgJjAlGjAkMiMoDiBeB_xHqqkZx_InStream_xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiPoKiNiHiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::RegisterObjID ()
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::RegisterObjID();
	// _xZkqqHx_iMlLiNnNiCmMiOjOiKnEiCpAiOoGjDlOiBeC_xHqqkZx_
	m_fdtmCreateTime = FFGetCurrentTime();
	m_fdtmModifyTime = m_fdtmCreateTime;
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmJiDiJiDhIiDiLjFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
// 06.04.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	g_pDoc->RegisterObjLabel(this);
	g_pDoc->RegisterObjLabel(GetObjID());
} // FCObjLabel::RegisterObjID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::RegisterObjForceID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiCgIiCgDiCpAjDgPjIfOiClHiCoJiBeCiClBiCmMjFjEjFgJiCmJjFhEiCkPiCoHiCoKiCmEiCkCiCoJiCgIiCgDiOkJjAgHiCpA_xHqqkZx_
 *			_xZkqqHx_iLkNjAkHjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmGiDgAiDgCiDhGiCmMjDgPjIfOiKnGiMfHiCmFiClBiCmMiKnGjAjEiCpAjAfGjAnNiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::RegisterObjForceID ()
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::RegisterObjForceID();
//----- 01.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMiOjOiKnEiCpAiOoGjDlOiBeC_xHqqkZx_
//	m_fdtmCreateTime = FFGetCurrentTime();
//	m_fdtmModifyTime = m_fdtmCreateTime;
//----- 01.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iMlLiNnNiCmMiOjOiKnEiCmNiPjBiCkLiKlHiCkGiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiKnGjAjEiCkKiMmEiCmOiCoKiCoJiCmMiCmNiBeB_xHqqkZx_Redo/Undo_xZkqqHx_iOjOiBeBiDhEiDeAiDeDiDiLiCmMjDmHiCnNiNjOiCnNiOjOiCmIiCmHiBeB_xHqqkZx_
	// _xZkqqHx_iOjOiKnEiPoOjFpBiCoAjDmHiCnNiNjOiCnMiCoKiCoJiPoKiNiHiCmIiCmMiCmFiBeC_xHqqkZx_
//----- 01.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmJiDiJiDhIiDiLjFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
// 06.04.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	g_pDoc->RegisterObjLabel(this);
	g_pDoc->RegisterObjLabel(GetObjID());
} // FCObjLabel::RegisterObjForceID ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::UnregisterObjID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJiPiIjHjNiBeC_xHqqkZx_delete_xZkqqHx_jBePiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::UnregisterObjID ()
{
//----- 06.04.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkJiCoHiDiJiDhIiDiLjFjEjFgJiCmMjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
	// Superclass_xZkqqHx_iKnGjAjEjBePiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJiCkEiClPiCmJjGjFiPmBiClHiCoJiBeC_xHqqkZx_
	g_pDoc->UnregisterObjLabel(GetObjID());
//----- 06.04.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::UnregisterObjID();
	//----- _xZkqqHx_iMlLiNnNiCmMiOjOiKnEiCpAiJpAiPjM_xHqqkZx_ -----
	m_fdtmCreateTime = 0;
	m_fdtmModifyTime = 0;
} // FCObjLabel::UnregisterObjID.

//----- 01.07.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::NewArrowedObjPolygon
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCoAiNgMjHlGiClFiClNiDhMiDiKiDfDiDjDiOoGjDlOiKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vlgptPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *			bIsClose	:_xZkqqHx_jFmCiClGiClNiDhMiDiKiDfDiDjDiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *			pArrowF		:_xZkqqHx_jGoOiIpDiCkKiCkAiCoJiPoKiNiHiCmNiBeBiNoMjAkMiBjFiPiJiKpKiJlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *			pArrowB		:_xZkqqHx_jGoOiIpDiCkKiCkAiCoJiPoKiNiHiCmNiBeBiNoMjAkMiBjFiPiJiKpKiJlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *			bIsWidePoly	:WidePoly_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
// *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *			mmrtaClip	: _xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			iClipSize	: mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *			01.07.16 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
// *************************************************************************/
//void FCObjLabel::NewArrowedObjPolygon (DBLPointVector& vmmptPoly, BOOL& bIsClose,
//										FCBaseArrow*& pArrowF, FCBaseArrow*& pArrowB,
//										BOOL& bIsWidePoly, mmetol mmElemLen,
//										const DBLRect mmrtaClip[], int iClipSize) const
//{
//	// NewObjPolygon_xZkqqHx_iCmGiIoBiCkCiBeBiJeFiPoDiCmMiMiHiCkPiClNjFjEjFkKiCmMiMgAiPpDiCmNiKePjBkEiCpAiMhGiOfKiBeC_xHqqkZx_
//	DBLRect mmrtInn = GetResizeFrame();
//
//	if (FD_OBLB_PENMARK_WIDTH <= mmrtInn.Width() &&
//		FD_OBLB_PENMARK_HEIGHT <= mmrtInn.Height())
//	{
//		switch (GetImageType())
//		{
//		case 1:	// Note.
//			vmmptPoly.resize(6);
//			vmmptPoly[0].SetPoint(mmrtInn.left, mmrtInn.top);
//			vmmptPoly[1].SetPoint(mmrtInn.right - FD_OBLB_PENMARK_WIDTH, mmrtInn.top);
//			vmmptPoly[2].SetPoint(mmrtInn.right, mmrtInn.top + FD_OBLB_PENMARK_HEIGHT);
//			vmmptPoly[3].SetPoint(mmrtInn.right, mmrtInn.bottom);
//			vmmptPoly[4].SetPoint(mmrtInn.left, mmrtInn.bottom);
//			vmmptPoly[5].SetPoint(mmrtInn.left, mmrtInn.top);
//			break;
//		case 0:	// Pencil.
//		default:
//			vmmptPoly.resize(5);
//			mmrtInn.Get5Polygon(vmmptPoly.begin());
//			break;
//		}
//	} else
//	{
//		vmmptPoly.resize(5);
//		mmrtInn.Get5Polygon(vmmptPoly.begin());
//	}
//	bIsClose = IsClosePolygon();
//	bIsWidePoly = FALSE;
//} // FCObjLabel::NewArrowedObjPolygon.
//----- 01.07.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::SetLabelMtime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDgFiDeMiDfIiDgHjFmPiNfIiOjOiNiPiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::SetLabelMtime (const FDTIME& fdtmLabelMtime)
{
	m_fdtmModifyTime = fdtmLabelMtime;
} // FCObjLabel::SetLabelMtime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLabel::SetImageType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiPoDiDeDiDiBiBfLiDfHiDfOiDeDiDhGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wType	:_xZkqqHx_iDeDiDiBiBfLiDfHiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_0:_xZkqqHx_iJjEjFeNiBeB_xHqqkZx_1:_xZkqqHx_iOiGiBeB_xHqqkZx_2:_xZkqqHx_iOjOiMhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLabel::SetImageType (WORD wType)
{
	m_wImageType = wType;
} // FCObjLabel::SetImageType.
