#include "stdafx.h"
#include "UndoArchive.h"	// For FCUndoArchive.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMisc.h"			// For RotateConv.
#include "UtilGraph.h"		// For FCAutoDC.
#include "ObjPoint.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::FCObjPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_FDFoundDoc_xZkqqHx_iCmM_xHqqkZx_InStream_xZkqqHx_iCmFjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_jFmPjAjEiCmMiPiJiKpKiJlLiCpAjCmHiJmB_xHqqkZx_.Tool_xZkqqHx_iCmFjAlGjAkMiClDiCoKiClNiOjOiCmMiInH_xHqqkZx_.
 *************************************************************************/
FCObjPoint::FCObjPoint ()
{
	// m_mmptPoint_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjPoint, m_mmptPoint));
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	memset(&m_mmptPoint, 0, sizeof(FCObjPoint) - offsetof(FCObjPoint, m_mmptPoint));

	m_mmptPoint = DBLPoint(0, 0);
	m_bIsVisible = FALSE;	// _xZkqqHx_jFfMiOkGiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_jFnLjBlGiCoCjEoEiKhCiCmMjBmOiPnLiCmJiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
} // FCObjPoint::FCObjPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoint::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_POINT) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjPoint::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjPoint::Type () const
{
	return FDOJ_POINT;
} // FCObjPoint::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::OnDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMono	:_xZkqqHx_iDiCiDgNiDeOiDiNjFgAiJoGiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.03 Fukushiro M. bIsMono_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void FCObjPoint::OnDraw (CDC* pDC, BOOL bIsMono)
{
	if ((g_->appMode & FD_APPMODE_MASK) == FD_APPMODE_CHIPEDITOR || m_bIsVisible)
	{
		FCDraw draw(pDC);
		draw.PenInit(FD_PEN_STYLE_SOLID, 0.0, FD_S_COLOR_BLACK);
		draw.RectLine(mm2lg(GetOuterFrame()));
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDraw(pDC, bIsMono);
} // FCObjPoint::OnDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::GetOuterFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeCjApMiCkKiCkAiCoKiCmOiClLiCmMjFjNiCoAiNgMjHlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeCjCgMiCmJiCmNiCkAiCoJjCpGjDhIiMoLiNlHiCkKiCkAiCmBiCmEiCoAiCoGiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *************************************************************************/
DBLRect FCObjPoint::GetOuterFrame () const
{
	return DBLRect(m_mmptPoint - DBLPoint(1, 1), m_mmptPoint + DBLPoint(1, 1));
} // FCObjPoint::GetOuterFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jCgMiCmMjAlDiKgNiClDiCmGiOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *************************************************************************/
DBLRect FCObjPoint::GetResizeFrame () const
{
	return DBLRect(m_mmptPoint, m_mmptPoint);
} // FCObjPoint::GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjFigure::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoint::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjPoint* ogrpp = static_cast<const FCObjPoint*>(objp);
	return m_mmptPoint == ogrpp->m_mmptPoint;
} // FCObjPoint::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjPoint::OutStream (FCUndoArchive& ar)
void FCObjPoint::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	ar << m_mmptPoint;	// _xZkqqHx_iDhMiDeDiDjDiDgHiNmAjFfHiBeC_xHqqkZx_
} // FCObjPoint::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void FCObjPoint::InStream (FCUndoArchive& ar)
{
	BASE_CLASS::InStream(ar);
	ar >> m_mmptPoint;	// _xZkqqHx_iDhMiDeDiDjDiDgHiNmAjFfHiBeC_xHqqkZx_
} // FCObjPoint::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::IsLineMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiBeBiDiJiDeDiDjDiDiCiDiKiDhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiJiDeDiDjDiDiCiDiKiDhGiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	CheckHitLineMolip _xZkqqHx_iKnGjAjEiCmGjIeBiMgHiClHiCoJiBeCiPeDjAlDiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_CheckHitLineMolip _xZkqqHx_iKnGjAjE_xHqqkZx_
 *			_xZkqqHx_iCmMiPeDjAlDiCpAjGfJiCoKiClIiCmJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoint::IsLineMolip (long lMolipId) const
{
	return FALSE;
} // FCObjPoint::IsLineMolip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::Move
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiInKjDkOiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDX	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *			mmDY	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_Y_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *************************************************************************/
void FCObjPoint::Move (mmetol mmDX, mmetol mmDY)
{
	if (mmDX == 0.0 && mmDY == 0.0) return;
	m_mmptPoint += DBLPoint(mmDX, mmDY);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Move(mmDX, mmDY);
} // FCObjPoint::Move.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::Resize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	: X_xZkqqHx_jFpLiMpMiCkKjElNjDfNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bYPosi	: Y_xZkqqHx_jFpLiMpMiCkKjElNjDfNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtOld	: _xZkqqHx_iDiKiDfEiDeDiDfJjBePiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCObjPoint::Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld)
{
	if (!almost0(mmrtNew.Width()) || !almost0(mmrtNew.Height()))
		FFThrowMiscUnknown();
	m_mmptPoint.x = mmrtNew.left;
	m_mmptPoint.y = mmrtNew.top;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Resize(bXPosi, bYPosi, mmrtNew, mmrtOld);
} // FCObjPoint::Resize.

//----- 05.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::Rotate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR		:_xZkqqHx_iJpBjDfNiClDiClJiCoJiKhAjDhIiBeC_xHqqkZx_-2.0 < dR < 2.0.
// *			mmCX	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
// *			mmCX	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCObjPoint::Rotate (double dR, mmetol mmCX, mmetol mmCY)
//{
//	// _xZkqqHx_iJpBjDfNiKhAjDhIiCkKiCePiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
//	if (dR == 0.0) return;
//	// _xZkqqHx_iJpBjDfNjFmPiKlHiCpAiOfKiPgPiBeC_xHqqkZx_
//	::RotateConv(m_mmptPoint, sin(dR * M_PI), cos(dR * M_PI), mmCX, mmCY);
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::Rotate(dR, mmCX, mmCY);
//} // FCObjPoint::Rotate.
//----- 05.02.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::IsResizable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	:X_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			bYPosi	:Y_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			mmrtNew	:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfHiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfM_xHqqkZx_
 *			FALSE	:_xZkqqHx_iDiKiDfEiDeDiDfJjFhDiJmCjEfM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoint::IsResizable (BOOL bXPosi, BOOL bYPosi,
								const DBLRect& mmrtNew) const
{
	return FALSE;
} // FCObjPoint::IsResizable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::HitTest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjBeJjBpAjIgHiCmMiCmHiCmMiImKjChFiCmJiNmAjFfHiCkKiDhMiDeDiDjDiDgHiClDiCoKiCmEiCkCiCoJiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptPos	: _xZkqqHx_iDhBiDgCiDgHiDhMiDeDiDjDiDgHiCmMiNmAjFfHiBgJiOmAiNmAjFfHiBgKiCpAjFnEiClH_xHqqkZx_.
 *			lgptMse	: _xZkqqHx_iDhNiDeFiDfIiCmMiDhMiDeDiDjDiDgHiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiDhMiDeDiDjDiDgHiCmMiDgOiDjDiDgIiDiL_xHqqkZx_.
 *************************************************************************/
short FCObjPoint::HitTest (DBLPoint& mmptPos, const CPoint& lgptMse) const
{
	return FD_HIT_NONE;
} // FCObjPoint::HitTest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::~FCObjPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *************************************************************************/
FCObjPoint::~FCObjPoint ()
{
} // FCObjPoint::~FCObjPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::GetPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const DBLPoint& FCObjPoint::GetPoint () const
{
	return m_mmptPoint;
} // FCObjPoint::GetPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::SetPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoint::SetPoint (const DBLPoint& mmpt)
{
	m_mmptPoint = mmpt;
} // FCObjPoint::SetPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::GetIsVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiClDiCoKiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiClDiCoKiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ChipEditor_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_g_->appMode _xZkqqHx_iCmJ_xHqqkZx_ FD_APPMODE_CHIPEDITOR _xZkqqHx_iCkKiKnMiCnMiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iCkJiCmHiCkEiCkJiCpAiMkJiCmEjFfMiOkGiCpAiMiIjCoIiClHiCoJiCkKiBeB_xHqqkZx_DynamicDraw _xZkqqHx_iCmFiCoAiDePiDiLiBfLiDhGjFnCiPfH_xHqqkZx_
 *			_xZkqqHx_iDgDiBfLiDiLiCmFiCmNiDhMiDeDiDjDiDgHjFjEjFgJiCpAjFfMiOkGiClHiCoJjFeLjHhGiCkKjAlGiClGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPoKiNiHiBeBjFfMiOkGiClHiCoJiDhMiDeDiDjDiDgHjFjEjFgJiCmNjFnCiPfHjBmOiPnLiCmMiDePiDiLiBfLiDhGiCmJiKnMiCnMiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCmMiCnNiCmFiCkAiCoJiCmMiCmFiBeBiClBiCmMiDhEiDiJiDePiCpAjFmPiNfIiClHiCoJiClBiCmGiCmFjBmOiJjOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoint::GetIsVisible () const
{
	return m_bIsVisible;
} // FCObjPoint::GetIsVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::SetIsVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiClDiCoKiCoJiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ChipEditor_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_g_->appMode _xZkqqHx_iCmJ_xHqqkZx_ FD_APPMODE_CHIPEDITOR _xZkqqHx_iCkKiKnMiCnMiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iCkJiCmHiCkEiCkJiCpAiMkJiCmEjFfMiOkGiCpAiMiIjCoIiClHiCoJiCkKiBeB_xHqqkZx_DynamicDraw _xZkqqHx_iCmFiCoAiDePiDiLiBfLiDhGjFnCiPfH_xHqqkZx_
 *			_xZkqqHx_iDgDiBfLiDiLiCmFiCmNiDhMiDeDiDjDiDgHjFjEjFgJiCpAjFfMiOkGiClHiCoJjFeLjHhGiCkKjAlGiClGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPoKiNiHiBeBjFfMiOkGiClHiCoJiDhMiDeDiDjDiDgHjFjEjFgJiCmNjFnCiPfHjBmOiPnLiCmMiDePiDiLiBfLiDhGiCmJiKnMiCnMiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCmMiCnNiCmFiCkAiCoJiCmMiCmFiBeBiClBiCmMiDhEiDiJiDePiCpAjFmPiNfIiClHiCoJiClBiCmGiCmFjBmOiJjOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoint::SetIsVisible (BOOL bVisible)
{
	m_bIsVisible = bVisible;
} // FCObjPoint::SetIsVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoint::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjPoint::CopySelf(pObj);
} // FCObjPoint::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoint::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoint::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjPoint::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	ASSERT(sizeof(*this) - offsetof(FCObjPoint, m_mmptPoint) ==
			sizeof(m_mmptPoint) + sizeof(m_bIsVisible) + 4);
	FCObjPoint* pPt = reinterpret_cast<FCObjPoint*>(pObj);
	pPt->m_mmptPoint = m_mmptPoint;
} // FCObjPoint::CopySelf.

