#ifndef __ObjWidePoly_h
#define __ObjWidePoly_h

#include "ObjPoly.h"	// For Superclass.

//;----- <EXPORT TO SDK> -----;

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCObjPoly

//;------ </EXPORT TO SDK> -----;

class CFCProObjWidePoly;
class FCHiCommandTable;
struct myMakeBezierThreadData;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCObjWidePoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjNiNeMiDhMiDiKiDfDiDjDjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCObjWidePoly : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	FCObjWidePoly ();
	virtual BOOL	IsKindOf (FTObjectType nType) const;

	//----- _xZkqqHx_iOmAjBmMiJlLiJmCjEfMiCmIiDeOiDiJiDfIiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual FTObjectType	Type () const;

	//----- Subclass_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual DBLRect	GetOuterFrame () const;

	//----- _xZkqqHx_jBkOjAkLiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual BOOL	IsEqual (const FCObjDynabase* objp) const;
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual void	OutStream (FCUndoArchive& ar);
	virtual void	OutStream (FCUndoArchive& ar, BOOL bIsOutBezier);
	virtual void	InStream (FCUndoArchive& ar);
	virtual void	CreatePropertyPage (CPropertyPageVector& vPropPage,
										const ObjDynabaseVector& vSelect);

	//----- _xZkqqHx_iKePiMgAiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual BOOL	IsClosePolygon () const;
	virtual void	NewObjPolygonForDraw (	DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const;
// 05.06.28 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	NewObjBezierForDraw (FCMmPolyBezier& polyBezier) const;

	virtual void	NewObjPolygonForResize (DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const;

	//----- _xZkqqHx_jFeLjHhGiCmJiJjOiClGiCmEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClHiCoKiCmOjHmHiCkC_xHqqkZx_ -----

	virtual void	OnPictArrowModified (PictArrowID paid);
	virtual void	OnArrowModified ();

	virtual ~FCObjWidePoly ();

	//----- FCObjWidePoly_xZkqqHx_iCmM_xHqqkZx_Subclass_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual mmetol	GetPolyWidthF () const;			// _xZkqqHx_jApMiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
	virtual mmetol	GetPolyWidthB () const;			// _xZkqqHx_jApMiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
	virtual short	GetWidthSlopeF () const;		// _xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
	virtual short	GetWidthSlopeB () const;		// _xZkqqHx_iPeJjHlJjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_

// 06.03.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	PrepareSideBezier ();

	//----- _xZkqqHx_iDfIiDiMiDgCiDgIiKnGiMfH_xHqqkZx_ -----
	static void		TerminateCalcBezierThread ();

friend class CFCProObjWidePoly;
friend class FCHiCommandTable;
friend struct myMakeBezierThreadData;

protected:
	virtual void	Move (mmetol mmDX, mmetol mmDY);
	virtual void	Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld);
	virtual void	Rotate (double dR, const DBLPoint& mmptCenter);

	virtual void	NewObjPolygon (DBLPointVector& vmmptPoly,
									mmetol mmElemLen,
									const DBLRect mmrtaClip[], int iClipSize,
									FCBaseArrow* pArrowF, FCBaseArrow* pArrowB) const;
	virtual void	NewArrowedObjPolygon (DBLPointVector& vmmptPoly, BOOL& bIsClose,
										FCBaseArrow*& pArrowF, FCBaseArrow*& pArrowB,
										BOOL& bIsWidePoly, mmetol mmElemLen,
										const DBLRect mmrtaClip[], int iClipSize) const;
	virtual void	NewArrowedObjBezier (	FCMmPolyBezier& polyBezier,
											BOOL& bIsClose,
											FCBaseArrow*& pArrowF,
											FCBaseArrow*& pArrowB,
											BOOL& bIsWidePoly) const;

	//----- FCObjWidePoly_xZkqqHx_iCmM_xHqqkZx_Subclass_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual BOOL	SetPolyWidthF (mmetol mmW);		// _xZkqqHx_jApMiCmMjFjNiCpAjAnNjCoIiBeC_xHqqkZx_
	virtual BOOL	SetPolyWidthB (mmetol mmW);		// _xZkqqHx_jApMiCmMjFjNiCpAjAnNjCoIiBeC_xHqqkZx_
	virtual BOOL	SetWidthSlopeF (short nWidthSlope);		// _xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
	virtual BOOL	SetWidthSlopeB (short nWidthSlope);		// _xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_

	//----- FCObjPoly_xZkqqHx_iCmM_xHqqkZx_Subclass_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual BOOL	CanSetOpenPolyJoint () const;
	virtual BOOL	GetIsOpenPolyJoint () const;
	virtual BOOL	SetIsOpenPolyJoint (BOOL bOpen);

	//----- _xZkqqHx_jBkOjAkLiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual void	Copy (FCObjDynabase* pObj) const;
	virtual void	CopySelf (FCObjDynabase* pObj) const;

	//----- FCObjWidePoly_xZkqqHx_iCmM_xHqqkZx_Subclass_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual void	CalcOutline (DBLPointVector& vmmOutPoly, mmetol mmElemLen,
								const DBLRect* mmrtaClip, int iClip,
								FCBaseArrow* pArrowF, FCBaseArrow* pArrowB) const;

//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
protected:
	virtual void	GetArrowF_AB (DBLPoint& mmptA, DBLPoint& mmptB) const;
	virtual void	GetArrowB_AB (DBLPoint& mmptA, DBLPoint& mmptB) const;

	virtual void	JointUpdated ();
	virtual void	CalcSideLine (	DBLPointVector& vmmptLeft,
									DBLPointVector& vmmptRight,
									BYTEVector& vIsJointLeft,
									BYTEVector& vIsJointRight,
									mmetol& mmArrowF_P,
									mmetol& mmArrowF_Q,
									angle& dArrowF_Angle,
									mmetol& mmArrowB_P,
									mmetol& mmArrowB_Q,
									angle& dArrowB_Angle) const;
	virtual void	SetApproximateBezier (	const DBLPointVector& mmptvLeftBezier,
											const DBLPointVector& mmptvRightBezier,
											mmetol mmArrowF_P,
											mmetol mmArrowF_Q,
											angle dArrowF_Angle,
											mmetol mmArrowB_P,
											mmetol mmArrowB_Q,
											angle dArrowB_Angle);
	virtual void	MoveApproximateBezier (mmetol mmDX, mmetol mmDY);
	virtual void	ResizeApproximateBezier (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld);
	virtual void	RotateApproximateBezier (double dR, const DBLPoint& mmptCenter);
	virtual void	ResetMakeBezier ();
	static void	RegisterMakeBezier (FCObjWidePoly* pObj);
	static void	UnregisterMakeBezier (FCObjWidePoly* pObj);
// 06.03.15 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	static void WINAPI myMakeBezierThread (LPVOID pvoid);

	static void	MakeBezierTimerProc (	HWND hwnd,
										UINT uMsg,
										UINT_PTR idEvent,
										DWORD dwTime);
	static void	MakeApproximateBezier (DBLPointVector& vmmptBezier, const DBLPoint* mmptPoly, long lPolySize, const BYTE* pIsJoint);
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.03.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
protected:
	static set<FCObjWidePoly*>	s_stWaitObjToMakeBezier;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKjBnCiClPiCmMjFjEjFgJiBeC_xHqqkZx_
	static UINT_PTR				s_uMakeBezierTimerId;		// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiMhGiOfKiKeKiOgOiDfOiDeDiDhNiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//----- 06.03.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

protected:
	mmetol	m_mmWidthF;			// _xZkqqHx_iKeKiOgOjDfPiCmMjBnBiCmMjFjNiBeC_xHqqkZx_
	mmetol	m_mmWidthB;			// _xZkqqHx_iPeJjHlJjDfPiCmMjBnBiCmMjFjNiBeC_xHqqkZx_
	short	m_nWidthSlopeF;		// _xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
	short	m_nWidthSlopeB;		// _xZkqqHx_iPeJjHlJjDfPiCmMiMfIiOmOiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_

	//----- _xZkqqHx_iClBiClBiCkJiCoHiJlKiCmNjFjEjFgJjCiGiCmFjAnNjCoIiClDiCoKiCoJ_xHqqkZx_ -----
	DBLPointVector	m_vmmptLeftBezier;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiLmIjApMiBgJiNlGjBkEiBgKiBeC_xHqqkZx_
	DBLPointVector	m_vmmptRightBezier;	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiLmIjApMiBgJiJeFjBkEiBgKiBeC_xHqqkZx_
	mmetol	m_mmArrowF_P;		// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiCgPiBeC_xHqqkZx_
	mmetol	m_mmArrowF_Q;		// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiChAiBeC_xHqqkZx_
	angle	m_dArrowF_Angle;	// _xZkqqHx_jBePjFpLjGoOiIpDiCmMiMpMiCkLiBeC_xHqqkZx_
	mmetol	m_mmArrowB_P;		// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiCgPiBeC_xHqqkZx_
	mmetol	m_mmArrowB_Q;		// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiChAiBeC_xHqqkZx_
	angle	m_dArrowB_Angle;	// _xZkqqHx_iMoDjFpLjGoOiIpDiCmMiMpMiCkL_xHqqkZx_
}; // class FCObjWidePoly.

#endif//__ObjWidePoly_h
