// ParaCmbSColor.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "dynamicdraw.h"
#include "UtilStr.h"		// For GetResString.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilDlg.h"		// For RightByLeftHand.
#include "ParaCmbSColor.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static const int s_iPara = 4;
//static const long s_lSeparateGap = 2;

/////////////////////////////////////////////////////////////////////////////
// CFCParaCmbSColor _xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfGiDiHiDjDiBeC_xHqqkZx_

IMPLEMENT_DYNCREATE(CFCParaCmbSColor, CFCCmbBase)

CFCParaCmbSColor::CFCParaCmbSColor ()
{
	m_iCurSel = CB_ERR;
	m_iHighlighted = CB_ERR;
	m_iCandidate = CB_ERR;
	m_ptLastMouse = CPoint(-1, -1);	// _xZkqqHx_jBePiJpBiCmMiDhNiDeFiDfIiImKjChFiBeC_xHqqkZx_
} // CFCParaCmbSColor::CFCParaCmbSColor.

CFCParaCmbSColor::CFCParaCmbSColor (BOOL bIsDetail)
				:BASE_CLASS(bIsDetail)
{
	m_iCurSel = CB_ERR;
	m_iHighlighted = CB_ERR;
	m_iCandidate = CB_ERR;
} // CFCParaCmbSColor::CFCParaCmbSColor.

CFCParaCmbSColor::~CFCParaCmbSColor ()
{
} // CFCParaCmbSColor::~CFCParaCmbSColor.


/////////////////////////////////////////////////////////////////////////////
// CFCParaCmbSColor _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

static long myLineColumnToIndex (long lLine, long lColumn)
{
	return (lLine * s_iPara) + lColumn;
}

static void myIndexToLineColumn (long& lLine, long& lColumn, long lIndex)
{
	lLine = lIndex / s_iPara;
	lColumn = lIndex % s_iPara;
}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCParaCmbSColor::PointToParaIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHiCmJiCkAiCoJiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeCiDfIiDeOiDiKiBfLiDjDiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBeCjBmOiJjOiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ CB_ERR_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHiCmMiDeFiDeCiDjDiDgIiDeFiCmNiBeBiMkJiCkGiCmIiCkCiCkKiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiNlGiPoDiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iOgOiCnMiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEkCiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ ComboBox         _xZkqqHx_iEkAiBkFiEkA_xHqqkZx_                  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEkDiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiElKiEkKiElM_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iElKiEkKiElM_xHqqkZx_
 *          _xZkqqHx_iEkAiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiBhLiBgDiBgDiBgDiBgDiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCParaCmbSColor::PointToParaIndex (const CPoint& pt) const
{
//----- 06.03.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHiCmMiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOfKiPgPiBeC_xHqqkZx_
//	CRect rtList = GetListClientRect();
//	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiNmAjFfHiMgOiCmJjFmPiKlHiBeC_xHqqkZx_
//	CPoint ptListLT(rtList.left, rtList.top);
//	CPoint ptListRB(rtList.right, rtList.bottom);
//	::ClientToScreen(m_hwndList, &ptListLT);
//	::ClientToScreen(m_hwndList, &ptListRB);
//	rtList.SetRect(ptListLT.x, ptListLT.y, ptListRB.x, ptListRB.y);
//
//	if (!rtList.PtInRect(pt)) return CB_ERR;
//
//	// _xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHjCiGiCmMiDeBiDeDiDgFiDiAiNiCiCpAiOoGjDlOiBeC_xHqqkZx_
//	const long lItemHeight = GetItemHeight(0);
//	// _xZkqqHx_iNmAjFfHiImKjChFiCmMiNhDiCpAiMhGiOfKiBeC_xHqqkZx_
//	long lLine = GetTopIndex() + ((pt.y - rtList.top) / lItemHeight);
//	if ((pt.y - rtList.top) % lItemHeight == 0) lLine--;
//
//	const long lItemWidth = rtList.Width() / s_iPara;
//	long lColumn = (pt.x - rtList.left) / lItemWidth;
//	if (s_iPara <= lColumn) lColumn = s_iPara - 1;
//	return myLineColumnToIndex(lLine, lColumn);
//----- 06.03.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHiCmMiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOfKiPgPiBeC_xHqqkZx_
	CRect rtList = GetListClientRectAsScreen();
	// _xZkqqHx_iLoJiMgAiCmJjDpMiCoHiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (!rtList.PtInRect(pt))
		return CB_ERR;
	// _xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHjCiGiCmMiDeBiDeDiDgFiDiAiNiCiCpAiOoGjDlOiBeC_xHqqkZx_
	const long lItemHeight = GetItemHeight(0);
	// _xZkqqHx_iNmAjFfHiImKjChFiCmMiNhDiCpAiMhGiOfKiBeC_xHqqkZx_
	long lLine = GetTopIndex() + ((pt.y - rtList.top) / lItemHeight);
	if ((pt.y - rtList.top) % lItemHeight == 0) lLine--;
	// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFjNiCpAiOfKiPgPiBeC_xHqqkZx_
	const long lItemWidth = rtList.Width() / s_iPara;
	long lColumn = (pt.x - rtList.left) / lItemWidth;
	if (s_iPara <= lColumn) lColumn = s_iPara - 1;
	int iIndex = myLineColumnToIndex(lLine, lColumn);
//----- 06.04.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (GetCount() <= iIndex)
		return CB_ERR;
//----- 06.04.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return iIndex;
//----- 06.03.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCParaCmbSColor::PointToParaIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCParaCmbSColor::GetParaListItemRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHiBeBiDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHiDeFiDeCiDjDiDgIiDeFiCmJiCkIiCkPiCoJ_xHqqkZx_
 *			_xZkqqHx_iDeBiDeDiDgFiDiAiLoJiMgAjHmMiIoGiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex		:_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCmMiDeBiDeDiDgFiDiAiLoJiMgAjHmMiIoGiBeCjHmMiIoGiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_CRect(0,0,0,0)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCParaCmbSColor::GetParaListItemRect (long lIndex) const
{
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkKjEmNiImNiCpAiCmNiCnNiPgPiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_(0,0,0,0)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// 06.03.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (lIndex <= 0 || m_vItemData.size() <= lIndex)
	if (lIndex < 0 || m_vItemData.size() <= lIndex)
		return CRect(0,0,0,0);

	// _xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHiCmMiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOfKiPgPiBeC_xHqqkZx_
	CRect rtList = GetListClientRect();

	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHiBeBiNhDjHpBiCpAiOfKiPgPiBeC_xHqqkZx_
	long lLine;
	long lColumn;
	myIndexToLineColumn(lLine, lColumn, lIndex);
	lLine -= GetTopIndex();

	// _xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHjCiGiCmMiDeBiDeDiDgFiDiAiNiCiCpAiOoGjDlOiBeC_xHqqkZx_
	const long lItemHeight = GetItemHeight(0);
	// _xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHjCiGiCmMiDeBiDeDiDgFiDiAjFjNiCpAiOfKiPgPiBeC_xHqqkZx_
	const long lItemWidth = rtList.Width() / s_iPara;

	CRect rtItem;
	rtItem.top = rtList.top + (lLine * lItemHeight);
	rtItem.bottom = rtItem.top + lItemHeight;
	rtItem.left = rtList.left + (lColumn * lItemWidth);
	rtItem.right = rtItem.left + lItemWidth;

	if ((rtItem & rtList) != rtItem)
		rtItem.SetRect(0,0,0,0);
	return rtItem;
} // CFCParaCmbSColor::GetParaListItemRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCParaCmbSColor::ListMessageProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHiCmJjBjHiCoHiCoKiCoJiDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPiOoGiCmBiCmEiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPjDpMiCoKiCoJiPoKiNiHiCmNiCfAiBeBiOpDiCkPjDpMiCoKiCmIiCkCiPoKiNiHiCmNiCePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iCePiCpAjFnEiClFiClNiPoKiNiHiBeBiDgGiDhEiDeIiDiLiDgHiCmMiDeFiDeCiDjDiDgIiDeFiDhGiDiNiDfGiDfHiDiDiCkKiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCParaCmbSColor::ListMessageProc (	UINT uMsg,
											WPARAM wParam,
											LPARAM lParam)
{
//	TRACE(_T("CFCParaCmbSColor::ListMessageProc %d\n"), uMsg);
	switch (uMsg)
	{
	case WM_SHOWWINDOW:
		//----- _xZkqqHx_iDiKiDfIiDgHiDeFiDeCiDjDiDgIiDeFiCmMjFfMiOkGiBeFjEpBjFfMiOkG_xHqqkZx_ -----
		{
//			TRACE(_T("CFCParaCmbSColor::SHOW %d\n"), wParam);
			// _xZkqqHx_iNlGiDhLiDfOiDjDiCpAiJjPiClFiClNiCmGiCkLiCmMiDeDiDjDiDgGiDgCiDeOiDfIjFmPjAjEiBeC_xHqqkZx_
			// LBUTTONUP_xZkqqHx_iCpAiMjPjCgNiCmFiCkLiCmIiCkCiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeBiClBiClBiCmFiCoAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
			m_iCandidate = CB_ERR;
			if (wParam == FALSE) return 1;
			return BASE_CLASS::ListMessageProc(uMsg, wParam, lParam);
		}
	case WM_MOUSEMOVE:
		//----- _xZkqqHx_iDhNiDeFiDfIiInKjDkOiDiBiDgCiDfKiBfLiDfHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
			CPoint ptMouse;
			(void)::GetCursorPos(&ptMouse);
			// _xZkqqHx_jBePiJpBiCmMiDhNiDeFiDfIiImKjChFiCmGjEoEiKhCiBeCjCmHjAnFiDhBiDjDiDgHiCkKjFfMiOkGiClDiCoKiCoJiCmGiBeB_xHqqkZx_
			// _xZkqqHx_iDhNiDeFiDfIiCkKiInKjDkOiClFiCmEiCkCiCmIiCkCiCmMiCmJjCmHjAnFiDhBiDjDiDgHiCkKiPmBiCkGiCoJiDfOiDeDiDhOiDjDiDePiCmF_xHqqkZx_
			// WM_MOUSEMOVE_xZkqqHx_iCkKjEkNjAlGiClHiCoJiBeC_xHqqkZx_
			if (ptMouse != m_ptLastMouse)
			//----- _xZkqqHx_iDhNiDeFiDfIiCkKiInKjDkOiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				m_ptLastMouse = ptMouse;
				int iIndex = PointToParaIndex(ptMouse);
				if (iIndex != CB_ERR)
					SetListHighlighted(iIndex);
			}
			return BASE_CLASS::ListMessageProc(uMsg, wParam, lParam);
		}
	case WM_LBUTTONDOWN:
		//----- _xZkqqHx_iNlGiDhLiDfOiDjD_xHqqkZx_DOWN_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			m_iCandidate = m_iHighlighted;
			return BASE_CLASS::ListMessageProc(uMsg, wParam, lParam);
		}
	case WM_LBUTTONUP:
		//----- _xZkqqHx_iNlGiDhLiDfOiDjD_xHqqkZx_UP_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// m_iCurSel_xZkqqHx_iCmMjAnNjCoIiCmNiBeB_xHqqkZx_SetCurSel()_xZkqqHx_iCpAiOgHiCoNiClIjClMjAnKiNhDiCkEiBeC_xHqqkZx_
			// BASE_CLASS::ListMessageProc_xZkqqHx_iKnGjAjEiCmJiCoGiCmBiCmEiBeBjGhLjHiIiCmM_xHqqkZx_CComboBox_xZkqqHx_iCmM_xHqqkZx_
			// CurSel _xZkqqHx_iCoAiInKjDkOiClHiCoJiClNiCnPiBeC_xHqqkZx_
			if (m_iHighlighted == CB_ERR)
				m_iCurSel = m_iCandidate;
			else
				m_iCurSel = m_iHighlighted;
			m_iHighlighted = m_iCurSel;
			m_iCandidate = CB_ERR;
			return BASE_CLASS::ListMessageProc(uMsg, wParam, lParam);
		}
	case WM_CHAR:
		//----- _xZkqqHx_iDeMiDiDiDiJiDeOiDfOjDpMjHmNiCmMiPoKiNiH_xHqqkZx_ -----
		if (wParam == '\r' || wParam == '\n')
		{
			// _xZkqqHx_iOkJjDkOjDeJiCmJiDgIiDiNiDgCiDhGiDfPiDeFiDjDiDiKiDfIiDgHiCmNiPmBiLiOiClDiCoKiCoJiBeC_xHqqkZx_
			// iCurSel _xZkqqHx_iCmN_xHqqkZx_ 0_xZkqqHx_iCmJiCmNiCmIiCoKiCmIiCkCiBeCiDhGiDiLiDfPiDeFiDjDiOjOiCmJiCmN_xHqqkZx_
			// 0_xZkqqHx_iImKjChFiCmJiBhFiPnKiNnHiBhGiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
			if (0 < m_iHighlighted && m_iHighlighted < GetCount())
			{
				SetCurSel(m_iHighlighted);
				// SelChange_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
				OnSelchange();
			}
		}
		// BASE_CLASS_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
		return BASE_CLASS::ListMessageProc(uMsg, wParam, lParam);
	case WM_KEYDOWN:
		//----- _xZkqqHx_iDeMiBfLiDfPiDeFiDjDiCmMiPoKiNiH_xHqqkZx_ -----
		if (m_iCandidate == CB_ERR)
		//----- _xZkqqHx_iNlGiDhLiDfOiDjDiCpAiJjPiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			int iCurSel = INT_MAX;
			switch (wParam)
			{
			case VK_UP:		// _xZkqqHx_iPoDjGoOiIpDiDeMiBfLiBeC_xHqqkZx_
				iCurSel = m_iHighlighted - s_iPara;
				break;
			case VK_DOWN:	// _xZkqqHx_iJlKjGoOiIpDiDeMiBfLiBeC_xHqqkZx_
				iCurSel = m_iHighlighted + s_iPara;
				break;
			case VK_LEFT:	// _xZkqqHx_iNlGjGoOiIpDiDeMiBfLiBeC_xHqqkZx_
				iCurSel = m_iHighlighted - 1;
				break;
			case VK_RIGHT:	// _xZkqqHx_iJeFjGoOiIpDiDeMiBfLiBeC_xHqqkZx_
				iCurSel = m_iHighlighted + 1;
				break;
			case VK_HOME:	// Home_xZkqqHx_iDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				iCurSel = 1;
				break;
			case VK_END:	// End_xZkqqHx_iDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				iCurSel = GetCount() - 1;
				break;
			case VK_PRIOR:	// PgaeUp_xZkqqHx_iDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
			  {
				int iPageNum = GetListClientRect().Height() / GetItemHeight(0) - 1;
				iCurSel = m_iHighlighted - (iPageNum * s_iPara);
				break;
			  }
			case VK_NEXT:	// PgaeDown_xZkqqHx_iDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
			  {
				int iPageNum = GetListClientRect().Height() / GetItemHeight(0) - 1;
				iCurSel = m_iHighlighted + (iPageNum * s_iPara);
				break;
			  }
			}
			if (iCurSel != INT_MAX)
			{
				// iCurSel _xZkqqHx_iCmN_xHqqkZx_ 0_xZkqqHx_iCmJiCmNiCmIiCoKiCmIiCkCiBeCiDhGiDiLiDfPiDeFiDjDiOjOiCmJiCmN_xHqqkZx_
				// 0_xZkqqHx_iImKjChFiCmJiBhFiPnKiNnHiBhGiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
				if (iCurSel < 1) iCurSel = 1;
				if (GetCount() <= iCurSel) iCurSel = GetCount() - 1;
				if (iCurSel != GetCurSel())
				{
					SetCurSel(iCurSel);
					// SelChange_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
					OnSelchange();
				}
			}
		}
		return 1;
	default:
		return BASE_CLASS::ListMessageProc(uMsg, wParam, lParam);
	}
} // CFCParaCmbSColor::ListMessageProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCParaCmbSColor::SetListHighlighted
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHjCiGiCmFiBeBiDgOiDeDiDiJiDeDiDgHjFfMiOkGiClDiCoKiCoJiDeBiDeDiDgFiDiAiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iHighlighted	:_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCoKiCnMiCmFiDgOiDeDiDiJiDeDiDgHiClOiCmBiClNiDeBiDeDiDgFiDiAiCpAjCmKiPoNiPpDjBnEiCmJjGnPiClFiBeBjAfGiClFiCkNiOhHjCoI_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiClNiDeBiDeDiDgFiDiAiCpAiDgOiDeDiDiJiDeDiDgHiPpDjBnEiCmJiClHiCoJiBeCiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCParaCmbSColor::SetListHighlighted (int iHighlighted)
{
	if (::IsWindow(m_hwndList) && ::IsWindowVisible(m_hwndList))
	{
		if (m_iHighlighted != iHighlighted)
		{
			CRect rtItemOld = GetParaListItemRect(m_iHighlighted);
			CRect rtItemNew = GetParaListItemRect(iHighlighted);
			m_iHighlighted = iHighlighted;
			if (!rtItemOld.IsRectNull())
				::InvalidateRect(m_hwndList, rtItemOld, TRUE);
			if (!rtItemNew.IsRectNull())
				::InvalidateRect(m_hwndList, rtItemNew, TRUE);
//			TRACE(_T("CFCParaCmbSColor::SetListHighlighted %d\n"), m_iHighlighted);
		}
	}
} // CFCParaCmbSColor::SetListHighlighted.

int CFCParaCmbSColor::GetCount () const
{
	return m_vItemData.size();
} // CFCParaCmbSColor::GetCount.

void CFCParaCmbSColor::SetCurSel (int iIndex)
{
	m_iCurSel = iIndex;
	m_iHighlighted = m_iCurSel;
//	TRACE(_T("CFCParaCmbSColor::SetCurSel %d\n"), m_iHighlighted);

	if (m_iCurSel == CB_ERR)
	{
		BASE_CLASS::SetCurSel(m_iCurSel);
	} else
	{
		long lLine;
		long lColumn;
		myIndexToLineColumn(lLine, lColumn, m_iCurSel);
		BASE_CLASS::SetCurSel(lLine);
	}
} // CFCParaCmbSColor::SetCurSel.

int CFCParaCmbSColor::GetCurSel () const
{
	return m_iCurSel;
} // CFCParaCmbSColor::GetCurSel.

DWORD CFCParaCmbSColor::GetItemData (int nIndex) const
{
	return (DWORD)m_vItemData[nIndex];
} // CFCParaCmbSColor::GetItemData.

int CFCParaCmbSColor::SetItemData (int nIndex, DWORD dwItemData)
{
	m_vItemData[nIndex] = (const void*)dwItemData;
	return 0;
} // CFCParaCmbSColor::SetItemData.

int CFCParaCmbSColor::AddString (LPCTSTR lpszString)
{
	int iParaCount = GetParaLineCount();
	m_vItemData.push_back(lpszString);
	if (iParaCount != GetParaLineCount())
		BASE_CLASS::AddString(_T(""));
	return m_vItemData.size() - 1;
} // CFCParaCmbSColor::AddString.

int CFCParaCmbSColor::InsertString (int nIndex, LPCTSTR lpszString)
{
	int iParaCount = GetParaLineCount();
	m_vItemData.insert(m_vItemData.begin() + nIndex, lpszString);
	if (iParaCount != GetParaLineCount())
		BASE_CLASS::AddString(_T(""));
	// _xZkqqHx_iMlLiNnNiImKjChFiCoGiCoIjBePiCmJjBhNjDpMiCmMiPoKiNiHiCmNiImKjChFiCpAiJmBiOfKiBeC_xHqqkZx_
	if (nIndex <= m_iCurSel)
		m_iCurSel++;
	if (nIndex <= m_iHighlighted)
		m_iHighlighted++;
	return nIndex;
} // CFCParaCmbSColor::InsertString.

int CFCParaCmbSColor::DeleteString (UINT nIndex)
{
	int iParaCount = GetParaLineCount();
	m_vItemData.erase(m_vItemData.begin() + nIndex);
	if (iParaCount != GetParaLineCount())
		BASE_CLASS::DeleteString(0);
	// _xZkqqHx_iMlLiNnNiImKjChFiCoGiCoIjBePiCpAiNoNiPjMiCmMiPoKiNiHiCmNiImKjChFiCpAiMlIiOfKiBeC_xHqqkZx_
	// _xZkqqHx_iMlLiNnNiImKjChFiCpAiNoNiPjMiCmMiPoKiNiHiCmNiBeB_xHqqkZx_CB_ERR_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	if (nIndex < m_iCurSel)
		m_iCurSel--;
	else
	if (nIndex == m_iCurSel)
		m_iCurSel = CB_ERR;

	if (nIndex < m_iHighlighted)
		m_iHighlighted--;
	else
	if (nIndex == m_iHighlighted)
		m_iHighlighted = CB_ERR;

	return m_vItemData.size();
} // CFCParaCmbSColor::DeleteString.

void CFCParaCmbSColor::ResetContent ()
{
	m_vItemData.clear();
	m_iCurSel = CB_ERR;
	m_iHighlighted = m_iCurSel;
	BASE_CLASS::ResetContent();
} // CFCParaCmbSColor::ResetContent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCParaCmbSColor::GetParaLineCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiKiDfIiDgHjCiGiCmMiNhDjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNhDjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCParaCmbSColor::GetParaLineCount () const
{
	return (m_vItemData.size() + s_iPara - 1) / s_iPara;
} // CFCParaCmbSColor::GetParaLineCount.

/////////////////////////////////////////////////////////////////////////////
// CFCParaCmbSColor _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCParaCmbSColor::DrawItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpDIS	:_xZkqqHx_jFgAiJoGiClHiCoJiDeBiDeDiDgFiDiAiCmJiKnGiClHiCoJiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCfDjFkKiKiEiClHiCoJiPoKiNiHiCmMjHoBiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkAiEkA_xHqqkZx_              _xZkqqHx_iEkAiEkA_xHqqkZx_              _xZkqqHx_iEkAiEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkAiEkA_xHqqkZx_              _xZkqqHx_iEkAiEkA_xHqqkZx_              _xZkqqHx_iEkAiEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *			_xZkqqHx_iCfCiCmCiCmMiLkLiCmMjFjNiCmGiBeBiCfDiCmCiCmMiNiAjGnKjFjNiCmFjBfDjBmMiCpAjFkKiKiEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCParaCmbSColor::DrawItem (LPDRAWITEMSTRUCT lpDIS)
{
	if (lpDIS->itemID == static_cast<UINT>(CB_ERR)) return;

	int iHighlighted = m_iHighlighted;

//	TRACE(_T("CFCParaCmbSColor::DrawItem\n"));
	long lC;
	CDC* pDC = CDC::FromHandle(lpDIS->hDC);
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, FALSE, 0, 0);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiDiKiDfIiDgHiCmMjFgAiJoGiCkJiBeI_xHqqkZx_
	const BOOL bIsDropped = (lpDIS->itemState & ODS_COMBOBOXEDIT) ? FALSE : TRUE;
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	CRect rtBox(lpDIS->rcItem.left,
				lpDIS->rcItem.top,
				lpDIS->rcItem.right,
				lpDIS->rcItem.bottom);
	// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFjNiCpAiOfKiPgPiBeC_xHqqkZx_
	const long lItemWidth = rtBox.Width() / s_iPara;
	CRectVector vItemRect;
	for (lC = 0; lC != s_iPara; lC++)
	{
		CRect rtItem;
		rtItem.left = rtBox.left + (lC * lItemWidth);
		rtItem.top = rtBox.top;
		rtItem.right = rtItem.left + lItemWidth;
		rtItem.bottom = rtBox.bottom;
		vItemRect.push_back(rtItem);
	}

	// "_xZkqqHx_iPnKiNnH_xHqqkZx_(D)..."_xZkqqHx_iCmMjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WString strDetail;
//	strDetail.Format(L"%s (%c)...", GetResWString(IDS_DETAIL_ETC),
//					::RightByLeftHand(FD_CBKY_DETAIL));
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString strDetail = FFMakeCommandText(GetResWString(IDS_DETAIL_ETC), ::RightByLeftHand(FD_CBKY_DETAIL));
//----- 06.03.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	strDetail.Replace(L"&&", L"#AnD#");
//	strDetail.Replace(L"&", L"");
//	strDetail.Replace(L"#AnD#", L"&&");
//----- 06.03.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	strDetail += L"...";
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	atDC.SetBkMode(TRANSPARENT);

	if (bIsDropped)
	//----- _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiDiKiDfIiDgHiCmMjFgAiJoGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		for (lC = 0; lC != s_iPara; lC++)
		{
			ASSERT(lpDIS->itemID != static_cast<UINT>(CB_ERR));
			long lIndex = myLineColumnToIndex(lpDIS->itemID, lC);
			if (lIndex == GetCount()) break;

			DWORD dwData = GetItemData(lIndex);
			if (lIndex != iHighlighted)
			//----- _xZkqqHx_iDgOiDeDiDiJiDeDiDgHiCmMiDeBiDeDiDgFiDiAiImIiKeP_xHqqkZx_ -----
			{
				// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
				FCAutoDC atDCSub(pDC, FALSE, 0, 0);
				// _xZkqqHx_jHmMiIoGiCpAjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
				atDCSub.FillRect(vItemRect[lC], FCAtBrush(pDC->GetBkColor()));
				// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
				atDCSub.SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
				if (m_bDrawDetail && (lIndex == 0))
				{
// 06.03.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//					atDCSub.DrawText(strDetail, CP_ACP, vItemRect[lC], DT_CENTER);
					atDCSub.DrawText(strDetail, CP_ACP, vItemRect[lC], DT_LEFT);
				} else
				{
					DrawItemSub(dwData, lIndex, ::GetSysColor(COLOR_WINDOWTEXT),
								vItemRect[lC], bIsDropped, pDC);
				}
			} else
			//----- _xZkqqHx_iDgOiDeDiDiJiDeDiDgHiCmMiDeBiDeDiDgFiDiA_xHqqkZx_ -----
			{
//				TRACE(_T("_xZkqqHx_iDgOiDeDiDiJiDeDiDgH_xHqqkZx_\n"));
				// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
				FCAutoDC atDCSub(pDC, FALSE, 0, 0);
				// _xZkqqHx_jHmMiIoGiCpAiDgOiDeDiDiJiDeDiDgHjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
				atDCSub.FillRect(vItemRect[lC], FCAtBrush(::GetSysColor(COLOR_HIGHLIGHT)));
				// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
				atDCSub.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
				if (m_bDrawDetail && (lIndex == 0))
				{
// 06.03.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//					atDCSub.DrawText(strDetail, CP_ACP, vItemRect[lC], DT_CENTER);
					atDCSub.DrawText(strDetail, CP_ACP, vItemRect[lC], DT_LEFT);
				} else
				{
					DrawItemSub(dwData, lIndex, ::GetSysColor(COLOR_HIGHLIGHT),
								vItemRect[lC], bIsDropped, pDC);
				}
				// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIiLoJiMgAiCpAjFgAiJoGiBeC_xHqqkZx_
				atDCSub.DrawFocusRect(&vItemRect[lC]);
			}
		}
	} else
	//----- _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIjFjEjFkKiCmMjFgAiJoGiCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 05.07.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// "_xZkqqHx_iPnKiNnH_xHqqkZx_"_xZkqqHx_iCpAjFfMiOkGiCkKiCnMiClOiOgDiCmBiCmEiCkIiCoIiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCePiCpAjBeJjBpAiCmMiPoKiNiHiCmNiPiIjHjNiClFiCmIiCkCiBeC_xHqqkZx_
		if (m_bDrawDetail && m_iCurSel == 0) return;
		// _xZkqqHx_iPnKiNnHiCpAjBeJjBpAiClFiClNiPoKiNiHiBeBjFmCiClGiCoJiCmGiCkLiCmJiBhFiPnKiNnHiBhGiCmNiNoNiPjMiClDiCoKiCoJiCmMiCmFiBeB_xHqqkZx_m_iCurSel = CB_ERR _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
		if (m_iCurSel == CB_ERR) return;
//----- 05.07.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

		// _xZkqqHx_jCmKiPoNiCmMjFgAiJoGiBeCiDhGiDiLiDfPiDeFiDjDiCpAiKeKiCkCiClNiPhFiKnEiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iNiAjGnKiCmMjBeJjBpAiCkKiJpAiPjMiClDiCoKiClNiCmGiCkLiCmMjFgAiJoGiBeC_xHqqkZx_
		if ((lpDIS->itemAction & ODA_DRAWENTIRE) ||
			(!(lpDIS->itemState & ODS_SELECTED) && (lpDIS->itemAction & ODA_SELECT)))
		{
			// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
			FCAutoDC atDCSub(pDC, FALSE, 0, 0);
			// _xZkqqHx_jHmMiIoGiCpAjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
			atDCSub.FillRect(rtBox, FCAtBrush(pDC->GetBkColor()));
			// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			atDCSub.SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
			DrawItemSub(GetItemData(m_iCurSel),
						m_iCurSel,
						::GetSysColor(COLOR_WINDOWTEXT),
						rtBox,
						bIsDropped,
						pDC);
		}
		// _xZkqqHx_iNiAjGnKiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiCmMjFgAiJoGiBeC_xHqqkZx_
		if ((lpDIS->itemState & ODS_SELECTED) &&
			(lpDIS->itemAction & (ODA_SELECT | ODA_DRAWENTIRE)))
		{
			// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
			FCAutoDC atDCSub(pDC, FALSE, 0, 0);
			// _xZkqqHx_jHmMiIoGiCpAiDgOiDeDiDiJiDeDiDgHjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
			atDCSub.FillRect(rtBox, FCAtBrush(::GetSysColor(COLOR_HIGHLIGHT)));
			// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			atDCSub.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
			DrawItemSub(GetItemData(m_iCurSel),
						m_iCurSel,
						::GetSysColor(COLOR_HIGHLIGHT),
						rtBox,
						bIsDropped,
						pDC);
			// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIiLoJiMgAiCpAjFgAiJoGiBeC_xHqqkZx_
			atDCSub.DrawFocusRect(&rtBox);
		}
		// _xZkqqHx_jFmPiNfIjFhDiJmCiPpDjBnEiCmMjFgAiJoGiBeC_xHqqkZx_
		if ((lpDIS->itemAction & ODA_DRAWENTIRE) &&
			(lpDIS->itemState & ODS_DISABLED))
		{
			// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
			FCAutoDC atDCSub(pDC, FALSE, 0, 0);
			// _xZkqqHx_jHmMiIoGiCpAjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
			atDCSub.FillRect(rtBox, FCAtBrush(pDC->GetBkColor()));	// _xZkqqHx_jEhHiMgJjAeGiOoGjDlOiBeC_xHqqkZx_
			// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			atDCSub.SetTextColor(::GetSysColor(COLOR_GRAYTEXT));
			DrawItemSub(GetItemData(m_iCurSel),
						m_iCurSel,
						::GetSysColor(COLOR_GRAYTEXT),
						rtBox,
						bIsDropped,
						pDC);
		}
	}
} // CFCParaCmbSColor::DrawItem.


BEGIN_MESSAGE_MAP(CFCParaCmbSColor, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCParaCmbSColor)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCParaCmbSColor _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

