// PrhHistFindBase.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "FoundDoc.h"			// For g_pDoc.
#include "RegData.h"			// For SaveRegBinary.etc.
#include "UtilMisc.h"			// For COleDtToFdsec.
#include "UtilErr.h"			// For FFMessageBox.
#include "UtilDlg.h"			// For SetUnitString.etc.
#include "UtilWin.h"			// For FFGetWindowText.
#include "UtilStr.h"			// For FFLoadWString.
#include "HiProject.h"			// For g_pProject.
#include "ObjLabel.h"			// For FCObjLabel.
#include "DlgHistFindResults.h"	// For CFCDlgHistFindResults.
#include "HistViewFrame.h"		// For FFHistViewFrame().
#include "DlgSelectUser.h"		// For CFCDlgSelectUser.
#include "PrhHistFindBase.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKjFnLjBlGjGlM_xHqqkZx_ -----
static const wchar_t* REG_PRH_HIST_FIND_BASE = L"CFCPrhHistFindBase";

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindBase _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfH_xHqqkZx_

IMPLEMENT_DYNCREATE(CFCPrhHistFindBase, CFCDialogBase)

static DWORD s_aSearchCtrlId[] = {
	IDC_HFD_TBC_SRH_CHK_SEARCH_ALL_DOCUMENT,	// _xZkqqHx_jBfDjFlGiPjBiCpAiMjPiNpFiBeC_xHqqkZx_
	IDC_HFD_TBC_SRH_CHK_SEARCH_BEFORE,			// _xZkqqHx_iJnPiLiOiCpAiMjPiNpFiBeC_xHqqkZx_
	IDC_HFD_TBC_SRH_CHK_SEARCH_HIGHER,			// _xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiBeC_xHqqkZx_
	IDC_HFD_TBC_SRH_CHK_SEARCH_BEFORE_BRANCH,	// _xZkqqHx_jBlMiCmMiOhNiCoAiMjPiNpFiBeC_xHqqkZx_
	IDC_HFD_TBC_SRH_CHK_SEARCH_AFTER,			// _xZkqqHx_jGkCjHiIiCpAiMjPiNpFiBeC_xHqqkZx_
	IDC_HFD_TBC_SRH_CHK_SEARCH_AFTER_BRANCH,	// _xZkqqHx_jBlMiCmMiOhNiCoAiMjPiNpFiBeC_xHqqkZx_
	0,
};

static DWORD s_aDateCtrlId[] = {
	IDC_HFD_TBC_TIM_CHK_TIME_FROM,		// _xZkqqHx_iKeKiOgOjDpKiOjOiCpAiMmAjCoIiBeC_xHqqkZx_
	IDC_HFD_TBC_TIM_STC0,				// _xZkqqHx_iKeKiOgOjDpKiOjOiBeC_xHqqkZx_
	IDC_HFD_TBC_TIM_DTM_TIME_FROM,		// _xZkqqHx_jDpKiOjOjDpMjHmNiBeC_xHqqkZx_
	IDC_HFD_TBC_TIM_CHK_TIME_UNTIL,		// _xZkqqHx_iPeJjHlJjDpKiOjOiCpAiMmAjCoIiBeC_xHqqkZx_
	IDC_HFD_TBC_TIM_STC1,				// _xZkqqHx_iPeJjHlJjDpKiOjOiBeC_xHqqkZx_
	IDC_HFD_TBC_TIM_DTM_TIME_UNTIL,		// _xZkqqHx_jDpKiOjOjDpMjHmNiBeC_xHqqkZx_
	0,
};

static DWORD s_aLabelCtrlId[] = {
	IDC_HFD_TBC_LBL_CHK_NARROW_BY_LABEL,	// _xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCmFiNgJiCoIiNjOiCnOiBeC_xHqqkZx_
	IDC_HFD_TBC_LBL_STC0,					// _xZkqqHx_iMjPiNpFjFlGiOjKjHpBiBeC_xHqqkZx_
	IDC_HFD_TBC_LBL_CMB_FIND_STRING,		// _xZkqqHx_jDpMjHmNjIgHiBeC_xHqqkZx_
	IDC_HFD_TBC_LBL_CHK_MULTI_WORD,			// _xZkqqHx_jFkBjAjEjCfAiMoKiCmMiMjPiNpFiBeC_xHqqkZx_
	IDC_HFD_TBC_LBL_CHK_REGEXP,				// _xZkqqHx_jAlDiLeLjFfMiMlLiBeC_xHqqkZx_
	IDC_HFD_TBC_LBL_CHK_AS_UPPERCASE,		// _xZkqqHx_jBoFjFlGiOjKiCmGiPkMjFlGiOjKiCpAiLoGjFmKiClFiCmIiCkCiBeC_xHqqkZx_
	0,
};

static DWORD s_aUserCtrlId[] = {
	IDC_HFD_TBC_USR_CHK_NARROW_BY_USER,		// _xZkqqHx_iDiGiBfLiDfFiCmFiNgJiCoIiNjOiCnOiBeC_xHqqkZx_
	IDC_HFD_TBC_USR_BTN_SELECT_USER,		// _xZkqqHx_iMjPiNpFjBmOiPnLiDiGiBfLiDfFiBeC_xHqqkZx_
	IDC_HFD_TBC_USR_LSV_USER_LIST,			// _xZkqqHx_iDiGiBfLiDfFjFfMiOkGjIgHiBeC_xHqqkZx_
	0,
};

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::CFCPrhHistFindBase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCPrhHistFindBase::CFCPrhHistFindBase ()
					: BASE_CLASS()
{
	//{{AFX_DATA_INIT(CFCPrhHistFindBase)
	m_bTbcLblNarrowByLabel = FALSE;
	m_bTbcLblMultiWord = FALSE;
	m_bTbcLblRegexp = FALSE;
	m_bTbcLblAsUppercase = FALSE;
	m_bTbcTimTimeFrom = FALSE;
	m_bTbcTimTimeUntil = FALSE;
	m_otmTbcTimTimeFrom = COleDateTime::GetCurrentTime();
	m_otmTbcTimTimeUntil = COleDateTime::GetCurrentTime();
	m_bTbcSrhSearchAllDocument = FALSE;
	m_bTbcSrhSearchBefore = FALSE;
	m_bTbcSrhSearchHigher = FALSE;
	m_bTbcSrhSearchBeforeBranch = FALSE;
	m_bTbcSrhSearchAfter = FALSE;
	m_bTbcSrhSearchAfterBranch = FALSE;
	m_bTbcUsrNarrowByUser = FALSE;
	//}}AFX_DATA_INIT

	//----- _xZkqqHx_iDiGiBfLiDfFjFmPjAjEiPiJiKpKiJlL_xHqqkZx_ -----
	// _xZkqqHx_iDhHiDiLiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_dwHelpId = DWORD(-1);
	// _xZkqqHx_iMjPiNpFjEmNiImNiBeC_xHqqkZx_
	m_iTabChangeNarrow = NARROW_TAB_SEARCH_AREA;
	m_iTabChangeNarrowOld = -1;
//----- 05.11.14 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiPiJiKpKiJlLiBeC_xHqqkZx_
	m_cmbTbcLblFindString.Initialize(REG_PRH_HIST_FIND_BASE, L"m_cmbTbcLblFindString");
//----- 05.11.14 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCPrhHistFindBase::CFCPrhHistFindBase.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::~CFCPrhHistFindBase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCPrhHistFindBase::~CFCPrhHistFindBase ()
{
} // CFCPrhHistFindBase::~CFCPrhHistFindBase.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfMiBfLiDfIiCkJiCoHiDfPiDeDiDeBiDiNiDePiDhLiDgCiDeOiDfIiDgFiDjDiDhGiDiMiBfLiDgHiCpAiOgHiCmBiCmEiDiCiBfLiDgIiDiMiDfI_xHqqkZx_
 *			_xZkqqHx_iDfPiDeDiDeBiDiNiDePiDhLiDgCiDeOiDfIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIDTemplate	:_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pParentWnd	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	nIDTemplate _xZkqqHx_iCpAiLeMiJkPiClHiCoJiClNiCnPiCmJiBeBiClBiCmMiKnGjAjEiCpAiKnEiCmJiLlCiCpBiClOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPrhHistFindBase::Create (UINT nIDTemplate, CWnd* pParentWnd)
{
	// _xZkqqHx_iDhHiDiLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
	m_dwHelpId = nIDTemplate;
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::Create(nIDTemplate, pParentWnd);
} // CFCPrhHistFindBase::Create.

void CFCPrhHistFindBase::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCPrhHistFindBase)
	DDX_Control(pDX, IDC_HFD_STC_BORDER_1, m_stcBorder1);
	DDX_Control(pDX, IDC_HFD_TBC_LBL_CMB_FIND_STRING, m_cmbTbcLblFindString);
	DDX_Check(pDX, IDC_HFD_TBC_LBL_CHK_NARROW_BY_LABEL, m_bTbcLblNarrowByLabel);
	DDX_Check(pDX, IDC_HFD_TBC_LBL_CHK_MULTI_WORD, m_bTbcLblMultiWord);
	DDX_Check(pDX, IDC_HFD_TBC_LBL_CHK_REGEXP, m_bTbcLblRegexp);
	DDX_Check(pDX, IDC_HFD_TBC_LBL_CHK_AS_UPPERCASE, m_bTbcLblAsUppercase);
	DDX_Check(pDX, IDC_HFD_TBC_TIM_CHK_TIME_FROM, m_bTbcTimTimeFrom);
	DDX_Check(pDX, IDC_HFD_TBC_TIM_CHK_TIME_UNTIL, m_bTbcTimTimeUntil);
	DDX_DateTimeCtrl(pDX, IDC_HFD_TBC_TIM_DTM_TIME_FROM, m_otmTbcTimTimeFrom);
	DDX_DateTimeCtrl(pDX, IDC_HFD_TBC_TIM_DTM_TIME_UNTIL, m_otmTbcTimTimeUntil);
	DDX_Check(pDX, IDC_HFD_TBC_SRH_CHK_SEARCH_ALL_DOCUMENT, m_bTbcSrhSearchAllDocument);
	DDX_Check(pDX, IDC_HFD_TBC_SRH_CHK_SEARCH_BEFORE, m_bTbcSrhSearchBefore);
	DDX_Check(pDX, IDC_HFD_TBC_SRH_CHK_SEARCH_HIGHER, m_bTbcSrhSearchHigher);
	DDX_Check(pDX, IDC_HFD_TBC_SRH_CHK_SEARCH_BEFORE_BRANCH, m_bTbcSrhSearchBeforeBranch);
	DDX_Check(pDX, IDC_HFD_TBC_SRH_CHK_SEARCH_AFTER, m_bTbcSrhSearchAfter);
	DDX_Check(pDX, IDC_HFD_TBC_SRH_CHK_SEARCH_AFTER_BRANCH, m_bTbcSrhSearchAfterBranch);
	DDX_Control(pDX, IDC_HFD_TAB_CHANGE_NARROW, m_tabChangeNarrow);
	DDX_Control(pDX, IDC_HFD_TBC_USR_LSV_USER_LIST, m_lsvTbcUsrUserList);
	DDX_Check(pDX, IDC_HFD_TBC_USR_CHK_NARROW_BY_USER, m_bTbcUsrNarrowByUser);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFCPrhHistFindBase, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCPrhHistFindBase)
	ON_BN_CLICKED(IDC_HFD_TBC_LBL_CHK_NARROW_BY_LABEL, OnHfdTbcLblChkNarrowByLabel)
	ON_BN_CLICKED(IDC_HFD_TBC_TIM_CHK_TIME_FROM, OnHfdTbcTimChkTimeFrom)
	ON_BN_CLICKED(IDC_HFD_TBC_TIM_CHK_TIME_UNTIL, OnHfdTbcTimChkTimeUntil)
	ON_BN_CLICKED(IDC_HFD_TBC_SRH_CHK_SEARCH_ALL_DOCUMENT, OnHfdTbcSrhChkSearchAllDocument)
	ON_BN_CLICKED(IDC_HFD_BTN_DO_FIND, OnHfdBtnDoFind)
	ON_BN_CLICKED(IDC_HFD_TBC_SRH_CHK_SEARCH_BEFORE, OnHfdTbcSrhChkSearchAbove)
	ON_BN_CLICKED(IDC_HFD_TBC_SRH_CHK_SEARCH_AFTER, OnHfdTbcSrhChkSearchBelow)
	ON_NOTIFY(TCN_SELCHANGE, IDC_HFD_TAB_CHANGE_NARROW, OnSelchangeHfdTabChangeNarrow)
	ON_BN_CLICKED(IDC_HFD_TBC_USR_BTN_SELECT_USER, OnHfdTbcUsrBtnSelectUser)
	ON_BN_CLICKED(IDC_HFD_TBC_USR_CHK_NARROW_BY_USER, OnHfdTbcUsrChkNarrowByUser)
	ON_BN_CLICKED(IDC_HFD_BTN_PREV_TAB, OnHfdBtnPrevTab)
	ON_BN_CLICKED(IDC_HFD_BTN_NEXT_TAB, OnHfdBtnNextTab)
	ON_BN_CLICKED(IDC_HFD_BTN_DO_NEW_FIND, OnHfdBtnDoNewFind)
	ON_CBN_SELCHANGE(IDC_HFD_CMB_SELECT_SEARCH_TYPE, OnSelchangeHfdCmbSelectSearchType)
	ON_BN_CLICKED(IDC_HFD_BTN_HELP, OnHfdBtnHelp)
	ON_BN_CLICKED(IDC_HFD_BTN_SHOW_RESULTS_PANEL, OnHfdBtnShowResultsPanel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//----- 05.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ON_BN_CLICKED(IDC_HFD_CHK_SEARCH_OBJECT, OnHfdChkSearchObject)
//	ON_BN_CLICKED(IDC_HFD_CHK_SEARCH_LINK, OnHfdChkSearchLink)
//	ON_BN_CLICKED(IDC_HFD_CHK_SEARCH_LABEL, OnHfdChkSearchLabel)
//	ON_BN_CLICKED(IDC_HFD_CHK_SEARCH_HIDOCUMENT, OnHfdChkSearchHidocument)
//	ON_BN_CLICKED(IDC_HFD_CHK_SEARCH_DATE, OnHfdChkSearchDate)
//----- 05.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindBase _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnSetActive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCkKiDeBiDeOiDgFiDeCiDhFiCmJiCmIiCoJiCmGiCkLiCmJiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnSetActive ()
{
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiPpDiLlFiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	m_cmbTbcLblFindString.UpdateControl();
	m_lsvTbcUsrUserList.UpdateControl();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNiCmMiMjPiNpFjFlGiOjKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	FFGetDlgItemText(this, IDC_HFD_TBC_LBL_CMB_FIND_STRING, m_wstrTbcLblFindString);
	// _xZkqqHx_iNgJiNjOiCnNiDiGiBfLiDfFiDiKiDfIiDgHiCkJiCoHiDiGiBfLiDfFiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	m_lsvTbcUsrUserList.GetUserId(m_stSelectedUserId);

	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiPpDiLlFiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchAllDocument", (BYTE*)&m_bTbcSrhSearchAllDocument, sizeof(m_bTbcSrhSearchAllDocument));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchBefore", (BYTE*)&m_bTbcSrhSearchBefore, sizeof(m_bTbcSrhSearchBefore));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchHigher", (BYTE*)&m_bTbcSrhSearchHigher, sizeof(m_bTbcSrhSearchHigher));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchBeforeBranch", (BYTE*)&m_bTbcSrhSearchBeforeBranch, sizeof(m_bTbcSrhSearchBeforeBranch));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchAfter", (BYTE*)&m_bTbcSrhSearchAfter, sizeof(m_bTbcSrhSearchAfter));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchAfterBranch", (BYTE*)&m_bTbcSrhSearchAfterBranch, sizeof(m_bTbcSrhSearchAfterBranch));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcTimTimeFrom", (BYTE*)&m_bTbcTimTimeFrom, sizeof(m_bTbcTimTimeFrom));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcTimTimeUntil", (BYTE*)&m_bTbcTimTimeUntil, sizeof(m_bTbcTimTimeUntil));
	FDSECTIME fdstFrom = COleDtToFdsec(m_otmTbcTimTimeFrom);
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"fdstFrom", (BYTE*)&fdstFrom, sizeof(fdstFrom));
	m_otmTbcTimTimeFrom = FdsecToFiletime(fdstFrom);
	FDSECTIME fdstUntil = COleDtToFdsec(m_otmTbcTimTimeUntil);
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"fdstUntil", (BYTE*)&fdstUntil, sizeof(fdstUntil));
	m_otmTbcTimTimeUntil = FdsecToFiletime(fdstUntil);
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcLblNarrowByLabel", (BYTE*)&m_bTbcLblNarrowByLabel, sizeof(m_bTbcLblNarrowByLabel));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcLblMultiWord", (BYTE*)&m_bTbcLblMultiWord, sizeof(m_bTbcLblMultiWord));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcLblRegexp", (BYTE*)&m_bTbcLblRegexp, sizeof(m_bTbcLblRegexp));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcLblAsUppercase", (BYTE*)&m_bTbcLblAsUppercase, sizeof(m_bTbcLblAsUppercase));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_iTabChangeNarrow", (BYTE*)&m_iTabChangeNarrow, sizeof(m_iTabChangeNarrow));
	g_pReg->LoadRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcUsrNarrowByUser", (BYTE*)&m_bTbcUsrNarrowByUser, sizeof(m_bTbcUsrNarrowByUser));

//----- 05.11.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCkJiCoHiDfCiDjDiDgHiDiNiBfLiDiLiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
//	UpdateControls();
//	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
//	UpdateActivate();
//----- 05.11.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCPrhHistFindBase::OnSetActive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnKillActive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCkKiDeBiDeOiDgFiDeCiDhFiCmFiCmIiCkNiCmIiCoJiCmGiCkLiCmJiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnKillActive ()
{
//----- 05.11.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
//	UpdateVariables();
//----- 05.11.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiPpDiLlFiCpAjFnLjBlGiClHiCoJ_xHqqkZx_ -----
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchAllDocument", (BYTE*)&m_bTbcSrhSearchAllDocument, sizeof(m_bTbcSrhSearchAllDocument));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchBefore", (BYTE*)&m_bTbcSrhSearchBefore, sizeof(m_bTbcSrhSearchBefore));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchHigher", (BYTE*)&m_bTbcSrhSearchHigher, sizeof(m_bTbcSrhSearchHigher));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchBeforeBranch", (BYTE*)&m_bTbcSrhSearchBeforeBranch, sizeof(m_bTbcSrhSearchBeforeBranch));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchAfter", (BYTE*)&m_bTbcSrhSearchAfter, sizeof(m_bTbcSrhSearchAfter));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcSrhSearchAfterBranch", (BYTE*)&m_bTbcSrhSearchAfterBranch, sizeof(m_bTbcSrhSearchAfterBranch));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcTimTimeFrom", (BYTE*)&m_bTbcTimTimeFrom, sizeof(m_bTbcTimTimeFrom));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcTimTimeUntil", (BYTE*)&m_bTbcTimTimeUntil, sizeof(m_bTbcTimTimeUntil));
	FDSECTIME fdstFrom = COleDtToFdsec(m_otmTbcTimTimeFrom);
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"fdstFrom", (BYTE*)&fdstFrom, sizeof(fdstFrom));
	FDSECTIME fdstUntil = COleDtToFdsec(m_otmTbcTimTimeUntil);
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"fdstUntil", (BYTE*)&fdstUntil, sizeof(fdstUntil));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcLblNarrowByLabel", (BYTE*)&m_bTbcLblNarrowByLabel, sizeof(m_bTbcLblNarrowByLabel));
	m_cmbTbcLblFindString.UpdateRegistory();
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcLblMultiWord", (BYTE*)&m_bTbcLblMultiWord, sizeof(m_bTbcLblMultiWord));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcLblRegexp", (BYTE*)&m_bTbcLblRegexp, sizeof(m_bTbcLblRegexp));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcLblAsUppercase", (BYTE*)&m_bTbcLblAsUppercase, sizeof(m_bTbcLblAsUppercase));
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_iTabChangeNarrow", (BYTE*)&m_iTabChangeNarrow, sizeof(m_iTabChangeNarrow));
	m_lsvTbcUsrUserList.UpdateRegistory();
	g_pReg->SaveRegBinary(REG_PRH_HIST_FIND_BASE, L"m_bTbcUsrNarrowByUser", (BYTE*)&m_bTbcUsrNarrowByUser, sizeof(m_bTbcUsrNarrowByUser));
} // CFCPrhHistFindBase::OnKillActive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::UpdateControls
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPjAjEiCmMjCgMiCmFiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::UpdateControls ()
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiCmFiCkLiCoJiPoKiNiHiCmNiBeB_xHqqkZx_m_projectCopy _xZkqqHx_iCmMjCgMiCpAiNmFjAfGiCmJiClHiCoJiBeC_xHqqkZx_
	PrepareProjectCopy();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateData(FALSE);
	// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNiCmMiMjPiNpFjFlGiOjKjHpBiCpAjAnNjCoIiBeC_xHqqkZx_
	FFSetDlgItemText(this, IDC_HFD_TBC_LBL_CMB_FIND_STRING, m_wstrTbcLblFindString);
	// _xZkqqHx_iNgJiNjOiCnNiDfOiDhFiCpAjAnNjCoIiBeC_xHqqkZx_
	m_tabChangeNarrow.SetCurSel(m_iTabChangeNarrow);
	// _xZkqqHx_iNgJiNjOiCnNiDiGiBfLiDfFiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lsvTbcUsrUserList.ClearUser();
	set<GUID>::const_iterator iId;
	for (iId = m_stSelectedUserId.begin(); iId != m_stSelectedUserId.end(); iId++)
	{
		// _xZkqqHx_iNgJiNjOiCnNiDiGiBfLiDfFiDiKiDfIiDgHiCmJiDiGiBfLiDfFiCpAjCmHiJmBiBeC_xHqqkZx_
		if (*iId == GUID_NULL)
// 06.04.29 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			m_lsvTbcUsrUserList.AddUser(*iId, FFLoadWString(IDS_UNSET));
			m_lsvTbcUsrUserList.AddUser(*iId, FFLoadWString(IDS_GUEST));
		else
			m_lsvTbcUsrUserList.AddUser(*iId, m_projectCopy.UserIdToUserName(*iId));
	}
} // CFCPrhHistFindBase::UpdateControls.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::UpdateVariables
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiBeBjFmPjAjEiCmMjCgMiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::UpdateVariables ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateData(TRUE);
	// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNiCmMiMjPiNpFjFlGiOjKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	FFGetDlgItemText(this, IDC_HFD_TBC_LBL_CMB_FIND_STRING, m_wstrTbcLblFindString);
	// _xZkqqHx_iNgJiNjOiCnNiDfOiDhFiCpAiOoGjDlOiBeC_xHqqkZx_
	m_iTabChangeNarrow = m_tabChangeNarrow.GetCurSel();
	// _xZkqqHx_iNgJiNjOiCnNiDiGiBfLiDfFiDiKiDfIiDgHiCkJiCoHiDiGiBfLiDfFiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	m_lsvTbcUsrUserList.GetUserId(m_stSelectedUserId);
} // CFCPrhHistFindBase::UpdateVariables.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myChangeVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiPpDjBnEiCpAjAnIiCoIjBnGiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCtrl		:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bVisible	:_xZkqqHx_jFfMiOkGiBeFjEpBjFfMiOkGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCfAjFlGiOjKiDfCiDhNiDjDiDgIiCkKiKlBiPmCiClFiCmIiCkCiCoGiCkEiBeBjEpBjFfMiOkGiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiCmNjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myChangeVisible (CWnd* pCtrl, BOOL bVisible)
{
	if (!bVisible)
	//----- _xZkqqHx_jEpBjFfMiOkGiCmJjAnIiCoIjBnGiCoNiCoJiPoKiNiH_xHqqkZx_ -----
	{
		WString wstrText;
		FFGetWindowText(pCtrl, wstrText);
		wstrText.Replace(L"&", L"0x26");
		FFSetWindowText(pCtrl, wstrText);
	} else
	if (bVisible)
	//----- _xZkqqHx_jFfMiOkGiCmJjAnIiCoIjBnGiCoNiCoJiPoKiNiH_xHqqkZx_ -----
	{
		WString wstrText;
		FFGetWindowText(pCtrl, wstrText);
		wstrText.Replace(L"0x26", L"&");
		FFSetWindowText(pCtrl, wstrText);
	}
	pCtrl->ShowWindow(bVisible ? SW_SHOW : SW_HIDE);
} // myChangeVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::UpdateActivate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::UpdateActivate ()
{
	//----- _xZkqqHx_iDfOiDhFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjAnNjCoI_xHqqkZx_ -----
	if (m_iTabChangeNarrow != m_iTabChangeNarrowOld)
	{
		int iTabIndex;
		for (iTabIndex = 0; iTabIndex <= NARROW_TAB_USER; iTabIndex++)
		{
			CString strTabTitle;
			GetDlgItemText(IDC_HFD_TBC_STC_SEARCH_AREA_TITLE + iTabIndex, strTabTitle);
			if (iTabIndex == m_iTabChangeNarrow - 1)
			{
				CString strPrevLetter;
				GetDlgItemText(IDC_HFD_BTN_PREV_TAB, strPrevLetter);
// 06.04.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//				strTabTitle += strPrevLetter;
				strTabTitle = strPrevLetter + strTabTitle;
			} else
			if (iTabIndex == m_iTabChangeNarrow + 1)
			{
				CString strNextLetter;
				GetDlgItemText(IDC_HFD_BTN_NEXT_TAB, strNextLetter);
// 06.04.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//				strTabTitle += strNextLetter;
				strTabTitle = strNextLetter + strTabTitle;
			}

			TCITEM item;
			item.mask = TCIF_TEXT;
			item.pszText = (TCHAR*)(const _TCHAR*)strTabTitle;
			m_tabChangeNarrow.SetItem(iTabIndex, &item);
		}
		m_iTabChangeNarrowOld = m_iTabChangeNarrow;
	}

	//----- _xZkqqHx_iNgJiNjOiCnNiDfOiDhFiCmMjFmPiNfIiCmJjElKiCkEjFfMiOkGiBeFjEpBjFfMiOkGiCpAjFmPiNfI_xHqqkZx_ -----
	BOOL bSearchCtrlShow = FALSE;
	BOOL bDateCtrlShow = FALSE;
	BOOL bLabelCtrlShow = FALSE;
	BOOL bUserCtrlShow = FALSE;

	switch (m_iTabChangeNarrow)
	{
	case NARROW_TAB_SEARCH_AREA:	// _xZkqqHx_iMjPiNpFjEmNiImNiBeC_xHqqkZx_
		bSearchCtrlShow = TRUE;
		break;
	case NARROW_TAB_DATE:			// _xZkqqHx_jDpKiOjOiNgJiNjOiCnNiBeC_xHqqkZx_
		bDateCtrlShow = TRUE;
		break;
	case NARROW_TAB_LABEL:			// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNiBeC_xHqqkZx_
		bLabelCtrlShow = TRUE;
		break;
	case NARROW_TAB_USER:			// _xZkqqHx_iDiGiBfLiDfFiNgJiNjOiCnNiBeC_xHqqkZx_
		bUserCtrlShow = TRUE;
		break;
	}

	long lC;
	for (lC = 0; s_aSearchCtrlId[lC] != 0; lC++)
		myChangeVisible(GetDlgItem(s_aSearchCtrlId[lC]), bSearchCtrlShow);
	for (lC = 0; s_aDateCtrlId[lC] != 0; lC++)
		myChangeVisible(GetDlgItem(s_aDateCtrlId[lC]), bDateCtrlShow);
	for (lC = 0; s_aLabelCtrlId[lC] != 0; lC++)
		myChangeVisible(GetDlgItem(s_aLabelCtrlId[lC]), bLabelCtrlShow);
	for (lC = 0; s_aUserCtrlId[lC] != 0; lC++)
		myChangeVisible(GetDlgItem(s_aUserCtrlId[lC]), bUserCtrlShow);

	//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCpAjAnNjCoI_xHqqkZx_ -----

	// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
	GetDlgItem(IDC_HFD_TBC_LBL_STC0)->EnableWindow(m_bTbcLblNarrowByLabel);
	GetDlgItem(IDC_HFD_TBC_LBL_CMB_FIND_STRING)->EnableWindow(m_bTbcLblNarrowByLabel);
	GetDlgItem(IDC_HFD_TBC_LBL_CHK_MULTI_WORD)->EnableWindow(m_bTbcLblNarrowByLabel);
	GetDlgItem(IDC_HFD_TBC_LBL_CHK_REGEXP)->EnableWindow(m_bTbcLblNarrowByLabel);
	GetDlgItem(IDC_HFD_TBC_LBL_CHK_AS_UPPERCASE)->EnableWindow(m_bTbcLblNarrowByLabel);

	// _xZkqqHx_iMjPiNpFjEmNiImNiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
	GetDlgItem(IDC_HFD_TBC_SRH_CHK_SEARCH_BEFORE)->EnableWindow(!m_bTbcSrhSearchAllDocument);
	GetDlgItem(IDC_HFD_TBC_SRH_CHK_SEARCH_HIGHER)->EnableWindow(!m_bTbcSrhSearchAllDocument && m_bTbcSrhSearchBefore);
	GetDlgItem(IDC_HFD_TBC_SRH_CHK_SEARCH_BEFORE_BRANCH)->EnableWindow(!m_bTbcSrhSearchAllDocument && m_bTbcSrhSearchBefore);
	GetDlgItem(IDC_HFD_TBC_SRH_CHK_SEARCH_AFTER)->EnableWindow(!m_bTbcSrhSearchAllDocument);
	GetDlgItem(IDC_HFD_TBC_SRH_CHK_SEARCH_AFTER_BRANCH)->EnableWindow(!m_bTbcSrhSearchAllDocument && m_bTbcSrhSearchAfter);

	//----- _xZkqqHx_jDpKiOjOiNgJiCoIiNjOiCnNiDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ -----
	GetDlgItem(IDC_HFD_TBC_TIM_STC0)->EnableWindow(m_bTbcTimTimeFrom);
	GetDlgItem(IDC_HFD_TBC_TIM_DTM_TIME_FROM)->EnableWindow(m_bTbcTimTimeFrom);
	GetDlgItem(IDC_HFD_TBC_TIM_STC1)->EnableWindow(m_bTbcTimTimeUntil);
	GetDlgItem(IDC_HFD_TBC_TIM_DTM_TIME_UNTIL)->EnableWindow(m_bTbcTimTimeUntil);

	// _xZkqqHx_iDiGiBfLiDfFiNgJiNjOiCnNiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
	GetDlgItem(IDC_HFD_TBC_USR_BTN_SELECT_USER)->EnableWindow(m_bTbcUsrNarrowByUser);
	GetDlgItem(IDC_HFD_TBC_USR_LSV_USER_LIST)->EnableWindow(m_bTbcUsrNarrowByUser);
} // CFCPrhHistFindBase::UpdateActivate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::GetRegName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClHiCoJiClNiCnPiCmMjDgPjIfOjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClHiCoJiClNiCnPiCmMjDgPjIfOjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CFCPrhHistFindBase::GetRegName () const
{
	return REG_PRH_HIST_FIND_BASE;
} // CFCPrhHistFindBase::GetRegName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::IsConsistent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLjAnNjCoIjCgMiCmMjGlFiPiCjAkLiCmMiDgAiDeGiDgCiDeOiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGlDjGlFiPiCiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjGlFiPiCiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPrhHistFindBase::IsConsistent ()
{
	if (!g_pProject->IsProjectOpened())
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_MSG_PROJECT_NOT_OPENED = "_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCnMiClJiCpB_xHqqkZx_"
		FFErrorBox(IDS_ERR_MSG_PROJECT_NOT_OPENED);
		return FALSE;
	}

	if (m_bTbcLblNarrowByLabel && m_wstrTbcLblFindString.IsEmpty())
	//----- _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmEiBeBiKiOiCmCiMjPiNpFjFlGiOjKjHpBiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_MSG_EXPRESSION_NOT_SET = "_xZkqqHx_iMjPiNpFjFlGiOjKjHpBiCkKjAnNjCoIiClDiCoKiCmEiCkCiCnMiClJiCpB_xHqqkZx_"
		FFErrorBox(IDS_ERR_MSG_EXPRESSION_NOT_SET);
		return FALSE;
	}

	if (m_bTbcTimTimeFrom && m_bTbcTimTimeUntil)
	//----- _xZkqqHx_jDpKiOjOiNgJiCoIiNjOiCnNiCkKjHlMjFpLiDgAiDeGiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (m_otmTbcTimTimeUntil < m_otmTbcTimTimeFrom)
		{
			// IDS_ERR_MSG_START_DATE_BEYOND_AFTER = "_xZkqqHx_iKeKiOgOjDpKiOjOiCoGiCoIiPeJjHlJjDpKiOjOiCkKjBePiCmJjAnNjCoIiClDiCoKiCmEiCkCiCnMiClH_xHqqkZx_"
			FFErrorBox(IDS_ERR_MSG_START_DATE_BEYOND_AFTER);
			return FALSE;
		}
	}
	// _xZkqqHx_jBfDjFlGiPjBiMjPiNpFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
	BOOL bTbcSrhSearchAllDocument = m_bTbcSrhSearchAllDocument;
	// _xZkqqHx_iDgAiDeGiDgCiDeOiDhLiDgCiDeOiDfIiCkKjDpMjHmNjFhDiJmCiCmJiCmIiCmBiCmEiCkCiCoKiCmOiBeBiMjPiNpFiCoAjFhDiJmCiCmGiCnNiCmIiClHiBeC_xHqqkZx_
	if (!GetDlgItem(IDC_HFD_TBC_SRH_CHK_SEARCH_ALL_DOCUMENT)->IsWindowEnabled())
		bTbcSrhSearchAllDocument = FALSE;
	if (!bTbcSrhSearchAllDocument && !m_bTbcSrhSearchBefore && !m_bTbcSrhSearchAfter)
	//----- _xZkqqHx_iMjPiNpFjEmNiImNiCmMiCkCiClIiCoKiCoAiDgAiDeGiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_MSG_TARGET_AREA_NOT_SET = "_xZkqqHx_iMjPiNpFjEmNiImNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCnMiClJiCpB_xHqqkZx_"
		FFErrorBox(IDS_ERR_MSG_TARGET_AREA_NOT_SET);
		return FALSE;
	}

	// _xZkqqHx_jBfDjFlGiPjBiMjPiNpFiImIiKePiCmMiPoKiNiHiCmFiBeBjHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (!bTbcSrhSearchAllDocument && !g_pDoc->GetIsDocumentOpened())
	{
		// IDS_ERR_MSG_DOCUMENT_NOT_OPENED = "_xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCnMiClJiCpB_xHqqkZx_"
		FFErrorBox(IDS_ERR_MSG_DOCUMENT_NOT_OPENED);
		return FALSE;
	}

	return TRUE;
} // CFCPrhHistFindBase::IsConsistent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::UpdateComboStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDeHiDgGiDeCiDgCiDgHiDhLiDgCiDeOiDfIjCiGiCmMjFlGiOjKjHpBiCpAiDiKiDfIiDgHiCnGiInKiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::UpdateComboStr ()
{
//----- 05.11.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jDkPiClGjFlGiOjKjHpBiCkKiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiCkAiCoJiCkJiCmHiCkEiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	int iSameStr = m_cmbTbcLblFindString.FindStringExact(0, WStrToTStr(m_wstrTbcLblFindString));
//	// _xZkqqHx_jDkPiClGjFlGiOjKjHpBiCkKiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDiKiDfIiDgHiCmJjHeMiCoJiPoKiNiHiCmNiBeBiNoNiPjMiBeC_xHqqkZx_
//	if (iSameStr != CB_ERR) m_cmbTbcLblFindString.DeleteString(iSameStr);
//	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiNmFiPiJiCmJjFlGiOjKjHpBiCpAjBhNjDpMiBeC_xHqqkZx_
//	m_cmbTbcLblFindString.InsertString(0, WStrToTStr(m_wstrTbcLblFindString));
//	// _xZkqqHx_jBhNjDpMiClFiClNjFlGiOjKjHpBiCpAjBeJjBpAiPpDjBnEiCmJiBeC_xHqqkZx_
//	m_cmbTbcLblFindString.SetCurSel(0);
//----- 05.11.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
	FFUpdateTextComboList(&m_cmbTbcLblFindString);
//----- 05.11.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCPrhHistFindBase::UpdateComboStr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::DoFind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::DoFind ()
{
} // CFCPrhHistFindBase::DoFind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::GetLabelIdToStringMap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMjFlGiPjBiCmMiBeBiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCmMiDgOiDgCiDfGiDiFiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpLabelIdToString	:_xZkqqHx_iDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCmMiDgOiDgCiDfGiDiFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::GetLabelIdToStringMap (ObjIdToWStringMap& mpLabelIdToString) const
{
	// _xZkqqHx_iMlLiNnNiCmMiDiJiDhIiDiLiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	FCLabelStidRecVector vLabelStid;
	g_pDoc->GetObjLabelStid(vLabelStid);
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID->_xZkqqHx_iDiJiDhIiDiLiDgFiBfLiDhFiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
	FCLabelStidRecVector::const_iterator iLbl;
	for (iLbl = vLabelStid.begin(); iLbl != vLabelStid.end(); iLbl++)
		mpLabelIdToString[(*iLbl)->pObjLabel->GetObjID()] = (*iLbl)->wstrLabel;
} // CFCPrhHistFindBase::GetLabelIdToStringMap.

//----- 05.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::CheckSearchButton
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhLiDfOiDjDiCpAiJjPiClDiCoKiClNiPpDjBnEiCmJiBeBjBlMiCmMiDhLiDfOiDjDiCpAjHkDiClFiClNiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwControlId	:_xZkqqHx_iJjPiClDiCoKiClNiPpDjBnEiCmMiDhLiDfOiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCPrhHistFindBase::CheckSearchButton (DWORD dwControlId)
//{
//	DWORD dwaControls[] = {
//		IDC_HFD_CHK_SEARCH_OBJECT,
//		IDC_HFD_CHK_SEARCH_LINK,
//		IDC_HFD_CHK_SEARCH_LABEL,
//		IDC_HFD_CHK_SEARCH_HIDOCUMENT,
//		IDC_HFD_CHK_SEARCH_DATE };
//	long lC;
//	for (lC = 0; lC < sizeof(dwaControls) / sizeof(dwaControls[0]); lC++)
//		CheckDlgButton(dwaControls[lC], dwaControls[lC] == dwControlId);
//} // CFCPrhHistFindBase::CheckSearchButton.
//----- 05.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::GetNarrowTimeFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiKeKiOgOiOjOiKnEiCpAiOoGjDlOiBeCiNgJiCoIiClBiCnMiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iNmFiPkMjCgM_xHqqkZx_(FDSECTIME_MIN)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiKeKiOgOiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME CFCPrhHistFindBase::GetNarrowTimeFrom () const
{
	// _xZkqqHx_iNgJiNjOiCnNiCmMiOjOiKnEiCpAiOfKiPgPiBeCiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiNmFiPkMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	return m_bTbcTimTimeFrom ? COleDtToFdsec(m_otmTbcTimTimeFrom) : FDSECTIME_MIN;
} // CFCPrhHistFindBase::GetNarrowTimeFrom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::GetNarrowTimeUntil
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiPeJjHlJiOjOiKnEiCpAiOoGjDlOiBeCiNgJiCoIiClBiCnMiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iNmFiPkMjCgM_xHqqkZx_(FDSECTIME_MAX)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiPeJjHlJiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME CFCPrhHistFindBase::GetNarrowTimeUntil () const
{
	// _xZkqqHx_iNgJiNjOiCnNiCmMiOjOiKnEiCpAiOfKiPgPiBeCiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiNmFjBoFjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	return m_bTbcTimTimeUntil ? COleDtToFdsec(m_otmTbcTimTimeUntil) : FDSECTIME_MAX;
} // CFCPrhHistFindBase::GetNarrowTimeUntil.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::GetNarrowUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiNgJiNjOiCnNiCmMiDiGiBfLiDfFjEhKjHpBiCpAjFnEiClHiBeCiNgJiCoIiNjOiCnMiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iLpDiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiNgJiNjOiCnNiCmMiDiGiBfLiDfFjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const set<GUID>& CFCPrhHistFindBase::GetNarrowUserId () const
{
	static set<GUID> stDummy;
	return m_bTbcUsrNarrowByUser ? m_stSelectedUserId : stDummy;
} // CFCPrhHistFindBase::GetNarrowUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::PrepareProjectCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiCmFiCkLiCoJiPoKiNiHiCmNiBeB_xHqqkZx_m_projectCopy _xZkqqHx_iCmMjCgMiCpAiNmFjAfGiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiHiCmNjBePiJpBiCmMjCgMiCpAiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::PrepareProjectCopy ()
{
	if (!g_pProject->IsProjectOpened())
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDhDiBfLiBeC_xHqqkZx_
		m_projectCopy.Clear();
	} else
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// Document_xZkqqHx_iImIiKePiCmF_xHqqkZx_g_pProject_xZkqqHx_iCpA_xHqqkZx_UpdateData_xZkqqHx_iClFiClNiCkNiCmIiCkCiCmMiCmFiBeB_xHqqkZx_
		// _xZkqqHx_jFmKiCmMjFmPjAjE_xHqqkZx_ project _xZkqqHx_iCpAjHhAiInDiClHiCoJiBeC_xHqqkZx_
		FCHiProject project = g_pFileServer->GetTopGroup(g_pProject->GetFilePathH());
		// _xZkqqHx_iDiNiDgCiDeOiClHiCoJiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
		FCDbReadLock autoLockProjectRead;
		if (project.TryLock(autoLockProjectRead))
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
		{
			project.UpdateData(autoLockProjectRead);
			m_projectCopy = project;
		}
	}
} // CFCPrhHistFindBase::PrepareProjectCopy.

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindBase _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPrhHistFindBase::OnInitDialog ()
{
//----- 05.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMjDpKiCmJiClPiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_otmTbcTimTimeFrom = COleDateTime::GetCurrentTime();
//	m_otmTbcTimTimeUntil = COleDateTime::GetCurrentTime();
//----- 05.01.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::OnInitDialog())
		return FALSE;

	// HELP_xZkqqHx_iDhLiDfOiDjDiCmMiJeFiJlKiCmJiDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAjFmPiNfIiBeC_xHqqkZx_
	CRect rtHelp;
	GetDlgItem(IDC_HFD_BTN_HELP)->GetWindowRect(rtHelp);
	CRect rtShowResults;
	GetDlgItem(IDC_HFD_BTN_SHOW_RESULTS_PANEL)->GetWindowRect(rtShowResults);
	// _xZkqqHx_jDeLjDjGiCmIiDeNiDiDiDgCiDhGiCpAiMhGiOfKiBeC_xHqqkZx_
	const long pxGap = rtHelp.left - rtShowResults.right;
	ScreenToClient(rtHelp);
	MoveWindow(0, 0, rtHelp.right + pxGap, rtHelp.bottom + pxGap, FALSE);

//----- 05.11.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_cmbTbcLblFindString.Initialize(REG_PRH_HIST_FIND_BASE, L"IDC_HFD_TBC_LBL_CMB_FIND_STRING");
//----- 05.11.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iDfOiDhFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjAnNjCoI_xHqqkZx_ -----
	m_tabChangeNarrow.InsertItem(NARROW_TAB_SEARCH_AREA, _T(""));
	m_tabChangeNarrow.InsertItem(NARROW_TAB_DATE, _T(""));
	m_tabChangeNarrow.InsertItem(NARROW_TAB_LABEL, _T(""));
	m_tabChangeNarrow.InsertItem(NARROW_TAB_USER, _T(""));

	//----- _xZkqqHx_iDfOiDhFiDfCiDjDiDgHiDiNiBfLiDiLiImKjChFiCnGiDfCiDjDiDgHiDiNiBfLiDiLiCpAiInKjDkO_xHqqkZx_ -----

	DWORD* aCtrlIdArray[] =
	{
		s_aSearchCtrlId,
		s_aDateCtrlId,
		s_aLabelCtrlId,
		s_aUserCtrlId,
	};

	CRect rectTab;
	GetDlgItem(IDC_HFD_TBC_STC_TAB_AREA)->GetWindowRect(rectTab);
	long lC;
	for (lC = 0; lC < sizeof(aCtrlIdArray) / sizeof(aCtrlIdArray[0]); lC++)
	{
		DWORD* aCtrlId = aCtrlIdArray[lC];
		CRect rect;
		GetDlgItem(aCtrlId[0])->GetWindowRect(rect);
		// _xZkqqHx_iInKjDkOiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
		long lOffX = rectTab.left - rect.left;
		long lOffY = rectTab.top - rect.top;
		for (long lE = 0; aCtrlId[lE] != 0; lE++)
		{
			CRect rtWindow;
			GetDlgItem(aCtrlId[lE])->GetWindowRect(rtWindow);
			::MapWindowPoints(HWND_DESKTOP, GetSafeHwnd(), LPPOINT(&rtWindow), 2);
			rtWindow += CSize(lOffX, lOffY);
			GetDlgItem(aCtrlId[lE])->MoveWindow(rtWindow.left, rtWindow.top, rtWindow.Width(), rtWindow.Height());
		}
	}

	//----- _xZkqqHx_jDpKiCmJiClPjFfMiOkGiCpA_xHqqkZx_ 1999_xZkqqHx_jEeO_xHqqkZx_ 2_xZkqqHx_iMiO_xHqqkZx_ 9_xZkqqHx_jDpK_xHqqkZx_ 14_xZkqqHx_iOjO_xHqqkZx_21_xZkqqHx_jFkK_xHqqkZx_ _xZkqqHx_iCmMiMgAiOkOiCmJiPeDjAlD_xHqqkZx_ -----
	CString strForm;
	strForm.LoadString(IDS_FORM_DATE_TIME_LONG_2);
	((CDateTimeCtrl*)GetDlgItem(IDC_HFD_TBC_TIM_DTM_TIME_FROM))->SetFormat(strForm);
	((CDateTimeCtrl*)GetDlgItem(IDC_HFD_TBC_TIM_DTM_TIME_UNTIL))->SetFormat(strForm);

	// _xZkqqHx_iDiGiBfLiDfFiDiKiDfIiDgHiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_lsvTbcUsrUserList.Initialize(REG_PRH_HIST_FIND_BASE, L"IDC_HFD_TBC_USR_LSV_USER_LIST");
	// _xZkqqHx_iMjPiNpFjEmNiImNiBeC_xHqqkZx_
	m_iTabChangeNarrow = NARROW_TAB_SEARCH_AREA;

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);

	// FFJustifyWindow _xZkqqHx_iCmNiMmEiCpBiCmFiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiDeFiDeCiDjDiDgIiDeFiCmNiBeB_xHqqkZx_CFCWndHistFindPanel _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfEiDhFiDeFiDeCiDjDiDgIiDeFiCmGiClFiCmE_xHqqkZx_
	// _xZkqqHx_iOgHiCoNiCoKiCoJiClNiCnPiBeC_xHqqkZx_

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	UpdateControls();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCPrhHistFindBase::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdTbcLblChkNarrowByLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdTbcLblChkNarrowByLabel ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindBase::OnHfdTbcLblChkNarrowByLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdTbcTimChkTimeFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdTbcTimChkTimeFrom ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindBase::OnHfdTbcTimChkTimeFrom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdTbcTimChkTimeUntil
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdTbcTimChkTimeUntil ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindBase::OnHfdTbcTimChkTimeUntil.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdTbcSrhChkSearchAllDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdTbcSrhChkSearchAllDocument ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindBase::OnHfdTbcSrhChkSearchAllDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdTbcSrhChkSearchAbove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdTbcSrhChkSearchAbove ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindBase::OnHfdTbcSrhChkSearchAbove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdTbcSrhChkSearchBelow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdTbcSrhChkSearchBelow ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindBase::OnHfdTbcSrhChkSearchBelow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdBtnDoNewFind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFjAfGiLeLiMjPiNpFiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdBtnDoNewFind ()
{
	// _xZkqqHx_iMiLiJmKjFfMiOkGiDfPiDeDiDeBiDiNiDePiCmJiBeBiDiKiDfIiDgHiPmBiLiOiDhLiDfOiDjDiCmMiDiBiDgCiDfKiBfLiDfHiCpAjBjHiCoJiBeC_xHqqkZx_
	FFHistViewFrame()->GetHtreeFindResults()->SendMessage(WM_COMMAND, MAKELPARAM(IDC_HFR_BTN_CLEAR_LIST, BN_CLICKED), 0);
	// _xZkqqHx_iClBiCmMiDfPiDeDiDeBiDiNiDePiCmJiBeBiMjPiNpFiDhLiDfOiDjDiCmMiDiBiDgCiDfKiBfLiDfHiCpAjBjHiCoJiBeC_xHqqkZx_
	SendMessage(WM_COMMAND, MAKELPARAM(IDC_HFD_BTN_DO_FIND, BN_CLICKED), 0);
} // CFCPrhHistFindBase::OnHfdBtnDoNewFind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdBtnDoFind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiMjPiNpFiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdBtnDoFind ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIjCiGiCmMiDiKiDfIiDgHiPiIjHjNiBeC_xHqqkZx_
	UpdateComboStr();
	// _xZkqqHx_jAnNjCoIjCgMiCmMjGlFiPiCiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!IsConsistent()) return;
	// _xZkqqHx_iMjPiNpFiPiIjHjNiBeC_xHqqkZx_
	DoFind();
	// _xZkqqHx_iMiLiJmKjFfMiOkGiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FFHistViewFrame()->GetHtreeFindResults()->ShowWindow(SW_SHOW);
	FFHistViewFrame()->GetHtreeFindResults()->SetWindowVisible(TRUE);
	FFHistViewFrame()->GetHtreeFindResults()->SetFocus();
	// _xZkqqHx_iMiLiJmKjFfMiOkGiDfPiDeDiDeBiDiNiDePiCmMiDiKiDfIiDgHiDhCiDiFiBfLiCpAiNfIjAfGiBeC_xHqqkZx_
	FFHistViewFrame()->GetHtreeFindResults()->UpdateList();
} // CFCPrhHistFindBase::OnHfdBtnDoFind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnCancel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmCiClGiCoJiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnCancel ()
{
//----- 05.11.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAjEpBjFfMiOkGiCmJiClHiCoJiBeC_xHqqkZx_
//	AfxDebugBreak();
//	GetParent()->ShowWindow(SW_HIDE);
//----- 05.11.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAjEpBjFfMiOkGiCmJiClHiCoJiBeC_xHqqkZx_WM_CLOSE_xZkqqHx_iCmFjEpBjFfMiOkGiCmJiClHiCoJiClBiCmGiBeC_xHqqkZx_
	GetParent()->SendMessage(WM_CLOSE);
//----- 05.11.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCPrhHistFindBase::OnCancel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnSelchangeHfdTabChangeNarrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDhFiDfCiDjDiDgHiDiNiBfLiDiLiCkKjAnIiCoIjBnGiCkGiCoHiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnSelchangeHfdTabChangeNarrow (NMHDR* pNMHDR, LRESULT* pResult)
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	*pResult = 0;
} // CFCPrhHistFindBase::OnSelchangeHfdTabChangeNarrow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdTbcUsrBtnSelectUser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiMjPiNpFjBmOiPnLiDiGiBfLiDfFiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdTbcUsrBtnSelectUser ()
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiCmFiCkLiCoJiPoKiNiHiCmNiBeB_xHqqkZx_m_projectCopy _xZkqqHx_iCmMjCgMiCpAiNmFjAfGiCmJiClHiCoJiBeC_xHqqkZx_
	PrepareProjectCopy();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	CFCDlgSelectUser dlg;
	dlg.Initialize(&m_projectCopy, TRUE);
	dlg.SetSelectedUserId(m_stSelectedUserId);
	if (dlg.DoModal() == IDOK)
	{
		// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
		dlg.GetSelectedUserId(m_stSelectedUserId);
		// _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCkJiCoHiDfCiDjDiDgHiDiNiBfLiDiLiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
		UpdateControls();
	}
} // CFCPrhHistFindBase::OnHfdTbcUsrBtnSelectUser.

//----- 05.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdChkSearchObject
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjFjEjFgJiMjPiNpFiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCPrhHistFindBase::OnHfdChkSearchObject ()
//{
//	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjAgFiDeFiDeCiDjDiDgIiDeFiCnGjDfNjBjHiClHiCoJiBeC_xHqqkZx_
//	MSG msg = *GetCurrentMessage();
//	GetParent()->PostMessage(msg.message, msg.wParam, msg.lParam);
//	// _xZkqqHx_iDhLiDfOiDjDiCpAiJjPiClFiClNiPpDjBnEiCpAjAnIiCoIjBnGiCkGiCoJiBeC_xHqqkZx_
//	CheckSearchButton(LOWORD(msg.wParam));
//} // CFCPrhHistFindBase::OnHfdChkSearchObject.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdChkSearchLink
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDiKiDjDiDeOiMjPiNpFiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCPrhHistFindBase::OnHfdChkSearchLink ()
//{
//	OnHfdChkSearchObject();
//} // CFCPrhHistFindBase::OnHfdChkSearchLink.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdChkSearchLabel
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDiJiDhIiDiLiMjPiNpFiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCPrhHistFindBase::OnHfdChkSearchLabel ()
//{
//	OnHfdChkSearchObject();
//} // CFCPrhHistFindBase::OnHfdChkSearchLabel.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdChkSearchHidocument
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjFlGiPjBjGlMiMjPiNpFiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCPrhHistFindBase::OnHfdChkSearchHidocument ()
//{
//	OnHfdChkSearchObject();
//} // CFCPrhHistFindBase::OnHfdChkSearchHidocument.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdChkSearchDate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjDpKiOjOiMjPiNpFiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCPrhHistFindBase::OnHfdChkSearchDate ()
//{
//	OnHfdChkSearchObject();
//} // CFCPrhHistFindBase::OnHfdChkSearchDate.
//----- 05.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdTbcUsrChkNarrowByUser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDiGiBfLiDfFiCmFiNgJiCoIiNjOiCnOiBhGiDgAiDeGiDgCiDeOiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdTbcUsrChkNarrowByUser ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindBase::OnHfdTbcUsrChkNarrowByUser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdBtnPrevTab
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBePiCmMiDfOiDhFiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdBtnPrevTab ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_jBePiCmMiDfOiDhFiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_iTabChangeNarrow == 0) return;
	// _xZkqqHx_jBePiCmMiDfOiDhFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	m_iTabChangeNarrow--;
	// _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCkJiCoHiDfCiDjDiDgHiDiNiBfLiDiLiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateControls();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindBase::OnHfdBtnPrevTab.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdBtnNextTab
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiCmMiDfOiDhFiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdBtnNextTab ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iOjPiCmMiDfOiDhFiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_iTabChangeNarrow == m_tabChangeNarrow.GetItemCount() - 1) return;
	// _xZkqqHx_iOjPiCmMiDfOiDhFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	m_iTabChangeNarrow++;
	// _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCkJiCoHiDfCiDjDiDgHiDiNiBfLiDiLiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateControls();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindBase::OnHfdBtnNextTab.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnSelchangeHfdCmbSelectSearchType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDfOiDeDiDhGiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnSelchangeHfdCmbSelectSearchType ()
{
//----- 05.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	CComboBox* pBox = (CComboBox*)GetDlgItem(IDC_HFD_CMB_SELECT_SEARCH_TYPE);
//	pBox->GetCurSel();
//----- 05.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjAgFiDeFiDeCiDjDiDgIiDeFiCnGjDfNjBjHiClHiCoJiBeC_xHqqkZx_
	MSG msg = *GetCurrentMessage();
	GetParent()->PostMessage(msg.message, msg.wParam, msg.lParam);
} // CFCPrhHistFindBase::OnSelchangeHfdCmbSelectSearchType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdBtnHelp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDiLiDhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdBtnHelp ()
{
	// _xZkqqHx_iDhHiDiLiDhGiCpAiLeOjDkOiBeC_xHqqkZx_
	FFGetApp()->WinHelp(HID_BASE_RESOURCE + m_dwHelpId);
} // CFCPrhHistFindBase::OnHfdBtnHelp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindBase::OnHfdBtnShowResultsPanel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiLiJmKiDhAiDgMiDiLiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindBase::OnHfdBtnShowResultsPanel ()
{
	// _xZkqqHx_iMiLiJmKjFfMiOkGiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FFHistViewFrame()->GetHtreeFindResults()->ShowWindow(SW_SHOW);
	FFHistViewFrame()->GetHtreeFindResults()->SetWindowVisible(TRUE);
	FFHistViewFrame()->GetHtreeFindResults()->SetFocus();
} // CFCPrhHistFindBase::OnHfdBtnShowResultsPanel.
