// PrhHistFindDocument.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "HistViewDoc.h"			// For FFHistViewDoc().
#include "HistViewFrame.h"			// For FFHistViewFrame().
#include "DlgHistFindResults.h"		// For CFCDlgHistFindResults.
#include "HiProject.h"				// For FCHiProject.
#include "PrhHistFindDocument.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKjFnLjBlGjGlM_xHqqkZx_ -----
static const wchar_t* REG_PRH_HIST_FIND_DOCUMENT = L"CFCPrhHistFindDocument";

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindDocument _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDocument::CFCPrhHistFindDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWndResult	:_xZkqqHx_iMjPiNpFiMiLiJmKjFfMiOkGiDhAiDgMiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCPrhHistFindDocument::CFCPrhHistFindDocument ()
						: BASE_CLASS()
{
	//{{AFX_DATA_INIT(CFCPrhHistFindDocument)
	m_bFindDocumentTitle = FALSE;
	m_bFindHiForkTag = FALSE;
	m_bFindComment = FALSE;
	//}}AFX_DATA_INIT
} // CFCPrhHistFindDocument::CFCPrhHistFindDocument.

void CFCPrhHistFindDocument::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCPrhHistFindDocument)
	DDX_Check(pDX, IDC_HFD_DOC_CHK_FIND_DOCUMENT_TITLE, m_bFindDocumentTitle);
	DDX_Check(pDX, IDC_HFD_DOC_CHK_FIND_HI_FORK_TAG, m_bFindHiForkTag);
	DDX_Check(pDX, IDC_HFD_DOC_CHK_FIND_COMMENT, m_bFindComment);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFCPrhHistFindDocument, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCPrhHistFindDocument)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindDocument _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDocument::OnSetActive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCkKiDeBiDeOiDgFiDeCiDhFiCmJiCmIiCoJiCmGiCkLiCmJiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDocument::OnSetActive ()
{
	// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSetActive();
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiPpDiLlFiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	g_pReg->LoadRegBinary(	GetRegName(),
							L"m_bFindDocumentTitle",
							(BYTE*)&m_bFindDocumentTitle,
							sizeof(m_bFindDocumentTitle));
	g_pReg->LoadRegBinary(	GetRegName(),
							L"m_bFindHiForkTag",
							(BYTE*)&m_bFindHiForkTag,
							sizeof(m_bFindHiForkTag));
	g_pReg->LoadRegBinary(	GetRegName(),
							L"m_bFindComment",
							(BYTE*)&m_bFindComment,
							sizeof(m_bFindComment));
} // CFCPrhHistFindDocument::OnSetActive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDocument::OnKillActive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCkKiDeBiDeOiDgFiDeCiDhFiCmFiCmIiCkNiCmIiCoJiCmGiCkLiCmJiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDocument::OnKillActive ()
{
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiPpDiLlFiCpAjFnLjBlGiClHiCoJ_xHqqkZx_ -----
	g_pReg->SaveRegBinary(	GetRegName(),
							L"m_bFindDocumentTitle",
							(BYTE*)&m_bFindDocumentTitle,
							sizeof(m_bFindDocumentTitle));
	g_pReg->SaveRegBinary(	GetRegName(),
							L"m_bFindHiForkTag",
							(BYTE*)&m_bFindHiForkTag,
							sizeof(m_bFindHiForkTag));
	g_pReg->SaveRegBinary(	GetRegName(),
							L"m_bFindComment",
							(BYTE*)&m_bFindComment,
							sizeof(m_bFindComment));
	// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnKillActive();
} // CFCPrhHistFindDocument::OnKillActive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDocument::GetRegName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClHiCoJiClNiCnPiCmMjDgPjIfOjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClHiCoJiClNiCnPiCmMjDgPjIfOjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CFCPrhHistFindDocument::GetRegName () const
{
	return REG_PRH_HIST_FIND_DOCUMENT;
} // CFCPrhHistFindDocument::GetRegName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDocument::IsConsistent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLjAnNjCoIjCgMiCmMjGlFiPiCjAkLiCmMiDgAiDeGiDgCiDeOiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGlDjGlFiPiCiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjGlFiPiCiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPrhHistFindDocument::IsConsistent ()
{
	// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::IsConsistent()) return FALSE;

	if ((!m_bFindDocumentTitle && !m_bFindHiForkTag) ||
		m_wstrTxbFindString.IsEmpty())
	//----- _xZkqqHx_iMjPiNpFjBmOiPnLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_MSG_SEARCH_TARGET_NOT_SPECIFIED = "_xZkqqHx_iMjPiNpFjBmOiPnLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCnMiClJiCpB_xHqqkZx_"
		FFErrorBox(IDS_ERR_MSG_SEARCH_TARGET_NOT_SPECIFIED);
		return FALSE;
	}
	return TRUE;
} // CFCPrhHistFindDocument::IsConsistent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindDocument::DoFind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindDocument::DoFind ()
{
	// CFCDlgHistFindResults_xZkqqHx_iCkJiCoH_xHqqkZx_HistoryFind_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	FCHistoryFind& hf = FFHistViewFrame()->GetHtreeFindResults()->GetHistoryFind();
//----- 06.02.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmNiDeHiDiJiBfLiBeCiOmAiNnLiCmNiMmEiCmOiCoKiCmIiCkCiCmNiClIiBeC_xHqqkZx_
	if (!g_pProject->IsProjectOpened())
		FFThrowMiscUnknown();
	long lDocumentId = FFHistViewDoc()->GetIsDocumentOpened() ? FFHistViewDoc()->GetDocumentId() : -1;
	flint fliNextSessionIndex = FFHistViewDoc()->GetIsDocumentOpened() ? FFHistViewDoc()->GetNextSessionIndex() : -1;
//----- 06.02.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iMjPiNpFiPiIjHjNiBeC_xHqqkZx_
	hf.FindDocument(g_pProject->GetFilePathH(),
					GetNarrowTimeFrom(),
					GetNarrowTimeUntil(),
					GetNarrowUserId(),
					m_bTbcSrhSearchAllDocument,
					m_bTbcSrhSearchBefore,
					m_bTbcSrhSearchHigher,
					m_bTbcSrhSearchBeforeBranch,
					m_bTbcSrhSearchAfter,
					m_bTbcSrhSearchAfterBranch,
					lDocumentId,
					fliNextSessionIndex,
					m_bFindDocumentTitle,
					m_bFindHiForkTag,
					m_bFindComment,
					m_wstrTxbFindString,
					m_bTxbMultiWord,
					m_bTxbRegexp,
					m_bTxbAsUppercase);
} // CFCPrhHistFindDocument::DoFind.

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindDocument _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

