// PrhHistFindText.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "HistViewDoc.h"		// For FFHistViewDoc().
#include "HistViewFrame.h"		// For FFHistViewFrame().
#include "DlgHistFindResults.h"	// For CFCDlgHistFindResults.
#include "HiProject.h"			// For FCHiProject.
#include "PrhHistFindText.h"	// This header.

// Superclass_xZkqqHx_iCmMjCoIiLgAiBeC_xHqqkZx_

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKjFnLjBlGjGlM_xHqqkZx_ -----
static const wchar_t* REG_PRH_HIST_FIND_TEXT = L"CFCPrhHistFindText";

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindText _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindText::CFCPrhHistFindText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWndResult	:_xZkqqHx_iMjPiNpFiMiLiJmKjFfMiOkGiDhAiDgMiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCPrhHistFindText::CFCPrhHistFindText ()
					: BASE_CLASS()
{
	//{{AFX_DATA_INIT(CFCPrhHistFindText)
	m_bSearchBeginOfHit = FALSE;
	m_bSearchEndOfHit = FALSE;
	m_bSearchSelectedInside = FALSE;
	//}}AFX_DATA_INIT
} // CFCPrhHistFindText::CFCPrhHistFindText.

void CFCPrhHistFindText::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCPrhHistFindText)
	DDX_Check(pDX, IDC_HFD_TXT_CHK_SEARCH_BEGIN_OF_HIT, m_bSearchBeginOfHit);
	DDX_Check(pDX, IDC_HFD_TXT_CHK_SEARCH_END_OF_HIT, m_bSearchEndOfHit);
	DDX_Check(pDX, IDC_HFD_TXT_CHK_SEARCH_SELECTED_INSIDE, m_bSearchSelectedInside);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFCPrhHistFindText, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCPrhHistFindText)
	ON_BN_CLICKED(IDC_HFD_TXT_CHK_SEARCH_SELECTED_INSIDE, OnHfdTxtChkSearchSelectedInside)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindText _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindText::OnSetActive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCkKiDeBiDeOiDgFiDeCiDhFiCmJiCmIiCoJiCmGiCkLiCmJiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindText::OnSetActive ()
{
	// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSetActive();
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiPpDiLlFiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	g_pReg->LoadRegBinary(	GetRegName(),
							L"m_bSearchBeginOfHit",
							(BYTE*)&m_bSearchBeginOfHit,
							sizeof(m_bSearchBeginOfHit));
	g_pReg->LoadRegBinary(	GetRegName(),
							L"m_bSearchEndOfHit",
							(BYTE*)&m_bSearchEndOfHit,
							sizeof(m_bSearchEndOfHit));
	g_pReg->LoadRegBinary(	GetRegName(),
							L"m_bSearchSelectedInside",
							(BYTE*)&m_bSearchSelectedInside,
							sizeof(m_bSearchSelectedInside));
} // CFCPrhHistFindText::OnSetActive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindText::OnKillActive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCkKiDeBiDeOiDgFiDeCiDhFiCmFiCmIiCkNiCmIiCoJiCmGiCkLiCmJiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindText::OnKillActive ()
{
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiPpDiLlFiCpAjFnLjBlGiClHiCoJ_xHqqkZx_ -----
	g_pReg->SaveRegBinary(	GetRegName(),
							L"m_bSearchBeginOfHit",
							(BYTE*)&m_bSearchBeginOfHit,
							sizeof(m_bSearchBeginOfHit));
	g_pReg->SaveRegBinary(	GetRegName(),
							L"m_bSearchEndOfHit",
							(BYTE*)&m_bSearchEndOfHit,
							sizeof(m_bSearchEndOfHit));
	g_pReg->SaveRegBinary(	GetRegName(),
							L"m_bSearchSelectedInside",
							(BYTE*)&m_bSearchSelectedInside,
							sizeof(m_bSearchSelectedInside));
	// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnKillActive();
} // CFCPrhHistFindText::OnKillActive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindText::GetRegName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClHiCoJiClNiCnPiCmMjDgPjIfOjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClHiCoJiClNiCnPiCmMjDgPjIfOjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CFCPrhHistFindText::GetRegName () const
{
	return REG_PRH_HIST_FIND_TEXT;
} // CFCPrhHistFindText::GetRegName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindText::IsConsistent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLjAnNjCoIjCgMiCmMjGlFiPiCjAkLiCmMiDgAiDeGiDgCiDeOiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGlDjGlFiPiCiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjGlFiPiCiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPrhHistFindText::IsConsistent ()
{
	// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::IsConsistent()) return FALSE;

	if ((!m_bSearchBeginOfHit && !m_bSearchEndOfHit) ||
		m_wstrTxbFindString.IsEmpty())
	//----- _xZkqqHx_iMjPiNpFjBmOiPnLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_MSG_SEARCH_TARGET_NOT_SPECIFIED = "_xZkqqHx_iMjPiNpFjBmOiPnLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCnMiClJiCpB_xHqqkZx_"
		FFErrorBox(IDS_ERR_MSG_SEARCH_TARGET_NOT_SPECIFIED);
		return FALSE;
	}

	if (m_bSearchSelectedInside && g_pView->SelectObjVector().empty())
	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmJiMmAjCoIiOjOiCmJjFjEjFgJiCkKjBeJjBpAiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_MSG_OBJECT_NOT_SET = "_xZkqqHx_jFjEjFgJiCkKjBeJjBpAiClDiCoKiCmEiCkCiCnMiClJiCpB_xHqqkZx_"
		FFErrorBox(IDS_ERR_MSG_OBJECT_NOT_SET);
		return FALSE;
	}

	return TRUE;
} // CFCPrhHistFindText::IsConsistent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindText::UpdateActivate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindText::UpdateActivate ()
{
	if (m_bSearchSelectedInside)
	//----- _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCmMiCnNiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// m_bTbcSrhSearchAllDocument_xZkqqHx_iBgJjBfDjFlGiPjBiMjPiNpFiBgKiCmMjCgMiCpAjFnLjBlGiClFiBeB_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iPoDjFpLiBeBiJlKjFpLiMjPiNpFiCkKjFhDiJmCiCmGiCmIiCoHiCmIiCkCiCoGiCkEiCmJiClHiCoJiClNiCnPiBeC_xHqqkZx_
		const FCAutoBackup<BOOL> backupSearchAllDocument(m_bTbcSrhSearchAllDocument, FALSE);
		// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::UpdateActivate();
		// _xZkqqHx_jBfDjFlGiPjBiCpAiMjPiNpFiCmNjFhDiJmCiBeC_xHqqkZx_
		GetDlgItem(IDC_HFD_TBC_SRH_CHK_SEARCH_ALL_DOCUMENT)->EnableWindow(FALSE);
	} else
	//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// Superclass_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::UpdateActivate();
		// _xZkqqHx_jBfDjFlGiPjBiCpAiMjPiNpFiCmNiJmCiBeC_xHqqkZx_
		GetDlgItem(IDC_HFD_TBC_SRH_CHK_SEARCH_ALL_DOCUMENT)->EnableWindow(TRUE);
	}
} // CFCPrhHistFindText::UpdateActivate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindText::DoFind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindText::DoFind ()
{
	// CFCDlgHistFindResults_xZkqqHx_iCkJiCoH_xHqqkZx_HistoryFind_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	FCHistoryFind& hf = FFHistViewFrame()->GetHtreeFindResults()->GetHistoryFind();
//----- 06.02.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmNiDeHiDiJiBfLiBeCiOmAiNnLiCmNiMmEiCmOiCoKiCmIiCkCiCmNiClIiBeC_xHqqkZx_
	if (!g_pProject->IsProjectOpened())
		FFThrowMiscUnknown();
	long lDocumentId = FFHistViewDoc()->GetIsDocumentOpened() ? FFHistViewDoc()->GetDocumentId() : -1;
	flint fliNextSessionIndex = FFHistViewDoc()->GetIsDocumentOpened() ? FFHistViewDoc()->GetNextSessionIndex() : -1;
//----- 06.02.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iMjPiNpFiPiIjHjNiBeC_xHqqkZx_
	hf.FindText(g_pProject->GetFilePathH(),
				GetNarrowTimeFrom(),
				GetNarrowTimeUntil(),
				GetNarrowUserId(),
				m_bTbcSrhSearchAllDocument,
				m_bTbcSrhSearchBefore,
				m_bTbcSrhSearchHigher,
				m_bTbcSrhSearchBeforeBranch,
				m_bTbcSrhSearchAfter,
				m_bTbcSrhSearchAfterBranch,
				lDocumentId,
				fliNextSessionIndex,
				m_bSearchBeginOfHit,
				m_bSearchEndOfHit,
				m_bSearchSelectedInside,
				g_pView->SelectObjVector(),
				m_wstrTxbFindString,
				m_bTxbMultiWord,
				m_bTxbRegexp,
				m_bTxbAsUppercase);
} // CFCPrhHistFindText::DoFind.

/////////////////////////////////////////////////////////////////////////////
// CFCPrhHistFindText _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPrhHistFindText::OnHfdTxtChkSearchSelectedInside
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDeGiDgCiDeOiDhLiDfOiDjDiBhFjBeJjBpAiClDiCoKiClNjFjEjFgJiCmJiMmAjCoIiClFiCmEiMjPiNpFiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPrhHistFindText::OnHfdTxtChkSearchSelectedInside ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCPrhHistFindText::OnHfdTxtChkSearchSelectedInside.
