#ifndef __RichEditBuffer_h
#define __RichEditBuffer_h

#include "UtilFont.h"	// For FCFontCharInfo;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCRichTextBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	RTF_xZkqqHx_iDgGiBfLiDfOiCpAiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmGiMpAiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCRichTextBuffer
{
public:
	FCRichTextBuffer ();
	~FCRichTextBuffer ();
	void	BeginGetChar ();
	BOOL	NextGetChar (wchar_t& wc, FCFontCharInfo& fci, FCTextLineInfo& tli);
	void	BeginAddChar (const FCFontCharInfo& fci);
	void	NextAddChar (	const wchar_t& wc,
							const FCFontCharInfo& fci,
							const FCTextLineInfo& tli);
	void	EndAddChar ();
	BOOL	CanPasteSpecial (DWORD dwFormat) const;
	void	PasteSpecial (const FCFontCharInfo& fci, DWORD dwFormat);
	void	Copy ();
	void	Clear ();
	BOOL	IsEmpty () const;
// 02.08.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_jCiGiNjBiMoKiCmMiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiCkKiCkEiCnMiCkNiCkCiCkJiCmIiCkC_xHqqkZx_)
	void	GetText (WString& wstr);

protected:
	void	RichGetWindowText (CString& rString) const;
// 02.06.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)
//	DWORD	RichGetSelectionCharFormat (MY_CHARFORMAT& cf) const;
	DWORD	RichGetSelectionCharFormat (CHARFORMATW& cf) const;
	long	RichGetTextLength () const;
	DWORD	RichGetParaFormat (PARAFORMAT& pf) const;
// 02.06.19 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (Times New Roman_xZkqqHx_iCmM_xHqqkZx_"_xZkqqHx_iDlP_xHqqkZx_"_xZkqqHx_iCkKjDfMiCoIjFhEiCkPiCoKiCmIiCkC_xHqqkZx_)
	DWORD	RichGetSelText (wchar_t wstr[]) const;
// 02.06.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)
//	BOOL	RichSetSelectionCharFormat (MY_CHARFORMAT& cf);
	BOOL	RichSetSelectionCharFormat (CHARFORMATW& cf);
// 06.11.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	void	RichSetSel (long nStartChar, long nEndChar);
	BOOL	RichSetSel (long nStartChar, long nEndChar);
	void	RichSetWindowText (const wchar_t* lpszString);
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----
//	BOOL	RichSetDefaultCharFormat (MY_CHARFORMAT& cf);
//	BOOL	RichSetWordCharFormat (MY_CHARFORMAT& cf);
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----
	BOOL	RichSetDefaultCharFormat (CHARFORMATW& cf);
	BOOL	RichSetWordCharFormat (CHARFORMATW& cf);
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----
	BOOL	RichSetParaFormat (PARAFORMAT& pf);
	void	RichReplaceSel (const wchar_t* lpszNewText, BOOL bCanUndo = FALSE);
	BOOL	RichCanPaste (UINT nFormat) const;
	void	RichPaste ();
	void	RichPasteSpecial (UINT nFormat);
	void	RichCopy ();

protected:
//----- 02.06.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----
//	HMODULE		m_hmdlRich1_0;
//	HMODULE		m_hmdlRich2_0;
//----- 02.06.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----
	HMODULE		m_hmdlRichEdit;
	short		m_nVersion;
//----- 02.06.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----
	HWND		m_hwndRichEdit;
// 01.04.16 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	CRichEditCtrl	m_richEditCtrl;
	CString		m_tstr;
// 06.11.22 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	WString		m_wstr;
	long		m_lCurIndex;
}; // class FCRichTextBuffer.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCMolipTextBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip_xZkqqHx_iMmFjHeMiDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmGiMpAiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCMolipTextBuffer
{
public:
	FCMolipTextBuffer ();
	void	BeginGetChar ();
	BOOL	NextGetChar (wchar_t& wc, FCFontCharInfo& fci, FCTextLineInfo& tli);
	void	BeginAddChar (const FCFontCharInfo& fci);
	void	NextAddChar (const wchar_t& wc, const FCFontCharInfo& fci,
						const FCTextLineInfo& tli);
	void	EndAddChar ();
	BOOL	CanPaste () const;
	void	Paste (const FCFontCharInfo& fci);
	void	Copy ();
	void	Clear ();
	BOOL	IsEmpty () const;
// 02.08.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_jCiGiNjBiMoKiCmMiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiCkKiCkEiCnMiCkNiCkCiCkJiCmIiCkC_xHqqkZx_)
	void	GetText (WString& wstr);

protected:
	const BYTE*		m_bypHead;
	BYTEVector		m_vTextBuff;
	FCTextLineInfo	m_tliCurLine;
	FCFontCharInfo	m_fciCurFont;
}; // class FCMolipTextBuffer.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCRichEditBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	RTF_xZkqqHx_iCkIiCoGiCnB_xHqqkZx_Molip_xZkqqHx_iMmFjHeMiDgFiDeMiDfIiDgHiCpAiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmGiMpAiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCRichEditBuffer
{
public:
	void	BeginGetChar ();
	BOOL	NextGetChar (wchar_t& wc, FCFontCharInfo& fci, FCTextLineInfo& tli);
	void	BeginAddChar (const FCFontCharInfo& fci);
	void	NextAddChar (const wchar_t& wc, const FCFontCharInfo& fci,
						const FCTextLineInfo& tli);
	void	EndAddChar ();
	BOOL	CanPasteSpecial (DWORD dwFormat) const;
	void	PasteSpecial (const FCFontCharInfo& fci, DWORD dwFormat);
	void	Copy ();
	void	Clear ();
	BOOL	IsEmpty () const;
// 02.08.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_jCiGiNjBiMoKiCmMiDgFiDeMiDfIiDgHjDfMiCoIjFhEiCkPiCkKiCkEiCnMiCkNiCkCiCkJiCmIiCkC_xHqqkZx_)
	void	GetText (WString& wstr);

protected:
	FCMolipTextBuffer	m_MolipText;
	FCRichTextBuffer	m_RichText;
}; // class FCRichEditBuffer.

#endif//__RichEditBuffer_h
