#ifndef __RichText_h
#define __RichText_h

/**********************************************************
 *                 _xZkqqHx_iBhJiDgOiDjDiDeLiDiKiBfLiLeMjGeAiBhK_xHqqkZx_
 *      a               _xZkqqHx_jEhKjHpB_xHqqkZx_(Array)
 *      b               _xZkqqHx_jIfPjHjNiMfO_xHqqkZx_(Bool)
 *      by              unsigned char(BYte)
 *      c               char(Char)
 *      cb              _xZkqqHx_jFlGiOjKjAjE_xHqqkZx_(Count of Byte)
 *      cr              _xZkqqHx_jAeG_xHqqkZx_(Color Reference value)
 *      cx,cy   short_xZkqqHx_iMfO_xHqqkZx_[_xZkqqHx_iNmAjFfH_xHqqkZx_(x,y)_xZkqqHx_iCmMiDeKiDeFiDjDiDfO_xHqqkZx_](Count of X,Y)
 *      dw              unsigned long_xZkqqHx_iMfO_xHqqkZx_(Double Word)
 *      fn              _xZkqqHx_iKnGjAjE_xHqqkZx_(FuNction)
 *      h               _xZkqqHx_iDgOiDjDiDgIiDiL_xHqqkZx_(Handle)
 *      i               int(Integer)
 *      l               long(Long)
 *      m               _xZkqqHx_iDeOiDiJiDfIiDiBiDjDiDgP_xHqqkZx_(data Member of a class)
 *      n               short_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_int
 *      p               _xZkqqHx_iDhMiDeDiDjDiDfOiMfO_xHqqkZx_(Pointer)
 *      s               _xZkqqHx_jFlGiOjKjHpB_xHqqkZx_(String)
 *      sz              0_xZkqqHx_iCmFiPeJiCoNiCoJjFlGiOjKjHpB_xHqqkZx_(String terminated with Zero)
 *      tm              _xZkqqHx_iDgFiDeMiDfIiDgHjAkBjGeA_xHqqkZx_(Text Metric)
 *      w               unsigned short(Word)
 *      x,y             short_xZkqqHx_iMfOiNmAjFfHjCgM_xHqqkZx_
 ********************************************************/

//;----- <EXPORT TO SDK> -----;
class FCUndoArchive;
class FCToolBase;
class FCToolRichText;
class FCObjFigure;
class FCSearchParser;
class CFCWndRichEdit;
class FCStatLineVector;
class FCStatChar;
class FCConvEnv;
struct FCFontCharInfo;
struct FCTextLineInfo;
//;------ </EXPORT TO SDK> -----;

class FCRichText
{
public:
	//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	FCRichText ();

	//----- _xZkqqHx_jBkOjAkLiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual BOOL	IsEqual (const FCRichText* objp) const;
	virtual void	OutStream (FCUndoArchive& ar);
	virtual void	InStream (FCUndoArchive& ar);

	//----- _xZkqqHx_iDhJiBfLiDfIiDgHiOjOiCmJjFmPiKlHiClDiCoKiCoJjBkOjAkLiCpAiOjNiCmC_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual void	ConvertEnvProp (FCConvEnv* pConv);

	//----- _xZkqqHx_jFeLjHhGiCmJiJjOiClGiCmEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClHiCoKiCmOjHmHiCkC_xHqqkZx_ -----
	virtual void	EmptyText (const FCObjFigure* pFig);
// 06.02.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual BOOL	IsIntersect (const DBLPoint& mmpt) const;
// 06.02.28 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	GetIntersect (long& lHitIndex, BOOL& bIsHitFront, const DBLPoint& mmptMargin, const DBLPoint& mmpt) const;


	virtual BOOL	IsUsedSFont (SFontID foid) const;
	virtual	~FCRichText ();

	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMiKnGjAjE_xHqqkZx_ -----
	virtual void	OnStartToEditText (	const FCObjFigure* ojpTarget,
										WORD wFixResizeByText,
										BOOL bIsShortenByText,
										BOOL bIsShowWindow,
										const DBLPoint* mmptCaret);
	virtual void	OnStopToEditText (	BYTEVector& byvQueue,
										double& dRatioHorz,
										double& dRatioVert,
										const FCObjFigure* ojpTarget);
	virtual void	ImportText (const CFCWndRichEdit* repEdit);
	virtual void	ExportText (CFCWndRichEdit* repEdit) const;
	virtual BOOL	IsEmpty () const;
	virtual const DBLRect&	GetTextRect () const;
	virtual void	SetTextRect (const DBLRect& mmrtText);
	virtual mmetol	GetMarginL () const;
	virtual mmetol	GetMarginT () const;
	virtual mmetol	GetMarginR () const;
	virtual mmetol	GetMarginB () const;
	virtual angle	GetAngle () const;
//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BYTE	GetResizeHorz () const;
//	virtual BYTE	GetResizeVert () const;
//	virtual BOOL	GetIsResizeShorten () const;
//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual BOOL	GetTextLeftRight (mmetol& mmLeft, mmetol& mmRight) const;
	virtual BOOL	GetTextTopBottom (mmetol& mmTop, mmetol& mmBottom) const;
//----- 05.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual mmetol	GetTextTop () const;
//	virtual mmetol	GetTextBottom () const;
//	virtual mmetol	GetTextRight () const;
//----- 05.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual void	SetMarginL (mmetol mmMarginL);
	virtual void	SetMarginT (mmetol mmMarginT);
	virtual void	SetMarginR (mmetol mmMarginR);
	virtual void	SetMarginB (mmetol mmMarginB);
	virtual void	SetAngle (angle dAngle);
//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual void	SetResizeHorz (BYTE byResizeHorz);
//	virtual void	SetResizeVert (BYTE byResizeVert);
//	virtual void	SetIsResizeShorten (BOOL bIsResizeShorten);
//----- 05.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	virtual void	Redo (const FCObjFigure* pObj, long lQueueSz, const BYTE* bypQueue);
	virtual void	Undo (const FCObjFigure* pObj, long lQueueSz, const BYTE* bypQueue);

	virtual FCStatLineVector&	GetTextData ();

	//----- _xZkqqHx_jBkOjAkLiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual void	Copy (FCRichText* pNew) const;

	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMiKnGjAjE_xHqqkZx_ -----
	virtual void	DrawText (CDC* pDC, SColorID scidSpec);
	virtual void	CalcTextLayout (CFCWndRichEdit* repEdit, const FCObjDynabase* pFig);
	virtual void	GetCharInfo (FCFontCharInfo& fciAnsi,
								FCFontCharInfo& fciSjis,
								BOOL bInit = TRUE) const;
	virtual void	SetCharInfo (BYTEVector& byvQueue,
								const FCFontCharInfo& fciAnsi,
								const FCFontCharInfo& fciSjis,
								const FCObjFigure* ojpFig);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	GetLineInfo (FCTextLineInfo& tli,
								BOOL bInit = TRUE) const;
	virtual void	SetLineInfo (BYTEVector& byvQueue,
								const FCTextLineInfo& tli,
								const FCObjFigure* ojpFig);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual int		GetAlignment () const;
//	virtual void	SetAlignment (BYTEVector& byvQueue, int iAlign, const FCObjFigure* ojpFig);
//----- 05.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual int		GetVertAlignment () const;
	virtual void	SetVertAlignment (BYTEVector& byvQueue, int iAlign, const FCObjFigure* ojpFig);
//----- 05.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	GetLineAfter (short& nLineAfter) const;
//	virtual void	SetLineAfter (BYTEVector& byvQueue, short nLineAfter, const FCObjFigure* ojpFig);
//----- 05.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	InflateFontSize (BYTEVector& byvQueue, const FCObjFigure* ojpFig);
	virtual void	DeflateFontSize (BYTEVector& byvQueue, const FCObjFigure* ojpFig);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual void	CalcTextFitSize (double& dRatioHorz,
									double& dRatioVert,
									const FCObjFigure* ojpFig,
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//									WORD wResizeHorzByText,
//									WORD wResizeVertByText,
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
									WORD wFixResizeByText,
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
									BOOL bIsTextResizeShorten) const;

	virtual void	ExportAll (CFCWndRichEdit* repEdit, const FCObjFigure* pFig) const;

	virtual BOOL	IsTextOver () const;

// 06.04.07 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual void	GetText (WString& str, BOOL bIs2CR = FALSE) const;
	virtual void	GetText (WString& str, BOOL bIs2CR = FALSE, BOOL bIsCutLastCR = FALSE) const;
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual void	ClearSelection (CDC* pDC);
//	virtual void	AppendSelection (long lFrom, long lTo);
//	virtual void	DrawSelection (CDC* pDC);
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual void	DrawSelection (CDC* pDC, longSet stSelIndex);
// 06.03.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	GetSelection (longRangeVector& vSelectRange) const;

	virtual const FCStatChar* CharFirst (long& lLine, long& lChar, mmetol& mmX,
										short& nAfterSpace, mmetol& mmBaseLine) const;
	virtual const FCStatChar* CharNext (long& lLine, long& lChar, mmetol& mmX,
										short& nAfterSpace, mmetol& mmBaseLine) const;

	virtual void	ReplaceAll (BYTEVector& byvQueue, FCSearchParser& sp,
								 const FCObjFigure* pFig);

//----- 05.02.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	static void		AdjustObjectSize (FCObjDynabase* pTopObj, FCRichText* pText,
//										double dRatioHorz, double dRatioVert);
//----- 05.02.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

protected:
	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMiKnGjAjE_xHqqkZx_ -----
	virtual void	GetMaskPolygon (DBLPointVector& vmmptPoly, const FCObjDynabase* ojpFig, const DBLPoint& mmptCenter) const;

protected:	// _xZkqqHx_iDiBiDjDiDgPjFmPjAjE_xHqqkZx_.
	mmetol	m_mmMarginL;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
	mmetol	m_mmMarginT;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
	mmetol	m_mmMarginR;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
	mmetol	m_mmMarginB;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
	DBLRect	m_mmrtText;		// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	angle	m_dAngle;		// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiBeC_xHqqkZx_

	DWORD	m_dwVertAlign;	// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_
	FCStatLineVector*	m_vpLine;	// _xZkqqHx_jFlGiOjKjHpBiPoOjFpBiBeC_xHqqkZx_

// 06.03.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	longRangeVector	m_vSelectRange;	// _xZkqqHx_jBeJjBpAjEmNiImNiBeC_xHqqkZx_
}; // class FCRichText.

#endif//__RichText_h
