#ifndef __SearchParser_h
#define __SearchParser_h

/*************************************************************************
 * <_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_>	SearchParser.h
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCSearchParser_xZkqqHx_iDeOiDiJiDfIiCmMjCoIiLgAiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiOkOiCmJjBmOiJjO_xHqqkZx_._xZkqqHx_iCnJiCmGiCpBiCmHjDmGiOkJiCmJiNoMjAkM_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			98.12.10 Fukushiro M. svaSeeker_xZkqqHx_iCmJjElKiCkCiBeBiKnGjAjEiCpAiKpEiCmCiCkJjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/

class FmRegExpNFA;		// _xZkqqHx_jAlDiLeLjFfMiMlLiDeOiDiJiDfIiBeC_xHqqkZx_

typedef vector<FmRegExpNFA*>	RegExPVector;

// GetMatchingPos_xZkqqHx_iCmFiBeB_xHqqkZx_vHitRange_xZkqqHx_iCmJiDhBiDgCiDgHiClHiCoJiNmFjBoFjAjEiBeC_xHqqkZx_
// _xZkqqHx_iClBiCoKiCpAiJhKiCkGiCoJiCmG_xHqqkZx_GetMatchingPos_xZkqqHx_iCpAjDhCjCiGiCmFiPeJjHlJiBeC_xHqqkZx_
#define FDMAX_TEXT_HIT 100

class FCSearchParser
{
public:
	FCSearchParser ();
	virtual ~FCSearchParser ();
	virtual void	Clear ();
	virtual BOOL	ParseSearch (const wchar_t* wcpExp, BOOL bRegExp, BOOL bCnvUpper,
								BOOL bMultiWord, BOOL bOrOpeOnly);
	virtual BOOL	ParseReplace (const wchar_t* wcpStr);
	virtual int		IsMatch (const wchar_t* wcpTarget);
	virtual void	GetMatchingPos (longRangeVector& vHitRange, const wchar_t* wcpTarget);
	virtual BOOL 	GetNextMatchingPos (const wchar_t*& wcpFrom, const wchar_t*& wcpTo,
										const wchar_t* wcpTop, const wchar_t* wcpHead);
	virtual BOOL 	GetPrevMatchingPos (const wchar_t*& wcpFrom, const wchar_t*& wcpTo,
										const wchar_t* wcpTop, const wchar_t* wcpHead);
	virtual const wchar_t* GetMatchingPos (const wchar_t* wcpTop, const wchar_t* wcpHead);
	virtual void	GetReplaceText (WString& str) const;

	virtual BOOL	IsRegExp () const;
	virtual BOOL	IsCnvUpper () const;
//----- 01.04.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	static wchar_t*	ConvUpper (wchar_t* wcpTarget);
//	static _TCHAR*	ConvUpper (_TCHAR* tcpTarget);
//----- 01.04.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

protected:
	virtual BOOL	ParseExpression (const wchar_t*& wcpStr, BOOL bMultiWord, BOOL bOrOpeOnly);
	virtual BOOL	ParseMultiExpression (const wchar_t*& wcpStr, BOOL bOrOpeOnly);
	virtual BOOL	ParseItem (const wchar_t*& wcpStr, BOOL bOrOpeOnly);
	virtual int		Evaluate (shortVector& vTokenStk, shortVector& vIsHitTbl,
								const wchar_t* wcpTarget);
	virtual int		EvalNot (shortVector& vTokenStk, shortVector& vIsHitTbl,
								const wchar_t* wcpTarget);
	virtual int		EvalAnd (shortVector& vTokenStk, shortVector& vIsHitTbl,
								const wchar_t* wcpTarget);
	virtual int		EvalOr (shortVector& vTokenStk, shortVector& vIsHitTbl,
								const wchar_t* wcpTarget);

//	virtual BOOL	IsMatch (const wchar_t* wcpTarget);
//	virtual BOOL	CalcTokenStack (const shortVector& vIsHitTbl) const;

protected:
	BOOL			m_bRegExp;			// _xZkqqHx_jAlDiLeLjFfMiMlLiMjPiNpFiCkJiCmHiCkEiCkJiBeI_xHqqkZx_
	BOOL			m_bCnvUpper;		// _xZkqqHx_jBoFjFlGiOjKjFmPiKlHiClHiCoJiCkJiCmHiCkEiCkJiBeI_xHqqkZx_
	WStringVector	m_vTokenTbl;		// _xZkqqHx_iDgHiBfLiDeOiDjDiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	RegExPVector	m_vRegExObjTbl;		// _xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
										// FmfCreate_xZkqqHx_iCmFjAlGjAkMiClHiCoJiClNiCnP_xHqqkZx_auto_ptr_xZkqqHx_iCmNiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
	shortVector		m_vTokenStk;		// _xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiBeC_xHqqkZx_
	WCharVector		m_vReplace;			// _xZkqqHx_jChFiKlHiMoDiCmMjFlGiOjKjHpBiBeC_xHqqkZx_
	WStringVector	m_vAfterRef;		// _xZkqqHx_iMoDjFpLiOfBiPmGjFlGiOjKjHpBiBeC_xHqqkZx_
}; // class FCSearchParser.

#endif // !__SearchParser_h
