#ifndef __SheetManager_h
#define __SheetManager_h

#include "LayerManager.h"					// For ObjectLZHashMap.

//;----- <EXPORT TO SDK> -----;
class FCLayerManager;
class FCObjDynabase;

typedef vector<FCLayerManager*> LayerManagerPVector;

typedef	vector<SheetID> FDSheetIDVector;

// 05.04.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//typedef BOOL (*FuncForAllObject) (FCObjDynabase* pObj, DWORD data);

//;------ </EXPORT TO SDK> -----;

// 03.07.08 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "../MolipSDK/FCSheetManagerExp.h"	// Superclass.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCSheetManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Document_xZkqqHx_iCmMiDfGiBfLiDgHiCpAiKmHjHjNiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCSheetManager
{
public:
	FCSheetManager ();
	virtual	~FCSheetManager ();
	virtual void	Initialize ();
	virtual void	Clear ();
	virtual void	DeleteAll ();
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual void	OutStream (FCUndoArchive& ar, BOOL bIsOutObject) const;
	virtual void	OutStream (FCUndoArchive& ar, BOOL bIsOutObject, BOOL bIsOutBezier) const;
	virtual void	InStream (FCUndoArchive& ar);
	virtual void	InTopBottomSheetStream (FCUndoArchive& ar);

// 03.06.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OutStreamTemplate (FCUndoArchive& ar) const;

	virtual FCLayerManager*	GetSheet (SheetID stid) const;
	virtual FCLayerManager*	GetFrontSheet () const;
	virtual BOOL	IsEmpty () const;

	virtual void	InsertSheet (SheetID& stidNew, const wchar_t* tcpName, SheetID stid, DWORD dwIdx);
	virtual void	DeleteSheet (SheetID stid);
	virtual void	ModifySheet (SheetID stid, const wchar_t* tcpName);
	virtual void	SetCurrentSheetId (SheetID stid);
	virtual void	ReOrderSheet (DWORD dwFirstIdx, DWORD dwLastIdx, const SheetID stidaNewOrder[]);

	virtual SheetID	GetCurrentSheetId () const;
	virtual void	GetSheetInfo (WString& strName, SheetID stid) const;

	virtual const FDSheetIDVector&	GetFreqSheetVector () const;
	virtual SheetID	GetFreeSheetID () const;
	virtual DWORD	SheetIDToIndex (SheetID stid) const;
	virtual SheetID	SheetIndexToID (DWORD dwIndex) const;
	virtual SheetID	GetSheetIDSize () const;
	virtual DWORD	GetSheetIndexSize () const;
	virtual BOOL	ObjDynabaseToSIdLZOrder (SheetID& stid, FCLayerZOrder& laorder,
										const FCObjDynabase* pObj, SheetID stidStart) const;
	virtual BOOL	CallForAllObject (FuncForAllObject func, void* data) const;

//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	IsUsedSColor (SColorID val) const;
//	virtual BOOL	IsUsedEmfImage (EmfImageID val) const;
//	virtual BOOL	IsUsedBrushRegister (BrushRegisterID val) const;
//	virtual BOOL	IsUsedPenRegister (PenRegisterID val) const;
//	virtual BOOL	IsUsedPenStyle (PenStyleID val) const;
//	virtual BOOL	IsUsedSFont (SFontID val) const;
//	virtual BOOL	IsUsedPictArrow (PictArrowID val) const;
//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// 05.04.12 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//	virtual void	PictArrowFrameModified (PictArrowID paid);
//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

protected:
	LayerManagerPVector	m_vSheet;			// _xZkqqHx_iDfGiBfLiDgHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	FDSheetIDVector		m_vFreqSheet;		// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmMiPiHiPjIiBeC_xHqqkZx_
	ObjectLZHashMap		m_mpObjToLZHash;	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->Layer,ZOrder_xZkqqHx_iCmMiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	ObjDynabaseVector		m_vBottomLayer;		// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
	ObjDynabaseVector		m_vTopLayer;		// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
	SheetID				m_stidCurrentSheet;	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
}; // class FCSheetManager.

#endif//__SheetManager_h

