// StcArrow.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilCoord.h"		// For mm2lg.etc.
#include "Arrow.h"		// For FCStdArrow.
#include "UtilGraph.h"	// For FCAutoDC.
#include "StcArrow.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCStcArrow

CFCStcArrow::CFCStcArrow ()
{
	m_lPenWidth		= 4;	// _xZkqqHx_iDhJiDjDjFjNiBeCjIfPjHjNiNmAjFfHjCgMiBeC_xHqqkZx_
	m_nDirect		= 0;
	m_nArrowType	= FDUG_ARW_TYPE_FLAT;
	m_nArrowParam0	= 0;
	m_nArrowParam1	= 0;
	m_nArrowParam2	= 0;
	m_paid = FD_PICT_ARROW_UNSPECIFY;
} // CFCStcArrow::CFCStcArrow.

CFCStcArrow::~CFCStcArrow ()
{
} // CFCStcArrow::~CFCStcArrow.

BEGIN_MESSAGE_MAP(CFCStcArrow, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCStcArrow)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCStcArrow _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

void CFCStcArrow::SetArrowDirect (BYTE byDirect)
{
	m_nDirect = byDirect;
} // CFCStcArrow::SetArrowDirect.

long CFCStcArrow::GetPenWidth () const
{
	return m_lPenWidth;
} // CFCStcArrow::GetPenWidth.

void CFCStcArrow::SetPenWidth (long lPenW)
{
	CRect rtClient;
	GetClientRect(rtClient);
	m_lPenWidth = lPenW;
	if (m_lPenWidth < 1) m_lPenWidth = 1;
	if (rtClient.Width() / 2 < m_lPenWidth) m_lPenWidth = rtClient.Width() / 2;
	if (rtClient.Height() / 2 < m_lPenWidth) m_lPenWidth = rtClient.Height() / 2;
} // CFCStcArrow::SetPenWidth.

void CFCStcArrow::SetArrowType (BYTE byArrowType)
{
	m_nArrowType = byArrowType;
} // CFCStcArrow::SetArrowType.

void CFCStcArrow::SetArrowParam0 (BYTE byArrowParam0)
{
	m_nArrowParam0 = byArrowParam0;
} // CFCStcArrow::SetArrowParam0.

void CFCStcArrow::SetArrowParam1 (BYTE byArrowParam1)
{
	m_nArrowParam1 = byArrowParam1;
} // CFCStcArrow::SetArrowParam1.

void CFCStcArrow::SetArrowParam2 (BYTE byArrowParam2)
{
	m_nArrowParam2 = byArrowParam2;
} // CFCStcArrow::SetArrowParam2.

void CFCStcArrow::SetPictArrowID (PictArrowID paid)
{
	m_paid = paid;
} // CFCStcArrow::SetPictArrowID.

/////////////////////////////////////////////////////////////////////////////
// CFCStcArrow _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

void CFCStcArrow::OnPaint ()
{
	CPaintDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(&dc, TRUE, 0, 0);

	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_jEhHiMgJjAeGiOoGjDlOiBeC_xHqqkZx_GetBkColor_xZkqqHx_iCmNjBmKjGnKiBeCjEhHiMgJjAeGiCmFjDgIiCoIjCnHiClHiBeC_xHqqkZx_
	atDC.FillRect(rtClient, FCAtBrush(::GetSysColor(COLOR_3DFACE)));
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiDfCiDjDiDgHiDiNiBfLiDiLiKePiCmJiCoAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
	atDC.IntersectClipRect(rtClient);

//----- 01.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CPoint ptaPoly[2];
//	ptaPoly[0].x = rtClient.left + 4;
//	ptaPoly[0].y = (rtClient.top + rtClient.bottom) / 2;
//	ptaPoly[1].x = rtClient.right - 4;
//	ptaPoly[1].y = (rtClient.top + rtClient.bottom) / 2;
//	long lH;
//	CPoint ptA;
//	atDC.SetPen(PS_SOLID, 4, FD_COLREF_BLACK);
//	DrawArrowHead(lH, ptA, m_nDirect, &dc, 0, 0, FD_COLREF_BLACK, NULL, 4.0, 1.0,
//					ptaPoly, 2, FCUGArrowParams(m_nArrowType, m_nArrowParam0,
//					m_nArrowParam1, m_nArrowParam2));
//	atDC.MoveTo(ptA);
//	if (m_nDirect == 0)
//		atDC.LineTo(ptaPoly[1]);
//	else
//		atDC.LineTo(ptaPoly[0]);
//----- 01.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//------ _xZkqqHx_jCmKiPoNiCmM_xHqqkZx_DisplayPPM(_xZkqqHx_jBkGiClP_xHqqkZx_1_xZkqqHx_jEhL_xHqqkZx_)_xZkqqHx_iCmFjFgAiJoGiClHiCoJiClNiCnPiBeBiDfJiBfLiDiAiCpAjAnNjCoI_xHqqkZx_ -----
	const double dZoom = g_->dZoom;
	g_->dZoom = g_->dDisplayPPM;
	//----- _xZkqqHx_jFgAiJoGiDeJiDhEiDfKiDgCiDgHjCgMiCpAjAnNjCoI_xHqqkZx_ -----
	const long lgOffsetX = g_->lgOffsetX;
	const long lgOffsetY = g_->lgOffsetY;
	g_->lgOffsetX = 0;
	g_->lgOffsetY = 0;

	DBLPointVector vmmpt;
	vmmpt.push_back(lg2mm(CPoint(rtClient.left + m_lPenWidth,
					  			(rtClient.top + rtClient.bottom) / 2)));
	vmmpt.push_back(lg2mm(CPoint(rtClient.right - m_lPenWidth,
					  			(rtClient.top + rtClient.bottom) / 2)));
	if (m_nDirect) Exchange(vmmpt[0], vmmpt[1]);
	FCBaseArrow* pArrow = NULL;
	if (m_nArrowType != FDUG_ARW_TYPE_FLAT)
	{
		if (m_nArrowType == FDUG_ARW_TYPE_PICT)
		{
			if (m_paid != FD_PICT_ARROW_UNSPECIFY && m_paid != FD_PICT_ARROW_UNUSE)
				pArrow = new FCPictArrow(m_paid, FALSE);
		}
		else
		{
			pArrow = new FCStdArrow(FCUGArrowParams(m_nArrowType, m_nArrowParam0,
													m_nArrowParam1, m_nArrowParam2), FALSE);
		}
	}
	// _xZkqqHx_jGoOiIpDiCmMiPiJiKpKiJlLiCmGjBePjFgAiJoGiPiIjHjNiBeC_xHqqkZx_
	if (pArrow != NULL)
	{
		pArrow->InitByPoly(vmmpt, lg2mm(m_lPenWidth), lg2mm(g_->lgdPrecision),
						FD_PEN_STYLE_SOLID, lg2mm(m_lPenWidth) / 10.0, FD_S_COLOR_BLACK,
						FD_PATTERN_UNUSE, FD_S_COLOR_TRANSPARENT, FD_S_COLOR_BLACK,
						FD_S_COLOR_TRANSPARENT);
		pArrow->PreDraw(&dc, FALSE);
	}

	// _xZkqqHx_iOlCjApMiCmMjFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, m_lPenWidth, FD_COLREF_BLACK);
	atDC.MoveTo(mm2lg(vmmpt[0]));
	atDC.LineTo(mm2lg(vmmpt[1]));

	// _xZkqqHx_jGoOiIpDiCmMiMoDjFgAiJoGiPiIjHjNiCmGjGoOiIpDiNoNiPjMiBeC_xHqqkZx_
	if (pArrow != NULL)
	{
		pArrow->FillArrow(&dc, lg2mm(g_->lgdPrecision), FD_S_COLOR_BLACK, rtClient);
		pArrow->PostDraw(&dc, FALSE);
		delete pArrow;
	}

	//------ _xZkqqHx_iDgPiDgCiDeOiDeBiDgCiDhGiCpAjGnPiClH_xHqqkZx_ -----
	g_->dZoom = dZoom;
	g_->lgOffsetX = lgOffsetX;
	g_->lgOffsetY = lgOffsetY;
//----- 01.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCStcArrow::OnPaint.
