// StcPaperSize.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilGraph.h"		// For FCAutoDC.
//#include "UtilStr.h"		// For FFCalcCharCount.
#include "StcPaperSize.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static const COLORREF s_colorBackground = FD_COLREF_GRAY;
static const COLORREF s_colorPaper = FD_COLREF_WHITE;
static const COLORREF s_colorSheetForeground = FD_COLREF_GRAY;

/////////////////////////////////////////////////////////////////////////////
// CFCStcPaperSize

CFCStcPaperSize::CFCStcPaperSize ()
{
//----- 05.05.14 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// CFCPrnPrintSetup_xZkqqHx_iCmFiBeBiDhGiDiKiDjDiDfOiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmJ_xHqqkZx_
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiClIjFfMiOkGiClDiCoKiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iPiJiKpKiJlLiClJiClIjFfMiOkGiCmFiDeHiDiJiBfLiCpAiLeOiClBiClDiCmIiCkCiCoGiCkEiBeBjCgMiCpAjDeLjDjGiCmJjDpMiCoKiCmEiCkIiCkNiBeC_xHqqkZx_
	m_lgPaperLeft = 0;				// _xZkqqHx_jHhAiOiGiCmMiNlGiNmAjFfHiBeC_xHqqkZx_
	m_lgPaperTop = 0;				// _xZkqqHx_jHhAiOiGiCmMiPoDiNmAjFfHiBeC_xHqqkZx_
	m_mmPaperWidth = 1.0;			// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	m_mmPaperHeight = 1.0;			// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
//----- 05.06.19 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	m_mmPageWidth = 1.0;		// _xZkqqHx_iDhJiBfLiDfHiCmMjFjNiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
//	m_mmPageHeight = 1.0;		// _xZkqqHx_iDhJiBfLiDfHiCmMiNiCiClDiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
//----- 05.06.19 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	m_mmPaperMarginL = 0.0;			// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	m_mmPaperMarginT = 0.0;			// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	m_mmPaperMarginR = 0.0;			// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	m_mmPaperMarginB = 0.0;			// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	m_dZoom = 1.0;					// _xZkqqHx_iOmAiNmAjFfH_xHqqkZx_->_xZkqqHx_jIfPjHjNiNmAjFfHiCmMjFmPiKlHiMfHjAjEiBeC_xHqqkZx_
//----- 05.05.14 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	m_colorSheet = s_colorPaper;	// _xZkqqHx_jHhAiOiGjAeGiBeC_xHqqkZx_
//----- 05.06.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	m_bIsPrintFooter = FALSE;		// _xZkqqHx_iDhEiDgCiDfOiCpAiIpDiNpMiClHiCoJiCkJiBeI_xHqqkZx_
	m_byHorzFooterPosition = 1;		// _xZkqqHx_iDhEiDgCiDfOiCmMiImKjChFiBgJjAiFjFlNjFpLiMpMiBgKiBeCiNlGiBiBiCePiBeBjCiGiJjLiBiBiCfAiBeBiJeFiBiBiCfBiBeC_xHqqkZx_
	m_byVertFooterPosition = 2;		// _xZkqqHx_iDhEiDgCiDfOiCmMiImKjChFiBgJjAiCjClMjFpLiMpMiBgKiBeCiPoDiBiBiCePiBeBjCiGiJjLiBiBiCfAiBeBiJlKiBiBiCfBiBeC_xHqqkZx_
	m_mmHorzFooterOffset = 0.0;		// _xZkqqHx_iDhEiDgCiDfOiCmMiDeJiDhEiDfKiDgCiDgHiBgJjAiFjFlNjFpLiMpMiBgKiBeC_xHqqkZx_
	m_mmVertFooterOffset = 0.0;		// _xZkqqHx_iDhEiDgCiDfOiCmMiDeJiDhEiDfKiDgCiDgHiBgJjAiCjClMjFpLiMpMiBgKiBeC_xHqqkZx_
	FFCopy(m_fciFooterFont, FFGetStdFont (10.5, 0.0), g_->dDisplayPPM);	// _xZkqqHx_iDhEiDgCiDfOjHhAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
	m_colorFooter = FD_COLREF_BLACK;	// _xZkqqHx_iDhEiDgCiDfOjHhAjAeGiBeC_xHqqkZx_
	m_wstrFooterText = L"";		// _xZkqqHx_iDhEiDgCiDfOiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
//----- 05.06.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCStcPaperSize::CFCStcPaperSize.

/////////////////////////////////////////////////////////////////////////////
// CFCStcPaperSize _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetPaperSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmWidth	:_xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCmMjFjNiCpAjAnNjCoIiBeC_xHqqkZx_
 *			mmHeight:_xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCmMiNiCiClDiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetPaperSize (double mmWidth, double mmHeight)
{
	m_mmPaperWidth	= mmWidth;		// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	m_mmPaperHeight	= mmHeight;		// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	// _xZkqqHx_jFfMiOkGjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_jHmMiIoGiCmM_xHqqkZx_5%_xZkqqHx_iCpAjHhAiOiGiCmMiKePiCmJiKiEiCoIjDjGiCmEiCoJiBeCiJlMjAnNjCoIiBeC_xHqqkZx_
	m_lgPaperLeft	= rtClient.right / 20;
	m_lgPaperTop	= rtClient.bottom / 20;
	// _xZkqqHx_jFfMiOkGjHmMiIoGiCkJiCoHiBeBjHmMiIoGiKePiCmMjClHiClDiCpAiCmNiClIiClHiBeC_xHqqkZx_
	rtClient.right -= m_lgPaperLeft * 2;
	rtClient.bottom -= m_lgPaperTop * 2;
//----- 00.09.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	ASSERT(!almost0(m_mmPaperWidth));
	ASSERT(!almost0(m_mmPaperHeight));
//----- 00.09.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPgDiCmGiJkBiCmMiKgHjBoFjHkGiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	double dZoomW = double(rtClient.right) / m_mmPaperWidth;
	double dZoomH = double(rtClient.bottom) / m_mmPaperHeight;
	// _xZkqqHx_iPgDiCmGiJkBiCmMiKgHjBoFjHkGiCpAjEoEiKhCiClFiBeBiPkMiClDiCkCjFpLiCpAiNmMjHhAiBeC_xHqqkZx_
	m_dZoom = (dZoomW < dZoomH) ? dZoomW : dZoomH;
	// _xZkqqHx_jFfMiOkGjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
	GetClientRect(rtClient);
	// _xZkqqHx_jHhAiOiGiCmMiDfEiDeDiDfJiCpAjIfPjHjNiNmAjFfHiCmFiMhGiOfKiBeC_xHqqkZx_
	long lgPaperWidth = mm2lg(m_mmPaperWidth, m_dZoom);
	long lgPaperHeight = mm2lg(m_mmPaperHeight, m_dZoom);
	// _xZkqqHx_jHmMiIoGiCmM_xHqqkZx_5%_xZkqqHx_iCpAjHhAiOiGiCmMiKePiCmJiKiEiCoIjDjGiCmEiCoJiBeCjGhLjAnNjCoIiBeC_xHqqkZx_
	m_lgPaperLeft	= (rtClient.right - lgPaperWidth) / 2;
	m_lgPaperTop	= (rtClient.bottom - lgPaperHeight) / 2;
} // CFCStcPaperSize::SetPaperSize.

//----- 05.06.19 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetPageSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCmMiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmWidth	:_xZkqqHx_iDhJiBfLiDfHiDfEiDeDiDfJiCmMjFjNiCpAjAnNjCoIiBeC_xHqqkZx_
// *			mmHeight:_xZkqqHx_iDhJiBfLiDfHiDfEiDeDiDfJiCmMiNiCiClDiCpAjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCStcPaperSize::SetPageSize (double mmWidth, double mmHeight)
//{
//	m_mmPageWidth	= mmWidth;		// _xZkqqHx_iDhJiBfLiDfHiCmMjFjNiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
//	m_mmPageHeight	= mmHeight;		// _xZkqqHx_iDhJiBfLiDfHiCmMiNiCiClDiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
//} // CFCStcPaperSize::SetPageSize.
//----- 05.06.19 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetPaperMargin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHhAiOiGiCmMjHfNjEjCiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmMarginL	:_xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiCpAiOhHjCoIiClHiCoJiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *			mmMarginT	:_xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiCpAiOhHjCoIiClHiCoJiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *			mmMarginR	:_xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiCpAiOhHjCoIiClHiCoJiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *			mmMarginB	:_xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiCpAiOhHjCoIiClHiCoJiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetPaperMargin (double mmMarginL, double mmMarginT,
									double mmMarginR, double mmMarginB)
{
	m_mmPaperMarginL	= mmMarginL;
	m_mmPaperMarginT	= mmMarginT;
	m_mmPaperMarginR	= mmMarginR;
	m_mmPaperMarginB	= mmMarginB;
} // CFCStcPaperSize::SetPaperMargin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::GetPaperMargin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHhAiOiGiCmMjHfNjEjCiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmMarginL	:_xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiCpAjFnEiClHiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *			mmMarginT	:_xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiCpAjFnEiClHiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *			mmMarginR	:_xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiCpAjFnEiClHiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *			mmMarginB	:_xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiCpAjFnEiClHiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::GetPaperMargin (double& mmMarginL, double& mmMarginT,
									double& mmMarginR, double& mmMarginB) const
{
	mmMarginL	= m_mmPaperMarginL;
	mmMarginT	= m_mmPaperMarginT;
	mmMarginR	= m_mmPaperMarginR;
	mmMarginB	= m_mmPaperMarginB;
} // CFCStcPaperSize::GetPaperMargin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetSheetColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHhAiOiGjAeGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	color	:_xZkqqHx_jHhAiOiGjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetSheetColor (COLORREF color)
{
	m_colorSheet = color;
} // CFCStcPaperSize::SetSheetColor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::ResetPaperColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHhAiOiGjAeGiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::ResetPaperColor ()
{
	m_colorSheet = s_colorPaper;	// _xZkqqHx_jHhAiOiGjAeGiBeC_xHqqkZx_
} // CFCStcPaperSize::ResetPaperColor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetIsPrintFooter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDgCiDfOiCpAiIpDiNpMiClHiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetIsPrintFooter (BOOL bIsPrint)
{
	m_bIsPrintFooter = bIsPrint;
} // CFCStcPaperSize::SetIsPrintFooter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetHorzFooterPosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDgCiDfOiCmMiImKjChFiBgJjAiFjFlNjFpLiMpMiBgKiBeCiNlGiBiBiCePiBeBjCiGiJjLiBiBiCfAiBeBiJeFiBiBiCfBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetHorzFooterPosition (BYTE byPosition)
{
	m_byHorzFooterPosition = byPosition;
} // CFCStcPaperSize::SetHorzFooterPosition.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetVertFooterPosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDgCiDfOiCmMiImKjChFiBgJjAiCjClMjFpLiMpMiBgKiBeCiPoDiBiBiCePiBeBjCiGiJjLiBiBiCfAiBeBiJlKiBiBiCfBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetVertFooterPosition (BYTE byPosition)
{
	m_byVertFooterPosition = byPosition;
} // CFCStcPaperSize::SetVertFooterPosition.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetHorzFooterOffset
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDgCiDfOiCmMiDeJiDhEiDfKiDgCiDgHiBgJjAiFjFlNjFpLiMpMiBgKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetHorzFooterOffset (mmetol mmOffset)
{
	m_mmHorzFooterOffset = mmOffset;
} // CFCStcPaperSize::SetHorzFooterOffset.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetVertFooterOffset
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDgCiDfOiCmMiDeJiDhEiDfKiDgCiDgHiBgJjAiCjClMjFpLiMpMiBgKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetVertFooterOffset (mmetol mmOffset)
{
	m_mmVertFooterOffset = mmOffset;
} // CFCStcPaperSize::SetVertFooterOffset.


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetFooterFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDgCiDfOjHhAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetFooterFont (const FCFontCharInfo& fci)
{
	m_fciFooterFont = fci;
} // CFCStcPaperSize::SetFooterFont.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetFooterColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDgCiDfOjHhAjAeGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetFooterColor (COLORREF color)
{
	m_colorFooter = color;
} // CFCStcPaperSize::SetFooterColor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::SetFooterText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDgCiDfOiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::SetFooterText (const wchar_t* wcpText)
{
	m_wstrFooterText = wcpText;
} // CFCStcPaperSize::SetFooterText.

/////////////////////////////////////////////////////////////////////////////
// CFCStcPaperSize _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjDiBeC_xHqqkZx_


CFCStcPaperSize::~CFCStcPaperSize ()
{
} // CFCStcPaperSize::~CFCStcPaperSize.


BEGIN_MESSAGE_MAP(CFCStcPaperSize, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCStcPaperSize)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCStcPaperSize _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcPaperSize::OnPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjFgAiJoGiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcPaperSize::OnPaint ()
{
//----- 05.06.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
//	CPaintDC dc(this);
//	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iBeC_xHqqkZx_
//	FCAutoDC atDC(&dc, TRUE, 0, 0);
//	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
//	CRect rtClient;
//	GetClientRect(rtClient);
//	// _xZkqqHx_jEhHiMgJjAeGiOoGjDlOiBeC_xHqqkZx_GetBkColor_xZkqqHx_iCmNjBmKjGnKiBeCjEhHiMgJjAeGiCmFjDgIiCoIjCnHiClHiBeC_xHqqkZx_
//	atDC.FillRect(rtClient, FCAtBrush(::GetSysColor(COLOR_3DSHADOW)));
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiDfCiDjDiDgHiDiNiBfLiDiLiKePiCmJiCoAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//	atDC.IntersectClipRect(rtClient);
//	// _xZkqqHx_jHhAiOiGiCmMiDfEiDeDiDfJiCpAjIfPjHjNiNmAjFfHiCmFiMhGiOfKiBeC_xHqqkZx_
//	long lgPaperWidth	= mm2lg(m_mmPaperWidth, m_dZoom);
//	long lgPaperHeight	= mm2lg(m_mmPaperHeight, m_dZoom);
//	// _xZkqqHx_jHhAiOiGjAeGiOoGjDlOiBeCjHhAiOiGiCpAjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
//	atDC.FillRect(	CRect(	m_lgPaperLeft,
//							m_lgPaperTop,
//							m_lgPaperLeft + lgPaperWidth,
//							m_lgPaperTop + lgPaperHeight),
//					FCAtBrush(::GetSysColor(COLOR_WINDOW)));
//
//	// _xZkqqHx_iDhJiBfLiDfHiCmMiDfEiDeDiDfJiCpAjIfPjHjNiNmAjFfHiCmFiMhGiOfKiBeC_xHqqkZx_
//	long lgMarginL = mm2lg(m_mmPaperMarginL, m_dZoom);
//	long lgMarginT = mm2lg(m_mmPaperMarginT, m_dZoom);
//	long lgMarginR = mm2lg(m_mmPaperMarginR, m_dZoom);
//	long lgMarginB = mm2lg(m_mmPaperMarginB, m_dZoom);
//	CRect rtPrnPage(m_lgPaperLeft + lgMarginL,
//					m_lgPaperTop + lgMarginT,
//					m_lgPaperLeft + lgPaperWidth - lgMarginR,
//					m_lgPaperTop + lgPaperHeight - lgMarginB);
//	if (rtPrnPage.right <= rtPrnPage.left) return;
//	if (rtPrnPage.bottom <= rtPrnPage.top) return;
//
////----- 05.06.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	double mmPrnPageWidth = m_mmPaperWidth - m_mmPaperMarginL - m_mmPaperMarginR;
////	double mmPrnPageHeight = m_mmPaperHeight - m_mmPaperMarginT - m_mmPaperMarginB;
////	ASSERT(!almost0(m_mmPageWidth));
////	ASSERT(!almost0(m_mmPageHeight));
////	double x = mmPrnPageWidth / m_mmPageWidth;
////	double y = mmPrnPageHeight / m_mmPageHeight;
////	double dRatio = (x < y) ? x : y;
////	long lgPageW = D2L(m_mmPageWidth * dRatio * m_dZoom);
////	long lgPageH = D2L(m_mmPageHeight * dRatio * m_dZoom);
////	atDC.FillRect(CRect(rtPrnPage.left, rtPrnPage.top,
////					  rtPrnPage.left + lgPageW + 1, rtPrnPage.top + lgPageH + 1),
////					FCAtBrush(::GetSysColor(COLOR_3DFACE)));
////----- 05.06.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	atDC.SetBkColor(FD_COLREF_BLACK);
//	atDC.FillRect(rtPrnPage, FCAtBrush(HS_BDIAGONAL, ::GetSysColor(COLOR_3DFACE)));
////----- 05.06.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	atDC.SetPen(PS_SOLID, 0, ::GetSysColor(COLOR_WINDOWFRAME));
//	atDC.SetStockBrush(HOLLOW_BRUSH);
//	atDC.MoveTo(rtPrnPage.left, rtPrnPage.top);
//	atDC.LineTo(rtPrnPage.right, rtPrnPage.top);
//	atDC.LineTo(rtPrnPage.right, rtPrnPage.bottom);
//	atDC.LineTo(rtPrnPage.left, rtPrnPage.bottom);
//	atDC.LineTo(rtPrnPage.left, rtPrnPage.top);
//----- 05.06.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	CPaintDC dc(this);
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iBeC_xHqqkZx_
	FCAutoDC atDC(&dc, TRUE, 0, 0);
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_jEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
	atDC.FillRect(rtClient, FCAtBrush(OptiColor(s_colorBackground)));
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiDfCiDjDiDgHiDiNiBfLiDiLiKePiCmJiCoAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
	atDC.IntersectClipRect(rtClient);
	// _xZkqqHx_jHhAiOiGiCmMiDfEiDeDiDfJiCpAjIfPjHjNiNmAjFfHiCmFiMhGiOfKiBeC_xHqqkZx_
	long lgPaperWidth	= mm2lg(m_mmPaperWidth, m_dZoom);
	long lgPaperHeight	= mm2lg(m_mmPaperHeight, m_dZoom);

	// _xZkqqHx_jHhAiOiGiCpAjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
	atDC.FillRect(	CRect(	m_lgPaperLeft,
							m_lgPaperTop,
							m_lgPaperLeft + lgPaperWidth,
							m_lgPaperTop + lgPaperHeight),
					FCAtBrush(OptiColor(s_colorPaper)));

	// _xZkqqHx_iDhJiBfLiDfHiCmMiDfEiDeDiDfJiCpAjIfPjHjNiNmAjFfHiCmFiMhGiOfKiBeC_xHqqkZx_
	long lgMarginL = mm2lg(m_mmPaperMarginL, m_dZoom);
	long lgMarginT = mm2lg(m_mmPaperMarginT, m_dZoom);
	long lgMarginR = mm2lg(m_mmPaperMarginR, m_dZoom);
	long lgMarginB = mm2lg(m_mmPaperMarginB, m_dZoom);
	CRect rtPrnPage(m_lgPaperLeft + lgMarginL,
					m_lgPaperTop + lgMarginT,
					m_lgPaperLeft + lgPaperWidth - lgMarginR,
					m_lgPaperTop + lgPaperHeight - lgMarginB);
	if (rtPrnPage.right <= rtPrnPage.left) return;
	if (rtPrnPage.bottom <= rtPrnPage.top) return;

	// _xZkqqHx_iDfGiBfLiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetBkColor(OptiColor(m_colorSheet));
	// _xZkqqHx_iDfGiBfLiDgHjHmMiIoGiCpAiDgOiDgCiDgAiDhAiDfOiBfLiDjDiCmFjFgAiJoGiBeC_xHqqkZx_
	atDC.FillRect(rtPrnPage, FCAtBrush(HS_BDIAGONAL, OptiColor(s_colorSheetForeground)));
	// _xZkqqHx_iDfGiBfLiDgHiCmMjHmMiIoGiCpAiOkGiClHiLoJiMgAiCpAjFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 0, OptiColor(s_colorSheetForeground));
	atDC.SetStockBrush(HOLLOW_BRUSH);
	atDC.MoveTo(rtPrnPage.left, rtPrnPage.top);
	atDC.LineTo(rtPrnPage.right, rtPrnPage.top);
	atDC.LineTo(rtPrnPage.right, rtPrnPage.bottom);
	atDC.LineTo(rtPrnPage.left, rtPrnPage.bottom);
	atDC.LineTo(rtPrnPage.left, rtPrnPage.top);

	if (m_bIsPrintFooter && !m_wstrFooterText.IsEmpty())
	//----- _xZkqqHx_iDhEiDgCiDfOiCpAiIpDiNpMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		LOGFONT logfont;
		FFCopy(logfont, m_fciFooterFont, m_dZoom);
		atDC.SetFont(&logfont);
		atDC.SetTextColor(m_colorFooter);
		atDC.SetBkMode(TRANSPARENT);
		CSize szText = atDC.GetTextExtent(m_wstrFooterText.c_str(), m_wstrFooterText.GetLength());
		long x, y;
		switch (m_byHorzFooterPosition)
		{
		case 0:	// _xZkqqHx_iNlGiBeC_xHqqkZx_
			x = 0;
			break;
		case 1:	// _xZkqqHx_jCiGiJjLiBeC_xHqqkZx_
			x = (lgPaperWidth - szText.cx) / 2;
			break;
		case 2:	// _xZkqqHx_iJeFiBeC_xHqqkZx_
			x = lgPaperWidth - szText.cx;
			break;
		}
		switch (m_byVertFooterPosition)
		{
		case 0:	// _xZkqqHx_iPoDiBeC_xHqqkZx_
			y = 0;
			break;
		case 1:	// _xZkqqHx_jCiGiJjLiBeC_xHqqkZx_
			y = (lgPaperHeight - szText.cy) / 2;
			break;
		case 2:	// _xZkqqHx_iJlKiBeC_xHqqkZx_
			y = lgPaperHeight - szText.cy;
			break;
		}
		x += m_lgPaperLeft + mm2lg(m_mmHorzFooterOffset, m_dZoom);
		y += m_lgPaperTop + mm2lg(m_mmVertFooterOffset, m_dZoom);
		atDC.ExtTextOut(x, y, m_wstrFooterText, CP_ACP, NULL);
	}
//----- 05.06.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCStcPaperSize::OnPaint.

