// StcText.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "Env.h"		// For g_pEnv.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilFont.h"	// For FFCopy.
#include "UtilGraph.h"	// For FCAutoDC.
#include "UtilStr.h"	// For CharSetToCodePage.
#include "UtilWin.h"	// For FFGetWindowText.
#include "StcText.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCStcText

CFCStcText::CFCStcText ()
{
	// _xZkqqHx_jFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	memset(&m_fci, 0, sizeof(m_fci));
} // CFCStcText::CFCStcText.

CFCStcText::~CFCStcText ()
{
} // CFCStcText::~CFCStcText.

/////////////////////////////////////////////////////////////////////////////
// CFCStcText _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcText::SetFontCharInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFgAiJoGjHhAiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci	:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcText::SetFontCharInfo (const FCFontCharInfo& fci)
{
	m_fci = fci;
} // CFCStcText::SetFontCharInfo.

//----- 02.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDfEiDjDiDhGiDiLiCmJiBeBjFfHiPiAjFlGiOjKiDfCiBfLiDgIiCmJiNiHiClJiClNjFlGiOjKiCpAjAnNjCoIiBeC_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcText::SetWindowTextW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiClHiCoJiDgFiDeMiDfIiDgHiCpA_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmFjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpText	:_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	SetWindowText _xZkqqHx_iCmF_xHqqkZx_MBCS_xZkqqHx_iCmFiLeMjIfOiClHiCoJiCmGiBeBiDgOiDjDiDePiDiLiDfCiBfLiDgIiClOiCmG_xHqqkZx_
 *			GetWindowText_xZkqqHx_iCmMiCmGiCkLiDfCiBfLiDgIiCkKiJlLiCkPiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcText::SetWindowTextW (const wchar_t* wcpText)
{
	m_wstrText = wcpText;
} // CFCStcText::SetWindowTextW.
//----- 02.09.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDfEiDjDiDhGiDiLiCmJiBeBjFfHiPiAjFlGiOjKiDfCiBfLiDgIiCmJiNiHiClJiClNjFlGiOjKiCpAjAnNjCoIiBeC_xHqqkZx_)-----

BEGIN_MESSAGE_MAP(CFCStcText, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCStcText)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCStcText _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcText::OnPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFgAiJoGiDiLiBfLiDgAiDjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcText::OnPaint ()
{
	CPaintDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_
	FCAutoDC atDC(&dc, FALSE, 0, 0);

	//---- _xZkqqHx_jEhHiMgJiCpAjFgAiJoG_xHqqkZx_ -----
	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_jEhHiMgJjAeGiOoGjDlOiBeC_xHqqkZx_GetBkColor_xZkqqHx_iCmNjBmKjGnKiBeCjEhHiMgJjAeGiCmFjDgIiCoIjCnHiClHiBeC_xHqqkZx_
	atDC.FillRect(rtClient, FCAtBrush(::GetSysColor(COLOR_3DFACE)));

	LOGFONT lf;
	FFCopy(lf, m_fci, g_->dDisplayPPM);
	atDC.SetFont(&lf);
	// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
	if (m_fci.dwMask & FDFI_FLAG_COLORREF)
		atDC.SetTextColor(::OptiColor(m_fci.crColor));
	else
		atDC.SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFgAiJoGiOjOiCmMiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetBkMode(TRANSPARENT);

	// _xZkqqHx_jFlGiOjKiKnEiKhFiCpAiOoGjDlOiBeC_xHqqkZx_
	long lCharAfter = 0;
	if (m_fci.dwMask & FDFI_FLAG_CHARAFTER)
		lCharAfter = tw2lg(m_fci.nCharAfter, g_->dDisplayPPM);

//----- 02.09.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDfEiDjDiDhGiDiLiCmJiBeBjFfHiPiAjFlGiOjKiDfCiBfLiDgIiCmJiNiHiClJiClNjFlGiOjKiCpAjAnNjCoIiBeC_xHqqkZx_)-----
//	WString strText;
//#if defined(_MBCS)
//	// _xZkqqHx_iDfCiBfLiDgIiDhJiBfLiDfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	DWORD dwCodePage = ::CharSetToCodePage(m_fci.byCharSet);
//	FFGetWindowText(this, strText, dwCodePage);
//#elif defined(_UNICODE)
//	FFGetWindowText(this, strText);
//#endif//_UNICODE
//
//	const wchar_t* tcpHead = strText;
//----- 02.09.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDfEiDjDiDhGiDiLiCmJiBeBjFfHiPiAjFlGiOjKiDfCiBfLiDgIiCmJiNiHiClJiClNjFlGiOjKiCpAjAnNjCoIiBeC_xHqqkZx_)-----
	// _xZkqqHx_iDfCiBfLiDgIiDhJiBfLiDfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	WORD wCodePage = ::CharSetToCodePage(m_fci.byCharSet);
	const wchar_t* tcpHead = m_wstrText;
//----- 02.09.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDfEiDjDiDhGiDiLiCmJiBeBjFfHiPiAjFlGiOjKiDfCiBfLiDgIiCmJiNiHiClJiClNjFlGiOjKiCpAjAnNjCoIiBeC_xHqqkZx_)-----

	// _xZkqqHx_jFlGiOjKjFgAiJoGiImKjChFiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
	long lX = rtClient.left;
	for (;;)
	{
		// _xZkqqHx_jFgAiJoGjIgHiCmMiJeFiCmJiDgFiDeMiDfIiDgHiCkKiIoMiCoKiClNiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (rtClient.right <= lX) break;
		if (*tcpHead == L'\0') break;
//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDfEiDjDiDhGiDiLiCmJiBeBjFfHiPiAjFlGiOjKiDfCiBfLiDgIiCmJiNiHiClJiClNjFlGiOjKiCpAjAnNjCoIiBeC_xHqqkZx_)-----
//		atDC.ExtTextOut(lX, rtClient.top, ETO_CLIPPED,
//						rtClient.left, rtClient.top,
//						rtClient.right, rtClient.bottom,
//						tcpHead, 1, NULL);
//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDfEiDjDiDhGiDiLiCmJiBeBjFfHiPiAjFlGiOjKiDfCiBfLiDgIiCmJiNiHiClJiClNjFlGiOjKiCpAjAnNjCoIiBeC_xHqqkZx_)-----
		atDC.ExtTextOut(lX, rtClient.top, ETO_CLIPPED,
						rtClient.left, rtClient.top,
						rtClient.right, rtClient.bottom,
						tcpHead, 1, wCodePage, NULL);
//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDfEiDjDiDhGiDiLiCmJiBeBjFfHiPiAjFlGiOjKiDfCiBfLiDgIiCmJiNiHiClJiClNjFlGiOjKiCpAjAnNjCoIiBeC_xHqqkZx_)-----
		// _xZkqqHx_jFlGiOjKiBgJiDfCiBfLiDgI_xHqqkZx_wChar_xZkqqHx_iBgKiCmMjFjNiCpAiOoGjDlOiBeC_xHqqkZx_
		ABC abc;
		atDC.GetCharABCWidth(*tcpHead, abc, wCodePage);
		tcpHead++;
		// _xZkqqHx_jFlGiOjKjFgAiJoGiImKjChFiCmJiBeBjFlGiOjKjFjNiBhLjFlGiOjKiKnEiKhFiCpAiJmBiOfKiBeC_xHqqkZx_
		lX += abc.abcA + abc.abcB + abc.abcC + lCharAfter;
	}

	// _xZkqqHx_jFgAiJoGjHhAiDiBiDgCiDfKiBfLiDfHiCmGiClFiCmE_xHqqkZx_ CStatic::OnPaint() _xZkqqHx_iCpAiMmEiCnBiPgPiClFiCmEiCmNiCkCiCkPiCnMiClJiCpB_xHqqkZx_
} // CFCStcText::OnPaint.
