#ifndef __StdClass_h
#define __StdClass_h

//;----- <EXPORT TO SDK> -----;

template<class T> interface IMpgSetContainer
{
	virtual set<T>* Create () const;
	virtual void Delete (set<T>* p) const;
	virtual typename set<T>::iterator begin (set<T>* p);
	virtual typename set<T>::const_iterator begin (const set<T>* p) const;
	virtual typename set<T>::iterator end (set<T>* p);
	virtual typename set<T>::const_iterator end (const set<T>* p) const;
	virtual typename set<T>::reverse_iterator rbegin (set<T>* p);
	virtual typename set<T>::const_reverse_iterator rbegin (const set<T>* p) const;
	virtual typename set<T>::reverse_iterator rend (set<T>* p);
	virtual typename set<T>::const_reverse_iterator rend (const set<T>* p) const;
	virtual typename set<T>::size_type size (const set<T>* p) const;
	virtual typename set<T>::size_type max_size (const set<T>* p) const;
	virtual bool empty (const set<T>* p) const;
	virtual pair<typename set<T>::iterator, bool> insert (set<T>* p, const T& x);
	virtual typename set<T>::iterator erase (set<T>* p, typename set<T>::iterator _P);
	virtual typename set<T>::iterator erase (set<T>* p, typename set<T>::iterator _F, typename set<T>::iterator _L);
	virtual typename set<T>::size_type erase (set<T>* p, const T& _Kv);
	virtual void clear (set<T>* p);
	virtual typename set<T>::const_iterator find (const set<T>* p, const T& _Kv) const;
	virtual typename set<T>::iterator find (set<T>* p, const T& _Kv);
	virtual typename set<T>::size_type count (const set<T>* p, const T& _Kv) const;
	virtual typename set<T>::iterator lower_bound (set<T>* p, const T& _Kv);
	virtual typename set<T>::const_iterator lower_bound (const set<T>* p, const T& _Kv) const;
	virtual typename set<T>::iterator upper_bound (set<T>* p, const T& _Kv);
	virtual typename set<T>::const_iterator upper_bound (const set<T>* p, const T& _Kv) const;

	virtual pair<typename set<T>::iterator, typename set<T>::iterator> equal_range (set<T>* p, const T& _Kv);
	virtual pair<typename set<T>::const_iterator, typename set<T>::const_iterator> equal_range (const set<T>* p, const T& _Kv) const;
}; // template<class T> interface IMpgSetContainer.

template<class T> interface IMpgSetIterator
{
	virtual T& Value (typename const set<T>::iterator& i);
	virtual void Inc (typename set<T>::iterator& i);
	virtual void Dec (typename set<T>::iterator& i);
	virtual bool IsEq (const typename set<T>::iterator& i1, const typename set<T>::iterator& i2);
	virtual const T& ConstValue (typename const set<T>::const_iterator& i);
	virtual void ConstInc (typename set<T>::const_iterator& i);
	virtual void ConstDec (typename set<T>::const_iterator& i);
	virtual bool ConstIsEq (const typename set<T>::const_iterator& i1, const typename set<T>::const_iterator& i2);
	virtual void Inc (typename set<T>::reverse_iterator& i);
	virtual void Dec (typename set<T>::reverse_iterator& i);
	virtual bool IsEq (const typename set<T>::reverse_iterator& i1, const typename set<T>::reverse_iterator& i2);
	virtual void ConstInc (typename set<T>::const_reverse_iterator& i);
	virtual void ConstDec (typename set<T>::const_reverse_iterator& i);
	virtual bool ConstIsEq (const typename set<T>::const_reverse_iterator& i1, const typename set<T>::const_reverse_iterator& i2);
}; // template<class T> interface IMpgSetIterator.

interface IMpgSet
{
	virtual IMpgSetContainer<DWORD>*	GetContainerI (DWORD*) = 0;
	virtual IMpgSetIterator<DWORD>*		GetIteratorI (DWORD*) = 0;
}; // interface IMpgSet.

interface IMpgStdClass
{
	virtual IMpgSet*	GetSetI () = 0;
}; // interface IMpgStdClass.

//;----- </EXPORT TO SDK> -----;

template<class T>
set<T>* IMpgSetContainer<T>::Create () const
{
	return new set<T>();
} // IMpgSetContainer<T>::Create.

template<class T>
void IMpgSetContainer<T>::Delete (set<T>* p) const
{
	delete p;
} // IMpgSetContainer<T>::Delete.

template<class T>
set<T>::iterator IMpgSetContainer<T>::begin (set<T>* p)
{
	return p->begin();
} // IMpgSetContainer<T>::begin.

template<class T>
set<T>::const_iterator IMpgSetContainer<T>::begin (const set<T>* p) const
{
	return p->begin();
} // IMpgSetContainer<T>::begin.

template<class T>
set<T>::iterator IMpgSetContainer<T>::end (set<T>* p)
{
	return p->end();
} // IMpgSetContainer<T>::end.

template<class T>
set<T>::const_iterator IMpgSetContainer<T>::end (const set<T>* p) const
{
	return p->end();
} // IMpgSetContainer<T>::end.

template<class T>
set<T>::reverse_iterator IMpgSetContainer<T>::rbegin (set<T>* p)
{
	return p->rbegin();
} // IMpgSetContainer<T>::rbegin.

template<class T>
set<T>::const_reverse_iterator IMpgSetContainer<T>::rbegin (const set<T>* p) const
{
	return ((const set<T>*)p)->rbegin();
} // IMpgSetContainer<T>::rbegin.

template<class T>
set<T>::reverse_iterator IMpgSetContainer<T>::rend (set<T>* p)
{
	return p->rend();
} // IMpgSetContainer<T>::rend.

template<class T>
set<T>::const_reverse_iterator IMpgSetContainer<T>::rend (const set<T>* p) const
{
	return ((const set<T>*)p)->rend();
} // IMpgSetContainer<T>::rend.

template<class T>
set<T>::size_type IMpgSetContainer<T>::size (const set<T>* p) const
{
	return p->size();
} // IMpgSetContainer<T>::size.

template<class T>
set<T>::size_type IMpgSetContainer<T>::max_size (const set<T>* p) const
{
	return p->max_size();
} // IMpgSetContainer<T>::max_size.

template<class T>
bool IMpgSetContainer<T>::empty (const set<T>* p) const
{
	return p->empty();
} // IMpgSetContainer<T>::empty.

template<class T>
pair<set<T>::iterator, bool> IMpgSetContainer<T>::insert (set<T>* p, const T& x)
{
	return p->insert(x);
} // IMpgSetContainer<T>::insert.

template<class T>
set<T>::iterator IMpgSetContainer<T>::erase (set<T>* p, set<T>::iterator _P)
{
	return p->erase(_P);
} // IMpgSetContainer<T>::erase.

template<class T>
set<T>::iterator IMpgSetContainer<T>::erase (set<T>* p, set<T>::iterator _F, set<T>::iterator _L)
{
	return p->erase(_F, _L);
} // IMpgSetContainer<T>::erase.

template<class T>
set<T>::size_type IMpgSetContainer<T>::erase (set<T>* p, const T& _Kv)
{
	return p->erase(_Kv);
} // IMpgSetContainer<T>::erase.

template<class T>
void IMpgSetContainer<T>::clear (set<T>* p)
{
	p->clear();
} // IMpgSetContainer<T>::clear.

template<class T>
set<T>::const_iterator IMpgSetContainer<T>::find (const set<T>* p, const T& _Kv) const
{
	return p->find(_Kv);
} // IMpgSetContainer<T>::find.

template<class T>
set<T>::iterator IMpgSetContainer<T>::find (set<T>* p, const T& _Kv)
{
	return p->find(_Kv);
} // IMpgSetContainer<T>::find.

template<class T>
set<T>::size_type IMpgSetContainer<T>::count (const set<T>* p, const T& _Kv) const
{
	return p->count(_Kv);
} // IMpgSetContainer<T>::count.

template<class T>
set<T>::iterator IMpgSetContainer<T>::lower_bound (set<T>* p, const T& _Kv)
{
	return p->lower_bound(_Kv);
} // IMpgSetContainer<T>::lower_bound.

template<class T>
set<T>::const_iterator IMpgSetContainer<T>::lower_bound (const set<T>* p, const T& _Kv) const
{
	return p->lower_bound(_Kv);
} // IMpgSetContainer<T>::lower_bound.

template<class T>
set<T>::iterator IMpgSetContainer<T>::upper_bound (set<T>* p, const T& _Kv)
{
	return p->upper_bound(_Kv);
} // IMpgSetContainer<T>::upper_bound.

template<class T>
set<T>::const_iterator IMpgSetContainer<T>::upper_bound (const set<T>* p, const T& _Kv) const
{
	return p->upper_bound(_Kv);
} // IMpgSetContainer<T>::upper_bound.

template<class T>
pair<set<T>::iterator, set<T>::iterator> IMpgSetContainer<T>::equal_range (set<T>* p, const T& _Kv)
{
	return p->equal_range(_Kv);
} // IMpgSetContainer<T>::equal_range.

template<class T>
pair<set<T>::const_iterator, set<T>::const_iterator> IMpgSetContainer<T>::equal_range (const set<T>* p, const T& _Kv) const
{
	return p->equal_range(_Kv);
} // IMpgSetContainer<T>::equal_range.

template<class T>
T& IMpgSetIterator<T>::Value (const set<T>::iterator& i)
{
	return *i;
} // IMpgSetIterator<T>::Value.

template<class T>
void IMpgSetIterator<T>::Inc (set<T>::iterator& i)
{
	i++;
} // IMpgSetIterator<T>::Inc.

template<class T>
void IMpgSetIterator<T>::Dec (set<T>::iterator& i)
{
	i--;
} // IMpgSetIterator<T>::Dec.

template<class T>
bool IMpgSetIterator<T>::IsEq (const set<T>::iterator& i1, const set<T>::iterator& i2)
{
	return (i1 == i2);
} // IMpgSetIterator<T>::IsEq.

template<class T>
const T& IMpgSetIterator<T>::ConstValue (const set<T>::const_iterator& i)
{
	return *i;
} // IMpgSetIterator<T>::ConstValue.

template<class T>
void IMpgSetIterator<T>::ConstInc (set<T>::const_iterator& i)
{
	i++;
} // IMpgSetIterator<T>::ConstInc.

template<class T>
void IMpgSetIterator<T>::ConstDec (set<T>::const_iterator& i)
{
	i--;
} // IMpgSetIterator<T>::ConstDec.

template<class T>
bool IMpgSetIterator<T>::ConstIsEq (const set<T>::const_iterator& i1, const set<T>::const_iterator& i2)
{
	return (i1 == i2);
} // IMpgSetIterator<T>::ConstIsEq.

template<class T>
void IMpgSetIterator<T>::Inc (set<T>::reverse_iterator& i)
{
	i++;
} // IMpgSetIterator<T>::Inc.

template<class T>
void IMpgSetIterator<T>::Dec (set<T>::reverse_iterator& i)
{
	i--;
} // IMpgSetIterator<T>::Dec.

template<class T>
bool IMpgSetIterator<T>::IsEq (const set<T>::reverse_iterator& i1, const set<T>::reverse_iterator& i2)
{
	return (i1 == i2);
} // IMpgSetIterator<T>::IsEq.

template<class T>
void IMpgSetIterator<T>::ConstInc (set<T>::const_reverse_iterator& i)
{
	i++;
} // IMpgSetIterator<T>::ConstInc.

template<class T>
void IMpgSetIterator<T>::ConstDec (set<T>::const_reverse_iterator& i)
{
	i--;
} // IMpgSetIterator<T>::ConstDec.

template<class T>
bool IMpgSetIterator<T>::ConstIsEq (const set<T>::const_reverse_iterator& i1, const set<T>::const_reverse_iterator& i2)
{
	return (i1 == i2);
} // IMpgSetIterator<T>::ConstIsEq.

////////////////////////////////////////////////////////////////////////////

class FCISet : public IMpgSet
{
public:
	virtual IMpgSetContainer<DWORD>*	GetContainerI (DWORD*) { return &m_ifDWORDContainer; }
	virtual IMpgSetIterator<DWORD>*		GetIteratorI (DWORD*)  { return &m_ifDWORDIterator; }
	IMpgSetContainer<DWORD>	m_ifDWORDContainer;
	IMpgSetIterator<DWORD>	m_ifDWORDIterator;
}; // class FCISet : public IMpgSet.

class FCIStdClass : public IMpgStdClass
{
public:
	virtual IMpgSet*	GetSetI () { return &m_ifStdSet; }
	FCISet	m_ifStdSet;
}; // class FCIStdClass.

#endif//__StdClass_h
