#include "stdafx.h"
#include "UtilMisc.h"		// For FdsecToFiletime.
#include "UtilStr.h"		// For FFCalcTextBox.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilCoord.h"		// For lg2mm.
#include "RegData.h"		// For g_pReg.
// 06.01.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "HiProject.h"	// For FCHiProject.
#include "TimeLabel.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


static mmetol s_mmTextMarginL = 1.0;
static mmetol s_mmTextMarginR = 2.0;
static mmetol s_mmTextMarginT = 2.0;
static mmetol s_mmTextMarginB = 2.0;

static double s_dTextLineGap = 0.1;

// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmM_xHqqkZx_ _xZkqqHx_jFjNiBiAiNiCiClD_xHqqkZx_ _xZkqqHx_iCmMiNmFjBoFjCgMiBeC_xHqqkZx_
static double s_dMaxWidthPerHeight = 4.0;
// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmM_xHqqkZx_ _xZkqqHx_jFjNiBiAiNiCiClD_xHqqkZx_ _xZkqqHx_iCmMjFfHiPiAjCgMiBeC_xHqqkZx_
static double s_dStdWidthPerHeight = 3.0;

// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDhJiDjDjFjNiBeC_xHqqkZx_
static mmetol s_mmLineWeight = 0.5;

const mmetol FD_WATCHMARK_WIDTH  = 4.0;
const mmetol FD_WATCHMARK_HEIGHT = 4.0;
const mmetol FD_WATCHMARK_OFFSET_X = 1.0;
const mmetol FD_WATCHMARK_OFFSET_Y = 1.0;

const DBLRect  FD_WATCH_PICT_A(0.0, 0.0, 4.0, 4.0);
const DBLPoint FD_WATCH_PICT_B[] = {
	DBLPoint(1.8, 2.1),
	DBLPoint(2.8, 2.1) };
const DBLPoint FD_WATCH_PICT_C[] = {
	DBLPoint(2.8, 2.1),
	DBLPoint(3.2, 1.9),
	DBLPoint(3.6, 2.1),
	DBLPoint(3.2, 2.3),
	DBLPoint(2.8, 2.1) };
const DBLPoint FD_WATCH_PICT_D[] = {
	DBLPoint(2.1, 2.4),
	DBLPoint(2.1, 1.1) };
const DBLPoint FD_WATCH_PICT_E[] = {
	DBLPoint(2.1, 1.1),
	DBLPoint(1.9, 0.7),
	DBLPoint(2.1, 0.3),
	DBLPoint(2.3, 0.7),
	DBLPoint(2.1, 1.1) };
const DBLPoint FD_WATCH_PICT_F[] = {
	DBLPoint(1.7, 2.0),
	DBLPoint(2.7, 2.0) };
const DBLPoint FD_WATCH_PICT_G[] = {
	DBLPoint(2.7, 2.0),
	DBLPoint(3.1, 1.8),
	DBLPoint(3.5, 2.0),
	DBLPoint(3.1, 2.2),
	DBLPoint(2.7, 2.0) };
const DBLPoint FD_WATCH_PICT_H[] = {
	DBLPoint(2.0, 2.3),
	DBLPoint(2.0, 1.0) };
const DBLPoint FD_WATCH_PICT_I[] = {
	DBLPoint(2.0, 1.0),
	DBLPoint(1.8, 0.6),
	DBLPoint(2.0, 0.2),
	DBLPoint(2.2, 0.6),
	DBLPoint(2.0, 1.0) };
const DBLRect FD_WATCH_PICT_J(0.2, 1.95, 0.7, 2.05);
const DBLRect FD_WATCH_PICT_K(1.95, 3.3, 2.05, 3.8);

const int FD_WATCH_PICT_B_SZ = sizeof(FD_WATCH_PICT_B) / sizeof(FD_WATCH_PICT_B[0]);
const int FD_WATCH_PICT_C_SZ = sizeof(FD_WATCH_PICT_C) / sizeof(FD_WATCH_PICT_C[0]);
const int FD_WATCH_PICT_D_SZ = sizeof(FD_WATCH_PICT_D) / sizeof(FD_WATCH_PICT_D[0]);
const int FD_WATCH_PICT_E_SZ = sizeof(FD_WATCH_PICT_E) / sizeof(FD_WATCH_PICT_E[0]);
const int FD_WATCH_PICT_F_SZ = sizeof(FD_WATCH_PICT_F) / sizeof(FD_WATCH_PICT_F[0]);
const int FD_WATCH_PICT_G_SZ = sizeof(FD_WATCH_PICT_G) / sizeof(FD_WATCH_PICT_G[0]);
const int FD_WATCH_PICT_H_SZ = sizeof(FD_WATCH_PICT_H) / sizeof(FD_WATCH_PICT_H[0]);
const int FD_WATCH_PICT_I_SZ = sizeof(FD_WATCH_PICT_I) / sizeof(FD_WATCH_PICT_I[0]);

const mmetol FD_WATCH_WEIGHT_A = 0.1;
const mmetol FD_WATCH_WEIGHT_B = 0.1;
const mmetol FD_WATCH_WEIGHT_C = 0.1;
const mmetol FD_WATCH_WEIGHT_D = 0.1;
const mmetol FD_WATCH_WEIGHT_E = 0.1;
const mmetol FD_WATCH_WEIGHT_F = 0.1;
const mmetol FD_WATCH_WEIGHT_G = 0.1;
const mmetol FD_WATCH_WEIGHT_H = 0.1;
const mmetol FD_WATCH_WEIGHT_I = 0.1;
const mmetol FD_WATCH_WEIGHT_J = 0.05;
const mmetol FD_WATCH_WEIGHT_K = 0.05;

const COLORREF FD_WATCH_PENCOL_A = FD_COLREF_BLACK;
const COLORREF FD_WATCH_PENCOL_B = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_PENCOL_C = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_PENCOL_D = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_PENCOL_E = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_PENCOL_F = FD_COLREF_DIM_GRAY;
const COLORREF FD_WATCH_PENCOL_G = FD_COLREF_DIM_GRAY;
const COLORREF FD_WATCH_PENCOL_H = FD_COLREF_DIM_GRAY;
const COLORREF FD_WATCH_PENCOL_I = FD_COLREF_DIM_GRAY;
const COLORREF FD_WATCH_PENCOL_J_1 = FD_COLREF_WHITE;
const COLORREF FD_WATCH_PENCOL_J_2 = FD_COLREF_BLACK;
const COLORREF FD_WATCH_PENCOL_K_1 = FD_COLREF_WHITE;
const COLORREF FD_WATCH_PENCOL_K_2 = FD_COLREF_BLACK;

const COLORREF FD_WATCH_BRUSHCOL_A = FD_COLREF_GAINS_BORO;
const COLORREF FD_WATCH_BRUSHCOL_C = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_BRUSHCOL_E = FD_COLREF_MIDNIGHT_BLUE;
const COLORREF FD_WATCH_BRUSHCOL_G = FD_COLREF_ORANGE;
const COLORREF FD_WATCH_BRUSHCOL_I = FD_COLREF_ORANGE;
const COLORREF FD_WATCH_BRUSHCOL_J = FD_COLREF_SILVER;
const COLORREF FD_WATCH_BRUSHCOL_K = FD_COLREF_SILVER;

/*************************************************************************
 *
 *             A        C        E                         F
 *          _xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEkH_xHqqkZx_                  _xZkqqHx_iEkFiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *      _xZkqqHx_iEkGiEjPiEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkCiEjPiEkG_xHqqkZx_
 *     B_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                                                _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_G
 *      _xZkqqHx_iEkJiEjPiEkA_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBjO_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJ_xHqqkZx_
 *     D_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkAiCfAiNhDjGnKiDgFiDeMiDfIiDgH_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_I
 *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkJiEjPiBjOiEkA_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJ_xHqqkZx_
 *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iOjOiMhG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_J
 *      _xZkqqHx_iEkIiEjPiEkA_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkAiCfBiNhDjGnKiDgFiDeMiDfIiDgH_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_I
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                                                _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_J
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkAiCfCiNhDjGnKiDgFiDeMiDfIiDgH_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_I
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                                                _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_H
 *          _xZkqqHx_iEkA_xHqqkZx_                                                _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEjPiEkI_xHqqkZx_
 *
 *       A :FD_WATCHMARK_OFFSET_X
 *       B :FD_WATCHMARK_OFFSET_Y
 *       C :FD_WATCHMARK_WIDTH
 *       D :FD_WATCHMARK_HEIGHT
 *       E :s_mmTextMarginL
 *       F :s_mmTextMarginR
 *       G :s_mmTextMarginT
 *       H :s_mmTextMarginB
 *       I :m_mmTextHeight
 *       J :s_dTextLineGap * m_mmTextHeight
 *
 *************************************************************************/


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::FCTimeLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTimeLabel::FCTimeLabel (	const DBLPoint& mmptCenter,
							const wchar_t* wcpLabelText,
							FDSECTIME fdstCreateTime,
							const GUID& guidUserId,
							const wchar_t* wcpUserName)
			:	m_mmrtFrame(mmptCenter, mmptCenter),
				m_wstrText(wcpLabelText),
				m_fdstCreateTime(fdstCreateTime),
				m_guidUserId(guidUserId),
				m_wstrUserName(wcpUserName),
				m_mmTextHeight(0),
				m_dZoom(0)
{
} // FCTimeLabel::FCTimeLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::GetFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const DBLRect& FCTimeLabel::GetFrame () const
{
	((FCTimeLabel*)this)->CalcLayout();
	return m_mmrtFrame;
} // FCTimeLabel::GetFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::GetOuterFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCTimeLabel::GetOuterFrame () const
{
// 06.02.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return GetFrame().ExtendRect(mm2lg(4));
// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiDhJiDjDjFjNiBeC_xHqqkZx_
	return GetFrame().ExtendRect(mm2lg(s_mmLineWeight) + 1);
} // FCTimeLabel::GetOuterFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::GetCenterPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCTimeLabel::GetCenterPoint () const
{
	return GetFrame().CenterPoint();
} // FCTimeLabel::GetCenterPoint.

//----- 05.09.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::SetCenterPoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCTimeLabel::SetCenterPoint (const DBLPoint& mmptCenter)
//{
//	CalcLayout();
//	m_mmrtFrame += (mmptCenter - m_mmrtFrame.CenterPoint());
//} // FCTimeLabel::SetCenterPoint.
//----- 05.09.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::GetLabelText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FCTimeLabel::GetLabelText () const
{
	return m_wstrText;
} // FCTimeLabel::GetLabelText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::GetCreateTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCTimeLabel::GetCreateTime () const
{
	return m_fdstCreateTime;
} // FCTimeLabel::GetCreateTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::GetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const GUID& FCTimeLabel::GetUserId () const
{
	return m_guidUserId;
} // FCTimeLabel::GetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::GetHintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmJjFfMiOkGiClHiCoJiCmMiCmJjDeLjDjGiCmIiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.01.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//WString FCTimeLabel::GetHintText (FCHiProject* pProject) const
WString FCTimeLabel::GetHintText () const
{
	COleDateTime otmDateCreate = FdsecToFiletime(m_fdstCreateTime);
	// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
	// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
	WString wstrDateCreate = TStrToWStr(otmDateCreate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));

	// IDS_FORM_HTREE_PROPERTY_H =
	//		_xZkqqHx_iOoNjFmK_xHqqkZx_:_xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_\r\n
	//		_xZkqqHx_jDoAjHgF_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iNoMjAkMjDpKiOjO_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iNoMjAkMiOnC_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iImKjChF_xHqqkZx_:(%f, %f)
	return FormatResString(	IDS_FORM_HTREE_PROPERTY_H,
							m_wstrText.c_str(),							// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
							wstrDateCreate.c_str(),						// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
// 06.01.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//							pProject->UserIdToUserName(m_guidUserId),	// _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
							m_wstrUserName.c_str(),						// _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
							mm2hi(m_mmrtFrame.CenterPoint().x),			// _xZkqqHx_iImKjChF_xHqqkZx_x_xZkqqHx_iBeC_xHqqkZx_
							mm2hi(m_mmrtFrame.CenterPoint().y));		// _xZkqqHx_iImKjChF_xHqqkZx_y_xZkqqHx_iBeC_xHqqkZx_
	return wstrDateCreate;
} // FCTimeLabel::GetHintText.

//----- 05.09.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::SetLabelText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCTimeLabel::SetLabelText (const wchar_t* wcpLabelText)
//{
//	m_wstrText = wcpLabelText;
//	CalcLayout();
//} // FCTimeLabel::SetLabelText.
//----- 05.09.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::OnDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTimeLabel::OnDraw (CDC* pDC)
{
	CalcLayout();
	FCAutoDC atDC(pDC);
	if (!almost0(g_pEnv->GetShadowLen()))
	//----- _xZkqqHx_iJgFiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		const DBLRect mmrtShadow = GetFrame() + g_pEnv->GetShadowLen();
		// _xZkqqHx_iJgFiCpAjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
		atDC.FillRect(mm2lg(mmrtShadow), FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_TIME_LABEL_SHADOW)));
	}
	// _xZkqqHx_jEhHiMgJiCpAjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
	atDC.FillRect(mm2lg(GetFrame()), FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_TIME_LABEL_FACE)));

	//----- _xZkqqHx_iOjOiMhGiDhNiBfLiDeOiCpAjFgAiJoG_xHqqkZx_ -----
	long lC;
	const DBLPoint mmptOffset(	GetFrame().left + FD_WATCHMARK_OFFSET_X,
								GetFrame().top + FD_WATCHMARK_OFFSET_Y);

	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_A), ::OptiColor(FD_WATCH_PENCOL_A));
	atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_A));
	atDC.Chord(mm2lg(FD_WATCH_PICT_A + mmptOffset), CPoint(0,0), CPoint(0,0));

	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_B), ::OptiColor(FD_WATCH_PENCOL_B));
	CPoint lgpt_B[FD_WATCH_PICT_B_SZ];
	for (lC = 0; lC < FD_WATCH_PICT_B_SZ; lC++)
		lgpt_B[lC] = mm2lg(FD_WATCH_PICT_B[lC] + mmptOffset);
	atDC.Polyline(lgpt_B, FD_WATCH_PICT_B_SZ);

	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_C), ::OptiColor(FD_WATCH_PENCOL_C));
	atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_C));
	CPoint lgpt_C[FD_WATCH_PICT_C_SZ];
	for (lC = 0; lC < FD_WATCH_PICT_C_SZ; lC++)
		lgpt_C[lC] = mm2lg(FD_WATCH_PICT_C[lC] + mmptOffset);
	atDC.Polygon(lgpt_C, FD_WATCH_PICT_C_SZ);

	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_D), ::OptiColor(FD_WATCH_PENCOL_D));
	CPoint lgpt_D[FD_WATCH_PICT_D_SZ];
	for (lC = 0; lC < FD_WATCH_PICT_D_SZ; lC++)
		lgpt_D[lC] = mm2lg(FD_WATCH_PICT_D[lC] + mmptOffset);
	atDC.Polyline(lgpt_D, FD_WATCH_PICT_D_SZ);

	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_E), ::OptiColor(FD_WATCH_PENCOL_E));
	atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_E));
	CPoint lgpt_E[FD_WATCH_PICT_E_SZ];
	for (lC = 0; lC < FD_WATCH_PICT_E_SZ; lC++)
		lgpt_E[lC] = mm2lg(FD_WATCH_PICT_E[lC] + mmptOffset);
	atDC.Polygon(lgpt_E, FD_WATCH_PICT_E_SZ);

	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_F), ::OptiColor(FD_WATCH_PENCOL_F));
	CPoint lgpt_F[FD_WATCH_PICT_F_SZ];
	for (lC = 0; lC < FD_WATCH_PICT_F_SZ; lC++)
		lgpt_F[lC] = mm2lg(FD_WATCH_PICT_F[lC] + mmptOffset);
	atDC.Polyline(lgpt_F, FD_WATCH_PICT_F_SZ);

	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_G), ::OptiColor(FD_WATCH_PENCOL_G));
	atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_G));
	CPoint lgpt_G[FD_WATCH_PICT_G_SZ];
	for (lC = 0; lC < FD_WATCH_PICT_G_SZ; lC++)
		lgpt_G[lC] = mm2lg(FD_WATCH_PICT_G[lC] + mmptOffset);
	atDC.Polygon(lgpt_G, FD_WATCH_PICT_G_SZ);

	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_H), ::OptiColor(FD_WATCH_PENCOL_H));
	CPoint lgpt_H[FD_WATCH_PICT_H_SZ];
	for (lC = 0; lC < FD_WATCH_PICT_H_SZ; lC++)
		lgpt_H[lC] = mm2lg(FD_WATCH_PICT_H[lC] + mmptOffset);
	atDC.Polyline(lgpt_H, FD_WATCH_PICT_H_SZ);

	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_I), ::OptiColor(FD_WATCH_PENCOL_I));
	atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_I));
	CPoint lgpt_I[FD_WATCH_PICT_I_SZ];
	for (lC = 0; lC < FD_WATCH_PICT_I_SZ; lC++)
		lgpt_I[lC] = mm2lg(FD_WATCH_PICT_I[lC] + mmptOffset);
	atDC.Polygon(lgpt_I, FD_WATCH_PICT_I_SZ);

	atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_J));
	atDC.FillRect(mm2lg(FD_WATCH_PICT_J + mmptOffset), FCAtBrush(::OptiColor(FD_WATCH_BRUSHCOL_J)));
	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_J), ::OptiColor(FD_WATCH_PENCOL_J_1));
	atDC.MoveTo(mm2lg(DBLPoint(FD_WATCH_PICT_J.left, FD_WATCH_PICT_J.bottom) + mmptOffset));
	atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_J.left, FD_WATCH_PICT_J.top) + mmptOffset));
	atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_J.right, FD_WATCH_PICT_J.top) + mmptOffset));
	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_J), ::OptiColor(FD_WATCH_PENCOL_J_2));
	atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_J.right, FD_WATCH_PICT_J.bottom) + mmptOffset));
	atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_J.left, FD_WATCH_PICT_J.bottom) + mmptOffset));

	atDC.SetBrush(::OptiColor(FD_WATCH_BRUSHCOL_K));
	atDC.FillRect(mm2lg(FD_WATCH_PICT_K + mmptOffset), FCAtBrush(::OptiColor(FD_WATCH_BRUSHCOL_K)));
	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_K), ::OptiColor(FD_WATCH_PENCOL_K_1));
	atDC.MoveTo(mm2lg(DBLPoint(FD_WATCH_PICT_K.left, FD_WATCH_PICT_K.bottom) + mmptOffset));
	atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_K.left, FD_WATCH_PICT_K.top) + mmptOffset));
	atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_K.right, FD_WATCH_PICT_K.top) + mmptOffset));
	atDC.SetPen(PS_SOLID, mm2lg(FD_WATCH_WEIGHT_K), ::OptiColor(FD_WATCH_PENCOL_K_2));
	atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_K.right, FD_WATCH_PICT_K.bottom) + mmptOffset));
	atDC.LineTo(mm2lg(DBLPoint(FD_WATCH_PICT_K.left, FD_WATCH_PICT_K.bottom) + mmptOffset));

	// _xZkqqHx_iDhEiDeIiDjDiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	LOGFONT logFont;
	g_pReg->InitRegFont(logFont, FDFT_TIME_LABEL_TEXT, 0, g_->dZoom);
	atDC.SetFont(&logFont);
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAjFgAiJoGiBeC_xHqqkZx_
	mmetol mmX = GetFrame().left + FD_WATCHMARK_OFFSET_X + FD_WATCHMARK_WIDTH + s_mmTextMarginL;
	mmetol mmY = GetFrame().top + s_mmTextMarginT;
	WStringVector::const_iterator iTxt;
	for (iTxt = m_vText.begin(); iTxt != m_vText.end(); iTxt++)
	{
		atDC.ExtTextOut(mm2lg(mmX), mm2lg(mmY), *iTxt, CP_ACP, NULL);
		mmY += m_mmTextHeight + (s_dTextLineGap * m_mmTextHeight);
	}

	//----- _xZkqqHx_jApMiCpAjFgAiJoG_xHqqkZx_ -----
	// _xZkqqHx_iDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, mm2lg(s_mmLineWeight), ::g_pReg->GetOptiRegColor(FDCL_TIME_LABEL_LINE));
	DBLPoint mmpta[5];
	CPoint lgpta[5];
	GetFrame().Get5Polygon(mmpta);
	mm2lg(lgpta, mmpta, 5);
	atDC.Polyline(lgpta, 5);
} // FCTimeLabel::OnDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabel::CalcLayout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 *
 *
 *
 *             A        C        E        mmBoxWidth       F
 *          _xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *      _xZkqqHx_iEkGiEjPiEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkCiEjPiEkG_xHqqkZx_
 *     B_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                                                _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_G
 *      _xZkqqHx_iEkJiEjPiEkA_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBjO_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJiEjPiEjPiEkG_xHqqkZx_
 *     D_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkAiCfAiNhDjGnKiDgFiDeMiDfIiDgH_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_I   _xZkqqHx_iEkA_xHqqkZx_
 *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkJiEjPiBjOiEkA_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJ_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iOjOiMhG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_J   _xZkqqHx_iEkA_xHqqkZx_
 *      _xZkqqHx_iEkIiEjPiEkA_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJ_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkAiCfBiNhDjGnKiDgFiDeMiDfIiDgH_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_I   _xZkqqHx_iEkA_xHqqkZx_mmBoxHeight
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJ_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                                                _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_J   _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJ_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkAiCfCiNhDjGnKiDgFiDeMiDfIiDgH_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_I   _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkAiEjPiEkJiEjPiEjPiEkI_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                                                _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_H
 *          _xZkqqHx_iEkA_xHqqkZx_                                                _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEjPiEkI_xHqqkZx_
 *
 *       A :FD_WATCHMARK_OFFSET_X
 *       B :FD_WATCHMARK_OFFSET_Y
 *       C :FD_WATCHMARK_WIDTH
 *       D :FD_WATCHMARK_HEIGHT
 *       E :s_mmTextMarginL
 *       F :s_mmTextMarginR
 *       G :s_mmTextMarginT
 *       H :s_mmTextMarginB
 *       I :m_mmTextHeight
 *       J :s_dTextLineGap * m_mmTextHeight
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTimeLabel::CalcLayout ()
{
	if (m_dZoom != g_->dZoom)
	{
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		WString wstrText = m_wstrText;
		// _xZkqqHx_iLpDjFlGiOjKiCmFiCmNiMhGiOfKiCmFiCkLiCmIiCkCiCmMiCmFiLpDjEjCiCpAjDpMiCoKiCoJiBeC_xHqqkZx_
		if (wstrText.IsEmpty()) wstrText = L" ";
//----- 06.04.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		m_dZoom = g_->dZoom;
		mmetol mmBoxWidth;
		mmetol mmBoxHeight;
		FFCalcTextBox(	mmBoxWidth,
						mmBoxHeight,
						m_mmTextHeight,
						m_vText,
						s_dMaxWidthPerHeight,
						s_dStdWidthPerHeight,
// 06.05.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//						FDFT_OBJECT_INIT,
						FDFT_TIME_LABEL_TEXT,
						wstrText,
						s_dTextLineGap * m_mmTextHeight,
						CP_ACP,
						TRUE,
						TRUE);

		mmBoxWidth += (FD_WATCHMARK_OFFSET_X + FD_WATCHMARK_WIDTH + s_mmTextMarginL + s_mmTextMarginR);
		mmBoxHeight += (s_mmTextMarginT + s_mmTextMarginB);
		if (mmBoxHeight < FD_WATCHMARK_OFFSET_Y + FD_WATCHMARK_HEIGHT + FD_WATCHMARK_OFFSET_Y)
			mmBoxHeight = FD_WATCHMARK_OFFSET_Y + FD_WATCHMARK_HEIGHT + FD_WATCHMARK_OFFSET_Y;
		const DBLPoint mmptCenter = m_mmrtFrame.CenterPoint();
		m_mmrtFrame.left = mmptCenter.x - mmBoxWidth / 2.0;
		m_mmrtFrame.top = mmptCenter.y - mmBoxHeight / 2.0;
		m_mmrtFrame.right = m_mmrtFrame.left + mmBoxWidth;
		m_mmrtFrame.bottom = m_mmrtFrame.top + mmBoxHeight;
	}
} // FCTimeLabel::CalcLayout.

