#include "stdafx.h"
#include "DynamicDraw.h"
#include <math.h>
// 03.07.18 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "MainFrame.h"		// For g_pFrame.
#include "DynamicDrawView.h"	// For g_pView.
#include "FoundDoc.h"		// For g_pDoc.
#include "ObjArc.h"			// For FCObjArc.
#include "LinkManager.h"	// For g_pDoc->LinkManager().
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMisc.h"			// For HitTest.
#include "UtilArc.h"		// For GetArcPolygon.
#include "Arrow.h"			// For FCStdArrow.
#include "UtilGraph.h"		// For FCEditDraw.
#include "RegData.h"		// For GetOptiRegColor.
#include "FrameWnd.h"		// For FFGetMainWnd().
#include "ToolArcEdit.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// 02.12.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//FCToolArcEdit g_toolArcEdit;

/////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiNiBfLiDeKiDiLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mySnapR
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiCpA_xHqqkZx_0.05_xZkqqHx_iNiPiCnNiCmFiDfIiDgJiDgCiDhGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR	:_xZkqqHx_jFmPiKlHiClHiCoJiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiKlHiMoDiCmMiKhAjDhIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static double mySnapR (double dR)
{
	if (!g_pReg->GetIsSnap()) return dR;
	// _xZkqqHx_iKhAjDhIiCpA_xHqqkZx_ 0 _xZkqqHx_iImIiPoD_xHqqkZx_ 2 _xZkqqHx_jGkCjGjOiCmJjAlDiLeLiJlLiBeC_xHqqkZx_
// 05.04.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return RegulateAngle(double(D2L(dR / 0.05)) * 0.05);
	return RegulateAngle(double(D2L(dR / g_pReg->GetSnapAngle())) * g_pReg->GetSnapAngle());
} // mySnapR.

/////////////////////////////////////////////////////////////////////////
// FCToolArcEdit_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolArcEdit::OnDraw (CDC* pDC)
////void FCToolArcEdit::OnDraw (CDC* pDC, const DBLRect* pmmrtRgn, long lRgnSize)
//{
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (GetCurrentState())
//	{
//	case STATE_MOVING_EDGE:		// _xZkqqHx_jCfLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
//	  {
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDraw(pDC);
//		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//		FCEditDraw eDraw(pDC, mm2lg(m_pHitObj->GetStdPenWeight()));
//		// _xZkqqHx_iMlDiCmMiPeDjAlDjApMiCpAiPmBiLiOiBeC_xHqqkZx_
//		eDraw.Polyline(m_vlgptArcP.begin(), m_vlgptArcP.size());
//		break;
//	  }
//	default:	// STATE_ENTER_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
//				// STATE_EXIT_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
//				// STATE_START_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
//				// STATE_STOP_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDraw(pDC);
//	}
//} // FCToolArcEdit::OnDraw.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: CDC*
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	View_xZkqqHx_iCmFjBeJjBpAjCiGiCmMjFjEjFgJiCpAjBfDiCmE_xHqqkZx_m_vSelInfo_xZkqqHx_iCnGjAnNjCoIiClHiCoJiBeCiLmIjApMjFjEjFgJiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiCkKiCkAiCoJiClNiCnPiBeBjCfAiCmIiCoJ_xHqqkZx_ ObjDynabaseVector _xZkqqHx_iCmFiCmNiPiIjHjNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBjDmBiOoKiCmIiDhIiDeOiDfOiBfL_xHqqkZx_ JointSelInfoVector _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::Select (CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);

	m_pHitObj	= NULL;			// _xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
	m_iHitEdge	= FDEK_NONE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiBeC_xHqqkZx_
	m_dR = 0;					// _xZkqqHx_iMlLiNnNiCmMiKhAjDhIiCpAiLeMjIfOiBeC_xHqqkZx_
	m_vlgptArcP.clear();		// _xZkqqHx_iMmDiCkCiPeDjAlDjApMiCpAiLeMjIfOiBeC_xHqqkZx_
} // FCToolArcEdit::Select.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::DrawSelectMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjFfMiOkGiOjOiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBgJjEpBjFfMiOkGiBgKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jFfMiOkGiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiDeKiDgJiDiBjDfPiDhNiBfLiDeOiCmGiBeBjBeJjBpAjCiGjIeBiMiLjDfPiCmMiIpIjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::DrawSelectMark (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_iJhOiMmKjFjEjFgJiCmFiCmIiCkCiPoKiNiHiCmNjFgAiJoGiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FDOJ_ARC)) return;
	FCObjArc* pArc = (FCObjArc*)pObj;

	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);

	const double dSinR = sin(pArc->GetAngle() * M_PI);
	const double dCosR = cos(pArc->GetAngle() * M_PI);

	//----- _xZkqqHx_iJhOiMmKiCmMiOlCjApMiCmMiMhGiOfKiBjFjFgAiJoG_xHqqkZx_ -----
	DBLPoint mmptH(pArc->GetCenterX() + pArc->GetHAxisX(), pArc->GetCenterY());
	::ShiftConv(mmptH, pArc->GetVAxisY(), pArc->GetVAxisX(), pArc->GetCenterY());
	::RotateConv(mmptH, dSinR, dCosR, pArc->GetCenterX(), pArc->GetCenterY());
	DBLPoint mmptV(pArc->GetCenterX(), pArc->GetCenterY() + pArc->GetVAxisY());
	::ShiftConv(mmptV, pArc->GetVAxisY(), pArc->GetVAxisX(), pArc->GetCenterY());
	::RotateConv(mmptV, dSinR, dCosR, pArc->GetCenterX(), pArc->GetCenterY());
	DBLPoint mmptC(pArc->GetCenterX(), pArc->GetCenterY());

	//----- _xZkqqHx_jGoOiIpDiCmMjFgAiJoG_xHqqkZx_ -----
	DBLPointVector vmmptPoly;
	vmmptPoly.push_back(mmptH);
	vmmptPoly.push_back(2 * mmptC - mmptH);
	FCStdArrow arrow(FCUGArrowParams(FDUG_ARW_TYPE_TYPICAL,
									FDUG_ARW_STYL_ARROW_C1, 3, 0), FALSE);
	// _xZkqqHx_iDfJiBfLiDiA_xHqqkZx_100%_xZkqqHx_iCmMiOjOiCmM_xHqqkZx_1mm_xZkqqHx_iCpAiKoOiPiAiCmJiBeBiPoNiCmJjDkPiClGjIfPjHjNjFjNiCmJiCmIiCoJiCoGiCkEiCmJiBeC_xHqqkZx_
	arrow.InitByPoly(vmmptPoly, lg2mm(g_->dDisplayPPM), 0.0,
					FD_PEN_STYLE_SOLID, 0.0, FD_S_COLOR_BLACK,
					FD_PATTERN_UNUSE, FD_S_COLOR_TRANSPARENT, FD_S_COLOR_BLACK,
					FD_S_COLOR_TRANSPARENT);
	arrow.FillArrow(eDraw, lg2mm(g_->lgdPrecision));
	eDraw.Line(&mm2lg(vmmptPoly[0]), &mm2lg(vmmptPoly[1]));
	eDraw.Line(&mm2lg(mmptV), &mm2lg(2 * mmptC - mmptV));
	//----- _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmMiMhGiOfKiBjFjFgAiJoG_xHqqkZx_ -----
	DBLPoint mmptBgn, mmptEnd;
	FCObjArc::GetEdgePos(mmptBgn, pArc, pArc->GetArcBgnR(), dSinR, dCosR);
	FCObjArc::GetEdgePos(mmptEnd, pArc, pArc->GetArcEndR(), dSinR, dCosR);
	eDraw.GeneralMark(mm2lg(mmptBgn));
	if (mm2lg(mmptBgn) != mm2lg(mmptEnd))
		eDraw.GeneralMark(mm2lg(mmptEnd));
} // FCToolArcEdit::DrawSelectedMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::CanHandle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiClBiCmMiDgDiBfLiDiLiCmFiIlFiCkGiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolArcEdit::CanHandle (const FCObjDynabase* pObj) const
{
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return pObj->IsKindOf(FDOJ_ARC);
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!pObj->IsKindOf(FDOJ_ARC)) return FALSE;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CanHandle(pObj);
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolArcEdit::CanHandle.

//----- 01.08.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::IsObjectCommandEnable
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCmMjCoIjAkLjDeJiCmIjHeMiMpIiBeFjGlDiMpIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolArcEdit::IsObjectCommandEnable (DWORD dwCmdID) const
//{
//	switch (dwCmdID)
//	{
//	case ID_OBJECT_DISCONNECT:
//	case ID_OBJECT_CONNECT:
//		return TRUE;
//	default:
//		return BASE_CLASS::IsObjectCommandEnable(dwCmdID);
//	}
//} // FCToolArcEdit::IsObjectCommandEnable.
//----- 01.08.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::CheckHitEdge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiPpDjBnEiCpAiBeBiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ m_iHitOn, m_pHitObj, m_lHitMolip,
 *			m_mmptHitPos _xZkqqHx_iCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolArcEdit::CheckHitEdge ()
{
//----- 05.06.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_pHitObj	= NULL;			// _xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
//	m_iHitEdge	= FDEK_NONE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiBeC_xHqqkZx_
//	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmMjIfPjHjNiNmAjFfHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
//	const CPoint lgptMsc = mm2lg(m_mmptMsc);
//	ObjDynabaseVector::const_reverse_iterator rObj;
//	for (rObj = g_pView->SelectObjVector().rbegin();
//		 rObj != g_pView->SelectObjVector().rend(); rObj++)
//	{
//		FCObjArc* pArc = (FCObjArc*)*rObj;
//		//----- _xZkqqHx_iOgOjCfLjDfPiBeFiPeJjCfLjDfPiCmMiMhGiOfK_xHqqkZx_ -----
//		const double dSinR = sin(pArc->GetAngle() * M_PI);
//		const double dCosR = cos(pArc->GetAngle() * M_PI);
//		// _xZkqqHx_iOgOjCfLjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
//		DBLPoint mmptBgn;
//		FCObjArc::GetEdgePos(mmptBgn, pArc, pArc->GetArcBgnR(), dSinR, dCosR);
//		if (::HitTest(mm2lg(mmptBgn), lgptMsc))
//		//----- _xZkqqHx_iOgOjCfLjDfPiCkKiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			m_pHitObj	= pArc;			// _xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
//			m_iHitEdge	= FDEK_BEGIN;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiBeC_xHqqkZx_
//			return TRUE;
//		}
//		// _xZkqqHx_iPeJjCfLjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
//		DBLPoint mmptEnd;
//		FCObjArc::GetEdgePos(mmptEnd, pArc, pArc->GetArcEndR(), dSinR, dCosR);
//		if (::HitTest(mm2lg(mmptEnd), lgptMsc))
//		//----- _xZkqqHx_iPeJjCfLjDfPiCkKiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			m_pHitObj	= pArc;		// _xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
//			m_iHitEdge	= FDEK_END;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiBeC_xHqqkZx_
//			return TRUE;
//		}
//	}
//	// _xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiBeC_xHqqkZx_
//	return FALSE;
//----- 05.06.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	m_pHitObj	= NULL;			// _xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
	m_iHitEdge	= FDEK_NONE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiBeC_xHqqkZx_
	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClHiCoJjFnCiPfHiDgOiDjDiDgIiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	set<FCHandleId> stIds;
	CheckHitHandle(stIds, m_mmptMsc);
	ObjDynabaseVector::const_reverse_iterator rObj;
	for (rObj = g_pView->SelectObjVector().rbegin();
		 rObj != g_pView->SelectObjVector().rend(); rObj++)
	{
		if (stIds.find(FCHandleId((*rObj)->GetObjID(), FDEK_BEGIN, 0, 0)) != stIds.end())
		//----- _xZkqqHx_iOgOjCfLjDfPiCkKiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			m_pHitObj	= (FCObjArc*)(*rObj);	// _xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
			m_iHitEdge	= FDEK_BEGIN;			// _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiBeC_xHqqkZx_
			return TRUE;
		}
		if (stIds.find(FCHandleId((*rObj)->GetObjID(), FDEK_END, 0, 0)) != stIds.end())
		//----- _xZkqqHx_iPeJjCfLjDfPiCkKiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			m_pHitObj	= (FCObjArc*)(*rObj);	// _xZkqqHx_iDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
			m_iHitEdge	= FDEK_END;				// _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiBeC_xHqqkZx_
			return TRUE;
		}
	}
	// _xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiBeC_xHqqkZx_
	return FALSE;
//----- 05.06.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolArcEdit::CheckHitEdge.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::OnDrawState (CDC* pDC, int iState)
{
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (iState)
//	{
//	case STATE_MOVING_EDGE:		// _xZkqqHx_jCfLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
//	  {
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDrawState(pDC, iState);
//		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//		FCEditDraw eDraw(pDC, mm2lg(m_pHitObj->GetStdPenWeight()));
//		// _xZkqqHx_iMlDiCmMiPeDjAlDjApMiCpAiPmBiLiOiBeC_xHqqkZx_
//		eDraw.Polyline(m_vlgptArcP.begin(), m_vlgptArcP.size());
//		break;
//	  }
//	default:	// STATE_ENTER_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
//				// STATE_EXIT_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
//				// STATE_START_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
//				// STATE_STOP_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDrawState(pDC, iState);
//	}
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_MOVING_EDGE:		// _xZkqqHx_jCfLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
		FCEditDraw eDraw(pDC, mm2lg(m_pHitObj->GetStdPenWeight()));
		// _xZkqqHx_iMlDiCmMiPeDjAlDjApMiCpAiPmBiLiOiBeC_xHqqkZx_
		eDraw.Polyline(m_vlgptArcP.begin(), m_vlgptArcP.size());
		break;
	  }
	default:	// STATE_ENTER_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
				// STATE_EXIT_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
				// STATE_START_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
				// STATE_STOP_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
		break;
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolArcEdit::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolArcEdit.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolArcEdit::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_IDLE:			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
//----- 02.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
		if (FFCanEditObject())
		//----- _xZkqqHx_jFjEjFgJjFnCiPfHiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
		{
//----- 02.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
			switch (iEvent)
			{
			case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
				if (CheckHitEdge())
					iNextState = STATE_ENTER_MOVE_EDGE;	// _xZkqqHx_jCfLjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
				break;
			}
// 02.06.05 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)
		}
		break;
	case STATE_ENTER_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_START_MOVE_EDGE;		// _xZkqqHx_jCfLjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_EXIT_MOVE_EDGE;		// _xZkqqHx_jCfLjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_START_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
		iNextState = STATE_MOVING_EDGE;		// _xZkqqHx_jCfLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
		break;
	case STATE_MOVING_EDGE:		// _xZkqqHx_jCfLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_MOVING_EDGE;		// _xZkqqHx_jCfLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_MOVE_EDGE;	// _xZkqqHx_jCfLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_EXIT_MOVE_EDGE;		// _xZkqqHx_jCfLjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
		break;
	case STATE_EXIT_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
		iNextState = STATE_IDLE;			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolArcEdit::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_ENTER_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
		StateEnterMoveEdge(pDC);
		break;
	case STATE_START_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
		StateStartMoveEdge(pDC);
		break;
	case STATE_MOVING_EDGE:		// _xZkqqHx_jCfLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
		StateMovingEdge(pDC);
		break;
	case STATE_STOP_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
		StateStopMoveEdge(pDC);
		break;
	case STATE_EXIT_MOVE_EDGE:	// _xZkqqHx_jCfLjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
		StateExitMoveEdge(pDC);
		break;
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolArcEdit::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::StateIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBnCiClPiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::StateIdle (CDC* pDC)
{
//	TRACE(_T("StateIdle\r\n"));
	// _xZkqqHx_iDhBiDgCiDgHiCmMiPoKiNiHiCmNiDeKiBfLiDfMiDiLjFmPiNfIiBeC_xHqqkZx_
	if (CheckHitEdge())
		SetIdleCursor(FFGetApp()->LoadStandardCursor(IDC_SIZEALL));
	// _xZkqqHx_iDhBiDgCiDgHiDeKiBfLiDfMiDiLiCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
	m_iCursorNew = FDPA_HIT_NONE;
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGjDjJiBeC_xHqqkZx_
	BASE_CLASS::StateIdle(pDC);
} // FCToolArcEdit::StateIdle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::StateEnterMoveEdge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfLjDfPiInKjDkOjDpMiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::StateEnterMoveEdge (CDC* pDC)
{
	TRACE(_T("StateEnterMoveEdge\r\n"));
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);

	if (m_iHitEdge == FDEK_BEGIN)
	//----- _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiCkKiOgOjCfLjDfPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMlLiNnNiCmMiKhAjDhIiCpAjAnNjCoIiBeC_xHqqkZx_
		m_dR = m_pHitObj->GetArcBgnR();
	} else
	//----- _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiCkKiPeJjCfLjDfPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMlLiNnNiCmMiKhAjDhIiCpAjAnNjCoIiBeC_xHqqkZx_
		m_dR = m_pHitObj->GetArcEndR();
	}
	//----- _xZkqqHx_iMlLiNnNiCmMiKhAjDhIiCpAiMhGiOfK_xHqqkZx_ -----
	const double dSinR = sin(m_pHitObj->GetAngle() * M_PI);
	const double dCosR = cos(m_pHitObj->GetAngle() * M_PI);
	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCnGiCmMjFfMiOkGiPiIjHjN_xHqqkZx_ -----
	DBLPoint mmptEdge;
	WString strMsg;
	FCObjArc::GetEdgePos(mmptEdge, m_pHitObj, m_dR, dSinR, dCosR);
	strMsg.Format(L"X:%f Y:%f R:%f", mm2hi(mmptEdge.x), mm2hi(mmptEdge.y), m_dR);
	FFGetMainWnd()->SetStatusBarText(strMsg);
} // FCToolArcEdit::StateEnterMoveEdge.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::StateStartMoveEdge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfLjDfPiInKjDkOiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::StateStartMoveEdge (CDC* pDC)
{
	TRACE(_T("StateStartMoveEdge\r\n"));
//----- 01.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
	g_pView->SetAutoScroll(TRUE);
//----- 01.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, mm2lg(m_pHitObj->GetStdPenWeight()));
	// _xZkqqHx_iPeDjAlDjApMiCpAiMhGiOfKiBjFjFgAiJoGiBeC_xHqqkZx_
	::GetArcPolygon(m_vlgptArcP,
					m_pHitObj->GetCenterX() * g_->dZoom,
					m_pHitObj->GetCenterY() * g_->dZoom,
					m_pHitObj->GetHAxisX() * g_->dZoom,
					m_pHitObj->GetVAxisY() * g_->dZoom,
					m_pHitObj->GetArcBgnR(), m_pHitObj->GetArcEndR(),
					FDOA_PIE, g_->lgdPrecision,
					m_pHitObj->GetVAxisX() * g_->dZoom,
					m_pHitObj->GetAngle(),
					m_pHitObj->GetCenterX() * g_->dZoom,
					m_pHitObj->GetCenterY() * g_->dZoom);
	eDraw.Polyline(m_vlgptArcP.begin(), m_vlgptArcP.size());
} // FCToolArcEdit::StateStartMoveEdge.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::StateMovingEdge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfLjDfPiInKjDkOjCiGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::StateMovingEdge (CDC* pDC)
{
	TRACE(_T("StateMovingEdge\r\n"));

	//----- _xZkqqHx_iMlLiNnNiCmMiKhAjDhIiCpAiMhGiOfK_xHqqkZx_ -----
	const double dSinR = sin(m_pHitObj->GetAngle() * M_PI);
	const double dCosR = cos(m_pHitObj->GetAngle() * M_PI);

	//----- _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiLhEjFmPiKlH_xHqqkZx_ -----
	DBLPoint mmptMscRot = m_mmptMsc;
	::RotateConv(mmptMscRot, -dSinR, dCosR,
				m_pHitObj->GetCenterX(), m_pHitObj->GetCenterY());
	::ShiftConv(mmptMscRot, m_pHitObj->GetVAxisY(),
				-m_pHitObj->GetVAxisX(), m_pHitObj->GetCenterY());
	//----- _xZkqqHx_iLhEjFmPiKlHiNmAjFfHiCkJiCoHiBeBiDhNiDeFiDfIiImKjChFiCmMiKhAjDhIiCpAiOfKiPgP_xHqqkZx_ -----
	mmptMscRot -= DBLPoint(	m_pHitObj->GetCenterX(),
							m_pHitObj->GetCenterY());
// 00.09.19 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	ASSERT(!almost0(m_pHitObj->GetVAxisY()));
//----- 00.09.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// y_xZkqqHx_jFpLiMpMiCmMjBoFiCkLiClDiCpAiBeBiJhOiMmKiCmMiPgDiJkBjEoEiCmFjAlDjFpLiJhOiMmKiCmJiPeDjAlDiBeC_xHqqkZx_
//	mmptMscRot.y *= m_pHitObj->GetHAxisX() / m_pHitObj->GetVAxisY();
//----- 00.09.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// y_xZkqqHx_jFpLiMpMiCmMjBoFiCkLiClDiCpAiBeBiJhOiMmKiCmMiPgDiJkBjEoEiCmFjAlDjFpLiJhOiMmKiCmJiPeDjAlDiBeC_xHqqkZx_
	if (!almost0(m_pHitObj->GetVAxisY()))
		mmptMscRot.y *= m_pHitObj->GetHAxisX() / m_pHitObj->GetVAxisY();
//----- 00.09.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	double dR = ::mySnapR(::ArcTan(mmptMscRot));

	// _xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiKhAjDhIiCmJjFmPiJlLiCkKjGlDiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_dR == dR) return;
	// _xZkqqHx_jAfGiClFiCkCiKhAjDhIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_dR = dR;

	double dBgnR, dEndR;
	if (m_iHitEdge == FDEK_BEGIN)
	//----- _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiCkKiOgOjCfLjDfPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		dBgnR = m_dR;
		dEndR = m_pHitObj->GetArcEndR();
	} else
	//----- _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiCkKiPeJjCfLjDfPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		dBgnR = m_pHitObj->GetArcBgnR();
		dEndR = m_dR;
	}

	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, mm2lg(m_pHitObj->GetStdPenWeight()));
	// _xZkqqHx_iMlDiCmMiPeDjAlDjApMiCpAiPmBiLiOiBeC_xHqqkZx_
	eDraw.Polyline(m_vlgptArcP.begin(), m_vlgptArcP.size());
	// _xZkqqHx_iPeDjAlDjApMiCpAiMhGiOfKiBjFjFgAiJoGiBeC_xHqqkZx_
	::GetArcPolygon(m_vlgptArcP,
					m_pHitObj->GetCenterX() * g_->dZoom,
					m_pHitObj->GetCenterY() * g_->dZoom,
					m_pHitObj->GetHAxisX() * g_->dZoom,
					m_pHitObj->GetVAxisY() * g_->dZoom,
					dBgnR, dEndR, FDOA_PIE, g_->lgdPrecision,
					m_pHitObj->GetVAxisX() * g_->dZoom,
					m_pHitObj->GetAngle(),
					m_pHitObj->GetCenterX() * g_->dZoom,
					m_pHitObj->GetCenterY() * g_->dZoom);
	eDraw.Polyline(m_vlgptArcP.begin(), m_vlgptArcP.size());

	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCnGiCmMjFfMiOkGiPiIjHjN_xHqqkZx_ -----
	DBLPoint mmptEdge;
	WString strMsg;
	FCObjArc::GetEdgePos(mmptEdge, m_pHitObj, m_dR, dSinR, dCosR);
	strMsg.Format(L"X:%f Y:%f R:%f", mm2hi(mmptEdge.x), mm2hi(mmptEdge.y), m_dR);
	FFGetMainWnd()->SetStatusBarText(strMsg);
} // FCToolArcEdit::StateMovingEdge.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::StateStopMoveEdge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfLjDfPiInKjDkOiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::StateStopMoveEdge (CDC* pDC)
{
	TRACE(_T("StateStopMoveEdge\r\n"));

//----- 01.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);
//----- 01.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, mm2lg(m_pHitObj->GetStdPenWeight()));
	// _xZkqqHx_iMlDiCmMiPeDjAlDjApMiCpAiPmBiLiOiBeC_xHqqkZx_
	eDraw.Polyline(m_vlgptArcP.begin(), m_vlgptArcP.size());
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_jFmPiNfIjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AddRgn(m_pHitObj);
	// _xZkqqHx_jCfLjDfPjFmPiNfIiDfCiDhNiDjDiDgIiCmMjEkNiNhDiBeC_xHqqkZx_
	if (m_iHitEdge == FDEK_BEGIN)
	//----- _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiCkKiOgOjCfLjDfPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FCArcRec arcRec;
		arcRec.wMask = FDFP_ARCBGNR;
		arcRec.dArcBgnR = m_dR;
		g_pDoc->CmdModifyArc(m_pHitObj, arcRec);
	} else
	//----- _xZkqqHx_iDhBiDgCiDgHiClFiClNjCfLjDfPiCkKiPeJjCfLjDfPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FCArcRec arcRec;
		arcRec.wMask = FDFP_ARCENDR;
		arcRec.dArcEndR = m_dR;
		g_pDoc->CmdModifyArc(m_pHitObj, arcRec);
	}
	// _xZkqqHx_jFmPiNfIiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(m_pHitObj);
//----- 05.06.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFmPiNfIiClFiClNiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
//	FTMolipSet setMolip;
//	setMolip.insert(FCMolipRec(m_pHitObj->GetObjID(), -1));
//	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify(setMolip);
//----- 05.06.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	g_pDoc->LinkManager()->MovedNotify(m_pHitObj);
//----- 05.06.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 05.06.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMjFmPiNfIiCpAiClBiCmMiDgDiBfLiDiLiCmJjCmKjCgNiBeC_xHqqkZx_
	OnSelectObjModified();
//----- 05.06.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
} // FCToolArcEdit::StateStopMoveEdge.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::StateExitMoveEdge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfLjDfPiInKjDkOiPgPiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::StateExitMoveEdge (CDC* pDC)
{
	TRACE(_T("StateExitMoveEdge\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiBeC_xHqqkZx_
	::FFReleaseCapture();
} // FCToolArcEdit::StateExitMoveEdge.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArcEdit::ResetEditHandleList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolArcEdit::ResetEditHandleList ()
{
	// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	ClearEditHandleList();
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = g_pView->SelectObjVector().begin();
		 iObj != g_pView->SelectObjVector().end(); iObj++)
	{
		FCObjArc* pArc = (FCObjArc*)*iObj;
		//----- _xZkqqHx_iOgOjCfLjDfPiBeFiPeJjCfLjDfPiCmMiMhGiOfK_xHqqkZx_ -----
		const double dSinR = sin(pArc->GetAngle() * M_PI);
		const double dCosR = cos(pArc->GetAngle() * M_PI);
		// _xZkqqHx_iOgOjCfLjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
		DBLPoint mmptBgn;
		FCObjArc::GetEdgePos(mmptBgn, pArc, pArc->GetArcBgnR(), dSinR, dCosR);
		// _xZkqqHx_iOgOjCfLjDfPiCpAjDgPjIfOiBeC_xHqqkZx_ID=(_xZkqqHx_jFjEjFgJ_xHqqkZx_ID, FDEK_BEGIN, 0, 0)_xZkqqHx_iBeC_xHqqkZx_
		AddEditHandle(mmptBgn, FCHandleId(long(pArc->GetObjID()), FDEK_BEGIN, 0, 0));

		// _xZkqqHx_iPeJjCfLjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
		DBLPoint mmptEnd;
		// _xZkqqHx_iPeJjCfLjDfPiCpAjDgPjIfOiBeC_xHqqkZx_ID=(_xZkqqHx_jFjEjFgJ_xHqqkZx_ID, FDEK_END, 0, 0)_xZkqqHx_iBeC_xHqqkZx_
		FCObjArc::GetEdgePos(mmptEnd, pArc, pArc->GetArcEndR(), dSinR, dCosR);
		AddEditHandle(mmptEnd, FCHandleId(long(pArc->GetObjID()), FDEK_END, 0, 0));
	}
} // FCToolArcEdit::ResetEditHandleList.

