#ifndef __ToolArrowTmpl_h
#define __ToolArrowTmpl_h

#include "stdafx.h"
#include "DynamicDraw.h"		// For ID_TLCMD_XXXX.
#include "Arrow.h"				// For FDUG_ARW_TYPE_FLAT.etc..
#include "UtilMisc.h"				// For CalcCrossPointLinePolyline.
#include "UtilStr.h"			// For GetResString.
#include "UtilDlg.h"			// For RightByLeftHand.
#include "RegData.h"			// For FCRegData.
#include "ObjPoly.h"			// FCObjPoly.
#include "FoundDoc.h"			// For g_pDoc.
#include "LinkManager.h"		// For FCMolipRec.
// 05.04.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "PrtArrowTmpl.h"		// For CFCPrtArrowTmpl.
#include "DynamicDrawView.h"	// For g_pView.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS SUPER

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	class FCToolArrowTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDjFjEjFgJiNoMjAkMiDgDiBfLiDiLiCmMiInHiCmM_xHqqkZx_template_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_FCToolPoly,
 *			FCToolBezier_xZkqqHx_jDjJiCmMiDfEiDhFiDeOiDiJiDfIiCmGiClFiCmEiOgHiCkEiClBiCmGiCmFiBeBiLmIjApMjFjEjFgJiCpA_xHqqkZx_
 *			_xZkqqHx_jGoOiIpDiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER> class FCToolArrowTmpl : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;
typedef BASE_CLASS::BASE_CLASS BASE_BASE_CLASS;

public:
	FCToolArrowTmpl (BOOL bInvert, const FCUGArrowParams* pFront = NULL,
									const FCUGArrowParams* pBack = NULL);
	//----- _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual void	OutStream (FCUndoArchive& ar);
//	virtual void	InStream (FCUndoArchive& ar);
//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual void	OnViewCreate ();
// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OnDraw (CDC* pDC);
// 05.07.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OnDraw (CDC* pDC, const DBLRect* pmmrtRgn = NULL, long lRgnSize = 0);
	virtual void	Select (CDC* pDC);

//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual void	SetFrontLinkGap (mmetol mmGap);
//	virtual mmetol	GetFrontLinkGap () const;
//	virtual void	SetBackLinkGap (mmetol mmGap);
//	virtual mmetol	GetBackLinkGap () const;
//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

protected:
	//----- _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
// 05.04.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	CreatePropertyPage (CPropertyPageVector& vPropPage);

	//----- SUPER_xZkqqHx_iDeOiDiJiDfIiCmMiDfEiDhFiKnGjAjE_xHqqkZx_ -----
	virtual HCURSOR	GetDefaultIdleCursor () const;
// 06.10.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual FCObjDynabase*	CreateNewObject ();
	virtual void	CreateNewObject (ObjDynabaseVector& vNewObj);
	virtual void	InitNewObject (FCObjDynabase* pObj) const;
// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	OnDrawState (CDC* pDC, int iState);
	virtual int		TransFDA (int iState, int iEvent);
	virtual void	StateFDA (int iState, CDC* pDC);

	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeM_xHqqkZx_ -----
	virtual void	InitBeginLink ();
	virtual void	InitEndLink ();
	virtual BOOL	CheckHitMolip ();

	//----- _xZkqqHx_jBeKiInKiPpDjBnEiPiIjHjN_xHqqkZx_ -----
	virtual void	StateSearchBgnMolip (CDC* pDC);
	virtual void	StateSetBgnLink (CDC* pDC);
	virtual void	StateShowBgnCur (CDC* pDC);
	virtual void	StateStopBgnCur (CDC* pDC);
	virtual void	StateStopBgnCur2 (CDC* pDC);
	virtual void	StateContextMenuBgn (CDC* pDC);
	virtual void	StateBgnLinkCommand (CDC* pDC);
	virtual void	StateSearchEndMolip (CDC* pDC);
	virtual void	StateSetEndLink (CDC* pDC);
	virtual void	StateShowEndCur (CDC* pDC);
	virtual void	StateContextMenuEnd (CDC* pDC);
	virtual void	StateEndLinkCommand (CDC* pDC);
	virtual void	StateTerminateJoint (CDC* pDC);
	virtual void	StateAbortJointByButton (CDC* pDC);

	//----- FCToolBaseFDA_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjHhGiCmJiJjOiClGiCmE_xHqqkZx_ -----
	virtual DWORD	CommandToLinkKind (DWORD dwCommand, BOOL bIsCenterMolipFrom);	// PopupLinkMenu_xZkqqHx_iCmMiDiBiDgKiDiFiBfLiCkJiCoHiDiKiDjDiDeOiOoNiCpAiOoGjDlOiBeC_xHqqkZx_

protected:
// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMjCoIiLgAiBeC_xHqqkZx_
enum
{
	STATE_BEGIN = BASE_CLASS::STATE_END,	// _xZkqqHx_iPpDjBnEiKeKiOgOiBeC_xHqqkZx_
	STATE_SEARCH_BGN_MOLIP,	// _xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiMjPiNpFiBeC_xHqqkZx_
	STATE_SET_BGN_LINK,		// _xZkqqHx_iDiKiDjDiDeOjDfPiKeKiOgOjDfPjAnNjCoIiBeC_xHqqkZx_
	STATE_SHOW_BGN_CUR,		// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
	STATE_STOP_BGN_CUR,		// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPeJjHlJiBeC_xHqqkZx_
	STATE_STOP_BGN_CUR_2,	// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	STATE_CONTEXT_MENU_BGN,	// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx___xZkqqHx_iKeKiOgOjDfPiBeC_xHqqkZx_
	STATE_BGN_LINK_COMMAND,	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	STATE_SEARCH_END_MOLIP,	// _xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiMjPiNpFiBeC_xHqqkZx_
	STATE_SET_END_LINK,		// _xZkqqHx_iDiKiDjDiDeOjDfPiPeJjHlJjDfPjAnNjCoIiBeC_xHqqkZx_
	STATE_SHOW_END_CUR,		// _xZkqqHx_iPeJjHlJjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
	STATE_CONTEXT_MENU_END,	// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx___xZkqqHx_iPeJjHlJjDfPiBeC_xHqqkZx_
	STATE_END_LINK_COMMAND,	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	STATE_END,				// _xZkqqHx_iPpDjBnEiPeJjHlJiBeC_xHqqkZx_
};

protected:
//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 05.04.23 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	mmetol		m_mmFrontLinkGap;	// _xZkqqHx_iDiKiDjDiDeOjFjEjFgJiNoMjAkMiOjOiCmMiOkJjDkOiDeNiDiDiDgCiDhGiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
//	mmetol		m_mmBackLinkGap;	// _xZkqqHx_iDiKiDjDiDeOjFjEjFgJiNoMjAkMiOjOiCmMiOkJjDkOiDeNiDiDiDgCiDhGiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
////----- 05.04.23 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	FCUGArrowParams	m_arrowFront;
	FCUGArrowParams	m_arrowBack;

	FTMolipKind	m_iHitOn;		// _xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
	FCObjDynabase*	m_pHitMolipObj;	// _xZkqqHx_iDiKiDjDiDeOjFjEjFgJiBeC_xHqqkZx_
	long		m_lHitMolip;	// _xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiBeC_xHqqkZx_
	DBLPoint	m_mmptHitPos;	// _xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiNmAjFfHiBeC_xHqqkZx_

	//----- _xZkqqHx_iKeKiOgOjDfPiKnGjIeBjFmPjAjE_xHqqkZx_ -----
	FTMolipKind	m_iBgnHitOn;	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
	FCObjDynabase*	m_pBgnHitObj;	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOjFjEjFgJiBeC_xHqqkZx_
	long		m_lBgnHitMolip;	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDiCiDiKiDhGiBeC_xHqqkZx_
	DBLPoint	m_mmptBgnHitPos;// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiNmAjFfHiBeC_xHqqkZx_
	DBLPoint	m_mmptBgnPos;	// _xZkqqHx_iKeKiOgOjDfPiNmAjFfHiBeC_xHqqkZx_
	DWORD		m_dwBgnLinkKind;	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiOoNiBeC_xHqqkZx_

	//----- _xZkqqHx_iPeJjHlJjDfPiKnGjIeBjFmPjAjE_xHqqkZx_ -----
	FTMolipKind	m_iEndHitOn;		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
	FCObjDynabase*	m_pEndHitObj;	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOjFjEjFgJiBeC_xHqqkZx_
	long		m_lEndHitMolip;		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiBeC_xHqqkZx_
	DBLPoint	m_mmptEndHitPos;	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiNmAjFfHiBeC_xHqqkZx_
	DWORD		m_dwEndLinkKind;	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiOoNiBeC_xHqqkZx_
}; // class FCToolArrowTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::FCToolArrowTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bInvert	:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCmMiNoMjHhAiCpAiLhEjDfNiClHiCoJiCkJiCmHiCkEiCkJiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
FCToolArrowTmpl<SUPER>::FCToolArrowTmpl (	BOOL bInvert,
											const FCUGArrowParams* pFront,
											const FCUGArrowParams* pBack)
{
//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 05.04.23 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	m_mmFrontLinkGap = 0.0;			// _xZkqqHx_iDiKiDjDiDeOjFjEjFgJiNoMjAkMiOjOiCmMiOkJjDkOiDeNiDiDiDgCiDhGiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
//	m_mmBackLinkGap = 0.0;			// _xZkqqHx_iDiKiDjDiDeOjFjEjFgJiNoMjAkMiOjOiCmMiOkJjDkOiDeNiDiDiDgCiDhGiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
////----- 05.04.23 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	m_bControlInvert = bInvert;
	if (pFront != NULL)
	{
		m_arrowFront = *pFront;
	} else
	{
		m_arrowFront.byType = FDUG_ARW_TYPE_FLAT;
		m_arrowFront.byParam0 = 0;
		m_arrowFront.byParam1 = 0;
		m_arrowFront.byParam2 = 0;
	}
	if (pBack != NULL)
	{
		m_arrowBack = *pBack;
	} else
	{
		m_arrowBack.byType = FDUG_ARW_TYPE_FLAT;
		m_arrowBack.byParam0 = 0;
		m_arrowBack.byParam1 = 0;
		m_arrowBack.byParam2 = 0;
	}
} // FCToolArrowTmpl<SUPER>::FCToolArrowTmpl.

//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::OutStream
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCToolArrowTmpl<SUPER>::OutStream (FCUndoArchive& ar)
//{
//	BASE_CLASS::OutStream(ar);
//	ar << m_mmFrontLinkGap;	// _xZkqqHx_iDiKiDjDiDeOjFjEjFgJiNoMjAkMiOjOiCmMiOkJjDkOiDeNiDiDiDgCiDhGiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
//	ar << m_mmBackLinkGap;	// _xZkqqHx_iDiKiDjDiDeOjFjEjFgJiNoMjAkMiOjOiCmMiOkJjDkOiDeNiDiDiDgCiDhGiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
//} // FCToolArrowTmpl<SUPER>::OutStream.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::InStream
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCkJiCoHiDgDiBfLiDiLiCmMjBkOjAkLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCToolArrowTmpl<SUPER>::InStream (FCUndoArchive& ar)
//{
//	BASE_CLASS::InStream(ar);
//	ar >> m_mmFrontLinkGap;	// _xZkqqHx_iDiKiDjDiDeOjFjEjFgJiNoMjAkMiOjOiCmMiOkJjDkOiDeNiDiDiDgCiDhGiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
//	ar >> m_mmBackLinkGap;	// _xZkqqHx_iDiKiDjDiDeOjFjEjFgJiNoMjAkMiOjOiCmMiOkJjDkOiDeNiDiDiDgCiDhGiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
//} // FCToolArrowTmpl<SUPER>::InStream.
//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::OnViewCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFCDynamicDrawView::OnCreate_xZkqqHx_iCkJiCoH_xHqqkZx_Call_xZkqqHx_iBeC_xHqqkZx_Tool_xZkqqHx_iCmMiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::OnViewCreate ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnViewCreate();
	FCObjPoly* pPolyTemplate = (FCObjPoly*)BASE_CLASS::GetInsideObject();
//----- 06.10.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jGoOiIpDiBjFiDhLiDgCiDeOiDfIiDgDiBfLiDiLiCmFiCmNjDoAjFjEjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiBeC_xHqqkZx_
	if (pPolyTemplate != NULL)
	//----- _xZkqqHx_jDoAjFjEjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.10.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iKeKiOgOjDfPiCmJjGoOiIpDiCpAjAnNjCoIiBeC_xHqqkZx_
		pPolyTemplate->SetArrowFType(m_arrowFront.byType);
		pPolyTemplate->SetArrowFParam0(m_arrowFront.byParam0);
		pPolyTemplate->SetArrowFParam1(m_arrowFront.byParam1);
		pPolyTemplate->SetArrowFParam2(m_arrowFront.byParam2);
		// _xZkqqHx_iPeJjHlJjDfPiCmJjGoOiIpDiCpAjAnNjCoIiBeC_xHqqkZx_
		pPolyTemplate->SetArrowBType(m_arrowBack.byType);
		pPolyTemplate->SetArrowBParam0(m_arrowBack.byParam0);
		pPolyTemplate->SetArrowBParam1(m_arrowBack.byParam1);
		pPolyTemplate->SetArrowBParam2(m_arrowBack.byParam2);
// 06.10.05 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	}
} // FCToolArrowTmpl<SUPER>::OnViewCreate.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPjBiCkLjClMiClFiCmMiCmGiCkL_xHqqkZx_View_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCToolArrowTmpl<SUPER>::OnDraw (CDC* pDC)
////void FCToolArrowTmpl<SUPER>::OnDraw (CDC* pDC, const DBLRect* pmmrtRgn, long lRgnSize)
//{
//	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiCkKjBlGiNnNiClHiCoJiCmIiCoHiBeBiKeKiOgOjDfPiDiKiDjDiDeOiCmJiDeKiBfLiDfMiDiLjFgAiJoGiBeC_xHqqkZx_
//	if (m_pBgnHitObj != NULL)
//		FCLinkManager::DrawCursor(pDC, mm2lg(m_mmptBgnHitPos), m_iBgnHitOn);
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnDraw(pDC);
//} // FCToolArrowTmpl<SUPER>::OnDraw.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::Select (CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);
	//----- _xZkqqHx_iKgFjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	m_iHitOn		= FDPA_HIT_NOT_MOLIP;// _xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
	m_pHitMolipObj		= NULL;			// _xZkqqHx_iDiKiDjDiDeOjFjEjFgJiBeC_xHqqkZx_
	m_lHitMolip		= -1;			// _xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiBeC_xHqqkZx_
	m_mmptHitPos.SetPoint(0,0);		// _xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiNmAjFfHiBeC_xHqqkZx_

	InitBeginLink();	// _xZkqqHx_iKeKiOgOjDfPiKnGjIeBjFmPjAjEiPiJiKpKiJlLiBeC_xHqqkZx_
	InitEndLink();		// _xZkqqHx_iPeJjHlJjDfPiKnGjIeBjFmPjAjEiPiJiKpKiJlLiBeC_xHqqkZx_
} // FCToolArrowTmpl<SUPER>::Select.

//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::SetFrontLinkGap
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAjElKiCkEiNoMjAkMiOjOiCmJiBeBiOkJjDkOjDeJiCmJjFjEjFgJiCmGiCmMiDeNiDiDiDgCiDhGiCpAiOoGiCoJiPoKiNiHiCmM_xHqqkZx_
// *			_xZkqqHx_iDeNiDiDiDgCiDhGiCmMjClHiClDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmGap	:_xZkqqHx_iDeNiDiDiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCToolArrowTmpl<SUPER>::SetFrontLinkGap (mmetol mmGap)
//{
//	m_mmFrontLinkGap = mmGap;
//} // FCToolArrowTmpl<SUPER>::SetFrontLinkGap.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::GetFrontLinkGap
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAjElKiCkEiNoMjAkMiOjOiCmJiBeBiOkJjDkOjDeJiCmJjFjEjFgJiCmGiCmMiDeNiDiDiDgCiDhGiCpAiOoGiCoJiPoKiNiHiCmM_xHqqkZx_
// *			_xZkqqHx_iDeNiDiDiDgCiDhGiCmMjClHiClDiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmGap	:_xZkqqHx_iDeNiDiDiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//mmetol FCToolArrowTmpl<SUPER>::GetFrontLinkGap () const
//{
//	return m_mmFrontLinkGap;
//} // FCToolArrowTmpl<SUPER>::GetFrontLinkGap.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::SetBackLinkGap
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAjElKiCkEiNoMjAkMiOjOiCmJiBeBiOkJjDkOjDeJiCmJjFjEjFgJiCmGiCmMiDeNiDiDiDgCiDhGiCpAiOoGiCoJiPoKiNiHiCmM_xHqqkZx_
// *			_xZkqqHx_iDeNiDiDiDgCiDhGiCmMjClHiClDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmGap	:_xZkqqHx_iDeNiDiDiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCToolArrowTmpl<SUPER>::SetBackLinkGap (mmetol mmGap)
//{
//	m_mmBackLinkGap = mmGap;
//} // FCToolArrowTmpl<SUPER>::SetBackLinkGap.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::GetBackLinkGap
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAjElKiCkEiNoMjAkMiOjOiCmJiBeBiOkJjDkOjDeJiCmJjFjEjFgJiCmGiCmMiDeNiDiDiDgCiDhGiCpAiOoGiCoJiPoKiNiHiCmM_xHqqkZx_
// *			_xZkqqHx_iDeNiDiDiDgCiDhGiCmMjClHiClDiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmGap	:_xZkqqHx_iDeNiDiDiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//mmetol FCToolArrowTmpl<SUPER>::GetBackLinkGap () const
//{
//	return m_mmBackLinkGap;
//} // FCToolArrowTmpl<SUPER>::GetBackLinkGap.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::CreatePropertyPage
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiNoMjAkMiClFiBeBjDgPjIfOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	:_xZkqqHx_iDhJiBfLiDfHiCpAjDgPjIfOiClHiCoJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCToolArrowTmpl<SUPER>::CreatePropertyPage (CPropertyPageVector& vPropPage)
//{
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::CreatePropertyPage(vPropPage);
//	vPropPage.push_back(new CFCPrtArrowTmpl);
//} // FCToolArrowTmpl<SUPER>::CreatePropertyPage.
//----- 05.04.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::GetDefaultIdleCursor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	StateIdle_xZkqqHx_iCmFiDgGiDhEiDeIiDiLiDgHiCmJiOgHiCoNiCoKiCoJiDeKiBfLiDfMiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jFfHiPiAiCmMiDeKiBfLiDfMiDiLiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
HCURSOR FCToolArrowTmpl<SUPER>::GetDefaultIdleCursor () const
{
	return NULL;
} // FCToolArrowTmpl<SUPER>::GetDefaultIdleCursor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::CreateNewObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiCmMjFjEjFgJiCmMiNoMjAkMiBeFiPiJiKpKiJlLiBeFjDgPjIfOiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ToolPolyArrow_xZkqqHx_iCpA_xHqqkZx_ToolPoly_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmJiClHiCoJiClNiCnPiCmJiBeBiClBiCmMiKnGjAjEiCpAiNoMiCmBiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
// 06.10.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//FCObjDynabase* FCToolArrowTmpl<SUPER>::CreateNewObject ()
void FCToolArrowTmpl<SUPER>::CreateNewObject (ObjDynabaseVector& vNewObj)
{
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmMiDfCiDhDiBfLiCpAiNoMjAkMiBeC_xHqqkZx_
//	const FCObjDynabase* pTmpl = GetReferenceObject();
//// 06.10.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////	if (pTmpl == NULL) return NULL;
//	if (pTmpl == NULL) return;
//	FCObjPoly* pPoly = (FCObjPoly*)pTmpl->Duplicate();
//	// _xZkqqHx_jFjEjFgJiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
//	InitNewObject(pPoly);
//	// _xZkqqHx_iDfEiDeDiDfJiCmMiNmEiMhGiOfKiBeC_xHqqkZx_
//	pPoly->CalcResizeFrame();
//	// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	pPoly->RegisterObjID();
//	// _xZkqqHx_jFjEjFgJjAlGjAkMiCmMiLeMjIfOiBeC_xHqqkZx_
//	g_pDoc->MulticmdCreate1Obj(pPoly, g_pDoc->GetCurrentSheetId(), LAST_LAYER_ORDER);
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCjGoOiIpDiDhMiDiKiDiJiDeDiDjDiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	BASE_CLASS::CreateNewObject(vNewObj);
	FCObjPoly* pPoly = (FCObjPoly*)vNewObj.back();
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDiKiDjDiDeOjAnNjCoI_xHqqkZx_ -----
	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIjFjEjFgJiBeC_xHqqkZx_
	ObjDynabaseSet stRedrawObj;

	// _xZkqqHx_iKeKiOgOjDfPiCmMiDiKiDjDiDeOjAnNjCoIiBeC_xHqqkZx_
	if (m_pBgnHitObj != NULL)
	{
		FCMolipRec linkFrom(m_pBgnHitObj->GetObjID(), m_lBgnHitMolip);
		FCMolipRec linkTo(pPoly->GetObjID(), 0);
		WORD wLinkKindA = m_dwBgnLinkKind & 0xffff;
		WORD wLinkKindB = m_dwBgnLinkKind >> 16;
		if (wLinkKindA != 0)
		{
			g_pDoc->CmdAppend1Link(stRedrawObj, linkFrom, linkTo, wLinkKindA);
		}
		if (wLinkKindB != 0)
		{
			g_pDoc->CmdAppend1Link(stRedrawObj, linkTo, linkFrom, wLinkKindB);
		}
	}
	// _xZkqqHx_iPeJjHlJjDfPiCmMiDiKiDjDiDeOjAnNjCoIiBeC_xHqqkZx_
	if (m_pEndHitObj != NULL)
	{
		FCMolipRec linkFrom(m_pEndHitObj->GetObjID(), m_lEndHitMolip);
		FCMolipRec linkTo(pPoly->GetObjID(),
						FCObjPoly::JointIDtoMolipID(pPoly->GetJointSize() - 1));
		WORD wLinkKindA = m_dwEndLinkKind & 0xffff;
		WORD wLinkKindB = m_dwEndLinkKind >> 16;
		if (wLinkKindA != 0)
		{
			g_pDoc->CmdAppend1Link(stRedrawObj, linkFrom, linkTo, wLinkKindA);
		}
		if (wLinkKindB != 0)
		{
			g_pDoc->CmdAppend1Link(stRedrawObj, linkTo, linkFrom, wLinkKindB);
		}
	}
	// _xZkqqHx_iNmEjFgAiJoGjHmMiIoGiCpAjDgPjIfOiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(stRedrawObj);

//----- 06.11.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
//	SetLastCreateObj(pPoly);
//----- 06.11.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// 06.10.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return pPoly;
	vNewObj.push_back(pPoly);
} // FCToolArrowTmpl<SUPER>::CreateNewObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::InitNewObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClFiClNjFjEjFgJiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iPiJiKpKiJlLiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::InitNewObject (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_jBkOjAkLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	BASE_CLASS::InitNewObject(pObj);
	// _xZkqqHx_jFjEjFgJiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	FCObjPoly* pPoly = (FCObjPoly*)pObj;
	const long lJointSz = pPoly->GetJointSize();

	//----- _xZkqqHx_jBlNiKhAjApMjFjEjFgJiCmMiBeBjFmPiMgAjBkOjAkLiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiInKjDkOiCmJjElKiCkEjBlMiCmMjIeBiMiLjDfPiInKjDkOiCmNjGlDiCkCiBeC_xHqqkZx_
	pPoly->SetLinkMoveType(FDOP_LMTYPE_NONE);
	// _xZkqqHx_iKeKiOgOjDfPiCmMjHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
	pPoly->SetBgnLinkMoveStyle(FDOP_LMSTYL_NONE);
	// _xZkqqHx_iPeJjHlJjDfPiCmMjHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
	pPoly->SetEndLinkMoveStyle(FDOP_LMSTYL_NONE);

	if (2 < lJointSz && m_pBgnHitObj != NULL)
	{
		//----- _xZkqqHx_iKeKiOgOjDfPiCmMiDiKiDjDiDeOjFmPiMgAiMgAiOkOjAnNjCoI_xHqqkZx_ -----
		if (2 < lJointSz)
		{
			pPoly->SetLinkMoveType(FDOP_LMTYPE_SAMEHV);
			mmetol mmDiffX = fabs(pPoly->GetJoint(1).m_mmptPivot.x -
											pPoly->GetJoint(0).m_mmptPivot.x);
			mmetol mmDiffY = fabs(pPoly->GetJoint(1).m_mmptPivot.y -
											pPoly->GetJoint(0).m_mmptPivot.y);
			if (mmDiffX < mmDiffY)
			{
				// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
				pPoly->SetBgnLinkMoveStyle(FDOP_LMSTYL_MOVE_HORZ);
			} else
			{
				// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
				pPoly->SetBgnLinkMoveStyle(FDOP_LMSTYL_MOVE_VERT);
			}
		}
	}
	if (2 < lJointSz && m_pEndHitObj != NULL)
	{
		//----- _xZkqqHx_iPeJjHlJjDfPiCmMiDiKiDjDiDeOjFmPiMgAiMgAiOkOjAnNjCoI_xHqqkZx_ -----
		pPoly->SetLinkMoveType(FDOP_LMTYPE_SAMEHV);
		mmetol mmDiffX = fabs(pPoly->GetJoint(lJointSz - 2).m_mmptPivot.x -
							pPoly->GetJoint(lJointSz - 1).m_mmptPivot.x);
		mmetol mmDiffY = fabs(pPoly->GetJoint(lJointSz - 2).m_mmptPivot.y -
							pPoly->GetJoint(lJointSz - 1).m_mmptPivot.y);
		if (mmDiffX < mmDiffY)
		//----- _xZkqqHx_iPeJjHlJjDfPiCmMjApMiCkKiBeBiCmHiClPiCoHiCkJiCmGiCkCiCkEiCmGiPgDjFpLiMpMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
			pPoly->SetEndLinkMoveStyle(FDOP_LMSTYL_MOVE_HORZ);
			//----- _xZkqqHx_iPeJjHlJjDfPiCmMjBePiCmMjDfPiCmMiNmAjFfHjFoCjAlDiPiIjHjN_xHqqkZx_ -----
			if (2 < m_pjvJoint.size() && !almost0(mmDiffY))
			{
				// X_xZkqqHx_iCmMiDfJiDiMiCkK_xHqqkZx_Y_xZkqqHx_iCmM_xHqqkZx_30%_xZkqqHx_iImIiJlKiCmIiCoHiCmOiBeBiPeJjHlJjDfPiCmMjBePjDfPiCmM_xHqqkZx_X_xZkqqHx_iCpAiPeJjHlJjDfPiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
				if (!almost0(mmDiffY) && mmDiffX / mmDiffY < 0.3)
					pPoly->GetJoint(lJointSz - 2).m_mmptPivot.x =
							pPoly->GetJoint(lJointSz - 1).m_mmptPivot.x;
			}
		} else
		//----- _xZkqqHx_iPeJjHlJjDfPiCmMjApMiCkKiBeBiCmHiClPiCoHiCkJiCmGiCkCiCkEiCmGiJkBjFpLiMpMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
			pPoly->SetEndLinkMoveStyle(FDOP_LMSTYL_MOVE_VERT);
			//----- _xZkqqHx_iPeJjHlJjDfPiCmMjBePiCmMjDfPiCmMiNmAjFfHjFoCjAlDiPiIjHjN_xHqqkZx_ -----
			if (2 < m_pjvJoint.size() && !almost0(mmDiffX))
			{
				// Y_xZkqqHx_iCmMiDfJiDiMiCkK_xHqqkZx_X_xZkqqHx_iCmM_xHqqkZx_30%_xZkqqHx_iImIiJlKiCmIiCoHiCmOiBeBiPeJjHlJjDfPiCmMjBePjDfPiCmM_xHqqkZx_Y_xZkqqHx_iCpAiPeJjHlJjDfPiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
				if (!almost0(mmDiffX) && mmDiffY / mmDiffX < 0.3)
					pPoly->GetJoint(lJointSz - 2).m_mmptPivot.y =
							pPoly->GetJoint(lJointSz - 1).m_mmptPivot.y;
			}
		}
	}

	if (m_iBgnHitOn == FDPA_HIT_POL_MOLIP && m_dwBgnLinkKind == FDLM_LINK_ON_ANGLE)
	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
	{
		if (abouteq(m_mmptBgnHitPos, pPoly->GetJoint(0).m_mmptPivot))
		//----- _xZkqqHx_iKeKiOgOjDfPiCmJiDgIiDiJiDgCiDePiCkKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			FCBezierControls bc;
			bc.A() = pPoly->GetJoint(0).m_mmptPivot;
			bc.B() = pPoly->GetJoint(0).m_mmptPivot + pPoly->GetJoint(0).m_mmptNext;
			bc.C() = pPoly->GetJoint(1).m_mmptPivot + pPoly->GetJoint(1).m_mmptPrev;
			bc.D() = pPoly->GetJoint(1).m_mmptPivot;
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (m_pBgnHitObj->CalcMolipCrossedControlPoint(bc, g_pReg->GetFrontArrowAutoGap(), m_lBgnHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			const mmetol mmArrowAutoGap = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetFrontArrowAutoGap() : 0.0;
			if (m_pBgnHitObj->CalcMolipCrossedControlPoint(bc, mmArrowAutoGap, m_lBgnHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			{
				// _xZkqqHx_iDhDiDhLiDgCiDgHiBeBjBePiIpIjDfPiBeBiMoDiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
				pPoly->GetJoint(0).m_mmptPivot = bc.A();
				pPoly->GetJoint(0).m_mmptNext = bc.B() - bc.A();
				pPoly->GetJoint(1).m_mmptPrev = bc.C() - bc.D();
			}
		}
	}

	if (m_iEndHitOn == FDPA_HIT_POL_MOLIP && m_dwEndLinkKind == FDLM_LINK_ON_ANGLE)
	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
	{
		if (abouteq(m_mmptEndHitPos, pPoly->GetJoint(lJointSz - 1).m_mmptPivot))
		//----- _xZkqqHx_iKeKiOgOjDfPiCmJiDgIiDiJiDgCiDePiCkKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			FCBezierControls bc;
			bc.A() = pPoly->GetJoint(lJointSz - 1).m_mmptPivot;
			bc.B() = pPoly->GetJoint(lJointSz - 1).m_mmptPivot + pPoly->GetJoint(lJointSz - 1).m_mmptPrev;
			bc.C() = pPoly->GetJoint(lJointSz - 2).m_mmptPivot + pPoly->GetJoint(lJointSz - 2).m_mmptNext;
			bc.D() = pPoly->GetJoint(lJointSz - 2).m_mmptPivot;
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (m_pEndHitObj->CalcMolipCrossedControlPoint(bc, g_pReg->GetBackArrowAutoGap(), m_lEndHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			const mmetol mmArrowAutoGap = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetBackArrowAutoGap() : 0.0;
			if (m_pEndHitObj->CalcMolipCrossedControlPoint(bc, mmArrowAutoGap, m_lEndHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			{
				// _xZkqqHx_iDhDiDhLiDgCiDgHiBeBjBePiIpIjDfPiBeBiMoDiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
				pPoly->GetJoint(lJointSz - 1).m_mmptPivot = bc.A();
				pPoly->GetJoint(lJointSz - 1).m_mmptPrev = bc.B() - bc.A();
				pPoly->GetJoint(lJointSz - 2).m_mmptNext = bc.C() - bc.D();
			}
		}
	}
} // FCToolArrowTmpl<SUPER>::InitNewObject.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPjBiCkLjClMiClFiCmMiCmGiCkL_xHqqkZx_View_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::OnDrawState (CDC* pDC, int iState)
{
	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiCkKjBlGiNnNiClHiCoJiCmIiCoHiBeBiKeKiOgOjDfPiDiKiDjDiDeOiCmJiDeKiBfLiDfMiDiLjFgAiJoGiBeC_xHqqkZx_
	if (m_pBgnHitObj != NULL)
		FCLinkManager::DrawCursor(pDC, mm2lg(m_mmptBgnHitPos), m_iBgnHitOn);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
} // FCToolArrowTmpl<SUPER>::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolPolyArrow.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
int FCToolArrowTmpl<SUPER>::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_IDLE:			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
//----- 02.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
		if (FFCanCreateObject())
		//----- _xZkqqHx_jFjEjFgJiNoMjAkMiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
		{
//----- 02.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
			switch (iEvent)
			{
			case WM_MOUSEMOVE:		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
				iNextState = STATE_SEARCH_BGN_MOLIP;	// _xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiMjPiNpFiBeC_xHqqkZx_
				break;
			case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			case WM_RBUTTONDOWN:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
				if (IsControl() && CheckHitMolip())
					iNextState = STATE_SET_BGN_LINK;	// _xZkqqHx_iDiKiDjDiDeOjDfPiKeKiOgOjDfPjAnNjCoIiBeC_xHqqkZx_
				break;
			}
// 02.06.05 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)
		}
		break;
	case STATE_SEARCH_BGN_MOLIP:	// _xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiMjPiNpFiBeC_xHqqkZx_
		iNextState = STATE_IDLE;	// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	case STATE_SET_BGN_LINK:		// _xZkqqHx_iDiKiDjDiDeOjDfPiKeKiOgOjDfPjAnNjCoIiBeC_xHqqkZx_
		iNextState = STATE_SHOW_BGN_CUR;	// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
		break;
	case STATE_SHOW_BGN_CUR:		// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_SHOW_BGN_CUR;	// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_BGN_CUR;	// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPeJjHlJiBeC_xHqqkZx_
			break;
		case WM_RBUTTONUP:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_BGN_CUR_2;	// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_BGN_CUR:	// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_START_JOINT;		// _xZkqqHx_jIeBiMiLjDfPjAnNjCoIiKeKiOgOiBeC_xHqqkZx_
		break;
	case STATE_STOP_BGN_CUR_2:	// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_CONTEXTMENU:	// _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiDiBiDgKiDiFiBfLiBeC_xHqqkZx_
			iNextState = STATE_CONTEXT_MENU_BGN;	// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx___xZkqqHx_iKeKiOgOjDfPiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_CONTEXT_MENU_BGN:		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx___xZkqqHx_iKeKiOgOjDfPiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_COMMAND:	// _xZkqqHx_iDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			iNextState = STATE_BGN_LINK_COMMAND;	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_BGN_LINK_COMMAND:	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		iNextState = STATE_START_JOINT;		// _xZkqqHx_jIeBiMiLjDfPjAnNjCoIiKeKiOgOiBeC_xHqqkZx_
		break;
	case STATE_DRAW_JOINT:	// _xZkqqHx_jIeBiMiLjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			iNextState = STATE_SEARCH_END_MOLIP;	// _xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiMjPiNpFiBeC_xHqqkZx_
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// _xZkqqHx_iClBiClBiCmF_xHqqkZx_ m_pjvJoint.back().m_mmptPivot != m_mmptCnv _xZkqqHx_iCpAiDgAiDeGiDgCiDeO_xHqqkZx_
			// _xZkqqHx_iClFiCmEiCmNiCmIiCoHiCmIiCkCiBeCiDgAiDeGiDgCiDeOiClHiCoJiCmGiBeBiDfIiDgJiDgCiDhGiCkKiMpIiCkCiCmEiCkCiCoJiPoKiNiHiCmJiCmNiBeB_xHqqkZx_
			// _xZkqqHx_iDfIiDgJiDgCiDhGiCkJiCoHjHkDiCoKiCmIiCkCiCmGiDiCiDiKiDhGiMjPiNpFiCpAiClFiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
			// _xZkqqHx_iCmCiCnMiCoIiBeBiIoKjDhIiDfIiDgJiDgCiDhGiCmJjFnPiCoHiCkGiCoHiCoKiCoJiCmGiBeBiClLiCmMiOpMiImNiCmMiDiCiDiKiDhGiCkKiMjPiNpF_xHqqkZx_
			// _xZkqqHx_iCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
			iNextState = STATE_SEARCH_END_MOLIP;	// _xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiMjPiNpFiBeC_xHqqkZx_
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			break;
		case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
		case WM_RBUTTONDOWN:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (IsControl() && CheckHitMolip())
				iNextState = STATE_SET_END_LINK;	// _xZkqqHx_iDiKiDjDiDeOjDfPiPeJjHlJjDfPjAnNjCoIiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_SEARCH_END_MOLIP:	// _xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiMjPiNpFiBeC_xHqqkZx_
// 05.04.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		iNextState = STATE_DRAW_JOINT;	// _xZkqqHx_jIeBiMiLjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
		iNextState = STATE_ERASE_JOINT;	// _xZkqqHx_jIeBiMiLjDfPiDeKiBfLiDfMiDiLiPmBiLiOiBeC_xHqqkZx_
		break;
	case STATE_SET_END_LINK:	// _xZkqqHx_iDiKiDjDiDeOjDfPiPeJjHlJjDfPjAnNjCoIiBeC_xHqqkZx_
		iNextState = STATE_SHOW_END_CUR;	// _xZkqqHx_iPeJjHlJjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
		break;
	case STATE_SHOW_END_CUR:	// _xZkqqHx_iPeJjHlJjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_SHOW_END_CUR;	// _xZkqqHx_iPeJjHlJjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_CREATE_OBJECT;	// _xZkqqHx_jFjEjFgJiNoMjAkMiBeC_xHqqkZx_
			break;
		case WM_CONTEXTMENU:	// _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiDiBiDgKiDiFiBfLiBeC_xHqqkZx_
			iNextState = STATE_CONTEXT_MENU_END;	// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx___xZkqqHx_iPeJjHlJjDfPiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_CONTEXT_MENU_END:	// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx___xZkqqHx_iPeJjHlJjDfPiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_COMMAND:	// _xZkqqHx_iDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			iNextState = STATE_END_LINK_COMMAND;	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_END_LINK_COMMAND:	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		iNextState = STATE_CREATE_OBJECT;	// _xZkqqHx_jFjEjFgJiNoMjAkMiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolArrowTmpl<SUPER>::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_SEARCH_BGN_MOLIP:	// _xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiMjPiNpFiBeC_xHqqkZx_
		StateSearchBgnMolip(pDC);
		break;
	case STATE_SET_BGN_LINK:		// _xZkqqHx_iDiKiDjDiDeOjDfPiKeKiOgOjDfPjAnNjCoIiBeC_xHqqkZx_
		StateSetBgnLink(pDC);
		break;
	case STATE_SHOW_BGN_CUR:		// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
		StateShowBgnCur(pDC);
		break;
	case STATE_STOP_BGN_CUR:		// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPeJjHlJiBeC_xHqqkZx_
		StateStopBgnCur(pDC);
		break;
	case STATE_STOP_BGN_CUR_2:		// _xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPeJjHlJ_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		StateStopBgnCur2(pDC);
		break;
	case STATE_CONTEXT_MENU_BGN:		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx___xZkqqHx_iKeKiOgOjDfPiBeC_xHqqkZx_
		StateContextMenuBgn(pDC);
		break;
	case STATE_BGN_LINK_COMMAND:	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		StateBgnLinkCommand(pDC);
		break;
	case STATE_SEARCH_END_MOLIP:	// _xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiMjPiNpFiBeC_xHqqkZx_
		StateSearchEndMolip(pDC);
		break;
	case STATE_SET_END_LINK:		// _xZkqqHx_iDiKiDjDiDeOjDfPiPeJjHlJjDfPjAnNjCoIiBeC_xHqqkZx_
		StateSetEndLink(pDC);
		break;
	case STATE_SHOW_END_CUR:		// _xZkqqHx_iPeJjHlJjDfPiDeKiBfLiDfMiDiLjFfMiOkGiBeC_xHqqkZx_
		StateShowEndCur(pDC);
		break;
	case STATE_CONTEXT_MENU_END:	// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx___xZkqqHx_iPeJjHlJjDfPiBeC_xHqqkZx_
		StateContextMenuEnd(pDC);
		break;
	case STATE_END_LINK_COMMAND:	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		StateEndLinkCommand(pDC);
		break;
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolArrowTmpl<SUPER>::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::InitBeginLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiKnGjIeBiCmMjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::InitBeginLink ()
{
	m_iBgnHitOn = FDPA_HIT_NOT_MOLIP;// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
	m_pBgnHitObj = NULL;			// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOjFjEjFgJiBeC_xHqqkZx_
	m_lBgnHitMolip = -1;			// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDiCiDiKiDhGiBeC_xHqqkZx_
	m_mmptBgnHitPos.SetPoint(0,0);	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiNmAjFfHiBeC_xHqqkZx_
	m_mmptBgnPos.SetPoint(0,0);		// _xZkqqHx_iKeKiOgOjDfPiNmAjFfHiBeC_xHqqkZx_
	m_dwBgnLinkKind	= DWORD(0);		// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiOoNiBeC_xHqqkZx_
} // FCToolArrowTmpl<SUPER>::InitBeginLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::InitEndLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiKnGjIeBiCmMjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::InitEndLink ()
{
	m_iEndHitOn		= FDPA_HIT_NOT_MOLIP;// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
	m_pEndHitObj	= NULL;			// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOjFjEjFgJiBeC_xHqqkZx_
	m_lEndHitMolip	= -1;			// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiBeC_xHqqkZx_
	m_mmptEndHitPos.SetPoint(0,0);	// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiNmAjFfHiBeC_xHqqkZx_
	m_dwEndLinkKind	= DWORD(0);		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiOoNiBeC_xHqqkZx_
} // FCToolArrowTmpl<SUPER>::InitEndLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::CheckHitMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhGiMjPiNpFiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhGiCkKiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolArrowTmpl<SUPER>::CheckHitMolip ()
{
	// _xZkqqHx_iDiCiDiKiDhGiPoDiCmFiCmMiDhNiDeFiDfIiCmMiDhBiDgCiDgHiPpDjBnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	m_iHitOn = FCLinkManager::GetHitOnMolipLine(m_pHitMolipObj, m_lHitMolip,
												m_mmptHitPos, m_mmptMsc,
												m_dwFlags, m_mmptCnv,
												m_mmlnvAry.begin(), m_mmlnvAry.size());
	// FDPA_HIT_NOT_MOLIP _xZkqqHx_iCmFjGlDiCkPiCoKiCmOiDhBiDgCiDgHiBeC_xHqqkZx_
	return (m_iHitOn != FDPA_HIT_NOT_MOLIP);
} // FCToolArrowTmpl<SUPER>::CheckHitMolip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateSearchBgnMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiMjPiNpFiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateSearchBgnMolip (CDC* pDC)
{
	TRACE(_T("StateSearchBgnMolip\r\n"));
	//----- _xZkqqHx_iCnMiClIiKgFjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	m_iHitOn = FDPA_HIT_NOT_MOLIP;
	m_pHitMolipObj = NULL;
	if (IsControl())
	//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiCiDiKiDhGiMjPiNpFiBeCiDiCiDiKiDhGiPoDiDhBiDgCiDgHiCmMiPoKiNiHiCmNiBeBiDhNiDeFiDfIiNmAjFfHiCpAiDiCiDiKiDhGiNmAjFfHiCmJjFoCjAlDiBeC_xHqqkZx_
		if (CheckHitMolip()) m_mmptCnv = m_mmptHitPos;
	}
	// _xZkqqHx_jAfGiClFiCkCiDeKiBfLiDfMiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	m_iCursorNew = m_iHitOn;
} // FCToolArrowTmpl<SUPER>::StateSearchBgnMolip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateSetBgnLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjDfPiKeKiOgOjDfPjAnNjCoIiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateSetBgnLink (CDC* pDC)
{
	TRACE(_T("StateSetBgnLink\r\n"));
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);

//----- 05.04.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiPpDjBnEiCmFiCmMiDhNiDeFiDfIiCmMiCoEiCoHiCkMiDhDiDeOiDfKiDiLjAjEiCpAjBoFiCkLiCnPiCmJiCmGiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jCiGjAfDjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiBeBiPkNiClFiCmFiCoAiDhNiDeFiDfIiCkKiCnEiCoKiCoJiCmGjApMiDiCiDiKiDhGiCnGiCmM_xHqqkZx_
	// _xZkqqHx_iOkJjDkOiInKjDkOiCkKiDeJiDhEiCmJiCmIiCoJiClNiCnPiBeC_xHqqkZx_
	m_lShakeBtnDownPixel = 5;
//----- 05.04.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----


	//----- _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiPoOjFpBiCpAjAnNjCoI_xHqqkZx_ -----
	m_iBgnHitOn = m_iHitOn;				// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
	m_pBgnHitObj = m_pHitMolipObj;		// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOjFjEjFgJiBeC_xHqqkZx_
	m_lBgnHitMolip = m_lHitMolip;		// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDiCiDiKiDhGiBeC_xHqqkZx_
	m_mmptBgnHitPos = m_mmptHitPos;		// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiNmAjFfHiBeC_xHqqkZx_
	//----- _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiOoN_xHqqkZx_ -----
	switch (m_iBgnHitOn)
	{
	case FDPA_HIT_POINT_MOLIP:	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dwBgnLinkKind = FDLM_LINK_ON_COORD;
		break;
	case FDPA_HIT_LINE_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dwBgnLinkKind = FDLM_LINK_ON_RATIO;
		break;
	case FDPA_HIT_POL_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dwBgnLinkKind = FDLM_LINK_ON_ANGLE;
	}

	// _xZkqqHx_iDhNiDeFiDfIiImKjChFiCpAiDiKiDjDiDeOiDiCiDiKiDhGiNmAjFfHiCmJjAnNjCoIiBeCiClBiCmMiMoDiCmMiDeKiBfLiDfMiDiLiPoKiNiHiCmJjEpFiCkGiCoJiBeC_xHqqkZx_
	m_mmptCnv = m_mmptHitPos;
	//----- _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMjAkHiMmAjApMiCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	m_mmptFix = m_mmptCnv;
	m_mmlnvAry.clear();
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(0, 1)));
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, 0)));
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, 1)));
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, -1)));
	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiCmJiDeKiBfLiDfMiDiLjFgAiJoGiBeC_xHqqkZx_
	FCLinkManager::DrawCursor(pDC, mm2lg(m_mmptBgnHitPos), m_iBgnHitOn);
	// _xZkqqHx_jAfGiClFiCkCiDeKiBfLiDfMiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	m_iCursorNew = FDPA_HIT_NOT_MOLIP;
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
	g_pView->SetAutoScroll(TRUE);
} // FCToolArrowTmpl<SUPER>::StateSetBgnLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateShowBgnCur
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateShowBgnCur (CDC* pDC)
{
	TRACE(_T("StateShowBgnCur\r\n"));
	// _xZkqqHx_iKeKiOgOjDfPiNmAjFfHiCmJiDhNiDeFiDfIiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmptBgnPos = m_mmptCnv;
	// SHOW_GUIDE_CUR_xZkqqHx_iPpDjBnEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::StateIdle(pDC);
} // FCToolArrowTmpl<SUPER>::StateShowBgnCur.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateStopBgnCur
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateStopBgnCur (CDC* pDC)
{
	TRACE(_T("StateStopBgnCur\r\n"));
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);
	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmJiKeKiOgOjDfPiNmAjFfHiCpAjAnNjCoIiBeCiOjPiCmMjIeBiMiLjDfPjAnNjCoIiPpDjBnEiCmJjEpFiCkGiCmEiBeC_xHqqkZx_
	m_mmptCnv = m_mmptBgnPos;
	::FFReleaseCapture();	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
} // FCToolArrowTmpl<SUPER>::StateStopBgnCur.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateStopBgnCur2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPeJjHlJiPiIjHjN_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateStopBgnCur2 (CDC* pDC)
{
	TRACE(_T("StateStopBgnCur2\r\n"));
	StateStopBgnCur(pDC);
} // FCToolArrowTmpl<SUPER>::StateStopBgnCur2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateContextMenuBgn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx___xZkqqHx_iKeKiOgOjDfPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateContextMenuBgn (CDC* pDC)
{
	TRACE(_T("FCToolArrowTmpl<SUPER>::StateContextMenuBgn\r\n"));
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeCiDiBiDgKiDiFiBfLiPeJjHlJiOjOiCmJiDhMiDgCiDhGiDeBiDgCiDhGiPeJjHlJiDfCiDhNiDjDiDgIiCpAjBjHjAeNiBeC_xHqqkZx_
	PopupLinkMenu();
} // FCToolArrowTmpl<SUPER>::StateContextMenuBgn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateBgnLinkCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateBgnLinkCommand (CDC* pDC)
{
	TRACE(_T("FCToolArrowTmpl<SUPER>::StateBgnLinkCommand\r\n"));
	m_dwBgnLinkKind = CommandToLinkKind(m_dwCommand, m_lBgnHitMolip == -1);
//----- 02.06.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_jBlNiKhAjApMjFjEjFgJiCmMjDhCjCiGiCmMjIeBiMiLjDfPiCmJiBeBjBlNiKhAjApMiCpAjBgPjFpLiMpMiDiKiDjDiDeOiCmFiNoMjAkMiClFiCoGiCkEiCmGiClFiClNiCmGiCkLiBeBjIeBiMiLjDfPiImKjChFiCkKiDfIiDgJiDgCiDhGiImKjChFiCmFiCmIiCkCiCmGiBeBiClIiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_)-----
	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiNmAjFfHiCpAjFmPiKlHiNmAjFfHiCmJjAnNjCoIiBeC_xHqqkZx_START_JOINT _xZkqqHx_iCmJiCkIiCkCiCmEiBeB_xHqqkZx_
	// m_mmptCnv _xZkqqHx_iCkKiDiKiDjDiDeOiCmMiKeKiOgOjDfPiCmJiOgHiCoNiCoKiCoJiClNiCnPiBeC_xHqqkZx_
	m_mmptCnv = m_mmptBgnHitPos;
//----- 02.06.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_jBlNiKhAjApMjFjEjFgJiCmMjDhCjCiGiCmMjIeBiMiLjDfPiCmJiBeBjBlNiKhAjApMiCpAjBgPjFpLiMpMiDiKiDjDiDeOiCmFiNoMjAkMiClFiCoGiCkEiCmGiClFiClNiCmGiCkLiBeBjIeBiMiLjDfPiImKjChFiCkKiDfIiDgJiDgCiDhGiImKjChFiCmFiCmIiCkCiCmGiBeBiClIiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_)-----
} // FCToolArrowTmpl<SUPER>::StateBgnLinkCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateSearchEndMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiMjPiNpFiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateSearchEndMolip (CDC* pDC)
{
	TRACE(_T("StateSearchEndMolip\r\n"));
	// _xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiMjPiNpFiPiIjHjNiCmGjDkPiClGiBeC_xHqqkZx_
	StateSearchBgnMolip(pDC);
} // FCToolArrowTmpl<SUPER>::StateSearchEndMolip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateSetEndLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjDfPiPeJjHlJjDfPjAnNjCoIiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateSetEndLink (CDC* pDC)
{
	TRACE(_T("StateSetEndLink\r\n"));
	//----- _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiPoOjFpBiCpAjAnNjCoI_xHqqkZx_ -----
	m_iEndHitOn = m_iHitOn;				// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiOoNjHnOiBeC_xHqqkZx_
	m_pEndHitObj = m_pHitMolipObj;		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOjFjEjFgJiBeC_xHqqkZx_
	m_lEndHitMolip = m_lHitMolip;		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDiCiDiKiDhGiBeC_xHqqkZx_
	m_mmptEndHitPos = m_mmptHitPos;		// _xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiNmAjFfHiBeC_xHqqkZx_
	//----- _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiOoN_xHqqkZx_ -----
	switch (m_iEndHitOn)
	{
	case FDPA_HIT_POINT_MOLIP:	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dwEndLinkKind = FDLM_LINK_ON_COORD;
		break;
	case FDPA_HIT_LINE_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dwEndLinkKind = FDLM_LINK_ON_RATIO;
		break;
	case FDPA_HIT_POL_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dwEndLinkKind = FDLM_LINK_ON_ANGLE;
	}
	// _xZkqqHx_iDhNiDeFiDfIiImKjChFiCpAiDiKiDjDiDeOiDiCiDiKiDhGiNmAjFfHiCmJjAnNjCoIiBeCiClBiCmMiMoDiCmMiDeKiBfLiDfMiDiLiPoKiNiHiCmJjEpFiCkGiCoJiBeC_xHqqkZx_
	m_mmptCnv = m_mmptHitPos;
	//----- _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMjAkHiMmAjApMiCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	m_mmptFix = m_mmptCnv;
	m_mmlnvAry.clear();
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(0, 1)));
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, 0)));
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, 1)));
	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(1, -1)));
	// _xZkqqHx_jAfGiClFiCkCiDeKiBfLiDfMiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	m_iCursorNew = FDPA_HIT_NOT_MOLIP;
} // FCToolArrowTmpl<SUPER>::StateSetEndLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateShowEndCur
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiDeKiBfLiDfMiDiLjFfMiOkGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateShowEndCur (CDC* pDC)
{
	TRACE(_T("StateShowEndCur\r\n"));
	// STATE_ERASE_JOINT,STATE_DRAW_JOINT_xZkqqHx_iPpDjBnEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::StateEraseJoint(pDC);
	BASE_CLASS::StateDrawJoint(pDC);
} // FCToolArrowTmpl<SUPER>::StateShowEndCur.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateContextMenuEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkG_xHqqkZx___xZkqqHx_iPeJjHlJjDfPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateContextMenuEnd (CDC* pDC)
{
	TRACE(_T("FCToolArrowTmpl<SUPER>::StateContextMenuEnd\r\n"));
	StateContextMenuBgn(pDC);
} // FCToolArrowTmpl<SUPER>::StateContextMenuEnd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateEndLinkCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateEndLinkCommand (CDC* pDC)
{
	TRACE(_T("FCToolArrowTmpl<SUPER>::StateEndLinkCommand\r\n"));
	m_dwEndLinkKind = CommandToLinkKind(m_dwCommand, m_lEndHitMolip == -1);
} // FCToolArrowTmpl<SUPER>::StateEndLinkCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateTerminateJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjAnNjCoIiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateTerminateJoint (CDC* pDC)
{
	InitBeginLink();	// _xZkqqHx_iKeKiOgOjDfPiKnGjIeBjFmPjAjEiPiJiKpKiJlLiBeC_xHqqkZx_
	InitEndLink();		// _xZkqqHx_iPeJjHlJjDfPiKnGjIeBjFmPjAjEiPiJiKpKiJlLiBeC_xHqqkZx_
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::StateTerminateJoint(pDC);
} // FCToolArrowTmpl<SUPER>::StateTerminateJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::StateAbortJointByButton
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjAnNjCoIjCiGiOhOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolArrowTmpl<SUPER>::StateAbortJointByButton (CDC* pDC)
{
	TRACE(_T("FCToolArrowTmpl<SUPER>::StateAbortJointByButton\r\n"));
	// _xZkqqHx_iKeKiOgOjDfPiDiKiDjDiDeOiCkKjBlGiNnNiClHiCoJiCmIiCoHiBeBiKeKiOgOjDfPiDiKiDjDiDeOiCmJiDeKiBfLiDfMiDiLjFgAiJoGiBeC_xHqqkZx_
	if (m_pBgnHitObj != NULL)
		FCLinkManager::DrawCursor(pDC, mm2lg(m_mmptBgnHitPos), m_iBgnHitOn);
	InitBeginLink();	// _xZkqqHx_iKeKiOgOjDfPiKnGjIeBjFmPjAjEiPiJiKpKiJlLiBeC_xHqqkZx_
	BASE_CLASS::StateAbortJointByButton(pDC);
} // FCToolArrowTmpl<SUPER>::StateAbortJointByButton.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::CommandToLinkKind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PopupLinkMenu_xZkqqHx_iCmMiDiBiDgKiDiFiBfLiCkJiCoHiDiKiDjDiDeOiOoNiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCommand			:_xZkqqHx_jCkDiCoJiDiKiDjDiDeOiCmMiOoNjHnOiCpAiOkGiClHiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsCenterMolipFrom	:_xZkqqHx_iDiKiDjDiDeOiMlDiCmMiDiCiDiKiDhGiCkKjCiGjAfDiDiCiDiKiDhGiCkJiBeIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiOoNiBeCiDiKiDjDiDeOiCpAiNoMjAkMiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ WORD(0)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiMlDiBeBiDiKiDjDiDeOjAoGiDiCiDiKiDhGiCkKjCiGjAfDiDiCiDiKiDhGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiClHiCoJ_xHqqkZx_
 *			CommandToLinkKind_xZkqqHx_iKnGjAjEiCmJjBmOiClFiCmEiBeBiDiKiDjDiDeOiMlDiDiCiDiKiDhGiCmMiCnNiOhHjCoIiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCmNiBeBiDgDiBfLiDiLiCmMiOoNjHnOiCmJiCoGiCmBiCmEjFmPiCoNiCoJiClNiCnPiBeBiDgDiBfLiDiL_xHqqkZx_
 *			_xZkqqHx_iCmJiClBiCmMiKnGjAjEiCmMiDgGiDhEiDeIiDiLiDgHiPiIjHjNiCpAiNhDiCoNiClJiCoJiClBiCmGiCmFiBeBiDgDiBfLiDiLiClCiCmGiCmM_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiOhHjCoIiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOoNjHnOiCkKjFmPiCoNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
DWORD FCToolArrowTmpl<SUPER>::CommandToLinkKind (DWORD dwCommand, BOOL bIsCenterMolipFrom)
{
	return CommandToLinkKindBoth(dwCommand, bIsCenterMolipFrom, FALSE);
} // FCToolArrowTmpl<SUPER>::CommandToLinkKind.

#endif//__ToolArrowTmpl_h
