#include "stdafx.h"
#include "DynamicDraw.h"		// For FFGetApp.
#include "RegData.h"			// For g_pReg.
#include "DynamicDrawView.h"	// For g_pView.
#include "LayerManager.h"		// For FFAddToLZSorted.
#include "UtilCoord.h"			// For mm2lg.etc.
#include "UtilMisc.h"				// For HitTest.
#include "UtilGraph.h"			// For FCEditDraw.
#include "UtilObj.h"			// For FFAddToLZSorted.
#include "UtilBezier.h"			// For FCBezierControls.
#include "FoundDoc.h"			// For g_pDoc.
#include "LinkManager.h"		// For FTMolipSet.
#include "ObjLine.h"			// For FCObjLine.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "ToolLineEdit.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////////
// FCLnPRec_xZkqqHx_iDeOiDiJiDfIiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLnPRec::FCLnPRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLnPRec::FCLnPRec ()
{
	m_pObj = NULL;
	m_bIsSelected[0] = FALSE;
	m_bIsSelected[1] = FALSE;
} // FCLnPRec::FCLnPRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLnPRec::FCLnPRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLnPRec::FCLnPRec (FCObjLine* ojlp, BOOL bIsFrom, BOOL bIsTo)
{
	m_pObj = ojlp;
	m_bIsSelected[0] = bIsFrom;
	m_bIsSelected[1] = bIsTo;
	// _xZkqqHx_iOgOjCfLiBeBiPeJjCfLiCmMiNmAjFfHiCpAiOoGjDlO_xHqqkZx_.
	m_pObj->GetPoints(m_mmptEnds[0], m_mmptEnds[1]);
} // FCLnPRec::FCLnPRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLnPRec::GetObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_AppendToSortedObj_xZkqqHx_iCmFjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjLine* FCLnPRec::GetObject () const
{
	return m_pObj;
} // FCLnPRec::GetObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLnPRec::UpdateEnds
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjApMjCfLiNmAjFfHiCpAiNmEjDhIiOoGjDlOiClHiCoJiBeCjFjEjFgJiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCmMjCgMiCpAiOoGjDlOiClHiCoJiInHiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.08.09 Fukushiro M. _xZkqqHx_jCgMiCpAjFnEiClHiCoGiCkEiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCLnPRec::UpdateEnds ()
{
	// _xZkqqHx_iOgOjCfLiBeBiPeJjCfLiCmMiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
	DBLPoint mmptEnds[2];
	m_pObj->GetPoints(mmptEnds[0], mmptEnds[1]);
	// _xZkqqHx_jCgMiCkKjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (almosteq(m_mmptEnds[0], mmptEnds[0]) &&
		almosteq(m_mmptEnds[1], mmptEnds[1])) return FALSE;
	m_mmptEnds[0] = mmptEnds[0];
	m_mmptEnds[1] = mmptEnds[1];
	return TRUE;
} // FCLnPRec::UpdateEnds.

//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLnPRec::DrawSelectMark
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjApMiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCLnPRec::DrawSelectMark (CDC* pDC) const
//{
//	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//	FCEditDraw eDraw(pDC, 0);
//	if (m_mmptEnds[0] == m_mmptEnds[1])
//	//----- _xZkqqHx_jApMjHlMjCfLiCkKjDkPiClGiNmAjFfHiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		if (m_bIsSelected[0] || m_bIsSelected[1])
//			eDraw.SelMark(mm2lg(m_mmptEnds[0]));
//		else
//			eDraw.UnselMark(mm2lg(m_mmptEnds[0]));
//	} else
//	//----- _xZkqqHx_jApMjHlMjCfLiCkKiInJiCmIiCoJiNmAjFfHiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		if (m_bIsSelected[0])
//			eDraw.SelMark(mm2lg(m_mmptEnds[0]));
//		else
//			eDraw.UnselMark(mm2lg(m_mmptEnds[0]));
//		if (m_bIsSelected[1])
//			eDraw.SelMark(mm2lg(m_mmptEnds[1]));
//		else
//			eDraw.UnselMark(mm2lg(m_mmptEnds[1]));
//	}
//} // FCLnPRec::DrawSelectMark.
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//////////////////////////////////////////////////////////////////////////
// FCToolLineEdit_xZkqqHx_iDeOiDiJiDfIiKnGjAjEiBeC_xHqqkZx_

//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::OnDraw (CDC* pDC)
////void FCToolLineEdit::OnDraw (CDC* pDC, const DBLRect* pmmrtRgn, long lRgnSize)
//{
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (GetCurrentState())
//	{
//	case STATE_MOVING_JOINT:		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
//	  {
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjApMjFjEjFgJiCpAiCfAiCmCiClIiCmCiDiLiBfLiDhGiClHiCoJiBeC_xHqqkZx_
//		FCLnPRecVector::const_iterator iRec;
//		for (iRec = m_lnpvSelect.begin(); iRec != m_lnpvSelect.end(); iRec++)
//		{
//			// _xZkqqHx_iClBiCmMjFjEjFgJiCmMjHlMjCfLiCmGiCoAjGkCjBeJjBpAiCmIiCoHiCmOiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//			if (!iRec->m_bIsSelected[0] && !iRec->m_bIsSelected[1]) continue;
//			// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//			FCEditDraw eDraw(pDC, mm2lg(iRec->GetObject()->GetStdPenWeight()));
//			// _xZkqqHx_jAfGiClFiCkCiPeDjAlDjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//			eDraw.Line(&mm2lg(iRec->m_mmptEnds[0]), &mm2lg(iRec->m_mmptEnds[1]));
//			// _xZkqqHx_jCfLjDfPiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//			iRec->DrawSelectMark(pDC);
//		}
//		break;
//	  }
//	default:
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDraw(pDC);
//	}
//} // FCToolLineEdit::OnDraw.
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::OnSelectObjModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCmFjBeJjBpAjCiGiCmMjFjEjFgJiCkKiBeBiDgDiBfLiDiLiImIiKePiCmMiPoKiPiKiCmFiPeDjAlDiClDiCoKiClNiPoKiNiHiCmJ_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeCjFnCiPfHjHhAiDhNiBfLiDeOiCmMiNmEjFgAiJoGiCmMjFeLjHhGiCmNjGlDiCkCiBgJjFmKjDhCiMmEiCmOiCoKiCoJiInHiBgKiBeC_xHqqkZx_
 *			_xZkqqHx_iDgDiBfLiDiLjCiGiCmJjFjEjFgJiCmMjBkOjAkLiCpAiOmKiClFiOjNiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeBjFjEjFgJiCmJiNiHiCoNiClJiCmE_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiCmFjFjEjFgJiCmMjBkOjAkLiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::OnSelectObjModified ()
{
	// _xZkqqHx_jFjEjFgJiCmMjFmPiNfIiCpA_xHqqkZx_m_lnpvSelect_xZkqqHx_iCmJjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
	FCLnPRecVector::iterator iLr;
	for (iLr = m_lnpvSelect.begin(); iLr != m_lnpvSelect.end(); iLr++)
	{
		(*iLr).UpdateEnds();
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSelectObjModified();
} // FCToolLineEdit::OnSelectObjModified.

//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::Select
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::Select (CDC* pDC)
//{
//	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::Select(pDC);
//	SetHitXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT));
//	m_mmptMov1st.SetPoint(0,0);	// _xZkqqHx_iInKjDkOjDfPiBeC_xHqqkZx_
//	// m_lnpvSelect_xZkqqHx_iCmNiClBiClBiCmFiDeOiDiKiDeBiClHiCoJiCmGiDhNiDfJiDeDiBeC_xHqqkZx_FCToolBase::Select_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_
//	// AppendSelectObj_xZkqqHx_iKnGjAjEiCkKiOmAiNhDiClDiCoKiCmEiCkCiCoJiClNiCnPiBeC_xHqqkZx_
//} // FCToolLineEdit::Select.
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::DrawSelectMark
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjFfMiOkGiOjOiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBgJjEpBjFfMiOkGiBgKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
// *			pObj:_xZkqqHx_jFfMiOkGiClHiCoJjFjEjFgJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::DrawSelectMark (CDC* pDC, FCObjDynabase* pObj)
//{
//	// _xZkqqHx_jApMjFjEjFgJiCmFiCmIiCkCiPoKiNiHiCmNjFgAiJoGiClJiClIjFjMiLeBiBeC_xHqqkZx_
//	if (!pObj->IsKindOf(FDOJ_LINE)) return;
//	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//	FCEditDraw eDraw(pDC, 0);
//	FCLnPRecVector::reverse_iterator iRec;
//	for (iRec = m_lnpvSelect.rbegin(); iRec != m_lnpvSelect.rend(); iRec++)
//	{
//		if (iRec->GetObject() == pObj)
//		{
//			iRec->DrawSelectMark(pDC);
//			break;
//		}
//	}
//} // FCToolLineEdit::DrawSelectMark.
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::OnAppendSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::AppendSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::OnAppendSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jBmOiPnLjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!CanHandle(pObj)) return;
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJiPfNiCmBiCmEjBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
	if (FFAddToLZSorted(m_lnpvSelect, FCLnPRec((FCObjLine*)pObj, FALSE, FALSE)) == DWORD(-1)) return;
//----- 05.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFfMiOkGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (pDC == NULL) return;
//	// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
//	DrawSelectMark(pDC, pObj);
//----- 05.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnAppendSelectObj(pDC, pObj);
//----- 05.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolLineEdit::OnAppendSelectObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::OnRemoveSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCkJiCoHjFjEjFgJiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjEpBjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::RemoveSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::OnRemoveSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jBmOiPnLjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!CanHandle(pObj)) return;
//----- 05.09.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnRemoveSelectObj(pDC, pObj);
//----- 05.09.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	long lLine;
	for (lLine = 0; lLine != m_lnpvSelect.size(); lLine++)
	{
		// _xZkqqHx_jDmGiOkJiKmHjHjNiDgFiBfLiDhFiDiLiCmMjFjEjFgJiCmGiIoKjChGiClFiClNiPoKiNiHiBeC_xHqqkZx_
		if (m_lnpvSelect[lLine].m_pObj == pObj)
		{
			if (lLine == GetLastSelectedXXX(XXX_JOINT).first)
			//----- _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjApMiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				//----- _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCmMiPoOjFpBiCpAiPiJiKpKiJlL_xHqqkZx_ -----
				// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiJpAiPjMiBeC_xHqqkZx_
				SetLastSelectedXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT));
			}
			// _xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
			m_lnpvSelect.erase(&m_lnpvSelect[lLine]);
			break;
		}
	}
} // FCToolLineEdit::OnRemoveSelectObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::CanHandle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiClBiCmMiDgDiBfLiDiLiCmFiIlFiCkGiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolLineEdit::CanHandle (const FCObjDynabase* pObj) const
{
	if (!pObj->IsKindOf(FDOJ_LINE)) return FALSE;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CanHandle(pObj);
} // FCToolLineEdit::CanHandle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::GetLineCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHjBmOiPnLiCmMjApMjFjEjFgJiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFnCiPfHjBmOiPnLiCmMjApMjFjEjFgJiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolLineEdit::GetLineCount () const
{
	return m_lnpvSelect.size();
} // FCToolLineEdit::GetLineCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::IsOpenLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFjEjFgJiCkKiKeKiCkCiCmEiCkCiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_jApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jApMjFjEjFgJiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolLineEdit::IsOpenLine (long lLineIndex) const
{
	return TRUE;
} // FCToolLineEdit::IsOpenLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::GetJointCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFjEjFgJiCmMjIeBiMiLjDfPjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_jApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jApMjFjEjFgJiCmMjIeBiMiLjDfPjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolLineEdit::GetJointCount (long lLineIndex) const
{
	return 2;
} // FCToolLineEdit::GetJointCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::GetBezierControls
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFjEjFgJiCmMiBeBiOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiKnEiCmMiDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bc			:_xZkqqHx_iDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *			lLineIndex	:_xZkqqHx_jApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lJointIndex	:_xZkqqHx_jIeBiMiLjDfPiCmMiKeKiOgOiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsForward	:_xZkqqHx_jIeBiMiLjDfPiPeJjHlJiDeDiDjDiDgGiDgCiDeOiDfIiCkKiBeBiKeKiOgOiDeDiDjDiDgGiDgCiDeOiDfIiCmJ_xHqqkZx_
 *						 _xZkqqHx_jBmOiClFiCmEiMoDjFpLiCkJjBePjFpLiCkJiCpAiOhHjCoIiBeCiMoDjFpLiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lJointIndex = 2, bIsForward = TRUE _xZkqqHx_iCmMiPoKiNiHiCmNiBeBjIeBiMiLjDfP_xHqqkZx_[2,3]_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jAkHiMoEjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *			lJointIndex = 2, bIsForward = FALSE _xZkqqHx_iCmMiPoKiNiHiCmNiBeBjIeBiMiLjDfP_xHqqkZx_[2,1]_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jAkHiMoEjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::GetBezierControls (FCBezierControls& bc,
										long lLineIndex,
										long lJointIndex,
										BOOL bIsForward) const
{
	if (bIsForward)
	{
		ASSERT(lJointIndex == 0);
		bc.A() = m_lnpvSelect[lLineIndex].m_mmptEnds[0];
		bc.B() = m_lnpvSelect[lLineIndex].m_mmptEnds[0];
		bc.C() = m_lnpvSelect[lLineIndex].m_mmptEnds[1];
		bc.D() = m_lnpvSelect[lLineIndex].m_mmptEnds[1];
	} else
	{
		ASSERT(lJointIndex == 1);
		bc.A() = m_lnpvSelect[lLineIndex].m_mmptEnds[1];
		bc.B() = m_lnpvSelect[lLineIndex].m_mmptEnds[1];
		bc.C() = m_lnpvSelect[lLineIndex].m_mmptEnds[0];
		bc.D() = m_lnpvSelect[lLineIndex].m_mmptEnds[0];
	}
} // FCToolLineEdit::GetBezierControls.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::GetLineObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFjEjFgJiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_jApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjFigure* FCToolLineEdit::GetLineObject (long lLineIndex) const
{
	return m_lnpvSelect[lLineIndex].GetObject();
} // FCToolLineEdit::GetLineObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::SetJointPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCmMiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	index	:_xZkqqHx_jApMiBeFjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLjDoAjFjEiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJjFmPjAjEiCmMiNmAjFfHjCgMiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::SetJointPoint (longPair index, DBLPoint mmpt)
{
	m_lnpvSelect[index.first].m_mmptEnds[index.second] = mmpt;
} // FCToolLineEdit::SetJointPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::DrawJointSelectMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiBeFiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	index	:_xZkqqHx_jApMiBeFjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::DrawJointSelectMark (CDC* pDC, longPair index) const
{
	FCEditDraw(pDC, 0).SelMark(mm2lg(GetFrameRectXXX(XXX_JOINT, index).GetLeftTop()));
} // FCToolLineEdit::DrawJointSelectMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::JointIDtoMolipID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfP_xHqqkZx_ID_xZkqqHx_iCkJiCoHiBeBiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lJointId	:_xZkqqHx_jIeBiMiLjDfP_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolLineEdit::JointIDtoMolipID (long lJointId) const
{
	return lJointId * 2;
} // FCToolLineEdit::JointIDtoMolipID.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::DrawSelectedBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCmMiJgFiLlPjEmNiImNiCmMiDhIiDfHiDeHiLmIjApMiCmMiCnNiCpA_xHqqkZx_XOR_xZkqqHx_jFgAiJoGiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: _xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfI_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnMouseMove_xZkqqHx_jCiGiCmMjFgAiJoGiDiLiBfLiDgAiDjDiCpAiCnMiCmGiCnPiClNiCoAiCmM_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::DrawSelectedBezier (CDC* pDC) const
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<longPair> vSelectedJoint;
	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
	// _xZkqqHx_jFmPiNfIiClDiCoKiCoJjApMjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	longSet stLineIndex;
	vector<longPair>::const_iterator iIdx;
	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
		stLineIndex.insert(iIdx->first);
	longSet::const_iterator iLdx;
	for (iLdx = stLineIndex.begin(); iLdx != stLineIndex.end(); iLdx++)
	{
		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
		FCEditDraw eDraw(pDC, mm2lg(GetLineObject(*iLdx)->GetStdPenWeight()));
		// _xZkqqHx_iPeDjAlDjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
		eDraw.Line(	&mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(*iLdx, 0)).GetLeftTop()),
					&mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(*iLdx, 1)).GetLeftTop()));
	}
} // FCToolLineEdit::DrawSelectedBezier.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::GetHitLine
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClFiClNjApMjFkKjFmPjAjEiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jApMjFkKjFmPjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCLnPRec& FCToolLineEdit::GetHitLine ()
//{
//	return m_lnpvSelect[GetHitXXX(XXX_JOINT).first];
//} // FCToolLineEdit::GetHitLine.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::GetHitEnds
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClFiClNjApMjCfLjFmPjAjEiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jApMjCfLjFmPjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//DBLPoint& FCToolLineEdit::GetHitEnds ()
//{
//	return m_lnpvSelect[GetHitXXX(XXX_JOINT).first].m_mmptEnds[GetHitXXX(XXX_JOINT).second];
//} // FCToolLineEdit::GetHitEnds.
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::StateIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBnCiClPiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::StateIdle (CDC* pDC)
{
	TRACE(_T("StateIdle\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmFiCmMiDhBiDgCiDgHiPpDjBnEiCpAjClCiCnHiCoJiBeCiDhBiDgCiDgHiClFiCmEiCkCiCoKiCmOiDeKiBfLiDfMiDiLjAnNjCoIiBeC_xHqqkZx_
	if (CheckHitXXX(XXX_JOINT))
		SetIdleCursor(FFGetApp()->LoadStandardCursor(IDC_SIZEALL));
	// _xZkqqHx_iDhBiDgCiDgHiDeKiBfLiDfMiDiLiCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
	m_iCursorNew = FDPA_HIT_NONE;
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGjDjJiBeC_xHqqkZx_
	BASE_CLASS::StateIdle(pDC);
} // FCToolLineEdit::StateIdle.

//----- 05.09.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::StateStartMoveJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjCfLiInKjDkOiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::StateStartMoveJoint (CDC* pDC)
//{
//	TRACE(_T("StateStartMoveJoint\r\n"));
//	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
//	::FFSetCapture(g_pView->m_hWnd);
//
//	//////////////////////// _xZkqqHx_iInKjDkOjApMjAnNjCoIiPiIjHjN_xHqqkZx_ ///////////////////////////
//	// _xZkqqHx_iInKjDkOjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_mmptMov1st = GetHitEnds();
//	// _xZkqqHx_iMmFjCoIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_mmptFix = GetHitLine().m_mmptEnds[(GetHitXXX(XXX_JOINT).second == 0) ? 1 : 0];
//	//----- _xZkqqHx_iInKjDkOjApMiCpAjAnNjCoI_xHqqkZx_ -----
//	m_mmlnvAry.clear();
//	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptMov1st));
//	DBLPoint mmptDif = m_mmptMov1st - m_mmptFix;
//	m_mmlnvAry.push_back(DBLLine(m_mmptFix,
//								 m_mmptFix + DBLPoint(mmptDif.y, -mmptDif.x)));
//	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGiBeCjApMjCfLiImKjChFjFfMiOkGiBeC_xHqqkZx_
//	FFGetMainWnd()->MoveRulerMMK(1, m_mmptMov1st);
//
//
//	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
//	g_pView->SetAutoScroll(TRUE);
//
//	FCLnPRecVector::iterator iRec;
//	for (iRec = m_lnpvSelect.begin(); iRec != m_lnpvSelect.end(); iRec++)
//	{
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjApMjCfLiCkKjGlDiCkCiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (!iRec->m_bIsSelected[0] && !iRec->m_bIsSelected[1]) continue;
//		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//		FCEditDraw eDraw(pDC, mm2lg(iRec->GetObject()->GetStdPenWeight()));
//		// _xZkqqHx_iPeDjAlDjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//		eDraw.Line(&mm2lg(iRec->m_mmptEnds[0]),  &mm2lg(iRec->m_mmptEnds[1]));
//		// _xZkqqHx_jCfLjDfPiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//		iRec->DrawSelectMark(pDC);
//	}
//} // FCToolLineEdit::StateStartMoveJoint.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::StateMovingJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjCfLiInKjDkOjCiGiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::StateMovingJoint (CDC* pDC)
//{
//	TRACE(_T("StateMovingJoint\r\n"));
//	// _xZkqqHx_iDhBiDgCiDgHiDeKiBfLiDfMiDiLiCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
//	m_iCursorNew = FDPA_HIT_NONE;
//	if (IsControl())
//	//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiDhNiDeFiDfIjBiAiNoMiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMjPiNpFiCpAiDhAiDfIiClHiCoJiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
//		FTMolipSet stIgnore;
//		stIgnore.insert(FCMolipRec(GetHitLine().GetObject()->GetObjID(), -1));
//		// _xZkqqHx_iDiCiDiKiDhGiMjPiNpFiBeCiDiKiDjDiDeOjAoGiCkKiOkJjFkKiOkJjAgHiCmIiCoHiCmOiMjPiNpFjGlDiOiLiBeC_xHqqkZx_
//		DBLPoint mmptHitPos;
//		m_iCursorNew = FCLinkManager::GetHitOnMolipLine(m_pHitMolipObj, m_lHitMolip,
//												mmptHitPos, m_mmptMsc,
//												m_dwFlags, m_mmptCnv,
//												m_mmlnvAry.begin(), m_mmlnvAry.size(),
//												&stIgnore);
//		// _xZkqqHx_iDiCiDiKiDhGiPoDiDhBiDgCiDgHiCmMiPoKiNiHiCmNiBeBiDhNiDeFiDfIiNmAjFfHiCpAiDiCiDiKiDhGiNmAjFfHiCmJjFoCjAlDiBeC_xHqqkZx_
//		if (m_iCursorNew != FDPA_HIT_NOT_MOLIP) m_mmptCnv = mmptHitPos;
//		switch (m_iCursorNew)
//		{
//		case FDPA_HIT_POINT_MOLIP:	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
//			m_dwJointLinkKind = FDLM_LINK_ON_COORD;
//			break;
//		case FDPA_HIT_LINE_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
//			m_dwJointLinkKind = FDLM_LINK_ON_RATIO;
//			break;
//		case FDPA_HIT_POL_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
//			m_dwJointLinkKind = FDLM_LINK_ON_ANGLE;
//		}
//	}
//	// _xZkqqHx_jDfPiCmMiInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
//	const DBLPoint mmptDif = m_mmptCnv - GetHitEnds();
//	if (!mmptDif.IsNull())
//	//----- _xZkqqHx_iInKjDkOjHmKiCkKiCePiCmFiCmIiCkCiCmIiCoHiCmOjApMiCmMjFgAiJoGiPiIjHjN_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjApMjFjEjFgJiCpAiCfAiCmCiClIiCmCiDiLiBfLiDhGiClHiCoJiBeC_xHqqkZx_
//		FCLnPRecVector::iterator iRec;
//		for (iRec = m_lnpvSelect.begin(); iRec != m_lnpvSelect.end(); iRec++)
//		{
//			// _xZkqqHx_iClBiCmMjFjEjFgJiCmMjHlMjCfLiCmGiCoAjGkCjBeJjBpAiCmIiCoHiCmOiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//			if (!iRec->m_bIsSelected[0] && !iRec->m_bIsSelected[1]) continue;
//			// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//			FCEditDraw eDraw(pDC, mm2lg(iRec->GetObject()->GetStdPenWeight()));
//			// _xZkqqHx_jBePiJpBiCmMiPeDjAlDjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
//			eDraw.Line(&mm2lg(iRec->m_mmptEnds[0]), &mm2lg(iRec->m_mmptEnds[1]));
//			// _xZkqqHx_jCfLjDfPiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
//			iRec->DrawSelectMark(pDC);
//			// _xZkqqHx_jBeJjBpAiClDiCoKiClNjCfLiCpAiDhNiDeFiDfIiInKjDkOjFkKiInKjDkOiClHiCoJiBeC_xHqqkZx_
//			if (iRec->m_bIsSelected[0]) iRec->m_mmptEnds[0] += mmptDif;
//			if (iRec->m_bIsSelected[1]) iRec->m_mmptEnds[1] += mmptDif;
//			// _xZkqqHx_jAfGiClFiCkCiPeDjAlDjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//			eDraw.Line(&mm2lg(iRec->m_mmptEnds[0]), &mm2lg(iRec->m_mmptEnds[1]));
//			// _xZkqqHx_jCfLjDfPiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//			iRec->DrawSelectMark(pDC);
//		}
//	}
//	// BASE_CLASS::StateIdle_xZkqqHx_iCmFiCmMiBeBiDeKiBfLiDfMiDiLiImKjChFjFfMiOkGiCmJjEpFiCkGiCmEiBeB_xHqqkZx_m_mmptMsc = m_mmptCnv_xZkqqHx_iCmJiBeC_xHqqkZx_
//	const DBLPoint mmptMscBak = m_mmptMsc;
//	m_mmptMsc = m_mmptCnv;
//	// _xZkqqHx_iDeKiBfLiDfMiDiLjFfMiOkGiBeCiInKjDkOjHmKiCkKiCePiCmFiCoAiBeBiDiKiDjDiDeOiMgAiOkOjFmPiNfIiCmMjFfMiOkGiCmMjFeLjHhGiCkKiCkAiCoJiClNiCnPjFeLjHhGiBeC_xHqqkZx_
//	BASE_CLASS::StateIdle(pDC);
//	// m_mmptMsc = m_mmptCnv _xZkqqHx_iCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
//	m_mmptMsc = mmptMscBak;
//} // FCToolLineEdit::StateMovingJoint.
//----- 05.09.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 05.09.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::StateContextMenuJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiDiBiDgKiDiFiBfL_xHqqkZx___xZkqqHx_jIeBiMiLjDfPiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::StateContextMenuJoint (CDC* pDC)
//{
//	TRACE(_T("FCToolLineEdit::StateContextMenuJoint\r\n"));
//	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeCiDiBiDgKiDiFiBfLiPeJjHlJiOjOiCmJiDhMiDgCiDhGiDeBiDgCiDhGiPeJjHlJiDfCiDhNiDjDiDgIiCpAjBjHjAeNiBeC_xHqqkZx_
//	PopupLinkMenu();
//} // FCToolLineEdit::StateContextMenuJoint.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::StateJointLinkCommand
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::StateJointLinkCommand (CDC* pDC)
//{
//	TRACE(_T("FCToolLineEdit::StateJointLinkCommand\r\n"));
//	// _xZkqqHx_iDiKiDjDiDeOiOoNiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_dwJointLinkKind = CommandToLinkKind(m_dwCommand, m_lHitMolip == -1);
//} // FCToolLineEdit::StateJointLinkCommand.
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.09.05 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::StateReLink
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjFhEjBnGiCkGiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::StateReLink (CDC* pDC)
//{
//	TRACE(_T("FCToolLineEdit::StateReLink\r\n"));
//	if (m_pHitMolipObj == NULL ||
//		m_iCursorNew == FDPA_HIT_NONE ||
//		m_iCursorNew == FDPA_HIT_NOT_MOLIP) return;
//	FCMolipRec linkFrom(m_pHitMolipObj->GetObjID(), m_lHitMolip);
//	FTMolipSet stLinkTo;
//	stLinkTo.insert(FCMolipRec(GetHitLine().GetObject()->GetObjID(), GetHitXXX(XXX_JOINT).second * 2));
//	WORD wLinkKindA = m_dwJointLinkKind & 0xffff;
//	WORD wLinkKindB = m_dwJointLinkKind >> 16;
//	FCLinkManager::ReLink(linkFrom, stLinkTo, wLinkKindA);
//	FCLinkManager::ReLink(stLinkTo, linkFrom, wLinkKindB);
//	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjIeBiMiLjDfPiCpAiDgAiDeGiDgCiDeO_xHqqkZx_ -----
//	long lSelSize = 0;
//	FCLnPRecVector::const_iterator iRec;
//	for (iRec = m_lnpvSelect.begin(); iRec != m_lnpvSelect.end(); iRec++)
//	{
//		if (iRec->m_bIsSelected[0]) lSelSize++;
//		if (iRec->m_bIsSelected[1]) lSelSize++;
//	}
//	if (lSelSize != 1) return;
//	if (wLinkKindA == FDLM_LINK_ON_ANGLE)
//	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
//	{
//		FCBezierControls bc;
//		mmetol mmArrowAutoGap;
//		if (GetHitXXX(XXX_JOINT).second == 0)
//		{
//			bc.A() = GetHitLine().m_mmptEnds[0];
//			bc.B() = GetHitLine().m_mmptEnds[0];
//			bc.C() = GetHitLine().m_mmptEnds[1];
//			bc.D() = GetHitLine().m_mmptEnds[1];
//			mmArrowAutoGap = g_pReg->GetFrontArrowAutoGap();
//		} else
//		{
//			bc.A() = GetHitLine().m_mmptEnds[1];
//			bc.B() = GetHitLine().m_mmptEnds[1];
//			bc.C() = GetHitLine().m_mmptEnds[0];
//			bc.D() = GetHitLine().m_mmptEnds[0];
//			mmArrowAutoGap = g_pReg->GetBackArrowAutoGap();
//		}
//		if (m_pHitMolipObj->CalcMolipCrossedControlPoint(bc, mmArrowAutoGap, m_lHitMolip))
//		{
//			// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//			FCEditDraw eDraw(pDC, mm2lg(GetHitLine().GetObject()->GetStdPenWeight()));
//			// _xZkqqHx_jBePiJpBiCmMiPeDjAlDjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
//			eDraw.Line(&mm2lg(GetHitLine().m_mmptEnds[0]), &mm2lg(GetHitLine().m_mmptEnds[1]));
//			// _xZkqqHx_jCfLjDfPiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
//			GetHitLine().DrawSelectMark(pDC);
//			// _xZkqqHx_jBeJjBpAiClDiCoKiClNjCfLiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
//			GetHitEnds() = bc.A();
//			// _xZkqqHx_jAfGiClFiCkCiPeDjAlDjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//			eDraw.Line(&mm2lg(GetHitLine().m_mmptEnds[0]), &mm2lg(GetHitLine().m_mmptEnds[1]));
//			// _xZkqqHx_jCfLjDfPiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//			GetHitLine().DrawSelectMark(pDC);
//		}
//	}
//} // FCToolLineEdit::StateReLink.
//----- 05.09.05 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.09.05 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::StateStopMoveJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjCfLiInKjDkOiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::StateStopMoveJoint (CDC* pDC)
//{
//	TRACE(_T("StateStopMoveJoint\r\n"));
//	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
//	g_pView->SetAutoScroll(FALSE);
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//	// _xZkqqHx_jBeJjBpAjDfPiCmMiInKjDkOiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
//	const DBLPoint mmptDif = GetHitEnds() - m_mmptMov1st;
//	// _xZkqqHx_iInKjDkOjBePiMoDiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiClHiCoJiPiAjEpFiCmGiClFiCmEiLpDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AddEmptyRgn();
//	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
//	FTMolipSet setMolip;
//	FCLnPRecVector::iterator iRec;
//	for (iRec = m_lnpvSelect.begin(); iRec != m_lnpvSelect.end(); iRec++)
//	{
//		// _xZkqqHx_iClBiCmMjFjEjFgJiCmMjHlMjCfLiCmGiCoAjGkCjBeJjBpAiCmIiCoHiCmOiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (!iRec->m_bIsSelected[0] && !iRec->m_bIsSelected[1]) continue;
//		// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOjFjNjFkKiNeMiClAiClNiInKjDkOjBePiCmMiKePjAnKiDhEiDiMiBfLiDiAiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
//		g_pView->AppendToLastRgn(iRec->GetObject()->GetOuterFrame().ExtendRect(lg2mm(FCEditDraw::GetSelMarkSizeHalf() + 1)));
//		// _xZkqqHx_iClBiCmMjFjEjFgJiCmMjHlMjCfLiCmGiCoAjBeJjBpAiCmIiCoHiCmOjFjEjFgJiInKjDkOiBeC_xHqqkZx_
//		if (iRec->m_bIsSelected[0] && iRec->m_bIsSelected[1])
//		{
//			// _xZkqqHx_iCfAjFjEjFgJiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//			g_pDoc->CmdMove1Obj(iRec->GetObject(), mmptDif);
//			// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiCmJjCmHiJmBiBeC_xHqqkZx_
//			setMolip.insert(FCMolipRec(iRec->GetObject()->GetObjID(), -1));
//		} else
//		// _xZkqqHx_iClBiCmMjFjEjFgJiCmMiKeKiOgOjDfPjBeJjBpAiCmIiCoHiCmOiKeKiOgOjDfPiInKjDkOiBeC_xHqqkZx_
//		if (iRec->m_bIsSelected[0])
//		{
//			//----- _xZkqqHx_iCfAiDiJiDeDiDjDjFjEjFgJiKeKiOgOjDfPiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhD_xHqqkZx_ -----
//			FCLineRec lineRec;
//			lineRec.wMask = FDFP_FROMENDX | FDFP_FROMENDY;
//			lineRec.mmFromEndX = iRec->GetObject()->GetFromEndX() + mmptDif.x;
//			lineRec.mmFromEndY = iRec->GetObject()->GetFromEndY() + mmptDif.y;
//			g_pDoc->CmdModifyLine(iRec->GetObject(), lineRec);
//			// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiCmJjCmHiJmBiBeC_xHqqkZx_
//			setMolip.insert(FCMolipRec(iRec->GetObject()->GetObjID(), 0));
//		} else
//		// _xZkqqHx_iClBiCmMjFjEjFgJiCmMiPeJjHlJjDfPjBeJjBpAiCmIiCoHiCmOiPeJjHlJjDfPiInKjDkOiBeC_xHqqkZx_
//		{
//			//----- _xZkqqHx_iCfAiDiJiDeDiDjDjFjEjFgJiPeJjHlJjDfPiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhD_xHqqkZx_ -----
//			FCLineRec lineRec;
//			lineRec.wMask = FDFP_TOENDX | FDFP_TOENDY;
//			lineRec.mmToEndX = iRec->GetObject()->GetToEndX() + mmptDif.x;
//			lineRec.mmToEndY = iRec->GetObject()->GetToEndY() + mmptDif.y;
//			g_pDoc->CmdModifyLine(iRec->GetObject(), lineRec);
//			// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiCmJjCmHiJmBiBeC_xHqqkZx_
//			setMolip.insert(FCMolipRec(iRec->GetObject()->GetObjID(), 2));
//		}
//		// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOjFjNjFkKiNeMiClAiClNiInKjDkOiMoDiCmMiKePjAnKiDhEiDiMiBfLiDiAiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
//		g_pView->AppendToLastRgn(iRec->GetObject()->GetOuterFrame().ExtendRect(lg2mm(FCEditDraw::GetSelMarkSizeHalf() + 1)));
//	}
//	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiCmJiKnGiClFiCmEiBeBiDiKiDjDiDeOjAoGjCmKjCgNiPiIjHjNiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify(setMolip);
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	OnSelectObjModified();
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoG_xHqqkZx_.
//	g_pView->SendRgnRedraw();
//	//_xZkqqHx_iInKjDkOjApMiCpAiJpAiPjMiBeC_xHqqkZx_
//	m_mmlnvAry.clear();
//} // FCToolLineEdit::StateStopMoveJoint.
//----- 05.09.05 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::CanLinkToSelection
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Idle_xZkqqHx_iCmF_xHqqkZx_CTRL+MSMOVE_xZkqqHx_iCmFiDiKiDjDiDeOiCkKjCkDiCoKiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolLineEdit::CanLinkToSelection () const
{
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (GetCurrentState() != STATE_IDLE) return FALSE;
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (GetCurrentState() != STATE_IDLE &&
		GetCurrentState() != STATE_CONTEXT_MENU &&
		GetCurrentState() != STATE_CONTEXT_MENU_LINK) return FALSE;
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jBeJjBpAjCiGiCmMjApMjFjEjFgJiCpAiCfAiCmCiClIiCmCiDiLiBfLiDhGiClHiCoJiBeC_xHqqkZx_
	FCLnPRecVector::const_iterator iRec;
	for (iRec = m_lnpvSelect.begin(); iRec != m_lnpvSelect.end(); iRec++)
	{
		if (iRec->m_bIsSelected[0]) return TRUE;
		if (iRec->m_bIsSelected[1]) return TRUE;
	}
	return FALSE;
} // FCToolLineEdit::CanLinkToSelection.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::GetSelectionForLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAjCkDiCoJiClNiCnPiCmMiDiCiDiKiDhGiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	STATE_LINK_COMMAND_xZkqqHx_jAoKjHhAiCmMiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::GetSelectionForLink (FTMolipSet& stMolip) const
{
	stMolip.clear();
	// _xZkqqHx_jBeJjBpAjCiGiCmMjApMjFjEjFgJiCpAiCfAiCmCiClIiCmCiDiLiBfLiDhGiClHiCoJiBeC_xHqqkZx_
	FCLnPRecVector::const_iterator iRec;
	for (iRec = m_lnpvSelect.begin(); iRec != m_lnpvSelect.end(); iRec++)
	{
		if (iRec->m_bIsSelected[0])
			stMolip.insert(FCMolipRec((*iRec).GetObject()->GetObjID(), 0));
		if (iRec->m_bIsSelected[1])
			stMolip.insert(FCMolipRec((*iRec).GetObject()->GetObjID(), 2));
	}
} // FCToolLineEdit::GetSelectionForLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::ResetEditHandleList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::ResetEditHandleList ()
{
	// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	ClearEditHandleList();
	long lC;
	for (lC = 0; lC != m_lnpvSelect.size(); lC++)
	{
		// _xZkqqHx_iOgOjCfLiCpAjDgPjIfOiBeC_xHqqkZx_
		AddEditHandle(	m_lnpvSelect[lC].m_mmptEnds[0],
						FCHandleId(lC, 0, 0, 0));
		// _xZkqqHx_iPeJjCfLiCpAjDgPjIfOiBeC_xHqqkZx_
		AddEditHandle(	m_lnpvSelect[lC].m_mmptEnds[1],
						FCHandleId(lC, 1, 0, 0));
	}
} // FCToolLineEdit::ResetEditHandleList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::GetSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			stXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiIoKjHjHiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vector/set _xZkqqHx_iCmMiCkCiClIiCoKiCmMiMgAiOkOiCmFiCoAjCgMiCpAjFnEiClJiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolLineEdit::GetSelectedXXX (XXX_Joint, vector<longPair>* vXxx, set<longPair>* stXxx) const
{
	long lSize = -1;
	if (vXxx != NULL)
	//----- vXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		vXxx->clear();
		for (long lLine = 0; lLine != m_lnpvSelect.size(); lLine++)
		{
			if (m_lnpvSelect[lLine].m_bIsSelected[0])
				vXxx->push_back(longPair(lLine, 0));
			if (m_lnpvSelect[lLine].m_bIsSelected[1])
				vXxx->push_back(longPair(lLine, 1));
		}
		lSize = vXxx->size();
	}
	if (stXxx != NULL)
	//----- stXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		stXxx->clear();
		for (long lLine = 0; lLine != m_lnpvSelect.size(); lLine++)
		{
			if (m_lnpvSelect[lLine].m_bIsSelected[0])
				stXxx->insert(longPair(lLine, 0));
			if (m_lnpvSelect[lLine].m_bIsSelected[1])
				stXxx->insert(longPair(lLine, 1));
		}
		lSize = stXxx->size();
	}
	if (lSize == -1)
	{
		lSize = 0;
		for (long lLine = 0; lLine != m_lnpvSelect.size(); lLine++)
		{
			if (m_lnpvSelect[lLine].m_bIsSelected[0])
				lSize++;
			if (m_lnpvSelect[lLine].m_bIsSelected[1])
				lSize++;
		}
	}
	return lSize;
} // FCToolLineEdit::GetSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::GetSelectableXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiIoKjHjHiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolLineEdit::GetSelectableXXX (XXX_Joint, vector<longPair>* vXxx) const
{
	if (vXxx != NULL)
	//----- vXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		vXxx->clear();
		for (long lLine = 0; lLine != m_lnpvSelect.size(); lLine++)
		{
			vXxx->push_back(longPair(lLine, 0));
			vXxx->push_back(longPair(lLine, 1));
		}
		return vXxx->size();
	} else
	//----- vXxx _xZkqqHx_iCpAjFnEiClDiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return m_lnpvSelect.size() * 2;
	}
} // FCToolLineEdit::GetSelectableXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::SelectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::SelectXXX (XXX_Joint, longPair xxx, CDC* pDC)
{
	// _xZkqqHx_iKpJiCmJjBeJjBpAiNmPiCnNiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
	if (m_lnpvSelect[xxx.first].m_bIsSelected[xxx.second]) return;
	// _xZkqqHx_jBeJjBpAjCmHiJmBiBeC_xHqqkZx_
	m_lnpvSelect[xxx.first].m_bIsSelected[xxx.second] = TRUE;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::SelectXXX(XXX_JOINT, xxx, pDC);
} // FCToolLineEdit::SelectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::UnselectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiBeBjBeJjBpAiPpDjBnEiCkJiCoHiKeKjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::UnselectXXX (XXX_Joint, longPair xxx, CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UnselectXXX(XXX_JOINT, xxx, pDC);
	if (xxx == InvalidValueXXX(XXX_JOINT))
	//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		for (long lLine = 0; lLine != m_lnpvSelect.size(); lLine++)
		{
			// _xZkqqHx_jBeJjBpAiJpAiPjMiBeC_xHqqkZx_
			m_lnpvSelect[lLine].m_bIsSelected[0] = FALSE;
			m_lnpvSelect[lLine].m_bIsSelected[1] = FALSE;
		}
	} else
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKpJiCmJjBeJjBpAiJpAiPjMiNmPiCnNiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
		if (!m_lnpvSelect[xxx.first].m_bIsSelected[xxx.second]) return;
		// _xZkqqHx_jBeJjBpAiJpAiPjMiBeC_xHqqkZx_
		m_lnpvSelect[xxx.first].m_bIsSelected[xxx.second] = FALSE;
	}
} // FCToolLineEdit::UnselectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::GetFrameRectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCToolLineEdit::GetFrameRectXXX (XXX_Joint, longPair xxx) const
{
	return DBLRect(m_lnpvSelect[xxx.first].m_mmptEnds[xxx.second], m_lnpvSelect[xxx.first].m_mmptEnds[xxx.second]);
} // FCToolLineEdit::GetFrameRectXXX.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::DrawFirstImageXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiPiJiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::DrawFirstImageXXX (XXX_Joint, CDC* pDC)
//{
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//	vector<longPair> vSelectedJoint;
//	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
//	vector<longPair>::const_iterator iIdx;
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//	{
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//		DrawJointSelectMark(pDC, *iIdx);
//		// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjFfMiOkGiBeC_xHqqkZx_
//		FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//	}
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_jFmPiNfIiClDiCoKiCoJjApMjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
////	longSet stLineIndex;
////	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
////		stLineIndex.insert(iIdx->first);
////	longSet::const_iterator iLdx;
////	for (iLdx = stLineIndex.begin(); iLdx != stLineIndex.end(); iLdx++)
////	{
////		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
////		FCEditDraw eDraw(pDC, mm2lg(GetLineObject(*iLdx)->GetStdPenWeight()));
////		// _xZkqqHx_iPeDjAlDjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
////		eDraw.Line(	&mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(*iLdx, 0)).GetLeftTop()),
////					&mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(*iLdx, 1)).GetLeftTop()));
////	}
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoJiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
//	DrawSelectedBezier(pDC);
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCToolLineEdit::DrawFirstImageXXX.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::RedrawMovingImageXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			mmptMove:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::RedrawMovingImageXXX (XXX_Joint, const DBLPoint& mmptMove, CDC* pDC)
//{
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//	vector<longPair> vSelectedJoint;
//	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
//	// _xZkqqHx_jFmPiNfIiClDiCoKiCoJjApMjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
//	longSet stLineIndex;
//	vector<longPair>::const_iterator iIdx;
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//		stLineIndex.insert(iIdx->first);
//
////----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	longSet::const_iterator iLdx;
//// _xZkqqHx_iDgFiDfIiDgHiBeC_xHqqkZx_
//	if (!mmptMove.IsNull())
//	//----- _xZkqqHx_iInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
////----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//		// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//		for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//			FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//
//// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////		longSet::const_iterator iLdx;
//		for (iLdx = stLineIndex.begin(); iLdx != stLineIndex.end(); iLdx++)
//		{
//			// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//			FCEditDraw eDraw(pDC, mm2lg(GetLineObject(*iLdx)->GetStdPenWeight()));
//			// _xZkqqHx_iPeDjAlDjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
//			eDraw.Line(	&mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(*iLdx, 0)).GetLeftTop()),
//						&mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(*iLdx, 1)).GetLeftTop()));
//		}
//
//		//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiClHiCnHiCmE_xHqqkZx_mmptMove_xZkqqHx_iClOiCkPiInKjDkO_xHqqkZx_ -----
//		for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//			SetJointPoint(*iIdx, GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop() + mmptMove);
//
//// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//	}
//
//	// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjFfMiOkGiBeC_xHqqkZx_
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//		FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//	for (iLdx = stLineIndex.begin(); iLdx != stLineIndex.end(); iLdx++)
//	{
//		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//		FCEditDraw eDraw(pDC, mm2lg(GetLineObject(*iLdx)->GetStdPenWeight()));
//		// _xZkqqHx_iPeDjAlDjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//		eDraw.Line(	&mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(*iLdx, 0)).GetLeftTop()),
//					&mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(*iLdx, 1)).GetLeftTop()));
//	}
//} // FCToolLineEdit::RedrawMovingImageXXX.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::OnDrawMovingImageXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::OnDrawMovingImageXXX (XXX_Joint, CDC* pDC)
//{
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDhDiDhLiDgCiDgHiCmGiIpIjDfPiBeBiIpIjApMiCpAjFgAiJoGiBeC_xHqqkZx_
//	FCToolBaseEdit::OnDraw(pDC);
//
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//	vector<longPair> vSelectedJoint;
//	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
//	// _xZkqqHx_jFmPiNfIiClDiCoKiCoJjApMjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
//	longSet stLineIndex;
//	vector<longPair>::const_iterator iIdx;
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//		stLineIndex.insert(iIdx->first);
//
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//	{
//		// _xZkqqHx_iInKjDkOjBePiCmMjIeBiMiLjDfPiCmMiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
//		DBLPoint mmptEnd[2];
//		((const FCObjLine*)GetLineObject(iIdx->first))->GetPoints(mmptEnd[0], mmptEnd[1]);
//		FCEditDraw(pDC, 0).UnselMark(mm2lg(mmptEnd[iIdx->second]));
//		// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjFfMiOkGiBeC_xHqqkZx_
//		FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//	}
//	longSet::const_iterator iLdx;
//	for (iLdx = stLineIndex.begin(); iLdx != stLineIndex.end(); iLdx++)
//	{
//		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//		FCEditDraw eDraw(pDC, mm2lg(GetLineObject(*iLdx)->GetStdPenWeight()));
//		// _xZkqqHx_iPeDjAlDjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
//		eDraw.Line(	&mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(*iLdx, 0)).GetLeftTop()),
//					&mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(*iLdx, 1)).GetLeftTop()));
//	}
//} // FCToolLineEdit::OnDrawMovingImageXXX.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::DrawLastImageXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiMoDiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolLineEdit::DrawLastImageXXX (XXX_Joint, CDC* pDC)
//{
//} // FCToolLineEdit::DrawLastImageXXX.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::MoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx		:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vmmptMove	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::MoveXXX (XXX_Joint, const vector<longPair>& vXxx, const DBLPointVector& vmmptMove)
{
	longSet stLineIndex;
	vector<longPair>::const_iterator iIdx;
	for (iIdx = vXxx.begin(); iIdx != vXxx.end(); iIdx++)
		stLineIndex.insert(iIdx->first);

	longSet::const_iterator iLjs;
	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoIiBeC_xHqqkZx_
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	for (iLjs = stLineIndex.begin(); iLjs != stLineIndex.end(); iLjs++)
//		g_pView->AddRgn(GetLineObject(*iLjs));
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	for (iLjs = stLineIndex.begin(); iLjs != stLineIndex.end(); iLjs++)
		AppendJointMovedRgn(*iLjs, longSet());
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
	FTMolipSet setMolip;
	for (long lC = 0; lC != vXxx.size(); lC++)
	{
		if (vXxx[lC].second == 0)
		// _xZkqqHx_iClBiCmMjFjEjFgJiCmMiKeKiOgOjDfPjBeJjBpAiCmIiCoHiCmOiKeKiOgOjDfPiInKjDkOiBeC_xHqqkZx_
		{
			//----- _xZkqqHx_iCfAiDiJiDeDiDjDjFjEjFgJiKeKiOgOjDfPiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhD_xHqqkZx_ -----
			FCLineRec lineRec;
			lineRec.wMask = FDFP_FROMENDX | FDFP_FROMENDY;
			lineRec.mmFromEndX = ((FCObjLine*)GetLineObject(vXxx[lC].first))->GetFromEndX() + vmmptMove[lC].x;
			lineRec.mmFromEndY = ((FCObjLine*)GetLineObject(vXxx[lC].first))->GetFromEndY() + vmmptMove[lC].y;
			g_pDoc->CmdModifyLine((FCObjLine*)GetLineObject(vXxx[lC].first), lineRec);
			// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiCmJjCmHiJmBiBeC_xHqqkZx_
			setMolip.insert(FCMolipRec(GetLineObject(vXxx[lC].first)->GetObjID(), 0));
		} else
		// _xZkqqHx_iClBiCmMjFjEjFgJiCmMiPeJjHlJjDfPjBeJjBpAiCmIiCoHiCmOiPeJjHlJjDfPiInKjDkOiBeC_xHqqkZx_
		{
			//----- _xZkqqHx_iCfAiDiJiDeDiDjDjFjEjFgJiPeJjHlJjDfPiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhD_xHqqkZx_ -----
			FCLineRec lineRec;
			lineRec.wMask = FDFP_TOENDX | FDFP_TOENDY;
			lineRec.mmToEndX = ((FCObjLine*)GetLineObject(vXxx[lC].first))->GetToEndX() + vmmptMove[lC].x;
			lineRec.mmToEndY = ((FCObjLine*)GetLineObject(vXxx[lC].first))->GetToEndY() + vmmptMove[lC].y;
			g_pDoc->CmdModifyLine((FCObjLine*)GetLineObject(vXxx[lC].first), lineRec);
			// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiCmJjCmHiJmBiBeC_xHqqkZx_
			setMolip.insert(FCMolipRec(GetLineObject(vXxx[lC].first)->GetObjID(), 2));
		}
	}
	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiCmJiKnGiClFiCmEiBeBiDiKiDjDiDeOjAoGjCmKjCgNiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->LinkManager()->MovedNotify(setMolip);
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	OnSelectObjModified();
	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoIiBeC_xHqqkZx_
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	for (iLjs = stLineIndex.begin(); iLjs != stLineIndex.end(); iLjs++)
//		g_pView->AddRgn(GetLineObject(*iLjs));
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	for (iLjs = stLineIndex.begin(); iLjs != stLineIndex.end(); iLjs++)
		AppendJointMovedRgn(*iLjs, longSet());
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoG_xHqqkZx_.
	g_pView->SendRgnRedraw();
} // FCToolLineEdit::MoveXXX.

//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolLineEdit::AppendJointMovedRgn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiPfHiNiHiCkKiInKjDkOiClDiCoKiCoJiOjOiCmMiBeBiMmFjHeMiDiKiBfLiDfHiDiHiDjDjCmHiJmBiPiIjHjN_xHqqkZx_
 *			_xZkqqHx_iCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_iInKjDkOiClDiCoKiCoJjIeBiMiLjDfPiCkKjBkOiClHiCoJjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stJointIndex:_xZkqqHx_iInKjDkOiClDiCoKiCoJjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolLineEdit::AppendJointMovedRgn (long lLineIndex, const longSet& stJointIndex)
{
	// _xZkqqHx_jFjEjFgJiCpAiCnMiCoJiClCiCmGiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoIiBeC_xHqqkZx_
	g_pView->AddRgn(GetLineObject(lLineIndex));
} // FCToolLineEdit::AppendJointMovedRgn.
//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----


