#include "stdafx.h"
#include "DynamicDraw.h"
#include <algorithm>		// For find template.
#include <float.h>			// For DBL_MAX
#include "FoundDoc.h"		// For g_pDoc.
#include "LinkManager.h"	// For g_pDoc->LinkManager().
#include "DynamicDrawView.h"	// For g_pView.
#include "ProPolyJoint.h"	// For CFCProPolyJoint.
#include "PrsObjProperty.h"	// For CFCPrsObjProperty.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMisc.h"		// For HitTest.
#include "UtilStr.h"		// For GetResString.
#include "UtilObj.h"		// For FFAddToLZSorted.
#include "UtilBezier.h"		// For CalcBezier2.
#include "UtilGraph.h"		// For FCEditDraw.
#include "UtilGraph.h"		// For FCEditDraw.
#include "Arrow.h"			// For FCBaseArrow.
#include "UtilDlg.h"		// For RightByLeftHand.
#include "RegData.h"		// For FCRegData.
#include "ObjPoly.h"		// For FCObjPoly.
#include "ObjWidePoly.h"	// For FCObjWidePoly.
#include "RichText.h"		// For FCRichText.
#include "FrameWnd.h"		// For FFGetMainWnd().
#include "ToolPolyEdit.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// 02.12.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//FCToolPolyEdit g_toolPolyEdit;

///////////////////////// JointSelInfo_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_ /////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::JointSelInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
JointSelInfo::JointSelInfo ()
{
	m_pObj = NULL;
} // JointSelInfo::JointSelInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::JointSelInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeCiPiJiKpKiJlLjHhAiIpIjAjEiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lSize	:pJoint_xZkqqHx_iCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *			pJoint	:_xZkqqHx_jIeBiMiLjDfPiCmMjEhKjHpBiBeC_xHqqkZx_
 *			bIsOpen	:_xZkqqHx_iDhMiDiKiDfDiDjDiCkKiDeJiBfLiDhGiDjDiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj	:_xZkqqHx_jIeBiMiLjDfPjEhKjHpBiCmMiDeJiBfLiDgJiBfLjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
JointSelInfo::JointSelInfo (long lSize, const FCPolyJoint *pJoint, BOOL bIsOpen,
							FCObjPoly* pObj)
			:FCPolyJointVector(lSize, pJoint, bIsOpen)
{
	m_pObj = pObj;
} // JointSelInfo::JointSelInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::~JointSelInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *************************************************************************/
JointSelInfo::~JointSelInfo () {}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::UpdateJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiDeKiDgJiDiBjDfPiBeBiIpIjDfPiCmMiNmAjFfHiCpAiBeBjFjEjFgJiCmMjIeBiMiLjDfPiCkJiCoHiNmEiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.08.09 Fukushiro M. _xZkqqHx_jCgMiCpAjFnEiClHiCoGiCkEiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
BOOL JointSelInfo::UpdateJoint ()
{
	BOOL bModified = FALSE;
	if (size() != m_pObj->GetJointSize())
	{
		bModified = TRUE;
		resize(m_pObj->GetJointSize());
	}
	const FCPolyJoint* pJoint = m_pObj->GetJoints();
	JointSelInfo::iterator i;
	for (i = begin(); i != end(); i++, pJoint++)
	{
		if (!almosteq(*i, *pJoint))
		{
			bModified = TRUE;
			*i = *pJoint;
		}
	}
	if (IsOpen() != m_pObj->GetIsOpenPolyJoint())
	{
		bModified = TRUE;
		SetOpenStatus(m_pObj->GetIsOpenPolyJoint());
	}
	return bModified;
} // JointSelInfo::UpdateJoint.

//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::MovePivot
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpA_xHqqkZx_mmptMove_xZkqqHx_iClOiCkPiInKjDkOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMove	:_xZkqqHx_iInKjDkOiLjHjHkDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void JointSelInfo::MovePivot (const DBLPoint& mmptMove)
//{
//	longVector::const_iterator iIdx;
//	for (iIdx = m_vSelJointIdx.begin(); iIdx != m_vSelJointIdx.end(); iIdx++)
//	{
//		(*this)[*iIdx].m_mmptPivot += mmptMove;
//	}
//} // JointSelInfo::MovePivot.
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::IsSelectedJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	idx_xZkqqHx_iCmFiOkGiClDiCoKiCoJjIeBiMiLjDfPiCkKjBeJjBpAiPpDjBnEiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	idx	:_xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiPpDjBnEiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBjEpBjBeJjBpAiPpDjBnEiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL JointSelInfo::IsSelectedJoint (long idx) const
//{
//	longVector::const_iterator iIdx;
//	iIdx = find(m_vSelJointIdx.begin(), m_vSelJointIdx.end(), idx);
//	// _xZkqqHx_jIeBiMiLjDfPiCkKiMkJiCmCiCkJiCmBiClNiCoHjAfOiCpAjFnEiClH_xHqqkZx_.
//	if (iIdx != m_vSelJointIdx.end()) return TRUE;
//	return FALSE;
//} // JointSelInfo::IsSelectedJoint.
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::SelectJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	idx_xZkqqHx_iCmFiOkGiClDiCoKiCoJjIeBiMiLjDfPiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	idx	:_xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpJiCmJjBeJjBpAiPpDjBnEiCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iBeBjEpBjBeJjBpAiPpDjBnEiCmIiCoHiCmO_xHqqkZx_ TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL JointSelInfo::SelectJoint (long idx)
{
	longVector::iterator iIdx;
	for (iIdx = m_vSelJointIdx.begin(); iIdx != m_vSelJointIdx.end(); iIdx++)
	{
		// _xZkqqHx_iKpJiCmJjBeJjBpAiNmPiCnNiCmMiPoKiNiHiCmNjFjMiLeB_xHqqkZx_.
		if (*iIdx == idx) return FALSE;
		//----- _xZkqqHx_jBeJjBpAiNmPiCnNjIeBiMiLjDfPiCmNiDeDiDjDiDgGiDgCiDeOiDfIiCkKiPkMiClDiCkCiPiHiCmJ_xHqqkZx_ -----
		if (idx < *iIdx)
		{
			// _xZkqqHx_jDeLjAnIiCmIiImKjChFiCmJjIeBiMiLjDfPiDeDiDjDiDgGiDgCiDeOiDfIiCpAjBhNjDpM_xHqqkZx_.
			m_vSelJointIdx.insert(iIdx, idx);
			// _xZkqqHx_jAlDiPoNjFjMiLeB_xHqqkZx_.
			return TRUE;
		}
	}
	//----- _xZkqqHx_jCmHiJmBiClHiCoJjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkKiNmFiCoAjBoFiCkLiCkCiOjO_xHqqkZx_ -----
	// _xZkqqHx_jBeJjBpAiNmPiCnNiDiKiDfIiDgHiCmMiNmFiMoDiCmJjCmHiJmB_xHqqkZx_.
	m_vSelJointIdx.push_back(idx);
	// _xZkqqHx_jAlDiPoNjFjMiLeB_xHqqkZx_.
	return TRUE;
} // JointSelInfo::SelectJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::UnselectJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	idx_xZkqqHx_iCmFiOkGiClDiCoKiCoJjIeBiMiLjDfPiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	idx	:_xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiPpDjBnEiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBiKpJiCmJjEpBjBeJjBpAiPpDjBnEiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL JointSelInfo::UnselectJoint (long idx)
{
	longVector::iterator iIdx;
	// _xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiDiKiDfIiDgHjCiGiCmJjCfEiClHiBeC_xHqqkZx_
	iIdx = find(m_vSelJointIdx.begin(), m_vSelJointIdx.end(), idx);
	// _xZkqqHx_iKpJiCmJjBeJjBpAiNmPiCnNiCmMiPoKiNiHiCmNjFjMiLeB_xHqqkZx_.
	if (iIdx == m_vSelJointIdx.end()) return FALSE;
	// _xZkqqHx_jBeJjBpAiNmPiCnNjIeBiMiLjDfPiCmMiDiKiDfIiDgHiCkJiCoHiPjMiCkN_xHqqkZx_.
	m_vSelJointIdx.erase(iIdx);
	// _xZkqqHx_jAlDiPoNjFjMiLeB_xHqqkZx_.
	return TRUE;
} // JointSelInfo::UnselectJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::ClearSelectJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjBeJjBpAiPpDjBnEiCmMjIeBiMiLjDfPiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void JointSelInfo::ClearSelectJoint ()
{
	m_vSelJointIdx.clear();
} // JointSelInfo::ClearSelectJoint.

//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::DrawPivotMark
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjBeJjBpAiPpDjBnEiCmMjIeBiMiLjDfPiCmMiDeKiDgJiDiBjDfPiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfI_xHqqkZx_ FCPolyJointVector _xZkqqHx_iCmM_xHqqkZx_ DrawPivotMark_xZkqqHx_iKnGjAjEiCmGiCmM_xHqqkZx_
// *			_xZkqqHx_iOgHiCkCjFkKiCkPiCmJjCiNiInDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void JointSelInfo::DrawPivotMark (CDC* pDC) const
//{
//	longVector::const_iterator iIdx;
//	for (iIdx = m_vSelJointIdx.begin(); iIdx != m_vSelJointIdx.end(); iIdx++)
//	{
//		(*this)[*iIdx].DrawPivotMark(pDC);
//	}
//} // JointSelInfo::DrawPivotMark.
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::DrawPullMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjBeJjBpAiPpDjBnEiCmMjIeBiMiLjDfPiCmMiIpIjDfPiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void JointSelInfo::DrawPullMark (CDC* pDC) const
{
	longVector::const_iterator iIdx;
	for (iIdx = m_vSelJointIdx.begin(); iIdx != m_vSelJointIdx.end(); iIdx++)
	{
		(*this)[*iIdx].DrawPullMark(pDC);
	}
} // JointSelInfo::DrawPullMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::GetAffected
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjBeJjBpAiPpDjBnEiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiClNiOjOiCmJiJgFiLlPiCpAiCkEiCkPiCoJjIeBiMiLjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iPfHiNiHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vJntSeq	:_xZkqqHx_jIeBiMiLjDfPiDeDiDjDiDgGiDgCiDeOiDfIjIeBjEnEiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoJjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPfHiNiHiCmNiBeBiCfAiCmCiImIiPoDiCmMjIeBjEnEiCmM_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGiCpAiNoMiCoJiBeCiClLiCmMiDePiDiLiBfLiDhGiCmMiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpA_xHqqkZx_ lStart_xZkqqHx_iCnGiBeB_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDfEiDeDiDfJiCpA_xHqqkZx_ lSize_xZkqqHx_iCnGjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiBeBjIeBiMiLjDfPiCmMiPfHiNiHiCpA_xHqqkZx_ [ 0, 1, 2, 5, 6, 9 ]_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			vJntSeq = { {0,3}, {5,2}, {9,1} }
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void JointSelInfo::GetAffected (JointSeqVector& vJntSeq) const
{
	FCPolyJointVector::GetAffected(vJntSeq, m_vSelJointIdx);
} // JointSelInfo::GetAffected.

//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::FindHitPrevPull
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBiOhHjCoIiNmAjFfHiCkKjBePiIpIjDfPiPoDiCmFiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiBeBiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmNiClLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMsc	:_xZkqqHx_iDhBiDgCiDgHiCpAjClCiCnHiCoJiNmAjFfHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *			_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long JointSelInfo::FindHitPrevPull (const DBLPoint& mmptMsc) const
//{
//	longVector::const_iterator iIdx;
//	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBiIpIjDfPiCpAjClCiCnHiCoJ_xHqqkZx_ -----
//	for (iIdx = m_vSelJointIdx.begin(); iIdx != m_vSelJointIdx.end(); iIdx++)
//	{
//		// _xZkqqHx_jBePiIpIjDfPiCkKiCkAiCoI_xHqqkZx_ _xZkqqHx_iKiOiCmCjBePiIpIjDfPiCmFiCmMiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
//		if (!((*this)[*iIdx].m_nType & 0x01) &&
//			(*this)[*iIdx].IsHitPrevPull(mmptMsc)) return *iIdx;
//	}
//	// _xZkqqHx_jBePiIpIjDfPiCmJiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
//	return -1L;
//} // JointSelInfo::FindHitPrevPull.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::FindHitNextPull
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBiOhHjCoIiNmAjFfHiCkKiMoDiIpIjDfPiPoDiCmFiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiBeBiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmNiClLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMsc	:_xZkqqHx_iDhBiDgCiDgHiCpAjClCiCnHiCoJiNmAjFfHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *			_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long JointSelInfo::FindHitNextPull (const DBLPoint& mmptMsc) const
//{
//	longVector::const_iterator iIdx;
//	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBiIpIjDfPiCpAjClCiCnHiCoJ_xHqqkZx_ -----
//	for (iIdx = m_vSelJointIdx.begin(); iIdx != m_vSelJointIdx.end(); iIdx++)
//	{
//		// _xZkqqHx_iMoDiIpIjDfPiCkKiCkAiCoI_xHqqkZx_ _xZkqqHx_iKiOiCmCiMoDiIpIjDfPiCmFiCmMiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
//		if (!((*this)[*iIdx].m_nType & 0x04) &&
//			(*this)[*iIdx].IsHitNextPull(mmptMsc)) return *iIdx;
//	}
//	// _xZkqqHx_iMoDiIpIjDfPiCmJiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
//	return -1L;
//} // JointSelInfo::FindHitNextPull.
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::GetSelJointVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDiKiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const longVector& JointSelInfo::GetSelJointVector () const
{
	return m_vSelJointIdx;
} // JointSelInfo::GetSelJointVector.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::GetObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiBfLiDfBiDgCiDgHjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfOiBfLiDfBiDgCiDgHjFjEjFgJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjPoly* JointSelInfo::GetObject () const
{
	return m_pObj;
} // JointSelInfo::GetObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::GetPtr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCPolyJoint_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FCPolyJoint_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyJoint* JointSelInfo::GetPtr ()
{
	return &at(0);
} // JointSelInfo::GetPtr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::GetPtr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCPolyJoint_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FCPolyJoint_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCPolyJoint* JointSelInfo::GetPtr () const
{
	return &at(0);
} // JointSelInfo::GetPtr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	JointSelInfo::GetSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long JointSelInfo::GetSize () const
{
	return (long)size();
} // JointSelInfo::GetSize.

////////////////////////// FCToolPolyEdit ///////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myCalcBezierClip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjBlNiKhAjApMjFjEjFgJiCmMiBeBiOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCmMiLmIjApMiCmJiKePjAnKiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgrtClip	:_xZkqqHx_iKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAjFnEiClH_xHqqkZx_.
 *			pObjPoly	:_xZkqqHx_jBlNiKhAjApMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stJointIndex:_xZkqqHx_iMhGiOfKiClHiCoJjIeBiMiLjDfPiCmMiPfHiNiHiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJoGjGmKiCmMiDhCiDiFiBfLiCmJiJgGiCmBiCmEiCkCiCoJjEmNiImNiClOiCkPiCpAiMhGiOfKiClHiCoJiBeCiDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_
 *			_xZkqqHx_iCmJiCmNiBeBjApMiCmMjFjNiCmGjBeJjBpAjHhAiCmMiDhNiBfLiDeOiDfEiDeDiDfJiBeBjBiAiNoMjHhAiIpIjApMiBeB_xHqqkZx_
 *			_xZkqqHx_iJgFiCmMiDfEiDeDiDfJiCpAiNgMjHlGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmJiBeBjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmGiBeBjIeBiMiLjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmM_xHqqkZx_
 *			_xZkqqHx_iKnGiMfHiCpAjAhNiOkGiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_jBlNiKhAjApMiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_
 *                _xZkqqHx_iCfB_xHqqkZx_    _xZkqqHx_iCfA_xHqqkZx_       
 *                _xZkqqHx_iBkF_xHqqkZx_ _xZkqqHx_iCfA_xHqqkZx_ _xZkqqHx_iBkF_xHqqkZx_       
 *             _xZkqqHx_iCfBiBfOiBfAiBfAiBfAiBfPiCeP_xHqqkZx_    
 *         _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_          _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_                 
 *          _xZkqqHx_iCfCiEkA_xHqqkZx_                 
 *            _xZkqqHx_iEkA_xHqqkZx_                 
 *         _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_          _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
 *             _xZkqqHx_iCfDiBfPiBfBiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                _xZkqqHx_iBkD_xHqqkZx_ _xZkqqHx_iCfE_xHqqkZx_ _xZkqqHx_iBkD_xHqqkZx_       
 *                _xZkqqHx_iCfE_xHqqkZx_    _xZkqqHx_iCfF_xHqqkZx_       
 *
 *			_xZkqqHx_jBlNiKhAjApMiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_
 *                _xZkqqHx_iCfB_xHqqkZx_    _xZkqqHx_iCfA_xHqqkZx_       
 *                _xZkqqHx_iBkF_xHqqkZx_ _xZkqqHx_iCfA_xHqqkZx_ _xZkqqHx_iBkF_xHqqkZx_       
 *             _xZkqqHx_iCfBiBfOiBfAiBfAiBfAiBfPiCeP_xHqqkZx_    
 *         _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_          _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_   
 *          _xZkqqHx_iCfCiEkA_xHqqkZx_            _xZkqqHx_iEkAiCfG_xHqqkZx_ 
 *            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_   
 *         _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_          _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
 *             _xZkqqHx_iCfDiBfPiBfBiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                _xZkqqHx_iBkD_xHqqkZx_ _xZkqqHx_iCfE_xHqqkZx_ _xZkqqHx_iBkD_xHqqkZx_       
 *                _xZkqqHx_iCfE_xHqqkZx_    _xZkqqHx_iCfF_xHqqkZx_       
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myCalcBezierClip (	CRect& lgrtClip,
								const FCObjPoly* pObjPoly,
								const longSet& stJointIndex)
{
	// _xZkqqHx_iInKjDkOiClDiCoKiCoJjIeBiMiLjDfPiCmJiCoGiCmBiCmEiJgFiLlPiCpAiOpDiCkPiCoJjIeBiMiLjApMiCmMjBfDiCmEiBeCiInKjDkOiClDiCoKiCoJ_xHqqkZx_
	// _xZkqqHx_jIeBiMiLjDfPiCmMjHlMjHnHiCoIiCmMjApMiCkKiJgFiLlPiCpAiOpDiCkPiCoJiBeC_xHqqkZx_
	longSet stAffectedLineIndex;
	longSet::const_iterator iIdx;
	for (iIdx = stJointIndex.begin(); iIdx != stJointIndex.end(); iIdx++)
	{
		// _xZkqqHx_iInKjDkOiClDiCoKiCoJjIeBiMiLjDfPiCmMjHlMjHnHiCoIiCmMjApMiCpAjCmHiJmBiBeCjIeBiMiLjApMiDeDiDjDiDgGiDgCiDeOiDfIiCmMjEmNiImNiCpA_xHqqkZx_
		// _xZkqqHx_jClEiCkGiCoJiPoKiNiHiCmNiMoDiCmFiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		stAffectedLineIndex.insert(*iIdx);
		if (*iIdx != 0)
			stAffectedLineIndex.insert(*iIdx - 1);
		else
			stAffectedLineIndex.insert(pObjPoly->GetJointSize() - 1);
	}
	// _xZkqqHx_jIeBiMiLjApMiDeDiDjDiDgGiDgCiDeOiDfIiCmMjEmNiImNiCpAjClEiCkGiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmNiNoNiPjMiBeC_xHqqkZx_
	if (pObjPoly->GetIsOpenPolyJoint())
		stAffectedLineIndex.erase(pObjPoly->GetJointSize() - 1);

	// WidePoly_xZkqqHx_iCkJiBeI_xHqqkZx_
	const BOOL bIsWidePoly = pObjPoly->IsKindOf(FDOJ_WIDE_POLY);

	//----- _xZkqqHx_jApMjFjNiCmMiMhGiOfKiBeC_xHqqkZx_WidePoly_xZkqqHx_iCmMiPoKiNiHiCmNjBnBiCmMjFjN_xHqqkZx_ -----
	mmetol mmWeight = pObjPoly->GetStdPenWeight();
	mmetol mmPolyWidthF;
	mmetol mmPolyWidthB;
	mmetol mmExt;	// _xZkqqHx_jAgDjApMiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCmMiKgHjCkDiDfEiDeDiDfJiBeC_xHqqkZx_
	if (bIsWidePoly)
	//----- WidePoly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		FCObjWidePoly* pWidePoly = (FCObjWidePoly*)pObjPoly;
		mmPolyWidthF = pWidePoly->GetPolyWidthF();
		mmPolyWidthB = pWidePoly->GetPolyWidthB();
		mmetol mmWidth = (mmPolyWidthF < mmPolyWidthB) ? mmPolyWidthB : mmPolyWidthF;
		// _xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P307_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_1.42 = Root(2.0)
		mmExt = 1.42 * (mmWidth / 2.0 + mmWeight);
	} else
	{
		mmPolyWidthF = mmWeight;
		mmPolyWidthB = mmWeight;
		mmExt = mmWeight / 2.0;
	}
	// mmExt _xZkqqHx_iCmNiBeBjBeJjBpAiDhNiBfLiDeOiCoGiCoIjBoFiCkLiCkNiCmIiCkNiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (mm2lg(mmExt) < FCEditDraw::GetSelMarkSizeHalf())
		mmExt = FCEditDraw::GetSelMarkSizeHalf();

	//----- _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoI_xHqqkZx_ -----
	DBLRect mmrtView;
	g_pView->GetClientRectMM(mmrtView);

	DBLRect mmrtArrowF(0,0,0,0);
	DBLRect mmrtArrowB(0,0,0,0);
	// _xZkqqHx_jHlMjCfLiCmMjDfPiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DBLPoint mmptEdgeF;
	DBLPoint mmptEdgeB;
	pObjPoly->GetEdgePoint(mmptEdgeF, mmptEdgeB);
	if (pObjPoly->GetIsOpenPolyJoint())
	//----- _xZkqqHx_jBlNiKhAjApMiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiBeFiBeFiBeFjGoOiIpDiCkKiCkAiCoJiJmCjEfMjAkLiCkAiCoI_xHqqkZx_ -----
	{
		if (stAffectedLineIndex.find(0) != stAffectedLineIndex.end() &&
			pObjPoly->GetArrowFType() != FDUG_ARW_TYPE_FLAT)
		//----- _xZkqqHx_jIeBiMiLjDfPiPfHiNiHiCmJiOgOjDfPiCkKiKnMiCnMiCoKiBeBiKiOiCmCiOgOjDfPjGoOiIpDiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (pObjPoly->GetArrowFType() == FDUG_ARW_TYPE_PICT)
			{
				FCPictArrow arrow(pObjPoly->GetPictArrowF(), bIsWidePoly);
				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
				arrow.CalcOuterFrame(mmrtArrowF, mmptEdgeF, mmPolyWidthF, mmWeight);
			} else
			{
				FCStdArrow arrow(FCUGArrowParams(pObjPoly->GetArrowFType(),
												pObjPoly->GetArrowFParam0(),
												pObjPoly->GetArrowFParam1(),
												pObjPoly->GetArrowFParam2()), bIsWidePoly);
				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
				arrow.CalcOuterFrame(mmrtArrowF, mmptEdgeF, mmPolyWidthF, mmWeight);
			}
			// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmJjGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCpAiNgMjHlGiBeC_xHqqkZx_
			mmrtView |= mmrtArrowF;
		}
		if (stAffectedLineIndex.find(pObjPoly->GetJointSize() - 2) != stAffectedLineIndex.end() &&
			pObjPoly->GetArrowBType() != FDUG_ARW_TYPE_FLAT)
		//----- _xZkqqHx_jIeBiMiLjDfPiPfHiNiHiCmJiPeJjDfPiCkKiKnMiCnMiCoKiBeBiKiOiCmCiPeJjDfPjGoOiIpDiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (pObjPoly->GetArrowBType() == FDUG_ARW_TYPE_PICT)
			{
				FCPictArrow arrow(pObjPoly->GetPictArrowB(), bIsWidePoly);
				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
				arrow.CalcOuterFrame(mmrtArrowB, mmptEdgeB, mmPolyWidthB, mmWeight);
			} else
			{
				FCStdArrow arrow(FCUGArrowParams(pObjPoly->GetArrowBType(),
												pObjPoly->GetArrowBParam0(),
												pObjPoly->GetArrowBParam1(),
												pObjPoly->GetArrowBParam2()), bIsWidePoly);
				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
				arrow.CalcOuterFrame(mmrtArrowB, mmptEdgeB, mmPolyWidthB, mmWeight);
			}
			// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmJjGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCpAiNgMjHlGiBeC_xHqqkZx_
			mmrtView |= mmrtArrowB;
		}
	}

	//----- _xZkqqHx_iLmIjApMiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfK_xHqqkZx_ -----
	CRect lgrtView = mm2lg(mmrtView);

	for (iIdx = stAffectedLineIndex.begin(); iIdx != stAffectedLineIndex.end(); iIdx++)
	//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoJjIeBiMiLjApMiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iLmIjApMiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfK_xHqqkZx_ -----
		CPointVector vlgptPoly;
		CalcBezier2(vlgptPoly,
					pObjPoly->GetJoints(),
					pObjPoly->GetJointSize(),
					mmExt * 2.0,
					*iIdx,
					1,
					g_->lgdPrecision,
					g_->dZoom,
					&lgrtView,
					1,
					StdMinRatio(lgrtView));
		//----- _xZkqqHx_jFmPiNfIiLmIjApMiCmJiKePjAnKiClHiCoJiLoJiMgAjHmMiIoGiCpAiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoI_xHqqkZx_ -----
		// _xZkqqHx_jClIjDfPiNmAjFfHiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		CRect lgrtFrame;
		FFCalcFrame(lgrtFrame, vlgptPoly.size(), vlgptPoly.begin());
		lgrtClip |= lgrtFrame;
	}

	if (pObjPoly->GetIsOpenPolyJoint() &&
		!bIsWidePoly &&
		(pObjPoly->IsFillPainted() ||
		 (pObjPoly->GetRichText() != NULL && !pObjPoly->GetRichText()->IsEmpty())))
	//----- _xZkqqHx_iKeKiCkCiClNjAhNiMgAiKiOiCmCjAhNiMgAiCmJjDgIjCnHiClFiCkKiCkAiCoJiBeBiIlNiCkCiCmNiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (stJointIndex.find(0) != stJointIndex.end() ||
			stJointIndex.find(pObjPoly->GetJointSize() - 1) != stJointIndex.end())
		//----- _xZkqqHx_iInKjDkOjDfPiCmJiBeBjIeBiMiLjDfPiCmMiKeKiOgOjDfPiIlNiCkCiCmNiPeJjHlJjDfPiCkKiKnMiCnMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iOgOjDfPiBeBiPeJjDfPiCpAiMiLiCnEjClMjApMiCmJiCoGiCmBiCmEiBeBjDgIiCoIiCmCiCnEiClFiCoCiDgFiDeMiDfIiDgHiCkKiJgFiLlPiCpAiOpDiCkPiCoJiBeC_xHqqkZx_
			//----- _xZkqqHx_jIeBiMiLjDfPiCmMiKeKiOgOjDfPiBeBiPeJjHlJjDfPiCpAiKePjAnKiDhEiDiMiBfLiDiAiCmJiJmBiOfK_xHqqkZx_ -----
			DBLRect mmrtEdge(mmptEdgeF, mmptEdgeB);
			mmrtEdge.NormalizeRect();
			lgrtClip |= mm2lg(mmrtEdge);
		}
	}
	// _xZkqqHx_jBnBjFjNjFkKiLoJiMgAiCpAiMpKiCkNiClHiCoJiBeC_xHqqkZx_
	lgrtClip.InflateRect(mm2lg(mmExt), mm2lg(mmExt));
	if (!mmrtArrowF.IsRectNull())
		lgrtClip |= mm2lg(mmrtArrowF);
	if (!mmrtArrowB.IsRectNull())
		lgrtClip |= mm2lg(mmrtArrowB);

	// _xZkqqHx_iJgFiCmMjBoFiCkLiClDiCpAiDeOiDiKiDgCiDhGiCmJjElNiJgGiClDiClJiCoJ_xHqqkZx_ -----
	if (pObjPoly->GetShadowSColor() != FD_S_COLOR_UNUSE)
	//----- _xZkqqHx_iJgFiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iJgFiCmMiDeJiDhEiDfKiDgCiDgHiCkKiJeFjFpLiMpMiCmMiPoKiNiHiBeC_xHqqkZx_
		if (0 <= g_pEnv->GetShadowLen().x)
			lgrtClip.right += mm2lg(g_pEnv->GetShadowLen().x);
		else
			lgrtClip.left += mm2lg(g_pEnv->GetShadowLen().x);

		// _xZkqqHx_iJgFiCmMiDeJiDhEiDfKiDgCiDgHiCkKiJlKjFpLiMpMiCmMiPoKiNiHiBeC_xHqqkZx_
		if (0 <= g_pEnv->GetShadowLen().y)
			lgrtClip.bottom += mm2lg(g_pEnv->GetShadowLen().y);
		else
			lgrtClip.top += mm2lg(g_pEnv->GetShadowLen().y);
	}

	// _xZkqqHx_iIpIjApMiCmMjHmMiIoGiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
	for (iIdx = stJointIndex.begin(); iIdx != stJointIndex.end(); iIdx++)
	{
		lgrtClip |= pObjPoly->GetJoint(*iIdx).GetPrevPullRgn();
		lgrtClip |= pObjPoly->GetJoint(*iIdx).GetNextPullRgn();
	}

	// _xZkqqHx_iPkNiClFjHfNjHfEiCpAiBeC_xHqqkZx_lg2mm(lgrtClip)_xZkqqHx_iCmFiDiKiBfLiDfHiDiHiDjDjAnNjCoIiClHiCoJiNnLiBeB_xHqqkZx_1Pixel_xZkqqHx_iOlIiCoNiCoKiCoJiPoKiNiHiCoAiBeC_xHqqkZx_
	lgrtClip.InflateRect(1, 1);
} // myCalcBezierClip.

//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcBezierAndClip
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiLmIjApMjFjEjFgJiCmMiBeBiOhHjCoIiClDiCoKiClNjEmNiImNiCmMiLmIjApMiCmMjClIjDfPjEhKjHpBiCmG_xHqqkZx_
// *			_xZkqqHx_iClLiCoKiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vlgptPoly	:_xZkqqHx_jClIjDfPjEhKjHpBiCpAjFnEiClH_xHqqkZx_.
// *			lgrtClip	:_xZkqqHx_iKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAjFnEiClH_xHqqkZx_.
// *			jointInf	:_xZkqqHx_jIeBiMiLjDfPiCmMjEhKjHpBiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *			jntSeq		:_xZkqqHx_iMhGiOfKiClHiCoJjIeBiMiLjDfPiCmMjEmNiImNiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJoGjGmKiCmMiDhCiDiFiBfLiCmJiJgGiCmBiCmEiCkCiCoJjEmNiImNiClOiCkPiCpAiMhGiOfKiClHiCoJiBeCiDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_
// *			_xZkqqHx_iCmJiCmNiBeBjApMiCmMjFjNiCmGjBeJjBpAjHhAiCmMiDhNiBfLiDeOiDfEiDeDiDfJiCpAiNgMjHlGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *			00.01.26 Fukushiro M. _xZkqqHx_jGoOiIpDiCpAiNgMjHlGiBeC_xHqqkZx_
// *			01.04.14 Fukushiro M. _xZkqqHx_jDgIjCnHiClFjAhNiMgAiCmMiPoKiNiHiCpAiNgMjHlGiBeCiKeKiCkCiClNjAhNiMgAiCoA_xHqqkZx_
// *									_xZkqqHx_jDgIjCnHiClJiCoJiCoGiCkEiCmJiCmIiCmBiClNiClNiCnPiBeC_xHqqkZx_
// *************************************************************************/
//static void CalcBezierAndClip (	CPointVector& vlgptPoly,
//								CRect& lgrtClip,
//								const JointSelInfo& jointInf,
//								const JointSeq& jntSeq)
//{
//	const FCObjPoly* pPoly = jointInf.GetObject();
//	// WidePoly_xZkqqHx_iCkJiBeI_xHqqkZx_
//	const BOOL bIsWidePoly = pPoly->IsKindOf(FDOJ_WIDE_POLY);
//
//	//----- _xZkqqHx_jApMjFjNiCmMiMhGiOfKiBeC_xHqqkZx_WidePoly_xZkqqHx_iCmMiPoKiNiHiCmNjBnBiCmMjFjN_xHqqkZx_ -----
//	mmetol mmWeight = pPoly->GetStdPenWeight();
//	mmetol mmPolyWidthF;
//	mmetol mmPolyWidthB;
//	mmetol mmExt;	// _xZkqqHx_jAgDjApMiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCmMiKgHjCkDiDfEiDeDiDfJiBeC_xHqqkZx_
//	if (bIsWidePoly)
//	//----- WidePoly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		FCObjWidePoly* pWidePoly = (FCObjWidePoly*)pPoly;
//		mmPolyWidthF = pWidePoly->GetPolyWidthF();
//		mmPolyWidthB = pWidePoly->GetPolyWidthB();
//		mmetol mmWidth = (mmPolyWidthF < mmPolyWidthB) ? mmPolyWidthB : mmPolyWidthF;
//		// _xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P307_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_1.42 = Root(2.0)
//		mmExt = 1.42 * (mmWidth / 2.0 + mmWeight);
//	} else
//	{
//		mmPolyWidthF = mmWeight;
//		mmPolyWidthB = mmWeight;
//		mmExt = mmWeight / 2.0;
//	}
//	if (mm2lg(mmExt) < FCEditDraw::GetSelMarkSizeHalf())
//		mmExt = FCEditDraw::GetSelMarkSizeHalf();
//
//	//----- _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoI_xHqqkZx_ -----
//	DBLRect mmrtView;
//	g_pView->GetClientRectMM(mmrtView);
//
//	DBLRect mmrtArrowF(0,0,0,0);
//	DBLRect mmrtArrowB(0,0,0,0);
//	if (pPoly->GetIsOpenPolyJoint())
//	//----- _xZkqqHx_iDhMiDiKiDfDiDjDiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiBeFiBeFiBeFjGoOiIpDiCkKiCkAiCoJiJmCjEfMjAkLiCkAiCoI_xHqqkZx_ -----
//	{
//		// GetEdgePoint_xZkqqHx_iCmMiMhGiOfKiCmJiCmNiDfCiDfIiDgHiCkKiCkJiCkJiCoJiCmMiCmFiBeBiCnMiClIiCfAiCmCiCmFiCoAjGoOiIpDiCkKiCkAiCoJiCkJiCmHiCkEiCkJjElLjCgGiBeC_xHqqkZx_
//		DBLPoint mmptEdgeF = jointInf.front().m_mmptPivot;
//		DBLPoint mmptEdgeB = jointInf.back().m_mmptPivot;
//		if (jntSeq.lStart == 0 &&
//			pPoly->GetArrowFType() != FDUG_ARW_TYPE_FLAT)
//		{
//			if (pPoly->GetArrowFType() == FDUG_ARW_TYPE_PICT)
//			{
//				FCPictArrow arrow(pPoly->GetPictArrowF(), bIsWidePoly);
//				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
//				arrow.CalcOuterFrame(mmrtArrowF, mmptEdgeF, mmPolyWidthF, mmWeight);
//			} else
//			{
//				FCStdArrow arrow(FCUGArrowParams(pPoly->GetArrowFType(),
//												pPoly->GetArrowFParam0(),
//												pPoly->GetArrowFParam1(),
//												pPoly->GetArrowFParam2()), bIsWidePoly);
//				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
//				arrow.CalcOuterFrame(mmrtArrowF, mmptEdgeF, mmPolyWidthF, mmWeight);
//			}
//			// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmJjGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCpAiNgMjHlGiBeC_xHqqkZx_
//			mmrtView |= mmrtArrowF;
//		}
//		if (jntSeq.lStart + jntSeq.lSize == pPoly->GetJointSize() - 1 &&
//			pPoly->GetArrowBType() != FDUG_ARW_TYPE_FLAT)
//		{
//			if (pPoly->GetArrowBType() == FDUG_ARW_TYPE_PICT)
//			{
//				FCPictArrow arrow(pPoly->GetPictArrowB(), bIsWidePoly);
//				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
//				arrow.CalcOuterFrame(mmrtArrowB, mmptEdgeB, mmPolyWidthB, mmWeight);
//			} else
//			{
//				FCStdArrow arrow(FCUGArrowParams(pPoly->GetArrowBType(),
//												pPoly->GetArrowBParam0(),
//												pPoly->GetArrowBParam1(),
//												pPoly->GetArrowBParam2()), bIsWidePoly);
//				// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
//				arrow.CalcOuterFrame(mmrtArrowB, mmptEdgeB, mmPolyWidthB, mmWeight);
//			}
//			// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmJjGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCpAiNgMjHlGiBeC_xHqqkZx_
//			mmrtView |= mmrtArrowB;
//		}
//	}
//
//	//----- _xZkqqHx_iLmIjApMiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfK_xHqqkZx_ -----
//	CRect lgrtView = mm2lg(mmrtView);
//	CalcBezier2(vlgptPoly, jointInf.begin(), jointInf.size(), mmExt * 2.0,
//				jntSeq.lStart, jntSeq.lSize, g_->lgdPrecision,
//				g_->dZoom, &lgrtView, 1, StdMinRatio(lgrtView));
//	//----- _xZkqqHx_jFmPiNfIiLmIjApMiCmJiKePjAnKiClHiCoJiLoJiMgAjHmMiIoGiCpAiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoI_xHqqkZx_ -----
//	// _xZkqqHx_jClIjDfPiNmAjFfHiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	FFCalcFrame(lgrtClip, vlgptPoly.size(), vlgptPoly.begin());
//
//	if (jointInf.IsOpen() &&
//		(pPoly->IsFillPainted() ||
//		 (pPoly->GetRichText() != NULL && !pPoly->GetRichText()->IsEmpty())))
//	//----- _xZkqqHx_iKeKiCkCiClNjAhNiMgAiKiOiCmCjAhNiMgAiCmJjDgIjCnHiClFiCkKiCkAiCoJiBeBiIlNiCkCiCmNiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (jntSeq.lStart == 0 || jntSeq.lStart + jntSeq.lSize == jointInf.size() - 1)
//		//----- _xZkqqHx_iInKjDkOjDfPiCmJiBeBjIeBiMiLjDfPiCmMiKeKiOgOjDfPiIlNiCkCiCmNiPeJjHlJjDfPiCkKiKnMiCnMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			//----- _xZkqqHx_jIeBiMiLjDfPiCmMiKeKiOgOjDfPiBeBiPeJjHlJjDfPiCpAiKePjAnKiDhEiDiMiBfLiDiAiCmJiJmBiOfK_xHqqkZx_ -----
//			SmallerOrLarger(lgrtClip.left, lgrtClip.right,
//							mm2lg(jointInf.front().m_mmptPivot.x));
//			SmallerOrLarger(lgrtClip.top, lgrtClip.bottom,
//							mm2lg(jointInf.front().m_mmptPivot.y));
//			SmallerOrLarger(lgrtClip.left, lgrtClip.right,
//							mm2lg(jointInf.back().m_mmptPivot.x));
//			SmallerOrLarger(lgrtClip.top, lgrtClip.bottom,
//							mm2lg(jointInf.back().m_mmptPivot.y));
//		}
//	}
//	// _xZkqqHx_jBnBjFjNjFkKiLoJiMgAiCpAiMpKiCkNiClHiCoJiBeC_xHqqkZx_
//	lgrtClip.InflateRect(mm2lg(mmExt), mm2lg(mmExt));
//	if (!mmrtArrowF.IsRectNull())
//		lgrtClip |= mm2lg(mmrtArrowF);
//	if (!mmrtArrowB.IsRectNull())
//		lgrtClip |= mm2lg(mmrtArrowB);
//	// _xZkqqHx_iPkNiClFjHfNjHfEiCpAiBeC_xHqqkZx_lg2mm(lgrtClip)_xZkqqHx_iCmFiDiKiBfLiDfHiDiHiDjDjAnNjCoIiClHiCoJiNnLiBeB_xHqqkZx_1Pixel_xZkqqHx_iOlIiCoNiCoKiCoJiPoKiNiHiCoAiBeC_xHqqkZx_
//	lgrtClip.InflateRect(1, 1);
//
////----- 02.06.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_jBlNiKhAjApMjGoOiIpDiCmFiBeBiJgFjFhEiCkLiCmMiPoKiNiHiBeBjAhNiMgAjFnCiPfHiDgDiBfLiDiLiCmFjBlNiKhAjApMiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiClNiPoKiNiHiCmJiBeBiJgFjFjEjFkKiCkKiNmEjFgAiJoGiClDiCoKiCmIiCkCiBeC_xHqqkZx_)-----
//	// _xZkqqHx_iJgFiCmMjBoFiCkLiClDiCpAiDeOiDiKiDgCiDhGiCmJjElNiJgGiClDiClJiCoJ_xHqqkZx_ -----
//	if (pPoly->GetShadowSColor() != FD_S_COLOR_UNUSE)
//	//----- _xZkqqHx_iJgFiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iJgFiCmMiDeJiDhEiDfKiDgCiDgHiCkKiJeFjFpLiMpMiCmMiPoKiNiHiBeC_xHqqkZx_
//		if (0 <= g_pEnv->GetShadowLen().x)
//			lgrtClip.right += mm2lg(g_pEnv->GetShadowLen().x);
//		else
//			lgrtClip.left += mm2lg(g_pEnv->GetShadowLen().x);
//
//		// _xZkqqHx_iJgFiCmMiDeJiDhEiDfKiDgCiDgHiCkKiJlKjFpLiMpMiCmMiPoKiNiHiBeC_xHqqkZx_
//		if (0 <= g_pEnv->GetShadowLen().y)
//			lgrtClip.bottom += mm2lg(g_pEnv->GetShadowLen().y);
//		else
//			lgrtClip.top += mm2lg(g_pEnv->GetShadowLen().y);
//	}
////----- 02.06.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_jBlNiKhAjApMjGoOiIpDiCmFiBeBiJgFjFhEiCkLiCmMiPoKiNiHiBeBjAhNiMgAjFnCiPfHiDgDiBfLiDiLiCmFjBlNiKhAjApMiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiClNiPoKiNiHiCmJiBeBiJgFjFjEjFkKiCkKiNmEjFgAiJoGiClDiCoKiCmIiCkCiBeC_xHqqkZx_)-----
//} // CalcBezierAndClip.
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnDraw (CDC* pDC)
//{
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (GetCurrentState())
//	{
////----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	case STATE_MOVING_JOINT:		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
////	  {
////		//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiClNiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
////		DrawSelectedBezier(pDC);
////		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDhDiDhLiDgCiDgHiCmGiIpIjDfPiBeBiIpIjApMiCpAjFgAiJoGiBeC_xHqqkZx_
////		BASE_CLASS::OnDraw(pDC);
////		// _xZkqqHx_iIpIjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
////		JointSelInfoVector::const_iterator iInf;
////		for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
////			(*iInf).DrawPullMark(pDC);
////			break;
////	  }
////----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	case STATE_MOVING_PULL:		// _xZkqqHx_iIpIjDfPiInKjDkOjCiGiBeC_xHqqkZx_
//	  {
//		//----- _xZkqqHx_jApMjFjNiCmMiMhGiOfKiBeC_xHqqkZx_WidePoly_xZkqqHx_iCmMiPoKiNiHiCmNjBnBjFjNiCpAiNgMjHlG_xHqqkZx_ -----
//		fmmetol mmfPenW = GetLineObject(GetHitXXX(XXX_JOINT).first)->GetStdPenWeight();
//		long lgPenW = mm2lg(mmfPenW);
//		//----- WidePoly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
//		if (GetLineObject(GetHitXXX(XXX_JOINT).first)->IsKindOf(FDOJ_WIDE_POLY))
//			lgPenW = 1;
//		CRect lgrtClient;
//		g_pView->GetClientRectLG(lgrtClient);
//		DrawPolyline(pDC, m_vlgptPoint.begin(), m_vlgptPoint.size(), lgPenW, lgrtClient);
//		break;
//	  }
//	}
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDhDiDhLiDgCiDgHiCmGiIpIjDfPiBeBiIpIjApMiCpAjFgAiJoGiBeC_xHqqkZx_
//	BASE_CLASS::OnDraw(pDC);
//} // FCToolPolyEdit::OnDraw.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnObjectProperties
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiCmJiCoGiCmBiCmEjFfMiOkGiClDiCoKiCoJiDiBiDgKiDiFiBfLiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_
 *          _xZkqqHx_jBeJjBpAiCmFiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::OnObjectProperties ()
{
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMiPfHiNiHiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	JointSpecVector vJointSpec;
	JointSelInfoVector::const_iterator iLT;
	for (iLT = m_vPolyLine.begin(); iLT != m_vPolyLine.end(); iLT++)
	{
		const longVector& vSelJtIdx = (*iLT).GetSelJointVector();
		if (!vSelJtIdx.empty())
		{
			vObj.push_back((*iLT).GetObject());
			longVector::const_iterator iSj;
			for (iSj = vSelJtIdx.begin(); iSj != vSelJtIdx.end(); iSj++)
				vJointSpec.push_back(FCJointSpec((*iLT).GetObject(), *iSj));
		}
	}

	if (vJointSpec.empty())
	{
		BASE_CLASS::OnObjectProperties();
	} else
	{
		CFCProPolyJoint	prpJoint;	// _xZkqqHx_jIeBiMiLjDfPiCmMiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiBeC_xHqqkZx_
		prpJoint.SetTargetJoint(vJointSpec);
		// ID_OBJECT_PROPERTIES = "_xZkqqHx_jFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_"
		CFCPrsObjProperty sheet(ID_OBJECT_PROPERTIES);
		CPropertyPageVector vPropPage;
		CPropertyPageVector::const_iterator iPN;
		// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJiDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
		sheet.SetTargetObject(&vObj);
		// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiNoMjAkMiBeC_xHqqkZx_
		(*vObj.begin())->CreatePropertyPage(vPropPage, vObj);
		// _xZkqqHx_iDhJiBfLiDfHiCpAiDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
		for (iPN = vPropPage.begin(); iPN != vPropPage.end(); ++iPN)
			sheet.AddPage(*iPN);
		// _xZkqqHx_iNmFiMoDiCmJjIeBiMiLjDfPiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAjCmHiJmBiBeC_xHqqkZx_
		sheet.AddPage(&prpJoint);
		// _xZkqqHx_jIeBiMiLjDfPiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiDeBiDeOiDgFiDeCiDhFiCmJiClHiCoJiBeC_xHqqkZx_
		sheet.SetActivePage(&prpJoint);
		// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
		sheet.DoModal();
		// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiJpAjFpKiBeC_xHqqkZx_
		for (iPN = vPropPage.begin(); iPN != vPropPage.end(); ++iPN)
			delete *iPN;
	}
} // FCToolPolyEdit::OnObjectProperties.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnSelectObjModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCmFjBeJjBpAjCiGiCmMjFjEjFgJiCkKiBeBiDgDiBfLiDiLiImIiKePiCmMiPoKiPiKiCmFiPeDjAlDiClDiCoKiClNiPoKiNiHiCmJ_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeCjFnCiPfHjHhAiDhNiBfLiDeOiCmMiNmEjFgAiJoGiCmMjFeLjHhGiCmNjGlDiCkCiBgJjFmKjDhCiMmEiCmOiCoKiCoJiInHiBgKiBeC_xHqqkZx_
 *			_xZkqqHx_iDgDiBfLiDiLjCiGiCmJjFjEjFgJiCmMjBkOjAkLiCpAiOmKiClFiOjNiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeBjFjEjFgJiCmJiNiHiCoNiClJiCmE_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiCmFjFjEjFgJiCmMjBkOjAkLiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::OnSelectObjModified ()
{
	// _xZkqqHx_jFjEjFgJiCmMjFmPiNfIiCpA_xHqqkZx_m_vPolyLine_xZkqqHx_iCmJjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
	JointSelInfoVector::iterator iLT;
	for (iLT = m_vPolyLine.begin(); iLT != m_vPolyLine.end(); iLT++)
	{
		(*iLT).UpdateJoint();
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSelectObjModified();
} // FCToolPolyEdit::OnSelectObjModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: CDC*
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	View_xZkqqHx_iCmFjBeJjBpAjCiGiCmMjFjEjFgJiCpAjBfDiCmE_xHqqkZx_m_vPolyLine_xZkqqHx_iCnGjAnNjCoIiClHiCoJiBeCiLmIjApMjFjEjFgJiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiCkKiCkAiCoJiClNiCnPiBeBjCfAiCmIiCoJ_xHqqkZx_ ObjDynabaseVector _xZkqqHx_iCmFiCmNiPiIjHjNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBjDmBiOoKiCmIiDhIiDeOiDfOiBfL_xHqqkZx_ JointSelInfoVector _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::Select (CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_jIeBiMiLjDfPiMjPiNpFiMiLiJmK_xHqqkZx_ -----
//	SetHitXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT));
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	m_iHitJointKnd = FDPK_NONE;	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiIpIjDfPiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
} // FCToolPolyEdit::Select.

//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::DrawSelectMark
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjFfMiOkGiOjOiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBgJjEpBjFfMiOkGiBgKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
// *			pObj:_xZkqqHx_jFfMiOkGiClHiCoJjFjEjFgJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiDeKiDgJiDiBjDfPiDhNiBfLiDeOiCmGiBeBjBeJjBpAjCiGjIeBiMiLjDfPiCmMiIpIjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::DrawSelectMark (CDC* pDC, FCObjDynabase* pObj)
//{
//	// _xZkqqHx_iLmIjApMjFjEjFgJiCmFiCmIiCkCiPoKiNiHiCmNjFgAiJoGiClJiClIjFjMiLeBiBeC_xHqqkZx_
//	if (!pObj->IsKindOf(FDOJ_POLY)) return;
//	JointSelInfoVector::iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//	{
//		if ((*iInf).GetObject() == pObj)
//		{
//			// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMjBfDiCmEiCmMiDeKiDgJiDiBjDfPiCpAjFgAiJoGiBeC_xHqqkZx_
//			(*iInf).FCPolyJointVector::DrawPivotMark(pDC);
//			// _xZkqqHx_jBeJjBpAjCiGiCmMiIpIjDfPiCmMiIpIjApMiCpAjFfMiOkGiBeC_xHqqkZx_
//			(*iInf).DrawPullMark(pDC);
//			break;
//		}
//	}
//} // FCToolPolyEdit::DrawSelectMark.
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnAppendSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::AppendSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::OnAppendSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jBmOiPnLjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!CanHandle(pObj)) return;
	FCObjPoly* pPoly = reinterpret_cast<FCObjPoly*>(pObj);
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJiPfNiCmBiCmEjBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
	DWORD dwIdx = FFAddToLZSorted(m_vPolyLine,
						JointSelInfo(pPoly->GetJointSize(), pPoly->GetJoints(),
									 pPoly->GetIsOpenPolyJoint(), pPoly));
	if (dwIdx == DWORD(-1)) return;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnAppendSelectObj(pDC, pObj);
} // FCToolPolyEdit::OnAppendSelectObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnRemoveSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCkJiCoHjFjEjFgJiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjEpBjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::RemoveSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::OnRemoveSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jBmOiPnLjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!CanHandle(pObj)) return;
//----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnRemoveSelectObj(pDC, pObj);
//----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	JointSelInfoVector::iterator iInf;
	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
	{
		if ((*iInf).GetObject() == pObj)
		//----- _xZkqqHx_iOoGiCoIiPjMiCkNjFjEjFgJiCkKiMkJiCmCiCkJiCmBiClN_xHqqkZx_ -----
		{
			if (iInf - m_vPolyLine.begin() == GetLastSelectedXXX(XXX_JOINT).first)
			//----- _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjApMiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				//----- _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCmMiPoOjFpBiCpAiPiJiKpKiJlL_xHqqkZx_ -----
				// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiJpAiPjMiBeC_xHqqkZx_
				SetLastSelectedXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT));
			}
			// m_vPolyLine_xZkqqHx_iCkJiCoHjFjEjFgJiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
			m_vPolyLine.erase(iInf);
			break;
		}
	}
} // FCToolPolyEdit::OnRemoveSelectObj.

//----- 05.07.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnClearSelectObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAjBfDiCmEjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
// *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::ClearSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
// *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnClearSelectObj (CDC* pDC)
//{
//	if (pDC != NULL)
//	{
//		JointSelInfoVector::iterator iInf;
//		for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//		{
//			// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMiIpIjDfPiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//			(*iInf).DrawPullMark(pDC);
//			// _xZkqqHx_jIeBiMiLjDfPiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//			(*iInf).FCPolyJointVector::DrawPivotMark(pDC);
//		}
//	}
//	// m_vPolyLine_xZkqqHx_iCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_vPolyLine.clear();
////----- 05.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//----- _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCmMiPoOjFpBiCpAiPiJiKpKiJlL_xHqqkZx_ -----
////	m_lLastPolygonIdx = -1;			// _xZkqqHx_jIeBiMiLjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////	m_lLastJointIdx = -1;			// _xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////----- 05.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//} // FCToolPolyEdit::OnClearSelectObj.
//----- 05.07.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlNiCkJiClFiCoHiNoNiPjMiJmCjEfMiCmIiCoAiCmMiCpAjBeJjBpAjCiGiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjElLjCgGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiDiBiDgKiDiFiBfLiCmMjHeMiMpIiBfOjGlDiMpIiCpAjAnIiCoIjBnGiCkGiCoJiClNiCnPiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iNoNiPjMiJmCjEfMiCmIjBeJjBpAjFkIiCkKjHeMiCoJiBeC_xHqqkZx_
 *			FALSE	: _xZkqqHx_iNoNiPjMiJmCjEfMiCmIjBeJjBpAjFkIiCkKjGlDiCkCiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::CanDelete () const
{
	// _xZkqqHx_jAhNiMgAiCpAiDgIiDiJiDgCiDePiClFiCmEiInKjDkOjCiGiCmJ_xHqqkZx_BS_xZkqqHx_iDeMiBfLiCpAiJjPiClHiCmGiCkIiClPiCoJiClNiCnPiBeB_xHqqkZx_Delete_xZkqqHx_iCmFiCkLiCoJ_xHqqkZx_
	// _xZkqqHx_iPpDjBnEiCpAjAkHiMmAiClHiCoJiBeC_xHqqkZx_
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if ((GetCurrentState() != STATE_IDLE) &&
//		(GetCurrentState() != STATE_CONTEXT_MENU)) return FALSE;
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (GetCurrentState() != STATE_IDLE &&
		GetCurrentState() != STATE_CONTEXT_MENU &&
		GetCurrentState() != STATE_CONTEXT_MENU_LINK) return FALSE;
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 05.09.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	JointSelInfoVector::const_iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//	{
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKiCkAiCoKiCmOjAfO_xHqqkZx_.
//		if (!(*iInf).GetSelJointVector().empty()) return TRUE;
//	}
//	return FALSE;
//----- 05.09.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKiCkAiCoKiCmOjAfOiBeC_xHqqkZx_
	return (GetSelectedXXX(XXX_JOINT) != 0);
//----- 05.09.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolPolyEdit::CanDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCpAiNoNiPjMiClHiCoJiBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P305
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.26 Fukushiro M. _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiNmEjFgAiJoGiCpAjCmHiJmBiBeCiOgDiCoIiCmMjDfPiCkKiCfAiCmC_xHqqkZx_
 *								  _xZkqqHx_iImIiJlKiCmMiOjOiCmMjFjEjFgJiNoNiPjMiPiIjHjNiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::OnDelete (CDC* pDC)
{
//----- 02.08.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_jAhNiMgAiCpAiDgIiDiJiDgCiDePiClFiCmEiInKjDkOjCiGiCmJ_xHqqkZx_BS_xZkqqHx_iDeMiBfLiCpAiJjPiClHiCmGiCkIiClPiCoJ_xHqqkZx_)-----
	// Delete_xZkqqHx_iDeMiBfLiCpA_xHqqkZx_IDLE_xZkqqHx_iImIiKePiCmFiLnGiOhOiClHiCoJiBeCiClBiCoKiCpAiClFiCmIiCkCiCmG_xHqqkZx_
	// _xZkqqHx_jAhNiMgAiCpAiDgIiDiJiDgCiDePiClFiCmEiInKjDkOjCiGiCmJ_xHqqkZx_BS_xZkqqHx_iDeMiBfLiCpAiJjPiClHiCmGiCkIiClPiCoJiBeC_xHqqkZx_
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (GetCurrentState() != STATE_IDLE ||
//		GetSelectLocalObjVector().empty()) return;
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (GetCurrentState() != STATE_IDLE &&
		GetCurrentState() != STATE_CONTEXT_MENU &&
		GetCurrentState() != STATE_CONTEXT_MENU_LINK) return;
	if (GetSelectLocalObjVector().empty()) return;
//----- 05.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 02.08.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_jAhNiMgAiCpAiDgIiDiJiDgCiDePiClFiCmEiInKjDkOjCiGiCmJ_xHqqkZx_BS_xZkqqHx_iDeMiBfLiCpAiJjPiClHiCmGiCkIiClPiCoJ_xHqqkZx_)-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiClHiCoJiPiAjEpFiCmGiClFiCmEiLpDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AddEmptyRgn();
	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
	FTMolipSet setMolip;
	// _xZkqqHx_iNoNiPjMiClDiCoKiCoJiCnHiCkLjFjEjFgJiPfHiNiHiBeC_xHqqkZx_
	ObjDynabaseVector vDelObj;
	// _xZkqqHx_iKgFjFjEjFgJiClCiCmGiCmJiBeBjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiNoNiPjMiClFiCmEiCoEiCkNiBeC_xHqqkZx_
	JointSelInfoVector::iterator iInf;
	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
	{
		//----- _xZkqqHx_jIeBiMiLjDfPiNoNiPjMiMoDiCmMiOgDiCoIiCmMjIeBiMiLjDfPjAjEiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if ((*iInf).size() - (*iInf).GetSelJointVector().size() < 2)
		//----- _xZkqqHx_iOgDiCoIiCmMjIeBiMiLjDfPjAjEiCkKiCfBjGkCjGjOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMoDiCmFiNoNiPjMiClHiCoJiInHiCmMiPfHiNiHiCmJjFjEjFgJiCpAjCmHiJmBiBeC_xHqqkZx_
			vDelObj.push_back((*iInf).GetObject());
		} else
		//----- _xZkqqHx_iOgDiCoIiCmMjIeBiMiLjDfPjAjEiCkKiCfBiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iIpIjDfPiCpAjEpBjFfMiOkGiCmJiClHiCoJiBeC_xHqqkZx_
			(*iInf).DrawPullMark(pDC);
			//----- _xZkqqHx_iNoNiPjMiClHiCoJjIeBiMiLjDfPiCmJiKnGjIeBiClHiCoJiDiKiDjDiDeOiCpAiNoNiPjMiClHiCoJ_xHqqkZx_ -----
			// _xZkqqHx_iDiCiDiKiDhGiPoOjFpBjEhKjHpBiCpAjHhAiInDiClHiCoJiBeC_xHqqkZx_
			FCMolipInfoVector vMolipInf;
			g_pDoc->LinkManager()->PrepareMolipInfoVector(vMolipInf, NULL,
											(*iInf).GetObject()->GetMolipCount(),
											(*iInf).GetObject()->GetObjID());
			//----- _xZkqqHx_iNoNiPjMiClHiCoJjIeBiMiLjDfPiCmJiKnGjIeBiClHiCoJiDiCiDiKiDhGiPoOjFpBiCpAiNoNiPjMiClHiCoJ_xHqqkZx_ -----
			FCMolipInfoVector vDelMolipInf;
			longVector::const_reverse_iterator iJ;
			for (iJ = (*iInf).GetSelJointVector().rbegin();
				 iJ != (*iInf).GetSelJointVector().rend(); iJ++)
			{
				const long lMolipId = JointIDtoMolipID(*iJ);
				// _xZkqqHx_iNoNiPjMiClHiCoJjIeBiMiLjDfPiCmMiDiCiDiKiDhGiCmGiClLiCoKiCmJjBlBiCkNiDiCiDiKiDhGiCpAiNoNiPjMjEhKjHpBiCmJjCmHiJmBiBeC_xHqqkZx_
				vDelMolipInf.insert(vDelMolipInf.end(),
									&vMolipInf[lMolipId], &vMolipInf[lMolipId+2]);
				// _xZkqqHx_iNoNiPjMiClHiCoJjIeBiMiLjDfPiCmMiDiCiDiKiDhGiCmGiClLiCoKiCmJjBlBiCkNiDiCiDiKiDhGiCpAiPoOjFpBjEhKjHpBiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
				vMolipInf.erase(&vMolipInf[lMolipId], &vMolipInf[lMolipId+2]);
			}
			// _xZkqqHx_iNoNiPjMiClFiClNiPoOjFpBiCpAjElNiJgGiBeC_xHqqkZx_
			g_pDoc->LinkManager()->DeleteLink(vDelMolipInf, NULL);
			// _xZkqqHx_jFmPiNfIiClFiClNiPoOjFpBiCpAjElNiJgGiBeC_xHqqkZx_
			// Link_xZkqqHx_iNoNiPjM_xHqqkZx_/Link_xZkqqHx_jCmHiJmBiCpAiDfKiDgCiDgHiCmFiOmAiNhDiClHiCoJiPoKiNiHiBeB_xHqqkZx_UpdateLinkConnect _xZkqqHx_iCmNiBeB_xHqqkZx_
			// _xZkqqHx_iNoNiPjMiCmFiIoKiJpBiBeBjCmHiJmBiCmFiIoKiJpBjFmKiBfIiCmJiOmAiNhDiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
			g_pDoc->LinkManager()->UpdateLinkConnect(
							(*iInf).GetObject()->GetObjID(), vMolipInf, NULL);
			// _xZkqqHx_iNoNiPjMjBePiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
			g_pView->AppendToLastRgn((*iInf).GetObject());
			// Tool_xZkqqHx_jDoAjFjEiCmMiDgGiBfLiDfOiCkJiCoHjIeBiMiLjDfPiCpAiNoNiPjMiBeC_xHqqkZx_
			(*iInf).DeleteJoints((*iInf).GetSelJointVector());
			// _xZkqqHx_jFjEjFgJjDoAjFjEiCmMjIeBiMiLjDfPiCmMiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdDeleteJoints((*iInf).GetObject(),
											(*iInf).GetSelJointVector());
			// _xZkqqHx_iNoNiPjMiMoDiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
			g_pView->AppendToLastRgn((*iInf).GetObject());
			// _xZkqqHx_iDiCiDiKiDhGiNoNiPjMiCmJjElKiCkEiDiCiDiKiDhGjFmPiNfIiCpAiLeMjIfOiBeC_xHqqkZx_
			setMolip.insert(FCMolipRec((*iInf).GetObject()->GetObjID(), -1));
			// _xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiDiKiDfIiDgHiCpAiJpAjFpKiBeC_xHqqkZx_
			(*iInf).ClearSelectJoint();
		}
	}
	// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
	g_pDoc->LinkManager()->MovedNotify(setMolip);
	// _xZkqqHx_iNoNiPjMiClHiCnHiCkLjFjEjFgJiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	ObjDynabaseVector::iterator iObj;
	for (iObj = vDelObj.begin(); iObj != vDelObj.end(); iObj++)
	{
		// _xZkqqHx_jBeJjBpAjFjEjFgJiCkJiCoHiCmNiClIiClHiBeCiIpIjApMjDjJiCpAiOgDiClDiCmIiCkCiInHiBeBjBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
		g_pView->RemoveSelectObj(*iObj, pDC);
		// _xZkqqHx_iKnGiMfHiClHiCoJiDiKiDjDiDeOiCpAiNoNiPjMiBeCjDoAjFjEiCmFiDiKiDjDiDeOiNoNiPjMiDfCiDhNiDjDiDgIiCmMiLeMjIfOiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		g_pDoc->LinkManager()->DeleteSoonNotify((*iObj)->GetObjID());
		// _xZkqqHx_iNoNiPjMjBePiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(*iObj);
		// _xZkqqHx_jFjEjFgJiCmMiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
		g_pDoc->MulticmdDelete1Obj(*iObj, g_pDoc->GetCurrentSheetId());
	}
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiDhEiDeIiDjDiDgHiCpAjAkOjHjNiBeC_xHqqkZx_
	if (!vDelObj.empty())
		g_pDoc->MulticmdDeleteUnusedFonts();
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	OnSelectObjModified();
//----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
} // FCToolPolyEdit::OnDelete.

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanSelectAll
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiClHiCnHiCmEjBeJjBpAiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::CanSelectAll () const
//{
//	return !m_vPolyLine.empty();
//} // FCToolPolyEdit::CanSelectAll.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnSelectAll
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiClHiCnHiCmEjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiClHiCnHiCmEjBeJjBpAiBhGiCkJiCoH_xHqqkZx_View_xZkqqHx_iCpAjCmKiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnSelectAll ()
//{
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBjBeJjBpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	JointSelInfoVector::iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//	{
//		for (long lJoint = 0; lJoint < (*iInf).size(); lJoint++)
//		{
//			SelectJoint(*iInf, lJoint, &dc);
//		}
//	}
//} // FCToolPolyEdit::OnSelectAll.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanClearSelect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::CanClearSelect () const
//{
//	JointSelInfoVector::const_iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//	{
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKiCkAiCoKiCmOjAfO_xHqqkZx_.
//		if (!(*iInf).GetSelJointVector().empty()) return TRUE;
//	}
//	return FALSE;
//} // FCToolPolyEdit::CanClearSelect.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnClearSelect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnClearSelect ()
//{
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	UnselectAllXXX(XXX_JOINT, &dc);
//} // FCToolPolyEdit::OnClearSelect.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanObjectAlignObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjAkOjHpBiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_jAkOjHpBiCmMiDfOiDeDiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_ToolBase.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::CanObjectAlignObj (FTAlignType nType) const
//{
////----- 05.09.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	long lCount = 0;
////	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiDeKiDeFiDjDiDgHiClHiCoJiBeC_xHqqkZx_
////	JointSelInfoVector::const_iterator iInf;
////	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
////		lCount += (*iInf).GetSelJointVector().size();
////
////	switch (nType)
////	{
////	case FDAT_ALIGN_V_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
////	case FDAT_ALIGN_H_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
////		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPjAjEiCkK_xHqqkZx_2_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
////		return (2 <= lCount);
////	case FDAT_SAME_GAP_V:		// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
////	case FDAT_SAME_GAP_H:		// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
////		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPjAjEiCkK_xHqqkZx_3_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
////		return (3 <= lCount);
////	}
////	return FALSE;
////----- 05.09.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	switch (nType)
//	{
//	case FDAT_ALIGN_V_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
//	case FDAT_ALIGN_H_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPjAjEiCkK_xHqqkZx_2_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
//		return (2 <= GetSelectedXXX(XXX_JOINT));
//	case FDAT_SAME_GAP_V:		// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//	case FDAT_SAME_GAP_H:		// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPjAjEiCkK_xHqqkZx_3_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
//		return (3 <= GetSelectedXXX(XXX_JOINT));
//	}
//	return FALSE;
////----- 05.09.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCToolPolyEdit::CanObjectAlignObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnObjectAlignObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjAkOjHpBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_jAkOjHpBiCmMiDfOiDeDiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_ToolBase.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnObjectAlignObj (FTAlignType nType)
//{
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjApMiCmMiBeBjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMiIpIjDfPiBeFiIpIjApMiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//	JointSelInfoVector::const_iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//		(*iInf).DrawPullMark(&dc);
//
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//
//	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
//	FTMolipSet setMolip;
//
//	switch (nType)
//	{
//	case FDAT_ALIGN_V_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
//	case FDAT_ALIGN_H_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
//	{
//		//----- _xZkqqHx_iCnMiClIiBeBjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjEhKjHpBiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ -----
//
//		vector<longPair> vSelJoint;	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjEhKjHpBiBeC_xHqqkZx_
//		for (long lPly = 0; lPly < m_vPolyLine.size(); lPly++)
//		//----- _xZkqqHx_jBmOiPnLjFjEjFgJiCmMiDhMiDiKiDfDiDjDiClHiCnHiCmEiCmJjBmOiClFiCmE_xHqqkZx_ -----
//		{
//			longVector::const_iterator iJnt;
//			for (iJnt = m_vPolyLine[lPly].GetSelJointVector().begin();
//				 iJnt != m_vPolyLine[lPly].GetSelJointVector().end(); iJnt++)
//				vSelJoint.push_back(longPair(lPly, *iJnt));
//		}
//
//		//----- _xZkqqHx_iKoOiPiAiCmGiCmIiCoJjIeBiMiLjDfPiCmMiDhMiDiKiDfDiDjDiBeFjIeBiMiLjDfPiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlO_xHqqkZx_ -----
//
////----- 05.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		long lStdPlyIdx = m_lLastPolygonIdx;	// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCmMiDhMiDiKiDfDiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////		long lStdJntIdx = m_lLastJointIdx;		// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCmMjIeBiMiLjDfPiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////----- 05.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		long lStdPlyIdx = GetLastSelectedXXX(XXX_JOINT).first;	// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCmMiDhMiDiKiDfDiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//		long lStdJntIdx = GetLastSelectedXXX(XXX_JOINT).second;	// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCmMjIeBiMiLjDfPiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////----- 05.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiBeBiNmFiPiJiCmMjIeBiMiLjDfPiCpAiOgHiCkEiBeC_xHqqkZx_
//		if (find(vSelJoint.begin(), vSelJoint.end(),
//			longPair(lStdPlyIdx, lStdJntIdx)) == vSelJoint.end())
//		{
//			lStdPlyIdx = vSelJoint.front().first;
//			lStdJntIdx = vSelJoint.front().second;
//		}
//
//		//----- _xZkqqHx_iKgFjIeBiMiLjDfPiCpAiBeBiKoOiPiAiCmMiNmAjFfHiCmJiNiHiCoNiClJiCmEiInKjDkOiClHiCoJ_xHqqkZx_ -----
//
//		vector<longPair>::iterator iiIdx;
//		for (iiIdx = vSelJoint.begin(); iiIdx != vSelJoint.end(); iiIdx++)
//		{
//			if (iiIdx->first == lStdPlyIdx && iiIdx->second == lStdJntIdx)
//				continue;
//			FCObjPoly* objp = m_vPolyLine[iiIdx->first].GetObject();
//			DBLPoint mmptMov =
//						m_vPolyLine[lStdPlyIdx][lStdJntIdx].m_mmptPivot -
//						m_vPolyLine[iiIdx->first][iiIdx->second].m_mmptPivot;
//
//			if (nType == FDAT_ALIGN_V_CENTER)
//			{
//				mmptMov.y = 0.0;		// _xZkqqHx_jCiGiJjLiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
//			} else
//			{
//				mmptMov.x = 0.0;		// _xZkqqHx_jCiGiJjLiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
//			}
//			// _xZkqqHx_jFmPiNfIjBePiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn(objp);
//			longVector vJointIdx(1, iiIdx->second);
//			g_pDoc->CmdMoveJoints(objp, vJointIdx, mmptMov);
//			m_vPolyLine[iiIdx->first][iiIdx->second].m_mmptPivot += mmptMov;
//			// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiCmJjElKiCkEiDiCiDiKiDhGjFmPiNfIiCpAiLeMjIfOiBeC_xHqqkZx_
//			setMolip.insert(FCMolipRec(objp->GetObjID(), -1));
//			// _xZkqqHx_jFmPiNfIiMoDiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn(objp);
//		}
//		break;
//	}
//	case FDAT_SAME_GAP_V:		// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//	case FDAT_SAME_GAP_H:		// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//	{
//		multimap<double, longPair> mmpJnt;
//		//------ _xZkqqHx_iCnMiClIiBeBiDhNiDiLiDgAiDhNiDgCiDhGiCpAjHjIjHhAiClFiCmEiKoOiPiAiImKjChFiCmMiPkMiClDiCkCiPiHiCmJjFjEjFgJiCpAjFmAiCnHiCoJ_xHqqkZx_ -----
//		for (long lPly = 0; lPly < m_vPolyLine.size(); lPly++)
//		{
//			longVector::const_iterator iJnt;
//			for (iJnt = m_vPolyLine[lPly].GetSelJointVector().begin();
//				 iJnt != m_vPolyLine[lPly].GetSelJointVector().end(); iJnt++)
//			{
//				if (nType == FDAT_SAME_GAP_V)	// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//					mmpJnt.insert(pair<double, longPair>(
//											m_vPolyLine[lPly][*iJnt].m_mmptPivot.y,
//											longPair(lPly, *iJnt)));
//				else	// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//					mmpJnt.insert(pair<double, longPair>(
//											m_vPolyLine[lPly][*iJnt].m_mmptPivot.x,
//											longPair(lPly, *iJnt)));
//			}
//		}
//		const double mmA0 = mmpJnt.begin()->first;
//		const double mmAn = mmpJnt.rbegin()->first;
//		const double mmGap = (mmAn - mmA0) / (mmpJnt.size() - 1);
//		multimap<double, longPair>::iterator idll;
//		long lC;
//		for (idll = mmpJnt.begin(), idll++, lC = 1;
//			 lC < mmpJnt.size() - 1; idll++, lC++)
//		{
//			double mmNewA = mmA0 + lC * mmGap;
//			FCObjPoly* objp = m_vPolyLine[idll->second.first].GetObject();
//			DBLPoint mmptMov(0,0);
//			if (nType == FDAT_SAME_GAP_V)	// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//				mmptMov.y = mmNewA -
//					m_vPolyLine[idll->second.first][idll->second.second].m_mmptPivot.y;
//			else	// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//				mmptMov.x = mmNewA -
//					m_vPolyLine[idll->second.first][idll->second.second].m_mmptPivot.x;
//			// _xZkqqHx_jFmPiNfIjBePiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn(objp);
//			longVector vJointIdx(1, idll->second.second);
//			g_pDoc->CmdMoveJoints(objp, vJointIdx, mmptMov);
//			m_vPolyLine[idll->second.first][idll->second.second].m_mmptPivot += mmptMov;
//			// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiCmJjElKiCkEiDiCiDiKiDhGjFmPiNfIiCpAiLeMjIfOiBeC_xHqqkZx_
//			setMolip.insert(FCMolipRec(objp->GetObjID(), -1));
//			// _xZkqqHx_jFmPiNfIiMoDiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn(objp);
//		}
//		break;
//	}
//	}
//	// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify(setMolip);
//
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
////----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	OnSelectObjModified();
////----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjApMiCmMiBeBjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMiIpIjDfPiBeFiIpIjApMiCpAjFfMiOkGiBeC_xHqqkZx_
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//		(*iInf).DrawPullMark(&dc);
//
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
//} // FCToolPolyEdit::OnObjectAlignObj.
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanObjectInsertJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCkKjBhNjDpMiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.08.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::CanObjectInsertJoint () const
{
	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIiJmCjEfMiCmIiCoHiCmOiJmCiBeC_xHqqkZx_
	return FFCanEditSelected();
//----- 06.11.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (FFCanEditSelected())
//	//----- _xZkqqHx_jFjEjFgJiCkKjFmPiNfIiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjIeBiMiLjDfPiCkKiCePiCkJiCfAiCmMiPoKiNiHiCmMiCnNiJmCiBeC_xHqqkZx_
//		if (GetSelectedXXX(XXX_JOINT) < 2)
//			return TRUE;
//	}
//	return FALSE;
//----- 06.11.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolPolyEdit::CanObjectInsertJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnObjectInsertJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCpAjBhNjDpMiClHiCoJiBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302,P303,P304
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.08.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::OnObjectInsertJoint ()
{
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//
////----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jBhNjDpMjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
//	DBLPoint mmptClicked = g_pView->GetLastPoint();
//	// _xZkqqHx_iCoAiClFjBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCkKiCfAiCmCiCkAiCoJiPoKiNiHiCmNiBeBiClLiCmMjDfPiCpAjBhNjDpMjDfPiCmJiBeC_xHqqkZx_
//	vector<longPair> vSelJoint;
//	GetSelectedXXX(XXX_JOINT, &vSelJoint);
//	if (vSelJoint.size() == 1)
//		mmptClicked = GetFrameRectXXX(XXX_JOINT, vSelJoint.front()).GetLeftTop();
////----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
//	UnselectXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT), &dc);
//
//	double dMinPowLen = DBL_MAX;
//	JointSelInfoVector::iterator iTargetInf;
//	long lTargetJoint;				// Q_xZkqqHx_iCkKjBkOiClHiCoJjIeBiMiLjDfPiCmM_xHqqkZx_ID_xZkqqHx_iBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P303_xZkqqHx_iCmMjHoBiCmFiCmN_xHqqkZx_C1_xZkqqHx_iBgJjBkGiClP_xHqqkZx_1_xZkqqHx_iBgKiCmFiCkAiCoJiBeC_xHqqkZx_
//	double dTargetT;				// Q_xZkqqHx_iCmMiOjOiNiP_xHqqkZx_(_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302)_xZkqqHx_iBeC_xHqqkZx_
//	DBLPoint mmptTargetQ;			// Q_xZkqqHx_iCmMiNmAjFfH_xHqqkZx_(_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302)_xZkqqHx_iBeC_xHqqkZx_
//	FCBezierControls bcTarget;		// C1-C2_xZkqqHx_iCmMiDhIiDfHiDeG_xHqqkZx_(_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302)_xZkqqHx_iBeC_xHqqkZx_
//
//	JointSelInfoVector::iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//	//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCpAiDiLiBfLiDhG_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jIeBiMiLjDfPjEhKjHpBiCpA_xHqqkZx_FCBezierControlsVector_xZkqqHx_iMfOiCmJjFmPiKlHiBeC_xHqqkZx_
//		FCBezierControlsVector vControls;
//		FFControlConv(vControls, (*iInf).begin(), (*iInf).size(), (*iInf).IsOpen());
//		// _xZkqqHx_iDhNiDeFiDfIiCmFiDeOiDiKiDgCiDeOiClDiCoKiClNiPoKiPiKiCmJiIoKjEnEiLnPiCkCiDhIiDfHiDeGiLmIjApMiCmMiNmAjFfHiChAiCmGiClLiCmMiOjOiNiPiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
//		long lControlIndex;	// _xZkqqHx_iIoKjEnEiLnPiCkCiDhIiDfHiDeGiLmIjApMiCmM_xHqqkZx_vControls_xZkqqHx_jEhKjHpBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//		double dT;			// _xZkqqHx_iDhIiDfHiDeGiLmIjApM_xHqqkZx_ vControls[lControlIndex] _xZkqqHx_jCiGiCmMiChAiCmMiOjOiNiPiBeC_xHqqkZx_
//		DBLPoint mmptQ;		// _xZkqqHx_iIoKjEnEiLnPiCkCiDhIiDfHiDeGiLmIjApMiCmMiNmAjFfHiChAiBeC_xHqqkZx_
//// 06.10.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		FFCalcT(lControlIndex, dT, mmptQ, vControls, g_pView->GetLastPoint());
//		FFCalcT(lControlIndex, dT, mmptQ, vControls, mmptClicked);
//		// _xZkqqHx_iChAiCmGiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCmMjDpBiPoGiBeC_xHqqkZx_
//// 06.10.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		double dPowLen = (mmptQ - g_pView->GetLastPoint()).PowLen();
//		double dPowLen = (mmptQ - mmptClicked).PowLen();
//		//----- _xZkqqHx_iNmFiPkMiCmMiLjHjHkDiCpAiOjNiCmCjApMjFkKiCmMiPoOjFpBiCpAiLeMjIfO_xHqqkZx_ -----
//		if (dPowLen < dMinPowLen)
//		//----- _xZkqqHx_iClBiCoKiCnMiCmFiCmMjFjEjFgJiCoGiCoIiBeBiCoGiCoIiChAiCmJiLnPiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			dMinPowLen = dPowLen;
//			iTargetInf = iInf;						// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiBeC_xHqqkZx_
//			lTargetJoint = lControlIndex;			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiDhIiDfHiDeGjIeBiMiLjDfPiBeC_xHqqkZx_
//			dTargetT = dT;							// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiOjOiNiPiBeC_xHqqkZx_
//			mmptTargetQ = mmptQ;					// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiNmAjFfHiBeC_xHqqkZx_
//			bcTarget = vControls[lControlIndex];	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPiBeC_xHqqkZx_
//		}
//	}
//	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiDhIiDfHiDeGiLmIjApMiCpAiBeBiChAiCmMiImKjChFiCpAiLkLiCmJjDpBiCmCiCmJjFkKiKiEiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iClLiCmMiNnLiBeBiClLiCoKiCnMiCmFiCmMiLmIjApMiMgAiPpDiCmGjDkPiClGiCmJiCmIiCoJiCoGiCkEiCmIiBeBjAkHiMoEjDfPiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
//	FCBezierControls bcChopped1;	// _xZkqqHx_iChAiCpAiLkLiCmJjBePjElMiCmMiDhIiDfHiDeGiLmIjApMiBeC_xHqqkZx_
//	FCBezierControls bcChopped2;	// _xZkqqHx_iChAiCpAiLkLiCmJiMoDjElMiCmMiDhIiDfHiDeGiLmIjApMiBeC_xHqqkZx_
//	FFChopBezier(bcChopped1, bcTarget, 0.0, dTargetT);
//	FFChopBezier(bcChopped2, bcTarget, dTargetT, 1.0);
//
//	// _xZkqqHx_iCoNiCkJiCoIiCoCiClHiCkNiClHiCoJiClNiCnPiBeBjFmPjAjEiCpAjHhAiInDiBeC_xHqqkZx_
//	const FCPolyJoint& jsiPrev = (*iTargetInf)[lTargetJoint];			// _xZkqqHx_jIeBiMiLjDfPiCpAjBhNjDpMiClHiCoJjClMjBePiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
//	const FCPolyJoint& jsiNext = (lTargetJoint == (*iTargetInf).size() - 1) ?
//								(*iTargetInf)[0] : (*iTargetInf)[lTargetJoint + 1];		// _xZkqqHx_jIeBiMiLjDfPiCpAjBhNjDpMiClHiCoJjClMiMoDiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
//	const DBLPoint mmptPrevJointNext = bcChopped1.B() - bcChopped1.A();	// _xZkqqHx_jClMjBePiCmMjIeBiMiLjDfPiCmMiMoDiIpIjDfPiBeC_xHqqkZx_
//	const DBLPoint mmptNextJointPrev = bcChopped2.C() - bcChopped2.D();	// _xZkqqHx_jClMjBePiCmMjIeBiMiLjDfPiCmMjBePiIpIjDfPiBeC_xHqqkZx_
//	DBLPoint mmptJointPrev = bcChopped1.C() - bcChopped1.D();		// _xZkqqHx_jBhNjDpMiClHiCoJjIeBiMiLjDfPiCmMjBePiIpIjDfPiBeC_xHqqkZx_
//	DBLPoint mmptJointNext = bcChopped2.B() - bcChopped2.A();		// _xZkqqHx_jBhNjDpMiClHiCoJjIeBiMiLjDfPiCmMiMoDiIpIjDfPiBeC_xHqqkZx_
//
//	BOOL bIsSetPull = TRUE;	// _xZkqqHx_iIpIjDfPiCpAiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
//	// _xZkqqHx_jBhNjDpMjClMjBePiCmMjIeBiMiLjDfPiCmMiMoDiIpIjDfPiBeBjClMiMoDiCmMjBePiIpIjDfPiCkKiInKjDkOiClDiCoKiCmIiCkCiCmIiCoHiCgFiCgAiCgLiChCiCgEiBeC_xHqqkZx_
//	if (almosteq(jsiPrev.m_mmptNext, mmptPrevJointNext) &&
//		almosteq(jsiNext.m_mmptPrev, mmptNextJointPrev))
//		bIsSetPull = FALSE;	// _xZkqqHx_iIpIjDfPiCpAiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
//	// _xZkqqHx_jBhNjDpMjClMjBePiCmMjIeBiMiLjDfPiCmMiMoDiIpIjDfPiCpAiInKjDkOiClHiCoJiPoKiNiHiBjF_xHqqkZx_
//	// _xZkqqHx_iMoDiIpIjDfPiBiBiCePiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiCgFiCgAiCgLiChCiCgEiBeC_xHqqkZx_
//	if (!almosteq(jsiPrev.m_mmptNext, mmptPrevJointNext) &&
//		jsiPrev.m_nType & FDJT_PST_PULL_0 != 0)
//		bIsSetPull = FALSE;
//	// _xZkqqHx_jBhNjDpMjClMiMoDiCmMjIeBiMiLjDfPiCmMjBePiIpIjDfPiCpAiInKjDkOiClHiCoJiPoKiNiHiBjF_xHqqkZx_
//	// _xZkqqHx_jBePiIpIjDfPiBiBiCePiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiCgFiCgAiCgLiChCiCgEiBeC_xHqqkZx_
//	if (!almosteq(jsiNext.m_mmptPrev, mmptNextJointPrev) &&
//		jsiNext.m_nType & FDJT_PRE_PULL_0 != 0)
//		bIsSetPull = FALSE;
//
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiClHiCoJiPiAjEpFiCmGiClFiCmEiLpDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AddEmptyRgn();
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//
//	//----- _xZkqqHx_jBhNjDpMiClHiCoJjIeBiMiLjDfPiCmJiKnGjIeBiClHiCoJiDiCiDiKiDhGiCpAjBhNjDpMiClHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_iDiCiDiKiDhGiPoOjFpBjEhKjHpBiCpAjHhAiInDiClHiCoJiBeC_xHqqkZx_
//	FCMolipInfoVector vMolipInf;
//	g_pDoc->LinkManager()->PrepareMolipInfoVector(	vMolipInf, NULL,
//													(*iTargetInf).GetObject()->GetMolipCount(),
//													(*iTargetInf).GetObject()->GetObjID());
//	long lMolipId;	// _xZkqqHx_jBhNjDpMiDiCiDiKiDhGjClMiMoDiCmMiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	if (dTargetT <= 0.5)	// _xZkqqHx_iDfAiBfLiDfI_xHqqkZx_B(_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P303)_xZkqqHx_iBeC_xHqqkZx_
//		lMolipId = JointIDtoMolipID(lTargetJoint) + 1;
//	else					// _xZkqqHx_iDfAiBfLiDfI_xHqqkZx_A(_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P303)_xZkqqHx_iBeC_xHqqkZx_
//		lMolipId = JointIDtoMolipID(lTargetJoint + 1);
//	// _xZkqqHx_jIeBiMiLjDfPjBhNjDpMiCmJjElKiCkEiDiCiDiKiDhGiCpAjBhNjDpMiBeC_xHqqkZx_
//	vMolipInf.insert(vMolipInf.begin() + lMolipId, 2, FCMolipInfo());
//	// _xZkqqHx_jFmPiNfIiClFiClNiPoOjFpBiCpAjElNiJgGiBeC_xHqqkZx_
//	// Link_xZkqqHx_iNoNiPjM_xHqqkZx_/Link_xZkqqHx_jCmHiJmBiCpAiDfKiDgCiDgHiCmFiOmAiNhDiClHiCoJiPoKiNiHiBeB_xHqqkZx_UpdateLinkConnect _xZkqqHx_iCmNiBeB_xHqqkZx_
//	// _xZkqqHx_iNoNiPjMiCmFiIoKiJpBiBeBjCmHiJmBiCmFiIoKiJpBjFmKiBfIiCmJiOmAiNhDiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->UpdateLinkConnect(
//							(*iTargetInf).GetObject()->GetObjID(), vMolipInf, NULL);
//
//	// _xZkqqHx_jFmPiNfIjBePiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AppendToLastRgn((*iTargetInf).GetObject());
//	if (bIsSetPull)
//	//----- _xZkqqHx_iMlDiCmMiLmIjApMiCmGjDkPiClGiCmJiCmIiCoJiCoGiCkEiBeBiIpIjApMiCpAjClCjAkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		FCPolyJointRec rec;
//		// _xZkqqHx_jClMjBePiCmMjIeBiMiLjDfPiCmMiMoDiIpIjDfPiCpAjFmPiNfIiBeC_xHqqkZx_
//		(*iTargetInf)[lTargetJoint].m_mmptNext = mmptPrevJointNext;
//		rec.wMask = FDFP_NEXTPULLX | FDFP_NEXTPULLY;
//		rec.mmNextPullX = mmptPrevJointNext.x;
//		rec.mmNextPullY = mmptPrevJointNext.y;
//		g_pDoc->CmdModifyPolyJoint((*iTargetInf).GetObject(), lTargetJoint, rec);
//
//		// _xZkqqHx_jClMiMoDiCmMjIeBiMiLjDfPiCmMiMoDiIpIjDfPiCpAjFmPiNfIiBeC_xHqqkZx_
//		long lTargetNext = (lTargetJoint == (*iTargetInf).size() - 1) ? 0 : lTargetJoint + 1;
//		(*iTargetInf)[lTargetNext].m_mmptPrev = mmptNextJointPrev;
//		rec.wMask = FDFP_PREVPULLX | FDFP_PREVPULLY;
//		rec.mmPrevPullX = mmptNextJointPrev.x;
//		rec.mmPrevPullY = mmptNextJointPrev.y;
//		g_pDoc->CmdModifyPolyJoint((*iTargetInf).GetObject(), lTargetNext, rec);
//	} else
//	//----- _xZkqqHx_iIpIjApMiCpAjClCjAkOiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		mmptJointPrev.SetPoint(0, 0);
//		mmptJointNext.SetPoint(0, 0);
//	}
//	// _xZkqqHx_jBhNjDpMiClHiCoJjIeBiMiLjDfPiCpAiNoMjAkMiBeCjBhNjDpMjClMjBePiCmMjIeBiMiLjDfPiCmMiDfOiDeDiDhGiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	FCPolyJoint pjNew(	(*iTargetInf)[lTargetJoint].m_nType,
//						mmptTargetQ,
//						mmptJointPrev,
//						mmptJointNext);
//	if (!almost0(mmptJointPrev) || !almost0(mmptJointNext))
//		pjNew.m_nType = FDJT_ROUND;
//	// _xZkqqHx_jIeBiMiLjDfPiCpAjBhNjDpMiBeC_xHqqkZx_
//	(*iTargetInf).insert(&(*iTargetInf)[lTargetJoint + 1], pjNew);
//	// _xZkqqHx_jFjEjFgJjDoAjFjEiCmMjIeBiMiLjDfPiCmMjBhNjDpMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//	g_pDoc->CmdInsertJoints((*iTargetInf).GetObject(), lTargetJoint + 1, 1, &pjNew);
//	// _xZkqqHx_jFmPiNfIiMoDiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AppendToLastRgn((*iTargetInf).GetObject());
//	// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify((*iTargetInf).GetObject());
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	OnSelectObjModified();
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
////----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jBhNjDpMiClDiCoKiClNjIeBiMiLjDfPiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
//	SelectXXX(XXX_JOINT, longPair(iTargetInf - m_vPolyLine.begin(), lTargetJoint + 1), &dc);
////----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);

	// _xZkqqHx_jBhNjDpMjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
	DBLPoint mmptClicked = g_pView->GetLastPoint();
	// _xZkqqHx_iCoAiClFjBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCkKiCfAiCmCiCkAiCoJiPoKiNiHiCmNiBeBiClLiCmMjDfPiCpAjBhNjDpMjDfPiCmJiBeC_xHqqkZx_
	vector<longPair> vSelJoint;
	GetSelectedXXX(XXX_JOINT, &vSelJoint);
	if (vSelJoint.size() == 1)
		mmptClicked = GetFrameRectXXX(XXX_JOINT, vSelJoint.front()).GetLeftTop();

	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	UnselectXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT), &dc);

	double dMinPowLen = DBL_MAX;
	long lTargetPoly;		// Q_xZkqqHx_iCkKjBkOiClHiCoJjBlNiKhAjApMjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeCiBeC_xHqqkZx_
	long lTargetBezier;		// Q_xZkqqHx_iCkKjBkOiClHiCoJjIeBiMiLjDfPiCmM_xHqqkZx_ID_xZkqqHx_iBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P303_xZkqqHx_iCmMjHoBiCmFiCmN_xHqqkZx_C1_xZkqqHx_iBgJjBkGiClP_xHqqkZx_1_xZkqqHx_iBgKiCmFiCkAiCoJiBeC_xHqqkZx_
	double dTargetT;		// Q_xZkqqHx_iCmMiOjOiNiP_xHqqkZx_(_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302)_xZkqqHx_iBeC_xHqqkZx_
	DBLPoint mmptTargetQ;	// Q_xZkqqHx_iCmMiNmAjFfH_xHqqkZx_(_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302)_xZkqqHx_iBeC_xHqqkZx_

	long lIndex;
	for (lIndex = 0; lIndex != m_vPolyLine.size(); lIndex++)
	//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_jIeBiMiLjDfPjEhKjHpBiCpA_xHqqkZx_FCBezierControlsVector_xZkqqHx_iMfOiCmJjFmPiKlHiBeC_xHqqkZx_
		FCBezierControlsVector vControls;
		FFControlConv(	vControls,
						m_vPolyLine[lIndex].GetPtr(),
						m_vPolyLine[lIndex].GetSize(),
						m_vPolyLine[lIndex].IsOpen());
		// _xZkqqHx_iDhNiDeFiDfIiCmFiDeOiDiKiDgCiDeOiClDiCoKiClNiPoKiPiKiCmJiIoKjEnEiLnPiCkCiDhIiDfHiDeGiLmIjApMiCmMiNmAjFfHiChAiCmGiClLiCmMiOjOiNiPiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
		long lControlIndex;		// _xZkqqHx_iIoKjEnEiLnPiCkCiDhIiDfHiDeGiLmIjApMiCmM_xHqqkZx_vControls_xZkqqHx_jEhKjHpBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
		double dT;				// _xZkqqHx_iDhIiDfHiDeGiLmIjApM_xHqqkZx_ vControls[lControlIndex] _xZkqqHx_jCiGiCmMiChAiCmMiOjOiNiPiBeC_xHqqkZx_
		DBLPoint mmptQ;			// _xZkqqHx_iIoKjEnEiLnPiCkCiDhIiDfHiDeGiLmIjApMiCmMiNmAjFfHiChAiBeC_xHqqkZx_
		FFCalcT(lControlIndex, dT, mmptQ, vControls, mmptClicked);
		// _xZkqqHx_iChAiCmGiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCmMjDpBiPoGiBeC_xHqqkZx_
		double dPowLen = (mmptQ - mmptClicked).PowLen();
		//----- _xZkqqHx_iNmFiPkMiCmMiLjHjHkDiCpAiOjNiCmCjApMjFkKiCmMiPoOjFpBiCpAiLeMjIfO_xHqqkZx_ -----
		if (dPowLen < dMinPowLen)
		//----- _xZkqqHx_iClBiCoKiCnMiCmFiCmMjFjEjFgJiCoGiCoIiBeBiCoGiCoIiChAiCmJiLnPiCkCiPoKiNiH_xHqqkZx_ -----
		{
			dMinPowLen = dPowLen;
			lTargetPoly = lIndex;					// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiBeC_xHqqkZx_
			lTargetBezier = lControlIndex;			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiDhIiDfHiDeGjIeBiMiLjDfPiBeC_xHqqkZx_
			dTargetT = dT;							// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiOjOiNiPiBeC_xHqqkZx_
			mmptTargetQ = mmptQ;					// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiNmAjFfHiBeC_xHqqkZx_
		}
	}
	// _xZkqqHx_jIeBiMiLjDfPiCpAiImKjChFiChAiCmJjBhNjDpMiBeC_xHqqkZx_
	longPair newJoint = InsertJoint(lTargetPoly, lTargetBezier, dTargetT, mmptTargetQ);
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	// _xZkqqHx_jBhNjDpMiClDiCoKiClNjIeBiMiLjDfPiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
	SelectXXX(XXX_JOINT, newJoint, &dc);
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolPolyEdit::OnObjectInsertJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanObjectConnect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnKjBlBiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_jBeJjBpAjCiGiCmMjDfPiCkKjAnKjBlBiJmCjEfM_xHqqkZx_
 *			FALSE	: _xZkqqHx_jBeJjBpAjCiGiCmMjDfPiCkKjAnKjBlBjFhDiJmCjEfM_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::CanObjectConnect () const
{
	JointSelInfoVector::const_iterator iInf;
	FCObjPoly*	paPly[2];	// _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCmMjBkOiClHiCoJjFjEjFgJiBeC_xHqqkZx_
	long		laJnt[2];	// _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	short		nIndex = 0;

	//----- _xZkqqHx_jBmOiPnLjFjEjFgJiClHiCnHiCmEiCmJjBmOiClFiCmE_xHqqkZx_ -----
	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
	{
		longVector::const_iterator	iIdx;
		for (iIdx = (*iInf).GetSelJointVector().begin();
			 iIdx != (*iInf).GetSelJointVector().end(); iIdx++)
		{
			// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKiCfCiCmCiImIiPoDiCkAiCoJiOjOiCmNjIeBiMiLjFhDiJmCjEfMiBeC_xHqqkZx_
			if (2 <= nIndex) return FALSE;
			//----- _xZkqqHx_jIeBiMiLjDfPiCmMjFjEjFgJiCmGiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiClHiCoJ_xHqqkZx_ -----
			paPly[nIndex] = (*iInf).GetObject();
			laJnt[nIndex] = *iIdx;
			nIndex++;
		}
	}
	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKiCfBiMmCiCmFiCmIiCkCiPoKiNiHiBgJiCfAiMmCiBeBiCePiMmCiBgKiCmNjFhDiJmCiBeC_xHqqkZx_
	if (nIndex != 2) return FALSE;
	// _xZkqqHx_jFmCiLmIjApMiCmMiPoKiNiHiCmNjIeBiMiLjFhDiJmCjEfMiBeC_xHqqkZx_
	if (!paPly[0]->GetIsOpenPolyJoint()) return FALSE;
	if (!paPly[1]->GetIsOpenPolyJoint()) return FALSE;
	// _xZkqqHx_jIeBiMiLjDfPiCkKjGjGjCfLiCmFjGlDiCkCiPoKiNiHiCmNjIeBiMiLjFhDiJmCjEfMiBeC_xHqqkZx_
	if (laJnt[0] != 0 && laJnt[0] != paPly[0]->GetJointSize() -1) return FALSE;
	if (laJnt[1] != 0 && laJnt[1] != paPly[1]->GetJointSize() -1) return FALSE;
	if (paPly[0] == paPly[1])
	// _xZkqqHx_jDkPiClGjFjEjFgJiCmMjHlMjCfLiCpAjAnKjBlBiClHiCoJiPoKiNiHiBeC_xHqqkZx_
	{
		// _xZkqqHx_iDhMiDiKiDfDiDjDjApMjHlMjCfLiCmMjAnKjBlBiBeFjAnKjBlBiJpAiPjMiCkKjAnNjCoIiCmFiCkLiCmIiCkCiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
		if (!paPly[0]->CanSetOpenPolyJoint()) return FALSE;
	}
	return TRUE;
} // FCToolPolyEdit::CanObjectConnect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnObjectConnect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCpAjAnKjBlBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.20 Fukushiro M. _xZkqqHx_jAnKjBlBiCmJjElKiCkEiDiKiDjDiDeOjFmPiNfIiCmJjBmOiJjOiBeC_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::OnObjectConnect ()
{
	FCObjPoly*	paPly[2];	// _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCmMjBkOiClHiCoJjFjEjFgJiBeC_xHqqkZx_
	long		laJnt[2];	// _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	short		nIndex = 0;

	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCePiCmGjIeBiMiLjDfPiCfAiCmMiPoOjFpBiCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
	JointSelInfoVector::iterator iInf;
	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
	{
		longVector::const_iterator iIdx;
		for (iIdx = (*iInf).GetSelJointVector().begin();
			 iIdx != (*iInf).GetSelJointVector().end(); iIdx++)
		{
			ASSERT(nIndex < 2);	// _xZkqqHx_iDeHiDiJiBfLiBeCjHeMiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
			//----- _xZkqqHx_jIeBiMiLjDfPiCmMjFjEjFgJiCmGiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiClHiCoJ_xHqqkZx_ -----
			paPly[nIndex] = (*iInf).GetObject();
			laJnt[nIndex] = *iIdx;
			nIndex++;
		}
	}
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
// 05.07.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	UnselectAllXXX(XXX_JOINT, &dc);
	UnselectXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT), &dc);
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	if (paPly[0] == paPly[1])
	//----- _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCkKjDkPiClGjFjEjFgJiPoDiBeBjBkGiClPiCfAiCmCiCmMjFjEjFgJiCmMjHlMjCfLiCmFiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iCfAiDhMiDiKiDfDiDjDjFjEjFgJjHlMjCfLjAnKjBlBiDfCiDhNiDjDiDgI_xHqqkZx_ -----
		FCPolyLinkRec plRec;
		plRec.wMask = FDFP_ISOPENPOLYJOINT;
		plRec.bIsOpenPolyJoint = FALSE;
		g_pDoc->CmdModifyPolyLink(paPly[0], plRec);
	} else
	//----- _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCkKiInJiCmIiCoJjFjEjFgJiPoDiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// View_xZkqqHx_iCmG_xHqqkZx_m_vPolyLine_xZkqqHx_iCkJiCoHiCfBjEnEjGnKiCmMjFjEjFgJiCmMjBeJjBpAiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
		g_pView->RemoveSelectObj(paPly[1], TRUE);
		// _xZkqqHx_iCfBjEnEjGnKiCmMjFjEjFgJiCmMjIeBiMiLjDfPiCpAiDiPiBfLiDeOiCmJiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
		FCPolyJointVector vJoint;
		vJoint.insert(vJoint.end(), paPly[1]->GetJoints(),
						paPly[1]->GetJoints() + paPly[1]->GetJointSize());
		// _xZkqqHx_iDiCiDiKiDhGiPoOjFpBjEhKjHpBiCpAjHhAiInDiClHiCoJiBeC_xHqqkZx_
		FCMolipInfoVector vMolipInf0;
		FCMolipInfo molipInf0;
		g_pDoc->LinkManager()->PrepareMolipInfoVector(vMolipInf0, &molipInf0,
													paPly[0]->GetMolipCount(),
													paPly[0]->GetObjID());
		FCMolipInfoVector vMolipInf1;
		FCMolipInfo molipInf1;
		g_pDoc->LinkManager()->PrepareMolipInfoVector(vMolipInf1, &molipInf1,
													paPly[1]->GetMolipCount(),
													paPly[1]->GetObjID());
		// _xZkqqHx_jFjEjFgJiCfAiCmMjCiGjAfDiDiCiDiKiDhGiCmGjIeBiMiLiClHiCoJiDiKiDjDiDeOiCpAjBfDiCmEjFjEjFgJiCePiCmMjCiGjAfDiDiCiDiKiDhGiCnGiInKjDkOiBeC_xHqqkZx_
		molipInf0.vLinkFrom.insert(molipInf0.vLinkFrom.end(),
									molipInf1.vLinkFrom.begin(),
									molipInf1.vLinkFrom.end());
		molipInf0.vLinkTo.insert(molipInf0.vLinkTo.end(),
									molipInf1.vLinkTo.begin(),
									molipInf1.vLinkTo.end());
		if (laJnt[0] == 0)
		{
			if (laJnt[1] == 0)
			//----- _xZkqqHx_jIeBiMiLjDfPiCePiCkKiKeKiOgOjDfPiBeBjIeBiMiLjDfPiCfAiCkKiKeKiOgOjDfPiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jIeBiMiLjDfPiCePiCmMiNmFiPiJiCmJiBeBjIeBiMiLjDfPiCfAiCpAiLhEiMpMiCkLiCmJjBhNjDpMiClHiCoJiPiAjEpFiBeC_xHqqkZx_
				ReversePolyJoint(vJoint.begin(), vJoint.size());
				reverse(vMolipInf1.begin(), vMolipInf1.end() - 1);
			}
			// _xZkqqHx_jFkBjAjEjIeBiMiLjDfPjBhNjDpMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			g_pDoc->CmdInsertJoints(paPly[0], 0, vJoint.size(), vJoint.begin());
			vMolipInf0.insert(vMolipInf0.begin(), vMolipInf1.begin(), vMolipInf1.end());
		} else
		{
			if (laJnt[1] != 0)
			//----- _xZkqqHx_jIeBiMiLjDfPiCePiCkKiPeJjHlJjDfPiBeBjIeBiMiLjDfPiCfAiCkKiPeJjHlJjDfPiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jIeBiMiLjDfPiCePiCmMiNmFiMoDiCmJiBeBjIeBiMiLjDfPiCfAiCpAiLhEiMpMiCkLiCmJjBhNjDpMiClHiCoJiPiAjEpFiBeC_xHqqkZx_
				ReversePolyJoint(vJoint.begin(), vJoint.size());
				reverse(vMolipInf1.begin(), vMolipInf1.end() - 1);
			}
			// _xZkqqHx_jFkBjAjEjIeBiMiLjDfPjBhNjDpMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			g_pDoc->CmdInsertJoints(paPly[0], laJnt[0] + 1, vJoint.size(), vJoint.begin());
			vMolipInf0.insert(vMolipInf0.end(), vMolipInf1.begin(), vMolipInf1.end());
		}
		// _xZkqqHx_jFmPiNfIiClFiClNiPoOjFpBiCpAjElNiJgGiBeC_xHqqkZx_
		// Link_xZkqqHx_iNoNiPjM_xHqqkZx_/Link_xZkqqHx_jCmHiJmBiCpAiDfKiDgCiDgHiCmFiOmAiNhDiClHiCoJiPoKiNiHiBeB_xHqqkZx_UpdateLinkConnect _xZkqqHx_iCmNiBeB_xHqqkZx_
		// _xZkqqHx_iNoNiPjMiCmFiIoKiJpBiBeBjCmHiJmBiCmFiIoKiJpBjFmKiBfIiCmJiOmAiNhDiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		g_pDoc->LinkManager()->UpdateLinkConnect(paPly[0]->GetObjID(),
													vMolipInf0, &molipInf0);
		g_pDoc->LinkManager()->DeleteSoonNotify(paPly[1]->GetObjID());
		// _xZkqqHx_jFjEjFgJiCmMiNoNiPjMiDfCiDhNiDjDiDgIiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->MulticmdDelete1Obj(paPly[1], g_pDoc->GetCurrentSheetId());
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiDhEiDeIiDjDiDgHiCpAjAkOjHjNiBeC_xHqqkZx_
		g_pDoc->MulticmdDeleteUnusedFonts();
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
//----- 05.06.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiCiDiKiDhGiInKjDkOiCmJjElKiCkEiDiCiDiKiDhGjFmPiNfIiCpAiLeMjIfOiBeC_xHqqkZx_
//	FTMolipSet setMolip;
//	setMolip.insert(FCMolipRec(paPly[0]->GetObjID(), -1));
//	// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify(setMolip);
//----- 05.06.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
	g_pDoc->LinkManager()->MovedNotify(paPly[0]);
//----- 05.06.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMjFmPiNfIiCpAiClBiCmMiDgDiBfLiDiLiCmJjCmKjCgNiBeC_xHqqkZx_
	OnSelectObjModified();
	//----- _xZkqqHx_iNmEjFgAiJoGiPiIjHjN_xHqqkZx_ -----
	// _xZkqqHx_jFmPiNfIiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(paPly[0]);
	g_pView->SendRgnRedraw();
} // FCToolPolyEdit::OnObjectConnect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanObjectDisconnect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjDfPiCkKjAnKjBlBiJpAiPjMiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnKjBlBiJpAiPjMiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::CanObjectDisconnect () const
{
	JointSelInfoVector::const_iterator iInf;
	FCObjPoly*	paPly[2];	// _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCmMjBkOiClHiCoJjFjEjFgJiBeC_xHqqkZx_
	long		laJnt[2];	// _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	short		nIndex = 0;

	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
	{
		longVector::const_iterator	iIdx;
		for (iIdx = (*iInf).GetSelJointVector().begin();
			 iIdx != (*iInf).GetSelJointVector().end(); iIdx++)
		{
			// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKiCfCiCmCiImIiPoDiCkAiCoJiOjOiCmNjIeBiMiLjFhDiJmCjEfMiBeC_xHqqkZx_
// 06.10.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			if (2 <= nIndex) return FALSE;
			if (nIndex == 2) return FALSE;
			//----- _xZkqqHx_jIeBiMiLjDfPiCmMjFjEjFgJiCmGiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiClHiCoJ_xHqqkZx_ -----
			paPly[nIndex] = (*iInf).GetObject();
			laJnt[nIndex] = *iIdx;
			nIndex++;
		}
	}
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKiCfBiMmCiCmFiCmIiCkCiPoKiNiHiBgJiCfAiMmCiBeBiCePiMmCiBgKiCmNjFhDiJmCiBeC_xHqqkZx_
//	if (nIndex != 2) return FALSE;
//	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKjDkPiClGjFjEjFgJiCmFjGlDiCkCiPoKiNiHiCmNjFhDiJmCiBeC_xHqqkZx_
//	if (paPly[0] != paPly[1]) return FALSE;
//	if (paPly[0]->GetIsOpenPolyJoint())
//	//----- _xZkqqHx_iKeKiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jIeBiMiLjDfPiCkKjGjGjCfLiCmMiPoKiNiHiCmNjIeBiMiLiJpAiPjMjFhDiJmCjEfMiBeC_xHqqkZx_
//		if (laJnt[0] == 0 || laJnt[0] == paPly[0]->GetJointSize() -1) return FALSE;
//		if (laJnt[1] == 0 || laJnt[1] == paPly[1]->GetJointSize() -1) return FALSE;
//		// _xZkqqHx_jHnHiCoIiNiHiCmBiClNjIeBiMiLjDfPiCmFiCmIiCkCiPoKiNiHiCmNjIeBiMiLiJpAiPjMjFhDiJmCjEfMiBeC_xHqqkZx_
//		if (laJnt[0] + 1 != laJnt[1]) return FALSE;
//	} else
//	//----- _xZkqqHx_jFmCiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jHnHiCoIiNiHiCmBiClNjIeBiMiLjDfPiCmFiCmIiCkCiPoKiNiHiCmNjIeBiMiLiJpAiPjMjFhDiJmCjEfMiBeC_xHqqkZx_
//		if ((laJnt[0] + 1 != laJnt[1]) &&
//			!(laJnt[0] == 0 && laJnt[1] == paPly[0]->GetJointSize() -1))
//			return FALSE;
//		// _xZkqqHx_iDhMiDiKiDfDiDjDjApMjHlMjCfLiCmMjAnKjBlBiBeFjAnKjBlBiJpAiPjMiCkKjAnNjCoIiCmFiCkLiCmIiCkCiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
//		if (!paPly[0]->CanSetOpenPolyJoint()) return FALSE;
//	}
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (nIndex == 0)
	{
		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKiCePiMmCiCmNjFhDiJmCiBeC_xHqqkZx_
		return FALSE;
	} else
	if (nIndex == 1)
	{
		if (paPly[0]->GetIsOpenPolyJoint())
		//----- _xZkqqHx_iKeKiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jIeBiMiLjDfPiCkKjGjGjCfLiCmMiPoKiNiHiCmNjIeBiMiLiJpAiPjMjFhDiJmCjEfMiBeC_xHqqkZx_
			if (laJnt[0] == 0 || laJnt[0] == paPly[0]->GetJointSize() -1)
				return FALSE;
		} else
		//----- _xZkqqHx_jFmCiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhMiDiKiDfDiDjDjApMjHlMjCfLiCmMjAnKjBlBiBeFjAnKjBlBiJpAiPjMiCkKjAnNjCoIiCmFiCkLiCmIiCkCiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
			if (!paPly[0]->CanSetOpenPolyJoint())
				return FALSE;
		}
	} else
	if (nIndex == 2)
	{
		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKjDkPiClGjFjEjFgJiCmFjGlDiCkCiPoKiNiHiCmNjFhDiJmCiBeC_xHqqkZx_
		if (paPly[0] != paPly[1]) return FALSE;
		if (paPly[0]->GetIsOpenPolyJoint())
		//----- _xZkqqHx_iKeKiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jIeBiMiLjDfPiCkKjGjGjCfLiCmMiPoKiNiHiCmNjIeBiMiLiJpAiPjMjFhDiJmCjEfMiBeC_xHqqkZx_
			if (laJnt[0] == 0 || laJnt[0] == paPly[0]->GetJointSize() -1)
				return FALSE;
			if (laJnt[1] == 0 || laJnt[1] == paPly[1]->GetJointSize() -1)
				return FALSE;
			// _xZkqqHx_jHnHiCoIiNiHiCmBiClNjIeBiMiLjDfPiCmFiCmIiCkCiPoKiNiHiCmNjIeBiMiLiJpAiPjMjFhDiJmCjEfMiBeC_xHqqkZx_
			if (laJnt[0] + 1 != laJnt[1])
				return FALSE;
		} else
		//----- _xZkqqHx_jFmCiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHnHiCoIiNiHiCmBiClNjIeBiMiLjDfPiCmFiCmIiCkCiPoKiNiHiCmNjIeBiMiLiJpAiPjMjFhDiJmCjEfMiBeC_xHqqkZx_
			if ((laJnt[0] + 1 != laJnt[1]) &&
				!(laJnt[0] == 0 && laJnt[1] == paPly[0]->GetJointSize() -1))
				return FALSE;
			// _xZkqqHx_iDhMiDiKiDfDiDjDjApMjHlMjCfLiCmMjAnKjBlBiBeFjAnKjBlBiJpAiPjMiCkKjAnNjCoIiCmFiCkLiCmIiCkCiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
			if (!paPly[0]->CanSetOpenPolyJoint())
				return FALSE;
		}
	}
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // FCToolPolyEdit::CanObjectDisconnect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnObjectDisconnect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCpAjAnKjBlBiJpAiPjMiClHiCoJiBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P306_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.08.31 Fukushiro M. _xZkqqHx_iNoMjAkMiClHiCoJjFjEjFgJiCmMiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCpAiOhHjCoIiBeC_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::OnObjectDisconnect ()
{
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCObjPoly*	paPly[2];	// _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCmMjBkOiClHiCoJjFjEjFgJiBeC_xHqqkZx_
//	long		laJnt[2];	// _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//	short		nIndex = 0;
//
//	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCePiCmGjIeBiMiLjDfPiCfAiCmMiPoOjFpBiCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
//	JointSelInfoVector::iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//	{
//		longVector::const_iterator iIdx;
//		for (iIdx = (*iInf).GetSelJointVector().begin();
//			 iIdx != (*iInf).GetSelJointVector().end(); iIdx++)
//		{
//// 06.10.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////			ASSERT(nIndex < 2);	// _xZkqqHx_iDeHiDiJiBfLiBeCjHeMiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
//			if (nIndex == 2) FFThrowMiscUnknown();	// _xZkqqHx_iDeHiDiJiBfLiBeCjHeMiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
//			//----- _xZkqqHx_jIeBiMiLjDfPiCmMjFjEjFgJiCmGiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiClHiCoJ_xHqqkZx_ -----
//			paPly[nIndex] = (*iInf).GetObject();
//			laJnt[nIndex] = *iIdx;
//			nIndex++;
//		}
//	}
//	// _xZkqqHx_jDkPiClGjFjEjFgJiCmFjGlDiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	ASSERT(paPly[0] == paPly[1]);
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	long	laSelPoly[2];	// _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCmMjBkOiClHiCoJjFjEjFgJiBeC_xHqqkZx_
	long	laSelJont[2];	// _xZkqqHx_jDpBiCmCiCmMjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	short	nSelCount = 0;
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCePiCmGjIeBiMiLjDfPiCfAiCmMiPoOjFpBiCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
	for (long lPolyIdx = 0;
		 lPolyIdx != m_vPolyLine.size();
		 lPolyIdx++)
	{
		longVector::const_iterator iIdx;
		for (iIdx = m_vPolyLine[lPolyIdx].GetSelJointVector().begin();
			 iIdx != m_vPolyLine[lPolyIdx].GetSelJointVector().end();
			 iIdx++)
		{
			if (nSelCount == 2) FFThrowMiscUnknown();	// _xZkqqHx_iDeHiDiJiBfLiBeCjHeMiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
			//----- _xZkqqHx_jIeBiMiLjDfPiCmMjFjEjFgJiCmGiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiClHiCoJ_xHqqkZx_ -----
			laSelPoly[nSelCount] = lPolyIdx;
			laSelJont[nSelCount] = *iIdx;
			nSelCount++;
		}
	}
	// _xZkqqHx_iNmFjCoBiCfAiCmCiCmNjBeJjBpAiClDiCoKiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (nSelCount == 0) FFThrowMiscUnknown();
	// _xZkqqHx_iCfBiCmCiCmMjBeJjBpAiCmNjDkPiClGjFjEjFgJiCmJjBkOiClDiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (nSelCount == 2 && laSelPoly[0] != laSelPoly[1])
		FFThrowMiscUnknown();
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiJpAiPjMiClHiCoJiBeCiDfDiDhOiCpAiOgDiClDiCmIiCkCiCoGiCkEiCmJiClHiCoJiClNiCnPiBeB_xHqqkZx_
	// InsertJoint _xZkqqHx_iCmMjBePiCmJiOmAiNhDiClDiCoKiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	UnselectXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT), &dc);

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_InsertJoint _xZkqqHx_jCiGiCmFiCoAiMmEiCmOiCoKiCoJiClNiCnPiBeB_xHqqkZx_
	// _xZkqqHx_iClLiCmMjBePiCmJiOmAiNhDiClFiCmEiDgMiDfIiDgHiClDiClJiCoJiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (nSelCount == 1)
	{
		// _xZkqqHx_jIeBiMiLjDfPiCpAjBeJjBpAiImKjChFiCmJjCmHiJmBiBeC_xHqqkZx_
		longPair newJoint = InsertJoint(laSelPoly[0], laSelJont[0], 0.0,
										m_vPolyLine[laSelPoly[0]][laSelJont[0]].GetPivotPoint());
		laSelPoly[1] = newJoint.first;
		laSelJont[1] = newJoint.second;
	}
	// _xZkqqHx_jDkPiClGjFjEjFgJiCmFjGlDiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (laSelPoly[0] != laSelPoly[1]) FFThrowMiscUnknown();
	FCObjPoly* pObjPoly = m_vPolyLine[laSelPoly[0]].GetObject();
//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (pObjPoly->GetIsOpenPolyJoint())
	//----- _xZkqqHx_iKeKiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFkKiKiEjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(pObjPoly);

		//----- _xZkqqHx_jFkKiKiEiMoDjElMiCmMjIeBiMiLjApMiCmMjFjEjFgJiCpAiNoMjAkM_xHqqkZx_ -----

		FCObjPoly* pNew = (FCObjPoly*)pObjPoly->Duplicate();
		// _xZkqqHx_jFjEjFgJiCmMiPiJiKpKiJlLiBeCjFkKiKiEiImKjChFiMoDjElMiCmMjIeBiMiLjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
		pNew->SetJoint(	pObjPoly->GetJointSize() - laSelJont[1],
						pObjPoly->GetJoints() + laSelJont[1]);
		// _xZkqqHx_iDfEiDeDiDfJiCmMiNmEiMhGiOfKiBeC_xHqqkZx_
		pNew->CalcResizeFrame();
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
		pNew->RegisterObjID();
//----- 00.08.31 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_jFjEjFgJjAlGjAkMiCmMiLeMjIfOiBeC_xHqqkZx_
//		g_pDoc->MulticmdCreate1Obj(pNew);
//----- 00.08.31 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_jFjEjFgJjAlGjAkMiCmMiLeMjIfOiBeC_xHqqkZx_
// 00.12.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		g_pDoc->MulticmdCreate1Obj(pNew, g_pDoc->ObjDynabaseToZOrder(pObjPoly) + 1);
		g_pDoc->MulticmdCreate1Obj(pNew, g_pDoc->GetCurrentSheetId(), g_pDoc->ObjDynabaseToLZOrder(pObjPoly) + 1);
//----- 00.08.31 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

		//----- _xZkqqHx_iDiCiDiKiDhGiBeFiDiKiDjDiDeOiCmMiInKjDkOiPiIjHjN_xHqqkZx_ -----

		// _xZkqqHx_jFjEjFgJiCePiCmMiDiCiDiKiDhGiPoOjFpBjEhKjHpBiCpAjHhAiInDiClHiCoJiBeC_xHqqkZx_
		FCMolipInfoVector vMolipInf0;
		g_pDoc->LinkManager()->PrepareMolipInfoVector(vMolipInf0, NULL,
													pObjPoly->GetMolipCount(),
													pObjPoly->GetObjID());
		// _xZkqqHx_jFjEjFgJiCfAiCmMiDiCiDiKiDhGiPoOjFpBjEhKjHpBiCpAiBeBjFjEjFgJiCePiCmMiPoOjFpBjEhKjHpBiCmMiMoDjElMiCkJiCoHiNoMjAkMiClHiCoJiBeC_xHqqkZx_
		FCMolipInfoVector vMolipInf1(
					vMolipInf0.begin() + JointIDtoMolipID(laSelJont[1]),
					vMolipInf0.end());
		// _xZkqqHx_jFjEjFgJiCePiCmMiPoOjFpBjEhKjHpBiCkJiCoHiBeBjFjEjFgJiCfAiCmMiPoOjFpBjEhKjHpBiCmJiDfCiDhDiBfLiClFiClNjFjEjFkKiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
		vMolipInf0.erase(
					vMolipInf0.begin() + JointIDtoMolipID(laSelJont[1]),
					vMolipInf0.end());
		// _xZkqqHx_jFmPiNfIiClFiClNiPoOjFpBiCpAjElNiJgGiBeC_xHqqkZx_
		// Link_xZkqqHx_iNoNiPjM_xHqqkZx_/Link_xZkqqHx_jCmHiJmBiCpAiDfKiDgCiDgHiCmFiOmAiNhDiClHiCoJiPoKiNiHiBeB_xHqqkZx_UpdateLinkConnect _xZkqqHx_iCmNiBeB_xHqqkZx_
		// _xZkqqHx_iNoNiPjMiCmFiIoKiJpBiBeBjCmHiJmBiCmFiIoKiJpBjFmKiBfIiCmJiOmAiNhDiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		g_pDoc->LinkManager()->UpdateLinkConnect(pObjPoly->GetObjID(),
													vMolipInf0, NULL);
		// _xZkqqHx_jFmPiNfIiClFiClNiPoOjFpBiCpAjElNiJgGiBeC_xHqqkZx_
		// Link_xZkqqHx_iNoNiPjM_xHqqkZx_/Link_xZkqqHx_jCmHiJmBiCpAiDfKiDgCiDgHiCmFiOmAiNhDiClHiCoJiPoKiNiHiBeB_xHqqkZx_UpdateLinkConnect _xZkqqHx_iCmNiBeB_xHqqkZx_
		// _xZkqqHx_iNoNiPjMiCmFiIoKiJpBiBeBjCmHiJmBiCmFiIoKiJpBjFmKiBfIiCmJiOmAiNhDiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		g_pDoc->LinkManager()->UpdateLinkConnect(pNew->GetObjID(),
													vMolipInf1, NULL);

		//----- _xZkqqHx_iNmFiPiJiCmMjFjEjFgJiCmMjIeBiMiLjDfPiCmMiNoNiPjMiPiIjHjN_xHqqkZx_ -----

		// _xZkqqHx_iNmFiPiJiCmMjFjEjFgJiCkJiCoHiNoNiPjMiClHiCoJiBeBjIeBiMiLjDfPiCmM_xHqqkZx_Idx_xZkqqHx_jEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
		longVector vJointIdx;
		for (long lIdx = laSelJont[1]; lIdx < pObjPoly->GetJointSize(); lIdx++)
			vJointIdx.push_back(lIdx);
		// _xZkqqHx_jIeBiMiLjDfPiCmMiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
		g_pDoc->CmdDeleteJoints(pObjPoly, vJointIdx);

		//----- _xZkqqHx_iDiCiDiKiDhGiInKjDkOiCmJjElKiCkEiDiCiDiKiDhGjFmPiNfIiCpAiLeMjIfO_xHqqkZx_ -----

		FTMolipSet setMolip;
		setMolip.insert(FCMolipRec(pObjPoly->GetObjID(), -1));
		setMolip.insert(FCMolipRec(pNew->GetObjID(), -1));
		// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
		g_pDoc->LinkManager()->MovedNotify(setMolip);
		// _xZkqqHx_jFkKiKiEiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(pObjPoly);
		g_pView->AppendToLastRgn(pNew);
	} else
	//----- _xZkqqHx_jFmCiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFkKiKiEjBePiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(pObjPoly);

		if (laSelJont[0] != 0 || laSelJont[1] != pObjPoly->GetJointSize() - 1)
		//----- _xZkqqHx_jIeBiMiLjDfPiCmMiKeKiOgOjDfPiBhMiPeJjHlJjDfPiKnEiImIiKePiCpAiKeKiCkNiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_iDiCiDiKiDhGiBeFiDiKiDjDiDeOiCmMiInKjDkOiPiIjHjN_xHqqkZx_ -----

			// _xZkqqHx_jFjEjFgJiCmMiDiCiDiKiDhGiPoOjFpBjEhKjHpBiCpAjHhAiInDiClHiCoJiBeC_xHqqkZx_
			FCMolipInfoVector vMolipInf;
			g_pDoc->LinkManager()->PrepareMolipInfoVector(vMolipInf, NULL,
														pObjPoly->GetMolipCount(),
														pObjPoly->GetObjID());
			// _xZkqqHx_iDiPiBfLiDeOiDiCiDiKiDhGiPoOjFpBjEhKjHpBiCpAiBeBjFjEjFgJiCmMiPoOjFpBjEhKjHpBiCmMiMoDjElMiCkJiCoHiNoMjAkMiClHiCoJiBeC_xHqqkZx_
			FCMolipInfoVector vWorkMI(
						vMolipInf.begin() + JointIDtoMolipID(laSelJont[1]),
						vMolipInf.end());
			// _xZkqqHx_jFjEjFgJiCmMiPoOjFpBjEhKjHpBiCkJiCoHiBeBiDiPiBfLiDeOiPoOjFpBjEhKjHpBiCmJiDfCiDhDiBfLiClFiClNjFjEjFkKiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
			vMolipInf.erase(
						vMolipInf.begin() + JointIDtoMolipID(laSelJont[1]),
						vMolipInf.end());
			// _xZkqqHx_jFjEjFgJiCmMiPoOjFpBjEhKjHpBiCmMjAoGjDkKiCmJiBeBiDiPiBfLiDeOiPoOjFpBjEhKjHpBiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
			vMolipInf.insert(vMolipInf.begin(), vWorkMI.begin(), vWorkMI.end());
			// _xZkqqHx_jFmPiNfIiClFiClNiPoOjFpBiCpAjElNiJgGiBeC_xHqqkZx_
			// Link_xZkqqHx_iNoNiPjM_xHqqkZx_/Link_xZkqqHx_jCmHiJmBiCpAiDfKiDgCiDgHiCmFiOmAiNhDiClHiCoJiPoKiNiHiBeB_xHqqkZx_UpdateLinkConnect _xZkqqHx_iCmNiBeB_xHqqkZx_
			// _xZkqqHx_iNoNiPjMiCmFiIoKiJpBiBeBjCmHiJmBiCmFiIoKiJpBjFmKiBfIiCmJiOmAiNhDiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
			g_pDoc->LinkManager()->UpdateLinkConnect(pObjPoly->GetObjID(),
														vMolipInf, NULL);

			//----- _xZkqqHx_jFjEjFgJiCmMjIeBiMiLjDfPiCmMiNoNiPjMiBeFiInKjDkOiPiIjHjN_xHqqkZx_ -----

			// _xZkqqHx_jFjEjFgJiCmMjIeBiMiLjDfPjFkKiKiEiImKjChFiCmMiMoDjElMiCpAiDiPiBfLiDeOiCmJiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
			FCPolyJointVector vJoint;
			vJoint.insert(vJoint.end(), pObjPoly->GetJoints() + laSelJont[1],
										pObjPoly->GetJoints() + pObjPoly->GetJointSize());
			// _xZkqqHx_jFjEjFgJiCkJiCoHiNoNiPjMiClHiCoJiBeBjIeBiMiLjDfPiCmM_xHqqkZx_Idx_xZkqqHx_jEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
			longVector vJointIdx;
			for (long lIdx = laSelJont[1]; lIdx < pObjPoly->GetJointSize(); lIdx++)
				vJointIdx.push_back(lIdx);
			// _xZkqqHx_jIeBiMiLjDfPiCmMiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
			g_pDoc->CmdDeleteJoints(pObjPoly, vJointIdx);
			// _xZkqqHx_jFkBjAjEjIeBiMiLjDfPjBhNjDpMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			g_pDoc->CmdInsertJoints(pObjPoly, 0, vJoint.size(), vJoint.begin());
		}
		//----- _xZkqqHx_iCfAiDhMiDiKiDfDiDjDjFjEjFgJjHlMjCfLjAnKjBlBiJpAiPjMiDfCiDhNiDjDiDgI_xHqqkZx_ -----
		FCPolyLinkRec plRec;
		plRec.wMask = FDFP_ISOPENPOLYJOINT;
		plRec.bIsOpenPolyJoint = TRUE;
		g_pDoc->CmdModifyPolyLink(pObjPoly, plRec);
		//----- _xZkqqHx_iDiCiDiKiDhGiInKjDkOiCmJjElKiCkEiDiCiDiKiDhGjFmPiNfIiCpAiLeMjIfO_xHqqkZx_ -----
//----- 05.06.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		FTMolipSet setMolip;
//		setMolip.insert(FCMolipRec(pObjPoly->GetObjID(), -1));
//		// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
//		g_pDoc->LinkManager()->MovedNotify(setMolip);
//----- 05.06.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
		g_pDoc->LinkManager()->MovedNotify(pObjPoly);
//----- 05.06.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jFkKiKiEiMoDiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(pObjPoly);
	}

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMjFmPiNfIiCpAiClBiCmMiDgDiBfLiDiLiCmJjCmKjCgNiBeC_xHqqkZx_
	OnSelectObjModified();
	//----- _xZkqqHx_iNmEjFgAiJoGiPiIjHjN_xHqqkZx_ -----
	g_pView->SendRgnRedraw();
} // FCToolPolyEdit::OnObjectDisconnect.

//----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanObjectMoveSnapLeft
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiNlGjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::CanObjectMoveSnapLeft () const
//{
//	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
//	if (!FFCanEditSelected()) return FALSE;
//	return TRUE;
//} // FCToolPolyEdit::CanObjectMoveSnapLeft.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnObjectMoveSnapLeft
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiNlGjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnObjectMoveSnapLeft ()
//{
//	MoveJointSnap(-1, 0);
//} // FCToolPolyEdit::OnObjectMoveSnapLeft.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanObjectMoveSnapUp
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiPoDjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::CanObjectMoveSnapUp () const
//{
//	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
//	if (!FFCanEditSelected()) return FALSE;
//	return TRUE;
//} // FCToolPolyEdit::CanObjectMoveSnapUp.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnObjectMoveSnapUp
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiPoDjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnObjectMoveSnapUp ()
//{
//	MoveJointSnap(0, -1);
//} // FCToolPolyEdit::OnObjectMoveSnapUp.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanObjectMoveSnapRight
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJeFjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::CanObjectMoveSnapRight () const
//{
//	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
//	if (!FFCanEditSelected()) return FALSE;
//	return TRUE;
//} // FCToolPolyEdit::CanObjectMoveSnapRight.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnObjectMoveSnapRight
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJeFjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnObjectMoveSnapRight ()
//{
//	MoveJointSnap(1, 0);
//} // FCToolPolyEdit::OnObjectMoveSnapRight.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanObjectMoveSnapDown
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJlKjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCkKiOmAiNhDiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::CanObjectMoveSnapDown () const
//{
//	// _xZkqqHx_jFjEjFgJiCkKjFmPiNfIjFhDiJmCjEfMiCmIiCoHiCmOjFhDiJmCiBeC_xHqqkZx_
//	if (!FFCanEditSelected()) return FALSE;
//	return TRUE;
//} // FCToolPolyEdit::CanObjectMoveSnapDown.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnObjectMoveSnapDown
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiBhFiJlKjFpLiMpMiCnGiDfIiDgJiDgCiDhGiInKjDkOiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnObjectMoveSnapDown ()
//{
//	MoveJointSnap(0, 1);
//} // FCToolPolyEdit::OnObjectMoveSnapDown.
//----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanHandle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiClBiCmMiDgDiBfLiDiLiCmFiIlFiCkGiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::CanHandle (const FCObjDynabase* pObj) const
{
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return pObj->IsKindOf(FDOJ_POLY);
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!pObj->IsKindOf(FDOJ_POLY)) return FALSE;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CanHandle(pObj);
//----- 00.12.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolPolyEdit::CanHandle.

//----- 01.01.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnCommand
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnCommand (DWORD dwCmdID)
//{
//	switch (dwCmdID)
//	{
//	case ID_OBJECT_PUT_RTF_OBJ:
//		OnObjectPutRtfObj();
//		break;
//	default:
//		BASE_CLASS::OnCommand(dwCmdID);
//	}
//} // FCToolPolyEdit::OnCommand.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnUpdateCommand
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCmMjHeMiMpIiBeFjGlDiMpIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::OnUpdateCommand (DWORD dwCmdID) const
//{
//	switch (dwCmdID)
//	{
//	case ID_OBJECT_PUT_RTF_OBJ:
//		return CanObjectPutRtfObj();
//	default:
//		return BASE_CLASS::OnUpdateCommand(dwCmdID);
//	}
//} // FCToolPolyEdit::OnUpdateCommand.
//----- 01.01.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::IsObjectCommandEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCmMjCoIjAkLjDeJiCmIjHeMiMpIiBeFjGlDiMpIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::IsObjectCommandEnable (DWORD dwCmdID) const
{
	switch (dwCmdID)
	{
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case ID_OBJECT_ALIGN_V_CENTER:
//	case ID_OBJECT_ALIGN_H_CENTER:
//	case ID_OBJECT_SAME_GAP_V:
//	case ID_OBJECT_SAME_GAP_H:
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case ID_OBJECT_INSERT_JOINT:
	case ID_OBJECT_DISCONNECT:
	case ID_OBJECT_CONNECT:
//----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case ID_OBJECT_MOVE_SNAP_LEFT:
//	case ID_OBJECT_MOVE_SNAP_UP:
//	case ID_OBJECT_MOVE_SNAP_RIGHT:
//	case ID_OBJECT_MOVE_SNAP_DOWN:
//----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		return TRUE;
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case ID_OBJECT_ALIGN_V_LEFT:
//	case ID_OBJECT_ALIGN_V_RIGHT:
//	case ID_OBJECT_ALIGN_H_TOP:
//	case ID_OBJECT_ALIGN_H_BOTTOM:
//	case ID_OBJECT_SAME_DIST_V:
//	case ID_OBJECT_SAME_DIST_H:
//	case ID_OBJECT_SAME_SIZE_X:
//	case ID_OBJECT_SAME_SIZE_Y:
//		return FALSE;
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	default:
		return BASE_CLASS::IsObjectCommandEnable(dwCmdID);
	}
} // FCToolPolyEdit::IsObjectCommandEnable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetLineCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHjBmOiPnLiCmMjApMjFjEjFgJiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFnCiPfHjBmOiPnLiCmMjApMjFjEjFgJiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolPolyEdit::GetLineCount () const
{
	return m_vPolyLine.size();
} // FCToolPolyEdit::GetLineCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::IsOpenLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFjEjFgJiCkKiKeKiCkCiCmEiCkCiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_jApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jApMjFjEjFgJiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::IsOpenLine (long lLineIndex) const
{
	return ((const FCObjPoly*)GetLineObject(lLineIndex))->GetIsOpenPolyJoint();
} // FCToolPolyEdit::IsOpenLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetJointCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFjEjFgJiCmMjIeBiMiLjDfPjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_jApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jApMjFjEjFgJiCmMjIeBiMiLjDfPjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolPolyEdit::GetJointCount (long lLineIndex) const
{
	return m_vPolyLine[lLineIndex].size();
} // FCToolPolyEdit::GetJointCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetBezierControls
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFjEjFgJiCmMiBeBiOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiKnEiCmMiDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bc			:_xZkqqHx_iDhIiDfHiDeGiLmIjApMjAkHiMoEjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *			lLineIndex	:_xZkqqHx_jApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lJointIndex	:_xZkqqHx_jIeBiMiLjDfPiCmMiKeKiOgOiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsForward	:_xZkqqHx_jIeBiMiLjDfPiPeJjHlJiDeDiDjDiDgGiDgCiDeOiDfIiCkKiBeBiKeKiOgOiDeDiDjDiDgGiDgCiDeOiDfIiCmJ_xHqqkZx_
 *						 _xZkqqHx_jBmOiClFiCmEiMoDjFpLiCkJjBePjFpLiCkJiCpAiOhHjCoIiBeCiMoDjFpLiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lJointIndex = 2, bIsForward = TRUE _xZkqqHx_iCmMiPoKiNiHiCmNiBeBjIeBiMiLjDfP_xHqqkZx_[2,3]_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jAkHiMoEjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *			lJointIndex = 2, bIsForward = FALSE _xZkqqHx_iCmMiPoKiNiHiCmNiBeBjIeBiMiLjDfP_xHqqkZx_[2,1]_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jAkHiMoEjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::GetBezierControls (FCBezierControls& bc,
										long lLineIndex,
										long lJointIndex,
										BOOL bIsForward) const
{
	if (bIsForward)
	{
		bc.A() = m_vPolyLine[lLineIndex][lJointIndex].m_mmptPivot;
		bc.B() = m_vPolyLine[lLineIndex][lJointIndex].m_mmptPivot +
					m_vPolyLine[lLineIndex][lJointIndex].m_mmptNext;
		bc.C() = m_vPolyLine[lLineIndex][lJointIndex + 1].m_mmptPivot +
					m_vPolyLine[lLineIndex][lJointIndex + 1].m_mmptPrev;
		bc.D() = m_vPolyLine[lLineIndex][lJointIndex + 1].m_mmptPivot;
	} else
	{
		bc.A() = m_vPolyLine[lLineIndex][lJointIndex].m_mmptPivot;
		bc.B() = m_vPolyLine[lLineIndex][lJointIndex].m_mmptPivot +
					m_vPolyLine[lLineIndex][lJointIndex].m_mmptPrev;
		bc.C() = m_vPolyLine[lLineIndex][lJointIndex - 1].m_mmptPivot +
					m_vPolyLine[lLineIndex][lJointIndex - 1].m_mmptNext;
		bc.D() = m_vPolyLine[lLineIndex][lJointIndex - 1].m_mmptPivot;
	}
} // FCToolPolyEdit::GetBezierControls.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetLineObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFjEjFgJiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_jApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjFigure* FCToolPolyEdit::GetLineObject (long lLineIndex) const
{
	return m_vPolyLine[lLineIndex].GetObject();
} // FCToolPolyEdit::GetLineObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::SetJointPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCmMiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	index	:_xZkqqHx_jApMiBeFjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLjDoAjFjEiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJjFmPjAjEiCmMiNmAjFfHjCgMiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::SetJointPoint (longPair index, DBLPoint mmpt)
{
	m_vPolyLine[index.first][index.second].m_mmptPivot = mmpt;
} // FCToolPolyEdit::SetJointPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::DrawJointSelectMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiBeFiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	index	:_xZkqqHx_jApMiBeFjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::DrawJointSelectMark (CDC* pDC, longPair index) const
{
	m_vPolyLine[index.first][index.second].DrawPullMark(pDC);
} // FCToolPolyEdit::DrawJointSelectMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::JointIDtoMolipID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfP_xHqqkZx_ID_xZkqqHx_iCkJiCoHiBeBiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lJointId	:_xZkqqHx_jIeBiMiLjDfP_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolPolyEdit::JointIDtoMolipID (long lJointId) const
{
	return FCObjPoly::JointIDtoMolipID(lJointId);
} // FCToolPolyEdit::JointIDtoMolipID.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::DrawSelectedBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCmMiJgFiLlPjEmNiImNiCmMiDhIiDfHiDeHiLmIjApMiCmMiCnNiCpA_xHqqkZx_XOR_xZkqqHx_jFgAiJoGiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: _xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfI_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnMouseMove_xZkqqHx_jCiGiCmMjFgAiJoGiDiLiBfLiDgAiDjDiCpAiCnMiCmGiCnPiClNiCoAiCmM_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::DrawSelectedBezier (CDC* pDC) const
{
	JointSelInfoVector::const_iterator iInf;
	JointSeqVector vJntSeq;
	//----- _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoI_xHqqkZx_ -----
	CRect	lgrtClip;
	g_pView->GetClientRectLG(lgrtClip);
	//----- _xZkqqHx_jFmPiNfIiMoDiCmMiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
	{
		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKjGlDiCkCiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if ((*iInf).GetSelJointVector().empty()) continue;
		//----- _xZkqqHx_jApMjFjNiCmMiMhGiOfKiBeC_xHqqkZx_WidePoly_xZkqqHx_iCmMiPoKiNiHiCmNjBnBjFjNiCpAiNgMjHlG_xHqqkZx_ -----
		fmmetol mmfPenW = (*iInf).GetObject()->GetStdPenWeight();
		long  lgPenW = mm2lg(mmfPenW);
		if ((*iInf).GetObject()->IsKindOf(FDOJ_WIDE_POLY))
		//----- WidePoly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			FCObjWidePoly* pWide = (FCObjWidePoly*)(*iInf).GetObject();
			mmetol mmWeight = (pWide->GetPolyWidthF() < pWide->GetPolyWidthB()) ?
							pWide->GetPolyWidthB() : pWide->GetPolyWidthF();
			mmfPenW = fmmetol(mmWeight) + (2.0 * mmfPenW);
			lgPenW = 1;
		}
		//----- _xZkqqHx_jFjEjFgJ_xHqqkZx_ (*iInf).GetObject() _xZkqqHx_iCmJiCkIiCkCiCmEjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmM_xHqqkZx_
		//		m_vSelJointIdx _xZkqqHx_iCmMjFmPiNfIiCmJiCoGiCmBiCmEiJgFiLlPiCpAiOpDiCkPiCoJiClHiCnHiCmEiCmM_xHqqkZx_
		//		_xZkqqHx_jIeBiMiLjDfPiCmMiPfHiNiHiCpA_xHqqkZx_ vStarts _xZkqqHx_iCmG_xHqqkZx_ vCounts _xZkqqHx_iCmJjFnEiClH_xHqqkZx_	-----
		(*iInf).GetAffected(vJntSeq);
		//----- vStarts _xZkqqHx_iCmG_xHqqkZx_ vCounts _xZkqqHx_iCmFjFfMiClDiCoKiCoJjIeBiMiLjDfPiPfHiNiHiCmJjBmO_xHqqkZx_
		//		_xZkqqHx_iDhIiDfHiDeHiLmIjApMiCpAiNmEiMhGiOfKiClFjFgAiJoGiClHiCoJ_xHqqkZx_					-----
		JointSeqVector::const_iterator iS;
		for (iS = vJntSeq.begin(); iS != vJntSeq.end(); iS++)
		{
			CPointVector vlgptPoint;
			//----- _xZkqqHx_iLmIjApMiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfK_xHqqkZx_ -----
			::CalcBezier2(vlgptPoint, (*iInf).begin(), (*iInf).size(), mmfPenW,
						(*iS).lStart, (*iS).lSize, g_->lgdPrecision, g_->dZoom,
// 00.07.19 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//						&lgrtClip, 1, 2.56 / g_->lZoom256);
						&lgrtClip, 1, StdMinRatio(lgrtClip));
			// _xZkqqHx_iLmIjApMiCpAjFgAiJoGiBeC_xHqqkZx_
			DrawPolyline(pDC, vlgptPoint.begin(), vlgptPoint.size(), lgPenW, lgrtClip);
			// _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAiJpAjFpK_xHqqkZx_.
			vlgptPoint.clear();
		}
	}
} // FCToolPolyEdit::DrawSelectedBezier.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetHitPolyline
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiCmJiDhBiDgCiDgHiClFiClNiDhMiDiKiDiJiDeDiDjDjFmPjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjFmPjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
JointSelInfo& FCToolPolyEdit::GetHitPolyline ()
{
	return m_vPolyLine[GetHitXXX(XXX_JOINT).first];
} // FCToolPolyEdit::GetHitPolyline.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetHitJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiCmJiDhBiDgCiDgHiClFiClNjIeBiMiLjDfPjFmPjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lOffset	:_xZkqqHx_jIeBiMiLjDfPiCmMiDeJiDhEiDfKiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjFmPjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyJoint& FCToolPolyEdit::GetHitJoint (long lOffset)
{
	return m_vPolyLine[GetHitXXX(XXX_JOINT).first][GetHitXXX(XXX_JOINT).second + lOffset];
} // FCToolPolyEdit::GetHitJoint.

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::SelectJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCpAjBeJjBpAiNmPiCnNiCmJjCmHiJmBiClHiCoJiBeCiNiHiCoNiClJiCmEjFfMiOkGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	selInf	:_xZkqqHx_jCmHiJmBiClHiCoJjIeBiMiLjDfPiCkKjBkOiClHiCoJiLmIjApMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			idx		:_xZkqqHx_jCmHiJmBiClHiCoJjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiCkKjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.22 Fukushiro M. pDC_xZkqqHx_iCmJ_xHqqkZx_NULL_xZkqqHx_iOhHjCoIiJmCjEfMiCmJiClFiClNiBeC_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::SelectJoint (JointSelInfo& selInf, long idx, CDC* pDC)
//{
//	// _xZkqqHx_jBeJjBpAiNmPiCnNjIeBiMiLjDfPiCmMiDiKiDfIiDgHiCmJjCmHiJmBiBeCjBeJjBpAiNmPiCnNjIeBiMiLjDfPiCmIiCoHiCmOiClBiCmMiCnMiCnMjFjMiLeBiBeC_xHqqkZx_
//	if (!selInf.SelectJoint(idx)) return;
//	// _xZkqqHx_jIeBiMiLjDfPiCmMiIpIjDfPiCpAjFfMiOkGiBeC_xHqqkZx_
//	if (pDC != NULL) selInf[idx].DrawPullMark(pDC);
//
//	//----- _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJ_xHqqkZx_ -----
////----- 05.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	m_lLastPolygonIdx = &selInf - m_vPolyLine.begin();// _xZkqqHx_jIeBiMiLjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////	m_lLastJointIdx = idx;							// _xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////----- 05.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	SetLastSelectedXXX(XXX_JOINT, longPair(&selInf - m_vPolyLine.begin(), idx));
////----- 05.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
////----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	ResetEditHandleList();
////----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//} // FCToolPolyEdit::SelectJoint.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::UnselectJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCpAjBeJjBpAiNmPiCnNiDiKiDfIiDgHiCkJiCoHiNoNiPjMiClHiCoJiBeCiNiHiCoNiClJiCmEjFfMiOkGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	selInf	:_xZkqqHx_iNoNiPjMiClHiCoJjIeBiMiLjDfPiCkKjBkOiClHiCoJiLmIjApMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			idx		:_xZkqqHx_iNoNiPjMiClHiCoJjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiCkKjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.22 Fukushiro M. pDC_xZkqqHx_iCmJ_xHqqkZx_NULL_xZkqqHx_iOhHjCoIiJmCjEfMiCmJiClFiClNiBeC_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::UnselectJoint (JointSelInfo& selInf, long idx, CDC* pDC)
//{
//	// _xZkqqHx_jBeJjBpAiNmPiCnNjIeBiMiLjDfPiCmMiDiKiDfIiDgHiCkJiCoHiPjMiLiOiBeCjGkCjBeJjBpAiCmMjIeBiMiLjDfPiCmIiCoHiClBiCmMiCnMiCnMjFjMiLeBiBeC_xHqqkZx_
//	if (!selInf.UnselectJoint(idx)) return;
//	// _xZkqqHx_jIeBiMiLjDfPiCmMiIpIjDfPiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//	if (pDC != NULL) selInf[idx].DrawPullMark(pDC);
//
////----- 05.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	if (&selInf - m_vPolyLine.begin() == m_lLastPolygonIdx && idx == m_lLastJointIdx)
////	// _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjApMiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiPoKiNiHiBeC_xHqqkZx_
////	{
////		//----- _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCmMiPoOjFpBiCpAiPiJiKpKiJlL_xHqqkZx_ -----
////		m_lLastPolygonIdx = -1;			// _xZkqqHx_jIeBiMiLjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////		m_lLastJointIdx = -1;			// _xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////	}
////----- 05.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
////----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	ResetEditHandleList();
////----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//} // FCToolPolyEdit::UnselectJoint.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::UnselectAllJoints
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiNmPiCnNiCmMjIeBiMiLjDfPiCpAjBfDiCmEjGkCjBeJjBpAiPpDjBnEiCmJjGnPiClHiBeCiNiHiCoNiClJiCmEjFfMiOkGiCoAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiCkKjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.22 Fukushiro M. pDC_xZkqqHx_iCmJ_xHqqkZx_NULL_xZkqqHx_iOhHjCoIiJmCjEfMiCmJiClFiClNiBeC_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::UnselectAllJoints (CDC* pDC)
//{
//	JointSelInfoVector::iterator iInf;
//	if (pDC != NULL)
//	{
//		// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjApMiCmMiBeBjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMiIpIjDfPiBeFiIpIjApMiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//		for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//			(*iInf).DrawPullMark(pDC);
//	}
//	// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjApMiCmMiBeBjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//		(*iInf).ClearSelectJoint();
//
////----- 05.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//----- _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCmMiPoOjFpBiCpAiPiJiKpKiJlL_xHqqkZx_ -----
////	m_lLastPolygonIdx = -1;			// _xZkqqHx_jIeBiMiLjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////	m_lLastJointIdx = -1;			// _xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////----- 05.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
////----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	ResetEditHandleList();
////----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//} // FCToolPolyEdit::UnselectAllJoints.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::MoveJointSnap
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFpLiMpMiCmJiBeBjIeBiMiLjDfPiCpAiDfIiDgJiDgCiDhGjCfAiImKiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lHorzDirection	:_xZkqqHx_jAiFjFlNjFpLiMpMiCmMiInKjDkOjHmKiCpAiOhHjCoIiClHiCoJiBeCjCmKiPoNiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_0_xZkqqHx_iBeB_xHqqkZx_+1_xZkqqHx_iBeC_xHqqkZx_
// *			lVertDirection	:_xZkqqHx_jAiCjClMjFpLiMpMiCmMiInKjDkOjHmKiCpAiOhHjCoIiClHiCoJiBeCjCmKiPoNiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_0_xZkqqHx_iBeB_xHqqkZx_+1_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ALT_xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiInKjDkOiClHiCoJiPoKiNiHiCmNiInKjDkOjHmKiCkKjAjEjFkKiCmMiCfAiCmJiCmIiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::MoveJointSnap (long lHorzDirection, long lVertDirection)
//{
//	//----- _xZkqqHx_iCnMiClIiBeBjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjEhKjHpBiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ -----
//	vector<longPair> vSelJoint;	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjEhKjHpBiBeC_xHqqkZx_
//	for (long lPly = 0; lPly < m_vPolyLine.size(); lPly++)
//	//----- _xZkqqHx_jBmOiPnLjFjEjFgJiCmMiDhMiDiKiDfDiDjDiClHiCnHiCmEiCmJjBmOiClFiCmE_xHqqkZx_ -----
//	{
//		longVector::const_iterator iJnt;
//		for (iJnt = m_vPolyLine[lPly].GetSelJointVector().begin();
//			 iJnt != m_vPolyLine[lPly].GetSelJointVector().end(); iJnt++)
//			vSelJoint.push_back(longPair(lPly, *iJnt));
//	}
//	// _xZkqqHx_jBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCkKiCmIiCkCiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
//	if (vSelJoint.empty()) return;
//	//----- _xZkqqHx_iKoOiPiAiCmGiCmIiCoJjIeBiMiLjDfPiCmMiDhMiDiKiDfDiDjDiBeFjIeBiMiLjDfPiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlO_xHqqkZx_ -----
//	long lStdPlyIdx = GetLastSelectedXXX(XXX_JOINT).first;	// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCmMiDhMiDiKiDfDiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//	long lStdJntIdx = GetLastSelectedXXX(XXX_JOINT).second;	// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCmMjIeBiMiLjDfPiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//	// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiBeBiNmFiPiJiCmMjIeBiMiLjDfPiCpAiOgHiCkEiBeC_xHqqkZx_
//	if (find(vSelJoint.begin(), vSelJoint.end(),
//		longPair(lStdPlyIdx, lStdJntIdx)) == vSelJoint.end())
//	{
//		lStdPlyIdx = vSelJoint.front().first;
//		lStdJntIdx = vSelJoint.front().second;
//	}
//
//	// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCmMiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
//	DBLPoint mmptFix = m_vPolyLine[lStdPlyIdx][lStdJntIdx].m_mmptPivot;
//	DBLPoint mmptNew = mmptFix;
//	// _xZkqqHx_jAfGiClFiCkCiImKjChFiCpAiMiIiCnPiCoJiBeC_xHqqkZx_
//	FFSnapMoveMP(mmptNew, lHorzDirection, lVertDirection);
//	// _xZkqqHx_jGhLjDjGiCmMiInKjDkOiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
//	mmetol mmDX = mmptNew.x - mmptFix.x;
//	mmetol mmDY = mmptNew.y - mmptFix.y;
//
//	// _xZkqqHx_iInKjDkOiLjHjHkDiCePiCmMiPoKiNiHiCmNjFjMiLeBiBeCiCkAiCoIiCkGiCmIiCkCiCkKiBeBjEePiCmMiClNiCnPiBeC_xHqqkZx_
//	if (mmDX == 0.0 && mmDY == 0.0) return;
//
//	// dc_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//
//	// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjApMiCmMiBeBjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMiIpIjDfPiBeFiIpIjApMiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//	JointSelInfoVector::const_iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//		(*iInf).DrawPullMark(&dc);
//
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//
//	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
//	FTMolipSet setMolip;
//
//	//----- _xZkqqHx_iKgFjIeBiMiLjDfPiCpAiInKjDkOiClHiCoJ_xHqqkZx_ -----
//	vector<longPair>::iterator iiIdx;
//	for (iiIdx = vSelJoint.begin(); iiIdx != vSelJoint.end(); iiIdx++)
//	{
//		FCObjPoly* objp = m_vPolyLine[iiIdx->first].GetObject();
//		// _xZkqqHx_jFmPiNfIjBePiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//		g_pView->AppendToLastRgn(objp);
//		longVector vJointIdx(1, iiIdx->second);
//		g_pDoc->CmdMoveJoints(objp, vJointIdx, DBLPoint(mmDX, mmDY));
//		m_vPolyLine[iiIdx->first][iiIdx->second].m_mmptPivot += DBLPoint(mmDX, mmDY);
//		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiCmJjElKiCkEiDiCiDiKiDhGjFmPiNfIiCpAiLeMjIfOiBeC_xHqqkZx_
//		setMolip.insert(FCMolipRec(objp->GetObjID(), -1));
//		// _xZkqqHx_jFmPiNfIiMoDiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//		g_pView->AppendToLastRgn(objp);
//	}
//
//	// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify(setMolip);
//
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
////----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	OnSelectObjModified();
////----- 05.06.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjApMiCmMiBeBjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMiIpIjDfPiBeFiIpIjApMiCpAjFfMiOkGiBeC_xHqqkZx_
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//		(*iInf).DrawPullMark(&dc);
//
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
//} // FCToolPolyEdit::MoveJointSnap.
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CheckHitPull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiIpIjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiPpDjBnEiCpAiBeBiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ m_pHitJointInf, m_lHitJointIdx, 
 *			m_iHitJointKnd _xZkqqHx_iCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::CheckHitPull ()
{
	m_iHitJointKnd = FDPK_NONE;	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiIpIjDfPiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//----- 05.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_pHitJointInf = NULL;		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiLmIjApMjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_lHitJointIdx = -1;		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjIeBiMiLjDfPiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//----- 05.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	SetHitXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT));
//----- 05.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 05.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	JointSelInfoVector::reverse_iterator riInf;
//	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBiIpIjDfPiPoDiCmMiDeOiDiKiDgCiDeOiCpAjClCiCnHiCoJ_xHqqkZx_ -----
//	for (riInf = m_vPolyLine.rbegin(); riInf != m_vPolyLine.rend(); riInf++)
//	{
//		long idxHit;
//		//----- _xZkqqHx_jBePiIpIjDfPiCmFiCmMiDhBiDgCiDgHiCpAiDgAiDeGiDgCiDeO_xHqqkZx_ -----
//		idxHit = (*riInf).FindHitPrevPull(m_mmptMsc);
//		if (0 <= idxHit)
//		{
//			m_iHitJointKnd = FDPK_PREV_PULL;	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiIpIjDfPiBeC_xHqqkZx_
//			m_pHitJointInf = &(*riInf);			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiLmIjApMiBeC_xHqqkZx_
//			m_lHitJointIdx = idxHit;			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjIeBiMiLjDfPiBeC_xHqqkZx_
//			return TRUE;
//		}
//		//----- _xZkqqHx_iMoDiIpIjDfPiCmFiCmMiDhBiDgCiDgHiCpAiDgAiDeGiDgCiDeO_xHqqkZx_ -----
//		idxHit = (*riInf).FindHitNextPull(m_mmptMsc);
//		if (0 <= idxHit)
//		{
//			m_iHitJointKnd = FDPK_NEXT_PULL;	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiIpIjDfPiBeC_xHqqkZx_
//			m_pHitJointInf = &(*riInf);			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiLmIjApMiBeC_xHqqkZx_
//			m_lHitJointIdx = idxHit;			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjIeBiMiLjDfPiBeC_xHqqkZx_
//			return TRUE;
//		}
//	}
//	// _xZkqqHx_iDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
//	return FALSE;
//----- 05.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClHiCoJjFnCiPfHiDgOiDjDiDgIiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	set<FCHandleId> stIds;
	CheckHitHandle(stIds, m_mmptMsc);

	// Z_xZkqqHx_iDgPiDgCiDhEiDeAiPiHiCmFiBeB_xHqqkZx_m_vPolyLine _xZkqqHx_iCmMiNmFiMoDiCmMjFjEjFgJiCkJiCoHjClCiNlIiBeC_xHqqkZx_
	set<FCHandleId>::reverse_iterator rHid;
	for (rHid = stIds.rbegin(); rHid != stIds.rend(); rHid++)
	{
		if (FTJointPntKind((*rHid).third) == FDPK_PREV_PULL ||
			FTJointPntKind((*rHid).third) == FDPK_NEXT_PULL)
		//----- _xZkqqHx_iIpIjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 05.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			m_pHitJointInf = &m_vPolyLine[(*rHid).first];
//			m_iHitJointKnd = FTJointPntKind((*rHid).second);
//			m_lHitJointIdx = (*rHid).third;
//----- 05.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			SetHitXXX(XXX_JOINT, longPair((*rHid).first, (*rHid).second));
			m_iHitJointKnd = FTJointPntKind((*rHid).third);
//----- 05.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			return TRUE;
		}
	}
	// _xZkqqHx_iDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
	return FALSE;
//----- 05.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolPolyEdit::CheckHitPull.

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CheckHitJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiDeKiDgJiDiBjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiPpDjBnEiCpAiBeBiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ m_pHitJointInf, m_lHitJointIdx, 
// *			m_iHitJointKnd _xZkqqHx_iCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::CheckHitJoint ()
//{
//	m_iHitJointKnd = FDPK_NONE;	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiIpIjDfPiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_pHitJointInf = NULL;		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiLmIjApMjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_lHitJointIdx = -1;		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjIeBiMiLjDfPiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//
////----- 05.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	const CPoint lgptMsc = mm2lg(m_mmptMsc);
////	JointSelInfoVector::reverse_iterator riInf;
////	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBiIpIjDfPiPoDiCmMiDeOiDiKiDgCiDeOiCpAjClCiCnHiCoJ_xHqqkZx_ -----
////	for (riInf = m_vPolyLine.rbegin(); riInf != m_vPolyLine.rend(); riInf++)
////	{
////		long idxHit;
////		//----- _xZkqqHx_iDeKiDgJiDiBjDfPiCmFiCmMiDhBiDgCiDgHiCpAiDgAiDeGiDgCiDeO_xHqqkZx_ -----
////		idxHit = (*riInf).FindHitPivot(lgptMsc);
////		if (0 <= idxHit)
////		{
////			m_iHitJointKnd = FDPK_PIVOT;		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDeKiDgJiDiBjDfPiBeC_xHqqkZx_
////			m_pHitJointInf = &(*riInf);			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiLmIjApMiBeC_xHqqkZx_
////			m_lHitJointIdx = idxHit;			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjIeBiMiLjDfPiBeC_xHqqkZx_
////			return TRUE;
////		}
////	}
////	// _xZkqqHx_iDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
////	return FALSE;
////----- 05.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClHiCoJjFnCiPfHiDgOiDjDiDgIiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//	set<FCHandleId> stIds;
//	CheckHitHandle(stIds, m_mmptMsc);
//	// Z_xZkqqHx_iDgPiDgCiDhEiDeAiPiHiCmFiBeB_xHqqkZx_m_vPolyLine _xZkqqHx_iCmMiNmFiMoDiCmMjFjEjFgJiCkJiCoHjClCiNlIiBeC_xHqqkZx_
//	set<FCHandleId>::reverse_iterator rHid;
//	for (rHid = stIds.rbegin(); rHid != stIds.rend(); rHid++)
//	{
//		if (FTJointPntKind((*rHid).third) == FDPK_PIVOT)
//		//----- _xZkqqHx_iDeKiDgJiDiBjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			m_pHitJointInf = &m_vPolyLine[(*rHid).first];
//			m_lHitJointIdx = (*rHid).second;
//			m_iHitJointKnd = FTJointPntKind((*rHid).third);
//			return TRUE;
//		}
//	}
//	// _xZkqqHx_iDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
//	return FALSE;
////----- 05.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCToolPolyEdit::CheckHitJoint.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::IsHitSelectedJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CheckHitJoint _xZkqqHx_iCmFiDhBiDgCiDgHiClFiClNjIeBiMiLjDfPiCkKiBeBjBeJjBpAiNmPiCnNjIeBiMiLjDfPiCkJiCmHiCkEiCkJ_xHqqkZx_
// *			_xZkqqHx_iCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::IsHitSelectedJoint () const
//{
//	return GetHitPolyline().IsSelectedJoint(m_lHitJointIdx);
//} // FCToolPolyEdit::IsHitSelectedJoint.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CheckHitMolip
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiDiCiDiKiDhGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pIgnore	:_xZkqqHx_iMjPiNpFiCpAjGlDiOiLiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiPpDjBnEiCpAiBeBiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ m_iHitOn, m_pHitObj, m_lHitMolip,
// *			m_mmptHitPos _xZkqqHx_iCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolPolyEdit::CheckHitMolip (const FCObjDynabase* pIgnore)
//{
//	// _xZkqqHx_iDiCiDiKiDhGiPoDiCmFiCmMiDhNiDeFiDfIiCmMiDhBiDgCiDgHiPpDjBnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//	m_iMolipKind = FCLinkManager::GetHitOnMolipLine(m_pMolipObj, m_lMolipId,
//											m_mmptMolipPos, m_mmptMsc,
//											m_dwFlags, m_mmptCnv,
//											m_mmlnvAry.begin(), m_mmlnvAry.size(),
//											pIgnore);
//	// FDPA_HIT_NOT_MOLIP _xZkqqHx_iCmFjGlDiCkPiCoKiCmOiDhBiDgCiDgHiBeC_xHqqkZx_
//	return (m_iMolipKind != FDPA_HIT_NOT_MOLIP);
//} // FCToolPolyEdit::CheckHitMolip.
//----- 01.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::OnDrawState (CDC* pDC, int iState)
{
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
//----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case STATE_MOVING_JOINT:		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
//	  {
//		//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiClNiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
//		DrawSelectedBezier(pDC);
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDhDiDhLiDgCiDgHiCmGiIpIjDfPiBeBiIpIjApMiCpAjFgAiJoGiBeC_xHqqkZx_
//		BASE_CLASS::OnDrawState(pDC, iState);
//		// _xZkqqHx_iIpIjApMiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
//		JointSelInfoVector::const_iterator iInf;
//		for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//			(*iInf).DrawPullMark(pDC);
//			break;
//	  }
//----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case STATE_MOVING_PULL:		// _xZkqqHx_iIpIjDfPiInKjDkOjCiGiBeC_xHqqkZx_
	  {
		//----- _xZkqqHx_jApMjFjNiCmMiMhGiOfKiBeC_xHqqkZx_WidePoly_xZkqqHx_iCmMiPoKiNiHiCmNjBnBjFjNiCpAiNgMjHlG_xHqqkZx_ -----
		fmmetol mmfPenW = GetLineObject(GetHitXXX(XXX_JOINT).first)->GetStdPenWeight();
		long lgPenW = mm2lg(mmfPenW);
		//----- WidePoly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		if (GetLineObject(GetHitXXX(XXX_JOINT).first)->IsKindOf(FDOJ_WIDE_POLY))
			lgPenW = 1;
		CRect lgrtClient;
		g_pView->GetClientRectLG(lgrtClient);
		DrawPolyline(pDC, m_vlgptPoint.begin(), m_vlgptPoint.size(), lgPenW, lgrtClient);
		break;
	  }
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDhDiDhLiDgCiDgHiCmGiIpIjDfPiBeBiIpIjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
} // FCToolPolyEdit::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolPolyEdit.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolPolyEdit::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_IDLE:				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (FFCanEditObject())
			//----- _xZkqqHx_jFjEjFgJjFnCiPfHiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
			{
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				if (CheckHitPull())
//					iNextState = STATE_ENTER_MOVE_PULL;		// _xZkqqHx_iIpIjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				// _xZkqqHx_jIeBiMiLjDfPiDhBiDgCiDgHiCmNiNmFjHeEjAoGiCmIiCmMiCmFiBeBiCnMiClIiDhBiDgCiDgHiClFiCmE_xHqqkZx_
				// _xZkqqHx_iCkCiCmIiCkCiClBiCmGiCpAjClCiCnHiCoJiBeC_xHqqkZx_
				if (!CheckHitXXX(XXX_JOINT))
				//----- _xZkqqHx_jIeBiMiLjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
				{
					if (CheckHitPull())
					//----- _xZkqqHx_iIpIjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
					{
						iNextState = STATE_ENTER_MOVE_PULL;		// _xZkqqHx_iIpIjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
					} else
					//----- _xZkqqHx_iIpIjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
					{
						if (CheckHitPolyline())
						//----- _xZkqqHx_jIeBiMiLjDfPiKnEiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
						{
							iNextState = STATE_ENTER_SELECT_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiBeC_xHqqkZx_
						}
					}
				}
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			}
			break;
		case WM_RBUTTONDOWN:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (FFCanEditObject())
			//----- _xZkqqHx_jFjEjFgJjFnCiPfHiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
			{
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				if (!IsControl() && CheckHitPull())
//					iNextState = STATE_ENTER_MOVE_PULL;		// _xZkqqHx_iIpIjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				// _xZkqqHx_jIeBiMiLjDfPiDhBiDgCiDgHiCmNiNmFjHeEjAoGiCmIiCmMiCmFiBeBiCnMiClIiDhBiDgCiDgHiClFiCmE_xHqqkZx_
				// _xZkqqHx_iCkCiCmIiCkCiClBiCmGiCpAjClCiCnHiCoJiBeC_xHqqkZx_
				if (!CheckHitXXX(XXX_JOINT))
				//----- _xZkqqHx_jIeBiMiLjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
				{
					if (!IsControl())
					//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiJjPiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
					{
						if (CheckHitPull())
						//----- _xZkqqHx_iIpIjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
						{
							iNextState = STATE_ENTER_MOVE_PULL;		// _xZkqqHx_iIpIjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
						} else
						//----- _xZkqqHx_iIpIjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
						{
							if (CheckHitPolyline())
							//----- _xZkqqHx_jIeBiMiLjDfPiKnEiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
							{
								iNextState = STATE_ENTER_SELECT_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiBeC_xHqqkZx_
							}
						}
					}
				}
//----- 06.10.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			}
			break;
		}
		break;

//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case STATE_ENTER_SELECT_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAjDpMiMpLiBeC_xHqqkZx_
		if (m_hitJoint2 != InvalidValueXXX(XXX_JOINT))
			iNextState = STATE_CLRSEL_SEL_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiBeC_xHqqkZx_
		break;
//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	case STATE_ENTER_MOVE_PULL:		// _xZkqqHx_iIpIjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_START_MOVE_PULL;	// _xZkqqHx_iIpIjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
		case WM_RBUTTONUP:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_EXIT_MOVE_PULL;	// _xZkqqHx_iIpIjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_START_MOVE_PULL:		// _xZkqqHx_iIpIjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
		iNextState = STATE_MOVING_PULL;		// _xZkqqHx_iIpIjDfPiInKjDkOjCiGiBeC_xHqqkZx_
		break;
	case STATE_MOVING_PULL:			// _xZkqqHx_iIpIjDfPiInKjDkOjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_MOVING_PULL;		// _xZkqqHx_iIpIjDfPiInKjDkOjCiGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
		case WM_RBUTTONUP:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_MOVE_PULL;	// _xZkqqHx_iIpIjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_MOVE_PULL:		// _xZkqqHx_iIpIjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_EXIT_MOVE_PULL;	// _xZkqqHx_iIpIjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
		break;
	case STATE_EXIT_MOVE_PULL:		// _xZkqqHx_iIpIjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
		iNextState = STATE_IDLE;			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolPolyEdit::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_ENTER_MOVE_PULL:		// _xZkqqHx_iIpIjDfPiInKjDkOjDpMiMpLiBeC_xHqqkZx_
		StateEnterMovePull(pDC);
		break;
	case STATE_START_MOVE_PULL:		// _xZkqqHx_iIpIjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
		StateStartMovePull(pDC);
		break;
	case STATE_MOVING_PULL:			// _xZkqqHx_iIpIjDfPiInKjDkOjCiGiBeC_xHqqkZx_
		StateMovingPull(pDC);
		break;
	case STATE_STOP_MOVE_PULL:		// _xZkqqHx_iIpIjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
		StateStopMovePull(pDC);
		break;
	case STATE_EXIT_MOVE_PULL:		// _xZkqqHx_iIpIjDfPiInKjDkOiPgPiMpLiBeC_xHqqkZx_
		StateExitMovePull(pDC);
		break;
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolPolyEdit::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBnCiClPiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::StateIdle (CDC* pDC)
{
	TRACE(_T("StateIdle\r\n"));
//----- 01.07.19 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhBiDgCiDgHiDeKiBfLiDfMiDiLiCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
//	m_iCursorNew = FDPA_HIT_NONE;
//----- 01.07.19 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iIpIjDfPiBeFiDeKiDgJiDiBjDfPiCmMiCkCiClIiCoKiCkJiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoKiCmOiDeKiBfLiDfMiDiLjAnNjCoIiBeC_xHqqkZx_
//----- 01.07.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (CheckHitPull() || CheckHitJoint())
//		::FFSetCurCursor(FFGetApp()->LoadStandardCursor(IDC_SIZEALL));
//----- 01.07.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
// 05.06.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (CheckHitPull() || CheckHitJoint())
	if (CheckHitPull() || CheckHitXXX(XXX_JOINT))
		SetIdleCursor(FFGetApp()->LoadStandardCursor(IDC_SIZEALL));
//----- 01.07.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.07.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhBiDgCiDgHiDeKiBfLiDfMiDiLiCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
	m_iCursorNew = FDPA_HIT_NONE;
//----- 01.07.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGjDjJiBeC_xHqqkZx_
	BASE_CLASS::StateIdle(pDC);
//----- 01.04.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolPolyEdit::StateIdle.

//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateClrselSelXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::StateClrselSelXXX (XXX_Joint, CDC* pDC)
{
	TRACE(_T("FCToolPolyEdit::StateClrselSelXXX\r\n"));
	if (m_hitJoint2 != InvalidValueXXX(XXX_JOINT))
	//----- _xZkqqHx_jIeBiMiLjDfPiKnEjBeJjBpAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jIeBiMiLjDfPiKnEjBeJjBpAiCmMiPoKiNiHiCmNiBeBiDfGiDhEiDgHiDeMiBfLiCmJiKnGiCoNiCoHiClIjBfDiCmEiCpAiJpAiPjMiBeC_xHqqkZx_
		UnselectXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT), pDC);
		// _xZkqqHx_jBeJjBpAiCmJjCmHiJmBiBeC_xHqqkZx_
		SelectXXX(XXX_JOINT, GetHitXXX(XXX_JOINT), pDC);
		SelectXXX(XXX_JOINT, m_hitJoint2, pDC);
	} else
	//----- _xZkqqHx_jIeBiMiLjDfPiKnEjBeJjBpAiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::StateClrselSelXXX(XXX_JOINT, pDC);
	}
} // FCToolPolyEdit::StateClrselSelXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateStartMoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiKeKiOgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::StateStartMoveXXX (XXX_Joint, CDC* pDC)
{
	TRACE(_T("FCToolPolyEdit::StateStartMoveXXX\r\n"));
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::StateStartMoveXXX(XXX_JOINT, pDC);
	if (m_hitJoint2 != InvalidValueXXX(XXX_JOINT))
	//----- _xZkqqHx_jIeBiMiLjDfPiKnEjBeJjBpAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		const FCPolyJoint polyJoint0 = GetHitJoint();
		const FCPolyJoint polyJoint1 = m_vPolyLine[m_hitJoint2.first][m_hitJoint2.second];
		if (!almosteq(polyJoint0.GetPivotPoint(), polyJoint1.GetPivotPoint()))
		//----- _xZkqqHx_iCfBjIeBiMiLjDfPiCkKjHkDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_jIeBiMiLjDfPiKnEiCmMjApMiCmGiBeBiClLiCmMjAiCjApMiCpAiInKjDkOjApMiCmJjAnNjCoI_xHqqkZx_ -----
			m_mmlnvAry.clear();
			const DBLLine mmln0(polyJoint0.GetPivotPoint(), polyJoint1.GetPivotPoint());
			const DBLLine mmln1 = mmln0.GetCrossLine(polyJoint0.GetPivotPoint());
			m_mmlnvAry.push_back(mmln1);
			m_mmlnvAry.push_back(mmln0);
		}
	}
} // FCToolPolyEdit::StateStartMoveXXX.
//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateEnterMoveJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiInKjDkOjDpMiMpLiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateEnterMoveJoint (CDC* pDC)
//{
//	TRACE(_T("StateEnterMoveJoint\r\n"));
//	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
//	::FFSetCapture(g_pView->m_hWnd);
//
//	//////////////////////// _xZkqqHx_iInKjDkOjApMjAnNjCoIiPiIjHjN_xHqqkZx_ ///////////////////////////
//	// _xZkqqHx_iInKjDkOjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_mmptMov = GetHitJoint().m_mmptPivot;
//	// _xZkqqHx_iMmFjCoIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_mmptFix = m_mmptMov;
//	// _xZkqqHx_iInKjDkOjBePiCmMiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_mmptFirst = m_mmptMov;
//
//	//----- _xZkqqHx_jAiFjFlNiBeFjAiCjClMjApMiCpAiInKjDkOjApMiCmJjAnNjCoI_xHqqkZx_ -----
//	m_mmlnvAry.clear();
//	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(10,0)));
//	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(0,10)));
//
//	//----- _xZkqqHx_jClMjBePiCmMjIeBiMiLjDfPiBeFjClMiMoDiCmMjIeBiMiLjDfPiCmGiInKjDkOjApMiCmMiPiIjHjN_xHqqkZx_ -----
//	DBLPoint mmptTmp;
//	if (GetHitJoint().m_nType & 0x01)
//	//----- _xZkqqHx_jBePiIpIjDfPiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		if (0 < GetHitXXX(XXX_JOINT).second)
//		//----- _xZkqqHx_jAoGjDkKjIeBiMiLjDfPiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfAiCmCjBePiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
//			mmptTmp = GetHitJoint(-1).m_mmptPivot;
//			if (mmptTmp != m_mmptFix)
//				m_mmlnvAry.push_back(DBLLine(m_mmptFix, mmptTmp));
//		} else if (!GetHitPolyline().IsOpen())
//		//----- _xZkqqHx_jAoGjDkKjIeBiMiLjDfP_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_jFmCiLmIjApMiCmFiCkAiCoJiOjO_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfAiCmCjBePiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
//			mmptTmp = GetHitPolyline().back().m_mmptPivot;
//			if (mmptTmp != m_mmptFix)
//				m_mmlnvAry.push_back(DBLLine(m_mmptFix, mmptTmp));
//		}
//	}
//	if (GetHitJoint().m_nType & 0x04)
//	//----- _xZkqqHx_iMoDiIpIjDfPiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		if (GetHitXXX(XXX_JOINT).second < GetHitPolyline().size() - 1)
//		//----- _xZkqqHx_iNmFiPeJjIeBiMiLjDfPiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfAiCmCiMoDiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
//			mmptTmp = GetHitJoint(+1).m_mmptPivot;
//			if (mmptTmp != m_mmptFix)
//				m_mmlnvAry.push_back(DBLLine(m_mmptFix, mmptTmp));
//		} if (!GetHitPolyline().IsOpen())
//		//----- _xZkqqHx_iNmFiPeJjIeBiMiLjDfP_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_jFmCiLmIjApMiCmFiCkAiCoJiOjO_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfAiCmCiMoDiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
//			mmptTmp = GetHitPolyline().front().m_mmptPivot;
//			if (mmptTmp != m_mmptFix)
//				m_mmlnvAry.push_back(DBLLine(m_mmptFix, mmptTmp));
//		}
//	}
//	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGiBeCiDhDiDhLiDgCiDgHiImKjChFjFfMiOkGiBeC_xHqqkZx_
//	FFGetMainWnd()->MoveRulerMMK(1, m_mmptMov);
//} // FCToolPolyEdit::StateEnterMoveJoint.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StatePreMoveJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiInKjDkOjBePiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StatePreMoveJoint (CDC* pDC)
//{
//	TRACE(_T("StatePreMoveJoint\r\n"));
//	//----- _xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
////----- 05.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	m_lLastPolygonIdx = m_pHitJointInf - m_vPolyLine.begin();	// _xZkqqHx_jIeBiMiLjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////	m_lLastJointIdx = GetHitXXX(XXX_JOINT).second;							// _xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////----- 05.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	SetLastSelectedXXX(XXX_JOINT, GetHitXXX(XXX_JOINT));
////----- 05.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCToolPolyEdit::StatePreMoveJoint.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateUnselJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjBeJjBpAjGjFiPmBiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateUnselJoint (CDC* pDC)
//{
//	TRACE(_T("StateUnselJoint\r\n"));
//	// _xZkqqHx_jBeJjBpAiJpAiPjMiBeC_xHqqkZx_
//	UnselectJoint(GetHitPolyline(), GetHitXXX(XXX_JOINT).second, pDC);
//} // FCToolPolyEdit::StateUnselJoint.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateClrselSelJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjBeJjBpAiPmBiLiOjCmHiJmBiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateClrselSelJoint (CDC* pDC)
//{
//	TRACE(_T("StateClrselSelJoint\r\n"));
//	// Shift_xZkqqHx_iCkKiJjPiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//	if (!IsShift()) UnselectAllXXX(XXX_JOINT, pDC);
//	// _xZkqqHx_jIeBiMiLjDfPiCpAjBeJjBpAiCmJjCmHiJmBiBeC_xHqqkZx_
//	SelectJoint(GetHitPolyline(), GetHitXXX(XXX_JOINT).second, pDC);
//} // FCToolPolyEdit::StateClrselSelJoint.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.09.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateStartMoveJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiInKjDkOiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateStartMoveJoint (CDC* pDC)
//{
//	TRACE(_T("StateStartMoveJoint\r\n"));
////----- 05.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
//	::FFSetCapture(g_pView->m_hWnd);
//
//	//////////////////////// _xZkqqHx_iInKjDkOjApMjAnNjCoIiPiIjHjN_xHqqkZx_ ///////////////////////////
//	// _xZkqqHx_iInKjDkOjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_mmptMov = GetHitJoint().m_mmptPivot;
//	// _xZkqqHx_iMmFjCoIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_mmptFix = m_mmptMov;
////----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iInKjDkOjBePiCmMiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
////	m_mmptFirst = m_mmptMov;
////----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	//----- _xZkqqHx_jAiFjFlNiBeFjAiCjClMjApMiCpAiInKjDkOjApMiCmJjAnNjCoI_xHqqkZx_ -----
//	m_mmlnvAry.clear();
//	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(10,0)));
//	m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptFix + DBLPoint(0,10)));
//
//	//----- _xZkqqHx_jClMjBePiCmMjIeBiMiLjDfPiBeFjClMiMoDiCmMjIeBiMiLjDfPiCmGiInKjDkOjApMiCmMiPiIjHjN_xHqqkZx_ -----
//	DBLPoint mmptTmp;
//	if (GetHitJoint().m_nType & 0x01)
//	//----- _xZkqqHx_jBePiIpIjDfPiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		if (0 < GetHitXXX(XXX_JOINT).second)
//		//----- _xZkqqHx_jAoGjDkKjIeBiMiLjDfPiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfAiCmCjBePiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
//			mmptTmp = GetHitJoint(-1).m_mmptPivot;
//			if (mmptTmp != m_mmptFix)
//				m_mmlnvAry.push_back(DBLLine(m_mmptFix, mmptTmp));
//		} else if (!GetHitPolyline().IsOpen())
//		//----- _xZkqqHx_jAoGjDkKjIeBiMiLjDfP_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_jFmCiLmIjApMiCmFiCkAiCoJiOjO_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfAiCmCjBePiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
//			mmptTmp = GetHitPolyline().back().m_mmptPivot;
//			if (mmptTmp != m_mmptFix)
//				m_mmlnvAry.push_back(DBLLine(m_mmptFix, mmptTmp));
//		}
//	}
//	if (GetHitJoint().m_nType & 0x04)
//	//----- _xZkqqHx_iMoDiIpIjDfPiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		if (GetHitXXX(XXX_JOINT).second < GetHitPolyline().size() - 1)
//		//----- _xZkqqHx_iNmFiPeJjIeBiMiLjDfPiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfAiCmCiMoDiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
//			mmptTmp = GetHitJoint(+1).m_mmptPivot;
//			if (mmptTmp != m_mmptFix)
//				m_mmlnvAry.push_back(DBLLine(m_mmptFix, mmptTmp));
//		} if (!GetHitPolyline().IsOpen())
//		//----- _xZkqqHx_iNmFiPeJjIeBiMiLjDfP_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_jFmCiLmIjApMiCmFiCkAiCoJiOjO_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfAiCmCiMoDiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
//			mmptTmp = GetHitPolyline().front().m_mmptPivot;
//			if (mmptTmp != m_mmptFix)
//				m_mmlnvAry.push_back(DBLLine(m_mmptFix, mmptTmp));
//		}
//	}
//	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGiBeCiDhDiDhLiDgCiDgHiImKjChFjFfMiOkGiBeC_xHqqkZx_
//	FFGetMainWnd()->MoveRulerMMK(1, m_mmptMov);
////----- 05.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
//	g_pView->SetAutoScroll(TRUE);
//
//	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjBePiCmMiNmEjFgAiJoGjHmMiIoGiBeC_xHqqkZx_
//	m_mmrtPreRegion.SetRect(0,0,0,0);
//	//----- _xZkqqHx_jFmPiNfIjBmOiPnLiCmGiCmIiCoJiLoJiMgAjHmMiIoGiCpAiCkAiCoHiCkJiClGiCnPiDiKiBfLiDfHiDiHiDjDiCmJiLeMjIfO_xHqqkZx_ -----
//	JointSelInfoVector::iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//	{
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKjGlDiCkCiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if ((*iInf).GetSelJointVector().empty()) continue;
//		JointSeqVector vJntSeq;
//		//----- _xZkqqHx_jIeBiMiLjDfPiInKjDkOiCmJjEpFiCkGiCmEiIpIjApMiCpAiPmBiLiOiClHiCoJ_xHqqkZx_ -----
//		(*iInf).DrawPullMark(pDC);
//		//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjFmPiNfIiCmJiCoGiCmBiCmEiJgFiLlPiCpAiOpDiCkPiCoJiClHiCnHiCmEiCmM_xHqqkZx_
//		//		_xZkqqHx_jIeBiMiLjDfPiCmMiPfHiNiHiCpA_xHqqkZx_ JointSeq::lStart _xZkqqHx_iCmG_xHqqkZx_ JointSeq::lSize _xZkqqHx_iCmJjFnEiClH_xHqqkZx_ -----
//		(*iInf).GetAffected(vJntSeq);
//		//----- vJntSeq _xZkqqHx_iCmFjFfMiClDiCoKiCoJjIeBiMiLjDfPiPfHiNiHiCmJjBmOiClFiCmE_xHqqkZx_
//		//		_xZkqqHx_iDhIiDfHiDeHiLmIjApMiCpAiNmEiMhGiOfKiClHiCoJ_xHqqkZx_							-----
//		JointSeqVector::const_iterator iS;
//		for (iS = vJntSeq.begin(); iS != vJntSeq.end(); iS++)
//		{
//			CPointVector vlgptPoint;
//			CRect lgrtClip;	// _xZkqqHx_iDhIiDfHiDeHiLmIjApMiCmJiKePjAnKiClHiCoJiLoJiMgAiBeC_xHqqkZx_
//			// _xZkqqHx_iOhHjCoIiLoGiKnEiCmMiDhIiDfHiDeHiLmIjApMiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiOfKiPgPiBeC_xHqqkZx_
//			CalcBezierAndClip(vlgptPoint, lgrtClip, *iInf, *iS);
//			// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjBePiCmMiNmEjFgAiJoGjHmMiIoGiCmJjAnNjCoIiBeC_xHqqkZx_
//			m_mmrtPreRegion |= lg2mm(lgrtClip);
//			vlgptPoint.clear();
//		}
//	}
//	//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoJiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
//	DrawSelectedBezier(pDC);
//	//----- _xZkqqHx_iInKjDkOiClHiCoJjIeBiMiLjDfPiCmJiDhNiBfLiDeOiCpAjFgAiJoG_xHqqkZx_ -----
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//		(*iInf).DrawPivotMark(pDC);
//
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_
//	// StateReLink_xZkqqHx_iCmM_xHqqkZx_ReLink_xZkqqHx_jDjJiCmFiDfCiDhNiDjDiDgIiPiIjHjNiCkKiOmAiNhDiClDiCoKiCoJiClNiCnPiBeBiClBiClBiCmF_xHqqkZx_
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCpAiKeKiOgOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//} // FCToolPolyEdit::StateStartMoveJoint.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateMovingJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiInKjDkOjCiGiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateMovingJoint (CDC* pDC)
//{
//	TRACE(_T("StateMovingJoint\r\n"));
//	// _xZkqqHx_iDhBiDgCiDgHiDeKiBfLiDfMiDiLiCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
//	m_iCursorNew = FDPA_HIT_NONE;
//
//	if (IsControl())
//	//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiDhNiDeFiDfIjBiAiNoMiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMjPiNpFiCpAiDhAiDfIiClHiCoJiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
//		FTMolipSet stIgnore;
//		stIgnore.insert(FCMolipRec(GetHitPolyline().GetObject()->GetObjID(), -1));
//		// _xZkqqHx_iDiCiDiKiDhGiMjPiNpFiBeCiDiKiDjDiDeOjAoGiCkKiOkJjFkKiOkJjAgHiCmIiCoHiCmOiMjPiNpFjGlDiOiLiBeC_xHqqkZx_
//		DBLPoint mmptHitPos;
//		m_iCursorNew = FCLinkManager::GetHitOnMolipLine(m_pHitMolipObj, m_lHitMolip,
//												mmptHitPos, m_mmptMsc,
//												m_dwFlags, m_mmptCnv,
//												m_mmlnvAry.begin(), m_mmlnvAry.size(),
//												&stIgnore);
//
//		// _xZkqqHx_iDiCiDiKiDhGiPoDiDhBiDgCiDgHiCmMiPoKiNiHiCmNiBeBiDhNiDeFiDfIiNmAjFfHiCpAiDiCiDiKiDhGiNmAjFfHiCmJjFoCjAlDiBeC_xHqqkZx_
//		if (m_iCursorNew != FDPA_HIT_NOT_MOLIP) m_mmptCnv = mmptHitPos;
//		switch (m_iCursorNew)
//		{
//		case FDPA_HIT_POINT_MOLIP:	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
//			m_dwJointLinkKind = FDLM_LINK_ON_COORD;
//			break;
//		case FDPA_HIT_LINE_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
//			m_dwJointLinkKind = FDLM_LINK_ON_RATIO;
//			break;
//		case FDPA_HIT_POL_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
//			m_dwJointLinkKind = FDLM_LINK_ON_ANGLE;
//		}
//	}
//	// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
//	const DBLPoint mmptDif = m_mmptCnv - m_mmptMov;
//	if (!mmptDif.IsNull())
//	//----- _xZkqqHx_iInKjDkOjHmKiCkKiCePiCmFiCmIiCkCiCmIiCoHiCmOjApMiCmMjFgAiJoGiPiIjHjN_xHqqkZx_ -----
//	{
//		//----- _xZkqqHx_iInKjDkOiClHiCoJjIeBiMiLjDfPiCmMiDhNiBfLiDeOiCpAiPmBiLiO_xHqqkZx_ -----
//		JointSelInfoVector::iterator iInf;
//		for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//			(*iInf).DrawPivotMark(pDC);
//		//----- _xZkqqHx_jBePiJpBjFgAiJoGiClFiClNiLmIjApMiCpAiPmBiLiO_xHqqkZx_ -----
//		DrawSelectedBezier(pDC);
//		//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiClHiCnHiCmE_xHqqkZx_mmptDif_xZkqqHx_iClOiCkPiInKjDkO_xHqqkZx_ -----
//		for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//			(*iInf).MovePivot(mmptDif);
//		//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiClNiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
//		DrawSelectedBezier(pDC);
//		//----- _xZkqqHx_iInKjDkOiClFiClNjIeBiMiLjDfPiCmJiDhNiBfLiDeOiCpAjFgAiJoG_xHqqkZx_ -----
//		for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//			(*iInf).DrawPivotMark(pDC);
//		// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiNmAjFfHiCpAiNmEjAnNjCoIiBeC_xHqqkZx_
//		m_mmptMov = m_mmptCnv;
//	}
//	// BASE_CLASS::StateIdle_xZkqqHx_iCmFiCmMiBeBiDeKiBfLiDfMiDiLiImKjChFjFfMiOkGiCmJjEpFiCkGiCmEiBeB_xHqqkZx_m_mmptMsc = m_mmptMov_xZkqqHx_iCmJiBeC_xHqqkZx_
//	const DBLPoint mmptMscBak = m_mmptMsc;
//	m_mmptMsc = m_mmptMov;
//	// _xZkqqHx_iDeKiBfLiDfMiDiLjFfMiOkGiBeCiInKjDkOjHmKiCkKiCePiCmFiCoAiBeBiDiKiDjDiDeOiMgAiOkOjFmPiNfIiCmMjFfMiOkGiCmMjFeLjHhGiCkKiCkAiCoJiClNiCnPjFeLjHhGiBeC_xHqqkZx_
//	BASE_CLASS::StateIdle(pDC);
//	// m_mmptMsc = m_mmptMov _xZkqqHx_iCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
//	m_mmptMsc = mmptMscBak;
//} // FCToolPolyEdit::StateMovingJoint.
//----- 05.09.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 05.09.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateContextMenuJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiDiBiDgKiDiFiBfL_xHqqkZx___xZkqqHx_jIeBiMiLjDfPiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateContextMenuJoint (CDC* pDC)
//{
//	TRACE(_T("FCToolPolyEdit::StateContextMenuJoint\r\n"));
//	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeCiDiBiDgKiDiFiBfLiPeJjHlJiOjOiCmJiDhMiDgCiDhGiDeBiDgCiDhGiPeJjHlJiDfCiDhNiDjDiDgIiCpAjBjHjAeNiBeC_xHqqkZx_
//	PopupLinkMenu();
//} // FCToolPolyEdit::StateContextMenuJoint.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateJointLinkCommand
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateJointLinkCommand (CDC* pDC)
//{
//	TRACE(_T("FCToolPolyEdit::StateJointLinkCommand\r\n"));
//	// _xZkqqHx_iDiKiDjDiDeOiOoNiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_dwJointLinkKind = CommandToLinkKind(m_dwCommand, m_lHitMolip == -1);
//} // FCToolPolyEdit::StateJointLinkCommand.
//----- 05.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateReLink
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOjFhEjBnGiCkGiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateReLink (CDC* pDC)
//{
//	TRACE(_T("FCToolPolyEdit::StateReLink\r\n"));
//	if (m_pHitMolipObj == NULL ||
//		m_iCursorNew == FDPA_HIT_NONE ||
//		m_iCursorNew == FDPA_HIT_NOT_MOLIP) return;
//	FCMolipRec linkFrom(m_pHitMolipObj->GetObjID(), m_lHitMolip);
//	FTMolipSet stLinkTo;
//	stLinkTo.insert(FCMolipRec(GetHitPolyline().GetObject()->GetObjID(),
//					JointIDtoMolipID(GetHitXXX(XXX_JOINT).second)));
//	WORD wLinkKindA = m_dwJointLinkKind & 0xffff;
//	WORD wLinkKindB = m_dwJointLinkKind >> 16;
//	FCLinkManager::ReLink(linkFrom, stLinkTo, wLinkKindA);
//	FCLinkManager::ReLink(stLinkTo, linkFrom, wLinkKindB);
//
//	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjIeBiMiLjDfPiCpAiDgAiDeGiDgCiDeO_xHqqkZx_ -----
//	long lSelSize = 0;
//	JointSelInfoVector::const_iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//		lSelSize += (*iInf).GetSelJointVector().size();
//	if (lSelSize != 1) return;
//	if (GetHitXXX(XXX_JOINT).second != 0 &&
//		GetHitXXX(XXX_JOINT).second != GetHitPolyline().size() - 1) return;
//	if (wLinkKindA == FDLM_LINK_ON_ANGLE)
//	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
//	{
//		FCBezierControls bc;
//		mmetol mmArrowAutoGap;
//		if (GetHitXXX(XXX_JOINT).second == 0)
//		{
//			bc.A() = GetHitPolyline()[0].m_mmptPivot;
//			bc.B() = GetHitPolyline()[0].m_mmptPivot + GetHitPolyline()[0].m_mmptNext;
//			bc.C() = GetHitPolyline()[1].m_mmptPivot + GetHitPolyline()[1].m_mmptPrev;
//			bc.D() = GetHitPolyline()[1].m_mmptPivot;
//			mmArrowAutoGap = g_pReg->GetFrontArrowAutoGap();
//		} else
//		{
//			bc.A() = GetHitJoint().m_mmptPivot;
//			bc.B() = GetHitJoint().m_mmptPivot + GetHitJoint().m_mmptPrev;
//			bc.C() = GetHitJoint(-1).m_mmptPivot + GetHitJoint(-1).m_mmptNext;
//			bc.D() = GetHitJoint(-1).m_mmptPivot;
//			mmArrowAutoGap = g_pReg->GetBackArrowAutoGap();
//		}
//		if (m_pHitMolipObj->CalcMolipCrossedControlPoint(bc, mmArrowAutoGap, m_lHitMolip))
//		{
//			// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
//			const DBLPoint mmptDif = bc.A() - m_mmptMov;
//			//----- _xZkqqHx_iInKjDkOiClHiCoJjIeBiMiLjDfPiCmMiDhNiBfLiDeOiCpAiPmBiLiO_xHqqkZx_ -----
//			GetHitPolyline().DrawPivotMark(pDC);
//			//----- _xZkqqHx_jBePiJpBjFgAiJoGiClFiClNiLmIjApMiCpAiPmBiLiO_xHqqkZx_ -----
//			DrawSelectedBezier(pDC);
//			//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiClHiCnHiCmE_xHqqkZx_mmptDif_xZkqqHx_iClOiCkPiInKjDkO_xHqqkZx_ -----
//			GetHitPolyline().MovePivot(mmptDif);
//			//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiClNiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
//			DrawSelectedBezier(pDC);
//			//----- _xZkqqHx_iInKjDkOiClFiClNjIeBiMiLjDfPiCmJiDhNiBfLiDeOiCpAjFgAiJoG_xHqqkZx_ -----
//			GetHitPolyline().DrawPivotMark(pDC);
//			// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiNmAjFfHiCpAiNmEjAnNjCoIiBeC_xHqqkZx_
//			m_mmptMov = bc.A();
//		}
//	}
//} // FCToolPolyEdit::StateReLink.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateStopMoveJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiInKjDkOiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateStopMoveJoint (CDC* pDC)
//{
//	TRACE(_T("StateStopMoveJoint\r\n"));
//	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
//	g_pView->SetAutoScroll(FALSE);
//
//	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjBePiCmMiNmEjFgAiJoGjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AddRgn(m_mmrtPreRegion);
//	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
//	FTMolipSet setMolip;
//	CRect lgrtClip;			// _xZkqqHx_iDhIiDfHiDeHiLmIjApMiCmJiKePjAnKiClHiCoJiLoJiMgAiBeC_xHqqkZx_
//	JointSeqVector vJntSeq;	// _xZkqqHx_jIeBjBlBiClHiCoJjIeBiMiLjDfPiCmMiPfHiNiHiBeC_xHqqkZx_
//	//----- _xZkqqHx_jFmPiNfIiMoDiCmMiLoJiMgAjHmMiIoGiCpAiDiKiBfLiDfHiDiHiDjDiCmJiLeMjIfO_xHqqkZx_ -----
//	JointSelInfoVector::iterator iInf;
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//	{
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKjGlDiCkCiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if ((*iInf).GetSelJointVector().empty()) continue;
//		// _xZkqqHx_jIeBiMiLjDfPiCmMiIpIjApMiCpAjFgAiJoGiClHiCoJiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiDiKiBfLiDfHiDiHiDjD_xHqqkZx_
//		// _xZkqqHx_iCmJiKhMiCkJiCoHiCmIiCkCiIpIjApMiCmMiIoKjFjEiCmN_xHqqkZx_RgnRedraw_xZkqqHx_iCmFjFgAiCkJiCoKiCmIiCkCiBeC_xHqqkZx_
//		(*iInf).DrawPullMark(pDC);
//		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiDhMiDiKiDfDiDjDjFjNiCmJiBeBiKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmMiKnEiCmFjFmPiJlLiCkKiCkAiCoJiPoKiNiHiBeB_xHqqkZx_
//		// _xZkqqHx_iIoKjFjEiCmMiDhMiDiKiDfDiDjDjClHiCkKjFmPiJlLiClFiClNiClOiCkPiCmFjFjEjFgJjBfDjBmMiCmMiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
//		BOOL bSlope = FALSE;
//		if ((*iInf).GetObject()->IsKindOf(FDOJ_WIDE_POLY))
//		//----- WidePoly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			const FCObjWidePoly* pWide = (const FCObjWidePoly*)(*iInf).GetObject();
//			if (!almosteq(pWide->GetPolyWidthF(), pWide->GetPolyWidthB()))
//				bSlope = TRUE;
//		}
//		if (bSlope)
//		//----- _xZkqqHx_jFjNiNeMjApMiCmFiKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmJiMfIiOmOiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iInKjDkOjBePiCmMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AddRgn((*iInf).GetObject());
//		} else
//		//----- _xZkqqHx_iKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmJiMfIiOmOiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMiPfHiNiHiCmMjFmPiNfIiCmJiCoGiCmBiCmEiJgFiLlPiCpAiOpDiCkPiCoJ_xHqqkZx_
//			// _xZkqqHx_iClHiCnHiCmEiCmMjIeBiMiLjDfPiCmMiPfHiNiHiCpA_xHqqkZx_ vJntSeq _xZkqqHx_iCmJjFnEiClHiBeC_xHqqkZx_
//			(*iInf).GetAffected(vJntSeq);
//			// vJntSeq _xZkqqHx_iCmFjFfMiClDiCoKiCoJjIeBiMiLjDfPiPfHiNiHiCmJjBmOiClFiCmEiDhIiDfHiDeHiLmIjApMiCpAiNmEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//			JointSeqVector::const_iterator iS;
//			for (iS = vJntSeq.begin(); iS != vJntSeq.end(); iS++)
//			{
//				CPointVector vlgptPoint;
//				// _xZkqqHx_iOhHjCoIiLoGiKnEiCmMiDhIiDfHiDeHiLmIjApMiCmGiKePjAnKiDhEiDiMiBfLiDiAiCpAiOfKiPgPiBeC_xHqqkZx_
//				CalcBezierAndClip(vlgptPoint, lgrtClip, *iInf, *iS);
//				// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoI_xHqqkZx_.
//				g_pView->AddRgn(lgrtClip);
//				vlgptPoint.clear();
//			}
//		}
////----- 05.09.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		g_pDoc->CmdMoveJoints((*iInf).GetObject(), (*iInf).GetSelJointVector(),
////								m_mmptMov - m_mmptFirst);
////----- 05.09.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		g_pDoc->CmdMoveJoints((*iInf).GetObject(), (*iInf).GetSelJointVector(),
//								m_mmptMov - m_mmptFix);
////----- 05.09.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		if (bSlope)
//		//----- _xZkqqHx_jFjNiNeMjApMiCmFiKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmJiMfIiOmOiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iInKjDkOiMoDiCmMiDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn((*iInf).GetObject());
//		}
//		// _xZkqqHx_iInKjDkOiClFiClNjBfDiCmEiCmMjIeBiMiLjDfPiCmJiKnGiClFiCmEiBeBiDiKiDjDiDeOjAoGjCmKjCgNiPiIjHjNiBeC_xHqqkZx_
//		longVector::const_iterator iIdx;
//		for (iIdx = (*iInf).GetSelJointVector().begin();
//			 iIdx != (*iInf).GetSelJointVector().end(); iIdx++)
//		{
//			// _xZkqqHx_iInKjDkOiClFiClNjIeBiMiLjDfPiDiCiDiKiDhGiCmGiBeBiClLiCmMjBePiMoDiCmMjIeBiMiLjDfPiKnEiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
//			setMolip.insert(FCMolipRec((*iInf).GetObject()->GetObjID(),
//										JointIDtoMolipID(*iIdx)));
//			setMolip.insert(FCMolipRec((*iInf).GetObject()->GetObjID(),
//									JointIDtoMolipID(*iIdx) + 1));
//			if (*iIdx == 0)
//				setMolip.insert(FCMolipRec((*iInf).GetObject()->GetObjID(),
//						JointIDtoMolipID((*iInf).size() - 1) + 1));
//			else
//				setMolip.insert(FCMolipRec((*iInf).GetObject()->GetObjID(),
//									JointIDtoMolipID(*iIdx) - 1));
//		}
//	}
//	// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
//	g_pDoc->LinkManager()->MovedNotify(setMolip);
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
//	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
//	OnSelectObjModified();
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
//	//_xZkqqHx_iInKjDkOjApMiCpAiJpAiPjMiBeC_xHqqkZx_
//	m_mmlnvAry.clear();
////----- 05.09.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiBeC_xHqqkZx_
////	::FFReleaseCapture();
////----- 05.09.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//} // FCToolPolyEdit::StateStopMoveJoint.
//----- 05.09.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateExitMoveJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiInKjDkOiPgPiMpLiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateExitMoveJoint (CDC* pDC)
//{
//	TRACE(_T("StateExitMoveJoint\r\n"));
//	//_xZkqqHx_iInKjDkOjApMiCpAiJpAiPjMiBeC_xHqqkZx_
//	m_mmlnvAry.clear();
//	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiBeC_xHqqkZx_
//	::FFReleaseCapture();
//} // FCToolPolyEdit::StateExitMoveJoint.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateStopEncloseJoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjBeJjBpAiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::StateStopEncloseJoint (CDC* pDC)
//{
//	TRACE(_T("StateStopEncloseJoint\r\n"));
////----- 01.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
////	g_pView->SetAutoScroll(FALSE);
////	FocusFrameDrawEnd(pDC);
////----- 01.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIiDhEiDiMiBfLiDiAiPmBiLiOjDjJiBeC_xHqqkZx_
//	BASE_CLASS::StateStopEncloseJoint(pDC);
//	JointSelInfoVector::iterator iInf;
//	DBLRect mmrtFocus = GetFocusFrame(XXX_JOINT);
//	if (IsShift())
//	//----- _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBiLoJiMgAjDoAiCmJiCkAiCoJiPoKiNiHiCmNjBeJjBpAiBeFjGkCjBeJjBpAiCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
//		for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//			for (long lJoint = 0; lJoint < (*iInf).size(); lJoint++)
//			{
//				if (mmrtFocus.PtInRect((*iInf)[lJoint].m_mmptPivot))
//				{
//					if ((*iInf).IsSelectedJoint(lJoint))
//						UnselectJoint(*iInf, lJoint, pDC);
//					else
//						SelectJoint(*iInf, lJoint, pDC);
//				}
//			}
//	} else
//	//----- _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCkKiJjPiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiBeBiNkBiCmMjBeJjBpAjIeBiMiLjDfPiCpAiJpAiPjMiBeC_xHqqkZx_
//		UnselectAllXXX(XXX_JOINT, pDC);
//		// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBiLoJiMgAjDoAiCmJiCkAiCoJiPoKiNiHiCmNjBeJjBpAiClHiCoJiBeC_xHqqkZx_
//		for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//			for (long lJoint = 0; lJoint < (*iInf).size(); lJoint++)
//			{
//				if (mmrtFocus.PtInRect((*iInf)[lJoint].m_mmptPivot))
//					SelectJoint(*iInf, lJoint, pDC);
//			}
//	}
//
////----- 01.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiBeC_xHqqkZx_
////	::FFReleaseCapture();
////----- 01.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//} // FCToolPolyEdit::StateStopEncloseJoint.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateEnterMovePull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjDfPiInKjDkOjDpMiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::StateEnterMovePull (CDC* pDC)
{
	TRACE(_T("StateEnterMovePull\r\n"));
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);
	DBLPoint mmptTmp;
	if (m_iHitJointKnd == FDPK_PREV_PULL)
	//----- _xZkqqHx_jBePiIpIjDfPiCmF_xHqqkZx_B_xZkqqHx_iDfPiDeFiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iInKjDkOjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
		m_mmptMovPull = GetHitJoint().m_mmptPivot +
							GetHitJoint().m_mmptPrev;
		// _xZkqqHx_iInKjDkOjApMiCmMiInHiBeBiMoDiIpIjDfPiCpAiLeMjIfOiBeC_xHqqkZx_
		mmptTmp = GetHitJoint().m_mmptPivot +
							GetHitJoint().m_mmptNext;
	} else
	//----- _xZkqqHx_iMoDiIpIjDfPiCmF_xHqqkZx_B_xZkqqHx_iDfPiDeFiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iInKjDkOjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
		m_mmptMovPull = GetHitJoint().m_mmptPivot +
							GetHitJoint().m_mmptNext;
		// _xZkqqHx_iInKjDkOjApMiCmMiInHiBeBjBePiIpIjDfPiCpAiLeMjIfOiBeC_xHqqkZx_
		mmptTmp = GetHitJoint().m_mmptPivot +
							GetHitJoint().m_mmptPrev;
	}
	//////// _xZkqqHx_iLkEjCmKiPiIjHjN_xHqqkZx_ ////////
	// _xZkqqHx_iMmFjCoIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmptFix = GetHitJoint().m_mmptPivot;
	//----- _xZkqqHx_iInKjDkOjApMiCpAjAnNjCoI_xHqqkZx_ -----
	m_mmlnvAry.clear();
//----- 06.12.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_mmptFix != m_mmptMovPull)
//		m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptMovPull));
//	else if (m_mmptFix != mmptTmp)
//		m_mmlnvAry.push_back(DBLLine(m_mmptFix, mmptTmp));
//----- 06.12.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!abouteq(m_mmptFix, m_mmptMovPull))
		m_mmlnvAry.push_back(DBLLine(m_mmptFix, m_mmptMovPull));
	else
	if (!abouteq(m_mmptFix, mmptTmp))
		m_mmlnvAry.push_back(DBLLine(m_mmptFix, mmptTmp));
//----- 06.12.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGiBeCiIpIjDfPiImKjChFjFfMiOkGiBeC_xHqqkZx_
	FFGetMainWnd()->MoveRulerMMK(1, m_mmptMovPull);
} // FCToolPolyEdit::StateEnterMovePull.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateStartMovePull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjDfPiInKjDkOiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::StateStartMovePull (CDC* pDC)
{
	TRACE(_T("StateStartMovePull\r\n"));
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
	g_pView->SetAutoScroll(TRUE);
//----- 05.09.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiOoGjDlO_xHqqkZx_ -----
//	CRect lgrtClient;
//	g_pView->GetClientRectLG(lgrtClient);
//	//----- _xZkqqHx_iJgFiLlPjEmNiImNiCpAiMhGiOfK_xHqqkZx_ -----
//	JointSeq jntSeq;	// _xZkqqHx_jIeBjBlBiClHiCoJjIeBiMiLjDfPiBeC_xHqqkZx_
//	GetHitPolyline().FCPolyJointVector::GetAffected(jntSeq, GetHitXXX(XXX_JOINT).second);
//	//----- _xZkqqHx_iNmFiPiJiCmMiIoKiJpBiClOiCkPiBeBiNmEjFgAiJoGiCmMiDiKiBfLiDfHiDiHiDjDjHhAiCmJ_xHqqkZx_
//	//		_xZkqqHx_iInKjDkOjBePiCmMiLoJiMgAjHmMiIoGiCpAiMhGiOfK_xHqqkZx_					-----
//	// _xZkqqHx_iOhHjCoIiLoGiKnEiCmMiDhIiDfHiDeHiLmIjApMiCmGiKePjAnKiDhEiDiMiBfLiDiAiCpAiOfKiPgPiBeC_xHqqkZx_
//	CRect lgrtClip;				// _xZkqqHx_iDhIiDfHiDeHiLmIjApMiCmJiKePjAnKiClHiCoJiLoJiMgAiBeC_xHqqkZx_
//	CalcBezierAndClip(m_vlgptPoint, lgrtClip, GetHitPolyline(), jntSeq);
//	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjBePiCmMiNmEjFgAiJoGjHmMiIoGiBeC_xHqqkZx_
//	m_mmrtPreRegion = lg2mm(lgrtClip);
//	//----- _xZkqqHx_jApMjFjNiCmMiMhGiOfKiBeC_xHqqkZx_WidePoly_xZkqqHx_iCmMiPoKiNiHiCmNiCfA_xHqqkZx_ -----
//	long lgPenW = mm2lg(GetHitPolyline().GetObject()->GetStdPenWeight());
//	if (GetHitPolyline().GetObject()->IsKindOf(FDOJ_WIDE_POLY)) lgPenW = 1;
//	//----- _xZkqqHx_iMlLiNnNiCmMiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
//	DrawPolyline(pDC, m_vlgptPoint.begin(), m_vlgptPoint.size(), lgPenW, lgrtClient);
//----- 05.09.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFnCiPfHjApMiNmAjFfHjEhKjHpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vlgptPoint.clear();
//----- 05.09.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolPolyEdit::StateStartMovePull.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateMovingPull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjDfPiInKjDkOjCiGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::StateMovingPull (CDC* pDC)
{
	TRACE(_T("StateMovingPull\r\n"));
	// _xZkqqHx_iIpIjDfPiCmMiInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLPoint mmptDif = m_mmptCnv - m_mmptMovPull;
	// _xZkqqHx_iIpIjDfPiCkKiInKjDkOiClFiCmEiCkCiCmIiCkPiCoKiCmOiPeJjHlJiBeC_xHqqkZx_
	if (mmptDif.x == 0 && mmptDif.y == 0) return;
	// _xZkqqHx_iIpIjDfPiCmMiImKjChFiCpAiNfIjAfGiBeC_xHqqkZx_
	m_mmptMovPull = m_mmptCnv;
	// _xZkqqHx_iIpIjApMiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
	GetHitJoint().DrawPullMark(pDC);
	//----- _xZkqqHx_jApMjFjNiCmMiMhGiOfKiBeC_xHqqkZx_WidePoly_xZkqqHx_iCmMiPoKiNiHiCmNjBnBjFjNiCpAiNgMjHlG_xHqqkZx_ -----
	fmmetol mmfPenW = GetLineObject(GetHitXXX(XXX_JOINT).first)->GetStdPenWeight();
	long  lgPenW = mm2lg(mmfPenW);
	if (GetLineObject(GetHitXXX(XXX_JOINT).first)->IsKindOf(FDOJ_WIDE_POLY))
	//----- WidePoly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		FCObjWidePoly* pWide = (FCObjWidePoly*)GetLineObject(GetHitXXX(XXX_JOINT).first);
		mmetol mmWeight = (pWide->GetPolyWidthF() < pWide->GetPolyWidthB()) ?
						pWide->GetPolyWidthB() : pWide->GetPolyWidthF();
		mmfPenW = fmmetol(mmWeight) + (2.0 * mmfPenW);
		lgPenW = 1;
	}
	//----- _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiOoGjDlO_xHqqkZx_ -----
	CRect lgrtClient;
	g_pView->GetClientRectLG(lgrtClient);
	//----- _xZkqqHx_iJgFiLlPjEmNiImNiCpAiMhGiOfK_xHqqkZx_ -----
	JointSeq jntSeq;	// _xZkqqHx_jIeBjBlBiClHiCoJjIeBiMiLjDfPiBeC_xHqqkZx_
	GetHitPolyline().FCPolyJointVector::GetAffected(jntSeq, GetHitXXX(XXX_JOINT).second);
	//----- _xZkqqHx_jBePiJpBiCmMiLmIjApMiCpAiPmBiLiOiClHiCoJ_xHqqkZx_ -----
	if (!m_vlgptPoint.empty())
		DrawPolyline(pDC, m_vlgptPoint.begin(), m_vlgptPoint.size(), lgPenW, lgrtClient);
	//----- _xZkqqHx_jAfGiClFiCkCiIpIjDfPiCpAjAnNjCoI_xHqqkZx_ -----
	if (m_iHitJointKnd == FDPK_PREV_PULL)
		GetHitJoint().SetAutoPrevPull(
				m_mmptCnv - GetHitJoint().m_mmptPivot);
	else
		GetHitJoint().SetAutoNextPull(
				m_mmptCnv - GetHitJoint().m_mmptPivot);
	//----- _xZkqqHx_jFmPiNfIiMoDiCmMiLmIjApMiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfK_xHqqkZx_ -----
	::CalcBezier2(m_vlgptPoint, GetHitPolyline().begin(), GetHitPolyline().size(),
				mmfPenW, jntSeq.lStart, jntSeq.lSize, g_->lgdPrecision, g_->dZoom,
				&lgrtClient, 1, StdMinRatio(lgrtClient));
	//----- _xZkqqHx_jFmPiNfIiMoDiCmMiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
	DrawPolyline(pDC, m_vlgptPoint.begin(), m_vlgptPoint.size(), lgPenW, lgrtClient);
	// _xZkqqHx_iIpIjApMiCpAjFfMiOkGiBeC_xHqqkZx_
	GetHitJoint().DrawPullMark(pDC);
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGiBeCiIpIjDfPiImKjChFjFfMiOkGiBeC_xHqqkZx_
	FFGetMainWnd()->MoveRulerMMK(1, m_mmptMovPull);
} // FCToolPolyEdit::StateMovingPull.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateStopMovePull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjDfPiInKjDkOiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::StateStopMovePull (CDC* pDC)
{
	TRACE(_T("StateStopMovePull\r\n"));
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);

	longSet stJointIndex;
	stJointIndex.insert(GetHitXXX(XXX_JOINT).second);
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iInKjDkOjBePiDiKiBfLiDfHiDiHiDjDiMhGiOfKiBeC_xHqqkZx_
//	const FCObjPoly* pObjPoly = (const FCObjPoly*)GetLineObject(GetHitXXX(XXX_JOINT).first);
//	CRect lgrtClip;
//	myCalcBezierClip(lgrtClip, pObjPoly, stJointIndex);
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AddRgn(lgrtClip);
//	if (pObjPoly->IsFillPainted() || pObjPoly->GetRichText() != NULL)
//	//----- _xZkqqHx_jDoAjFjEiCmMjDgIiCoIiCmCiCnEiClFiBeFiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCmMjCmHiJmBjAnNjCoIiBeCjCmHiJmBiCmFjAnNjCoIiClHiCoJiCmMiCmNiBeB_xHqqkZx_lgrtClip _xZkqqHx_iCmJiIpIjApMiCkKiKnMiCnMiCoKiCoJiClNiCnPiBeC_xHqqkZx_
//		g_pView->AppendToLastRgn(pObjPoly);
//	}
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iInKjDkOjBePiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	AppendJointMovedRgn(GetHitXXX(XXX_JOINT).first, stJointIndex);
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();
	//----- _xZkqqHx_iIpIjDfPiCmMiInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhD_xHqqkZx_ -----
	// _xZkqqHx_iCmGiCoIiCkAiCkGiClIjBePiIpIjDfPiBeFiMoDiIpIjDfPjHlMjFpLiCpAiInKjDkOiClDiClJiCoJiBeCiDfCiDhNiDjDiDgIiKnGjAjEjCiGiCmF_xHqqkZx_
	// _xZkqqHx_iInKjDkOiClFiCmEiCkCiCmIiCkCjCgMiCmNiLeMjIfOiClFiCmIiCkCiCoGiCkEiCmJjElLjCgGiClFiCmEiCkNiCoKiCoJiClNiCnPiBeC_xHqqkZx_
	FCPolyJointRec rec;
	rec.wMask = 0;
	rec.wMask = FDFP_PREVPULLX|FDFP_PREVPULLY|FDFP_NEXTPULLX|FDFP_NEXTPULLY;
	rec.mmPrevPullX	= GetHitJoint().GetPrevPullX();
	rec.mmPrevPullY	= GetHitJoint().GetPrevPullY();
	rec.mmNextPullX	= GetHitJoint().GetNextPullX();
	rec.mmNextPullY	= GetHitJoint().GetNextPullY();
	g_pDoc->CmdModifyPolyJoint((FCObjPoly*)GetLineObject(GetHitXXX(XXX_JOINT).first), GetHitXXX(XXX_JOINT).second, rec);

	// _xZkqqHx_iInKjDkOiClFiClNjIeBiMiLjDfPiDiCiDiKiDhGiCmGiBeBiClLiCmMjBePiMoDiCmMjIeBiMiLjDfPiKnEiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
	FTMolipSet setMolip;	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
	setMolip.insert(FCMolipRec(	GetLineObject(GetHitXXX(XXX_JOINT).first)->GetObjID(),
								JointIDtoMolipID(GetHitXXX(XXX_JOINT).second)));
	setMolip.insert(FCMolipRec(	GetLineObject(GetHitXXX(XXX_JOINT).first)->GetObjID(),
								JointIDtoMolipID(GetHitXXX(XXX_JOINT).second) + 1));
	if (GetHitXXX(XXX_JOINT).second == 0)
		setMolip.insert(FCMolipRec(	GetLineObject(GetHitXXX(XXX_JOINT).first)->GetObjID(),
									JointIDtoMolipID(GetJointCount(GetHitXXX(XXX_JOINT).first) - 1) + 1));
	else
		setMolip.insert(FCMolipRec(	GetLineObject(GetHitXXX(XXX_JOINT).first)->GetObjID(),
									JointIDtoMolipID(GetHitXXX(XXX_JOINT).second) - 1));
	// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
	g_pDoc->LinkManager()->MovedNotify(setMolip);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iInKjDkOiMoDiDiKiBfLiDfHiDiHiDjDiMhGiOfKiBeC_xHqqkZx_
//	myCalcBezierClip(lgrtClip, pObjPoly, stJointIndex);
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//	g_pView->AddRgn(lgrtClip);
//	if (pObjPoly->IsFillPainted() || pObjPoly->GetRichText() != NULL)
//	//----- _xZkqqHx_jDoAjFjEiCmMjDgIiCoIiCmCiCnEiClFiBeFiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCmMjCmHiJmBjAnNjCoIiBeCjCmHiJmBiCmFjAnNjCoIiClHiCoJiCmMiCmNiBeB_xHqqkZx_lgrtClip _xZkqqHx_iCmJiIpIjApMiCkKiKnMiCnMiCoKiCoJiClNiCnPiBeC_xHqqkZx_
//		g_pView->AppendToLastRgn(pObjPoly);
//	}
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iInKjDkOiMoDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	AppendJointMovedRgn(GetHitXXX(XXX_JOINT).first, stJointIndex);
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	OnSelectObjModified();
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjHmMiIoGiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
} // FCToolPolyEdit::StateStopMovePull.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::StateExitMovePull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjDfPiInKjDkOiPgPiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::StateExitMovePull (CDC* pDC)
{
	TRACE(_T("StateExitMovePull\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiBeC_xHqqkZx_
	::FFReleaseCapture();
} // FCToolPolyEdit::StateExitMovePull.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetSubMenuIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCToolPolyEdit::StateContextMenu _xZkqqHx_iCmFjFfMiOkGiClHiCoJiDfEiDhFiDiBiDgKiDiFiBfLiCmM_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolPolyEdit::GetSubMenuIndex () const
{
	return FD_MENU_TOOL_POLY_EDIT;
} // FCToolPolyEdit::GetSubMenuIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CanLinkToSelection
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Idle_xZkqqHx_iCmF_xHqqkZx_CTRL+MSMOVE_xZkqqHx_iCmFiDiKiDjDiDeOiCkKjCkDiCoKiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::CanLinkToSelection () const
{
	if (GetCurrentState() != STATE_IDLE &&
		GetCurrentState() != STATE_CONTEXT_MENU &&
		GetCurrentState() != STATE_CONTEXT_MENU_LINK) return FALSE;
	JointSelInfoVector::const_iterator iInf;
	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
		if (!(*iInf).GetSelJointVector().empty()) return TRUE;
	return FALSE;
} // FCToolPolyEdit::CanLinkToSelection.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetSelectionForLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCpAjCkDiCoJiClNiCnPiCmMiDiCiDiKiDhGiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	STATE_LINK_COMMAND_xZkqqHx_jAoKjHhAiCmMiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::GetSelectionForLink (FTMolipSet& stMolip) const
{
	stMolip.clear();
	JointSelInfoVector::const_iterator iInf;
	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
	{
		longVector::const_iterator iIdx;
		for (iIdx = (*iInf).GetSelJointVector().begin();
			 iIdx != (*iInf).GetSelJointVector().end(); iIdx++)
		{
			stMolip.insert(FCMolipRec((*iInf).GetObject()->GetObjID(),
										JointIDtoMolipID(*iIdx)));
		}
	}
} // FCToolPolyEdit::GetSelectionForLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::ResetEditHandleList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::ResetEditHandleList ()
{
	// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	ClearEditHandleList();
	long lC;
	for (lC = 0; lC != m_vPolyLine.size(); lC++)
	{
		const JointSelInfo& info = m_vPolyLine[lC];
		//----- _xZkqqHx_iDeKiDgJiDiBjDfPiCpAjDgPjIfO_xHqqkZx_ -----
		long lCC;
		for (lCC = 0; lCC != info.size(); lCC++)
		{
			AddEditHandle(	info[lCC].GetPivotPoint(),
							FCHandleId(lC, lCC, FDPK_PIVOT, 0));
		}

		longVector::const_iterator iIdx;
		//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmJjBmOiClFiCmEiBeBiIpIjDfPiCpAjClCiCnHiCoJ_xHqqkZx_ -----
		for (iIdx = info.GetSelJointVector().begin();
			 iIdx != info.GetSelJointVector().end(); iIdx++)
		{
			if (!(info[*iIdx].m_nType & 0x01))
			//----- _xZkqqHx_jBePiIpIjDfPiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jBePiIpIjDfPiCpAjDgPjIfOiBeC_xHqqkZx_
				AddEditHandle(	info[*iIdx].GetPrevPullPoint(),
								FCHandleId(lC, *iIdx, FDPK_PREV_PULL, 0));
				AddEditHandle(	info[*iIdx].GetPrevChar1Rect(),
								FCHandleId(lC, *iIdx, FDPK_PREV_PULL, 0));
				AddEditHandle(	info[*iIdx].GetPrevChar2Rect(),
								FCHandleId(lC, *iIdx, FDPK_PREV_PULL, 0));
			}
			if (!(info[*iIdx].m_nType & 0x04))
			//----- _xZkqqHx_iMoDiIpIjDfPiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMoDiIpIjDfPiCpAjDgPjIfOiBeC_xHqqkZx_
				AddEditHandle(	info[*iIdx].GetNextPullPoint(),
								FCHandleId(lC, *iIdx, FDPK_NEXT_PULL, 0));
				AddEditHandle(	info[*iIdx].GetNextChar1Rect(),
								FCHandleId(lC, *iIdx, FDPK_NEXT_PULL, 0));
				AddEditHandle(	info[*iIdx].GetNextChar2Rect(),
								FCHandleId(lC, *iIdx, FDPK_NEXT_PULL, 0));
			}
		}
	}
} // FCToolPolyEdit::ResetEditHandleList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			stXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiIoKjHjHiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vector/set _xZkqqHx_iCmMiCkCiClIiCoKiCmMiMgAiOkOiCmFiCoAjCgMiCpAjFnEiClJiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolPolyEdit::GetSelectedXXX (XXX_Joint, vector<longPair>* vXxx, set<longPair>* stXxx) const
{
	long lSize = -1;
	if (vXxx != NULL)
	//----- vXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		vXxx->clear();
		for (long lPoly = 0; lPoly != m_vPolyLine.size(); lPoly++)
		{
			longVector::const_iterator iIdx;
			for (iIdx = m_vPolyLine[lPoly].GetSelJointVector().begin();
				 iIdx != m_vPolyLine[lPoly].GetSelJointVector().end(); iIdx++)
				vXxx->push_back(longPair(lPoly, *iIdx));
		}
		lSize = vXxx->size();
	}
	if (stXxx != NULL)
	//----- stXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		stXxx->clear();
		for (long lPoly = 0; lPoly != m_vPolyLine.size(); lPoly++)
		{
			longVector::const_iterator iIdx;
			for (iIdx = m_vPolyLine[lPoly].GetSelJointVector().begin();
				 iIdx != m_vPolyLine[lPoly].GetSelJointVector().end(); iIdx++)
				stXxx->insert(longPair(lPoly, *iIdx));
		}
		lSize = stXxx->size();
	}
	if (lSize == -1)
	{
		lSize = 0;
		for (long lPoly = 0; lPoly != m_vPolyLine.size(); lPoly++)
			lSize += m_vPolyLine[lPoly].GetSelJointVector().size();
	}
	return lSize;
} // FCToolPolyEdit::GetSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetSelectableXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiIoKjHjHiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolPolyEdit::GetSelectableXXX (XXX_Joint, vector<longPair>* vXxx) const
{
	if (vXxx != NULL)
	//----- vXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		vXxx->clear();
		for (long lPoly = 0; lPoly != m_vPolyLine.size(); lPoly++)
			for (long lJoint = 0; lJoint != m_vPolyLine[lPoly].size(); lJoint++)
				vXxx->push_back(longPair(lPoly, lJoint));
		return vXxx->size();
	} else
	//----- vXxx _xZkqqHx_iCpAjFnEiClDiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		long lSize = 0;
		for (long lPoly = 0; lPoly != m_vPolyLine.size(); lPoly++)
			lSize += m_vPolyLine[lPoly].size();
		return lSize;
	}
} // FCToolPolyEdit::GetSelectableXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::SelectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::SelectXXX (XXX_Joint, longPair xxx, CDC* pDC)
{
	// _xZkqqHx_jBeJjBpAiNmPiCnNjIeBiMiLjDfPiCmMiDiKiDfIiDgHiCmJjCmHiJmBiBeCjBeJjBpAiNmPiCnNjIeBiMiLjDfPiCmIiCoHiCmOiClBiCmMiCnMiCnMjFjMiLeBiBeC_xHqqkZx_
	if (!m_vPolyLine[xxx.first].SelectJoint(xxx.second)) return;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::SelectXXX(XXX_JOINT, xxx, pDC);
} // FCToolPolyEdit::SelectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::UnselectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiBeBjBeJjBpAiPpDjBnEiCkJiCoHiKeKjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeCjBfDiCmEiJpAiPjMiClHiCoJiPoKiNiHiCmN_xHqqkZx_InvalidValueXXX()_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::UnselectXXX (XXX_Joint, longPair xxx, CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UnselectXXX(XXX_JOINT, xxx, pDC);
	if (xxx == InvalidValueXXX(XXX_JOINT))
	//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		JointSelInfoVector::iterator iInf;
		for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
			(*iInf).ClearSelectJoint();
	} else
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiNmPiCnNjIeBiMiLjDfPiCmMiDiKiDfIiDgHiCkJiCoHiPjMiLiOiBeCjGkCjBeJjBpAiCmMjIeBiMiLjDfPiCmIiCoHiClBiCmMiCnMiCnMjFjMiLeBiBeC_xHqqkZx_
		if (!m_vPolyLine[xxx.first].UnselectJoint(xxx.second)) return;
	}
} // FCToolPolyEdit::UnselectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::GetFrameRectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCToolPolyEdit::GetFrameRectXXX (XXX_Joint, longPair xxx) const
{
	return DBLRect(m_vPolyLine[xxx.first][xxx.second].m_mmptPivot, m_vPolyLine[xxx.first][xxx.second].m_mmptPivot);
} // FCToolPolyEdit::GetFrameRectXXX.

//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CheckHitNextXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmFjBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmFiBeBiDhNiDeFiDfIiImKjChFiCmJiDhBiDgCiDgH_xHqqkZx_
 *			_xZkqqHx_iClFiCmEiCkCiCoJ_xHqqkZx_ lastXxx_xZkqqHx_iCmMiOjPiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hitXxx	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *					 NULL_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmN_xHqqkZx_m_hitXxx_xZkqqHx_iCmJjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			lastXxx	:_xZkqqHx_jBePiJpBiDhBiDgCiDgHiClFiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *					 _xZkqqHx_iOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ InvalidValueXXX_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::CheckHitNextXXX (XXX_Joint, longPair* hitXxx, longPair lastXxx)
{
	// _xZkqqHx_iDiKiDfKiDgCiDgHiClFiCmEiCkIiCkJiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	m_hitJoint2 = InvalidValueXXX(XXX_JOINT);
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CheckHitNextXXX(XXX_JOINT, hitXxx, lastXxx);
} // FCToolPolyEdit::CheckHitNextXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CheckHitPolyline
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmFjBeJjBpAiJmCjEfMiCmIjIeBiMiLjDfPjCiGiCmFiBeBiDhNiDeFiDfIiImKjChFiCmJiDhBiDgCiDgH_xHqqkZx_
 *			_xZkqqHx_iClFiCmEiCkCiCoJiDhMiDiKiDiJiDeDiDjDiBgJjIeBiMiLjDfPiKnEiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_m_hitXxx _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolPolyEdit::CheckHitPolyline ()
{
	SetHitXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT));
	m_hitJoint2 = InvalidValueXXX(XXX_JOINT);
	JointSelInfoVector::reverse_iterator rInf;
	long lPolyIdx;
	for (lPolyIdx = m_vPolyLine.size() - 1; lPolyIdx != -1; lPolyIdx--)
	{
// 06.11.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		const mmetol mmW = (m_vPolyLine[lPolyIdx].GetObject()->GetStdPenWeight() / 2.0) + lg2mm(5);
		const mmetol mmW = (m_vPolyLine[lPolyIdx].GetObject()->GetStdPenWeight() / 2.0) + lg2mm(FD_HIT_TEST_MARGIN);
		long lStartJoint = m_vPolyLine[lPolyIdx].IsOpen() ?
							m_vPolyLine[lPolyIdx].GetSize() - 2 :
							m_vPolyLine[lPolyIdx].GetSize() - 1;
		while (lStartJoint != -1)
		{
			// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjClIjDfPjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
			DBLPointVector vmmptPoly;
			::CalcBezier2(	vmmptPoly,
							m_vPolyLine[lPolyIdx].GetPtr(), m_vPolyLine[lPolyIdx].GetSize(),
																	// _xZkqqHx_jAkHiMoEjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
							m_vPolyLine[lPolyIdx].GetObject()->GetStdPenWeight(),
																	// _xZkqqHx_iDhJiDjDjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
							lStartJoint, 1,							// _xZkqqHx_iMhGiOfKjEmNiImNiCpAiOhHjCoIiBeC_xHqqkZx_
							lg2mm(g_->lgdPrecision),				// _xZkqqHx_jClIjDfPiKnEiLjHjHkDiCmMjGnKiImAiCpAiOhHjCoIiBeC_xHqqkZx_
							1.0,									// _xZkqqHx_iDfJiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
							(const DBLRect*)NULL, 0,				// _xZkqqHx_iDeOiDiKiDgCiDhDiDjDiDePiCpAiOhHjCoIiBeC_xHqqkZx_
							::StdMinRatio(mm2lg(m_vPolyLine[lPolyIdx].GetObject()->GetResizeFrame())));
																	// _xZkqqHx_jClIjDfPjEhKjHpBiCmMiPmIjHkKiKoOiPiAiCpAiOhHjCoIiBeC_xHqqkZx_
			//----- _xZkqqHx_jFjEjFgJiCmMjApMiCmJjDfPiCkKiLnPiCkCiCmIiCoHiCmOiDhBiDgCiDgH_xHqqkZx_ -----
			if (0 < ::FFPolyIntersect(m_mmptMsc, vmmptPoly.begin(), vmmptPoly.size(), mmW))
			//----- _xZkqqHx_jFjEjFgJiCmMjApMiCmJjDfPiCkKiLnPiCkCiPoKiNiH_xHqqkZx_ -----
			{
				SetHitXXX(XXX_JOINT, longPair(lPolyIdx, lStartJoint));
				if (lStartJoint + 1 != m_vPolyLine[lPolyIdx].GetSize())
					m_hitJoint2 = longPair(lPolyIdx, lStartJoint + 1);
				else
					m_hitJoint2 = longPair(lPolyIdx, 0);
				return TRUE;
			}
			lStartJoint--;
		}
	}
	return FALSE;
} // FCToolPolyEdit::CheckHitPolyline.
//----- 06.10.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::DrawFirstImageXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiPiJiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::DrawFirstImageXXX (XXX_Joint, CDC* pDC)
//{
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//	vector<longPair> vSelectedJoint;
//	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
//	vector<longPair>::const_iterator iIdx;
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//	{
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//		DrawJointSelectMark(pDC, *iIdx);
//		// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjFfMiOkGiBeC_xHqqkZx_
//		FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//	}
//	//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoJiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
//	DrawSelectedBezier(pDC);
//} // FCToolPolyEdit::DrawFirstImageXXX.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::RedrawMovingImageXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			mmptMove:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::RedrawMovingImageXXX (XXX_Joint, const DBLPoint& mmptMove, CDC* pDC)
//{
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//	vector<longPair> vSelectedJoint;
//	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
//
//	vector<longPair>::const_iterator iIdx;
////----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	longSet::const_iterator iLdx;
//// _xZkqqHx_iDgFiDfIiDgHiBeC_xHqqkZx_
//	if (!mmptMove.IsNull())
//	//----- _xZkqqHx_iInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
////----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//		// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//		for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//			FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//
//		//----- _xZkqqHx_jBePiJpBjFgAiJoGiClFiClNiLmIjApMiCpAiPmBiLiO_xHqqkZx_ -----
//		DrawSelectedBezier(pDC);
//
//		//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiClHiCnHiCmE_xHqqkZx_mmptMove_xZkqqHx_iClOiCkPiInKjDkO_xHqqkZx_ -----
//		for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//			SetJointPoint(*iIdx, GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop() + mmptMove);
//
//// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//	}
//
//	//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiClNiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
//	DrawSelectedBezier(pDC);
//
//	// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjFfMiOkGiBeC_xHqqkZx_
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//		FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//} // FCToolPolyEdit::RedrawMovingImageXXX.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::OnDrawMovingImageXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::OnDrawMovingImageXXX (XXX_Joint, CDC* pDC)
//{
//	//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiClNiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
//	DrawSelectedBezier(pDC);
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//	vector<longPair> vSelectedJoint;
//	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
//	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
//	vector<longPair>::const_iterator iIdx;
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//	{
//		// _xZkqqHx_iInKjDkOjBePiCmMjIeBiMiLjDfPiCmMiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
//		FCEditDraw(pDC, 0).UnselMark(mm2lg(((const FCObjPoly*)GetLineObject(iIdx->first))->GetJoint(iIdx->second).GetPivotPoint()));
//		// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCmMiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
//		FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//	}
//	// OnDraw_xZkqqHx_iCpAiOmAiNhDiClDiClJiCmIiCkCiClNiCnPiBeB_xHqqkZx_Baseclass_xZkqqHx_iKnGjAjEiCmNiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_
//} // FCToolPolyEdit::OnDrawMovingImageXXX.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::DrawLastImageXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiMoDiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::DrawLastImageXXX (XXX_Joint, CDC* pDC)
//{
////----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iClBiCmMiKnGjAjEiCkKiLpDiCmFiCoAjGhHiCmHiCmMiPoKiNiHiCmNjAlDiPoNiCmJjFgAiJoGiClDiCoKiCoJiCkKiBeB_xHqqkZx_
//	// _xZkqqHx_iCgAiCpAjAiCjClMiCmJiPoDiCmJiInKjDkOiClFiClNiPoKiNiHiCmJiCmNiDfDiDhOiCkKiOgDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//	//
//	//    _xZkqqHx_iBkA_xHqqkZx_
//	//    _xZkqqHx_iEkA_xHqqkZx_
//	//    _xZkqqHx_iEkA_xHqqkZx_
//	//    _xZkqqHx_iEkA_xHqqkZx_
//	//    _xZkqqHx_iEkA_xHqqkZx_
//	//  _xZkqqHx_iBkKiEkA_xHqqkZx_
//	//  _xZkqqHx_iCgAiBkAiEjPiEjPiEjPiEjPiEjPiBkA_xHqqkZx_
//	//
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//	vector<longPair> vSelectedJoint;
//	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
//	// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//	vector<longPair>::const_iterator iIdx;
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//		FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//	//----- _xZkqqHx_jBePiJpBjFgAiJoGiClFiClNiLmIjApMiCpAiPmBiLiO_xHqqkZx_ -----
//	DrawSelectedBezier(pDC);
////----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//} // FCToolPolyEdit::DrawLastImageXXX.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::MoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx		:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vmmptMove	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::MoveXXX (XXX_Joint, const vector<longPair>& vXxx, const DBLPointVector& vmmptMove)
{
	map<long, longSet> mpLineToJointSet;
	vector<longPair>::const_iterator iIdx;
	for (iIdx = vXxx.begin(); iIdx != vXxx.end(); iIdx++)
		mpLineToJointSet[iIdx->first].insert(iIdx->second);

	map<long, longSet>::const_iterator iLjs;
	for (iLjs = mpLineToJointSet.begin(); iLjs != mpLineToJointSet.end(); iLjs++)
	{
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		const FCObjPoly* pObjPoly = (const FCObjPoly*)GetLineObject(iLjs->first);
//		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiMhGiOfKiBeC_xHqqkZx_
//		CRect lgrtClip;
//		myCalcBezierClip(lgrtClip, pObjPoly, iLjs->second);
//		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//		g_pView->AddRgn(lgrtClip);
//		if (pObjPoly->IsFillPainted() || pObjPoly->GetRichText() != NULL)
//		//----- _xZkqqHx_jDoAjFjEiCmMjDgIiCoIiCmCiCnEiClFiBeFiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCmMjCmHiJmBjAnNjCoIiBeCjCmHiJmBiCmFjAnNjCoIiClHiCoJiCmMiCmNiBeB_xHqqkZx_lgrtClip _xZkqqHx_iCmJiIpIjApMiCkKiKnMiCnMiCoKiCoJiClNiCnPiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn(pObjPoly);
//		}
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iInKjDkOjBePiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
		AppendJointMovedRgn(iLjs->first, iLjs->second);
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}

	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
	FTMolipSet setMolip;
	for (long lC = 0; lC != vXxx.size(); lC++)
	{
		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiBeC_xHqqkZx_
		g_pDoc->CmdMoveJoint((FCObjPoly*)GetLineObject(vXxx[lC].first), vXxx[lC].second, vmmptMove[lC]);
		// _xZkqqHx_iInKjDkOiClFiClNjIeBiMiLjDfPiDiCiDiKiDhGiCmGiBeBiClLiCmMjBePiMoDiCmMjIeBiMiLjDfPiKnEiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
		setMolip.insert(FCMolipRec(	GetLineObject(vXxx[lC].first)->GetObjID(),
									JointIDtoMolipID(vXxx[lC].second)));
		setMolip.insert(FCMolipRec(	GetLineObject(vXxx[lC].first)->GetObjID(),
									JointIDtoMolipID(vXxx[lC].second) + 1));
		if (vXxx[lC].second == 0)
			setMolip.insert(FCMolipRec(	GetLineObject(vXxx[lC].first)->GetObjID(),
										JointIDtoMolipID(GetJointCount(vXxx[lC].first) - 1) + 1));
		else
			setMolip.insert(FCMolipRec(	GetLineObject(vXxx[lC].first)->GetObjID(),
										JointIDtoMolipID(vXxx[lC].second) - 1));
	}
	// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
	g_pDoc->LinkManager()->MovedNotify(setMolip);
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

	for (iLjs = mpLineToJointSet.begin(); iLjs != mpLineToJointSet.end(); iLjs++)
	{
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		const FCObjPoly* pObjPoly = (const FCObjPoly*)GetLineObject(iLjs->first);
//		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiMhGiOfKiBeC_xHqqkZx_
//		CRect lgrtClip;
//		myCalcBezierClip(lgrtClip, pObjPoly, iLjs->second);
//		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
//		g_pView->AddRgn(lgrtClip);
//		if (pObjPoly->IsFillPainted() || pObjPoly->GetRichText() != NULL)
//		//----- _xZkqqHx_jDoAjFjEiCmMjDgIiCoIiCmCiCnEiClFiBeFiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCmMjCmHiJmBjAnNjCoIiBeCjCmHiJmBiCmFjAnNjCoIiClHiCoJiCmMiCmNiBeB_xHqqkZx_lgrtClip _xZkqqHx_iCmJiIpIjApMiCkKiKnMiCnMiCoKiCoJiClNiCnPiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn(pObjPoly);
//		}
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iInKjDkOiMoDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
		AppendJointMovedRgn(iLjs->first, iLjs->second);
//----- 06.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	OnSelectObjModified();
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
} // FCToolPolyEdit::MoveXXX.

//----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::InsertJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiImKjChFiCmJjIeBiMiLjDfPiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBhNjDpMjBePiCmGjBlNiKhAjApMjFjEjFgJiCmMiMgAiPpDiCkKjFmPiCoNiCoHiCmIiCkCiCoGiCkEiBeBjBhNjDpMjIeBiMiLjDfPiCmMiIpIjDfPiBeB_xHqqkZx_
 *			_xZkqqHx_jBePiMoDiCmMjIeBiMiLjDfPiCmMiIpIjDfPiCkKjClCjAkOiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgIjEkNiNhDiBeBiDiKiBfLiDfHiDiHiDjDjAnNjCoIiCmNiClDiCoKiCoJiCkKiBeBiNmEjFgAiJoGiCmNiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lTargetPoly	:_xZkqqHx_jIeBiMiLjDfPjBhNjDpMjBmOiPnLiCmMjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302_xZkqqHx_iCmM_xHqqkZx_Q_xZkqqHx_iCkKjBkOiClHiCoJjBlNiKhAjApMjFjEjFgJiBeC_xHqqkZx_
 *			lTargetBezier:_xZkqqHx_jIeBiMiLjDfPjBhNjDpMjBmOiPnLiCmMiDhMiDiKiDiJiDeDiDjDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302_xZkqqHx_iCmM_xHqqkZx_Q_xZkqqHx_iCkKjBkOiClHiCoJiDhMiDiKiDiJiDeDiDjDiBeC_xHqqkZx_
 *			dTargetT	:_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302_xZkqqHx_iCmM_xHqqkZx_Q_xZkqqHx_iCmMiOjOiNiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptTargetQ;:_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302_xZkqqHx_iCmM_xHqqkZx_Q_xZkqqHx_iCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBhNjDpMiClDiCoKiClNjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnObjectInsertJoint _xZkqqHx_iCmMiCmIiCkJiCnNiCpA_xHqqkZx_ InsertJoint _xZkqqHx_iCmJiPgPiClFiClNiBeC_xHqqkZx_
 *			_xZkqqHx_jIeBiMiLjDfPiCfAiCmCjBeJjBpAiOjOiCmJ_xHqqkZx_OnObjectDisconnect_xZkqqHx_iCpAiOmAiNhDiClHiCoJiPoKiNiHiBeB_xHqqkZx_
 *			InsertJoint _xZkqqHx_iClFiCmEiCkJiCoHjFkKiKiEiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjAhNiCmMjHoBiCmJiCkIiCkCiCmEiBeBiChAiCmMiImKjChFiCmJjIeBiMiLjDfPiCpAjBhNjDpMiClHiCoJiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *
 *                  C2    _xZkqqHx_iChA_xHqqkZx_  C1
 *                  _xZkqqHx_iBkF_xHqqkZx_ B1 _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkF_xHqqkZx_
 *                 _xZkqqHx_iBfOiBfAiBfAiBfAiBfAiBfAiBfP_xHqqkZx_
 *             B2_xZkqqHx_iBfO_xHqqkZx_              _xZkqqHx_iBfP_xHqqkZx_B0
 *         C3_xZkqqHx_iBkDiBfO_xHqqkZx_        B3        _xZkqqHx_iBfPiBkD_xHqqkZx_C0
 *             _xZkqqHx_iBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfA_xHqqkZx_
 *			lTargetBezier=1_xZkqqHx_iBeB_xHqqkZx_dTargetT=0.4 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
longPair FCToolPolyEdit::InsertJoint (	long lTargetPoly,
										long lTargetBezier,
										double dTargetT,
										const DBLPoint& mmptTargetQ)
{
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiBeC_xHqqkZx_
	JointSelInfo& targetInf = m_vPolyLine[lTargetPoly];
	// Q_xZkqqHx_iCkKjBkOiClHiCoJjIeBiMiLjDfPiCmM_xHqqkZx_ID_xZkqqHx_iBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P303_xZkqqHx_iCmMjHoBiCmFiCmN_xHqqkZx_C1_xZkqqHx_iBgJjBkGiClP_xHqqkZx_1_xZkqqHx_iBgKiCmFiCkAiCoJiBeC_xHqqkZx_
	long lTargetJoint = lTargetBezier;
	// _xZkqqHx_iPoDjAhNjHoBiCmJiCkIiCkCiCmEiCmNiBeB_xHqqkZx_
	// targetInf.IsOpen()=FALSE
	// targetInf.size()=4
	// _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	long lNextJoint = (lTargetJoint + 1 == targetInf.size()) ? 0 : lTargetJoint + 1;
	// C1-C2_xZkqqHx_iCmMiDhIiDfHiDeG_xHqqkZx_(_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P302)_xZkqqHx_iBeC_xHqqkZx_
	FCBezierControls bcTarget(	targetInf[lTargetJoint].GetPivotPoint(),
								targetInf[lTargetJoint].GetNextPullPoint(),
								targetInf[lNextJoint].GetPrevPullPoint(),
								targetInf[lNextJoint].GetPivotPoint());

	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiDhIiDfHiDeGiLmIjApMiCpAiBeBiChAiCmMiImKjChFiCpAiLkLiCmJjDpBiCmCiCmJjFkKiKiEiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClLiCmMiNnLiBeBiClLiCoKiCnMiCmFiCmMiLmIjApMiMgAiPpDiCmGjDkPiClGiCmJiCmIiCoJiCoGiCkEiCmIiBeBjAkHiMoEjDfPiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	FCBezierControls bcChopped1;	// _xZkqqHx_iChAiCpAiLkLiCmJjBePjElMiCmMiDhIiDfHiDeGiLmIjApMiBeC_xHqqkZx_
	FCBezierControls bcChopped2;	// _xZkqqHx_iChAiCpAiLkLiCmJiMoDjElMiCmMiDhIiDfHiDeGiLmIjApMiBeC_xHqqkZx_
	FFChopBezier(bcChopped1, bcTarget, 0.0, dTargetT);
	FFChopBezier(bcChopped2, bcTarget, dTargetT, 1.0);

	// _xZkqqHx_iCoNiCkJiCoIiCoCiClHiCkNiClHiCoJiClNiCnPiBeBjFmPjAjEiCpAjHhAiInDiBeC_xHqqkZx_
	const FCPolyJoint& jsiPrev = targetInf[lTargetJoint];			// _xZkqqHx_jIeBiMiLjDfPiCpAjBhNjDpMiClHiCoJjClMjBePiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
	const FCPolyJoint& jsiNext = (lTargetJoint == targetInf.size() - 1) ?
								targetInf[0] : targetInf[lTargetJoint + 1];		// _xZkqqHx_jIeBiMiLjDfPiCpAjBhNjDpMiClHiCoJjClMiMoDiCmMjIeBiMiLjDfPiBeC_xHqqkZx_
	const DBLPoint mmptPrevJointNext = bcChopped1.B() - bcChopped1.A();	// _xZkqqHx_jClMjBePiCmMjIeBiMiLjDfPiCmMiMoDiIpIjDfPiBeC_xHqqkZx_
	const DBLPoint mmptNextJointPrev = bcChopped2.C() - bcChopped2.D();	// _xZkqqHx_jClMjBePiCmMjIeBiMiLjDfPiCmMjBePiIpIjDfPiBeC_xHqqkZx_
	DBLPoint mmptJointPrev = bcChopped1.C() - bcChopped1.D();		// _xZkqqHx_jBhNjDpMiClHiCoJjIeBiMiLjDfPiCmMjBePiIpIjDfPiBeC_xHqqkZx_
	DBLPoint mmptJointNext = bcChopped2.B() - bcChopped2.A();		// _xZkqqHx_jBhNjDpMiClHiCoJjIeBiMiLjDfPiCmMiMoDiIpIjDfPiBeC_xHqqkZx_

	BOOL bIsSetPull = TRUE;	// _xZkqqHx_iIpIjDfPiCpAiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
	// _xZkqqHx_jBhNjDpMjClMjBePiCmMjIeBiMiLjDfPiCmMiMoDiIpIjDfPiBeBjClMiMoDiCmMjBePiIpIjDfPiCkKiInKjDkOiClDiCoKiCmIiCkCiCmIiCoHiCgFiCgAiCgLiChCiCgEiBeC_xHqqkZx_
	if (almosteq(jsiPrev.m_mmptNext, mmptPrevJointNext) &&
		almosteq(jsiNext.m_mmptPrev, mmptNextJointPrev))
		bIsSetPull = FALSE;	// _xZkqqHx_iIpIjDfPiCpAiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
	// _xZkqqHx_jBhNjDpMjClMjBePiCmMjIeBiMiLjDfPiCmMiMoDiIpIjDfPiCpAiInKjDkOiClHiCoJiPoKiNiHiBjF_xHqqkZx_
	// _xZkqqHx_iMoDiIpIjDfPiBiBiCePiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiCgFiCgAiCgLiChCiCgEiBeC_xHqqkZx_
	if (!almosteq(jsiPrev.m_mmptNext, mmptPrevJointNext) &&
		jsiPrev.m_nType & FDJT_PST_PULL_0 != 0)
		bIsSetPull = FALSE;
	// _xZkqqHx_jBhNjDpMjClMiMoDiCmMjIeBiMiLjDfPiCmMjBePiIpIjDfPiCpAiInKjDkOiClHiCoJiPoKiNiHiBjF_xHqqkZx_
	// _xZkqqHx_jBePiIpIjDfPiBiBiCePiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiCgFiCgAiCgLiChCiCgEiBeC_xHqqkZx_
	if (!almosteq(jsiNext.m_mmptPrev, mmptNextJointPrev) &&
		jsiNext.m_nType & FDJT_PRE_PULL_0 != 0)
		bIsSetPull = FALSE;

	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiClHiCoJiPiAjEpFiCmGiClFiCmEiLpDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AddEmptyRgn();
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	//----- _xZkqqHx_jBhNjDpMiClHiCoJjIeBiMiLjDfPiCmJiKnGjIeBiClHiCoJiDiCiDiKiDhGiCpAjBhNjDpMiClHiCoJ_xHqqkZx_ -----
	// _xZkqqHx_iDiCiDiKiDhGiPoOjFpBjEhKjHpBiCpAjHhAiInDiClHiCoJiBeC_xHqqkZx_
	FCMolipInfoVector vMolipInf;
	g_pDoc->LinkManager()->PrepareMolipInfoVector(	vMolipInf, NULL,
													targetInf.GetObject()->GetMolipCount(),
													targetInf.GetObject()->GetObjID());
	long lMolipId;	// _xZkqqHx_jBhNjDpMiDiCiDiKiDhGjClMiMoDiCmMiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	if (dTargetT <= 0.5)	// _xZkqqHx_iDfAiBfLiDfI_xHqqkZx_B(_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P303)_xZkqqHx_iBeC_xHqqkZx_
		lMolipId = JointIDtoMolipID(lTargetJoint) + 1;
	else					// _xZkqqHx_iDfAiBfLiDfI_xHqqkZx_A(_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P303)_xZkqqHx_iBeC_xHqqkZx_
		lMolipId = JointIDtoMolipID(lTargetJoint + 1);
	// _xZkqqHx_jIeBiMiLjDfPjBhNjDpMiCmJjElKiCkEiDiCiDiKiDhGiCpAjBhNjDpMiBeC_xHqqkZx_
	vMolipInf.insert(vMolipInf.begin() + lMolipId, 2, FCMolipInfo());
	// _xZkqqHx_jFmPiNfIiClFiClNiPoOjFpBiCpAjElNiJgGiBeC_xHqqkZx_
	// Link_xZkqqHx_iNoNiPjM_xHqqkZx_/Link_xZkqqHx_jCmHiJmBiCpAiDfKiDgCiDgHiCmFiOmAiNhDiClHiCoJiPoKiNiHiBeB_xHqqkZx_UpdateLinkConnect _xZkqqHx_iCmNiBeB_xHqqkZx_
	// _xZkqqHx_iNoNiPjMiCmFiIoKiJpBiBeBjCmHiJmBiCmFiIoKiJpBjFmKiBfIiCmJiOmAiNhDiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	g_pDoc->LinkManager()->UpdateLinkConnect(
							targetInf.GetObject()->GetObjID(), vMolipInf, NULL);

	// _xZkqqHx_jFmPiNfIjBePiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(targetInf.GetObject());
	if (bIsSetPull)
	//----- _xZkqqHx_iMlDiCmMiLmIjApMiCmGjDkPiClGiCmJiCmIiCoJiCoGiCkEiBeBiIpIjApMiCpAjClCjAkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		FCPolyJointRec rec;
		// _xZkqqHx_jClMjBePiCmMjIeBiMiLjDfPiCmMiMoDiIpIjDfPiCpAjFmPiNfIiBeC_xHqqkZx_
		targetInf[lTargetJoint].m_mmptNext = mmptPrevJointNext;
		rec.wMask = FDFP_NEXTPULLX | FDFP_NEXTPULLY;
		rec.mmNextPullX = mmptPrevJointNext.x;
		rec.mmNextPullY = mmptPrevJointNext.y;
		g_pDoc->CmdModifyPolyJoint(targetInf.GetObject(), lTargetJoint, rec);

		// _xZkqqHx_jClMiMoDiCmMjIeBiMiLjDfPiCmMiMoDiIpIjDfPiCpAjFmPiNfIiBeC_xHqqkZx_
		long lTargetNext = (lTargetJoint == targetInf.size() - 1) ? 0 : lTargetJoint + 1;
		targetInf[lTargetNext].m_mmptPrev = mmptNextJointPrev;
		rec.wMask = FDFP_PREVPULLX | FDFP_PREVPULLY;
		rec.mmPrevPullX = mmptNextJointPrev.x;
		rec.mmPrevPullY = mmptNextJointPrev.y;
		g_pDoc->CmdModifyPolyJoint(targetInf.GetObject(), lTargetNext, rec);
	} else
	//----- _xZkqqHx_iIpIjApMiCpAjClCjAkOiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		mmptJointPrev.SetPoint(0, 0);
		mmptJointNext.SetPoint(0, 0);
	}
	// _xZkqqHx_jBhNjDpMiClHiCoJjIeBiMiLjDfPiCpAiNoMjAkMiBeCjBhNjDpMjClMjBePiCmMjIeBiMiLjDfPiCmMiDfOiDeDiDhGiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCPolyJoint pjNew(	targetInf[lTargetJoint].m_nType,
						mmptTargetQ,
						mmptJointPrev,
						mmptJointNext);
	if (!almost0(mmptJointPrev) || !almost0(mmptJointNext))
		pjNew.m_nType = FDJT_ROUND;
	// _xZkqqHx_jIeBiMiLjDfPiCpAjBhNjDpMiBeC_xHqqkZx_
	targetInf.insert(&targetInf[lTargetJoint + 1], pjNew);
	// _xZkqqHx_jFjEjFgJjDoAjFjEiCmMjIeBiMiLjDfPiCmMjBhNjDpMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	g_pDoc->CmdInsertJoints(targetInf.GetObject(), lTargetJoint + 1, 1, &pjNew);
	// _xZkqqHx_jFmPiNfIiMoDiCmMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(targetInf.GetObject());
	// _xZkqqHx_iDiCiDiKiDhGiCmMiInKjDkOiCpAjCmKjCgNiBeC_xHqqkZx_
	g_pDoc->LinkManager()->MovedNotify(targetInf.GetObject());
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	OnSelectObjModified();
	return longPair(lTargetPoly, lTargetJoint + 1);
} // FCToolPolyEdit::InsertJoint.
//----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::CalcLinkOffsetWhenMoveJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ToolBasePolyEdit2.mdpf _xZkqqHx_iCmJiCkIiCkCiCmEiBeBjFjEjFgJ_xHqqkZx_H_xZkqqHx_iCmMjIeBiMiLjDfP_xHqqkZx_H_xZkqqHx_iCpAiInKjDkOiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_K_xZkqqHx_iCmJiDiKiDjDiDeOiClHiCoJiBgJiDiKiDjDiDeOjFpLiMpMiCmN_xHqqkZx_K->H_xZkqqHx_iBgKiPoKiNiHiCmMiBeBiDiKiDjDiDeO_xHqqkZx_K->H_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jDeLjAnIiCmIiDeJiDhEiDfKiDgCiDgHiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObjH		:ToolBasePolyEdit2.mdpf _xZkqqHx_iCmMjFjEjFgJ_xHqqkZx_H_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipIdH	:ToolBasePolyEdit2.mdpf _xZkqqHx_iCmMiDiCiDiKiDhG_xHqqkZx_H_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObjK		:ToolBasePolyEdit2.mdpf _xZkqqHx_iCmMjFjEjFgJ_xHqqkZx_K_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipIdK	:ToolBasePolyEdit2.mdpf _xZkqqHx_iCmMiDiCiDiKiDhG_xHqqkZx_K_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptH		:_xZkqqHx_iInKjDkOiMoDiCmM_xHqqkZx_H_xZkqqHx_iCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wLinkKind	:ToolBasePolyEdit2.mdpf _xZkqqHx_iCmM_xHqqkZx_K->H_xZkqqHx_iCmMiDiKiDjDiDeOiOoNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCToolPolyEdit::CalcLinkOffsetWhenMoveJoint (	const FCObjDynabase* pObjH,
														long lMolipIdH,
														const FCObjDynabase* pObjK,
														long lMolipIdK,
														const DBLPoint& mmptH,
														WORD wLinkKind) const
{
	if (wLinkKind == FDLM_LINK_ON_ANGLE)
	//----- mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkD_xHqqkZx_ -----
	{
		ASSERT(pObjH->IsKindOf(FDOJ_POLY));
		const FCObjPoly* pPolyH = (const FCObjPoly*)pObjH;
		if (pPolyH->GetLinkMoveType() == FDOP_LMTYPE_AXIS)
		{
			DBLPoint mmptOffset;
			if (lMolipIdH == pObjH->GetFrontEdgeMolipId())
			{
				// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCpAiMhGiOfKiBeC_xHqqkZx_
				DBLPoint mmptPQ = pPolyH->GetJoint(pPolyH->GetJointSize() - 1).GetPivotPoint() - pPolyH->GetJoint(0).GetPivotPoint();
				// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCmMiKhAjDhIiCpAiMhGiOfKiBeC_xHqqkZx_
				double dAnglePQ = ::ArcTan(mmptPQ);
				// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDiJiDeDiDjDiCmMiKhAjDhIiCpAiMhGiOfKiBeC_xHqqkZx_
				FCBezierControls bc(pPolyH->GetJoint(0).GetPivotPoint(),
									pPolyH->GetJoint(0).GetNextPullPoint(),
									pPolyH->GetJoint(1).GetPrevPullPoint(),
									pPolyH->GetJoint(1).GetPivotPoint());
				double dAnglePT = FFGetBezierAngle(bc, 0.0);
				// PQ -> PT _xZkqqHx_iCmMiKhAjDhIiCpAiMhGiOfKiBeC_xHqqkZx_
				double dR = dAnglePT - dAnglePQ;
				mmptOffset.x = ::RegulateAngle(dR);
				mmptOffset.y = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetFrontArrowAutoGap() : 0.0;
			} else
			if (lMolipIdH == pObjH->GetBackEdgeMolipId())
			{
				// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCpAiMhGiOfKiBeC_xHqqkZx_
				DBLPoint mmptPQ = pPolyH->GetJoint(0).GetPivotPoint() - pPolyH->GetJoint(pPolyH->GetJointSize() - 1).GetPivotPoint();
				// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCmMiKhAjDhIiCpAiMhGiOfKiBeC_xHqqkZx_
				double dAnglePQ = ::ArcTan(mmptPQ);
				// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDiJiDeDiDjDiCmMiKhAjDhIiCpAiMhGiOfKiBeC_xHqqkZx_
				FCBezierControls bc(pPolyH->GetJoint(pPolyH->GetJointSize() - 1).GetPivotPoint(),
									pPolyH->GetJoint(pPolyH->GetJointSize() - 1).GetPrevPullPoint(),
									pPolyH->GetJoint(pPolyH->GetJointSize() - 2).GetNextPullPoint(),
									pPolyH->GetJoint(pPolyH->GetJointSize() - 2).GetPivotPoint());
				double dAnglePT = FFGetBezierAngle(bc, 0.0);
				// PQ -> PT _xZkqqHx_iCmMiKhAjDhIiCpAiMhGiOfKiBeC_xHqqkZx_
				double dR = dAnglePT - dAnglePQ;
				mmptOffset.x = ::RegulateAngle(dR);
				mmptOffset.y = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetBackArrowAutoGap() : 0.0;
			} else
			{
				mmptOffset.x = 0.0;
				mmptOffset.y = 0.0;
			}
			return mmptOffset;
		}
	}
	return BASE_CLASS::CalcLinkOffsetWhenMoveJoint(pObjH, lMolipIdH, pObjK, lMolipIdK, mmptH, wLinkKind);
} // FCToolPolyEdit::CalcLinkOffsetWhenMoveJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::AppendJointMovedRgn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiPfHiNiHiCkKiInKjDkOiClDiCoKiCoJiOjOiCmMiBeBiMmFjHeMiDiKiBfLiDfHiDiHiDjDjCmHiJmBiPiIjHjN_xHqqkZx_
 *			_xZkqqHx_iCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_iInKjDkOiClDiCoKiCoJjIeBiMiLjDfPiCkKjBkOiClHiCoJjFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stJointIndex:_xZkqqHx_iInKjDkOiClDiCoKiCoJjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::AppendJointMovedRgn (long lLineIndex, const longSet& stJointIndex)
{
	const FCObjPoly* pObjPoly = (const FCObjPoly*)GetLineObject(lLineIndex);
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiMhGiOfKiBeC_xHqqkZx_
	CRect lgrtClip;
	myCalcBezierClip(lgrtClip, pObjPoly, stJointIndex);
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
	g_pView->AddRgn(lgrtClip);
	if (pObjPoly->IsFillPainted() || pObjPoly->GetRichText() != NULL)
	//----- _xZkqqHx_jDoAjFjEiCmMjDgIiCoIiCmCiCnEiClFiBeFiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCmMjCmHiJmBjAnNjCoIiBeCjCmHiJmBiCmFjAnNjCoIiClHiCoJiCmMiCmNiBeB_xHqqkZx_lgrtClip _xZkqqHx_iCmJiIpIjApMiCkKiKnMiCnMiCoKiCoJiClNiCnPiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(pObjPoly);
	}
} // FCToolPolyEdit::AppendJointMovedRgn.
//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::DrawSelectedBezier
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiClNjIeBiMiLjDfPiCmMiJgFiLlPjEmNiImNiCmMiDhIiDfHiDeHiLmIjApMiCmMiCnNiCpA_xHqqkZx_XOR_xZkqqHx_jFgAiJoGiClHiCoJ_xHqqkZx_.
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: _xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfI_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnMouseMove_xZkqqHx_jCiGiCmMjFgAiJoGiDiLiBfLiDgAiDjDiCpAiCnMiCmGiCnPiClNiCoAiCmM_xHqqkZx_.
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolPolyEdit::DrawSelectedBezier (CDC* pDC) const
//{
//	JointSelInfoVector::const_iterator iInf;
//	JointSeqVector vJntSeq;
//	//----- _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjAnNjCoI_xHqqkZx_ -----
//	CRect	lgrtClip;
//	g_pView->GetClientRectLG(lgrtClip);
//	//----- _xZkqqHx_jFmPiNfIiMoDiCmMiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
//	for (iInf = m_vPolyLine.begin(); iInf != m_vPolyLine.end(); iInf++)
//	{
//		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCkKjGlDiCkCiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if ((*iInf).GetSelJointVector().empty()) continue;
//		//----- _xZkqqHx_jApMjFjNiCmMiMhGiOfKiBeC_xHqqkZx_WidePoly_xZkqqHx_iCmMiPoKiNiHiCmNjBnBjFjNiCpAiNgMjHlG_xHqqkZx_ -----
//		fmmetol mmfPenW = (*iInf).GetObject()->GetStdPenWeight();
//		long  lgPenW = mm2lg(mmfPenW);
//		if ((*iInf).GetObject()->IsKindOf(FDOJ_WIDE_POLY))
//		//----- WidePoly_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			FCObjWidePoly* pWide = (FCObjWidePoly*)(*iInf).GetObject();
//			mmetol mmWeight = (pWide->GetPolyWidthF() < pWide->GetPolyWidthB()) ?
//							pWide->GetPolyWidthB() : pWide->GetPolyWidthF();
//			mmfPenW = fmmetol(mmWeight) + (2.0 * mmfPenW);
//			lgPenW = 1;
//		}
//		//----- _xZkqqHx_jFjEjFgJ_xHqqkZx_ (*iInf).GetObject() _xZkqqHx_iCmJiCkIiCkCiCmEjBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmM_xHqqkZx_
//		//		m_vSelJointIdx _xZkqqHx_iCmMjFmPiNfIiCmJiCoGiCmBiCmEiJgFiLlPiCpAiOpDiCkPiCoJiClHiCnHiCmEiCmM_xHqqkZx_
//		//		_xZkqqHx_jIeBiMiLjDfPiCmMiPfHiNiHiCpA_xHqqkZx_ vStarts _xZkqqHx_iCmG_xHqqkZx_ vCounts _xZkqqHx_iCmJjFnEiClH_xHqqkZx_	-----
//		(*iInf).GetAffected(vJntSeq);
//		//----- vStarts _xZkqqHx_iCmG_xHqqkZx_ vCounts _xZkqqHx_iCmFjFfMiClDiCoKiCoJjIeBiMiLjDfPiPfHiNiHiCmJjBmO_xHqqkZx_
//		//		_xZkqqHx_iDhIiDfHiDeHiLmIjApMiCpAiNmEiMhGiOfKiClFjFgAiJoGiClHiCoJ_xHqqkZx_					-----
//		JointSeqVector::const_iterator iS;
//		for (iS = vJntSeq.begin(); iS != vJntSeq.end(); iS++)
//		{
//			CPointVector vlgptPoint;
//			//----- _xZkqqHx_iLmIjApMiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfK_xHqqkZx_ -----
//			::CalcBezier2(vlgptPoint, (*iInf).begin(), (*iInf).size(), mmfPenW,
//						(*iS).lStart, (*iS).lSize, g_->lgdPrecision, g_->dZoom,
//// 00.07.19 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////						&lgrtClip, 1, 2.56 / g_->lZoom256);
//						&lgrtClip, 1, StdMinRatio(lgrtClip));
//			// _xZkqqHx_iLmIjApMiCpAjFgAiJoGiBeC_xHqqkZx_
//			DrawPolyline(pDC, vlgptPoint.begin(), vlgptPoint.size(), lgPenW, lgrtClip);
//			// _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAiJpAjFpK_xHqqkZx_.
//			vlgptPoint.clear();
//		}
//	}
//} // FCToolPolyEdit::DrawSelectedBezier.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolPolyEdit::DrawPolyline
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHfOiCkGiCoHiCoKiClNiIpIjAjEiCkJiCoHiDhMiDiKiDfDiDjDiCpAjFgAiJoGiBeCjBlMiCmMiKnGjAjEiCmMiLkEjCmKiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC			:_xZkqqHx_iDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			lgptaPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDiNmAjFfHjEhKjHpBiBeCjIfPjHjNiNmAjFfHiBeC_xHqqkZx_
 *			lPolySize	:lgptaPoly_xZkqqHx_iCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *			lgPenW		:_xZkqqHx_iDhJiDjDiCmMjFjNiBeCjIfPjHjNiNmAjFfHiBeC_xHqqkZx_
 *			lgrtClip	:_xZkqqHx_iDeOiDiKiDgCiDhGjHmMiIoGiBeCiClBiCmMjHmMiIoGjCiGiCmMiCnNiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJjBePiCmJiBeB_xHqqkZx_pDC_xZkqqHx_iCmJjFgAiJoGjBkOjAkLiCpAjAnNjCoIiClFiCmEiCkIiCkJiCmIiCkPiCoKiCmO_xHqqkZx_
 *			_xZkqqHx_iCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.22 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *			99.04.24 Fukushiro M. _xZkqqHx_jHnHiCoIiNiHiCkEiCfBjDfPiCkKjAiFjFlNjApMiBeFjAiCjClMjApMiCmMiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
 *************************************************************************/
void FCToolPolyEdit::DrawPolyline (CDC* pDC, const CPoint lgptaPoly[],
									long lPolySize, long lgPenW,
									const CRect& lgrtClip) const
{
	//----- _xZkqqHx_iDeOiDiKiDgCiDhGjHmMiIoGiCpAiDhJiDjDiCmMjFjNjFkKiNeMiClAiClNjHmMiIoGiCpAiMhGiOfK_xHqqkZx_ -----
	CRect lgrtEx = lgrtClip;
	const long lgEx = (lgPenW + 1) / 2;
	lgrtEx.InflateRect(lgEx, lgEx);

	long	lBgn, lEnd;
	CRect	lgrtSmall;
	// _xZkqqHx_iDhMiDiKiDfDiDjDiNmAjFfHjEhKjHpBiCmMiBeBiNmFiPiJiCmJiDeOiDiKiDgCiDhGjHmMiIoGiCmJiCkJiCkJiCoJjDfJiOjKiCpAiMhGiOfKiBeC_xHqqkZx_
	for (lBgn = 1; lBgn < lPolySize; lBgn++)
	{
		// _xZkqqHx_iNmAjFfHjEhKjHpBiCmMjHnHiCoIiNiHiCkEiCfBjDfPiCkJiCoHiLoJiMgAiCpAjAlGjAkMiBeC_xHqqkZx_
		lgrtSmall.SetRect(lgptaPoly[lBgn-1], lgptaPoly[lBgn]);
		lgrtSmall.NormalizeRect();
		// _xZkqqHx_jHnHiCoIiNiHiCkEiCfBjDfPiCkKjAiFjFlNjApMiBeFjAiCjClMjApMiCmMiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
		if (lgrtSmall.Width() == 0) lgrtSmall.right++;
		if (lgrtSmall.Height() == 0) lgrtSmall.bottom++;
		// _xZkqqHx_jDpBiCmCiCmMiNmAjFfHiCkJiCoHjAlGjAkMiClDiCoKiClNiLoJiMgAiCmGiDeOiDiKiDgCiDhGiCkKiMpAiCoNiCoKiCmOiBeBiNmFiPiJiCmMjDfJiOjKiBeC_xHqqkZx_
		if (!(lgrtEx & lgrtSmall).IsRectEmpty()) break;
	}
	lBgn--;

	// _xZkqqHx_iDhMiDiKiDfDiDjDiNmAjFfHjEhKjHpBiCmMiBeBiNmFiMoDiCmJiDeOiDiKiDgCiDhGjHmMiIoGiCmJiCkJiCkJiCoJjDfJiOjKiCpAiMhGiOfKiBeC_xHqqkZx_
	for (lEnd = lPolySize - 1; 0 < lEnd; lEnd--)
	{
		// _xZkqqHx_iNmAjFfHjEhKjHpBiCmMjHnHiCoIiNiHiCkEjDpBiCmCiCkJiCoHiLoJiMgAiCpAjAlGjAkMiBeC_xHqqkZx_
		lgrtSmall.SetRect(lgptaPoly[lEnd-1], lgptaPoly[lEnd]);
		lgrtSmall.NormalizeRect();
		// _xZkqqHx_jHnHiCoIiNiHiCkEiCfBjDfPiCkKjAiFjFlNjApMiBeFjAiCjClMjApMiCmMiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
		if (lgrtSmall.Width() == 0) lgrtSmall.right++;
		if (lgrtSmall.Height() == 0) lgrtSmall.bottom++;
		// _xZkqqHx_jDpBiCmCiCmMiNmAjFfHiCkJiCoHjAlGjAkMiClDiCoKiClNiLoJiMgAiCmGiDeOiDiKiDgCiDhGiCkKiMpAiCoNiCoKiCmOiBeBiNmFiMoDiCmMjDfJiOjKiBeC_xHqqkZx_
		if (!(lgrtEx & lgrtSmall).IsRectEmpty()) break;
	}
	// _xZkqqHx_iDhMiDiKiDfDiDjDjFgAiJoGiBeC_xHqqkZx_
	if (lBgn < lEnd)
	{
		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
		FCEditDraw eDraw(pDC, lgPenW);
		eDraw.Polyline((CPoint*)lgptaPoly + lBgn, lEnd - lBgn + 1);
	}
} // FCToolPolyEdit::DrawPolyline.

