#include "stdafx.h"
#include "DynamicDraw.h"		// For FFCanEditObject.
#include "FoundDoc.h"			// For g_pDoc.
#include "DynamicDrawView.h"	// For g_pView.
#include "LayerManager.h"		// For FDOZ_ON_SELECT.
#include "ToolSelect.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::FCToolSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCToolSelect::FCToolSelect ()
{
	// FCToolSelectObjTmpl_xZkqqHx_iDeOiDiJiDfIiCmMjFjEjFgJiDeBiDeOiDfKiDfIiLjGiJmCiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
	// _xZkqqHx_jBeJjBpAiCmMiCnNiCpAiLjGiJmCiBeC_xHqqkZx_
	BASE_BASE_CLASS::m_wOperation = FDOZ_ON_SELECT;
} // FCToolSelect::FCToolSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::CanSelectTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelect::CanSelectTool () const
{
	// _xZkqqHx_jFlGiPjBiCkKiKeKiCkCiCmEiCkCiCmIiCkPiCoKiCmOiClBiCmMiDgDiBfLiDiLiCmMjBeJjBpAiCmNjFhDiJmCiBeC_xHqqkZx_
	if (!g_pDoc->GetIsDocumentOpened()) return FALSE;
	// _xZkqqHx_jFjEjFgJiCkKjFnCiPfHiJmCjEfMiCmIiCoHiCmOiClBiCmMiDgDiBfLiDiLiCmMjBeJjBpAiCmNjFhDiJmCiBeC_xHqqkZx_
	// _xZkqqHx_jBoDiCoNiCoIiCmJ_xHqqkZx_ToolSelEdit_xZkqqHx_iCkKiJmCiBeCiClBiCoKiCmJiCoGiCoIiBeBiDiMiDeDiDiEiBfLjAnIiCoIjBnGiCkGiOjOiCmJ_xHqqkZx_
	// _xZkqqHx_iDgDiBfLiDiLiCkKjAnIiCoIjBnGiCkGiCoHiCoKiCoJiBeC_xHqqkZx_CFCDynamicDrawView::OnLayerUpdated_xZkqqHx_iBeB_xHqqkZx_
	// ToolSelEdit::CanSelectTool_xZkqqHx_iCoAiOfBiPmGiBeC_xHqqkZx_
	if (FFCanEditObject()) return FALSE;
	return TRUE;
} // FCToolSelect::CanSelectTool.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolSelect::OnDraw (CDC* pDC)
//{
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (GetCurrentState())
//	{
//	case STATE_SELECTING_TEXT:		// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjCiGiBeC_xHqqkZx_
//	  {
//		// _xZkqqHx_iClHiCmFiCmJjAnNjCoIiNmPiCnNiCmMjBeJjBpAjEmNiImNiCpAiOoGjDlOiBeC_xHqqkZx_
//		longRangeVector vSelectRange;
//// 06.03.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		m_pHitTextObj->GetRichText()->GetSelection(vSelectRange);
//		g_pView->GetTextSelection(vSelectRange, m_pHitTextObj->GetObjID());
//		long lC;
//		// _xZkqqHx_iClHiCmFiCmJjAnNjCoIiNmPiCnNiCmMjBeJjBpAjEmNiImNiBeC_xHqqkZx_
//		longSet stCurSelIndex;
//		mdef_const_iterator(longRangeVector, iRange);
//		m1_for (iRange, vSelectRange)
//		{
//			for (lC = iRange->lFrom; lC != iRange->lTo; lC++)
//				stCurSelIndex.insert(lC);
//		}
//		// _xZkqqHx_jAfGiClFiCkNjBeJjBpAiClDiCoKiClNjEmNiImNiBeC_xHqqkZx_
//		longSet stNewSelIndex;
//		long lIndexFrom = (m_lHitCharIndexFrom < m_lHitCharIndexUntil) ? m_lHitCharIndexFrom : m_lHitCharIndexUntil;
//		long lIndexUntil = (m_lHitCharIndexFrom < m_lHitCharIndexUntil) ? m_lHitCharIndexUntil : m_lHitCharIndexFrom;
//		for (lC = lIndexFrom; lC != lIndexUntil; lC++)
//		{
//			// _xZkqqHx_iKpJiCmJjBeJjBpAiNmPiCnNiCmMjEmNiImNiImIiKePiCpAjAnNjCoIiBeC_xHqqkZx_
//			if (stCurSelIndex.find(lC) == stCurSelIndex.end())
//				stNewSelIndex.insert(lC);
//		}
//		// _xZkqqHx_jFgAiJoGiClHiCoJiBeC_xHqqkZx_
//		m_pHitTextObj->GetRichText()->DrawSelection(pDC, stNewSelIndex);
//		break;
//	  }
//	}
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnDraw(pDC);
//} // FCToolSelect::OnDraw.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::CheckHitText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDgFiDeMiDfIiDgHiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFmPjAjEiCmJjCgMiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolSelect::CheckHitText ()
{
	ObjDynabaseVector vSelectable;
	GetSelectableXXX(XXX_OBJ_BASE, &vSelectable);
	// _xZkqqHx_jBeJjBpAiJmCjEfMiCmIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiLhEiPiHiCmJjClCiNlIiBeC_xHqqkZx_
	ObjDynabaseVector::reverse_iterator rObj;
	for (rObj = vSelectable.rbegin(); rObj != vSelectable.rend(); rObj++)
	{
		BOOL bIsHitText;
		long lHitCharIndex;
		BOOL bIsHitCharFront;
		const DBLPoint mmptMargin(lg2mm(10), lg2mm(2));
		FCObjDynabase* pHitObj = (*rObj)->GetIntersect(	bIsHitText,
														lHitCharIndex,
														bIsHitCharFront,
// 06.04.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//														TRUE,
														mmptMargin,
														m_mmptMsc,
														FALSE);
		if (pHitObj != NULL && bIsHitText)
		{
			m_pHitTextObj = (FCObjFigure*)pHitObj;
			m_lHitCharIndexFrom = lHitCharIndex;
			if (!bIsHitCharFront)
				m_lHitCharIndexFrom++;
			m_lHitCharIndexUntil = m_lHitCharIndexFrom;
			break;
		} else
		{
			m_pHitTextObj = NULL;
		}
	}
	return (m_pHitTextObj != NULL);
} // FCToolSelect::CheckHitText.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelect::OnDrawState (CDC* pDC, int iState)
{
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_SELECTING_TEXT:		// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjCiGiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iClHiCmFiCmJjAnNjCoIiNmPiCnNiCmMjBeJjBpAjEmNiImNiCpAiOoGjDlOiBeC_xHqqkZx_
		longRangeVector vSelectRange;
// 06.03.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		m_pHitTextObj->GetRichText()->GetSelection(vSelectRange);
		g_pView->GetTextSelection(vSelectRange, m_pHitTextObj->GetObjID());
		long lC;
		// _xZkqqHx_iClHiCmFiCmJjAnNjCoIiNmPiCnNiCmMjBeJjBpAjEmNiImNiBeC_xHqqkZx_
		longSet stCurSelIndex;
		mdef_const_iterator(longRangeVector, iRange);
		m1_for (iRange, vSelectRange)
		{
			for (lC = iRange->lFrom; lC != iRange->lTo; lC++)
				stCurSelIndex.insert(lC);
		}
		// _xZkqqHx_jAfGiClFiCkNjBeJjBpAiClDiCoKiClNjEmNiImNiBeC_xHqqkZx_
		longSet stNewSelIndex;
		long lIndexFrom = (m_lHitCharIndexFrom < m_lHitCharIndexUntil) ? m_lHitCharIndexFrom : m_lHitCharIndexUntil;
		long lIndexUntil = (m_lHitCharIndexFrom < m_lHitCharIndexUntil) ? m_lHitCharIndexUntil : m_lHitCharIndexFrom;
		for (lC = lIndexFrom; lC != lIndexUntil; lC++)
		{
			// _xZkqqHx_iKpJiCmJjBeJjBpAiNmPiCnNiCmMjEmNiImNiImIiKePiCpAjAnNjCoIiBeC_xHqqkZx_
			if (stCurSelIndex.find(lC) == stCurSelIndex.end())
				stNewSelIndex.insert(lC);
		}
		// _xZkqqHx_jFgAiJoGiClHiCoJiBeC_xHqqkZx_
		m_pHitTextObj->GetRichText()->DrawSelection(pDC, stNewSelIndex);
		break;
	  }
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
} // FCToolSelect::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolPoly.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolSelect::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_

	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case FCToolSelectTmpl<FCToolBaseFDA, FCObjDynabase*, FCToolSelectObjTmplId>::STATE_PRE_UNSEL_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMjBePiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
		  {
			if (m_pHitTextObj != NULL)
				iNextState = STATE_START_SELECT_TEXT;	// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAiKeKiOgOiBeC_xHqqkZx_
			break;
		  }
		}
		break;
	case FCToolSelectTmpl<FCToolBaseFDA, FCObjDynabase*, FCToolSelectObjTmplId>::STATE_CLRSEL_SEL_XXX:	// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
		  {
			if (m_pHitTextObj != NULL)
				iNextState = STATE_START_SELECT_TEXT;	// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAiKeKiOgOiBeC_xHqqkZx_
			break;
		  }
		}
		break;
	case STATE_START_SELECT_TEXT:	// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAiKeKiOgOiBeC_xHqqkZx_
		iNextState = STATE_SELECTING_TEXT; 	// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjCiGiBeC_xHqqkZx_
		break;
	case STATE_SELECTING_TEXT:   	// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_SELECTING_TEXT;		// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjCiGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
		case WM_RBUTTONUP:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_SELECT_TEXT;	// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_SELECT_TEXT: 	// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAiPeJjHlJiBeC_xHqqkZx_
		iNextState = FCToolSelectTmpl<FCToolBaseFDA, FCObjDynabase*, FCToolSelectObjTmplId>::STATE_EXIT_SELECT_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolSelect::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelect::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_START_SELECT_TEXT:	// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAiKeKiOgOiBeC_xHqqkZx_
		StateStartSelectText(pDC);
		break;
	case STATE_SELECTING_TEXT:		// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjCiGiBeC_xHqqkZx_
		StateSelectingText(pDC);
		break;
	case STATE_STOP_SELECT_TEXT:	// _xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAiPeJjHlJiBeC_xHqqkZx_
		StateStopSelectText(pDC);
		break;
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolSelect::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::StateClrselSelXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelect::StateClrselSelXXX (XXX_ObjDynabase, CDC* pDC)
{
	// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLjFmPiNfIiBeC_xHqqkZx_
	if (m_pHitTextObj != NULL)
		FFGetMainWnd()->SetCurCursor(g_pView, FFGetApp()->LoadStandardCursor(IDC_IBEAM));
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::StateClrselSelXXX(XXX_OBJ_BASE, pDC);
} // FCToolSelect::StateClrselSelXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::StatePreUnselXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMjBePiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelect::StatePreUnselXXX (XXX_ObjDynabase, CDC* pDC)
{
	// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLjFmPiNfIiBeC_xHqqkZx_
	if (m_pHitTextObj != NULL)
		FFGetMainWnd()->SetCurCursor(g_pView, FFGetApp()->LoadStandardCursor(IDC_IBEAM));
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::StatePreUnselXXX(XXX_OBJ_BASE, pDC);
} // FCToolSelect::StatePreUnselXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::StateIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBnCiClPiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelect::StateIdle (CDC* pDC)
{
	// _xZkqqHx_iDhBiDgCiDgHiCmMiPoKiNiHiCmNiDeKiBfLiDfMiDiLjFmPiNfIiBeC_xHqqkZx_
	if (CheckHitText())
		SetIdleCursor(FFGetApp()->LoadStandardCursor(IDC_IBEAM));
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGjDjJiBeC_xHqqkZx_
	BASE_CLASS::StateIdle(pDC);
} // FCToolSelect::StateIdle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::StateStartSelectText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAiKeKiOgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelect::StateStartSelectText (CDC* pDC)
{
	TRACE(_T("FCToolSelect::StateStartSelectText\n"));
	if (!IsShift())
	//----- _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		ObjDynabaseVector vSelected;
		GetSelectedXXX(XXX_OBJ_BASE, &vSelected);
		// _xZkqqHx_jBeJjBpAiDeJiDhFiDfHiDeGiDeOiDgHiCkJiCoHiDgFiDeMiDfIiDgHjBeJjBpAiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		mdef_iterator(ObjDynabaseVector, iObj);
		m1_for (iObj, vSelected)
			(*iObj)->ClearTextSelection(pDC);
	}
} // FCToolSelect::StateStartSelectText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::StateSelectingText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAjCiGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelect::StateSelectingText (CDC* pDC)
{
	TRACE(_T("FCToolSelect::StateSelectingText\n"));
	// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLjFmPiNfIiBeC_xHqqkZx_
	FFGetMainWnd()->SetCurCursor(g_pView, FFGetApp()->LoadStandardCursor(IDC_IBEAM));

	long lHitCharIndexUntil;
	const DBLPoint mmptMargin(lg2mm(10), lg2mm(2));
	BOOL bIsHitCharFront;
	if (m_pHitTextObj->GetRichText()->GetIntersect(lHitCharIndexUntil, bIsHitCharFront, mmptMargin, m_mmptMsc))
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiPoDiCmJiDhNiDeFiDfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFlGiOjKiMoDjElMiCmJiDhBiDgCiDgHiCmMiPoKiNiHiCmNiDeDiDjDiDgGiDgCiDeOiDfIiCpAiJmBiOfKiBeC_xHqqkZx_
		if (!bIsHitCharFront)
			lHitCharIndexUntil++;
		if (lHitCharIndexUntil != m_lHitCharIndexUntil)
		//----- _xZkqqHx_jBePiJpBiCmGjBeJjBpAjEmNiImNiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iClHiCmFiCmJjAnNjCoIiNmPiCnNiCmMjBeJjBpAjEmNiImNiCpAiOoGjDlOiBeC_xHqqkZx_
			longRangeVector vSelectRange;
// 06.03.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			m_pHitTextObj->GetRichText()->GetSelection(vSelectRange);
			g_pView->GetTextSelection(vSelectRange, m_pHitTextObj->GetObjID());
			long lC;
			// _xZkqqHx_iClHiCmFiCmJjAnNjCoIiNmPiCnNiCmMjBeJjBpAjEmNiImNiBeC_xHqqkZx_
			longSet stCurSelIndex;
			mdef_const_iterator(longRangeVector, iRange);
			m1_for (iRange, vSelectRange)
			{
				for (lC = iRange->lFrom; lC != iRange->lTo; lC++)
					stCurSelIndex.insert(lC);
			}
			// _xZkqqHx_jAfGiClFiCkNjBeJjBpAiClDiCoKiClNjEmNiImNiBeC_xHqqkZx_
			longSet stNewSelIndex = stCurSelIndex;
			long lIndexFrom = (m_lHitCharIndexFrom < m_lHitCharIndexUntil) ? m_lHitCharIndexFrom : m_lHitCharIndexUntil;
			long lIndexUntil = (m_lHitCharIndexFrom < m_lHitCharIndexUntil) ? m_lHitCharIndexUntil : m_lHitCharIndexFrom;
			for (lC = lIndexFrom; lC != lIndexUntil; lC++)
				stCurSelIndex.insert(lC);

			lIndexFrom = (m_lHitCharIndexFrom < lHitCharIndexUntil) ? m_lHitCharIndexFrom : lHitCharIndexUntil;
			lIndexUntil = (m_lHitCharIndexFrom < lHitCharIndexUntil) ? lHitCharIndexUntil : m_lHitCharIndexFrom;
			for (lC = lIndexFrom; lC != lIndexUntil; lC++)
				stNewSelIndex.insert(lC);

			// _xZkqqHx_jBeJjBpAiNmPiCnNjEmNiImNiCmGjAfGjBeJjBpAjEmNiImNiCmMiLkEjCmKjFjEjFkKiCpAiOoGiCoIiLiOiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iMiLiJmKiBeB_xHqqkZx_stCurSelIndex_xZkqqHx_iCmJiCmNiPmBiLiOiClHiCnHiCkLjEmNiImNiBeB_xHqqkZx_stNewSelIndex_xZkqqHx_iCmJiCmN_xHqqkZx_
			// _xZkqqHx_jFgAiJoGiClHiCnHiCkLjEmNiImNiCkKiOgDiCoJiBeC_xHqqkZx_
			FFIntersection(longSet(), stCurSelIndex, stNewSelIndex);
			// _xZkqqHx_iPmBiLiOiClHiCnHiCkLjEmNiImNiCmGjFgAiJoGiClHiCnHiCkLjEmNiImNiCpAiDhNiBfLiDfHiBeC_xHqqkZx_
			FFInsert(stCurSelIndex, stNewSelIndex);
			// _xZkqqHx_jHlMjFpLjFgAiJoGiClHiCoJiBeCiPmBiLiOiClHiCnHiCkLjEmNiImNiCmNiBeBiKpJiCmJjFgAiJoGiClDiCoKiCmEiCkCiCoJjFjEjFkKiCpAjFgAiJoGiClHiCoJiClNiCnPiBeB_xHqqkZx_
			// _xZkqqHx_iPjPiOoIiCmJiPmBiLiOiClDiCoKiCoJiBeC_xHqqkZx_
			m_pHitTextObj->GetRichText()->DrawSelection(pDC, stCurSelIndex);
			m_lHitCharIndexUntil = lHitCharIndexUntil;
		}
	}
} // FCToolSelect::StateSelectingText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolSelect::StateStopSelectText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBeJjBpAiPeJjHlJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolSelect::StateStopSelectText (CDC* pDC)
{
	TRACE(_T("FCToolSelect::StateStopSelectText\n"));
	// _xZkqqHx_iDeOiDiKiDgCiDeOiCmJiDhBiDgCiDgHiClFiClNjFlGiOjKiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	if (m_lHitCharIndexUntil < m_lHitCharIndexFrom)
		::Exchange(m_lHitCharIndexFrom, m_lHitCharIndexUntil);
	if (m_lHitCharIndexFrom != m_lHitCharIndexUntil)
	{
// 06.03.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		m_pHitTextObj->GetRichText()->AppendSelection(m_lHitCharIndexFrom, m_lHitCharIndexUntil);
		g_pView->AppendTextSelection(m_pHitTextObj->GetObjID(), m_lHitCharIndexFrom, m_lHitCharIndexUntil);
	}
} // FCToolSelect::StateStopSelectText.

