#include "stdafx.h"
#include "DynamicDraw.h"		// For FFGetApp.
// 03.07.18 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "MainFrame.h"		// For g_pFrame.
#include "DynamicDrawView.h"	// For g_pView.
#include "FrameWnd.h"		// For FFGetMainWnd().
#include "DynamicDrawDoc.h"	// For g_pDoc.
#include "ToolZoom.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolZoom::GetDefaultIdleCursor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	StateIdle_xZkqqHx_iCmFiDgGiDhEiDeIiDiLiDgHiCmJiOgHiCoNiCoKiCoJiDeKiBfLiDfMiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jFfHiPiAiCmMiDeKiBfLiDfMiDiLiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HCURSOR FCToolZoom::GetDefaultIdleCursor () const
{
	if (IsShift())
		return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_ZOOM_OUT);
	else
		return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_ZOOM_IN);
} // FCToolZoom::GetDefaultIdleCursor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolZoom::CanSelectTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolZoom::CanSelectTool () const
{
	// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmNiBeBjFlGiPjBiCkKjDmHiCnNiNjOiCnNiCgOiCgKiCmFiKeKiCkCiCmEiCkCiCoJiCmGiCkLiClOiCkP_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
	if (g_pDoc->GetIsDocumentOpened()) return TRUE;
	return FALSE;
} // FCToolZoom::CanSelectTool.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolZoom::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolZoom.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolZoom::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_

	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_IDLE:		// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
		case WM_LBUTTONDBLCLK:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDhFiDiLiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
			if (IsShift())
				iNextState = STATE_ZOOM_OUT;	// _xZkqqHx_iDfJiBfLiDiAiDeBiDeFiDgHiBeC_xHqqkZx_
			else
				iNextState = STATE_ZOOM_IN;		// _xZkqqHx_iDfJiBfLiDiAiDeDiDjDiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_ZOOM_IN:		// _xZkqqHx_iDfJiBfLiDiAiDeDiDjDiBeC_xHqqkZx_
		iNextState = STATE_IDLE;		// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	case STATE_ZOOM_OUT:	// _xZkqqHx_iDfJiBfLiDiAiDeBiDeFiDgHiBeC_xHqqkZx_
		iNextState = STATE_IDLE;		// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolZoom::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolZoom::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolZoom::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_ZOOM_IN:		// _xZkqqHx_iDfJiBfLiDiAiDeDiDjDiBeC_xHqqkZx_
		StateZoomIn(pDC);
		break;
	case STATE_ZOOM_OUT:	// _xZkqqHx_iDfJiBfLiDiAiDeBiDeFiDgHiBeC_xHqqkZx_
		StateZoomOut(pDC);
		break;
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolZoom::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolZoom::StateIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBnCiClPiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolZoom::StateIdle (CDC* pDC)
{
	TRACE(_T("StateIdle\r\n"));
	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCnGiCmMjFfMiOkGiPiIjHjN_xHqqkZx_ -----
	WString strMsg;
	strMsg.Format(L"ZOOM %d%%", (g_->lZoom256 * 100) / 256);
	FFGetMainWnd()->SetStatusBarText(strMsg);

	//----- _xZkqqHx_iDeKiBfLiDfMiDiLjAnNjCoIiBeC_xHqqkZx_FCToolBaseFDA::StateIdle_xZkqqHx_iCmMjBoDiCoNiCoIiCmJ_xHqqkZx_ -----
	// _xZkqqHx_iDfGiBfLiDgHiCkKiPiAjEpFiCmFiCkLiCmEiCkCiCmIiCkCiPoKiNiHiCmNiNlLiOjOiMhGiDeKiBfLiDfMiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	if (!g_pDoc->IsCurrentSheetReady())
		m_hIdleCursor = FFGetApp()->LoadStandardCursor(IDC_WAIT);
	if (m_hIdleCursor == NULL)
		m_hIdleCursor = GetDefaultIdleCursor();
	FFGetMainWnd()->SetCurCursor(g_pView, m_hIdleCursor);
	// StateIdle_xZkqqHx_iOjOiCmMiDeKiBfLiDfMiDiLjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_hIdleCursor = NULL;
} // FCToolZoom::StateIdle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolZoom::StateZoomIn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiDeDiDjDiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolZoom::StateZoomIn (CDC* pDC)
{
	TRACE(_T("StateZoomIn\r\n"));
	if (IsControl())
	{
		g_pView->PostMessage(WM_USER_SET_ZOOM256, TRUE, g_->lZoom256 * 1.2);
	} else
	{
		g_pView->SendMessage(WM_COMMAND, ID_VIEW_ZOOMIN, 0L);
	}
//	EndOfSession();
} // FCToolZoom::StateZoomIn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolZoom::StateZoomOut
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiDeBiDeFiDgHiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolZoom::StateZoomOut (CDC* pDC)
{
	TRACE(_T("StateZoomOut\r\n"));
	if (IsControl())
	{
		g_pView->PostMessage(WM_USER_SET_ZOOM256, TRUE, g_->lZoom256 * 0.8);
	} else
	{
		g_pView->SendMessage(WM_COMMAND, ID_VIEW_ZOOMOUT, 0L);
	}
//	EndOfSession();
} // FCToolZoom::StateZoomOut.

