#include "stdafx.h"
#include "UtilBezier.h"	// For FCBezierControlsVector.
#include "UtilArc.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const double g_aSin[] = {
	0.00000000000000000000e+000,	// 0
	3.48994967025009690000e-002,	// 2
	6.97564737441253020000e-002,	// 4
	1.04528463267653460000e-001,	// 6
	1.39173100960065440000e-001,	// 8
	1.73648177666930330000e-001,	// 10
	2.07911690817759310000e-001,	// 12
	2.41921895599667730000e-001,	// 14
	2.75637355816999160000e-001,	// 16
	3.09016994374947400000e-001,	// 18
	3.42020143325668710000e-001,	// 20
	3.74606593415912010000e-001,	// 22
	4.06736643075800150000e-001,	// 24
	4.38371146789077400000e-001,	// 26
	4.69471562785890810000e-001,	// 28
	4.99999999999999940000e-001,	// 30
	5.29919264233204900000e-001,	// 32
	5.59192903470746790000e-001,	// 34
	5.87785252292473140000e-001,	// 36
	6.15661475325658290000e-001,	// 38
	6.42787609686539250000e-001,	// 40
	6.69130606358858240000e-001,	// 42
	6.94658370458997250000e-001,	// 44
	7.19339800338651080000e-001,	// 46
	7.43144825477394130000e-001,	// 48
	7.66044443118978010000e-001,	// 50
	7.88010753606721900000e-001,	// 52
	8.09016994374947450000e-001,	// 54
	8.29037572555041740000e-001,	// 56
	8.48048096156425960000e-001,	// 58
	8.66025403784438600000e-001,	// 60
	8.82947592858926880000e-001,	// 62
	8.98794046299167040000e-001,	// 64
	9.13545457642600870000e-001,	// 66
	9.27183854566787310000e-001,	// 68
	9.39692620785908320000e-001,	// 70
	9.51056516295153530000e-001,	// 72
	9.61261695938318890000e-001,	// 74
	9.70295726275996470000e-001,	// 76
	9.78147600733805690000e-001,	// 78
	9.84807753012208020000e-001,	// 80
	9.90268068741570360000e-001,	// 82
	9.94521895368273290000e-001,	// 84
	9.97564050259824200000e-001,	// 86
	9.99390827019095760000e-001,	// 88
	1.00000000000000000000e+000,	// 90
	9.99390827019095760000e-001,	// 92
	9.97564050259824200000e-001,	// 94
	9.94521895368273400000e-001,	// 96
	9.90268068741570360000e-001,	// 98
	9.84807753012208020000e-001,	// 100
	9.78147600733805690000e-001,	// 102
	9.70295726275996470000e-001,	// 104
	9.61261695938318890000e-001,	// 106
	9.51056516295153640000e-001,	// 108
	9.39692620785908430000e-001,	// 110
	9.27183854566787420000e-001,	// 112
	9.13545457642600980000e-001,	// 114
	8.98794046299166930000e-001,	// 116
	8.82947592858927100000e-001,	// 118
	8.66025403784438710000e-001,	// 120
	8.48048096156426070000e-001,	// 122
	8.29037572555041740000e-001,	// 124
	8.09016994374947450000e-001,	// 126
	7.88010753606722010000e-001,	// 128
	7.66044443118978010000e-001,	// 130
	7.43144825477394470000e-001,	// 132
	7.19339800338651080000e-001,	// 134
	6.94658370458997480000e-001,	// 136
	6.69130606358858020000e-001,	// 138
	6.42787609686539470000e-001,	// 140
	6.15661475325658400000e-001,	// 142
	5.87785252292473250000e-001,	// 144
	5.59192903470746900000e-001,	// 146
	5.29919264233204900000e-001,	// 148
	4.99999999999999940000e-001,	// 150
	4.69471562785890690000e-001,	// 152
	4.38371146789077680000e-001,	// 154
	4.06736643075800040000e-001,	// 156
	3.74606593415912240000e-001,	// 158
	3.42020143325668880000e-001,	// 160
	3.09016994374947510000e-001,	// 162
	2.75637355816999220000e-001,	// 164
	2.41921895599667730000e-001,	// 166
	2.07911690817759310000e-001,	// 168
	1.73648177666930690000e-001,	// 170
	1.39173100960065330000e-001,	// 172
	1.04528463267653730000e-001,	// 174
	6.97564737441255240000e-002,	// 176
	3.48994967025011430000e-002,	// 178
	1.22460635382237730000e-016,	// 180
	-3.48994967025009000000e-002,	// 182
	-6.97564737441248310000e-002,	// 184
	-1.04528463267653500000e-001,	// 186
	-1.39173100960065520000e-001,	// 188
	-1.73648177666930470000e-001,	// 190
	-2.07911690817759070000e-001,	// 192
	-2.41921895599667510000e-001,	// 194
	-2.75637355816998610000e-001,	// 196
	-3.09016994374947730000e-001,	// 198
	-3.42020143325668660000e-001,	// 200
	-3.74606593415912010000e-001,	// 202
	-4.06736643075799820000e-001,	// 204
	-4.38371146789077070000e-001,	// 206
	-4.69471562785890470000e-001,	// 208
	-5.00000000000000110000e-001,	// 210
	-5.29919264233204790000e-001,	// 212
	-5.59192903470746680000e-001,	// 214
	-5.87785252292473030000e-001,	// 216
	-6.15661475325657850000e-001,	// 218
	-6.42787609686539250000e-001,	// 220
	-6.69130606358858240000e-001,	// 222
	-6.94658370458997370000e-001,	// 224
	-7.19339800338650860000e-001,	// 226
	-7.43144825477394020000e-001,	// 228
	-7.66044443118977900000e-001,	// 230
	-7.88010753606722130000e-001,	// 232
	-8.09016994374947340000e-001,	// 234
	-8.29037572555041400000e-001,	// 236
	-8.48048096156425960000e-001,	// 238
	-8.66025403784438370000e-001,	// 240
	-8.82947592858926990000e-001,	// 242
	-8.98794046299166820000e-001,	// 244
	-9.13545457642600980000e-001,	// 246
	-9.27183854566787310000e-001,	// 248
	-9.39692620785908210000e-001,	// 250
	-9.51056516295153530000e-001,	// 252
	-9.61261695938319010000e-001,	// 254
	-9.70295726275996470000e-001,	// 256
	-9.78147600733805580000e-001,	// 258
	-9.84807753012208020000e-001,	// 260
	-9.90268068741570250000e-001,	// 262
	-9.94521895368273290000e-001,	// 264
	-9.97564050259824200000e-001,	// 266
	-9.99390827019095760000e-001,	// 268
	-1.00000000000000000000e+000,	// 270
	-9.99390827019095760000e-001,	// 272
	-9.97564050259824310000e-001,	// 274
	-9.94521895368273290000e-001,	// 276
	-9.90268068741570360000e-001,	// 278
	-9.84807753012208130000e-001,	// 280
	-9.78147600733805580000e-001,	// 282
	-9.70295726275996580000e-001,	// 284
	-9.61261695938319010000e-001,	// 286
	-9.51056516295153640000e-001,	// 288
	-9.39692620785908320000e-001,	// 290
	-9.27183854566787420000e-001,	// 292
	-9.13545457642601090000e-001,	// 294
	-8.98794046299167040000e-001,	// 296
	-8.82947592858927100000e-001,	// 298
	-8.66025403784438600000e-001,	// 300
	-8.48048096156426180000e-001,	// 302
	-8.29037572555041620000e-001,	// 304
	-8.09016994374947560000e-001,	// 306
	-7.88010753606722350000e-001,	// 308
	-7.66044443118978120000e-001,	// 310
	-7.43144825477394020000e-001,	// 312
	-7.19339800338651190000e-001,	// 314
	-6.94658370458997590000e-001,	// 316
	-6.69130606358858790000e-001,	// 318
	-6.42787609686539580000e-001,	// 320
	-6.15661475325658180000e-001,	// 322
	-5.87785252292473360000e-001,	// 324
	-5.59192903470747350000e-001,	// 326
	-5.29919264233205010000e-001,	// 328
	-5.00000000000000440000e-001,	// 330
	-4.69471562785890810000e-001,	// 332
	-4.38371146789077790000e-001,	// 334
	-4.06736643075800150000e-001,	// 336
	-3.74606593415912350000e-001,	// 338
	-3.42020143325669430000e-001,	// 340
	-3.09016994374947620000e-001,	// 342
	-2.75637355816998940000e-001,	// 344
	-2.41921895599667870000e-001,	// 346
	-2.07911690817759870000e-001,	// 348
	-1.73648177666930390000e-001,	// 350
	-1.39173100960065880000e-001,	// 352
	-1.04528463267654300000e-001,	// 354
	-6.97564737441256360000e-002,	// 356
	-3.48994967025008230000e-002,	// 358
	0.00000000000000000000e+000,	// 0
	3.48994967025009690000e-002,	// 2
	6.97564737441253020000e-002,	// 4
	1.04528463267653460000e-001,	// 6
	1.39173100960065440000e-001,	// 8
	1.73648177666930330000e-001,	// 10
	2.07911690817759310000e-001,	// 12
	2.41921895599667730000e-001,	// 14
	2.75637355816999160000e-001,	// 16
	3.09016994374947400000e-001,	// 18
	3.42020143325668710000e-001,	// 20
	3.74606593415912010000e-001,	// 22
	4.06736643075800150000e-001,	// 24
	4.38371146789077400000e-001,	// 26
	4.69471562785890810000e-001,	// 28
	4.99999999999999940000e-001,	// 30
	5.29919264233204900000e-001,	// 32
	5.59192903470746790000e-001,	// 34
	5.87785252292473140000e-001,	// 36
	6.15661475325658290000e-001,	// 38
	6.42787609686539250000e-001,	// 40
	6.69130606358858240000e-001,	// 42
	6.94658370458997250000e-001,	// 44
	7.19339800338651080000e-001,	// 46
	7.43144825477394130000e-001,	// 48
	7.66044443118978010000e-001,	// 50
	7.88010753606721900000e-001,	// 52
	8.09016994374947450000e-001,	// 54
	8.29037572555041740000e-001,	// 56
	8.48048096156425960000e-001,	// 58
	8.66025403784438600000e-001,	// 60
	8.82947592858926880000e-001,	// 62
	8.98794046299167040000e-001,	// 64
	9.13545457642600870000e-001,	// 66
	9.27183854566787310000e-001,	// 68
	9.39692620785908320000e-001,	// 70
	9.51056516295153530000e-001,	// 72
	9.61261695938318890000e-001,	// 74
	9.70295726275996470000e-001,	// 76
	9.78147600733805690000e-001,	// 78
	9.84807753012208020000e-001,	// 80
	9.90268068741570360000e-001,	// 82
	9.94521895368273290000e-001,	// 84
	9.97564050259824200000e-001,	// 86
	9.99390827019095760000e-001,	// 88
	1.00000000000000000000e+000,	// 90
};

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetArcBeziers
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJhOiCmMjCiGjAfDjDfPiBeB_xHqqkZx_X_xZkqqHx_iOlCjElMiMgBiBeB_xHqqkZx_Y_xZkqqHx_iOlCjElMiMgBiBeBiJhOiMmKiCmMiKeKiOgOiKhAiBeBiPeJjHlJiKhAiCpAiOhHjCoIiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iJhOiMmKiCmMiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptArcO	:_xZkqqHx_iJhOiMmKiCmMjCiGjAfDjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLx		:_xZkqqHx_iJhOiMmKiCmM_xHqqkZx_X_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLy		:_xZkqqHx_iJhOiMmKiCmM_xHqqkZx_Y_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dBeginR		:_xZkqqHx_iJhOiMmKiCmMiKeKiOgOiKhAiCpAiOhHjCoIiBeC_xHqqkZx_[0.0, 2.0)
 *			dEndR		:_xZkqqHx_iJhOiMmKiCmMiPeJjHlJiKhAiCpAiOhHjCoIiBeC_xHqqkZx_[0.0, 2.0)
 *			nType		:_xZkqqHx_iJhOiCmMiMgAiPpDiCpAiOhHjCoIiBeCiImIiJlKiCmMiMgAiCkKiOhHjCoIiCmFiCkLiCoJiBeC_xHqqkZx_
 *					1	:_xZkqqHx_iDhAiDeDiMfO_xHqqkZx_
 *					2	:_xZkqqHx_iLhMiMfO_xHqqkZx_
 *					3	:_xZkqqHx_iJhOiMmKiCmMiCnN_xHqqkZx_
 *			mmShiftX	:X_xZkqqHx_jFpLiMpMiCnGiCmMiDfGiDhEiDgHjFmPiMgAiCmMjBoFiCkLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRotate		:_xZkqqHx_iJpBjDfNjFmPiMgAiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptRotateO	:_xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfGiDhEiDgHjFmPiMgAiCmNiBeBiJhOiMmKiCmMjCiGjAfDjDfPiNmAjFfHiCpAjCiGjAfDiCmJiNhDiCkEiBeC_xHqqkZx_
 *
 *                                           mmShiftX
 *                                          _xZkqqHx_iEkA_xHqqkZx_-_xZkqqHx_iEjPiEjPiBkIiEkA_xHqqkZx_
 *                              _xZkqqHx_iBfBiBfBiBfBiBfBiBfBiBfBiBfBiBfBiBfBiBfBiBfB_xHqqkZx_ 
 *                            _xZkqqHx_iBfO_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBfO_xHqqkZx_ 
 *                          _xZkqqHx_iBfO_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_
 *                        _xZkqqHx_iBfO_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBfO_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_
 *                      _xZkqqHx_iBfO_xHqqkZx_                  _xZkqqHx_iEkAiBfO_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *                    _xZkqqHx_iBfO_xHqqkZx_                    _xZkqqHx_iBfO_xHqqkZx_
 *                  _xZkqqHx_iBfO_xHqqkZx_                    _xZkqqHx_iBfO_xHqqkZx_
 *                _xZkqqHx_iBfO_xHqqkZx_                    _xZkqqHx_iBfO_xHqqkZx_
 *              _xZkqqHx_iBfO_xHqqkZx_                    _xZkqqHx_iBfO_xHqqkZx_
 *            _xZkqqHx_iBfO_xHqqkZx_                    _xZkqqHx_iBfO_xHqqkZx_
 *            _xZkqqHx_iBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfA_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetArcBeziers (	FCMmPolyBezier& polyBezier,
						const DBLPoint& mmptArcO,
						mmetol mmLx,
						mmetol mmLy,
						angle dBeginR,
						angle dEndR,
						short nType,
						mmetol mmShiftX,
						angle dRotate,
						const DBLPoint& mmptRotateO)
{
	// _xZkqqHx_iCnMiClIiBeB_xHqqkZx_mmLx,mmLy_xZkqqHx_iCpAjElMiMgBiCmGiClHiCoJjBmIiJhOiCmMiMmKiCpAiMhGiOfKiBeC_xHqqkZx_
	FFCalcArcBeziers(polyBezier, mmptArcO, mmLx, mmLy, dBeginR, dEndR);
	if (!almosteq(polyBezier.front(), polyBezier.back()))
	//----- _xZkqqHx_iOgOjDfPiCmGiPeJjDfPiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
	{
		switch (nType)
		{
		case 1:		// _xZkqqHx_iDhAiDeDiMfOiBeC_xHqqkZx_
			// _xZkqqHx_jCiGjAfDiNmAjFfHiCpAjCmHiJmBiBeC_xHqqkZx_
			polyBezier.push_back(polyBezier.back());
			polyBezier.push_back(mmptArcO);
			polyBezier.push_back(mmptArcO);
			// _xZkqqHx_iOgOjDfPiCpAjCmHiJmBiBeC_xHqqkZx_
			polyBezier.push_back(mmptArcO);
			polyBezier.push_back(polyBezier.front());
			polyBezier.push_back(polyBezier.front());
			break;
		case 2:		// _xZkqqHx_iLhMiMfOiBeC_xHqqkZx_
			// _xZkqqHx_iOgOjDfPiCpAjCmHiJmBiBeC_xHqqkZx_
			polyBezier.push_back(polyBezier.back());
			polyBezier.push_back(polyBezier.front());
			polyBezier.push_back(polyBezier.front());
			break;
		}
	}
	// _xZkqqHx_iDfGiDhEiDgHiBeBiJpBjDfNjFmPiKlHiClHiCoJiBeC_xHqqkZx_
	if (!almost0(mmShiftX))
	//----- _xZkqqHx_iDfGiDhEiDgHjFmPiKlHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		ShiftConv(	polyBezier.GetArray(),
					polyBezier.size(),
					mmLy, mmShiftX, mmptArcO.y);
	}
	if (!almost0(dRotate))
	//----- _xZkqqHx_iJpBjDfNjFmPiKlHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		RotateConv(	polyBezier.GetArray(),
					polyBezier.size(),
					FFSin(dRotate),
					FFCos(dRotate),
					mmptRotateO.x,
					mmptRotateO.y);
	}
} // FFGetArcBeziers.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcArcBeziers
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBmIiJhOiCmMiJhOiMmKiCpAjFkBjAjEiCmMiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptO		:_xZkqqHx_iJhOiCmMjCiGjAfDjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLx		:_xZkqqHx_iJhOiMmKiCmM_xHqqkZx_X_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLy		:_xZkqqHx_iJhOiMmKiCmM_xHqqkZx_Y_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dBeginR		:_xZkqqHx_iOgOjDfPiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dEndR		:_xZkqqHx_iPeJjDfPiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJhOiMmKiCpAiDhIiDfHiDeGiLnPiOjHiClHiCoJiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJhOiMmKiCmMiOgOjDfP_xHqqkZx_A_xZkqqHx_iCmGiPeJjDfP_xHqqkZx_D_xZkqqHx_iCmMiKhAjDhIiCmNiKpJjCgNiCmGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOgOjDfPiCkJiCoHiPeJjDfPiCnGiCmMiKhAjDhIiNlHiCkKjBlNiCkLiCkCiPoKiNiHiBeBiClLiCoKiCpAiIoKiCmCiCmMiDhIiDfHiDeGiLmIjApMiCmF_xHqqkZx_
 *			_xZkqqHx_iLnPiOjHiClHiCoJiClBiCmGiCmNiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
 *			0.5_xZkqqHx_iImIjDoAiCmMiJhOiMmKiCmJiLmPjDjJiCmJjFkKiKiEiClFiBeBiClLiCoKiClMiCoKiCpAiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
extern void FFCalcArcBeziers (	FCMmPolyBezier& polyBezier,
								const DBLPoint& mmptO,
								mmetol mmLx,
								mmetol mmLy,
								angle dBeginR,
								angle dEndR)
{
	polyBezier.clear();
	polyBezier.SetIsBezier(TRUE);
	// _xZkqqHx_iOgOjDfPiCkJiCoHiPeJjDfPiCmJiOiKiCoJiKhAjDhIiNlHiCpAiMhGiOfKiBeC_xHqqkZx_
	angle dDR = RegulateAngle(dEndR - dBeginR);
	// _xZkqqHx_iOgOjDfPiCmGiPeJjDfPiCkKjDkPiClGiKhAjDhIiCmIiCoHiBeBiJhOiBeC_xHqqkZx_
	if (almost0(dDR)) dDR = 2.0;
	long lDivSize = 1;
	while (0.5 < dDR / double(lDivSize))
		lDivSize++;
	FCBezierControls bc;
	angle dPrevR = dBeginR;
	for (long lC = 0; lC != lDivSize; lC++)
	{
		angle dNextR = dBeginR + dDR * double(lC + 1) / double(lDivSize);
		FFCalcArcBezier(bc, mmptO, mmLx, mmLy, dPrevR, dNextR);
		polyBezier.push_back(bc.A());
		polyBezier.push_back(bc.B());
		polyBezier.push_back(bc.C());
		dPrevR = dNextR;
	}
	polyBezier.push_back(bc.D());
} // FFCalcArcBeziers.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcArcBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBmIiJhOiCmMiJhOiMmKiCpAiCfAiCmCiCmMiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bc		:_xZkqqHx_iCfDiCmCiCmMjAkHiMoEjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptO	:_xZkqqHx_iJhOiCmMjCiGjAfDjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLx	:_xZkqqHx_iJhOiMmKiCmM_xHqqkZx_X_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLy	:_xZkqqHx_iJhOiMmKiCmM_xHqqkZx_Y_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRa		:_xZkqqHx_iOgOjDfPiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRd		:_xZkqqHx_iPeJjDfPiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOgOjDfPiCkJiCoHiPeJjDfPiCnGiCmMiKhAjDhIiNlHiCmN_xHqqkZx_0.5_xZkqqHx_iImIjDoAiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJhOiMmKiCpAiDhIiDfHiDeGiLnPiOjHiClHiCoJiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJhOiMmKiCmMiOgOjDfP_xHqqkZx_A_xZkqqHx_iCmGiPeJjDfP_xHqqkZx_D_xZkqqHx_iCmMiKhAjDhIiCmNiKpJjCgNiCmGiClHiCoJiBeC_xHqqkZx_
 *			A_xZkqqHx_iCmG_xHqqkZx_D_xZkqqHx_iCmMjCiGiKnEiCmMiKhAjDhIiCmMiJhOiMmKiPoDiCmMjDfPiCpA_xHqqkZx_P_xZkqqHx_iCmGiClHiCoJiBeC_xHqqkZx_
 *
 *                    P
 *                  _xZkqqHx_iBfOiBfP_xHqqkZx_
 *                _xZkqqHx_iBfO_xHqqkZx_    _xZkqqHx_iBfP_xHqqkZx_
 *              _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfP_xHqqkZx_
 *            _xZkqqHx_iBfO_xHqqkZx_            _xZkqqHx_iBfP_xHqqkZx_
 *           A                D
 *
 *			A_xZkqqHx_iCmG_xHqqkZx_D_xZkqqHx_iCmMiKhAjDhIiCkJiCoHiBeBjClMjApM_xHqqkZx_AB_xZkqqHx_iCmG_xHqqkZx_DC_xZkqqHx_iCmMiKhAjDhIiCmNiOfKiPgPiCmFiCkLiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmNiDhIiDfHiDeGiLmIjApMiCmMiOkOiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3
 *			P_xZkqqHx_iCmNjCiGiKnEjDfPiCmIiCmMiCmFiBeB_xHqqkZx_t=0.5_xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *			P = 0.125*A + 0.375*B + 0.375*C + 0.125*D
 *			B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAiBeBjApMjFkK_xHqqkZx_AB=L*u_xZkqqHx_iCmGjApMjFkK_xHqqkZx_DC=M*u(L,M_xZkqqHx_iCmNjClHiClD_xHqqkZx_1)_xZkqqHx_iCmFjFfMiClHiCmG_xHqqkZx_
 *			B=A+L*u
 *			C=D+M*u
 *			_xZkqqHx_iClBiCoKiCpAjBoDjDpMiClFiCmE_xHqqkZx_
 *			P = 0.125*A + 0.125*D + 0.375*(A + L*u) + 0.375*(D + M*u)
 *			P = 0.5*A + 0.5*D + 0.375*L*u + 0.375*M*u
 *			u_xZkqqHx_iCpAiJpAiCkCiCmE_xHqqkZx_
 *			u = (-0.5*(A + D) + P)/(0.375*(L + M)) _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			_xZkqqHx_jFkKjFoKiCkKiCePiCmJiCmIiCoHiCmIiCkCiCoGiCkEiBeB_xHqqkZx_x_xZkqqHx_iCkJ_xHqqkZx_y_xZkqqHx_iCmJiKnGiClFiCmEiHeAiCpAiJpAiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCalcArcBezier (	FCBezierControls& bc,
						const DBLPoint& mmptO,
						mmetol mmLx,
						mmetol mmLy,
						angle dRa,
						angle dRd)
{
	// _xZkqqHx_iOgOjDfPiCkJiCoHiPeJjDfPiCmJiOiKiCoJiKhAjDhIiNlHiCpAiMhGiOfKiBeC_xHqqkZx_
	angle dDR = RegulateAngle(dRd - dRa);
	// _xZkqqHx_iLnPiOjHiCmFiCkLiCoJiCmMiCmN_xHqqkZx_1/4*PI_xZkqqHx_iCnMiCmFiBeC_xHqqkZx_
	if (0.5 < dDR) return FALSE;
	// _xZkqqHx_jDfP_xHqqkZx_P_xZkqqHx_iCmMiKhAjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
	angle dRp = dRa + (dDR / 2.0);
	// Ly_xZkqqHx_iCpAjElMiMgBiCmGiClHiCoJjAfOiJhOiCmMiJhOiMmKiCpAiLnPiOjHiClHiCoJiBeC_xHqqkZx_
	DBLPoint mmptP = mmptO + mmLy * DBLPoint(FFCos(dRp), FFSin(dRp));
	bc.A() = mmptO + mmLy * DBLPoint(FFCos(dRa), FFSin(dRa));
	bc.D() = mmptO + mmLy * DBLPoint(FFCos(dRd), FFSin(dRd));
	angle dRl = dRa + 0.5;
	angle dRm = dRd - 0.5;
	DBLPoint mmptL = DBLPoint(FFCos(dRl), FFSin(dRl));
	DBLPoint mmptM = DBLPoint(FFCos(dRm), FFSin(dRm));
	mmetol mmU;
	if (almost0(mmptL.x + mmptM.x))
		mmU = (-0.5*(bc.A().y + bc.D().y) + mmptP.y)/(0.375*(mmptL.y + mmptM.y));
	else
		mmU = (-0.5*(bc.A().x + bc.D().x) + mmptP.x)/(0.375*(mmptL.x + mmptM.x));
	bc.B() = bc.A() + mmU * mmptL;
	bc.C() = bc.D() + mmU * mmptM;
	// _xZkqqHx_iDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
	FFResizePolygon(bc.m_mmptControl,
					4,
					DBLRect(mmptO, mmptO).ExtendRect(mmLy),
					TRUE, TRUE,
					DBLRect(mmptO, mmptO).ExtendRect(mmLx, mmLy));
	return TRUE;
} // FFCalcArcBezier.

