#include "stdafx.h"
#include <float.h>		// For DBL_MAX.
#include "Cardano.h"	// For FCCardano.
//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
#include "UtilErr.h"	// For FFThrowMiscUnknown.
#include "UtilMath.h"	// For ArcTan.
//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
#include "UtilBezier.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFControlConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCBezierControlsVector_xZkqqHx_iMfOiCmMiDhIiDfHiDeGjAkHiMoEjDfPjEhKjHpBiCpAiBeB_xHqqkZx_FCMmPolyBezier_xZkqqHx_iMfO_xHqqkZx_
 *			_xZkqqHx_iCmMiDhIiDfHiDeGjAkHiMoEjDfPjEhKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	:FCMmPolyBezier_xZkqqHx_iMfOjAkHiMoEjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vControls	:FCBezierControlsVector_xZkqqHx_iMfOjAkHiMoEjDfPjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFControlConv (FCMmPolyBezier& polyBezier, const FCBezierControlsVector& vControls)
{
	polyBezier.clear();
	polyBezier.SetIsBezier(TRUE);
	if (vControls.empty()) return;
	polyBezier.push_back(vControls[0].A());
	for (long lC = 0; lC != vControls.size(); lC++)
	{
		polyBezier.push_back(vControls[lC].B());
		polyBezier.push_back(vControls[lC].C());
		polyBezier.push_back(vControls[lC].D());
	}
} // FFControlConv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFControlConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCMmPolyBezier_xZkqqHx_iMfOiCmMiDhIiDfHiDeGjAkHiMoEjDfPjEhKjHpBiCpAiBeB_xHqqkZx_FCBezierControlsVector_xZkqqHx_iMfO_xHqqkZx_
 *			_xZkqqHx_iCmMiDhIiDfHiDeGjAkHiMoEjDfPjEhKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vControls	:FCBezierControlsVector_xZkqqHx_iMfOjAkHiMoEjDfPjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			polyBezier	:FCMmPolyBezier_xZkqqHx_iMfOjAkHiMoEjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFControlConv (FCBezierControlsVector& vControls, const FCMmPolyBezier& polyBezier)
{
	ASSERT(polyBezier.GetIsBezier());
	vControls.clear();
	if (polyBezier.empty()) return;
	for (long lC = 0; lC != polyBezier.size() - 1; lC += 3)
	{
		vControls.push_back(FCBezierControls(polyBezier[lC],
											 polyBezier[lC+1],
											 polyBezier[lC+2],
											 polyBezier[lC+3]));
	}
} // FFControlConv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetWideWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiImKjChFiCmMjBnBiCmMjFjNiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iFromVal	:_xZkqqHx_jFjNiMhGiOfKiCmJiOgHiCkEiJhOiMmKiCmM_xHqqkZx_x_xZkqqHx_jCgMiCmMiKeKiOgOiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
 *			iUntilVal	:_xZkqqHx_jFjNiMhGiOfKiCmJiOgHiCkEiJhOiMmKiCmM_xHqqkZx_x_xZkqqHx_jCgMiCmMiPeJjHlJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_[0, 10000]_xZkqqHx_iBeC_xHqqkZx_
 *			dN			:_xZkqqHx_jFjNiMhGiOfKiCpAiNhDiCkEiDhMiDiKiDfDiDjDiCmMiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_[0.0, 1.0]_xZkqqHx_iBeC_xHqqkZx_
 *			mmWF		:_xZkqqHx_iDhMiDiKiDfDiDjDiCmMiNmFiPiJiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmWB		:_xZkqqHx_iDhMiDiKiDfDiDjDiCmMiNmFiMoDiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBnBiCmMjFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBnBiCmMjFjNiCmMjFmPiJlLiCmNiBeBiJhOiCmMiMmKiCmMiLmIjApMiBgJ_xHqqkZx_y = 1 - _xZkqqHx_iBoD_xHqqkZx_(1-x^2)_xZkqqHx_iBgKiCmJiDhNiDgCiDhGiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHfMiCnPiBeB_xHqqkZx_x = [0,1]_xZkqqHx_iCmGiClFiCmE_xHqqkZx_ 1/10000 _xZkqqHx_iClIiCmC_xHqqkZx_ x_xZkqqHx_iCpAjFmPiJlLiClDiClJiClNiCmGiCkLiCmM_xHqqkZx_ y _xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_jEhKjHpB_xHqqkZx_ s_vmmWidth_xZkqqHx_iCmJjFnLjBlGiBeCiClBiCmMjCgMiCpAiOgHiCmBiCmEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			[iFromVal,iUntilVal]_xZkqqHx_iCmNiBeBiClBiCmM_xHqqkZx_10001_xZkqqHx_iMmCiCmMjEhKjHpBiCmMiCkEiClPiBeBiMhGiOfKiCmJiOgHjHhAiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iNmFiPiJiCmGiNmFiMoDiCpAiOhHjCoIiBeCjBkGiClPiBeB_xHqqkZx_mmWF _xZkqqHx_iCmJ_xHqqkZx_ s_vmmWidth[iFromVal] _xZkqqHx_iCkKiBeB_xHqqkZx_
 *			mmWB _xZkqqHx_iCmJ_xHqqkZx_ s_vmmWidth[iUntilVal]] _xZkqqHx_iCkKiDhNiDgCiDhGiClDiCoKiCoJiBeC_xHqqkZx_
 *			dN_xZkqqHx_iCmNiBeB_xHqqkZx_[0,1]_xZkqqHx_iCmMiKnEiCmFiBeBjBnBiCnBiCmMjFjNiCpAiMhGiOfKiClHiCoJiClNiCnPiCmMiImKjChFiCpAiOkGiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jBkGiClP_xHqqkZx_ dN = 0 _xZkqqHx_iCmMiOjOiBeBiImKjChFiCmNiDhMiDiKiDfDiDjDiCmMiNmFiPiJiBgJjBnBiCnBiCmMjFjNiCmN_xHqqkZx_mmWF_xZkqqHx_iBgKiCmFiCkAiCoIiBeB_xHqqkZx_
 *			dN = 1_xZkqqHx_iCmMiOjO_xHqqkZx_ _xZkqqHx_iBeBiImKjChFiCmNiDhMiDiKiDfDiDjDiCmMiNmFiMoDiBgJjBnBiCnBiCmMjFjNiCmN_xHqqkZx_mmWB_xZkqqHx_iBgKiCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FFGetWideWidth (int iFromVal, int iUntilVal, double dN, mmetol mmWF, mmetol mmWB)
{
	static mmetolVector s_vmmWidth;
	if (s_vmmWidth.empty())
	{
		s_vmmWidth.reserve(10001);
		for (long lC = 0; lC <= 10000; lC++)
		{
			double dX = double(lC) / 10000.0;
			s_vmmWidth.push_back(1.0 - sqrt(1.0 - dX * dX));
		}
	}
	if (iFromVal == iUntilVal)
	{
		return mmWF + (mmWB - mmWF) * dN;
	}
	// w(x) = [WF -> WB];
	// k(x) = [s_vmmWidth[iFromVal] -> s_vmmWidth[iUntilVal]];
	// k -> w : w(x) = a * k(x) + b
	mmetol mmWDiff = mmWB - mmWF;
	mmetol mmADiff = s_vmmWidth[iUntilVal] - s_vmmWidth[iFromVal];
	// iFromVal != iUntilVal_xZkqqHx_iCmIiCmMiCmFiBeB_xHqqkZx_mmADiff != 0.0_xZkqqHx_iBeC_xHqqkZx_
	double dRA = mmWDiff / mmADiff;
	double dRB = mmWF - dRA * s_vmmWidth[iFromVal];
	double dVal = double(iFromVal) + double(iUntilVal - iFromVal) * dN;
	double dInt;
	double dMod = modf(dVal, &dInt);
	if (almost0(dMod))
	{
		return dRA * s_vmmWidth[long(dInt)] + dRB;
	} else
	{
		mmetol mmW0 = dRA * s_vmmWidth[long(dInt)] + dRB;
		mmetol mmW1 = dRA * s_vmmWidth[long(dInt) + 1] + dRB;
		return mmW0 + (mmW1 - mmW0) * dMod;
	}
} // FFGetWideWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcWideWidthArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBnBjFjNiCmMiMfIiOmOiPoOjFpBiCkJiCoHiBeBjBnBjFjNiCmMjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmW		:_xZkqqHx_jBnBjFjNiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vmmptPoly	:_xZkqqHx_jAgDjApMiDhMiDiKiDfDiDjDiCpAiOhHjCoIiBeCiMfIiOmOjFmPiJlLjHkGiCkKiCkAiCoJiPoKiNiHiBeBjClHiCkC_xHqqkZx_
 *						 _xZkqqHx_jClMjApMiCmNiNnHiCkJiCkCiDhMiDiKiDfDiDjDiCmJjFkKiKiEiClDiCoKiCmEjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmWF		:_xZkqqHx_iKeKiOgOjDfPiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmWB		:_xZkqqHx_iPeJjHlJjDfPiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iFromVal	:_xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOjCgMiCpAiOhHjCoIiBeC_xHqqkZx_[0,10000]_xZkqqHx_iBeC_xHqqkZx_
 *			iUntilVal	:_xZkqqHx_iKeKiOgOjDfPiCmMiMfIiOmOjCgMiCpAiOhHjCoIiBeC_xHqqkZx_[0,10000]_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCalcWideWidthArray (	mmetolVector& vmmW,
							DBLPointVector& vmmptPoly,
							BYTEVector& vIsJoint,
							mmetol mmElemLen,
							mmetol mmWF, mmetol mmWB,
							int iFromVal, int iUntilVal)
{
	// mmElemLen == 0 _xZkqqHx_iCmFiCmNjDkOiNoMiClFiCmIiCkCiBeC_xHqqkZx_
	ASSERT(aboutless(0, mmElemLen));
	// vmmW_xZkqqHx_iCmMiPiAjEpFiCpAiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	vmmW.clear();
	vmmW.reserve(vmmptPoly.size());
	if (almosteq(mmWF, mmWB))
	//----- _xZkqqHx_iKeKiOgOiCmMjFjNiCmGiPeJjHlJiCmMjFjNiCkKjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFjNiCmMjFmPiJlLjHkGiCmNiOhHjCoIjFhDjHhGiBeC_xHqqkZx_
		DBLPointVector::const_iterator iDp;
		for (iDp = vmmptPoly.begin(); iDp != vmmptPoly.end(); iDp++)
			vmmW.push_back(mmWF);
	} else
	if (iFromVal == iUntilVal)
	//----- _xZkqqHx_jFjNiCmMjFmPiJlLiCkKiIoKiOjPiKnGjAjEiCmJiDhNiDgCiDhGiClDiCoKiCoJiPoKiNiH_xHqqkZx_ -----
	{
		vmmW.push_back(0.0);
		DBLPointVector::const_iterator iDp;
		for (iDp = vmmptPoly.begin() + 1; iDp != vmmptPoly.end(); iDp++)
		{
			mmetol mmDiff = (*iDp - *(iDp - 1)).Len();
			vmmW.push_back(vmmW.back() + mmDiff);
		}
		mmetolVector::iterator iRl;
		for (iRl = vmmW.begin(); iRl != vmmW.end(); iRl++)
			*iRl = FFGetWideWidth(iFromVal, iUntilVal, *iRl / vmmW.back(), mmWF, mmWB);
	} else
	//----- _xZkqqHx_jFjNiCmMjFmPiJlLiCkKiJhOiMmKiKnGjAjEiCmJiDhNiDgCiDhGiClDiCoKiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// ElemLen_xZkqqHx_iCmM_xHqqkZx_4_xZkqqHx_jEhLiCpAiBeBiNmFjClHiCmMiDhMiDiKiDfDiDjDiLjHjHkDiCmGiClHiCoJiBeCiClNiClOiClFiBeBjFjNiCmMjFmPiJlLjHkGiCkK_xHqqkZx_
		// _xZkqqHx_iJhOiMmKiKnGjAjEiCmJiDhNiDgCiDhGiClDiCoKiCoJiPoKiNiHiBeCiCfAiOjPiKnGjAjEiCmMiPoKiNiHiCmNiDhMiDiKiDfDiDjDiLjHjHkDiCmNjClHiCkNiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
		mmetol mmElemMin = mmElemLen * 4.0;
		DBLPointVector vmmptPolyOrig = vmmptPoly;
		BYTEVector vIsJointOrig = vIsJoint;

		vmmptPoly.clear();
		vmmptPoly.push_back(vmmptPolyOrig[0]);

		vIsJoint.clear();
		vIsJoint.push_back(vIsJointOrig[0]);

		vmmW.push_back(0.0);
		for (long lC = 1; lC < vmmptPolyOrig.size(); lC++)
		{
			const mmetol mmWPrev = vmmW.back();
			mmetol mmDistance = (vmmptPolyOrig[lC] - vmmptPolyOrig[lC-1]).Len();
			if (mmElemMin < mmDistance)
			{
				long lDiv = long(mmDistance / mmElemMin) + 1;
				for (long lCC = 1; lCC < lDiv; lCC++)
				{
					vmmptPoly.push_back(vmmptPolyOrig[lC-1] +
										(vmmptPolyOrig[lC] - vmmptPolyOrig[lC-1]) * (double(lCC) / double(lDiv)));
					vIsJoint.push_back(FALSE);
					vmmW.push_back(mmWPrev + mmDistance * (double(lCC) / double(lDiv)));
				}
			}
			vmmptPoly.push_back(vmmptPolyOrig[lC]);
			vIsJoint.push_back(vIsJointOrig[lC]);
			vmmW.push_back(mmWPrev + mmDistance);
		}
		mmetolVector::iterator iRl;
		for (iRl = vmmW.begin(); iRl != vmmW.end(); iRl++)
			*iRl = FFGetWideWidth(iFromVal, iUntilVal, *iRl / vmmW.back(), mmWF, mmWB);
	}
} // FFCalcWideWidthArray.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcBCFromADLMP2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCgAiCgBiCmGiCgDiCgCiCmMiKhAjDhIiCkKiKpJjCgNiCmMiPoKiNiHiCmJiBeBiCfBiCmCiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jAkHiMoEjDfPiCgBiBeBiCgCiCmMjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptB		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptC		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgCiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptA		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptD		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptL		:_xZkqqHx_iCgAiCgBiCmMiDhIiDeOiDfOiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptM		:_xZkqqHx_iCgDiCgCiCmMiDhIiDeOiDfOiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP1		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCfAiCpAiOhHjCoIiBeC_xHqqkZx_P0->Pn_xZkqqHx_iCmM_xHqqkZx_1/3_xZkqqHx_iCkNiCoHiCkCiCpA_xHqqkZx_
 *						 _xZkqqHx_jBeJiCnEiClBiCmGiBeC_xHqqkZx_
 *			mmptP2		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCfBiCpAiOhHjCoIiBeC_xHqqkZx_P0->Pn_xZkqqHx_iCmM_xHqqkZx_2/3_xZkqqHx_iCkNiCoHiCkCiCpA_xHqqkZx_
 *						 _xZkqqHx_jBeJiCnEiClBiCmGiBeC_xHqqkZx_
 *			dRP1		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCfAiCmJiCkIiCkPiCoJiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_[-_xZkqqHx_iDmO_xHqqkZx_,_xZkqqHx_iDmO_xHqqkZx_]
 *			dRP2		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCfBiCmJiCkIiCkPiCoJiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_[-_xZkqqHx_iDmO_xHqqkZx_,_xZkqqHx_iDmO_xHqqkZx_]
 *			dAnglePlay	:dRP1_xZkqqHx_iBeF_xHqqkZx_dRP2_xZkqqHx_iCmGiBeBiLnPiOjHiOkOiCmFjDlOiCoHiCoKiCoJiKhAjDhIiCmMiNlHjFkKiCmMiLjGjHgFjEmNiImNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAkHiMoEjDfPiCgBiBeBiCgCiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *                  P1
 *                  _xZkqqHx_iBkF_xHqqkZx_
 *               _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *               _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfPiBkD_xHqqkZx_P0
 *            _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *              _xZkqqHx_iEkA_xHqqkZx_               
 *               _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBkF_xHqqkZx_Pn
 *               _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                  _xZkqqHx_iBkD_xHqqkZx_
 *                  P2
 *
 *			_xZkqqHx_iClBiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmNiBeBjBoFiOeHjEgDiCmJiMlOiCkEiCmGiImIiJlKiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiCgAiCgBiCmGiCgDiCgCiCmMiKhAjDhIiCkKiKpJjCgNiCmGiClFiCmEjAkHjGpBiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEiDhMiDiKiDiJiDeDiDjDiPoDiCmMjDpBiCmCiCmMjDfP_xHqqkZx_(P1_xZkqqHx_iBeB_xHqqkZx_P2)_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiCoJiCoGiCkEiCmI_xHqqkZx_
 *				_xZkqqHx_iCgAiCgBiCmMjClHiClDiCmGiCgDiCgCiCmMjClHiClDiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iCmCiCnMiCoIiBeBiOgOjDfP_xHqqkZx_P0_xZkqqHx_iCmGiPeJjDfP_xHqqkZx_Pn_xZkqqHx_iCmMiKhAjDhIiBeBjBkGiClPiCgAiCgBiCmGiCgDiCgCiCmMiKhAjDhIiCmNiKpJjCgNiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiOkOiCmNiImIiJlKiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3 _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAiBeBjApMjFkK_xHqqkZx_AB=L*u_xZkqqHx_iCmGjApMjFkK_xHqqkZx_DC=M*v(L,M_xZkqqHx_iCmNjClHiClD_xHqqkZx_1)_xZkqqHx_iCmFjFfMiClHiCmG_xHqqkZx_
 *			B=A+L*u
 *			C=D+M*v
 *			_xZkqqHx_iClBiCoKiCpAiHeAiCmJjBoDjDpMiClFiCmEjDfHiKeKiBeBiNfIiCmJ_xHqqkZx_xy_xZkqqHx_jFpLiMpMiCmJjFkKiJpAiClFiCmEiJpAiCkCiCmEiCkCiCkNiCmG_xHqqkZx_
 *			t^3*(-2*Ax/Lx + 2*Dx/Lx + 2*Ay/Ly - 2*Dy/Ly + 3/Lx*Mx*v - 3/Ly*My*v) +
 *			  t^2*(3*Ax/Lx - 3*Dx/Lx - 3*Ay/Ly + 3*Dy/Ly - 3/Lx*Mx*v + 3/Ly*My*v) +
 *			    (-Ax/Lx + Ay/Ly + 1/Lx*Px - 1/Ly*Py) = 0 _xZkqqHx_iBeFiBeFiBeFiHeE_xHqqkZx_
 *			v_xZkqqHx_iCmMjCgMiCpAjDeLjDjGiCmJiMiIiCnPiCmEiBeBiHeEiCpA_xHqqkZx_t_xZkqqHx_iCmJiKnGiClFiCmEiJpAiCkNiBeCiClLiCmM_xHqqkZx_t_xZkqqHx_iCmMjCgMiCpAiHeBiCmJjBoDjDpMiClFiCmE_xHqqkZx_ u _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			v_xZkqqHx_iCmMjCgMiCpAiInKjDkOiClDiClJiCmEiBeBiClLiCmMjDhDjDhI_xHqqkZx_ u _xZkqqHx_iCpAiMhGiOfKiClHiCoJiClBiCmGiCmFiBeBjAiFjFlN_xHqqkZx_u_xZkqqHx_iOlCiBeBjAiCjClM_xHqqkZx_v_xZkqqHx_iOlCiCmM_xHqqkZx_
 *			_xZkqqHx_iDePiDiJiDhEiCpAiNoMjAkMiPgPjHiIiCoJiBeC_xHqqkZx_
 *			P1_xZkqqHx_iBeB_xHqqkZx_P2_xZkqqHx_iCmJiKnGiClFiCmEiBeB_xHqqkZx_u_xZkqqHx_iOlCiCmG_xHqqkZx_v_xZkqqHx_iOlCiCmMiDePiDiJiDhEiCpAiNoMjAkMiClFiBeBiMpAiNlHiClHiCoJjDfP_xHqqkZx_T_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDfP_xHqqkZx_T_xZkqqHx_iCmM_xHqqkZx_u_xZkqqHx_iBeF_xHqqkZx_v_xZkqqHx_iCkKiBeB_xHqqkZx_P1_xZkqqHx_iBeF_xHqqkZx_P2_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiCoJiDhIiDfHiDeGiLmIjApMiCpAjGjOiClNiClH_xHqqkZx_B_xZkqqHx_iBeF_xHqqkZx_C_xZkqqHx_iCmMiMfHjAjEiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCalcBCFromADLMP2 (DBLPoint& mmptB,
						DBLPoint& mmptC,
						const DBLPoint& mmptA,
						const DBLPoint& mmptD,
						DBLPoint mmptL,
						DBLPoint mmptM,
						const DBLPoint& mmptP1,
						const DBLPoint& mmptP2,
						double dRP1,
						double dRP2,
						double dAnglePlay)
{
	struct sub {
		static mmetol GetV (mmetol mmFailV,
							mmetol mmSucceedV,
							const DBLPoint& mmptA,
							const DBLPoint& mmptD,
							const DBLPoint& mmptL,
							const DBLPoint& mmptM,
							const DBLPoint& mmptP,
							mmetol mmMaxLen,
							double dRP,
							double dAnglePlay)
		{
			for (long lM = 0; lM != 10; lM++)
			{
				mmetol mmTestV = (mmFailV + mmSucceedV) / 2.0;
				BOOL bSucceed = FALSE;
				mmetol mmU;
				double dT;
				// v_xZkqqHx_iCmJjBmOiClHiCoJ_xHqqkZx_u_xZkqqHx_iCmMjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
				if (FFCalcUFromVADLMP(mmU, dT, mmTestV, mmptA, mmptD, mmptL, mmptM, mmptP) && mmU < mmMaxLen)
				//----- v_xZkqqHx_iCmJjBmOiClHiCoJ_xHqqkZx_u_xZkqqHx_iCkKiOfKiPgPiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
				{
					// v,u_xZkqqHx_iCmMjCgMiCmFiCmM_xHqqkZx_ t _xZkqqHx_iCmJiCkIiCkPiCoJiKhAjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
					double dRz = FFCalcBezierAngle(FCBezierControls(mmptA, mmptA + mmptL * mmU, mmptD + mmptM * mmTestV, mmptD), dT);
					// dRP1_xZkqqHx_iCmGiBeBiLnPiOjHiOkOiCmFjDlOiCoHiCoKiCoJiKhAjDhIiCmMiNlHjFkKiCkKiLjGjHgFjEmNiImNiImIjDoAiCmIiCoH_xHqqkZx_GOOD_xZkqqHx_iBeC_xHqqkZx_
					if (fabs(FFAngleMinusPitoPi(dRP - dRz)) < dAnglePlay) bSucceed = TRUE;
				}
				if (bSucceed)
					mmSucceedV = mmTestV;
				else
					mmFailV = mmTestV;
			}
			return (mmSucceedV + mmFailV) / 2.0;
		}

		static BOOL GetMinMaxV (mmetol& mmMinV,
								mmetol& mmMaxV,
								const DBLPoint& mmptA,
								const DBLPoint& mmptD,
								const DBLPoint& mmptL,
								const DBLPoint& mmptM,
								const DBLPoint& mmptP,
								mmetol mmUnitLen,
								mmetol mmMaxLen,
								double dRP,
								double dAnglePlay)
		{
			//----- _xZkqqHx_iCnMiClIiBeB_xHqqkZx_v_xZkqqHx_iCmMjCgMiCpAjFmPiJlLiClDiClJiCmEiBeBiClLiCoKiCmJjBmOiClHiCoJ_xHqqkZx_u_xZkqqHx_iCmMjCgMiCpAiOfKiPgP_xHqqkZx_ -----
			long lC;
			for (lC = 0;; lC++)
			{
				// v_xZkqqHx_iCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
				mmetol mmV = mmUnitLen * double(lC);
				if (mmMaxLen <= mmV) return FALSE;
				mmetol mmU;
				double dT;
				// v_xZkqqHx_iCmJjBmOiClHiCoJ_xHqqkZx_u_xZkqqHx_iCmMjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
				if (FFCalcUFromVADLMP(mmU, dT, mmV, mmptA, mmptD, mmptL, mmptM, mmptP) && mmU < mmMaxLen)
				//----- v_xZkqqHx_iCmJjBmOiClHiCoJ_xHqqkZx_u_xZkqqHx_iCkKiOfKiPgPiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
				{
					// v,u_xZkqqHx_iCmMjCgMiCmFiCmM_xHqqkZx_ t _xZkqqHx_iCmJiCkIiCkPiCoJiKhAjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
					double dRz = FFCalcBezierAngle(FCBezierControls(mmptA, mmptA + mmptL * mmU, mmptD + mmptM * mmV, mmptD), dT);
					// dRP_xZkqqHx_iCmGiBeBiLnPiOjHiOkOiCmFjDlOiCoHiCoKiCoJiKhAjDhIiCmMiNlHjFkKiCkKiLjGjHgFjEmNiImNiImIjDoAiCmIiCoHiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
					if (fabs(FFAngleMinusPitoPi(dRP - dRz)) < dAnglePlay) break;
				}
			}
			if (lC == 0)
			{
				mmMinV = 0.0;
			} else
			{
				mmetol mmFailV = mmUnitLen * double(lC - 1);
				mmetol mmSucceedV = mmUnitLen * double(lC);
				mmMinV = GetV(mmFailV, mmSucceedV, mmptA, mmptD, mmptL, mmptM, mmptP, mmMaxLen, dRP, dAnglePlay);
			}

			for (lC++;; lC++)
			{
				// v_xZkqqHx_iCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
				mmetol mmV = mmUnitLen * double(lC);
				if (mmMaxLen <= mmV) break;
				mmetol mmU;
				double dT;
				// v_xZkqqHx_iCmJjBmOiClHiCoJ_xHqqkZx_u_xZkqqHx_iCmMjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
				if (!FFCalcUFromVADLMP(mmU, dT, mmV, mmptA, mmptD, mmptL, mmptM, mmptP) || mmMaxLen <= mmU)
					break;
				// v,u_xZkqqHx_iCmMjCgMiCmFiCmM_xHqqkZx_ t _xZkqqHx_iCmJiCkIiCkPiCoJiKhAjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
				double dRz = FFCalcBezierAngle(FCBezierControls(mmptA, mmptA + mmptL * mmU, mmptD + mmptM * mmV, mmptD), dT);
				// dRP_xZkqqHx_iCmGiBeBiLnPiOjHiOkOiCmFjDlOiCoHiCoKiCoJiKhAjDhIiCmMiNlHjFkKiCkKiLjGjHgFjEmNiImNiKePiCmIiCoHiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
				if (dAnglePlay <= fabs(FFAngleMinusPitoPi(dRP - dRz))) break;
			}
			mmetol mmSucceedV = mmUnitLen * double(lC - 1);
			mmetol mmFailV = mmUnitLen * double(lC);
			mmMaxV = GetV(mmFailV, mmSucceedV, mmptA, mmptD, mmptL, mmptM, mmptP, mmMaxLen, dRP, dAnglePlay);
			return TRUE;
		}
	};

	// L,M_xZkqqHx_iCpAjCfAiImKjClH_xHqqkZx_(1mm)_xZkqqHx_iCmJjFoCjAlDiBeC_xHqqkZx_
	mmptL /= mmptL.Len();
	mmptM /= mmptM.Len();

	// P0-P1-P2-Pn_xZkqqHx_iCmMjClHiClDiCkJiCoHiBeB_xHqqkZx_u,v_xZkqqHx_iCmMiMhGiOfKjEmNiImNiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const mmetol mmMaxLen = ((mmptA - mmptP1).Len() + (mmptD - mmptP2).Len() + (mmptP1 - mmptP2).Len()) * 10.0;
	const mmetol mmUnitLen = mmMaxLen / 40.0;
	// P1_xZkqqHx_iCpAjCmKiClHiPoKiNiHiCmM_xHqqkZx_V_xZkqqHx_iCmMjEmNiImN_xHqqkZx_(MinV1, MaxV1)_xZkqqHx_iCmG_xHqqkZx_P2_xZkqqHx_iCpAjCmKiClHiPoKiNiHiCmM_xHqqkZx_V_xZkqqHx_iCmMjEmNiImN_xHqqkZx_(MinV2, MaxV2)_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
	mmetol mmMinV1;
	mmetol mmMaxV1;
	if (!sub::GetMinMaxV(mmMinV1, mmMaxV1, mmptA, mmptD, mmptL, mmptM, mmptP1, mmUnitLen, mmMaxLen, dRP1, dAnglePlay))
		return FALSE;
	mmetol mmMinV2;
	mmetol mmMaxV2;
	if (!sub::GetMinMaxV(mmMinV2, mmMaxV2, mmptA, mmptD, mmptL, mmptM, mmptP2, mmUnitLen, mmMaxLen, dRP2, dAnglePlay))
		return FALSE;
	// V_xZkqqHx_iCmMiNmFiPkMjCgMiBeBiNmFjBoFjCgMiBeC_xHqqkZx_
	const mmetol mmMinV = (mmMinV1 < mmMinV2) ? mmMinV2 : mmMinV1;
	const mmetol mmMaxV = (mmMaxV1 < mmMaxV2) ? mmMaxV1 : mmMaxV2;

	mmetol mmUDiffMin = DBL_MAX;
	mmetol mmGoodU;
	mmetol mmGoodV;

	DBLPointVector vmmptLine0;
	DBLPointVector vmmptLine1;
	BOOL bStarted = FALSE;
	mmetol mmMinU = DBL_MAX;
	mmetol mmMaxU = -DBL_MAX;
	const mmetol mmIncV = (mmMaxV - mmMinV) / 50.0;
	//----- _xZkqqHx_iCnMiClIiBeB_xHqqkZx_v_xZkqqHx_iCmMjCgMiCpAjFmPiJlLiClDiClJiCmEiBeBiClLiCoKiCmJjBmOiClHiCoJ_xHqqkZx_u_xZkqqHx_iCmMjCgMiCpAiOfKiPgP_xHqqkZx_ -----
	long lC;
	for (lC = 0; lC != 50; lC++)
	{
		// v_xZkqqHx_iCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
		mmetol mmNextV = mmMinV + mmIncV * double(lC);
		mmetol mmPrevV;
		mmetol mmNextU1;
		mmetol mmNextU2;
		mmetol mmPrevU1;
		mmetol mmPrevU2;
		double dT1;
		double dT2;
		BOOL bSucceed = FALSE;
		// v_xZkqqHx_iCmJjBmOiClHiCoJ_xHqqkZx_u_xZkqqHx_iCmMjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
		if (FFCalcUFromVADLMP(mmNextU1, dT1, mmNextV, mmptA, mmptD, mmptL, mmptM, mmptP1) &&
			FFCalcUFromVADLMP(mmNextU2, dT2, mmNextV, mmptA, mmptD, mmptL, mmptM, mmptP2))
		//----- u_xZkqqHx_iCkKiOfKiPgPiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
		{
			// v,u_xZkqqHx_iCmMjCgMiCmFiCmM_xHqqkZx_ t1 _xZkqqHx_iCmJiCkIiCkPiCoJiKhAjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
			double dRz1 = FFCalcBezierAngle(FCBezierControls(mmptA, mmptA + mmptL * mmNextU1, mmptD + mmptM * mmNextV, mmptD), dT1);
			// v,u_xZkqqHx_iCmMjCgMiCmFiCmM_xHqqkZx_ t2 _xZkqqHx_iCmJiCkIiCkPiCoJiKhAjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
			double dRz2 = FFCalcBezierAngle(FCBezierControls(mmptA, mmptA + mmptL * mmNextU2, mmptD + mmptM * mmNextV, mmptD), dT2);
			// dRP1,dRP2_xZkqqHx_iCmGiBeBiLnPiOjHiOkOiCmFjDlOiCoHiCoKiCoJiKhAjDhIiCmMiNlHjFkKiCkKiLjGjHgFjEmNiImNiImIjDoAiCmIiCoHiOfKiPgPjAkMiMpHiBeC_xHqqkZx_
			if (fabs(FFAngleMinusPitoPi(dRP1 - dRz1)) < dAnglePlay &&
				fabs(FFAngleMinusPitoPi(dRP2 - dRz2)) < dAnglePlay)
				bSucceed = TRUE;
		}
		if (bSucceed)
		//----- u_xZkqqHx_iCkKiOfKiPgPiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
		{
			if (almosteq(mmNextU1, mmNextU2))
			//----- U_xZkqqHx_iCmMjCgMiCkKiCnJiCnKjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
			{
				mmptB = mmptA + mmptL * mmNextU1;
				mmptC = mmptD + mmptM * mmNextV;
				return TRUE;
			}
			if (fabs(mmNextU1 - mmNextU2) < mmUDiffMin)
			//----- U1_xZkqqHx_iCmG_xHqqkZx_U2_xZkqqHx_iCmMiNlHiCkKiPkNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				mmUDiffMin = fabs(mmNextU1 - mmNextU2);
				mmGoodU = (mmNextU1 + mmNextU2) / 2.0;
				mmGoodV = mmNextV;
			}

			if (bStarted)
			//----- _xZkqqHx_iCfBiJpBjGnKiImIiNhOiCmM_xHqqkZx_u_xZkqqHx_iCkKiOfKiPgPiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
			{
				//                                          _xZkqqHx_iBfBiBfB_xHqqkZx_ NextU2
				//                                      _xZkqqHx_iBfO_xHqqkZx_    _xZkqqHx_iBkK_xHqqkZx_
				//           PrevU1 _xZkqqHx_iBfBiBfB_xHqqkZx_              _xZkqqHx_iBfO_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
				//                  _xZkqqHx_iBkK_xHqqkZx_    _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
				//                  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
				//       CrossU _xZkqqHx_iBfBiBfBiEkAiBfBiBfBiBfB_xHqqkZx_  _xZkqqHx_iBfPiBfO_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
				//                  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBfOiBfP_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
				//                  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBfO_xHqqkZx_    _xZkqqHx_iBfP_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
				//                  _xZkqqHx_iBkL_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
				//           PrevU2 _xZkqqHx_iBfAiBfA_xHqqkZx_              _xZkqqHx_iBfP_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
				//                       _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBkL_xHqqkZx_
				//                       _xZkqqHx_iEkA_xHqqkZx_                 _xZkqqHx_iBfAiBfA_xHqqkZx_ NextU1
				//                       _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
				//                       _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_
				//                      PrevV           NextV
				//
				if ((mmPrevU1 <= mmPrevU2 && mmNextU2 <= mmNextU1) ||
					(mmPrevU2 <= mmPrevU1 && mmNextU1 <= mmNextU2))
				//----- _xZkqqHx_iMpAiNlHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					DBLPoint mmptCross = DBLLine(DBLPoint(mmPrevV, mmPrevU1), DBLPoint(mmNextV, mmNextU1)) & 
										 DBLLine(DBLPoint(mmPrevV, mmPrevU2), DBLPoint(mmNextV, mmNextU2));
					mmptB = mmptA + mmptL * mmptCross.y;
					mmptC = mmptD + mmptM * mmptCross.x;
					return TRUE;
				}
			}
			// _xZkqqHx_iMhGiOfKiKeKiOgOiDhEiDiJiDePiCpAiCgOiCgNiBeC_xHqqkZx_u_xZkqqHx_iCkKiOfKiPgPiCmFiCkLiCoJjEmNiImNiCmM_xHqqkZx_v_xZkqqHx_iCmN_xHqqkZx_
			// _xZkqqHx_iMmAiCoHiCoKiCmEiCkCiCoJiClNiCnPiBeBiClLiCmMjEmNiImNiCpAjClEiCkGiClNiCoHiMhGiOfKiCpA_xHqqkZx_
			// _xZkqqHx_jCoCiOhOiClHiCoJiClNiCnPiCmMiDhEiDiJiDePiBeC_xHqqkZx_
			bStarted = TRUE;
			mmPrevV = mmNextV;
			mmPrevU1 = mmNextU1;
			mmPrevU2 = mmNextU2;
		} else
		//----- u_xZkqqHx_iCkKiOfKiPgPiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMhGiOfKiKeKiOgOiDhEiDiJiDePiCkKiCgOiCgNiCmMiPoKiNiHiCmNiPiIjHjNiCpAiPeJjHlJiBeC_xHqqkZx_
			if (bStarted) break;
		}
	}
	// _xZkqqHx_iMpAjDfPiCkKiLiBiCnMiCoHiCmIiCkJiCmBiClNiPoKiNiHiBeBiNmFiCoA_xHqqkZx_V1_xZkqqHx_iBeB_xHqqkZx_V2_xZkqqHx_iCkKiLnPjAnKiClHiCoJjCgMiCpAjFnEiClHiBeC_xHqqkZx_
	mmptB = mmptA + mmptL * mmGoodU;
	mmptC = mmptD + mmptM * mmGoodV;
	return TRUE;
} // FFCalcBCFromADLMP2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcUFromVADLMP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFkKiCgDiCgCiCmMjClHiClD_xHqqkZx_v_xZkqqHx_iCmJjBmOiClHiCoJjApMjFkKiCgAiCgBiCmMjClHiClD_xHqqkZx_u_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmU		:_xZkqqHx_iCgAiCgBiCmMiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmV		:_xZkqqHx_iCgDiCgCiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptA	:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptD	:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptL	:_xZkqqHx_iCgAiCgBiCmMiDhIiDeOiDfOiBfLiBgJjCfAiImKjClHiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptM	:_xZkqqHx_iCgDiCgCiCmMiDhIiDeOiDfOiBfLiBgJjCfAiImKjClHiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP	:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	mmU_xZkqqHx_iCkKiLiBiCnPiCoHiCoKiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	U_xZkqqHx_iCmN_xHqqkZx_0_xZkqqHx_iImIiPoDiCmMjCgMiCmMiCnNjHeMiMpIiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jClMjApMiCgAiCgBiCmGiCgDiCgCiCmMiMfIiCkLiCmNiKpJjCgNiCmGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmNjDfPiCgPiCpAjCmKiCoJiCoAiCmMiCmGiClFiBeBjApMjFkKiCgDiCgCiCmMjClHiClD_xHqqkZx_v_xZkqqHx_iCmJjBmOiClHiCoJjApMjFkKiCgAiCgBiCmM_xHqqkZx_
 *			_xZkqqHx_jClHiClD_xHqqkZx_u_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiOkOiCmNiImIiJlKiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3 _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAiBeBjApMjFkK_xHqqkZx_AB=L*u_xZkqqHx_iCmGjApMjFkK_xHqqkZx_DC=M*v(L,M_xZkqqHx_iCmNjClHiClD_xHqqkZx_1)_xZkqqHx_iCmFjFfMiClHiCmG_xHqqkZx_
 *			B=A+L*u
 *			C=D+M*v
 *			_xZkqqHx_iClBiCoKiCpAiHeAiCmJjBoDjDpMiClFiCmE_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * (A+L*u) * (1-t)^2 * t + 3 * (D+M*v) * (1-t) * t^2 + D * t^3
 *			1-t=k_xZkqqHx_iCmGiClFiCmE_xHqqkZx_
 *			P = A * k^3 + 3 * (A+L*u) * k^2 * t + 3 * (D+M*v) * k * t^2 + D * t^3 _xZkqqHx_iBeFiBeFiBeFiHeF_xHqqkZx_
 *			1) Lx != 0, Ly != 0 _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				_xZkqqHx_iHeFiCpA_xHqqkZx_u_xZkqqHx_iCmJiKnGiClFiCmEjDfHiKeK_xHqqkZx_
 *				u = (P - A*k^3 - 3*A*k^2*t - 3*D*k*t^2 - D*t^3 - 3*M*k*t^2*v)/(3*L*k^2*t) _xZkqqHx_iBeFiBeFiBeFiHeB_xHqqkZx_
 *				x,y_xZkqqHx_iCmJiKnGiMfHiClFiCmIiCkCjFmPjAjEiCmNjBfDiCmEiNlGjFnDiCmJiPfHiCnPiCoJ_xHqqkZx_
 *				3*k^2*t*u = (P - A*k^3 - 3*A*k^2*t - 3*D*k*t^2 - D*t^3 - 3*M*k*t^2*v)/L
 *				_xZkqqHx_iClBiCoKiCpA_xHqqkZx_x,y_xZkqqHx_iCmJiKnGiClFiCmEjDfHiKeK_xHqqkZx_
 *				3*k^2*t*u = (Px - Ax*k^3 - 3*Ax*k^2*t - 3*Dx*k*t^2 - Dx*t^3 - 3*Mx*k*t^2*v)/Lx _xZkqqHx_iBeFiBeFiBeFiHeC_xHqqkZx_
 *				3*k^2*t*u = (Py - Ay*k^3 - 3*Ay*k^2*t - 3*Dy*k*t^2 - Dy*t^3 - 3*My*k*t^2*v)/Ly _xZkqqHx_iBeFiBeFiBeFiHeD_xHqqkZx_
 *				_xZkqqHx_iHeCiCmGiHeDiCmMiNlGjFnDiCmNjDkPiClGjCgMiCmIiCmMiCmFiBeB_xHqqkZx_
 *				(Px - Ax*k^3 - 3*Ax*k^2*t - 3*Dx*k*t^2 - Dx*t^3 - 3*Mx*k*t^2*v)/Lx - (Py - Ay*k^3 - 3*Ay*k^2*t - 3*Dy*k*t^2 - Dy*t^3 - 3*My*k*t^2*v)/Ly = 0
 *				_xZkqqHx_iClBiCoKiCpAjDfHiKeKiClFiCmE_xHqqkZx_
 *				t^3*(-2*Ax/Lx + 2*Dx/Lx + 2*Ay/Ly - 2*Dy/Ly + 3/Lx*Mx*v - 3/Ly*My*v) +
 *				  t^2*(3*Ax/Lx - 3*Dx/Lx - 3*Ay/Ly + 3*Dy/Ly - 3/Lx*Mx*v + 3/Ly*My*v) +
 *				    (-Ax/Lx + Ay/Ly + 1/Lx*Px - 1/Ly*Py) = 0 _xZkqqHx_iBeFiBeFiBeFiHeE_xHqqkZx_
 *				v_xZkqqHx_iCmMjCgMiCpAjDeLjDjGiCmJiMiIiCnPiCmEiBeBiHeEiCpA_xHqqkZx_t_xZkqqHx_iCmJiKnGiClFiCmEiJpAiCkNiBeC_xHqqkZx_t_xZkqqHx_iCmMjCgMiCpAiHeBiCmJjBoDjDpMiClFiCmE_xHqqkZx_ u _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			2) Lx == 0, Ly != 0 _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				Lx == 0_xZkqqHx_iCmIiCmMiCmFiBeBiHeFiCkJiCoHiImIiJlKiCmGiCmIiCoJiBeC_xHqqkZx_
 *				Px = Ax * k^3 + 3 * Ax * k^2 * t + 3 * (Dx+Mx*v) * k * t^2 + Dx * t^3
 *				_xZkqqHx_iClBiCoKiCpA_xHqqkZx_ t _xZkqqHx_iCmJiKnGiClFiCmEjDfHiKeKiClFiCmE_xHqqkZx_
 *				t^3*(2*Ax - 2*Dx - 3*Mx*v) +
 *				  t^2*(-3*Ax + 3*Dx + 3*Mx*v) +
 *				    Ax - Px = 0 _xZkqqHx_iBeFiBeFiBeFiHeG_xHqqkZx_
 *				v_xZkqqHx_iCmMjCgMiCpAjDeLjDjGiCmJiMiIiCnPiCmEiBeBiHeGiCpA_xHqqkZx_t_xZkqqHx_iCmJiKnGiClFiCmEiJpAiCkNiBeC_xHqqkZx_t_xZkqqHx_iCmMjCgMiCpAiHeBiCmJjBoDjDpMiClFiCmE_xHqqkZx_ u _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			3) Lx != 0, Ly == 0 _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				Ly == 0_xZkqqHx_iCmIiCmMiCmFiBeBiHeFiCkJiCoHiImIiJlKiCmGiCmIiCoJiBeC_xHqqkZx_
 *				Py = Ay * k^3 + 3 * Ay * k^2 * t + 3 * (Dy+My*v) * k * t^2 + Dy * t^3
 *				_xZkqqHx_iClBiCoKiCpA_xHqqkZx_ t _xZkqqHx_iCmJiKnGiClFiCmEjDfHiKeKiClFiCmE_xHqqkZx_
 *				t^3*(2*Ay - 2*Dy - 3*My*v) +
 *				  t^2*(-3*Ay + 3*Dy + 3*My*v) +
 *				    Ay - Py = 0 _xZkqqHx_iBeFiBeFiBeFiHeH_xHqqkZx_
 *				v_xZkqqHx_iCmMjCgMiCpAjDeLjDjGiCmJiMiIiCnPiCmEiBeBiHeHiCpA_xHqqkZx_t_xZkqqHx_iCmJiKnGiClFiCmEiJpAiCkNiBeC_xHqqkZx_t_xZkqqHx_iCmMjCgMiCpAiHeBiCmJjBoDjDpMiClFiCmE_xHqqkZx_ u _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCalcUFromVADLMP (mmetol& mmU,
						double& dT,
						mmetol mmV,
						const DBLPoint& mmptA,
						const DBLPoint& mmptD,
						const DBLPoint& mmptL,
						const DBLPoint& mmptM,
						const DBLPoint& mmptP)
{
	// _xZkqqHx_iDeKiDiLiDfPiDgNjGeAiCmFiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCCardano cd;
	if (almost0(mmptL.x))
	//----- Lx = 0 _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeKiDiLiDfPiDgNjGeAiCmFiHeGiCmMiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		cd.Set(	2.0*mmptA.x - 2.0*mmptD.x - 3.0*mmptM.x*mmV,
				-3.0*mmptA.x + 3.0*mmptD.x + 3.0*mmptM.x*mmV,
				0.0,
				mmptA.x - mmptP.x);
	} else
	if (almost0(mmptL.y))
	//----- Ly = 0 _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeKiDiLiDfPiDgNjGeAiCmFiHeHiCmMiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		cd.Set(	2.0*mmptA.y - 2.0*mmptD.y - 3.0*mmptM.y*mmV,
				-3.0*mmptA.y + 3.0*mmptD.y + 3.0*mmptM.y*mmV,
				0.0,
				mmptA.y - mmptP.y);
	} else
	//----- Lx != 0, Ly != 0 _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeKiDiLiDfPiDgNjGeAiCmFiHeEiCmMiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		cd.Set(	-2.0*mmptA.x/mmptL.x + 2.0*mmptD.x/mmptL.x + 2.0*mmptA.y/mmptL.y - 2.0*mmptD.y/mmptL.y + 3.0/mmptL.x*mmptM.x*mmV - 3.0/mmptL.y*mmptM.y*mmV,
				3.0*mmptA.x/mmptL.x - 3.0*mmptD.x/mmptL.x - 3.0*mmptA.y/mmptL.y + 3.0*mmptD.y/mmptL.y - 3.0/mmptL.x*mmptM.x*mmV + 3.0/mmptL.y*mmptM.y*mmV,
				0,
				-mmptA.x/mmptL.x + mmptA.y/mmptL.y + mmptP.x/mmptL.x - mmptP.y/mmptL.y);
	}
	const long lCount = cd.Solve();
	mmetol mmUMin = DBL_MAX;
	for (long lC = 0; lC != lCount; lC++)
	//----- _xZkqqHx_iJpAiCpAjClCiCnHiCoJ_xHqqkZx_ -----
	{
		// _xZkqqHx_jHeMiMpIiCmIiCjEiCmMjCgMiCmFiCkAiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		if (almost0(cd.m_cSol[lC].imag()) && 0.0 < cd.m_cSol[lC].real() && cd.m_cSol[lC].real() < 1.0)
		//----- _xZkqqHx_iLjFjAjEjFjEiCkKiCePiCmFiCkAiCoIiBeBiOmAjAjEjFjEiBgJjBkGiClP_xHqqkZx_t_xZkqqHx_iBgKiCkK_xHqqkZx_(0,1)_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// t_xZkqqHx_iCmG_xHqqkZx_k_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			double dTp = cd.m_cSol[lC].real();
			double dKp = 1.0 - dTp;
			// t_xZkqqHx_iCkJiCoH_xHqqkZx_u_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
			mmetol mmUt;
			// Lx = 0 _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ y _xZkqqHx_iCmMjCgMiCkJiCoHiLiBiCnPiCoJiBeC_xHqqkZx_
			if (almost0(mmptL.x))
				mmUt = (mmptP.y - mmptA.y*POW3(dKp) - 3.0*mmptA.y*POW2(dKp)*dTp - 3.0*mmptD.y*dKp*POW2(dTp) - mmptD.y*POW3(dTp) - 3.0*mmptM.y*dKp*POW2(dTp)*mmV)/(3.0*mmptL.y*POW2(dKp)*dTp);
			else
				mmUt = (mmptP.x - mmptA.x*POW3(dKp) - 3.0*mmptA.x*POW2(dKp)*dTp - 3.0*mmptD.x*dKp*POW2(dTp) - mmptD.x*POW3(dTp) - 3.0*mmptM.x*dKp*POW2(dTp)*mmV)/(3.0*mmptL.x*POW2(dKp)*dTp);
//			ASSERT(fabs((mmUx - mmUy) / mmUx) < 0.1);
			// u_xZkqqHx_iCmN_xHqqkZx_0_xZkqqHx_iCoGiCoIjBoFiCkLiCkNiCmIiCkNiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
			// _xZkqqHx_jCgMiCkKiPkMiClDiCkCiCnJiCmHjHmHiCkCiBeC_xHqqkZx_
			if (0.0 < mmUt && mmUt < mmUMin)
			{
				mmUMin = mmUt;
				dT = dTp;
			}
		}
	}
	if (mmUMin != DBL_MAX)
	//---- u_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmU = mmUMin;
		return TRUE;
	}
	return FALSE;
} // FFCalcUFromVADLMP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcVFromUADLMP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFkKiCgAiCgBiCmMjClHiClD_xHqqkZx_u_xZkqqHx_iCmJjBmOiClHiCoJjApMjFkKiCgDiCgCiCmMjClHiClD_xHqqkZx_v_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmV		:_xZkqqHx_iCgDiCgCiCmMiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmU		:_xZkqqHx_iCgAiCgBiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptA	:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptD	:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptL	:_xZkqqHx_iCgAiCgBiCmMiDhIiDeOiDfOiBfLiBgJjCfAiImKjClHiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptM	:_xZkqqHx_iCgDiCgCiCmMiDhIiDeOiDfOiBfLiBgJjCfAiImKjClHiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP	:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	mmV_xZkqqHx_iCkKiLiBiCnPiCoHiCoKiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	V_xZkqqHx_iCmN_xHqqkZx_0_xZkqqHx_iImIiPoDiCmMjCgMiCmMiCnNjHeMiMpIiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jClMjApMiCgAiCgBiCmGiCgDiCgCiCmMiMfIiCkLiCmNiKpJjCgNiCmGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmNjDfPiCgPiCpAjCmKiCoJiCoAiCmMiCmGiClFiBeBjApMjFkKiCgDiCgCiCmMjClHiClD_xHqqkZx_v_xZkqqHx_iCmJjBmOiClHiCoJjApMjFkKiCgAiCgBiCmM_xHqqkZx_
 *			_xZkqqHx_jClHiClD_xHqqkZx_u_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiOkOiCmNiImIiJlKiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3 _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAiBeBjApMjFkK_xHqqkZx_AB=L*u_xZkqqHx_iCmGjApMjFkK_xHqqkZx_DC=M*v(L,M_xZkqqHx_iCmNjClHiClD_xHqqkZx_1)_xZkqqHx_iCmFjFfMiClHiCmG_xHqqkZx_
 *			B=A+L*u
 *			C=D+M*v
 *			_xZkqqHx_iClBiCoKiCpAiHeAiCmJjBoDjDpMiClFiCmE_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * (A+L*u) * (1-t)^2 * t + 3 * (D+M*v) * (1-t) * t^2 + D * t^3
 *			1-t=k_xZkqqHx_iCmGiClFiCmE_xHqqkZx_
 *			P = A * k^3 + 3 * (A+L*u) * k^2 * t + 3 * (D+M*v) * k * t^2 + D * t^3 _xZkqqHx_iBeFiBeFiBeFiHeF_xHqqkZx_
 *			1) Mx != 0, My != 0 _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				_xZkqqHx_iHeFiCpA_xHqqkZx_v_xZkqqHx_iCmJiKnGiClFiCmEjDfHiKeK_xHqqkZx_
 *				v = (P - A*k^3 - 3*A*k^2*t - 3*D*k*t^2 - D*t^3 - 3*L*k^2*t*u)/(3*M*k*t^2) _xZkqqHx_iBeFiBeFiBeFiHeB_xHqqkZx_
 *				x,y_xZkqqHx_iCmJiKnGiMfHiClFiCmIiCkCjFmPjAjEiCmNjBfDiCmEiNlGjFnDiCmJiPfHiCnPiCoJ_xHqqkZx_
 *				3*k*t^2*v = (P - A*k^3 - 3*A*k^2*t - 3*D*k*t^2 - D*t^3 - 3*L*k^2*t*u)/M
 *				_xZkqqHx_iClBiCoKiCpA_xHqqkZx_x,y_xZkqqHx_iCmJiKnGiClFiCmEjDfHiKeK_xHqqkZx_
 *				3*k*t^2*v = (Px - Ax*k^3 - 3*Ax*k^2*t - 3*Dx*k*t^2 - Dx*t^3 - 3*Lx*k^2*t*u)/Mx _xZkqqHx_iBeFiBeFiBeFiHeC_xHqqkZx_
 *				3*k*t^2*v = (Py - Ay*k^3 - 3*Ay*k^2*t - 3*Dy*k*t^2 - Dy*t^3 - 3*Ly*k^2*t*u)/My _xZkqqHx_iBeFiBeFiBeFiHeD_xHqqkZx_
 *				_xZkqqHx_iHeCiCmGiHeDiCmMiNlGjFnDiCmNjDkPiClGiCmIiCmMiCmFiBeB_xHqqkZx_
 *				(Px - Ax*k^3 - 3*Ax*k^2*t - 3*Dx*k*t^2 - Dx*t^3 - 3*Lx*k^2*t*u)/Mx - (Py - Ay*k^3 - 3*Ay*k^2*t - 3*Dy*k*t^2 - Dy*t^3 - 3*Ly*k^2*t*u)/My = 0
 *				_xZkqqHx_iClBiCoKiCpAjDfHiKeKiClFiCmE_xHqqkZx_
 *				t^3*(-2*Ax/Mx + 2*Dx/Mx + 2*Ay/My - 2*Dy/My - 3*Lx/Mx*u + 3*Ly/My*u) +
 *				  t^2*(3*Ax/Mx - 3*Dx/Mx - 3*Ay/My + 3*Dy/My + 6*Lx/Mx*u - 6*Ly/My*u) +
 *				    t*(-3*Lx/Mx*u + 3*Ly/My*u) +
 *				      (-Ax/Mx + Ay/My + Px/Mx - Py/My) = 0 _xZkqqHx_iBeFiBeFiBeFiHeE_xHqqkZx_
 *				u_xZkqqHx_iCmMjCgMiCpAjDeLjDjGiCmJiMiIiCnPiCmEiBeBiHeEiCpA_xHqqkZx_t_xZkqqHx_iCmJiKnGiClFiCmEiJpAiCkNiBeC_xHqqkZx_t_xZkqqHx_iCmMjCgMiCpAiHeBiCmJjBoDjDpMiClFiCmE_xHqqkZx_ v _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			2) Mx == 0, My != 0 _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				Mx == 0_xZkqqHx_iCmIiCmMiCmFiBeBiHeFiCkJiCoHiImIiJlKiCmGiCmIiCoJiBeC_xHqqkZx_
 *				Px = Ax * k^3 + 3 * (Ax+Lx*u) * k^2 * t + 3 * Dx * k * t^2 + Dx * t^3
 *				_xZkqqHx_iClBiCoKiCpA_xHqqkZx_ t _xZkqqHx_iCmJiKnGiClFiCmEjDfHiKeKiClFiCmE_xHqqkZx_
 *				t^3*(2*Ax - 2*Dx + 3*Lx*u) +
 *				  t^2*(-3*Ax + 3*Dx - 6*Lx*u) +
 *				   3*Lx*t*u +
 *				    Ax - Px = 0 _xZkqqHx_iBeFiBeFiBeFiHeG_xHqqkZx_
 *				u_xZkqqHx_iCmMjCgMiCpAjDeLjDjGiCmJiMiIiCnPiCmEiBeBiHeGiCpA_xHqqkZx_t_xZkqqHx_iCmJiKnGiClFiCmEiJpAiCkNiBeC_xHqqkZx_t_xZkqqHx_iCmMjCgMiCpAiHeBiCmJjBoDjDpMiClFiCmE_xHqqkZx_ v _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			3) Mx != 0, My == 0 _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				My == 0_xZkqqHx_iCmIiCmMiCmFiBeBiHeFiCkJiCoHiImIiJlKiCmGiCmIiCoJiBeC_xHqqkZx_
 *				Py = Ay * k^3 + 3 * (Ay+Ly*u) * k^2 * t + 3 * Dy * k * t^2 + Dy * t^3
 *				_xZkqqHx_iClBiCoKiCpA_xHqqkZx_ t _xZkqqHx_iCmJiKnGiClFiCmEjDfHiKeKiClFiCmE_xHqqkZx_
 *				t^3*(2*Ay - 2*Dy + 3*Ly*u) +
 *				  t^2*(-3*Ay + 3*Dy - 6*Ly*u) +
 *				   3*Ly*t*u +
 *				    Ay - Py = 0 _xZkqqHx_iBeFiBeFiBeFiHeH_xHqqkZx_
 *				u_xZkqqHx_iCmMjCgMiCpAjDeLjDjGiCmJiMiIiCnPiCmEiBeBiHeHiCpA_xHqqkZx_t_xZkqqHx_iCmJiKnGiClFiCmEiJpAiCkNiBeC_xHqqkZx_t_xZkqqHx_iCmMjCgMiCpAiHeBiCmJjBoDjDpMiClFiCmE_xHqqkZx_ v _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCalcVFromUADLMP (mmetol& mmV,
						double& dT,
						mmetol mmU,
						DBLPoint mmptA,
						DBLPoint mmptD,
						DBLPoint mmptL,
						DBLPoint mmptM,
						DBLPoint mmptP)
{
	// _xZkqqHx_iDeKiDiLiDfPiDgNjGeAiCmFiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCCardano cd;
	if (almost0(mmptM.x))
	//----- Mx = 0 _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeKiDiLiDfPiDgNjGeAiCmFiHeGiCmMiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		cd.Set(	2.0*mmptA.x - 2.0*mmptD.x + 3.0*mmptL.x*mmU,
				-3.0*mmptA.x + 3.0*mmptD.x - 6.0*mmptL.x*mmU,
				3.0*mmptL.x*mmU,
				mmptA.x - mmptP.x);
	} else
	if (almost0(mmptM.y))
	//----- My = 0 _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeKiDiLiDfPiDgNjGeAiCmFiHeHiCmMiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		cd.Set(	2.0*mmptA.y - 2.0*mmptD.y + 3.0*mmptL.y*mmU,
				-3.0*mmptA.y + 3.0*mmptD.y - 6.0*mmptL.y*mmU,
				3.0*mmptL.y*mmU,
				mmptA.y - mmptP.y);
	} else
	//----- Mx != 0, My != 0 _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeKiDiLiDfPiDgNjGeAiCmFiHeEiCmMiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		cd.Set(	-2.0*mmptA.x/mmptM.x + 2.0*mmptD.x/mmptM.x + 2.0*mmptA.y/mmptM.y - 2.0*mmptD.y/mmptM.y - 3.0*mmptL.x/mmptM.x*mmU + 3.0*mmptL.y/mmptM.y*mmU,
				3.0*mmptA.x/mmptM.x - 3.0*mmptD.x/mmptM.x - 3.0*mmptA.y/mmptM.y + 3.0*mmptD.y/mmptM.y + 6.0*mmptL.x/mmptM.x*mmU - 6.0*mmptL.y/mmptM.y*mmU,
				-3.0*mmptL.x/mmptM.x*mmU + 3.0*mmptL.y/mmptM.y*mmU,
				-mmptA.x/mmptM.x + mmptA.y/mmptM.y + mmptP.x/mmptM.x - mmptP.y/mmptM.y);
	}
	const long lCount = cd.Solve();
	mmetol mmVMin = DBL_MAX;
	for (long lC = 0; lC != lCount; lC++)
	//----- _xZkqqHx_iJpAiCpAjClCiCnHiCoJ_xHqqkZx_ -----
	{
		// _xZkqqHx_jHeMiMpIiCmIiCjEiCmMjCgMiCmFiCkAiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		if (almost0(cd.m_cSol[lC].imag()) && 0.0 < cd.m_cSol[lC].real() && cd.m_cSol[lC].real() < 1.0)
		//----- _xZkqqHx_iLjFjAjEjFjEiCkKiCePiCmFiCkAiCoIiBeBiOmAjAjEjFjEiBgJjBkGiClP_xHqqkZx_t_xZkqqHx_iBgKiCkK_xHqqkZx_(0,1)_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// t_xZkqqHx_iCmG_xHqqkZx_k_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			double dTp = cd.m_cSol[lC].real();
			double dKp = 1.0 - dTp;
			// t_xZkqqHx_iCkJiCoH_xHqqkZx_v_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
			mmetol mmVt;
			// Mx = 0 _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ y _xZkqqHx_iCmMjCgMiCkJiCoHiLiBiCnPiCoJiBeC_xHqqkZx_
			if (almost0(mmptM.x))
				mmVt = (mmptP.y - mmptA.y*POW3(dKp) - 3.0*mmptA.y*POW2(dKp)*dTp - 3.0*mmptD.y*dKp*POW2(dTp) - mmptD.y*POW3(dTp) - 3.0*mmptL.y*POW2(dKp)*dTp*mmU)/(3.0*mmptM.y*dKp*POW2(dTp));
			else
				mmVt = (mmptP.x - mmptA.x*POW3(dKp) - 3.0*mmptA.x*POW2(dKp)*dTp - 3.0*mmptD.x*dKp*POW2(dTp) - mmptD.x*POW3(dTp) - 3.0*mmptL.x*POW2(dKp)*dTp*mmU)/(3.0*mmptM.x*dKp*POW2(dTp));
//			ASSERT(fabs((mmVx - mmVy) / mmVx) < 0.1);
			// v_xZkqqHx_iCmN_xHqqkZx_0_xZkqqHx_iCoGiCoIjBoFiCkLiCkNiCmIiCkNiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
			// _xZkqqHx_jCgMiCkKiPkMiClDiCkCiCnJiCmHjHmHiCkCiBeC_xHqqkZx_
			if (0.0 < mmVt && mmVt < mmVMin)
			{
				mmVMin = mmVt;
				dT = dTp;
			}
		}
	}
	if (mmVMin != DBL_MAX)
	//---- v_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmV = mmVMin;
		return TRUE;
	}
	return FALSE;
} // FFCalcVFromUADLMP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcBFromACDLP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCgAiBeBiCgCiBeBiCgDiBeDiCgAiCgBiCmMiKhAjDhIiCkKiKpJjCgNiCmMiPoKiNiHiCmJiBeBiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jAkHiMoEjDfPiCgBiCmMjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptB		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptA		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptC		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptD		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptL		:_xZkqqHx_iCgAiCgBiCmMiDhIiDeOiDfOiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_Pn_xZkqqHx_iKpBiCoIiBgJ_xHqqkZx_P0->Pn_xZkqqHx_iCmM_xHqqkZx_2/3_xZkqqHx_iCkNiCoHiCkCiBgK_xHqqkZx_
 *						 _xZkqqHx_iCpAjBeJiCnEiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAkHiMoEjDfPiCgBiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *                  P
 *                  _xZkqqHx_iBkF_xHqqkZx_
 *               _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *               _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfPiBkD_xHqqkZx_P0
 *            _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *              _xZkqqHx_iEkA_xHqqkZx_               
 *               _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBkF_xHqqkZx_Pn
 *               _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *
 *
 *			_xZkqqHx_iClBiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmNiBeBjBoFiOeHjEgDiCmJiMlOiCkEiCmGiImIiJlKiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiCgAiCgBiCmMiKhAjDhIiCkKiKpJjCgNiCmGiClFiCmEjAkHjGpBiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEiDhMiDiKiDiJiDeDiDjDiPoDiCmMjDfP_xHqqkZx_(P)_xZkqqHx_iCpAjCmKiCoJiCoGiCkEiCmIiCgAiCgBiCmMjClHiClDiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iCmCiCnMiCoIiBeBiCgAiBeBiCgCiBeBiCgDiBeDiCgAiCgBiCmMiKhAjDhIiCkKiKpJjCgNiCmFiCkAiCoIiBeBjDfPiCgPiCpAjCmKiCoJiClBiCmGiCkKiCoNiCkJiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiOkOiCmNiImIiJlKiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3 _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			B_xZkqqHx_iCpAiBeBjApMjFkK_xHqqkZx_AB=L*u_xZkqqHx_iCmFjFfMiClHiCmG_xHqqkZx_
 *			B=A+L*u
 *			_xZkqqHx_iClBiCoKiCpAiHeAiCmJjBoDjDpMiClHiCoJiBeC_xHqqkZx_
 *			P = A*(1 - t)^3 + 3*C*(1 - t)*t^2 + D*t^3 + 3*t*(A + L*u)*(1 - t)^2
 *			_xZkqqHx_iClBiCoKiCpAjDfHiKeKiClFiBeB_xHqqkZx_u_xZkqqHx_iCmJiKnGiClFiCmEiJpAiCkNiCmG_xHqqkZx_
 *			u = -(A - P - 3*A*t^2 + 3*C*t^2 + 2*A*t^3 - 3*C*t^3 + D*t^3)/(L*3*t*(1 - 2*t + t^2)) _xZkqqHx_iBeFiBeFiBeFiHeB_xHqqkZx_
 *			x,y_xZkqqHx_iCmJiKnGiMfHiCmIiCkCjFmPjAjEiCpAjBfDiCmEiNlGjFnDiCmJiPfHiCnPiCoJiBeC_xHqqkZx_
 *			u*3*t*(1 - 2*t + t^2) = -(A - P - 3*A*t^2 + 3*C*t^2 + 2*A*t^3 - 3*C*t^3 + D*t^3)/L
 *			_xZkqqHx_iClBiCoKiCpA_xHqqkZx_ x,y_xZkqqHx_iCmJiCmCiCkCiCmEjFfMiClHiCmG_xHqqkZx_
 *			u*3*t*(1 - 2*t + t^2) = -(Ax - Px - 3*Ax*t^2 + 3*Cx*t^2 + 2*Ax*t^3 - 3*Cx*t^3 + Dx*t^3)/Lx _xZkqqHx_iBeFiBeFiBeFiHeC_xHqqkZx_
 *			u*3*t*(1 - 2*t + t^2) = -(Ay - Py - 3*Ay*t^2 + 3*Cy*t^2 + 2*Ay*t^3 - 3*Cy*t^3 + Dy*t^3)/Ly _xZkqqHx_iBeFiBeFiBeFiHeD_xHqqkZx_
 *			_xZkqqHx_iHeCiBeBiHeDiCmMiNlGjFnDiCmNjDjJiClFiCkCiCmMiCmF_xHqqkZx_
 *			-(Ax - Px - 3*Ax*t^2 + 3*Cx*t^2 + 2*Ax*t^3 - 3*Cx*t^3 + Dx*t^3)/Lx =
 *				-(Ay - Py - 3*Ay*t^2 + 3*Cy*t^2 + 2*Ay*t^3 - 3*Cy*t^3 + Dy*t^3)/Ly
 *			_xZkqqHx_jFkKjFoKiCmJiCePiCkKiCkAiCoJiCmGiCnMiClIiCkCiCmMiCmFiBeBjHlMjFnDiCmJ_xHqqkZx_Lx*Ly_xZkqqHx_iCpAiCkJiCkPiCoJiBeC_xHqqkZx_
 *			-(Ax - Px - 3*Ax*t^2 + 3*Cx*t^2 + 2*Ax*t^3 - 3*Cx*t^3 + Dx*t^3)*Ly =
 *				-(Ay - Py - 3*Ay*t^2 + 3*Cy*t^2 + 2*Ay*t^3 - 3*Cy*t^3 + Dy*t^3)*Lx
 *			_xZkqqHx_iClBiCoKiCpA_xHqqkZx_ t _xZkqqHx_iCmJiKnGiClFiCmEiCnMiCmGiCnPiCoJiBeC_xHqqkZx_
 *			Ay*Lx - Ax*Ly + Ly*Px - Lx*Py +
 *				(-3*Ay*Lx + 3*Cy*Lx + 3*Ax*Ly - 3*Cx*Ly)*t^2 +
 *					(2*Ay*Lx - 3*Cy*Lx + Dy*Lx - 2*Ax*Ly + 3*Cx*Ly - Dx*Ly)*t^3 = 0
 *			_xZkqqHx_iImIiJlKiCmFjChFiCkLiKlHiCkGiCmEiBeBiOkOiCpAiMkJiCoCiClHiCkNiClHiCoJiBeC_xHqqkZx_
 *			Ay*Lx = E
 *			Ax*Ly = F
 *			Cy*Lx = G
 *			Cx*Ly = H
 *			E - F + Ly*Px - Lx*Py +
 *				3*(-E + G + F - H)*t^2 +
 *					(2*E - 3*G + Dy*Lx - 2*F + 3*H - Dx*Ly)*t^3 = 0
 *			_xZkqqHx_iClBiCoKiCpAiJpAiCkCiCmE_xHqqkZx_ t _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iHeB_xHqqkZx_ _xZkqqHx_iCpAiCnMiCmGiCnPiCoJiBeC_xHqqkZx_
 *			u = -(A - P + (-3*A + 3*C)*t^2 + (2*A - 3*C + D)*t^3)/(L*3*t*(1 - 2*t + t^2)) _xZkqqHx_iBeFiBeFiBeFiHeB_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiOkOiCkJiCoH_xHqqkZx_ u _xZkqqHx_iCpAiLiBiCnPiBeB_xHqqkZx_B_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCalcBFromACDLP (	DBLPoint& mmptB,
						const DBLPoint& mmptA,
						const DBLPoint& mmptC,
						const DBLPoint& mmptD,
						const DBLPoint& mmptL,
						const DBLPoint& mmptP)
{
	const double dE = mmptA.y * mmptL.x;
	const double dF = mmptA.x * mmptL.y;
	const double dG = mmptC.y * mmptL.x;
	const double dH = mmptC.x * mmptL.y;
	// _xZkqqHx_iDeKiDiLiDfPiDgNjGeAiCmFiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCCardano cd;
	cd.Set(	2.0 * dE - 3.0 * dG + mmptD.y * mmptL.x - 2.0 * dF + 3.0 * dH - mmptD.x * mmptL.y,
			3.0 * (-dE + dG + dF - dH),
			0.0,
			dE - dF + mmptL.y * mmptP.x - mmptL.x * mmptP.y);
	if (about0(cd.m_dA) &&
		about0(cd.m_dB) &&
		about0(cd.m_dC) &&
		about0(cd.m_dD))
	//----- _xZkqqHx_iCfDiIpIjAjEiCkKiClHiCnHiCmEiCePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// t_xZkqqHx_iCkKiCmHiCkEiCkCiCkEjCgMiCmFiCkAiCmBiCmEiCoAjHmHiCkCiCmGiCkCiCkEiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iCgAiBeBiCgCiBeBiCgDiBeBiCgLiBeBiCgPiCkKiIoKjClMjApMiCmJjFmAiCnEiPoKiNiHiCmJiLeOiClBiCoJiBeC_xHqqkZx_
		mmptB = mmptA;
		return TRUE;
	}
	const long lCount = cd.Solve();

	mmetol mmUMin = DBL_MAX;
	for (long lC = 0; lC != lCount; lC++)
	//----- _xZkqqHx_iJpAiCpAjClCiCnHiCoJ_xHqqkZx_ -----
	{
		// _xZkqqHx_jHeMiMpIiCmIiCjEiCmMjCgMiCmFiCkAiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		if (figeq(cd.m_cSol[lC].imag(), 0, 5) &&
			0.0 < cd.m_cSol[lC].real() && cd.m_cSol[lC].real() < 1.0)
		//----- _xZkqqHx_iLjFjAjEjFjEiCkKiCePiCmFiCkAiCoIiBeBiOmAjAjEjFjEiBgJjBkGiClP_xHqqkZx_t_xZkqqHx_iBgKiCkK_xHqqkZx_(0,1)_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			double dT = cd.m_cSol[lC].real();
			mmetol mmU;
			if (almost0(mmptL.x))
				mmU = -(mmptA.y - mmptP.y +
						(-3.0 * mmptA.y + 3.0 * mmptC.y) * POW2(dT) +
						(2.0 * mmptA.y - 3.0 * mmptC.y + mmptD.y) * POW3(dT)) / (mmptL.y * 3.0 * dT * (1 - 2.0 * dT + POW2(dT)));
			else
				mmU = -(mmptA.x - mmptP.x +
						(-3.0 * mmptA.x + 3.0 * mmptC.x) * POW2(dT) +
						(2.0 * mmptA.x - 3.0 * mmptC.x + mmptD.x) * POW3(dT)) / (mmptL.x * 3.0 * dT * (1 - 2.0 * dT + POW2(dT)));
			// u_xZkqqHx_iCmN_xHqqkZx_0_xZkqqHx_iCoGiCoIjBoFiCkLiCkNiCmIiCkNiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
			// _xZkqqHx_jCgMiCkKiPkMiClDiCkCiCnJiCmHjHmHiCkCiBeC_xHqqkZx_
			if (0.0 < mmU && mmU < mmUMin)
				mmUMin = mmU;

			DBLPoint mmptP1 = mmptA*POW3(1.0 - dT) + 3*mmptC*(1.0 - dT)*POW2(dT) + mmptD*POW3(dT) + 3.0*dT*(mmptA + mmptL*mmU)*POW2(1.0 - dT);
		}
	}
	if (mmUMin != DBL_MAX)
	//---- v_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmptB = mmptA + mmptL * mmUMin;
		return TRUE;
	}
	return FALSE;
} // FFCalcBFromACDLP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcCFromABDMP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCgAiBeBiCgBiBeBiCgDiBeDiCgDiCgCiCmMiKhAjDhIiCkKiKpJjCgNiCmMiPoKiNiHiCmJiBeBiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jAkHiMoEjDfPiCgCiCmMjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptC		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgCiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptA		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptB		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptD		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptM		:_xZkqqHx_iCgDiCgCiCmMiDhIiDeOiDfOiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_P0_xZkqqHx_iKpBiCoIiBgJ_xHqqkZx_P0->Pn_xZkqqHx_iCmM_xHqqkZx_1/3_xZkqqHx_iCkNiCoHiCkCiBgK_xHqqkZx_
 *						 _xZkqqHx_iCpAjBeJiCnEiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAkHiMoEjDfPiCgCiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *                  P
 *                  _xZkqqHx_iBkF_xHqqkZx_
 *               _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *               _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfPiBkD_xHqqkZx_P0
 *            _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *              _xZkqqHx_iEkA_xHqqkZx_               
 *               _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBkF_xHqqkZx_Pn
 *               _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *
 *
 *			_xZkqqHx_iClBiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmNiBeBjBoFiOeHjEgDiCmJiMlOiCkEiCmGiImIiJlKiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiCgDiCgCiCmMiKhAjDhIiCkKiKpJjCgNiCmGiClFiCmEjAkHjGpBiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEiDhMiDiKiDiJiDeDiDjDiPoDiCmMjDfP_xHqqkZx_(P)_xZkqqHx_iCpAjCmKiCoJiCoGiCkEiCmIiCgDiCgCiCmMjClHiClDiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iCmCiCnMiCoIiBeBiCgAiBeBiCgBiBeBiCgDiBeDiCgDiCgCiCmMiKhAjDhIiCkKiKpJjCgNiCmFiCkAiCoIiBeBjDfPiCgPiCpAjCmKiCoJiClBiCmGiCkKiCoNiCkJiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiOkOiCmNiImIiJlKiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3 _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			C_xZkqqHx_iCpAiBeBjApMjFkK_xHqqkZx_DC=M*v_xZkqqHx_iCmFjFfMiClHiCmG_xHqqkZx_
 *			C=D+M*v
 *			_xZkqqHx_iClBiCoKiCpAiHeAiCmJjBoDjDpMiClHiCoJiBeC_xHqqkZx_
 *			P = A*(1 - t)^3 + 3*B*t*(1 - t)^2 + D*t^3 + 3*(1 - t)*t^2*(D + M*v)
 *			_xZkqqHx_iClBiCoKiCpAjDfHiKeKiClFiBeB_xHqqkZx_v_xZkqqHx_iCmJiKnGiClFiCmEiJpAiCkNiCmG_xHqqkZx_
 *			v = -(A - P - 3*A*t + 3*B*t + 3*A*t^2 - 6*B*t^2 + 3*D*t^2 - A*t^3 + 3*B*t^3 - 2*D*t^3)/(M*3*t^2*(1 - t)) _xZkqqHx_iBeFiBeFiBeFiHeB_xHqqkZx_
 *			x,y_xZkqqHx_iCmJiKnGiMfHiCmIiCkCjFmPjAjEiCpAjBfDiCmEiNlGjFnDiCmJiPfHiCnPiCoJiBeC_xHqqkZx_
 *			v*3*t^2*(1 - t) = -(A - P - 3*A*t + 3*B*t + 3*A*t^2 - 6*B*t^2 + 3*D*t^2 - A*t^3 + 3*B*t^3 - 2*D*t^3)/M
 *			_xZkqqHx_iClBiCoKiCpA_xHqqkZx_ x,y_xZkqqHx_iCmJiCmCiCkCiCmEjFfMiClHiCmG_xHqqkZx_
 *			v*3*t^2*(1 - t) = -(Ax - Px - 3*Ax*t + 3*Bx*t + 3*Ax*t^2 - 6*Bx*t^2 + 3*Dx*t^2 - Ax*t^3 + 3*Bx*t^3 - 2*Dx*t^3)/Mx _xZkqqHx_iBeFiBeFiBeFiHeC_xHqqkZx_
 *			v*3*t^2*(1 - t) = -(Ay - Py - 3*Ay*t + 3*By*t + 3*Ay*t^2 - 6*By*t^2 + 3*Dy*t^2 - Ay*t^3 + 3*By*t^3 - 2*Dy*t^3)/My _xZkqqHx_iBeFiBeFiBeFiHeD_xHqqkZx_
 *			_xZkqqHx_iHeCiBeBiHeDiCmMiNlGjFnDiCmNjDjJiClFiCkCiCmMiCmF_xHqqkZx_
 *			-(Ax - Px - 3*Ax*t + 3*Bx*t + 3*Ax*t^2 - 6*Bx*t^2 + 3*Dx*t^2 - Ax*t^3 + 3*Bx*t^3 - 2*Dx*t^3)/Mx =
 *				 -(Ay - Py - 3*Ay*t + 3*By*t + 3*Ay*t^2 - 6*By*t^2 + 3*Dy*t^2 - Ay*t^3 + 3*By*t^3 - 2*Dy*t^3)/My
 *			_xZkqqHx_jFkKjFoKiCmJiCePiCkKiCkAiCoJiCmGiCnMiClIiCkCiCmMiCmFiBeBjHlMjFnDiCmJ_xHqqkZx_Mx*My_xZkqqHx_iCpAiCkJiCkPiCoJiBeC_xHqqkZx_
 *			-(Ax - Px - 3*Ax*t + 3*Bx*t + 3*Ax*t^2 - 6*Bx*t^2 + 3*Dx*t^2 - Ax*t^3 + 3*Bx*t^3 - 2*Dx*t^3)*My =
 *				 -(Ay - Py - 3*Ay*t + 3*By*t + 3*Ay*t^2 - 6*By*t^2 + 3*Dy*t^2 - Ay*t^3 + 3*By*t^3 - 2*Dy*t^3)*Mx
 *			_xZkqqHx_iClBiCoKiCpA_xHqqkZx_ t _xZkqqHx_iCmJiKnGiClFiCmEiCnMiCmGiCnPiCoJiBeC_xHqqkZx_
 *			Ay*Mx - Ax*My + My*Px - Mx*Py +
 *				(-3*Ay*Mx + 3*By*Mx + 3*Ax*My - 3*Bx*My)*t +
 *					(3*Ay*Mx - 6*By*Mx + 3*Dy*Mx - 3*Ax*My + 6*Bx*My - 3*Dx*My)*t^2 +
 *						(-Ay*Mx + 3*By*Mx - 2*Dy*Mx + Ax*My - 3*Bx*My + 2*Dx*My)*t^3 = 0
 *			_xZkqqHx_iImIiJlKiCmFjChFiCkLiKlHiCkGiCmEiBeBiOkOiCpAiMkJiCoCiClHiCkNiClHiCoJiBeC_xHqqkZx_
 *			Ay*Mx = E
 *			Ax*My = F
 *			By*Mx = G
 *			Bx*My = H
 *			Dy*Mx = I
 *			Dx*My = J
 *			E - F + My*Px - Mx*Py +
 *				3*(-E + G + F - H)*t +
 *					3*(E - 2*G + I - F + 2*H - J)*t^2 +
 *						(-E + 3*G - 2*I + F - 3*H + 2*J)*t^3 = 0
 *			_xZkqqHx_iClBiCoKiCpAiJpAiCkCiCmE_xHqqkZx_ t _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iHeB_xHqqkZx_ _xZkqqHx_iCpAiCnMiCmGiCnPiCoJiBeC_xHqqkZx_
 *			v = (-A + P + 3*(A - B)*t + 3*(-A + 2*B - D)*t^2 + (A - 3*B + 2*D)*t^3) / (M*3*t^2*(1 - t))
 *			_xZkqqHx_iClBiCmMiOkOiCkJiCoH_xHqqkZx_ v _xZkqqHx_iCpAiLiBiCnPiBeB_xHqqkZx_C_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCalcCFromABDMP (	DBLPoint& mmptC,
						const DBLPoint& mmptA,
						const DBLPoint& mmptB,
						const DBLPoint& mmptD,
						const DBLPoint& mmptM,
						const DBLPoint& mmptP)
{
	const double dE = mmptA.y * mmptM.x;
	const double dF = mmptA.x * mmptM.y;
	const double dG = mmptB.y * mmptM.x;
	const double dH = mmptB.x * mmptM.y;
	const double dI = mmptD.y * mmptM.x;
	const double dJ = mmptD.x * mmptM.y;
	// _xZkqqHx_iDeKiDiLiDfPiDgNjGeAiCmFiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCCardano cd;
	cd.Set(	-dE + 3.0 * dG - 2.0 * dI + dF - 3.0 * dH + 2.0 * dJ,
			3.0 * (dE - 2.0 * dG + dI - dF + 2.0 * dH - dJ),
			3.0 * (-dE + dG + dF - dH),
			dE - dF + mmptM.y * mmptP.x - mmptM.x * mmptP.y);
	if (about0(cd.m_dA) &&
		about0(cd.m_dB) &&
		about0(cd.m_dC) &&
		about0(cd.m_dD))
	//----- _xZkqqHx_iCfDiIpIjAjEiCkKiClHiCnHiCmEiCePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// t_xZkqqHx_iCkKiCmHiCkEiCkCiCkEjCgMiCmFiCkAiCmBiCmEiCoAjHmHiCkCiCmGiCkCiCkEiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iCgAiBeBiCgCiBeBiCgDiBeBiCgLiBeBiCgPiCkKiIoKjClMjApMiCmJjFmAiCnEiPoKiNiHiCmJiLeOiClBiCoJiBeC_xHqqkZx_
		mmptC = mmptD;
		return TRUE;
	}
	const long lCount = cd.Solve();

	mmetol mmVMin = DBL_MAX;
	for (long lC = 0; lC != lCount; lC++)
	//----- _xZkqqHx_iJpAiCpAjClCiCnHiCoJ_xHqqkZx_ -----
	{
		// _xZkqqHx_jHeMiMpIiCmIiCjEiCmMjCgMiCmFiCkAiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		if (figeq(cd.m_cSol[lC].imag(), 0, 5) &&
			0.0 < cd.m_cSol[lC].real() && cd.m_cSol[lC].real() < 1.0)
		//----- _xZkqqHx_iLjFjAjEjFjEiCkKiCePiCmFiCkAiCoIiBeBiOmAjAjEjFjEiBgJjBkGiClP_xHqqkZx_t_xZkqqHx_iBgKiCkK_xHqqkZx_(0,1)_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			double dT = cd.m_cSol[lC].real();
			mmetol mmV;
			if (almost0(mmptM.x))
				mmV = (	-mmptA.y + mmptP.y + 3.0 * (mmptA.y - mmptB.y) * dT +
						3.0 * (-mmptA.y + 2.0 * mmptB.y - mmptD.y) * POW2(dT) +
						(mmptA.y - 3.0 * mmptB.y + 2.0  *  mmptD.y) * POW3(dT)) / (mmptM.y * 3.0 * POW2(dT) * (1.0 - dT));
			else
				mmV = (	-mmptA.x + mmptP.x + 3.0 * (mmptA.x - mmptB.x) * dT +
						3.0 * (-mmptA.x + 2.0 * mmptB.x - mmptD.x) * POW2(dT) +
						(mmptA.x - 3.0 * mmptB.x + 2.0  *  mmptD.x) * POW3(dT)) / (mmptM.x * 3.0 * POW2(dT) * (1.0 - dT));

			// v_xZkqqHx_iCmN_xHqqkZx_0_xZkqqHx_iCoGiCoIjBoFiCkLiCkNiCmIiCkNiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
			// _xZkqqHx_jCgMiCkKiPkMiClDiCkCiCnJiCmHjHmHiCkCiBeC_xHqqkZx_
			if (0.0 < mmV && mmV < mmVMin)
				mmVMin = mmV;
		}
	}
	if (mmVMin != DBL_MAX)
	//---- v_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmptC = mmptD + mmptM * mmVMin;
		return TRUE;
	}
	return FALSE;
} // FFCalcCFromABDMP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetBezierVelocity
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	bc_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiCoJiDhIiDfHiDeGiLmIjApMiCmMiBeBiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJjBkMjDhIiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bc	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dT	:_xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJjBkMjDhIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiOkOiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3
 *			_xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJjBkMjDhIiCmNiBeBiDhIiDfHiDeGiLmIjApMiCmMiOkOiCmMjDlBiKnGjAjEiCmFiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *			P' = -3*(A - B) + 6*(A - 2*B + C)*t - 3*(A - 3*B + 3*C - D)*t^2
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FFGetBezierVelocity (const FCBezierControls& bc, double dT)
{
	return -3.0*(bc.A() - bc.B()) + 6.0*(bc.A() - 2.0*bc.B() + bc.C())*dT - 3.0*(bc.A() - 3.0*bc.B() + 3.0*bc.C() - bc.D())*POW2(dT);
} // FFGetBezierVelocity.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFChopBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiOjOiNiP_xHqqkZx_T0_xZkqqHx_iBgA_xHqqkZx_Tn_xZkqqHx_jFjEjFkKiCpAiBeBjFmKiCmMiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bcChopped	:_xZkqqHx_jAfGiClFiCkCiDhIiDfHiDeGiLmIjApMiCpAjFnEiClHiBeC_xHqqkZx_
 *			bc			:_xZkqqHx_iLnPiOjHjBmOiPnLiCmMiDhIiDfHiDeGiLmIjApMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dT0			:_xZkqqHx_iOjOiNiP_xHqqkZx_T0_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dTn			:_xZkqqHx_iOjOiNiP_xHqqkZx_Tn_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsBeqA		:TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_bcChopped_xZkqqHx_iCmMjDfP_xHqqkZx_B=_xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCmGiLkNjAkHiClDiCoKiCoJiBeC_xHqqkZx_
 *			bIsCeqD		:TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_bcChopped_xZkqqHx_iCmMjDfP_xHqqkZx_C=_xZkqqHx_jDfP_xHqqkZx_D_xZkqqHx_iCmGiLkNjAkHiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOfKiPgPiCmJiOlIjEhDiClFiClNiPoKiNiHiCmFiCoAiBeB_xHqqkZx_bcChopped _xZkqqHx_iCmJjDeLjDjGiCmIjCgMiCpAjFnEiClHiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiOkOiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3
 *			// _xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJjBkMjDhIiCpA_xHqqkZx_V(t)_xZkqqHx_iCmGiClHiCoJiBeC_xHqqkZx_
 *			T0_xZkqqHx_iCmJiCkIiCkPiCoJ_xHqqkZx_P_xZkqqHx_iCpAiOgOjDfP_xHqqkZx_P0_xZkqqHx_iBeB_xHqqkZx_Tn_xZkqqHx_iCmJiCkIiCkPiCoJ_xHqqkZx_P_xZkqqHx_iCpAiPeJjDfP_xHqqkZx_Pn_xZkqqHx_iCmGiClFiCmEiBeB_xHqqkZx_P0_xZkqqHx_iBgA_xHqqkZx_Pn_xZkqqHx_iCpAjAfGiClFiCkC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClHiCoJiClBiCmGiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			P0_xZkqqHx_iCmJiCkIiCkPiCoJjBkMjDhIiCmN_xHqqkZx_V(T0)=V0_xZkqqHx_iBeB_xHqqkZx_Pn_xZkqqHx_iCmJiCkIiCkPiCoJjBkMjDhIiCmN_xHqqkZx_V(Tn)=Vn_xZkqqHx_iCmFiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *			P0_xZkqqHx_iBgA_xHqqkZx_Pn_xZkqqHx_iCmMjDhCjCiGiCmMjDfP_xHqqkZx_ P(T1)=S1,P(T2)=S2_xZkqqHx_iCpAjDeLjDjGiCmJjBeJjBpAiClFiCmEiBeB_xHqqkZx_
 *			FFCalcBCFromADLMP2_xZkqqHx_iKnGjAjEiCmJiCoGiCmBiCmEjAfGiClFiCkC_xHqqkZx_B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jCgMiCkKiLiBiCnMiCoHiCmIiCkCiPoKiNiHiCoAiBeBjDeLjDjGiCmIiMhGiOfKiCpAiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFChopBezier (	FCBezierControls& bcChopped,
					FCBezierControls bc,
					double dT0,
					double dTn,
					BOOL bIsBeqA,
					BOOL bIsCeqD)
{
//----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jIeBiMiLjDfPjFkKiKiEiOjOiCmJiBeBiKpJjBlGjIeBiMiLjDfPiCmGjDkPiClGiImKjChFiCmFjFkKiKiEiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiBeB_xHqqkZx_
	// dT0 = 0, dTn = 1_xZkqqHx_iBeB_xHqqkZx_dT0 = dTn _xZkqqHx_iCmMiPoKiNiHiCkKiCkAiCoIiCkGiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jDmBiCmJ_xHqqkZx_ dT0 = dTn _xZkqqHx_iCmMiPoKiNiHiCmNjAlDiClFiCkCjDjKiCkGiCkKjDlBiCkPiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiClBiCoKiCoHiCmMiPoKiNiHiCmMiPiIjHjNiCpAjFmKjDhCjHhAiInDiClHiCoJiBeC_xHqqkZx_
	if (abouteq(dT0, 0.0) && abouteq(dTn, 1.0))
	//----- dT0 = 0, dTn = 1 _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		bcChopped = bc;
		return TRUE;
	} else
	if (abouteq(dT0, dTn))
	//----- dT0 = dTn _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		const DBLPoint mmptP = FFCalcBezierPoint(bc, dT0);
		bcChopped.A() = mmptP;
		bcChopped.B() = mmptP;
		bcChopped.C() = mmptP;
		bcChopped.D() = mmptP;
		return TRUE;
	} else
	//----- _xZkqqHx_iClLiCoKiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		const double dT3 = dT0 + (dTn - dT0) / 3.0;
		const double dT4 = dT0 + (dTn - dT0) * 2.0 / 3.0;
		const DBLPoint mmptP0 = FFCalcBezierPoint(bc, dT0);
		const DBLPoint mmptPn = FFCalcBezierPoint(bc, dTn);
		const DBLPoint mmptS1 = FFCalcBezierPoint(bc, dT3);
		const DBLPoint mmptS2 = FFCalcBezierPoint(bc, dT4);
		const DBLPoint mmptV0 = bIsBeqA ? DBLPoint(0.0, 0.0) : FFGetBezierVelocity(bc, dT0);
		const DBLPoint mmptVn = bIsCeqD ? DBLPoint(0.0, 0.0) : FFGetBezierVelocity(bc, dTn);
		// B,C_xZkqqHx_iCmMiDgGiDhEiDeIiDiLiDgHjCgMiBeCjAlDiClFiCkCjCgMiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
		DBLPoint mmptB = mmptP0 + 0.1 * mmptV0;
		DBLPoint mmptC = mmptPn - 0.1 * mmptVn;
		BOOL bSucceed = FALSE;
		if (almost0(mmptV0))
		//----- P0_xZkqqHx_iCmJiCkIiCkPiCoJiMfIiCkLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMfIiCkLiCkKiMiIiCnMiCoHiCmIiCkCiCmMiCmNiBeB_xHqqkZx_A=B_xZkqqHx_iCmMiPoKiNiHiCmFiCkAiCoJiBeC_xHqqkZx_
			mmptB = mmptP0;
			if (almost0(mmptVn))
			//----- Pn_xZkqqHx_iCmJiCkIiCkPiCoJiMfIiCkLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMfIiCkLiCkKiMiIiCnMiCoHiCmIiCkCiCmMiCmNiBeB_xHqqkZx_C=D_xZkqqHx_iCmMiPoKiNiHiCmFiCkAiCoJiBeC_xHqqkZx_
				mmptC = mmptPn;
				bSucceed = TRUE;
			} else
			//----- Pn_xZkqqHx_iCmJiCkIiCkPiCoJiMfIiCkLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iCgAiBeBiCgBiBeBiCgDiBeDiCgDiCgCiCmMiKhAjDhIiCmGiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoHjAkHiMoEjDfPiCgCiCmMjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
				bSucceed = FFCalcCFromABDMP(mmptC,
											mmptP0,
											mmptB,
											mmptPn,
											-mmptVn,
											mmptS1);
			}
		} else
		//----- P0_xZkqqHx_iCmJiCkIiCkPiCoJiMfIiCkLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (almost0(mmptVn))
			//----- Pn_xZkqqHx_iCmJiCkIiCkPiCoJiMfIiCkLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMfIiCkLiCkKiMiIiCnMiCoHiCmIiCkCiCmMiCmNiBeB_xHqqkZx_C=D_xZkqqHx_iCmMiPoKiNiHiCmFiCkAiCoJiBeC_xHqqkZx_
				mmptC = mmptPn;
				// _xZkqqHx_iCgAiBeBiCgCiBeBiCgDiBeDiCgAiCgBiCmMiKhAjDhIiCmGiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoHjAkHiMoEjDfPiCgBiCmMjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
				bSucceed = FFCalcBFromACDLP(mmptB,
											mmptP0,
											mmptC,
											mmptPn,
											mmptV0,
											mmptS2);
			} else
			//----- Pn_xZkqqHx_iCmJiCkIiCkPiCoJiMfIiCkLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iCgAiBeBiCgDiBeDiCgAiCgBiCmMiKhAjDhIiBeBiCgDiCgCiCmMiKhAjDhIiCmGiCfBiCmCiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoHjAkHiMoEjDfPiCgBiBeBiCgCiCmMjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
				bSucceed = FFCalcBCFromADLMP2(	mmptB, mmptC, mmptP0, mmptPn,
												mmptV0, -mmptVn, mmptS1, mmptS2,
												FFCalcBezierAngle(bc, dT3),
												FFCalcBezierAngle(bc, dT4),
												0.05 * M_PI);
			}
		}
		bcChopped.A() = mmptP0;
		bcChopped.B() = mmptB;
		bcChopped.C() = mmptC;
		bcChopped.D() = mmptPn;
		return bSucceed;
// 06.10.18 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	}
} // FFChopBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcAfterDistanceT
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiDhIiDfHiDeGiLmIjApMiPoDiCmJiCkIiCkCiCmEiBeBiOjOiNiP_xHqqkZx_t0_xZkqqHx_iCmMiImKjChFiChAiCkJiCoHiBeBiOhHjCoIiClDiCoKiClNiLjHjHkDiCmM_xHqqkZx_
 *			_xZkqqHx_iImKjChFiCgPiCmMiOjOiNiP_xHqqkZx_t_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bc			:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dT0			:_xZkqqHx_iOjOiNiP_xHqqkZx_t0_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmTargetLen	:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iImKjChFiCgPiCmMiOjOiNiPiBeCiDfOiBfLiDfBiDgCiDgHiLjHjHkDiCkKiDhIiDfHiDeGiLmIjApMiCpAjClEiCkGiCoJiPoKiNiHiCmN_xHqqkZx_ -1.0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	t0 < t _xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClIiBeB_xHqqkZx_0.1_xZkqqHx_iClIiCmCiDhIiDfHiDeGiLmIjApMiCmMiLjHjHkDiCpAiOfKiPgPiClFiBeBiDfOiBfLiDfBiDgCiDgHiCmMiOjOiNiPiCkK_xHqqkZx_
 *			_xZkqqHx_iCmHiCmMjEmNiImNiCmJjDpMiCoJiCkJiCpAiNgJiCoIiNjOiCnOiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiLjHjHkDiCmNjCfAjClCjBjNiJmBiBgJiMlIiPkNiBgKiCmFiCmNiCmIiCkCiClNiCnPiBeBiCfBjFkKiKiEiCmJiCoGiCoJ_xHqqkZx_
 *			_xZkqqHx_iNgJiNjOiCnNiCmNiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
 *			
 *			      t0                               t
 *			      _xZkqqHx_iEkA_xHqqkZx_                             _xZkqqHx_iBkJiEjPiBkI_xHqqkZx_
 *			    _xZkqqHx_iBgDiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiBgD_xHqqkZx_
 *			     +0.0  +0.1  +0.2  +0.3  +0.4  +0.5  +0.6  +0.7
 *			
 *			(t0+0.5)_xZkqqHx_iBgA_xHqqkZx_(t0+0.6)_xZkqqHx_iCmMiKnEiCmJiDfOiBfLiDfBiDgCiDgHiCmMiOjOiNiP_xHqqkZx_t_xZkqqHx_iCkKiCkAiCoJiCmGiCoNiCkJiCmBiClNiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iOjPiCmMiDfIiDgFiDgCiDhGiCmFiCmNiBeBiCfBjFkKiKiEjGeAiCmF_xHqqkZx_t_xZkqqHx_iCpAiNgJiCoIiNjOiCnOiBeC_xHqqkZx_
 *			+0.5_xZkqqHx_iCmG_xHqqkZx_+0.6_xZkqqHx_iCmMjCiGiKnEiCmM_xHqqkZx_t=+0.55_xZkqqHx_iCmMiNmAjFfH_xHqqkZx_P_xZkqqHx_iCpAiOfKiPgPiClFiBeB_xHqqkZx_Q_xZkqqHx_iCkJiCoH_xHqqkZx_P_xZkqqHx_iCmMiLjHjHkDiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *			
 *			          |QP|        _xZkqqHx_iCgP_xHqqkZx_
 *			    _xZkqqHx_iBgDiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_
 *			       TargetLen      _xZkqqHx_iEkA_xHqqkZx_
 *			    _xZkqqHx_iBgDiEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *			    _xZkqqHx_iBgDiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiBgD_xHqqkZx_
 *			     +0.5            +0.55           +0.6
 *			     Lower            _xZkqqHx_iBkK_xHqqkZx_             Upper
 *			                   New Upper
 *			
 *			|QP|>=TargetLen _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_Upper_xZkqqHx_iCpAjCiGiKnEiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *			
 *			
 *			          |QP|        _xZkqqHx_iCgP_xHqqkZx_
 *			    _xZkqqHx_iBgDiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_
 *			       TargetLen      _xZkqqHx_iEkA_xHqqkZx_
 *			    _xZkqqHx_iBgDiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiBkIiEkA_xHqqkZx_
 *			    _xZkqqHx_iBgDiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiBgD_xHqqkZx_
 *			     +0.5            +0.55           +0.6
 *			     Lower            _xZkqqHx_iBkK_xHqqkZx_             Upper
 *			                   New Lower
 *			
 *			|QP|<TargetLen _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_Lower_xZkqqHx_iCpAjCiGiKnEiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FFCalcAfterDistanceT (const FCBezierControls& bc, const DBLPoint& mmptQ, double dT0, mmetol mmTargetLen)
{
	double dTargetLen = POW2(mmTargetLen);
//	const DBLPoint mmptQ = FFCalcBezierPoint(bc, dT0);
	double dLowerT = dT0;
	double dUpperT;
	for (;;)
	{
		dUpperT = dLowerT + 0.1;
		if (1.0 < dUpperT) dUpperT = 1.0;
		const DBLPoint mmptP = FFCalcBezierPoint(bc, dUpperT);
		if (dTargetLen <= (mmptP - mmptQ).PowLen()) break;
		if (dUpperT == 1.0) return -1.0;
		dLowerT = dUpperT;
	}
	double dT = (dLowerT + dUpperT) / 2.0;
	for (long lC = 0; lC != 10; lC++)
	{
		const DBLPoint mmptP = FFCalcBezierPoint(bc, dT);
		if ((mmptP - mmptQ).PowLen() < dTargetLen)
		{
			dLowerT = dT;
		} else
		{
			dUpperT = dT;
		}
		dT = (dLowerT + dUpperT) / 2.0;
	}
	return dT;
} // FFCalcAfterDistanceT.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcBeforeDistanceT
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bc			:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dT0			:_xZkqqHx_iOjOiNiP_xHqqkZx_t0_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmTargetLen	:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iImKjChFiCgPiCmMiOjOiNiPiBeCiDfOiBfLiDfBiDgCiDgHiLjHjHkDiCkKiDhIiDfHiDeGiLmIjApMiCpAjClEiCkGiCoJiPoKiNiHiCmN_xHqqkZx_ -1.0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	t < t0 _xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClIiBeB_xHqqkZx_0.1_xZkqqHx_iClIiCmCiDhIiDfHiDeGiLmIjApMiCmMiLjHjHkDiCpAiOfKiPgPiClFiBeBiDfOiBfLiDfBiDgCiDgHiCmMiOjOiNiPiCkK_xHqqkZx_
 *			_xZkqqHx_iCmHiCmMjEmNiImNiCmJjDpMiCoJiCkJiCpAiNgJiCoIiNjOiCnOiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiLjHjHkDiCmNjCfAjClCjBjNiJmBiBgJiMlIiPkNiBgKiCmFiCmNiCmIiCkCiClNiCnPiBeBiCfBjFkKiKiEiCmJiCoGiCoJ_xHqqkZx_
 *			_xZkqqHx_iNgJiNjOiCnNiCmNiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
 *			
 *			                     t                          t0
 *			                   _xZkqqHx_iBkJiEjPiBkI_xHqqkZx_                       _xZkqqHx_iEkA_xHqqkZx_
 *			    _xZkqqHx_iBgDiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiBgD_xHqqkZx_
 *			     -0.7  -0.6  -0.5  -0.4  -0.3  -0.2  -0.1  -0.0
 *			
 *			(t0-0.5)_xZkqqHx_iBgA_xHqqkZx_(t0-0.4)_xZkqqHx_iCmMiKnEiCmJiDfOiBfLiDfBiDgCiDgHiCmMiOjOiNiP_xHqqkZx_t_xZkqqHx_iCkKiCkAiCoJiCmGiCoNiCkJiCmBiClNiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iOjPiCmMiDfIiDgFiDgCiDhGiCmFiCmNiBeBiCfBjFkKiKiEjGeAiCmF_xHqqkZx_t_xZkqqHx_iCpAiNgJiCoIiNjOiCnOiBeC_xHqqkZx_
 *			-0.5_xZkqqHx_iCmG_xHqqkZx_-0.4_xZkqqHx_iCmMjCiGiKnEiCmM_xHqqkZx_t=-0.45_xZkqqHx_iCmMiNmAjFfH_xHqqkZx_P_xZkqqHx_iCpAiOfKiPgPiClFiBeB_xHqqkZx_Q_xZkqqHx_iCkJiCoH_xHqqkZx_P_xZkqqHx_iCmMiLjHjHkDiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *			
 *			                      _xZkqqHx_iCgP_xHqqkZx_        |QP|
 *			                      _xZkqqHx_iEkAiBkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *			                      _xZkqqHx_iEkA_xHqqkZx_      TargetLen
 *			                      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkAiBkJiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *			    _xZkqqHx_iBgDiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiBgD_xHqqkZx_
 *			     -0.5            -0.45           -0.4
 *			     Lower            _xZkqqHx_iBkK_xHqqkZx_             Upper
 *			                   New Lower
 *			
 *			|QP|>=TargetLen _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_Lower_xZkqqHx_iCpAjCiGiKnEiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *			
 *			
 *			                      _xZkqqHx_iCgP_xHqqkZx_        |QP|
 *			                      _xZkqqHx_iEkAiBkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *			                      _xZkqqHx_iEkA_xHqqkZx_      TargetLen
 *			              _xZkqqHx_iEkAiBkJiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *			    _xZkqqHx_iBgDiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiBgD_xHqqkZx_
 *			     -0.5            -0.45           -0.4
 *			     Lower            _xZkqqHx_iBkK_xHqqkZx_             Upper
 *			                   New Upper
 *			
 *			|QP|<TargetLen _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_Upper_xZkqqHx_iCpAjCiGiKnEiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FFCalcBeforeDistanceT (const FCBezierControls& bc, double dT0, mmetol mmTargetLen)
{
	double dTargetLen = POW2(mmTargetLen);
	const DBLPoint mmptQ = FFCalcBezierPoint(bc, dT0);
	double dUpperT = dT0;
	double dLowerT;
	for (;;)
	{
		dLowerT = dUpperT - 0.1;
		if (dLowerT < 0.0) dLowerT = 0.0;
		const DBLPoint mmptP = FFCalcBezierPoint(bc, dLowerT);
		if (dTargetLen <= (mmptP - mmptQ).PowLen()) break;
		if (dLowerT == 0.0) return -1.0;
		dUpperT = dLowerT;
	}
	double dT = (dUpperT + dLowerT) / 2.0;
	for (long lC = 0; lC != 10; lC++)
	{
		const DBLPoint mmptP = FFCalcBezierPoint(bc, dT);
		if ((mmptP - mmptQ).PowLen() < dTargetLen)
		{
			dUpperT = dT;
		} else
		{
			dLowerT = dT;
		}
		dT = (dUpperT + dLowerT) / 2.0;
	}
	return dT;
} // FFCalcBeforeDistanceT.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcT
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDfPiCgPiCmJiNmFiCoAiLnPiCkCiBeBiDhIiDfHiDeGiLmIjApMiPoDiCmMjDfPiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lControlIndex	:_xZkqqHx_iCgPiCmJiNmFiCoAiLnPiCkCiDhIiDfHiDeGiLmIjApMjEhKjHpBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			dT				:_xZkqqHx_iCgPiCmJiNmFiCoAiLnPiCkCiDhIiDfHiDeGiLmIjApMiCmMiOjOiNiPiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptQ			:_xZkqqHx_iCgPiCmJiNmFiCoAiLnPiCkCiDhIiDfHiDeGiLmIjApMiPoDiCmMjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *			vControls		:_xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP			:_xZkqqHx_jDfPiCgPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMiPoKiNiHiCmNiBeB_xHqqkZx_lControlIndex = 2_xZkqqHx_iBeB_xHqqkZx_dT = 0.4 _xZkqqHx_iCkKjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *                   _xZkqqHx_iCeP_xHqqkZx_                     _xZkqqHx_iCfA_xHqqkZx_                      _xZkqqHx_iCfB_xHqqkZx_
 *         _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                                                        0.0 0.2 0.4 0.6 0.8 1.0
 *                                                         _xZkqqHx_iEkFiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkH_xHqqkZx_
 *
 *          _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_  
 *            _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfP_xHqqkZx_
 *                                                                 _xZkqqHx_iBkD_xHqqkZx_
 *                                                                 _xZkqqHx_iCgP_xHqqkZx_
 *
 *			_xZkqqHx_iCfAiBeEiDhIiDfHiDeGiLmIjApMiCpAiCfAiCePiCmMjApMjFkKiCmJjFkKiKiEiClFiBeBjDfPiCgPiCmJiNmFiCoAiLnPiCkCjApMjFkKiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEiNmFiCoAiLnPiCkCjApMjFkKiCmMiOjOiNiPjEmNiImN_xHqqkZx_(LowerT, UpperT)_xZkqqHx_iCpAiBeBjApMjFkK_xHqqkZx_(LowerQ,UpperQ)
 *				_xZkqqHx_iPoDiCmMjDfPiCgPiCmJiNmFiCoAiLnPiCkCjDfP_xHqqkZx_MinQm_xZkqqHx_iCmMjApMjFkKjClHjEoEjHkGiCmFiCfBiCmCiCmJjFkKiKiEiClHiCoJiBeC_xHqqkZx_
 *				_xZkqqHx_jBkGiClPiBeB_xHqqkZx_|LowerQ-MinQm|_xZkqqHx_iBeG_xHqqkZx_|MinQm-UpperQ|_xZkqqHx_iBiB_xHqqkZx_|LowerT-T|_xZkqqHx_iBeG_xHqqkZx_|T-UpperT|_xZkqqHx_iCmG_xHqqkZx_
 *				_xZkqqHx_iCmIiCoJiCoGiCkEiCmIiOjOiNiP_xHqqkZx_T_xZkqqHx_iCpAiLiBiCnPiBeB_xHqqkZx_T_xZkqqHx_iCmFiOjOiNiPiCpAjFkKiKiEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeEiOjOiNiP_xHqqkZx_T_xZkqqHx_iCmJiCkIiCkPiCoJiDhIiDfHiDeGiLmIjApMiPoDiCmMjDfPiChAiCpAiOfKiPgPiClFiBeBiCgPiCkKjDpBiCmCiCmMjApMjFkK_xHqqkZx_
 *				(LowerQ,Q)_xZkqqHx_iCmG_xHqqkZx_(Q,UpperQ)_xZkqqHx_iCmMiCmHiClPiCoHiCmJiLnPiCkCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfDiBeEiCgPiCkK_xHqqkZx_(LowerQ,Q)_xZkqqHx_iCmJiLnPiCkCiPoKiNiHiCmN_xHqqkZx_UpperQ_xZkqqHx_iCmG_xHqqkZx_UpperT_xZkqqHx_iCpAiBeB_xHqqkZx_(Q,UpperQ)_xZkqqHx_iCmJ_xHqqkZx_
 *				_xZkqqHx_iLnPiCkCiPoKiNiHiCmN_xHqqkZx_LowerQ_xZkqqHx_iCmG_xHqqkZx_LowerT_xZkqqHx_iCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfEiBeEiCfBiBgAiCfDiCpAiMeKiCoIjFnEiClFiCmEiCgPiCmJiLnPiCmDiCkPiCmEiCkCiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.08.05 Fukushiro M. _xZkqqHx_iDhIiDfHiDeGiCkKjClMjApMiCmMiPoKiNiHiCmMjCgMiCkKiCkIiCkJiClFiCkCiCmMiCmFiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void FFCalcT (	long& lControlIndex,
				double& dT,
				DBLPoint& mmptQ,
				const FCBezierControlsVector& vControls,
				const DBLPoint& mmptP)
{
	double dMinPowLen = DBL_MAX;
	DBLPoint mmptLowerQ;
	DBLPoint mmptUpperQ;
	DBLPoint mmptMinQm;
	double dLowerT;
	double dUpperT;
	long lC;
	for (lC = 0; lC != vControls.size(); lC++)
	//----- _xZkqqHx_jBfDiDhIiDfHiDeGjEhKjHpBiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		const FCBezierControls& bc = vControls[lC];
		DBLPoint mmptQ2 = bc.A();
		// lT_xZkqqHx_iCmNiBeB_xHqqkZx_<=10_xZkqqHx_iCnMiCmFiDeKiDeFiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDhIiDfHiDeGiDfKiDePiDiBiDjDiDgHiCkKiNmFiMoDiCmMiPoKiNiHiCpAiNgMjHlGiBeC_xHqqkZx_
		long lT;
		for (lT = 1; lT <= 10; lT++)
		{
			const double dT1 = double(lT - 1) / 10.0;
			const double dT2 = double(lT) / 10.0;
			const DBLPoint mmptQ1 = mmptQ2;
			mmptQ2 = FFCalcBezierPoint(bc, dT2);
			DBLPoint mmptQm;
			double dPowTmp = CalcPowDistance(mmptQm, mmptQ1, mmptQ2, mmptP);
			if (dPowTmp < dMinPowLen)
			//----- (Q1,Q2)_xZkqqHx_iCkKiCgPiCmJiCoGiCoIiLnPiCkCiPoKiNiH_xHqqkZx_ -----
			{
				dMinPowLen = dPowTmp;
				lControlIndex = lC;
				mmptLowerQ = mmptQ1;
				mmptUpperQ = mmptQ2;
				mmptMinQm = mmptQm;
				dLowerT = dT1;
				dUpperT = dT2;
			}
		}
	}
//----- 05.08.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClPiCoFiCkEiCmHjFkKiKiEiMhGiOfKiClFiClNiImKjChFiCmJ_xHqqkZx_Q_xZkqqHx_iCkKiCkAiCoJiPoKiNiHiCmNiBeBiClLiCmMiCnMiCnMjFnEiClHiBeC_xHqqkZx_
	// _xZkqqHx_iDfKiDePiDiBiDjDiDgHiCmMjCfLjDfPiCmGiCgPiCkKiIoKjChGiClHiCoJiPoKiNiHiCmIiCmHiBeBiImIiJlKiCmMiPiIjHjNiCpAjDpMiCoKiCmIiCkCiCmG_xHqqkZx_
	// _xZkqqHx_iLnPiOjOjCgMiCkKjFnEiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	if (almosteq(mmptLowerQ, mmptMinQm))
	{
		dT = dLowerT;
		mmptQ = mmptLowerQ;
		return;
	}
	if (almosteq(mmptUpperQ, mmptMinQm))
	{
		dT = dUpperT;
		mmptQ = mmptUpperQ;
		return;
	}
//----- 05.08.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	const FCBezierControls& bc = vControls[lControlIndex];
	for (lC = 0;; lC++)
	{
		// _xZkqqHx_iOjOiNiPiChDiCpAiOfKiPgPiBeC_xHqqkZx_
		dT = dLowerT + (dUpperT - dLowerT) * ((mmptMinQm - mmptLowerQ).Len() / (mmptUpperQ - mmptLowerQ).Len());
		// _xZkqqHx_iChDiCmJiCkIiCkPiCoJjDfPiChAiCpAiOfKiPgPiBeC_xHqqkZx_
		mmptQ = FFCalcBezierPoint(bc, dT);
		// _xZkqqHx_iPfMjFkKiMhGiOfKiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (lC == 10 || almosteq(mmptQ, mmptMinQm)) break;
		DBLPoint mmptQm1;
		DBLPoint mmptQm2;
		double dPowTmp1 = CalcPowDistance(mmptQm1, mmptLowerQ, mmptQ, mmptP);
		double dPowTmp2 = CalcPowDistance(mmptQm2, mmptUpperQ, mmptQ, mmptP);
		if (dPowTmp1 < dPowTmp2)
		{
			dUpperT = dT;
			mmptUpperQ = mmptQ;
			mmptMinQm = mmptQm1;
		} else
		{
			dLowerT = dT;
			mmptLowerQ = mmptQ;
			mmptMinQm = mmptQm2;
		}
	}
} // FFCalcT.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCkJiCoHiBeBiDhMiDiKiDiJiDeDiDjDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjClIjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vIsJoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjIeBiMiLjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			polyBezier	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmWeight	:_xZkqqHx_iLmIjApMiCmMjBlOiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtClip	:_xZkqqHx_iDeOiDiKiDgCiDhGjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lClipSize	:mmrtClip_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vIsJoint_xZkqqHx_iCmNiBeB_xHqqkZx_vmmptPoint_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjBfDiCmEiCmMjClIjDfPiCkKiBeBiLmIjApMiCmMjClIjDfPiCkJiBeB_xHqqkZx_
 *			_xZkqqHx_iLmIjApMiCmGiLmIjApMiCmMjAnKjBlBjDfPiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCalcBezier (DBLPointVector& vmmptPoint,
					BYTEVector& vIsJoint,
					const FCMmPolyBezier& polyBezier,
					mmetol mmWeight,
					mmetol mmElemLen,
					const DBLRect* mmrtClip,
					long lClipSize)
{
	vmmptPoint.clear();
	// DrawBezierFast2_xZkqqHx_iKnGjAjEiCmNiOgOjDfPiCpAiNoMjAkMiClFiCmIiCkCiClNiCnPiBeBiOgOjDfPiCpAjBhNjDpMiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	vmmptPoint.push_back(polyBezier[0]);
	vIsJoint.push_back(TRUE);

	FCBezierControlsVector vControls;	// _xZkqqHx_iDhIiDfHiDeGiMhGiOfKjHhAiCmMiCfDjDfPiCmMjAkHiMoEjDfPiNmAjFfHiBeC_xHqqkZx_
// 05.04.21 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DBLRect mmrtStone;					// _xZkqqHx_iCfDjDfPiNmAjFfHiCmJiKePjAnKiClHiCoJiLoJiMgAiBeC_xHqqkZx_

	// _xZkqqHx_iCfDjDfPiCmMjAkHiMoEjDfPiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
	FFControlConv(vControls, polyBezier);
	long lControl;
	for (lControl = 0; lControl != vControls.size(); lControl++)
	{
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		const FCBezierControls& bc = vControls[lControl];
//		// _xZkqqHx_iDhMiDiKiDfDiDjDiMhGiOfKiCkKiPmIjHkKiJmCjEfMiCkJiBeI_xHqqkZx_
//		BOOL bIsOmit = FALSE;
//		if (lClipSize != 0)
//		//----- _xZkqqHx_iMhGiOfKjHmMiIoGiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfDjDfPiNmAjFfHiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiMhGiOfKiBeC_xHqqkZx_
//			::FFCalcFrame(mmrtStone, 4, bc.m_mmptControl);
//			// _xZkqqHx_iKePjAnKiLoJiMgAiCpAjApMjFjNiClOiCkPiNeMiClAiCoJiBeC_xHqqkZx_
//			mmrtStone.Extend(mmWeight / 2.0);
//			//----- _xZkqqHx_iCfDjDfPiNmAjFfHiKePjAnKiLoJiMgAiCmGiDiKiBfLiDfHiDiHiDjDiCkKiPgEiCmIiCoJiCkJjClCiCnHiCoJ_xHqqkZx_ -----
//			bIsOmit = TRUE;
//			for (long lClip = 0; lClip != lClipSize; lClip++)
//			{
//				if (!(mmrtStone & mmrtClip[lClip]).IsRectEmpty())
//				//----- _xZkqqHx_iPgEiCmIiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//				{
//					bIsOmit = FALSE;
//					break;
//				}
//			}
//		}
//		// _xZkqqHx_iCfDjDfPiNmAjFfHiCmMjBePiIpIjDfPiBeFiMoDiIpIjDfPiCkKiCePiCmMiPoKiNiHiCmNiPmIjHkKiBeC_xHqqkZx_
//		if (!bIsOmit &&
//			almosteq(bc.A(), bc.B()) && almosteq(bc.C(), bc.D()))
//			bIsOmit = TRUE;
//
//		// _xZkqqHx_iCfDjDfPiNmAjFfHiCmMjBePiIpIjDfPiBeFiMoDiIpIjDfPiCkKjHlMjCfLiCmMjIeBiMiLjDfPiCmMiKnEiCmJiCkAiCoJiPoKiNiHiCmNiPmIjHkKiBeC_xHqqkZx_
//		if (!bIsOmit &&
//			almost0(CalcPowDistance(DBLPoint(), bc.A(), bc.D(), bc.B())) &&
//			almost0(CalcPowDistance(DBLPoint(), bc.A(), bc.D(), bc.C())))
//			bIsOmit = TRUE;
//
//		if (bIsOmit)
//		//----- _xZkqqHx_iDhIiDfHiDeGiLmIjApMiMhGiOfKiPmIjHkK_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_)_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			vmmptPoint.push_back(bc.D());
//			if (!vIsJoint.empty())
//				vIsJoint.back() = TRUE;
//			vIsJoint.push_back(TRUE);
//		} else
//		//----- _xZkqqHx_iDhIiDfHiDeGiLmIjApMiMhGiOfKiCkKjFeLjHhGiCmIiPoKiNiH_xHqqkZx_ -----
//		{
//			//----------------------------------------------------
//			// _xZkqqHx_iCnMiClIjCfEiNlIjHhAiCmJiCfHjFkKiKiEiCmMiDhIiDfHiDeGiCpAjFgAiCkLiBeBiCfHjFnDiCmMiNiHiMhGjClHiCpA_xHqqkZx_
//			// _xZkqqHx_iKoOiPiAiCmJjFkKiKiEjAjEiCpAiMiIjCoIiClHiCoJiBeC_xHqqkZx_
//			//----------------------------------------------------
//			// _xZkqqHx_jCfEiNlIjHhAiCfHjFkKiKiEiDhIiDfHiDeGiCpAiMhGiOfKiBeC_xHqqkZx_
//			DBLPointVector vmmptPolyTest;	// _xZkqqHx_jClCiNlIjHhAjClIjDfPiNmAjFfHjEhKjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
//			DrawBezierFast2(vmmptPolyTest, bc.m_mmptControl, 8);
//			vmmptPolyTest.insert(vmmptPolyTest.begin(), bc.A());
//			mmetol mmTestLen = 0.0;
//			for (long lC = 0; lC != vmmptPolyTest.size() - 1; lC++)
//				mmTestLen += (vmmptPolyTest[lC + 1] - vmmptPolyTest[lC]).Len();
//			ASSERT(!almost0(mmElemLen));
//			long lSplit = D2L(mmTestLen / mmElemLen);
//			// _xZkqqHx_iNmFjCoBjFkKiKiEjAjEiCpAiCfHiCmJiClHiCoJiBeCiClBiCoKiImIiJlKiCmJiCmIiCoJiCmGiBeB_xHqqkZx_ObjPoly_xZkqqHx_iCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiMhGiOfKiOjOjDjJiCmJjFhDjDhDiNiHiCkKjAlGiClGiCoJiBeC_xHqqkZx_
//			if (lSplit < 8) lSplit = 8;
//			// _xZkqqHx_iNmFjBoFjFkKiKiEjAjEiCpA_xHqqkZx_200_xZkqqHx_iCmJiClHiCoJiBeCjBoFiCkLiClHiCkMiCoJiCmGjFgAiJoGiCmJiOjOiKnEiCkKiCkJiCkJiCmBiClNiCoIiBeB_xHqqkZx_DrawBezierFast2_xZkqqHx_iCmM_xHqqkZx_short_xZkqqHx_iMfOiCmJjFmPiKlHiCmFiCkLiCmIiCkCiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
//			if (200 < lSplit) lSplit = 200;
//			// _xZkqqHx_jAlDiOkOiCmIiDhIiDfHiDeGiMhGiOfKiBeC_xHqqkZx_
//			DBLPointVector vmmptPointTmp;
//			DrawBezierFast2(vmmptPointTmp, bc.m_mmptControl, short(lSplit));
//			vmmptPoint.insert(vmmptPoint.end(), vmmptPointTmp.begin(), vmmptPointTmp.end());
//			if (lControl != 0)
//			//----- _xZkqqHx_iNmFiPiJiCmMiDhIiDfHiDeGiLmIjApMiDfKiDePiDiBiDjDiDgHiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//			{
//				const FCBezierControls& bcPrev = vControls[lControl - 1];
//				if (almosteq(bcPrev.C(), bcPrev.D()))
//				//----- _xZkqqHx_jBePiCmMiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCgCiCkKiCgDiCmJjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
//				{
//					vIsJoint.back() = TRUE;
//				} else
//				if (almosteq(bc.A(), bc.B()))
//				//----- _xZkqqHx_iNkBiCmMiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCgBiCkKiCgAiCmJjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
//				{
//					vIsJoint.back() = TRUE;
//				} else
//				{
//					DBLPoint mmptS;
//					if (about0(CalcPowDistance(mmptS, bcPrev.C(), bc.B(), bc.A())))
//					//----- _xZkqqHx_iNkBiCmMiDhIiDfHiDeGiLmIjApMiCmMjDfPiCgAiCmMjBePiMoDiCmMjAkHiMoEjDfPiCkKiIoKjClMjApMiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//					{
//						vIsJoint.back() = TRUE;
//					}
//				}
//			}
//			BYTEVector vIsJointTmp(vmmptPointTmp.size(), FALSE);
//			vIsJoint.insert(vIsJoint.end(), vIsJointTmp.begin(), vIsJointTmp.end());
//		}
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		const FCBezierControls& bc = vControls[lControl];
		// _xZkqqHx_iDhIiDfHiDeGiMhGiOfKiBeC_xHqqkZx_
		DBLPointVector vmmptPointTmp;
		FFCalcBezier(	vmmptPointTmp,
						bc,
						mmWeight,
						mmElemLen,
						mmrtClip,
						lClipSize);
		// _xZkqqHx_iOgOjDfPiCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		vmmptPointTmp.erase(vmmptPointTmp.begin());
		// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmJjBhNjDpMiBeC_xHqqkZx_
		vmmptPoint.insert(vmmptPoint.end(), vmmptPointTmp.begin(), vmmptPointTmp.end());
		if (vmmptPointTmp.size() == 1)
		//----- _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkKjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			vIsJoint.back() = TRUE;
			vIsJoint.push_back(TRUE);
		} else
		//----- _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkKiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (lControl != 0)
			//----- _xZkqqHx_iNmFiPiJiCmMiDhIiDfHiDeGiLmIjApMiDfKiDePiDiBiDjDiDgHiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				const FCBezierControls& bcPrev = vControls[lControl - 1];
				if (almosteq(bcPrev.C(), bcPrev.D()))
				//----- _xZkqqHx_jBePiCmMiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCgCiCkKiCgDiCmJjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
				{
					vIsJoint.back() = TRUE;
				} else
				if (almosteq(bc.A(), bc.B()))
				//----- _xZkqqHx_iNkBiCmMiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCgBiCkKiCgAiCmJjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
				{
					vIsJoint.back() = TRUE;
				} else
				{
					DBLPoint mmptS;
					if (about0(CalcPowDistance(mmptS, bcPrev.C(), bc.B(), bc.A())))
					//----- _xZkqqHx_iNkBiCmMiDhIiDfHiDeGiLmIjApMiCmMjDfPiCgAiCmMjBePiMoDiCmMjAkHiMoEjDfPiCkKiIoKjClMjApMiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
					{
						vIsJoint.back() = TRUE;
					}
				}
			}
			BYTEVector vIsJointTmp(vmmptPointTmp.size(), FALSE);
			vIsJoint.insert(vIsJoint.end(), vIsJointTmp.begin(), vIsJointTmp.end());
		}
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	vIsJoint.back() = TRUE;
} // FFCalcBezier.

//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPjEhKjHpBiCkJiCoHiBeBjBfDiCmEiCmMjAkHiMoEjDfPiCmJiKePjAnKiClHiCoJiLoJiMgAjHmMiIoGiCpA_xHqqkZx_
 *			_xZkqqHx_iOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrt	:_xZkqqHx_iLoJiMgAjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
 *			lCount	:_xZkqqHx_jAkHiMoEjDfPiNmAjFfHjEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bcs		:_xZkqqHx_jAkHiMoEjDfPiNmAjFfHjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCalcFrame (DBLRect& mmrt, long lCount, const FCBezierControls bcs[])
{
	mmrt.SetRect(DBL_MAX, DBL_MAX, -DBL_MAX, -DBL_MAX);
	for (long l = 0; l != lCount; l++)
	{
		for (long ll = 0; ll != 4; ll++)
		{
			SmallerOrLarger(mmrt.left, mmrt.right, bcs[l].m_mmptControl[ll].x);
			SmallerOrLarger(mmrt.top, mmrt.bottom, bcs[l].m_mmptControl[ll].y);
		}
	}
} // FFCalcFrame.
//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.12.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetStdElemLen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FFCalcBezier_xZkqqHx_iCmIiCmHiCmFiOgHiCoNiCoKiCoJiBeBiLmIjApMiCmMiDhMiDiKiDiJiDeDiDjDiOoGjDlOiOjOiCmMjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iKoOiPiAiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jClIjDfPiKnEiCmMiKoOiPiAiLjHjHkDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJoGjGmKiCmMiDfJiBfLiDiAiCmIiCmHiCmJiKnGiMfHiCmIiCkCiCmGiClBiCoLiCmFjHhAiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfJiBfLiDiAiCpAiInDiOkPiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_lg2mm(g_->lgdPrecision) _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FFGetStdElemLen ()
{
	return lg2mm(FD_STD_PRECISION, g_->dDisplayPPM);
} // FFGetStdElemLen.
//----- 06.12.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCkJiCoHiBeBiDhMiDiKiDiJiDeDiDjDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjClIjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bc			:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmWeight	:_xZkqqHx_iLmIjApMiCmMjBlOiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtClip	:_xZkqqHx_iDeOiDiKiDgCiDhGjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lClipSize	:mmrtClip_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkKjClMjApMiCmMiPoKiNiHiBeBiIlNiCkCiCmNiDeOiDiKiDgCiDhGiKePiCmMiPoKiNiHiCmNiBeB_xHqqkZx_vmmptPoint_xZkqqHx_iCmJ_xHqqkZx_
 *			_xZkqqHx_jApMjFkKiCmMiOgOjDfPiCmGiPeJjDfPiCmMiCfBjDfPiCkKjAnNjCoIiClDiCoKiCoJiBeCiLmIjApMiCmMiPoKiNiHiCmNiBeBiNmFjCoBiCmFiCoA_xHqqkZx_
 *			_xZkqqHx_iCfIiCmCiCmMjDfPiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCalcBezier (	DBLPointVector& vmmptPoint,
					const FCBezierControls& bc,
					mmetol mmWeight,
					mmetol mmElemLen,
					const DBLRect* mmrtClip,
					long lClipSize)
{
	vmmptPoint.clear();
	// _xZkqqHx_iDhMiDiKiDfDiDjDiMhGiOfKiCkKiPmIjHkKiJmCjEfMiCkJiBeI_xHqqkZx_
	BOOL bIsOmit = FALSE;
	if (lClipSize != 0)
	//----- _xZkqqHx_iMhGiOfKjHmMiIoGiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iCfDjDfPiNmAjFfHiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiMhGiOfKiBeC_xHqqkZx_
		DBLRect mmrtStone;
		::FFCalcFrame(mmrtStone, 4, bc.m_mmptControl);
		// _xZkqqHx_iKePjAnKiLoJiMgAiCpAjApMjFjNiClOiCkPiNeMiClAiCoJiBeC_xHqqkZx_
		mmrtStone.Extend(mmWeight / 2.0);
		//----- _xZkqqHx_iCfDjDfPiNmAjFfHiKePjAnKiLoJiMgAiCmGiDiKiBfLiDfHiDiHiDjDiCkKiPgEiCmIiCoJiCkJjClCiCnHiCoJ_xHqqkZx_ -----
		bIsOmit = TRUE;
		for (long lClip = 0; lClip != lClipSize; lClip++)
		{
			if (!(mmrtStone & mmrtClip[lClip]).IsRectEmpty())
			//----- _xZkqqHx_iPgEiCmIiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				bIsOmit = FALSE;
				break;
			}
		}
	}
	// _xZkqqHx_iCfDjDfPiNmAjFfHiCmMjBePiIpIjDfPiBeFiMoDiIpIjDfPiCkKiCePiCmMiPoKiNiHiCmNiPmIjHkKiBeC_xHqqkZx_
	if (!bIsOmit &&
		almosteq(bc.A(), bc.B()) && almosteq(bc.C(), bc.D()))
		bIsOmit = TRUE;

	// _xZkqqHx_iCfDjDfPiNmAjFfHiCmMjBePiIpIjDfPiBeFiMoDiIpIjDfPiCkKjHlMjCfLiCmMjIeBiMiLjDfPiCmMiKnEiCmJiCkAiCoJiPoKiNiHiCmNiPmIjHkKiBeC_xHqqkZx_
	if (!bIsOmit &&
		almost0(CalcPowDistance(DBLPoint(), bc.A(), bc.D(), bc.B())) &&
		almost0(CalcPowDistance(DBLPoint(), bc.A(), bc.D(), bc.C())))
		bIsOmit = TRUE;

	if (bIsOmit)
	//----- _xZkqqHx_iDhIiDfHiDeGiLmIjApMiMhGiOfKiPmIjHkK_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_)_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		vmmptPoint.push_back(bc.A());
		vmmptPoint.push_back(bc.D());
	} else
	//----- _xZkqqHx_iDhIiDfHiDeGiLmIjApMiMhGiOfKiCkKjFeLjHhGiCmIiPoKiNiH_xHqqkZx_ -----
	{
		//----------------------------------------------------
		// _xZkqqHx_iCnMiClIjCfEiNlIjHhAiCmJiCfHjFkKiKiEiCmMiDhIiDfHiDeGiCpAjFgAiCkLiBeBiCfHjFnDiCmMiNiHiMhGjClHiCpA_xHqqkZx_
		// _xZkqqHx_iKoOiPiAiCmJjFkKiKiEjAjEiCpAiMiIjCoIiClHiCoJiBeC_xHqqkZx_
		//----------------------------------------------------
		// _xZkqqHx_jCfEiNlIjHhAiCfHjFkKiKiEiDhIiDfHiDeGiCpAiMhGiOfKiBeC_xHqqkZx_
		DBLPointVector vmmptPolyTest;	// _xZkqqHx_jClCiNlIjHhAjClIjDfPiNmAjFfHjEhKjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
		DrawBezierFast2(vmmptPolyTest, bc.m_mmptControl, 8);
		vmmptPolyTest.insert(vmmptPolyTest.begin(), bc.A());
		mmetol mmTestLen = 0.0;
		for (long lC = 0; lC != vmmptPolyTest.size() - 1; lC++)
			mmTestLen += (vmmptPolyTest[lC + 1] - vmmptPolyTest[lC]).Len();
		ASSERT(!almost0(mmElemLen));
		long lSplit = D2L(mmTestLen / mmElemLen);
		// _xZkqqHx_iNmFjCoBjFkKiKiEjAjEiCpAiCfHiCmJiClHiCoJiBeCiClBiCoKiImIiJlKiCmJiCmIiCoJiCmGiBeB_xHqqkZx_ObjPoly_xZkqqHx_iCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiMhGiOfKiOjOjDjJiCmJjFhDjDhDiNiHiCkKjAlGiClGiCoJiBeC_xHqqkZx_
		if (lSplit < 8) lSplit = 8;
		// _xZkqqHx_iNmFjBoFjFkKiKiEjAjEiCpA_xHqqkZx_200_xZkqqHx_iCmJiClHiCoJiBeCjBoFiCkLiClHiCkMiCoJiCmGjFgAiJoGiCmJiOjOiKnEiCkKiCkJiCkJiCmBiClNiCoIiBeB_xHqqkZx_DrawBezierFast2_xZkqqHx_iCmM_xHqqkZx_short_xZkqqHx_iMfOiCmJjFmPiKlHiCmFiCkLiCmIiCkCiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
		if (200 < lSplit) lSplit = 200;
		// _xZkqqHx_jAlDiOkOiCmIiDhIiDfHiDeGiMhGiOfKiBeC_xHqqkZx_
		DrawBezierFast2(vmmptPoint, bc.m_mmptControl, short(lSplit));
		// DrawBezierFast2_xZkqqHx_iKnGjAjEiCmNiOgOjDfPiCpAiNoMjAkMiClFiCmIiCkCiClNiCnPiBeBiOgOjDfPiCpAjBhNjDpMiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		vmmptPoint.insert(vmmptPoint.begin(), bc.A());
	}
} // FFCalcBezier.

//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetBezierAcceleration
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	bc_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiCoJiDhIiDfHiDeGiLmIjApMiCmMiBeBiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJiJmBjBkMjDhIiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bc	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dT	:_xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJiJmBjBkMjDhIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiOkOiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3
 *			_xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJiJmBjBkMjDhIiCmNiBeBiDhIiDfHiDeGiLmIjApMiCmMiOkOiCmMjDpBiKeLjDlBiKnGjAjEiCmFiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *			P' = -3*(A - B) + 6*(A - 2*B + C)*t - 3*(A - 3*B + 3*C - D)*t^2
 *			P'' = 6*(A - 2*B + C) - 6*(A - 3*B + 3*C - D)*t
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FFGetBezierAcceleration (const FCBezierControls& bc, double dT)
{
	return 6.0*(bc.A() - 2.0*bc.B() + bc.C()) - 6.0*(bc.A() - 3.0*bc.B() + 3.0*bc.C() - bc.D())*dT;
} // FFGetBezierAcceleration.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetBezierAngle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	bc_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiCoJiDhIiDfHiDeGiLmIjApMiCmMiBeBiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJiKhAjDhIiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bc	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dT	:_xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJiKhAjDhIiBeCiKhAjDhIiCmNiBeB_xHqqkZx_[0.0, 2.0)_xZkqqHx_iCmMjEmNiImNiBeC_xHqqkZx_
 *			_xZkqqHx_jCfAiImKiCmN_xHqqkZx_ _xZkqqHx_iDiJiDfHiDeBiDjDiBfOiDmO_xHqqkZx_ _xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJiKhAjDhIiCmNiBeBiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJjBkMjDhIiCmMiMpMiCkLiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJjBkMjDhIiCkK_xHqqkZx_0_xZkqqHx_iCmFiCkAiCoJiPoKiNiHiCmNiBeBiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJiJmBjBkMjDhIiCmMiMpMiCkLiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJiCkIiCkPiCoJjBkMjDhIiBeBiJmBjBkMjDhIiCmNiBeBiClLiCoKiClMiCoKjDlBiKnGjAjEiCmGjDpBiKeLjDlBiKnGjAjEiCmF_xHqqkZx_
 *			_xZkqqHx_iLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FFGetBezierAngle (const FCBezierControls& bc, double dT)
{
	DBLPoint mmptV = FFGetBezierVelocity(bc, dT);
	if (about0(mmptV))
		mmptV = FFGetBezierAcceleration(bc, dT);
	if (about0(mmptV))
		FFThrowMiscUnknown();
	return ArcTan(mmptV);
} // FFGetBezierAngle.
//----- 06.10.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
