
#include "stdafx.h"

#include "RegData.h"	// For g_pReg.
#include "UtilMisc.h"	// For FFVersionInfo.etc.
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "UtilMath.h"	// For POW2.
#include "UtilCoord.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MAX_COORD_WIN95	30000	// 95_xZkqqHx_iMgO_xHqqkZx_OS_xZkqqHx_iCmMiNmAjFfHjCgMiCmMiNmFjBoFiBgJiNmFiPkNiBgKjCgMiBeCjGhLjDjGiCmN_xHqqkZx_32768_xZkqqHx_iBeC_xHqqkZx_
								// _xZkqqHx_iDeNiDiKiDeNiDiKiCmMjCgMiCpAiCmGiCoJiCmGiBeBiCkEiCnMiCkNjDkOiNoMiClFiCmIiCkCiBeC_xHqqkZx_

hic mm2hi (mmetol mm)
{
	return (mm / g_pReg->GetUnitCoeff());
} // mm2hi (mmetol mm).

//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mm22hi2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlNjFpL_xHqqkZx_mm(mm x mm)_xZkqqHx_iCpA_xHqqkZx_HI_xZkqqHx_iNmAjFfHiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mm2	:_xZkqqHx_jFlNjFpL_xHqqkZx_mm_xZkqqHx_iCmMjGmKjAmPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	HI_xZkqqHx_iNmAjFfHiCmMjGmKjAmPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double mm22hi2 (double mm2)
{
	return (mm2 / POW2(g_pReg->GetUnitCoeff()));
} // mm22hi2 (double mm2).
//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

hixc mm2hix (mmetol mm)
{
	return D2LL(g_pReg->GetUnitToHixCoeff() * mm / g_pReg->GetUnitCoeff());
} // mm2hix.

mmetol hi2mm (hic hi)
{
	return (hi * g_pReg->GetUnitCoeff());
} // hi2mm (hic hi).

mmetol hix2mm (hixc hix)
{
	 return (mmetol(hix) / g_pReg->GetUnitToHixCoeff()) * g_pReg->GetUnitCoeff();
} // mm2hix.

//----- _xZkqqHx_jIfPjHjNiNmAjFfHiCkJiCoH_xHqqkZx_HI_xZkqqHx_iNmAjFfHiCnG_xHqqkZx_ -----
hic lg2hi (long a, double dZoom)
{
	return (double(a) / dZoom) / g_pReg->GetUnitCoeff();
} // lg2hi.

//----- HI_xZkqqHx_iNmAjFfHiCkJiCoHjIfPjHjNiNmAjFfHiCnG_xHqqkZx_ -----
long hi2lg (hic a, double dZoom)
{
	return D2L(dZoom * (a * g_pReg->GetUnitCoeff()));
} // hi2lg.

hixc hi2hix (hic hi)
{
	return D2LL(g_pReg->GetUnitToHixCoeff() * (hi));
} // hi2hix (hic hi).

hic hix2hi (hixc hix)
{
	return (hic(hix) / g_pReg->GetUnitToHixCoeff());
} // hix2hi (hixc hix).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLimitCoord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmAjFfHjCgMiCpAiBeB_xHqqkZx_95_xZkqqHx_iMgO_xHqqkZx_OS_xZkqqHx_iCmMiNmAjFfHjCgMiCmMiNmFjBoFiBgJiNmFiPkNiBgKjCgMiCmJjAkHiMmAiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
 *			_xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	c	:_xZkqqHx_iNmAjFfHjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiMoDiCmMiNmAjFfHjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.07.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline long FFLimitCoord (long c)
{
	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
	//----- NT_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		return c;
	} else
	//----- 95_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		if (c < -MAX_COORD_WIN95)
			return -MAX_COORD_WIN95;
		else if (MAX_COORD_WIN95 < c)
			return MAX_COORD_WIN95;
		else
			return c;
	}
} // FFLimitCoord (long c).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLimitCoord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FFLimitCoord _xZkqqHx_iKnGjAjEiCmMjEhKjHpBjEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	apt	:_xZkqqHx_jEhKjHpBiCpAiOhHjCoIiBeCjCgMiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *			sz	:apt_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.07.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline void FFLimitCoord (CPoint apt[], long sz)
{
	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
	//----- 95_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		for (long lC = 0; lC < sz; lC++)
		{
			if (apt[lC].x < -MAX_COORD_WIN95)
				apt[lC].x = -MAX_COORD_WIN95;
			else if (MAX_COORD_WIN95 < apt[lC].x)
				apt[lC].x = MAX_COORD_WIN95;
			if (apt[lC].y < -MAX_COORD_WIN95)
				apt[lC].y = -MAX_COORD_WIN95;
			else if (MAX_COORD_WIN95 < apt[lC].y)
				apt[lC].y = MAX_COORD_WIN95;
		}
	}
} // FFLimitCoord (CPoint[] apt, long sz).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSnapMP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOmAiNmAjFfHiCpAiDfIiDgJiDgCiDhGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmX		:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiMoDiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *					 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmY		:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiMoDiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *					 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			alpha	:_xZkqqHx_iDfIiDgJiDgCiDhGiKnEiKhFiCmJiKhMiCkPiCoJiMfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.23 Fukushiro M. _xZkqqHx_iDeMiBfLiPoOjFpBiCpAiIpIjAjEiCkJiCoHiNoNiPjM_xHqqkZx_.
 *			05.03.02 Fukushiro M. CFCDynamicDrawView_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void FFSnapMP (mmetol* mmX, mmetol* mmY)
{
	if (!g_pReg->GetIsSnap()) return;
	// _xZkqqHx_iDeJiDiLiDgHiDeMiBfLiJjPiClFiBeI_xHqqkZx_
	const BOOL bAlt = GetKeyState(VK_MENU) < 0;
	double alpha = bAlt ? 0.1 : 1.0;

	if (mmX != NULL && !almost0(g_pReg->GetSnapInterval().x))
	//----- _xZkqqHx_iDfIiDgJiDgCiDhGiKnEiKhFiCkKiCePiCmFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		const mmetol mmSnap = alpha * g_pReg->GetSnapInterval().x;
		ASSERT(0 < mmSnap);
		*mmX = D2L(*mmX / mmSnap) * mmSnap;
	}
	if (mmY != NULL && !almost0(g_pReg->GetSnapInterval().y))
	//----- _xZkqqHx_iDfIiDgJiDgCiDhGiKnEiKhFiCkKiCePiCmFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		const mmetol mmSnap = alpha * g_pReg->GetSnapInterval().y;
		ASSERT(0 < mmSnap);
		*mmY = D2L(*mmY / mmSnap) * mmSnap;
	}
} // FFSnapMP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSnapMP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOmAiNmAjFfHiCpAiDfIiDgJiDgCiDhGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt	:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiMoDiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			alpha	:_xZkqqHx_iDfIiDgJiDgCiDhGiKnEiKhFiCmJiKhMiCkPiCoJiMfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.23 Fukushiro M. _xZkqqHx_iDeMiBfLiPoOjFpBiCpAiIpIjAjEiCkJiCoHiNoNiPjM_xHqqkZx_.
 *			05.03.02 Fukushiro M. CFCDynamicDrawView_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void FFSnapMP (DBLPoint& mmpt)
{
	FFSnapMP(&mmpt.x, &mmpt.y);
} // FFSnapMP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSnapMP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHiCpAiDfIiDgJiDgCiDhGjFmPiKlHiClHiCoJiBeCjFmPiKlHiMoDiCmMjCgMiCmNiBeBjFmPiKlHjBePiCmG_xHqqkZx_
 *			_xZkqqHx_jDjJiClFiCkCiCkJjBoFiCkLiCkNiCmIiCmBiCmEiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmX		:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiMoDiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *					 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmY		:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiMoDiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *					 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSnapGeMP (mmetol* mmX, mmetol* mmY)
{
	mmetol mmXOrg;
	mmetol mmYOrg;
	if (mmX != NULL) mmXOrg = *mmX;
	if (mmY != NULL) mmYOrg = *mmY;
	FFSnapMP(mmX, mmY);
	if (mmX != NULL)
	{
		if (*mmX < mmXOrg)
			*mmX += g_pReg->GetSnapInterval().x;
	}
	if (mmY != NULL)
	{
		if (*mmY < mmYOrg)
			*mmY += g_pReg->GetSnapInterval().y;
	}
} // FFSnapMP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSnapMoveMP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFpLiMpMiCmJiBeBiNmAjFfHiCpAiDfIiDgJiDgCiDhGjCfAiImKiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmX				:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiMoDiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmY				:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiMoDiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lHorzDirection	:_xZkqqHx_jAiFjFlNjFpLiMpMiCmMiInKjDkOjHmKiCpAiOhHjCoIiClHiCoJiBeCjCmKiPoNiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_0_xZkqqHx_iBeB_xHqqkZx_+1_xZkqqHx_iBeC_xHqqkZx_
 *			lVertDirection	:_xZkqqHx_jAiCjClMjFpLiMpMiCmMiInKjDkOjHmKiCpAiOhHjCoIiClHiCoJiBeCjCmKiPoNiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_0_xZkqqHx_iBeB_xHqqkZx_+1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ALT_xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiInKjDkOiClHiCoJiPoKiNiHiCmNiInKjDkOjHmKiCkKjAjEjFkKiCmMiCfAiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSnapMoveMP (mmetol* mmX, mmetol* mmY, long lHorzDirection, long lVertDirection)
{
	// _xZkqqHx_iDeJiDiLiDgHiDeMiBfLiJjPiClFiBeI_xHqqkZx_
	const BOOL bAlt = GetKeyState(VK_MENU) < 0;
	double alpha = bAlt ? 0.1 : 1.0;
	if (mmX != NULL)
	{
		double mmDX = alpha * double(lHorzDirection) * g_pReg->GetSnapInterval().x;
		// _xZkqqHx_jAfGiClFiCkCjFjEjFgJiImKjChFiCpAiJlMiMiIiCnPiBeC_xHqqkZx_
		mmetol mmNewX = *mmX + mmDX;
		// _xZkqqHx_jAfGiClFiCkCjFjEjFgJiImKjChFiCpAiDfIiDgJiDgCiDhGiBeC_xHqqkZx_
		FFSnapMP(&mmNewX, NULL);
		if (lHorzDirection != 0) *mmX = mmNewX;
	}
	if (mmY != NULL)
	{
		double mmDY = alpha * double(lVertDirection) * g_pReg->GetSnapInterval().y;
		// _xZkqqHx_jAfGiClFiCkCjFjEjFgJiImKjChFiCpAiJlMiMiIiCnPiBeC_xHqqkZx_
		mmetol mmNewY = *mmY + mmDY;
		// _xZkqqHx_jAfGiClFiCkCjFjEjFgJiImKjChFiCpAiDfIiDgJiDgCiDhGiBeC_xHqqkZx_
		FFSnapMP(NULL, &mmNewY);
		if (lVertDirection != 0) *mmY = mmNewY;
	}
} // FFSnapMoveMP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSnapMoveMP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFpLiMpMiCmJiBeBiNmAjFfHiCpAiDfIiDgJiDgCiDhGjCfAiImKiCmFiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt			:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiMoDiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			lHorzDirection	:_xZkqqHx_jAiFjFlNjFpLiMpMiCmMiInKjDkOjHmKiCpAiOhHjCoIiClHiCoJiBeCjCmKiPoNiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_0_xZkqqHx_iBeB_xHqqkZx_+1_xZkqqHx_iBeC_xHqqkZx_
 *			lVertDirection	:_xZkqqHx_jAiCjClMjFpLiMpMiCmMiInKjDkOjHmKiCpAiOhHjCoIiClHiCoJiBeCjCmKiPoNiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_0_xZkqqHx_iBeB_xHqqkZx_+1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ALT_xZkqqHx_iDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiInKjDkOiClHiCoJiPoKiNiHiCmNiInKjDkOjHmKiCkKjAjEjFkKiCmMiCfAiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSnapMoveMP (DBLPoint& mmpt, long lHorzDirection, long lVertDirection)
{
	FFSnapMoveMP(&mmpt.x, &mmpt.y, lHorzDirection, lVertDirection);
} // FFSnapMoveMP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLimitMP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Ctrl&Shift_xZkqqHx_iDeMiBfLiCmFiInKjDkOiNmAjFfHiCpAjFmPiKlHiClHiCoJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *			_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P230.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMov	: _xZkqqHx_iInKjDkOiNmAjFfH_xHqqkZx_._xZkqqHx_jFmPiKlHjBePiCmMiNmAjFfHiCpAiOpDiOoGiCoIiBeBjFmPiKlHiMoDiCmMiNmAjFfHiCpAjFnEiClH_xHqqkZx_.
 *			nFlags	: _xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiDhLiBfLiDgIiCmMiPoOjFpB_xHqqkZx_.
 *			mptFix	: _xZkqqHx_iMmFjCoIiNmAjFfH_xHqqkZx_.
 *			mmlnAry	: _xZkqqHx_iInKjDkOiNmAjFfHiCkKiInKjDkOiCmFiCkLiCoJjClMjApMiCmMjEhKjHpB_xHqqkZx_.
 *			iArySz	: mmlnAry_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.03.02 Fukushiro M. CFCDynamicDrawView_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void FFLimitMP (DBLPoint& mmptMov,
				UINT nFlags,
				const DBLPoint& mmptFix,
				const DBLLine mmlnAry[],
				int iArySz)
{
	// _xZkqqHx_iNmFiPiJiCmMiDhNiDeFiDfIiNmAjFfHiCpAjFnLjBlGiBeC_xHqqkZx_
	const DBLPoint mmptOrg = mmptMov;
	// _xZkqqHx_iCnMiClIiBeBiDfIiDgJiDgCiDhGjFmPiKlHiBeC_xHqqkZx_
	FFSnapMP(mmptMov);
	// _xZkqqHx_jClMjApMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeB_xHqqkZx_.
	if (iArySz <= 0) return;
	// _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCkKiJjPiClDiCoKiCmEiCmIiCkPiCoKiCmOjFjMiLeB_xHqqkZx_.
	if (!(nFlags & MK_SHIFT)) return;

	/*----- mmlnAry_xZkqqHx_iCmMjCiGiCkJiCoH_xHqqkZx_mmptOrg_xZkqqHx_iCmJiNmFiCoAiLnPiCkCjClMjApMiCpAjBeJiCnE_xHqqkZx_ -----*/
	double	mmLen2;
	DBLLine	mmlnTarget = mmlnAry[0];
	double	mmLen2Min = (mmlnAry[0].GetNearest(mmptOrg) - mmptOrg).PowLen();
	for (int iC = 1; iC < iArySz; iC++)
	{
		// _xZkqqHx_jClMjApMiCmG_xHqqkZx_mmptOrg_xZkqqHx_iCmMiLjHjHkDiCmMjDpBiPoGiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
		mmLen2 = (mmlnAry[iC].GetNearest(mmptOrg) - mmptOrg).PowLen();
		// _xZkqqHx_iLjHjHkDiCmMjDpBiPoGjCgMiCpAiOgHiCmBiCmEiBeB_xHqqkZx_mmptOrg_xZkqqHx_iCmGiCmMiLjHjHkDiCkKiNmFiCoAiLnPiCkCjClMjApMiCpAjBeJiCnEiBeC_xHqqkZx_
		if (mmLen2 < mmLen2Min)
		{
			mmlnTarget = mmlnAry[iC];
			mmLen2Min = mmLen2;
		}
	}
	//----- _xZkqqHx_iImIiNhOiCmMiPiIjHjNiCmFiCmNjClMjApM_xHqqkZx_ mmlnTarget _xZkqqHx_iCpAiOgHjHhA_xHqqkZx_ -----

	// _xZkqqHx_jClMjApMiCkKjAiCjClMiCmMiOjOiBeC_xHqqkZx_
	if (mmlnTarget.IsVertical())
	{
		// x_xZkqqHx_jCgMiCpAjAnNjCoIiBeC_xHqqkZx_x_xZkqqHx_iCmN_xHqqkZx_y_xZkqqHx_iCmMjCgMiCmJiKnGiMfHiCmIiCkNiIoKjCoIiBeC_xHqqkZx_
		mmptMov.x = mmlnTarget.GetX(0);
		return;
	}
	// _xZkqqHx_jClMjApMiCkKjAiFjFlNiCmMiOjOiBeC_xHqqkZx_
	if (mmlnTarget.IsHorizontal())
	{
		// y_xZkqqHx_jCgMiCpAjAnNjCoIiBeC_xHqqkZx_y_xZkqqHx_iCmN_xHqqkZx_x_xZkqqHx_iCmMjCgMiCmJiKnGiMfHiCmIiCkNiIoKjCoIiBeC_xHqqkZx_
		mmptMov.y = mmlnTarget.GetY(0);
		return;
	}

	/*----- mmptOrg_xZkqqHx_iCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHiCmG_xHqqkZx_y_xZkqqHx_iNmAjFfHiCmMiCmHiClPiCoHiCpAjAlGiCkJiClHiCkJiCpAiMiIjCoI_xHqqkZx_ -----*/
	double mmEvalChangeX;
	double mmNewMov_x = mmlnTarget.GetX(mmptOrg.y);
	if ((mmNewMov_x <= mmptOrg.x && mmptOrg.x <= mmptFix.x) ||
		(mmptFix.x <= mmptOrg.x && mmptOrg.x <= mmNewMov_x))
	{
		mmEvalChangeX = 0.0;
	} else
	{
		mmEvalChangeX = fabs(mmptOrg.x - mmNewMov_x);
		if (fabs(mmptOrg.x - mmptFix.x) < mmEvalChangeX)
			mmEvalChangeX = fabs(mmptOrg.x - mmptFix.x);
	}

	double mmEvalChangeY;
	double mmNewMov_y = mmlnTarget.GetY(mmptOrg.x);
	if ((mmNewMov_y <= mmptOrg.y && mmptOrg.y <= mmptFix.y) ||
		(mmptFix.y <= mmptOrg.y && mmptOrg.y <= mmNewMov_y))
	{
		mmEvalChangeY = 0.0;
	} else
	{
		mmEvalChangeY = fabs(mmptOrg.y - mmNewMov_y);
		if (fabs(mmptOrg.y - mmptFix.y) < mmEvalChangeY)
			mmEvalChangeY = fabs(mmptOrg.y - mmptFix.y);
	}
	// x,y_xZkqqHx_iCmMjFfNiJlPjCgMiCmMjHmHiCkCiBgJjCoBiCkCiBgKjFpLiCpAiNmMjHhAiBeC_xHqqkZx_
	if (mmEvalChangeX < mmEvalChangeY)
		mmptMov.x = mmlnTarget.GetX(mmptMov.y);
	else
		mmptMov.y = mmlnTarget.GetY(mmptMov.x);
} // FFLimitMP.

