#ifndef __UtilCoord_h
#define __UtilCoord_h

/************************** _xZkqqHx_iNmAjFfHiMgOjFmPiKlH_xHqqkZx_ ************************/

// _xZkqqHx_iDfJiBfLiDiAiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_SDK_xZkqqHx_iMpGiKeKjHhAiBeC_xHqqkZx_
inline double GetZoom100 () { return g_->dDisplayPPM; }
inline double GetCurrentZoom () { return g_->dZoom; }

//----- _xZkqqHx_iOmAiNmAjFfHiCkJiCoHjIfPjHjNiNmAjFfHiCnG_xHqqkZx_ -----

// _xZkqqHx_iDfIiDeKiDiJiBfLjCgMiCmMjFmPiKlHiBeC_xHqqkZx_
inline long mm2lg (double a, double dZoom = g_->dZoom) { return D2L(dZoom * a); }

// _xZkqqHx_iDhMiDeDiDjDiDgHiMfOiCmMjFmPiKlHiBeC_xHqqkZx_
inline CPoint mm2lg (const DBLPoint& dpnt, double dZoom = g_->dZoom)
	{
		return CPoint(mm2lg(dpnt.x, dZoom), mm2lg(dpnt.y, dZoom));
	}

// _xZkqqHx_iLoJiMgAiMfOiCmMjFmPiKlHiBeC_xHqqkZx_
inline CRect mm2lg (const DBLRect& drct, double dZoom = g_->dZoom)
	{
		return CRect(mm2lg(drct.left, dZoom), mm2lg(drct.top, dZoom),
					 mm2lg(drct.right, dZoom), mm2lg(drct.bottom, dZoom));
	}

// _xZkqqHx_iDhMiDeDiDjDiDgHiDhIiDeOiDfOiBfLiCmMjFmPiKlHiBeC_xHqqkZx_
inline void mm2lg (CPointVector& vlgpt, const DBLPointVector& vmmpt, double dZoom = g_->dZoom)
	{
		vlgpt.assign(vmmpt.size());
		for (long lC = 0; lC < vmmpt.size(); lC++)
			vlgpt[lC] = mm2lg(vmmpt[lC], dZoom);
	}

// _xZkqqHx_jEhKjHpBiCmMjFmPiKlHiBeCiDhMiDeDiDjDiDgHjEhKjHpBiBeBiDfIiDeKiDiJiBfLjEhKjHpBjDjJiBeC_xHqqkZx_
template<class LG, class MM>
void mm2lg (LG lga[], const MM mma[], long sz, double dZoom = g_->dZoom)
	{
		for (sz--; 0 <= sz; sz--) lga[sz] = mm2lg(mma[sz], dZoom);
	}

//----- _xZkqqHx_jIfPjHjNiNmAjFfHiCkJiCoHiOmAiNmAjFfHiCnG_xHqqkZx_ -----

// _xZkqqHx_iDfIiDeKiDiJiBfLjCgMiCmMjFmPiKlHiBeC_xHqqkZx_
inline double lg2mm (long a, double dZoom = g_->dZoom)
	{
		return static_cast<double>(a) / dZoom;
	}

// _xZkqqHx_iDhMiDeDiDjDiDgHiMfOiCmMjFmPiKlHiBeC_xHqqkZx_
inline DBLPoint lg2mm (const CPoint& pnt, double dZoom = g_->dZoom)
	{
		return DBLPoint(static_cast<double>(pnt.x) / dZoom,
						static_cast<double>(pnt.y) / dZoom);
	}

// _xZkqqHx_iDfEiDeDiDfJiMfOiCmMjFmPiKlHiBeC_xHqqkZx_
inline DBLPoint lg2mm (const CSize& sz, double dZoom = g_->dZoom)
	{
		return DBLPoint(static_cast<double>(sz.cx) / dZoom,
						static_cast<double>(sz.cy) / dZoom);
	}

// _xZkqqHx_iLoJiMgAiMfOiCmMjFmPiKlHiBeC_xHqqkZx_
inline DBLRect lg2mm (const CRect& rct, double dZoom = g_->dZoom)
	{
		return DBLRect(	static_cast<double>(rct.left) / dZoom,
						static_cast<double>(rct.top) / dZoom,
						static_cast<double>(rct.right) / dZoom,
						static_cast<double>(rct.bottom) / dZoom);
	}

// _xZkqqHx_iDhMiDeDiDjDiDgHiDhIiDeOiDfOiBfLiCmMjFmPiKlHiBeC_xHqqkZx_
inline void lg2mm (DBLPointVector& vmmpt, const CPointVector& vlgpt, double dZoom = g_->dZoom)
	{
		vmmpt.assign(vlgpt.size());
		for (long lC = 0; lC < vlgpt.size(); lC++)
			vmmpt[lC] = lg2mm(vlgpt[lC], dZoom);
	}

// _xZkqqHx_jEhKjHpBiCmMjFmPiKlHiBeCiDhMiDeDiDjDiDgHjEhKjHpBiBeBiDfIiDeKiDiJiBfLjEhKjHpBjDjJiBeC_xHqqkZx_
template<class LG, class MM>
void lg2mm (MM mma[], const LG lga[], long sz)
	{
		for (sz--; 0 <= sz; sz--) mma[sz] = lg2mm(lga[sz]);
	}

//----- TWIPS_xZkqqHx_iNmAjFfHiCkJiCoH_xHqqkZx_POINT_xZkqqHx_iNmAjFfHiCnG_xHqqkZx_ -----
#define tw2pnt(a) (static_cast<double>(a) / 20.0)

//----- POINT_xZkqqHx_iNmAjFfHiCkJiCoH_xHqqkZx_TWIPS_xZkqqHx_iNmAjFfHiCnG_xHqqkZx_ -----
#define pnt2tw(a) D2L((a) * 20.0)

//----- TWIPS_xZkqqHx_iNmAjFfHiCkJiCoHiOmAiNmAjFfHiCnG_xHqqkZx_ -----
#define tw2mm(a) (25.4 * static_cast<double>(a) / 1440.0)

//----- _xZkqqHx_iOmAiNmAjFfHiCkJiCoH_xHqqkZx_TWIPS_xZkqqHx_iNmAjFfHiCnG_xHqqkZx_ -----
#define mm2tw(a) D2L(1440.0 * (a) / 25.4)

//----- TWIPS_xZkqqHx_iNmAjFfHiCkJiCoHjIfPjHjNiNmAjFfHiCnG_xHqqkZx_ -----
inline long tw2lg (long tw, double dZoom = g_->dZoom)
{
	return D2L(dZoom * (25.4 * double(tw) / 1440.0));
} // tw2lg.

/*************************************************************************
 * <_xZkqqHx_jCoIiLgA_xHqqkZx_>	pnt2mm
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHiNmAjFfHjCgMiCkJiCoHiOmAiNmAjFfHjCgMiCnGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
#define pnt2mm(a) ((25.4 / 72.0) * (a))

/*************************************************************************
 * <_xZkqqHx_jCoIiLgA_xHqqkZx_>	pnt2lg
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHiNmAjFfHjCgMiCkJiCoHjIfPjHjNjFfHjCgMiCnGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline long pnt2lg (dblpnt a, double dZoom = g_->dZoom)
{
	return mm2lg(pnt2mm(a), dZoom);
} // pnt2lg.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mmown2real
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetDeviceCaps(LOGPIXELSX)_xZkqqHx_iCmJiKoOiCmDiCkCiClN_xHqqkZx_ mm _xZkqqHx_jCfAiImKiCpA_xHqqkZx_
 *			GetDeviceCaps(HORZRES) / GetDeviceCaps(HORZSIZE) _xZkqqHx_iCmJiKoOiCmDiCkCiClN_xHqqkZx_
 *			mm _xZkqqHx_jCfAiImKiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline DBLRect mmown2real (const DBLRect& mmrt)
{
	return mmrt * DBLPoint(g_->dDisplayPPM / g_->dRealDisplayPPMHorz,
							g_->dDisplayPPM / g_->dRealDisplayPPMVert);
} // mmown2real.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mmown2real
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetDeviceCaps(LOGPIXELSX)_xZkqqHx_iCmJiKoOiCmDiCkCiClN_xHqqkZx_ mm _xZkqqHx_jCfAiImKiCpA_xHqqkZx_
 *			GetDeviceCaps(HORZRES) / GetDeviceCaps(HORZSIZE) _xZkqqHx_iCmJiKoOiCmDiCkCiClN_xHqqkZx_
 *			mm _xZkqqHx_jCfAiImKiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline void mmown2real (mmetol& mmX, mmetol& mmY)
{
	mmX *= (g_->dDisplayPPM / g_->dRealDisplayPPMHorz);
	mmY *= (g_->dDisplayPPM / g_->dRealDisplayPPMVert);
} // mmown2real.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mmreal2own
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetDeviceCaps(HORZRES) / GetDeviceCaps(HORZSIZE) _xZkqqHx_iCmJiKoOiCmDiCkCiClN_xHqqkZx_
 *			mm _xZkqqHx_jCfAiImKiCpA_xHqqkZx_GetDeviceCaps(LOGPIXELSX)_xZkqqHx_iCmJiKoOiCmDiCkCiClN_xHqqkZx_ mm _xZkqqHx_jCfAiImKiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline DBLRect mmreal2own (const DBLRect& mmrt)
{
	return mmrt * DBLPoint(g_->dRealDisplayPPMHorz / g_->dDisplayPPM,
							g_->dRealDisplayPPMVert / g_->dDisplayPPM);
} // mmreal2own.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mmreal2own
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetDeviceCaps(HORZRES) / GetDeviceCaps(HORZSIZE) _xZkqqHx_iCmJiKoOiCmDiCkCiClN_xHqqkZx_
 *			mm _xZkqqHx_jCfAiImKiCpA_xHqqkZx_GetDeviceCaps(LOGPIXELSX)_xZkqqHx_iCmJiKoOiCmDiCkCiClN_xHqqkZx_ mm _xZkqqHx_jCfAiImKiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline void mmreal2own (mmetol& mmX, mmetol& mmY)
{
	mmX *= (g_->dRealDisplayPPMHorz / g_->dDisplayPPM);
	mmY *= (g_->dRealDisplayPPMVert/ g_->dDisplayPPM);
} // mmreal2own.

/*************************************************************************
 * <_xZkqqHx_jCoIiLgA_xHqqkZx_>	mm2pnt
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOmAiNmAjFfHjCgMiCkJiCoHiDhMiDeDiDjDiDgHiNmAjFfHjCgMiCnGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
#define mm2pnt(a) ((72.0 / 25.4) * (a))

/////////////////////////////////////////////////////////////////
// _xZkqqHx_iNmAjFfHjFmPiKlHiKnGjAjEiBeBiDhNiDeOiDiNiBeC_xHqqkZx_

//----- _xZkqqHx_iOmAiNmAjFfHiCkJiCoH_xHqqkZx_HI_xZkqqHx_iNmAjFfHiCnG_xHqqkZx_ -----
extern hic mm2hi (mmetol mm);

// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
extern double mm22hi2 (double mm2);

extern hixc mm2hix (mmetol mm);

//----- HI_xZkqqHx_iNmAjFfHiCkJiCoHiOmAiNmAjFfHiCnG_xHqqkZx_ -----
extern mmetol hi2mm (hic hi);

extern mmetol hix2mm (hixc hix);

//----- _xZkqqHx_jIfPjHjNiNmAjFfHiCkJiCoH_xHqqkZx_HI_xZkqqHx_iNmAjFfHiCnG_xHqqkZx_ -----
extern hic lg2hi (long a, double dZoom = g_->dZoom);

//----- HI_xZkqqHx_iNmAjFfHiCkJiCoHjIfPjHjNiNmAjFfHiCnG_xHqqkZx_ -----
extern long hi2lg (hic a, double dZoom = g_->dZoom);

extern hixc hi2hix (hic hi);

extern hic hix2hi (hixc hix);

//----- 02.07.21 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
extern long FFLimitCoord (long c);
extern void FFLimitCoord (CPoint apt[], long sz);
//----- 02.07.21 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----

//////////////////////////////////////////////////////////////////
// _xZkqqHx_iDfIiDgJiDgCiDhGiKnGjAjEiBeC_xHqqkZx_

extern void FFSnapMP (mmetol* mmX, mmetol* mmY);
extern void FFSnapMP (DBLPoint& mmpt);
extern void FFSnapGeMP (mmetol* mmX, mmetol* mmY);
extern void FFSnapMoveMP (mmetol* mmX, mmetol* mmY, long lHorzDirection, long lVertDirection);
extern void FFSnapMoveMP (DBLPoint& mmpt, long lHorzDirection, long lVertDirection);
extern void FFLimitMP (	DBLPoint& mmptMov,
						UINT nFlags,
						const DBLPoint& mmptFix,
						const DBLLine mmlnAry[],
						int iArySz);

#endif//__UtilCoord_h
