#ifndef __UtilFile_h
#define __UtilFile_h

//;----- <EXPORT TO SDK> -----;
typedef struct _stat struct_stat;

//;----- <EXPORT TO SERVER> -----;

// 06.02.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//class WString;
class FCFileBase;

//----- Historic Draw _xZkqqHx_iCmMiDgFiBfLiDhFiDiLiKnGjIeBiDhEiDeAiDeDiDiL_xHqqkZx_ -----
// DynamicServer.cpp _xZkqqHx_iCmMiDgFiBfLiDhFiDiLiDhEiDeAiDeDiDiLiNfMjBkCjAhNiCpAiOfBiPmGiBeC_xHqqkZx_
// _xZkqqHx_iDgFiBfLiDhFiDiLiDgGiBfLiDfOiCmMiKgHjCkDiOhBiBeC_xHqqkZx_
#define FDTBL_DATA_FILE_EXT			L".ddtb"
// _xZkqqHx_iDgFiBfLiDhFiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCmMiKgHjCkDiOhBiBeC_xHqqkZx_
#define FDTBL_INDEX_FILE_EXT		L".ddix"

// _xZkqqHx_iDgFiBfLiDhFiDiLiPiKjHeMiMkAiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiBeC_xHqqkZx_
#define FDTBL_LOCK_OWN_DIR_NAME		L".own"
// _xZkqqHx_iDgFiBfLiDhFiDiLiPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmMiKgHjCkDiOhBiBeC_xHqqkZx_
#define FDTBL_LOCK_OWN_FILE_EXT		L".k"

// _xZkqqHx_iDgFiBfLiDhFiDiLiJpAjFpKjHhGiLiBiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKjGlMiBeC_xHqqkZx_
#define FDTBL_LOCK_REQ_DIR_NAME		L".req"
// _xZkqqHx_iDgFiBfLiDhFiDiLiJpAjFpKjHhGiLiBiCmMiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
#define FDTBL_LOCK_REQ_FILE_NAME	L"x"

// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiJpBjFjMiDhEiDeAiDeDiDiLiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiBeC_xHqqkZx_
#define FDTBL_RECOVER_DIR_NAME		L".rcv"
// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiJpBjFjMiDhEiDeAiDeDiDiLiCmMiKgHjCkDiOhBiBeC_xHqqkZx_
#define FDTBL_RECOVER_FILE_EXT		L".m"


enum FTFileKind
{
	FD_FILE_NOT_EXIST = 0,	// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiBeC_xHqqkZx_
	FD_FILE_32,				// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
	FD_FILE_DIRECTORY,		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
	FD_FILE_LOCK,			// _xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
	FD_FILE_DIFF,			// _xZkqqHx_iNlHjFkKiDiNiDePiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
	FD_FILE_NONE,			// _xZkqqHx_jGkCjCoIiLgAiBeCiNmFiMoDiCmFiCkAiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
}; // enum FTFileKind.

struct FCHiFileFindData
{
	WString		m_wstrFileName;			// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
	FTFileKind	m_fileKind;				// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiOoNjHnOiBeC_xHqqkZx_
	WString		m_wstrDirectoryPath;	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiBeCiNmFiMoDiCmJ_xHqqkZx_'\\'_xZkqqHx_jFhEiCkLiBeC_xHqqkZx_
	HANDLE		m_hFindFile;			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfEiBfLiDgAiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	FTFileKind	m_fileKindSearch[FD_FILE_NONE];	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDhEiDeAiDeDiDiLiCmMiOoNjHnOiBeC_xHqqkZx_
}; // FCHiFileFindData.

// FFEnumDirectoryFileNest_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
typedef BOOL (*FPEnumDirectoryFileProc)(void* pData,					// _xZkqqHx_iDiGiBfLiDfFiDgGiBfLiDfOiBeC_xHqqkZx_
										FTFileKind fileKind,			// _xZkqqHx_iDhEiDeAiDeDiDiLiOoNiBeC_xHqqkZx_
										const wchar_t* wcpDirPath,		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiBeC_xHqqkZx_
										const wchar_t* wcpFileName);	// _xZkqqHx_iDhEiDeAiDeDiDiLiBgJiDgGiDeCiDiMiDeOiDgHiDiKiBgKjGlMiBeC_xHqqkZx_


//;------ </EXPORT TO SDK> -----;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCWorkDir
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiCmFiCmNiDiPiBfLiDeOiDhEiDeAiDeDiDiLiCpAjFkBjAjEiNoMjAkMiClHiCoJiCkKiBeBiClLiCmMiDiPiBfLiDeOiDhEiDeAiDeDiDiLiCpA_xHqqkZx_
 *			_xZkqqHx_iCnMiCmGiCnPiCmEiIoKiCmCiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCmFiKmHjHjNiClHiCoJiClNiCnPiCmJiBeBiDiPiBfLiDeOiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_
 *			_xZkqqHx_iCpAiIoKiCmCiNoMjAkMiBeFiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCWorkDir
{
public:
	FCWorkDir (const wchar_t* wcpExt);
	~FCWorkDir ();
	const WString& GetWorkDir () const;

protected:
	WString	m_wstrWorkDir;
	HANDLE	m_hFile;
}; // FCWorkDir.

//;----- </EXPORT TO SERVER> -----;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCWorkFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCmJiBeBiIoKiOjOiDhEiDeAiDeDiDiLiCpAiNoMjAkMiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iOkJjDkOjDeJiCmJiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCWorkFile
{
public:
	FCWorkFile ();
	~FCWorkFile ();
	CFile file;
}; // class FCWorkFile.

//----- _xZkqqHx_iDfEiDeDiDfJiCgBiKnGjIeBiCmMiKnGjAjE_xHqqkZx_ -----
extern void	WriteVSizeU (CFile& file, ULONGLONG ddwVSizeU);
											// _xZkqqHx_iDfEiDeDiDfJiCgBiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
extern ULONGLONG	ReadVSizeU (CFile& file);	// _xZkqqHx_iDfEiDeDiDfJiCgBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
extern ULONGLONG	RReadVSizeU (CFile& file);	// _xZkqqHx_iDfEiDeDiDfJiCgBiCpAiLhEiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
extern void		SkipVSizeU (CFile& file);	// _xZkqqHx_iDfEiDeDiDfJiCgBiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
extern void		RSkipVSizeU (CFile& file);	// _xZkqqHx_iDfEiDeDiDfJiCgBiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
extern void		WriteVSizeU (BYTEVector& vBuff, ULONGLONG ddwVSizeU);
											// _xZkqqHx_iDhIiDeOiDfOiBfLiDgPiDgCiDhEiDeAiCmJiDfEiDeDiDfJiCgBiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
extern void		InsertVSizeU (BYTEVector& vBuff, long lPos, ULONGLONG ddwVSizeU);
											// _xZkqqHx_iDhIiDeOiDfOiBfLiDgPiDgCiDhEiDeAiCmJiDfEiDeDiDfJiCgBiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
extern ULONGLONG	ReadVSizeU (const BYTE*& bypBuff);
											// _xZkqqHx_iDgPiDgCiDhEiDeAiCkJiCoHiDfEiDeDiDfJiCgBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
extern ULONGLONG	RReadVSizeU (const BYTE*& bypBuff);	// _xZkqqHx_iDfEiDeDiDfJiCgBiCpAiLhEiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
extern ULONGLONG	LongToVSizeU (long lVal);		// long_xZkqqHx_iMfOiCkJiCoHiDfEiDeDiDfJiCgBiMfOiCnGjFmPiKlHiBeC_xHqqkZx_
extern long			VSizeUToLong (ULONGLONG ddwVSizeU);	// _xZkqqHx_iDfEiDeDiDfJiCgBiMfOiCkJiCoH_xHqqkZx_long_xZkqqHx_iMfOiCnGjFmPiKlHiBeC_xHqqkZx_

//----- BYTEVector_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiKnGjIeB_xHqqkZx_ -----
extern void		FFWriteStream (BYTEVector& vStream, const void* pData, DWORD dwCount);
											// vStream_xZkqqHx_iCmMiNmFiMoDiCmJ_xHqqkZx_pData_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
extern void		FFReadStream (const BYTE*& bypBuff, void* pData, DWORD dwCount);
											// pData_xZkqqHx_iCmJiDgGiBfLiDfOiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiKnGjIeB_xHqqkZx_ -----
// _xZkqqHx_iDhEiDeAiDeDiDiLjAoCjBmOiDhAiDfIjGlMiCpAiDhAiDfIjFjEjFkKiCmGiDhEiDeAiDeDiDiLjGlMjFjEjFkKiCmJjFkKiJpAiClHiCoJiBeC_xHqqkZx_
extern void	FFSplitFileName (WString* strDirPath, WString* strFile, WString* strExtension,
							const wchar_t* wcpFileFull);
// _xZkqqHx_iDhEiDeAiDeDiDiLiBgJjAoCjBmOiBeFjBiKjBmOiBgKiDhAiDfIjGlMiCpAiDhEiDeAiDeDiDiLjFjEjFkKiBgJiDhAiDfIjFhEiCkLiBgKiCmGiKgHjCkDiOhBiCmJjFkKiJpAiClHiCoJiBeC_xHqqkZx_
extern void	FFSplitFileName (WString* strFile, WString* strExtension,
							const wchar_t* wcpFilePath);

// _xZkqqHx_iDhEiDeAiDeDiDiLiBgJjAoCjBmOiBeFjBiKjBmOiBgKiDhAiDfIjGlMiCmMiKgHjCkDiOhBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
extern WString FFGetFileExtension (const wchar_t* wcpFilePath);
// _xZkqqHx_iDhEiDeAiDeDiDiLiBgJjAoCjBmOiBgKiDhAiDfIjGlMiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
extern WString FFGetFileDirectory (const wchar_t* wcpFilePath, BOOL bChopLast = FALSE);
// _xZkqqHx_iDhEiDeAiDeDiDiLiBgJjAoCjBmOiBeFjBiKjBmOiBgKiDhAiDfIjGlMiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
extern WString FFGetFileName (const wchar_t* wcpFilePath);

// _xZkqqHx_iDhEiDiLiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
extern WString FFFullPath (const wchar_t* wcpFileName);

// wcpFilePath1_xZkqqHx_iCmG_xHqqkZx_wcpFilePath2_xZkqqHx_iCmMiLkEjCmKiCmMiDhAiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
extern WString FFGetCommonPath (const wchar_t* wcpFilePath1,
								const wchar_t* wcpFilePath2);
// wcpDirPathBase_xZkqqHx_iCkJiCoHiCmMjBiKjBmOiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
extern WString FFGetRelativePath (	const wchar_t* wcpDirPathBase,
									const wchar_t* wcpFilePathTarg);
extern WString FFGetAbsolutePath (	const wchar_t* wcpDirPathBase,
									const wchar_t* wcpFilePathTarg);

// _xZkqqHx_iDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
extern void FFMakeUniqFileName (WString& wstrName, const wchar_t* wcpFile);

// _xZkqqHx_iDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
extern void FFMakeUniqFileName (WString& strName, const wchar_t* wcpPath,
								const wchar_t* wcpExt);
// TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmJiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
extern void FFMakeUniqTmpFileName (WString& strName, const wchar_t* wcpPreName,
									const wchar_t* wcpExt);
// TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
extern WString FFGetTmpDirectory ();

// TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmJiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCmFiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
extern BOOL FFCopyToUniqTmpFile (WString& wstrDestName,
								const wchar_t* wcpOrigName,
								const wchar_t* wcpPreName);

// _xZkqqHx_jFlGiOjKjHpBjCiGiCmMiBeBiDhEiDeAiDeDiDiLjGlMiCmJiOgHiCkGiCmIiCkCjFlGiOjK_xHqqkZx_ _xZkqqHx_iLhJiCnB_xHqqkZx_'.'_xZkqqHx_iCpA_xHqqkZx_'_'_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
extern void FFFileNameRegal (WString& strName, wchar_t tch = L'_');
// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCkKjHeMiMpIiCkJjClCiCnHiCoJiBeC_xHqqkZx_
extern BOOL FFIsFilePathRegal (const wchar_t* wcpFilePath);
//----- 06.03.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCkKjHeMiMpIiCkJjClCiCnHiCoJiBeC_xHqqkZx_
//extern BOOL FFIsDirectoryPathRegal (const wchar_t* wcpDirPath);
//----- 06.03.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiBeFiDhEiDeAiDeDiDiLiCmMjHpBiLjDiBeC_xHqqkZx_
extern void FFEnumDirectoryFile (	WStringVector& vDirName,
									WStringVector& vFileName,
									const wchar_t* wcpDirPath);
// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiBeFiDhEiDeAiDeDiDiLiCmMjHpBiLjDiBeC_xHqqkZx_
extern BOOL FFEnumDirectoryFileNest (	FPEnumDirectoryFileProc proc,
										const wchar_t* wcpDirPath,
										void* pData);

//----- 06.03.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _wstat_xZkqqHx_iCmMjBoDiCoNiCoIiBeC_xHqqkZx_95_xZkqqHx_iMgOiCmFiCmNiOgHiCkGiCmIiCkCiClNiCnPiBeC_xHqqkZx_
//extern int mywstat (const wchar_t* path, struct_stat* buffer);
//----- 06.03.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// _wremove_xZkqqHx_iCmMjBoDiCoNiCoIiBeC_xHqqkZx_95_xZkqqHx_iMgOiCmFiCmNiOgHiCkGiCmIiCkCiClNiCnPiBeC_xHqqkZx_
extern int mywremove (const wchar_t* path);
// _wrename_xZkqqHx_iCmMjBoDiCoNiCoIiBeC_xHqqkZx_95_xZkqqHx_iMgOiCmFiCmNiOgHiCkGiCmIiCkCiClNiCnPiBeC_xHqqkZx_
extern int mywrename (const wchar_t* oldname, const wchar_t* newname);
// _wsopen_xZkqqHx_iCmMjBoDiCoNiCoIiBeC_xHqqkZx_95_xZkqqHx_iMgOiCmFiCmNiOgHiCkGiCmIiCkCiClNiCnPiBeC_xHqqkZx_
extern int mywsopen (const wchar_t* wcpPath, int oflag, int shflag, int pmode = 0);
// SetCurrentDirectory_xZkqqHx_iCmM_xHqqkZx_wchar_t_xZkqqHx_jEmFiBeC_xHqqkZx_
extern BOOL FFSetCurrentDirectory (const wchar_t* path);
// DeleteFile_xZkqqHx_iCmM_xHqqkZx_wchar_t_xZkqqHx_jEmFiBeC_xHqqkZx_
extern BOOL FFDeleteFile (const wchar_t* wcpFileName);
//----- 03.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmEiCkCiCoJiPoKiNiHiCmNjAfOiBeC_xHqqkZx_
//extern BOOL FFIsFileExist (const wchar_t* path, BOOL* bIsDir = NULL);
//----- 03.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMjBlGiNnNiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
extern FTFileKind FFIsThereFile (const wchar_t* path);
//----- 06.03.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMjBlGiNnNiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//extern FTFileKind FFCheckFileExist (const wchar_t* path);
//----- 06.03.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 03.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
// _xZkqqHx_iMlLiNnNiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
extern WString FFGetCurrentDirectory (BOOL bAddSlash);
//----- 06.05.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
extern WString FFGetDesktopDirectory ();
//----- 06.05.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
extern BOOL FFCopyFile (const wchar_t* wcpExistingFile, const wchar_t* wcpNewFile, BOOL bFailIfExists);
// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHjCgMiCmJjFmPiKlHiBeC_xHqqkZx_
extern FTDocumentFormat FFFileNameToFormat (const wchar_t* wcpFileName);
// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiClCiCmGiDfCiDhDiBfLiBeC_xHqqkZx_
extern BOOL FFCopyDirectory (const wchar_t* wcpPathFrom,
							const wchar_t* wcpPathTo);
//----- 06.01.19 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//extern BOOL FFCopyDirectory (const wchar_t* wcpPathFrom,
//							 const wchar_t* wcpPathTo);
//----- 06.01.19 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 03.12.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iOhHjCoIiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
extern BOOL FFRecursiveCreateDirectory (WString* wstrCreatedPath, const wchar_t* wcpDirPath);

// 06.02.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//extern BOOL FFRecursiveCreateDirectory (WString* wstrCreatedPath, const wchar_t* wcpDirPath);
// _xZkqqHx_iOhHjCoIiCmMiDgGiDeCiDiMiDeOiDgHiDiKiImIiJlKiCpAjBfDiCmEiNoNiPjMiBeC_xHqqkZx_
// 06.01.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//extern void FFRemoveDirectory (const wchar_t* wcpPath);

// 06.03.10 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
extern BOOL FFRemoveDirectory (const wchar_t* wcpPath);

extern BOOL FFRecursiveRemoveDirectory (const wchar_t* wcpPath);
extern BOOL FFCreateDirectory (	const wchar_t* wcpDirPath,
								LPSECURITY_ATTRIBUTES lpSecurityAttributes);
// 06.03.10 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
extern BOOL FFCanAllAccessDirectory (const wchar_t* wcpDirPath);

// UNICODE_xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDeAiDeDiDiLiCkJiCoHiDgGiBfLiDfOiCpAiIoKiKiHiClFiCmEjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
extern int FFLoadTextFile (WString& wstrBuff, const wchar_t* wcpFile);
// UNICODE_xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDeAiDeDiDiLiCmJiDgGiBfLiDfOiCpAiIoKiKiHiClFiCmEiPjBiCkLiPgPiClHiBeC_xHqqkZx_
extern BOOL FFSaveTextFile (const wchar_t* wcpBuff, const wchar_t* wcpFile);
// _xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDeAiDeDiDiLiCkJiCoHiDgGiBfLiDfOiCpAiIoKiKiHiClFiCmEjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
extern int FFLoadTextFile (astring& strBuff, const wchar_t* wcpFile);
// _xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDeAiDeDiDiLiCmJiDgGiBfLiDfOiCpAiIoKiKiHiClFiCmEiPjBiCkLiPgPiClHiBeC_xHqqkZx_
extern BOOL FFSaveTextFile (const char* cpBuff, const wchar_t* wcpFile);

extern flint FFCopy (FCFileBase& file0, FCFileBase& file1, flint fliSize);

extern WString FFTableToTopDirPath (const wchar_t* wcpTablePath);

//----- 06.03.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//extern WString FFAbnormalizePath (const wchar_t* wcpPath);
//extern WString FFNormalizePath (const wchar_t* wcpPath);
//extern BOOL FFCheckAbnormalPath (const wchar_t* wcpPath);
//----- 06.03.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

extern BYTEVector& operator << (BYTEVector& vStream, const BYTEVector& data);
extern BYTEVector& operator << (BYTEVector& vStream, BYTEVector& data);
extern void FFWriteData (const void* pData, DWORD dwCount, BYTEVector& vStream);
extern void FFReadData (BYTEVector& data, const BYTE*& pStream);

//;----- <EXPORT TO SERVER> -----;

////////////////////////////////////////////////////////////////////////
// template_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_

//----- BYTEVector_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiKnGjIeB_xHqqkZx_ -----
template<class T> BYTEVector& operator << (BYTEVector& vStream, const T data)
{
	FFWriteStream(vStream, &data, sizeof(data));
	return vStream;
} // template<class T> void operator <<.

template<class T> void FFReadData (T& data, const BYTE*& bypStream)
{
	FFReadStream(bypStream, &data, sizeof(data));
} // template<class T> void FFReadData.

template<class T> void FFSkipData (T* data, const BYTE*& bypStream)
{
	bypStream += sizeof(T);
} // template<class T> void FFSkipData.

template<class S, class T> void FFCopyData (S& fileTo, T& fileFrom, flint fliSize)
{
	BYTE byaBuff[100000];
	while (fliSize != 0)
	{
		flint fliCount = fliSize;
		if (sizeof(byaBuff) < fliCount)
			fliCount = sizeof(byaBuff);
		fliCount = fileFrom.Read64(byaBuff, fliCount);
		fileTo.Write64(byaBuff, fliCount);
		fliSize -= fliCount;
	}
} // template<class S, class T> void FFCopyData.

//;----- </EXPORT TO SERVER> -----;

#endif//__UtilFile_h
