#ifndef __UtilFont_h
#define __UtilFont_h

// UNICODE_xZkqqHx_iCmMjFlGiOjKiBeC_xHqqkZx_
#define WCH_TAB	0x0009
#define WCH_SPC	0x0020
#define WCH_LF	0x000d
#define WCH_CR	0x000a
#define WCH_BS	0x0008

//----- 06.05.21 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
#define WCH_HAN_KUTEN	0xff64		// '_xZkqqHx_iBeB_xHqqkZx_'
#define WCH_HAN_TOUTEN	0xff61		// '_xZkqqHx_iBeC_xHqqkZx_'
#define WCH_ZEN_SPC		0x3000		// '_xZkqqHx_iBeA_xHqqkZx_'
#define WCH_ZEN_KUTEN	0x3001		// '_xZkqqHx_iBeB_xHqqkZx_'
#define WCH_ZEN_TOUTEN	0x3002		// '_xZkqqHx_iBeC_xHqqkZx_'
#define WCH_ZEN_COMMA	0xff0c		// '_xZkqqHx_iBeD_xHqqkZx_'
#define WCH_ZEN_PERIOD	0xff0e		// '_xZkqqHx_iBeE_xHqqkZx_'
//----- 06.05.21 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//;----- <EXPORT TO SDK> -----;

#define FDFI_OFST_NORMALSCRIPT	0
#define FDFI_OFST_SUPERSCRIPT	1
#define FDFI_OFST_MIDSCRIPT		2
#define FDFI_OFST_SUBSCRIPT		3

// _xZkqqHx_iPoDjFhEiCkLiBeBiJlKjFhEiCkLiDhEiDeIiDjDiDgHiCmMiDfEiDeDiDfJjEoEiBeC_xHqqkZx_
#define FDFR_SMALL_RATIO	0.65

#define FDFI_FLAG_HEIGHT	(0x00000001 << 0)
#define FDFI_FLAG_WEIGHT	(0x00000001 << 1)
#define FDFI_FLAG_ITALIC	(0x00000001 << 2)
#define FDFI_FLAG_UNDERLINE	(0x00000001 << 3)
#define FDFI_FLAG_STRIKEOUT	(0x00000001 << 4)
#define FDFI_FLAG_CHARSET	(0x00000001 << 5)
#define FDFI_FLAG_FACENAME	(0x00000001 << 6)
#define FDFI_FLAG_OFFSET	(0x00000001 << 7)
#define FDFI_FLAG_CHARAFTER	(0x00000001 << 8)
#define FDFI_FLAG_COLORREF	(0x00000001 << 9)
#define FDFI_FLAG_UNUSED	(0x00000001 << 31)	// _xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_

#define FDFI_FLAG_ALL		(FDFI_FLAG_HEIGHT|FDFI_FLAG_WEIGHT|FDFI_FLAG_ITALIC|FDFI_FLAG_UNDERLINE| \
							 FDFI_FLAG_STRIKEOUT|FDFI_FLAG_CHARSET|FDFI_FLAG_FACENAME| \
							 FDFI_FLAG_OFFSET|FDFI_FLAG_CHARAFTER|FDFI_FLAG_COLORREF)

//;------ </EXPORT TO SDK> -----;

#define FDUFWeight(a) WORD((a) >> 16)
#define FDUFItalic(a) WORD((a) & 0x0000ffff)
#define FDUFWeightItalic(a, b) (DWORD(a) << 16 | ((b) ? 0x00000001 : 0x00000000))

//;----- <EXPORT TO SDK> -----;

#define FDUFChrSupSub(a) WORD((a) >> 14)
#define FDUFChrOffset(a) (((a) & 0x2000) ? -short((a) & 0x1fff) : short((a) & 0x1fff))
#define FDUFChrSupSubOffset(a, b) (WORD(((a) & 0x0003) << 14) | ((0 <= (b)) ? WORD((b) & 0x1fff) : WORD(((-(b)) & 0x1fff) | 0x2000)))

///////////////////////////////////////////////////////////////////////////////
// wOffset_xZkqqHx_iCmMiDhCiDgCiDgHiDhEiDeCiBfLiDiLiDgIiBeC_xHqqkZx_
// xx  x  xxxxxxxxxxxxx
// ~~a ~b ~~~~~~~~~~~~~c
// a:_xZkqqHx_jFiBjCmKiBeBiPoDjFhEiCkLiBeBjCiGjFhEiCkLiBeBiJlKjFhEiCkL_xHqqkZx_(FDFI_OFST_NORMALSCRIPT - FDFI_OFST_SUBSCRIPT)
// b:_xZkqqHx_iDeJiDhEiDfKiDgCiDgH_xHqqkZx_(c)_xZkqqHx_iCkKjFiJiCmIiCoHiCmO_xHqqkZx_ 1_xZkqqHx_iBeB_xHqqkZx_0_xZkqqHx_iImIiPoDiCmIiCoHiCmO_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
// c:_xZkqqHx_iPoDiJlKjFpLiMpMiCmMiDeJiDhEiDfKiDgCiDgHiBeC_xHqqkZx_TWIPS_xZkqqHx_jCfAiImKiBeC_xHqqkZx_
//
// (a)_xZkqqHx_iCkKjFiBjCmKiImIiKePiCmIiCoHiCmOiBeBiDhEiDeIiDjDiDgHiDfEiDeDiDfJiCmN_xHqqkZx_ FDFR_SMALL_RATIO_xZkqqHx_jEhLiBeC_xHqqkZx_
///////////////////////////////////////////////////////////////////////////////

//;------ </EXPORT TO SDK> -----;

typedef set<LOGFONT> LOGFONTSet;

//;----- <EXPORT TO SDK> -----;

typedef map<WORD, WString> FTCharSetMap;
typedef map<WString, FTCharSetMap> FTFontCharSetMap;

struct FCFontCharInfo
{
	DWORD		dwMask;
	mmetol		mmHeight;
	WORD		wWeight;
	BYTE		byItalic;
	BYTE		byUnderline;
	BYTE		byStrikeOut;
	BYTE		byCharSet;
	BYTE		byPitchAndFamily;
	BYTE		dummy;
	WORD		wOffset;
	short		nCharAfter;
	COLORREF	crColor;
	wchar_t		szFaceName[LF_FACESIZE];
//;------ </EXPORT TO SDK> -----;
	// _xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_
	void		OutStream (BYTEVector& vStream) const;
	void		InStream (const BYTE*& pData);
//;----- <EXPORT TO SDK> -----;
}; // struct FCFontCharInfo.

//;------ </EXPORT TO SDK> -----;

//;----- <EXPORT TO SDK> -----;
// _xZkqqHx_iDhEiDeIiDjDiDgHiCmMjFmPiNfIiPoOjFpBiCmMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
struct FCErrFontInfo
{
	FCErrFontInfo (BYTE byOldCharSet, const wchar_t* wcpOldFaceName,
					BYTE byNewCharSet, const wchar_t* wcpNewFaceName) :
		m_byOldCharSet(byOldCharSet), m_wstrOldFaceName(wcpOldFaceName),
		m_byNewCharSet(byNewCharSet), m_wstrNewFaceName(wcpNewFaceName) {}
	BYTE	m_byOldCharSet;
	WString	m_wstrOldFaceName;
	BYTE	m_byNewCharSet;
	WString	m_wstrNewFaceName;
}; // struct FCErrFontInfo.
//;------ </EXPORT TO SDK> -----;


// _xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmM_xHqqkZx_LOGFONT_xZkqqHx_iBeCjAoCjBmOjBlGiNnNiClHiCoJiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
extern const LOGFONT& FFGetStdFont ();
//----- 03.07.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiOoGjDlOiBeC_xHqqkZx_
extern const LOGFONT& FFGetStdFont (dblpnt dbptHeight, long lfEscapement);
//----- 03.07.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
// _xZkqqHx_iDhEiDeIiDjDiDgHiPiJiKpKiJlLiBeCiDhEiDeIiDjDiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiDfGiDfIiDgFiDiAiDhEiDeIiDjDiDgHiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
extern void FFCreateFontIndirect (CFont& font, const LOGFONT& logFont);
// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiOjOiCmJiBeB_xHqqkZx_lfWidth_xZkqqHx_iCpAjAnNjCoIiBeCiJoGjGmKiCkK_xHqqkZx_4:3_xZkqqHx_iCmFiCmIiCkCiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
// _xZkqqHx_iBgJiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhHiDgCiDfPiCpAiPjBjBnGiCkGiCmEiBeBjAlIjDhIiCpAiNiCiCnPiCoJiCmMiCmJjHjIjHhAiBgK_xHqqkZx_
extern void FFSetLogFontWidth (LOGFONT& logFont);

extern void FFCopy (CHARFORMATA& cfa, const CHARFORMATW& cfw);
extern void FFCopy (CHARFORMATW& cfw, const CHARFORMATA& cfa);
extern void FFCopy (FCFontCharInfo& fci, const CHARFORMATW& cf);
extern void FFCopy (CHARFORMATW& cf, const FCFontCharInfo& fci);
extern void FFCopy (LOGFONT& lf, const FCFontCharInfo& fci, double dZoom);
extern void FFCopy (FCFontCharInfo& fci, const LOGFONT& lf, double dZoom);

extern void FFOverwrite (FCFontCharInfo& fci1, const FCFontCharInfo& fci2, DWORD dwMask);
extern void operator |= (FCFontCharInfo& fci1, const FCFontCharInfo& fci2);
extern void operator &= (FCFontCharInfo& fci1, const FCFontCharInfo& fci2);
extern BOOL operator == (const FCFontCharInfo& fci1, const FCFontCharInfo& fci2);
extern BOOL operator != (const FCFontCharInfo& fci1, const FCFontCharInfo& fci2);
extern void FFGetNearest (FCFontCharInfo& fci, const WORDVector* vCharSet = NULL, const FCFontCharInfo* fciStd = NULL);
extern BOOL FFFindFirstFont (LOGFONT& lf, BYTE byCharSet);
extern BOOL FFFindFirstFont (LOGFONT& lf, const WORDVector& vCharSet);

extern BOOL operator == (const CHARFORMATW& cf1, const CHARFORMATW& cf2);
extern BOOL operator != (const CHARFORMATW& cf1, const CHARFORMATW& cf2);

//------------------------------------------------------------------------
// _xZkqqHx_iImIiJlKiCmM_xHqqkZx_DWORD _xZkqqHx_iCmMiJlKiImK_xHqqkZx_16Bit_xZkqqHx_iCmNiBeBiDhEiDeIiDjDiDgHiCkK_xHqqkZx_Italic_xZkqqHx_iCkJiCmHiCkEiCkJiBeBiPoDiImK_xHqqkZx_16Bit_xZkqqHx_iCmN_xHqqkZx_Weight_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
//-------------------------------------------------------------------------
extern const wchar_t* FFWeightItalicToStr (WString& str, DWORD dwWeightItalic);
extern DWORD FFStrToWeightItalic (const wchar_t* tcpStr);

extern void FFCollectWeightItalic (DWORDSet& stWeightItalic, WORD wCharSet, const wchar_t* tcpFontName);
//----- 02.08.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----
extern WORD FFCollectWeightItalic (DWORDSet& stWeightItalic, const WORDVector& vCharSet,
									const wchar_t* tcpFontName);
//----- 02.08.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----

extern int FFUnicodeToSubset (wchar_t wChar);

extern const wchar_t* FFCharsetToName (WORD wCharset);
// 02.08.12 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)
extern BOOL FFIsBasicLatinChar (wchar_t wChar);

//----------<NOT EXPORT TO VIEWER>-----------
extern BOOL FFIsStdFontChar (wchar_t wChar);
//----------</NOT EXPORT TO VIEWER>-----------

// 02.08.11 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)
extern void FFUnicodeToCharSet (WORDVector& vCharSet, wchar_t wCode, WORD w1StCharSet);

// _xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeHiDiJiBfLiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
extern void FFAppendErrFontInfo (BYTE byOldCharSet, const wchar_t* wcpOldFaceName,
								BYTE byNewCharSet, const wchar_t* wcpNewFaceName);
// _xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeHiDiJiBfLiPoOjFpBiCpAiOoGiCoIiPgPiClFiCmEiBeBjDoAjFjEjFmPjAjEiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
extern void FFGetAndClearErrFontInfo (vector<FCErrFontInfo>& vFontInfo);
// _xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeHiDiJiBfLiPoOjFpBiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
extern BOOL FFIsErrFontInfo ();

//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// _xZkqqHx_iDhEiDeIiDjDiDgHjGlMiCmMiIoKjHjHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
extern void FFCollectFontName (FTFontCharSetMap* mpExtCodeFontMap, WStringSet* stStdCodeFontName);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

#endif//__UtilFont_h
