#include "stdafx.h"

#include "RegData.h"	// For GetOptiRegColor.
#include "Env.h"		// For g_pEnv.
#include "UtilMisc.h"	// For FFCalcFrame.
#include "UtilStr.h"	// For WCharToCode.
#include "UtilFont.h"	// For FFCreateFontIndirect.
#include "UtilBezier.h"	// For FCLgPolyBezier.
#include "UtilGraph.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define GEN_MARK_H		3	// _xZkqqHx_jEmEjHhAiDhNiBfLiDeOiBgJiDiKiDfEiDeDiDfJjHhAiDhNiBfLiDeOjDjJiBgKiCmMjElMjFkKiBeC_xHqqkZx_
#define SMALL_MARK_H	2	// _xZkqqHx_iPkMjEmEjHhAiDhNiBfLiDeOiBgJiDiKiDjDiDeOiDgDiBfLiDiLjBeJjBpAiDhNiBfLiDeOjDjJiBgKiCmMjElMjFkKiBeC_xHqqkZx_
#define SEL_MARK_H		4	// _xZkqqHx_jBeJjBpAjDfPiDhNiBfLiDeOiBgJiDhMiDiKiDfDiDjDiDgDiBfLiDiLjBeJjBpAiDhNiBfLiDeOjDjJiBgKiCmMjElMjFkKiBeC_xHqqkZx_


//----- 06.12.27 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myMoveTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CDC_xZkqqHx_iCmM_xHqqkZx_MoveTo_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:CDC_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pt	:_xZkqqHx_iNmAjFfHiCpAiLeMjIfOiClHiCoJjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			x	:x_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			y	:y_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	MoveTo_xZkqqHx_iCmMjFnEiClHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Release_xZkqqHx_jEmFiCmFiBeB_xHqqkZx_MoveTo _xZkqqHx_iCmG_xHqqkZx_ LineTo _xZkqqHx_iCmFjDkPiClGiNmAjFfHiCpAiOhHjCoIiClFiClNiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_jHiOiClPiCoJiClBiCmGiCkKiCkAiCmBiClNiBeC_xHqqkZx_
 *			_xZkqqHx_jDkPiClGiNmAjFfHiCpAiOhHjCoIiClDiClJiCmIiCkCiClNiCnPiBeBiClBiCmMiKnGjAjEiCpAjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static CPoint myMoveTo (CDC* pDC, CPoint& pt, int x, int y)
{
	pt.x = x;
	pt.y = y;
	return pDC->MoveTo(x, y);
} // myMoveTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myLineTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CDC_xZkqqHx_iCmM_xHqqkZx_MoveTo_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:CDC_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pt	:_xZkqqHx_iNmAjFfHiCpAiLeMjIfOiClHiCoJjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			x	:x_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			y	:y_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	LineTo_xZkqqHx_iCmMjFnEiClHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Release_xZkqqHx_jEmFiCmFiBeB_xHqqkZx_MoveTo _xZkqqHx_iCmG_xHqqkZx_ LineTo _xZkqqHx_iCmFjDkPiClGiNmAjFfHiCpAiOhHjCoIiClFiClNiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_jHiOiClPiCoJiClBiCmGiCkKiCkAiCmBiClNiBeC_xHqqkZx_
 *			_xZkqqHx_jDkPiClGiNmAjFfHiCpAiOhHjCoIiClDiClJiCmIiCkCiClNiCnPiBeBiClBiCmMiKnGjAjEiCpAjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static BOOL myLineTo (CDC* pDC, CPoint& pt, int x, int y)
{
	if (pt.x != x || pt.y != y)
	{
		pt.x = x;
		pt.y = y;
		return pDC->LineTo(x, y);
	}
	return TRUE;
} // myLineTo.
//----- 06.12.27 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::FCEditDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgPenW	:_xZkqqHx_iDhJiDjDiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			col		:_xZkqqHx_jFfMiOkGiClDiClJiCoJjAeGiCpAiOhHjCoIiBeCjEhHiMgJiCmMjElNjDfNjAeGiCmJiCmIiCoJiClBiCmGiCpAiNgMjHlGiClFiCmEiOhHjCoIiBeC_xHqqkZx_
 *			lPenStyle:_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *					 PS_SOLID/PS_DASH/PS_DOT/PS_DASHDOT/PS_DASHDOTDOT _xZkqqHx_iCkJiCoHiOhHjCoIiBeC_xHqqkZx_
 *			lgOffsetX, lgOFfsetY :_xZkqqHx_jFgAiJoGiOjOiCmMiNmAjFfHiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCEditDraw::FCEditDraw (CDC* pDC, long lgPenW, COLORREF col, long lPenStyle,
						long lgOffsetX, long lgOffsetY)
{
	// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	Initialize(pDC, lgPenW, col, lPenStyle, lgOffsetX, lgOffsetY);
} // FCEditDraw::FCEditDraw.

//----- 05.02.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::FCEditDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lgPenW	:_xZkqqHx_iDhJiDjDiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
// *			col		:_xZkqqHx_jFfMiOkGiClDiClJiCoJjAeGiCpAiOhHjCoIiBeCjEhHiMgJiCmMjElNjDfNjAeGiCmJiCmIiCoJiClBiCmGiCpAiNgMjHlGiClFiCmEiOhHjCoIiBeC_xHqqkZx_
// *			lgOffsetX, lgOFfsetY :_xZkqqHx_jFgAiJoGiOjOiCmMiNmAjFfHiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
////----- 05.02.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////FCEditDraw::FCEditDraw (CDC* pDC, long lgPenW, COLORREF col,
////						long lgOffsetX, long lgOffsetY) :
////			m_pDC(pDC),
////			m_brush(OptiColor(col)),
////			m_lgOffsetX(lgOffsetX),
////			m_lgOffsetY(lgOffsetY)
////{
////	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
////	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
////	LOGBRUSH logbPen = { BS_SOLID, OptiColor(col), 0 };
////	//----- _xZkqqHx_iDhJiDjDiCmMjAnNjCoI_xHqqkZx_ -----
////	if (g_pReg->GetEditDrawPen() == 0)
////		m_pen.CreatePen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_ROUND|PS_JOIN_ROUND, lgPenW, &logbPen);
////	else
////		m_pen.CreatePen(PS_COSMETIC|PS_SOLID, 1, &logbPen);
////	//----- pDC_xZkqqHx_iCmMjFgAiJoGjBkOjAkLjAnNjCoI_xHqqkZx_ -----
////	if (g_pFDPalette == NULL && g_pReg->GetEditDrawMode() == 0)
////		m_rop2Old = m_pDC->SetROP2(R2_XORPEN);
////	else
////		m_rop2Old = m_pDC->SetROP2(R2_NOT);
////	m_pPenOld = m_pDC->SelectObject(&m_pen);
////	m_pBrushOld = m_pDC->SelectObject(&m_brush);
////} // FCEditDraw::FCEditDraw.
////----- 05.02.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//FCEditDraw::FCEditDraw (CDC* pDC, long lgPenW, COLORREF col,
//						long lgOffsetX, long lgOffsetY)
//{
//	// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	Initialize(pDC, PS_SOLID, lgPenW, col, lgOffsetX, lgOffsetY);
//} // FCEditDraw::FCEditDraw.
////----- 05.02.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 05.02.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.02.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::FCEditDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lgPenW	:_xZkqqHx_iDhJiDjDiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lgOffsetX, lgOFfsetY :_xZkqqHx_jFgAiJoGiOjOiCmMiNmAjFfHiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
////----- 05.02.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////FCEditDraw::FCEditDraw (CDC* pDC, long lgPenW, long lgOffsetX, long lgOffsetY) :
////			m_pDC(pDC),
////			m_brush(g_pReg->GetOptiRegColor(FDCL_EDIT_LINE) ^ g_pReg->GetOptiSheetColor()),
////			m_lgOffsetX(lgOffsetX),
////			m_lgOffsetY(lgOffsetY)
////{
////	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
////	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
////	LOGBRUSH logbPen = { BS_SOLID, g_pReg->GetOptiRegColor(FDCL_EDIT_LINE) ^
////									g_pReg->GetOptiSheetColor(), 0 };
////	//----- _xZkqqHx_iDhJiDjDiCmMjAnNjCoI_xHqqkZx_ -----
////	if (g_pReg->GetEditDrawPen() == 0)
////		m_pen.CreatePen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_ROUND|PS_JOIN_ROUND, lgPenW, &logbPen);
////	else
////		m_pen.CreatePen(PS_COSMETIC|PS_SOLID, 1, &logbPen);
////	//----- pDC_xZkqqHx_iCmMjFgAiJoGjBkOjAkLjAnNjCoI_xHqqkZx_ -----
////	if (g_pFDPalette == NULL && g_pReg->GetEditDrawMode() == 0)
////		m_rop2Old = m_pDC->SetROP2(R2_XORPEN);
////	else
////		m_rop2Old = m_pDC->SetROP2(R2_NOT);
////	m_pPenOld = m_pDC->SelectObject(&m_pen);
////	m_pBrushOld = m_pDC->SelectObject(&m_brush);
////} // FCEditDraw::FCEditDraw.
////----- 05.02.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//FCEditDraw::FCEditDraw (CDC* pDC, long lgPenW, long lgOffsetX, long lgOffsetY)
//{
//	// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	Initialize(pDC, PS_SOLID, lgPenW, COLORREF(-1), lgOffsetX, lgOffsetY);
//} // FCEditDraw::FCEditDraw.
////----- 05.02.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 05.02.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::FCEditDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			penType	:_xZkqqHx_iDhJiDjDiCmMiLkNiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgOffsetX, lgOFfsetY :_xZkqqHx_jFgAiJoGiOjOiCmMiNmAjFfHiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 05.02.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//FCEditDraw::FCEditDraw (CDC* pDC, FTEditPenType penType, long lgOffsetX, long lgOffsetY) :
//			m_pDC(pDC),
//			m_brush(g_pReg->GetOptiRegColor(FDCL_EDIT_LINE) ^ g_pReg->GetOptiSheetColor()),
//			m_lgOffsetX(lgOffsetX),
//			m_lgOffsetY(lgOffsetY)
//{
//	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
//	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
//	LOGBRUSH logbPen = { BS_SOLID, g_pReg->GetOptiRegColor(FDCL_EDIT_LINE) ^
//									g_pReg->GetOptiSheetColor(), 0 };
//	//----- _xZkqqHx_iDhJiDjDiCmMjAnNjCoI_xHqqkZx_ -----
//	if (g_pReg->GetEditDrawPen() == 0)
//	{
//		if (penType == FDPN_TIMID)	// _xZkqqHx_iOoDiCkCiDhJiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
//			m_pen.CreatePen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_ROUND|PS_JOIN_ROUND, 1, &logbPen);
//		else	// _xZkqqHx_iLkNiCkCiDhJiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
//			m_pen.CreatePen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_ROUND|PS_JOIN_ROUND, 3, &logbPen);
//	} else
//	{
//		if (penType == FDPN_TIMID)	// _xZkqqHx_iOoDiCkCiDhJiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
//			m_pen.CreatePen(PS_COSMETIC|PS_DOT, 1, &logbPen);
//		else	// _xZkqqHx_iLkNiCkCiDhJiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
//			m_pen.CreatePen(PS_COSMETIC|PS_SOLID, 1, &logbPen);
//	}
//	//----- pDC_xZkqqHx_iCmMjFgAiJoGjBkOjAkLjAnNjCoI_xHqqkZx_ -----
//	if (g_pFDPalette == NULL && g_pReg->GetEditDrawMode() == 0)
//		m_rop2Old = m_pDC->SetROP2(R2_XORPEN);
//	else
//		m_rop2Old = m_pDC->SetROP2(R2_NOT);
//	m_pPenOld = m_pDC->SelectObject(&m_pen);
//	m_pBrushOld = m_pDC->SelectObject(&m_brush);
//} // FCEditDraw::FCEditDraw.
//----- 05.02.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
FCEditDraw::FCEditDraw (CDC* pDC, FTEditPenType penType, long lgOffsetX, long lgOffsetY)
{
	if (g_pReg->GetEditDrawPen() == 0)
	{
		if (penType == FDPN_TIMID)	// _xZkqqHx_iOoDiCkCiDhJiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
			Initialize(pDC, 1, COLORREF(-1), PS_SOLID, lgOffsetX, lgOffsetY);
		else	// _xZkqqHx_iLkNiCkCiDhJiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
			Initialize(pDC, 3, COLORREF(-1), PS_SOLID, lgOffsetX, lgOffsetY);
	} else
	{
		if (penType == FDPN_TIMID)	// _xZkqqHx_iOoDiCkCiDhJiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
			Initialize(pDC, 1, COLORREF(-1), PS_DOT, lgOffsetX, lgOffsetY);
		else	// _xZkqqHx_iLkNiCkCiDhJiDjDiCmMiPoKiNiHiBeC_xHqqkZx_
			Initialize(pDC, 1, COLORREF(-1), PS_SOLID, lgOffsetX, lgOffsetY);
	}
} // FCEditDraw::FCEditDraw.
//----- 05.02.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiClHiCoJiBeCiDfCiDjDiDfIiDgHiDiJiDeOiDfOiCmFiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgPenW	:_xZkqqHx_iDhJiDjDiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			col		:_xZkqqHx_jFfMiOkGiClDiClJiCoJjAeGiCpAiOhHjCoIiBeCjEhHiMgJiCmMjElNjDfNjAeGiCmJiCmIiCoJiClBiCmGiCpAiNgMjHlGiClFiCmEiOhHjCoIiBeC_xHqqkZx_
 *			lPenStyle:_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *					 PS_SOLID/PS_DASH/PS_DOT/PS_DASHDOT/PS_DASHDOTDOT _xZkqqHx_iCkJiCoHiOhHjCoIiBeC_xHqqkZx_
 *			lgOffsetX, lgOFfsetY :_xZkqqHx_jFgAiJoGiOjOiCmMiNmAjFfHiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::Initialize (	CDC* pDC,
								long lgPenW,
								COLORREF col,
								long lPenStyle,
								long lgOffsetX,
								long lgOffsetY)
{
	if (col == COLORREF(-1))
		col = g_pReg->GetOptiRegColor(FDCL_EDIT_LINE) ^ g_pReg->GetOptiSheetColor();
	if (lPenStyle == -1)
		lPenStyle = PS_SOLID;
	m_pDC = pDC;
	m_brush.CreateSolidBrush(OptiColor(col));
	m_lgOffsetX = lgOffsetX;
	m_lgOffsetY = lgOffsetY;
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(col), 0 };
	//----- _xZkqqHx_iDhJiDjDiCmMjAnNjCoI_xHqqkZx_ -----
	if (g_pReg->GetEditDrawPen() == 0)
		m_pen.CreatePen(PS_GEOMETRIC|lPenStyle|PS_ENDCAP_FLAT|PS_JOIN_BEVEL, lgPenW, &logbPen);
	else
		m_pen.CreatePen(PS_COSMETIC|lPenStyle, 1, &logbPen);
	//----- pDC_xZkqqHx_iCmMjFgAiJoGjBkOjAkLjAnNjCoI_xHqqkZx_ -----
	if (g_pFDPalette == NULL && g_pReg->GetEditDrawMode() == 0)
		m_rop2Old = m_pDC->SetROP2(R2_XORPEN);
	else
		m_rop2Old = m_pDC->SetROP2(R2_NOT);
	m_pPenOld = m_pDC->SelectObject(&m_pen);
	m_pBrushOld = m_pDC->SelectObject(&m_brush);
} // FCEditDraw::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::~FCEditDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCEditDraw::~FCEditDraw ()
{
	//----- pDC_xZkqqHx_iCmMjFgAiJoGjBkOjAkLiCpAjGnPiClH_xHqqkZx_ -----
	m_pDC->SelectObject(m_pBrushOld);
	m_pDC->SelectObject(m_pPenOld);
	m_pDC->SetROP2(m_rop2Old);
} // FCEditDraw::~FCEditDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::RectLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCiGjAfDjDfPiCmMiOpMiImNiCmJiLoJiMgAiCmMjApMiCpAiIpIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptCenter	:_xZkqqHx_jCiGjAfDiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgHalfW		:_xZkqqHx_iLoJiMgAiCmM_xHqqkZx_ _xZkqqHx_jFjN_xHqqkZx_/2 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgHalfH		:_xZkqqHx_iLoJiMgAiCmM_xHqqkZx_ _xZkqqHx_iNiC_xHqqkZx_/2 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::RectLine (const CPoint& lgptCenter, long lgHalfW, long lgHalfH)
{
	RectLine(CRect(lgptCenter.x - lgHalfW, lgptCenter.y - lgHalfH,
					lgptCenter.x + lgHalfW, lgptCenter.y + lgHalfH));
} // FCEditDraw::RectLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::RectLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiLoJiMgAiCmMjApMiCpAiIpIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgrtFrame	:_xZkqqHx_iLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_CDC::Rectangle_xZkqqHx_iCmIiCmHiCmGiInJiCmIiCoIiBeB_xHqqkZx_
 *						 _xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDiMiBfLiDiAiCmMiClPiCoFiCkEiCmHiPoDiCmJjFgAiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::RectLine (const CRect& lgrtFrame)
{
	Line(&CPoint(lgrtFrame.left, lgrtFrame.top),
		&CPoint(lgrtFrame.right, lgrtFrame.top),
		&CPoint(lgrtFrame.right, lgrtFrame.bottom),
		&CPoint(lgrtFrame.left, lgrtFrame.bottom),
		&CPoint(lgrtFrame.left, lgrtFrame.top));
} // FCEditDraw::RectLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::RectFill
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCiGjAfDjDfPiCmMiOpMiImNiCmJiLoJiMgAiCpAjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptCenter	:_xZkqqHx_jCiGjAfDiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgHalfW		:_xZkqqHx_iLoJiMgAiCmM_xHqqkZx_ _xZkqqHx_jFjN_xHqqkZx_/2 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgHalfH		:_xZkqqHx_iLoJiMgAiCmM_xHqqkZx_ _xZkqqHx_iNiC_xHqqkZx_/2 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::RectFill (const CPoint& lgptCenter, long lgHalfW, long lgHalfH)
{
	RectFill(CRect(lgptCenter.x - lgHalfW, lgptCenter.y - lgHalfH,
					lgptCenter.x + lgHalfW + 1, lgptCenter.y + lgHalfH + 1));
} // FCEditDraw::RectFill.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::RectFill
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCiGjAfDjDfPiCmMiOpMiImNiCmJiLoJiMgAiCpAjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgrtFrame	:_xZkqqHx_iLoJiMgAiCpAiOhHjCoIiBeCiDhEiDiMiBfLiDiAiCmMiClPiCoFiCkEiCmHiPoDiCmJjFgAiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::RectFill (const CRect& lgrtFrame)
{
	// Rectangle + StrokeAndFillPath _xZkqqHx_iCmNiBeB_xHqqkZx_95_xZkqqHx_iCmFjDkOiNoMiClFiCmIiCkCiBeC_xHqqkZx_
	m_pDC->BeginPath();
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//	POINT pt[] = {	{ lgrtFrame.left - m_lgOffsetX, lgrtFrame.top - m_lgOffsetY },
//					{ lgrtFrame.right - m_lgOffsetX, lgrtFrame.top - m_lgOffsetY },
//					{ lgrtFrame.right - m_lgOffsetX, lgrtFrame.bottom - m_lgOffsetY },
//					{ lgrtFrame.left - m_lgOffsetX, lgrtFrame.bottom - m_lgOffsetY },
//					{ lgrtFrame.left - m_lgOffsetX, lgrtFrame.top - m_lgOffsetY } };
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	POINT pt[] = {	{ mylgx2dvx(lgrtFrame.left),
					  mylgy2dvy(lgrtFrame.top) },
					{ mylgx2dvx(lgrtFrame.right),
					  mylgy2dvy(lgrtFrame.top) },
					{ mylgx2dvx(lgrtFrame.right),
					  mylgy2dvy(lgrtFrame.bottom) },
					{ mylgx2dvx(lgrtFrame.left),
					  mylgy2dvy(lgrtFrame.bottom) },
					{ mylgx2dvx(lgrtFrame.left),
					  mylgy2dvy(lgrtFrame.top) } };
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	m_pDC->Polyline(pt, 5);
	m_pDC->EndPath();
	m_pDC->FillPath();
} // FCEditDraw::RectFill.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::SelMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCiGjAfDjDfPiCmMiOpMiImNiCmJiDhMiDeDiDjDiDgHjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptCenter	:_xZkqqHx_jCiGjAfDiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::SelMark (const CPoint& lgptCenter)
{
	RectFill(lgptCenter, SEL_MARK_H, SEL_MARK_H);
} // FCEditDraw::SelMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::UnselMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCiGjAfDjDfPiCmMiOpMiImNiCmJiDhMiDeDiDjDiDgHjEpBjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptCenter	:_xZkqqHx_jCiGjAfDiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::UnselMark (const CPoint& lgptCenter)
{
	RectLine(lgptCenter, SEL_MARK_H, SEL_MARK_H);
} // FCEditDraw::UnselMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::GeneralMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCiGjAfDjDfPiCmMiOpMiImNiCmJjEmEjHhAiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptCenter	:_xZkqqHx_jCiGjAfDiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::GeneralMark (const CPoint& lgptCenter)
{
	RectFill(lgptCenter, GEN_MARK_H, GEN_MARK_H);
} // FCEditDraw::GeneralMark.

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::GeneralMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCiGjAfDjDfPiCmMiOpMiImNiCmJiPkMjEmEjHhAiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptCenter	:_xZkqqHx_jCiGjAfDiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::SmallMark (const CPoint& lgptCenter)
{
	RectFill(lgptCenter, SMALL_MARK_H, SMALL_MARK_H);
} // FCEditDraw::GeneralMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::Polyline
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlNiKhAjApMiCpAiIpIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpPoints	:_xZkqqHx_jBlNiKhAjApMiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_LONG_MAX_xZkqqHx_iCmFiLoGjAnIiCoHiCoKiClN_xHqqkZx_
 *						 _xZkqqHx_jFkBjAjEiCmMjBlNiKhAjApMiCmFiCoAjFgAiJoGiCmFiCkLiCoJiBeC_xHqqkZx_
 *			nCount		:lpPoints_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	WinNT/Win2000_xZkqqHx_iCmFiCmNiBeBjFjN_xHqqkZx_0/1_xZkqqHx_iCmMjApMiCpAiIpIiCkNiCmGiCkLiCmJiBeB_xHqqkZx_BeginPath/EndPath
 *			_xZkqqHx_iCpAiOhHjCoIiClFiCmIiCkCiCmGiBeB_xHqqkZx_XOR_xZkqqHx_iCmFiCfBiJpB_xHqqkZx_ _xZkqqHx_jClMjApMiCpAiIpIiCkCiClNiOjOjEpHjGkNiCmJiInJiCmIiCoJjApMiCpAiIpIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::Polyline (const CPoint* lpPoints, int nCount)
{
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_pDC->BeginPath();
//	// A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJiCmMiCpAjGgIiCkOiClNiCnPiBeB_xHqqkZx_
//	// mylgx2dvx_xZkqqHx_iBeB_xHqqkZx_mylgy2dvy_xZkqqHx_jCiGiCmF_xHqqkZx_FFLimitCoord _xZkqqHx_iCmFjCgMiCpAjAkHiMmAiClHiCoJiBeC_xHqqkZx_
//	m_pDC->MoveTo(mylgx2dvx(lpPoints[0].x),
//				  mylgy2dvy(lpPoints[0].y));
//	for (long lC = 1; lC < nCount; lC++)
//		m_pDC->LineTo(mylgx2dvx(lpPoints[lC].x),
//					  mylgy2dvy(lpPoints[lC].y));
//	m_pDC->EndPath();
//	m_pDC->StrokePath();
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	m_pDC->BeginPath();
	for (long lC = 0; lC < nCount; lC++)
	{
		if (lpPoints[lC].x != LONG_MAX)
		{
			// A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJiCmMiCpAjGgIiCkOiClNiCnPiBeB_xHqqkZx_
			// mylgx2dvx_xZkqqHx_iBeB_xHqqkZx_mylgy2dvy_xZkqqHx_jCiGiCmF_xHqqkZx_FFLimitCoord _xZkqqHx_iCmFjCgMiCpAjAkHiMmAiClHiCoJiBeC_xHqqkZx_
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			m_pDC->MoveTo(mylgx2dvx(lpPoints[lC].x),
//						  mylgy2dvy(lpPoints[lC].y));
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			MoveTo(lpPoints[lC]);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
// 06.12.31 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			for (lC++; lpPoints[lC].x != LONG_MAX && lC != nCount; lC++)
			for (lC++; lC != nCount && lpPoints[lC].x != LONG_MAX; lC++)
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				m_pDC->LineTo(mylgx2dvx(lpPoints[lC].x),
//							  mylgy2dvy(lpPoints[lC].y));
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				LineTo(lpPoints[lC]);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	m_pDC->EndPath();
	m_pDC->StrokePath();
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCEditDraw::Polyline.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::Polygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlNiKhAiMgAiCpAjFgAiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpPoints	:_xZkqqHx_jBlNiKhAjApMiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nCount		:lpPoints_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::Polygon (const CPoint* lpPoints, int nCount)
{
	m_pDC->BeginPath();
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//	m_pDC->MoveTo(lpPoints[0].x - m_lgOffsetX, lpPoints[0].y - m_lgOffsetY);
//	for (long lC = 1; lC < nCount; lC++)
//		m_pDC->LineTo(lpPoints[lC].x - m_lgOffsetX, lpPoints[lC].y - m_lgOffsetY);
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_pDC->MoveTo(mylgx2dvx(lpPoints[0].x),
//				  mylgy2dvy(lpPoints[0].y));
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	MoveTo(lpPoints[0]);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	for (long lC = 1; lC != nCount; lC++)
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		m_pDC->LineTo(mylgx2dvx(lpPoints[lC].x),
//					  mylgy2dvy(lpPoints[lC].y));
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		LineTo(lpPoints[lC]);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	m_pDC->EndPath();
	m_pDC->FillPath();
} // FCEditDraw::Polygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::Line
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jClMjApMiCpAiIpIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPoint0	:_xZkqqHx_jClMjApMiCmMjBoGiCfAiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pPoint1	:_xZkqqHx_jClMjApMiCmMjBoGiCfBiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pPoint3	:_xZkqqHx_jClMjApMiCmMjBoGiCfCiNmAjFfHiCpAiOhHjCoIiBeCiBeFiBeFiBeFiBeF_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::Line (	const CPoint* pPoint0, const CPoint* pPoint1,
						const CPoint* pPoint2, const CPoint* pPoint3,
						const CPoint* pPoint4, const CPoint* pPoint5,
						const CPoint* pPoint6, const CPoint* pPoint7,
						const CPoint* pPoint8, const CPoint* pPoint9)
{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_pDC->BeginPath();
////----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
////	m_pDC->MoveTo(pPoint0->x - m_lgOffsetX, pPoint0->y - m_lgOffsetY);
////	m_pDC->LineTo(pPoint1->x - m_lgOffsetX, pPoint1->y - m_lgOffsetY);
////	if (pPoint2 != NULL) m_pDC->LineTo(pPoint2->x - m_lgOffsetX, pPoint2->y - m_lgOffsetY);
////	if (pPoint3 != NULL) m_pDC->LineTo(pPoint3->x - m_lgOffsetX, pPoint3->y - m_lgOffsetY);
////	if (pPoint4 != NULL) m_pDC->LineTo(pPoint4->x - m_lgOffsetX, pPoint4->y - m_lgOffsetY);
////	if (pPoint5 != NULL) m_pDC->LineTo(pPoint5->x - m_lgOffsetX, pPoint5->y - m_lgOffsetY);
////	if (pPoint6 != NULL) m_pDC->LineTo(pPoint6->x - m_lgOffsetX, pPoint6->y - m_lgOffsetY);
////	if (pPoint7 != NULL) m_pDC->LineTo(pPoint7->x - m_lgOffsetX, pPoint7->y - m_lgOffsetY);
////	if (pPoint8 != NULL) m_pDC->LineTo(pPoint8->x - m_lgOffsetX, pPoint8->y - m_lgOffsetY);
////	if (pPoint9 != NULL) m_pDC->LineTo(pPoint9->x - m_lgOffsetX, pPoint9->y - m_lgOffsetY);
////----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//	m_pDC->MoveTo(mylgx2dvx(pPoint0->x),
//				  mylgy2dvy(pPoint0->y));
//	m_pDC->LineTo(mylgx2dvx(pPoint1->x),
//				  mylgy2dvy(pPoint1->y));
//	if (pPoint2 != NULL) m_pDC->LineTo(	mylgx2dvx(pPoint2->x),
//										mylgy2dvy(pPoint2->y));
//	if (pPoint3 != NULL) m_pDC->LineTo(	mylgx2dvx(pPoint3->x),
//										mylgy2dvy(pPoint3->y));
//	if (pPoint4 != NULL) m_pDC->LineTo(	mylgx2dvx(pPoint4->x),
//										mylgy2dvy(pPoint4->y));
//	if (pPoint5 != NULL) m_pDC->LineTo(	mylgx2dvx(pPoint5->x),
//										mylgy2dvy(pPoint5->y));
//	if (pPoint6 != NULL) m_pDC->LineTo(	mylgx2dvx(pPoint6->x),
//										mylgy2dvy(pPoint6->y));
//	if (pPoint7 != NULL) m_pDC->LineTo(	mylgx2dvx(pPoint7->x),
//										mylgy2dvy(pPoint7->y));
//	if (pPoint8 != NULL) m_pDC->LineTo(	mylgx2dvx(pPoint8->x),
//										mylgy2dvy(pPoint8->y));
//	if (pPoint9 != NULL) m_pDC->LineTo(	mylgx2dvx(pPoint9->x),
//										mylgy2dvy(pPoint9->y));
////----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//	m_pDC->EndPath();
//	m_pDC->StrokePath();
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	CPointVector vlgptPoly;
do {
	vlgptPoly.push_back(*pPoint0);
	vlgptPoly.push_back(*pPoint1);
	if (pPoint2 == NULL) break;
	vlgptPoly.push_back(*pPoint2);
	if (pPoint3 == NULL) break;
	vlgptPoly.push_back(*pPoint3);
	if (pPoint4 == NULL) break;
	vlgptPoly.push_back(*pPoint4);
	if (pPoint5 == NULL) break;
	vlgptPoly.push_back(*pPoint5);
	if (pPoint6 == NULL) break;
	vlgptPoly.push_back(*pPoint6);
	if (pPoint7 == NULL) break;
	vlgptPoly.push_back(*pPoint7);
	if (pPoint8 == NULL) break;
	vlgptPoly.push_back(*pPoint8);
	if (pPoint9 == NULL) break;
	vlgptPoly.push_back(*pPoint9);
} while (FALSE);
	Polyline(&vlgptPoly.at(0), vlgptPoly.size());
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCEditDraw::Line.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::ArcLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJhOiMmKiCpAjFgAiJoGiClHiCoJiBeCjCiGiCmNjDgIjCnHiClDiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rect	:_xZkqqHx_iJhOiMmKiCkKiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptStart	:_xZkqqHx_iJhOiMmKiKeKiOgOjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptEnd	:_xZkqqHx_iJhOiMmKiPeJjHlJjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::ArcLine (const CRect& rect, const CPoint& ptStart, const CPoint& ptEnd)
{
	// Win95,98_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_Arc_xZkqqHx_iCmN_xHqqkZx_BeginPath_xZkqqHx_iCmJjBmOiJjOiClFiCmEiCkCiCmIiCkCiBeC_xHqqkZx_
// 01.11.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_pDC->BeginPath();
	CBrush* pOldBrush = m_pDC->SelectObject(CBrush::FromHandle((HBRUSH)GetStockObject(HOLLOW_BRUSH)));
	m_pDC->Arc(rect - CPoint(m_lgOffsetX, m_lgOffsetY), ptStart, ptEnd);
	m_pDC->SelectObject(pOldBrush);
//----- 01.11.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	m_pDC->EndPath();
//	m_pDC->StrokePath();
//----- 01.11.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCEditDraw::ArcLine.

//----- 06.12.27 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::MoveTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIfPjHjNiNmAjFfHiCpAiDgGiDgPiDeDiDfIiNmAjFfHiCmJjFmPiKlHiClFiCmEiBeB_xHqqkZx_MoveTo_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpt	:_xZkqqHx_jIfPjHjNiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::MoveTo (const CPoint& lgpt)
{
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	MoveTo(lgpt.x, lgpt.y);
} // FCEditDraw::MoveTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::MoveTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIfPjHjNiNmAjFfHiCpAiDgGiDgPiDeDiDfIiNmAjFfHiCmJjFmPiKlHiClFiCmEiBeB_xHqqkZx_MoveTo_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgX, lgY	:_xZkqqHx_jIfPjHjNiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::MoveTo (long lgX, long lgY)
{
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	// mylgx2dvx, mylgx2dvy _xZkqqHx_iCmFjAkHiMmAiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
	myMoveTo(m_pDC, m_lgptLastMoveTo, mylgx2dvx(lgX), mylgy2dvy(lgY));
} // FCEditDraw::MoveTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::LineTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIfPjHjNiNmAjFfHiCpAiDgGiDgPiDeDiDfIiNmAjFfHiCmJjFmPiKlHiClFiCmEiBeB_xHqqkZx_LineTo_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpt	:_xZkqqHx_jIfPjHjNiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::LineTo (const CPoint& lgpt)
{
	LineTo(lgpt.x, lgpt.y);
} // FCEditDraw::LineTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::LineTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIfPjHjNiNmAjFfHiCpAiDgGiDgPiDeDiDfIiNmAjFfHiCmJjFmPiKlHiClFiCmEiBeB_xHqqkZx_LineTo_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgX, lgY	:_xZkqqHx_jIfPjHjNiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCEditDraw::LineTo (long lgX, long lgY)
{
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	// mylgx2dvx, mylgx2dvy _xZkqqHx_iCmFjAkHiMmAiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
	myLineTo(m_pDC, m_lgptLastMoveTo, mylgx2dvx(lgX), mylgy2dvy(lgY));
} // FCEditDraw::LineTo.
//----- 06.12.27 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::GetEditColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjAlDjApMiCmMjAeGiBgJjFoCjAeGiBgKiCpAjFnEiClHiBeC_xHqqkZx_R2_XORPEN _xZkqqHx_iCmGiCmMjBgHiCnNiNiHiCoNiClJiCmFjHeMiMpIiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeDjAlDjApMiCmMjAeGiBgJjFoCjAeGiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static _xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
COLORREF FCEditDraw::GetEditColor ()
{
	return g_pReg->GetOptiRegColor(FDCL_EDIT_LINE) ^ g_pReg->GetOptiSheetColor();
} // FCEditDraw::GetEditColor.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::GetSelMarkSizeHalf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiBeFjEpBjBeJjBpAiDhNiBfLiDeO_xHqqkZx_(SelMark,UnselMark)_xZkqqHx_iCmMiDfEiDeDiDfJiCmMjElMjFkKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static _xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCEditDraw::GetSelMarkSizeHalf ()
{
	return SEL_MARK_H;
} // FCEditDraw::GetSelMarkSizeHalf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::GetGeneralMarkSizeHalf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEmEjHhAiDhNiBfLiDeO_xHqqkZx_(GeneralMark)_xZkqqHx_iCmMiDfEiDeDiDfJiCmMjElMjFkKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static _xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCEditDraw::GetGeneralMarkSizeHalf ()
{
	return GEN_MARK_H;
} // FCEditDraw::GetGeneralMarkSizeHalf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::GetSmallMarkSizeHalf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPkMjEmEjHhAiDhNiBfLiDeO_xHqqkZx_(SmallMark)_xZkqqHx_iCmMiDfEiDeDiDfJiCmMjElMjFkKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static _xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCEditDraw::GetSmallMarkSizeHalf ()
{
	return SMALL_MARK_H;
} // FCEditDraw::GetSmallMarkSizeHalf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::FCDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDraw::FCDraw (CDC* pDC,
				FTDrawWhich eDrawWhich,
				double dZoom,
				long lgOffsetX,
				long lgOffsetY)
			:	m_pDC(pDC),
				m_eDrawWhich(eDrawWhich),
				m_dZoom(dZoom),
				m_lgOffsetX(lgOffsetX),
				m_lgOffsetY(lgOffsetY),
				m_psidPenStyle(FD_PEN_STYLE_UNUSE),
				m_mmfPenWeight(0),
				m_scidPenBackSColor(FD_S_COLOR_UNUSE),
				m_ptidBrushPattern(FD_PATTERN_UNUSE),
				m_scidBrushForeSColor(FD_S_COLOR_UNUSE),
				m_scidBrushBackSColor(FD_S_COLOR_UNUSE),
				m_pPenOld(NULL),
				m_pBrushOld(NULL)
{
	// _xZkqqHx_iDhAiDiMiDgCiDgHiCmMjAnNjCoIiBeC_xHqqkZx_
	if (g_pFDPalette != NULL)
		m_pPaletteOld = m_pDC->SelectPalette(g_pFDPalette, TRUE);
	else
		m_pPaletteOld = NULL;
} // FCDraw::FCDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::~FCDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDraw::~FCDraw ()
{
	if (m_pPenOld != NULL)
		m_pDC->SelectObject(m_pPenOld);
	if (m_pBrushOld != NULL)
		m_pDC->SelectObject(m_pBrushOld);
	// _xZkqqHx_iDhAiDiMiDgCiDgHiCmMjFjMiMlDiBeC_xHqqkZx_
	if (m_pPaletteOld != NULL)
		m_pDC->SelectPalette(m_pPaletteOld, TRUE);
} // FCDraw::~FCDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::PenInit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Pen_xZkqqHx_iCpAiIpIjAjEiCmFiPiJiKpKiJlLiClHiCoJiBeCjFjEjFgJiCmM_xHqqkZx_OnDraw_xZkqqHx_jDjJiCmFiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byPenType			:PEN_xZkqqHx_iCmMiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			psidPenStyle		:PEN_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptidPenPattern		:PEN_xZkqqHx_iCmMiDhAiDfOiBfLiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmfPenWeight		:PEN_xZkqqHx_iCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidPenForeSColor	:PEN_xZkqqHx_iCmMjBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidPenBackSColor	:PEN_xZkqqHx_iCmMjEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:pen_xZkqqHx_iCpAiPiJiKpKiJlLiCmFiCkLiClNiPoKiNiHiBeC_xHqqkZx_
 *			FALSE	:_xZkqqHx_iIpIjAjEiCmMjGlFiPiCiBeFiDgGiDgPiDeDiDfIiOoGjDlOiOlIjEhDiCkKiMlEiIpGiCmF_xHqqkZx_pen_xZkqqHx_iCpA_xHqqkZx_
 *					 _xZkqqHx_iPiJiKpKiJlLiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::PenInit (	PenStyleID	psidPenStyle,
						fmmetol		mmfPenWeight,
						SColorID	scidPenBackSColor)
{
	LOGBRUSH logbPen;
	m_psidPenStyle = (psidPenStyle != FD_PEN_STYLE_UNSPECIFY) ?
							psidPenStyle : FD_PEN_STYLE_UNUSE;
	m_mmfPenWeight = mmfPenWeight;
	// _xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiBeFjEhHiMgJjAeGiCkKiOhHjCoIjGlDiClFiCmIiCoHiCmOiBeBjEhHiMgJjAeGiCmJjGlDiMpIiCpAiLeMjIfOiBeC_xHqqkZx_
	m_scidPenBackSColor = (m_psidPenStyle != FD_PEN_STYLE_UNUSE &&
							scidPenBackSColor != FD_S_COLOR_UNSPECIFY) ?
							scidPenBackSColor : FD_S_COLOR_UNUSE;
	if (m_scidPenBackSColor != FD_S_COLOR_UNUSE)
	//----- _xZkqqHx_iDhJiDjDiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		logbPen.lbStyle = BS_SOLID;
		logbPen.lbColor = ::OptiColor(g_pEnv->scid2cref(scidPenBackSColor));

//----- 05.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		if (m_eDrawWhich == FDDR_ENHANCED_METAFILE ||
			m_eDrawWhich == FDDR_PRINTER ||
			m_eDrawWhich == FDDR_PRINT_PREVIEW)
		//----- _xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiBeBiIpDiNpMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiCmMiDhAiDfOiBfLiDjDjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
			DWORD lgaData[4];
			GetPenStyleArray(lgaData);
			if (lgaData[0] == 0 && lgaData[1] == 0 &&
				lgaData[2] == 0 && lgaData[3] == 0)
			//----- _xZkqqHx_iDfIiDfOiDeDiDiLiCkKjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
			{
				if (m_pen.CreatePen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_ROUND|PS_JOIN_ROUND,
									mymm2lg(mmfPenWeight), &logbPen))
				{
					ASSERT(m_pPenOld == NULL);
					m_pPenOld = m_pDC->SelectObject(&m_pen);
				}
			} else
			//----- _xZkqqHx_iDfIiDfOiDeDiDiLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				if (m_pen.CreatePen(PS_GEOMETRIC|PS_USERSTYLE|PS_ENDCAP_ROUND|PS_JOIN_ROUND,
									mymm2lg(mmfPenWeight), &logbPen, 4, lgaData))
				{
					ASSERT(m_pPenOld == NULL);
					m_pPenOld = m_pDC->SelectObject(&m_pen);
				}
			}
		} else
//----- 05.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		if (m_eDrawWhich != FDDR_METAFILE)
		//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiImIiKePiBgJiJoGjGmKiBeBiDhGiDiKiDjDiDfOiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (m_pen.CreatePen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_ROUND|PS_JOIN_ROUND,
								mymm2lg(mmfPenWeight), &logbPen))
			{
				ASSERT(m_pPenOld == NULL);
				m_pPenOld = m_pDC->SelectObject(&m_pen);
			}
		} else
		//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// Pen_xZkqqHx_iCpAiNoMjAkMiBeCiDiBiDfOiDhEiDeAiDeDiDiLiCmNiBeBiLiMiOkOiCmMiIpIjAjEiCmFiCmIiCkCiCmGiDfPiDiBiBeJiBeC_xHqqkZx_
			if (m_pen.CreatePen(PS_SOLID, mymm2lg(mmfPenWeight),
								OptiColor(g_pEnv->scid2cref(scidPenBackSColor))))
			{
				ASSERT(m_pPenOld == NULL);
				m_pPenOld = m_pDC->SelectObject(&m_pen);
			}
		}
	}
} // FCDraw::PenInit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::BrushInit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Brush_xZkqqHx_iCpAiIpIjAjEiCmFiPiJiKpKiJlLiClHiCoJiBeCjFjEjFgJiCmM_xHqqkZx_OnDraw_xZkqqHx_jDjJiCmFiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byBrushType			:BRUSH_xZkqqHx_iCmMiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptidBrushPattern	:BRUSH_xZkqqHx_iCmMiDhAiDfOiBfLiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidBrushForeSColor	:BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidBrushBackSColor	:BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:brush_xZkqqHx_iCpAiPiJiKpKiJlLiCmFiCkLiClNiPoKiNiHiBeC_xHqqkZx_
 *			FALSE	:_xZkqqHx_iIpIjAjEiCmMjGlFiPiCiBeFiDgGiDgPiDeDiDfIiOoGjDlOiOlIjEhDiCkKiMlEiIpGiCmF_xHqqkZx_brush_xZkqqHx_iCpA_xHqqkZx_
 *					 _xZkqqHx_iPiJiKpKiJlLiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::BrushInit (PatternID	ptidBrushPattern,
						SColorID	scidBrushForeSColor,
						SColorID	scidBrushBackSColor)
{
	m_ptidBrushPattern = (ptidBrushPattern != FD_PATTERN_UNSPECIFY) ?
							ptidBrushPattern : FD_PATTERN_UNUSE;
	m_scidBrushForeSColor = (m_ptidBrushPattern != FD_PATTERN_UNUSE &&
								scidBrushForeSColor != FD_S_COLOR_UNSPECIFY) ?
							scidBrushForeSColor : FD_S_COLOR_UNUSE;
	m_scidBrushBackSColor = (scidBrushBackSColor != FD_S_COLOR_UNSPECIFY) ?
							scidBrushBackSColor : FD_S_COLOR_UNUSE;
	LOGBRUSH logBrush = { BS_NULL, 0, 0 };
	if (m_eDrawWhich != FDDR_METAFILE)
	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiImIiKePiBgJiJoGjGmKiBeBiDhGiDiKiDjDiDfOiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiBgKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_scidBrushBackSColor != FD_S_COLOR_UNUSE)
		//----- _xZkqqHx_jEhHiMgJiCkKjDkHjGlOiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			logBrush.lbStyle = BS_SOLID;
			logBrush.lbColor = ::OptiColor(g_pEnv->scid2cref(m_scidBrushBackSColor));
		}
	} else
	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_scidBrushForeSColor != FD_S_COLOR_UNUSE)
		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhAiDfOiBfLiDjDiCkKiCkAiCoIiBeBjEhHiMgJiCkKjDkHjGlOiCmMiPoKiNiHiCmNjEhHiMgJiCmJjEjCiCpAjAnNjCoIiBeC_xHqqkZx_
			if (m_scidBrushBackSColor == FD_S_COLOR_UNUSE)
				m_scidBrushBackSColor = FD_S_COLOR_WHITE;
			// _xZkqqHx_iDhCiDgCiDgHiDhNiDgCiDhGiDgGiBfLiDfOiCpAjAhNiMgAiCmMjGmNjHgMiCmJjDfMiCoIjFhEiCkPiCoJiOjOiBeBiDgGiBfLiDfOiCpAiJlKiCkJiCoH_xHqqkZx_
			// _xZkqqHx_iPoDiCmJiMpMiCkJiCmBiCmEjDfMiCoIjFhEiCkPiCmJiOgHjHhAiBgJiClHiCmIiCoNiClPiPoDiJlKiLhEjDfNiBgKiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
			g_pEnv->GetPatternBrush(logBrush, m_ptidBrushPattern, m_scidBrushForeSColor,
									m_scidBrushBackSColor);
		} else
		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCkKjGlDiCkCiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (m_scidBrushBackSColor != FD_S_COLOR_UNUSE)
			//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCkKjGlDiCkNiBeBjEhHiMgJiCkKjDkHjGlOiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
			{
				logBrush.lbStyle = BS_SOLID;
				logBrush.lbColor = ::OptiColor(g_pEnv->scid2cref(m_scidBrushBackSColor));
			}
		}
	}
	if (logBrush.lbStyle != BS_NULL && m_brush.CreateBrushIndirect(&logBrush))
	{
		ASSERT(m_pBrushOld == NULL);
		m_pBrushOld = m_pDC->SelectObject(&m_brush);
	}
} // FCDraw::BrushInit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::PenInitNull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Pen_xZkqqHx_iCpAjDkHjGlOiDhJiDjDiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::PenInitNull ()
{
	ASSERT(m_pPenOld == NULL);
	m_psidPenStyle = FD_PEN_STYLE_UNUSE;
	m_mmfPenWeight = 0.0;
	m_scidPenBackSColor = FD_S_COLOR_UNUSE;

	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiHiCmNiBeB_xHqqkZx_NULL_PEN_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	// BeginPath -> Polygon _xZkqqHx_iCmFiCoAjApMiCkKjFgAiJoGiClDiCoKiCmEiClFiCnMiCkEiClNiCnPiBeC_xHqqkZx_
	if (m_eDrawWhich == FDDR_METAFILE)
	m_pPenOld = m_pDC->SelectObject(CPen::FromHandle((HPEN)GetStockObject(NULL_PEN)));
} // FCDraw::PenInitNull.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::BrushInitNull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Brush_xZkqqHx_iCpAjDkHjGlOiDhFiDiJiDfGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::BrushInitNull ()
{
	m_ptidBrushPattern = FD_PATTERN_UNUSE;
	m_scidBrushForeSColor = FD_S_COLOR_UNUSE;
	m_scidBrushBackSColor = FD_S_COLOR_UNUSE;
	ASSERT(m_pBrushOld == NULL);
} // FCDraw::BrushInitNull.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::Polyline
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlNiKhAjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptaPoly	:_xZkqqHx_jClIjDfPiNmAjFfHiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPolySz		:_xZkqqHx_jEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmJiDfIiDfOiDeDiDiLiBgJjDfPjApMjDjJiBgKiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeB_xHqqkZx_Win95/98_xZkqqHx_iCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jFgAiJoGiCmFiCkLiCmIiCkCiClNiCnPiBeBjAoKjHhAiCmMjFgAiJoGiDiLiBfLiDgAiDjDiCmGiClFiCmEiNoMjAkMiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::Polyline (const CPoint* lgptaPoly, long lPolySz)
{
	Polyline(FCLgPolyBezier(FALSE, lgptaPoly, lPolySz));
//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// PS_NULL _xZkqqHx_iCmNiBeB_xHqqkZx_XEROX PS PagePrinter_xZkqqHx_iCmFiDeHiDiJiBfLiCkKiPgPiCoJiClNiCnPiBeBjDkHjGlOiCmMiPoKiNiHiCmN_xHqqkZx_
//	// _xZkqqHx_iJlNiCoAjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
//	if (m_scidPenBackSColor == FD_S_COLOR_UNUSE) return;
//	// _xZkqqHx_jFgAiJoGjFhDiJmCjEfMiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
//	const FCPenStyleRec* pPenStyleRec = g_pEnv->GetPenStyleRec(m_psidPenStyle);
//	if (m_mmfPenWeight < 0 || pPenStyleRec == NULL) return;
//
//	// _xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiCmMiDhAiDfOiBfLiDjDjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
//	DWORD lgaData[4];
//	GetPenStyleArray(lgaData);
//	if (lgaData[0] == 0 && lgaData[1] == 0 &&
//		lgaData[2] == 0 && lgaData[3] == 0)
//	//----- _xZkqqHx_iDfIiDfOiDeDiDiLiCkKjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		m_pDC->BeginPath();
//		POINT* dvpta = new POINT[lPolySz];
//		mylg2dv(dvpta, lgptaPoly, lPolySz);
//		m_pDC->Polyline(dvpta, lPolySz);
//		delete[] dvpta;
//		m_pDC->EndPath();
//		m_pDC->StrokePath();
//		return;
//	}
//
//	m_pDC->BeginPath();
//	long lDataC = 3;
//	double dlgShort = 0;
//	for (long lC = 1; lC < lPolySz; lC++)
//	{
//		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjApMjFkKiBgJ_xHqqkZx_[lC-1] ~ [lC]_xZkqqHx_iBgKiCmMjBoFiCkLiClDiCpAiMhGiOfKiBeC_xHqqkZx_
//		const DBLPoint dlgptLine = DBLPoint(lgptaPoly[lC]) - DBLPoint(lgptaPoly[lC - 1]);
//		// _xZkqqHx_jIeBjBlBiClHiCoJiCfBjDfPiCkKjDkPiClGiNmAjFfHiCmIiCoHiCmOiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (dlgptLine.IsNull()) continue;
//		const double dlgLineLen = dlgptLine.Len();
//
//		//----- _xZkqqHx_iCnMiClIiBeBjFgAiJoGiCmMiOgDiCoIiLjHjHkDiBgJ_xHqqkZx_dlgShort_xZkqqHx_iBgKiCpAiPiIjHjNiClHiCoJ_xHqqkZx_ -----
//
//		if (dlgLineLen < dlgShort)
//		//----- _xZkqqHx_jFgAiJoGiCmMiOgDiCoIiLjHjHkDiCkKiBeBiDfOiBfLiDfBiDgCiDgHiCmMjApMjFkKiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			dlgShort -= dlgLineLen;
//			if (!(lDataC & 1))
//			//----- _xZkqqHx_iLpEjAjEiBeBiClHiCmIiCoNiClPjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				MoveTo(lgptaPoly[lC - 1]);
//				LineTo(lgptaPoly[lC]);
//			}
//			continue;
//		} else
//		//----- _xZkqqHx_jFgAiJoGiCmMiOgDiCoIiLjHjHkDiCkKiBeBiDfOiBfLiDfBiDgCiDgHiCmMjApMjFkKiCpAiJlKiJpBiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			if (!(lDataC & 1))
//			//----- _xZkqqHx_iLpEjAjEiBeBiClHiCmIiCoNiClPjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				DBLPoint dlgptA = DBLPoint(lgptaPoly[lC - 1]) + (dlgptLine * (dlgShort / dlgLineLen));
//				MoveTo(lgptaPoly[lC - 1]);
//				LineTo(D2L(dlgptA.x), D2L(dlgptA.y));
//			}
//		}
//
//		//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjApMjFkKiCpAiBeBiDfIiDfOiDeDiDiLjEhKjHpBiBgJ_xHqqkZx_lgaData_xZkqqHx_iBgKiCmFjFkKiKiEjFgAiJoGiClHiCoJ_xHqqkZx_ -----
//
//		for (;;)
//		{
//			lDataC++;
//			if (4 <= lDataC) lDataC = 0;
//
//			if (!(lDataC & 1))
//			//----- _xZkqqHx_iLpEjAjEiBeBiClHiCmIiCoNiClPjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_jFgAiJoGiKeKiOgOjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
//				DBLPoint dlgptA = DBLPoint(lgptaPoly[lC - 1]) + (dlgptLine * (dlgShort / dlgLineLen));
//				dlgShort += lgaData[lDataC];
//				if (dlgLineLen < dlgShort)
//				//----- _xZkqqHx_jFgAiJoGiLjHjHkDiCkKiBeBiDfOiBfLiDfBiDgCiDgHjApMjFkKiCmMjFgAiCkLiOgDiClFiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//				{
//					// _xZkqqHx_iNmFiMoDiCnMiCmFjFgAiCkLiCkLiCoJiBeC_xHqqkZx_
//					MoveTo(D2L(dlgptA.x), D2L(dlgptA.y));
//					LineTo(lgptaPoly[lC]);
//					// _xZkqqHx_jFgAiJoGiCmMiOgDiCoIiLjHjHkDiBgJ_xHqqkZx_dlgShort_xZkqqHx_iBgKiCpAiOfKiPgPiBeC_xHqqkZx_
//					dlgShort -= dlgLineLen;
//					break;
//				}
//				// _xZkqqHx_jFgAiJoGiPeJjHlJjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
//				DBLPoint dlgptB = DBLPoint(lgptaPoly[lC - 1]) + (dlgptLine * (dlgShort / dlgLineLen));
//				// _xZkqqHx_jFgAiJoGiClHiCoJiBeC_xHqqkZx_
//				MoveTo(D2L(dlgptA.x), D2L(dlgptA.y));
//				LineTo(D2L(dlgptB.x), D2L(dlgptB.y));
//			} else
//			//----- _xZkqqHx_iKoPjAjEiBeBiClHiCmIiCoNiClPiKnEiMiEiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iDfIiDfOiDeDiDiLjEhKjHpBiCmMiBeBiKnEiMiEiLjHjHkDiCpAiMlLiNnNiCmMjFgAiJoGiImKjChFiBgJ_xHqqkZx_dlgShort_xZkqqHx_iBgKiCmJiJmBiOfKiBeC_xHqqkZx_
//				dlgShort += lgaData[lDataC];
//				if (dlgLineLen < dlgShort)
//				//----- _xZkqqHx_jFgAiJoGiLjHjHkDiCkKiBeBiDfOiBfLiDfBiDgCiDgHjApMjFkKiCmMjFgAiCkLiOgDiClFiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//				{
//					// _xZkqqHx_jFgAiJoGiCmMiOgDiCoIiLjHjHkDiBgJ_xHqqkZx_dlgShort_xZkqqHx_iBgKiCpAiOfKiPgPiBeC_xHqqkZx_
//					dlgShort -= dlgLineLen;
//					break;
//				}
//			}
//		}
//	}
//	m_pDC->EndPath();
//	m_pDC->StrokePath();
//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCDraw::Polyline.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::Polygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlNiKhAiMgAiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptaPoly	:_xZkqqHx_jClIjDfPiNmAjFfHiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPolySz		:_xZkqqHx_jEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmJiDfIiDfOiDeDiDiLiBgJjDfPjApMjDjJiBgKiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeB_xHqqkZx_Win95/98_xZkqqHx_iCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jFgAiJoGiCmFiCkLiCmIiCkCiClNiCnPiBeBjAoKjHhAiCmMjFgAiJoGiDiLiBfLiDgAiDjDiCmGiClFiCmEiNoMjAkMiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::Polygon (const CPoint* lgptaPoly, long lPolySz, const CRect& lgrtRgn)
{
	Polygon(FCLgPolyBezier(FALSE, lgptaPoly, lPolySz), lgrtRgn);
//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (m_eDrawWhich != FDDR_METAFILE)
//	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiImIiKePiBgJiJoGjGmKiBeBiDhGiDiKiDjDiDfOiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiBeBiClLiCmMjBlMiBgKiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		if (m_scidBrushForeSColor != FD_S_COLOR_UNUSE)
//		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iNmAjFfHjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
//			POINT* dvpta = new POINT[lPolySz];
//			mylg2dv(dvpta, lgptaPoly, lPolySz);
//			if (m_scidBrushBackSColor != FD_S_COLOR_UNUSE)
//			//----- _xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGiCkKjDkHjGlOiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				//----- _xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiPiIjHjN_xHqqkZx_ -----
//				m_pDC->BeginPath();
//				m_pDC->Polygon(dvpta, lPolySz);
//				m_pDC->EndPath();
//				m_pDC->FillPath();
//			}
//			// _xZkqqHx_iDhAiDfOiBfLiDjDjFgAiJoGiPiIjHjNiBeC_xHqqkZx_
//			FillPathWithPattern(dvpta, lPolySz, mylg2dv(lgrtRgn));
//			// _xZkqqHx_jFmPiKlHiNmAjFfHjEhKjHpBiCpAiNoNiPjMiBeC_xHqqkZx_
//			delete[] dvpta;
//			// _xZkqqHx_jApMjFgAiJoGiBeC_xHqqkZx_
//			Polyline(lgptaPoly, lPolySz);
//		} else
//		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			if (m_scidBrushBackSColor != FD_S_COLOR_UNUSE)
//			//----- _xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGiCkKjDkHjGlOiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iNmAjFfHjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
//				POINT* dvpta = new POINT[lPolySz];
//				mylg2dv(dvpta, lgptaPoly, lPolySz);
//				//----- _xZkqqHx_iDhAiDfIiNoMjAkM_xHqqkZx_ -----
//				m_pDC->BeginPath();
//				m_pDC->Polygon(dvpta, lPolySz);
//				m_pDC->EndPath();
//				// _xZkqqHx_jFmPiKlHiNmAjFfHjEhKjHpBiCpAiNoNiPjMiBeC_xHqqkZx_
//				delete[] dvpta;
//				// _xZkqqHx_iDhAiDfIiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
//				m_pDC->FillPath();
//				// HP DeskJet970Cxi/Win98_xZkqqHx_iCmFiDeHiDiJiBfLiCkKjEkNjAlGiClFiClNiCmMiCmFiBeBiLpDiCmMiDhJiDjDiCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//				// _xZkqqHx_iDhJiDjDiCkKjHeMiCoJiPoKiNiHiCmNjApMjFgAiJoGiBeC_xHqqkZx_
//				if (m_scidPenBackSColor != FD_S_COLOR_UNUSE)
//					Polyline(lgptaPoly, lPolySz);
//			} else
//			//----- _xZkqqHx_jEhHiMgJjAeGiCkKjDkHjGlOiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_jApMjFgAiJoGiBeC_xHqqkZx_
//				Polyline(lgptaPoly, lPolySz);
//			}
//		}
//	} else
//	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		if (m_scidBrushBackSColor != FD_S_COLOR_UNUSE)
//		//----- _xZkqqHx_jEhHiMgJjAeGiCkKjDkHjGlOiImIiKePiCmMiPoKiNiHiBgJiDiBiDfOiDhEiDeAiDeDiDiLiCmFiCmNiBeBjEhHiMgJjAeGjDkHjGlOiBiBjEhHiMgJjGlDiClFiBgK_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iNmAjFfHjFmPiKlHiClFiCmEiBeBiDhAiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//			POINT* dvpta = new POINT[lPolySz];
//			mylg2dv(dvpta, lgptaPoly, lPolySz);
//			m_pDC->BeginPath();
//			m_pDC->Polygon(dvpta, lPolySz);
//			m_pDC->EndPath();
//			delete[] dvpta;
//			if (m_scidPenBackSColor != FD_S_COLOR_UNUSE)
//			//----- _xZkqqHx_iDhJiDjDiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iDhAiDfIiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
//				m_pDC->FillPath();
//				// _xZkqqHx_jApMjFgAiJoGiBeC_xHqqkZx_
//				Polyline(lgptaPoly, lPolySz);
//			} else
//			//----- _xZkqqHx_iDhJiDjDiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iDhAiDfIiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
//				m_pDC->FillPath();
//			}
//		} else
//		//----- _xZkqqHx_jEhHiMgJjAeGiCkKjDkHjGlOiCmMiPoKiNiHiBgJiDiBiDfOiDhEiDeAiDeDiDiLiCmFiCmNiBeBjEhHiMgJjAeGjDkHjGlOiBiBjEhHiMgJjGlDiClFiBgK_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jApMjFgAiJoGiBeC_xHqqkZx_
//			Polyline(lgptaPoly, lPolySz);
//		}
//	}
//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCDraw::Polygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::Polyline
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlNiKhAjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptaPoly	:_xZkqqHx_jClIjDfPiNmAjFfHiCmMjEhKjHpBiCpAiOhHjCoIiBeCiDhMiDiKiDiJiDeDiDjDjEhKjHpBiBeFiDhIiDfHiDeGjEhKjHpBiCmM_xHqqkZx_
 *						 _xZkqqHx_iPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *			lPolySz		:_xZkqqHx_jEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::Polyline (const FCLgPolyBezier& lgptaPoly)
{
	// PS_NULL _xZkqqHx_iCmNiBeB_xHqqkZx_XEROX PS PagePrinter_xZkqqHx_iCmFiDeHiDiJiBfLiCkKiPgPiCoJiClNiCnPiBeBjDkHjGlOiCmMiPoKiNiHiCmN_xHqqkZx_
	// _xZkqqHx_iJlNiCoAjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
	if (m_scidPenBackSColor == FD_S_COLOR_UNUSE) return;
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFgAiJoGjFhDiJmCjEfMiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
//	const FCPenStyleRec* pPenStyleRec = g_pEnv->GetPenStyleRec(m_psidPenStyle);
//	if (m_mmfPenWeight < 0 || pPenStyleRec == NULL) return;
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFgAiJoGjFhDiJmCjEfMiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
	if (m_mmfPenWeight < 0) return;
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	if (m_eDrawWhich == FDDR_ENHANCED_METAFILE ||
		m_eDrawWhich == FDDR_PRINTER ||
		m_eDrawWhich == FDDR_PRINT_PREVIEW)
	//----- _xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiBeBiIpDiNpMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiHiBeBiMlLiNnNiCmMiDhJiDjDiCmJiDfIiDfOiDeDiDiLiDhAiDfOiBfLiDjDiCkKjBgHiCnNiNjOiCnMiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
		FCLgPolyBezier dvpt;
		mylg2dv(dvpt, lgptaPoly);
		// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMiDhNiDfIiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
		m_pDC->BeginPath();
		if (dvpt.GetIsBezier())
			m_pDC->PolyBezier(&dvpt.front(), dvpt.size());
		else
			m_pDC->Polyline(&dvpt.front(), dvpt.size());
		m_pDC->EndPath();
		m_pDC->StrokePath();
		return;
	}

	// _xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiImIiKePiCmFiCmNiBeBiDhIiDfHiDeGiLmIjApMiCmMjFgAiJoGiCmNjFhDiJmCiBeC_xHqqkZx_
	ASSERT(!lgptaPoly.GetIsBezier());

	// _xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiCmMiDhAiDfOiBfLiDjDjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD lgaData[4];
	GetPenStyleArray(lgaData);
	if (lgaData[0] == 0 && lgaData[1] == 0 &&
		lgaData[2] == 0 && lgaData[3] == 0)
	//----- _xZkqqHx_iDfIiDfOiDeDiDiLiCkKjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FCLgPolyBezier dvpt;
		mylg2dv(dvpt, lgptaPoly);
		// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMiDhNiDfIiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
		m_pDC->BeginPath();
		m_pDC->Polyline(&dvpt.front(), dvpt.size());
		m_pDC->EndPath();
		m_pDC->StrokePath();
		return;
	}

	m_pDC->BeginPath();
	long lDataC = 3;
	double dlgShort = 0;
	for (long lC = 1; lC < lgptaPoly.size(); lC++)
	{
		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjApMjFkKiBgJ_xHqqkZx_[lC-1] ~ [lC]_xZkqqHx_iBgKiCmMjBoFiCkLiClDiCpAiMhGiOfKiBeC_xHqqkZx_
		const DBLPoint dlgptLine = DBLPoint(lgptaPoly[lC]) - DBLPoint(lgptaPoly[lC - 1]);
		// _xZkqqHx_jIeBjBlBiClHiCoJiCfBjDfPiCkKjDkPiClGiNmAjFfHiCmIiCoHiCmOiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (dlgptLine.IsNull()) continue;
		const double dlgLineLen = dlgptLine.Len();

		//----- _xZkqqHx_iCnMiClIiBeBjFgAiJoGiCmMiOgDiCoIiLjHjHkDiBgJ_xHqqkZx_dlgShort_xZkqqHx_iBgKiCpAiPiIjHjNiClHiCoJ_xHqqkZx_ -----

		if (dlgLineLen < dlgShort)
		//----- _xZkqqHx_jFgAiJoGiCmMiOgDiCoIiLjHjHkDiCkKiBeBiDfOiBfLiDfBiDgCiDgHiCmMjApMjFkKiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			dlgShort -= dlgLineLen;
			if (!(lDataC & 1))
			//----- _xZkqqHx_iLpEjAjEiBeBiClHiCmIiCoNiClPjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
			{
				MoveTo(lgptaPoly[lC - 1]);
				LineTo(lgptaPoly[lC]);
			}
			continue;
		} else
		//----- _xZkqqHx_jFgAiJoGiCmMiOgDiCoIiLjHjHkDiCkKiBeBiDfOiBfLiDfBiDgCiDgHiCmMjApMjFkKiCpAiJlKiJpBiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (!(lDataC & 1))
			//----- _xZkqqHx_iLpEjAjEiBeBiClHiCmIiCoNiClPjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
			{
				DBLPoint dlgptA = DBLPoint(lgptaPoly[lC - 1]) + (dlgptLine * (dlgShort / dlgLineLen));
				MoveTo(lgptaPoly[lC - 1]);
				LineTo(D2L(dlgptA.x), D2L(dlgptA.y));
			}
		}

		//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjApMjFkKiCpAiBeBiDfIiDfOiDeDiDiLjEhKjHpBiBgJ_xHqqkZx_lgaData_xZkqqHx_iBgKiCmFjFkKiKiEjFgAiJoGiClHiCoJ_xHqqkZx_ -----

		for (;;)
		{
			lDataC++;
			if (4 <= lDataC) lDataC = 0;

			if (!(lDataC & 1))
			//----- _xZkqqHx_iLpEjAjEiBeBiClHiCmIiCoNiClPjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFgAiJoGiKeKiOgOjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
				DBLPoint dlgptA = DBLPoint(lgptaPoly[lC - 1]) + (dlgptLine * (dlgShort / dlgLineLen));
				dlgShort += lgaData[lDataC];
				if (dlgLineLen < dlgShort)
				//----- _xZkqqHx_jFgAiJoGiLjHjHkDiCkKiBeBiDfOiBfLiDfBiDgCiDgHjApMjFkKiCmMjFgAiCkLiOgDiClFiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iNmFiMoDiCnMiCmFjFgAiCkLiCkLiCoJiBeC_xHqqkZx_
					MoveTo(D2L(dlgptA.x), D2L(dlgptA.y));
					LineTo(lgptaPoly[lC]);
					// _xZkqqHx_jFgAiJoGiCmMiOgDiCoIiLjHjHkDiBgJ_xHqqkZx_dlgShort_xZkqqHx_iBgKiCpAiOfKiPgPiBeC_xHqqkZx_
					dlgShort -= dlgLineLen;
					break;
				}
				// _xZkqqHx_jFgAiJoGiPeJjHlJjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
				DBLPoint dlgptB = DBLPoint(lgptaPoly[lC - 1]) + (dlgptLine * (dlgShort / dlgLineLen));
				// _xZkqqHx_jFgAiJoGiClHiCoJiBeC_xHqqkZx_
				MoveTo(D2L(dlgptA.x), D2L(dlgptA.y));
				LineTo(D2L(dlgptB.x), D2L(dlgptB.y));
			} else
			//----- _xZkqqHx_iKoPjAjEiBeBiClHiCmIiCoNiClPiKnEiMiEiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDfIiDfOiDeDiDiLjEhKjHpBiCmMiBeBiKnEiMiEiLjHjHkDiCpAiMlLiNnNiCmMjFgAiJoGiImKjChFiBgJ_xHqqkZx_dlgShort_xZkqqHx_iBgKiCmJiJmBiOfKiBeC_xHqqkZx_
				dlgShort += lgaData[lDataC];
				if (dlgLineLen < dlgShort)
				//----- _xZkqqHx_jFgAiJoGiLjHjHkDiCkKiBeBiDfOiBfLiDfBiDgCiDgHjApMjFkKiCmMjFgAiCkLiOgDiClFiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_jFgAiJoGiCmMiOgDiCoIiLjHjHkDiBgJ_xHqqkZx_dlgShort_xZkqqHx_iBgKiCpAiOfKiPgPiBeC_xHqqkZx_
					dlgShort -= dlgLineLen;
					break;
				}
			}
		}
	}
	m_pDC->EndPath();
	m_pDC->StrokePath();
} // FCDraw::Polyline.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::Polygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlNiKhAiMgAiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptaPoly	:_xZkqqHx_jClIjDfPiNmAjFfHiCmMjEhKjHpBiCpAiOhHjCoIiBeCiDhMiDiKiDiJiDeDiDjDjEhKjHpBiBeFiDhIiDfHiDeGjEhKjHpBiCmM_xHqqkZx_
 *						 _xZkqqHx_iPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *			lPolySz		:_xZkqqHx_jEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmJiDfIiDfOiDeDiDiLiBgJjDfPjApMjDjJiBgKiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeB_xHqqkZx_Win95/98_xZkqqHx_iCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jFgAiJoGiCmFiCkLiCmIiCkCiClNiCnPiBeBjAoKjHhAiCmMjFgAiJoGiDiLiBfLiDgAiDjDiCmGiClFiCmEiNoMjAkMiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::Polygon (const FCLgPolyBezier& lgptaPoly, const CRect& lgrtRgn)
{
	if (m_eDrawWhich != FDDR_METAFILE)
	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiImIiKePiBgJiJoGjGmKiBeBiDhGiDiKiDjDiDfOiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiBeBiClLiCmMjBlMiBgKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_scidBrushForeSColor != FD_S_COLOR_UNUSE)
		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNmAjFfHjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
			FCLgPolyBezier dvpt;
			mylg2dv(dvpt, lgptaPoly);
			if (m_scidBrushBackSColor != FD_S_COLOR_UNUSE)
			//----- _xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGiCkKjDkHjGlOiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
			{
				//----- _xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiPiIjHjN_xHqqkZx_ -----
				m_pDC->BeginPath();
				if (dvpt.GetIsBezier())
					m_pDC->PolyBezier(&dvpt.front(), dvpt.size());
				else
					m_pDC->Polyline(&dvpt.front(), dvpt.size());
				m_pDC->EndPath();
				m_pDC->FillPath();
			}
			// _xZkqqHx_iDhAiDfOiBfLiDjDjFgAiJoGiPiIjHjNiBeC_xHqqkZx_
			FillPathWithPattern(dvpt, mylg2dv(lgrtRgn));
			// _xZkqqHx_jApMjFgAiJoGiBeC_xHqqkZx_
			Polyline(lgptaPoly);
		} else
		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			if (m_scidBrushBackSColor != FD_S_COLOR_UNUSE)
			//----- _xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGiCkKjDkHjGlOiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iNmAjFfHjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
				FCLgPolyBezier dvpt;
				mylg2dv(dvpt, lgptaPoly);
				//----- _xZkqqHx_iDhAiDfIiNoMjAkM_xHqqkZx_ -----
				m_pDC->BeginPath();
				if (dvpt.GetIsBezier())
					m_pDC->PolyBezier(&dvpt.front(), dvpt.size());
				else
					m_pDC->Polyline(&dvpt.front(), dvpt.size());
				m_pDC->EndPath();
				// _xZkqqHx_iDhAiDfIiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
				m_pDC->FillPath();
				// HP DeskJet970Cxi/Win98_xZkqqHx_iCmFiDeHiDiJiBfLiCkKjEkNjAlGiClFiClNiCmMiCmFiBeBiLpDiCmMiDhJiDjDiCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
				// _xZkqqHx_iDhJiDjDiCkKjHeMiCoJiPoKiNiHiCmNjApMjFgAiJoGiBeC_xHqqkZx_
				if (m_scidPenBackSColor != FD_S_COLOR_UNUSE)
					Polyline(lgptaPoly);
			} else
			//----- _xZkqqHx_jEhHiMgJjAeGiCkKjDkHjGlOiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jApMjFgAiJoGiBeC_xHqqkZx_
				Polyline(lgptaPoly);
			}
		}
	} else
	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiHiBeBiDhIiDfHiDeGiLmIjApMiCmFiCmMjFgAiJoGiCmNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
		if (lgptaPoly.GetIsBezier())
			FFThrowMiscUnknown();
		if (m_scidBrushBackSColor != FD_S_COLOR_UNUSE)
		//----- _xZkqqHx_jEhHiMgJjAeGiCkKjDkHjGlOiImIiKePiCmMiPoKiNiHiBgJiDiBiDfOiDhEiDeAiDeDiDiLiCmFiCmNiBeBjEhHiMgJjAeGjDkHjGlOiBiBjEhHiMgJjGlDiClFiBgK_xHqqkZx_ -----
		{
			// _xZkqqHx_iNmAjFfHjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
			FCLgPolyBezier dvpt;
			mylg2dv(dvpt, lgptaPoly);
			m_pDC->BeginPath();
			// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmN_xHqqkZx_ Polyline _xZkqqHx_iCmFiCmNjFgAiJoGiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
			m_pDC->Polygon(&dvpt.front(), dvpt.size());
			m_pDC->EndPath();
			// _xZkqqHx_iDhAiDfIiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
			m_pDC->FillPath();
			if (m_scidPenBackSColor != FD_S_COLOR_UNUSE)
			//----- _xZkqqHx_iDhJiDjDiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jApMjFgAiJoGiBeC_xHqqkZx_
				Polyline(lgptaPoly);
			}
		} else
		//----- _xZkqqHx_jEhHiMgJjAeGiCkKjDkHjGlOiCmMiPoKiNiHiBgJiDiBiDfOiDhEiDeAiDeDiDiLiCmFiCmNiBeBjEhHiMgJjAeGjDkHjGlOiBiBjEhHiMgJjGlDiClFiBgK_xHqqkZx_ -----
		{
			// _xZkqqHx_jApMjFgAiJoGiBeC_xHqqkZx_
			Polyline(lgptaPoly);
		}
	}
} // FCDraw::Polygon.

//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::PolyBezier
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptaPoly:_xZkqqHx_iDfIiDhGiDiJiDeDiDjDiCmMjCfLjDfPiCmGjAkHiMoEjDfPiCpAiOjNiCmC_xHqqkZx_ POINT _xZkqqHx_iDgGiBfLiDfOiNfMjBkCjBmMiCmMjEhKjHpBiCnGiCmMiDhMiDeDiDjDiDfOiBeC_xHqqkZx_ 
// *			lPolySz	:lpPoints _xZkqqHx_jEhKjHpBjDoAiCmMjDfPiCmMjAjEiCpAiOhHjCoIiClFiCnMiClHiBeCiClBiCmMjCgMiCmJiCmN_xHqqkZx_
// *					 _xZkqqHx_jFgAiJoGiClHiCoJiDfIiDhGiDiJiDeDiDjDiCmMjAjEiCmM_xHqqkZx_ 3 _xZkqqHx_jEhLiCoGiCoIiCoA_xHqqkZx_ 1 _xZkqqHx_jBoFiCkLiCkCjCgMiCpA_xHqqkZx_
// *					 _xZkqqHx_iOhHjCoIiClHiCoJjFeLjHhGiCkKiCkAiCoIiCnMiClHiBeCiClLiCmMjHjNjHfCiCmNiBeBiDhIiDfHiDeH_xHqqkZx_ _xZkqqHx_iDfIiDhGiDiJiDeDiDjDiCmNiBeB_xHqqkZx_
// *					 2 _xZkqqHx_iCmCiCmMjAkHiMoEjDfPiCmG_xHqqkZx_ 1 _xZkqqHx_iCmCiCmMjCfLjDfPiCpAjFeLjHhGiCmGiClFiBeBiClDiCoHiCmJiNmFiPiJiCmM_xHqqkZx_
// *					 _xZkqqHx_iDfIiDhGiDiJiDeDiDjDiCmMiOgOjDfPiCkKjFeLjHhGiCmIiClNiCnPiCmFiClHiBeC_xHqqkZx_ 
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCDraw::PolyBezier (const CPoint* lgptaPoly, long lPolySz)
//{
//	// PS_NULL _xZkqqHx_iCmNiBeB_xHqqkZx_XEROX PS PagePrinter_xZkqqHx_iCmFiDeHiDiJiBfLiCkKiPgPiCoJiClNiCnPiBeBjDkHjGlOiCmMiPoKiNiHiCmN_xHqqkZx_
//	// _xZkqqHx_iJlNiCoAjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
//	if (m_scidPenBackSColor == FD_S_COLOR_UNUSE) return;
//	// _xZkqqHx_jFgAiJoGjFhDiJmCjEfMiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
//	const FCPenStyleRec* pPenStyleRec = g_pEnv->GetPenStyleRec(m_psidPenStyle);
//	if (m_mmfPenWeight < 0 || pPenStyleRec == NULL) return;
//	// 
//	m_pDC->BeginPath();
//	POINT* dvpta = new POINT[lPolySz];
//	mylg2dv(dvpta, lgptaPoly, lPolySz);
//	m_pDC->PolyBezier(dvpta, lPolySz);
//	delete[] dvpta;
//	m_pDC->EndPath();
//	m_pDC->StrokePath();
//} // FCDraw::PolyBezier.
//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::Line
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jClMjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptFrom	:_xZkqqHx_jApMiCmMiOgOjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgptTo		:_xZkqqHx_jApMiCmMiPeJjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmJiDfIiDfOiDeDiDiLiBgJjDfPjApMjDjJiBgKiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeB_xHqqkZx_Win95/98_xZkqqHx_iCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jFgAiJoGiCmFiCkLiCmIiCkCiClNiCnPiBeBjAoKjHhAiCmMjFgAiJoGiDiLiBfLiDgAiDjDiCmGiClFiCmEiNoMjAkMiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::Line (const CPoint& lgptFrom, const CPoint& lgptTo)
{
	if (m_psidPenStyle == FD_PEN_STYLE_SOLID)
	{
		// PS_NULL _xZkqqHx_iCmNiBeB_xHqqkZx_XEROX PS PagePrinter_xZkqqHx_iCmFiDeHiDiJiBfLiCkKiPgPiCoJiClNiCnPiBeBjDkHjGlOiCmMiPoKiNiHiCmN_xHqqkZx_
		// _xZkqqHx_iJlNiCoAjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
		if (m_scidPenBackSColor == FD_S_COLOR_UNUSE) return;
		m_pDC->BeginPath();
		MoveTo(lgptFrom);
		LineTo(lgptTo);
		m_pDC->EndPath();
		m_pDC->StrokePath();
		return;
	}
	CPoint lgptaPoly[2] = { lgptFrom, lgptTo };
	Polyline(lgptaPoly, 2);
} // FCDraw::Line.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::FillRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLoJiMgAiCpAjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgrt	:_xZkqqHx_jDgIiCoIiCmCiCnEiClHjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::FillRect (const CRect& lgrt, const CRect& lgrtRgn)
{
	// Rectangle + StrokeAndFillPath _xZkqqHx_iCmNiBeB_xHqqkZx_95_xZkqqHx_iCmFjDkOiNoMiClFiCmIiCkCiBeC_xHqqkZx_
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//	POINT pt[] = {	{ lgrt.left - m_lgOffsetX, lgrt.top - m_lgOffsetY },
//					{ lgrt.right - m_lgOffsetX, lgrt.top - m_lgOffsetY },
//					{ lgrt.right - m_lgOffsetX, lgrt.bottom - m_lgOffsetY },
//					{ lgrt.left - m_lgOffsetX, lgrt.bottom - m_lgOffsetY },
//					{ lgrt.left - m_lgOffsetX, lgrt.top - m_lgOffsetY } };
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	POINT pt[] = {	{ mylgx2dvx(lgrt.left),
//					  mylgy2dvy(lgrt.top) },
//					{ mylgx2dvx(lgrt.right),
//					  mylgy2dvy(lgrt.top) },
//					{ mylgx2dvx(lgrt.right),
//					  mylgy2dvy(lgrt.bottom) },
//					{ mylgx2dvx(lgrt.left),
//					  mylgy2dvy(lgrt.bottom) },
//					{ mylgx2dvx(lgrt.left),
//					  mylgy2dvy(lgrt.top) } };
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCLgPolyBezier pt;
	pt.push_back(CPoint(mylgx2dvx(lgrt.left), mylgy2dvy(lgrt.top)));
	pt.push_back(CPoint(mylgx2dvx(lgrt.right), mylgy2dvy(lgrt.top)));
	pt.push_back(CPoint(mylgx2dvx(lgrt.right), mylgy2dvy(lgrt.bottom)));
	pt.push_back(CPoint(mylgx2dvx(lgrt.left), mylgy2dvy(lgrt.bottom)));
	pt.push_back(CPoint(mylgx2dvx(lgrt.left), mylgy2dvy(lgrt.top)));
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	if (m_eDrawWhich != FDDR_METAFILE)
	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiImIiKePiBgJiJoGjGmKiBeBiDhGiDiKiDjDiDfOiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiBgKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_scidBrushBackSColor != FD_S_COLOR_UNUSE)
		//----- _xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGiCkKjDkHjGlOiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_iDhAiDfIiNoMjAkM_xHqqkZx_ -----
			m_pDC->BeginPath();
			m_pDC->Polygon(&pt.front(), pt.size());
			m_pDC->EndPath();
			// _xZkqqHx_iDhAiDfIiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
			m_pDC->FillPath();
		}
		if (m_scidBrushForeSColor != FD_S_COLOR_UNUSE)
		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhAiDfOiBfLiDjDjFgAiJoGiPiIjHjNiBeC_xHqqkZx_
			FillPathWithPattern(pt, mylg2dv(lgrtRgn));
		}
	} else
	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_scidBrushBackSColor != FD_S_COLOR_UNUSE)
		//----- _xZkqqHx_jEhHiMgJjAeGiCkKjDkHjGlOiImIiKePiCmMiPoKiNiHiBgJiDiBiDfOiDhEiDeAiDeDiDiLiCmFiCmNiBeBjEhHiMgJjAeGjDkHjGlOiBiBjEhHiMgJjGlDiClFiBgK_xHqqkZx_ -----
		{
			//----- _xZkqqHx_iDhAiDfIiNoMjAkM_xHqqkZx_ -----
			m_pDC->BeginPath();
			m_pDC->Polygon(&pt.front(), pt.size());
			m_pDC->EndPath();
			// _xZkqqHx_iDhAiDfIiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
			m_pDC->FillPath();
		}
	}
} // FCDraw::FillRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::RectLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLpDiCmMiLoJiMgAiBgJiDhEiDiMiBfLiDiAiCmMiCnNiBgKiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgrt	:_xZkqqHx_iLoJiMgAiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::RectLine (const CRect& lgrt)
{
	CPoint lgptaPoly[5] = { CPoint(lgrt.left, lgrt.top), CPoint(lgrt.right, lgrt.top),
							CPoint(lgrt.right, lgrt.bottom),
							CPoint(lgrt.left, lgrt.bottom), CPoint(lgrt.left, lgrt.top) };
	Polyline(lgptaPoly, 5);
} // FCDraw::RectLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawOLE
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pOle		:OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgrt		:_xZkqqHx_jFgAiJoGiClHiCoJ_xHqqkZx_ OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCmJiKePjAnKiClHiCoJiOgMiKhAiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nDrawAspect	:OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiKePiKmPiBeBiCmCiCnMiCoIiDeBiDeDiDgFiDiAiCpAjFfMiOkGiClHiCoJjFpLjGeAiCpA_xHqqkZx_
 *						 _xZkqqHx_iOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiPeJjHlJiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDraw::DrawOLE (	COleClientItem* pOle, const CRect& lgrt,
						DVASPECT nDrawAspect)
{
	// OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCpAjFfMiOkGiBeC_xHqqkZx_
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//	return pOle->Draw(m_pDC, CRect(lgrt.left - m_lgOffsetX, lgrt.top - m_lgOffsetY,
//						lgrt.right - m_lgOffsetX, lgrt.bottom - m_lgOffsetY),
//						nDrawAspect);
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	CRect rtOle(mylgx2dvx(lgrt.left),
				mylgy2dvy(lgrt.top),
				mylgx2dvx(lgrt.right),
				mylgy2dvy(lgrt.bottom));
	// _xZkqqHx_jAhNiMgAiDfEiDeDiDfJiCkKiCePiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	// _xZkqqHx_iDfJiBfLiDiAiCpAiPkMiClDiCkNiClFiClNiPoKiNiHiCmJiCkAiCoIiCkGiCoJiBeCiDfEiDeDiDfJiCkKiCePiCmM_xHqqkZx_OLE_xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_jFgAiJoGiClFiCoGiCkEiCmGiClHiCoJiCmGiDeHiDiJiBfLiCkKjEkNjAlGiClHiCoJiBeC_xHqqkZx_
	if (rtOle.IsRectEmpty()) return FALSE;
	return pOle->Draw(m_pDC, rtOle, nDrawAspect);
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
} // FCDraw::DrawOLE.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::PlayMetaFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDraw::PlayMetaFile (	HENHMETAFILE hEnhMetaFile,
							const CRect& lgrtBounds,
							const CRect& lgrtFrame,
							const FCLgPolyBezier& lgptaPoly,
							BOOL bTileH, BOOL bTileV)
{
	// CDC_xZkqqHx_iCmMiPpDjBnEiCpAjFnLjBlGiBeC_xHqqkZx_SelectClipPath _xZkqqHx_iCmFiDeOiDiKiDgCiDhGiCpAjFmPiNfIiClHiCoJiClNiCnPiBeC_xHqqkZx_
	m_pDC->SaveDC();
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	POINT* dvpt = new POINT[lPolySize + 1];
//	mylg2dv(dvpt, lgptaPoly, lPolySize);
//	if (dvpt[lPolySize - 1].x != dvpt[0].x || dvpt[lPolySize - 1].y != dvpt[0].y)
//	{
//		dvpt[lPolySize] = dvpt[0];
//		lPolySize++;
//	}
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCLgPolyBezier dvpt;
	mylg2dv(dvpt, lgptaPoly);
	if (dvpt.back().x != dvpt.front().x || dvpt.back().y != dvpt.front().y)
		dvpt.push_back(dvpt[0]);
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMiDhNiDfIiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
	m_pDC->BeginPath();
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_pDC->Polygon(dvpt, lPolySize);
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (dvpt.GetIsBezier())
		m_pDC->PolyBezier(&dvpt.front(), dvpt.size());
	else
		m_pDC->Polygon(&dvpt.front(), dvpt.size());
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	m_pDC->EndPath();
	m_pDC->SelectClipPath(RGN_AND);
// 05.04.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	delete[] dvpt;
	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLjFgAiJoGiImKjChFiCpAiMhGiOfKiBeC_xHqqkZx_
	const CRect dvrtBounds = mylg2dv(lgrtBounds);
	// _xZkqqHx_iDhMiDiKiDfDiDjDiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
	CRect dvrtFrame = mylg2dv(lgrtFrame);
	long lBoundsW = dvrtBounds.Width();
	long lBoundsH = dvrtBounds.Height();
	CRect dvrtDraw = dvrtBounds;
	do
	{
		do
		{
			if (!m_pDC->PlayMetaFile(hEnhMetaFile, dvrtDraw))
			{
				m_pDC->RestoreDC(-1);
				return FALSE;
			}
			dvrtDraw.left += lBoundsW;
			dvrtDraw.right += lBoundsW;
		} while (bTileH && dvrtDraw.left < dvrtFrame.right);
		dvrtDraw.left = dvrtBounds.left;
		dvrtDraw.right = dvrtBounds.right;
		dvrtDraw.top += lBoundsH;
		dvrtDraw.bottom += lBoundsH;
	} while (bTileV && dvrtDraw.top < dvrtFrame.bottom);

	m_pDC->RestoreDC(-1);
	return TRUE;
} // FCDraw::PlayMetaFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::GetPenStyleArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhJiDjDiDfIiDfOiDeDiDiLiCmMiDhAiDfOiBfLiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgaData	:_xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiCmMiDhAiDfOiBfLiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
  * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::GetPenStyleArray (DWORD lgaData[]) const
{
	const FCPenStyleRec* pPenStyleRec = g_pEnv->GetPenStyleRec(m_psidPenStyle);
	if (almost0(pPenStyleRec->m_mmfaData[0]) && almost0(pPenStyleRec->m_mmfaData[1]) &&
		almost0(pPenStyleRec->m_mmfaData[2]) && almost0(pPenStyleRec->m_mmfaData[3]))
	//----- _xZkqqHx_iDfIiDfOiDeDiDiLiCkKjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		lgaData[0] = 0;
		lgaData[1] = 0;
		lgaData[2] = 0;
		lgaData[3] = 0;
	} else
	//----- _xZkqqHx_iDfIiDfOiDeDiDiLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhJiDjDjFjN_xHqqkZx_ 0.25mm_xZkqqHx_iCkKjFfHiPiAiBgJiCfAiBgKiCmGiCmIiCoJiCoGiCkEiCmJiBeBiCfDjEhLiClHiCoJiBeC_xHqqkZx_
		double mmW = m_mmfPenWeight * 4.0;
		if (mmW < 1.0) mmW = 1.0;
		for (int i = 0; i != 4; i++)
		{
			lgaData[i] = mymm2lg(pPenStyleRec->m_mmfaData[i] * mmW);
			// 0_xZkqqHx_iCmJiCmIiCoJiCmGiBeBiImIiJlKiCmMjFgAiJoGiPiIjHjNiCmFjGlDiMmAiDiLiBfLiDhGiCmJiKnHiCoJiClNiCnPiBeC_xHqqkZx_
			if (lgaData[i] == 0) lgaData[i] = 1;
		}
	}
} // FCDraw::GetPenStyleArray.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::mymm2lg
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiBfLiDeKiDiLiCmMiDfJiBfLiDiAjCgM_xHqqkZx_ m_dZoom _xZkqqHx_iCmJiKoOiCmDiCkCiCmEiOmAiNmAjFfHiCpAjIfPjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mm	:_xZkqqHx_iOmAiNmAjFfHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIfPjHjNiNmAjFfHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCDraw::mymm2lg (mmetol mm) const
{
	return D2L(m_dZoom * mm);
} // FCDraw::mymm2lg.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::mymm2lg
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiBfLiDeKiDiLiCmMiDfJiBfLiDiAjCgM_xHqqkZx_ m_dZoom _xZkqqHx_iCmJiKoOiCmDiCkCiCmEiOmAiNmAjFfHiCpAjIfPjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	drct	:_xZkqqHx_iOmAiNmAjFfHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIfPjHjNiNmAjFfHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect FCDraw::mymm2lg (const DBLRect& drct) const
{
	return CRect(mymm2lg(drct.left), mymm2lg(drct.top),
				 mymm2lg(drct.right), mymm2lg(drct.bottom));
} // FCDraw::mymm2lg.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::mylg2dv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIfPjHjNiNmAjFfHiCmJiBeBiDeJiDhEiDfKiDgCiDgHiCpAiJmBiOfKiClFiCmEiDgGiDgPiDeDiDfIiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dvpt	:_xZkqqHx_iDgGiDgPiDeDiDfIiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lgpt	:_xZkqqHx_jIfPjHjNiNmAjFfHjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCount	:lgpt_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::mylg2dv (POINT* dvpt, const POINT* lgpt, long lCount) const
{
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//	for (long lC = 0; lC < lCount; lC++)
//	{
//		dvpt[lC].x = lgpt[lC].x - m_lgOffsetX;
//		dvpt[lC].y = lgpt[lC].y - m_lgOffsetY;
//	}
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	for (long lC = 0; lC != lCount; lC++)
	{
		dvpt[lC].x = mylgx2dvx(lgpt[lC].x);
		dvpt[lC].y = mylgy2dvy(lgpt[lC].y);
	}
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
} // FCDraw::mylg2dv.

CRect FCDraw::mylg2dv (const CRect& lgrt) const
{
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//	return CRect(lgrt.left - m_lgOffsetX, lgrt.top - m_lgOffsetY,
//				 lgrt.right - m_lgOffsetX, lgrt.bottom - m_lgOffsetY);
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	return CRect(mylgx2dvx(lgrt.left),
				 mylgy2dvy(lgrt.top),
				 mylgx2dvx(lgrt.right),
				 mylgy2dvy(lgrt.bottom));
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
} // FCDraw::mylg2dv.

void FCDraw::mylg2dv (FCLgPolyBezier& dvpt, const FCLgPolyBezier& lgpt) const
{
	dvpt.SetIsBezier(lgpt.GetIsBezier());
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	dvpt.assign(lgpt.size());
	for (long lC = 0; lC != lgpt.size(); lC++)
	{
		dvpt[lC].x = mylgx2dvx(lgpt[lC].x);
		dvpt[lC].y = mylgy2dvy(lgpt[lC].y);
	}
} // FCDraw::mylg2dv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::MoveTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIfPjHjNiNmAjFfHiCpAiDgGiDgPiDeDiDfIiNmAjFfHiCmJjFmPiKlHiClFiCmEiBeB_xHqqkZx_MoveTo_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpt	:_xZkqqHx_jIfPjHjNiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::MoveTo (const CPoint& lgpt)
{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
//	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
//	m_pDC->MoveTo(mylgx2dvx(lgpt.x),
//				  mylgy2dvy(lgpt.y));
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	MoveTo(lgpt.x, lgpt.y);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCDraw::MoveTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::MoveTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIfPjHjNiNmAjFfHiCpAiDgGiDgPiDeDiDfIiNmAjFfHiCmJjFmPiKlHiClFiCmEiBeB_xHqqkZx_MoveTo_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgX, lgY	:_xZkqqHx_jIfPjHjNiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::MoveTo (long lgX, long lgY)
{
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	// mylgx2dvx, mylgx2dvy _xZkqqHx_iCmFjAkHiMmAiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_pDC->MoveTo(mylgx2dvx(lgX), mylgy2dvy(lgY));
	myMoveTo(m_pDC, m_lgptLastMoveTo, mylgx2dvx(lgX), mylgy2dvy(lgY));
} // FCDraw::MoveTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::LineTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIfPjHjNiNmAjFfHiCpAiDgGiDgPiDeDiDfIiNmAjFfHiCmJjFmPiKlHiClFiCmEiBeB_xHqqkZx_LineTo_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpt	:_xZkqqHx_jIfPjHjNiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::LineTo (const CPoint& lgpt)
{
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_pDC->LineTo(mylgx2dvx(lgpt.x), mylgy2dvy(lgpt.y));
	LineTo(lgpt.x, lgpt.y);
} // FCDraw::LineTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::LineTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIfPjHjNiNmAjFfHiCpAiDgGiDgPiDeDiDfIiNmAjFfHiCmJjFmPiKlHiClFiCmEiBeB_xHqqkZx_LineTo_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgX, lgY	:_xZkqqHx_jIfPjHjNiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::LineTo (long lgX, long lgY)
{
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	// mylgx2dvx, mylgx2dvy _xZkqqHx_iCmFjAkHiMmAiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_pDC->LineTo(mylgx2dvx(lgX), mylgy2dvy(lgY));
	myLineTo(m_pDC, m_lgptLastMoveTo, mylgx2dvx(lgX), mylgy2dvy(lgY));
} // FCDraw::LineTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::FillPathWithPattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjHmMiIoGiCpAiBeBiMlLiNnNiCmMiDhAiDfOiBfLiDjDiCmFjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dvptaPoly	:_xZkqqHx_jHmMiIoGiCpAiOhHjCoIiClHiCoJiNmAjFfHjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPolySz		:pPoint_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dvrtRgn		:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_iLpDiCmMiLoJiMgA_xHqqkZx_ _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//void FCDraw::FillPathWithPattern (const POINT* dvptaPoly, long lPolySz,
//									const CRect& dvrtRgn)
//{
//	ASSERT(m_eDrawWhich != FDDR_METAFILE);
//	CRect dvrtFrame;
//	::FFCalcFrame(dvrtFrame, lPolySz, (const CPoint*)dvptaPoly);
//	// _xZkqqHx_jFgAiJoGjHmMiIoGiCkKjGlDiCkCiBgJjFjN_xHqqkZx_or_xZkqqHx_iNiCiClDiCkK_xHqqkZx_0_xZkqqHx_iBgKiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (dvrtFrame.IsRectEmpty()) return;
//	m_pDC->SaveDC();
//	if (m_eDrawWhich == FDDR_DISPLAY)
//	//----- _xZkqqHx_iJoGjGmKiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// 0.2mm_xZkqqHx_iCpAiDhAiDfOiBfLiDjDiCmMiCfAiDeBiDgHiDiAiCmJjAnNjCoIiBeC_xHqqkZx_
//		long lgLineW = mymm2lg(0.2);
//		if (lgLineW == 0) lgLineW = 1;
//		CRect rtCanvas(0, 0, 0, 0);
//		DrawPattern(NULL, 0, lgLineW, rtCanvas, m_ptidBrushPattern, rtCanvas);
//		const long lCanvasW = rtCanvas.Width();
//		const long lCanvasH = rtCanvas.Height();
//		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCpAiNoMjAkM_xHqqkZx_ -----
//		CBitmap bitmap;
//		bitmap.CreateBitmap(lCanvasW, lCanvasH, m_pDC->GetDeviceCaps(PLANES),
//							m_pDC->GetDeviceCaps(BITSPIXEL), NULL);
//		// _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_CDC_xZkqqHx_iCmJiDhCiDgCiDgHiDhNiDgCiDhGiCpAjAnNjCoI_xHqqkZx_.
//		CDC	dcMem;
//		dcMem.CreateCompatibleDC(m_pDC);
//		dcMem.SelectObject(&bitmap);
//		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoG_xHqqkZx_ -----
//		dcMem.SetWindowOrg(0, 0);
//		dcMem.FillRect(rtCanvas,
//					CBrush::FromHandle((HBRUSH)GetStockObject(BLACK_BRUSH)));
//		DrawPattern(&dcMem, ::OptiColor(g_pEnv->scid2cref(m_scidBrushForeSColor)),
//					lgLineW, rtCanvas, m_ptidBrushPattern, rtCanvas);
//		//----- _xZkqqHx_iDhNiDfIiDeOiDhCiDgCiDgHiDhNiDgCiDhGiCpAiNoMjAkM_xHqqkZx_ -----
//		CBitmap bitMask;
//		bitMask.CreateBitmap(lCanvasW, lCanvasH, 1, 1, NULL);
//		CDC	dcMask;
//		dcMask.CreateCompatibleDC(m_pDC);
//		dcMask.SelectObject(&bitMask);
//		//----- _xZkqqHx_iDhNiDfIiDeOiCpAjFgAiJoG_xHqqkZx_ -----
//		dcMask.SetWindowOrg(0, 0);
//		dcMask.FillRect(rtCanvas,
//					CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));
//		DrawPattern(&dcMask, FD_COLREF_BLACK, lgLineW, rtCanvas, m_ptidBrushPattern, rtCanvas);
//
//		// _xZkqqHx_jFeLjHhGiCmIjFjEjFkKiClOiCkPiDeOiDiKiDgCiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
//		m_pDC->BeginPath();
//		m_pDC->Polygon((POINT*)dvptaPoly, lPolySz);
//		m_pDC->EndPath();
//		m_pDC->SelectClipPath(RGN_AND);
//		// _xZkqqHx_jFgAiJoGiCkKjFeLjHhGiCmIiDiKiBfLiDfHiDiHiDjDiCpAiOfKiPgPiBeC_xHqqkZx_
//		CRect dvrtClient = dvrtFrame;
//		if (!dvrtRgn.IsRectEmpty())
//			dvrtClient &= dvrtRgn;
//		long lY = dvrtFrame.top;
//		for (;;)
//		{
//			lY += lCanvasH;
//			if (dvrtClient.top <= lY) break;
//		}
//		lY -= lCanvasH;
//		for (;;)
//		{
//			if (dvrtClient.bottom < lY) break;
//			long lX = dvrtFrame.left;
//			for (;;)
//			{
//				lX += lCanvasW;
//				if (dvrtClient.left <= lX) break;
//			}
//			lX -= lCanvasW;
//			for (;;)
//			{
//				if (dvrtClient.right < lX) break;
//				// _xZkqqHx_iCnMiClIiDhNiDfIiDeOiCmFiBeBiDhAiDfOiBfLiDjDjFjEjFkKiCpAiLpDiCkPiCoJiBeC_xHqqkZx_
//				m_pDC->BitBlt(lX, lY, lCanvasW, lCanvasH, &dcMask, 0, 0, SRCAND);
//				// _xZkqqHx_iLpDiCkCiClNiDhAiDfOiBfLiDjDjFjEjFkKiCmJiBeBiDhAiDfOiBfLiDjDiCpAjEoNiClJiCoJiBeC_xHqqkZx_
//				m_pDC->BitBlt(lX, lY, lCanvasW, lCanvasH, &dcMem, 0, 0, SRCPAINT);
//				lX += lCanvasW;
//			}
//			lY += lCanvasH;
//		}
//		dcMem.DeleteDC();
//		dcMask.DeleteDC();
//	} else
//	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		m_pDC->BeginPath();
//		m_pDC->Polygon((POINT*)dvptaPoly, lPolySz);
//		m_pDC->EndPath();
//		m_pDC->SelectClipPath(RGN_AND);
//		long lgLineW = mymm2lg(0.2);
//		if (lgLineW == 0) lgLineW = 1;
//		// _xZkqqHx_jFgAiJoGiCkKjFeLjHhGiCmIiDiKiBfLiDfHiDiHiDjDiCpAiOfKiPgPiBeC_xHqqkZx_
//		CRect dvrtClient = dvrtFrame;
//		if (!dvrtRgn.IsRectEmpty())
//			dvrtClient &= dvrtRgn;
//		DrawPattern(m_pDC, ::OptiColor(g_pEnv->scid2cref(m_scidBrushForeSColor)),
//					lgLineW, dvrtFrame, m_ptidBrushPattern, dvrtClient);
//	}
//	m_pDC->RestoreDC(-1);
//} // FCDraw::FillPathWithPattern.
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
void FCDraw::FillPathWithPattern (	const FCLgPolyBezier& dvptaPoly,
									const CRect& dvrtRgn)
{
	ASSERT(m_eDrawWhich != FDDR_METAFILE);
	CRect dvrtFrame;
	::FFCalcFrame(dvrtFrame, dvptaPoly.size(), &dvptaPoly.front());
	// _xZkqqHx_jFgAiJoGjHmMiIoGiCkKjGlDiCkCiBgJjFjN_xHqqkZx_or_xZkqqHx_iNiCiClDiCkK_xHqqkZx_0_xZkqqHx_iBgKiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (dvrtFrame.IsRectEmpty()) return;
	m_pDC->SaveDC();
	if (m_eDrawWhich == FDDR_DISPLAY)
	//----- _xZkqqHx_iJoGjGmKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// 0.2mm_xZkqqHx_iCpAiDhAiDfOiBfLiDjDiCmMiCfAiDeBiDgHiDiAiCmJjAnNjCoIiBeC_xHqqkZx_
		long lgLineW = mymm2lg(0.2);
		if (lgLineW == 0) lgLineW = 1;
		CRect rtCanvas(0, 0, 0, 0);
		DrawPattern(NULL, 0, lgLineW, rtCanvas, m_ptidBrushPattern, rtCanvas);
		const long lCanvasW = rtCanvas.Width();
		const long lCanvasH = rtCanvas.Height();
		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCpAiNoMjAkM_xHqqkZx_ -----
		CBitmap bitmap;
		bitmap.CreateBitmap(lCanvasW, lCanvasH, m_pDC->GetDeviceCaps(PLANES),
							m_pDC->GetDeviceCaps(BITSPIXEL), NULL);
		// _xZkqqHx_jFgAiJoGjHhA_xHqqkZx_CDC_xZkqqHx_iCmJiDhCiDgCiDgHiDhNiDgCiDhGiCpAjAnNjCoI_xHqqkZx_.
		CDC	dcMem;
		dcMem.CreateCompatibleDC(m_pDC);
		dcMem.SelectObject(&bitmap);
		//----- _xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoG_xHqqkZx_ -----
		dcMem.SetWindowOrg(0, 0);
		dcMem.FillRect(rtCanvas,
					CBrush::FromHandle((HBRUSH)GetStockObject(BLACK_BRUSH)));
		DrawPattern(&dcMem, ::OptiColor(g_pEnv->scid2cref(m_scidBrushForeSColor)),
					lgLineW, rtCanvas, m_ptidBrushPattern, rtCanvas);
		//----- _xZkqqHx_iDhNiDfIiDeOiDhCiDgCiDgHiDhNiDgCiDhGiCpAiNoMjAkM_xHqqkZx_ -----
		CBitmap bitMask;
		bitMask.CreateBitmap(lCanvasW, lCanvasH, 1, 1, NULL);
		CDC	dcMask;
		dcMask.CreateCompatibleDC(m_pDC);
		dcMask.SelectObject(&bitMask);
		//----- _xZkqqHx_iDhNiDfIiDeOiCpAjFgAiJoG_xHqqkZx_ -----
		dcMask.SetWindowOrg(0, 0);
		dcMask.FillRect(rtCanvas,
					CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));
		DrawPattern(&dcMask, FD_COLREF_BLACK, lgLineW, rtCanvas, m_ptidBrushPattern, rtCanvas);

		// _xZkqqHx_jFeLjHhGiCmIjFjEjFkKiClOiCkPiDeOiDiKiDgCiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
		m_pDC->BeginPath();
		if (dvptaPoly.GetIsBezier())
			m_pDC->PolyBezier(&dvptaPoly.front(), dvptaPoly.size());
		else
			m_pDC->Polyline((CPoint*)&dvptaPoly.front(), dvptaPoly.size());
		m_pDC->EndPath();
		m_pDC->SelectClipPath(RGN_AND);
		// _xZkqqHx_jFgAiJoGiCkKjFeLjHhGiCmIiDiKiBfLiDfHiDiHiDjDiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect dvrtClient = dvrtFrame;
		if (!dvrtRgn.IsRectEmpty())
			dvrtClient &= dvrtRgn;
		long lY = dvrtFrame.top;
		for (;;)
		{
			lY += lCanvasH;
			if (dvrtClient.top <= lY) break;
		}
		lY -= lCanvasH;
		for (;;)
		{
			if (dvrtClient.bottom < lY) break;
			long lX = dvrtFrame.left;
			for (;;)
			{
				lX += lCanvasW;
				if (dvrtClient.left <= lX) break;
			}
			lX -= lCanvasW;
			for (;;)
			{
				if (dvrtClient.right < lX) break;
				// _xZkqqHx_iCnMiClIiDhNiDfIiDeOiCmFiBeBiDhAiDfOiBfLiDjDjFjEjFkKiCpAiLpDiCkPiCoJiBeC_xHqqkZx_
				m_pDC->BitBlt(lX, lY, lCanvasW, lCanvasH, &dcMask, 0, 0, SRCAND);
				// _xZkqqHx_iLpDiCkCiClNiDhAiDfOiBfLiDjDjFjEjFkKiCmJiBeBiDhAiDfOiBfLiDjDiCpAjEoNiClJiCoJiBeC_xHqqkZx_
				m_pDC->BitBlt(lX, lY, lCanvasW, lCanvasH, &dcMem, 0, 0, SRCPAINT);
				lX += lCanvasW;
			}
			lY += lCanvasH;
		}
		dcMem.DeleteDC();
		dcMask.DeleteDC();
	} else
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_pDC->BeginPath();
		if (dvptaPoly.GetIsBezier())
			m_pDC->PolyBezier(&dvptaPoly.front(), dvptaPoly.size());
		else
			m_pDC->Polyline((CPoint*)&dvptaPoly.front(), dvptaPoly.size());
		m_pDC->EndPath();
		m_pDC->SelectClipPath(RGN_AND);
		long lgLineW = mymm2lg(0.2);
		if (lgLineW == 0) lgLineW = 1;
		// _xZkqqHx_jFgAiJoGiCkKjFeLjHhGiCmIiDiKiBfLiDfHiDiHiDjDiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect dvrtClient = dvrtFrame;
		if (!dvrtRgn.IsRectEmpty())
			dvrtClient &= dvrtRgn;
		DrawPattern(m_pDC, ::OptiColor(g_pEnv->scid2cref(m_scidBrushForeSColor)),
					lgLineW, dvrtFrame, m_ptidBrushPattern, dvrtClient);
	}
	m_pDC->RestoreDC(-1);
} // FCDraw::FillPathWithPattern.
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawPattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCmMiDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiBeCiIlNiCkCiCmNiBeBiDhAiDfOiBfLiDjDiCmMiNmFiPkMiMeKiCoIjFnEiClF_xHqqkZx_
 *			_xZkqqHx_iDfEiDeDiDfJiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			ptid		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawPattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
							PatternID ptid, const CRect& rtClip)
{
	switch (ptid)
	{
	case 0:
		DrawPinholePattern(pDC, cr, nAtomLen, rtCanvas, 20, 2, rtClip);
		break;
	case 1:
		DrawPinholePattern(pDC, cr, nAtomLen, rtCanvas, 10, 2, rtClip);
		break;
	case 2:
		DrawPinholePattern(pDC, cr, nAtomLen, rtCanvas, 7, 3, rtClip);
		break;
	case 3:
		DrawStarPattern(pDC, cr, nAtomLen, rtCanvas, 6, 6, rtClip);
		break;
	case 4:
		DrawStarPattern(pDC, cr, nAtomLen, rtCanvas, 6, 3, rtClip);
		break;
	case 5:
		DrawStarPattern(pDC, cr, nAtomLen, rtCanvas, 8, 2, rtClip);
		break;
	case 6:
		DrawStarPattern(pDC, cr, nAtomLen, rtCanvas, 12, 2, rtClip);
		break;
	case 7:
		DrawVLinePattern(pDC, cr, nAtomLen, rtCanvas, 20, 1, rtClip);
		break;
	case 8:
		DrawVLinePattern(pDC, cr, nAtomLen, rtCanvas, 10, 1, rtClip);
		break;
	case 9:
		DrawVLinePattern(pDC, cr, nAtomLen, rtCanvas, 5, 1, rtClip);
		break;
	case 10:
		DrawVLinePattern(pDC, cr, nAtomLen, rtCanvas, 20, 2, rtClip);
		break;
	case 11:
		DrawVLinePattern(pDC, cr, nAtomLen, rtCanvas, 10, 2, rtClip);
		break;
	case 12:
		DrawVLinePattern(pDC, cr, nAtomLen, rtCanvas, 5, 2, rtClip);
		break;
	case 13:
		DrawHLinePattern(pDC, cr, nAtomLen, rtCanvas, 20, 1, rtClip);
		break;
	case 14:
		DrawHLinePattern(pDC, cr, nAtomLen, rtCanvas, 10, 1, rtClip);
		break;
	case 15:
		DrawHLinePattern(pDC, cr, nAtomLen, rtCanvas, 5, 1, rtClip);
		break;
	case 16:
		DrawHLinePattern(pDC, cr, nAtomLen, rtCanvas, 20, 2, rtClip);
		break;
	case 17:
		DrawHLinePattern(pDC, cr, nAtomLen, rtCanvas, 10, 2, rtClip);
		break;
	case 18:
		DrawHLinePattern(pDC, cr, nAtomLen, rtCanvas, 5, 2, rtClip);
		break;
	case 19:
		DrawRDLinePattern(pDC, cr, nAtomLen, rtCanvas, 28, 1, rtClip);
		break;
	case 20:
		DrawRDLinePattern(pDC, cr, nAtomLen, rtCanvas, 14, 1, rtClip);
		break;
	case 21:
		DrawRDLinePattern(pDC, cr, nAtomLen, rtCanvas, 7, 1, rtClip);
		break;
	case 22:
		DrawRDLinePattern(pDC, cr, nAtomLen, rtCanvas, 28, 2, rtClip);
		break;
	case 23:
		DrawRDLinePattern(pDC, cr, nAtomLen, rtCanvas, 14, 2, rtClip);
		break;
	case 24:
		DrawRDLinePattern(pDC, cr, nAtomLen, rtCanvas, 7, 2, rtClip);
		break;
	case 25:
		DrawLDLinePattern(pDC, cr, nAtomLen, rtCanvas, 28, 1, rtClip);
		break;
	case 26:
		DrawLDLinePattern(pDC, cr, nAtomLen, rtCanvas, 14, 1, rtClip);
		break;
	case 27:
		DrawLDLinePattern(pDC, cr, nAtomLen, rtCanvas, 7, 1, rtClip);
		break;
	case 28:
		DrawLDLinePattern(pDC, cr, nAtomLen, rtCanvas, 28, 2, rtClip);
		break;
	case 29:
		DrawLDLinePattern(pDC, cr, nAtomLen, rtCanvas, 14, 2, rtClip);
		break;
	case 30:
		DrawLDLinePattern(pDC, cr, nAtomLen, rtCanvas, 7, 2, rtClip);
		break;
	case 31:
		DrawVHLatticePattern(pDC, cr, nAtomLen, rtCanvas, 20, 1, rtClip);
		break;
	case 32:
		DrawVHLatticePattern(pDC, cr, nAtomLen, rtCanvas, 10, 1, rtClip);
		break;
	case 33:
		DrawVHLatticePattern(pDC, cr, nAtomLen, rtCanvas, 5, 1, rtClip);
		break;
	case 34:
		DrawVHLatticePattern(pDC, cr, nAtomLen, rtCanvas, 20, 2, rtClip);
		break;
	case 35:
		DrawVHLatticePattern(pDC, cr, nAtomLen, rtCanvas, 10, 2, rtClip);
		break;
	case 36:
		DrawVHLatticePattern(pDC, cr, nAtomLen, rtCanvas, 5, 2, rtClip);
		break;
	case 37:
		DrawDgLatticePattern(pDC, cr, nAtomLen, rtCanvas, 28, 1, rtClip);
		break;
	case 38:
		DrawDgLatticePattern(pDC, cr, nAtomLen, rtCanvas, 14, 1, rtClip);
		break;
	case 39:
		DrawDgLatticePattern(pDC, cr, nAtomLen, rtCanvas, 7, 1, rtClip);
		break;
	case 40:
		DrawDgLatticePattern(pDC, cr, nAtomLen, rtCanvas, 28, 2, rtClip);
		break;
	case 41:
		DrawDgLatticePattern(pDC, cr, nAtomLen, rtCanvas, 14, 2, rtClip);
		break;
	case 42:
		DrawDgLatticePattern(pDC, cr, nAtomLen, rtCanvas, 7, 2, rtClip);
		break;
	case 43:
		DrawHWavePattern(pDC, cr, nAtomLen, rtCanvas, 20, 8, 1, rtClip);
		break;
	case 44:
		DrawHWavePattern(pDC, cr, nAtomLen, rtCanvas, 10, 8, 1, rtClip);
		break;
	case 45:
		DrawHWavePattern(pDC, cr, nAtomLen, rtCanvas, 5, 8, 1, rtClip);
		break;
	case 46:
		DrawHWavePattern(pDC, cr, nAtomLen, rtCanvas, 20, 8, 2, rtClip);
		break;
	case 47:
		DrawHWavePattern(pDC, cr, nAtomLen, rtCanvas, 10, 8, 2, rtClip);
		break;
	case 48:
		DrawHWavePattern(pDC, cr, nAtomLen, rtCanvas, 5, 8, 2, rtClip);
		break;
	case 49:
		DrawVWavePattern(pDC, cr, nAtomLen, rtCanvas, 20, 8, 1, rtClip);
		break;
	case 50:
		DrawVWavePattern(pDC, cr, nAtomLen, rtCanvas, 10, 8, 1, rtClip);
		break;
	case 51:
		DrawVWavePattern(pDC, cr, nAtomLen, rtCanvas, 5, 8, 1, rtClip);
		break;
	case 52:
		DrawVWavePattern(pDC, cr, nAtomLen, rtCanvas, 20, 8, 2, rtClip);
		break;
	case 53:
		DrawVWavePattern(pDC, cr, nAtomLen, rtCanvas, 10, 8, 2, rtClip);
		break;
	case 54:
		DrawVWavePattern(pDC, cr, nAtomLen, rtCanvas, 5, 8, 2, rtClip);
		break;
	default:
		DrawPinholePattern(pDC, cr, nAtomLen, rtCanvas, 6, 3, rtClip);
	}
} // FCDraw::DrawPattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawPinholePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBiCmGiClBiCoLiCmHiClBiCoLiMiKiCkKiLpDiCkCiCmEiCkCiCmEiBeBjEhHiMgJjAeGiCkK_xHqqkZx_
 *			_xZkqqHx_iMkJiCkGiCoJiCoGiCkEiCmIiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nHoleW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjDfPiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawPinholePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nHoleW, CRect rtClip)
{
	long lGap = nAtomLen * nSkip;
	if (pDC == NULL)
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(cr), 0 };
	CPen pen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT|PS_JOIN_BEVEL,
				lGap - nAtomLen * nHoleW, &logbPen);
	CPen* pOldPen = pDC->SelectObject(&pen);
	rtClip.InflateRect(lGap, lGap);
	long lRight = rtCanvas.right + lGap;
	if (rtClip.right < lRight) lRight = rtClip.right;
	long lBottom = rtCanvas.bottom + lGap;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	long lStartX, lStartY;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGap);
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGap);
	long lX, lY;

// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint lgptLastMoveTo;
	for (lX = lStartX; lX < lRight; lX += lGap)
	{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		pDC->MoveTo(lX, rtCanvas.top);
//		pDC->LineTo(lX, rtCanvas.bottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		myMoveTo(pDC, lgptLastMoveTo, lX, rtCanvas.top);
		myLineTo(pDC, lgptLastMoveTo, lX, rtCanvas.bottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	for (lY = lStartY; lY < lBottom; lY += lGap)
	{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		pDC->MoveTo(rtCanvas.left, lY);
//		pDC->LineTo(rtCanvas.right, lY);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		myMoveTo(pDC, lgptLastMoveTo, rtCanvas.left, lY);
		myLineTo(pDC, lgptLastMoveTo, rtCanvas.right, lY);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	pDC->SelectObject(pOldPen);
} // FCDraw::DrawPinholePattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawStarPattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBiCmGiClBiCoLiCmHiClBiCoLjBePiMgJjAeGiCmMjDfPiCkKiMkJiCkGiCoJiCoGiCkEiCmI_xHqqkZx_
 *			_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nStarW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjDfPiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawStarPattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nStarW, CRect rtClip)
{
	long lGap = nAtomLen * nSkip * 2;
	if (pDC == NULL)
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(cr), 0 };
	CPen pen(PS_COSMETIC|PS_SOLID, 1, &logbPen);
	CPen* pOldPen = pDC->SelectObject(&pen);
	CBrush brush(OptiColor(cr));
	CBrush* pOldBrush = pDC->SelectObject(&brush);
	const long lW = nAtomLen * nStarW + 1;
	rtClip.InflateRect(lW, lW);
	long lRight = rtCanvas.right + lW;
	if (rtClip.right < lRight) lRight = rtClip.right;
	long lBottom = rtCanvas.bottom + lW;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	long lStartX, lStartY;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGap);
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGap);
	long lX, lY;
	for (lY = lStartY; lY < lBottom; lY += lGap)
	{
		for (lX = lStartX; lX < lRight; lX += lGap)
		{
			pDC->Rectangle(lX, lY, lX + lW, lY + lW);
		}
	}
	for (lStartX = rtCanvas.left - lGap / 2; lStartX < rtClip.left; lStartX += lGap);
	for (lStartY = rtCanvas.top - lGap / 2; lStartY < rtClip.top; lStartY += lGap);
	for (lY = lStartY; lY < lBottom; lY += lGap)
	{
		for (lX = lStartX; lX < lRight; lX += lGap)
		{
			pDC->Rectangle(lX, lY, lX + lW, lY + lW);
		}
	}
	pDC->SelectObject(pOldPen);
	pDC->SelectObject(pOldBrush);
} // FCDraw::DrawStarPattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawVLinePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMjAiCjClMjApMiCkKiMeKiCoIjFnEiClHiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawVLinePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nLineW, CRect rtClip)
{
	long lGap = nAtomLen * nSkip;
	if (pDC == NULL)
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(cr), 0 };
	const long lW = nAtomLen * nLineW;
	CPen pen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT|PS_JOIN_BEVEL, lW, &logbPen);
	CPen* pOldPen = pDC->SelectObject(&pen);
	rtClip.InflateRect(lW, lW);
	long lRight = rtCanvas.right + lW;
	if (rtClip.right < lRight) lRight = rtClip.right;
	long lTop = rtCanvas.top - lW;
	if (lTop < rtClip.top) lTop = rtClip.top;
	long lBottom = rtCanvas.bottom + lW;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	long lStartX;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGap);
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint lgptLastMoveTo;
	long lX;
	for (lX = lStartX; lX < lRight; lX += lGap)
	{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		pDC->MoveTo(lX, lTop);
//		pDC->LineTo(lX, lBottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		myMoveTo(pDC, lgptLastMoveTo, lX, lTop);
		myLineTo(pDC, lgptLastMoveTo, lX, lBottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	pDC->SelectObject(pOldPen);
} // FCDraw::DrawVLinePattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawHLinePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMjAiFjFlNjApMiCkKiMeKiCoIjFnEiClHiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawHLinePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nLineW, CRect rtClip)
{
	long lGap = nAtomLen * nSkip;
	if (pDC == NULL)
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(cr), 0 };
	const long lW = nAtomLen * nLineW;
	CPen pen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT|PS_JOIN_BEVEL, lW, &logbPen);
	CPen* pOldPen = pDC->SelectObject(&pen);
	rtClip.InflateRect(lW, lW);
	long lBottom = rtCanvas.bottom + lW;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	long lLeft = rtCanvas.left - lW;
	if (lLeft < rtClip.left) lLeft = rtClip.left;
	long lRight = rtCanvas.right + lW;
	if (rtClip.right < lRight) lRight = rtClip.right;
	long lStartY;
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGap);
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint lgptLastMoveTo;
	long lY;
	for (lY = lStartY; lY < lBottom; lY += lGap)
	{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		pDC->MoveTo(lLeft, lY);
//		pDC->LineTo(lRight, lY);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		myMoveTo(pDC, lgptLastMoveTo, lLeft, lY);
		myLineTo(pDC, lgptLastMoveTo, lRight, lY);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	pDC->SelectObject(pOldPen);
} // FCDraw::DrawHLinePattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawLDLinePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMiOmOjApMiBgJiNlGiPoDiCkJiCoHiJeFiJlKiCnGiBgKiCkK_xHqqkZx_
 *			_xZkqqHx_iMeKiCoIjFnEiClHiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawLDLinePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nLineW, CRect rtClip)
{
	long lGap = nAtomLen * nSkip;
	if (pDC == NULL)
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(cr), 0 };
	const long lW = nAtomLen * nLineW;
	CPen pen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT|PS_JOIN_BEVEL, lW, &logbPen);
	CPen* pOldPen = pDC->SelectObject(&pen);
	rtClip.InflateRect(lW, lW);
	long lRight = rtCanvas.right + lW;
	long lBottom = rtCanvas.bottom + lW;
	long lWidth = rtCanvas.Width();
	long lHeight = rtCanvas.Height();

// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint lgptLastMoveTo;
	long lX, lY;
	for (lX = rtCanvas.left; lX < lRight; lX += lGap)
	{
		long lPatSize = rtCanvas.right - lX;
		if (lHeight < lPatSize) lPatSize = lHeight;
		CRect rtLine(lX - lW, rtCanvas.top - lW,
					lX + lPatSize + lW, rtCanvas.top + lPatSize + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pDC->MoveTo(rtLine.left, rtLine.top);
//			pDC->LineTo(rtLine.right, rtLine.bottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			myMoveTo(pDC, lgptLastMoveTo, rtLine.left, rtLine.top);
			myLineTo(pDC, lgptLastMoveTo, rtLine.right, rtLine.bottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	for (lY = rtCanvas.top + lGap; lY < lBottom; lY += lGap)
	{
		long lPatSize = rtCanvas.bottom - lY;
		if (lWidth < lPatSize) lPatSize = lWidth;
		CRect rtLine(rtCanvas.left - lW, lY - lW,
					rtCanvas.left + lPatSize + lW, lY + lPatSize + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pDC->MoveTo(rtLine.left, rtLine.top);
//			pDC->LineTo(rtLine.right, rtLine.bottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			myMoveTo(pDC, lgptLastMoveTo, rtLine.left, rtLine.top);
			myLineTo(pDC, lgptLastMoveTo, rtLine.right, rtLine.bottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	pDC->SelectObject(pOldPen);
} // FCDraw::DrawLDLinePattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawRDLinePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMiOmOjApMiBgJiJeFiPoDiCkJiCoHiNlGiJlKiCnGiBgKiCkK_xHqqkZx_
 *			_xZkqqHx_iMeKiCoIjFnEiClHiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawRDLinePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nLineW, CRect rtClip)
{
	long lGap = nAtomLen * nSkip;
	if (pDC == NULL)
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(cr), 0 };
	const long lW = nAtomLen * nLineW;
	CPen pen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT|PS_JOIN_BEVEL, lW, &logbPen);
	CPen* pOldPen = pDC->SelectObject(&pen);
	rtClip.InflateRect(lW, lW);
	long lRight = rtCanvas.right + lW;
	long lTop = rtCanvas.top - lW;
	long lWidth = rtCanvas.Width();
	long lHeight = rtCanvas.Height();
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint lgptLastMoveTo;
	long lX, lY;
	for (lX = rtCanvas.left; lX < lRight; lX += lGap)
	{
		long lPatSize = rtCanvas.right - lX;
		if (lHeight < lPatSize) lPatSize = lHeight;
		CRect rtLine(lX - lW, rtCanvas.bottom - lPatSize - lW,
					lX + lPatSize + lW, rtCanvas.bottom + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pDC->MoveTo(rtLine.left, rtLine.bottom);
//			pDC->LineTo(rtLine.right, rtLine.top);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			myMoveTo(pDC, lgptLastMoveTo, rtLine.left, rtLine.bottom);
			myLineTo(pDC, lgptLastMoveTo, rtLine.right, rtLine.top);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	for (lY = rtCanvas.bottom - lGap; lTop < lY; lY -= lGap)
	{
		long lPatSize = lY - rtCanvas.top;
		if (lWidth < lPatSize) lPatSize = lWidth;
		CRect rtLine(rtCanvas.left - lW, lY - lPatSize - lW,
					rtCanvas.left + lPatSize + lW, lY + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pDC->MoveTo(rtLine.left, rtLine.bottom);
//			pDC->LineTo(rtLine.right, rtLine.top);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			myMoveTo(pDC, lgptLastMoveTo, rtLine.left, rtLine.bottom);
			myLineTo(pDC, lgptLastMoveTo, rtLine.right, rtLine.top);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	pDC->SelectObject(pOldPen);
} // FCDraw::DrawRDLinePattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawVHLatticePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMjFpLiKoBjGmNjHgMiCkKiMeKiCoIjFnEiClHiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawVHLatticePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
									short nSkip, short nLineW, CRect rtClip)
{
	long lGap = nAtomLen * nSkip;
	if (pDC == NULL)
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(cr), 0 };
	const long lW = nAtomLen * nLineW;
	CPen pen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT|PS_JOIN_BEVEL, lW, &logbPen);
	CPen* pOldPen = pDC->SelectObject(&pen);
	rtClip.InflateRect(lW, lW);
	long lLeft = rtCanvas.left - lW;
	if (lLeft < rtClip.left) lLeft = rtClip.left;
	long lTop = rtCanvas.top - lW;
	if (lTop < rtClip.top) lTop = rtClip.top;
	long lRight = rtCanvas.right + lW;
	if (rtClip.right < lRight) lRight = rtClip.right;
	long lBottom = rtCanvas.bottom + lW;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	long lStartX;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGap);
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint lgptLastMoveTo;
	long lX, lY;
	for (lX = lStartX; lX < lRight; lX += lGap)
	{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		pDC->MoveTo(lX, lTop);
//		pDC->LineTo(lX, lBottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		myMoveTo(pDC, lgptLastMoveTo, lX, lTop);
		myLineTo(pDC, lgptLastMoveTo, lX, lBottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	long lStartY;
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGap);
	for (lY = lStartY; lY < lBottom; lY += lGap)
	{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		pDC->MoveTo(lLeft, lY);
//		pDC->LineTo(lRight, lY);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		myMoveTo(pDC, lgptLastMoveTo, lLeft, lY);
		myLineTo(pDC, lgptLastMoveTo, lRight, lY);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	pDC->SelectObject(pOldPen);
} // FCDraw::DrawVHLatticePattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawDgLatticePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMiOmOiCnPiCmMjFpLiKoBjGmNjHgMiCkKiMeKiCoIjFnEiClH_xHqqkZx_
 *			_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawDgLatticePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
									short nSkip, short nLineW, CRect rtClip)
{
	long lGap = nAtomLen * nSkip;
	if (pDC == NULL)
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(cr), 0 };
	const long lW = nAtomLen * nLineW;
	CPen pen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT|PS_JOIN_BEVEL, lW, &logbPen);
	CPen* pOldPen = pDC->SelectObject(&pen);
	rtClip.InflateRect(lW, lW);
	long lRight = rtCanvas.right + lW;
	long lTop = rtCanvas.top - lW;
	long lBottom = rtCanvas.bottom + lW;
	long lWidth = rtCanvas.Width();
	long lHeight = rtCanvas.Height();
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint lgptLastMoveTo;
	long lX, lY;
	for (lX = rtCanvas.left; lX < lRight; lX += lGap)
	{
		long lPatSize = rtCanvas.right - lX;
		if (lHeight < lPatSize) lPatSize = lHeight;
		CRect rtLine(lX - lW, rtCanvas.top - lW,
					lX + lPatSize + lW, rtCanvas.top + lPatSize + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pDC->MoveTo(rtLine.left, rtLine.top);
//			pDC->LineTo(rtLine.right, rtLine.bottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			myMoveTo(pDC, lgptLastMoveTo, rtLine.left, rtLine.top);
			myLineTo(pDC, lgptLastMoveTo, rtLine.right, rtLine.bottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	for (lY = rtCanvas.top + lGap; lY < lBottom; lY += lGap)
	{
		long lPatSize = rtCanvas.bottom - lY;
		if (lWidth < lPatSize) lPatSize = lWidth;
		CRect rtLine(rtCanvas.left - lW, lY - lW,
					rtCanvas.left + lPatSize + lW, lY + lPatSize + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pDC->MoveTo(rtLine.left, rtLine.top);
//			pDC->LineTo(rtLine.right, rtLine.bottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			myMoveTo(pDC, lgptLastMoveTo, rtLine.left, rtLine.top);
			myLineTo(pDC, lgptLastMoveTo, rtLine.right, rtLine.bottom);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}

	for (lX = rtCanvas.left; lX < lRight; lX += lGap)
	{
		long lPatSize = rtCanvas.right - lX;
		if (lHeight < lPatSize) lPatSize = lHeight;
		CRect rtLine(lX - lW, rtCanvas.bottom - lPatSize - lW,
					lX + lPatSize + lW, rtCanvas.bottom + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pDC->MoveTo(rtLine.left, rtLine.bottom);
//			pDC->LineTo(rtLine.right, rtLine.top);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			myMoveTo(pDC, lgptLastMoveTo, rtLine.left, rtLine.bottom);
			myLineTo(pDC, lgptLastMoveTo, rtLine.right, rtLine.top);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	for (lY = rtCanvas.bottom - lGap; lTop < lY; lY -= lGap)
	{
		long lPatSize = lY - rtCanvas.top;
		if (lWidth < lPatSize) lPatSize = lWidth;
		CRect rtLine(rtCanvas.left - lW, lY - lPatSize - lW,
					rtCanvas.left + lPatSize + lW, lY + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pDC->MoveTo(rtLine.left, rtLine.bottom);
//			pDC->LineTo(rtLine.right, rtLine.top);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			myMoveTo(pDC, lgptLastMoveTo, rtLine.left, rtLine.bottom);
			myLineTo(pDC, lgptLastMoveTo, rtLine.right, rtLine.top);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	pDC->SelectObject(pOldPen);
} // FCDraw::DrawDgLatticePattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawHWavePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMjAiFjFlNjFpLiMpMiCmMjEgHjGmNjHgMiCkKiMeKiCoIjFnEiClH_xHqqkZx_
 *			_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nWaveW		:_xZkqqHx_jFgAiJoGiClHiCoJjEgHiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawHWavePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nWaveW, short nLineW, CRect rtClip)
{
	long lGapH = nAtomLen * nWaveW;
	long lGapV = nAtomLen * nSkip;
	if (pDC == NULL)
	{
		while (lGapH < 16 || lGapV < 16)
		{
			lGapH *= 2;
			lGapV *= 2;
		}
		rtCanvas.SetRect(0, 0, lGapH, lGapV);
		return;
	}
	long lWaveHeight = lGapH / 2;
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(cr), 0 };
	const long lW = nAtomLen * nLineW;
	CPen pen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT|PS_JOIN_BEVEL, lW, &logbPen);
	CPen* pOldPen = pDC->SelectObject(&pen);
	rtClip.InflateRect(lGapH, lGapV);
	long lBottom = rtCanvas.bottom + lGapV;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	long lRight = rtCanvas.right + lGapH;
	if (rtClip.right < lRight) lRight = rtClip.right;
	long lStartX;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGapH);
	long lStartY;
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGapV);
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint lgptLastMoveTo;
	long lX, lY;
	for (lY = lStartY; lY < lBottom; lY += lGapV)
	{
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		pDC->MoveTo(lStartX, lY);
		myMoveTo(pDC, lgptLastMoveTo, lStartX, lY);
		for (lX = lStartX; lX < lRight; lX += lGapH)
		{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pDC->LineTo(lX + lWaveHeight, lY - lWaveHeight);
//			pDC->LineTo(lX + 2 * lWaveHeight, lY);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			myLineTo(pDC, lgptLastMoveTo, lX + lWaveHeight, lY - lWaveHeight);
			myLineTo(pDC, lgptLastMoveTo, lX + 2 * lWaveHeight, lY);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	pDC->SelectObject(pOldPen);
} // FCDraw::DrawHWavePattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::DrawVWavePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMjAiCjClMjFpLiMpMiCmMjEgHjGmNjHgMiCkKiMeKiCoIjFnEiClH_xHqqkZx_
 *			_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nWaveW		:_xZkqqHx_jFgAiJoGiClHiCoJjEgHiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDraw::DrawVWavePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nWaveW, short nLineW, CRect rtClip)
{
	long lGapV = nAtomLen * nWaveW;
	long lGapH = nAtomLen * nSkip;
	if (pDC == NULL)
	{
		while (lGapV < 16 || lGapH < 16)
		{
			lGapV *= 2;
			lGapH *= 2;
		}
		rtCanvas.SetRect(0, 0, lGapH, lGapV);
		return;
	}
	long lWaveHeight = lGapV / 2;
	// Pen_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_(Style,Width,Color)_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_iIpIjAjEiCpAiOoGiCoJ_xHqqkZx_CreatePen_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_
	// NVIDIA_xZkqqHx_iCmMiDhCiDgGiDeJiDeKiBfLiDgIiCmIiCmHiCmFiDfDiDhOiCkKiOgDiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	LOGBRUSH logbPen = { BS_SOLID, OptiColor(cr), 0 };
	const long lW = nAtomLen * nLineW;
	CPen pen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT|PS_JOIN_BEVEL, lW, &logbPen);
	CPen* pOldPen = pDC->SelectObject(&pen);
	rtClip.InflateRect(lGapH, lGapV);
	long lBottom = rtCanvas.bottom + lGapV;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	long lRight = rtCanvas.right + lGapH;
	if (rtClip.right < lRight) lRight = rtClip.right;
	long lStartX;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGapH);
	long lStartY;
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGapV);
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint lgptLastMoveTo;
	long lX, lY;
	for (lX = lStartX; lX < lRight; lX += lGapH)
	{
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		pDC->MoveTo(lX, lStartY);
		myMoveTo(pDC, lgptLastMoveTo, lX, lStartY);
		for (lY = lStartY; lY < lBottom; lY += lGapV)
		{
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pDC->LineTo(lX - lWaveHeight, lY + lWaveHeight);
//			pDC->LineTo(lX, lY + 2 * lWaveHeight);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			myLineTo(pDC, lgptLastMoveTo, lX - lWaveHeight, lY + lWaveHeight);
			myLineTo(pDC, lgptLastMoveTo, lX, lY + 2 * lWaveHeight);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	pDC->SelectObject(pOldPen);
} // FCDraw::DrawVWavePattern.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::FCAutoDC
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSaveDC	:SaveDC,RestoreDC_xZkqqHx_iCpAiOmAiNhDiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAutoDC::FCAutoDC (CDC* pDC, BOOL bSaveDC, long lgOffsetX, long lgOffsetY)
{
	m_pDC = pDC;
	m_bSaveDC = bSaveDC;

	m_lgOffsetX = lgOffsetX;	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
	m_lgOffsetY = lgOffsetY;	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_

	// CDC_xZkqqHx_iCmMiPpDjBnEiCpAjFnLjBlGiBeC_xHqqkZx_
	if (m_bSaveDC) m_pDC->SaveDC();

	m_pCurAtFont = NULL;
	m_pCurAtPen = NULL;
	m_pCurAtBrush = NULL;
	m_pCurAtBitmap = NULL;

	m_pFontOrig = NULL;
	m_pPenOrig = NULL;
	m_pBrushOrig = NULL;
	m_pBitmapOrig = NULL;

	m_bSetWindowOrg	= FALSE;	// SetWindowOrg_xZkqqHx_iCkKiOmAiNhDiNmPiCnNiCkJiBeI_xHqqkZx_
	m_ptWindowOrgOrig= CPoint(0,0);

	m_bSetBkColor	= FALSE;	// SetBkColor_xZkqqHx_iCkKiOmAiNhDiNmPiCnNiCkJiBeI_xHqqkZx_
	m_crBkColorOrig	= NULL;

	m_bSetBkMode	= FALSE;	// SetBkMode_xZkqqHx_iCkKiOmAiNhDiNmPiCnNiCkJiBeI_xHqqkZx_
	m_iBkModeOrig	= NULL;

	m_bSetTextColor	= FALSE;	// SetTextColor_xZkqqHx_iCkKiOmAiNhDiNmPiCnNiCkJiBeI_xHqqkZx_
	m_crTextColorOrig= NULL;

	m_bSetMapMode	= FALSE;	// SetMapMode_xZkqqHx_iCkKiOmAiNhDiNmPiCnNiCkJiBeI_xHqqkZx_
	m_iMapModeOrig	= NULL;

	m_pOwnFont = NULL;		// _xZkqqHx_iPiKjHeMiClHiCoJiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
	m_pOwnPen = NULL;		// _xZkqqHx_iPiKjHeMiClHiCoJiDhJiDjDiBeC_xHqqkZx_
	m_pOwnBrush = NULL;		// _xZkqqHx_iPiKjHeMiClHiCoJiDhFiDiJiDfGiBeC_xHqqkZx_

	// _xZkqqHx_iDhAiDiMiDgCiDgHiCmMjAnNjCoIiBeC_xHqqkZx_
	if (g_pFDPalette != NULL)
		m_pPaletteOld = m_pDC->SelectPalette(g_pFDPalette, TRUE);
	else
		m_pPaletteOld = NULL;
} // FCAutoDC::FCAutoDC.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::~FCAutoDC
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAutoDC::~FCAutoDC ()
{
	if (m_bSetWindowOrg)
		m_pDC->SetWindowOrg(m_ptWindowOrgOrig);

	if (m_bSetBkColor)
		m_pDC->SetBkColor(m_crBkColorOrig);

	if (m_bSetBkMode)
		m_pDC->SetBkMode(m_iBkModeOrig);

	if (m_bSetTextColor)
		m_pDC->SetTextColor(m_crTextColorOrig);

	if (m_bSetMapMode)
		m_pDC->SetMapMode(m_iMapModeOrig);

	if (m_pFontOrig != NULL)
		// CDC_xZkqqHx_iCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
		(void)m_pDC->SelectObject(m_pFontOrig);

	if (m_pPenOrig != NULL)
		// CDC_xZkqqHx_iCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
		(void)m_pDC->SelectObject(m_pPenOrig);

	if (m_pBrushOrig != NULL)
		// CDC_xZkqqHx_iCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
		(void)m_pDC->SelectObject(m_pBrushOrig);

	if (m_pBitmapOrig != NULL)
		// CDC_xZkqqHx_iCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
		(void)m_pDC->SelectObject(m_pBitmapOrig);


	if (m_pCurAtFont != NULL)
	//----- _xZkqqHx_iMlLiNnNiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		m_pCurAtFont->SetAtDC(NULL);

	if (m_pCurAtPen != NULL)
	//----- _xZkqqHx_iMlLiNnNiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		m_pCurAtPen->SetAtDC(NULL);

	if (m_pCurAtBrush != NULL)
	//----- _xZkqqHx_iMlLiNnNiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		m_pCurAtBrush->SetAtDC(NULL);

	if (m_pCurAtBitmap != NULL)
	//----- _xZkqqHx_iMlLiNnNiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		m_pCurAtBitmap->SetAtDC(NULL);


	if (m_pOwnFont != NULL)
	//----- _xZkqqHx_iPiKjHeMiClHiCoJiDhEiDeIiDjDiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		delete m_pOwnFont;

	if (m_pOwnPen != NULL)
	//----- _xZkqqHx_iPiKjHeMiClHiCoJiDhJiDjDiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		delete m_pOwnPen;

	if (m_pOwnBrush != NULL)
	//----- _xZkqqHx_iPiKjHeMiClHiCoJiDhFiDiJiDfGiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		delete m_pOwnBrush;

	// _xZkqqHx_iDhAiDiMiDgCiDgHiCmMjFjMiMlDiBeC_xHqqkZx_
	if (m_pPaletteOld != NULL)
		m_pDC->SelectPalette(m_pPaletteOld, TRUE);

	// _xZkqqHx_iDfKiBfLiDhFjBePiCmMiPpDjBnEiCmJjGnPiClHiBeC_xHqqkZx_
	if (m_bSaveDC) m_pDC->RestoreDC(-1);
} // FCAutoDC::~FCAutoDC.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetWindowOrg
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CDC::SetWindowOrg_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ptWindowOrg	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjAfGiClFiCkCiMlEjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetWindowOrg (POINT ptWindowOrg)
{
	if (m_bSetWindowOrg)
	{
		(void)m_pDC->SetWindowOrg(ptWindowOrg);
	} else
	{
		m_bSetWindowOrg = TRUE;
		m_ptWindowOrgOrig = m_pDC->SetWindowOrg(ptWindowOrg);
	}
} // FCAutoDC::SetWindowOrg.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetBkColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CDC::SetBkColor_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeCiDfIiDfOiDeDiDiLjFhEiCkLiDiJiDeDiDjDiKnEiCmMiClHiCkLiCnMiBeB_xHqqkZx_
 *			_xZkqqHx_iDhFiDiJiDfGiCmMiDgOiDgCiDgAiDiJiDeDiDjDiKnEiCmMiClHiCkLiCnMiBeBjFlGiOjKiDfKiDiLiCmMiDgPiDgCiDeOiDePiDiJiDeFiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	crBkColor	:_xZkqqHx_jEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetBkColor (COLORREF crBkColor)
{
	if (m_bSetBkColor)
	{
		(void)m_pDC->SetBkColor(crBkColor);
	} else
	{
		m_bSetBkColor = TRUE;
		m_crBkColorOrig = m_pDC->SetBkColor(crBkColor);
	}
} // FCAutoDC::SetBkColor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetBkMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CDC::SetBkMode_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iBkMode	:_xZkqqHx_jEhHiMgJjAeGjFgAiJoGiDiCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetBkMode (int iBkMode)
{
	if (m_bSetBkMode)
	{
		(void)m_pDC->SetBkMode(iBkMode);
	} else
	{
		m_bSetBkMode = TRUE;
		m_iBkModeOrig = m_pDC->SetBkMode(iBkMode);
	}
} // FCAutoDC::SetBkMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetTextColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CDC::SetTextColor_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	crTextColor	:_xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetTextColor (COLORREF crTextColor)
{
	if (m_bSetTextColor)
	{
		(void)m_pDC->SetTextColor(crTextColor);
	} else
	{
		m_bSetTextColor = TRUE;
		m_crTextColorOrig = m_pDC->SetTextColor(crTextColor);
	}
} // FCAutoDC::SetTextColor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::GetTextColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CDC::GetTextColor_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
COLORREF FCAutoDC::GetTextColor () const
{
	return m_pDC->GetTextColor();
} // FCAutoDC::GetTextColor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetMapMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CDC::SetMapMode_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iMapMode	:_xZkqqHx_iDhNiDgCiDhGiDiCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetMapMode (int iMapMode)
{
	if (m_bSetMapMode)
	{
		(void)m_pDC->SetMapMode(iMapMode);
	} else
	{
		m_bSetMapMode = TRUE;
		m_iMapModeOrig = m_pDC->SetMapMode(iMapMode);
	}
} // FCAutoDC::SetMapMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCpAiNoMjAkMiClFiBeBjAnNjCoIiClHiCoJiBeCiDhEiDeIiDjDiDgHiCmNiDeOiDiJiDfIjDoAjFjEiCmJjFnLjBlGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpLogFont	:_xZkqqHx_iDhEiDeIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetFont (const LOGFONT* lpLogFont)
{
	// _xZkqqHx_iPiKjHeMiClHiCoJiDhEiDeIiDjDiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	if (m_pOwnFont != NULL) delete m_pOwnFont;
	m_pOwnFont = new FCAtFont();
	::FFCreateFontIndirect(*(m_pOwnFont->Get()), *lpLogFont);
	SetObject(*m_pOwnFont);
} // FCAutoDC::SetFont.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetPen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCpAiNoMjAkMiClFiBeBjAnNjCoIiClHiCoJiBeCiDhJiDjDiCmNiDeOiDiJiDfIjDoAjFjEiCmJjFnLjBlGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nPenStyle	:_xZkqqHx_iDhJiDjDiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nWidth		:_xZkqqHx_iDhJiDjDjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			crColor		:_xZkqqHx_iDhJiDjDjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetPen (int nPenStyle, int nWidth, COLORREF crColor)
{
	// _xZkqqHx_iPiKjHeMiClHiCoJiDhJiDjDiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	if (m_pOwnPen != NULL) delete m_pOwnPen;
	m_pOwnPen = new FCAtPen(nPenStyle, nWidth, crColor);
	SetObject(*m_pOwnPen);
} // FCAutoDC::SetPen.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetPen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCpAiNoMjAkMiClFiBeBjAnNjCoIiClHiCoJiBeCiDhJiDjDiCmNiDeOiDiJiDfIjDoAjFjEiCmJjFnLjBlGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nPenStyle	:_xZkqqHx_iDhJiDjDiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nWidth		:_xZkqqHx_iDhJiDjDjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLogBrush	:_xZkqqHx_iDhJiDjDiCpAjDgIiCoIiCmCiCnEiClHiDhFiDiJiDfGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nStyleCount	:lpStyle_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lpStyle		:_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetPen (int nPenStyle, int nWidth, const LOGBRUSH* pLogBrush, int nStyleCount, const DWORD* lpStyle)
{
	// _xZkqqHx_iPiKjHeMiClHiCoJiDhJiDjDiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	if (m_pOwnPen != NULL) delete m_pOwnPen;
	m_pOwnPen = new FCAtPen(nPenStyle, nWidth, pLogBrush, nStyleCount, lpStyle);
	SetObject(*m_pOwnPen);
} // FCAutoDC::SetPen.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetStockPen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDgCiDeOiDhJiDjDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fnObject	:_xZkqqHx_iDfIiDgHiDgCiDeOiDhJiDjDiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetStockPen (int fnObject)
{
	if (m_pCurAtPen != NULL)
	//----- _xZkqqHx_iMlLiNnNiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_pCurAtPen->SetAtDC(NULL);
		m_pCurAtPen = NULL;
	}
	// GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjAnNjCoIiBeCiDgPiDgCiDeOiDeBiDgCiDhGiCkKjGlDiCkCiPoKiNiHiCmNiBeBiDgPiDgCiDeOiDeBiDgCiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
	(void)BackupGdiObject(m_pDC->SelectObject(CPen::FromHandle((HPEN)GetStockObject(fnObject))));
} // FCAutoDC::SetStockPen.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetBrush
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhFiDiJiDfGiCpAiNoMjAkMiClFiBeBjAnNjCoIiClHiCoJiBeCiDhFiDiJiDfGiCmNiDeOiDiJiDfIjDoAjFjEiCmJjFnLjBlGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	crColor	:_xZkqqHx_iDhFiDiJiDfGjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetBrush (COLORREF crColor)
{
	// _xZkqqHx_iPiKjHeMiClHiCoJiDhFiDiJiDfGiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	if (m_pOwnBrush != NULL) delete m_pOwnBrush;
	m_pOwnBrush = new FCAtBrush(crColor);
	SetObject(*m_pOwnBrush);
} // FCAutoDC::SetBrush.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetBrush
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhFiDiJiDfGiCpAiNoMjAkMiClFiBeBjAnNjCoIiClHiCoJiBeCiDhFiDiJiDfGiCmNiDeOiDiJiDfIjDoAjFjEiCmJjFnLjBlGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pLogBrush	:_xZkqqHx_jDgIiCoIiCmCiCnEiClHiDhFiDiJiDfGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetBrush (LPLOGBRUSH lpLogBrush)
{
	// _xZkqqHx_iPiKjHeMiClHiCoJiDhFiDiJiDfGiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	if (m_pOwnBrush != NULL) delete m_pOwnBrush;
	m_pOwnBrush = new FCAtBrush();
	m_pOwnBrush->Get()->CreateBrushIndirect(lpLogBrush);
	SetObject(*m_pOwnBrush);
} // FCAutoDC::SetBrush.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetStockBrush
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDgCiDeOiDhFiDiJiDfGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fnObject	:_xZkqqHx_iDfIiDgHiDgCiDeOiDhFiDiJiDfGiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::SetStockBrush (int fnObject)
{
	if (m_pCurAtBrush != NULL)
	//----- _xZkqqHx_iMlLiNnNiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_pCurAtBrush->SetAtDC(NULL);
		m_pCurAtBrush = NULL;
	}
	// GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjAnNjCoIiBeCiDgPiDgCiDeOiDeBiDgCiDhGiCkKjGlDiCkCiPoKiNiHiCmNiBeBiDgPiDgCiDeOiDeBiDgCiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
	(void)BackupGdiObject(m_pDC->SelectObject(CBrush::FromHandle((HBRUSH)GetStockObject(fnObject))));
} // FCAutoDC::SetStockBrush.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::GetCharABCWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiCmFiBeBiOhHjCoIiClDiCoKiClNjFlGiOjKiCmM_xHqqkZx_ABC_xZkqqHx_jEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			TrueType_xZkqqHx_iImIiKePiClOiCmGiBeB_xHqqkZx_GetCharWidth_xZkqqHx_iCpAiOgHiCmBiCmEiBeBjDeLjDjGiCmIjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar	:_xZkqqHx_jClCiCnHiCoJjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_UNICODE_xZkqqHx_iBeC_xHqqkZx_
 *			abc		:_xZkqqHx_jCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 02.09.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDfOiDeDiMoKiCmIiCmHiCmFiBeBjFlGiOjKjFjNiCkKjAlDiClFiCkNiOfKiPgPiClDiCoKiCmIiCkC_xHqqkZx_)
//BOOL FCAutoDC::GetCharABCWidth (wchar_t wChar, ABC& abc) const
BOOL FCAutoDC::GetCharABCWidth (wchar_t wChar, ABC& abc, WORD wCodePage) const
{
//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----
//	// _MBCS_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_UNICODE_xZkqqHx_iCmMjFlGiOjK_xHqqkZx_ wChar _xZkqqHx_iCpA_xHqqkZx_MBCS_xZkqqHx_iCmMjFlGiOjKiCmJjFmPiKlHiBeC_xHqqkZx_
//	// _UNICODE_xZkqqHx_iCmMiPoKiNiHiCmNiBeBjCgMiCmNjDkPiClGiBeC_xHqqkZx_
//	wChar = WCharToCode(wChar);
//	if (m_pDC->GetCharABCWidths(wChar, wChar, &abc)) return TRUE;
//	int iWidth;
//	if (m_pDC->GetCharWidth(wChar, wChar, &iWidth))
//	{
//		abc.abcA = 0;
//		abc.abcB = iWidth;
//		abc.abcC = 0;
//		return TRUE;
//	}
//	return FALSE;
//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----
#if defined(_MBCS)

	// UNICODE_xZkqqHx_iCmMjFlGiOjK_xHqqkZx_ wChar _xZkqqHx_iCpA_xHqqkZx_MBCS_xZkqqHx_iCmMjFlGiOjKiCmJjFmPiKlHiBeC_xHqqkZx_
	wchar_t wMbcsChar = wChar;
// 02.09.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDfOiDeDiMoKiCmIiCmHiCmFiBeBjFlGiOjKjFjNiCkKjAlDiClFiCkNiOfKiPgPiClDiCoKiCmIiCkC_xHqqkZx_)
//	if (WCharToCode(wMbcsChar) &&
	if (WCharToCode(wMbcsChar, wCodePage) &&
		::GetCharABCWidths(m_pDC->m_hDC, wMbcsChar, wMbcsChar, &abc)) return TRUE;

#elif defined(_UNICODE)

	if (::GetCharABCWidths(m_pDC->m_hDC, wChar, wChar, &abc)) return TRUE;

#endif//_UNICODE

	int iWidth;
	// GetCharWidthW _xZkqqHx_iCmNiBeB_xHqqkZx_95,98,Me_xZkqqHx_iCmFiCoAjHjIjHhAiJmCjEfMiBeC_xHqqkZx_
	if (::GetCharWidthW(m_pDC->m_hDC, wChar, wChar, &iWidth))
	{
		abc.abcA = 0;
		abc.abcB = iWidth;
		abc.abcC = 0;
		return TRUE;
	}
	return FALSE;

//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----
} // FCAutoDC::GetCharABCWidth.

//----- 02.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::GetCharABCWidth
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiCmFiBeBiOhHjCoIiClDiCoKiClNjFlGiOjKiCmM_xHqqkZx_ABC_xZkqqHx_jEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			TrueType_xZkqqHx_iImIiKePiClOiCmGiBeB_xHqqkZx_GetCharWidth_xZkqqHx_iCpAiOgHiCmBiCmEiBeBjDeLjDjGiCmIjCgMiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpStr	:_xZkqqHx_jClCiCnHiCoJjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
// *			iWordLen:tcpStr_xZkqqHx_iCmMjFlGiOjKiCmMiDfEiDeDiDfJiBeC_xHqqkZx_MBCS_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_1_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_2_xZkqqHx_iBeC_xHqqkZx_
// *					 UNICODE_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ 1_xZkqqHx_iBeC_xHqqkZx_
// *			abc		:_xZkqqHx_jCgMiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCAutoDC::GetCharABCWidth (const wchar_t* tcpStr, int iWordLen, ABC& abc) const
//{
//#if defined(_MBCS)
//	ASSERT(iWordLen < 3);
//	//----- _xZkqqHx_iCnMiClIiBeBiCfAjFlGiOjKiCmMiDfCiBfLiDgIiCmJjBgHiCnNjHkHiCmEiCoJ_xHqqkZx_ -----
//	WORD wChar = 0;
//	while (0 < iWordLen--)
//	{
//		wChar = WORD(wChar << 8) | BYTE(*tcpStr);
//		tcpStr++;
//	}
//	// ABC_xZkqqHx_iCmMjFjNiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//	if (m_pDC->GetCharABCWidths(wChar, wChar, &abc)) return TRUE;
//	// TrueType_xZkqqHx_iCmFiCmNiCmIiCkCiPoKiNiHiBeB_xHqqkZx_GetCharWidth_xZkqqHx_iCmFjClCiCnHiCoJiBeC_xHqqkZx_
//	int iWidth;
//	if (m_pDC->GetCharWidth(wChar, wChar, &iWidth))
//	{
//		abc.abcA = 0;
//		abc.abcB = iWidth;
//		abc.abcC = 0;
//		return TRUE;
//	}
//	return FALSE;
//#elif defined(_UNICODE)
//	ASSERT(iWordLen == 1);
//	return GetCharABCWidth(*tcpStr, abc);
//#endif//_UNICODE
//} // FCAutoDC::GetCharABCWidth.
//----- 02.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::GetCharWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiCmFiBeBiOhHjCoIiClDiCoKiClNjFlGiOjKiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpStr	:_xZkqqHx_jClCiCnHiCoJjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iWordLen:tcpStr_xZkqqHx_iCmMjFlGiOjKiCmMiDfEiDeDiDfJiBeC_xHqqkZx_MBCS_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_1_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_2_xZkqqHx_iBeC_xHqqkZx_
 *					 UNICODE_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ 1_xZkqqHx_iBeC_xHqqkZx_
 *			iWidth	:_xZkqqHx_jCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCAutoDC::GetCharWidth (wchar_t wChar, int& iWidth, WORD wCodePage) const
{
	ABC abc;
	if (GetCharABCWidth(wChar, abc, wCodePage))
	{
		iWidth = abc.abcA + abc.abcB + abc.abcC;
		return TRUE;
	} else
	{
		return FALSE;
	}
} // FCAutoDC::GetCharWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::GetOutputTextExtent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPgPjHmNiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOgHjHhAiClFiCmEiBeBiMlLiNnNiCmMiDhEiDeIiDjDiDgHiCmFiCmM_xHqqkZx_
 *			_xZkqqHx_iNhDiCmMjFjNiCmGiNiCiClDiCpAiMhGiOfKiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpString	:_xZkqqHx_iMhGiOfKiClHiCoJjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iCount		:wcpString_xZkqqHx_iCmMjFlGiOjKjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wCodePage	: _xZkqqHx_iClBiCmMjFlGiOjKiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBjFgAiJoGiCmJjFeLjHhGiCmIiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CSize FCAutoDC::GetOutputTextExtent (const wchar_t* wcpString, int nCount, WORD wCodePage) const
{
#if defined(_MBCS)
	CString str = WStrToTStr(wcpString, wCodePage);
	return m_pDC->GetOutputTextExtent(str);
#elif defined(_UNICODE)
	return m_pDC->GetOutputTextExtent(wcpString, nCount);
#endif//_UNICODE
} // FCAutoDC::GetOutputTextExtent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::GetOutlineTextMetrics
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CDC::GetOutlineTextMetrics_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
UINT FCAutoDC::GetOutlineTextMetrics (UINT cbData, LPOUTLINETEXTMETRIC lpotm) const
{
	return m_pDC->GetOutlineTextMetrics(cbData, lpotm);
} // FCAutoDC::GetOutlineTextMetrics.

//////////////////////////////////////////////////////////////////////////////
// FCAutoDC _xZkqqHx_jFgAiJoGiKnGjAjEiMfBiBeC_xHqqkZx_

CPoint FCAutoDC::MoveTo (int x, int y)
{
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	// mylg2dv_xZkqqHx_iCmFjAkHiMmAiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return m_pDC->MoveTo(mylg2dv(x, y));
	return myMoveTo(m_pDC, m_lgptLastMoveTo, mylgx2dvx(x), mylgy2dvy(y));
} // FCAutoDC::MoveTo.

CPoint FCAutoDC::MoveTo (POINT point)
{
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return m_pDC->MoveTo(mylg2dv(point));
	return MoveTo(point.x, point.y);
} // FCAutoDC::MoveTo.

BOOL FCAutoDC::LineTo (int x, int y)
{
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	// mylg2dv_xZkqqHx_iCmFjAkHiMmAiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return m_pDC->LineTo(mylg2dv(x, y));
	return myLineTo(m_pDC, m_lgptLastMoveTo, mylgx2dvx(x), mylgy2dvy(y));
} // FCAutoDC::LineTo.

BOOL FCAutoDC::LineTo (POINT point)
{
// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return m_pDC->LineTo(mylg2dv(point));
	return LineTo(point.x, point.y);
} // FCAutoDC::LineTo.

//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
//BOOL FCAutoDC::TextOut (int x, int y, const wchar_t* lpszString, int nCount)
//{
//#if defined(_MBCS)
//	astring tcvBuff((nCount + 1) * sizeof(wchar_t), _T('\0'));
//	int iSize = WideCharToMultiByte(CP_ACP, 0, lpszString, nCount,
//									tcvBuff.begin(), tcvBuff.size(), NULL, NULL);
//	return m_pDC->TextOut(mylgx2dvx(x), mylgy2dvy(y), tcvBuff.c_str(), iSize);
//#elif defined(_UNICODE)
//	return m_pDC->TextOut(mylgx2dvx(x), mylgy2dvy(y), lpszString, nCount);
//#endif//_UNICODE
//} // FCAutoDC::TextOut.
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
BOOL FCAutoDC::TextOut (int x, int y, const wchar_t* lpszString, int nCount, WORD wCodePage)
{
#if defined(_MBCS)
	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
	//----- NT_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		return ::TextOutW(m_pDC->m_hDC, mylgx2dvx(x), mylgy2dvy(y), lpszString, nCount);
	} else
	//----- 95_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		astring astr((nCount + 1) * sizeof(wchar_t), '\0');
		int iSize = WideCharToMultiByte(wCodePage, 0, lpszString, nCount,
										astr.begin(), astr.size(), NULL, NULL);
		return ::TextOut(m_pDC->m_hDC, mylgx2dvx(x), mylgy2dvy(y), astr.c_str(), iSize);
	}
#elif defined(_UNICODE)
	return ::TextOutW(m_pDC->m_hDC, mylgx2dvx(x), mylgy2dvy(y), lpszString, nCount);
#endif//_UNICODE
} // FCAutoDC::TextOut.
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----

//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
//BOOL FCAutoDC::TextOut (int x, int y, const WString& wstr)
//{
//#if defined(_MBCS)
//	tcstring tstr = WStrToTStr(wstr);
//	return m_pDC->TextOut(mylgx2dvx(x), mylgy2dvy(y), tstr.c_str(), tstr.length());
//#elif defined(_UNICODE)
//	return m_pDC->TextOut(mylgx2dvx(x), mylgy2dvy(y), wstr.c_str(), wstr.length());
//#endif//_UNICODE
//} // FCAutoDC::TextOut.
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
BOOL FCAutoDC::TextOut (int x, int y, const WString& wstr, WORD wCodePage)
{
	return TextOut(x, y, wstr.c_str(), wstr.length(), wCodePage);
} // FCAutoDC::TextOut.
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----

BOOL FCAutoDC::ExtTextOut (	int x, int y, UINT nOptions, int left, int top,
							int right, int bottom, const wchar_t* lpszString,
							UINT nCount, WORD wCodePage, LPINT lpDxWidths)
{
#if defined(_MBCS)
	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
	//----- NT_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		return ::ExtTextOutW(m_pDC->m_hDC, mylgx2dvx(x), mylgy2dvy(y), nOptions,
							mylg2dv(left, top, right, bottom),
							lpszString, nCount, lpDxWidths);
	} else
	//----- 95_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		if (lpDxWidths != NULL)
		//----- lpDxWidths_xZkqqHx_iCmMiOhHjCoIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			astring astr;
			// ExtTextOut_xZkqqHx_iCmMjFlGiOjKiKnEjFjNiOhHjCoIiIpIjAjEjHhAiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
			vector<int> viDxWidths;
			for (int iC = 0; iC < nCount; iC++)
			{
				char szBuff[3];
				long lStrLen;
				(void)GetAChar(szBuff, lStrLen, lpszString[iC], wCodePage);
				if (lStrLen == 2)
				//----- 1_xZkqqHx_jFlGiOjKiCkK_xHqqkZx_2_xZkqqHx_iDgPiDeDiDgHiCmMiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_jFlGiOjKjFjNiCmMiLeMjIfOiCoA_xHqqkZx_2_xZkqqHx_iCmCiCmJiClHiCoJiBeC_xHqqkZx_
					viDxWidths.push_back(lpDxWidths[iC] / 2);
					viDxWidths.push_back(lpDxWidths[iC] - viDxWidths.back());
				} else
				//----- 1_xZkqqHx_jFlGiOjKiCkK_xHqqkZx_1_xZkqqHx_iDgPiDeDiDgHiCmMiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_jFlGiOjKjFjNiCmMiLeMjIfOiCoA_xHqqkZx_1_xZkqqHx_iCmCiCmJiClHiCoJiBeC_xHqqkZx_
					viDxWidths.push_back(lpDxWidths[iC]);
				}
				astr += szBuff;
			}
			return ::ExtTextOut(m_pDC->m_hDC, mylgx2dvx(x), mylgy2dvy(y), nOptions,
								mylg2dv(left, top, right, bottom),
								astr.c_str(), astr.length(),
								viDxWidths.begin());
		} else
		//----- lpDxWidths_xZkqqHx_iCmMiOhHjCoIiCkKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			astring astr((nCount + 1) * sizeof(wchar_t), '\0');
			int iSize = WideCharToMultiByte(wCodePage, 0, lpszString, nCount,
											astr.begin(), astr.size(), NULL, NULL);
			return ::ExtTextOut(m_pDC->m_hDC, mylgx2dvx(x), mylgy2dvy(y), nOptions,
								mylg2dv(left, top, right, bottom),
								astr.c_str(), iSize, NULL);
		}
	}
#elif defined(_UNICODE)
	return ::ExtTextOutW(m_pDC->m_hDC, mylgx2dvx(x), mylgy2dvy(y), nOptions,
							mylg2dv(left, top, right, bottom),
							lpszString, nCount, lpDxWidths);
#endif//_UNICODE
} // FCAutoDC::ExtTextOut.

BOOL FCAutoDC::ExtTextOut (int x, int y, const WString& str, WORD wCodePage, LPINT lpDxWidths)
{
	return ExtTextOut(x, y, 0, 0, 0, 0, 0, str.c_str(), str.length(), wCodePage, lpDxWidths);
} // FCAutoDC::ExtTextOut.

int FCAutoDC::DrawText (const wchar_t* lpszString, int nCount, WORD wCodePage,
						LPRECT lpRect, UINT nFormat)
{
#if defined(_MBCS)
	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
	//----- NT_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		return ::DrawTextW(m_pDC->m_hDC, lpszString, nCount, mylg2dv(lpRect), nFormat);
	} else
	//----- 95_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		astring astr((nCount + 1) * sizeof(wchar_t), '\0');
		int iSize = WideCharToMultiByte(wCodePage, 0, lpszString, nCount,
										astr.begin(), astr.size(), NULL, NULL);
		return ::DrawText(m_pDC->m_hDC, astr.c_str(), iSize, mylg2dv(lpRect), nFormat);
	}
#elif defined(_UNICODE)
	return ::DrawTextW(m_pDC->m_hDC, lpszString, nCount, mylg2dv(lpRect), nFormat);
#endif//_UNICODE
} // FCAutoDC::DrawText.

int FCAutoDC::DrawText (const WString& wstr, WORD wCodePage, LPRECT lpRect, UINT nFormat)
{
	return DrawText(wstr.c_str(), wstr.size(), wCodePage, lpRect, nFormat);
} // FCAutoDC::DrawText.

int FCAutoDC::DrawTextEx (const WString& wstr, WORD wCodePage, LPRECT lpRect,
						UINT nFormat, DRAWTEXTPARAMS* lpDTParams)
{
#if defined(_MBCS)
	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
	//----- NT_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_iLkNiIpIiCmJ_xHqqkZx_(wchar_t*)_xZkqqHx_iDeMiDiDiDfIiDgHiClHiCoJiCkKiBeB_xHqqkZx_DT_MODIFYSTRING_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmIiCkCiMmAiCoIjCgMiCkKjAnNjCoIiClDiCoKiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
		return ::DrawTextExW(m_pDC->m_hDC, (wchar_t*)wstr.c_str(), wstr.length(),
							mylg2dv(lpRect), nFormat, lpDTParams);
	} else
	//----- 95_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		astring astr((wstr.size() + 1) * sizeof(wchar_t), '\0');
		int iSize = WideCharToMultiByte(wCodePage, 0, wstr.c_str(), wstr.size(),
										astr.begin(), astr.size(), NULL, NULL);
		return ::DrawTextEx(m_pDC->m_hDC, (char*)astr.c_str(), iSize,
							mylg2dv(lpRect), nFormat, lpDTParams);
	}
#elif defined(_UNICODE)
	// _xZkqqHx_iLkNiIpIiCmJ_xHqqkZx_(wchar_t*)_xZkqqHx_iDeMiDiDiDfIiDgHiClHiCoJiCkKiBeB_xHqqkZx_DT_MODIFYSTRING_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmIiCkCiMmAiCoIjCgMiCkKjAnNjCoIiClDiCoKiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
	return ::DrawTextExW(m_pDC->m_hDC, (wchar_t*)wstr.c_str(), wstr.length(),
						mylg2dv(lpRect), nFormat, lpDTParams);
#endif//_UNICODE
} // FCAutoDC::DrawTextEx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::DrawTextLines
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCmJiKoOiCmDiCkCiCmEiBeBiJpMiNhDiCpAiKnMiCnOiDgFiDeMiDfIiDgHiCpAiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iLoJiMgAjCiGiCmJjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgrtBox		:_xZkqqHx_jFlGiOjKiCpAjFfMiOkGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstr		:_xZkqqHx_jFfMiOkGiClHiCoJiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wCodePage	: _xZkqqHx_iClBiCmMjFlGiOjKiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxLineHeight:_xZkqqHx_iCfAiNhDiCmMiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxLineGap	:_xZkqqHx_iNhDiCmGiNhDiCmMiKnEiCmMiDeNiDiDiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwFormat	:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiNhDjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	dwFormat _xZkqqHx_iCmJ_xHqqkZx_ _xZkqqHx_iPoDiJlKjFpLiMpMiCmFiCmMjEhKjChFiCpAiOhHjCoIiClFiClNiPoKiNiHiBeBiJlKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 *			DT_TOP_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiBeC_xHqqkZx_
 *         _xZkqqHx_iEkBiBgDiBgDiBgDiBgD_xHqqkZx_ lgrtBox_xZkqqHx_iBgDiBgDiBgDiBgDiBgDiEkC_xHqqkZx_
 *         _xZkqqHx_iBeGiCfAiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfBiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfCiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfDiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfEiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 *			DT_VCENTER_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiBeC_xHqqkZx_
 *         _xZkqqHx_iEkBiBgDiBgDiBgDiBgD_xHqqkZx_ lgrtBox_xZkqqHx_iBgDiBgDiBgDiBgDiBgDiEkC_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfAiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfBiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfCiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfDiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfEiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 *			DT_BOTTOM_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiBeC_xHqqkZx_
 *         _xZkqqHx_iEkBiBgDiBgDiBgDiBgD_xHqqkZx_ lgrtBox_xZkqqHx_iBgDiBgDiBgDiBgDiBgDiEkC_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfAiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfBiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfCiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfDiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iBeGiCfEiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_
 *         _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCAutoDC::DrawTextLines (	const CRect& lgrtBox,
								const WString& wstr,
								WORD wCodePage,
								long pxLineHeight,
								long pxLineGap,
								DWORD dwFormat,
								BOOL bIsWordWrapE,
								BOOL bIsWordWrapJ)
{
	CRect dvrtBox = mylg2dv(lgrtBox);
	long lLineCount = 0;
	longlongVector vCountLength;
	// _xZkqqHx_iKgFiNhDiCmMjFlGiOjKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	WStringVector vText;
	FFCalcTextLines(vText, m_pDC, wstr, dvrtBox.Width(), wCodePage, bIsWordWrapE, bIsWordWrapJ);

	if (dwFormat & DT_VCENTER)
	//----- _xZkqqHx_iPgDjCiGiKpBiClJiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgFiDeMiDfIiDgHjBfDjBmMiNiCiBeC_xHqqkZx_
		long pxTextH;
		//----- _xZkqqHx_iDgFiDeMiDfIiDgHjBfDjBmMiCkKiOhHjCoIiCmMiLoJiMgAiCmJiOpLiCnMiCoJiCoGiCkEiBeBiDgFiDeMiDfIiDgHiCmMiBgIiPoDiJlKiBgIiCpAiDeKiDgCiDgHiClHiCoJ_xHqqkZx_ -----
		for (;;)
		{
			// vText _xZkqqHx_iCmMiPoKiNiHiCmMiBeBjBfDjBmMiCmMiNiCiClDiCpAiMhGiOfKiBeC_xHqqkZx_
			pxTextH = vText.size() * pxLineHeight + (long(vText.size()) - 1) * pxLineGap;
			// _xZkqqHx_iNiCiClDiCkKjFfMiOkGiLoJiMgAiCmJiOpLiCnMiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
			if (pxTextH <= dvrtBox.Height()) break;
			// _xZkqqHx_iOpLiCnMiCoHiCmIiCkCiCmMiCmFiBeBiNmFiMoDiCmMiNhDiCpAiNoNiCoJiBeC_xHqqkZx_
			vText.pop_back();
			// vText _xZkqqHx_iCmMiPoKiNiHiCmMiBeBjBfDjBmMiCmMiNiCiClDiCpAiMhGiOfKiBeC_xHqqkZx_
			pxTextH = vText.size() * pxLineHeight + (long(vText.size()) - 1) * pxLineGap;
			// _xZkqqHx_iNiCiClDiCkKjFfMiOkGiLoJiMgAiCmJiOpLiCnMiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
			if (pxTextH <= dvrtBox.Height()) break;
			// _xZkqqHx_iOpLiCnMiCoHiCmIiCkCiCmMiCmFiBeBiNmFiPiJiCmMiNhDiCpAiNoNiCoJiBeC_xHqqkZx_
			vText.erase(vText.begin());
		}
//		pxTextH = vText.size() * pxLineHeight + (long(vText.size()) - 1) * pxLineGap;
		// _xZkqqHx_jFfMiOkGiLoJiMgAiCmMiPoDiCpAjClCjAkOiClHiCoJiBeC_xHqqkZx_
		dvrtBox.top += (dvrtBox.Height() - pxTextH) / 2.0;
	} else
	if (dwFormat & DT_BOTTOM)
	//----- _xZkqqHx_iJlKiKpBiClJiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgFiDeMiDfIiDgHjBfDjBmMiNiCiBeC_xHqqkZx_
		long pxTextH;
		//----- _xZkqqHx_iDgFiDeMiDfIiDgHjBfDjBmMiCkKiOhHjCoIiCmMiLoJiMgAiCmJiOpLiCnMiCoJiCoGiCkEiBeBiDgFiDeMiDfIiDgHiCmMiBgIiPoDiBgIiCpAiDeKiDgCiDgHiClHiCoJ_xHqqkZx_ -----
		for (;;)
		{
			// vText _xZkqqHx_iCmMiPoKiNiHiCmMiBeBjBfDjBmMiCmMiNiCiClDiCpAiMhGiOfKiBeC_xHqqkZx_
			pxTextH = vText.size() * pxLineHeight + (long(vText.size()) - 1) * pxLineGap;
			// _xZkqqHx_iNiCiClDiCkKjFfMiOkGiLoJiMgAiCmJiOpLiCnMiCoJiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
			if (pxTextH <= dvrtBox.Height()) break;
			// _xZkqqHx_iOpLiCnMiCoHiCmIiCkCiCmMiCmFiBeBiNmFiPiJiCmMiNhDiCpAiNoNiCoJiBeC_xHqqkZx_
			vText.erase(vText.begin());
		}
//		pxTextH = vText.size() * pxLineHeight + (long(vText.size()) - 1) * pxLineGap;
		// _xZkqqHx_jFfMiOkGiLoJiMgAiCmMiPoDiCpAjClCjAkOiClHiCoJiBeC_xHqqkZx_
		dvrtBox.top += dvrtBox.Height() - pxTextH;
	}
	// _xZkqqHx_jFhDjHhGiCmIiDhEiDeIiBfLiDhNiDgCiDgHiCpAjGjFiPmBiBeC_xHqqkZx_
	dwFormat &= ~DT_VCENTER;
	dwFormat &= ~DT_BOTTOM;
	// _xZkqqHx_jFeLjHhGiCmIiDhEiDeIiBfLiDhNiDgCiDgHiCpAjCmHiJmBiBeC_xHqqkZx_
	dwFormat |= DT_TOP;
	dwFormat |= DT_SINGLELINE;

	WStringVector::const_iterator iTx;
	for (iTx = vText.begin(); iTx != vText.end(); iTx++)
	{
		// _xZkqqHx_iClBiCoKiImIiPoDjFgAiJoGiCmFiCkLiCmIiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (dvrtBox.bottom <= dvrtBox.top) break;
		// _xZkqqHx_iNmFiPiJiCmMiNhDiImIiKePiCmNiBeBiNhDiKnEiDeNiDiDiDgCiDhGiCpAiJmBiOfKiBeC_xHqqkZx_
		if (iTx != vText.begin())
			dvrtBox.top += pxLineGap;
		// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAjFgAiJoGiBeC_xHqqkZx_
		DrawText(*iTx, wCodePage, dvrtBox, dwFormat);
		// _xZkqqHx_iNhDjAjEiCpAiJmBiOfKiBeC_xHqqkZx_
		lLineCount++;
		// _xZkqqHx_jFgAiJoGiImKjChFiCpAiCfAiNhDiJlKiCmJiClIiCoHiClHiBeC_xHqqkZx_
		dvrtBox.top += pxLineHeight;
	}
	// _xZkqqHx_iNhDjAjEiCpAjFnEiClHiBeC_xHqqkZx_
	return lLineCount;
} // FCAutoDC::DrawTextLines.

int FCAutoDC::IntersectClipRect (int x1, int y1, int x2, int y2)
{
	return m_pDC->IntersectClipRect(mylg2dv(x1, y1, x2, y2));
} // FCAutoDC::IntersectClipRect.

int FCAutoDC::IntersectClipRect (LPCRECT lpRect)
{
	return m_pDC->IntersectClipRect(mylg2dv(lpRect));
} // FCAutoDC::IntersectClipRect.

int FCAutoDC::SetClipRgn (CRgn* pRgn)
{
	return m_pDC->SelectClipRgn(pRgn);
} // FCAutoDC::SetClipRgn.

int FCAutoDC::SetClipRgn (CRgn* pRgn, int nMode)
{
	return m_pDC->SelectClipRgn(pRgn, nMode);
} // FCAutoDC::SetClipRgn.

void FCAutoDC::FillRect (LPCRECT lpRect, FCAtBrush& brush)
{
	m_pDC->FillRect(mylg2dv(lpRect), brush.Get());
} // FCAutoDC::FillRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::FillPoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDfDiDjDiCpAiMlLiNnNiCmMiDhFiDiJiDfGiCmFjDgIiCoIiCmCiCnEiClHiBeCjApMiCmNjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::FillPoly (LPPOINT lpPoints, int nCount)
{
	m_pDC->BeginPath();
	POINT* dvpta = new POINT[nCount];
	mylg2dv(dvpta, lpPoints, nCount);
	m_pDC->Polygon(dvpta, nCount);
	delete[] dvpta;
	m_pDC->EndPath();
	m_pDC->FillPath();
} // FCAutoDC::FillPoly.

BOOL FCAutoDC::Polygon (LPPOINT lpPoints, int nCount)
{
	POINT* dvpt = new POINT[nCount];
	mylg2dv(dvpt, lpPoints, nCount);
	BOOL bRet = m_pDC->Polygon(dvpt, nCount);
	delete[] dvpt;
	return bRet;
} // FCAutoDC::Polygon.

BOOL FCAutoDC::Polyline (LPPOINT lpPoints, int nCount)
{
	POINT* dvpt = new POINT[nCount];
	mylg2dv(dvpt, lpPoints, nCount);
	BOOL bRet = m_pDC->Polyline(dvpt, nCount);
	delete[] dvpt;
	return bRet;
} // FCAutoDC::Polyline.

BOOL FCAutoDC::Arc (LPCRECT lpRect, POINT ptStart, POINT ptEnd)
{
	return m_pDC->Arc(mylg2dv(lpRect), mylg2dv(ptStart), mylg2dv(ptEnd));
} // FCAutoDC::Arc.

BOOL FCAutoDC::Pie (LPCRECT lpRect, POINT ptStart, POINT ptEnd)
{
	return m_pDC->Pie(mylg2dv(lpRect), mylg2dv(ptStart), mylg2dv(ptEnd));
} // FCAutoDC::Pie.

BOOL FCAutoDC::Chord (LPCRECT lpRect, POINT ptStart, POINT ptEnd)
{
	return m_pDC->Chord(mylg2dv(lpRect), mylg2dv(ptStart), mylg2dv(ptEnd));
} // FCAutoDC::Chord.

BOOL FCAutoDC::Rectangle (int x1, int y1, int x2, int y2)
{
	return m_pDC->Rectangle(mylg2dv(x1, y1, x2, y2));
} // FCAutoDC::Rectangle.

BOOL FCAutoDC::Rectangle (LPCRECT lpRect)
{
	return m_pDC->Rectangle(mylg2dv(lpRect));
} // FCAutoDC::Rectangle.

BOOL FCAutoDC::BitBlt (int x, int y, int nWidth, int nHeight, CDC* pSrcDC, int xSrc, int ySrc, DWORD dwRop)
{
	return m_pDC->BitBlt(mylgx2dvx(x), mylgy2dvy(y), nWidth, nHeight, pSrcDC,
							xSrc, ySrc, dwRop);
} // FCAutoDC::BitBlt.

void FCAutoDC::DrawFocusRect (LPCRECT lpRect)
{
	m_pDC->DrawFocusRect(mylg2dv(lpRect));
} // FCAutoDC::DrawFocusRect.

BOOL FCAutoDC::DrawEdge (LPRECT lpRect, UINT nEdge, UINT nFlags)
{
	return m_pDC->DrawEdge(mylg2dv(lpRect), nEdge, nFlags);
} // FCAutoDC::DrawEdge.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::DrawEdge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lDepth = -4 _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkA_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkB_xHqqkZx_                  _xZkqqHx_iBkAiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkB_xHqqkZx_                  _xZkqqHx_iBkAiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkB_xHqqkZx_                  _xZkqqHx_iBkAiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkB_xHqqkZx_                  _xZkqqHx_iBkAiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkB_xHqqkZx_                  _xZkqqHx_iBkAiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkBiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkA_xHqqkZx_
 *
 *          lDepth = 3 _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkB_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkA_xHqqkZx_                      _xZkqqHx_iBkBiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkA_xHqqkZx_                      _xZkqqHx_iBkBiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkA_xHqqkZx_                      _xZkqqHx_iBkBiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkA_xHqqkZx_                      _xZkqqHx_iBkBiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkA_xHqqkZx_                      _xZkqqHx_iBkBiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkA_xHqqkZx_                      _xZkqqHx_iBkBiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkA_xHqqkZx_                      _xZkqqHx_iBkBiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkAiBkAiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkAiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkB_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkB_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCAutoDC::DrawEdge (LPCRECT lpRect, long lDepth, COLORREF colLight, COLORREF colShadow)
{
	if (lDepth == 0)
		FFThrowMiscUnknown();
	FCAtPen penUL(PS_SOLID, 1, (lDepth < 0) ? colShadow : colLight);
	FCAtPen penBR(PS_SOLID, 1, (lDepth < 0) ? colLight : colShadow);
	lDepth = labs(lDepth);
	long lC;
	CPoint pt0;
	CPoint pt1;
	pt0.x = lpRect->left;
	pt0.y = lpRect->bottom - 1;
	pt1.x = lpRect->right;
	pt1.y = lpRect->top;
	SetObject(penUL);
	for (lC = 0; lC != lDepth; lC++)
	{
		MoveTo(pt0);
		LineTo(pt0.x, pt1.y);
		LineTo(pt1);
		pt0 += CSize(1,-1);
		pt1 += CSize(-1,1);
	}

	pt0.x = lpRect->left;
	pt0.y = lpRect->bottom;
	pt1.x = lpRect->right;
	pt1.y = lpRect->top + 1;
	SetObject(penBR);
	for (lC = 0; lC != lDepth; lC++)
	{
		MoveTo(pt0);
		LineTo(pt1.x, pt0.y);
		LineTo(pt1);
		pt0 += CSize(1,-1);
		pt1 += CSize(-1,1);
	}
} // FCAutoDC::DrawEdge.

//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::PlayMetaFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCAutoDC::PlayMetaFile (	HENHMETAFILE hEnhMetaFile,
//								const CRect& lgrtBounds,
//								const CRect& lgrtFrame,
//								const FCLgPolyBezier& lgptaPoly,
//								BOOL bTileH, BOOL bTileV)
//{
////----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	POINT* dvpt = new POINT[lPolySize + 1];
////	mylg2dv(dvpt, lgptaPoly, lPolySize);
////	if (dvpt[lPolySize - 1].x != dvpt[0].x || dvpt[lPolySize - 1].y != dvpt[0].y)
////	{
////		dvpt[lPolySize] = dvpt[0];
////		lPolySize++;
////	}
////----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	FCLgPolyBezier dvpt;
//	mylg2dv(dvpt, lgptaPoly);
//	if (dvpt.back().x != dvpt.front().x || dvpt.back().y != dvpt.front().y)
//		dvpt.push_back(dvpt[0]);
////----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMiDhNiDfIiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
//	m_pDC->BeginPath();
////----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	m_pDC->Polygon(dvpt, lPolySize);
////----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	if (dvpt.GetIsBezier())
//		m_pDC->PolyBezier(&dvpt.front(), dvpt.size());
//	else
//		m_pDC->Polygon(&dvpt.front(), dvpt.size());
////----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	m_pDC->EndPath();
//	m_pDC->SelectClipPath(RGN_AND);
//// 05.04.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	delete[] dvpt;
//	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLjFgAiJoGiImKjChFiCpAiMhGiOfKiBeC_xHqqkZx_
//	const CRect dvrtBounds = mylg2dv(lgrtBounds);
//	// _xZkqqHx_iDhMiDiKiDfDiDjDiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
//	CRect dvrtFrame = mylg2dv(lgrtFrame);
//	long lBoundsW = dvrtBounds.Width();
//	long lBoundsH = dvrtBounds.Height();
//	CRect dvrtDraw = dvrtBounds;
//	do
//	{
//		do
//		{
//			if (!m_pDC->PlayMetaFile(hEnhMetaFile, dvrtDraw)) return FALSE;
//			dvrtDraw.left += lBoundsW;
//			dvrtDraw.right += lBoundsW;
//		} while (bTileH && dvrtDraw.left < dvrtFrame.right);
//		dvrtDraw.left = dvrtBounds.left;
//		dvrtDraw.right = dvrtBounds.right;
//		dvrtDraw.top += lBoundsH;
//		dvrtDraw.bottom += lBoundsH;
//	} while (bTileV && dvrtDraw.top < dvrtFrame.bottom);
//
//	return TRUE;
//} // FCAutoDC::PlayMetaFile.
//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

BOOL FCAutoDC::DrawIconEx (int xLeft, int yTop, HICON hIcon, int cxWidth, int cyWidth,
							UINT istepIfAniCur, HBRUSH hbrFlickerFreeDraw, UINT diFlags)
{
	return ::DrawIconEx(m_pDC->m_hDC, xLeft, yTop, hIcon, cxWidth, cyWidth,
						istepIfAniCur, hbrFlickerFreeDraw, diFlags);
} // FCAutoDC::DrawIconEx.

CSize FCAutoDC::GetTextExtent (const wchar_t* wszString, int nCount) const
{
	return m_pDC->GetTextExtent(WStrToTStr(wszString), nCount);
} // FCAutoDC::GetTextExtent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::CurAtObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjAnNjCoIiClDiCoKiCmEiCkCiCoJ_xHqqkZx_AutoGDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			template_xZkqqHx_iKnGjAjEjHhAiCmJjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	FCAtFont	:_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCpAjDmBjCoIiClHiCoJiClNiCnPiCmMiIpIjAjEiBeCiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmM_xHqqkZx_AutoGDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAtFont* & FCAutoDC::CurAtObject (FCAtFont&)
{
	return m_pCurAtFont;
} // FCAutoDC::CurAtObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::CurAtObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjAnNjCoIiClDiCoKiCmEiCkCiCoJ_xHqqkZx_AutoGDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			template_xZkqqHx_iKnGjAjEjHhAiCmJjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	FCAtPen	:_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCpAjDmBjCoIiClHiCoJiClNiCnPiCmMiIpIjAjEiBeCiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmM_xHqqkZx_AutoGDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAtPen* & FCAutoDC::CurAtObject (FCAtPen&)
{
	return m_pCurAtPen;
} // FCAutoDC::CurAtObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::CurAtObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjAnNjCoIiClDiCoKiCmEiCkCiCoJ_xHqqkZx_AutoGDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			template_xZkqqHx_iKnGjAjEjHhAiCmJjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	FCAtBrush	:_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCpAjDmBjCoIiClHiCoJiClNiCnPiCmMiIpIjAjEiBeCiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmM_xHqqkZx_AutoGDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAtBrush* & FCAutoDC::CurAtObject (FCAtBrush&)
{
	return m_pCurAtBrush;
} // FCAutoDC::CurAtObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::CurAtObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjAnNjCoIiClDiCoKiCmEiCkCiCoJ_xHqqkZx_AutoGDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			template_xZkqqHx_iKnGjAjEjHhAiCmJjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	FCAtBitmap	:_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCpAjDmBjCoIiClHiCoJiClNiCnPiCmMiIpIjAjEiBeCiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmM_xHqqkZx_AutoGDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAtBitmap* & FCAutoDC::CurAtObject (FCAtBitmap&)
{
	return m_pCurAtBitmap;
} // FCAutoDC::CurAtObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::BackupGdiObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDiKiDfHiDgJiDiLiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiDgPiDgCiDeOiDeBiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pFont	:GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiClN_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFont* FCAutoDC::BackupGdiObject (CFont* pFont)
{
	ASSERT(m_pFontOrig != NULL || pFont != NULL);
	// _xZkqqHx_iKpJiCmJiDeJiDiKiDfHiDgJiDiLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiCmIiCoHiBeBiPoDiPjBiCkLiClFiCmIiCkCiCmFiPeJjHlJiBeC_xHqqkZx_
	if (m_pFontOrig != NULL && pFont != NULL) return NULL;
	CFont* pFontOrig = m_pFontOrig;
	m_pFontOrig = pFont;
	return pFontOrig;
} // FCAutoDC::BackupGdiObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::BackupGdiObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDiKiDfHiDgJiDiLiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiDgPiDgCiDeOiDeBiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPen	:GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiClN_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPen* FCAutoDC::BackupGdiObject (CPen* pPen)
{
	ASSERT(m_pPenOrig != NULL || pPen != NULL);
	// _xZkqqHx_iKpJiCmJiDeJiDiKiDfHiDgJiDiLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiCmIiCoHiBeBiPoDiPjBiCkLiClFiCmIiCkCiCmFiPeJjHlJiBeC_xHqqkZx_
	if (m_pPenOrig != NULL && pPen != NULL) return NULL;
	CPen* pPenOrig = m_pPenOrig;
	m_pPenOrig = pPen;
	return pPenOrig;
} // FCAutoDC::BackupGdiObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::BackupGdiObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDiKiDfHiDgJiDiLiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiDgPiDgCiDeOiDeBiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pBrush	:GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiClN_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CBrush* FCAutoDC::BackupGdiObject (CBrush* pBrush)
{
	ASSERT(m_pBrushOrig != NULL || pBrush != NULL);
	// _xZkqqHx_iKpJiCmJiDeJiDiKiDfHiDgJiDiLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiCmIiCoHiBeBiPoDiPjBiCkLiClFiCmIiCkCiCmFiPeJjHlJiBeC_xHqqkZx_
	if (m_pBrushOrig != NULL && pBrush != NULL) return NULL;
	CBrush* pBrushOrig = m_pBrushOrig;
	m_pBrushOrig = pBrush;
	return pBrushOrig;
} // FCAutoDC::BackupGdiObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::BackupGdiObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDiKiDfHiDgJiDiLiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiDgPiDgCiDeOiDeBiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pBitmap	:GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiClN_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CBitmap* FCAutoDC::BackupGdiObject (CBitmap* pBitmap)
{
	ASSERT(m_pBitmapOrig != NULL || pBitmap != NULL);
	// _xZkqqHx_iKpJiCmJiDeJiDiKiDfHiDgJiDiLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiCmIiCoHiBeBiPoDiPjBiCkLiClFiCmIiCkCiCmFiPeJjHlJiBeC_xHqqkZx_
	if (m_pBitmapOrig != NULL && pBitmap != NULL) return NULL;
	CBitmap* pBitmapOrig = m_pBitmapOrig;
	m_pBitmapOrig = pBitmap;
	return pBitmapOrig;
} // FCAutoDC::BackupGdiObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::GetDC
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmM_xHqqkZx_CDC_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	CDC_xZkqqHx_iDhMiDeDiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CDC* FCAutoDC::GetDC () const
{
	return m_pDC;
} // FCAutoDC::GetDC.

///////////////////////////////////////////////////////////////////////////
// mylg2dv
// _xZkqqHx_jIfPjHjNiNmAjFfHiCmJiBeBiDeJiDhEiDfKiDgCiDgHiCpAiJmBiOfKiClFiCmEiDgGiDgPiDeDiDfIiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_

CPoint FCAutoDC::mylg2dv (const CPoint& lgpt) const
{
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	// mylgx2dvx,mylgx2dvy_xZkqqHx_iCmFjAkHiMmAiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
	return CPoint(mylgx2dvx(lgpt.x), mylgy2dvy(lgpt.y));
} // FCAutoDC::mylg2dv.

CPoint FCAutoDC::mylg2dv (long x, long y) const
{
	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
	// mylgx2dvx,mylgx2dvy_xZkqqHx_iCmFjAkHiMmAiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
	return CPoint(mylgx2dvx(x), mylgy2dvy(y));
} // FCAutoDC::mylg2dv.

CRect FCAutoDC::mylg2dv (const CRect& lgrt) const
{
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//	return CRect(lgrt.left - m_lgOffsetX, lgrt.top - m_lgOffsetY,
//					lgrt.right - m_lgOffsetX, lgrt.bottom - m_lgOffsetY);
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	return CRect(mylgx2dvx(lgrt.left),
				 mylgy2dvy(lgrt.top),
				 mylgx2dvx(lgrt.right),
				 mylgy2dvy(lgrt.bottom));
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
} // FCAutoDC::mylg2dv.

CRect FCAutoDC::mylg2dv (long left, long top, long right, long bottom) const
{
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//	return CRect(left - m_lgOffsetX, top - m_lgOffsetY,
//					right - m_lgOffsetX, bottom - m_lgOffsetY);
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	return CRect(mylgx2dvx(left),
				 mylgy2dvy(top),
				 mylgx2dvx(right),
				 mylgy2dvy(bottom));
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
} // FCAutoDC::mylg2dv.

//----- 02.07.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//long FCAutoDC::mylgx2dvx (long lgx) const
//{
//// 02.07.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)
////	return lgx - m_lgOffsetX;
//	return FFLimitCoord(lgx - m_lgOffsetX);
//} // FCAutoDC::mylgx2dvx.
//
//long FCAutoDC::mylgy2dvy (long lgy) const
//{
//// 02.07.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)
////	return lgy - m_lgOffsetY;
//	return FFLimitCoord(lgy - m_lgOffsetY);
//} // FCAutoDC::mylgy2dvy.
//----- 02.07.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----

void FCAutoDC::mylg2dv (POINT* dvpt, const POINT* lgpt, long lCount) const
{
	for (long lC = 0; lC != lCount; lC++)
	{
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
//		dvpt[lC].x = lgpt[lC].x - m_lgOffsetX;
//		dvpt[lC].y = lgpt[lC].y - m_lgOffsetY;
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
		dvpt[lC].x = mylgx2dvx(lgpt[lC].x);
		dvpt[lC].y = mylgy2dvy(lgpt[lC].y);
//----- 02.07.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	}
} // FCAutoDC::mylg2dv.

//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void FCAutoDC::mylg2dv (FCLgPolyBezier& dvpt, const FCLgPolyBezier& lgpt) const
//{
//	dvpt.SetIsBezier(lgpt.GetIsBezier());
//	// _xZkqqHx_jFjEjFgJiCkKjBoFiCkLiCkCiPoKiNiHiBeBiDfJiBfLiDiAiCpAjBoFiCkLiCkNiClHiCoJiCmGiBeBjFjEjFgJiCmMiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCkK_xHqqkZx_
//	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiClHiCkMiCoJiCkJiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiBeC_xHqqkZx_95_xZkqqHx_iDeKiBfLiDgMiDiLiCmFiCmNjFfMiOkGiCkKjHjAiCoKiCoJiBeC_xHqqkZx_
//	dvpt.assign(lgpt.size());
//	for (long lC = 0; lC < lgpt.size(); lC++)
//	{
//		dvpt[lC].x = mylgx2dvx(lgpt[lC].x);
//		dvpt[lC].y = mylgy2dvy(lgpt[lC].y);
//	}
//} // FCAutoDC::mylg2dv.
//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////////////
// FCAutoGdiStock _xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoGdiStock::FCAutoGdiStock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAutoGdiStock::FCAutoGdiStock ()
{
} // FCAutoGdiStock::FCAutoGdiStock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoGdiStock::~FCAutoGdiStock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAutoGdiStock::~FCAutoGdiStock ()
{
	map<FC3Fold<int, int, COLORREF>, FCAtPen*>::iterator iPen;
	for (iPen = m_mpPen.begin(); iPen != m_mpPen.end(); iPen++)
		delete (*iPen).second;
	m_mpPen.clear();
	map<COLORREF, FCAtBrush*>::iterator iBrs;
	for (iBrs = m_mpBrush.begin(); iBrs != m_mpBrush.end(); iBrs++)
		delete (*iBrs).second;
	m_mpBrush.clear();
} // FCAutoGdiStock::~FCAutoGdiStock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoGdiStock::GetPen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDhJiDjDiCpAjFnEiClHiBeCjDgPjIfOiCkKiCmIiCkPiCoKiCmOiBeBjAfGiLeLiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nPenStyle	:_xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nWidth		:_xZkqqHx_iDhJiDjDiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			crColor		:_xZkqqHx_iDhJiDjDiCmMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAtPen& FCAutoGdiStock::GetPen (int nPenStyle, int nWidth, COLORREF crColor)
{
	map<FC3Fold<int, int, COLORREF>, FCAtPen*>::iterator iPen;
	iPen = m_mpPen.find(FC3Fold<int, int, COLORREF>(nPenStyle, nWidth, crColor));
	if (iPen != m_mpPen.end()) return *(*iPen).second;
	FCAtPen* pPen = new FCAtPen(nPenStyle, nWidth, crColor);
	m_mpPen[FC3Fold<int, int, COLORREF>(nPenStyle, nWidth, crColor)] = pPen;
	return *pPen;
} // FCAutoGdiStock::GetPen.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoGdiStock::GetRegPen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDhJiDjDiCpAjFnEiClHiBeCjDgPjIfOiCkKiCmIiCkPiCoKiCmOiBeBjAfGiLeLiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nPenStyle	:_xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nWidth		:_xZkqqHx_iDhJiDjDiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nType		:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClDiCoKiCmEiCkCiCoJiDhJiDjDiCmMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAtPen& FCAutoGdiStock::GetRegPen (int nPenStyle, int nWidth, FDRegColorType nType)
{
	return GetPen(nPenStyle, nWidth, g_pReg->GetOptiRegColor(nType));
} // FCAutoGdiStock::GetRegPen.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoGdiStock::GetBrush
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDhFiDiJiDfGiCpAjFnEiClHiBeCjDgPjIfOiCkKiCmIiCkPiCoKiCmOiBeBjAfGiLeLiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	crColor		:_xZkqqHx_iDhFiDiJiDfGiCmMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhFiDiJiDfGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAtBrush& FCAutoGdiStock::GetBrush (COLORREF crColor)
{
	map<COLORREF, FCAtBrush*>::iterator iBrs;
	iBrs = m_mpBrush.find(crColor);
	if (iBrs != m_mpBrush.end()) return *(*iBrs).second;
	FCAtBrush* pBrush = new FCAtBrush(crColor);
	m_mpBrush[crColor] = pBrush;
	return *pBrush;
} // FCAutoGdiStock::GetBrush.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoGdiStock::GetRegBrush
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDhFiDiJiDfGiCpAjFnEiClHiBeCjDgPjIfOiCkKiCmIiCkPiCoKiCmOiBeBjAfGiLeLiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClDiCoKiCmEiCkCiCoJiDhFiDiJiDfGiCmMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhFiDiJiDfGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCAtBrush& FCAutoGdiStock::GetRegBrush (FDRegColorType nType)
{
	return GetBrush(g_pReg->GetOptiRegColor(nType));
} // FCAutoGdiStock::GetRegBrush.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetMiddleColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDpBiCmCiCmMjAeGiCmMjCiGiKnEjAeGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dProportion	:_xZkqqHx_jDpBiCmCiCmMjAeGiCmMiKiEiNiHiCpAiOhHjCoIiBeC_xHqqkZx_[0.0, 1.0]_xZkqqHx_iBeC_xHqqkZx_
 *						 0.0_xZkqqHx_iCmMiOjOiCmJ_xHqqkZx_colBegin_xZkqqHx_iBeB_xHqqkZx_1.0_xZkqqHx_iCmMiOjOiCmJ_xHqqkZx_colEnd_xZkqqHx_iBeC_xHqqkZx_
 *			colBegin	:_xZkqqHx_iKeKiOgOjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			colEnd		:_xZkqqHx_iPeJjHlJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCiGiKnEjAeGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
COLORREF FFGetMiddleColor (double dProportion, COLORREF colBegin, COLORREF colEnd)
{
	// _xZkqqHx_jCgMiCmMiPoDiMmAiBeFiJlKiMmAiCmFjFoCjAlDiBeC_xHqqkZx_
	if (dProportion < 0.0) dProportion = 0.0;
	if (1.0 < dProportion) dProportion = 1.0;
	// RGB_xZkqqHx_iCmJjFkKiJpAiBeC_xHqqkZx_
	double dBeginR = (double)GetRValue(colBegin);
	double dBeginG = (double)GetGValue(colBegin);
	double dBeginB = (double)GetBValue(colBegin);
	double dEndR = (double)GetRValue(colEnd);
	double dEndG = (double)GetGValue(colEnd);
	double dEndB = (double)GetBValue(colEnd);
	dBeginR += dProportion * (dEndR - dBeginR);
	dBeginG += dProportion * (dEndG - dBeginG);
	dBeginB += dProportion * (dEndB - dBeginB);
	return RGB(D2L(dBeginR), D2L(dBeginG), D2L(dBeginB));
} // FFGetMiddleColor.
