#include "stdafx.h"
#include "UtilMisc.h"	// For FFCalcFrame.
#include "UtilErr.h"	// For FFThrowMiscUnknown.
#include "UtilStdLib.h"	// For FFInsert.
#include "UtilLine.h"	// This header.

// _xZkqqHx_iDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_0_xZkqqHx_iCmMjApMjFkKjAjEiBhOiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_1_xZkqqHx_iCmMjApMjFkKjAjEiCmMiKoOiPiAjCgMiBeC_xHqqkZx_
// _xZkqqHx_iClBiCoKiCpAjClEiCkGiCoJiPoKiNiHiBeBiJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClFiCmEiBeBiJlKiImKiCmFjEoEiKhCiClHiCoJiBeC_xHqqkZx_
static const long FD_POLY_HASH_ITEM_MAX = 100;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	<
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DBLPoint_xZkqqHx_jDkPiOgNiCmMjBoFiPkMiKnGiMfHiCpAjEoEiKhCiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pt0,pt1	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmM_xHqqkZx_DBLPoint_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	pt0 < pt1 _xZkqqHx_iCmMiCmGiCkL_xHqqkZx_true_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_false_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	set<DBLPoint>,map<DBLPoint>_xZkqqHx_jDjJiCmF_xHqqkZx_DBLPoint_xZkqqHx_iCmMjBoFiPkMjEoEiKhCiCkKjFeLjHhGiBeC_xHqqkZx_
 *			almosteq_xZkqqHx_iCmFiMlFjGkHiCmIiIoKjChGiCmNjEpAiCkPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline bool operator < (const DBLPoint& pt0, const DBLPoint& pt1)
{
	if (almosteq(pt0.y, pt1.y))
		return almostless(pt0.x, pt1.x) ? true : false;
	return almostless(pt0.y, pt1.y) ? true : false;
} // bool operator < .

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetIntersectLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLoJiMgAiCmGjApMjFkKiCkKiMpAiCoNiCoJjApMjFkKiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmslIntersect	:_xZkqqHx_iMpAiNlHjApMjFkKiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmsl			:_xZkqqHx_jApMjFkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrt			:_xZkqqHx_iLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiNlHiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iLoJiMgAiCmGiMpAiCoNiCoJjApMjFkKiCmGiCmNiBeBiImIiJlKiCmMiCoGiCkEiCmJiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_         _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_        _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEjPiEjPiEjPiEjP_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkJiEjP_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_         _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_        _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *              _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_                 _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_                _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_  
 *            _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_             _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_            _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *             _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_              _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_ 
 *               _xZkqqHx_iBfPiBfO_xHqqkZx_                   _xZkqqHx_iBfPiBfO_xHqqkZx_                  _xZkqqHx_iBfPiBfO_xHqqkZx_   
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_         _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_        _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEjPiEjPiEkH_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEjPiEjPiEjPiEjP_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_         _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_        _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFGetIntersectLine (DBLShortLine& mmslIntersect, const DBLShortLine& mmsl, const DBLRect& mmrt)
{
	// mmptP[0],mmptP[1]_xZkqqHx_iCmMjHlMjFpLiCkKiBeB_xHqqkZx_mmslIntersect _xZkqqHx_iCmMjHlMjCfLiCmGiCmIiCoJiBeC_xHqqkZx_
	int iC = 0;
	DBLPoint mmptP[2];

	for (;;)
	{
		if (almosteq(mmsl.pt0.y, mmsl.pt1.y))
		//----- mmsl_xZkqqHx_iCkKjAiFjFlNjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (almostless(mmsl.pt0.y, mmrt.top) || almostless(mmrt.bottom, mmsl.pt0.y))
				return FALSE;
			if (almostlesseq(mmrt.left, mmsl.pt0.x) && almostlesseq(mmsl.pt0.x, mmrt.right))
				mmptP[iC++] = mmsl.pt0;
			if (almostlesseq(mmrt.left, mmsl.pt1.x) && almostlesseq(mmsl.pt1.x, mmrt.right))
				mmptP[iC++] = mmsl.pt1;
			if (iC == 2) break;
			DBLPoint mmptQ;
			// mmrt.bottom = mmrt.top _xZkqqHx_iCmMiPoKiNiHiCpAiNgMjHlGiClFiCmEiPoDiJlKiCmJiNeMiClAiCmEiCkIiCkNiBeC_xHqqkZx_
			const DBLShortLine mmslLeft(mmrt.left, mmrt.top - 10.0, mmrt.left, mmrt.bottom + 10.0);
			if (mmslLeft.CrossPoint(mmptQ, mmsl))
			{
				mmptP[iC++] = mmptQ;
				if (iC == 2) break;
			}
			// mmrt.bottom = mmrt.top _xZkqqHx_iCmMiPoKiNiHiCpAiNgMjHlGiClFiCmEiPoDiJlKiCmJiNeMiClAiCmEiCkIiCkNiBeC_xHqqkZx_
			const DBLShortLine mmslRight(mmrt.right, mmrt.top - 10.0, mmrt.right, mmrt.bottom + 10.0);
			if (mmslRight.CrossPoint(mmptQ, mmsl))
			{
				mmptP[iC++] = mmptQ;
				if (iC == 2) break;
			}
		} else
		if (almosteq(mmsl.pt0.x, mmsl.pt1.x))
		//----- mmsl_xZkqqHx_iCkKjAiCjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (almostless(mmsl.pt0.x, mmrt.left) || almostless(mmrt.right, mmsl.pt0.x))
				return FALSE;
			if (almostlesseq(mmrt.top, mmsl.pt0.y) && almostlesseq(mmsl.pt0.y, mmrt.bottom))
				mmptP[iC++] = mmsl.pt0;
			if (almostlesseq(mmrt.top, mmsl.pt1.y) && almostlesseq(mmsl.pt1.y, mmrt.bottom))
				mmptP[iC++] = mmsl.pt1;
			if (iC == 2) break;
			DBLPoint mmptQ;
			// mmrt.right = mmrt.left _xZkqqHx_iCmMiPoKiNiHiCpAiNgMjHlGiClFiCmEiPoDiJlKiCmJiNeMiClAiCmEiCkIiCkNiBeC_xHqqkZx_
			const DBLShortLine mmslTop(mmrt.left - 10.0, mmrt.top, mmrt.right + 10.0, mmrt.top);
			if (mmslTop.CrossPoint(mmptQ, mmsl))
			{
				mmptP[iC++] = mmptQ;
				if (iC == 2) break;
			}
			// mmrt.right = mmrt.left _xZkqqHx_iCmMiPoKiNiHiCpAiNgMjHlGiClFiCmEiPoDiJlKiCmJiNeMiClAiCmEiCkIiCkNiBeC_xHqqkZx_
			const DBLShortLine mmslBottom(mmrt.left - 10.0, mmrt.bottom, mmrt.right + 10.0, mmrt.bottom);
			if (mmslBottom.CrossPoint(mmptQ, mmsl))
			{
				mmptP[iC++] = mmptQ;
				if (iC == 2) break;
			}
		} else
		{
			// mmrt_xZkqqHx_iCmMiPoDiJlKiNlGiJeFiCmMjFnDiCmMjApMjFkKiCpAiNoMjAkMiClFiBeBiClLiCoKiCmG_xHqqkZx_mmsl_xZkqqHx_iCkKiMpAiNlHiClHiCoJjDfPiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			if (mmrt.PtInRect(mmsl.pt0))
				mmptP[iC++] = mmsl.pt0;
			if (mmrt.PtInRect(mmsl.pt1))
				mmptP[iC++] = mmsl.pt1;
			if (iC == 2) break;
			DBLPoint mmptQ;
			const DBLShortLine mmslTop(mmrt.left, mmrt.top, mmrt.right, mmrt.top);
			if (mmslTop.CrossPoint(mmptQ, mmsl))
			{
				mmptP[iC++] = mmptQ;
				if (iC == 2) break;
			}
			const DBLShortLine mmslRight(mmrt.right, mmrt.top, mmrt.right, mmrt.bottom);
			if (mmslRight.CrossPoint(mmptQ, mmsl))
			{
				mmptP[iC++] = mmptQ;
				if (iC == 2) break;
			}
			const DBLShortLine mmslBottom(mmrt.right, mmrt.bottom, mmrt.left, mmrt.bottom);
			if (mmslBottom.CrossPoint(mmptQ, mmsl))
			{
				mmptP[iC++] = mmptQ;
				if (iC == 2) break;
			}
			const DBLShortLine mmslLeft(mmrt.left, mmrt.bottom, mmrt.left, mmrt.top);
			if (mmslLeft.CrossPoint(mmptQ, mmsl))
			{
				mmptP[iC++] = mmptQ;
				if (iC == 2) break;
			}
		}
		return FALSE;
	}
	mmslIntersect.SetPoints(mmptP[0], mmptP[1]);
	return TRUE;
} // FFGetIntersectLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHashRec::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCPolyHashRec_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrtFrame	:_xZkqqHx_iDhEiDiMiBfLiDiAiCpAiOhHjCoIiBeCiClBiCmMiDhEiDiMiBfLiDiAiCpAjClEiCkGiClNiDhMiDiKiDiJiDeDiDjDiBeB_xHqqkZx_
 *						 _xZkqqHx_iDiGiDgKiDgCiDgHiCmNjGlDiOiLiClDiCoKiCoJiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhEiDiMiBfLiDiAiCmNiPkMiClDiCkCjEmNiImNiCpAiOhHjCoIiClHiCoJjFpLiCkKiBeBiPiIjHjNiCkKjBkMiCkNiCmIiCoJiBeC_xHqqkZx_
 *			mmGridWidth	:_xZkqqHx_iDePiDiKiDgCiDgIjClHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stIndex		:_xZkqqHx_iDgOiDgCiDfGiDiFjBmOiPnLiCmMiDhMiDiKiDiJiDeDiDjDiCmMjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpB_xHqqkZx_ mmptPoint _xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *			mmrtFrame _xZkqqHx_iCmNiBeB_xHqqkZx_left <= x < right_xZkqqHx_iBeB_xHqqkZx_top <= y < bottom _xZkqqHx_iCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCPolyHashRec_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiBeCiDgHiDgCiDhGiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpA_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClHiCoJiBeBiIlNiCkCiCmNiPoDiImKiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCkKiJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClHiCoJiNnLiCmJ_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iPoDiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCkKiJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_mmrtFrame _xZkqqHx_iCmJ_xHqqkZx_
 *			_xZkqqHx_iJlKiImKiDgOiDgCiDfGiDiFiCmMjEmNiImNiBgJjBkOiClHiCoJiPoDiImKiDiGiDgKiDgCiDgHiBgKiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgHiDgCiDhGiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_mmrtFrame_xZkqqHx_iCmN_xHqqkZx_DBL_MAX_xZkqqHx_iCmMiNmFjBoFjEmNiImN_xHqqkZx_
 *			_xZkqqHx_iCpAiOhHjCoIiClFiClNiCoIiBeBjClCiCnHiCoJjFeLjHhGiCkKiCkAiCoJjEmNiImNiCmMiCnNiCpAiOhHjCoIiClFiClNiCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyHashRec* FCPolyHashRec::Create (	const DBLRect& mmrtFrame,
										mmetol mmGridWidth,
										const longSet& stIndex,
										long lPointSize,
										const DBLPoint* mmptPoint)
{
	ASSERT(!stIndex.empty());
	FCPolyHashRec* pHashRec = new FCPolyHashRec();
	// _xZkqqHx_iDePiDiKiDgCiDgIjClHiCpAiOhHjCoIiBeC_xHqqkZx_
	pHashRec->m_mmGridWidth = mmGridWidth;

	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjApMjFkKiCpAiBeBiDhEiDiMiBfLiDiAiCmJjDpMiCoJjClHiClDiCmJiPeDjAlDiClHiCoJiBeC_xHqqkZx_
	map<long, DBLShortLine> mpIndexToLine;
	longSet::const_iterator iIdx;
	for (iIdx = stIndex.begin(); iIdx != stIndex.end(); iIdx++)
	{
		DBLShortLine mmslIntersect;
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (FFGetIntersectLine(mmslIntersect, DBLShortLine(mmptPoint[*iIdx], mmptPoint[*iIdx + 1]), mmrtFrame))
//			mpIndexToLine[*iIdx] = mmslIntersect;
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// 1%_xZkqqHx_iCnJiCmHjApMjFkKiCmMjHlMjCfLiCpAiJiEiCmOiClHiBeCiCkMiCoIiCkMiCoIiCmFiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
		const mmetol mmLen = (mmptPoint[*iIdx] - mmptPoint[*iIdx + 1]).Len();
		DBLPoint mmptNew0 = mmptPoint[*iIdx] + (mmptPoint[*iIdx] - mmptPoint[*iIdx + 1]) * 0.01;
		DBLPoint mmptNew1 = mmptPoint[*iIdx + 1] + (mmptPoint[*iIdx + 1] - mmptPoint[*iIdx]) * 0.01;
		if (FFGetIntersectLine(mmslIntersect, DBLShortLine(mmptNew0, mmptNew1), mmrtFrame))
			mpIndexToLine[*iIdx] = mmslIntersect;
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	map<long, DBLShortLine>::const_iterator iIl;
	for (iIl = mpIndexToLine.begin(); iIl != mpIndexToLine.end(); iIl++)
	{
		// _xZkqqHx_jApMjFkKiCmMjHlMjCfLiCmMjDfPiCkKjBkOiClHiCoJiDiGiDgKiDgCiDgHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		DBLPoint mmptUnitFrame0;
		DBLPoint mmptUnitFrame1;
		GetBelongUnitFrame(mmptUnitFrame0, mmGridWidth, (*iIl).second.pt0);
		GetBelongUnitFrame(mmptUnitFrame1, mmGridWidth, (*iIl).second.pt1);
		// _xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFkKjBfDjBmMiCkKjBkOiClHiCoJjBfDiDiGiDgKiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
		set<DBLPoint> stUnitFrame;
		GetIntersectUnitFrame(	stUnitFrame,
								mmGridWidth,
								(*iIl).second,
								mmptUnitFrame0,
								mmptUnitFrame1);
		set<DBLPoint>::const_iterator iPt;
		for (iPt = stUnitFrame.begin(); iPt != stUnitFrame.end(); iPt++)
		{
			// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJiOpLiCnMiCmBiCmEiCkCiCoJiDiGiDgKiDgCiDgHiCmMiCnNjCmHiJmBiClHiCoJiBeC_xHqqkZx_
			// _xZkqqHx_jApMjFkKiCmMjHlMjCfLiCmNiPoDiCmFiCfAiBjDjAeMiCmOiClFiCmEiCkAiCoJiCmMiCmFiBeBiDiGiDgKiDgCiDgHiCkKiDhEiDiMiBfLiDiAiCmJ_xHqqkZx_
			// _xZkqqHx_iOpLiCnMiCoJiCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
			// right_xZkqqHx_iCmG_xHqqkZx_bottom _xZkqqHx_iCmN_xHqqkZx_ almostless _xZkqqHx_iCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
			if (almostlesseq(mmrtFrame.left, (*iPt).x) &&
				almostlesseq(mmrtFrame.top, (*iPt).y) &&
				almostless((*iPt).x, mmrtFrame.right) &&
				almostless((*iPt).y, mmrtFrame.bottom))
				pHashRec->m_mpUnitToLineIndex[*iPt].insert((*iIl).first);
//----- 05.08.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			ASSERT(	almostlesseq(mmrtFrame.left, (*iPt).x) &&
//					almostlesseq(mmrtFrame.top, (*iPt).y) &&
//					almostlesseq((*iPt).x, mmrtFrame.right) &&
//					almostlesseq((*iPt).y, mmrtFrame.bottom));
//----- 05.08.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		}
	}
	return pHashRec;
} // FCPolyHashRec::Create.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHashRec::GetBelongUnitFrameX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhMiDeDiDjDiDgHiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiCkKjBkOiClHiCoJiDiGiDgKiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmUnitX			:_xZkqqHx_iDiGiDgKiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmGridWidth		:_xZkqqHx_iDePiDiKiDgCiDgIjClHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmX				:_xZkqqHx_jBmOiPnLiCmMiDhMiDeDiDjDiDgHiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBjDfP_xHqqkZx_P_xZkqqHx_iCmMiDiGiDgKiDgCiDgHiCmNiBeB_xHqqkZx_x3_xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *
 *          x0    x1    x2    x3    x4    x5
 *        y0_xZkqqHx_iEkBiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y1_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y2_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_ P_xZkqqHx_iBeFiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y3_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y4_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y5_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyHashRec::GetBelongUnitFrameX (mmetol& mmUnitX, mmetol mmGridWidth, const mmetol mmX)
{
	// mmX / mmGridWidth = A _xZkqqHx_iCmGiClHiCoJiBeC_xHqqkZx_
	// A = -23.0000_xZkqqHx_iBgD_xHqqkZx_1 _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_dInt = -23.0, dMod = -0.0000_xZkqqHx_iBgD_xHqqkZx_1 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = -23.0 _xZkqqHx_iCmMiCnMiCnMiCmFjAlDiClFiCkCiBeC_xHqqkZx_
	// A = 23.0000_xZkqqHx_iBgD_xHqqkZx_1 _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_dInt = 23.0, dMod = 0.0000_xZkqqHx_iBgD_xHqqkZx_1 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = 23.0 _xZkqqHx_iCmMiCnMiCnMiCmFjAlDiClFiCkCiBeC_xHqqkZx_
	// A = 22.5_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_dInt = 22.0, dMod = 0.5 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = 22.0 _xZkqqHx_iCmMiCnMiCnMiCmFjAlDiClFiCkCiBeC_xHqqkZx_
	// A = -22.5_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_dInt = -22.0, dMod = -0.5 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = -23.0 _xZkqqHx_iCmJjFoCjAlDiCkKjFeLjHhGiBeC_xHqqkZx_
	// A = -22.99999_xZkqqHx_iBgDiCmMiPoKiNiHiBeB_xHqqkZx_dInt = -22.0, dMod = -0.99999_xZkqqHx_iBgD_xHqqkZx_ _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = -23.0 _xZkqqHx_iCmJjFoCjAlDiCkKjFeLjHhGiBeC_xHqqkZx_
	// A = 22.99999_xZkqqHx_iBgDiCmMiPoKiNiHiBeB_xHqqkZx_dInt = 22.0, dMod = 0.99999_xZkqqHx_iBgD_xHqqkZx_ _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = 23.0 _xZkqqHx_iCmJjFoCjAlDiCkKjFeLjHhGiBeC_xHqqkZx_
	if (mmGridWidth < 1.0)
	//----- _xZkqqHx_iDePiDiKiDgCiDgIjClHiCkK_xHqqkZx_0.1_xZkqqHx_iImIiJlKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// mmX_xZkqqHx_iCkKiLjAjBoFiCmIjCgMiCmMiPoKiNiHiBeB_xHqqkZx_mmX / mmGridWidth _xZkqqHx_iCkK_xHqqkZx_
		// _xZkqqHx_iDeJiBfLiDgPiBfLiDhEiDiNiBfLiClHiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCoKiCpAjGgIiCkOiClNiCnPiCmJiBeBiPkMjAjEjDfPiImIiJlKiCmMiCnNiCpA_xHqqkZx_
		// _xZkqqHx_jFmKiCmJiPiIjHjNiClHiCoJiBeC_xHqqkZx_
		double dOver;
		double dUnder = modf(mmX, &dOver);
		ASSERT(almosteq(dOver + dUnder, mmX));
		double dInt;
		double dMod = modf(dUnder / mmGridWidth, &dInt);
		if (almostless(dMod, 0.0))
			dInt -= 1.0;
		else
		if (almosteq(dMod, 1.0))
			dInt += 1.0;
		mmUnitX = dOver + mmGridWidth * dInt;
	} else
	//----- _xZkqqHx_iDePiDiKiDgCiDgIjClHiCkK_xHqqkZx_1_xZkqqHx_iImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		double dInt;
		double dMod = modf(mmX / mmGridWidth, &dInt);
		if (almostless(dMod, 0.0))
			dInt -= 1.0;
		else
		if (almosteq(dMod, 1.0))
			dInt += 1.0;
		mmUnitX = mmGridWidth * dInt;
	}
//	ASSERT(almostlesseq(mmUnitX, mmX) && almostlesseq(mmX, mmUnitX + mmGridWidth));
} // FCPolyHashRec::GetBelongUnitFrameX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHashRec::GetBelongUnitFrameY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhMiDeDiDjDiDgHiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCkKjBkOiClHiCoJiDiGiDgKiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmUnitY			:_xZkqqHx_iDiGiDgKiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmGridWidth		:_xZkqqHx_iDePiDiKiDgCiDgIjClHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmY				:_xZkqqHx_jBmOiPnLiCmMiDhMiDeDiDjDiDgHiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBjDfP_xHqqkZx_P_xZkqqHx_iCmMiDiGiDgKiDgCiDgHiCmNiBeB_xHqqkZx_y2_xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *
 *          x0    x1    x2    x3    x4    x5
 *        y0_xZkqqHx_iEkBiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y1_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y2_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_ P_xZkqqHx_iBeFiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y3_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y4_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y5_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyHashRec::GetBelongUnitFrameY (mmetol& mmUnitY, mmetol mmGridWidth, const mmetol mmY)
{
	// mmY / mmGridWidth = A _xZkqqHx_iCmGiClHiCoJiBeC_xHqqkZx_
	// A = -23.0000_xZkqqHx_iBgD_xHqqkZx_1 _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_dInt = -23.0, dMod = -0.0000_xZkqqHx_iBgD_xHqqkZx_1 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = -23.0 _xZkqqHx_iCmMiCnMiCnMiCmFjAlDiClFiCkCiBeC_xHqqkZx_
	// A = 23.0000_xZkqqHx_iBgD_xHqqkZx_1 _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_dInt = 23.0, dMod = 0.0000_xZkqqHx_iBgD_xHqqkZx_1 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = 23.0 _xZkqqHx_iCmMiCnMiCnMiCmFjAlDiClFiCkCiBeC_xHqqkZx_
	// A = 22.5_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_dInt = 22.0, dMod = 0.5 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = 22.0 _xZkqqHx_iCmMiCnMiCnMiCmFjAlDiClFiCkCiBeC_xHqqkZx_
	// A = -22.5_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_dInt = -22.0, dMod = -0.5 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = -23.0 _xZkqqHx_iCmJjFoCjAlDiCkKjFeLjHhGiBeC_xHqqkZx_
	// A = -22.99999_xZkqqHx_iBgDiCmMiPoKiNiHiBeB_xHqqkZx_dInt = -22.0, dMod = -0.99999_xZkqqHx_iBgD_xHqqkZx_ _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = -23.0 _xZkqqHx_iCmJjFoCjAlDiCkKjFeLjHhGiBeC_xHqqkZx_
	// A = 22.99999_xZkqqHx_iBgDiCmMiPoKiNiHiBeB_xHqqkZx_dInt = 22.0, dMod = 0.99999_xZkqqHx_iBgD_xHqqkZx_ _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiCmN_xHqqkZx_ dInt = 23.0 _xZkqqHx_iCmJjFoCjAlDiCkKjFeLjHhGiBeC_xHqqkZx_
	if (mmGridWidth < 1.0)
	//----- _xZkqqHx_iDePiDiKiDgCiDgIjClHiCkK_xHqqkZx_0.1_xZkqqHx_iImIiJlKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// mmY_xZkqqHx_iCkKiLjAjBoFiCmIjCgMiCmMiPoKiNiHiBeB_xHqqkZx_mmY / mmGridWidth _xZkqqHx_iCkK_xHqqkZx_
		// _xZkqqHx_iDeJiBfLiDgPiBfLiDhEiDiNiBfLiClHiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCoKiCpAjGgIiCkOiClNiCnPiCmJiBeBiPkMjAjEjDfPiImIiJlKiCmMiCnNiCpA_xHqqkZx_
		// _xZkqqHx_jFmKiCmJiPiIjHjNiClHiCoJiBeC_xHqqkZx_
		double dOver;
		double dUnder = modf(mmY, &dOver);
		ASSERT(almosteq(dOver + dUnder, mmY));
		double dInt;
		double dMod = modf(dUnder / mmGridWidth, &dInt);
		if (almostless(dMod, 0.0))
			dInt -= 1.0;
		else
		if (almosteq(dMod, 1.0))
			dInt += 1.0;
		mmUnitY = dOver + mmGridWidth * dInt;
	} else
	//----- _xZkqqHx_iDePiDiKiDgCiDgIjClHiCkK_xHqqkZx_1_xZkqqHx_iImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		double dInt;
		double dMod = modf(mmY / mmGridWidth, &dInt);
		if (almostless(dMod, 0.0))
			dInt -= 1.0;
		else
		if (almosteq(dMod, 1.0))
			dInt += 1.0;
		mmUnitY = mmGridWidth * dInt;
	}
//	ASSERT(almostlesseq(mmUnitY, mmY) && almostlesseq(mmY, mmUnitY + mmGridWidth));
} // FCPolyHashRec::GetBelongUnitFrameY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHashRec::GetBelongUnitFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhMiDeDiDjDiDgHiCkKjBkOiClHiCoJiDiGiDgKiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptUnitFrame	:_xZkqqHx_iDiGiDgKiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmGridWidth		:_xZkqqHx_iDePiDiKiDgCiDgIjClHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP			:_xZkqqHx_jBmOiPnLiCmMiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBjDfP_xHqqkZx_P_xZkqqHx_iCmMiDiGiDgKiDgCiDgHiCmNiBeB_xHqqkZx_(x3,y2)_xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiGiDgKiDgCiDgHiCmMjFjNiBeBiNiCiClDiCmN_xHqqkZx_mmGridWidth_xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 *          x0    x1    x2    x3    x4    x5
 *        y0_xZkqqHx_iEkBiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y1_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y2_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_ P_xZkqqHx_iBeFiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y3_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y4_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y5_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyHashRec::GetBelongUnitFrame (DBLPoint& mmptUnitFrame, mmetol mmGridWidth, const DBLPoint& mmptP)
{
	GetBelongUnitFrameX(mmptUnitFrame.x, mmGridWidth, mmptP.x);
	GetBelongUnitFrameY(mmptUnitFrame.y, mmGridWidth, mmptP.y);
} // FCPolyHashRec::GetBelongUnitFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHashRec::GetIntersectUnitFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjApMjFkKiCkKjBkOiClHiCoJjBfDiDiGiDgKiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vUnitFrame		:_xZkqqHx_iDiGiDgKiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmGridWidth		:_xZkqqHx_iDePiDiKiDgCiDgIjClHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpsl			:_xZkqqHx_jBmOiPnLiCmMjApMjFkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptUnitFirst	:_xZkqqHx_jApMjFkKiCmMiOgOjDfPiCkKjBkOiClHiCoJiDiGiDgKiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptUnitLast	:_xZkqqHx_jApMjFkKiCmMiPeJjDfPiCkKjBkOiClHiCoJiDiGiDgKiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBjApMjFkKiCkKjBkOiClHiCoJiDiGiDgKiDgCiDgHiCmNiBeB_xHqqkZx_(x1,y1)(x2,y2)(x2,y3)(x3,y3)(x3,y4)
 *			_xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 *          x0    x1    x2    x3    x4    x5
 *        y0_xZkqqHx_iEkBiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkGiEjPiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y1_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBfPiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y2_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiBfPiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkAiBfP_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y3_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiBfPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y4_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiBfPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y5_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyHashRec::GetIntersectUnitFrame (	set<DBLPoint>& stUnitFrame,
											mmetol mmGridWidth,
											const DBLShortLine& mmsl,
											DBLPoint mmptUnitFirst,
											DBLPoint mmptUnitLast)
{
	// Y_xZkqqHx_jFpLiMpMiCmJiBeBjApMjFkKiCpAiDiGiDgKiDgCiDgHjCfAiImKiCmFjFkKjCgGiClFiBeB_xHqqkZx_
	// _xZkqqHx_iKgFiDiGiDgKiDgCiDgHiNhDiCmMiPoDjCfLiCmGiJlKjCfLiCmFiBeB_xHqqkZx_X_xZkqqHx_jFpLiMpMiCmJ_xHqqkZx_
	// _xZkqqHx_iCmHiCmMiDiGiDgKiDgCiDgHiCmJjBkOiClHiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_

	if (mmptUnitLast.y < mmptUnitFirst.y)
		Exchange(mmptUnitFirst, mmptUnitLast);
	// _xZkqqHx_iDiGiDgKiDgCiDgHiNhDiCmJiCkIiCkPiCoJiBeBiPoDjCfLiCmM_xHqqkZx_X_xZkqqHx_jFpLiMpMiDiGiDgKiDgCiDgHiBeC_xHqqkZx_
	mmetol mmTopUnitX = mmptUnitFirst.x;
	if (mmptUnitFirst.y != mmptUnitLast.y)
	//----- Y_xZkqqHx_jFpLiMpMiCmMiOgOjDfPiBeFiPeJjDfPiDiGiDgKiDgCiDgHiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// Y_xZkqqHx_jFpLiMpMiCmJiBeBiDiGiDgKiDgCiDgHjCfAiImKiCmFjFkKjCgGiClHiCoJiBeC_xHqqkZx_
		DBLLine mmln(mmsl.pt0, mmsl.pt1);
		for (mmetol mmTopUnitY = mmptUnitFirst.y;
			 !almosteq(mmTopUnitY, mmptUnitLast.y);
			 mmTopUnitY += mmGridWidth)
		{
			mmetol mmBottomX = mmln.GetX(mmTopUnitY + mmGridWidth);
			// _xZkqqHx_iDiGiDgKiDgCiDgHiNhDiCmJiCkIiCkPiCoJiBeBiJlKjCfLiCmM_xHqqkZx_X_xZkqqHx_jFpLiMpMiDiGiDgKiDgCiDgHiBeC_xHqqkZx_
			mmetol mmBottomUnitX;
			GetBelongUnitFrameX(mmBottomUnitX, mmGridWidth, mmBottomX);
			// mmTopUnitX < mmBottomUnitX _xZkqqHx_iCmGiCmIiCoJiCoGiCkEjFmAiCnHjBnGiCkGiCoJiBeC_xHqqkZx_
			if (mmBottomUnitX < mmTopUnitX)
				Exchange(mmTopUnitX, mmBottomUnitX);
			// _xZkqqHx_iDiGiDgKiDgCiDgHiNhDiCmJiCkIiCkPiCoJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiCmMiDiGiDgKiDgCiDgHjEmNiImNiCpAjBfDiCmEiDhBiDgCiDgHjBmOiPnLiCmGiClFiCmEjCmHiJmBiClHiCoJiBeC_xHqqkZx_
			for (mmetol mmUnitX = mmTopUnitX; almostlesseq(mmUnitX, mmBottomUnitX); mmUnitX += mmGridWidth)
				stUnitFrame.insert(DBLPoint(mmUnitX, mmTopUnitY));
			mmTopUnitX = mmBottomUnitX;
		}
	}
	// _xZkqqHx_iNmFiPeJiCmMiDiGiDgKiDgCiDgHiNhDiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	mmetol mmBottomUnitX = mmptUnitLast.x;
	// mmTopUnitX < mmBottomUnitX _xZkqqHx_iCmGiCmIiCoJiCoGiCkEjFmAiCnHjBnGiCkGiCoJiBeC_xHqqkZx_
	if (mmBottomUnitX < mmTopUnitX)
		Exchange(mmTopUnitX, mmBottomUnitX);
	// _xZkqqHx_iDiGiDgKiDgCiDgHiNhDiCmJiCkIiCkPiCoJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiCmMiDiGiDgKiDgCiDgHjEmNiImNiCpAjBfDiCmEiDhBiDgCiDgHjBmOiPnLiCmGiClFiCmEjCmHiJmBiClHiCoJiBeC_xHqqkZx_
	for (mmetol mmUnitX = mmTopUnitX; almostlesseq(mmUnitX, mmBottomUnitX); mmUnitX += mmGridWidth)
		stUnitFrame.insert(DBLPoint(mmUnitX, mmptUnitLast.y));
} // FCPolyHashRec::GetIntersectUnitFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHashRec::GetWillIntersectPolySet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpBiCmCiCmMiDhMiDiKiDiJiDeDiDjDiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAjEoEiKhCiClFiBeBiMpAiNlHiClFiCmEiCkCiCoJiJmCjEfMjAkLiCkKiCkAiCoJ_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDhJiDeBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stIndexIndex	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDhJiDeBiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jHhGjBgGiCmM_xHqqkZx_first_xZkqqHx_iCmN_xHqqkZx_mmptPoint0_xZkqqHx_iBeB_xHqqkZx_second_xZkqqHx_iCmN_xHqqkZx_mmptPoint1_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_jApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *			pHashRec0		:mmptPoint0_xZkqqHx_iCmMiDhMiDiKiDiJiDeDiDjDiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHashRec1		:mmptPoint1_xZkqqHx_iCmMiDhMiDiKiDiJiDeDiDjDiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize0		:mmptPoint0_xZkqqHx_iCmMjEhKjHpBjHhGjBgGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint0		:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize1		:mmptPoint1_xZkqqHx_iCmMjEhKjHpBjHhGjBgGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint1		:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBiDhMiDiKiDiJiDeDiDjD_xHqqkZx_L1_xZkqqHx_iCmG_xHqqkZx_L2_xZkqqHx_iCmNiBeBiDiGiDgKiDgCiDgH_xHqqkZx_(X1,Y1)_xZkqqHx_iCmG_xHqqkZx_
 *			(X3,Y1)_xZkqqHx_iCmFjDkPiClGiDiGiDgKiDgCiDgHiCmJjBkOiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDiGiDgKiDgCiDgHiCmN_xHqqkZx_(X1,Y1)_xZkqqHx_iCmG_xHqqkZx_(X3,Y1)_xZkqqHx_iCkKiMpAiNlHiJmCjEfMjAkLiCkAiCoIiCmG_xHqqkZx_
 *			_xZkqqHx_jElLjCgGiClDiCoKiBeBiClBiCmMiDiGiDgKiDgCiDgHiCmJjBkOiClHiCoJiDhMiDiKiDiJiDeDiDjDjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCmM_xHqqkZx_
 *			_xZkqqHx_iDhJiDeBiCkKjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiBeB_xHqqkZx_L1_xZkqqHx_iCmM_xHqqkZx_index=[3,4]_xZkqqHx_iBeB_xHqqkZx_L2_xZkqqHx_iCmM_xHqqkZx_index=[5]_xZkqqHx_iCkK_xHqqkZx_(X1,Y1)_xZkqqHx_iCmJjBkOiClFiBeB_xHqqkZx_
 *			L1_xZkqqHx_iCmM_xHqqkZx_index=[7]_xZkqqHx_iBeB_xHqqkZx_L2_xZkqqHx_iCmM_xHqqkZx_index=[8]_xZkqqHx_iCkK_xHqqkZx_(X3,Y1)_xZkqqHx_iCmJjBkOiClHiCoJiPoKiNiHiBeB_xHqqkZx_
 *			(3,5)(4,5)(7,8)_xZkqqHx_iCmMiCfCiDhJiDeBiCkKiMpAiNlHiJmCjEfMjAkLiCmGiClFiCmEjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *               _xZkqqHx_iBfP_xHqqkZx_  X1        X2    _xZkqqHx_iBfO_xHqqkZx_  X3    _xZkqqHx_iEkA_xHqqkZx_  X4
 *               L1_xZkqqHx_iBfPiBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBfO_xHqqkZx_L2  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                   _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBeGiBfO_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          Y1 _xZkqqHx_iBgDiBgDiBgDiEkJiBfPiBgDiBgDiBgDiBfOiBgDiBgDiBgDiBgDiEkJiBgDiBgDiEkAiBgDiEkJiBgDiBgD_xHqqkZx_
 *                   _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBfP_xHqqkZx_  _xZkqqHx_iBfOiBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iBfOiBfB_xHqqkZx___xZkqqHx_iBfBiBfBiBfB_xHqqkZx_
 *                   _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBhO_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iBfOiBfO_xHqqkZx_   _xZkqqHx_iBeG_xHqqkZx_
 *                   _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBfO_xHqqkZx_  _xZkqqHx_iBfPiBeG_xHqqkZx_         _xZkqqHx_iBfO_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *          Y2 _xZkqqHx_iBgDiBgDiBgDiEkJiBfOiBgDiBgDiBgDiBfPiBgDiBgDiBgD_xHqqkZx_ _xZkqqHx_iBfO_xHqqkZx_ _xZkqqHx_iBgDiEkAiBgDiBgDiEkJiBgDiBgD_xHqqkZx_
 *                   _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBeGiBfPiBfB_xHqqkZx___xZkqqHx_iBfO_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *                 _xZkqqHx_iBfOiBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *          Y3 _xZkqqHx_iBgDiBeFiEkAiBeFiEkJiBgDiBgDiBgDiBgDiEkJiBgDiBgDiBgDiBgDiEkJiBgDiEkAiBgDiBgDiEkJiBgDiBgD_xHqqkZx_
 *                _xZkqqHx_iEkEiEjPiEjPiEjP_xHqqkZx_-_xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *                   _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *                   _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyHashRec::GetWillIntersectPolySet (	set< pair<long, long> >& stIndexIndex,
												FCPolyHashRec* pHashRec0,
												FCPolyHashRec* pHashRec1,
												long lPointSize0,
												const DBLPoint* mmptPoint0,
												long lPointSize1,
												const DBLPoint* mmptPoint1)
{
	// _xZkqqHx_iDePiDiKiDgCiDgIjClHiCmNjDkPiClGiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	ASSERT(almosteq(pHashRec0->m_mmGridWidth, pHashRec1->m_mmGridWidth));

	map<DBLPoint, longSet>::iterator iRec0;
	map<DBLPoint, longSet>::iterator iRec1;
	iRec0 = pHashRec0->m_mpUnitToLineIndex.begin();
	iRec1 = pHashRec1->m_mpUnitToLineIndex.begin();
	for (;;)
	{
		// _xZkqqHx_jEoEiKhCiClHiCoJiDiGiDgKiDgCiDgHiCkKjGlDiCkNiCmIiCoKiCmOiPeJjHlJiBeC_xHqqkZx_
		if (iRec0 == pHashRec0->m_mpUnitToLineIndex.end()) break;
		if (iRec1 == pHashRec1->m_mpUnitToLineIndex.end()) break;

		if ((*iRec0).first < (*iRec1).first)
		//----- _xZkqqHx_iDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_0_xZkqqHx_iCmMiDiGiDgKiDgCiDgHiCkKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_1_xZkqqHx_iCmMiDiGiDgKiDgCiDgHiCoGiCoIiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			iRec0++;
		} else
		if ((*iRec1).first < (*iRec0).first)
		//----- _xZkqqHx_iDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_1_xZkqqHx_iCmMiDiGiDgKiDgCiDgHiCkKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_0_xZkqqHx_iCmMiDiGiDgKiDgCiDgHiCoGiCoIiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			iRec1++;
		} else
		//----- _xZkqqHx_iDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_0_xZkqqHx_iCmMiDiGiDgKiDgCiDgHiCmGiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_1_xZkqqHx_iCmMiDiGiDgKiDgCiDgHiCkKjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
		{
			if (FD_POLY_HASH_ITEM_MAX < (*iRec0).second.size() * (*iRec1).second.size())
			//----- _xZkqqHx_iDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_0_xZkqqHx_iCmMjApMjFkKjAjEiBhOiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_1_xZkqqHx_iCmMjApMjFkKjAjEiCkKiKoOiPiAjCgMiCpAjClEiCkGiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_0_xZkqqHx_iBeBiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_1_xZkqqHx_iClLiCoKiClMiCoKiCmJiBeB_xHqqkZx_1/10_xZkqqHx_iCmMiDePiDiKiDgCiDgIjClHiCmMiJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
				FCPolyHashRec* pSubRec0 = pHashRec0->CreateSubHash((*iRec0).first, lPointSize0, mmptPoint0);
				FCPolyHashRec* pSubRec1 = pHashRec1->CreateSubHash((*iRec1).first, lPointSize1, mmptPoint1);
				// 1/10_xZkqqHx_iCmMiJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCmFiNfIiCmJjEoEiKhCiClHiCoJiBeC_xHqqkZx_
				GetWillIntersectPolySet(stIndexIndex, pSubRec0, pSubRec1, lPointSize0, mmptPoint0, lPointSize1, mmptPoint1);
			} else
			//----- _xZkqqHx_iDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_0_xZkqqHx_iCmMjApMjFkKjAjEiBhOiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_1_xZkqqHx_iCmMjApMjFkKjAjEiCkKiKoOiPiAjCgMiCpAiJlKiJpBiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jDkPiClGiDiGiDgKiDgCiDgHiCmJjBkOiClHiCoJiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_0_xZkqqHx_iBeBiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgI_xHqqkZx_1_xZkqqHx_iCmMjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCpA_xHqqkZx_
				// _xZkqqHx_jBiNjDjGiCoIiCmFiMpAiNlHiJmCjEfMjAkLiDhJiDeBjDgPjIfOiBeC_xHqqkZx_
				longSet::iterator iIdx0;
				longSet::iterator iIdx1;
				for (iIdx0 = (*iRec0).second.begin(); iIdx0 != (*iRec0).second.end(); iIdx0++)
					for (iIdx1 = (*iRec1).second.begin(); iIdx1 != (*iRec1).second.end(); iIdx1++)
						stIndexIndex.insert(pair<long, long>(*iIdx0, *iIdx1));
			}
			iRec0++;
			iRec1++;
		}
	}
} // FCPolyHashRec::GetWillIntersectPolySet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHashRec::~FCPolyHashRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyHashRec::~FCPolyHashRec ()
{
	// _xZkqqHx_iJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAjBfDiCmEiNoNiPjMiBeC_xHqqkZx_
	map<DBLPoint, FCPolyHashRec*>::iterator iHash;
	for (iHash = m_mpSubHash.begin(); iHash != m_mpSubHash.end(); iHash++)
		delete (*iHash).second;
	m_mpSubHash.clear();
} // FCPolyHashRec::~FCPolyHashRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHashRec::CreateSubHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiDgKiDgCiDgHiCmMiJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptUnit	:_xZkqqHx_iJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClHiCoJiDiGiDgKiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iClBiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClDiCoKiClNiJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClDiCoKiClNiJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCmNiBeBjCgMiCpAjFnEiClHjBePiCmJjDoAjFjEiCmJiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyHashRec* FCPolyHashRec::CreateSubHash (const DBLPoint& mmptUnit, long lPointSize, const DBLPoint* mmptPoint)
{
	// _xZkqqHx_iJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCkKiKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	map<DBLPoint, FCPolyHashRec*>::iterator iHash = m_mpSubHash.find(mmptUnit);
	// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
	if (iHash != m_mpSubHash.end()) return (*iHash).second;
	// _xZkqqHx_iDiGiDgKiDgCiDgHjEmNiImNiCmMiDhEiDiMiBfLiDiAiCpAiNoMjAkMiBeC_xHqqkZx_
	DBLRect mmrtFrame(mmptUnit.x, mmptUnit.y, mmptUnit.x + m_mmGridWidth, mmptUnit.y + m_mmGridWidth);
	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiDgKiDgCiDgHiCmJjBkOiClHiCoJjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCpAiMjPiNpFiBeC_xHqqkZx_
	map<DBLPoint, longSet>::iterator iUix = m_mpUnitToLineIndex.find(mmptUnit);
	ASSERT(iUix != m_mpUnitToLineIndex.end());
	ASSERT(!(*iUix).second.empty());
	// _xZkqqHx_iDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
	FCPolyHashRec* pSubHashRec = Create(mmrtFrame, m_mmGridWidth / 10.0, (*iUix).second, lPointSize, mmptPoint);
	// _xZkqqHx_iNoMjAkMiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
	m_mpSubHash[mmptUnit] = pSubHashRec;
	return pSubHashRec;
} // FCPolyHashRec::CreateSubHash.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHash::FCPolyHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyHash::FCPolyHash ()
			:m_pTopHash(NULL)
{
} // FCPolyHash::FCPolyHash.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHash::FCPolyHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNoMjAkMiClHiCoJiDhMiDiKiDiJiDeDiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtFrameMax:_xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNoMjAkMiClHiCoJjEmNiImNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiPiJiKpKiJlLiCpAiNhDiCkCiBeBiDgOiDgCiDfGiDiFiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyHash::FCPolyHash (long lPointSize, const DBLPoint* mmptPoint, const DBLRect& mmrtFrameMax)
			:m_pTopHash(NULL)
{
	Initialize(lPointSize, mmptPoint, mmrtFrameMax);
} // FCPolyHash::FCPolyHash.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHash::~FCPolyHash
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPolyHash::~FCPolyHash ()
{
	if (m_pTopHash != NULL)
	//----- _xZkqqHx_iDgOiDgCiDfGiDiFiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNoNiPjMiBeC_xHqqkZx_
		delete m_pTopHash;
		m_pTopHash = NULL;
	}
} // FCPolyHash::~FCPolyHash.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHash::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmJiCoGiCmBiCmEiDgOiDgCiDfGiDiFiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNoMjAkMiClHiCoJiDhMiDiKiDiJiDeDiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtFrameMax:_xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNoMjAkMiClHiCoJjEmNiImNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmfrFrameMax=(x0,y0,x4,y4)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBiJlKjAhNiCmMiCoGiCkEiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiCkEiClP_xHqqkZx_mmfrFrameMax_xZkqqHx_iCmJiOpLiCnMiCoJjEmNiImNiCmMiCnNiCpAiDgOiDgCiDfGiDiFiJlLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNmFiPiJiCmJiNoMjAkMiClDiCoKiCoJiDgOiDgCiDfGiDiFiCmNiJlKjAhNiCmMiCoGiCkEiCmJiKeLjBhHiCpAiOjNiClNiClIiBeBiIoKjBhHiCmMiCnNiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiKiDgCiDgIjClHiCmNiBeBiDhMiDiKiDiJiDeDiDjDiCmG_xHqqkZx_mmrtFrameMax_xZkqqHx_iCkJiCoHjDeLjDjGiCmIjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iBfP_xHqqkZx_
 *                _xZkqqHx_iBfP_xHqqkZx_
 *          x0    x1_xZkqqHx_iBfP_xHqqkZx_  x2    x3    x4
 *        y0_xZkqqHx_iEkBiEjPiEjPiEkGiEjPiBfPiEkGiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y1_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiBfPiEjPiEkJiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBfPiEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        y2_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiBfPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkAiBfP_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *        y3_xZkqqHx_iEkFiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiBfPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBfP_xHqqkZx_
 *        y4_xZkqqHx_iEkEiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkIiEjPiEjPiEkDiBfP_xHqqkZx_
 *                                      _xZkqqHx_iBfP_xHqqkZx_
 *                                        _xZkqqHx_iBfP_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyHash::Initialize (long lPointSize, const DBLPoint* mmptPoint, const DBLRect& mmrtFrameMax)
{
	if (m_pTopHash != NULL)
	//----- _xZkqqHx_iDgOiDgCiDfGiDiFiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAiNoNiPjMiBeC_xHqqkZx_
		delete m_pTopHash;
		m_pTopHash = NULL;
	}
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	m_vPoint.clear();
	m_vPoint.insert(m_vPoint.begin(), mmptPoint, mmptPoint + lPointSize);
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjEmNiImNiCpAiMhGiOfKiBeC_xHqqkZx_
	FFCalcFrame(m_mmrtFrame, lPointSize, mmptPoint);
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEmNiImNiCpAiBeB_xHqqkZx_mmrtFrameMax_xZkqqHx_iCpAjClEiCkGiCmIiCkCiCoGiCkEjAkHiMmAiClHiCoJiBeC_xHqqkZx_
	m_mmrtFrame &= mmrtFrameMax;

	// _xZkqqHx_iDhEiDiMiBfLiDiAiCkKiLpDiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (almost0(m_mmrtFrame.Width()) && almost0(m_mmrtFrame.Height()))
		return;

	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEmNiImNiCmMiCkEiClPiBeBiNiCiClDiCmGjFjNiCmFjBoFiCkLiCkCjCgMiCpAiCmGiCoJiBeC_xHqqkZx_
	mmetol mmWidth = (m_mmrtFrame.Width() < m_mmrtFrame.Height()) ? m_mmrtFrame.Height() : m_mmrtFrame.Width();
	//
	// _xZkqqHx_iDePiDiKiDgCiDgIjClHiCmMiOfKiPgPjFpLjGeAiBeC_xHqqkZx_
	//
	// _xZkqqHx_iBgD_xHqqkZx_ 10^5 --- 10^4 --- 10^3 --- 10^2 --- 10^1 --- 10^0 --- 10^-1 --- 10^-2 --- 10^-3 _xZkqqHx_iBgD_xHqqkZx_
	//                   A                                                       B
	//
	// mmWidth _xZkqqHx_iCkKiCmHiClBiCmMjEmNiImNiCmJjDpMiCoJiCkJiCkKjGoCjBoIiBeC_xHqqkZx_A_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_10^3_xZkqqHx_iCkKiDePiDiKiDgCiDgIjClHiBeB_xHqqkZx_B_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_10^-3_xZkqqHx_iCkKiDePiDiKiDgCiDgIjClHiCmGiCmIiCoJiBeC_xHqqkZx_
	//
	double dd = log10(mmWidth);
	// 10^3.5 _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ 10^3_xZkqqHx_iBeB_xHqqkZx_10^-2.5 _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ 10^-3 _xZkqqHx_iCpAiLiBiCnPiClNiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iOhHjAjEjFjEiCpAjAkOjAjEiCmFiDeMiDiDiDfIiDgHiClHiCoJiCmGiBeB_xHqqkZx_3.5_xZkqqHx_iCmN_xHqqkZx_3_xZkqqHx_iCmJiCmIiCoJiCkKiBeB_xHqqkZx_-2.5_xZkqqHx_iCmN_xHqqkZx_-2_xZkqqHx_iCmJiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCoKiCpAjGgIiCkOiCmJiCmNiBeB_xHqqkZx_int(-2.5 + X) - X (X _xZkqqHx_iCmNiBeB_xHqqkZx_|-2.5|_xZkqqHx_iImIiPoDiCmMjAkOjAjE_xHqqkZx_) _xZkqqHx_iCmGiClHiCoKiCmOjHmHiCkCiBeC_xHqqkZx_
	// _xZkqqHx_jHoBiBeG_xHqqkZx_int(-2.5 + 4.0) - 4 -> int(1.5) - 4 -> 1 - 4 -> -3
	// double _xZkqqHx_iCmMiOhHjAjEjFjEiCmN_xHqqkZx_ 10^308_xZkqqHx_iBgA_xHqqkZx_10^-308 _xZkqqHx_iCmIiCmMiCmFiBeB_xHqqkZx_400_xZkqqHx_iCpAiJmBiOfKiClHiCoKiCmOiPfMjFkKiBeC_xHqqkZx_
	int b = int(dd + 400.0) - 400;
	mmetol mmGridWidth = pow(10.0, b);
	// FCPolyHashRec::Create _xZkqqHx_iCmNiBeBiDhMiDiKiDfDiDjDiCmMiDiGiDgKiDgCiDgHiCkK_xHqqkZx_
	// _xZkqqHx_jBfDiCmEiOpLiCnMiCoJiCoGiCkEiBeBiDhMiDiKiDfDiDjDiDhEiDiMiBfLiDiAiCmMiNlGiPoDjCfLiBeBiJeFiJlKjCfLiCmM_xHqqkZx_
	// _xZkqqHx_iDiGiDgKiDgCiDgHiCkKiOpLiCnMiCoJiCoGiCkEiCmIiDhEiDiMiBfLiDiAiCmFjAkHiMmAiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iNlGiPoDjCfLiCkKjBkOiClHiCoJiDiGiDgKiDgCiDgHiCpAiOfKiPgPiBeC_xHqqkZx_
	DBLPoint mmptUnitFrameUL;
	FCPolyHashRec::GetBelongUnitFrame(mmptUnitFrameUL, mmGridWidth, DBLPoint(m_mmrtFrame.left, m_mmrtFrame.top));
	// _xZkqqHx_iJeFiJlKjCfLiCkKjBkOiClHiCoJiDiGiDgKiDgCiDgHiCpAiOfKiPgPiBeC_xHqqkZx_
	DBLPoint mmptUnitFrameRB;
	FCPolyHashRec::GetBelongUnitFrame(mmptUnitFrameRB, mmGridWidth, DBLPoint(m_mmrtFrame.right, m_mmrtFrame.bottom));
	DBLRect mmrtFrame(	mmptUnitFrameUL.x,
						mmptUnitFrameUL.y,
						mmptUnitFrameRB.x + mmGridWidth,
						mmptUnitFrameRB.y + mmGridWidth);
	// _xZkqqHx_jBfDiCmEiCmMjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
	longSet stIndex;
	long lIndex;
	for (lIndex = 0; lIndex != lPointSize - 1; lIndex++)
		stIndex.insert(lIndex);
	// _xZkqqHx_iDgHiDgCiDhGiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiBeC_xHqqkZx_
	m_pTopHash = FCPolyHashRec::Create(	mmrtFrame,
										mmGridWidth,
										stIndex,
										lPointSize,
										mmptPoint);
} // FCPolyHash::Initialize.

class myLess
{
public:
	bool operator () (const DBLPoint& p0, const DBLPoint& p1) const
	{
		return almostless(p0, p1) ? true : false;
	}
}; // class myLess.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHash::GetIntersectPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDpBiCmCiCmMiDgOiDgCiDfGiDiFiCpAiOgHiCmBiCmEiBeBjDpBiCmCiCmMiDhMiDiKiDiJiDeDiDjDiCkKiMpAiNlHiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_jDfPiCpAjBfDiCmEjHpBiLjDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vIntersectPoint	:_xZkqqHx_jDpBiCmCiCmMiDhMiDiKiDiJiDeDiDjDiCkKiMpAiNlHiClHiCoJjDfPiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			polyHash0		:_xZkqqHx_jEoEiKhCiClHiCoJiDgOiDgCiDfGiDiFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			polyHash1		:_xZkqqHx_jEoEiKhCiClHiCoJiDgOiDgCiDfGiDiFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiNlHiClHiCoJjDfPiCkKiIoKiCmCiCmFiCoAiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCPolyHash::GetIntersectPoint (DBLPointVector& vIntersectPoint, FCPolyHash& polyHash0, FCPolyHash& polyHash1)
{
//----- 05.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	vIntersectPoint.clear();
//	// _xZkqqHx_iMpAiNlHiJmCjEfMjAkLiCmMiCkAiCoJjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDhJiDeBiPfHiNiHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	set< pair<long, long> > stIndexIndex;
//	GetWillIntersectPolySet(stIndexIndex, polyHash0, polyHash1);
//	// _xZkqqHx_iDhJiDeBiCmMjApMjFkKiCkKiMpAiNlHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiBeBiIoKiCmCiClIiCmCjClCiCnHiCoJiBeC_xHqqkZx_
//	set< pair<long, long> >::const_iterator iIi;
//	for (iIi = stIndexIndex.begin(); iIi != stIndexIndex.end(); iIi++)
//	{
//		DBLShortLine mmsl1(polyHash0.m_vPoint[(*iIi).first], polyHash0.m_vPoint[(*iIi).first + 1]);
//		DBLShortLine mmsl2(polyHash1.m_vPoint[(*iIi).second], polyHash1.m_vPoint[(*iIi).second + 1]);
//		DBLPoint mmptP;
//		// _xZkqqHx_jDpBiCmCiCmMjApMjFkKiCkKiMpAiNlHiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiCmMiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//		if (mmsl1.CrossPoint(mmptP, mmsl2))
//			vIntersectPoint.push_back(mmptP);
//	}
//	return !vIntersectPoint.empty();
//----- 05.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// DBLShortLine::CrossPoint_xZkqqHx_iCmMiMpAjDfPiMhGiOfKiCmNiMlFjGkHiCmJiCmNiMpAiNlHiClFiCmEiCkCiCmIiCkNiCmEiCoA_xHqqkZx_
	// _xZkqqHx_iMpAiNlHiClFiCmEiCkCiCoJiCmGjElLjCgGiClHiCoJiPoKiNiHiCkKiCkAiCoJiBeCiClBiCmMiClNiCnPiBeBjDkPiClGiMpAjDfPiCkKjHnHiCoIiNiHiCkE_xHqqkZx_
	// _xZkqqHx_jApMjFkKiCmMjHlMjFpLiCmJiPgPiCoJiPoKiNiHiCkKiCkAiCoIiCkGiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iCnMiClNiMpAjDfPiCkKjApMjFkKiCmMjCfLjDfPiPoDiCmJiCkAiCoJiPoKiNiHiCoAjDkPiClGiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCoKiCpAjEhCiPjMiClHiCoJiClNiCnPiBeB_xHqqkZx_set<DBLPoint, myLess>_xZkqqHx_jFmPjAjEiCmFiIoKjDhIjAkOjHjNiClHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iMpAjDfPiDiKiDfIiDgHiBeCiCnJiCnKiIoKjChGiClHiCoJjDfPiCpAjEhCiPjMiBeC_xHqqkZx_
	set<DBLPoint, myLess> stP;
	// _xZkqqHx_iMpAiNlHiJmCjEfMjAkLiCmMiCkAiCoJjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDhJiDeBiPfHiNiHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	set< pair<long, long> > stIndexIndex;
	GetWillIntersectPolySet(stIndexIndex, polyHash0, polyHash1);
	// _xZkqqHx_iDhJiDeBiCmMjApMjFkKiCkKiMpAiNlHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiBeBiIoKiCmCiClIiCmCjClCiCnHiCoJiBeC_xHqqkZx_
	set< pair<long, long> >::const_iterator iIi;
	for (iIi = stIndexIndex.begin(); iIi != stIndexIndex.end(); iIi++)
	{
		DBLShortLine mmsl1(polyHash0.m_vPoint[(*iIi).first], polyHash0.m_vPoint[(*iIi).first + 1]);
		DBLShortLine mmsl2(polyHash1.m_vPoint[(*iIi).second], polyHash1.m_vPoint[(*iIi).second + 1]);
		DBLPoint mmptP;
		// _xZkqqHx_jDpBiCmCiCmMjApMjFkKiCkKiMpAiNlHiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiCmMiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
		if (mmsl1.CrossPoint(mmptP, mmsl2))
			stP.insert(mmptP);
	}
	vIntersectPoint.clear();
	set<DBLPoint, myLess>::const_iterator iP;
	for (iP = stP.begin(); iP != stP.end(); iP++)
		vIntersectPoint.push_back(*iP);
	return !vIntersectPoint.empty();
//----- 05.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCPolyHash::GetIntersectPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHash::GetWillIntersectPolySet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpBiCmCiCmMiDgOiDgCiDfGiDiFiCpAjEoEiKhCiClFiBeBiMpAiNlHiClFiCmEiCkCiCoJiJmCjEfMjAkLiCkKiCkAiCoJ_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDhJiDeBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stIndexIndex	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDhJiDeBiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jHhGjBgGiCmM_xHqqkZx_first_xZkqqHx_iCmN_xHqqkZx_mmptPoint0_xZkqqHx_iBeB_xHqqkZx_second_xZkqqHx_iCmN_xHqqkZx_mmptPoint1_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_jApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *			polyHash0		:_xZkqqHx_jEoEiKhCiClHiCoJiDgOiDgCiDfGiDiFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			polyHash1		:_xZkqqHx_jEoEiKhCiClHiCoJiDgOiDgCiDfGiDiFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBiDhMiDiKiDiJiDeDiDjD_xHqqkZx_L1_xZkqqHx_iCmG_xHqqkZx_L2_xZkqqHx_iCmNiBeBiDiGiDgKiDgCiDgH_xHqqkZx_(X1,Y1)_xZkqqHx_iCmG_xHqqkZx_
 *			(X3,Y1)_xZkqqHx_iCmFjDkPiClGiDiGiDgKiDgCiDgHiCmJjBkOiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDiGiDgKiDgCiDgHiCmN_xHqqkZx_(X1,Y1)_xZkqqHx_iCmG_xHqqkZx_(X3,Y1)_xZkqqHx_iCkKiMpAiNlHiJmCjEfMjAkLiCkAiCoIiCmG_xHqqkZx_
 *			_xZkqqHx_jElLjCgGiClDiCoKiBeBiClBiCmMiDiGiDgKiDgCiDgHiCmJjBkOiClHiCoJiDhMiDiKiDiJiDeDiDjDjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCmM_xHqqkZx_
 *			_xZkqqHx_iDhJiDeBiCkKjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiBeB_xHqqkZx_L1_xZkqqHx_iCmM_xHqqkZx_index=[3,4]_xZkqqHx_iBeB_xHqqkZx_L2_xZkqqHx_iCmM_xHqqkZx_index=[5]_xZkqqHx_iCkK_xHqqkZx_(X1,Y1)_xZkqqHx_iCmJjBkOiClFiBeB_xHqqkZx_
 *			L1_xZkqqHx_iCmM_xHqqkZx_index=[7]_xZkqqHx_iBeB_xHqqkZx_L2_xZkqqHx_iCmM_xHqqkZx_index=[8]_xZkqqHx_iCkK_xHqqkZx_(X3,Y1)_xZkqqHx_iCmJjBkOiClHiCoJiPoKiNiHiBeB_xHqqkZx_
 *			(3,5)(4,5)(7,8)_xZkqqHx_iCmMiCfCiDhJiDeBiCkKiMpAiNlHiJmCjEfMjAkLiCmGiClFiCmEjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *               _xZkqqHx_iBfP_xHqqkZx_  X1        X2    _xZkqqHx_iBfO_xHqqkZx_  X3    _xZkqqHx_iEkA_xHqqkZx_  X4
 *               L1_xZkqqHx_iBfPiBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBfO_xHqqkZx_L2  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                   _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBeGiBfO_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          Y1 _xZkqqHx_iBgDiBgDiBgDiEkJiBfPiBgDiBgDiBgDiBfOiBgDiBgDiBgDiBgDiEkJiBgDiBgDiEkAiBgDiEkJiBgDiBgD_xHqqkZx_
 *                   _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBfP_xHqqkZx_  _xZkqqHx_iBfOiBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iBfOiBfB_xHqqkZx___xZkqqHx_iBfBiBfBiBfB_xHqqkZx_
 *                   _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBhO_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iBfOiBfO_xHqqkZx_   _xZkqqHx_iBeG_xHqqkZx_
 *                   _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBfO_xHqqkZx_  _xZkqqHx_iBfPiBeG_xHqqkZx_         _xZkqqHx_iBfO_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *          Y2 _xZkqqHx_iBgDiBgDiBgDiEkJiBfOiBgDiBgDiBgDiBfPiBgDiBgDiBgDiBeFiBfOiBeFiBgDiEkAiBgDiBgDiEkJiBgDiBgD_xHqqkZx_
 *                   _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBeGiBfPiBfB_xHqqkZx___xZkqqHx_iBfO_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *                 _xZkqqHx_iBfOiBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *          Y3 _xZkqqHx_iBgDiBeFiEkAiBeFiEkJiBgDiBgDiBgDiBgDiEkJiBgDiBgDiBgDiBgDiEkJiBgDiEkAiBgDiBgDiEkJiBgDiBgD_xHqqkZx_
 *                _xZkqqHx_iEkEiEjPiEjPiEjP_xHqqkZx_-_xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_
 *                   _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *                   _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyHash::GetWillIntersectPolySet (	set< pair<long, long> >& stIndexIndex,
											FCPolyHash& polyHash0,
											FCPolyHash& polyHash1)
{
	stIndexIndex.clear();

//----- 06.12.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jClMjApMiCmMiOgOjDfPiBeFiPeJjDfPiCkKjDkPiClGiPoKiNiHiCmJiImIiJlKiCkKjHeMiCoIiCkGiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDiKiDiKiBfLiDfIjEmFiCmFiDeHiDiJiBfLiCkKjAlGiClGiCoJiPoKiNiHiCkKiCkAiCmBiClNiClNiCnPiBeBjHoBiKePjEkNjAlGiBeC_xHqqkZx_
	if (polyHash0.m_pTopHash == NULL ||
		polyHash1.m_pTopHash == NULL)
		FFThrowMiscUnknown();
//----- 06.12.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iCnMiClIiDhEiDiMiBfLiDiAiCpAjEoEiKhCiBeCiDhEiDiMiBfLiDiAiCmJiPgEiCmIiCoIiCkKiCmIiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
	if ((polyHash0.m_mmrtFrame & polyHash1.m_mmrtFrame).IsRectNull())
		return;
	// _xZkqqHx_jEoEiKhCiClHiCoJjHlMjFpLiCmMiDgOiDgCiDfGiDiFiCmMiDePiDiKiDgCiDgIjClHiCpAiClLiCoLiCkGiCoJiBeCjClHiCkCjFpLiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
	if (almostless(polyHash0.m_pTopHash->m_mmGridWidth, polyHash1.m_pTopHash->m_mmGridWidth))
	//----- _xZkqqHx_iDgOiDgCiDfGiDiFiCePiCoGiCoIiDgOiDgCiDfGiDiFiCfAiCmMiDePiDiKiDgCiDgIjClHiCkKjClHiCkCiPoKiNiH_xHqqkZx_ ----
	{
		// _xZkqqHx_iDePiDiKiDgCiDgIjClHiCkKjDkPiClGiCmJiCmIiCoJiCnMiCmFiBeBiDgOiDgCiDfGiDiFiCePiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiPoDiImKiCmMiDgOiDgCiDfGiDiFiCmJjFmPiCkGiCmEiCkCiCkNiBeC_xHqqkZx_
		while (!almosteq(polyHash0.m_pTopHash->m_mmGridWidth, polyHash1.m_pTopHash->m_mmGridWidth))
			polyHash0.CreateSuperHashRec();
	} else
	if (almostless(polyHash1.m_pTopHash->m_mmGridWidth, polyHash0.m_pTopHash->m_mmGridWidth))
	//----- _xZkqqHx_iDgOiDgCiDfGiDiFiCfAiCoGiCoIiDgOiDgCiDfGiDiFiCePiCmMiDePiDiKiDgCiDgIjClHiCkKjClHiCkCiPoKiNiH_xHqqkZx_ ----
	{
		// _xZkqqHx_iDePiDiKiDgCiDgIjClHiCkKjDkPiClGiCmJiCmIiCoJiCnMiCmFiBeBiDgOiDgCiDfGiDiFiCfAiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiPoDiImKiCmMiDgOiDgCiDfGiDiFiCmJjFmPiCkGiCmEiCkCiCkNiBeC_xHqqkZx_
		while (!almosteq(polyHash0.m_pTopHash->m_mmGridWidth, polyHash1.m_pTopHash->m_mmGridWidth))
			polyHash1.CreateSuperHashRec();
	}
	// _xZkqqHx_iDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAjEoEiKhCiBeC_xHqqkZx_
	FCPolyHashRec::GetWillIntersectPolySet(	stIndexIndex,
											polyHash0.m_pTopHash,
											polyHash1.m_pTopHash,
											polyHash0.m_vPoint.size(),
											polyHash0.m_vPoint.begin(),
											polyHash1.m_vPoint.size(),
											polyHash1.m_vPoint.begin());
} // FCPolyHash::GetWillIntersectPolySet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPolyHash::CreateSuperHashRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgOiDgCiDfGiDiFiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCmMiBeBiIoKiCmCiPoDiImKiCmMiDgOiDgCiDfGiDiFiCpAiNoMjAkMiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiCpAiDgHiDgCiDhGiDgOiDgCiDfGiDiFiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCfAiCmMiCoGiCkEiCmIiBeBiDePiDiKiDgCiDgIjClH_xHqqkZx_ 0.1mm_xZkqqHx_iCmMiDgOiDgCiDfGiDiFiCkKiCkAiCoJiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiPoDiImKiCmMiDgOiDgCiDfGiDiFiCmNiBeBjAhNiCfBiCmMiCoGiCkEiCmJiCmIiCoJiBeC_xHqqkZx_
 *			0.1mm_xZkqqHx_jClHiCmMiDgOiDgCiDfGiDiFiCmNiPoDiImKiDgOiDgCiDfGiDiFiCmMiDiGiDgKiDgCiDgHiClCiCmGiCmJiCfIiCmCiCmJ_xHqqkZx_
 *			_xZkqqHx_jFkKiKiEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *                          10.9                12.2
 *                           _xZkqqHx_iEkA_xHqqkZx_11            12  _xZkqqHx_iEkA_xHqqkZx_
 *                           _xZkqqHx_iEkAiEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *                    30.9 _xZkqqHx_iEjPiEkMiElBiElBiElBiElBiElBiElBiElBiElBiElBiEkN_xHqqkZx_
 *                      31 _xZkqqHx_iEjPiElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_
 *                           _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_
 *                           _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_
 *                           _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_
 *                           _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_
 *                           _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_
 *                      32 _xZkqqHx_iEjPiElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_
 *                           _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_
 *                    32.2 _xZkqqHx_iEjPiEkPiElDiElDiElDiElDiElDiElDiElDiElDiElDiEkO_xHqqkZx_
 *                            _xZkqqHx_jAhNiCfA_xHqqkZx_ 0.1mm_xZkqqHx_jClHiDgOiDgCiDfGiDiF_xHqqkZx_
 *
 *
 *                 10            11            12            13 
 *                 _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_ 
 *            30 _xZkqqHx_iEjPiEkMiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_    L=1     _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkLiBkJiEjPiEjPiEjPiEjPiBkIiEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkMiElEiElBiElBiElBiElBiElBiElBiElEiElBiEkN_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_ 
 *            31 _xZkqqHx_iEjPiElAiEkKiEkKiEkKiEkKiEkKiElEiElEiElEiElEiElEiElEiElEiElEiElEiElEiElEiEkKiEkKiEkKiEkKiElC_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_ 
 *            32 _xZkqqHx_iEjPiElAiEkKiEkKiEkKiEkKiEkKiElEiElEiElEiElEiElEiElEiElEiElEiElEiElEiElEiEkKiEkKiEkKiEkKiElC_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iElAiElEiElEiElEiElEiElEiElEiElEiElEiElEiElC_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkPiElEiElDiElDiElDiElDiElDiElDiElEiElDiEkO_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkIiEkJiEkJiBkJ_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_    L=0.1   _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_ 
 *                 _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_ 
 *            33 _xZkqqHx_iEjPiEkPiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiElE_xHqqkZx_ 
 *                            _xZkqqHx_jAhNiCfB_xHqqkZx_ 1mm_xZkqqHx_jClHiDgOiDgCiDfGiDiF_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPolyHash::CreateSuperHashRec ()
{
	// _xZkqqHx_iPoDjAhNiCpAjHoBiCmJiCmGiCoJiCmGiBeBjAfGiClFiCkN_xHqqkZx_1mm_xZkqqHx_jClHiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpA_xHqqkZx_
	// _xZkqqHx_iNoMjAkMiClFiBeBiClLiClBiCmJiClBiCoKiCnMiCmFiCmM_xHqqkZx_(_xZkqqHx_iDiGiDgKiDgCiDgH_xHqqkZx_->_xZkqqHx_jApMjFkKiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_)_xZkqqHx_iPoOjFpBiCpA_xHqqkZx_
	// _xZkqqHx_iInKjDkOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jAfGiClFiCkNiNoMjAkMiClFiClN_xHqqkZx_1mm_xZkqqHx_jClHiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCmJiBeBjAfGiClFiCkN_xHqqkZx_
	// _xZkqqHx_iJlKiImKiCmM_xHqqkZx_0.1mm_xZkqqHx_jClHiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClFiBeBiClBiCoKiCnMiCmFiCmM_xHqqkZx_
	// _xZkqqHx_iDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiPoOjFpBiCpAjAfGiClFiCkNiNoMjAkMiClFiClNiDiMiDfCiBfLiDgIiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iPfNjHiIiCmMiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCmNjGjFiPmBiClFiBeBjAfGiClFiCkC_xHqqkZx_1mm_xZkqqHx_jClHiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpA_xHqqkZx_
	// _xZkqqHx_iDgHiDgCiDhGiCmGiClFiCmEjDgPjIfOiClHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iPoDiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCmMiDePiDiKiDgCiDgIjClHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	mmetol mmGridWidth = m_pTopHash->m_mmGridWidth * 10.0;
	// _xZkqqHx_iPoDiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCPolyHashRec* pSuperHashRec = new FCPolyHashRec();
	// _xZkqqHx_iDePiDiKiDgCiDgIjClHiCpAjAnNjCoIiBeC_xHqqkZx_
	pSuperHashRec->m_mmGridWidth = mmGridWidth;
	map<DBLPoint, longSet>::iterator iUix;
	for (iUix = m_pTopHash->m_mpUnitToLineIndex.begin();
		 iUix != m_pTopHash->m_mpUnitToLineIndex.end(); iUix++)
	{
		// _xZkqqHx_iMlLiNnNiCmMiDgOiDgCiDfGiDiFiCmMiKmHjHjNiClHiCoJiDiGiDgKiDgCiDgHiClCiCmGiCmJiBeBjBmOiJjOiClHiCoJ_xHqqkZx_
		// _xZkqqHx_iPoDiImKiDgOiDgCiDfGiDiFiDiGiDgKiDgCiDgHiCmJjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iPoDjAhNiCmMjHoBiCmFiCkCiCkEiCmGiBeB_xHqqkZx_(*iUix).first=(11.0,30.9)_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
		// mmGridWidth=1.0_xZkqqHx_iBeB_xHqqkZx_mmptUnitFrame=(11,30)_xZkqqHx_iCmGiCmIiCoIiBeB_xHqqkZx_
		// _xZkqqHx_iPoDiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCmM_xHqqkZx_(11,30)_xZkqqHx_iDiGiDgKiDgCiDgHiCmJ_xHqqkZx_(11.0,30.9)_xZkqqHx_iDiGiDgKiDgCiDgHiCkK_xHqqkZx_
		// _xZkqqHx_iKmHjHjNiClHiCoJjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jDkPjHgMiCmJiBeB_xHqqkZx_(11.1,30.9)(11.2,30.9)_xZkqqHx_iBeFiBeFiBeFiCmMiKmHjHjNiClHiCoJ_xHqqkZx_
		// _xZkqqHx_jApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_(11,30)_xZkqqHx_iDiGiDgKiDgCiDgHiKmHjHjNiJlKiCmJjFkBiOmKiClDiCoKiCoJiBeC_xHqqkZx_
		DBLPoint mmptUnitFrame;
		FCPolyHashRec::GetBelongUnitFrame(mmptUnitFrame, mmGridWidth, (*iUix).first);
		FFInsert(pSuperHashRec->m_mpUnitToLineIndex[mmptUnitFrame], (*iUix).second);
		// mmptUnitFrame_xZkqqHx_iCmMiDiGiDgKiDgCiDgHiCmJiJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCkKiKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		FCPolyHashRec* pSubHashRec = pSuperHashRec->m_mpSubHash[mmptUnitFrame];
		if (pSubHashRec == NULL)
		//----- _xZkqqHx_iCnMiClOjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
			pSubHashRec = new FCPolyHashRec();
			// _xZkqqHx_iDePiDiKiDgCiDgIjClHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			pSubHashRec->m_mmGridWidth = m_pTopHash->m_mmGridWidth;
			// _xZkqqHx_iJlKiImKiDgOiDgCiDfGiDiFiKmHjHjNiDgFiBfLiDhFiDiLiCmJjDgPjIfOiBeC_xHqqkZx_
			pSuperHashRec->m_mpSubHash[mmptUnitFrame] = pSubHashRec;
		}
		// _xZkqqHx_iJlKiImKiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCmJiBeBiBgJiDiGiDgKiDgCiDgH_xHqqkZx_->_xZkqqHx_jApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiPfHiNiHiBgKiCmMiDgGiBfLiDfOiCpAjFkBiOmKiBeC_xHqqkZx_
		pSubHashRec->m_mpUnitToLineIndex.insert(*iUix);
		// _xZkqqHx_iMlLiNnNiCmMiJlKiImKiDiGiDgKiDgCiDgHiCmJiBeBiNfIiCmJiJlKiImKiCmMiDiGiDgKiDgCiDgHiCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
		// _xZkqqHx_iClLiCoKiCpAjAfGiClFiCkNiNoMjAkMiClFiClNiJlKiImKiDiGiDgKiDgCiDgHiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
		if (m_pTopHash->m_mpSubHash.find((*iUix).first) != m_pTopHash->m_mpSubHash.end())
			pSubHashRec->m_mpSubHash[(*iUix).first] = m_pTopHash->m_mpSubHash[(*iUix).first];
	}
	// _xZkqqHx_iClBiCoKiCnMiCmFiCmMiDgHiDgCiDhGiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAiDeOiDiKiDeBiBeBiNoNiPjMiBeC_xHqqkZx_
	m_pTopHash->m_mpSubHash.clear();
	delete m_pTopHash;
	// _xZkqqHx_jAfGiClFiCkCiDgHiDgCiDhGiDgOiDgCiDfGiDiFiDiMiDfCiBfLiDgIiCpAjDgPjIfOiBeC_xHqqkZx_
	m_pTopHash = pSuperHashRec;
} // FCPolyHash::CreateSuperHashRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetLineLength
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMiBeBiNfMjAkMjApMjFkKiCmMjClHiClDiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vLineLength	:_xZkqqHx_jApMjFkKjClHiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lPointSize	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjBfDjClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMiCoGiCkEiCmJiBeBiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCkK_xHqqkZx_ P[0],P[1],_xZkqqHx_iBgD_xHqqkZx_,P[n]_xZkqqHx_iCmGjHfOiCkGiCoHiCoKiCmE_xHqqkZx_
 *			_xZkqqHx_iCkCiCoJiPoKiNiHiBeBjApMjFkKjClHjEhKjHpBiCmN_xHqqkZx_ L[0],L[1],_xZkqqHx_iBgD_xHqqkZx_,L[n-1]_xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjBfDjClHiCmNiBeB_xHqqkZx_L[0]+L[1]+_xZkqqHx_iBgD_xHqqkZx_+L[n-1]_xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *
 *               L[0]      L[1]           L[2]
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiBgD_xHqqkZx_
 *         P[0]        P[1]    P[2]                  P[3]
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FFGetLineLength (doubleVector& vLineLength, long lPointSize, const DBLPoint* mmptPoint)
{
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjBfDjClHiCpAiOfKiPgPiBeC_xHqqkZx_
	double dTotalLength = 0;
	vLineLength.clear();
	long lIndex;
	for (lIndex = 0; lIndex != lPointSize - 1; lIndex++)
	{
		const DBLPoint mmptL = mmptPoint[lIndex + 1] - mmptPoint[lIndex];
		vLineLength.push_back(mmptL.Len());
		dTotalLength += vLineLength.back();
	}
	return dTotalLength;
} // FFGetLineLength.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetLineAngle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMiBeBiNfMjAkMjApMjFkKiCmMiKhAjDhIiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vLineAngle	:_xZkqqHx_jApMjFkKiKhAjDhIiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lPointSize	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKhAjDhIiCmMjCfAiImKiCmNiBeB_xHqqkZx_[-pi, pi]_xZkqqHx_iCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetLineAngle (doubleVector& vLineAngle, long lPointSize, const DBLPoint* mmptPoint)
{
	vLineAngle.clear();
	long lIndex;
	for (lIndex = 0; lIndex != lPointSize - 1; lIndex++)
	{
		const DBLPoint mmptL = mmptPoint[lIndex + 1] - mmptPoint[lIndex];
		vLineAngle.push_back(atan2(mmptL.y, mmptL.x));
	}
} // FFGetLineAngle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetMilestonePoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMiBeBiDhNiDeDiDiLiDfIiDgHiDjDiImKjChFiCmMjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vMilestone	:_xZkqqHx_iDhNiDeDiDiLiDfIiDgHiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lPointSize	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineLength	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiNfMjAkMiClHiCoJjApMjFkKiCmMjClHiClDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDivCount	:_xZkqqHx_iDhNiDeDiDiLiDfIiDgHiDjDiCmMjFkKiKiEjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKiCmMjAhNiCmNiBeB_xHqqkZx_lPointSize=4_xZkqqHx_iBeB_xHqqkZx_lDivCount=4_xZkqqHx_iCmMiPoKiNiHiCmFiCkAiCoJiBeC_xHqqkZx_
 *
 *         lC=0      lC=1      lC=2      lC=3      lC=4
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElC_xHqqkZx_
 *         P[0]        P[1]  P[2]                  P[3]
 *
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCmMjBfDjClHiCpA_xHqqkZx_ lDivCount_xZkqqHx_jAjEiCmJiLmPjDjJiCmJjFkKiKiEiClFiClNiPoKiNiHiCmM_xHqqkZx_
 *			_xZkqqHx_iKgFiImKjChFiCpAiDhNiDeDiDiLiDfIiDgHiDjDiCmGiMmEiCnEiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeDiDiLiDfIiDgHiDjDiCmMiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetMilestonePoint (	DBLPointVector& vMilestone,
							long lPointSize,
							const DBLPoint* mmptPoint,
							const double* pLineLength,
							long lDivCount)
{
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjBfDjClHiCpAiOfKiPgPiBeC_xHqqkZx_
	double dTotalLength = 0;
	long lIndex;
	for (lIndex = 0; lIndex != lPointSize - 1; lIndex++)
		dTotalLength += pLineLength[lIndex];

	lIndex = 0;
	double dCurLength = 0.0;
	double dNextLength = dCurLength + pLineLength[lIndex];
	vMilestone.clear();
	// _xZkqqHx_iNmFiPiJiCmMiDhNiDeDiDiLiDfIiDgHiDjDiCpAiLeMjIfOiBeC_xHqqkZx_
	vMilestone.push_back(mmptPoint[0]);
	long lC;
	for (lC = 1; lC != lDivCount; lC++)
	{
		// _xZkqqHx_iOgOjDfPiCkJiCoHiMlLiNnNiCmMiDhNiDeDiDiLiDfIiDgHiDjDiImKjChF_xHqqkZx_(lC)_xZkqqHx_iCnMiCmFiCmMiLjHjHkDiCpAiMhGiOfKiBeC_xHqqkZx_
		const double dMileLength = dTotalLength * double(lC) / double(lDivCount);
		for (;;)
		{
			// _xZkqqHx_iPoDjAhNiCmMjHoBiCmFiMlOiCkEiCmGiBeB_xHqqkZx_lC=1_xZkqqHx_iBeB_xHqqkZx_lIndex=0_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_dMileLength=lC(0)_xZkqqHx_iBgA_xHqqkZx_lC(1)_xZkqqHx_iBeB_xHqqkZx_dCurLength=0_xZkqqHx_iBeB_xHqqkZx_dNextLength=P[0]_xZkqqHx_iBgA_xHqqkZx_P[1]_xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
			// dMileLength_xZkqqHx_iCkK_xHqqkZx_dCurLength_xZkqqHx_iCmG_xHqqkZx_dNextLength_xZkqqHx_iCmMiKnEiCmJiCkAiCoJiPoKiNiHiCmNiBeB_xHqqkZx_P[lIndex]_xZkqqHx_iBgA_xHqqkZx_P[lIndex+1]_xZkqqHx_iCmG_xHqqkZx_P[lIndex]_xZkqqHx_iBgA_xHqqkZx_dMileLength_xZkqqHx_iCmM_xHqqkZx_
			// _xZkqqHx_iKiEiCoIiNiHiCkCiCkJiCoH_xHqqkZx_dMileLength_xZkqqHx_iImKjChFiCmMiNmAjFfHiCpAiMhGiOfKiCmFiCkLiCoJiBeC_xHqqkZx_

			if (dMileLength <= dNextLength)
			//----- _xZkqqHx_iMlLiNnNiCmMiDhNiDeDiDiLiDfIiDgHiDjDiImKjChFiCkKiBeB_xHqqkZx_mmptPoint[lIndex]_xZkqqHx_iBgA_xHqqkZx_mmptPoint[lIndex+1]_xZkqqHx_iCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				//                       _xZkqqHx_iCgM_xHqqkZx_
				//  lC=0      lC=1      lC=2      lC=3      lC=4
				//   _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
				//   _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElC_xHqqkZx_
				//  P[0]        P[1]  P[2]                  P[3]
				//                     P2                    P3
				//
				// _xZkqqHx_iClBiCmMjAhNiCmJiCkIiCkCiCmEiBeB_xHqqkZx_lC=2_xZkqqHx_iBeB_xHqqkZx_lIndex=2_xZkqqHx_iCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
				// P3=mmptPoint[lIndex + 1]_xZkqqHx_iBeB_xHqqkZx_P2=mmptPoint[lIndex]_xZkqqHx_iBeB_xHqqkZx_M=dMileLength_xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
				//
				// _xZkqqHx_iPoDjAhNiCmJiCkIiCkCiCmEiBeB_xHqqkZx_P2-M_xZkqqHx_iKnEiCmMiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
				double dLenM = dMileLength - dCurLength;
				// |P2-M|/|P2-P3|_xZkqqHx_iCpA_xHqqkZx_P2P3_xZkqqHx_iCmMiDhIiDeOiDfOiBfLiCmJiKhMiCkPiCoJiClBiCmGiCmFiBeB_xHqqkZx_M_xZkqqHx_iCmMiNmAjFfH_xHqqkZx_ mmptM_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
				DBLPoint mmptM = mmptPoint[lIndex] + (mmptPoint[lIndex + 1] - mmptPoint[lIndex]) * (dLenM / pLineLength[lIndex]);
				// _xZkqqHx_iDhNiDeDiDiLiDfIiDgHiDjDiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
				vMilestone.push_back(mmptM);
				break;
			} else
			//----- _xZkqqHx_iMlLiNnNiCmMiDhNiDeDiDiLiDfIiDgHiDjDiImKjChFiCkKiBeB_xHqqkZx_mmptPoint[lIndex+1]_xZkqqHx_iBgAiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// lIndex_xZkqqHx_iCpAiJmBiOfKiClFiCmEiBeBiMlLiNnNiCmM_xHqqkZx_P_xZkqqHx_iCmMiImKjChFiCpAiJeFiCmJjAgJiCnPiCoJiBeC_xHqqkZx_
				lIndex++;
				dCurLength = dNextLength;
				dNextLength = dCurLength + pLineLength[lIndex];
			}
		}
	}
	// _xZkqqHx_iNmFiMoDiCmMiDhNiDeDiDiLiDfIiDgHiDjDiCpAiLeMjIfOiBeC_xHqqkZx_
	vMilestone.push_back(mmptPoint[lPointSize - 1]);
} // FFGetMilestonePoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mySlimLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCmMiPoHjClHiCmIjDfPiCpAiPmIjHkKiClFiDfIiDiKiDiAiJlLiClFiClNiDhMiDiKiDiJiDeDiDjDiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vSlimLine		:_xZkqqHx_iDfIiDiKiDiAiJlLiClFiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptPoint		:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndexFirst		:_xZkqqHx_iPmIjHkKiClHiCoJjEmNiImNiCmMiNmFiPiJiCmMiDhMiDeDiDjDiDgHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpA_xHqqkZx_
 *							 _xZkqqHx_iOhHjCoIiBeCiJlKjAhNiCfAiCmMjHoBiCmFiCmNiBeB_xHqqkZx_P0_xZkqqHx_iBeC_xHqqkZx_
 *			lIndexLast		:_xZkqqHx_iPmIjHkKiClHiCoJjEmNiImNiCmMiNmFiMoDiCmMiDhMiDeDiDjDiDgHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpA_xHqqkZx_
 *							 _xZkqqHx_iOhHjCoIiBeCiJlKjAhNiCfAiCmMjHoBiCmFiCmNiBeB_xHqqkZx_Pn_xZkqqHx_iBeC_xHqqkZx_
 *			mmSlimDistance1	:_xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iOhHjCoIiBeCiJlKjAhNiCfAiCmMiPoKiNiHiBeBjClMjApM_xHqqkZx_P0-Pn_xZkqqHx_iCmGiNmFiCoAiJjDiCkCjDfPiCgM_xHqqkZx_
 *							 _xZkqqHx_iCmMiLjHjHkDiCkK_xHqqkZx_mmSlimDistance1_xZkqqHx_iImIiJlKiCmMiPoKiNiHiCmNiBeB_xHqqkZx_P0_xZkqqHx_iCkJiCoH_xHqqkZx_Pn_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_iKnEiCmMjBfDiCmEiCmMjDfPiCkKiPmIjHkKiClDiCoKiCoJiBeC_xHqqkZx_
 *			dRoundA			:_xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiMfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMjElLjCgGiCmJiDhMiDiKiDiJiDeDiDjDiCmM_xHqqkZx_
 *							 _xZkqqHx_iOgOjDfP_xHqqkZx_-_xZkqqHx_iPeJjDfPiKnEiCmMiLjHjHkDiCoAiNgMjHlGiClDiClJiCoJiBeC_xHqqkZx_
 *							 _xZkqqHx_iNgMjHlGiClDiClJiCmIiCkCiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJlKjAhNiCfAiCmMjHoBiCmFiBeBjClMjApM_xHqqkZx_P0-Pn_xZkqqHx_iCmGjDfPiCgMiCmMiLjHjHkDiCpAiCgLiCmGiClHiCoJiCmGiBeB_xHqqkZx_
 *							 dRoundA*L _xZkqqHx_iCkK_xHqqkZx_|P0-Pn|_xZkqqHx_iImIiJlKiCmMiPoKiNiHiCmNiBeB_xHqqkZx_P0_xZkqqHx_iCkJiCoH_xHqqkZx_Pn_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_iKnEiCmMjBfDiCmEiCmMjDfPiCkKiPmIjHkKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfIiDiKiDiAiJlLiDhMiDiKiDiJiDeDiDjD_xHqqkZx_(vSlimLine)_xZkqqHx_iCmJiCmNiBeBiOgOjDfP_xHqqkZx_(P0)_xZkqqHx_iCkKiKnMiCnMiCoKiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_iPeJjDfP_xHqqkZx_(Pn)_xZkqqHx_iCmNiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHfOiCkGiCoHiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMiBeBjFhDjHhGiCmIjDfPiCpAjGjFiPmBiClFiCmEiDfIiDiKiDiAiCmIjEhKjHpBiCmJ_xHqqkZx_
 *			_xZkqqHx_jFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiBeBiJlKjAhNiCfAiCmMiDhMiDiKiDiJiDeDiDjDiCkKjHfOiCkGiCoHiCoKiCmEiDfIiDiKiDiAiJlLiClHiCoJiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_jClMjApM_xHqqkZx_(P0-Pn)_xZkqqHx_iCmGiNmFiCoAiJjDiCkCjDfPiCgMiCpAiOgDiClFiCmEiBeBjBlMiCmMjDfPiCmNiPmIjHkKiClHiCoJiCmGiBeBiJlKjAhNiCfB_xHqqkZx_
 *			_xZkqqHx_iCmMiCoGiCkEiCmIiDhMiDiKiDiJiDeDiDjDiCkKjDlOiCoHiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiDfIiDiKiDiAiJlLiClFiJnPiCkMiCmIiCmMiCmFiBeBjClMjApM_xHqqkZx_P0-M_xZkqqHx_iCkJiCoHiNmFiCoAiJjDiCkCjDfP_xHqqkZx_Mx _xZkqqHx_iCpAiLiBiCnPiCmE_xHqqkZx_
 *			P0-Mx-M_xZkqqHx_iCmMiDfIiDiKiDiAiJlLiDhMiDiKiDiJiDeDiDjDiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiCoGiCkEiCmJiBeBiOgOjDfPiCmGiPeJjDfPiCpAiMiLiCnEjClMjApMiCkJiCoHiNmFiCoAiJjDiCkCjDfPiCpAiOgDiClFiCmCiCmC_xHqqkZx_
 *			_xZkqqHx_iNmEiLeBjDeJiCmJiDhMiDeDiDjDiDgHiCpAiPmIjHkKiClFiCmEiCkCiCkNiBeC_xHqqkZx_
 *
 *                _xZkqqHx_iCgM_xHqqkZx_
 *                _xZkqqHx_iBkF_xHqqkZx_
 *               _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_
 *             _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfP_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_   
 *            _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_   
 *             _xZkqqHx_iBfP_xHqqkZx_          _xZkqqHx_iBkF_xHqqkZx_Pn
 *               _xZkqqHx_iBfP_xHqqkZx_          
 *                _xZkqqHx_iBkD_xHqqkZx_
 *                P0
 *                     _xZkqqHx_jAhNiCfA_xHqqkZx_
 *
 *
 *                _xZkqqHx_iCgM_xHqqkZx_
 *                _xZkqqHx_iBkF_xHqqkZx_
 *                |_xZkqqHx_iBfP_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBfP_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBfP_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBfP_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iBkF_xHqqkZx_Pn
 *                _xZkqqHx_iEkA_xHqqkZx_         
 *                _xZkqqHx_iBkD_xHqqkZx_
 *                P0
 *                     _xZkqqHx_jAhNiCfB_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void mySlimLine (DBLPointVector& vSlimLine,
						const DBLPoint* mmptPoint,
						long lIndexFirst,
						long lIndexLast,
						mmetol mmSlimDistance1,
						double dRoundA)
{
	if (lIndexLast == lIndexFirst) return;
	if (lIndexLast - lIndexFirst == 1)
	//----- _xZkqqHx_iDhMiDeDiDjDiDgHjAjEiCkKiCfBiMmCiCmMiPoKiNiH_xHqqkZx_ -----
	{
		vSlimLine.push_back(mmptPoint[lIndexLast]);
		return;
	}
	//----- _xZkqqHx_jClMjApM_xHqqkZx_P0-Pn_xZkqqHx_iCkJiCoHiNmFiCoAiJjDiCkCjDfPiCgMiCmGiBeBiClLiCmMiLjHjHkDiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
	// _xZkqqHx_jClMjApM_xHqqkZx_P0-Pn_xZkqqHx_iCkJiCoHiNmFiCoAiJjDiCkCjDfPiCnMiCmFiCmMiLjHjHkDiCmMiCfBiPoGjCgMiBeC_xHqqkZx_
	double dMaxPowLen = -DBL_MAX;
	long lIndexFar = -1;
	const DBLLine dblLine(mmptPoint[lIndexFirst], mmptPoint[lIndexLast]);
	long lIndex;
	for (lIndex = lIndexFirst + 1; lIndex != lIndexLast; lIndex++)
	{
		// _xZkqqHx_jClMjApM_xHqqkZx_P0-Pn_xZkqqHx_iPoDiCmFiBeBjClCiNlIiDhMiDeDiDjDiDgHiCmJiNmFiCoAiLnPiCkCjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
		DBLPoint mmptNear = dblLine.GetNearest(mmptPoint[lIndex]);
		// _xZkqqHx_iNmFiCoAiLnPiCkCjDfPiCmGjClCiNlIiDhMiDeDiDjDiDgHiCmMiLjHjHkDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
		double dPowLen = (mmptNear - mmptPoint[lIndex]).PowLen();
		if (dMaxPowLen < dPowLen)
		//----- _xZkqqHx_iClBiCoKiCnMiCmFiCmFiNmFiCoAiJjDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			dMaxPowLen = dPowLen;
			lIndexFar = lIndex;
		}
	}
	const double dStdDistancePow = mmSlimDistance1 * mmSlimDistance1;
	if (dStdDistancePow < dMaxPowLen)
	//----- _xZkqqHx_jDfPiCgMiCnMiCmFiCmMiLjHjHkDiCkKiKoOiPiAjCgMiCpAjClEiCkGiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDfPiCgMiCpAiLkLiCmJjBePjElMiCmMiDhMiDiKiDiJiDeDiDjDiCmGiMoDjElMiCmMiDhMiDiKiDiJiDeDiDjDiCpAiNmEiLeBjDeJiCmJiPiIjHjNiBeC_xHqqkZx_
		mySlimLine(vSlimLine, mmptPoint, lIndexFirst, lIndexFar, mmSlimDistance1, dRoundA);
		mySlimLine(vSlimLine, mmptPoint, lIndexFar, lIndexLast, mmSlimDistance1, dRoundA);
		return;
	}
	if (dRoundA != 0.0)
	//----- _xZkqqHx_iKoOiPiAiMfHjAjEiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ ----
	{
		const double dPowLenTmp = (mmptPoint[lIndexFirst] - mmptPoint[lIndexLast]).PowLen();
		if (dPowLenTmp < dMaxPowLen * POW2(dRoundA))
		//----- _xZkqqHx_iKoOiPiAjCgMiCpAjClEiCkGiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jDfPiCgMiCpAiLkLiCmJjBePjElMiCmMiDhMiDiKiDiJiDeDiDjDiCmGiMoDjElMiCmMiDhMiDiKiDiJiDeDiDjDiCpAiNmEiLeBjDeJiCmJiPiIjHjNiBeC_xHqqkZx_
			mySlimLine(vSlimLine, mmptPoint, lIndexFirst, lIndexFar, mmSlimDistance1, dRoundA);
			mySlimLine(vSlimLine, mmptPoint, lIndexFar, lIndexLast, mmSlimDistance1, dRoundA);
			return;
		}
	}
	// _xZkqqHx_iNmEiLeBjDeJiCmIiPiIjHjNiCpAiClFiCmIiCkCiPoKiNiHiCmNiBeBiPeJjDfPiCpAiDfIiDiKiDiAiDiJiDeDiDjDiCmJjCmHiJmBiBeC_xHqqkZx_
	vSlimLine.push_back(mmptPoint[lIndexLast]);
} // mySlimLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSlimLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCmMiPoHjClHiCmIjDfPiCpAiPmIjHkKiClFiDfIiDiKiDiAiJlLiClFiClNiDhMiDiKiDiJiDeDiDjDiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoint		:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeCiDfIiDiKiDiAiJlLiClFiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmSlimDistance1	:_xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJlKjAhNiCfAiCmMiPoKiNiHiBeBjClMjApM_xHqqkZx_P0-Pn_xZkqqHx_iCmGiNmFiCoAiJjDiCkCjDfPiCgMiCmMiLjHjHkDiCkK_xHqqkZx_
 *							 mmSlimDistance1_xZkqqHx_iImIiJlKiCmMiPoKiNiHiCmNiBeB_xHqqkZx_P0_xZkqqHx_iCkJiCoH_xHqqkZx_Pn_xZkqqHx_iCmMiKnEiCmM_xHqqkZx_
 *							 _xZkqqHx_jBfDiCmEiCmMjDfPiCkKiPmIjHkKiClDiCoKiCoJiBeC_xHqqkZx_
 *			dRoundA			:_xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiMfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMjElLjCgGiCmJiDhMiDiKiDiJiDeDiDjDiCmM_xHqqkZx_
 *							 _xZkqqHx_iOgOjDfP_xHqqkZx_-_xZkqqHx_iPeJjDfPiKnEiCmMiLjHjHkDiCoAiNgMjHlGiClDiClJiCoJiBeC_xHqqkZx_
 *							 _xZkqqHx_iNgMjHlGiClDiClJiCmIiCkCiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJlKjAhNiCfAiCmMjHoBiCmFiBeBjClMjApM_xHqqkZx_P0-Pn_xZkqqHx_iCmGjDfPiCgMiCmMiLjHjHkDiCpAiCgLiCmGiClHiCoJiCmGiBeB_xHqqkZx_
 *							 dRoundA*L _xZkqqHx_iCkK_xHqqkZx_|P0-Pn|_xZkqqHx_iImIiJlKiCmMiPoKiNiHiCmNiBeB_xHqqkZx_P0_xZkqqHx_iCkJiCoH_xHqqkZx_Pn_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_iKnEiCmMjBfDiCmEiCmMjDfPiCkKiPmIjHkKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHfOiCkGiCoHiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMiBeBjFhDjHhGiCmIjDfPiCpAjGjFiPmBiClFiCmEiDfIiDiKiDiAiCmIjEhKjHpBiCmJ_xHqqkZx_
 *			_xZkqqHx_jFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiBeBiJlKjAhNiCfAiCmMiDhMiDiKiDiJiDeDiDjDiCkKjHfOiCkGiCoHiCoKiCmEiDfIiDiKiDiAiJlLiClHiCoJiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_jClMjApM_xHqqkZx_(P0-Pn)_xZkqqHx_iCmGiNmFiCoAiJjDiCkCjDfPiCgMiCpAiOgDiClFiCmEiBeBjBlMiCmMjDfPiCmNiPmIjHkKiClHiCoJiCmGiBeBiJlKjAhNiCfB_xHqqkZx_
 *			_xZkqqHx_iCmMiCoGiCkEiCmIiDhMiDiKiDiJiDeDiDjDiCkKjDlOiCoHiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiDfIiDiKiDiAiJlLiClFiJnPiCkMiCmIiCmMiCmFiBeBjClMjApM_xHqqkZx_P0-M_xZkqqHx_iCkJiCoHiNmFiCoAiJjDiCkCjDfP_xHqqkZx_Mx _xZkqqHx_iCpAiLiBiCnPiCmE_xHqqkZx_
 *			P0-Mx-M_xZkqqHx_iCmMiDfIiDiKiDiAiJlLiDhMiDiKiDiJiDeDiDjDiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiCoGiCkEiCmJiBeBiOgOjDfPiCmGiPeJjDfPiCpAiMiLiCnEjClMjApMiCkJiCoHiNmFiCoAiJjDiCkCjDfPiCpAiOgDiClFiCmCiCmC_xHqqkZx_
 *			_xZkqqHx_iNmEiLeBjDeJiCmJiDhMiDeDiDjDiDgHiCpAiPmIjHkKiClFiCmEiCkCiCkNiBeC_xHqqkZx_
 *
 *                _xZkqqHx_iCgM_xHqqkZx_
 *                _xZkqqHx_iBkF_xHqqkZx_
 *               _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_
 *             _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfP_xHqqkZx_
 *            _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_   
 *            _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_   
 *             _xZkqqHx_iBfP_xHqqkZx_          _xZkqqHx_iBkF_xHqqkZx_Pn
 *               _xZkqqHx_iBfP_xHqqkZx_          
 *                _xZkqqHx_iBkD_xHqqkZx_
 *                P0
 *                     _xZkqqHx_jAhNiCfA_xHqqkZx_
 *
 *
 *                _xZkqqHx_iCgM_xHqqkZx_
 *                _xZkqqHx_iBkF_xHqqkZx_
 *                |_xZkqqHx_iBfP_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBfP_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBfP_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBfP_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_       _xZkqqHx_iBkF_xHqqkZx_Pn
 *                _xZkqqHx_iEkA_xHqqkZx_         
 *                _xZkqqHx_iBkD_xHqqkZx_
 *                P0
 *                     _xZkqqHx_jAhNiCfB_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSlimLine (DBLPointVector& vmmptPoint,
				mmetol mmSlimDistance1,
				mmetol mmSlimDistance2,
				double dRoundA)
{
	if (vmmptPoint.size() < 2) return;
	// _xZkqqHx_iDfIiDiKiDiAiDiJiDeDiDjDiCpAiOoGjDlOiBeC_xHqqkZx_
	DBLPointVector vmmptSlim;
	vmmptSlim.push_back(vmmptPoint[0]);
	mySlimLine(vmmptSlim, vmmptPoint.begin(), 0, vmmptPoint.size() - 1, mmSlimDistance1, dRoundA);
	vmmptPoint = vmmptSlim;
} // FFSlimLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFOmitClosePoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHnHiCoIiNiHiCkEjDpBiCmCiCmMiDhMiDeDiDjDiDgHiCkKiLnPjAnKiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiIoKiCmCiCmJiCnMiCmGiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoint		:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeCiPmIjHkKiClFiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmSlimDistance2	:_xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHnHiCoIiNiHiCkEiCfBjDfPiCmMiLjHjHkDiCkKiClBiCmMjCgMiCoGiCoIiPkMiClDiCkCiPoKiNiHiBeB_xHqqkZx_
 *							 _xZkqqHx_iIoKjFpLiCmMjDfPiCkKiPmIjHkKiClDiCoKiCoJiBeC_xHqqkZx_
 *							 _xZkqqHx_iPmIjHkKiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFOmitClosePoint (	DBLPointVector& vmmptPoint,
						BYTEVector& vIsJoint,
						mmetol mmSlimDistance2)
{
	if (almost0(mmSlimDistance2)) return;

	const double dSlimDistance2 = POW2(mmSlimDistance2);
	BOOL bErased;
	do {
		// vmmptPoint[lIndex] _xZkqqHx_iCpAiNoNiPjMiClHiCoJiPoKiNiHiBeB_xHqqkZx_vmmptPoint[lIndex-1]_xZkqqHx_iCmG_xHqqkZx_
		// vmmptPoint[lIndex+1]_xZkqqHx_iCkKiLnPjAnKiClHiCoJiClBiCmGiCoAiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCoKiCpAjClCiCnHiCoJiClNiCnPiBeBjDpBiPgEiDiLiBfLiDhGiCmGiClHiCoJiBeC_xHqqkZx_
		bErased = FALSE;
		long lIndex;
		for (lIndex = 0; vmmptPoint.size() != 2 && lIndex < vmmptPoint.size() - 1;)
		{
			if ((vmmptPoint[lIndex + 1] - vmmptPoint[lIndex]).PowLen() <= dSlimDistance2)
			//----- _xZkqqHx_jHnHiCoIiNiHiCkEjDpBiCmCiCmMiDhMiDeDiDjDiDgHiCkKiLnPjAnKiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				bErased = TRUE;
				if (lIndex == 0)
				//----- _xZkqqHx_iNmFiPiJiCmMjDpBiCmCiCmMiDhMiDeDiDjDiDgHiCkKiLnPjAnKiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					vmmptPoint.erase(&vmmptPoint[lIndex + 1]);
					vIsJoint.erase(&vIsJoint[lIndex + 1]);
				} else
				if (lIndex + 1 == vmmptPoint.size() - 1)
				//----- _xZkqqHx_iNmFiMoDiCmMjDpBiCmCiCmMiDhMiDeDiDjDiDgHiCkKiLnPjAnKiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					vmmptPoint.erase(&vmmptPoint[lIndex]);
					vIsJoint.erase(&vIsJoint[lIndex]);
				} else
				//----- _xZkqqHx_jCiGiKnEiCmMjDpBiCmCiCmMiDhMiDeDiDjDiDgHiCkKiLnPjAnKiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iKgFiDhMiDeDiDjDiDgHiCmJiCoNiCkJiCoIiCoCiClHiCkNjGlMjBePiCpAjFhEiCkPiCoJiBeC_xHqqkZx_
					const int idxP0 = lIndex - 1;
					const int idxP1 = lIndex;
					const int idxP2 = lIndex + 1;
					const int idxP3 = lIndex + 2;
					//
					// P1_xZkqqHx_iCmG_xHqqkZx_P2_xZkqqHx_iCmMiCmHiClPiCoHiCpAiNoNiPjMiClHiCnHiCkLiCkJiClOiCkKiBeB_xHqqkZx_P0-P1-P2-P3_xZkqqHx_iCmM_xHqqkZx_
					// _xZkqqHx_jFmAiCnBiCpAiNgMiCkGiCmEiBeBiNoNiPjMiClFiCmEiJgFiLlPiCkKiCoGiCoIiPkNiCmIiCkCjFpLiBeBjBkGiClP_xHqqkZx_
					// P0-P2_xZkqqHx_iCmG_xHqqkZx_P1_xZkqqHx_iCmMiLjHjHkDiCmGiBeB_xHqqkZx_P1-P3_xZkqqHx_iCmG_xHqqkZx_P2_xZkqqHx_iCmMiLjHjHkDiCpAjEoEiKhCiClFiCmE_xHqqkZx_
					// _xZkqqHx_iCoGiCoIiPkMiClDiCkCjFpLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
					//
					// _xZkqqHx_jClMjApM_xHqqkZx_P0-P2_xZkqqHx_iBeC_xHqqkZx_
					const DBLLine dblLine02(vmmptPoint[idxP0], vmmptPoint[idxP2]);
					// _xZkqqHx_jClMjApM_xHqqkZx_P0-P2_xZkqqHx_iPoDiCmFiBeB_xHqqkZx_P1_xZkqqHx_iCmJiNmFiCoAiLnPiCkCjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
					DBLPoint mmptN1 = dblLine02.GetNearest(vmmptPoint[idxP1]);
					double dPowLen1 = (vmmptPoint[idxP1] - mmptN1).PowLen();
					// _xZkqqHx_jClMjApM_xHqqkZx_P1-P3_xZkqqHx_iBeC_xHqqkZx_
					const DBLLine dblLine13(vmmptPoint[idxP1], vmmptPoint[idxP3]);
					// _xZkqqHx_jClMjApM_xHqqkZx_P1-P3_xZkqqHx_iPoDiCmFiBeB_xHqqkZx_P2_xZkqqHx_iCmJiNmFiCoAiLnPiCkCjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
					DBLPoint mmptN2 = dblLine13.GetNearest(vmmptPoint[idxP2]);
					double dPowLen2 = (vmmptPoint[idxP2] - mmptN2).PowLen();
					if (dPowLen1 < dPowLen2)
					{
						vmmptPoint.erase(&vmmptPoint[idxP1]);
						vIsJoint.erase(&vIsJoint[idxP1]);
					} else
					{
						vmmptPoint.erase(&vmmptPoint[idxP2]);
						vIsJoint.erase(&vIsJoint[idxP2]);
					}
				}
			} else
			//----- _xZkqqHx_jHnHiCoIiNiHiCkEjDpBiCmCiCmMiDhMiDeDiDjDiDgHiCkKiLnPjAnKiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				lIndex++;
			}
		}
	} while(bErased);
} // FFOmitClosePoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFOmitAngle0Point
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHnHiCoIiNiHiCkEjDpBiCmCiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIiCkKjDkPiClGiPoKiNiHiCmNiBeBiIoKiCmCiCmJiCnMiCmGiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeCiPmIjHkKiClFiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLineAngle	:_xZkqqHx_jApMjFkKiCmMiKhAjDhIjEhKjHpBiCpAiOhHjCoIiBeCiPmIjHkKiClFiClNiKhAjDhIjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			dAnglePlay	:_xZkqqHx_iKhAjDhIiNlHiKoOiPiAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_[0,2_xZkqqHx_iDmO_xHqqkZx_]_xZkqqHx_iBeCjHnHiCoIiNiHiCkEjApMjFkKiCmM_xHqqkZx_
 *						 _xZkqqHx_iKhAjDhIiNlHiCkKiClBiCmMjCgMjGkCjGjOiCmIiCoHiCmOjDjJiClFiCkCiCmGjElLjCgGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjAhNiCfAiCmMiPoKiNiHiBeB_xHqqkZx_P5,P6_xZkqqHx_iCkKiPmIjHkKiClDiCoKiCmEjAhNiCfBiCmMiCoGiCkEiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 *                P3    P4
 *                _xZkqqHx_iBkF_xHqqkZx_ L3 _xZkqqHx_iBkF_xHqqkZx_
 *             L2_xZkqqHx_iBfOiBfAiBfAiBfAiBfP_xHqqkZx_L4
 *         P2_xZkqqHx_iBkDiBfO_xHqqkZx_          _xZkqqHx_iBfPiBkD_xHqqkZx_P5
 *          L1_xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBfP_xHqqkZx_L5
 *            _xZkqqHx_iEkA_xHqqkZx_               _xZkqqHx_iBfPiBkD_xHqqkZx_P6
 *         P1_xZkqqHx_iBkFiBfP_xHqqkZx_                _xZkqqHx_iBfP_xHqqkZx_L6
 *             L0_xZkqqHx_iBfP_xHqqkZx_                _xZkqqHx_iBfPiBkD_xHqqkZx_P7
 *                _xZkqqHx_iBkD_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_L7
 *                P0                _xZkqqHx_iEkA_xHqqkZx_
 *                                   _xZkqqHx_iBkF_xHqqkZx_P8
 *                      _xZkqqHx_jAhNiCfA_xHqqkZx_
 *
 *
 *                P3    P4
 *                _xZkqqHx_iBkF_xHqqkZx_ L3 _xZkqqHx_iBkF_xHqqkZx_
 *             L2_xZkqqHx_iBfOiBfAiBfAiBfAiBfP_xHqqkZx_
 *         P2_xZkqqHx_iBkDiBfO_xHqqkZx_          _xZkqqHx_iBfP_xHqqkZx_
 *          L1_xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBfP_xHqqkZx_L4
 *            _xZkqqHx_iEkA_xHqqkZx_               _xZkqqHx_iBfP_xHqqkZx_
 *         P1_xZkqqHx_iBkFiBfP_xHqqkZx_                _xZkqqHx_iBfP_xHqqkZx_
 *             L0_xZkqqHx_iBfP_xHqqkZx_                _xZkqqHx_iBfPiBkD_xHqqkZx_P5
 *                _xZkqqHx_iBkD_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_L5
 *                P0                _xZkqqHx_iEkA_xHqqkZx_
 *                                   _xZkqqHx_iBkF_xHqqkZx_P6
 *                      _xZkqqHx_jAhNiCfB_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFOmitAngle0Point (DBLPointVector& vmmptPoint,
						BYTEVector& vIsJoint,
						doubleVector& vLineAngle,
						double dAnglePlay)
{
	BOOL bErased;
	do {
		// vLineAngle[lIndex] _xZkqqHx_iCpAiNoNiPjMiClHiCoJiPoKiNiHiBeB_xHqqkZx_vLineAngle[lIndex-1]_xZkqqHx_iCmG_xHqqkZx_
		// vLineAngle[lIndex+1]_xZkqqHx_iCmMiKhAjDhIiCkKjDjJiClFiCkNiCmIiCoJiPoKiNiHiCoAiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCoKiCpAjClCiCnHiCoJiClNiCnPiBeBjDpBiPgEiDiLiBfLiDhGiCmGiClHiCoJiBeC_xHqqkZx_
		bErased = FALSE;
		long lIndex;
		for (lIndex = 0; vLineAngle.size() != 2 && lIndex < vLineAngle.size() - 1;)
		{
			if (fabs(FFAngleMinusPitoPi(vLineAngle[lIndex + 1] - vLineAngle[lIndex])) < dAnglePlay)
			//----- _xZkqqHx_jHnHiCoIiNiHiCkEjDpBiCmCiCmMjApMjFkKiCmMiKhAjDhIiCkKjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
			{
				bErased = TRUE;
				vLineAngle.erase(&vLineAngle[lIndex + 1]);
				vmmptPoint.erase(&vmmptPoint[lIndex + 1]);
				vIsJoint.erase(&vIsJoint[lIndex + 1]);
				const DBLPoint mmptL = vmmptPoint[lIndex + 1] - vmmptPoint[lIndex];
				vLineAngle[lIndex] = atan2(mmptL.y, mmptL.x);
			} else
			//----- _xZkqqHx_jHnHiCoIiNiHiCkEjDpBiCmCiCmMiDhMiDeDiDjDiDgHiCkKiLnPjAnKiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				lIndex++;
			}
		}
	} while(bErased);
} // FFOmitAngle0Point.
