#include "stdafx.h"

//----------<NOT EXPORT TO VIEWER>-----------

#include <algorithm>		// For sort template.
#include <float.h>			// For DBL_MAX.
#include "PolyJoint.h"		// For FCPolyJoint.
#include "DBLShortLine.h"	// For DBLShortLine.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilErr.h"		// For FFThrowMiscUnknown().
//----------</NOT EXPORT TO VIEWER>-----------
#include "UtilMisc.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef _DEBUG

////////////////////////////////////////////////////////////////////////
// FCCheckTime_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_

FCCheckTime::FCCheckTime (const wchar_t* wcpMessage)
			:	m_strMessage(WStrToTStr(wcpMessage))
{
	m_fdtmBegin = FFGetCurrentTime();
} // FCCheckTime::FCCheckTime.

FCCheckTime::~FCCheckTime ()
{
	FDTIME fdtmPass = FFGetCurrentTime() - m_fdtmBegin;
	TRACE(	_T("%s %I64d %f\r\n"),
			m_strMessage,
			fdtmPass,
			double(long(fdtmPass)) / 10000000.0);
} // FCCheckTime::~FCCheckTime.

#endif//_DEBUG

//;----- <EXPORT TO SERVER> -----;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFVersionInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	FFVersionInfo()_xZkqqHx_iCmMiDiBiDjDiDgPiPoOjFpB_xHqqkZx_
 *			
 *			FFVersionInfo().dwMajorVersion]
 *			WindowsNT3.51	3
 *			WindowsNT4.0	4
 *			Windows2000		5
 *			Windows95		4
 *			Windows98		4
 *			WindowsMe		4
 *			
 *			FFVersionInfo().dwMinorVersion]
 *			WindowsNT3.51	51
 *			WindowsNT4.0	0
 *			Windows2000		0
 *			Windows95		0
 *			Windows98		10
 *			WindowsMe		90
 *			
 *			FFVersionInfo().dwBuildNumber]
 *			_xZkqqHx_jFhDjGlOiBeC_xHqqkZx_
 *			
 *			FFVersionInfo().dwPlatformId]
 *			WindowsNT3.51	VER_PLATFORM_WIN32_NT
 *			WindowsNT4.0	VER_PLATFORM_WIN32_NT
 *			Windows2000		VER_PLATFORM_WIN32_NT
 *			Windows95		VER_PLATFORM_WIN32_WINDOWS
 *			Windows98		VER_PLATFORM_WIN32_WINDOWS
 *			WindowsMe		VER_PLATFORM_WIN32_WINDOWS
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const OSVERSIONINFO& FFVersionInfo ()
{
	//
	// FFVersionInfo()_xZkqqHx_iCmMiDiBiDjDiDgPiPoOjFpB_xHqqkZx_
	//
	// [FFVersionInfo().dwMajorVersion]
	//   WindowsNT3.51	3
	//   WindowsNT4.0	4
	//   Windows2000	5
	//   Windows95		4
	//   Windows98		4
	//   WindowsMe		4
	//
	// [FFVersionInfo().dwMinorVersion]
	//   WindowsNT3.51	51
	//   WindowsNT4.0	0
	//   Windows2000	0
	//   Windows95		0
	//   Windows98		10
	//   WindowsMe		90
	//
	// [FFVersionInfo().dwBuildNumber]
	// _xZkqqHx_jFhDjGlOiBeC_xHqqkZx_
	//
	// [FFVersionInfo().dwPlatformId]
	//   WindowsNT3.51	VER_PLATFORM_WIN32_NT
	//   WindowsNT4.0	VER_PLATFORM_WIN32_NT
	//   Windows2000	VER_PLATFORM_WIN32_NT
	//   Windows95		VER_PLATFORM_WIN32_WINDOWS
	//   Windows98		VER_PLATFORM_WIN32_WINDOWS
	//   WindowsMe		VER_PLATFORM_WIN32_WINDOWS
	//

	static OSVERSIONINFO s_versionInfo = { 0, 0, 0, 0, 0, { _T('\x00') } };
	if (s_versionInfo.dwOSVersionInfoSize == 0)
	{
		s_versionInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		// OS_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiPoOjFpBiOoGjDlOiBeC_xHqqkZx_
		::GetVersionEx(&s_versionInfo);
	}
	return s_versionInfo;
} // FFVersionInfo ().

//;----- </EXPORT TO SERVER> -----;

//----- Capture_xZkqqHx_iKnGjIeBiKnGjAjE_xHqqkZx_ -----

// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAiDeMiDiDiDhGiDgAiDiDjCiGiCmJiBeBiDeBiDeOiDgFiDeCiDhFiCmIiDeBiDhGiDiKiCkKjAnIiCoIjBnGiCoNiCmBiClNiPoKiNiHiBeB_xHqqkZx_
// _xZkqqHx_iDeMiDiDiDhGiDgAiDiDiCmNiJpAiPjMiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
// _xZkqqHx_iNmEiCnBiClBiCmMiDeBiDhGiDiKiCkKiDeBiDeOiDgFiDeCiDhFiCmJiCmIiCmBiClNiOjOiBeBiDeMiDiDiDhGiDgAiDiDiDeFiDeCiDjDiDgIiDeFiCpA_xHqqkZx_
// _xZkqqHx_jFjMiKiIiClDiClJiCoJiInHiCmJiBeBiClBiCoKiCoHiCmMiKnGjAjEiCpAjHhAiInDiClFiClNiBeC_xHqqkZx_

// _xZkqqHx_iMlLiNnNiDeMiDiDiDhGiDgAiDiDiClDiCoKiCmEiCoJiDgOiDfJiCmMiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//static HWND s_hwndCapture = NULL;
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
static vector<HWND> s_vHwndCapture;
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetCapture
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeMiDiDiDhGiDgAiDiDiDeFiDeCiDjDiDgIiDeFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeMiDiDiDhGiDgAiDiDiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HWND FFGetCapture ()
{
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return s_hwndCapture;
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (s_vHwndCapture.empty())
		return NULL;
	else
		return s_vHwndCapture.back();
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFGetCapture.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetCapture
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeMiDiDiDhGiDgAiDiDiDeFiDeCiDjDiDgIiDeFiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDeMiDiDiDhGiDgAiDiDjCiGiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSetCapture (HWND hwnd)
{
	TRACE(_T("FFSetCapture\n"));
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	s_hwndCapture = hwnd;
//	SetCapture(s_hwndCapture);
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	s_vHwndCapture.push_back(hwnd);
	SetCapture(s_vHwndCapture.back());
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFSetCapture.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFReleaseCapture
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDeMiDiDiDhGiDgAiDiDiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFReleaseCapture ()
{
	TRACE(_T("FFReleaseCapture\n"));
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	s_hwndCapture = NULL;
//	ReleaseCapture();
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (s_vHwndCapture.empty())
		FFThrowMiscUnknown();

	s_vHwndCapture.pop_back();
	if (s_vHwndCapture.empty())
		ReleaseCapture();
	else
		SetCapture(s_vHwndCapture.back());
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFReleaseCapture.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFUpdateCapture
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDhGiDiKiCkKiDeBiDeOiDgFiDeCiDhFiCmJiCmIiCmBiClNiOjOjDjJiBeBiDeMiDiDiDhGiDgAiDiDiCpAjFjMiKiIiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFUpdateCapture ()
{
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (s_hwndCapture != NULL && s_hwndCapture != GetCapture())
//		SetCapture(s_hwndCapture);
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!s_vHwndCapture.empty() && s_vHwndCapture.back() != GetCapture())
		SetCapture(s_vHwndCapture.back());
//----- 06.04.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFUpdateCapture.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLoadLibrary
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDgJiDhOiDgCiDeO_xHqqkZx_ _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ _xZkqqHx_iDiJiDeDiDhFiDiJiDiK_xHqqkZx_ (DLL) _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCpAjDmHiCnNiNjOiCnNiBeB_xHqqkZx_
 *			_xZkqqHx_iOfBiPmGiDeKiDeFiDjDiDgHiCpAiDeDiDjDiDeOiDiKiDiBiDjDiDgHiClFiCnMiClHiBeCiKpJiCmJjDmHiCnNiNjOiCnNiNmPiCnNiCmMiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iOfBiPmGiDeKiDeFiDjDiDgHiCmMiDeDiDjDiDeOiDiKiDiBiDjDiDgHiCmMiCnNiNhDiCkCiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpModuleName	:DLL_xZkqqHx_iCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiPeJjHlJiClFiClNiPoKiNiHiCmNiBeBiDiCiDfHiDiFiBfLiDiLiCnGiCmMiDgOiDjDiDgIiDiLiCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmFiDhNiDiLiDgAiDfIiDiMiDgCiDgIiCpAiOgHjHhAiClFiBeBjDkOjDeJiCmJiKgHjCkD_xHqqkZx_ DLL _xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_jDmHiCnNiNjOiCnOiPoKiNiHiBeB_xHqqkZx_FreeLibrary_xZkqqHx_iKnGjAjEiCkIiCoGiCnB_xHqqkZx_ LoadLibrary_xZkqqHx_iKnGjAjEiCmMjBoDiCoNiCoIiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_jFeLiClI_xHqqkZx_ AfxFreeLibrary _xZkqqHx_iCmG_xHqqkZx_ AfxLoadLibrary _xZkqqHx_iCpAiOgHjHhAiClHiCoJjFeLjHhGiCkKiCkAiCoIiCnMiClHiBeC_xHqqkZx_
 *			AfxLoadLibrary _xZkqqHx_iCmG_xHqqkZx_ AfxFreeLibrary _xZkqqHx_iCpAiOgHjHhAiClHiCoJiClBiCmGiCmJiCoGiCmBiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iKgHjCkD_xHqqkZx_ DLL _xZkqqHx_iCmMjDmHiCnNiNjOiCnNiCnMiClNiCmNiDeBiDjDiDiNiBfLiDgIiOjOiCmJiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iDfIiDfOiBfLiDgHiDeBiDgCiDhG_xHqqkZx_ _xZkqqHx_iDfCiBfLiDgIiCmGiPeJjHlJiDfCiBfLiDgIiCkKiBeBiDePiDiNiBfLiDgPiDiLiCmI_xHqqkZx_ MFC
 *			_xZkqqHx_iCmMiPpDjBnEiCpAjEgKjBlJiClHiCoJiCmMiCpAjGgIiCkMiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HINSTANCE FFLoadLibrary (const wchar_t* wcpModuleName)
{
#ifdef _AFXDLL
	return AfxLoadLibrary(WStrToTStr(wcpModuleName));
#else //_AFXDLL
	return ::LoadLibrary(WStrToTStr(wcpModuleName));
#endif//_AFXDLL
} // FFLoadLibrary.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFreeLibrary
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDfPiDeDiDgJiDhOiDgCiDeO_xHqqkZx_ _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ _xZkqqHx_iDiJiDeDiDhFiDiJiDiK_xHqqkZx_ (DLL) _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_iOfBiPmGiDeKiDeFiDjDiDgHiCpAiDgGiDeOiDiKiDiBiDjDiDgHiClFiCnMiClHiBeCiOfBiPmGiDeKiDeFiDjDiDgHiCkK_xHqqkZx_ 0 _xZkqqHx_iCmJiCmIiCoJiCmGiBeB_xHqqkZx_
 *			_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKiMmEiCnBiPgPiClFiDhGiDiNiDfKiDfIiCmMiDeBiDgIiDiMiDfIjHmMiIoGiCkJiCoHiJpAjFpKiClDiCoKiBeB_xHqqkZx_
 *			_xZkqqHx_iDgOiDjDiDgIiDiLiCkKjGlDiMpIiCmJiCmIiCoIiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hInstLib	:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDiJiDeDiDhFiDiJiDiK_xHqqkZx_ _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiPeJjHlJiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeCiClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFFreeLibrary (HINSTANCE hInstLib)
{
#ifdef _AFXDLL
	return AfxFreeLibrary(hInstLib);
#else //_AFXDLL
	return ::FreeLibrary(hInstLib);
#endif//_AFXDLL
} // FFFreeLibrary.

//----------<NOT EXPORT TO VIEWER>-----------

//----- 05.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 02.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDgFiDfIiDgH_xHqqkZx_)-----
//void FFSmoothMm2Lg (CPointVector& vlgpt, const DBLPointVector& vmmpt,
//					BOOL bIsClose, const mmetol mmElemLen, double dZoom)
//{
//	const mmetol mmElemPowMin = mmElemLen * 0.5 * mmElemLen * 0.5;
//	const mmetol mmElemPowMax = mmElemLen * 2.0 * mmElemLen * 2.0;
//	DBLPoint mmptPrev = vmmpt[0];
//	long lBestC = -1;
//	mmetol mmElemPowBest = DBL_MAX;
//	for (long lC = 1; lC != vmmpt.size(); lC++)
//	{
//		const mmetol mmElemPow = (mmptPrev - vmmpt[lC]).PowLen();
//		if (mmElemPow < mmElemPowMin)
//		{
//			continue;
//		}
//		else if (mmElemPow < mmElemPowMax)
//		{
//			if (mmElemPow <= mmElemPowBest)
//			{
//				mmElemPowBest = mmElemPow;
//				lBestC = lC;
//			}
//		} else
//		{
//			vlgpt.push_back(mm2lg(vmmpt[lBestC], dZoom));
//			mmptPrev = vmmpt[lBestC];
//			lC = lBestC;
//			lBestC = -1;
//			mmElemPowBest = DBL_MAX;
//		}
//	}
//	if (lBestC != -1)
//	{
//		vlgpt.push_back(mm2lg(vmmpt[lBestC], dZoom));
//	}
//	if (vlgpt.back() != mm2lg(vmmpt.back()))
//	{
//		vlgpt.push_back(mm2lg(vmmpt.back(), dZoom));
//	}
//} // FFSmoothMm2Lg.
////----- 02.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDgFiDfIiDgH_xHqqkZx_)-----
//----- 05.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RotateConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpBjDfNjFmPiKlHiCmMiMoDiCmMiNmAjFfHjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaTarg	: _xZkqqHx_jFmPiKlHjBmOiPnLiCmMiNmAjFfH_xHqqkZx_(_xZkqqHx_jEhKjHpB_xHqqkZx_)
 *			lTarg		: mmptaTarg_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *			dSin		: _xZkqqHx_iJpBjDfNiKhAiCmM_xHqqkZx_SIN_xZkqqHx_jCgM_xHqqkZx_
 *			dCos		: _xZkqqHx_iJpBjDfNiKhAiCmM_xHqqkZx_COS_xZkqqHx_jCgM_xHqqkZx_
 *			mmRotCenterX: _xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
 *			mmRotCenterY: _xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_217_xZkqqHx_iBgA_xHqqkZx_219_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_.
 *			DBL_MAX_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiClLiCmMiCnMiCnMiOgDiClHiBeC_xHqqkZx_
 *************************************************************************/
void RotateConv (DBLPoint mmptaTarg[], long lTarg,
				double dSin, double dCos, double mmRotCenterX,
				double mmRotCenterY)
{
	while (0 < lTarg--)
	{
		if (mmptaTarg[lTarg].x != DBL_MAX)
			RotateConv(mmptaTarg[lTarg], dSin, dCos, mmRotCenterX, mmRotCenterY);
	}
} // RotateConv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFResizePolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCpAiBeBjHfOiCkGiCoHiCoKiClNiDfEiDeDiDfJiCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt		:_xZkqqHx_jFmPiKlHjBePiCmMiDhMiDiKiDfDiDjDjEhKjHpBiCpAiOhHjCoIiBeCjFmPiKlHiMoDiCmMiDhMiDiKiDfDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lPolySize	:_xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtFrameOld:_xZkqqHx_jFmPiKlHjBePiCmMiDhEiDiMiBfLiDiAiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bXPosi		:_xZkqqHx_jFmPiKlHiOjOiCmMjAiFjFlNjFpLiMpMiCmMjElNjDfNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bYPosi		:_xZkqqHx_jFmPiKlHiOjOiCmMjAiCjClMjFpLiMpMiCmMjElNjDfNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtFrameNew:_xZkqqHx_jFmPiKlHiMoDiCmMiDhEiDiMiBfLiDiAiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmpt_xZkqqHx_iCkK_xHqqkZx_DBL_MAX_xZkqqHx_iCmFiLoGjAnIiCoHiCoKiClNjFkBjAjEiCmMiDhMiDiKiDfDiDjDjEhKjHpBiCmMiPoKiNiHiBeB_xHqqkZx_
 *			DBL_MAX_xZkqqHx_iCmFiLoGjAnIiCoHiCoKiClNjFkBjAjEiCmMiDhMiDiKiDfDiDjDjEhKjHpBiCmJjFkKiKiEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFResizePolygon (	DBLPoint mmpt[],
						long lPolySize,
						const DBLRect& mmrtFrameOld,
						BOOL bXPosi, BOOL bYPosi,
						const DBLRect& mmrtFrameNew)
{
	// _xZkqqHx_iDiKiDfEiDeDiDfJjEoEjHkGiBeC_xHqqkZx_
	double dAx, dAy;
	if (almost0(mmrtFrameOld.Width()))
		dAx = 1.0;
	else
		dAx = mmrtFrameNew.Width() / mmrtFrameOld.Width();
	if (almost0(mmrtFrameOld.Height()))
		dAy = 1.0;
	else
		dAy = mmrtFrameNew.Height() / mmrtFrameOld.Height();
	mmetol mmBaseX = mmrtFrameNew.left;
	mmetol mmBaseY = mmrtFrameNew.top;
	if (!bXPosi)
	{
		dAx = -dAx;
		mmBaseX = mmrtFrameNew.right;
	}
	if (!bYPosi)
	{
		dAy = -dAy;
		mmBaseY = mmrtFrameNew.bottom;
	}
	for (long l = 0; l != lPolySize; l++)
	{
		if (mmpt[l].x != DBL_MAX)
			mmpt[l].x = mmBaseX + dAx * (mmpt[l].x - mmrtFrameOld.left);
		if (mmpt[l].y != DBL_MAX)
			mmpt[l].y = mmBaseY + dAy * (mmpt[l].y - mmrtFrameOld.top);
	}
} // FFResizePolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFResizePolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCpAiBeBjHfOiCkGiCoHiCoKiClNiDfEiDeDiDfJiCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgptaPoly	: _xZkqqHx_jFmPiKlHiMoDiCmMiDhMiDiKiDfDiDjDjEhKjHpBiCpAjFnEiClH_xHqqkZx_._xZkqqHx_jIfPjHjNiNmAjFfH_xHqqkZx_.
 *			lPolySize	: _xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCmMiDfEiDeDiDfJ_xHqqkZx_
 *			mmptaPoly	: _xZkqqHx_jFmPiKlHjBePiCmMiDhMiDiKiDfDiDjDjEhKjHpB_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *			mmrtFrame	: _xZkqqHx_jFmPiKlHjBePiCmMiDhMiDiKiDfDiDjDjEhKjHpBiCmMiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *			bXPosi		: _xZkqqHx_jFmPiKlHiOjOiCmMjAiFjFlNjFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			bYPosi		: _xZkqqHx_jFmPiKlHiOjOiCmMjAiCjClMjFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			mmrtResize	: _xZkqqHx_jFmPiKlHiMoDiCmMiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmptaPoly_xZkqqHx_iCkK_xHqqkZx_DBL_MAX_xZkqqHx_iCmFiLoGjAnIiCoHiCoKiClNjFkBjAjEiCmMiDhMiDiKiDfDiDjDjEhKjHpBiCmMiPoKiNiHiBeB_xHqqkZx_
 *			LONG_MAX_xZkqqHx_iCmFiLoGjAnIiCoHiCoKiClNjFkBjAjEiCmMiDhMiDiKiDfDiDjDjEhKjHpBiCmJjFkKiKiEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.xx Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			98.10.10 Fukushiro M. ObjDynabase_xZkqqHx_iCkJiCoH_xHqqkZx_Tool_xZkqqHx_iCnGiInKjDkO_xHqqkZx_.
 *************************************************************************/
void FFResizePolygon (	CPoint lgptaPoly[],
						long lPolySize, const DBLPoint mmptaPoly[],
						const DBLRect& mmrtFrame,
						BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtResize)
{
//----- 05.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiKiDfEiDeDiDfJjEoEjHkGiBeC_xHqqkZx_
//	double dAX, dAY;
//	if (almost0(mmrtFrame.Width()))
//		dAX = 1.0;
//	else
//		dAX = mmrtResize.Width() / mmrtFrame.Width();
//	if (almost0(mmrtFrame.Height()))
//		dAY = 1.0;
//	else
//		dAY = mmrtResize.Height() / mmrtFrame.Height();
//
//	if (bXPosi)
//	{
//		for (long l = 0; l != lPolySize; l++)
//		{
//			if (mmptaPoly[l].x != DBL_MAX)
//			{
//				mmetol mmDX = dAX * (mmptaPoly[l].x - mmrtFrame.left);
//				lgptaPoly[l].x = mm2lg(mmrtResize.left + mmDX);
//			} else
//			{
//				lgptaPoly[l].x = LONG_MAX;
//			}
//		}
//	} else
//	{
//		for (long l = 0; l != lPolySize; l++)
//		{
//			if (mmptaPoly[l].x != DBL_MAX)
//			{
//				mmetol mmDX = dAX * (mmptaPoly[l].x - mmrtFrame.left);
//				lgptaPoly[l].x = mm2lg(mmrtResize.right - mmDX);
//			} else
//			{
//				lgptaPoly[l].x = LONG_MAX;
//			}
//		}
//	}
//	if (bYPosi)
//	{
//		for (long l = 0; l != lPolySize; l++)
//		{
//			if (mmptaPoly[l].y != DBL_MAX)
//			{
//				mmetol mmDY = dAY * (mmptaPoly[l].y - mmrtFrame.top);
//				lgptaPoly[l].y = mm2lg(mmrtResize.top + mmDY);
//			} else
//			{
//				lgptaPoly[l].y = LONG_MAX;
//			}
//		}
//	} else
//	{
//		for (long l = 0; l != lPolySize; l++)
//		{
//			if (mmptaPoly[l].y != DBL_MAX)
//			{
//				mmetol mmDY = dAY * (mmptaPoly[l].y - mmrtFrame.top);
//				lgptaPoly[l].y = mm2lg(mmrtResize.bottom - mmDY);
//			} else
//			{
//				lgptaPoly[l].y = LONG_MAX;
//			}
//		}
//	}
//----- 05.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DBLPointVector vmmpt(mmptaPoly, mmptaPoly + lPolySize);
	FFResizePolygon(vmmpt.begin(), lPolySize, mmrtFrame, bXPosi, bYPosi, mmrtResize);
	for (long l = 0; l != lPolySize; l++)
	{
		if (vmmpt[l].x == DBL_MAX)
			lgptaPoly[l].x = LONG_MAX;
		else
			lgptaPoly[l].x = mm2lg(vmmpt[l].x);
		if (vmmpt[l].y == DBL_MAX)
			lgptaPoly[l].y = LONG_MAX;
		else
			lgptaPoly[l].y = mm2lg(vmmpt[l].y);
	}
//----- 05.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFResizePolygon.

//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IsPtInPolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCkKjHfOiCkGiCoHiCoKiClNiDhMiDiKiDfDiDjDiCmMjDoAjBkEiCmJiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaP	: _xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPjEhKjHpB_xHqqkZx_
 *			lP		: mmptaP_xZkqqHx_iCmMjAjE_xHqqkZx_
 *			mmptA	: _xZkqqHx_jClCiCnHiCoJjDfP_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_jDfPiCmNiDhMiDiKiDfDiDjDiCmMjDoAjBkE_xHqqkZx_
 *			FALSE	: _xZkqqHx_jDfPiCmNiDhMiDiKiDfDiDjDiCmMiKePjBkE_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P148,P232. _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCmMiNlGiCmJiCkCiCkNiCmCjApMiCkKiCkAiCoJiCkJiCpAjAjEiCkGiCmEiBeBiKoPjAjE_xHqqkZx_
 *			_xZkqqHx_iCmIiCoHiCmOjDfP_xHqqkZx_A_xZkqqHx_iCmNiDhMiDiKiDfDiDjDjDoAiCmJiCkAiCoJiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.26 Fukushiro M. _xZkqqHx_iJpAjAoAiCpAjCmHiJmB_xHqqkZx_.
 *************************************************************************/
extern BOOL IsPtInPolygon (const DBLPoint mmptaP[], long lP,
							const DBLPoint& mmptA)
{
	DBLPoint	mmptP0, mmptP1;
	short		nL = 0;
	double		mmX;
	long		l;

	if (mmptaP[0] == mmptaP[lP - 1])
	{
		mmptP0 = mmptaP[0];
		l = 1;
	} else
	{
		mmptP0 = mmptaP[lP - 1];
		l = 0;
	}

	for (; l < lP; l++)
	{
		mmptP1 = mmptaP[l];

		if ((mmptP0.y == mmptA.y) && (mmptA.y == mmptP1.y))
		/*----- _xZkqqHx_jApMiCkKjAiFjFlNiCkJiCmC_xHqqkZx_ A _xZkqqHx_iCkKjApMiPoDiCmMiPoKiNiH_xHqqkZx_ -----*/
		{
			// mmptA_xZkqqHx_iCmNjApMiPoD_xHqqkZx_?.
			if ((mmptP0.x <= mmptA.x && mmptA.x <= mmptP1.x) ||
				(mmptP1.x <= mmptA.x && mmptA.x <= mmptP0.x)) return TRUE;

		} else if ((mmptP1.y < mmptA.y && mmptA.y <= mmptP0.y) ||
				   (mmptP0.y < mmptA.y && mmptA.y <= mmptP1.y))
		/*-----  P1 _xZkqqHx_iCoGiCoI_xHqqkZx_ P0 _xZkqqHx_iCkKiJlKiBeBiKiOiCmC_xHqqkZx_ A _xZkqqHx_iCkK_xHqqkZx_ P1 _xZkqqHx_iCmG_xHqqkZx_ P0 _xZkqqHx_iCmMiKnE_xHqqkZx_ _xZkqqHx_iIlNiCmN_xHqqkZx_ P0 _xZkqqHx_iPoD_xHqqkZx_ _xZkqqHx_iIlNiCmN_xHqqkZx_
				 P0 _xZkqqHx_iCoGiCoI_xHqqkZx_ P1 _xZkqqHx_iCkKiJlKiBeBiKiOiCmC_xHqqkZx_ A _xZkqqHx_iCkK_xHqqkZx_ P0 _xZkqqHx_iCmG_xHqqkZx_ P1 _xZkqqHx_iCmMiKnE_xHqqkZx_ _xZkqqHx_iIlNiCmN_xHqqkZx_ P1 _xZkqqHx_iPoD_xHqqkZx_ -----*/
		{
			// mmX_xZkqqHx_iCmF_xHqqkZx_mmptA.y_xZkqqHx_iCmMjAiFjFlNjApMiCmGiMpAiNlD_xHqqkZx_.
			mmX = mmptP0.x + (mmptP1.x - mmptP0.x) *
						(mmptA.y - mmptP0.y) / (mmptP1.y - mmptP0.y);
			// mmptA_xZkqqHx_iCmNjApMiPoD_xHqqkZx_?.
			if (mmX == mmptA.x) return TRUE;
			if (mmX < mmptA.x) nL++;
		}

		mmptP0 = mmptP1;
	}

	if (nL & 1)	return TRUE;
	return FALSE;
} // IsPtInPolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcPowDistance
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_P_xZkqqHx_iCmJiCoAiCmBiCmGiCoAiLnPiCkCjApMjFkK_xHqqkZx_OA_xZkqqHx_iPoDiCmMjDfP_xHqqkZx_S_xZkqqHx_iCmMiNmAjFfHiCpAiLiBiCnPiBeBjDfP_xHqqkZx_P_xZkqqHx_iCmGjDfP_xHqqkZx_S_xZkqqHx_iCmMiLjHjHkDiCmM_xHqqkZx_
 *			_xZkqqHx_jDpBiPoGiCpAjFnEiClHiBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P112,P220
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptS	: _xZkqqHx_jDfP_xHqqkZx_S_xZkqqHx_iCmMiNmAjFfH_xHqqkZx_
 *			mmptO	: _xZkqqHx_jApMjFkKiCmMiIoKjCfLiCmMiNmAjFfH_xHqqkZx_
 *			mmptA	: _xZkqqHx_jApMjFkKiCmMiIoKjCfLiCmMiNmAjFfH_xHqqkZx_
 *			mmptP	: _xZkqqHx_jDfP_xHqqkZx_P_xZkqqHx_iCmMiNmAjFfH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLjHjHkDiCmMjDpBiPoG_xHqqkZx_
 *************************************************************************/
double CalcPowDistance (DBLPoint& mmptS, const DBLPoint& mmptO,
						const DBLPoint& mmptA, const DBLPoint& mmptP)
{
	return CalcPowDistance(mmptS, mmptO, mmptA, (mmptA - mmptO).PowLen(), mmptP);
} // CalcPowDistance.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcPowDistance
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_P_xZkqqHx_iCmJiCoAiCmBiCmGiCoAiLnPiCkCjApMjFkK_xHqqkZx_OA_xZkqqHx_iPoDiCmMjDfP_xHqqkZx_S_xZkqqHx_iCmMiNmAjFfHiCpAiLiBiCnPiBeBjDfP_xHqqkZx_P_xZkqqHx_iCmGjDfP_xHqqkZx_S_xZkqqHx_iCmMiLjHjHkDiCmM_xHqqkZx_
 *			_xZkqqHx_jDpBiPoGiCpAjFnEiClHiBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P112,P220
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptS	:_xZkqqHx_jDfP_xHqqkZx_S_xZkqqHx_iCmMiNmAjFfHiBeC_xHqqkZx_
 *			mmptO	:_xZkqqHx_jApMjFkKiCmMiIoKjCfLiCmMiNmAjFfHiBeC_xHqqkZx_
 *			mmptA	:_xZkqqHx_jApMjFkKiCmMiIoKjCfLiCmMiNmAjFfHiBeC_xHqqkZx_
 *			mmOAPowLen	:_xZkqqHx_jApMjFkK_xHqqkZx_OA_xZkqqHx_iCmMjClHiClDiCmMjDpBiPoGiBeC_xHqqkZx_
 *			mmptP	:_xZkqqHx_jDfP_xHqqkZx_P_xZkqqHx_iCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLjHjHkDiCmMjDpBiPoG_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmOAPowLen_xZkqqHx_iCmF_xHqqkZx_OA_xZkqqHx_iCmMiLjHjHkDiCpAiKePjFjEiCkJiCoHjAnNjCoIiClFiCmEiCkCiCoJiCmMiCmNiBeB_xHqqkZx_mmptO_xZkqqHx_iCmG_xHqqkZx_
 *			mmptA_xZkqqHx_iCpAiMmFjCoIiCmFiJlNiJpBiCoAiOgHiCkEiPoKiNiHiCmMiMpIjHkGiCpAiNgMjHlGiClFiCmEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.04.21 Fukushiro M. mmOAPowLen=0_xZkqqHx_iCmMiPoKiNiHiCmMiPiIjHjNiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
double CalcPowDistance (DBLPoint& mmptS, const DBLPoint& mmptO,
						const DBLPoint& mmptA, const double& mmOAPowLen,
						const DBLPoint& mmptP)
{
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	double mmOP2 = (mmptP - mmptO).PowLen();
//	double mmAP2 = (mmptP - mmptA).PowLen();
//
//	if (mmAP2 + mmOAPowLen <= mmOP2)
//	{
//		mmptS = mmptA;
//		return mmAP2;
//	}
//	if (mmOP2 + mmOAPowLen <= mmAP2)
//	{
//		mmptS = mmptO;
//		return mmOP2;
//	}
//	ASSERT(!almost0(mmOAPowLen));
//	double dS = (mmOP2 - mmAP2 - mmOAPowLen) / (2.0 * mmOAPowLen);
//	mmptS = mmptA + dS * (mmptA - mmptO);
//	return (mmptP - mmptS).PowLen();
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!almost0(mmOAPowLen))
	//----- _xZkqqHx_jDfP_xHqqkZx_O_xZkqqHx_iCmGjDfP_xHqqkZx_A_xZkqqHx_iCkKjHkDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		double mmOP2 = (mmptP - mmptO).PowLen();
		double mmAP2 = (mmptP - mmptA).PowLen();
		if (mmAP2 + mmOAPowLen <= mmOP2)
		{
			mmptS = mmptA;
			return mmAP2;
		}
		if (mmOP2 + mmOAPowLen <= mmAP2)
		{
			mmptS = mmptO;
			return mmOP2;
		}
		double dS = (mmOP2 - mmAP2 - mmOAPowLen) / (2.0 * mmOAPowLen);
		mmptS = mmptA + dS * (mmptA - mmptO);
		return (mmptP - mmptS).PowLen();
	} else
	//----- _xZkqqHx_jDfP_xHqqkZx_O_xZkqqHx_iCmGjDfP_xHqqkZx_A_xZkqqHx_iCkKjDjJiClFiCkCiPoKiNiH_xHqqkZx_ -----
	{
		mmptS = mmptO;
		return (mmptP - mmptS).PowLen();
	}
//----- 05.04.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CalcPowDistance.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcPowDistance
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjApM_xHqqkZx_H_xZkqqHx_jCiGiCmFiBeBjDfP_xHqqkZx_P_xZkqqHx_iCmJiCoAiCmBiCmGiCoAiLnPiCkCjApMjFkK_xHqqkZx_A_xZkqqHx_iPoDiCmMjDfP_xHqqkZx_S_xZkqqHx_iCmMiNmAjFfHiCpAiLiBiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_jDfP_xHqqkZx_P_xZkqqHx_iCmGjDfP_xHqqkZx_S_xZkqqHx_iCmMiLjHjHkDiCmMjDpBiPoGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptS	: _xZkqqHx_jDfP_xHqqkZx_S_xZkqqHx_iCmMiNmAjFfH_xHqqkZx_
 *			mmptaH	: _xZkqqHx_jIeBiMiLjApM_xHqqkZx_H
 *			lH		: _xZkqqHx_jIeBiMiLjApMjCiGiCmMjDfPiCmMjAjE_xHqqkZx_
 *			mmptP	: _xZkqqHx_jDfP_xHqqkZx_P_xZkqqHx_iCmMiNmAjFfH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLjHjHkDiCmMjDpBiPoG_xHqqkZx_
 *************************************************************************/
double CalcPowDistance (DBLPoint& mmptS, const DBLPoint* mmptaH,
						long lH, const DBLPoint& mmptP)
{
	DBLPoint	mmptTmp;
	double	mmMin2, mmT2;
	mmMin2 = ::CalcPowDistance(mmptS, mmptaH[0], mmptaH[1], mmptP);

	for (long l = 2; l < lH; l++)
	{
		mmT2 = ::CalcPowDistance(mmptTmp, mmptaH[l-1], mmptaH[l], mmptP);
		if (mmT2 < mmMin2)
		{
			mmMin2 = mmT2;
			mmptS = mmptTmp;
		}
	}
	return mmMin2;
} // CalcPowDistance.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	ArcTan
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHfOiCkGiCoHiCoKiClN_xHqqkZx_X_xZkqqHx_iBeB_xHqqkZx_Y_xZkqqHx_iCmJiKoOiCmDiCkLiBeBiDeBiBfLiDeOiDfOiDjDiDfHiDeGiDjDiDgHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dX	: X
 *			dY	: Y
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiBfLiDeOiDfOiDjDiDfHiDeGiDjDiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	X,Y_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCmMjCgMiCkK_xHqqkZx_0_xZkqqHx_iCmFiCkAiCoJiClBiCmGiCmJiCoAjBmOiJjOiClHiCoJiBeC_xHqqkZx_X,Y_xZkqqHx_iCmMjHlMjFpLiCkK_xHqqkZx_0_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiBeB_xHqqkZx_0_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jFnEjCgMiCmNiBeB_xHqqkZx_[0.0, 2.0)_xZkqqHx_iCmMjEmNiImNiBeCjCfAiImKiCmN_xHqqkZx_ _xZkqqHx_iDiJiDfHiDeBiDjDiBfOiDmO_xHqqkZx_ _xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.01 Fukushiro M. _xZkqqHx_jFnEjCgMiCkK_xHqqkZx_ [0.0, 2.0)_xZkqqHx_iCmJiCmIiCoJiCoGiCkEiCmJiBeB_xHqqkZx_
 *								  _xZkqqHx_iDeBiDiLiDfDiDiKiDfJiDiAiCpAiPeDjAlDiBeC_xHqqkZx_atan2_xZkqqHx_iCpAjDlBjDpMiBeC_xHqqkZx_
 *************************************************************************/
double ArcTan (double dX, double dY)
{
	return ArcTan(DBLPoint(dX, dY));
} // ArcTan.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	ArcTan
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHfOiCkGiCoHiCoKiClN_xHqqkZx_X_xZkqqHx_iBeB_xHqqkZx_Y_xZkqqHx_iCmJiKoOiCmDiCkLiBeBiDeBiBfLiDeOiDfOiDjDiDfHiDeGiDjDiDgHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptL	:X,Y_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiBfLiDeOiDfOiDjDiDfHiDeGiDjDiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	X,Y_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCmMjCgMiCkK_xHqqkZx_0_xZkqqHx_iCmFiCkAiCoJiClBiCmGiCmJiCoAjBmOiJjOiClHiCoJiBeC_xHqqkZx_X,Y_xZkqqHx_iCmMjHlMjFpLiCkK_xHqqkZx_0_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiBeB_xHqqkZx_0_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jFnEjCgMiCmNiBeB_xHqqkZx_[0.0, 2.0)_xZkqqHx_iCmMjEmNiImNiBeCjCfAiImKiCmN_xHqqkZx_ _xZkqqHx_iDiJiDfHiDeBiDjDiBfOiDmO_xHqqkZx_ _xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double ArcTan (const DBLPoint& mmptL)
{
	if (almost0(mmptL)) return 0.0;
	// atan2_xZkqqHx_iCmNiDiJiDfHiDeBiDjDiCmIiCmMiCmFiBeBiDiJiDfHiDeBiDjD_xHqqkZx_/_xZkqqHx_iDmO_xHqqkZx_ _xZkqqHx_iCmJjFmPiKlHiBeC_xHqqkZx_
	// atan2_xZkqqHx_iCmN_xHqqkZx_[-_xZkqqHx_iDmO_xHqqkZx_, _xZkqqHx_iDmO_xHqqkZx_]_xZkqqHx_iCmIiCmMiCmFiBeB_xHqqkZx_[0.0, 2.0)_xZkqqHx_iCmJjFoCjAlDiBeC_xHqqkZx_
	return ::RegulateAngle(atan2(mmptL.y, mmptL.x) / M_PI);
} // ArcTan.

//----- 02.07.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	PolyIntersect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ptPos_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiClNiNmAjFfHiCkKiBeB_xHqqkZx_aPoint_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiClNjIeBiMiLjApMiPoDiCmM_xHqqkZx_
// *			_xZkqqHx_iLnPjGfEiCmJiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiLnPjGfEiCmGiCmNiBeBjApMiCmMiOpMiImNiCpA_xHqqkZx_ nW
// *			(_xZkqqHx_jApMiCmMjFjN_xHqqkZx_)_xZkqqHx_iCmMjEmNiImNiCmFjClCiCnHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iLnPjGfEiCmJjHeMiCoJiPoKiNiHiCmNiBeB_xHqqkZx_aPoint_xZkqqHx_iCmMiNmFiPiJiCmJiMpAiCoNiCmBiClNjApMiCmMjApMjEnEiNiGiCpAjFnEiClHiBeC_xHqqkZx_
// *			_xZkqqHx_iLnPjGfEiCmJjGlDiCkCiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ptPos	: _xZkqqHx_jClCiCnHiCoJjDfP_xHqqkZx_.
// *			aPoint	: _xZkqqHx_jIeBiMiLjApMiCpAiOhHjCoIiClHiCoJ_xHqqkZx_
// *			lPoint	: aPoint_xZkqqHx_jCiGiCmMiDhMiDeDiDjDiDgHjAjEiCpAiOhHjCoIiClHiCoJ_xHqqkZx_
// *			nW		: _xZkqqHx_jApMiCmMjFjNiCpAiOhHjCoIiClHiCoJ_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiCoNiCmBiClNjApMiCmMjEnEiNiGiCpAjFnEiClHiBeCiLnPjGfEiCmJjGlDiCkCiPoKiNiHiCmNiCePiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiBeB_xHqqkZx_aPoint[0]_xZkqqHx_iCmG_xHqqkZx_aPoint[1]_xZkqqHx_iCmMiKnEiCpAiMiLiCnEjApMiCmGiBeB_xHqqkZx_pPos_xZkqqHx_iCkKiMpAiCoNiCmBiCmE_xHqqkZx_
//			_xZkqqHx_iCkCiClNiPoKiNiHiBeBjFnEjCgMiCmN_xHqqkZx_"1"_xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
// *************************************************************************/
//LONG PolyIntersect (const CPoint& ptPos, const CPoint aPoint[], LONG lPoint, SHORT nW)
//{
//	int	nW2 = int((FLOAT)nW * 1.4);
//
//	CPoint	points[4];
//	long	lX0, lY0, lX1, lY1, lDX, lDY;
//
//	for (long l = 1; l < lPoint; l++)
//	{
//
//		/* _xZkqqHx_iCnMiClIiBeBjApMiCmMiNmAjFfHiCpAiChHiCmFjAlDiLeLiJlL_xHqqkZx_ */
//		if (aPoint[l-1].x < aPoint[l].x)
//		{
//			lX0 = aPoint[l-1].x;
//			lY0 = aPoint[l-1].y;
//			lX1 = aPoint[l].x;
//			lY1 = aPoint[l].y;
//		} else {
//			lX0 = aPoint[l].x;
//			lY0 = aPoint[l].y;
//			lX1 = aPoint[l-1].x;
//			lY1 = aPoint[l-1].y;
//		}
//		lDX = lX1 - lX0;
//		lDY = lY1 - lY0;
//
//		/* tan_xZkqqHx_iCkKiBiHiCmMiPoKiNiHiCmJjBmOiJjO_xHqqkZx_ */
//		if (lDX == 0)
//		{
//			if (0 < lDY)
//			{
//				points[0].x = lX0 - nW;
//				points[0].y = lY0 - nW;
//				points[1].x = lX0 + nW;
//				points[1].y = lY0 - nW;
//				points[2].x = lX0 + nW;
//				points[2].y = lY1 + nW;
//				points[3].x = lX0 - nW;
//				points[3].y = lY1 + nW;
//			} else {
//				points[0].x = lX0 - nW;
//				points[0].y = lY1 - nW;
//				points[1].x = lX0 + nW;
//				points[1].y = lY1 - nW;
//				points[2].x = lX0 + nW;
//				points[2].y = lY0 + nW;
//				points[3].x = lX0 - nW;
//				points[3].y = lY0 + nW;
//			}
//		} else {
//			float	fTan;
//			fTan = (float)lDY / (float)lDX;
//			if (fTan <= -2.41)
//			{
//				points[0].x = lX1 - nW;
//				points[0].y = lY1 - nW;
//				points[1].x = lX1 + nW;
//				points[1].y = lY1 - nW;
//				points[2].x = lX0 + nW;
//				points[2].y = lY0 + nW;
//				points[3].x = lX0 - nW;
//				points[3].y = lY0 + nW;
//			} else if (-2.14 < fTan && fTan < -0.41)
//			{
//				points[0].x = lX1;
//				points[0].y = lY1 - nW2;
//				points[1].x = lX1 + nW2;
//				points[1].y = lY1;
//				points[2].x = lX0;
//				points[2].y = lY0 + nW2;
//				points[3].x = lX0 - nW2;
//				points[3].y = lY0;
//			} else if (-0.41 <= fTan && fTan <= 0.41)
//			{
//				points[0].x = lX0 - nW;
//				points[0].y = lY0 + nW;
//				points[1].x = lX0 - nW;
//				points[1].y = lY0 - nW;
//				points[2].x = lX1 + nW;
//				points[2].y = lY1 - nW;
//				points[3].x = lX1 + nW;
//				points[3].y = lY1 + nW;
//			} else if (0.41 < fTan && fTan < 2.41)
//			{
//				points[0].x = lX0 - nW2;
//				points[0].y = lY0;
//				points[1].x = lX0;
//				points[1].y = lY0 - nW2;
//				points[2].x = lX1 + nW2;
//				points[2].y = lY1;
//				points[3].x = lX1;
//				points[3].y = lY1 + nW2;
//			} else
//			{
//				points[0].x = lX0 - nW;
//				points[0].y = lY0 - nW;
//				points[1].x = lX0 + nW;
//				points[1].y = lY0 - nW;
//				points[2].x = lX1 + nW;
//				points[2].y = lY1 + nW;
//				points[3].x = lX1 - nW;
//				points[3].y = lY1 + nW;
//			}
//		}
//		CRgn rgn;
//		rgn.CreatePolygonRgn(points, 4, ALTERNATE);
//
//		if (rgn.PtInRegion(ptPos))
//		{
//			return l;
//		}
//	}
//	return 0;
//} // PolyIntersect.
//----- 02.07.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPolyIntersect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	mmptPos_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiClNiNmAjFfHiCkKiBeB_xHqqkZx_mmptaPoint_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiClNjIeBiMiLjApMiPoDiCmM_xHqqkZx_
 *			_xZkqqHx_iLnPjGfEiCmJiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiLnPjGfEiCmGiCmNiBeBjApMiCmMiOpMiImNiCpA_xHqqkZx_ mmWidth
 *			(_xZkqqHx_jApMiCmMjFjN_xHqqkZx_)_xZkqqHx_iCmMjEmNiImNiCmFjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iLnPjGfEiCmJjHeMiCoJiPoKiNiHiCmNiBeB_xHqqkZx_mmptaPoint_xZkqqHx_iCmMiNmFiPiJiCmJiMpAiCoNiCmBiClNjApMiCmMjApMjEnEiNiGiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iLnPjGfEiCmJjGlDiCkCiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptptPos	:_xZkqqHx_jClCiCnHiCoJjDfPiBeC_xHqqkZx_
 *			mmptaPoint	:_xZkqqHx_jIeBiMiLjApMiCpAiOhHjCoIiClHiCoJ_xHqqkZx_
 *			lPoint		:aPoint_xZkqqHx_jCiGiCmMiDhMiDeDiDjDiDgHjAjEiCpAiOhHjCoIiClHiCoJ_xHqqkZx_
 *			mmWidth		:_xZkqqHx_jApMiCmMjFjNiCpAiOhHjCoIiClHiCoJ_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiCoNiCmBiClNjApMiCmMjEnEiNiGiCpAjFnEiClHiBeCiLnPjGfEiCmJjGlDiCkCiPoKiNiHiCmNiCePiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiBeB_xHqqkZx_aPoint[0]_xZkqqHx_iCmG_xHqqkZx_aPoint[1]_xZkqqHx_iCmMiKnEiCpAiMiLiCnEjApMiCmGiBeB_xHqqkZx_pPos_xZkqqHx_iCkKiMpAiCoNiCmBiCmE_xHqqkZx_
 *			_xZkqqHx_iCkCiClNiPoKiNiHiBeBjFnEjCgMiCmN_xHqqkZx_"1"_xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiClBiCmFiCmNiBeBjIfPjHjNiNmAjFfHiCmJjFmPiKlHiClFiCmEiCoA_xHqqkZx_CRgn::PtInRegion _xZkqqHx_iCmNiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
 *			95_xZkqqHx_iMgO_xHqqkZx_Windows_xZkqqHx_iCmFiCmMiNmAjFfHjCgMiCmMjAkHiMmAiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.07.21 Fukushiro M. _xZkqqHx_jFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
long FFPolyIntersect (const DBLPoint& mmptPos,
					const DBLPoint mmptaPoint[], long lPoint, mmetol mmWidth)
{
	// mmWidth _xZkqqHx_iCkK_xHqqkZx_45_xZkqqHx_jDhIiCmMiPoKiNiHiCmMjFjNiBeC_xHqqkZx_
	mmetol mmWidth2 = mmWidth * 1.41;
	DBLPoint mmptaRgn[4];
	mmetol mmX0, mmY0, mmX1, mmY1;

	for (long lC = 1; lC < lPoint; lC++)
	{
		// _xZkqqHx_iCnMiClIiBeBjApMiCmMiNmAjFfHiCpAiChHiCmFjAlDiLeLiJlLiBeC_xHqqkZx_
		if (mmptaPoint[lC - 1].x < mmptaPoint[lC].x)
		{
			mmX0 = mmptaPoint[lC - 1].x;
			mmY0 = mmptaPoint[lC - 1].y;
			mmX1 = mmptaPoint[lC].x;
			mmY1 = mmptaPoint[lC].y;
		} else
		{
			mmX0 = mmptaPoint[lC].x;
			mmY0 = mmptaPoint[lC].y;
			mmX1 = mmptaPoint[lC - 1].x;
			mmY1 = mmptaPoint[lC - 1].y;
		}
		mmetol mmDX = mmX1 - mmX0;
		mmetol mmDY = mmY1 - mmY0;
		// tan_xZkqqHx_iCkKiBiHiCmMiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
		if (rough0(mmDX))
		//----- mmDX _xZkqqHx_iCkKiCnMiCkAiCnMiCkA_xHqqkZx_0_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (0 < mmDY)
			{
				mmptaRgn[0].x = mmX0 - mmWidth;
				mmptaRgn[0].y = mmY0 - mmWidth;
				mmptaRgn[1].x = mmX0 + mmWidth;
				mmptaRgn[1].y = mmY0 - mmWidth;
				mmptaRgn[2].x = mmX0 + mmWidth;
				mmptaRgn[2].y = mmY1 + mmWidth;
				mmptaRgn[3].x = mmX0 - mmWidth;
				mmptaRgn[3].y = mmY1 + mmWidth;
			} else
			{
				mmptaRgn[0].x = mmX0 - mmWidth;
				mmptaRgn[0].y = mmY1 - mmWidth;
				mmptaRgn[1].x = mmX0 + mmWidth;
				mmptaRgn[1].y = mmY1 - mmWidth;
				mmptaRgn[2].x = mmX0 + mmWidth;
				mmptaRgn[2].y = mmY0 + mmWidth;
				mmptaRgn[3].x = mmX0 - mmWidth;
				mmptaRgn[3].y = mmY0 + mmWidth;
			}
		} else
		{
			double dTan = mmDY / mmDX;
			if (dTan <= -2.41)
			{
				mmptaRgn[0].x = mmX1 - mmWidth;
				mmptaRgn[0].y = mmY1 - mmWidth;
				mmptaRgn[1].x = mmX1 + mmWidth;
				mmptaRgn[1].y = mmY1 - mmWidth;
				mmptaRgn[2].x = mmX0 + mmWidth;
				mmptaRgn[2].y = mmY0 + mmWidth;
				mmptaRgn[3].x = mmX0 - mmWidth;
				mmptaRgn[3].y = mmY0 + mmWidth;
			} else
			if (-2.14 < dTan && dTan < -0.41)
			{
				mmptaRgn[0].x = mmX1;
				mmptaRgn[0].y = mmY1 - mmWidth2;
				mmptaRgn[1].x = mmX1 + mmWidth2;
				mmptaRgn[1].y = mmY1;
				mmptaRgn[2].x = mmX0;
				mmptaRgn[2].y = mmY0 + mmWidth2;
				mmptaRgn[3].x = mmX0 - mmWidth2;
				mmptaRgn[3].y = mmY0;
			} else
			if (-0.41 <= dTan && dTan <= 0.41)
			{
				mmptaRgn[0].x = mmX0 - mmWidth;
				mmptaRgn[0].y = mmY0 + mmWidth;
				mmptaRgn[1].x = mmX0 - mmWidth;
				mmptaRgn[1].y = mmY0 - mmWidth;
				mmptaRgn[2].x = mmX1 + mmWidth;
				mmptaRgn[2].y = mmY1 - mmWidth;
				mmptaRgn[3].x = mmX1 + mmWidth;
				mmptaRgn[3].y = mmY1 + mmWidth;
			} else
			if (0.41 < dTan && dTan < 2.41)
			{
				mmptaRgn[0].x = mmX0 - mmWidth2;
				mmptaRgn[0].y = mmY0;
				mmptaRgn[1].x = mmX0;
				mmptaRgn[1].y = mmY0 - mmWidth2;
				mmptaRgn[2].x = mmX1 + mmWidth2;
				mmptaRgn[2].y = mmY1;
				mmptaRgn[3].x = mmX1;
				mmptaRgn[3].y = mmY1 + mmWidth2;
			} else
			{
				mmptaRgn[0].x = mmX0 - mmWidth;
				mmptaRgn[0].y = mmY0 - mmWidth;
				mmptaRgn[1].x = mmX0 + mmWidth;
				mmptaRgn[1].y = mmY0 - mmWidth;
				mmptaRgn[2].x = mmX1 + mmWidth;
				mmptaRgn[2].y = mmY1 + mmWidth;
				mmptaRgn[3].x = mmX1 - mmWidth;
				mmptaRgn[3].y = mmY1 + mmWidth;
			}
		}
		if (IsPtInPolygon(mmptaRgn, 4, mmptPos)) return lC;
	}
	return 0;
} // FFPolyIntersect.
//----- 02.07.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcRoundy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHiCmMiKnLiClDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_mmptPrev, mmptNext_xZkqqHx_iCpAiKoOiCmJiBeB_xHqqkZx_pjTarget
			_xZkqqHx_iCmM_xHqqkZx_m_mmptPrev, m_mmptNext_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pjTarget	:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjDfPiCpAiOhHjCoIiBeCiIpIjDfPiCpAjAnNjCoIiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			mmptPrev	:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjBePiCmMjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptNext	:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiMoDiCmMjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nRound		:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiKnLiClDiBgJiCePiImIiPoDiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPgPjHmN_xHqqkZx_>	pjTarget.m_mmptPrev	: _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjDfPiCmMjBePiCnGiCmMiKnLiClD_xHqqkZx_
 *			pjTarget.m_mmptNext	: _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjDfPiCmMiMoDiCnGiCmMiKnLiClD_xHqqkZx_
 *************************************************************************/
void CalcRoundy (FCPolyJoint& pjTarget, const DBLPoint& mmptPrev,
				const DBLPoint& mmptNext, short nRound)
{
	DBLPoint mmptA, mmptC;

	mmptA = mmptPrev - pjTarget.m_mmptPivot;
	mmptC = mmptNext - pjTarget.m_mmptPivot;

	if ((almost0(mmptA.x) && almost0(mmptA.y)) ||
		(almost0(mmptC.x) && almost0(mmptC.y)))
	{
		pjTarget.m_mmptPrev.x = 0;
		pjTarget.m_mmptPrev.y = 0;
		pjTarget.m_mmptNext.x = 0;
		pjTarget.m_mmptNext.y = 0;
		return;
	}
	double dLab_bc = ::sqrt(mmptA.PowLen() / mmptC.PowLen());
	double dLbc_ab = 1 / dLab_bc;

	pjTarget.m_mmptNext = ((double)nRound / 100.0) * (mmptC - dLbc_ab * mmptA) / 2.0;
	pjTarget.m_mmptPrev = ((double)nRound / 100.0) * (mmptA - dLab_bc * mmptC) / 2.0;
} // CalcRoundy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	PolyCrossHoriz
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDfDiDjDiCmGjAiFjFlNjApMiCkKiDeOiDiNiDfIiClHiCoJjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiCpAiClHiCnHiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPjEhKjHpB_xHqqkZx_
 *			lPolySize	:mmptaPoly_xZkqqHx_iCmMjAjE_xHqqkZx_
 *			bIsClose	:_xZkqqHx_iDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCmIiCoHiCmO_xHqqkZx_TRUE.
 *			mmLY		:_xZkqqHx_jClCiCnHiCoJjAiFjFlNjApMiCmM_xHqqkZx_Y.
 *			mmvCrossX	:_xZkqqHx_iMpAiNlDiClHiCoJjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiCpAjFnEiClH_xHqqkZx_.X_xZkqqHx_iNmAjFfHiCmNiPlIiPiHiCmJiDfMiBfLiDgHiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P148,P232. mmptaPoly_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiCoJiDhMiDiKiDfDiDjDiCmGjAiFjFlNjApM_xHqqkZx_ mmLY
 *			_xZkqqHx_iCkKiDeOiDiNiDfIiClHiCoJjDfPiCpAiClHiCnHiCmEiMhGiOfKiClFiBeB_xHqqkZx_mmvCrossX_xZkqqHx_iCmJjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			98.11.22 Fukushiro M. WndRichEdit.cpp -> UtilMisc.cpp_xZkqqHx_iCnGiInKjDkO_xHqqkZx_.
 *************************************************************************/
void PolyCrossHoriz (	const DBLPoint mmptaPoly[],
						long lPolySize,
						BOOL bIsClose,
						double mmLY,
						doubleVector& mmvCrossX)
{
	DBLPoint	mmptP0, mmptP1;
	double		mmX;
	long		l;

	mmvCrossX.clear();

	if (bIsClose && mmptaPoly[0] != mmptaPoly[lPolySize - 1])
	{
		mmptP0 = mmptaPoly[lPolySize - 1];
		l = 0;
	} else
	{
		mmptP0 = mmptaPoly[0];
		l = 1;
	}

	for (; l < lPolySize; l++)
	{
		mmptP1 = mmptaPoly[l];

//----- 01.02.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if ((mmptP1.y < mmLY && mmLY <= mmptP0.y) ||
//			(mmptP0.y < mmLY && mmLY <= mmptP1.y))
//----- 01.02.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// P0,P1_xZkqqHx_iCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiCkKiKgNiOmAiCmJiInJiCmIiCoIiBeBiKnEiCmJ_xHqqkZx_LY_xZkqqHx_iCkKjBlGiNnNiClHiCoJiClBiCmGiBeC_xHqqkZx_
		if ((aboutless(mmptP1.y, mmptP0.y) && mmptP1.y < mmLY && mmLY <= mmptP0.y) ||
			(aboutless(mmptP0.y, mmptP1.y) && mmptP0.y < mmLY && mmLY <= mmptP1.y))
//----- 01.02.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		/*-----  P1 _xZkqqHx_iCoGiCoI_xHqqkZx_ P0 _xZkqqHx_iCkKiJlKiBeBiKiOiCmC_xHqqkZx_ L _xZkqqHx_iCkK_xHqqkZx_ P1 _xZkqqHx_iCmG_xHqqkZx_ P0 _xZkqqHx_iCmMiKnE_xHqqkZx_ _xZkqqHx_iIlNiCmN_xHqqkZx_ P0 _xZkqqHx_iPoD_xHqqkZx_ _xZkqqHx_iIlNiCmN_xHqqkZx_
				 P0 _xZkqqHx_iCoGiCoI_xHqqkZx_ P1 _xZkqqHx_iCkKiJlKiBeBiKiOiCmC_xHqqkZx_ L _xZkqqHx_iCkK_xHqqkZx_ P0 _xZkqqHx_iCmG_xHqqkZx_ P1 _xZkqqHx_iCmMiKnE_xHqqkZx_ _xZkqqHx_iIlNiCmN_xHqqkZx_ P1 _xZkqqHx_iPoD_xHqqkZx_ -----*/
		{
			// _xZkqqHx_jAiFjFlNjApM_xHqqkZx_ mmLY _xZkqqHx_iCmG_xHqqkZx_ P0-P1 _xZkqqHx_iCkKiMpAiNlDiClHiCoJ_xHqqkZx_ mmX _xZkqqHx_iCpAiOfKiPgP_xHqqkZx_.
			mmX = mmptP0.x + (mmptP1.x - mmptP0.x) *
						(mmLY - mmptP0.y) / (mmptP1.y - mmptP0.y);
			mmvCrossX.push_back(mmX);
		}
		mmptP0 = mmptP1;
	}
	sort(mmvCrossX.begin(), mmvCrossX.end());

} // PolyCrossHoriz.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	PolyCrossVert
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDfDiDjDiCmGjAiCjClMjApMiCkKiDeOiDiNiDfIiClHiCoJjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAiClHiCnHiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPjEhKjHpB_xHqqkZx_
 *			lPolySize	:mmptaPoly_xZkqqHx_iCmMjAjE_xHqqkZx_
 *			bIsClose	:_xZkqqHx_iDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCmIiCoHiCmO_xHqqkZx_TRUE.
 *			mmLX		:_xZkqqHx_jClCiCnHiCoJjAiCjClMjApMiCmM_xHqqkZx_X.
 *			mmvCrossY	:_xZkqqHx_iMpAiNlDiClHiCoJjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAjFnEiClH_xHqqkZx_.Y_xZkqqHx_iNmAjFfHiCmNiPlIiPiHiCmJiDfMiBfLiDgHiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P148,P232. mmptaPoly_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiCoJiDhMiDiKiDfDiDjDiCmGjAiCjClMjApM_xHqqkZx_ mmLX
 *			_xZkqqHx_iCkKiDeOiDiNiDfIiClHiCoJjDfPiCpAiClHiCnHiCmEiMhGiOfKiClFiBeB_xHqqkZx_mmvCrossY_xZkqqHx_iCmJjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void PolyCrossVert (const DBLPoint mmptaPoly[], long lPolySize, BOOL bIsClose,
					double mmLX, doubleVector& mmvCrossY)
{
	DBLPoint	mmptP0, mmptP1;
	double		mmY;
	long		l;

	mmvCrossY.clear();

	if (bIsClose && mmptaPoly[0] != mmptaPoly[lPolySize - 1])
	{
		mmptP0 = mmptaPoly[lPolySize - 1];
		l = 0;
	} else
	{
		mmptP0 = mmptaPoly[0];
		l = 1;
	}

	for (; l < lPolySize; l++)
	{
		mmptP1 = mmptaPoly[l];

//----- 01.02.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if ((mmptP1.x < mmLX && mmLX <= mmptP0.x) ||
//			(mmptP0.x < mmLX && mmLX <= mmptP1.x))
//----- 01.02.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// P0,P1_xZkqqHx_iCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHiCkKiKgNiOmAiCmJiInJiCmIiCoIiBeBiKnEiCmJ_xHqqkZx_LX_xZkqqHx_iCkKjBlGiNnNiClHiCoJiClBiCmGiBeC_xHqqkZx_
		if ((aboutless(mmptP1.x, mmptP0.x) && mmptP1.x < mmLX && mmLX <= mmptP0.x) ||
			(aboutless(mmptP0.x, mmptP1.x) && mmptP0.x < mmLX && mmLX <= mmptP1.x))
//----- 01.02.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		/*-----  P1 _xZkqqHx_iCoGiCoI_xHqqkZx_ P0 _xZkqqHx_iCkKiJeFiBeBiKiOiCmC_xHqqkZx_ L _xZkqqHx_iCkK_xHqqkZx_ P1 _xZkqqHx_iCmG_xHqqkZx_ P0 _xZkqqHx_iCmMiKnE_xHqqkZx_ _xZkqqHx_iIlNiCmN_xHqqkZx_ P0 _xZkqqHx_iPoD_xHqqkZx_ _xZkqqHx_iIlNiCmN_xHqqkZx_
				 P0 _xZkqqHx_iCoGiCoI_xHqqkZx_ P1 _xZkqqHx_iCkKiJeFiBeBiKiOiCmC_xHqqkZx_ L _xZkqqHx_iCkK_xHqqkZx_ P0 _xZkqqHx_iCmG_xHqqkZx_ P1 _xZkqqHx_iCmMiKnE_xHqqkZx_ _xZkqqHx_iIlNiCmN_xHqqkZx_ P1 _xZkqqHx_iPoD_xHqqkZx_ -----*/
		{
			// _xZkqqHx_jAiCjClMjApM_xHqqkZx_ mmLX _xZkqqHx_iCmG_xHqqkZx_ P0-P1 _xZkqqHx_iCkKiMpAiNlDiClHiCoJ_xHqqkZx_ mmY _xZkqqHx_iCpAiOfKiPgP_xHqqkZx_.
			mmY = mmptP0.y + (mmptP1.y - mmptP0.y) *
						(mmLX - mmptP0.x) / (mmptP1.x - mmptP0.x);
			mmvCrossY.push_back(mmY);
		}
		mmptP0 = mmptP1;
	}

	sort(mmvCrossY.begin(), mmvCrossY.end());

} // PolyCrossVert.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	PolyAboutCrossHoriz
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDfDiDjDiCmGjAiFjFlNjApMiCkKiDeOiDiNiDfIiClHiCoJjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiCpAiClHiCnHiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPjEhKjHpB_xHqqkZx_
 *			lPolySize	:mmptaPoly_xZkqqHx_iCmMjAjE_xHqqkZx_
 *			bIsClose	:_xZkqqHx_iDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCmIiCoHiCmO_xHqqkZx_TRUE.
 *			mmLY		:_xZkqqHx_jClCiCnHiCoJjAiFjFlNjApMiCmM_xHqqkZx_Y.
 *			mmvCrossX	:_xZkqqHx_iMpAiNlDiClHiCoJjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiCpAjFnEiClH_xHqqkZx_.X_xZkqqHx_iNmAjFfHiCmNiPlIiPiHiCmJiDfMiBfLiDgHiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	PolyCrossHoriz_xZkqqHx_iCmGiCmMiIoBiCkCiCmNiBeB_xHqqkZx_PolyCrossHoriz_xZkqqHx_iCkKiDeOiDiNiDfIiClFiCmEiCkCiCmIiCkCiCmG_xHqqkZx_
 *			_xZkqqHx_iOfKiPgPiClFiCmIiCkCiCmMiCmJjBmOiClFiCmEiBeBiClBiCoKiCmNjEpBiPoNiCmJiLnPiCkCiPpDjBnEiCoAiDeOiDiNiDfIiCmGjElLjCgGiClF_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void PolyAboutCrossHoriz (const DBLPoint mmptaPoly[], long lPolySize, BOOL bIsClose,
						mmetol mmLY, doubleVector& mmvCrossX)
{
	DBLPoint	mmptP0, mmptP1;
	mmetol		mmX;
	long		l;
	mmvCrossX.clear();
	if (bIsClose && mmptaPoly[0] != mmptaPoly[lPolySize - 1])
	{
		mmptP0 = mmptaPoly[lPolySize - 1];
		l = 0;
	} else
	{
		mmptP0 = mmptaPoly[0];
		l = 1;
	}
	for (; l < lPolySize; l++)
	{
		mmptP1 = mmptaPoly[l];
		// P0,P1_xZkqqHx_iCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiCkKiKgNiOmAiCmJiInJiCmIiCoIiBeBiKnEiCmJ_xHqqkZx_LY_xZkqqHx_iCkKjBlGiNnNiClHiCoJiClBiCmGiBeC_xHqqkZx_
		if ((aboutless(mmptP1.y, mmptP0.y) &&
			aboutlesseq(mmptP1.y, mmLY) && aboutlesseq(mmLY, mmptP0.y)) ||
			(aboutless(mmptP0.y, mmptP1.y) &&
			aboutlesseq(mmptP0.y, mmLY) && aboutlesseq(mmLY, mmptP1.y)))
		{
			// _xZkqqHx_jAiFjFlNjApM_xHqqkZx_ mmLY _xZkqqHx_iCmG_xHqqkZx_ P0-P1 _xZkqqHx_iCkKiMpAiNlDiClHiCoJ_xHqqkZx_ mmX _xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
			mmX = mmptP0.x + (mmptP1.x - mmptP0.x) *
						(mmLY - mmptP0.y) / (mmptP1.y - mmptP0.y);
			mmvCrossX.push_back(mmX);
		}
		mmptP0 = mmptP1;
	}
	sort(mmvCrossX.begin(), mmvCrossX.end());
} // PolyAboutCrossHoriz.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	PolyAboutCrossVert
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDfDiDjDiCmGjAiCjClMjApMiCkKiDeOiDiNiDfIiClHiCoJjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAiClHiCnHiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPjEhKjHpB_xHqqkZx_
 *			lPolySize	:mmptaPoly_xZkqqHx_iCmMjAjE_xHqqkZx_
 *			bIsClose	:_xZkqqHx_iDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCmIiCoHiCmO_xHqqkZx_TRUE.
 *			mmLX		:_xZkqqHx_jClCiCnHiCoJjAiCjClMjApMiCmM_xHqqkZx_X.
 *			mmvCrossY	:_xZkqqHx_iMpAiNlDiClHiCoJjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAjFnEiClH_xHqqkZx_.Y_xZkqqHx_iNmAjFfHiCmNiPlIiPiHiCmJiDfMiBfLiDgHiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	PolyCrossVert_xZkqqHx_iCmGiCmMiIoBiCkCiCmNiBeB_xHqqkZx_PolyCrossVert_xZkqqHx_iCkKiDeOiDiNiDfIiClFiCmEiCkCiCmIiCkCiCmG_xHqqkZx_
 *			_xZkqqHx_iOfKiPgPiClFiCmIiCkCiCmMiCmJjBmOiClFiCmEiBeBiClBiCoKiCmNjEpBiPoNiCmJiLnPiCkCiPpDjBnEiCoAiDeOiDiNiDfIiCmGjElLjCgGiClF_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void PolyAboutCrossVert (const DBLPoint mmptaPoly[], long lPolySize, BOOL bIsClose,
						mmetol mmLX, doubleVector& mmvCrossY)
{
	DBLPoint	mmptP0, mmptP1;
	mmetol		mmY;
	long		l;
	mmvCrossY.clear();
	if (bIsClose && mmptaPoly[0] != mmptaPoly[lPolySize - 1])
	{
		mmptP0 = mmptaPoly[lPolySize - 1];
		l = 0;
	} else
	{
		mmptP0 = mmptaPoly[0];
		l = 1;
	}
	for (; l < lPolySize; l++)
	{
		mmptP1 = mmptaPoly[l];
		// P0,P1_xZkqqHx_iCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHiCkKiKgNiOmAiCmJiInJiCmIiCoIiBeBiKnEiCmJ_xHqqkZx_LX_xZkqqHx_iCkKjBlGiNnNiClHiCoJiClBiCmGiBeC_xHqqkZx_
		if ((aboutless(mmptP1.x, mmptP0.x) &&
			aboutlesseq(mmptP1.x, mmLX) && aboutlesseq(mmLX, mmptP0.x)) ||
			(aboutless(mmptP0.x, mmptP1.x) &&
			aboutlesseq(mmptP0.x, mmLX) && aboutlesseq(mmLX, mmptP1.x)))
		{
			// _xZkqqHx_jAiFjFlNjApM_xHqqkZx_ mmLX _xZkqqHx_iCmG_xHqqkZx_ P0-P1 _xZkqqHx_iCkKiMpAiNlDiClHiCoJ_xHqqkZx_ mmY _xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
			mmY = mmptP0.y + (mmptP1.y - mmptP0.y) *
						(mmLX - mmptP0.x) / (mmptP1.x - mmptP0.x);
			mmvCrossY.push_back(mmY);
		}
		mmptP0 = mmptP1;
	}
	sort(mmvCrossY.begin(), mmvCrossY.end());
} // PolyAboutCrossVert.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	PolyCrossLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDfDiDjDiCmGjClMjApMiCkKiDeOiDiNiDfIiClHiCoJjDfPiCmMiNmAjFfHiCpAiClHiCnHiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPjEhKjHpB_xHqqkZx_
 *			lPolySize	:mmptaPoly_xZkqqHx_iCmMjAjE_xHqqkZx_
 *			bIsClose	:_xZkqqHx_iDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCmIiCoHiCmO_xHqqkZx_TRUE.
 *			mmlnL		:_xZkqqHx_jClCiCnHiCoJjClMjApM_xHqqkZx_.
 *			mmptvCross	:_xZkqqHx_iMpAiNlDiClHiCoJjDfPiCmMiNmAjFfHiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmptaPoly_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiCoJiDhMiDiKiDfDiDjDiCmGjClMjApM_xHqqkZx_ mmlnL_xZkqqHx_iCkKiDeOiDiNiDfIiClHiCoJjDfPiCpAiClHiCnHiCmE_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClFiBeB_xHqqkZx_mmptvCross_xZkqqHx_iCmJjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void PolyCrossLine (const DBLPoint mmptaPoly[], long lPolySize, BOOL bIsClose,
					const DBLLine& mmlnL, DBLPointVector& mmptvCross)
{
	DBLShortLine mmsln;
	DBLPoint mmptP, mmptC;
	long l;

	mmptvCross.clear();

	if (bIsClose && mmptaPoly[0] != mmptaPoly[lPolySize - 1])
	{
		mmptP = mmptaPoly[lPolySize - 1];
		l = 0;
	} else
	{
		mmptP = mmptaPoly[0];
		l = 1;
	}

	for (; l < lPolySize; l++)
	{
		mmsln.SetPoints(mmptP, mmptaPoly[l]);
		if (mmsln.CrossPoint(mmptC, mmlnL)) mmptvCross.push_back(mmptC);
		mmptP = mmptaPoly[l];
	}

} // PolyCrossLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcCrossPointLinePolyline
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDiJiDeDiDjD_xHqqkZx_P_xZkqqHx_iCmGjClMjApM_xHqqkZx_AN_xZkqqHx_iCmMiMpAjDfP_xHqqkZx_F_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_F_xZkqqHx_iCmNiBeBiNmFiCoA_xHqqkZx_AN_xZkqqHx_jFpLiMpMiCmFiJjDiCkCiMpAjDfPiBeC_xHqqkZx_
 *			UtilMisc.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptF		:_xZkqqHx_iMpAjDfPiCpAjFnEiClHiBeCiMpAjDfPiCkKjGlDiCkCiPoKiNiHiCmNiBeBjFmPiNfIiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *			mmptaP		:_xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSizeP		:mmptaP_xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_iDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeBiKeKiCkCiCmEiCkCiCoJiCmIiCoH_xHqqkZx_
 *						 FALSE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptA		:_xZkqqHx_jClMjApMiCmMiIoKjFpLiCmMjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptN		:_xZkqqHx_jClMjApMiCmMiIoKjFpLiCmMjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAjDfPiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmptA != mmptN _xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CalcCrossPointLinePolyline (DBLPoint& mmptF,
								const DBLPoint mmptaP[], long lSizeP,
								BOOL bIsClose,
								const DBLPoint& mmptA,
								const DBLPoint& mmptN)
{
	ASSERT(!almosteq(mmptA, mmptN));
	//----- _xZkqqHx_jApM_xHqqkZx_AN_xZkqqHx_iCmGiDhMiDiKiDfDiDjDiCkKiDeOiDiNiDfIiClHiCoJjDfPiCpAjBfDiCmEiLiBiCnPiCoJ_xHqqkZx_ -----
	DBLPointVector vmmptCross;
	// mmptA == mmptN _xZkqqHx_iCmNiCkAiCoIiCkGiCmIiCkCiBeC_xHqqkZx_
	DBLLine mmlnAN(mmptA, mmptN);
	PolyCrossLine(mmptaP, lSizeP, bIsClose, mmlnAN, vmmptCross);
	// _xZkqqHx_iMpAjDfPiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (vmmptCross.empty()) return FALSE;
	//----- _xZkqqHx_iDhIiDeOiDgHiDiL_xHqqkZx_AN_xZkqqHx_iCmJiJiIiCmBiCmEiBeBiNmFiCoA_xHqqkZx_A_xZkqqHx_iCkJiCoHiJjDiCkCiDeOiDiNiDfIjDfP_xHqqkZx_F_xZkqqHx_iCpAiLiBiCnPiCoJ_xHqqkZx_ -----
	DBLPointVector::const_iterator iPt = vmmptCross.begin();
	mmptF = *iPt;
	for (; iPt != vmmptCross.end(); iPt++)
	{
		if ((mmptA.x < mmptN.x && mmptF.x < (*iPt).x) ||
			(mmptA.x > mmptN.x && mmptF.x > (*iPt).x) ||
			(mmptA.y < mmptN.y && mmptF.y < (*iPt).y) ||
			(mmptA.y > mmptN.y && mmptF.y > (*iPt).y))
		{
			mmptF = *iPt;
		}
	}
	return TRUE;
} // CalcCrossPointLinePolyline.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFMakeCommonInside
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PolyCrossHoriz_xZkqqHx_iCmIiCmHiCmFiNoMjAkMiClDiCoKiClNiMpAjDfPiPfHiNiHiCmNiBeBiKoPjAjEjEnEjGnKiCmMiMpAjDfPiCmG_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiOjPiCmMiMpAjDfPiCmMiKnEiCkKjAhNiMgAiCmMjDoAjBkEiCmJiCkAiCoJiCmGiCkCiCkEjAkLiOlPiCpAiOjNiCmCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmNiBeBjFkBjAjEiCmMiMpAjDfPiPfHiNiHiCpAiBeBjAhNiMgAiCmMjDoAjBkEiCmJiCkAiCoJjEmNiImNiBeBiCmGiCkCiCkE_xHqqkZx_
 *			_xZkqqHx_iKmPjDfPiCkJiCoHiIoKiCmCiCmJiCnMiCmGiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmvCommonInsideX	:_xZkqqHx_iIoKiCmCiCmJiCnMiCmGiCnPiClNiMpAjDfPiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmvaInsideX			:_xZkqqHx_jFkBjAjEiCmMiMpAjDfPiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lInsideXSize		:mmvaInsideX_xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	InsideX _xZkqqHx_iCmG_xHqqkZx_X_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCoJiCkKiBeBjAiFjFlNjApMiCmGiCmMiMpAjDfPiCmJiMmAiCoHiClIjAiCjClMjApMiCmGiCmM_xHqqkZx_
 *			_xZkqqHx_iMpAjDfPiCmFiCoAjHmHiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	  _xZkqqHx_iImIiJlKiCmMiCfCiCmCiCmMiMpAjDfPiPfHiNiHiCpAiCnMiCmGiCnPiCoJiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *
 *                     +1        -1        +1            -1      +1            -1        +1            -1 
 *        InsideX[0]   _xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEkA_xHqqkZx_        _xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEjPiEjPiEkA_xHqqkZx_      _xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEjPiEjPiEkA_xHqqkZx_        _xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEjPiEjPiEkA_xHqqkZx_
 *    
 *                         +2        -2      +2      -2                   +2                  -2 
 *        InsideX[1]       _xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEkA_xHqqkZx_      _xZkqqHx_iEkAiEjPiEjPiEjPiEkA_xHqqkZx_                   _xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkA_xHqqkZx_ 
 *    
 *                             +3        -3      +3            -3      +3            -3 
 *        InsideX[2]           _xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEkA_xHqqkZx_      _xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEjPiEjPiEkA_xHqqkZx_      _xZkqqHx_iEkAiEjPiEjPiEjPiEjPiEjPiEjPiEkA_xHqqkZx_ 
 *
 *			_xZkqqHx_iKgFiMpAjDfPiCmJiCmNiBeBiKoPjAjEjEnEjGnKiCpA_xHqqkZx_+1_xZkqqHx_iBeBiLpEjAjEjEnEjGnKiCpA_xHqqkZx_-1_xZkqqHx_iCmGiCkCiCkEiCoGiCkEiCmJiBeB_xHqqkZx_+_xZkqqHx_iCmG_xHqqkZx_-_xZkqqHx_iCmFiIpDiCpAjFhEiCkPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCkEiClHiCoJiCmGiBeB_xHqqkZx_+_xZkqqHx_iBgA_xHqqkZx_-_xZkqqHx_iCmMiKnEiCkKjAhNiMgAiCmMjDoAjBkEiCmJiCkAiCoJiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFkBjAjEiCmMiMpAjDfPiPfHiNiHiCpAiBeBiMpAjDfPiCmMiPkMiClDiCkCiPiHiCmJiIoKiCmCiCmMiDiKiDfIiDgHiCmJiCnMiCmGiCnPiCoJiCmGiImIiJlKiCmMiCoGiCkEiCmJiCmIiCoJiBeC_xHqqkZx_
 *			+1_xZkqqHx_iCmF_xHqqkZx_1_xZkqqHx_iDhEiDiJiDePiCkK_xHqqkZx_ON_xZkqqHx_iBeB_xHqqkZx_-1_xZkqqHx_iCmF_xHqqkZx_1_xZkqqHx_iDhEiDiJiDePiCkKiDeJiDhEiCmJiCmIiCoJiCmGiClHiCoJiCmGiBeBiJlKjAhNiCmMiBhFiDhEiDiJiDeP_xHqqkZx_1,2,3_xZkqqHx_iCkK_xHqqkZx_ON_xZkqqHx_iBhGiCmJ_xHqqkZx_
 *			_xZkqqHx_iCmIiCoJjEmNiImNiCkKiCfCiCmCiCmMiMpAjDfPiPfHiNiHiCmFiLkEjCmKiCmMjAhNiMgAjDoAjBkEiCmMiLpDiKnEiCmFiCkAiCoJiClBiCmGiCkKiCoNiCkJiCoJiBeC_xHqqkZx_
 *
 *                     +1        -1        +1            -1      +1            -1        +1            -1 
 *                     _xZkqqHx_iEkA_xHqqkZx_  +2    _xZkqqHx_iEkA_xHqqkZx_  -2    _xZkqqHx_iEkA_xHqqkZx_+2      -2  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      +2    _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  -2        _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  +3_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  -3_xZkqqHx_iEkAiEkA_xHqqkZx_  +3  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    -3_xZkqqHx_iEkA_xHqqkZx_    +3_xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    -3  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iEkFiEjPiEkJiEjPiEkJiEkJiEjPiEkJiEjPiEkJiEkJiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEjPiEkJiEkJiEjPiEjPiEkJiEkJiEjPiEjPiEkJiEjPiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *
 *      _xZkqqHx_iDhEiDiJiDeP_xHqqkZx_1,2,3_xZkqqHx_iCkK_xHqqkZx_ON        _xZkqqHx_iEkFiEkH_xHqqkZx_              _xZkqqHx_iEkFiEjPiEkH_xHqqkZx_                  _xZkqqHx_iEkFiEjPiEjPiEkH_xHqqkZx_
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFMakeCommonInside (	mmetolVector& mmvCommonInsideX,
							mmetolVector mmvaInsideX[],
							long lInsideXSize)
{
	mmvCommonInsideX.clear();
	// _xZkqqHx_jFkBjAjEiCmMiMpAjDfPiPfHiNiHiCpAiCnMiCmGiCnPiClNiPfHiNiHiCpAiNoMjAkMiBeC_xHqqkZx_
	multimap<mmetol, long> mmpCommonX;
	long lC;
	for (lC = 0; lC != lInsideXSize; lC++)
	{
		// _xZkqqHx_iDhEiDiJiDePiBeC_xHqqkZx_
		const long lFlag = lC + 1;
		mmetolVector& mmvInsideX = mmvaInsideX[lC];
		for (long lIndex = 0; lIndex != mmvInsideX.size(); lIndex++)
		{
			// lIndex _xZkqqHx_iCkKiKoPjAjEiCmMiPoKiNiHiBgJjBkGiClPiLpEjAjEjEnEjGnKiCmMiPoKiNiHiBgKiCmNjFiJiCmMiDhEiDiJiDePiBeB_xHqqkZx_
			// _xZkqqHx_iLpEjAjEiCmMiPoKiNiHiBgJjBkGiClPiKoPjAjEjEnEjGnKiCmMiPoKiNiHiBgKiCmNjAlDiCmMiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
			mmpCommonX.insert(pair<mmetol, long>(mmvInsideX[lIndex], (lIndex % 2) ? -lFlag : lFlag));
		}
	}
	longSet stFlag;
	multimap<mmetol, long>::const_iterator iMmf;
	for (iMmf = mmpCommonX.begin(); iMmf != mmpCommonX.end(); iMmf++)
	{
		if ((*iMmf).second < 0)
		//----- _xZkqqHx_jFiJiCmMiDhEiDiJiDePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhEiDiJiDePiCpA_xHqqkZx_OFF_xZkqqHx_iBeC_xHqqkZx_
			if (stFlag.erase(abs((*iMmf).second)) != 1) FFThrowMiscUnknown();
			// _xZkqqHx_iDhEiDiJiDePiCkKjBfDiCmE_xHqqkZx_ON_xZkqqHx_iCmMiPpDjBnEiCkJiCoHiIoKiCmC_xHqqkZx_OFF_xZkqqHx_iCmJiCmIiCmBiClNiPoKiNiHiCmNiLkEjCmKiMpAjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
			if (stFlag.size() == lInsideXSize - 1)
				mmvCommonInsideX.push_back((*iMmf).first);
		} else
		//----- _xZkqqHx_jAlDiCmMiDhEiDiJiDePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhEiDiJiDePiCpA_xHqqkZx_ON_xZkqqHx_iBeC_xHqqkZx_
			stFlag.insert((*iMmf).second);
			// _xZkqqHx_iDhEiDiJiDePiCkKjBfDiCmE_xHqqkZx_ON_xZkqqHx_iCmMiPoKiNiHiCmNiLkEjCmKiMpAjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
			if (stFlag.size() == lInsideXSize)
				mmvCommonInsideX.push_back((*iMmf).first);
		}
	}
	ASSERT(stFlag.empty());
	ASSERT(mmvCommonInsideX.size() % 2 == 0);

	// _xZkqqHx_iDfEiDeDiDfJiCkKiCePiBgJiIlNiCkCiCmNiCnJiCnKiCePiBgKiCmMiLpDiKnEiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
	// mmvCommonInsideX _xZkqqHx_iCpAiNoMiCoJiNnLiBeBiMpAjDfPiPfHiNiHiCmMiBhLiCmGiBhMiCkKiMpAiNlHiClHiCoJiPoKiNiHiCmJjEkNjAlGiClFjDlOiCoJiBeC_xHqqkZx_
	for (lC = 0; lC != mmvCommonInsideX.size();)
	{
		if (almosteq(mmvCommonInsideX[lC], mmvCommonInsideX[lC+1]))
		//----- _xZkqqHx_jDoAjBkEiCmMjEmNiImNiCkKjGhHiCmHjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			mmvCommonInsideX.erase(	mmvCommonInsideX.begin() + lC,
									mmvCommonInsideX.begin() + lC + 2);
		} else
		//----- _xZkqqHx_jDoAjBkEiCmMjEmNiImNiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
		{
			lC += 2;
		}
	}
} // FFMakeCommonInside.

//----------</NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFRemoveSamePoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDkPiClGiNmAjFfHiCpAiOjNiCmCjIeBjBlBiClFiClNiCfBiCmCiCmMjDfPiCpAiJpAiPmBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFRemoveSamePoint (DBLPointVector& vPoly, BYTEVector& vIsJoint)
{
//----- 05.04.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	DBLPoint dptPrev = vPoly[0];
//	long lC = 1;
//	while (lC < vPoly.size())
//	{
//		if (dptPrev.IsMostEqual(vPoly[lC]))
//		{
//			vPoly.erase(&vPoly[lC]);
//		} else
//		{
//			dptPrev = vPoly[lC];
//			lC++;
//		}
//	}
//----- 05.04.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	long lC = 1;
	while (lC != vPoly.size())
	{
// 05.05.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		if (vPoly[lC-1].IsMostEqual(vPoly[lC]))
		if (abouteq(vPoly[lC-1], vPoly[lC]))
		{
			vPoly.erase(&vPoly[lC]);
			vIsJoint.erase(&vIsJoint[lC]);
		} else
		{
			lC++;
		}
	}
//----- 05.04.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFRemoveSamePoint.
//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	TurnToWhich
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfCiCmCiCmMjDfPiCmFiOkGiClDiCoKiCoJjApMiCkKiBeBiCmHiCmMjFpLiMpMiCnGiLmIiCkKiCmBiCmEiCkCiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	A	: _xZkqqHx_jBoGiIoKjDfP_xHqqkZx_
 *			B	: _xZkqqHx_jBoGjDpBjDfP_xHqqkZx_
 *			C	: _xZkqqHx_jBoGiOePjDfP_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TURN_TO_NONE	: _xZkqqHx_jFpLiMpMiCkKjBkKiCoKiCmIiCkC_xHqqkZx_
 *			TURN_TO_RIGHT	: A->B_xZkqqHx_iCoGiCoIiCoA_xHqqkZx_B->C_xZkqqHx_iCkKiJeFjFpLiMpM_xHqqkZx_
 *			TURN_TO_LEFT	: A->B_xZkqqHx_iCoGiCoIiCoA_xHqqkZx_B->C_xZkqqHx_iCkKiNlGjFpLiMpM_xHqqkZx_
 *			TURN_TO_FRONT	: A->B_xZkqqHx_iCmG_xHqqkZx_B->C_xZkqqHx_iCkKiKkOjBfDiCmJjDkPjFpLiMpM_xHqqkZx_
 *			TURN_TO_BACK	: A->B_xZkqqHx_iCmG_xHqqkZx_B->C_xZkqqHx_iCkKiKkOjBfDiCmJiLhEjFpLiMpM_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFpLiMpMjElLjCoIiCmNiBeBiKkOjBfDiCmIiMlFjGkHiClDiCmNiCmIiCkCiBeC_xHqqkZx_abouteq_xZkqqHx_iCpAiOgHiCmBiCmEiCkCiCoJiCmMiCmNiBeB_xHqqkZx_
 *			almosteq_xZkqqHx_iCpAiOgHiCkEiCmGiBeB_xHqqkZx_TURN_TO_LEFT/TURN_TO_RIGHT_xZkqqHx_iCmGjElLjCgGiClDiCoKiCoJiCmMiCmJ_xHqqkZx_
 *			DBLLine(A, B) || DBLLine(B, C) _xZkqqHx_iCmFiCkAiCoJiPoKiNiHiCkKiCkAiCmBiClNiClNiCnPiBeC_xHqqkZx_
 *			DBLLine_xZkqqHx_iCmMiMfIiCkLiCmMjFpLiCkKiBeBiMhGiOfKiMoLiNlHiCkKjAlGiClGiCoCiClHiCkCiClNiCnPiClOiCmGiOhGiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.20 Fukushiro M. almosteq _xZkqqHx_iCpAiOgHiCkEiCoGiCkEiCmJjFmPiNfIiBeCiDeHiDiJiBfLiCmMiInHiBeC_xHqqkZx_
 *************************************************************************/
FDTurnTo TurnToWhich (DBLPoint A, DBLPoint B, DBLPoint C)
{
	DBLLine	L;
	double	dY;
	//----- almosteq_xZkqqHx_iCmMjFhDiKgNjCoIjHhGjBgGiCpAiPjMiKePiClHiCoJiClNiCnPiBeBjCgMiCpAjBlFiCkGiCoJ_xHqqkZx_ -----
	//----- L.GetY_xZkqqHx_iKnGjAjEiCmFiDeHiDiJiBfLiCkKiLeOiCkLiClNiClNiCnP_xHqqkZx_ -----
//----- 01.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (almosteq(A.x, B.x)) B.x = A.x;
//	if (almosteq(A.y, B.y)) B.y = A.y;
//	if (almosteq(A.x, C.x)) C.x = A.x;
//	if (almosteq(A.y, C.y)) C.y = A.y;
//	if (almosteq(B.x, C.x)) C.x = B.x;
//	if (almosteq(B.y, C.y)) C.y = B.y;
//----- 01.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	if (abouteq(A.x, B.x))
	//----- A_xZkqqHx_iCmG_xHqqkZx_B_xZkqqHx_iCpAiMiLiCnEjApMiCkKjAiCjClMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// A == B_xZkqqHx_iBeC_xHqqkZx_
		if (abouteq(A.y, B.y))
		{
			return TURN_TO_NONE;
		} else
		if (A.y < B.y)		// _xZkqqHx_jApM_xHqqkZx_AB_xZkqqHx_iCmNiJlK_xHqqkZx_(Y_xZkqqHx_jBjNiJmB_xHqqkZx_)_xZkqqHx_jFpLiMpMiBeC_xHqqkZx_
		{
			if (!abouteq(B.x, C.x))
			{
				if (B.x < C.x)	return TURN_TO_LEFT;
				if (C.x < B.x)	return TURN_TO_RIGHT;
			}
			//----- C_xZkqqHx_iCmNjApM_xHqqkZx_AB_xZkqqHx_iPoD_xHqqkZx_ -----
			if (!abouteq(B.y, C.y))
			{
				if (B.y < C.y)	return TURN_TO_FRONT;
				if (C.y < B.y)	return TURN_TO_BACK;
			}
			//----- B == C.
			return TURN_TO_NONE;
		} else
		//----- _xZkqqHx_iImIiNhOiCmN_xHqqkZx_ (B.y < A.y) _xZkqqHx_jApM_xHqqkZx_AB_xZkqqHx_iCmNiPoD_xHqqkZx_(Y_xZkqqHx_iMlIiPkN_xHqqkZx_)_xZkqqHx_jFpLiMpM_xHqqkZx_ -----
		{
			if (!abouteq(B.x, C.x))
			{
				if (B.x < C.x)	return TURN_TO_RIGHT;
				if (C.x < B.x)	return TURN_TO_LEFT;
			}
			//----- C_xZkqqHx_iCmNjApM_xHqqkZx_AB_xZkqqHx_iPoD_xHqqkZx_ -----
			if (!abouteq(B.y, C.y))
			{
				if (B.y < C.y)	return TURN_TO_BACK;
				if (C.y < B.y)	return TURN_TO_FRONT;
			}
			//----- B == C.
			return TURN_TO_NONE;
		}
	} else
	if (A.x < B.x)		// _xZkqqHx_jApM_xHqqkZx_AB_xZkqqHx_iCmNiJeF_xHqqkZx_(X_xZkqqHx_jBjNiJmB_xHqqkZx_)_xZkqqHx_jFpLiMpMiBeC_xHqqkZx_
	{
		L.SetPoints(A, B);
		dY = L.GetY(C.x);
		if (!abouteq(dY, C.y))
		{
			if (dY < C.y)	return TURN_TO_RIGHT;
			if (C.y < dY)	return TURN_TO_LEFT;
		}
		//----- C_xZkqqHx_iCmNjApM_xHqqkZx_AB_xZkqqHx_iPoD_xHqqkZx_ -----
		if (!abouteq(B.x, C.x))
		{
			if (B.x < C.x)	return TURN_TO_FRONT;
			if (C.x < B.x)	return TURN_TO_BACK;
		}
		// B == C.
		return TURN_TO_NONE;
	} else
	//----- _xZkqqHx_iImIiNhOiCmN_xHqqkZx_ (B.x < A.x) _xZkqqHx_jApM_xHqqkZx_AB_xZkqqHx_iCmNiNlG_xHqqkZx_(X_xZkqqHx_iMlIiPkN_xHqqkZx_)_xZkqqHx_jFpLiMpM_xHqqkZx_ -----
	{
		L.SetPoints(A, B);
		dY	= L.GetY(C.x);
		if (!abouteq(dY, C.y))
		{
			if (dY < C.y)	return TURN_TO_LEFT;
			if (C.y < dY)	return TURN_TO_RIGHT;
		}
		//----- C_xZkqqHx_iCmNjApM_xHqqkZx_AB_xZkqqHx_iPoD_xHqqkZx_ -----
		if (!abouteq(B.x, C.x))
		{
			if (B.x < C.x)	return TURN_TO_BACK;
			if (C.x < B.x)	return TURN_TO_FRONT;
		}
		// B == C.
		return TURN_TO_NONE;
	}
} // TurnToWhich.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	TurnToWhich
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApM_xHqqkZx_A_xZkqqHx_iCmJjBmOiClFiCmEjApM_xHqqkZx_B_xZkqqHx_jApMiCkKiBeBiCmHiCmMjFpLiMpMiCnGiLmIiCkKiCmBiCmEiCkCiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	A0	: _xZkqqHx_jApM_xHqqkZx_A_xZkqqHx_iCmMjBoGiIoKjDfP_xHqqkZx_
 *			A1	: _xZkqqHx_jApM_xHqqkZx_A_xZkqqHx_iCmMjBoGjDpBjDfP_xHqqkZx_
 *			B0	: _xZkqqHx_jApM_xHqqkZx_B_xZkqqHx_iCmMjBoGiIoKjDfP_xHqqkZx_
 *			B1	: _xZkqqHx_jApM_xHqqkZx_B_xZkqqHx_iCmMjBoGjDpBjDfP_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TURN_TO_NONE	: _xZkqqHx_jFpLiMpMiCkKjBkKiCoKiCmIiCkC_xHqqkZx_
 *			TURN_TO_RIGHT	: A0->A1_xZkqqHx_iCoGiCoIiCoA_xHqqkZx_B0->B1_xZkqqHx_iCkKiJeFjFpLiMpM_xHqqkZx_
 *			TURN_TO_LEFT	: A0->A1_xZkqqHx_iCoGiCoIiCoA_xHqqkZx_B0->B1_xZkqqHx_iCkKiNlGjFpLiMpM_xHqqkZx_
 *			TURN_TO_FRONT	: A0->A1_xZkqqHx_iCmG_xHqqkZx_B0->B1_xZkqqHx_iCkKiKkOjBfDiCmJjDkPjFpLiMpM_xHqqkZx_
 *			TURN_TO_BACK	: A0->A1_xZkqqHx_iCmG_xHqqkZx_B0->B1_xZkqqHx_iCkKiKkOjBfDiCmJiLhEjFpLiMpM_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDTurnTo TurnToWhich (const DBLPoint& A0, const DBLPoint& A1,
						const DBLPoint& B0, const DBLPoint& B1)
{
	// B0_xZkqqHx_iCpA_xHqqkZx_A1_xZkqqHx_iCmJiPgEiCmLiCmEiBeB_xHqqkZx_B1_xZkqqHx_iCpAiClLiCmMjFkKiInKjDkOiClHiCoJiBeC_xHqqkZx_
	return TurnToWhich(A0, A1, B1 + (A1 - B0));
} // TurnToWhich.

//----------</NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLineDir
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjFkK_xHqqkZx_OA_xZkqqHx_iCmMiMpMiCkLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dptO	_xZkqqHx_iBeGjApMjFkKiCmMiKeKiOgOjDfP_xHqqkZx_
 *			dptA	_xZkqqHx_iBeGjApMjFkKiCmMiPeJjHlJjDfP_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	DIR_NONE		_xZkqqHx_iBeGiKeKiOgOjDfPiCmGiPeJjHlJjDfPiCkKjDkPiClGiPoKiNiHiBeC_xHqqkZx_
 *			DIR_UPPERRIGHT	_xZkqqHx_iBeGiKeKiOgOjDfPiCoGiCoIiPeJjHlJjDfPiCkKiJeFiPoDiCmMiPoKiNiHiBeC_xHqqkZx_
 *			DIR_JUSTUPPER	_xZkqqHx_iBeGiKeKiOgOjDfPiCoGiCoIiPeJjHlJjDfPiCkKjAfOiPoDiCmMiPoKiNiHiBeC_xHqqkZx_
 *			DIR_UPPERLEFT	_xZkqqHx_iBeGiKeKiOgOjDfPiCoGiCoIiPeJjHlJjDfPiCkKiNlGiPoDiCmMiPoKiNiHiBeC_xHqqkZx_
 *			DIR_JUSTLEFT	_xZkqqHx_iBeGiKeKiOgOjDfPiCoGiCoIiPeJjHlJjDfPiCkKjAfOiNlGiCmMiPoKiNiHiBeC_xHqqkZx_
 *			DIR_DOWNLEFT	_xZkqqHx_iBeGiKeKiOgOjDfPiCoGiCoIiPeJjHlJjDfPiCkKiNlGiJlKiCmMiPoKiNiHiBeC_xHqqkZx_
 *			DIR_JUSTDOWN	_xZkqqHx_iBeGiKeKiOgOjDfPiCoGiCoIiPeJjHlJjDfPiCkKjAfOiJlKiCmMiPoKiNiHiBeC_xHqqkZx_
 *			DIR_DOWNRIGHT	_xZkqqHx_iBeGiKeKiOgOjDfPiCoGiCoIiPeJjHlJjDfPiCkKiJeFiJlKiCmMiPoKiNiHiBeC_xHqqkZx_
 *			DIR_JUSTRIGHT	_xZkqqHx_iBeGiKeKiOgOjDfPiCoGiCoIiPeJjHlJjDfPiCkKjAfOiJeFiCmMiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	UPPER/LOWER_xZkqqHx_iCmNiBeB_xHqqkZx_y_xZkqqHx_iOlCiCkKiJlKjFpLiMpMiCmIiCmMiCmFiBeB_xHqqkZx_y_xZkqqHx_jAkMjFkKiCmMjBoFiPkMiKnGiMfHiCmGiLhEjDfNiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iCkCiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.14 Fukushiro M. almosteq_xZkqqHx_iCpAjDlBjDpMiBeC_xHqqkZx_
 *************************************************************************/
FDDirect FFLineDir (const DBLPoint& dptO, const DBLPoint& dptA)
{
	// _xZkqqHx_jBoFiPkMjEoEiKhCiCmMjBePiCmJ_xHqqkZx_almosteq_xZkqqHx_iCmFjEoEiKhCiClHiCoJiClBiCmGiCmFiBeBiCnJiCnKjDjJiClFiCkCiPoKiNiHiCpAiPjMiKePiClHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmM_xHqqkZx_x_xZkqqHx_iCkKjDjJiClFiCkCiPoKiNiHiBeC_xHqqkZx_
	if (almosteq(dptO.x, dptA.x))
	{
		// _xZkqqHx_iKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmM_xHqqkZx_y_xZkqqHx_iCkKjDjJiClFiCkCiPoKiNiHiCmNiBeBiKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmNjDkPiClGiNmAjFfHiBeC_xHqqkZx_
		if (almosteq(dptO.y, dptA.y)) return DIR_NONE;
		if (dptO.y < dptA.y) return DIR_JUSTDOWN;
		return DIR_JUSTUPPER; // dptA.y < dptO.y _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
	}
	// _xZkqqHx_iKeKiOgOjDfPiCmM_xHqqkZx_x < _xZkqqHx_iPeJjHlJjDfPiCmM_xHqqkZx_x _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
	if (dptO.x < dptA.x)
	{
		// _xZkqqHx_iKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmM_xHqqkZx_y_xZkqqHx_iCkKjDjJiClFiCkCiPoKiNiHiCmNiBeBjAfOiJeFjFpLiMpMiBeC_xHqqkZx_
		if (almosteq(dptO.y, dptA.y)) return DIR_JUSTRIGHT;
		if (dptO.y < dptA.y)	return DIR_DOWNRIGHT;
		return DIR_UPPERRIGHT; // dptA.y < dptO.y_xZkqqHx_iBeC_xHqqkZx_
	}
	//----- _xZkqqHx_iClBiCoKiImIiNhOiCmN_xHqqkZx_ _xZkqqHx_iPeJjHlJjDfPiCmM_xHqqkZx_x < _xZkqqHx_iKeKiOgOjDfPiCmM_xHqqkZx_x _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	// _xZkqqHx_iKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmM_xHqqkZx_y_xZkqqHx_iCkKjDjJiClFiCkCiPoKiNiHiCmNiBeBjAfOiNlGjFpLiMpMiBeC_xHqqkZx_
	if (almosteq(dptO.y, dptA.y)) return DIR_JUSTLEFT;
	if (dptO.y < dptA.y) return DIR_DOWNLEFT;
	return DIR_UPPERLEFT;	// dptA.y < dptO.y_xZkqqHx_iBeC_xHqqkZx_
} // FFLineDir.


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	operator < (const DBLPoint& mmpt1, const DBLPoint& mmpt2)
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DBLPoint _xZkqqHx_iCpAjEoEiKhCiClHiCoJiBeC_xHqqkZx_FFCalcTriangleSpace_xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static bool operator < (const DBLPoint& mmpt1, const DBLPoint& mmpt2)
{
	if (mmpt1.x < mmpt2.x) return true;
	if (mmpt1.x > mmpt2.x) return false;
	return (mmpt1.y < mmpt2.y);
} // operator <.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcTriangleSpace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiOePiKhAiMgAiCmMjGmKjAmPiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptP0	:_xZkqqHx_jClIjDfPiCePiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP1	:_xZkqqHx_jClIjDfPiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP2	:_xZkqqHx_jClIjDfPiCfBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGmKjAmPiBeCjFlNjFpLiDhOiDiKiDiBiBfLiDgHiDiL_xHqqkZx_(mm^2)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	P0 -> P1 -> P2 _xZkqqHx_iCkKiJeFiLmIiCkKiCoIiCmMiPoKiNiHiCmNjAlDiBeBiNlGiLmIiCkKiCoIiCmMiPoKiNiHiCmNjFiJiCmM_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAjFnEiClHiBeCjGmKjAmPiCmNiKfEiOfKiBeC_xHqqkZx_"_xZkqqHx_jGmKjAmPiMhGiOfK_xHqqkZx_.mdpf" _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FFCalcTriangleSpace (const DBLPoint& mmptP0, const DBLPoint& mmptP1, const DBLPoint& mmptP2)
{
	// _xZkqqHx_iJeFiLmIiCkKiCoIiCkJiBeI_xHqqkZx_
	const BOOL bIsToRight = (::TurnToWhich(mmptP0, mmptP1, mmptP2) == TURN_TO_RIGHT);
	// _xZkqqHx_iNmAjFfHiCmM_xHqqkZx_Y_xZkqqHx_jCgMiCmFiDfMiBfLiDgHiClHiCoJiClNiCnPiCmJiBeB_xHqqkZx_(P.y, P)_xZkqqHx_iCmMjEhKjHpBiCpAiNoMiCoJiBeC_xHqqkZx_
	pair<mmetol, DBLPoint> aOrder[3];
	aOrder[0].first = mmptP0.y;
	aOrder[0].second = mmptP0;
	aOrder[1].first = mmptP1.y;
	aOrder[1].second = mmptP1;
	aOrder[2].first = mmptP2.y;
	aOrder[2].second = mmptP2;
	// p.Y _xZkqqHx_iCmFiDfMiBfLiDgHiBeC_xHqqkZx_
	std::sort(aOrder, aOrder + 3);
	// Y_xZkqqHx_jCgMiCmFiPlIiPiHiCmJ_xHqqkZx_ A, B, C _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const DBLPoint mmptA = aOrder[0].second;
	const DBLPoint mmptB = aOrder[1].second;
	const DBLPoint mmptC = aOrder[2].second;
	// B _xZkqqHx_iCpAjCmKiCoIjAiFjFlNiCmIjClMjApM_xHqqkZx_BX_xZkqqHx_iBeC_xHqqkZx_
	const DBLLine lnBX(mmptB, mmptB + DBLPoint(1, 0));
	// A _xZkqqHx_iCmG_xHqqkZx_ C _xZkqqHx_iCpAjCmKiCoJjClMjApM_xHqqkZx_AC_xZkqqHx_iBeC_xHqqkZx_
	const DBLLine lnAC(mmptA, mmptC);
	// _xZkqqHx_iOePiKhAiMgAiCmMjGmKjAmPiBeC_xHqqkZx_
	double dSpace = 0.0;
	if (lnBX && lnAC)
	//----- BX_xZkqqHx_iCmG_xHqqkZx_AC_xZkqqHx_iCkKiMpAiNlHiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMpAjDfP_xHqqkZx_X_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
		const DBLPoint mmptX = lnBX & lnAC;
		// _xZkqqHx_iOePiKhAiMgAiCmMjGmKjAmPiCmNiBeB_xHqqkZx_|X,B| x |A.y, C.y| / 2 _xZkqqHx_iCmFiOfKiPgPiCmFiCkLiCoJiBeC_xHqqkZx_
		dSpace = ((mmptC.y - mmptA.y) * ::fabs(mmptB.x - mmptX.x)) / 2.0;
	}
	// _xZkqqHx_iJeFiLmIiCkKiCoIiCmMiPoKiNiHiCmNjAlDiBeBiClLiCoKiImIiKePiCmNjFiJiCmMjGmKjAmPiCpAjFnEiClHiBeC_xHqqkZx_
	return bIsToRight ? dSpace : -dSpace;
} // FFCalcTriangleSpace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcPolygonSpace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDfDiDjDiCmMjGmKjAmPiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptP	:_xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCount	:mmptP_xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGmKjAmPiBeCjFlNjFpLiDhOiDiKiDiBiBfLiDgHiDiL_xHqqkZx_(mm^2)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jGmKjAmPiCmNiKfEiOfKiBeC_xHqqkZx_"_xZkqqHx_jGmKjAmPiMhGiOfK_xHqqkZx_.mdpf" _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *			mmptP[0] != mmptP[lCount - 1] _xZkqqHx_iCmFiCkAiCmBiCmEjHmHiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FFCalcPolygonSpace (const DBLPoint mmptP[], long lCount)
{
	// _xZkqqHx_jGmKjAmPiBeC_xHqqkZx_
	double dSpace = 0;
	while (2 < lCount)
	{
		// _xZkqqHx_iOePiKhAiMgAiCmMjGmKjAmPiCpAiJmBiOfKiBeCjGmKjAmPiCmNjAlDiCkJjFiJiCmMiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
		dSpace += FFCalcTriangleSpace(mmptP[0], mmptP[lCount - 1], mmptP[lCount - 2]);
		// _xZkqqHx_iMhGiOfKiNmPiCnNiCmMiOePiKhAiMgAiCpAiPjMiCkNiBeC_xHqqkZx_
		lCount--;
	}
	// _xZkqqHx_jGmKjAmPiCpAjFnEiClHiBeCjFiJiCmFiCkAiCmBiCmEiCoAiBeBjAoCjBmOjCgMiCpAjFnEiClJiCmOiCoGiCkCiBeC_xHqqkZx_
	return fabs(dSpace);
} // FFCalcPolygonSpace.


//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IsSameDirection
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBjBlBiClHiCoJiCfCjDfPiBeBiCgPiBeBiChAiBeDiChBiCmJiCkIiCkCiCmEiBeBjApMjFkKiCgPiChAiCmGjApMjFkKiChAiChBiCkKjDkPiClG_xHqqkZx_
 *			_xZkqqHx_jFpLiMpMiBgJiCfIiCePjDhIiImIiPoDjFpLiMpMjDfNiKlHiClFiCmIiCkCiBgKiCmMiPoKiNiHiCmJjAfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	UtilMisc.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL IsSameDirection (const DBLPoint& mmptP, const DBLPoint& mmptQ, const DBLPoint& mmptR)
{
	ASSERT(!almosteq(mmptP, mmptQ));
	ASSERT(!almosteq(mmptQ, mmptR));
	DBLLine mmlnL = DBLLine(mmptP, mmptQ).GetCrossLine(mmptQ);
	if (mmlnL.IsVertical())
	{
		mmetol mmX = mmlnL.GetX(0);
		return (mmptP.x < mmX) ? (mmX < mmptR.x) : (mmptR.x < mmX);
	} else
	if (mmlnL.IsHorizontal())
	{
		mmetol mmY = mmlnL.GetY(0);
		return (mmptP.y < mmY) ? (mmY < mmptR.y) : (mmptR.y < mmY);
	} else
	{
		return (mmptP.y < mmlnL.GetY(mmptP.x)) ? (mmlnL.GetY(mmptR.x) < mmptR.y) :
												 (mmptR.y < mmlnL.GetY(mmptR.x));
	}
} // IsSameDirection.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IsSameDirection
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBjBlBiClHiCoJjApMjFkKiCgPiChAiCmGjApMjFkKiChAiChBiCkKjDkPiClGjFpLiMpMiBgJiCfIiCePjDhIiImIiPoDjFpLiMpMjDfNiKlHiClFiCmIiCkCiBgK_xHqqkZx_
 *			_xZkqqHx_iCmMiPoKiNiHiCmJjAfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	UtilMisc.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL IsSameDirection (const DBLPoint& mmptP, const DBLPoint& mmptQ, const DBLPoint& mmptR, const DBLPoint& mmptS)
{
	// _xZkqqHx_jDfP_xHqqkZx_R_xZkqqHx_iCpAjDfP_xHqqkZx_Q_xZkqqHx_iCmJiInKjDkOiClFiCmEiBeBiClLiCmMjFkKjDfP_xHqqkZx_S_xZkqqHx_iCoAiInKjDkOiBeC_xHqqkZx_
	return IsSameDirection(mmptP, mmptQ, mmptS + (mmptQ - mmptR));
} // IsSameDirection.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetCurrentTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiOjOiKnEiBeC_xHqqkZx_100-nanosecond since January 1, 1601.(_xZkqqHx_jAkCiKeFjFfHiPiAiOjO_xHqqkZx_)
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDTIME FFGetCurrentTime ()
{
	//----- _xZkqqHx_iMlLiNnNiCmMiOjOiKnEiCpAiOoGjDlO_xHqqkZx_ -----
	FILETIME ftSystemTime;
	GetSystemTimeAsFileTime(&ftSystemTime);
	// 100-nanosecond since January 1, 1601.
	return FiletimeToFdtime(ftSystemTime);
} // FFGetCurrentTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetCurrentMillisecTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiOjOiKnEiBeC_xHqqkZx_millisecond since January 1, 1601.(_xZkqqHx_jAkCiKeFjFfHiPiAiOjO_xHqqkZx_)
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDMILLISECTIME FFGetCurrentMillisecTime ()
{
	return FdtimeToFdmillisec(FFGetCurrentTime());
} // FFGetCurrentMillisecTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FdtimeToFdmillisec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FDTIME_xZkqqHx_iMfOiCmMjCgMiCpA_xHqqkZx_FDMILLISECTIME_xZkqqHx_iMfOiCmMjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdtm	:FDTIME_xZkqqHx_iMfOiCmMiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDMILLISECTIME_xZkqqHx_iMfOiCmMiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDMILLISECTIME FdtimeToFdmillisec (FDTIME fdtm)
{
	return fdtm / 10000;
} // FdtimeToFdmillisec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetCurrentSecTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiOjOiKnEiBeC_xHqqkZx_second since January 1, 1601.(_xZkqqHx_jAkCiKeFjFfHiPiAiOjO_xHqqkZx_)
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FFGetCurrentSecTime ()
{
	return FdtimeToFdsec(FFGetCurrentTime());
} // FFGetCurrentSecTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FdtimeToFdsec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FDTIME_xZkqqHx_iMfOiCmMjCgMiCpA_xHqqkZx_FDSECTIME_xZkqqHx_iMfOiCmMjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdtm	:FDTIME_xZkqqHx_iMfOiCmMiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDSECTIME_xZkqqHx_iMfOiCmMiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FdtimeToFdsec (FDTIME fdtm)
{
	return fdtm / 10000000;
} // FdtimeToFdsec.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FdtimeToFiletime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FDTIME_xZkqqHx_iMfOiCmMjCgMiCpA_xHqqkZx_FILETIME_xZkqqHx_iMfOiCmMjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdtm	:FDTIME_xZkqqHx_iMfOiCmMiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FILETIME_xZkqqHx_iMfOiCmMiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FILETIME FdtimeToFiletime (FDTIME fdtm)
{
	return *(FILETIME*)&fdtm;
} // FdtimeToFiletime.

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FdsecToFdtime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FDSECTIME_xZkqqHx_iMfOiCmMjCgMiCpA_xHqqkZx_FDTIME_xZkqqHx_iMfOiCmMjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdst	:FDSECTIME_xZkqqHx_iMfOiCmMiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDTIME_xZkqqHx_iMfOiCmMiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDTIME FdsecToFdtime (FDSECTIME fdst)
{
	return fdst * 10000000;
} // FdsecToFdtime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FdsecToFiletime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FDSECTIME_xZkqqHx_iMfOiCmMjCgMiCpA_xHqqkZx_FILETIME_xZkqqHx_iMfOiCmMjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdst	:FDSECTIME_xZkqqHx_iMfOiCmMiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FILETIME_xZkqqHx_iMfOiCmMiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FILETIME FdsecToFiletime (FDSECTIME fdst)
{
	return FdtimeToFiletime(FdsecToFdtime(fdst));
} // FdsecToFiletime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FiletimeToFdtime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FILETIME_xZkqqHx_iMfOiCmMjCgMiCpA_xHqqkZx_FDTIME_xZkqqHx_iMfOiCmMjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ft	:FILETIME_xZkqqHx_iMfOiCmMiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDTIME_xZkqqHx_iMfOiCmMiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDTIME FiletimeToFdtime (FILETIME ft)
{
	return *(FDTIME*)&ft;
} // FiletimeToFdtime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	COleDtToFdtime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	COleDateTime_xZkqqHx_iMfOiCmMjCgMiCpA_xHqqkZx_FDTIME_xZkqqHx_iMfOiCmMjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	otm	:COleDateTime_xZkqqHx_iMfOiCmMiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDTIME_xZkqqHx_iMfOiCmMiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDTIME COleDtToFdtime (const COleDateTime& otm)
{
	SYSTEMTIME sysTime;
	(void)otm.GetAsSystemTime(sysTime);
	// SYSTEMTIME_xZkqqHx_iCpA_xHqqkZx_FILETIME_xZkqqHx_iCmJjFmPiKlHiBeC_xHqqkZx_
	FILETIME ftLocal;
	SystemTimeToFileTime(&sysTime, &ftLocal);
	// Local time -> UTC_xZkqqHx_iBeC_xHqqkZx_
	FILETIME ftUtc;
	(void)LocalFileTimeToFileTime(&ftLocal, &ftUtc);
	// FILETIME_xZkqqHx_iCpA_xHqqkZx_FDTIME_xZkqqHx_iCmJjFmPiKlHiBeC_xHqqkZx_
	return FiletimeToFdtime(ftUtc);
} // COleDtToFdtime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	COleDtToFdsec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	COleDateTime_xZkqqHx_iMfOiCmMjCgMiCpA_xHqqkZx_FDSECTIME_xZkqqHx_iMfOiCmMjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	otm	:COleDateTime_xZkqqHx_iMfOiCmMiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDSECTIME_xZkqqHx_iMfOiCmMiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME COleDtToFdsec (const COleDateTime& otm)
{
	return FdtimeToFdsec(COleDtToFdtime(otm));
} // COleDtToFdsec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFWheelDeltaToScrollCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgFiDiKiDhNiDeFiDfIiCmM_xHqqkZx_wheel_xZkqqHx_iCkKiJpBjDfNiClFiClNiLjHjHkDiCkJiCoHiBeBiDfIiDeOiDiNiBfLiDiLjHmKiCpAiOfKiPgPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	zDelta	:_xZkqqHx_iJpBjDfNiLjHjHkDiCpAiOhHiOkGiBeC_xHqqkZx_zDelta _xZkqqHx_jCgMiCmN_xHqqkZx_ WHEEL_DELTA (_xZkqqHx_jCgM_xHqqkZx_ 120)
 *					 _xZkqqHx_iCmMjEhLjAjEiCnMiClNiCmNjGpBjAjEiCmJiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDhAiDgMiDiLiCmFiOhHjCoIiClDiCoKiCoJiDfIiDeOiDiNiBfLiDiLiDhAiDiJiDiBiBfLiDfOiCpAiNgMjHlGiClF_xHqqkZx_
 *			_xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FFWheelDeltaToScrollCount (short zDelta)
{
	//----- _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCmNiBeB_xHqqkZx_AUXDATA.CPP_xZkqqHx_iCmM_xHqqkZx_AUX_DATA::AUX_DATA()_xZkqqHx_iCmJiLeMiNnK_xHqqkZx_ -----
	DWORD dwVersion = ::GetVersion();
	BOOL bWin95 = (dwVersion & 0x80000000) != 0;
	BOOL bWin4 = (BYTE)dwVersion >= 4;

	//----- _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCmNiBeB_xHqqkZx_VIEWSCRL.CPP_xZkqqHx_iCmM_xHqqkZx__AfxGetMouseScrollLines()_xZkqqHx_iCmJiLeMiNnK_xHqqkZx_ -----
	UINT uWheelScrollLines = 3;
	if (!bWin4)
	{
		HKEY hKey;
		if (RegOpenKeyEx(HKEY_CURRENT_USER,  _T("Control Panel\\Desktop"),
				0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
		{
			TCHAR szData[128];
			DWORD dwKeyDataType;
			DWORD dwDataBufSize = sizeof(szData);
			if (RegQueryValueEx(hKey, _T("WheelScrollLines"), NULL, &dwKeyDataType,
					(LPBYTE)&szData, &dwDataBufSize) == ERROR_SUCCESS)
			{
				uWheelScrollLines = _tcstoul(szData, NULL, 10);
			}
			RegCloseKey(hKey);
		}
	}
	else if (!bWin95)
	{
		::SystemParametersInfo(SPI_GETWHEELSCROLLLINES, 0, &uWheelScrollLines, 0);
	}
	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCmNiBeB_xHqqkZx_VIEWSCRL.CPP_xZkqqHx_iCmM_xHqqkZx_DoMouseWheel()_xZkqqHx_iCmJiLeMiNnKiBeC_xHqqkZx_
	return ::MulDiv(-zDelta, uWheelScrollLines, WHEEL_DELTA);
} // FFWheelDeltaToScrollCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCreateGuid
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GUID_xZkqqHx_iCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	GUID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID FFCreateGuid ()
{
	GUID guid = GUID_NULL;
	::CoCreateGuid(&guid);
	return guid;
} // FFCreateGuid.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetGuidCheckCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GUID_xZkqqHx_iCkJiCoHiBeBiCfBiDgPiDeDiDgHiCmMiDgAiDeGiDgCiDeOiDfCiBfLiDgIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid	:GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgAiDeGiDgCiDeOiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FFGetGuidCheckCode (const GUID& guid)
{
//----- 04.10.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WORD wCheckCode = 0;
//	for (long lC = 0; lC != sizeof(guid); lC++)
//	{
//		long lw = ((BYTE*)&guid)[lC];
//		wCheckCode += WORD((lC + 1) * lw * lw);
//	}
//	return wCheckCode;
//----- 04.10.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return FFCalcCRC(sizeof(guid), &guid);
//----- 04.10.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFGetGuidCheckCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcCRC
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CCITT_xZkqqHx_iCmM_xHqqkZx_16bit-CRC(Cyclical Redundancy Check:_xZkqqHx_iPiEiJpBiPoHjClHiMjPiNlI_xHqqkZx_)_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliCount:_xZkqqHx_iDgGiBfLiDfOiCmMiDgPiDeDiDgHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData	:_xZkqqHx_iDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			crc		:_xZkqqHx_iClBiCoKiCnMiCmFiCmM_xHqqkZx_CRC_xZkqqHx_jCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	CRC_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FFCalcCRC (flint fliCount, const void* pData, WORD crc)
{
	static WORD s_CCITT_16_POLYx1021[] =
	{
		0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
		0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
		0x1231, 0x0210, 0x3273, 0x2252, 0x52B5, 0x4294, 0x72F7, 0x62D6,
		0x9339, 0x8318, 0xB37B, 0xA35A, 0xD3BD, 0xC39C, 0xF3FF, 0xE3DE,
		0x2462, 0x3443, 0x0420, 0x1401, 0x64E6, 0x74C7, 0x44A4, 0x5485,
		0xA56A, 0xB54B, 0x8528, 0x9509, 0xE5EE, 0xF5CF, 0xC5AC, 0xD58D,
		0x3653, 0x2672, 0x1611, 0x0630, 0x76D7, 0x66F6, 0x5695, 0x46B4,
		0xB75B, 0xA77A, 0x9719, 0x8738, 0xF7DF, 0xE7FE, 0xD79D, 0xC7BC,
		0x48C4, 0x58E5, 0x6886, 0x78A7, 0x0840, 0x1861, 0x2802, 0x3823,
		0xC9CC, 0xD9ED, 0xE98E, 0xF9AF, 0x8948, 0x9969, 0xA90A, 0xB92B,
		0x5AF5, 0x4AD4, 0x7AB7, 0x6A96, 0x1A71, 0x0A50, 0x3A33, 0x2A12,
		0xDBFD, 0xCBDC, 0xFBBF, 0xEB9E, 0x9B79, 0x8B58, 0xBB3B, 0xAB1A,
		0x6CA6, 0x7C87, 0x4CE4, 0x5CC5, 0x2C22, 0x3C03, 0x0C60, 0x1C41,
		0xEDAE, 0xFD8F, 0xCDEC, 0xDDCD, 0xAD2A, 0xBD0B, 0x8D68, 0x9D49,
		0x7E97, 0x6EB6, 0x5ED5, 0x4EF4, 0x3E13, 0x2E32, 0x1E51, 0x0E70,
		0xFF9F, 0xEFBE, 0xDFDD, 0xCFFC, 0xBF1B, 0xAF3A, 0x9F59, 0x8F78,
		0x9188, 0x81A9, 0xB1CA, 0xA1EB, 0xD10C, 0xC12D, 0xF14E, 0xE16F,
		0x1080, 0x00A1, 0x30C2, 0x20E3, 0x5004, 0x4025, 0x7046, 0x6067,
		0x83B9, 0x9398, 0xA3FB, 0xB3DA, 0xC33D, 0xD31C, 0xE37F, 0xF35E,
		0x02B1, 0x1290, 0x22F3, 0x32D2, 0x4235, 0x5214, 0x6277, 0x7256,
		0xB5EA, 0xA5CB, 0x95A8, 0x8589, 0xF56E, 0xE54F, 0xD52C, 0xC50D,
		0x34E2, 0x24C3, 0x14A0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
		0xA7DB, 0xB7FA, 0x8799, 0x97B8, 0xE75F, 0xF77E, 0xC71D, 0xD73C,
		0x26D3, 0x36F2, 0x0691, 0x16B0, 0x6657, 0x7676, 0x4615, 0x5634,
		0xD94C, 0xC96D, 0xF90E, 0xE92F, 0x99C8, 0x89E9, 0xB98A, 0xA9AB,
		0x5844, 0x4865, 0x7806, 0x6827, 0x18C0, 0x08E1, 0x3882, 0x28A3,
		0xCB7D, 0xDB5C, 0xEB3F, 0xFB1E, 0x8BF9, 0x9BD8, 0xABBB, 0xBB9A,
		0x4A75, 0x5A54, 0x6A37, 0x7A16, 0x0AF1, 0x1AD0, 0x2AB3, 0x3A92,
		0xFD2E, 0xED0F, 0xDD6C, 0xCD4D, 0xBDAA, 0xAD8B, 0x9DE8, 0x8DC9,
		0x7C26, 0x6C07, 0x5C64, 0x4C45, 0x3CA2, 0x2C83, 0x1CE0, 0x0CC1,
		0xEF1F, 0xFF3E, 0xCF5D, 0xDF7C, 0xAF9B, 0xBFBA, 0x8FD9, 0x9FF8,
		0x6E17, 0x7E36, 0x4E55, 0x5E74, 0x2E93, 0x3EB2, 0x0ED1, 0x1EF0
	};
	const BYTE* bypData = (const BYTE*)pData;
// 04.11.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	WORD crc = 0xffff;
	while (fliCount-- != 0)
	{
		crc = (crc << 8) ^ s_CCITT_16_POLYx1021[(crc >> 8) ^ *bypData];
		bypData++;
	}
	return crc;
} // FFCalcCRC.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jClIjDfPiNmAjFfHiCmMjEhKjHpBiCkJiCoHiBeBiClLiCmMjAhNiMgAiCmJiKePjAnKiClHiCoJiLoJiMgAjHmMiIoGiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rect	: _xZkqqHx_iLoJiMgAjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
 *			lSize	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiDfEiDeDiDfJ_xHqqkZx_.
 *			point	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpB_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jClIjDfPiNmAjFfHiCkK_xHqqkZx_ LONG_MAX _xZkqqHx_iCmJiCoGiCmBiCmEjFkKiKiEiClDiCoKiCoJjFkBjAjEiCmMjBlNiKhAjApMiCmFiCkAiCmBiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCalcFrame (CRect& rect, long lSize, const CPoint point[])
{
	rect.SetRect(LONG_MAX, LONG_MAX, LONG_MIN, LONG_MIN);
	for (long l = 0; l != lSize; l++)
	{
		if (point[l].x != LONG_MAX)
		{
			SmallerOrLarger(rect.left, rect.right, point[l].x);
			SmallerOrLarger(rect.top, rect.bottom, point[l].y);
		}
	}
} // FFCalcFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jClIjDfPiNmAjFfHiCmMjEhKjHpBiCkJiCoHiBeBiClLiCmMjAhNiMgAiCmJiKePjAnKiClHiCoJiLoJiMgAjHmMiIoGiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rect	: _xZkqqHx_iLoJiMgAjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
 *			lSize	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiDfEiDeDiDfJ_xHqqkZx_.
 *			point	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpB_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jClIjDfPiNmAjFfHiCkK_xHqqkZx_ DBL_MAX _xZkqqHx_iCmJiCoGiCmBiCmEjFkKiKiEiClDiCoKiCoJjFkBjAjEiCmMjBlNiKhAjApMiCmFiCkAiCmBiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCalcFrame (DBLRect& rect, long lSize, const DBLPoint point[])
{
	rect.SetRect(DBL_MAX, DBL_MAX, -DBL_MAX, -DBL_MAX);
	for (long l = 0; l != lSize; l++)
	{
		if (point[l].x != DBL_MAX)
		{
			SmallerOrLarger(rect.left, rect.right, point[l].x);
			SmallerOrLarger(rect.top, rect.bottom, point[l].y);
		}
	}
} // FFCalcFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLoadRegString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfHiDfIiDgHiDiKiDeMiBfLiCkJiCoHjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strData		:_xZkqqHx_iOoGiCoIiPgPiClFiClNjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			hKey		:_xZkqqHx_iDiBiDeDiDjDiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_CLASS_ROOT_xZkqqHx_jDjJiBeC_xHqqkZx_
 *			tcpSubKey	:_xZkqqHx_iDfEiDhFiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpName		:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMjGlMjBePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFLoadRegString (	WString& strData, HKEY hKey,
						const wchar_t* tcpSubKey, const wchar_t* tcpName)
{
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiDeMiBfLiCmMiDeJiBfLiDhGiDjDiCpAiDgHiDiJiDeDiBeC_xHqqkZx_
	HKEY hSubKey;
	if (RegOpenKeyEx(hKey, WStrToTStr(tcpSubKey), 0L,
					KEY_QUERY_VALUE, &hSubKey) != ERROR_SUCCESS) return FALSE;
	// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	DWORD dwDataSz = 0;
	if (RegQueryValueEx(hSubKey, WStrToTStr(tcpName), NULL,
						NULL, NULL, &dwDataSz) != ERROR_SUCCESS)
	{
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCpAiDeOiDiNiBfLiDfJiBeC_xHqqkZx_
		RegCloseKey(hSubKey);
		return FALSE;
	}
	// _xZkqqHx_iDgGiBfLiDfOiOpDiCkPiOoGiCoIjHhAiCmMiDgPiDgCiDhEiDeAiCpAiKgNjFnLiBeC_xHqqkZx_
	CString strTData;
	LPTSTR pBuff = strTData.GetBuffer(dwDataSz);
	// _xZkqqHx_jFlGiOjKiDgGiBfLiDfOjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	if (RegQueryValueEx(hSubKey, WStrToTStr(tcpName), NULL, NULL,
						(BYTE*)pBuff, &dwDataSz) != ERROR_SUCCESS)
	{
		// _xZkqqHx_jHmMiIoGiCpAiKeKjFpKiBeCiDgGiBfLiDfOiCmN_xHqqkZx_strTData_xZkqqHx_jCiGiCmJiOgDiCoJiBeC_xHqqkZx_
		strTData.ReleaseBuffer();
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCpAiDeOiDiNiBfLiDfJiBeC_xHqqkZx_
		RegCloseKey(hSubKey);
		return FALSE;
	}
	// _xZkqqHx_jHmMiIoGiCpAiKeKjFpKiBeCiDgGiBfLiDfOiCmN_xHqqkZx_strTData_xZkqqHx_jCiGiCmJiOgDiCoJiBeC_xHqqkZx_
	strTData.ReleaseBuffer();
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCpAiDeOiDiNiBfLiDfJiBeC_xHqqkZx_
	RegCloseKey(hSubKey);
	strData = TStrToWStr(strTData);
	return TRUE;
} // FFLoadRegString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLoadRegDWORD
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfHiDfIiDgHiDiKiDeMiBfLiCkJiCoH_xHqqkZx_DWORD_xZkqqHx_jCgMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwData		:_xZkqqHx_iOoGiCoIiPgPiClFiClN_xHqqkZx_DWORD_xZkqqHx_jCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			hKey		:_xZkqqHx_iDiBiDeDiDjDiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_CLASS_ROOT_xZkqqHx_jDjJiBeC_xHqqkZx_
 *			tcpSubKey	:_xZkqqHx_iDfEiDhFiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpName		:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMjGlMjBePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFLoadRegDWORD (	DWORD& dwData, HKEY hKey,
						const wchar_t* tcpSubKey, const wchar_t* tcpName)
{
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiDeMiBfLiCmMiDeJiBfLiDhGiDjDiCpAiDgHiDiJiDeDiBeC_xHqqkZx_
	HKEY hSubKey;
	if (RegOpenKeyEx(hKey, WStrToTStr(tcpSubKey), 0L,
					KEY_QUERY_VALUE, &hSubKey) != ERROR_SUCCESS) return FALSE;
	// _xZkqqHx_iDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	DWORD dwDataSz = sizeof(DWORD);
	if (RegQueryValueEx(hSubKey, WStrToTStr(tcpName), NULL,
						NULL, (LPBYTE)&dwData, &dwDataSz) != ERROR_SUCCESS)
	{
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCpAiDeOiDiNiBfLiDfJiBeC_xHqqkZx_
		RegCloseKey(hSubKey);
		return FALSE;
	}
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCpAiDeOiDiNiBfLiDfJiBeC_xHqqkZx_
	RegCloseKey(hSubKey);
	return TRUE;
} // FFLoadRegDWORD.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetSmallerItemFromList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCgMiCpAjEhKjHpBjCiGiCkJiCoHjCfEiClFiPgPiClFiBeBjEhKjHpBjCiGiCmFiIoKiCmCiPkMiClDiCkCjCgMiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lValue		:_xZkqqHx_jClCiCnHiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pList		:_xZkqqHx_jCgMiCmMjEhKjHpBiCpAiOhHjCoIiBeCiPlIiPiHiCmJiDfMiBfLiDgHiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			lListSize	:pList_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jEhKjHpBjCiGiCmFiIoKiCmCiPkMiClDiCkCjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoB_xHqqkZx_1_xZkqqHx_iBeG_xHqqkZx_	lValue	:5
 *					pList	:{ 1, 3, 4, 6, 8, 10 }
 *					Return	:4
 *
 *			_xZkqqHx_jHoB_xHqqkZx_2_xZkqqHx_iBeG_xHqqkZx_	lValue	:4
 *					pList	:{ 1, 3, 4, 6, 8, 10 }
 *					Return	:3
 *
 *			_xZkqqHx_jHoB_xHqqkZx_3_xZkqqHx_iBeG_xHqqkZx_	lValue	:1
 *					pList	:{ 1, 3, 4, 6, 8, 10 }
 *					Return	:1
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FFGetSmallerItemFromList (long lValue, const long* pList, long lListSize)
{
	const long* pItem = lower_bound(pList, pList + lListSize, lValue);
	if (pItem == pList) return pList[0];
	if (pItem == pList + lListSize) return pList[lListSize - 1];
	pItem--;
	return *pItem;
} // FFGetSmallerItemFromList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetLargerItemFromList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCgMiCpAjEhKjHpBjCiGiCkJiCoHjCfEiClFiPgPiClFiBeBjEhKjHpBjCiGiCmFiIoKiCmCjBoFiCkLiCkCjCgMiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lValue		:_xZkqqHx_jClCiCnHiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pList		:_xZkqqHx_jCgMiCmMjEhKjHpBiCpAiOhHjCoIiBeCiPlIiPiHiCmJiDfMiBfLiDgHiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			lListSize	:pList_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jEhKjHpBjCiGiCmFiIoKiCmCjBoFiCkLiCkCjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoB_xHqqkZx_1_xZkqqHx_iBeG_xHqqkZx_	lValue	:5
 *					pList	:{ 1, 3, 4, 6, 8, 10 }
 *					Return	:6
 *
 *			_xZkqqHx_jHoB_xHqqkZx_2_xZkqqHx_iBeG_xHqqkZx_	lValue	:4
 *					pList	:{ 1, 3, 4, 6, 8, 10 }
 *					Return	:6
 *
 *			_xZkqqHx_jHoB_xHqqkZx_3_xZkqqHx_iBeG_xHqqkZx_	lValue	:10
 *					pList	:{ 1, 3, 4, 6, 8, 10 }
 *					Return	:10
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FFGetLargerItemFromList (long lValue, const long* pList, long lListSize)
{
	const long* pItem = upper_bound(pList, pList + lListSize, lValue);
	if (pItem == pList + lListSize) return pList[lListSize - 1];
	return *pItem;
} // FFGetLargerItemFromList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopyHandle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgOiDjDiDgIiDiLiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	h		:_xZkqqHx_iDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nFlags	:GlobalAlloc_xZkqqHx_iCmMiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiClDiCoKiClNiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HANDLE FFCopyHandle (HANDLE h, UINT nFlags)
{
	DWORD dwLen = GlobalSize(h);
	HANDLE hCopy;
	if (hCopy = GlobalAlloc(nFlags, dwLen))
	{
		BYTE* lpCopy = (BYTE *)GlobalLock(hCopy);
		BYTE* lp     = (BYTE *)GlobalLock(h);
		while (dwLen--) *lpCopy++ = *lp++;
		GlobalUnlock(hCopy);
		GlobalUnlock(h);
	}
	return hCopy;
} // FFCopyHandle.

//----------</NOT EXPORT TO VIEWER>-----------
