#include "stdafx.h"
#include <algorithm>	// For find template.
#include "resource.h"	// For IDS_XXX.
#include "UtilStr.h"	// For GetResString.
#include "UtilPrint.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

struct FDPaperRec
{
	DWORD	m_dwName;
	double	m_mmWidth;
	double	m_mmHeight;
	short	m_nPaperType;
};

#ifndef DMPAPER_A6
#define DMPAPER_A6                  70  // A6 105 x 148 mm.
#endif//!DMPAPER_A6

#ifndef DMPAPER_JENV_CHOU3
#define DMPAPER_JENV_CHOU3          73  // Japanese Envelope Chou #3.
#endif//!DMPAPER_JENV_CHOU3

#ifndef DMPAPER_JENV_CHOU4
#define DMPAPER_JENV_CHOU4          74  // Japanese Envelope Chou #4.
#endif//!DMPAPER_JENV_CHOU4

static FDPaperRec s_aPaperRec[] =
{
	{ IDS_PAPER_USER,               100.0	,100.0	,-1 },
	{ IDS_PAPER_LETTER,             215.9	,279.4	,DMPAPER_LETTER },
	{ IDS_PAPER_LEGAL,              215.9	,355.6	,DMPAPER_LEGAL },
	{ IDS_PAPER_A4,                 210.0	,297.0	,DMPAPER_A4 },
	{ IDS_PAPER_CSHEET,             431.8	,558.8	,DMPAPER_CSHEET },
	{ IDS_PAPER_DSHEET,             558.8	,863.6	,DMPAPER_DSHEET },
	{ IDS_PAPER_ESHEET,             863.6	,1117.6	,DMPAPER_ESHEET },
	{ IDS_PAPER_LETTERSMALL,        215.9	,279.4	,DMPAPER_LETTERSMALL },
	{ IDS_PAPER_TABLOID,            279.4	,431.8	,DMPAPER_TABLOID },
	{ IDS_PAPER_LEDGER,             431.8	,279.4	,DMPAPER_LEDGER },
	{ IDS_PAPER_STATEMENT,          139.7	,215.9	,DMPAPER_STATEMENT },
// 05.05.14 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	{ IDS_PAPER_EXECUTIVE,          184.150	,266.7	,DMPAPER_EXECUTIVE },
	{ IDS_PAPER_EXECUTIVE,          184.2	,266.7	,DMPAPER_EXECUTIVE },
	{ IDS_PAPER_A2,                 420.0	,594.0	,DMPAPER_A2 },
	{ IDS_PAPER_A3,                 297.0	,420.0	,DMPAPER_A3 },
	{ IDS_PAPER_A4SMALL,            210.0	,297.0	,DMPAPER_A4SMALL },
	{ IDS_PAPER_A5,                 148.0	,210.0	,DMPAPER_A5 },
	{ IDS_PAPER_A6,                 105.0	,148.0	,DMPAPER_A6 },
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	{ IDS_PAPER_B4,                 250.0	,354.0	,DMPAPER_B4 },
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	{ IDS_PAPER_B4,                 257.0	,364.0	,-2 },
	{ IDS_PAPER_B4SMALL,            250.0	,354.0	,DMPAPER_B4 },
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	{ IDS_PAPER_B5,                 182.0	,257.0	,DMPAPER_B5 },
	{ IDS_PAPER_FOLIO,              215.9	,330.2	,DMPAPER_FOLIO },
	{ IDS_PAPER_QUARTO,             215.0	,275.0	,DMPAPER_QUARTO },
	{ IDS_PAPER_10X14,              254.0	,355.6	,DMPAPER_10X14 },
	{ IDS_PAPER_11X17,              279.4	,431.8	,DMPAPER_11X17 },
	{ IDS_PAPER_NOTE,               215.9	,279.4	,DMPAPER_NOTE },
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	{ IDS_PAPER_ENV_9,              98.425	,225.425,DMPAPER_ENV_9 },
//	{ IDS_PAPER_ENV_10,             104.775	,241.3	,DMPAPER_ENV_10 },
//	{ IDS_PAPER_ENV_11,             114.3	,263.525,DMPAPER_ENV_11 },
//	{ IDS_PAPER_ENV_12,             120.650	,279.4	,DMPAPER_ENV_12 },
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	{ IDS_PAPER_ENV_9,              98.4	,225.4,	DMPAPER_ENV_9 },
	{ IDS_PAPER_ENV_10,             104.8	,241.3	,DMPAPER_ENV_10 },
	{ IDS_PAPER_ENV_11,             114.3	,263.5	,DMPAPER_ENV_11 },
	{ IDS_PAPER_ENV_12,             120.7	,279.4	,DMPAPER_ENV_12 },
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	{ IDS_PAPER_ENV_14,             127.0	,292.1	,DMPAPER_ENV_14 },
	{ IDS_PAPER_ENV_DL,             110.0	,220.0	,DMPAPER_ENV_DL },
	{ IDS_PAPER_ENV_C5,             162.0	,229.0	,DMPAPER_ENV_C5 },
	{ IDS_PAPER_ENV_C3,             324.0	,458.0	,DMPAPER_ENV_C3 },
	{ IDS_PAPER_ENV_C4,             229.0	,324.0	,DMPAPER_ENV_C4 },
	{ IDS_PAPER_ENV_C6,             114.0	,162.0	,DMPAPER_ENV_C6 },
	{ IDS_PAPER_ENV_C65,            114.0	,229.0	,DMPAPER_ENV_C65 },
	{ IDS_PAPER_ENV_B4,             250.0	,353.0	,DMPAPER_ENV_B4 },
	{ IDS_PAPER_ENV_B5,             176.0	,250.0	,DMPAPER_ENV_B5 },
	{ IDS_PAPER_ENV_B6,             176.0	,125.0	,DMPAPER_ENV_B6 },
	{ IDS_PAPER_ENV_ITALY,          110.0	,230.0	,DMPAPER_ENV_ITALY },
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	{ IDS_PAPER_ENV_MONARCH,        98.425	,190.5	,DMPAPER_ENV_MONARCH },
//	{ IDS_PAPER_ENV_PERSONAL,       92.075	,165.1	,DMPAPER_ENV_PERSONAL },
//	{ IDS_PAPER_FANFOLD_US,         377.825	,279.4	,DMPAPER_FANFOLD_US },
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	{ IDS_PAPER_ENV_MONARCH,        98.4	,190.5	,DMPAPER_ENV_MONARCH },
	{ IDS_PAPER_ENV_PERSONAL,       92.1	,165.1	,DMPAPER_ENV_PERSONAL },
	{ IDS_PAPER_FANFOLD_US,         377.8	,279.4	,DMPAPER_FANFOLD_US },
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	{ IDS_PAPER_FANFOLD_STD_GERMAN, 215.9	,304.8	,DMPAPER_FANFOLD_STD_GERMAN },
	{ IDS_PAPER_FANFOLD_LGL_GERMAN, 215.9	,330.2	,DMPAPER_FANFOLD_LGL_GERMAN },
	{ IDS_PAPER_JAPANESE_POSTCARD,  100.0	,148.0	,DMPAPER_JAPANESE_POSTCARD },
	{ IDS_PAPER_JENV_CHOU3,         120.0	,235.0	,DMPAPER_JENV_CHOU3 },
	{ IDS_PAPER_JENV_CHOU4,         90.0	,205.0	,DMPAPER_JENV_CHOU4 },
};

int PaperTypeToIndex (short nPaperType)
{
	const int iSize = PaperIndexSize();
	for (int iC = 0; iC < iSize; iC++)
	{
		if (s_aPaperRec[iC].m_nPaperType == nPaperType) return iC;
	}
	return -1;
} // BOOL PaperTypeToPaperIndex.

//----- 03.07.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//const wchar_t* GetPaperName (int index)
//{
//	return GetResWString(s_aPaperRec[index].m_dwName);
//} // wchar_t* GetPaperName.
//----- 03.07.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
WString GetPaperName (int index)
{
	return FFLoadWString(s_aPaperRec[index].m_dwName);
} // wchar_t* GetPaperName.
//----- 03.07.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

double GetPaperWidth (int index, short nOrient)
{
	if (nOrient == DMORIENT_PORTRAIT)
		return s_aPaperRec[index].m_mmWidth;
	else
		return s_aPaperRec[index].m_mmHeight;
} // GetPaperWidth.

double GetPaperHeight (int index, short nOrient)
{
	if (nOrient == DMORIENT_PORTRAIT)
		return s_aPaperRec[index].m_mmHeight;
	else
		return s_aPaperRec[index].m_mmWidth;
} // GetPaperHeight.

short GetPaperType (int index)
{
	return s_aPaperRec[index].m_nPaperType;
} // GetPaperType.

int PaperIndexSize ()
{
	return sizeof(s_aPaperRec) / sizeof(s_aPaperRec[0]);
} // int PaperIndexSize ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcHardMargin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiBfLiDgIiDeFiDeGiDeBiCmMjHfNjEjCiCpAiMhGiOfKiBeFiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmMarginL, mmMarginT, mmMarginR, mmMarginB	:_xZkqqHx_jHfNjEjCiCpAjFnEiClHiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CalcHardMargin (double& mmMarginL, double& mmMarginT,
					 double& mmMarginR, double& mmMarginB, CDC* pDC)
{
	// _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiNlGiPoDiDhNiBfLiDfHiDjD_xHqqkZx_(Pixel_xZkqqHx_jCfAiImK_xHqqkZx_)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	const long pxMarginL = pDC->GetDeviceCaps(PHYSICALOFFSETX);
	const long pxMarginT = pDC->GetDeviceCaps(PHYSICALOFFSETY);
	// _xZkqqHx_jHhAiOiGiCmMiDfEiDeDiDfJ_xHqqkZx_(Pixel_xZkqqHx_jCfAiImK_xHqqkZx_)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	const long pxPaperW = pDC->GetDeviceCaps(PHYSICALWIDTH);
	const long pxPaperH = pDC->GetDeviceCaps(PHYSICALHEIGHT);
	const long pxPrinterW = pDC->GetDeviceCaps(HORZRES);
	const long pxPrinterH = pDC->GetDeviceCaps(VERTRES);

	if (pxPaperW == 0 || pxPaperH == 0)
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiImIiKePiCmMiPoKiNiHiBgJiDhGiDiMiDhCiDiFiBfLjDjJiBgK_xHqqkZx_-----
	{
		mmMarginL = 0.0;
		mmMarginT = 0.0;
		mmMarginR = 0.0;
		mmMarginB = 0.0;
	} else
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiJeFiJlKiDhNiBfLiDfHiDjD_xHqqkZx_(Pixel_xZkqqHx_jCfAiImK_xHqqkZx_)_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
		const long pxMarginR = pxPaperW - pxPrinterW - pxMarginL;
		const long pxMarginB = pxPaperH - pxPrinterH - pxMarginT;
		// _xZkqqHx_iDhGiDiKiDjDiDfOiCmMjAlIiNnHjDhI_xHqqkZx_(DPI)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		const long lDpiX = pDC->GetDeviceCaps(LOGPIXELSX);
		const long lDpiY = pDC->GetDeviceCaps(LOGPIXELSY);
		// _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiMmAiKeFiCmMjHfNjEjCiCpAiMhGiOfKiBeC_xHqqkZx_
		mmMarginL = 25.4 * double(pxMarginL) / double(lDpiX);
		mmMarginT = 25.4 * double(pxMarginT) / double(lDpiY);
		mmMarginR = 25.4 * double(pxMarginR) / double(lDpiX);
		mmMarginB = 25.4 * double(pxMarginB) / double(lDpiY);
	}
} // void CalcHardMargin.

//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcPaperSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiCmMjHhAiOiGiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmWidth		:_xZkqqHx_jHhAiOiGjFjNiCpAjFnEiClHiBeC_xHqqkZx_
// *			mmHeight	:_xZkqqHx_jHhAiOiGiNiCiCpAjFnEiClHiBeC_xHqqkZx_
// *			pMode		:_xZkqqHx_iDhGiDiKiDjDiDfOiCmM_xHqqkZx_DEVMODE_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pDC			:_xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CalcPaperSize (mmetol& mmWidth, mmetol& mmHeight, DEVMODE* pMode, CDC* pDC)
//{
//	//----- _xZkqqHx_jHhAiOiGiCmMiDfEiDeDiDfJiCpAiMhGiOfKiClHiCoJ_xHqqkZx_ -----
//	const int index = PaperTypeToIndex(pMode->dmPaperSize);
//	if (index < 0)
//	{
//		// _xZkqqHx_jHhAiOiGiCmMiDfEiDeDiDfJ_xHqqkZx_(Pixel_xZkqqHx_jCfAiImK_xHqqkZx_)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//		const long pxPaperW = pDC->GetDeviceCaps(PHYSICALWIDTH);
//		const long pxPaperH = pDC->GetDeviceCaps(PHYSICALHEIGHT);
//		// _xZkqqHx_iDhGiDiKiDjDiDfOiCmMjAlIiNnHjDhI_xHqqkZx_(DPI)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//		const long lDpiX = pDC->GetDeviceCaps(LOGPIXELSX);
//		const long lDpiY = pDC->GetDeviceCaps(LOGPIXELSY);
//		// _xZkqqHx_jHhAiOiGiCmMiDfEiDeDiDfJ_xHqqkZx_(mm_xZkqqHx_jCfAiImK_xHqqkZx_)_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
//		mmWidth = 25.4 * double(pxPaperW) / double(lDpiX);
//		mmHeight = 25.4 * double(pxPaperH) / double(lDpiY);
//	} else
//	{
//		// _xZkqqHx_jHhAiOiGiCmMiDfEiDeDiDfJ_xHqqkZx_(mm_xZkqqHx_jCfAiImK_xHqqkZx_)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
//		mmWidth = ::GetPaperWidth(index, pMode->dmOrientation);
//		mmHeight = ::GetPaperHeight(index, pMode->dmOrientation);
//	}
//} // GetPaperSize.
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetPaperSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiCmMjHhAiOiGiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmWidth		:_xZkqqHx_jHhAiOiGjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmHeight	:_xZkqqHx_jHhAiOiGiNiCiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDevice	:_xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpPort		:_xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pMode		:_xZkqqHx_iDhGiDiKiDjDiDfOiCmM_xHqqkZx_DEVMODE_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiDgIiDiJiDeDiDgPiCmJjGoCiCkCiNiHiCoNiClJiCmEjHhAiOiGiDfEiDeDiDfJiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *			mmWidth, mmHeight _xZkqqHx_iCmJiCmNiBeBjHhAiOiGiCmMiMpMiCkLiBgJiPgDiBeFiJkBiBgKiCpAiNgMjHlGiClFiClN_xHqqkZx_
 *			_xZkqqHx_jCgMiCkKjAnNjCoIiClDiCoKiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFGetPaperSize (mmetol& mmWidth,
					mmetol& mmHeight,
					const wchar_t* wcpDevice,
					const wchar_t* wcpPort,
					DEVMODE* pMode)
{
	WORDVector vPaperId;
	CPointVector vPaperSize;
	if (FFGetPaperIdList(vPaperId, wcpDevice, wcpPort) &&
		FFGetPaperSizeList(vPaperSize, wcpDevice, wcpPort))
	{
		// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
		WORDVector::const_iterator i = find(vPaperId.begin(), vPaperId.end(), pMode->dmPaperSize);
		if (i != vPaperId.end())
		{
			// _xZkqqHx_jHhAiOiGiCmMiDfEiDeDiDfJ_xHqqkZx_(0.1mm_xZkqqHx_jCfAiImK_xHqqkZx_)_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
			CPoint ptPaperSize = vPaperSize[i - vPaperId.begin()];
			// _xZkqqHx_jHhAiOiGiCmMiDfEiDeDiDfJ_xHqqkZx_(mm_xZkqqHx_jCfAiImK_xHqqkZx_)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
			mmWidth = double(ptPaperSize.x) / 10.0;
			mmHeight = double(ptPaperSize.y) / 10.0;
			// _xZkqqHx_jHhAiOiGiCkKiJkBiMpMiCkLiCmMiPoKiNiHiCmNjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
			if (pMode->dmOrientation == DMORIENT_LANDSCAPE)
				::Exchange(mmWidth, mmHeight);
			return TRUE;
		}
	}
	return FALSE;
} // FFGetPaperSize.
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetPaperName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiCmMjHhAiOiGjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrPaperName:_xZkqqHx_jHhAiOiGjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDevice	:_xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpPort		:_xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pMode		:_xZkqqHx_iDhGiDiKiDjDiDfOiCmM_xHqqkZx_DEVMODE_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiDgIiDiJiDeDiDgPiCmJjGoCiCkCiNiHiCoNiClJiCmEjHhAiOiGjGlMiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFGetPaperName (WString& wstrPaperName,
					const wchar_t* wcpDevice,
					const wchar_t* wcpPort,
					DEVMODE* pMode)
{
	WORDVector vPaperId;
	WStringVector vPaperName;
	if (FFGetPaperIdList(vPaperId, wcpDevice, wcpPort) &&
		FFGetPaperNameList(vPaperName, wcpDevice, wcpPort))
	{
		// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
		WORDVector::const_iterator i = find(vPaperId.begin(), vPaperId.end(), pMode->dmPaperSize);
		if (i != vPaperId.end())
		{
			// _xZkqqHx_jHhAiOiGjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
			wstrPaperName = vPaperName[i - vPaperId.begin()];
			return TRUE;
		}
	}
	return FALSE;
} // FFGetPaperName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPaperSizeToId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMjHhAiOiGiDfEiDeDiDfJiCkJiCoHjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wPaperId	:_xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDevice	:_xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpPort		:_xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptPaperSize	:_xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCpAiOhHjCoIiBeCjHhAiOiGiCmMiMpMiCkLiCmNiPgDiCmMiPoKiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCmMjCfAiImKiCmN_xHqqkZx_0.1mm_xZkqqHx_iBeC_xHqqkZx_
 *			wPaperIdReccomended
 *						:_xZkqqHx_jDkPiClGjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCkKjFkBjAjEiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmJiBeBjHeEjAoGiClFiCmEjBeJjBpAiClHiCoJ_xHqqkZx_
 *						 _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_WORD(-1)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiDgIiDiJiDeDiDgPiCmJjGoCiCkCiNiHiCoNiClJiCmEiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiKiDjDiDfOiCmJiBeBiOhHjCoIiClDiCoKiClNjHhAiOiGiDfEiDeDiDfJiCkKjDpBiCmCiImIiPoDjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *			wPaperIdReccomended _xZkqqHx_iCmGiIoKjChGiClHiCoJjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAjHeEjAoGiClHiCoJiBeC_xHqqkZx_
 *			wPaperIdReccomended _xZkqqHx_iCmGiIoKjChGiClHiCoJjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiCoAjCgMiCmMiPkMiClDiCkCjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFPaperSizeToId (	WORD& wPaperId,
						const wchar_t* wcpDevice,
						const wchar_t* wcpPort,
						const CPoint& ptPaperSize,
						WORD wPaperIdReccomended)
{
	// _xZkqqHx_iDhGiDiKiDjDiDfOiCmMjHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCmGjHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	WORDVector vPaperId;
	CPointVector vPaperSize;
	if (FFGetPaperIdList(vPaperId, wcpDevice, wcpPort) &&
		FFGetPaperSizeList(vPaperSize, wcpDevice, wcpPort))
	//----- _xZkqqHx_jHhAiOiGjEhKjHpBiCkKiOoGjDlOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCpAiMjPiNpFiBeC_xHqqkZx_
		WORDSet stPaperId;
		CPointVector::iterator i = vPaperSize.begin() - 1;
		for (;;)
		{
			i = find(i + 1, vPaperSize.end(), ptPaperSize);
			if (i == vPaperSize.end()) break;
			stPaperId.insert(vPaperId[i - vPaperSize.begin()]);
		}
		if (!stPaperId.empty())
		//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
			if (stPaperId.find(wPaperIdReccomended) != stPaperId.end())
				wPaperId = wPaperIdReccomended;
			else
				wPaperId = *stPaperId.begin();
			return TRUE;
		}
	}
	return FALSE;
} // FFPaperSizeToId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPaperIdToSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCkJiCoHjHhAiOiGiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ptPaperSize	:_xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCpAjFnEiClHiBeCjHhAiOiGiCmMiMpMiCkLiCmNiPgDiCmMiPoKiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *						 _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCmMjCfAiImKiCmN_xHqqkZx_0.1mm_xZkqqHx_iBeC_xHqqkZx_
 *			wcpDevice	:_xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpPort		:_xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wPaperId	:_xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiDgIiDiJiDeDiDgPiCmJjGoCiCkCiNiHiCoNiClJiCmEiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFPaperIdToSize (	CPoint& ptPaperSize,
						const wchar_t* wcpDevice,
						const wchar_t* wcpPort,
						WORD wPaperId)
{
	// _xZkqqHx_iDhGiDiKiDjDiDfOiCmMjHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCmGjHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	WORDVector vPaperId;
	CPointVector vPaperSize;
	if (FFGetPaperIdList(vPaperId, wcpDevice, wcpPort) &&
		FFGetPaperSizeList(vPaperSize, wcpDevice, wcpPort))
	//----- _xZkqqHx_jHhAiOiGjEhKjHpBiCkKiOoGjDlOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
		WORDVector::const_iterator i = find(vPaperId.begin(), vPaperId.end(), wPaperId);
		if (i != vPaperId.end())
		//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
			ptPaperSize = vPaperSize[i - vPaperId.begin()];
			return TRUE;
		}
	}
	return FALSE;
} // FFPaperIdToSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcAutoMargin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHfNjEjCiOkJjDkOiCmMiPoKiNiHiBeBjFlGiPjBjHfNjEjCiCmMiDfEiDeDiDfJiCkJiCoHiOmAiNnLiCmMiIpDiNpMjHhAiOiGiCmMjHfNjEjCiCpA_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmMarginL		:_xZkqqHx_iIpDiNpMjHhAiOiGjHfNjEjCiNlGiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmMarginT		:_xZkqqHx_iIpDiNpMjHhAiOiGjHfNjEjCiPoDiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmMarginR		:_xZkqqHx_iIpDiNpMjHhAiOiGjHfNjEjCiJeFiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmMarginB		:_xZkqqHx_iIpDiNpMjHhAiOiGjHfNjEjCiJlKiCpAjFnEiClHiBeC_xHqqkZx_
 *			dRatio			:_xZkqqHx_iIpDiNpMiKgHjBoFjHkGiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmDocPaperW		:_xZkqqHx_jFlGiPjBjHhAiOiGjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDocPaperH		:_xZkqqHx_jFlGiPjBjHhAiOiGiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDocPageW		:_xZkqqHx_jFlGiPjBiDhJiBfLiDfHjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDocPageH		:_xZkqqHx_jFlGiPjBiDhJiBfLiDfHiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDocMarginL	:_xZkqqHx_jFlGiPjBjHfNjEjCiNlGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDocMarginT	:_xZkqqHx_jFlGiPjBjHfNjEjCiPoDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDocMarginR	:_xZkqqHx_jFlGiPjBjHfNjEjCiJeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDocMarginB	:_xZkqqHx_jFlGiPjBjHfNjEjCiJlKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmPrnPaperW		:_xZkqqHx_iIpDiNpMjHhAiOiGjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmPrnPaperH		:_xZkqqHx_iIpDiNpMjHhAiOiGiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmHardMarginL	:_xZkqqHx_iIpDiNpMiMmAjDhIjHfNjEjCiNlGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmHardMarginT	:_xZkqqHx_iIpDiNpMiMmAjDhIjHfNjEjCiPoDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmHardMarginR	:_xZkqqHx_iIpDiNpMiMmAjDhIjHfNjEjCiJeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmHardMarginB	:_xZkqqHx_iIpDiNpMiMmAjDhIjHfNjEjCiJlKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CalcAutoMargin (mmetol& mmMarginL, mmetol& mmMarginT,
					mmetol& mmMarginR, mmetol& mmMarginB, double& dRatio,
					mmetol mmDocPaperW, mmetol mmDocPaperH,
					mmetol mmDocPageW, mmetol mmDocPageH,
					mmetol mmDocMarginL, mmetol mmDocMarginT,
					mmetol mmDocMarginR, mmetol mmDocMarginB,
					mmetol mmPrnPaperW, mmetol mmPrnPaperH,
					mmetol mmHardMarginL, mmetol mmHardMarginT,
					mmetol mmHardMarginR, mmetol mmHardMarginB)
{
//----- 00.09.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	ASSERT(!almost0(mmDocPaperW));
	ASSERT(!almost0(mmDocPaperH));
//----- 00.09.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_jFlGiPjBjHhAiOiGiCmJjBmOiClHiCoJjFlGiPjBjHhAiOiGjHfNjEjCiCmMiKiEiNiHiCkJiCoHiIpDiNpMjHhAiOiGjHfNjEjCiCpAiOfKiPgP_xHqqkZx_ -----
	mmMarginL = mmPrnPaperW * (mmDocMarginL / mmDocPaperW);
	mmMarginT = mmPrnPaperH * (mmDocMarginT / mmDocPaperH);
	mmMarginR = mmPrnPaperW * (mmDocMarginR / mmDocPaperW);
	mmMarginB = mmPrnPaperH * (mmDocMarginB / mmDocPaperH);

	//----- _xZkqqHx_iIpDiNpMjHhAiOiGjHfNjEjCiCkKiIpDiNpMiMmAjDhIiCpAjClEiCkGiCmEiCkCiClNiCoHiBeBiMmAjDhIiCmMjCgMiCmJjFoCjAlD_xHqqkZx_ -----
	if (mmMarginL < mmHardMarginL) mmMarginL = mmHardMarginL;
	if (mmMarginT < mmHardMarginT) mmMarginT = mmHardMarginT;
	if (mmMarginR < mmHardMarginR) mmMarginR = mmHardMarginR;
	if (mmMarginB < mmHardMarginB) mmMarginB = mmHardMarginB;

	//----- _xZkqqHx_iNlGiJeFiIpDiNpMjHhAiOiGjHfNjEjCiCmMiJmBiOfKiCkKiIpDiNpMjHhAiOiGjFjNiCpAjClEiCkGiCmEiCkCiClNiCoHjFoCjAlD_xHqqkZx_ -----
	if (mmPrnPaperW <= mmMarginL + mmMarginR)
	{
		mmMarginL = mmHardMarginL;
		mmMarginR = mmHardMarginR;
	}
	//----- _xZkqqHx_iPoDiJlKiIpDiNpMjHhAiOiGjHfNjEjCiCmMiJmBiOfKiCkKiIpDiNpMjHhAiOiGiNiCiCpAjClEiCkGiCmEiCkCiClNiCoHjFoCjAlD_xHqqkZx_ -----
	if (mmPrnPaperH <= mmMarginT + mmMarginB)
	{
		mmMarginT = mmHardMarginT;
		mmMarginB = mmHardMarginB;
	}

	//----- _xZkqqHx_iIpDiNpMiDhJiBfLiDfHiDfEiDeDiDfJiCpAiJlMiMhGiOfK_xHqqkZx_ -----
	mmetol mmTmpPrnPageW = mmPrnPaperW - mmMarginL - mmMarginR;
	mmetol mmTmpPrnPageH = mmPrnPaperH - mmMarginT - mmMarginB;

//----- 00.09.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	ASSERT(!almost0(mmDocPageW));
	ASSERT(!almost0(mmDocPageH));
//----- 00.09.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iIpDiNpMiDhJiBfLiDfHiCmGjFlGiPjBiDhJiBfLiDfHiCmMjEoEjHkGiBgJiKgHjBoFjHkGiBgKiCpAiMhGiOfK_xHqqkZx_ -----
	double x = mmTmpPrnPageW / mmDocPageW;
	double y = mmTmpPrnPageH / mmDocPageH;
	dRatio = (x < y) ? x : y;

	//----- _xZkqqHx_iKgHjBoFjHkGiCkJiCoHiIpDiNpMiDhJiBfLiDfHiCpAiOfKiPgP_xHqqkZx_ -----
	mmetol mmPrnPageW = mmDocPageW * dRatio;
	mmetol mmPrnPageH = mmDocPageH * dRatio;

	//----- _xZkqqHx_jFlGiPjBiDhJiBfLiDfHiCmJiKgHjBoFjHkGiCpAiKhMiCkPiClNiCoHiIpDiNpMiDhJiBfLiDfHiCmJiCmIiCoJiCoGiCkEiCmJiBeBjHfNjEjCiCpAjFoCjAlD_xHqqkZx_ -----
	mmetol mmDiffX = (mmTmpPrnPageW - mmPrnPageW) / 2.0;
	mmetol mmDiffY = (mmTmpPrnPageH - mmPrnPageH) / 2.0;
	mmMarginL += mmDiffX;
	mmMarginT += mmDiffY;
	mmMarginR += mmDiffX;
	mmMarginB += mmDiffY;
} // CalcAutoMargin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetDeviceName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DEVNAMES_xZkqqHx_iNfMjBkCjBmMiCkJiCoHiDgGiDgPiDeDiDfIjGlMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpDevNames	:DEVNAMES_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiDgPiDeDiDfIjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetDeviceName (LPDEVNAMES lpDevNames)
{
	// _xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	return AStrToWStr(((char*)lpDevNames) + lpDevNames->wDeviceOffset);
} // FFGetDeviceName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetPortName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DEVNAMES_xZkqqHx_iNfMjBkCjBmMiCkJiCoHiDhMiBfLiDgHjGlMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpDevNames	:DEVNAMES_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhMiBfLiDgHjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetPortName (LPDEVNAMES lpDevNames)
{
	// _xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	return AStrToWStr(((char*)lpDevNames) + lpDevNames->wOutputOffset);
} // FFGetPortName.

//----- 05.05.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetPaperSizeList
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMjHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCmGjHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPaperId	:_xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			vPaperSize	:_xZkqqHx_iPgDiBgJiDhMiBfLiDgHiDiMiBfLiDgHiBgKiCmMiPoKiNiHiCmMjHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *						 _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCmMjCfAiImKiCmN_xHqqkZx_0.1mm_xZkqqHx_iBeC_xHqqkZx_
// *			lpDevNames	:DEVNAMES_xZkqqHx_iNfMjBkCjBmMiCpAjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiCkKiOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiDgIiDiJiDeDiDgPiCmJjGoCiCkCiNiHiCoNiClJiCpAiClFiCmEiBeBjHhAiOiGiCmMiIoKjHjHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFGetPaperSizeList (	WORDVector& vPaperId,
//							CPointVector& vPaperSize,
//							LPDEVNAMES lpDevNames)
//{
//	// _xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
//	const WString wstrDevice = AStrToWStr(((char*)lpDevNames) + lpDevNames->wDeviceOffset);
//	// _xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
//	const WString wstrPort = AStrToWStr(((char*)lpDevNames) + lpDevNames->wOutputOffset);
//	return FFGetPaperSizeList(	vPaperId,
//								vPaperSize,
//								wstrDevice,
//								wstrPort);
//} // FFGetPaperSizeList.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetPaperSizeList
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMjHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCmGjHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPaperId	:_xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			vPaperSize	:_xZkqqHx_iPgDiBgJiDhMiBfLiDgHiDiMiBfLiDgHiBgKiCmMiPoKiNiHiCmMjHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *						 _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCmMjCfAiImKiCmN_xHqqkZx_0.1mm_xZkqqHx_iBeC_xHqqkZx_
// *			wcpDevice	:_xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpPort		:_xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiCkKiOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiDgIiDiJiDeDiDgPiCmJjGoCiCkCiNiHiCoNiClJiCpAiClFiCmEiBeBjHhAiOiGiCmMiIoKjHjHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFGetPaperSizeList (	WORDVector& vPaperId,
//							CPointVector& vPaperSize,
//							const wchar_t* wcpDevice,
//							const wchar_t* wcpPort)
//{
//	// _xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
//	const CString strDevice = WStrToTStr(wcpDevice);
//	// _xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
//	const CString strPort = WStrToTStr(wcpPort);
//	//----- _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//	DWORD dwDataSize = DeviceCapabilities(strDevice, strPort, DC_PAPERS, NULL, NULL);
//	// _xZkqqHx_iDgGiBfLiDfOiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
//	if (dwDataSize == 0 || dwDataSize == DWORD(-1)) return FALSE;
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
//	vPaperId.assign(dwDataSize);
//	// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
//	DeviceCapabilities(strDevice, strPort, DC_PAPERS, (LPTSTR)vPaperId.begin(), NULL);
//
//	//----- _xZkqqHx_jHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//	dwDataSize = DeviceCapabilities(strDevice, strPort, DC_PAPERSIZE, NULL, NULL);
//	// _xZkqqHx_iDgGiBfLiDfOiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
//	if (dwDataSize == 0 || dwDataSize == DWORD(-1)) return FALSE;
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
//	vPaperSize.assign(dwDataSize);
//	// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
//	DeviceCapabilities(strDevice, strPort, DC_PAPERSIZE, (LPTSTR)vPaperSize.begin(), NULL);
//	return TRUE;
//} // FFGetPaperSizeList.
//
//----- 05.05.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetPaperIdList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMjHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPaperId	:_xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDevice	:_xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpPort		:_xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiDgIiDiJiDeDiDgPiCmJjGoCiCkCiNiHiCoNiClJiCpAiClFiCmEiBeBiIoKjHjHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFGetPaperIdList (	WORDVector& vPaperId,
						const wchar_t* wcpDevice,
						const wchar_t* wcpPort)
{
	// _xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	const CString strDevice = WStrToTStr(wcpDevice);
	// _xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	const CString strPort = WStrToTStr(wcpPort);
	//----- _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	// _xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwDataSize = DeviceCapabilities(strDevice, strPort, DC_PAPERS, NULL, NULL);
	// _xZkqqHx_iDgGiBfLiDfOiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (dwDataSize == 0 || dwDataSize == DWORD(-1)) return FALSE;
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
	vPaperId.assign(dwDataSize);
	// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	DeviceCapabilities(strDevice, strPort, DC_PAPERS, (LPTSTR)vPaperId.begin(), NULL);
	return TRUE;
} // FFGetPaperIdList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetPaperSizeList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMjHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPaperSize	:_xZkqqHx_iPgDiBgJiDhMiBfLiDgHiDiMiBfLiDgHiBgKiCmMiPoKiNiHiCmMjHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *						 _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCmMjCfAiImKiCmN_xHqqkZx_0.1mm_xZkqqHx_iBeC_xHqqkZx_
 *			wcpDevice	:_xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpPort		:_xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiDgIiDiJiDeDiDgPiCmJjGoCiCkCiNiHiCoNiClJiCpAiClFiCmEiBeBiIoKjHjHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFGetPaperSizeList (	CPointVector& vPaperSize,
							const wchar_t* wcpDevice,
							const wchar_t* wcpPort)
{
	// _xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	const CString strDevice = WStrToTStr(wcpDevice);
	// _xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	const CString strPort = WStrToTStr(wcpPort);
	//----- _xZkqqHx_jHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	// _xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwDataSize = DeviceCapabilities(strDevice, strPort, DC_PAPERSIZE, NULL, NULL);
	// _xZkqqHx_iDgGiBfLiDfOiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (dwDataSize == 0 || dwDataSize == DWORD(-1)) return FALSE;
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
	vPaperSize.assign(dwDataSize);
	// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	DeviceCapabilities(strDevice, strPort, DC_PAPERSIZE, (LPTSTR)vPaperSize.begin(), NULL);
	return TRUE;
} // FFGetPaperSizeList.

//----- 05.05.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetPaperNameList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMjHhAiOiGjGlMjEhKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPaperName	:_xZkqqHx_jHhAiOiGjGlMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDevice	:_xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpPort		:_xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiDgIiDiJiDeDiDgPiCmJjGoCiCkCiNiHiCoNiClJiCpAiClFiCmEiBeBiIoKjHjHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFGetPaperNameList (	WStringVector& vPaperName,
							const wchar_t* wcpDevice,
							const wchar_t* wcpPort)
{
	// _xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	const CString strDevice = WStrToTStr(wcpDevice);
	// _xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	const CString strPort = WStrToTStr(wcpPort);
	//----- _xZkqqHx_jHhAiOiGjGlMjEhKjHpBiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	// _xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwDataSize = DeviceCapabilities(strDevice, strPort, DC_PAPERNAMES, NULL, NULL);
	// _xZkqqHx_iDgGiBfLiDfOiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (dwDataSize == 0 || dwDataSize == DWORD(-1)) return FALSE;
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
	BYTEVector vBuff(dwDataSize * 64);
	vPaperName.clear();
	// _xZkqqHx_jHhAiOiGjGlMjEhKjHpBiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
	DeviceCapabilities(strDevice, strPort, DC_PAPERNAMES, (LPTSTR)vBuff.begin(), NULL);
	for (int iC = 0; iC < vBuff.size(); iC += 64)
	{
		const char* cpName = (const char*)(&vBuff[iC]);
		vPaperName.push_back(AStrToWStr(cpName));
	}
	return TRUE;
} // FFGetPaperNameList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFEvalPageNumberText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHjEnEiNiGiDhEiDeIiBfLiDiAjFlGiOjKjHpBiCpAiIpDiNpMjFlGiOjKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrEvalText	:_xZkqqHx_jFmPiKlHiMoDiCmMiIpDiNpMjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpText			:_xZkqqHx_jFmPiKlHjBePiCmMiDhEiDeIiBfLiDiAjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPageNumberInOne:_xZkqqHx_iDfGiBfLiDgHjCiGiCmMiDhJiBfLiDfHjEnEiNiGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPageNumberInAll:_xZkqqHx_jBfDiDfGiBfLiDgHiCmMiDhJiBfLiDfHjEnEiNiGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lTotalPageInOne	:_xZkqqHx_iDfGiBfLiDgHjCiGiCmMjBiNiDhJiBfLiDfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lTotalPageInAll	:_xZkqqHx_jBfDiDfGiBfLiDgHiCmMjBiNiDhJiBfLiDfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSheetNumber	:_xZkqqHx_iDfGiBfLiDgHjEnEiNiGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lTotalSheet		:_xZkqqHx_jBiNiDfGiBfLiDgHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpSheetTitle	:_xZkqqHx_iDfGiBfLiDgHiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDiAiCmJjFlGjGeAiDeHiDiJiBfLiCkKiCkAiCmBiCmEiCoAjGlDiOiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDiAjFlGiOjKjHpBiCmJiCmNiBeBiImIiJlKiCmMjFmPjAjEiCkKjHhAiInDiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			pn	:PageNumber in this sheet.
 *				_xZkqqHx_iDhJiBfLiDfHjEnEiNiGiBgJiDfGiBfLiDgHjCiGiBgK_xHqqkZx_
 *			PN	:PageNumber through all sheets.
 *				_xZkqqHx_iDhJiBfLiDfHjEnEiNiGiBgJjCmKiClFiBgK_xHqqkZx_
 *			pa	:TotalPageNumber in this sheet.
 *				_xZkqqHx_iDhJiBfLiDfHjBiNjAjEiBgJiDfGiBfLiDgHjCiGiBgK_xHqqkZx_
 *			PA	:TotalPageNumber through all sheets.
 *				_xZkqqHx_iDhJiBfLiDfHjBiNjAjEiBgJjCmKiClFiBgK_xHqqkZx_
 *			sn	:SheetNumber.
 *				_xZkqqHx_iDfGiBfLiDgHjEnEiNiGiBeC_xHqqkZx_
 *			sa	:TotalSheetNumber.
 *				_xZkqqHx_jBiNiDfGiBfLiDgHjAjEiBeC_xHqqkZx_
 *			st	:SheetTitle.
 *				_xZkqqHx_iDfGiBfLiDgHjGlMiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iClBiCoKiCoHiCmMiLeMiNiGiCmNiBeB_xHqqkZx_%_xZkqqHx_iCmFiImNiCkEiClBiCmGiCmFjFmPjAjEiCmGiClFiCmEiLeAjEfMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFmPjAjEjCiGiCmMiLeMiNiGiMoDiCmJjAjEjCgMiCpAjBkLiClFiCmEiBeBjFfMiOkGiMiFjAjEiCpAiOhHjCoIiCmFiCkLiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFmPjAjEjCiGiCmMiLeMiNiGiMoDiCmJiBeBiBhLiBhMiCmFiDeJiDhEiDfKiDgCiDgHiCpAiJmBiOfKiClHiCoJiClBiCmGiCkKiCmFiCkLiCoJiBeC_xHqqkZx_
 *			'\'_xZkqqHx_iLeMiNiGiCmMiMoDiCmMjFlGiOjKiCmNiBeBiClLiCmMiCnMiCnMjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiBeGiDfGiBfLiDgHjBiNjAjEiCmNiCfAiCePiBeBiCfAiDfGiBfLiDgHjGiIiCmJiCfDiDhJiBfLiDfHiCkKjBlGiNnNiClFiBeBiMlLiNnNiCmN_xHqqkZx_
 *				_xZkqqHx_iDfGiBfLiDgHiCfCiCmMiCfBiDhJiBfLiDfHjGnKiCmMiPoKiNiHiBeC_xHqqkZx_
 *			"-- %pn% --" _xZkqqHx_iBkI_xHqqkZx_ "-- 2 --"
 *			"-- %PN% --" _xZkqqHx_iBkI_xHqqkZx_ "-- 10 --"
 *			"-- %PN%/%PA% --" _xZkqqHx_iBkI_xHqqkZx_ "-- 10/40 --"
 *			"-- %pn4-1% --" _xZkqqHx_iBkI_xHqqkZx_ "-- 0001 --"
 *			"-- \%pn4-1% --" _xZkqqHx_iBkI_xHqqkZx_ "-- \%pn4-1 --"
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFEvalPageNumberText (	WString& wstrEvalText,
							const wchar_t* wcpText,
							long lPageNumberInOne,
							long lPageNumberInAll,
							long lTotalPageInOne,
							long lTotalPageInAll,
							long lSheetNumber,
							long lTotalSheet,
							const wchar_t* wcpSheetTitle)
{
	enum {
		NONE = 0,
		ANY_NUMBER,		// _xZkqqHx_iDhJiBfLiDfHiBeFiDfGiBfLiDgHjEnEiNiG_xHqqkZx_
		SHEET_TITLE,	// _xZkqqHx_iDfGiBfLiDgHjGlMiBeC_xHqqkZx_
	};
	wstrEvalText.Empty();
	while (wcpText[0] != L'\0')
	{
		if (wcpText[0] == L'\\')
		//----- \ _xZkqqHx_iCmFiOgOiCnMiCoJiPoKiNiH_xHqqkZx_ ----
		{
			// \ _xZkqqHx_iCpAjBjHiCoJiBeC_xHqqkZx_
			wcpText++;
			if (wcpText[0] != L'\0')
			//----- _xZkqqHx_iPeJjCfLiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iOjPiCmMjFlGiOjKiCpAjGlDiPpAiMiPiCmJjFfMiOkGiBeC_xHqqkZx_
				wstrEvalText += wcpText[0];
				// _xZkqqHx_jFlGiOjKiCpAjBjHiCoJiBeC_xHqqkZx_
				wcpText++;
			}
		} else
		if (wcpText[0] == L'%')
		//----- % _xZkqqHx_iCmFiOgOiCnMiCoJiPoKiNiH_xHqqkZx_ ----
		{
			// % _xZkqqHx_iCpAjBjHiCoJiBeC_xHqqkZx_
			wcpText++;
			// _xZkqqHx_iDhEiDeIiBfLiDiAiCmMiMfOiCpAjClCiCnHiCoJiBeC_xHqqkZx_
			int iForm = ANY_NUMBER;
			long lNumber;
			if (wcsncmp(wcpText, L"pn", 2) == 0)
			{
				lNumber = lPageNumberInOne;
			} else
			if (wcsncmp(wcpText, L"PN", 2) == 0)
			{
				lNumber = lPageNumberInAll;
			} else
			if (wcsncmp(wcpText, L"pa", 2) == 0)
			{
				lNumber = lTotalPageInOne;
			} else
			if (wcsncmp(wcpText, L"PA", 2) == 0)
			{
				lNumber = lTotalPageInAll;
			} else
			if (wcsncmp(wcpText, L"sn", 2) == 0)
			{
				lNumber = lSheetNumber;
			} else
			if (wcsncmp(wcpText, L"sa", 2) == 0)
			{
				lNumber = lTotalSheet;
			} else
			if (wcsncmp(wcpText, L"st", 2) == 0)
			{
				iForm = SHEET_TITLE;
			} else
			{
				iForm = NONE;
			}
			if (iForm == ANY_NUMBER)
			//----- _xZkqqHx_iDhJiBfLiDfHjAjEiBeBiDfGiBfLiDgHjAjEjDjJiCmMjAjEiMfOiCmFiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				long lFigure = -1;	// _xZkqqHx_jFfMiOkGiMiFjAjEiOhHjCoIiBeC_xHqqkZx_
				long lOffset = 0;	// _xZkqqHx_iDeJiDhEiDfKiDgCiDgHiOhHjCoIiBeC_xHqqkZx_
				// _xZkqqHx_iLeMiNiGiCpAjBjHiCoJiBeC_xHqqkZx_
				wcpText += 2;
				if (L'0' <= wcpText[0] && wcpText[0] <= L'9')
				//----- _xZkqqHx_iLeMiNiGiCmMiMoDiCmJjAjEjCgMiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_jFfMiOkGiMiFjAjEiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
					lFigure = wcstol(wcpText, (wchar_t**)&wcpText, 10);
				}
				if (wcpText[0] == L'-')
				//----- _xZkqqHx_iBhMjFiEiNiGiCmFiDeJiDhEiDfKiDgCiDgHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_jFiEiNiGiCpAjBjHiCoJiBeC_xHqqkZx_
					wcpText++;
					// _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
					lOffset = -wcstol(wcpText, (wchar_t**)&wcpText, 10);
				} else
				if (wcpText[0] == L'+')
				//----- _xZkqqHx_iBhLjFiEiNiGiCmFiDeJiDhEiDfKiDgCiDgHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_jFiEiNiGiCpAjBjHiCoJiBeC_xHqqkZx_
					wcpText++;
					// _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
					lOffset = wcstol(wcpText, (wchar_t**)&wcpText, 10);
				}
				// _xZkqqHx_jFmPiKlHiMoDjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
				WString wstr;
				wstr.Format(L"%d", lNumber + lOffset);
				if (lFigure != -1)
				//----- _xZkqqHx_jFfMiOkGiMiFjAjEiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_jDkKiCmJiCePiCePiCePiCePiCePiCePiCpAjCmHiJmBiClFiCmEiBeBiJeFjBkEiClOiCkPiOoGiCoIiPgPiClHiBeC_xHqqkZx_
					wstr = WString(lFigure, L'0') + wstr;
					wstr.Right(lFigure);
				}
				wstrEvalText += wstr;
				if (wcpText[0] == L'%')
					wcpText++;
			} else
			if (iForm == SHEET_TITLE)
			//----- _xZkqqHx_iDfGiBfLiDgHjGlMiCmMjFlGiOjKiMfOiCmFiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iLeMiNiGiCpAjBjHiCoJiBeC_xHqqkZx_
				wcpText += 2;
				wstrEvalText += wcpSheetTitle;
				if (wcpText[0] == L'%')
					wcpText++;
			}
		} else
		//----- % _xZkqqHx_iImIiKePiCmFiOgOiCnMiCoJiPoKiNiH_xHqqkZx_ ----
		{
			// _xZkqqHx_iCfAjFlGiOjKiCpAjFfMiOkGiBeC_xHqqkZx_
			wstrEvalText += wcpText[0];
			// _xZkqqHx_iCfAjFlGiOjKiCpAjBjHiCoJiBeC_xHqqkZx_
			wcpText++;
		}
	}
} // FFEvalPageNumberText.

