#include "stdafx.h"
#include "UtilBezier.h"	// For FCMmPolyBezier.
#include "UtilRect.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetInvalidRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLoJiMgAiCmMiCkEiClPiBeBjHeMiMpIiCmIjHmMiIoGiCmMiLoJiMgAiCmMiOgDiCoIiCmMiLoJiMgAiBgJjGlDiMpIiCmIjHmMiIoGiBgKiCmM_xHqqkZx_
 *			_xZkqqHx_jEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vrtInvalid	:_xZkqqHx_jGlDiMpIjHmMiIoGiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			rtSrc		:_xZkqqHx_iMlDiCmMiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtValid		:_xZkqqHx_jHeMiMpIjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	rtInvalid_xZkqqHx_iCmNiPiJiKpKiJlLiClDiCoKiClIiBeBiLoJiMgAiCkKjCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMiCoGiCkEiCmJ_xHqqkZx_ rtSrc, rtValid _xZkqqHx_iCkJiCoHiBeB_xHqqkZx_rtInvalid_xZkqqHx_iCmMjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_rtSrc _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkBiEjP_xHqqkZx_rtValid _xZkqqHx_iEjPiEkC_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                                  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *                             _xZkqqHx_iBkL_xHqqkZx_
 *
 *
 *         Src.l      Val.l          Val.r     Src.r
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *     Src.t_xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        rtInvalid       _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *     Val.t_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_rtInvalid
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_rtInvalid _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *     Val.b_xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_        rtInvalid     _xZkqqHx_iEkA_xHqqkZx_
 *     Src.b_xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetInvalidRect (	CRectVector& vrtInvalid,
						const CRect& rtSrc,
						CRect rtValid)
{
	// rtValid _xZkqqHx_iCpA_xHqqkZx_ rtSrc_xZkqqHx_iCmJiOpLiCnMiCoJjBoFiCkLiClDiCmJiPeDjAlDiBeC_xHqqkZx_
	rtValid = rtSrc & rtValid;
	if (rtValid.IsRectEmpty())
	{
		vrtInvalid.push_back(rtSrc);
	} else
	{
		const CRect rt1(rtSrc.left, rtSrc.top, rtValid.right, rtValid.top);
		const CRect rt2(rtValid.right, rtSrc.top, rtSrc.right, rtValid.bottom);
		const CRect rt3(rtValid.left, rtValid.bottom, rtSrc.right, rtSrc.bottom);
		const CRect rt4(rtSrc.left, rtValid.top, rtValid.left, rtSrc.bottom);
		if (!rt1.IsRectEmpty()) vrtInvalid.push_back(rt1);
		if (!rt2.IsRectEmpty()) vrtInvalid.push_back(rt2);
		if (!rt3.IsRectEmpty()) vrtInvalid.push_back(rt3);
		if (!rt4.IsRectEmpty()) vrtInvalid.push_back(rt4);
	}
} // FFGetInvalidRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetRectPolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLoJiMgAiCmMjCiGjAfDjDfPiBeB_xHqqkZx_X_xZkqqHx_iOlCjElMiMgBiBeB_xHqqkZx_Y_xZkqqHx_iOlCjElMiMgBiBeB_xHqqkZx_X_xZkqqHx_iOlCjFpLiMpMiCnGiCmMiDfGiDhEiDgHjFmPiMgAiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iLoJiMgAiCmMjIeBiMiLjApMiCmMiNmAjFfHiPoOjFpBiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoint	:_xZkqqHx_jIeBiMiLjApMiCmMiNmAjFfHjEhKjHpBiCpAiOpLiCnPiCoJiDgPiDgCiDhEiDeAiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptCenter	:_xZkqqHx_jCiGjAfDjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLx		:X_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLy		:Y_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmShiftX	:X_xZkqqHx_jFpLiMpMiCnGiCmMiDfGiDhEiDgHjFmPiMgAiCmMjBoFiCkLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRotate		:_xZkqqHx_iJpBjDfNjFmPiMgAiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptRotateCenter	:_xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.21 Fukushiro M. _xZkqqHx_iPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void FFGetRectPolygon (	DBLPointVector& vmmptPoint,
						const DBLPoint& mmptCenter,
						mmetol mmLx, mmetol mmLy,
						mmetol mmShiftX,
						angle dRotate,
						const DBLPoint& mmptRotateCenter)
{
	DBLPoint mmptPoint[4];
	if (mmShiftX == 0.0)
	{
		mmptPoint[0].x = mmptCenter.x - mmLx;
		mmptPoint[0].y = mmptCenter.y - mmLy;
		mmptPoint[1].x = mmptCenter.x + mmLx;
		mmptPoint[1].y = mmptCenter.y - mmLy;
		mmptPoint[2].x = mmptCenter.x + mmLx;
		mmptPoint[2].y = mmptCenter.y + mmLy;
		mmptPoint[3].x = mmptCenter.x - mmLx;
		mmptPoint[3].y = mmptCenter.y + mmLy;
	} else
	{
		mmptPoint[0].x = mmptCenter.x - mmLx - mmShiftX;
		mmptPoint[0].y = mmptCenter.y - mmLy;
		mmptPoint[1].x = mmptCenter.x + mmLx - mmShiftX;
		mmptPoint[1].y = mmptCenter.y - mmLy;
		mmptPoint[2].x = mmptCenter.x + mmLx + mmShiftX;
		mmptPoint[2].y = mmptCenter.y + mmLy;
		mmptPoint[3].x = mmptCenter.x - mmLx + mmShiftX;
		mmptPoint[3].y = mmptCenter.y + mmLy;
	}
	vmmptPoint.assign(5);
	if (dRotate == 0.0)
	{
		for (int n = 0; n < 4; n++)
		{
			vmmptPoint[n] = mmptPoint[n];
		}
	} else
	{
		double dSinR = FFSin(dRotate);
		double dCosR = FFCos(dRotate);
		for (int n = 0; n < 4; n++)
		{
			vmmptPoint[n].x = mmptRotateCenter.x + dCosR * (mmptPoint[n].x - mmptRotateCenter.x)
								- dSinR * (mmptPoint[n].y - mmptRotateCenter.y);
			vmmptPoint[n].y = mmptRotateCenter.y + dSinR * (mmptPoint[n].x - mmptRotateCenter.x)
								+ dCosR * (mmptPoint[n].y - mmptRotateCenter.y);
		}
	}
	vmmptPoint[4] = vmmptPoint[0];
} // FFGetRectPolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetRectBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLoJiMgAiCmMjCiGjAfDjDfPiBeB_xHqqkZx_X_xZkqqHx_iOlCjElMiMgBiBeB_xHqqkZx_Y_xZkqqHx_iOlCjElMiMgBiBeB_xHqqkZx_X_xZkqqHx_iOlCjFpLiMpMiCnGiCmMiDfGiDhEiDgHjFmPiMgAiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iLoJiMgAiCmMiDhIiDfHiDeGjEhKjHpBiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	:_xZkqqHx_iDhIiDfHiDeGjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptCenter	:_xZkqqHx_jCiGjAfDjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLx		:X_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLy		:Y_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmShiftX	:X_xZkqqHx_jFpLiMpMiCnGiCmMiDfGiDhEiDgHjFmPiMgAiCmMjBoFiCkLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRotate		:_xZkqqHx_iJpBjDfNjFmPiMgAiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptRotateCenter	:_xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetRectBezier (	FCMmPolyBezier& polyBezier,
						const DBLPoint& mmptCenter,
						mmetol mmLx,
						mmetol mmLy,
						mmetol mmShiftX,
						angle dRotate,
						const DBLPoint& mmptRotateCenter)
{
	polyBezier.clear();
	polyBezier.SetIsBezier(TRUE);
	// _xZkqqHx_iCnMiClIiBeBjFmPiMgAiClFiCmEiCkCiCmIiCkCjClHjFpLiMgAiCmMiOgMiLpHiCmMjEhKjHpBiCpAjDlOiCoJiBeC_xHqqkZx_
	DBLPoint mmptPoint[4];
	DBLRect(mmptCenter - DBLPoint(mmLx, mmLy), mmptCenter + DBLPoint(mmLx, mmLy)).Get4Polygon(mmptPoint);
	if (!almost0(mmShiftX))
	//----- _xZkqqHx_iDfGiDhEiDgHjFmPiMgAiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmptPoint[0].x -= mmShiftX;
		mmptPoint[1].x -= mmShiftX;
		mmptPoint[2].x += mmShiftX;
		mmptPoint[3].x += mmShiftX;
	}
	if (!almost0(dRotate))
	//----- _xZkqqHx_iJpBjDfNjFmPiMgAiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		RotateConv(mmptPoint, 4, FFSin(dRotate), FFCos(dRotate), mmptRotateCenter.x, mmptRotateCenter.y);
	}
	polyBezier.push_back(mmptPoint[0]);		// A.
	polyBezier.push_back(mmptPoint[0]);		// B.
	polyBezier.push_back(mmptPoint[1]);		// C.
	polyBezier.push_back(mmptPoint[1]);		// A.
	polyBezier.push_back(mmptPoint[1]);		// B.
	polyBezier.push_back(mmptPoint[2]);		// C.
	polyBezier.push_back(mmptPoint[2]);		// A.
	polyBezier.push_back(mmptPoint[2]);		// B.
	polyBezier.push_back(mmptPoint[3]);		// C.
	polyBezier.push_back(mmptPoint[3]);		// A.
	polyBezier.push_back(mmptPoint[3]);		// B.
	polyBezier.push_back(mmptPoint[0]);		// C.
	polyBezier.push_back(mmptPoint[0]);		// D.
} // FFGetRectBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetRoundRectBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLoJiMgAiCmMjCiGjAfDjDfPiBeB_xHqqkZx_X_xZkqqHx_iOlCjElMiMgBiBeB_xHqqkZx_Y_xZkqqHx_iOlCjElMiMgBiBeB_xHqqkZx_X_xZkqqHx_iOlCjFpLiMpMiCnGiCmMiDfGiDhEiDgHjFmPiMgAiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iLoJiMgAiCmMiDhIiDfHiDeGjEhKjHpBiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	:_xZkqqHx_iDhIiDfHiDeGjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptCenter	:_xZkqqHx_jCiGjAfDjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLx		:X_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLy		:Y_xZkqqHx_iOlCjElMiMgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmRoundX	:_xZkqqHx_iKhAiCmMiJhOiMmKiCmMjElMiMgBiBgJiChHjFpLiMpMiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmRoundY	:_xZkqqHx_iKhAiCmMiJhOiMmKiCmMjElMiMgBiBgJiChIjFpLiMpMiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmShiftX	:X_xZkqqHx_jFpLiMpMiCnGiCmMiDfGiDhEiDgHjFmPiMgAiCmMjBoFiCkLiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRotate		:_xZkqqHx_iJpBjDfNjFmPiMgAiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptRotateCenter	:_xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetRoundRectBezier (	FCMmPolyBezier& polyBezier,
							const DBLPoint& mmptCenter,
							mmetol mmLx,
							mmetol mmLy,
							mmetol mmRoundX,
							mmetol mmRoundY,
							mmetol mmShiftX,
							angle dRotate,
							const DBLPoint& mmptRotateCenter)
{
	if (almost0(mmRoundX) || almost0(mmRoundY))
	//----- _xZkqqHx_iKhAiKnLiCkKjGlDiCkCiPoKiNiHiBgJjBkGiClPjFiBjCmKiCmMiLoJiMgAiCmMiPoKiNiHiBgK_xHqqkZx_-----
	{
		FFGetRectBezier(polyBezier,
						mmptCenter,
						mmLx,
						mmLy,
						mmShiftX,
						dRotate,
						mmptRotateCenter);
		return;
	}

	//----- _xZkqqHx_iKhAiKnLiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----

	// _xZkqqHx_iKhAiCmMiKnLiCnNiCkKjGlDiCkCiPpDjBnEiCmMiLoJiMgAiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLRect mmrtOut(mmptCenter - DBLPoint(mmLx, mmLy), mmptCenter + DBLPoint(mmLx, mmLy));
	DBLRect mmrtIn = mmrtOut.ReduceRect(mmRoundX, mmRoundY);

	//
	//      Out.left In.left          In.right Out.right
	//         _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
	//         _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBfBiBfBiEkAiBfBiBfBiBfB_xHqqkZx_Out.top
	//         _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBfOiBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfAiBfP_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
	//         _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBfO_xHqqkZx_                      _xZkqqHx_iBfP_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_
	//            _xZkqqHx_iBfO_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBfP_xHqqkZx_ 
	//          _xZkqqHx_iBfO_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBfP_xHqqkZx_       In.top
	//         _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBfAiBfA_xHqqkZx_                  _xZkqqHx_iBfAiBfA_xHqqkZx_   _xZkqqHx_iEkAiBfAiBfAiBfA_xHqqkZx_
	//         _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkA_xHqqkZx_
	//         _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkA_xHqqkZx_
	//         _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkA_xHqqkZx_
	//         _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBfBiBfB_xHqqkZx_                  _xZkqqHx_iBfBiBfB_xHqqkZx_   _xZkqqHx_iEkAiBfBiBfBiBfB_xHqqkZx_In.bottom
	//          _xZkqqHx_iBfP_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBfO_xHqqkZx_ 
	//            _xZkqqHx_iBfP_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBfO_xHqqkZx_   
	//              _xZkqqHx_iBfP_xHqqkZx_                      _xZkqqHx_iBfO_xHqqkZx_   
	//                _xZkqqHx_iBfPiBfBiBfBiBfBiBfBiBfBiBfBiBfBiBfBiBfBiBfO_xHqqkZx_             Out.bottom
	//                                       _xZkqqHx_iBfAiBfAiBfAiBfAiBfAiBfA_xHqqkZx_
	//

	FCBezierControlsVector vControls;
	FCBezierControls bc;
	FFCalcArcBezier(bc,
					DBLPoint(mmrtIn.left, mmrtIn.top),
					mmRoundX,
					mmRoundY,
					1.0,
					1.5);
	vControls.push_back(bc);
	vControls.push_back(FCBezierControls(DBLPoint(mmrtIn.left, mmrtOut.top),
										DBLPoint(mmrtIn.left, mmrtOut.top),
										DBLPoint(mmrtIn.right, mmrtOut.top),
										DBLPoint(mmrtIn.right, mmrtOut.top)));
	FFCalcArcBezier(bc,
					DBLPoint(mmrtIn.right, mmrtIn.top),
					mmRoundX,
					mmRoundY,
					1.5,
					0.0);
	vControls.push_back(bc);
	vControls.push_back(FCBezierControls(DBLPoint(mmrtOut.right, mmrtIn.top),
										DBLPoint(mmrtOut.right, mmrtIn.top),
										DBLPoint(mmrtOut.right, mmrtIn.bottom),
										DBLPoint(mmrtOut.right, mmrtIn.bottom)));
	FFCalcArcBezier(bc,
					DBLPoint(mmrtIn.right, mmrtIn.bottom),
					mmRoundX,
					mmRoundY,
					0.0,
					0.5);
	vControls.push_back(bc);
	vControls.push_back(FCBezierControls(DBLPoint(mmrtIn.right, mmrtOut.bottom),
										DBLPoint(mmrtIn.right, mmrtOut.bottom),
										DBLPoint(mmrtIn.left, mmrtOut.bottom),
										DBLPoint(mmrtIn.left, mmrtOut.bottom)));
	FFCalcArcBezier(bc,
					DBLPoint(mmrtIn.left, mmrtIn.bottom),
					mmRoundX,
					mmRoundY,
					0.5,
					1.0);
	vControls.push_back(bc);
	vControls.push_back(FCBezierControls(DBLPoint(mmrtOut.left, mmrtIn.bottom),
										DBLPoint(mmrtOut.left, mmrtIn.bottom),
										DBLPoint(mmrtOut.left, mmrtIn.top),
										DBLPoint(mmrtOut.left, mmrtIn.top)));

	FFControlConv(polyBezier, vControls);
	// _xZkqqHx_iDfGiDhEiDgHiBeBiJpBjDfNjFmPiKlHiClHiCoJiBeC_xHqqkZx_
	if (!almost0(mmShiftX))
	//----- _xZkqqHx_iDfGiDhEiDgHjFmPiKlHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		ShiftConv(	polyBezier.GetArray(),
					polyBezier.size(),
					mmLy, mmShiftX, mmptCenter.y);
	}
	if (!almost0(dRotate))
	//----- _xZkqqHx_iJpBjDfNjFmPiKlHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		RotateConv(	polyBezier.GetArray(),
					polyBezier.size(),
					FFSin(dRotate),
					FFCos(dRotate),
					mmptRotateCenter.x,
					mmptRotateCenter.y);
	}
} // FFGetRoundRectBezier.
