#ifndef __UtilSort_h
#define __UtilSort_h

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCLess
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	STL_xZkqqHx_iCmM_xHqqkZx_ sort_xZkqqHx_iKnGjAjE_xHqqkZx_ _xZkqqHx_iCmFiBeBjFkBjAjEiCmMiDfMiBfLiDgHiNiAjGnKiCpAiOjNiCmCiNfMjBkCjBmMiDiMiDfCiBfLiDgIiCmM_xHqqkZx_
 *			_xZkqqHx_iDfMiBfLiDgHiCpAiNhDiCkEiClNiCnPiCmMiDfMiBfLiDgHiKnGjAjEiCpAjCoIiLgAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vSortOrder	:_xZkqqHx_iDfMiBfLiDgHiCpAiNhDiCkEiNiAjGnKiCmMiPiHjEnEiCpAiOhHjCoIiClHiCoJiBeCiDiKiDgPiBfLiDfIiCmF_xHqqkZx_
 *						 _xZkqqHx_iDfMiBfLiDgHiClHiCoJiNiAjGnKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmNiBeB_xHqqkZx_
 *						 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_ = (_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIjCgM_xHqqkZx_ | 0x8000)
 *						 _xZkqqHx_iCmFiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfMiBfLiDgHjBmOiPnLiCmGiCmIiCoJiNfMjBkCjBmMiBgJiDeOiDiJiDfIiBgKiCmNiBeBiImIiJlKiCmMiDiBiDjDiDgPiBfLiKnGjAjEiCpA_xHqqkZx_
 *			_xZkqqHx_iOjNiClNiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 *			static int Compare (const T& rec0, const T& rec1, WORD wItemIdx);
 *			if (rec0.Item < rec1.Item) return -1;
 *			if (rec0.Item > rec1.Item) return  1;
 *			if (rec0.Item == rec1.Item) return 0;
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class S, class T> class FCLess
{
public:
	FCLess (const WORDVector& vSortOrder) : m_vSortOrder(vSortOrder) {}
	bool operator () (const T& rec0, const T& rec1) const
		{
			// _xZkqqHx_iDfMiBfLiDgHiPiHiPjIiDiKiDfIiDgHiCmMiNmFiMoDiCkJiCoHiPiHiCmJjEoEiKhCiBeC_xHqqkZx_
			WORDVector::const_reverse_iterator rR;
			for (rR = m_vSortOrder.rbegin(); rR != m_vSortOrder.rend(); rR++)
			{
				WORD wItemIdx = *rR & 0x7fff;
				bool bReverse = (*rR & 0x8000) != 0;
				int iCmp = S::Compare(rec0, rec1, wItemIdx);
				if (iCmp < 0) return !bReverse;
				if (0 < iCmp) return bReverse;
			}
			// rec0,rec1_xZkqqHx_iCmMjBfDiCmEiCmMiNiAjGnKiCkKjDkPiClGiPoKiNiHiBeC_xHqqkZx_
			return false;
		}
protected:
	const WORDVector&	m_vSortOrder;
}; // class FCLess.

extern void FFAddSortOrder (WORDVector& vSortOrder, WORD wItem);

#endif //__UtilSort_h

