#include "stdafx.h"
#include "resource.h"		// For IDS_ERR_MSG_COMPRESS.
#include "zlib.h"			// For uncompress.etc.
#include "UtilZlibPng.h"	// For FFZlibCompress2.
#include "UtilMisc.h"		// For FFGetGuidCheckCode.
#include "UtilErr.h"		// For CFCMiscException.
#include "UtilFile.h"		// For ReadData.
#include "UtilFont.h"		// For WCH_XXX.
#include "UtilGraph.h"		// For FCAutoDC.
#include "RegData.h"		// For g_pReg.
#include "UtilStr.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiKgFiMiFjAjEiBeC_xHqqkZx_
#define FD_USER_ID_STR_LEN_1	8
#define FD_USER_ID_STR_LEN_2	4
#define FD_USER_ID_STR_LEN_3	4
#define FD_USER_ID_STR_LEN_4	4
#define FD_USER_ID_STR_LEN_5	12
#define FD_USER_ID_STR_LEN_C	4
#define FD_USER_ID_STR_LEN	(FD_USER_ID_STR_LEN_1 + 1 + FD_USER_ID_STR_LEN_2 + 1 + FD_USER_ID_STR_LEN_3 + 1 + FD_USER_ID_STR_LEN_4 + 1 + FD_USER_ID_STR_LEN_5 + 1 + FD_USER_ID_STR_LEN_C)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CharSetToCodePage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LOGFONT,CHARFORMAT_xZkqqHx_jDjJiCmM_xHqqkZx_CharSet_xZkqqHx_iCpAiDfCiBfLiDgIiDhJiBfLiDfHiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byCharSet	:_xZkqqHx_iDeMiDiDiDiJiDeOiDfOiDfKiDgCiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiBfLiDgIiDhJiBfLiDfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfGiDjDiDhLiDiLiBgJ_xHqqkZx_CharSet=2_xZkqqHx_iBgKiCpAiDfCiBfLiDgIiDhJiBfLiDfHiCmJjFmPiKlHiClHiCoJiCmGiBeBjFhDjGlOiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiBfLiDgIiDhJiBfLiDfH_xHqqkZx_(42)_xZkqqHx_iCmJiCmIiCmBiCmEiClFiCnMiCkEiBeCiClBiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCmFiCmN_xHqqkZx_
 *			UNICODE<->MBCS_xZkqqHx_iCmMjFmPiKlHiCkKiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDfGiDjDiDhLiDiLiCmNiJhAiMoKiCmMiDfCiBfLiDgIiDhJiBfLiDfH_xHqqkZx_(1252)_xZkqqHx_iCmFjBoDjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD CharSetToCodePage (BYTE byCharSet)
{
	// _xZkqqHx_iDfGiDjDiDhLiDiLiCmNiJhAiMoKiCmMiDfCiBfLiDgIiDhJiBfLiDfH_xHqqkZx_(1252)_xZkqqHx_iCmFjBoDjHhAiBeC_xHqqkZx_
	if (byCharSet == 2) return 1252;
    CHARSETINFO	ciCharInf;
	if (TranslateCharsetInfo((DWORD*)byCharSet,
							&ciCharInf, TCI_SRCCHARSET))
		return ciCharInf.ciACP;
	else
// 02.02.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		return 1252;	// Windows 3.1 Latin 1 (US, Western Europe).
		return CP_ACP;
} // CharSetToCodePage.

//----- 02.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetWChar
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	pStr_xZkqqHx_iCmMjAoGjDkKiCkJiCoHiCfAjFlGiOjKiCpAiOoGjDlOiClFiBeBiOjPiCmMjFlGiOjKiCmMiDhMiDeDiDjDiDfOiCpA_xHqqkZx_pStrNext_xZkqqHx_iCmJ_xHqqkZx_
// *			_xZkqqHx_jAnNjCoIiClFiBeBjFlGiOjKiDfCiBfLiDgIiCpAjFnEiClHiBeCiBgJiCfBiDgPiDeDiDgHiDfCiBfLiDgIiCmJjBmOiJjOiBgK_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pStrNext	: _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiDhMiDeDiDjDiDfO_xHqqkZx_
// *			pStr		: _xZkqqHx_iCfAjFlGiOjKiCpAiOoGjDlOiClHiCoJiClNiCnPiCmMiDhMiDeDiDjDiDfO_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx_UNICODE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//wchar_t GetWChar (const _TCHAR*& pStrNext, const _TCHAR* pStr)
//{
//#if defined(_MBCS)
//	pStrNext = ::CharNext(pStr);
//	// _xZkqqHx_jFlGiOjKjHpBiCmMiNmFiMoDiBeC_xHqqkZx_
//	if (pStrNext == pStr) return 0;
//	wchar_t wChar;
//	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, pStr, pStrNext - pStr, &wChar, 1);
//	return wChar;
//#elif defined(_UNICODE)
//	wchar_t wChar = *pStr;
//	if (wChar != L'\0')
//		pStrNext = pStr + 1;
//	else
//		pStrNext = pStr;
//	return wChar;
//#endif//_UNICODE
//} // GetWChar.
//----- 02.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetWChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	pStr_xZkqqHx_iCmMjAoGjDkKiCkJiCoHiCfAjFlGiOjKiCpAiOoGjDlOiClFiBeBiOjPiCmMjFlGiOjKiCmMiDhMiDeDiDjDiDfOiCpA_xHqqkZx_pStrNext_xZkqqHx_iCmJ_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClFiBeBjFlGiOjKiDfCiBfLiDgIiCpAjFnEiClHiBeCiBgJiCfBiDgPiDeDiDgHiDfCiBfLiDgIiCmJjBmOiJjOiBgK_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pStrNext	: _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiDhMiDeDiDjDiDfO_xHqqkZx_
 *			pStr		: _xZkqqHx_iCfAjFlGiOjKiCpAiOoGjDlOiClHiCoJiClNiCnPiCmMiDhMiDeDiDjDiDfO_xHqqkZx_
 *			wCodePage	: _xZkqqHx_iClBiCmMjFlGiOjKiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx_UNICODE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CharNext_xZkqqHx_iKnGjAjEiCmNiDfCiBfLiDgIiDhJiBfLiDfHiCmJjBmOiJjOiClFiCmEiCkCiCmIiCkCiBeCiClBiCmMiClNiCnP_xHqqkZx_
 *			CFCWndRichEdit::OnPaste_xZkqqHx_iKnGjAjEjCiGiCmFiBeBjDpBiCmCiCmMiInJiCmIiCoJiDhEiDeIiDjDiDgHiCmJ_xHqqkZx_
 *			_xZkqqHx_iCnMiClNiCkKiCmBiClNiDfCiBfLiDgI_xHqqkZx_ 0xe0 _xZkqqHx_iCmG_xHqqkZx_ 0x20 _xZkqqHx_iCpA_xHqqkZx_ 0xe020 _xZkqqHx_iCmGiCkCiCkEiCfAjFlGiOjKiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiBfLiDgIiCmGiClFiCmEjEeGiOkPiClFiCmEiClFiCnMiCmBiClNiBeC_xHqqkZx_
 *			_xZkqqHx_iOmAiNnLiCmJiCmNiBeB_xHqqkZx_0xe0_xZkqqHx_iCmG_xHqqkZx_0x20_xZkqqHx_iCmNiInJiCmIiCoJiDhEiDeIiDjDiDgHiBeBjBkGiClPiInJiCmIiCoJiDfCiBfLiDgIiDhJiBfLiDfH_xHqqkZx_
 *			_xZkqqHx_iCmJjBkOiClHiCoJjFlGiOjKiCmFiCkAiCoIiBeBiCfBjFlGiOjKiCmGiClFiCmEiIlFiCoNiCoKiCoJiCnHiCkLiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMjGoCjBoIiCmMjBmOiPiIiCmGiClFiCmE_xHqqkZx_CharNextExA_xZkqqHx_iCpAiOgHiCmBiClNiBeC_xHqqkZx_
 *************************************************************************/
wchar_t GetWChar (const _TCHAR*& pStrNext, const _TCHAR* pStr, WORD wCodePage)
{
#if defined(_MBCS)
	pStrNext = ::CharNextExA(wCodePage, pStr, 0);
	// _xZkqqHx_jFlGiOjKjHpBiCmMiNmFiMoDiBeC_xHqqkZx_
	if (pStrNext == pStr) return 0;
	wchar_t wChar;
// 02.02.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, pStr, pStrNext - pStr, &wChar, 1);
	MultiByteToWideChar(wCodePage, MB_PRECOMPOSED, pStr, pStrNext - pStr, &wChar, 1);
	return wChar;
#elif defined(_UNICODE)
	wchar_t wChar = *pStr;
	if (wChar != L'\0')
		pStrNext = pStr + 1;
	else
		pStrNext = pStr;
	return wChar;
#endif//_UNICODE
} // GetWChar.

#if defined(_MBCS)
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetAChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	UNICODE_xZkqqHx_jFlGiOjKiCpA_xHqqkZx_MBCS_xZkqqHx_iCmM_xHqqkZx_char*_xZkqqHx_jFlGiOjKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	szBuff	:char*_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *					 _xZkqqHx_iNmFjCoBiCmFiCoAiDfEiDeDiDfJ_xHqqkZx_=3_xZkqqHx_iCkKjFeLjHhGiBeC_xHqqkZx_
 *			lStrLen	:_xZkqqHx_iDgPiDgCiDhEiDeAiCmJiDfCiDhDiBfLiClFiClNjFlGiOjKjHpBiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *			wChar	:UNICODE_xZkqqHx_jFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wCodePage	: _xZkqqHx_iClBiCmMjFlGiOjKiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	szBuff_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	UNICODE_xZkqqHx_iCpA_xHqqkZx_char*_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
//char* GetAChar (char szBuff[], long& lStrLen, wchar_t wChar)
char* GetAChar (char szBuff[], long& lStrLen, wchar_t wChar, WORD wCodePage)
{
// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
//	lStrLen = WideCharToMultiByte(CP_ACP, 0, &wChar, 1, szBuff, 3, NULL, NULL);
	lStrLen = WideCharToMultiByte(wCodePage, 0, &wChar, 1, szBuff, 3, NULL, NULL);
	szBuff[lStrLen] = _T('\0');
	return szBuff;
} // GetAChar.
#endif//_MBCS

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CodeToWChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpMjHmNiClDiCoKiClNjFlGiOjKiDfCiBfLiDgIiCpAiBeB_xHqqkZx_UNICODE_xZkqqHx_iCmM_xHqqkZx_wchar_t_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wCode	:_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_UNICODE_xZkqqHx_iCmMiPoKiNiHiCmGiBeB_xHqqkZx_MBCS_xZkqqHx_iCmMiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	UNICODE_xZkqqHx_iCmMjFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 02.09.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDfOiDeDiMoKiCmIiCmHiCmFiBeBjFlGiOjKjFjNiCkKjAlDiClFiCkNiOfKiPgPiClDiCoKiCmIiCkC_xHqqkZx_)
//wchar_t CodeToWChar (WORD wCode)
wchar_t CodeToWChar (WORD wCode, WORD wCodePage)
{
#if defined(_MBCS)
	_TCHAR sz[3];
	if (wCode & 0xff00)
	{
		sz[0] = wCode >> 8;
		sz[1] = wCode & 0x00ff;
		sz[2] = _T('\0');
	} else
	{
		sz[0] = wCode & 0x00ff;
		sz[1] = _T('\0');
	}
	wchar_t wChar;
// 02.09.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDfOiDeDiMoKiCmIiCmHiCmFiBeBjFlGiOjKjFjNiCkKjAlDiClFiCkNiOfKiPgPiClDiCoKiCmIiCkC_xHqqkZx_)
//	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, sz, -1, &wChar, 1);
	MultiByteToWideChar(wCodePage, MB_PRECOMPOSED, sz, -1, &wChar, 1);
	return wChar;
#elif defined(_UNICODE)
	return wCode;
#endif//_UNICODE
} // CodeToWChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	WCharToCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpMjHmNiClDiCoKiClN_xHqqkZx_UNICODE_xZkqqHx_iCmM_xHqqkZx_wchar_t_xZkqqHx_jFlGiOjKiCpAiBeB_xHqqkZx_MBCS_xZkqqHx_iCmMjFlGiOjKiDfCiBfLiDgIiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar	:UNICODE_xZkqqHx_iCmMjFlGiOjKiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_MBCS_xZkqqHx_iDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	MBCS_xZkqqHx_iCmMjFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx__UNICODE_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_UNICODE_xZkqqHx_iCmMjFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----
//WORD WCharToCode (wchar_t wChar)
//{
//#if defined(_MBCS)
//	_TCHAR szBuff[3];
//	int iStrLen = WideCharToMultiByte(CP_ACP, 0, &wChar, 1, szBuff, 3, NULL, NULL);
//	const _TCHAR* tcpStr = szBuff;
//	WORD wCode = 0;
//	while (0 < iStrLen--)
//	{
//		wCode = WORD(wCode << 8) | BYTE(*tcpStr);
//		tcpStr++;
//	}
//	return wCode;
//#elif defined(_UNICODE)
//	return wChar;
//#endif//_UNICODE
//} // WCharToCode.
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----
// 02.09.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDfOiDeDiMoKiCmIiCmHiCmFiBeBjFlGiOjKjFjNiCkKjAlDiClFiCkNiOfKiPgPiClDiCoKiCmIiCkC_xHqqkZx_)
//BOOL WCharToCode (wchar_t& wChar)
BOOL WCharToCode (wchar_t& wChar, WORD wCodePage)
{
#if defined(_MBCS)
	_TCHAR szBuff[3];
	BOOL bUsedDefaultChar = FALSE;
// 02.09.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDfOiDeDiMoKiCmIiCmHiCmFiBeBjFlGiOjKjFjNiCkKjAlDiClFiCkNiOfKiPgPiClDiCoKiCmIiCkC_xHqqkZx_)
//	int iStrLen = WideCharToMultiByte(CP_ACP, 0, &wChar, 1, szBuff, 3, NULL, NULL);
	int iStrLen = WideCharToMultiByte(wCodePage, 0, &wChar, 1, szBuff, 3, NULL, &bUsedDefaultChar);
	// _xZkqqHx_jBmOiJjOiClHiCoJ_xHqqkZx_MBCS_xZkqqHx_iDfCiBfLiDgIiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (bUsedDefaultChar) return FALSE;
	const _TCHAR* tcpStr = szBuff;
	wChar = 0;
	while (0 < iStrLen--)
	{
		wChar = WORD(wChar << 8) | BYTE(*tcpStr);
		tcpStr++;
	}
#endif//_MBCS
	return TRUE;
} // WCharToCode.
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetCharKind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiCmMiOoNjHnOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar	:_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx_UNICODE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiCmMiOoNjHnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.04.19 Fukushiro M. UNICODE_xZkqqHx_iJlLiBeC_xHqqkZx_
 *			06.05.21 Fukushiro M. WndRichEdit.cpp_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
FDCharKind FFGetCharKind (wchar_t wChar)
{
	if (wChar < L' ')		return FDCK_ANSI_ETC;
	else
	if (wChar < L'0')		return FDCK_ANSI_MARK;
	else
	if (wChar < L':')		return FDCK_ANSI_NUMBER;
	else
	if (wChar < L'A')		return FDCK_ANSI_MARK;
	else
	if (wChar < L'[')		return FDCK_ANSI_ALPHABET;
	else
	if (wChar < L'a')		return FDCK_ANSI_MARK;
	else
	if (wChar < L'{')		return FDCK_ANSI_ALPHABET;
	else
	if (wChar < 0x00c0)		return FDCK_ANSI_MARK;
	else
	if (wChar < 0x0250)		return FDCK_ANSI_ALPHABET;	// _xZkqqHx_jAlDiKgNiCmJiCmNiBeBiDiJiDgFiDjDiKgHjCkD_xHqqkZx_A,B_xZkqqHx_iBeC_xHqqkZx_
	else
	if (0xff21 <= wChar && wChar <= 0xff3a || 0xff41 <= wChar && wChar <= 0xff5a)
							return FDCK_ZENK_ALPHABET;	// _xZkqqHx_jBfDiKhAiDeBiDiLiDhEiDeAiDhIiDgCiDgHiBeC_xHqqkZx_
	else
		return FDCharKind(FDCK_OTHER_BEGIN + FFUnicodeToSubset(wChar));
} // FFGetCharKind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIsWrapedWordE
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKiImKjChFiCkKiJhAjFlGjCfAiMoKiLkLiKeFiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCjCfAiMoKiLkLiKeFiCmF_xHqqkZx_
 *			_xZkqqHx_iCmIiCkCiPoKiNiHiCmNiBeBjFlGiOjKiImKjChFiCoGiCoIiCoAjBePiKiOiCmCiNmFiCoAiMoDiCoLiCmMjCfAiMoKiLkLiKeFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lNewCount	:_xZkqqHx_jCfAiMoKiLkLiKeFiImKjChF_xHqqkZx_(_xZkqqHx_iLkLiKeFiCmMiJeFiCmMjFlGiOjK_xHqqkZx_idx)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpString	:_xZkqqHx_jClCiCnHiCoJjFlGiOjKjHpBiCpAiOhHjCoIiBeCiJpMiNhDiCkKiKnMiCnMiCoKiCmEiCkCiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
 *			lStringLen	:wcpString_xZkqqHx_iCmMjHeMiMpIiCmIjFlGiOjKjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCharCount	:_xZkqqHx_jClCiCnHiCoJjFlGiOjKiImKjChF_xHqqkZx_(_xZkqqHx_iLkLiKeFiCmMiJeFiCmMjFlGiOjK_xHqqkZx_idx)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCfAiMoKiLkLiKeFiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jDpKjGhLiMoKiDfCiBfLiDgIiCoAiNkMiClGiCmBiCmEiCkCiCkCiCoJiCmMiCmFiBeBjFlGiOjKjEoEiKhCiCmNiPgPjHiIiCoJiClOiCkP_xHqqkZx_ == _xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iNhDiCkEiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiKpEiCmCiCkJiCmMjHoBiCpAiNnKiClJiCoJiBeC_xHqqkZx_~_xZkqqHx_iCmJiCkAiCoJiPoKiNiHiCmNiBeB_xHqqkZx_^_xZkqqHx_iCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iHeA_xHqqkZx_	ABC.ABC
 *				    ^ ~
 *  
 *			_xZkqqHx_iHeB_xHqqkZx_	ABC ABC...
 *				    ^   ~
 *  
 *			_xZkqqHx_iHeC_xHqqkZx_	ABC ABC . . .
 *				    ^       ~
 *  
 *			_xZkqqHx_iHeD_xHqqkZx_	ABC ABC  .  .    .
 *				    ^         ~
 *  
 *			_xZkqqHx_iHeE_xHqqkZx_	ABC ABC     ABC
 *				       ~    ^
 *  
 *			_xZkqqHx_iHeF_xHqqkZx_	ABC ABC     \0
 *				       ~    ^
 *  
 *			_xZkqqHx_iHeG_xHqqkZx_	ABC
 *				^     ~
 *  
 *			_xZkqqHx_iHeH_xHqqkZx_	_xZkqqHx_iCkAiCkCiCkEiBeCiCkAiCkCiCkE_xHqqkZx_
 *				          _xZkqqHx_iBeP_xHqqkZx_
 *			              _xZkqqHx_iBfA_xHqqkZx_
 *
 *			_xZkqqHx_iKoOjGhLiCmNiHeAiBeCiClOiCkKiOmAiNnLiCmJiCmNiMlLiNnNiImKjChFiCkKiLoGjAnIiCoIiLeMiNiGiClOiCmBiClNiCoIiLpDjEjCiClOiCmBiClNiCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiLoGjAnIiCoIiLeMiNiGiCmMiPoKiNiHiBeFiLpDjEjCiCmMiPoKiNiHiCmMjBePiPiIjHjNiCpAiNhDiCmBiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiCkJiCoHiHeAiCmMiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBePiPiIjHjNiBeGiLoGjAnIiCoIiLeMiNiGiCmMiPoKiNiHiCmNiBeBiIoKiCmCjBePiCmMjFlGiOjKiBgJiLpDjEjCiImIiKePiBgKiCnGjGnPiClHiBeC_xHqqkZx_
 *					_xZkqqHx_iLpDjEjCiCmMiPoKiNiHiCmNiBeBiIoKiCmCjAoGiCmMjFlGiOjKiBgJiLpDjEjCiImIiKePiBgKiCnGjAgJiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iHeAiCkKiOmAiNhDiCmFiCkLiCoJiCnMiCmFiBeBiClBiCmMjBePiPiIjHjNiCpAiJlNjDhIiCoAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFIsWrapedWordE (long& lNewCount, const wchar_t* wcpString, long lStringLen, long lCharCount)
{
	long lCharIndex = lCharCount;
	for (;;)
	{
		if (lCharIndex <= 0)
		{
			lNewCount = 0;
			break;
		}
		if (lCharIndex == lStringLen)
		{
			lNewCount = lCharIndex;
			break;
		}
		// _xZkqqHx_iJpMiNhDiCkKiKnMiCnMiCoKiCmEiCkCiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
		if (wcpString[lCharIndex] == WCH_LF ||
			wcpString[lCharIndex] == WCH_CR)
			FFThrowMiscUnknown();

		if (wcpString[lCharIndex] == L'.' ||
			wcpString[lCharIndex] == L',' ||
			wcpString[lCharIndex] == L'?' ||
			wcpString[lCharIndex] == L'!' ||
			wcpString[lCharIndex] == L';' ||
			wcpString[lCharIndex] == L':')
		//----- _xZkqqHx_iLoGjAnIiCoIiLeMiNiGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iIoKiCmCjBePiCmMjFlGiOjKiBgJiLpDjEjCiImIiKePiBgKiCnMiCmFjGnPiClHiBeC_xHqqkZx_
			for (lCharIndex--; lCharIndex != -1; lCharIndex--)
			{
				if (wcpString[lCharIndex] == WCH_TAB ||
					wcpString[lCharIndex] == WCH_SPC) continue;
				break;
			}
		} else
		if (wcpString[lCharIndex] == WCH_TAB ||
			wcpString[lCharIndex] == WCH_SPC)
		//----- _xZkqqHx_iLpDjEjCiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iIoKiCmCiMoDiCmMjFlGiOjKiBgJiLpDjEjCiImIiKePiBgKiCnMiCmFjAgJiCnPiCoJiBeC_xHqqkZx_
			for (lCharIndex++; lCharIndex != lStringLen; lCharIndex++)
			{
				if (wcpString[lCharIndex] == WCH_TAB ||
					wcpString[lCharIndex] == WCH_SPC) continue;
				break;
			}
		} else
		//----- _xZkqqHx_iLoGjAnIiCoIiLeMiNiGiBeFiLpDjEjCiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iClBiClBiCmFiNhDiCkEiCmMiCmNiBeBiHeAiCmMiPoKiNiHiCmMiPiIjHjNiBeC_xHqqkZx_
			for (lCharIndex--; lCharIndex != -1; lCharIndex--)
			{
				// _xZkqqHx_iJpMiNhDiCkKiKnMiCnMiCoKiCmEiCkCiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
				if (wcpString[lCharIndex] == WCH_LF ||
					wcpString[lCharIndex] == WCH_CR)
					FFThrowMiscUnknown();
				if (wcpString[lCharIndex] == WCH_TAB ||
					wcpString[lCharIndex] == WCH_SPC ||
					wcpString[lCharIndex] == L'-' ||
					wcpString[lCharIndex] == L'.' ||
					wcpString[lCharIndex] == L',' ||
					wcpString[lCharIndex] == L'?' ||
					wcpString[lCharIndex] == L'!' ||
					wcpString[lCharIndex] == L';' ||
					wcpString[lCharIndex] == L':')
					break;
				// ANSI_xZkqqHx_iDfCiBfLiDgIiImIiKePiCmIiCoHiCmOiBeBjGlDiPpAiMiPiCmJiPeJjHlJiBeC_xHqqkZx_
				if (FDCK_ANSI_END < FFGetCharKind(wcpString[lCharIndex])) break;
			}
			lNewCount = lCharIndex + 1;
			break;
		}
	}
	return (lNewCount == lCharCount);
} // FFIsWrapedWordE.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIsWrapedWordJ
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKiImKjChFiCkKjIgBjFlGiLkLiKeFiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiLkLiKeFiCmF_xHqqkZx_
 *			_xZkqqHx_iCmIiCkCiPoKiNiHiCmNiBeBjFlGiOjKiImKjChFiCoGiCoIiCoAjBePiKiOiCmCiNmFiCoAiMoDiCoLiCmMiLkLiKeFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lNewCount	:_xZkqqHx_jIgBjFlGiLkLiKeFiImKjChF_xHqqkZx_(_xZkqqHx_iLkLiKeFiCmMiJeFiCmMjFlGiOjK_xHqqkZx_idx)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpString	:_xZkqqHx_jClCiCnHiCoJiNhDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lStringLen	:wcpString_xZkqqHx_iCmMjHeMiMpIiCmIjFlGiOjKjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCharCount	:_xZkqqHx_jClCiCnHiCoJjFlGiOjKiImKjChF_xHqqkZx_(_xZkqqHx_iLkLiKeFiCmMiJeFiCmMjFlGiOjK_xHqqkZx_idx)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIgBjFlGiLkLiKeFiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iJhAiMoKiDfCiBfLiDgIiCoAiNkMiClGiCmBiCmEiCkCiCkCiCoJiCmMiCmFiBeBjFlGiOjKjEoEiKhCiCmNiPgPjHiIiCoJiClOiCkP_xHqqkZx_ == _xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iNhDiCkEiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiKpEiCmCiCkJiCmMjHoBiCpAiNnKiClJiCoJiBeCiBfAiCmJiCkAiCoJiPoKiNiHiCmNiBeBiBePiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iHeA_xHqqkZx_	_xZkqqHx_iCkAiCkCiCkEiBeCiCkAiCkCiCkE_xHqqkZx_
 *				          _xZkqqHx_iBeP_xHqqkZx_
 *			              _xZkqqHx_iBfA_xHqqkZx_
 *  
 *			_xZkqqHx_iHeB_xHqqkZx_	_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_ _xZkqqHx_iCkAiCkCiCkEiBeCiBeCiBeC_xHqqkZx_
 *				           _xZkqqHx_iBeP_xHqqkZx_  _xZkqqHx_iBfA_xHqqkZx_
 *  
 *			_xZkqqHx_iHeC_xHqqkZx_	_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_ _xZkqqHx_iCkAiCkCiCkE_xHqqkZx_  _xZkqqHx_iBeC_xHqqkZx_  _xZkqqHx_iBeC_xHqqkZx_   _xZkqqHx_iBeC_xHqqkZx_
 *				           _xZkqqHx_iBeP_xHqqkZx_      _xZkqqHx_iBfA_xHqqkZx_
 *  
 *			_xZkqqHx_iHeD_xHqqkZx_	_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_ _xZkqqHx_iCkAiCkCiCkE_xHqqkZx_  _xZkqqHx_iBeC_xHqqkZx_  _xZkqqHx_iBeC_xHqqkZx_   _xZkqqHx_iBeC_xHqqkZx_
 *				           _xZkqqHx_iBeP_xHqqkZx_        _xZkqqHx_iBfA_xHqqkZx_
 *  
 *			_xZkqqHx_iHeE_xHqqkZx_	_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_ _xZkqqHx_iCkAiCkCiCkE_xHqqkZx_        _xZkqqHx_iCkAiCkCiCkE_xHqqkZx_
 *				             _xZkqqHx_iBfA_xHqqkZx_      _xZkqqHx_iBeP_xHqqkZx_
 *  
 *			_xZkqqHx_iHeF_xHqqkZx_	_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_ _xZkqqHx_iCkAiCkCiCkE_xHqqkZx_      \0
 *				             _xZkqqHx_iBfA_xHqqkZx_    _xZkqqHx_iBeP_xHqqkZx_
 *  
 *			_xZkqqHx_iHeG_xHqqkZx_	_xZkqqHx_iCkE_xHqqkZx_
 *				_xZkqqHx_iBeP_xHqqkZx_      _xZkqqHx_iBfA_xHqqkZx_
 *  
 *			_xZkqqHx_iHeH_xHqqkZx_	_xZkqqHx_iCkAiCkCiCkEiCgAiCgBiCgCiCgD_xHqqkZx_
 *				      _xZkqqHx_iBeP_xHqqkZx_    _xZkqqHx_iBfA_xHqqkZx_
 *
 *			_xZkqqHx_iKoOjGhLiCmNiHeAiBeCiClOiCkKiOmAiNnLiCmJiCmNiMlLiNnNiImKjChFiCkKiLoGjAnIiCoIiLeMiNiGiClOiCmBiClNiCoIiLpDjEjCiClOiCmBiClNiCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiLoGjAnIiCoIiLeMiNiGiCmMiPoKiNiHiBeFiLpDjEjCiCmMiPoKiNiHiCmMjBePiPiIjHjNiCpAiNhDiCmBiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiCkJiCoHiHeAiCmMiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBePiPiIjHjNiBeGiLoGjAnIiCoIiLeMiNiGiCmMiPoKiNiHiCmNiBeBiIoKiCmCjBePiCmMjFlGiOjKiBgJiLpDjEjCiImIiKePiBgKiCnGjGnPiClHiBeC_xHqqkZx_
 *					_xZkqqHx_iLpDjEjCiCmMiPoKiNiHiCmNiBeBiIoKiCmCjAoGiCmMjFlGiOjKiBgJiLpDjEjCiImIiKePiBgKiCnGjAgJiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iHeAiCkKiOmAiNhDiCmFiCkLiCoJiCnMiCmFiBeBiClBiCmMjBePiPiIjHjNiCpAiJlNjDhIiCoAiNhDiCkEiBeC_xHqqkZx_
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFIsWrapedWordJ (long& lNewCount, const wchar_t* wcpString, long lStringLen, long lCharCount)
{
	long lCharIndex = lCharCount;
	for (;;)
	{
		if (lCharIndex <= 0)
		{
			lNewCount = 0;
			break;
		}
		if (lCharIndex == lStringLen)
		{
			lNewCount = lCharIndex;
			break;
		}
		// _xZkqqHx_iJpMiNhDiCkKiKnMiCnMiCoKiCmEiCkCiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
		if (wcpString[lCharIndex] == WCH_LF ||
			wcpString[lCharIndex] == WCH_CR)
			FFThrowMiscUnknown();

		if (wcpString[lCharIndex] == WCH_ZEN_TOUTEN ||
			wcpString[lCharIndex] == WCH_ZEN_KUTEN ||
			wcpString[lCharIndex] == WCH_ZEN_COMMA ||
			wcpString[lCharIndex] == WCH_ZEN_PERIOD ||
			wcpString[lCharIndex] == WCH_HAN_TOUTEN ||
			wcpString[lCharIndex] == WCH_HAN_KUTEN)
		//----- _xZkqqHx_iLoGjAnIiCoIiLeMiNiGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iIoKiCmCjBePiCmMjFlGiOjKiBgJiLpDjEjCiImIiKePiBgKiCnMiCmFjGnPiClHiBeC_xHqqkZx_
			for (lCharIndex--; lCharIndex != -1; lCharIndex--)
			{
				if (wcpString[lCharIndex] == WCH_TAB ||
					wcpString[lCharIndex] == WCH_SPC ||
					wcpString[lCharIndex] == WCH_ZEN_SPC) continue;
				break;
			}
		} else
		if (wcpString[lCharIndex] == WCH_TAB ||
			wcpString[lCharIndex] == WCH_SPC ||
			wcpString[lCharIndex] == WCH_ZEN_SPC)
		//----- _xZkqqHx_iLpDjEjCiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iIoKiCmCiMoDiCmMjFlGiOjKiBgJiLpDjEjCiImIiKePiBgKiCnMiCmFjAgJiCnPiCoJiBeC_xHqqkZx_
			for (lCharIndex++; lCharIndex != lStringLen; lCharIndex++)
			{
				if (wcpString[lCharIndex] == WCH_TAB ||
					wcpString[lCharIndex] == WCH_SPC ||
					wcpString[lCharIndex] == WCH_ZEN_SPC) continue;
				break;
			}
		} else
		//----- _xZkqqHx_iLoGjAnIiCoIiLeMiNiGiBeFiLpDjEjCiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			FDCharKind cKind = FFGetCharKind(wcpString[lCharIndex]);
			lCharIndex--;
			// _xZkqqHx_jBfDiKhAiDeBiDiLiDhEiDeAiDhIiDgCiDgHiCpAiDiPiBfLiDgIiDiJiDgCiDhGjBmOiPnLiCmJiBeC_xHqqkZx_
			// _xZkqqHx_iDeKiDfOiDeKiDgJiCmNiBeBjBfDjFjEiDeKiDfOiDeKiDgJiCmMjFlGiPmNiCmMiPoKiNiHiCpAiNgMjHlGiClFiCmEiBeB_xHqqkZx_
			// _xZkqqHx_iDiPiBfLiDgIiDiJiDgCiDhGiCmMjBmOiPnLiKePiCmGiClHiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iDeNiDiKiDfGiDiDiBeBiDiNiDfGiDeBjFlGiOjKiCmNiBeBiDiPiBfLiDgIiDiJiDgCiDhGiCmMjBmOiPnLiCmGiClFiCmEiCoA_xHqqkZx_
			// _xZkqqHx_iOmAjHhAjAkLiCkKjCoBiCkCiBeCiCnMiClNiBeB_xHqqkZx_UNICODE_xZkqqHx_iCmJiCkIiCkCiCmEiCmNjBfDiKhAiDfCiBfLiDgIiCmFiCmNjGlDiCkCiBeC_xHqqkZx_
			if (cKind == FDCK_ZENK_ALPHABET)
			{
				for (; 0 <= lCharIndex; lCharIndex--)
				{
					if (cKind != FFGetCharKind(wcpString[lCharIndex])) break;
				}
			}
			lNewCount = lCharIndex + 1;
			break;
		}
	}
	return (lNewCount == lCharCount);
} // FFIsWrapedWordJ.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcCharCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	pxWidth_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjFjNiCmJjFfMiOkGiJmCjEfMiCmIjFlGiOjKjHpB_xHqqkZx_ wcpStr _xZkqqHx_iCmMjFlGiOjKjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pxTextWidth	:_xZkqqHx_jFfMiOkGjFjNiCmJiOpLiCnMiCoJjFlGiOjKjHpBiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *			pDC			:_xZkqqHx_jFlGiOjKjFjNiCpAiMhGiOfKiClHiCoJiInHiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjHfMiCnPiMhGiOfKjHhAiCmM_xHqqkZx_
 *						 _xZkqqHx_iDhEiDeIiDjDiDgHiCpAjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *			wcpStr		:_xZkqqHx_iMhGiOfKiClHiCoJiInHiCmMjFlGiOjKjHpBiBeC_xHqqkZx_
 *			pxWidthLimit:_xZkqqHx_jFfMiOkGjFjNiCmMiPoDiMmAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wCodePage	: _xZkqqHx_iClBiCmMjFlGiOjKiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiJmCjEfMiCmIjFlGiOjKjAjEiBeCiJpMiNhDiDfCiBfLiDgIiCmNiKnMiCnMiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpStr_xZkqqHx_iCmMiNmFiPiJiCmMjFlGiOjKiCkJiCoHiCfAjFlGiOjKiCmDiCmCjFjNiCpAjBkLiClFiCmEiCoEiCkLiBeB_xHqqkZx_pxWidth_xZkqqHx_iCpAiJhKiCkGiCoJ_xHqqkZx_
 *			_xZkqqHx_jClMjBePiCmMjFlGiOjKiCnMiCmFiCmMjFlGiOjKjAjEiCpAjFnEiClHiBeC_xHqqkZx_MBCS_xZkqqHx_iCmMiCfBiDgPiDeDiDgHjFlGiOjKiLkLiKeFiCoA_xHqqkZx_
 *			_xZkqqHx_iInDiOkPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	pxWidth_xZkqqHx_iCmMjEmNiImNjDoAiCmJiJpMiNhDiDfCiBfLiDgIiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiCmMjClMjBePiCmMjFlGiOjK_xHqqkZx_
 *			_xZkqqHx_iCnMiCmFiClFiCkJjAjEiCkGiCmIiCkCiBeC_xHqqkZx_
 *			pxWidth_xZkqqHx_iCmGjFlGiOjKjFjNiCkKiClPiCoFiCkEiCmHjDkPiClGiPoKiNiHiCmNiBeBjFlGiOjKiCkKiOpLiCnMiCmBiCmEiCkCiCoJiCmGiNgMiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FFCalcCharCount (	long& pxTextWidth,
						CDC* pDC,
						const wchar_t* wcpStr,
						long pxWidthLimit,
						WORD wCodePage,
						BOOL bIsWordWrapE,
						BOOL bIsWordWrapJ)
{
//----- 06.05.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCAutoDC atDC(pDC);
//	const wchar_t* wcpHead = wcpStr;
//	pxTextWidth = 0;
//	for (;;)
//	{
//		// _xZkqqHx_jFlGiOjKjHpBiPeJjCfLiCmMiPoKiNiHiBeBiJpMiNhDiDfCiBfLiDgIiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
//		if (*wcpHead == L'\0' || *wcpHead == L'\r' || *wcpHead == L'\n') break;
//		// 1_xZkqqHx_jFlGiOjKiCmMjFjNiCpAiOoGjDlOiBeC_xHqqkZx_
//		int iCharW;
//		atDC.GetCharWidth(*wcpHead, iCharW, wCodePage);
//		// [wcpStr,wcpHead]_xZkqqHx_iCnMiCmFiCmMjFlGiOjKjFjNiCpAiMhGiOfKiBeC_xHqqkZx_
//		// _xZkqqHx_jFlGiOjKjFjNiCkKiDeJiBfLiDgPiBfLiClFiClNiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
//		if (pxWidthLimit < pxTextWidth + iCharW) break;
//		// _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiPiIjHjNiCnGjAgJiCnOiBeC_xHqqkZx_
//		pxTextWidth += iCharW;
//		wcpHead++;
//	}
//	return long(wcpHead - wcpStr);
//----- 06.05.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjCfLiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const wchar_t* wcpEnd = wcpStr;
	for (;;)
	{
		// _xZkqqHx_jFlGiOjKjHpBiPeJjCfLiCmMiPoKiNiHiBeBiJpMiNhDiDfCiBfLiDgIiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (*wcpEnd == L'\0' || *wcpEnd == L'\r' || *wcpEnd == L'\n') break;
		wcpEnd++;
	}

	FCAutoDC atDC(pDC);
	const wchar_t* wcpHead = wcpStr;
	pxTextWidth = 0;
	while (wcpHead != wcpEnd)
	{
		// 1_xZkqqHx_jFlGiOjKiCmMjFjNiCpAiOoGjDlOiBeC_xHqqkZx_
		int iCharW;
		atDC.GetCharWidth(*wcpHead, iCharW, wCodePage);
		// [wcpStr,wcpHead]_xZkqqHx_iCnMiCmFiCmMjFlGiOjKjFjNiCpAiMhGiOfKiBeC_xHqqkZx_
		// _xZkqqHx_jFlGiOjKjFjNiCkKiDeJiBfLiDgPiBfLiClFiClNiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (pxWidthLimit < pxTextWidth + iCharW) break;
		// _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiPiIjHjNiCnGjAgJiCnOiBeC_xHqqkZx_
		pxTextWidth += iCharW;
		wcpHead++;
	}
	// _xZkqqHx_jEmNiImNiCmJiOpLiCnMiCoJjHeMiMpIjFlGiOjKjAjEiBeC_xHqqkZx_
	long lCharCount = long(wcpHead - wcpStr);

	// _xZkqqHx_iJpMiNhDiCnMiCmFiCmMiNmFjBoFjFlGiOjKjAjEiBeC_xHqqkZx_
	const long lStringLen = long(wcpEnd - wcpStr);
	//----- _xZkqqHx_iDiPiBfLiDgIiDiJiDgCiDhGiCmMiPiIjHjN_xHqqkZx_ -----
	long lNewCountE = lCharCount;
	long lNewCountJ = lCharCount;
	if (bIsWordWrapE)
		FFIsWrapedWordE(lNewCountE, wcpStr, lStringLen, lCharCount);
	if (bIsWordWrapJ)
		FFIsWrapedWordJ(lNewCountJ, wcpStr, lStringLen, lCharCount);
	// lCharCount, lNewCountE, lNewCountJ _xZkqqHx_iCmFiNmFiCoAiPkMiClDiCkCiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
	// _xZkqqHx_iDiPiBfLiDgIiDiJiDgCiDhGiPiIjHjNiCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_lCharCount _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
	long lLeastCount = lCharCount;
	if (lNewCountE < lLeastCount) lLeastCount = lNewCountE;
	if (lNewCountJ < lLeastCount) lLeastCount = lNewCountJ;
	// _xZkqqHx_iNmFiCoAiPkMiClDiCkCiImKjChFiCkKiCePiCmFiCmIiCkCiPoKiNiHiCmNiBeBjFlGiOjKjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
	if (lLeastCount != 0)
		lCharCount = lLeastCount;
	return lCharCount;
//----- 06.05.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFCalcCharCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcTextLines
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAiBeBiOhHjCoIiClDiCoKiClNiJkBjFjNiCmJiOpLiCnMiCoJiCoGiCkEiCmJjFkKiKiEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vText	:_xZkqqHx_jFkKiKiEiClDiCoKiClNiDgFiDeMiDfIiDgHiNhDiCpAjFnEiClHiBeCjHhGjBgGiCmJiCmNiBeBiJpMiNhDiCpAiKnMiCnMiCmIiCkC_xHqqkZx_
 *					 _xZkqqHx_iCfAiNhDiCmMiDgFiDeMiDfIiDgHiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFlGiOjKjFjNiCpAiMhGiOfKiClHiCoJiInHiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjHfMiCnPiMhGiOfKjHhAiCmM_xHqqkZx_
 *					 _xZkqqHx_iDhEiDeIiDjDiDgHiCpAjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *			wcpText	:_xZkqqHx_iMhGiOfKiClHiCoJiInHiCmMjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxWidthLimit	:_xZkqqHx_jFfMiOkGjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wCodePage	: _xZkqqHx_iClBiCmMjFlGiOjKiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmFiCoAjFjNiCkKiNeMiCkCjFjEjFkKiCmMjFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	pDC_xZkqqHx_iCmJiCmNiBeBjHfMiCnPiDfEiDeDiDfJiMhGiOfKjHhAiCmJiDhEiDeIiDjDiDgHiCpAjAnNjCoIiClFiCmEiCkIiCkNiBeCiClBiCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiDjDiDgHjFjNiCmNiDhEiDeIiDjDiDgHiDfEiDeDiDfJiCmJjEoEjHoBiClHiCoJiCmGiCmNiMmAiCoHiCmIiCkCiCmMiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_jHfMiCnPjBoFiCkLiCnPiCmMiDhEiDeIiDjDiDgHiCpAiBeBjFjNiMhGiOfKjHhAiCmJiMmFjCoIiCmFiMiIiCnPiCmEiCkIiCkNiCmGiCoGiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FFCalcTextLines (	WStringVector& vText,
						CDC* pDC,
						const wchar_t* wcpText,
						long pxWidthLimit,
						WORD wCodePage,
						BOOL bIsWordWrapE,
						BOOL bIsWordWrapJ)
{
	// _xZkqqHx_jFkKiKiEiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_vCountLength_xZkqqHx_iCmMjHhGjBgGiCmM_xHqqkZx_pair<long,long>_xZkqqHx_iCmMiBeB_xHqqkZx_
	// _xZkqqHx_jBePiOnCiCmNiJpMiNhDiCpAiKnMiCnOjFlGiOjKjAjEiBeBiMoDiOnCiCmNiJpMiNhDiCpAiKnMiCnMiCmIiCkCjFlGiOjKjAjEiBeC_xHqqkZx_
	longlongVector vCountLength;
	long pxMaxWidth = FFCalcTextLines(vCountLength, pDC, wcpText, pxWidthLimit, wCodePage, bIsWordWrapE, bIsWordWrapJ);
	longlongVector::const_iterator iLL;
	for (iLL = vCountLength.begin(); iLL != vCountLength.end(); iLL++)
	{
		vText.push_back(WString(wcpText, (*iLL).second));
		wcpText += (*iLL).first;
	}
	return pxMaxWidth;
} // FFCalcTextLines.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcTextLines
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAiBeBiOhHjCoIiClDiCoKiClNiJkBjFjNiCmJiOpLiCnMiCoJiCoGiCkEiCmJjFkKiKiEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vCountLength	:_xZkqqHx_jFkKiKiEiPoOjFpBiCpAjFnEiClHiBeCjHhGjBgGiCmM_xHqqkZx_pair<long,long>_xZkqqHx_iCmMiBeB_xHqqkZx_
 *							 _xZkqqHx_jBePiOnCiCmNiJpMiNhDiCpAiKnMiCnOjFlGiOjKjAjEiBeBiMoDiOnCiCmNiJpMiNhDiCpAiKnMiCnMiCmIiCkC_xHqqkZx_
 *							 _xZkqqHx_jFlGiOjKjAjEiBeBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFlGiOjKjFjNiCpAiMhGiOfKiClHiCoJiInHiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjHfMiCnPiMhGiOfKjHhAiCmM_xHqqkZx_
 *					 _xZkqqHx_iDhEiDeIiDjDiDgHiCpAjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *			wcpText	:_xZkqqHx_iMhGiOfKiClHiCoJiInHiCmMjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxWidthLimit:_xZkqqHx_jFfMiOkGjFjNiCmMiPoDiMmAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wCodePage	: _xZkqqHx_iClBiCmMjFlGiOjKiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmFiCoAjFjNiCkKiNeMiCkCjFjEjFkKiCmMjFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	pDC_xZkqqHx_iCmJiCmNiBeBjHfMiCnPiDfEiDeDiDfJiMhGiOfKjHhAiCmJiDhEiDeIiDjDiDgHiCpAjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FFCalcTextLines (	longlongVector& vCountLength,
						CDC* pDC,
						const wchar_t* wcpText,
						long pxWidthLimit,
						WORD wCodePage,
						BOOL bIsWordWrapE,
						BOOL bIsWordWrapJ)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmFiCoAjFjNiCkKiNeMiCkCjFjEjFkKiCmMjFjNiBeC_xHqqkZx_
	long pxMaxWidth = 0;

	//----- _xZkqqHx_iNhDjAjEiBjFiNiCiClDiMhGiOfK_xHqqkZx_ -----
	vCountLength.clear();
	if (wcpText == NULL) return 0;
	const wchar_t* wcpHead = wcpText;
	for (;;)
	{
		// pxWidthLimit_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjFjNiCmJjFfMiOkGiJmCjEfMiCmIjFlGiOjKjHpB_xHqqkZx_ wcpHead _xZkqqHx_iCmMjFlGiOjKjAjEiCpAjFnEiClHiBeC_xHqqkZx_
		// _xZkqqHx_iJpMiNhDiDfCiBfLiDgIiCmNjAjEiCmJiKnMiCnMiCmIiCkCiBeC_xHqqkZx_
		long pxTextWidth;
		long lCount = FFCalcCharCount(pxTextWidth, pDC, wcpHead, pxWidthLimit, wCodePage, bIsWordWrapE, bIsWordWrapJ);
		// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmFiCoAjFjNiCkKiNeMiCkCjFjEjFkKiCmMjFjNiBeC_xHqqkZx_
		if (pxMaxWidth < pxTextWidth) pxMaxWidth = pxTextWidth;
		wcpHead += lCount;
		// _xZkqqHx_iJpMiNhDiDfCiBfLiDgIiCpAiKnMiCnOjFlGiOjKjAjEiBeC_xHqqkZx_
		long lLength = lCount;
		// _xZkqqHx_iJpMiNhDiDfCiBfLiDgIiCmMiPoKiNiHiCmNiClLiCoKiCpAjBjHiCoJiBeC_xHqqkZx_
		if (*wcpHead == '\r')
		{
			wcpHead++;
			lLength++;
		}
		if (*wcpHead == '\n')
		{
			wcpHead++;
			lLength++;
		}
		// _xZkqqHx_iJpMiNhDiDfCiBfLiDgIiCpAiKnMiCnOjFlGiOjKjAjEiCkKiCePiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
		if (lLength == 0) break;
		// [_xZkqqHx_iJpMiNhDiCpAiKnMiCnOjFlGiOjKjAjEiBeBiJpMiNhDiCpAiKnMiCnMiCmIiCkCjFlGiOjKjAjE_xHqqkZx_]_xZkqqHx_iCmMjEhKjHpBiCpAjCmHiJmBiBeC_xHqqkZx_
		vCountLength.push_back(pair<long, long>(lLength, lCount));
	}
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmFiCoAjFjNiCkKiNeMiCkCjFjEjFkKiCmMjFjNiBeC_xHqqkZx_
	return pxMaxWidth;
} // FFCalcTextLines.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcTextFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjNiCpAiPoDiMmAiCmGiClHiCoJiBeBiDgFiDeMiDfIiDgHjBfDjBmMiCmMjFjNiCmGiNiCiClDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pxWidth		:_xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *			pxHeight	:_xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *			vText		:_xZkqqHx_jFkKiKiEiClDiCoKiClNiDgFiDeMiDfIiDgHiNhDiCpAjFnEiClHiBeCjHhGjBgGiCmJiCmNiBeBiJpMiNhDiCpAiKnMiCnMiCmIiCkC_xHqqkZx_
 *						 _xZkqqHx_iCfAiNhDiCmMiDgFiDeMiDfIiDgHiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			pxWidthLimit:_xZkqqHx_jFfMiOkGjFjNiCmMiPoDiMmAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC			:_xZkqqHx_jFlGiOjKjFjNiCpAiMhGiOfKiClHiCoJiInHiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjHfMiCnPiMhGiOfKjHhAiCmM_xHqqkZx_
 *						 _xZkqqHx_iDhEiDeIiDjDiDgHiCpAjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *			wcpText		:_xZkqqHx_iMhGiOfKiClHiCoJiInHiCmMjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxLineHeight:_xZkqqHx_iCfAiNhDiCmMiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pxLineGap	:_xZkqqHx_iNhDiCmGiNhDiCmMiKnEiCmMiDeNiDiDiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wCodePage	: _xZkqqHx_iClBiCmMjFlGiOjKiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCfEiNhDiCmMiDgFiDeMiDfIiDgHiCmMiPoKiNiHiCmMjHoBiBeC_xHqqkZx_
 *         _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkCiEjPiEjPiEjP_xHqqkZx_
 *         _xZkqqHx_iBeGiCfAiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBkK_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iBeGiCfBiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iBeGiCfCiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iDgFiDeMiDfIiDgHjBfDjBmMiCmMiNiCiClD_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iBeGiCfDiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineGap          _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iBeGiCfEiNhDjGnK_xHqqkZx_ _xZkqqHx_iEkAiBkJ_xHqqkZx_ pxLineHeight  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBkL_xHqqkZx_
 *         _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkDiEjPiEjPiEjP_xHqqkZx_
 *         _xZkqqHx_iEkA_xHqqkZx_                          _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkAiBkJiEjPiEjPiEjP_xHqqkZx_ pxWidth -_xZkqqHx_iEjPiEjPiEjPiBkIiEkA_xHqqkZx_
 *
 *			pxWidth_xZkqqHx_iBeF_xHqqkZx_pxWidth _xZkqqHx_iCmNiBeBjFlGiOjKiCkKiOpLiCnMiCoJiDeMiDgCiDgAiDiKiClFiClNjFjNiCmGiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCalcTextFrame (	long& pxWidth,
						long& pxHeight,
						WStringVector& vText,
						long pxWidthLimit,
						CDC* pDC,
						const wchar_t* wcpText,
						long pxLineHeight,
						long pxLineGap,
						WORD wCodePage,
						BOOL bIsWordWrapE,
						BOOL bIsWordWrapJ)
{
	long pxMaxWidth = FFCalcTextLines(vText, pDC, wcpText, pxWidthLimit, wCodePage, bIsWordWrapE, bIsWordWrapJ);

	if (vText.empty())
	//----- _xZkqqHx_iJlNiCoAiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		pxWidth = 0;
		pxHeight = 0;
	} else
	{
		pxWidth = pxMaxWidth;
		pxHeight = vText.size() * pxLineHeight + (vText.size() - 1) * pxLineGap;
	}
} // FFCalcTextFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcTextBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiDeMiDfIiDgHiCkKiOpLiCnMiCoJiDhLiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmBoxWidth	:_xZkqqHx_iDhLiDgCiDeOiDfIiCmMiMhGiOfKiMiLiJmKiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmBoxHeight	:_xZkqqHx_iDhLiDgCiDeOiDfIiCmMiMhGiOfKiMiLiJmKiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmTextHeight:_xZkqqHx_iIoKiNhDiCmMiDgFiDeMiDfIiDgHiNiCiCpAjFnEiClHiBeC_xHqqkZx_
 *			vText		:_xZkqqHx_jFkKiKiEiClDiCoKiClNiDgFiDeMiDfIiDgHiNhDiCpAjFnEiClHiBeCjHhGjBgGiCmJiCmNiBeBiJpMiNhDiCpAiKnMiCnMiCmIiCkC_xHqqkZx_
 *						 _xZkqqHx_iCfAiNhDiCmMiDgFiDeMiDfIiDgHiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			dMaxWidthPerHeight :_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmM_xHqqkZx_ _xZkqqHx_jFjNiBiAiNiCiClD_xHqqkZx_ _xZkqqHx_iCmMiNmFjBoFjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dStdWidthPerHeight :_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmM_xHqqkZx_ _xZkqqHx_jFjNiBiAiNiCiClD_xHqqkZx_ _xZkqqHx_iCmMjFfHiPiAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC			:_xZkqqHx_jFlGiOjKjFjNiCpAiMhGiOfKiClHiCoJiInHiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjHfMiCnPiMhGiOfKjHhAiCmM_xHqqkZx_
 *						 _xZkqqHx_iDhEiDeIiDjDiDgHiCpAjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *			wcpText		:_xZkqqHx_iMhGiOfKiClHiCoJiInHiCmMjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLineGap	:_xZkqqHx_iNhDiCmGiNhDiCmMiKnEiCmMiDeNiDiDiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wCodePage	: _xZkqqHx_iClBiCmMjFlGiOjKiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>
 *         _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkNiEjPiEjPiEkG_xHqqkZx_
 *         _xZkqqHx_iEkLiCfAiNhDjGnK_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ mmLineGap              _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkLiCfBiNhDjGnK_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ mmLineGap              _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkLiCfCiNhDjGnK_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ mmLineGap              _xZkqqHx_iEkL_xHqqkZx_  mmBoxHeight
 *         _xZkqqHx_iEkLiCfDiNhDjGnK_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ mmLineGap              _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkLiCfEiNhDjGnK_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkAiBkJ_xHqqkZx_ mmLineGap              _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkLiCfFiNhDjGnK_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkOiEjPiEjPiEkI_xHqqkZx_
 *         _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
 *         _xZkqqHx_iEkAiBkJiEjPiEjPiEjP_xHqqkZx_ mmBoxWidth _xZkqqHx_iEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_
 *
 *			_xZkqqHx_iCnMiClIiBeBiDgFiDeMiDfIiDgHiCmMiJpMiNhDiCmMiCnNiCpAiNgMjHlGiClFiCmEiBeB_xHqqkZx_mmBoxWidth _xZkqqHx_iCmG_xHqqkZx_ mmBoxHeight _xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClHiCoJiBeC_xHqqkZx_(mmBoxWidth / mmBoxHeight) _xZkqqHx_iCkK_xHqqkZx_ dMaxWidthPerHeight _xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_iJhKiCkGiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_dStdWidthPerHeight _xZkqqHx_iCpAiKoOiPiAiCmJiClFiCmE_xHqqkZx_
 *			mmBoxWidth _xZkqqHx_iCmG_xHqqkZx_ mmBoxHeight _xZkqqHx_iCpAiNmEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCalcTextBox (mmetol& mmBoxWidth,
					mmetol& mmBoxHeight,
					mmetol& mmTextHeight,
					WStringVector& vText,
					double dMaxWidthPerHeight,
					double dStdWidthPerHeight,
					FDRegFontType fontType,
					const wchar_t* wcpText,
					mmetol mmLineGap,
					WORD wCodePage,
					BOOL bIsWordWrapE,
					BOOL bIsWordWrapJ)
{
	// _xZkqqHx_iLpDjFlGiOjKiCmFiCmNiMhGiOfKiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	if (wcpText == NULL || wcpText[0] == L'\0')
		FFThrowMiscUnknown();

	CDC dc;
	dc.CreateDC(_T("DISPLAY"), NULL, NULL, NULL);

	CFont font;
	g_pReg->InitRegFont(font, fontType, 0, g_->dZoom);
	CFont* pFontOld = dc.SelectObject(&font);
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDiBiDgHiDiKiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	TEXTMETRIC tmMetrics;
	dc.GetTextMetrics(&tmMetrics);
	// _xZkqqHx_iNhDiKnEiCmMiDhDiDeOiDfKiDiLjCgMiCpAiOfKiPgPiBeC_xHqqkZx_
	const long pxLineGap = mm2lg(mmLineGap);

	long pxWidth, pxHeight;
	// _xZkqqHx_jFjNjGlDjAkHiMmA_xHqqkZx_(LONG_MAX)_xZkqqHx_iCmMiPoKiNiHiCmMiBeBiDgFiDeMiDfIiDgHjBfDjBmMiCmMjFjNiCmGiNiCiClDiCpAiMhGiOfKiBeC_xHqqkZx_
	vText.clear();
	FFCalcTextFrame(pxWidth,
					pxHeight,
					vText,
					LONG_MAX,
					&dc,
					wcpText,
					tmMetrics.tmHeight,
					pxLineGap,
					wCodePage,
					bIsWordWrapE,
					bIsWordWrapJ);
	if (dMaxWidthPerHeight < double(pxWidth) / double(pxHeight))
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAiCmMiPgDiJkBjEoEiCkKjAkHiMmAjCgMiCpAiJhKiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// pxWidth _xZkqqHx_iCmG_xHqqkZx_ pxHeight _xZkqqHx_iCmFiNoMiCoHiCoKiCoJjGmKjAmPiCmGjDjJiClFiCkC_xHqqkZx_ _xZkqqHx_jDeLjDjGiCmIjFjNiBeFiNiCiClDiCpA_xHqqkZx_
		// _xZkqqHx_iMhGiOfKiClFiBeBiClLiCmMjFjNiCmJiKoOiCmDiCkCiCmE_xHqqkZx_ _xZkqqHx_iNmEjDhI_xHqqkZx_ _xZkqqHx_jFjNiCmGiNiCiClDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
		// Area = W * H
		// newW x newH = Area
		// newH = newW / dStdWidthPerHeight
		// newW * newW / dStdWidthPerHeight = Area
		// newW * newW = Area * dStdWidthPerHeight
		// newW = _xZkqqHx_iBoD_xHqqkZx_(Area * dStdWidthPerHeight)
		long pxNewWidth = D2L(sqrt(double(pxWidth) * double(pxHeight) * dStdWidthPerHeight));
		// _xZkqqHx_jFjNiPoDiMmAiCkK_xHqqkZx_pxNewWidth_xZkqqHx_iCmMiPoKiNiHiCmMiBeBiDgFiDeMiDfIiDgHjBfDjBmMiCmMjFjNiCmGiNiCiClDiCpAiMhGiOfKiBeC_xHqqkZx_
		vText.clear();
		FFCalcTextFrame(pxWidth,
						pxHeight,
						vText,
						pxNewWidth,
						&dc,
						wcpText,
						tmMetrics.tmHeight,
						pxLineGap,
						wCodePage,
						bIsWordWrapE,
						bIsWordWrapJ);
	}
	dc.SelectObject(pFontOld);
	mmBoxWidth = lg2mm(pxWidth);
	mmBoxHeight = lg2mm(pxHeight);
	mmTextHeight = lg2mm(tmMetrics.tmHeight);
} // FFCalcTextBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFAppendString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	str_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjFlGiOjKjHpBiCmMiMoDiCoLiCmJ_xHqqkZx_wcpStr_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjFlGiOjKjHpBiCpA_xHqqkZx_
 *			_xZkqqHx_iCmCiCmIiCkCiCmFiIoKiCmCiCmMjFlGiOjKjHpBiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str		:_xZkqqHx_iCmCiCmIiCkOiNlGiCmMjFlGiOjKjHpBiCpAiOhHjCoIiClFiBeBiCmCiCmIiCkCiClOiMoDiCmMjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpStr	:_xZkqqHx_iCmCiCmIiCkOiJeFiCmMjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFkBjAjEiCmMiDhEiDeAiDeDiDiLjGlMjDjJiCpAiCmCiCmIiCkCiCmFiIoKiCmCiCmMjFlGiOjKjHpBiCmJiClHiCoJiBeCiLoGjAnIiCoIiCmM_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKiCkKiOgHiCkGiCmIiCkCiInHiBeB_xHqqkZx_16_xZkqqHx_jAgJiCmMjFlGiOjKjAjEjFlGiOjKjHpBiCpAiKnEiCmJiLlCiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFAppendString (WString& str, const wchar_t* wcpStr)
{
	WString strLen;
	strLen.Format(L"%x ", wcslen(wcpStr));
	str += strLen + wcpStr;
} // FFAppendString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFExtractString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	str_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjFlGiOjKjHpBiCmMjDkKiCkJiCoHiCfAiCmCiCmMjFlGiOjKjHpBiCpAjElCiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str		:_xZkqqHx_iOoGiCoIiPgPiClHiMlDiCmMjFlGiOjKjHpBiCpAiOhHjCoIiClFiBeBjElCiCkLiPgPiClDiCoKiClNiMoDiCmMjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jElCiCkLiPgPiClFiClNjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFAppendString_xZkqqHx_iCmFiNoMiCoHiCoKiClNjFlGiOjKjHpBiCpAiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFExtractString (WString& str)
{
	if (str.IsEmpty()) return L"";
	const wchar_t* wcpStr = (const wchar_t*)str;
	wchar_t* wcpNext;
	DWORD dwLen = wcstoul(wcpStr, &wcpNext, 16);
	int iNumLen = (wcpNext - wcpStr) + 1;
	const WString strHead = str.Mid(iNumLen, dwLen);
	str.Delete(0, iNumLen + dwLen);
	return strHead;
} // FFExtractString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFInsTopString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	str_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCmJ_xHqqkZx_wcpStr_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjFlGiOjKjHpBiCpA_xHqqkZx_
 *			_xZkqqHx_iCmCiCmIiCkCiCmFiIoKiCmCiCmMjFlGiOjKjHpBiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str		:_xZkqqHx_iCmCiCmIiCkOiJeFiCmMjFlGiOjKjHpBiCpAiOhHjCoIiClFiBeBiCmCiCmIiCkCiClOiMoDiCmMjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpStr	:_xZkqqHx_iCmCiCmIiCkOiNlGiCmMjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFkBjAjEiCmMiDhEiDeAiDeDiDiLjGlMjDjJiCpAiCmCiCmIiCkCiCmFiIoKiCmCiCmMjFlGiOjKjHpBiCmJiClHiCoJiBeCiLoGjAnIiCoIiCmM_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKiCkKiOgHiCkGiCmIiCkCiInHiBeB_xHqqkZx_16_xZkqqHx_jAgJiCmMjFlGiOjKjAjEjFlGiOjKjHpBiCpAiKnEiCmJiLlCiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFInsTopString (WString& str, const wchar_t* wcpStr)
{
	WString strNew;
	strNew.Format(L"%x %s%s", wcslen(wcpStr), wcpStr, str.c_str());
	str = strNew;
} // FFInsTopString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFExtractUntil
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCkJiCoH_xHqqkZx_wc_xZkqqHx_iCmFiLoGjAnIiCoHiCoKiCoJjAoGjDkKiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *			wc _xZkqqHx_iCmMjClMjBePiCnMiCmFiCmMjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_str _xZkqqHx_iCmNiBeB_xHqqkZx_wc_xZkqqHx_iCnMiCmFiCmMjFlGiOjK_xHqqkZx_(wc _xZkqqHx_iCpAiKnMiCnO_xHqqkZx_)_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_iNoNiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str	:_xZkqqHx_iOoGiCoIiPgPiClDiCoKiCoJjFlGiOjKjHpBiCpAiOhHjCoIiBeCjAoGjDkKiBgA_xHqqkZx_wc_xZkqqHx_iCnMiCmFiCkKiDeKiDgCiDgHiClDiCoKiCoJiBeC_xHqqkZx_
 *			wc	:_xZkqqHx_iLoGjAnIiCoIjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAoGjDkKjFlGiOjKjHpBiBeCiLoGjAnIiCoIjFlGiOjKiCmNiKnMiCnMiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFExtractUntil (WString& str, wchar_t wc)
{
	WString str2;
	int iPos = str.find_first_of(wc);
	if (iPos != WString::npos)
	{
		str2.assign(str.c_str(), iPos);
		str.erase(str.begin(), str.begin() + iPos + 1);
	} else
	{
		str2 = str;
		str.erase();
	}
	return str2;
} // FFExtractUntil.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFExtractUntil
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCkJiCoH_xHqqkZx_wcp_xZkqqHx_iCmMiCkEiClPiCmMiCfAjFlGiOjKiCmFiLoGjAnIiCoHiCoKiCoJjAoGjDkKiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str	:_xZkqqHx_iOoGiCoIiPgPiClDiCoKiCoJjFlGiOjKjHpBiCpAiOhHjCoIiBeCjAoGjDkKiBgA_xHqqkZx_tc_xZkqqHx_iCnMiCmFiCkKiDeKiDgCiDgHiClDiCoKiCoJiBeC_xHqqkZx_
 *			wcp	:_xZkqqHx_iLoGjAnIiCoIjFlGiOjKiCmMjEhKjHpBiCpAiOhHjCoIiBeCiLpDjFlGiOjKiCmFiPeJiCoNiCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAoGjDkKjFlGiOjKjHpBiBeCiLoGjAnIiCoIjFlGiOjKiCmNiKnMiCnMiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFExtractUntil (WString& str, const wchar_t* wcp)
{
	WString strLeft = str.SpanExcluding(wcp);
	str.Delete(0, strLeft.GetLength());
	if (!str.IsEmpty()) str.Delete(0);
	return strLeft;
} // FFExtractUntil.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFExtractUntil
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCkJiCoH_xHqqkZx_c_xZkqqHx_iCmFiLoGjAnIiCoHiCoKiCoJjAoGjDkKiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *			c _xZkqqHx_iCmMjClMjBePiCnMiCmFiCmMjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_str _xZkqqHx_iCmNiBeB_xHqqkZx_c_xZkqqHx_iCnMiCmFiCmMjFlGiOjK_xHqqkZx_(c _xZkqqHx_iCpAiKnMiCnO_xHqqkZx_)_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_iNoNiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAoGjDkKjFlGiOjKjHpBiBeCiLoGjAnIiCoIjFlGiOjKiCmNiKnMiCnMiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	char_xZkqqHx_iMfOjAoKjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
astring FFExtractUntil (astring& str, char c)
{
	astring str2;
	int iPos = str.find_first_of(c);
	if (iPos != astring::npos)
	{
		str2.assign(str.c_str(), iPos);
		str.erase(str.begin(), str.begin() + iPos + 1);
	} else
	{
		str2 = str;
		str.erase();
	}
	return str2;
} // FFExtractUntil.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFExtractUntil
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCkJiCoH_xHqqkZx_cp_xZkqqHx_iCmMiIoKjFlGiOjK_xHqqkZx_ c _xZkqqHx_iCmFiLoGjAnIiCoHiCoKiCoJjAoGjDkKiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *			c _xZkqqHx_iCmMjClMjBePiCnMiCmFiCmMjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_str _xZkqqHx_iCmNiBeB_xHqqkZx_c_xZkqqHx_iCnMiCmFiCmMjFlGiOjK_xHqqkZx_(c _xZkqqHx_iCpAiKnMiCnO_xHqqkZx_)_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_iNoNiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAoGjDkKjFlGiOjKjHpBiBeCiLoGjAnIiCoIjFlGiOjKiCmNiKnMiCnMiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	char_xZkqqHx_iMfOjAoKjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
astring FFExtractUntil (astring& str, const char* cp)
{
	astring str2;
	int iPos = str.find_first_of(cp);
	if (iPos != astring::npos)
	{
		str2.assign(str.c_str(), iPos);
		str.erase(str.begin(), str.begin() + iPos + 1);
	} else
	{
		str2 = str;
		str.erase();
	}
	return str2;
} // FFExtractUntil.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAiNhDiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_lLineCount_xZkqqHx_iCmJjBjHiCmBiClNiNhDjAjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJpMiNhDiCmMjClMjBePiCnMiCmFiCmMjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_str _xZkqqHx_iCmNiBeBiJpMiNhDiCnMiCmFiCmMjFlGiOjK_xHqqkZx_(_xZkqqHx_iJpMiNhDiCpAiKnMiCnO_xHqqkZx_)_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_iNoNiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
astring GetLine (astring& str, long& lLineCount)
{
	astring str2;
	int iPos = str.find_first_of("\r\n");
	if (iPos != astring::npos)
	{
		lLineCount = 1;
		str2.assign(str.c_str(), iPos);
		if (str[iPos] == '\r') iPos++;
		if (str[iPos] == '\n') iPos++;
		str.erase(str.begin(), str.begin() + iPos);
	} else
	{
		lLineCount = 0;
		str2 = str;
		str.erase();
	}
	return str2;
} // GetLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	TrimLeft
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiNlGiCmMiLpDjEjCiBeFiJpMiNhDiCpAiNoNiPjMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	char_xZkqqHx_iMfOjAoKjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void TrimLeft (astring& str)
{
	int iPos = str.find_first_not_of(" \t\r\n");
	if (iPos != astring::npos)
		str.erase(str.begin(), str.begin() + iPos);
	else
		str.erase();
} // TrimLeft.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	TrimRight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiJeFiCmMiLpDjEjCiBeFiJpMiNhDiCpAiNoNiPjMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	char_xZkqqHx_iMfOjAoKjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void TrimRight (astring& str)
{
	int iPos = str.find_last_not_of(" \t\r\n");
	if (iPos != astring::npos)
		str.erase(str.begin() + iPos + 1, str.end());
	else
		str.erase();
} // TrimRight.

//----- 01.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//typedef set<BYTE>	BYTESet;
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myEnumFontFamExProc
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SetCurCharInfo_xZkqqHx_iKnGjAjEjCiGiCmMiBeB_xHqqkZx_EnumFontFamiliesEx_xZkqqHx_jHhA_xHqqkZx_Callback_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_jHpBiLjDiClDiCoKiClN_xHqqkZx_CharSet_xZkqqHx_iCpAiBeB_xHqqkZx_setCharSet_xZkqqHx_iCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pLogFont	:LOGFONT_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lParam		:BYTESet*_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static int CALLBACK myEnumFontFamExProc (const LOGFONT* pLogFont,
//										 const TEXTMETRIC*, DWORD, LPARAM lParam)
//{
//	BYTESet* setCharSet = (BYTESet*)lParam;
//	setCharSet->insert(pLogFont->lfCharSet);
//	return 1;
//} // myEnumFontFamExProc.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IsCharSetIncluded
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeIiDjDiDgHiCmJiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_CharSet_xZkqqHx_iCkKiKnMiCnMiCoKiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hdc	:_xZkqqHx_iDhEiDeIiDjDiDgHiCpAjClCiCnHiCoJiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			cf	:_xZkqqHx_iDhEiDeIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lfCharSet	:_xZkqqHx_jClCiCnHiCoJ_xHqqkZx_CharSet_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnMiCnMiCoKiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiKnMiCnMiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL IsCharSetIncluded (HDC hdc, const CHARFORMAT& cf, BYTE lfCharSet)
//{
//	//----- cf_xZkqqHx_iCmJjAnNjCoIiClDiCoKiClNiDhEiDeIiDjDiDgHiCmM_xHqqkZx_CharSet_xZkqqHx_iIoKjHjHiCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
//	BYTESet setCharSet;
//	LOGFONT logFont;
//	logFont.lfCharSet = DEFAULT_CHARSET;
//	_tcscpy(logFont.lfFaceName, cf.szFaceName);
//	logFont.lfPitchAndFamily = 0;
//	(void)::EnumFontFamiliesEx(hdc, &logFont, myEnumFontFamExProc, LPARAM(&setCharSet), 0);
//	// _xZkqqHx_iDhEiDeIiDjDiDgHiCmJiOhHjCoIiCmM_xHqqkZx_CharSet_xZkqqHx_iCkKiKnMiCnMiCoKiCoJiCmIiCoHiBeB_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
//	return (setCharSet.find(lfCharSet) != setCharSet.end());
//} // IsCharSetIncluded.
//----- 01.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 03.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetResString
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfMiBfLiDfIiCmMjFlGiOjKjHpBiCpAiOoGjDlOiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeCiDiKiDfMiBfLiDfIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_iLpDjFlGiOjK_xHqqkZx_ _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmJiDfIiDfOiDgFiDeCiDgCiDeOiCmJjFlGiOjKjHpBiCpAjFnLjBlGiClFiBeBiClLiCoKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const _TCHAR* GetResString (DWORD dwId)
//{
//	static map<DWORD, TCHARAuto> mpIdToString;
//	if (mpIdToString.find(dwId) == mpIdToString.end())
//	{
//		CString str;
//		str.LoadString(dwId);
//		mpIdToString[dwId] = TCHARAuto(StrNewCpy(str));
//	}
//	return mpIdToString[dwId].get();
//} // GetResString.
//----- 03.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----------<NOT EXPORT TO SDK>-----------
// CString _xZkqqHx_iCmN_xHqqkZx_SDK_xZkqqHx_iCmFiOgHiCkGiCmIiCkCiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLoadString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiKiDfMiBfLiDfIjFlGiOjKjHpBiCpAjDmHiCnNiNjOiCpBiCmFjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeCiDiKiDfMiBfLiDfIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_iLpDjFlGiOjK_xHqqkZx_ _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CString FFLoadString (DWORD dwId)
{
	CString str;
	str.LoadString(dwId);
	return str;
} // FFLoadString.

//----------</NOT EXPORT TO SDK>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLoadWString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiKiDfMiBfLiDfIjFlGiOjKjHpBiCpAjDmHiCnNiNjOiCpBiCmFjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeCiDiKiDfMiBfLiDfIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_iLpDjFlGiOjK_xHqqkZx_ _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFLoadWString (DWORD dwId)
{
	WString wstr;
	wstr.LoadString(dwId);
	return wstr;
} // FFLoadWString.

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetResWString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfMiBfLiDfIiCmMjFlGiOjKjHpBiCpAiOoGjDlOiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeCiDiKiDfMiBfLiDfIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_iLpDjFlGiOjK_xHqqkZx_ _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmJiDfIiDfOiDgFiDeCiDgCiDeOiCmJjFlGiOjKjHpBiCpAjFnLjBlGiClFiBeBiClLiCoKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* GetResWString (DWORD dwId)
{
	static map<DWORD, WCharAuto> mpIdToString;
	if (mpIdToString.find(dwId) == mpIdToString.end())
	{
		WString str;
		str.LoadString(dwId);
		mpIdToString[dwId] = WCharAuto(StrNewCpy(str));
	}
	return mpIdToString[dwId].get();
} // GetResWString.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFormatString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	wcpFormat_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDhEiDeIiBfLiDhNiDgCiDgHiMgAiOkOiCmFjFlGiOjKjHpBiCpAiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFormat	:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			...			:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjBmOiPnLjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFFormatString (const wchar_t* wcpFormat, ...)
{
	va_list argList;
	va_start(argList, wcpFormat);
	WString wstr = FFFormatStringV(wcpFormat, argList);
	va_end(argList);
	return wstr;
} // FFFormatString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFormatStringV
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	wcpFormat_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDhEiDeIiBfLiDhNiDgCiDgHiMgAiOkOiCmFjFlGiOjKjHpBiCpAiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFormat	:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			argList	:_xZkqqHx_iIpIjAjEiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFFormatStringV (const wchar_t* wcpFormat, va_list argList)
{
	WString strMsg;
	strMsg.FormatV(wcpFormat, argList);
	return strMsg;
} // FFFormatStringV.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FormatResString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfMiBfLiDfIiCmMjFlGiOjKjHpBiCpAiOoGjDlOiClFiCmEiBeBiDhEiDeIiBfLiDhNiDgCiDgHiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjFlGiOjKjHpBiCmMiDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			...		:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjBmOiPnLjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeCiDiKiDfMiBfLiDfIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_iLpDjFlGiOjK_xHqqkZx_ _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
//----- 03.07.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjFlGiOjKjHpBiCmNiBeBjDoAjFjEiCmJiDfIiDfOiDgFiDeCiDgCiDeOiCmJjFlGiOjKjHpBiCpAjFnLjBlGiClHiCoJiBeC_xHqqkZx_
// *
//----- 03.07.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FormatResString (DWORD dwId, ...)
{
	va_list argList;
	va_start(argList, dwId);
	WString wstr = FormatResStringV(dwId, argList);
	va_end(argList);
	return wstr;
} // FormatResString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FormatResStringV
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfMiBfLiDfIiCmMjFlGiOjKjHpBiCpAiOoGjDlOiClFiCmEiBeBiDhEiDeIiBfLiDhNiDgCiDgHiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjFlGiOjKjHpBiCmMiDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			argList	:_xZkqqHx_iIpIjAjEiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeCiDiKiDfMiBfLiDfIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_iLpDjFlGiOjK_xHqqkZx_ _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FormatResStringV (DWORD dwId, va_list argList)
{
	WString wstrForm;
	wstrForm.LoadString(dwId);
	WString strMsg;
	strMsg.FormatV(wstrForm.c_str(), argList);
	return strMsg;
} // FormatResStringV.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSkipSpace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCmMjAoGjDkKiCkJiCoHiLpDjEjCiBeBiDfOiDhFiBeBiJpMiNhDiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpStr	:_xZkqqHx_jFlGiOjKjHpBiCmMjAoGjDkKiDhMiDeDiDjDiDfOiCpAjHfOiCkGiCoJiBeCiInKjDkOiMoDiCmMjCgMiCkKjFnEiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSkipSpace (const wchar_t*& wcpStr)
{
	for (;;)
	{
		switch (*wcpStr)
		{
		case L' ':
		case L'\t':
		case L'\r':
		case L'\n':
			wcpStr++;
			break;
		default:
			return;
		}
	}
} // FFSkipSpace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFConvertStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	wchar_t_xZkqqHx_jFlGiOjKjHpBiCpAiBeBiOhHjCoIiCmMiPeJjHlJiDfCiBfLiDgIiCnMiCmFiImIiJlKiCmMiDiLiBfLiDiLiCmFjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *			"\r"	:'\r'_xZkqqHx_jFjMiLeBiDfCiBfLiDgI_xHqqkZx_
 *			"\n"	:'\n'_xZkqqHx_iJpMiNhDiDfCiBfLiDgI_xHqqkZx_
 *			"\t"	:'\t'_xZkqqHx_iDfOiDhFiDfCiBfLiDgI_xHqqkZx_
 *			"\x"	:'x'_xZkqqHx_jCmKiPoNiDfCiBfLiDgIiBgJ_xHqqkZx_x_xZkqqHx_iCmN_xHqqkZx_r,n,t_xZkqqHx_iImIiKePiBgK_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strOut		:_xZkqqHx_jFmPiKlHiMoDjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpStr		:_xZkqqHx_jFmPiKlHjBmOiPnLjFlGiOjKjHpBiCpAiOhHjCoIiBeCjFmPiKlHiCmFiCkLiClNiPoKiPiKiCnMiCmFiInKjDkOiBeC_xHqqkZx_
 *			wcaEndCode	:_xZkqqHx_iPeJjHlJiDfCiBfLiDgIiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEndCodeSz	:wcaEndCode_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDpMjHmNiBeG_xHqqkZx_wcpStr = "ABCD/", wcEndCode = '/' _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_
 *			_xZkqqHx_iPgPjHmNiBeG_xHqqkZx_strOut = "ABCD", wcpStr = "/"
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFConvertStr (	WString& strOut,
					const wchar_t*& wcpStr,
					const wchar_t wcaEndCode[],
					int iEndCodeSz)
{
	strOut.erase();
	// _xZkqqHx_jEpBiDeHiDfIiDfAiBfLiDhGiPpDjBnEiCpAjAnNjCoIiBeC_xHqqkZx_
	BOOL bEsc = FALSE;
	for (;;)
	{
		if (bEsc)
		//----- _xZkqqHx_iDeHiDfIiDfAiBfLiDhGiPpDjBnEiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jEpBiDeHiDfIiDfAiBfLiDhGiPpDjBnEiCmJiBeC_xHqqkZx_
			bEsc = FALSE;
			switch (*wcpStr)
			{
			case L'\0':	// _xZkqqHx_iLpDjFlGiOjKiBeC_xHqqkZx_
				return FALSE;	// _xZkqqHx_iDeHiDiJiBfLiBeC_xHqqkZx_
			case L'r':	// _xZkqqHx_jFjMiLeBiBeC_xHqqkZx_
				strOut += L'\r';
				break;
			case L'n':	// _xZkqqHx_iJpMiNhDiBeC_xHqqkZx_
				strOut += L'\n';
				break;
			case L't':	// _xZkqqHx_iDfOiDhFiBeC_xHqqkZx_
				strOut += L'\t';
				break;
			default:
				strOut += *wcpStr;
			}
		} else
		//----- _xZkqqHx_jEpBiDeHiDfIiDfAiBfLiDhGiPpDjBnEiCmMiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_iPeJjHlJiDfCiBfLiDgIiCmMiMjPiNlI_xHqqkZx_ -----
			for (int iC = 0; iC < iEndCodeSz; iC++)
				if (*wcpStr == wcaEndCode[iC]) return TRUE;

			if (*wcpStr == FDST_CHR_ESC)
			//----- _xZkqqHx_iDeHiDfIiDfAiBfLiDhGjFlGiOjKiCmMiPoKiNiH_xHqqkZx_ -----
			{
				bEsc = TRUE;
			} else
			if (*wcpStr == L'\0')
			//----- _xZkqqHx_iLpDjFlGiOjKiCmMiPoKiNiH_xHqqkZx_ -----
			{
				return FALSE;	// _xZkqqHx_iDeHiDiJiBfLiBeC_xHqqkZx_
			} else
			{
				strOut += *wcpStr;
			}
		}
		// _xZkqqHx_iOjPiCmMjFlGiOjKiCmJiInKjDkOiBeC_xHqqkZx_
		wcpStr++;
	}
	return FALSE;
} // FFConvertStr.

//----- 02.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFLoadString
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfMiBfLiDfIiCkJiCoHjFlGiOjKjHpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFLoadString (WString& wstr, DWORD dwCtrl)
//{
//	WString str;
//	str.LoadString(dwCtrl);
//	wstr = TStrToWStr(str);
//} // FFLoadString.
//----- 02.02.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	wstrBuff_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjFlGiOjKjHpBiDgGiBfLiDfOiCkJiCoHiBeBiCfAiNhDiClOiCkPjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrLine:_xZkqqHx_iJpMiNhDiCmMjClMjBePiCnMiCmFiCmMjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_str _xZkqqHx_iCmNiBeBiJpMiNhDiCnMiCmFiCmMjFlGiOjK_xHqqkZx_
 *					(_xZkqqHx_iJpMiNhDiCpAiKnMiCnO_xHqqkZx_)_xZkqqHx_iCkKiNoNiCoHiCoKiCoJiBeC_xHqqkZx_
 *			wstrBuff:_xZkqqHx_jDmHiCnNiNjOiCnOiDgGiBfLiDfOiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeCiCfAiNhDjDmHiCnNiNjOiCpBiClOjFkKiCmN_xHqqkZx_
 *					 _xZkqqHx_jGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGjGjGiCmJiOiKiCmBiCmEiNhDiCpAjDmHiCnNiNjOiCnPiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL GetLine (WString& wstrLine, WString& wstrBuff)
{
	wstrLine.erase();
	WString::iterator iWcL;
	WString::iterator iWcR;
	for (iWcR = wstrBuff.begin(), iWcL = iWcR; iWcR != wstrBuff.end(); iWcR++)
	{
		if (*iWcR == L'\r')
		{
			continue;
		} else
		if (*iWcR == L'\n')
		{
			iWcR++;
			break;
		} else
		{
			iWcL++;
		}
	}
	wstrLine.append(wstrBuff.begin(), iWcL);
	wstrBuff.erase(wstrBuff.begin(), iWcR);
	return !wstrLine.empty() || !wstrBuff.empty();
} // GetLine.

//----- 06.11.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetCSVTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_CSV_xZkqqHx_iDgFiDeMiDfIiDgHiCkJiCoHiBeBjFlGiOjKjHpBiCmMiDhNiDgHiDiKiDgCiDeOiDfIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vvTextTable	:_xZkqqHx_jFlGiOjKjHpBiDhNiDgHiDiKiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_vvTextTable[_xZkqqHx_iNhD_xHqqkZx_][_xZkqqHx_jHpB_xHqqkZx_]_xZkqqHx_iBeC_xHqqkZx_
 *			wcpText		:CSV_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_NULL_xZkqqHx_iCmNiOhHjCoIiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iNmFjCoBiCmFiCoA_xHqqkZx_1_xZkqqHx_iNhD_xHqqkZx_1_xZkqqHx_jHpBiCmMiDhNiDgHiDiKiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKgFiNhDiCmMjClHiClDiBgJjHpBjAjEiBgKiCmNiNmFjBoFjClHiCmJiNiHiCoNiClJiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetCSVTable (vector<WStringVector>& vvTextTable,
					const wchar_t* wcpText)
{
	if (wcpText == NULL)
		FFThrowMiscUnknown();
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiBeBiDfOiDhFiLoGjAnIiCoIiCmFiDhNiDgHiDiKiDgCiDeOiDfIiPpDiCmMiDgFiDeMiDfIiDgHjEhKjHpBiCmJiNoMiCoIjClMiClHiBeC_xHqqkZx_
	vvTextTable.clear();
	vvTextTable.push_back(WStringVector());
	for (;;)
	{
		WString wstrItem;
		wchar_t wLastChar;
		// CSV_xZkqqHx_iCmMiCfAiDeBiDeDiDgFiDiAiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		if (!FFGetCSVItem(wstrItem, wLastChar, wcpText))
			break;
		vvTextTable.back().push_back(wstrItem);
		// _xZkqqHx_iJpMiNhDiDfCiBfLiDgIiCmFiPeJjHlJiClFiClNiPoKiNiHiCmNiBeBiNhDiCpAjCmHiJmBiBeC_xHqqkZx_
		if (wLastChar == L'\n')
			vvTextTable.push_back(WStringVector());
		else
		if (wLastChar == L'\0')
			break;
		ASSERT(wLastChar == L'\n' || wLastChar == L'\t');
	}
	while (vvTextTable.size() != 1)
	//----- _xZkqqHx_iNmFiMoDiCmMiCfAiNhDiCmJiCmIiCoJiCnMiCmFiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgFiDeMiDfIiDgHjEhKjHpBiCmMiNmFiMoDiCmMiNhDiCkKiLpDiCmMiPoKiNiHiCmNiBeBiNmFiMoDiCmMiNhDiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
		if (vvTextTable.back().size() == 0)
			vvTextTable.pop_back();
		else
		if (vvTextTable.back().size() == 1 &&
			vvTextTable.back().front().IsEmpty())
			vvTextTable.pop_back();
		else
			break;
	}
	// _xZkqqHx_iDgFiDeMiDfIiDgHjEhKjHpBiCmNiNhDiClCiCmGiCmJjHpBjAjEiCkKiInJiCmIiCoJiCmMiCmFiBeBiNmFjBoFiCmMjHpBjAjEiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iNmFiPkMiCmMjHpBjAjEiBiBiCfAiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	long lMaxColumn = 1;
	long lLineIndex;
	for (lLineIndex = 0; lLineIndex != vvTextTable.size(); lLineIndex++)
		if (lMaxColumn < vvTextTable[lLineIndex].size())
			lMaxColumn = vvTextTable[lLineIndex].size();
	// _xZkqqHx_jBfDiCmEiCmMiNhDiCpAiNmFjBoFjHpBjAjEiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
	for (lLineIndex = 0; lLineIndex != vvTextTable.size(); lLineIndex++)
	{
		if (vvTextTable[lLineIndex].size() != lMaxColumn)
			vvTextTable[lLineIndex].resize(lMaxColumn);
	}
} // FFGetCSVTable.
//----- 06.11.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetCSVItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKjHpBiCkJiCoHiBeB_xHqqkZx_Excel_xZkqqHx_iCmM_xHqqkZx_CSV_xZkqqHx_iMgAiOkOiCmMiCfAiNiAjGnKiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstr		:_xZkqqHx_iOoGiCoIiPgPiClDiCoKiClNiDeBiDeDiDgFiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *			wLastChar	:_xZkqqHx_iNmFiMoDiCmJiOoGiCoIiPgPiClDiCoKiClNjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpNext		:CSV_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeCiOjPiCmMiDeBiDeDiDgFiDiAiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iLoGjAnIiCoIjFlGiOjKiCmNiDfOiDhFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	"ABC",ABC,"AB,C",A"B"C,"A""B""C", _xZkqqHx_iCkJiCoHiOoGiCoIiPgPiClDiCoKiCoJiDeBiDeDiDgFiDiAiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iNlGiCkJiCoHiPiHiCmJiBeB_xHqqkZx_ABC/ABC/AB,C/ABC/A"B"C _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFGetCSVItem (	WString& wstr,
					wchar_t& wLastChar,
					const wchar_t*& wcpNext)
{
	struct my
	{
		static wchar_t GetCSVWChar (wchar_t buff[], const wchar_t*& wcpNext)
		{
			buff[0] = *wcpNext;
			wcpNext++;
			switch (buff[0])
			{
			case L'\0':
				wcpNext--;
				return buff[0];
			case L'\r':
				if (*wcpNext == L'\n')
				{
					buff[1] = *wcpNext;
					buff[2] = L'\0';
					wcpNext++;
					return buff[1];
				}
				// *wcpNext != L'\n' _xZkqqHx_iCmN_xHqqkZx_ default _xZkqqHx_iPiIjHjNiBeC_xHqqkZx_
			default:
				buff[1] = L'\0';
				return buff[0];
			}
		}
	};
	enum {
		STATE_NONE = 0,
		STATE_START,
		STATE_BEGIN,
		STATE_ADDING,
		STATE_DQ_BEGIN,
		STATE_DQ_ADDING,
		STATE_DQ_END,
		STATE_ERROR,
		STATE_END,
		STATE_GOAL,
	};
	wchar_t wcsLastStr[3];
	BOOL bIsSucceed = TRUE;
	int iState = STATE_START;
	wstr.Empty();
	while (bIsSucceed)
	{
		switch (iState)
		{
		case STATE_START:		// START.
			break;

		case STATE_BEGIN:
			break;

		case STATE_ADDING:
			wstr += wcsLastStr;
			break;

		case STATE_DQ_BEGIN:
			break;

		case STATE_DQ_ADDING:
			wstr += wcsLastStr;
			break;

		case STATE_DQ_END:
			break;

		case STATE_ERROR:
			bIsSucceed = FALSE;
			break;

		case STATE_END:
			break;
		}

		// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
		int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_

		if (iNextState == STATE_NONE)
		// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
		{
			// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
			switch (iState)
			{
			case STATE_START:		// START.
				iNextState = STATE_BEGIN;
				break;

			case STATE_BEGIN:
				wLastChar = my::GetCSVWChar(wcsLastStr, wcpNext);
				switch (wLastChar)
				{
				case L'\t':
				case L'\n':
				case L'\0':
					iNextState = STATE_END;
					break;
				case L'"':
					iNextState = STATE_DQ_BEGIN;
					break;
				default:
					iNextState = STATE_ADDING;
				}
				break;

			case STATE_ADDING:
				wLastChar = my::GetCSVWChar(wcsLastStr, wcpNext);
				switch (wLastChar)
				{
				case L'\t':
				case L'\n':
				case L'\0':
					iNextState = STATE_END;
					break;
				default:
					iNextState = STATE_ADDING;
				}
				break;

			case STATE_DQ_BEGIN:
				wLastChar = my::GetCSVWChar(wcsLastStr, wcpNext);
				switch (wLastChar)
				{
				case L'"':
					iNextState = STATE_DQ_END;
					break;
				case L'\0':
					iNextState = STATE_ERROR;
					break;
				default:
					iNextState = STATE_DQ_ADDING;
				}
				break;

			case STATE_DQ_ADDING:
				wLastChar = my::GetCSVWChar(wcsLastStr, wcpNext);
				switch (wLastChar)
				{
				case L'"':
					iNextState = STATE_DQ_END;
					break;
				case L'\0':
					iNextState = STATE_ERROR;
					break;
				default:
					iNextState = STATE_DQ_ADDING;
				}
				break;

			case STATE_DQ_END:
				wLastChar = my::GetCSVWChar(wcsLastStr, wcpNext);
				switch (wLastChar)
				{
				case L'"':
					iNextState = STATE_DQ_ADDING;
					break;
				case L'\t':
				case L'\n':
				case L'\0':
					iNextState = STATE_END;
					break;
				default:
					iNextState = STATE_ADDING;
				}
				break;

			case STATE_ERROR:
				iNextState = STATE_GOAL;
				break;

			case STATE_END:
				iNextState = STATE_GOAL;
				break;

			case STATE_GOAL:
				iNextState = STATE_NONE;
				break;
			}
		}

		if (iNextState == STATE_NONE) break;
		iState = iNextState;
	}
	return bIsSucceed;
} // FFGetCSVItem.

//----- 02.02.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	swprintf
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	swprintf_xZkqqHx_iCmM_xHqqkZx_WString_xZkqqHx_jEmFiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void swprintf (WString& str, const wchar_t* wcpForm, ...)
//{
//	va_list argList;
//	va_start(argList, wcpForm);
//
//	int iCount = -1;
//	for (size_t nnn = 1000; iCount == -1; nnn *= 2)
//	{
//		str.resize(nnn);
//		iCount = _vsnwprintf(str.begin(), nnn - 1, wcpForm, argList);
//	}
//	str.resize(iCount);
//	va_end(argList);
//} // swprintf.
//----- 02.02.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCompressLZ77
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgGiBfLiDfOiCpA_xHqqkZx_LZ77_xZkqqHx_iIlDiPgLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vCompressBuff	:_xZkqqHx_iIlDiPgLiClFiClNiDgGiBfLiDfOiCpAjCmHiJmBiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			pRawData		:_xZkqqHx_iIlDiPgLjBePiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwRawDataSize	:_xZkqqHx_iIlDiPgLjBePiCmMiDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	vCompressBuff_xZkqqHx_iCmJiKpJiCmJjDpMiCmBiCmEiCkCiCoJiDgGiBfLiDfOiCmMiMoDiCoLiCmJjCmHiJmBiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCompressLZ77 (BYTEVector& vCompressBuff,
					const BYTE* pRawData,
					DWORD dwRawDataSize)
{
//----- 06.03.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iPgPjHmNiDfEiDeDiDfJiCmNiNmFjCoBiCmFiCoA_xHqqkZx_ 0.1%_xZkqqHx_jBjN_xHqqkZx_ + 12byte_xZkqqHx_iBeC_xHqqkZx_
//	DWORD dwCompressSize = (DWORD)(dwRawDataSize * 1.001) + 12;
//	vCompressBuff.resize(dwCompressSize);
//	for (;;)
//	{
//		// LZ77_xZkqqHx_iIlDiPgLiPiIjHjNiBeC_xHqqkZx_
//		int iRet = ::compress2(vCompressBuff.begin(), &dwCompressSize,
//								pRawData, dwRawDataSize, Z_DEFAULT_COMPRESSION);
//		// _xZkqqHx_jAlDiPoNiCmJiIlDiPgLiCmFiCkLiClNiPoKiNiHiBeC_xHqqkZx_
//		if (iRet == Z_OK) break;
//		if (iRet != Z_BUF_ERROR)
//		//----- _xZkqqHx_iDgPiDgCiDhEiDeAjFhDjBkLiImIiKePiCmMiDeHiDiJiBfLiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDgGiBfLiDfOiIlDiPgLjCiGiCmJiDeHiDiJiBfL_xHqqkZx_ %d _xZkqqHx_iCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_
//			FFThrowMiscException(IDS_ERR_MSG_COMPRESS, iRet);
//		} else
//		//----- _xZkqqHx_iDgPiDgCiDhEiDeAjFhDjBkLiCmMiDeHiDiJiBfLiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAiCfAiBeEiCfEjEhLiBeC_xHqqkZx_
//			vCompressBuff.resize(vCompressBuff.size() * 1.5);
//			dwCompressSize = vCompressBuff.size();
//		}
//	}
//	vCompressBuff.resize(dwCompressSize);
//----- 06.03.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDhIiDfIiDgHiDfIiDhDiBfLiDgIiCmFiIlDiPgLiBeC_xHqqkZx_Z_DEFAULT_COMPRESSION_xZkqqHx_iBgJiBiBiCfFiBgKiCmF_xHqqkZx_
	// _xZkqqHx_iIlDiPgLiClFiCmEiCkCiClNiCkKiBeBjBoFiCkLiCmIiDgGiBfLiDfOiCpAiIlFiCkEiCmGjChIiCkNiCmEiCmHiCkEiClFiCoGiCkEiCoAiCmIiCkCiBeC_xHqqkZx_
	int iRet = FFZlibCompress2(vCompressBuff, pRawData, dwRawDataSize, Z_BEST_SPEED);
	if (iRet != Z_OK)
	//----- _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgGiBfLiDfOiIlDiPgLjCiGiCmJiDeHiDiJiBfL_xHqqkZx_ %d _xZkqqHx_iCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_
		FFThrowMiscException(IDS_ERR_MSG_COMPRESS, iRet);
	}
//----- 06.03.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFCompressLZ77.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFUncompressLZ77
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ77_xZkqqHx_iIlDiPgLiClDiCoKiClNiDgGiBfLiDfOiCpAiJpAjDiAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bypRawDataBuff	:_xZkqqHx_iJpAjDiAiMoDiCmMiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *			dwRawDataSize	:bypRawDataBuff_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJpAjDiAiMoDiCmMiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *			bypCompressData	:_xZkqqHx_iIlDiPgLiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCompressSize	:_xZkqqHx_iIlDiPgLiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFUncompressLZ77 (	BYTE* bypRawDataBuff,
						DWORD& dwRawDataSize,
						const BYTE* bypCompressData,
						DWORD dwCompressSize)
{
	int iRet = ::uncompress(bypRawDataBuff, &dwRawDataSize,
							bypCompressData, dwCompressSize);
	if (iRet != Z_OK)
	{
		// _xZkqqHx_iDgGiBfLiDfOjAeMjCkDjCiGiCmJiDeHiDiJiBfL_xHqqkZx_ %d _xZkqqHx_iCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_
		FFThrowMiscException(IDS_ERR_MSG_UNCOMPRESS, iRet);
	}
} // FFUncompressLZ77.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFWriteLZ77DataBlock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ77_xZkqqHx_iDgGiBfLiDfOiDhFiDiNiDgCiDeOiBgJ_xHqqkZx_LZ77_xZkqqHx_iMgAiOkOiCmFiIlDiPgLiClDiCoKiClNiDgGiBfLiDfOiCmMiDhFiDiNiDgCiDeOiBgK_xHqqkZx_
 *			_xZkqqHx_iCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vDataBuff		:LZ77_xZkqqHx_iDgGiBfLiDfOiDhFiDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *			pRawData		:_xZkqqHx_iIlDiPgLjBePiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwRawDataSize	:_xZkqqHx_iIlDiPgLjBePiCmMiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	vDataBuff_xZkqqHx_iCmNiBeBiKpJiCmJjDpMiCmBiCmEiCkCiCoJiDgGiBfLiDfOiCmNiClLiCmMiCnMiCnMiCmJiBeBiPeJjCfLiCmJ_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOiCkKjCmHiJmBiClDiCoKiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	LZ77_xZkqqHx_iDgGiBfLiDfOiDhFiDiNiDgCiDeOiCmMiMgAiOkOiCmNiImIiJlKiBeC_xHqqkZx_
 *
 *	_xZkqqHx_iEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEkG_xHqqkZx_
 *	_xZkqqHx_iEkA_xHqqkZx_ 1 Byte _xZkqqHx_iEkA_xHqqkZx_      4 Byte      _xZkqqHx_iEkA_xHqqkZx_  n Byte  _xZkqqHx_iEkA_xHqqkZx_
 *	_xZkqqHx_iEkJiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *	_xZkqqHx_iEkAiIlDiPgLjFpLjGeAiEkAiJpAjDiAiMoDiDgGiBfLiDfOiDfEiDeDiDfJiEkAiIlDiPgLiDgGiBfLiDfOiEkA_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFWriteLZ77DataBlock (	BYTEVector& vDataBuff,
							const BYTE* pRawData,
							DWORD dwRawDataSize)
{
//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgGiBfLiDfOiCpAiIlDiPgLiBeC_xHqqkZx_
//	BYTEVector vCompressBuff;
//	FFCompressLZ77(vCompressBuff, pRawData, dwRawDataSize);
//	// LZ77_xZkqqHx_iIlDiPgLjFpLjGeAiCpAiPgPjHmNiBeC_xHqqkZx_
//	vDataBuff << (BYTE)FD_COMPRESS_LZ77;
//	// _xZkqqHx_jEpBiIlDiPgLiDgGiBfLiDfOiDfEiDeDiDfJiCpAiPgPjHmNiBeC_xHqqkZx_
//	vDataBuff << dwRawDataSize;
//	// _xZkqqHx_iIlDiPgLiClFiClNiDeBiBfLiDeKiDeDiDhFiCpAiPgPjHmNiBeC_xHqqkZx_
//	FFWriteStream(vDataBuff, vCompressBuff.begin(), vCompressBuff.size());
//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// LZ77_xZkqqHx_iIlDiPgLjFpLjGeAiCpAiPgPjHmNiBeC_xHqqkZx_
	vDataBuff << (BYTE)FD_COMPRESS_LZ77;
	// _xZkqqHx_jEpBiIlDiPgLiDgGiBfLiDfOiDfEiDeDiDfJiCpAiPgPjHmNiBeC_xHqqkZx_
	vDataBuff << dwRawDataSize;
	// _xZkqqHx_iDgGiBfLiDfOiCpAiIlDiPgLiBeC_xHqqkZx_
	FFCompressLZ77(vDataBuff, pRawData, dwRawDataSize);
//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFWriteLZ77DataBlock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFReadLZ77DataBlock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ77_xZkqqHx_iDgGiBfLiDfOiDhFiDiNiDgCiDeOiBgJ_xHqqkZx_LZ77_xZkqqHx_iMgAiOkOiCmFiIlDiPgLiClDiCoKiClNiDgGiBfLiDfOiCmMiDhFiDiNiDgCiDeOiBgK_xHqqkZx_
 *			_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vRawDataBuff	:_xZkqqHx_iJpAjDiAiMoDiCmMiDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJpAjDiAiMoDiCmMiDgGiBfLiDfOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			pDataBlock		:LZ77_xZkqqHx_iDgGiBfLiDfOiDhFiDiNiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwDataBlockSize	:LZ77_xZkqqHx_iDgGiBfLiDfOiDhFiDiNiDgCiDeOiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	vRawDataBuff _xZkqqHx_iCmNiJlNjDhIiCoAiNmEjHjIjHhAiClHiCoJiCmMiCmFiBeB_xHqqkZx_clear()_xZkqqHx_iCmIiCmHiCkJiCkPiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
 *			_xZkqqHx_iCmIiCoJiCnHiCkNiDiBiDiCiDiKiBfLiDfEiDeDiDfJiCkKjFmPiCoNiCoHiCmIiCkCiCoGiCkEiCmJjCiNiInDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	LZ77_xZkqqHx_iDgGiBfLiDfOiDhFiDiNiDgCiDeOiCmMiMgAiOkOiCmNiImIiJlKiBeC_xHqqkZx_
 *
 *	_xZkqqHx_iEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEkG_xHqqkZx_
 *	_xZkqqHx_iEkA_xHqqkZx_ 1 Byte _xZkqqHx_iEkA_xHqqkZx_      4 Byte      _xZkqqHx_iEkA_xHqqkZx_  n Byte  _xZkqqHx_iEkA_xHqqkZx_
 *	_xZkqqHx_iEkJiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *	_xZkqqHx_iEkAiIlDiPgLjFpLjGeAiEkAiJpAjDiAiMoDiDgGiBfLiDfOiDfEiDeDiDfJiEkAiIlDiPgLiDgGiBfLiDfOiEkA_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFReadLZ77DataBlock (	BYTEVector& vRawDataBuff,
							const BYTE* pDataBlock,
							DWORD dwDataBlockSize)
{
	// _xZkqqHx_iIlDiPgLjFpLjGeAiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	BYTE byCompressMethod;
	FFReadData(byCompressMethod, pDataBlock);
	if (byCompressMethod != FD_COMPRESS_LZ77)
		FFThrowDDFileException(IDS_ERR_FILE_WRONG_VERSION, L"");
	// _xZkqqHx_iJpAjDiAiMoDiDgGiBfLiDfOiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
	DWORD dwRawDataSize;
	FFReadData(dwRawDataSize, pDataBlock);
	// _xZkqqHx_jEpBiIlDiPgLiDgGiBfLiDfOiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	vRawDataBuff.resize(dwRawDataSize);
	// _xZkqqHx_iIlDiPgLiDgGiBfLiDfOiCpAiJpAjDiAiClHiCoJiBeC_xHqqkZx_
	FFUncompressLZ77(&vRawDataBuff.front(), dwRawDataSize,
					 pDataBlock, dwDataBlockSize);
} // FFReadLZ77DataBlock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGuidToString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GUID_xZkqqHx_iCkJiCoH_xHqqkZx_GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCpAjAlGjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstr1	:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCfAiCpAjFnEiClHiBeC_xHqqkZx_
 *			wstr2	:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCfBiCpAjFnEiClHiBeC_xHqqkZx_
 *			wstr3	:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCfCiCpAjFnEiClHiBeC_xHqqkZx_
 *			wstr4	:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCfDiCpAjFnEiClHiBeC_xHqqkZx_
 *			wstr5	:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCfEiCpAjFnEiClHiBeC_xHqqkZx_
 *			guid	:GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGuidToString (WString& wstr1, WString& wstr2, WString& wstr3,
					WString& wstr4, WString& wstr5, const GUID& guid)
{
	wstr1.Format(L"%08lX", guid.Data1);
	wstr2.Format(L"%04X", guid.Data2);
	wstr3.Format(L"%04X", guid.Data3);
	wstr4.Format(L"%02X%02X", guid.Data4[0], guid.Data4[1]);
	wstr5.Format(L"%02X%02X%02X%02X%02X%02X",
				guid.Data4[2], guid.Data4[3], guid.Data4[4],
				guid.Data4[5], guid.Data4[6], guid.Data4[7]);
} // FFGuidToString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFStringToGuid
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCkJiCoH_xHqqkZx_GUID_xZkqqHx_iCpAjAlGjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid	:GUID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			wcp1	:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCfAiCpAiOhHjCoIiBeCiCfHiMiFiCmM_xHqqkZx_16_xZkqqHx_jAgJjAjEjFlGiOjKjHpBiBeC_xHqqkZx_
 *			wcp2	:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCfBiCpAiOhHjCoIiBeCiCfDiMiFiCmM_xHqqkZx_16_xZkqqHx_jAgJjAjEjFlGiOjKjHpBiBeC_xHqqkZx_
 *			wcp3	:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCfCiCpAiOhHjCoIiBeCiCfDiMiFiCmM_xHqqkZx_16_xZkqqHx_jAgJjAjEjFlGiOjKjHpBiBeC_xHqqkZx_
 *			wcp4	:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCfDiCpAiOhHjCoIiBeCiCfDiMiFiCmM_xHqqkZx_16_xZkqqHx_jAgJjAjEjFlGiOjKjHpBiBeC_xHqqkZx_
 *			wcp5	:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCfEiCpAiOhHjCoIiBeCiCfAiCfBiMiFiCmM_xHqqkZx_16_xZkqqHx_jAgJjAjEjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiClFiCkNjFmPiKlHiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeCjFlGiOjKjHpBiCkKiKnEiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFStringToGuid (GUID& guid, const wchar_t* wcp1, const wchar_t* wcp2,
					const wchar_t* wcp3, const wchar_t* wcp4, const wchar_t* wcp5)
{
	int iC;
	const WString wstr1 = wcp1;
	if (wstr1.GetLength() != 8) return FALSE;
	for (iC = 0; iC < wstr1.GetLength(); iC++)
		if (iswxdigit(wstr1.GetAt(iC)) == 0) return FALSE;
	const WString wstr2 = wcp2;
	if (wstr2.GetLength() != 4) return FALSE;
	for (iC = 0; iC < wstr2.GetLength(); iC++)
		if (iswxdigit(wstr2.GetAt(iC)) == 0) return FALSE;
	const WString wstr3 = wcp3;
	if (wstr3.GetLength() != 4) return FALSE;
	for (iC = 0; iC < wstr3.GetLength(); iC++)
		if (iswxdigit(wstr3.GetAt(iC)) == 0) return FALSE;
	const WString wstr4 = wcp4;
	if (wstr4.GetLength() != 4) return FALSE;
	for (iC = 0; iC < wstr4.GetLength(); iC++)
		if (iswxdigit(wstr4.GetAt(iC)) == 0) return FALSE;
	const WString wstr5 = wcp5;
	if (wstr5.GetLength() != 12) return FALSE;
	for (iC = 0; iC < wstr5.GetLength(); iC++)
		if (iswxdigit(wstr5.GetAt(iC)) == 0) return FALSE;

	guid.Data1 = wcstoul(wcp1, NULL, 16);
	guid.Data2 = wcstoul(wcp2, NULL, 16);
	guid.Data3 = wcstoul(wcp3, NULL, 16);
	WString wstr45 = wcp4;
	wstr45 += wcp5;
	for (iC = 0; iC < sizeof(guid.Data4) / sizeof(guid.Data4[0]); iC++)
	{
		WString wstrTmp;
		wstrTmp += wstr45.GetAt(iC * 2);
		wstrTmp += wstr45.GetAt(iC * 2 + 1);
		guid.Data4[iC] = wcstoul(wstrTmp, NULL, 16);
	}
	return TRUE;
} // FFStringToGuid.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGuidToString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GUID_xZkqqHx_iCkJiCoH_xHqqkZx_GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCpAjAlGjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid	:GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	GUID_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGuidToString (const GUID& guid)
{
	WString wstr;
	wstr.Format(L"%08lX-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X",
				guid.Data1, guid.Data2, guid.Data3,
				guid.Data4[0], guid.Data4[1], guid.Data4[2], guid.Data4[3],
				guid.Data4[4], guid.Data4[5], guid.Data4[6], guid.Data4[7]);
	return wstr;
} // FFGuidToString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFStringToGuid
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCkJiCoH_xHqqkZx_GUID_xZkqqHx_iCpAjAlGjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpGuid		:GUID_xZkqqHx_iCmMjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iNmFiMoDiCmJiDgAiDeGiDgCiDeOiDfCiBfLiDgIiCkKjFhEiCkCiCmEiCkCiCmEiCoA_xHqqkZx_OK_xZkqqHx_iBeC_xHqqkZx_
 *			wcpGuidNext	:GUID_xZkqqHx_jFlGiOjKjHpBiCmMiOjPiCnGiInKjDkOiClFiCmEjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	GUID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID FFStringToGuid (const wchar_t* wcpGuid, const wchar_t** wcpGuidNext)
{
	WString wstrGuid = wcpGuid;
	WString wstr1 = FFExtractUntil(wstrGuid, L'-');
	WString wstr2 = FFExtractUntil(wstrGuid, L'-');
	WString wstr3 = FFExtractUntil(wstrGuid, L'-');
	WString wstr4 = FFExtractUntil(wstrGuid, L'-');
	WString wstr5 = FFExtractUntil(wstrGuid, L"- \t\r\n");
	// GUID_xZkqqHx_iCmJiOgHiCoNiCoKiClNjFlGiOjKjAjEiClOiCkPiDhMiDeDiDjDiDfOiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
	if (wcpGuidNext != NULL)
		*wcpGuidNext = wcpGuid +
						wstr1.GetLength() + 1 +
						wstr2.GetLength() + 1 +
						wstr3.GetLength() + 1 +
						wstr4.GetLength() + 1 +
						wstr5.GetLength();
	GUID guid = GUID_NULL;
	FFStringToGuid(guid, wstr1, wstr2, wstr3, wstr4, wstr5);
	return guid;
} // FFStringToGuid.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGuidToExString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GUID_xZkqqHx_iCkJiCoH_xHqqkZx_GUID+CRC_xZkqqHx_iCmMjFlGiOjKjHpBiCpAjAlGjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid	:GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	GUID+CRC_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiBeG_xHqqkZx_3BDB4215-40A0-4CB8-9F68-8E063B645135-C261
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGuidToExString (const GUID& guid)
{
	if (guid == GUID_NULL)
		return WString();
	else
		return FFFormatString(	L"%s-%04X",
								FFGuidToString(guid).c_str(),
								FFGetGuidCheckCode(guid));
} // FFGuidToExString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetFormedUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiBfLiPoOjFpBiCpAiMgAiOkOiJlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfFiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpUserName	:_xZkqqHx_iDiGiBfLiDfFiBfLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiBfLiPoOjFpBjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiBeG_xHqqkZx_Fukushiro Masayuki (3BDB4215-40A0-4CB8-9F68-8E063B645135-C261)
 *				guest
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetFormedUserId (const GUID& guidUserId, const wchar_t* wcpUserName)
{
	if (guidUserId == GUID_NULL)
	//----- GUEST_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		return FFLoadWString(IDS_GUEST);
	} else
	//----- GUEST_xZkqqHx_iImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		return FFFormatString(	L"%s (%s-%04X)",
								wcpUserName,
								FFGuidToString(guidUserId).c_str(),
								FFGetGuidCheckCode(guidUserId));
	}
} // FFGetFormedUserId.

