#ifndef __UtilStr_h
#define __UtilStr_h

//;----- <EXPORT TO SDK> -----;
typedef vector< pair<long, long> > longlongVector;
enum FDRegFontType;

// _xZkqqHx_jFlGiOjKiCmMiOoNjHnOiBeC_xHqqkZx_
enum FDCharKind
{
	FDCK_ANSI_BEGIN,	// _xZkqqHx_iClBiCoKiCoGiCoIiJlKiBgJiImIiPoDiCmMjCgMiBgKiCmN_xHqqkZx_ANSI_xZkqqHx_iLeMiNiGiBeC_xHqqkZx_
	FDCK_ANSI_MARK,		// _xZkqqHx_iLeMiNiG_xHqqkZx_.20-2f 3a-40 5b-60 7b-7e
	FDCK_ANSI_NUMBER,	// _xZkqqHx_jAjEiOjK_xHqqkZx_.30-39
	FDCK_ANSI_ALPHABET,	// _xZkqqHx_iDeBiDiLiDhEiDeAiDhIiDgCiDgH_xHqqkZx_.41-5a 61-7a
	FDCK_ANSI_ETC,		// _xZkqqHx_iClLiCmMjBlM_xHqqkZx_.
	FDCK_ANSI_END,		// _xZkqqHx_iClBiCoKiCoGiCoIiPoDiBgJiImIiJlKiCmMjCgMiBgKiCmN_xHqqkZx_ANSI_xZkqqHx_iLeMiNiGiBeC_xHqqkZx_
	FDCK_ZENK_BEGIN,	// _xZkqqHx_iClBiCoKiCoGiCoIiJlKiBgJiImIiPoDiCmMjCgMiBgKiCmNjBfDiKhAiLeMiNiGiBeC_xHqqkZx_
	FDCK_ZENK_ALPHABET,	// _xZkqqHx_jBfDiKhAiDeBiDiLiDhEiDeAiDhIiDgCiDgHiBeC_xHqqkZx_
	FDCK_ZENK_END,		// _xZkqqHx_iClBiCoKiCoGiCoIiPoDiBgJiImIiJlKiCmMjCgMiBgKiCmNjBfDiKhAiLeMiNiGiBeC_xHqqkZx_
	FDCK_OTHER_BEGIN,	// _xZkqqHx_iClBiCoKiCoGiCoIiJlKiCmNiClLiCmMjBlMiCmMiDfCiBfLiDgIiBeC_xHqqkZx_
};
//;------ </EXPORT TO SDK> -----;

// _xZkqqHx_jDmBiOoKjFlGiOjKiBeC_xHqqkZx_ESC_xZkqqHx_iDfCiBfLiDgIiBeC_xHqqkZx_
const wchar_t FDST_CHR_ESC = L'\\';

extern WORD CharSetToCodePage (BYTE byCharSet);
extern wchar_t GetWChar (const _TCHAR*& pStrNext, const _TCHAR* pStr, WORD wCodePage);

#if defined(_MBCS)
// _xZkqqHx_iDfOiDeDiMoKiCmIiCmHiCmFiBeBjFlGiOjKjFjNiCkKjAlDiClFiCkNiOfKiPgPiClDiCoKiCoJiCoGiCkEiBeB_xHqqkZx_wCodePage_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
extern char* GetAChar (char szBuff[], long& lStrLen, wchar_t wChar, WORD wCodePage);
#endif//_MBCS

// _xZkqqHx_iDfOiDeDiMoKiCmIiCmHiCmFiBeBjFlGiOjKjFjNiCkKjAlDiClFiCkNiOfKiPgPiClDiCoKiCoJiCoGiCkEiBeB_xHqqkZx_wCodePage_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
extern wchar_t CodeToWChar (WORD wCode, WORD wCodePage);
// _xZkqqHx_iDfOiDeDiMoKiCmIiCmHiCmFiBeBjFlGiOjKjFjNiCkKjAlDiClFiCkNiOfKiPgPiClDiCoKiCoJiCoGiCkEiBeB_xHqqkZx_wCodePage_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
extern BOOL WCharToCode (wchar_t& wChar, WORD wCodePage);

//----- 06.05.21 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// _xZkqqHx_jFlGiOjKiDfCiBfLiDgIiCkJiCoHjFlGiOjKiCmMiOoNjHnOiCpAjFnEiClHiBeC_xHqqkZx_
extern FDCharKind FFGetCharKind (wchar_t wChar);
// _xZkqqHx_iJhAjFlGiDiPiBfLiDgIiDiJiDgCiDhGiBeC_xHqqkZx_
extern BOOL FFIsWrapedWordE (long& lNewCount, const wchar_t* wcpString, long lStringLen, long lCharCount);
// _xZkqqHx_jDpKjGhLiMoKjFlGiDiPiBfLiDgIiDiJiDgCiDhGiBeC_xHqqkZx_
extern BOOL FFIsWrapedWordJ (long& lNewCount, const wchar_t* wcpString, long lStringLen, long lCharCount);
//----- 06.05.21 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iDfOiDeDiMoKiCmIiCmHiCmFiBeBjFlGiOjKjFjNiCkKjAlDiClFiCkNiOfKiPgPiClDiCoKiCoJiCoGiCkEiBeB_xHqqkZx_wCodePage_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
extern long FFCalcCharCount (	long& pxTextWidth,
								CDC* pDC,
								const wchar_t* wcpStr,
								long pxWidthLimit,
								WORD wCodePage,
								BOOL bIsWordWrapE,
								BOOL bIsWordWrapJ);

//----- 04.05.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAiBeBiOhHjCoIiClDiCoKiClNiJkBjFjNiCmJiOpLiCnMiCoJiCoGiCkEiCmJjFkKiKiEiClHiCoJiBeC_xHqqkZx_
extern long FFCalcTextLines (	WStringVector& vText,
								CDC* pDC,
								const wchar_t* wcpText,
								long pxWidthLimit,
								WORD wCodePage,
								BOOL bIsWordWrapE,
								BOOL bIsWordWrapJ);
// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAiBeBiOhHjCoIiClDiCoKiClNiJkBjFjNiCmJiOpLiCnMiCoJiCoGiCkEiCmJjFkKiKiEiClHiCoJiBeC_xHqqkZx_
extern long FFCalcTextLines (	longlongVector& vCountLength,
								CDC* pDC,
								const wchar_t* wcpText,
								long pxWidthLimit,
								WORD wCodePage,
								BOOL bIsWordWrapE,
								BOOL bIsWordWrapJ);

// _xZkqqHx_iOhHjCoIiClDiCoKiClNjFjNiCpAiPoDiMmAiCmGiClHiCoJiBeBiDgFiDeMiDfIiDgHjBfDjBmMiCmMjFjNiCmGiNiCiClDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
extern void FFCalcTextFrame (	long& pxWidth,
								long& pxHeight,
								WStringVector& vText,
								long pxWidthLimit,
								CDC* pDC,
								const wchar_t* wcpText,
								long pxLineHeight,
								long pxLineGap,
								WORD wCodePage,
								BOOL bIsWordWrapE,
								BOOL bIsWordWrapJ);

// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiDeMiDfIiDgHiCkKiOpLiCnMiCoJiDhLiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
extern void FFCalcTextBox (	mmetol& mmBoxWidth,
							mmetol& mmBoxHeight,
							mmetol& mmTextHeight,
							WStringVector& vText,
							double dMaxWidthPerHeight,
							double dStdWidthPerHeight,
							FDRegFontType fontType,
							const wchar_t* wcpText,
							mmetol mmLineGap,
							WORD wCodePage,
							BOOL bIsWordWrapE,
							BOOL bIsWordWrapJ);

// _xZkqqHx_jFlGiOjKjHpBiCpAiCmCiCmIiCkCiCmFiIoKiCmCiCmMjFlGiOjKjHpBiCmJiClHiCoJiBeC_xHqqkZx_
extern void FFAppendString (WString& str, const wchar_t* wcpStr);
// _xZkqqHx_iCmCiCmIiCkCiClOjFlGiOjKjHpBiCkJiCoHiIoKiCmCiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
extern WString FFExtractString (WString& str);
// _xZkqqHx_jFlGiOjKjHpBiCpAjAoGjDkKiCmJjBhNjDpMiClFiCmEiIoKiCmCiCmMjFlGiOjKjHpBiCmJiClHiCoJiBeC_xHqqkZx_
extern void FFInsTopString (WString& str, const wchar_t* wcpStr);

// _xZkqqHx_jFlGiOjKjHpBiCkJiCoHiOhHjCoIiCmMjFlGiOjKiCmFiLoGjAnIiCoHiCoKiCoJjAoGjDkKiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
extern WString FFExtractUntil (WString& str, wchar_t wc);
extern WString FFExtractUntil (WString& str, const wchar_t* wcp);

// _xZkqqHx_jFlGiOjKjHpBiCkJiCoH_xHqqkZx_c_xZkqqHx_iCmFiLoGjAnIiCoHiCoKiCoJjAoGjDkKiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
extern astring FFExtractUntil (astring& str, char c);
extern astring FFExtractUntil (astring& str, const char* cp);
extern astring GetLine (astring& str, long& lLineCount);

// _xZkqqHx_jFlGiOjKjHpBiNlGiCmMiLpDjEjCiBeFiJpMiNhDiCpAiNoNiPjMiBeC_xHqqkZx_
extern void TrimLeft (astring& str);
// _xZkqqHx_jFlGiOjKjHpBiJeFiCmMiLpDjEjCiBeFiJpMiNhDiCpAiNoNiPjMiBeC_xHqqkZx_
extern void TrimRight (astring& str);

// _xZkqqHx_iDiKiDfMiBfLiDfIiCmMjFlGiOjKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
//----------<NOT EXPORT TO SDK>-----------
// CString _xZkqqHx_iCmN_xHqqkZx_SDK_xZkqqHx_iCmFiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
extern CString FFLoadString (DWORD dwId);
//----------</NOT EXPORT TO SDK>-----------
extern WString FFLoadWString (DWORD dwId);

//----------<NOT EXPORT TO VIEWER>-----------
extern const wchar_t* GetResWString (DWORD dwId);
//----------</NOT EXPORT TO VIEWER>-----------
extern WString FFFormatString (const wchar_t* wcpFormat, ...);
extern WString FFFormatStringV (const wchar_t* wcpFormat, va_list argList);
extern WString FormatResString (DWORD dwId, ...);
extern WString FormatResStringV (DWORD dwId, va_list argList);

// wchar_t_xZkqqHx_iCmMiLpDjEjCiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
extern void FFSkipSpace (const wchar_t*& wcpStr);
extern BOOL FFConvertStr (	WString& strOut,
							const wchar_t*& wcpStr,
							const wchar_t wcaEndCode[],
							int iEndCodeSz);

//extern void FFLoadString (WString& wstr, DWORD dwCtrl);

extern BOOL GetLine (WString& wstrLine, WString& wstrBuff);

//----- 06.11.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
extern void FFGetCSVTable (	vector<WStringVector>& vvTextTable,
							const wchar_t* wcpText);
//----- 06.11.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

extern BOOL FFGetCSVItem (	WString& wstr,
							wchar_t& wLastChar,
							const wchar_t*& wcpNext);

extern void FFCompressLZ77 (BYTEVector& vCompressBuff,
							const BYTE* pRawData,
							DWORD dwRawDataSize);
extern void FFUncompressLZ77 (BYTE* bypRawDataBuff,
							DWORD& dwRawDataSize,
							const BYTE* bypCompressData,
							DWORD dwCompressSize);
extern void FFWriteLZ77DataBlock (BYTEVector& vDataBuff,
									const BYTE* pRawData,
									DWORD dwRawDataSize);
extern void FFReadLZ77DataBlock (BYTEVector& vRawDataBuff,
								const BYTE* pDataBlock,
								DWORD dwDataBlockSize);

extern void FFGuidToString (WString& wstr1, WString& wstr2, WString& wstr3,
							WString& wstr4, WString& wstr5, const GUID& guid);
extern BOOL FFStringToGuid (GUID& guid, const wchar_t* wcp1, const wchar_t* wcp2,
							const wchar_t* wcp3, const wchar_t* wcp4, const wchar_t* wcp5);
extern WString FFGuidToString (const GUID& guid);
extern GUID FFStringToGuid (const wchar_t* wcpGuid, const wchar_t** wcpGuidNext = NULL);
extern WString FFGuidToExString (const GUID& guid);
extern WString FFGetFormedUserId (const GUID& guidUserId, const wchar_t* wcpUserName);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	StrNewCpy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpAjAfGiClFiCkCjHmMiIoGiCnGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pStr	:_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkCjHmMiIoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_tcsdup_xZkqqHx_iCmNjHmMiIoGiKgNjFnLiCmJ_xHqqkZx_malloc_xZkqqHx_iCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_new_xZkqqHx_iCpAiOgHiCkEjGhLiKnGjAjEiCpAjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline char* StrNewCpy (const char* pStr)
{
	char* pNew = new char[strlen(pStr) + 1];
	strcpy(pNew, pStr);
	return pNew;
} // StrNewCpy.

//;----- <EXPORT TO SERVER> -----;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	StrNewCpy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpAjAfGiClFiCkCjHmMiIoGiCnGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pStr	:_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkCjHmMiIoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	wcsdup_xZkqqHx_iCmNjHmMiIoGiKgNjFnLiCmJ_xHqqkZx_malloc_xZkqqHx_iCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_new_xZkqqHx_iCpAiOgHiCkEjGhLiKnGjAjEiCpAjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline wchar_t* StrNewCpy (const wchar_t* pStr)
{
	wchar_t* pNew = new wchar_t[wcslen(pStr) + 1];
	wcscpy(pNew, pStr);
	return pNew;
} // StrNewCpy.

//;----- </EXPORT TO SERVER> -----;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	StrNewNCpy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKjAjEiCmMjFlGiOjKjHpBiCpAjAfGiClFiCkCjHmMiIoGiCnGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pStr	:_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *			iLen	:_xZkqqHx_jFlGiOjKjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkCjHmMiIoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_tcsdup_xZkqqHx_iCmNjHmMiIoGiKgNjFnLiCmJ_xHqqkZx_malloc_xZkqqHx_iCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_new_xZkqqHx_iCpAiOgHiCkEjGhLiKnGjAjEiCpAjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline wchar_t* StrNewNCpy (const wchar_t* pStr, int iLen)
{
	wchar_t* pNew = new wchar_t[iLen + 1];
	wcsncpy(pNew, pStr, iLen);
	pNew[iLen] = L'\0';
	return pNew;
} // StrNewNCpy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	StrNewNCpy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKjAjEiCmMjFlGiOjKjHpBiCpAjAfGiClFiCkCjHmMiIoGiCnGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pStr	:_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *			iLen	:_xZkqqHx_jFlGiOjKjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkCjHmMiIoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_tcsdup_xZkqqHx_iCmNjHmMiIoGiKgNjFnLiCmJ_xHqqkZx_malloc_xZkqqHx_iCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_new_xZkqqHx_iCpAiOgHiCkEjGhLiKnGjAjEiCpAjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline char* StrNewNCpy (const char* pStr, int iLen)
{
	char* pNew = new char[iLen + 1];
	strncpy(pNew, pStr, iLen);
	pNew[iLen] = '\0';
	return pNew;
} // StrNewNCpy.

#endif//__UtilStr_h

