#ifndef __UtilVersion_h
#define __UtilVersion_h

class FCUndoArchive;

//;----- <EXPORT TO SDK> -----;

const int FD_MAX_APP_NAME = 20;	// _xZkqqHx_iDeBiDhGiDiKjGlMiCmMiNmFjBoFjCgMiBeCiClBiCoKiImIiPoDiCmMjGlMjBePiCmNiJnPiLiOiCmJiCmIiCkCiBeC_xHqqkZx_

enum {
	FDPL_WINDOWS = 0,
};

// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
#define FD_APP_MAJOR_VER	WORD(4)				// [0 - 31]
#define FD_APP_MINOR_VER	WORD(1)				// [0 - 31]
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//#define FD_APP_LEVEL_A		char('B')			// [A - P]
//#define FD_APP_LEVEL_B		char('1')			// [1 - 4]
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
#define FD_APP_LEVEL_A		char('K')			// [K - Z]
#define FD_APP_LEVEL_B		char('3')			// [1 - 4]
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

#if defined(_UNICODE)
#define FD_APP_IS_UNICODE	L"XP"				// UNICODE_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
#else //_UNICODE
#define FD_APP_IS_UNICODE	L"ME"				// MBCS_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
#endif//_UNICODE

// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDgPiBfLiDfHiDiHiDjDiCpAiOpLjIfOiClHiCoJiNfMjBkCjBmMiBeC_xHqqkZx_
union FCAppVersion
{
	WORD	wVersion;	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	struct {
		WORD	wLevelB	: 2;	// _xZkqqHx_iDiMiDhIiDiLiCgBiBeC_xHqqkZx_
		WORD	wLevelA	: 4;	// _xZkqqHx_iDiMiDhIiDiLiCgAiBeC_xHqqkZx_
		WORD	wMinor	: 5;	// _xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
		WORD	wMajor	: 5;	// _xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	};
}; // FCAppVersion.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCHeaderInf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCpAjEfLiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.02.04 Fukushiro M. _xZkqqHx_iKgHjCkD_xHqqkZx_
 *************************************************************************/
class FCHeaderInf
{
public:
//;----- </EXPORT TO SDK> -----;

	FCHeaderInf ();
// 02.05.30 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDiLiDfPjDoAiCmFiJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCkJiCoHjAfGiLeLiNoMjAkMiClFiClNiBhF_xHqqkZx_Dynamic Draw Document_xZkqqHx_iBhGiCmJiJlNiCkJiCpAjFgAiClBiCkEiCmGiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)
	void	Clear ();
	void	Init ();
	void	InitCreateTime ();
	void	InStream (FCUndoArchive& ar);
	void	InStream (const BYTE*& pData);
	void	InStream (CFile& file);
//----- 02.05.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDiLiDfPjDoAiCmFiJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCkJiCoHjAfGiLeLiNoMjAkMiClFiClNiBhF_xHqqkZx_Dynamic Draw Document_xZkqqHx_iBhGiCmJiJlNiCkJiCpAjFgAiClBiCkEiCmGiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
//	void	OutStream (FCUndoArchive& ar) const;
//	void	OutStream (BYTEVector& vByteStream) const;
//----- 02.05.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDiLiDfPjDoAiCmFiJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCkJiCoHjAfGiLeLiNoMjAkMiClFiClNiBhF_xHqqkZx_Dynamic Draw Document_xZkqqHx_iBhGiCmJiJlNiCkJiCpAjFgAiClBiCkEiCmGiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
	void	OutStreamCurrent (FCUndoArchive& ar, WORD wFileType) const;
	void	OutStreamCurrent (BYTEVector& vData, WORD wFileType) const;

	time_t	GetCreateTime () const;
	time_t	GetUpdateTime () const;

	const char*	GetAppName () const;
	WORD	GetFileType () const;
	void	SetFileType (WORD wFileType);

	void	RegalCheck (WORD wFileType1,
						WORD wFileType2 = FD_DTP_NONE,
						WORD wFileType3 = FD_DTP_NONE,
						WORD wFileType4 = FD_DTP_NONE) const;

	WORD	GetFileVersion () const;

//----- 03.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	WString	GetRelativeVersion () const;
//	void	SetRelativeVersion (const wchar_t* wstrVersion);
//----- 03.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	void	operator = (const FCHeaderInf& inf);

	static const CLSID&		GetStcCLSID ();
	static const char*		GetStcAppName ();
	static WString			FileVersionToString (WORD wVersion);
	static const wchar_t*	GetStcAppVersionString ();
	static WString			GetStcAppMajorMinorString ();
	static const wchar_t*	GetStcFileVersionString ();
	static long	GetStreamSize ();
	static WORD	GetStcAppVersion ();
	static WORD	GetStcFileVersion ();
	static WORD MajorMinorToFileVersion (WORD wMajorVer, WORD wMinorVer);
	static void FileVersionMajorMinor (WORD& wMajorVer, WORD& wMinorVer, WORD wVersion);

protected:

//;----- <EXPORT TO SDK> -----;
	WORD		m_wAppVersion;		// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	BYTE		m_byPlatform;		// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiBeC_xHqqkZx_
	BYTE		m_byFileType;		// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiBeC_xHqqkZx_
	WORD		m_wFileVersion;		// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	time_t		m_tmCreate;			// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
	time_t		m_tmUpdate;			// _xZkqqHx_iNfIjAfGjDpKiOjOiBeC_xHqqkZx_
}; // class FCHeaderInf.

//;----- </EXPORT TO SDK> -----;

#endif//__UtilVersion_h

